
import import_declare_test

from splunktaucclib.rest_handler.endpoint import (
    field,
    validator,
    RestModel,
    SingleModel,
)
from splunktaucclib.rest_handler import admin_external, util
from splunktaucclib.rest_handler.admin_external import AdminExternalHandler
import logging


util.remove_http_proxy_env_vars()


special_fields = [
    field.RestField(
        'name',
        required=True,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^[0-9a-z\-\_]*$""", 
        )
    )
]

fields = [
    field.RestField(
        'alias',
        required=False,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'description',
        required=False,
        encrypted=False,
        default=None,
        validator=validator.AllOf(
            validator.String(
                max_len=100, 
                min_len=1, 
            ), 
            validator.Pattern(
                regex=r"""^.*$""", 
            )
        )
    ), 
    field.RestField(
        'default_priority',
        required=True,
        encrypted=False,
        default='medium',
        validator=validator.Pattern(
            regex=r"""^(low|medium|high|critical|pending)$""", 
        )
    ), 
    field.RestField(
        'pagination_mode',
        required=True,
        encrypted=False,
        default='local',
        validator=validator.Pattern(
            regex=r"""^(local|remote)$""", 
        )
    ), 
    field.RestField(
        'pagination_size',
        required=True,
        encrypted=False,
        default='10000',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'ui_default_timerange',
        required=True,
        encrypted=False,
        default='24h',
        validator=validator.Pattern(
            regex=r"""^[1-9][0-9]*[mhd]$""", 
        )
    ), 
    field.RestField(
        'ui_min_object_width',
        required=True,
        encrypted=False,
        default='300',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'ui_expand_metrics',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'ui_home_tabs_order',
        required=True,
        encrypted=False,
        default='dsm,cim,flx,dhm,mhm,wlk,fqm,flip,audit,alerts',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9,]+$""", 
        )
    ), 
    field.RestField(
        'default_disruption_min_time_sec',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'outliers_set_state',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'data_sampling_set_state',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'data_sampling_obfuscation',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'adaptive_delay',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'mloutliers',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'mloutliers_allowlist',
        required=True,
        encrypted=False,
        default='dsm,dhm,flx,wlk,cim,fqm',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9,]+$""", 
        )
    ), 
    field.RestField(
        'sampling',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'splk_feeds_delayed_inspector_24hours_range_min_sec',
        required=True,
        encrypted=False,
        default='14400',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_feeds_delayed_inspector_7days_range_min_sec',
        required=True,
        encrypted=False,
        default='43200',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_feeds_delayed_inspector_until_disabled_range_min_sec',
        required=True,
        encrypted=False,
        default='172800',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_feeds_auto_disablement_period',
        required=True,
        encrypted=False,
        default='60d',
        validator=validator.Pattern(
            regex=r"""^[0-9]*d$""", 
        )
    ), 
    field.RestField(
        'indexed_constraint',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'cmdb_lookup',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'splk_dsm_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_dhm_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_mhm_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_flx_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_fqm_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_wlk_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_cim_cmdb_search',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_dsm_tabulator_groupby',
        required=True,
        encrypted=False,
        default='data_index',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_dhm_tabulator_groupby',
        required=True,
        encrypted=False,
        default='tenant_id',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_mhm_tabulator_groupby',
        required=True,
        encrypted=False,
        default='tenant_id',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_flx_tabulator_groupby',
        required=True,
        encrypted=False,
        default='group',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_fqm_tabulator_groupby',
        required=True,
        encrypted=False,
        default='metadata_datamodel,metadata_index,metadata_sourcetype',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_wlk_tabulator_groupby',
        required=True,
        encrypted=False,
        default='overgroup',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'splk_cim_tabulator_groupby',
        required=True,
        encrypted=False,
        default='cim_datamodel_name',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    )
]
model = RestModel(fields, name=None, special_fields=special_fields)


endpoint = SingleModel(
    'trackme_vtenants',
    model,
    config_name='vtenants',
    need_reload=False,
)


if __name__ == '__main__':
    logging.getLogger().addHandler(logging.NullHandler())
    admin_external.handle(
        endpoint,
        handler=AdminExternalHandler,
    )
