const { Callbacks } = require("jquery");

require([
  "jquery",
  "underscore",
  "splunkjs/mvc",
  "splunkjs/mvc/searchcontrolsview",
  "splunkjs/mvc/searchmanager",
  "splunkjs/mvc/postprocessmanager",
  "splunkjs/mvc/savedsearchmanager",
  "splunkjs/mvc/dropdownview",
  "splunkjs/mvc/multidropdownview",
  "splunkjs/mvc/tableview",
  "splunkjs/mvc/textinputview",
  "splunkjs/mvc/singleview",
  "splunkjs/mvc/chartview",
  "splunkjs/mvc/resultslinkview",
  "splunkjs/mvc/simplexml/searcheventhandler",
  "splunkjs/mvc/visualizationregistry",
  Splunk.util.make_url("/static/app/trackme/tabulator/js/tabulator.js"),
  Splunk.util.make_url("/static/app/trackme/momentjs/moment.js"),
  "splunkjs/mvc/simplexml/ready!",
  "splunkjs/mvc/simpleform/input/multiselect",
], function (
  $,
  _,
  mvc,
  SearchControlsView,
  SearchManager,
  PostProcessManager,
  SavedSearchManager,
  DropdownView,
  MultiDropdownView,
  TableView,
  TextInputView,
  SingleView,
  ChartView,
  ResultsLinkView,
  SearchEventHandler,
  VisualizationRegistry,
  TabulatorFull,
  moment
) {
  function getSplunkUrl(path) {
    return Splunk.util.make_url(path);
  }

  //
  // ajax promise for API calls
  //

  async function asyncAjax(ajaxurl, ajaxType, ajaxdata) {
    var resultCall;
    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
        data: JSON.stringify(ajaxdata),
      });
      return resultCall;
    } catch (error) {
      // notify error
      $("#cssloader").remove();
      // hide div id badges-tenant-count-loader using css display: none
      $("#badges-tenant-count-loader").css("visibility", "hidden");

      // if the error contains "insufficient permission to access this resource" as a full sentence
      if (
        error.responseText.includes(
          "insufficient permission to access this resource"
        )
      ) {
        error_message = {
          status: "failure",
          message:
            "Error due to insufficient permissions, to access and use TrackMe, you need to be granted a TrackMe capability which is part of the TrackMe roles. Please contact your Splunk administrator and refer to: https://docs.trackme-solutions.com/latest/admin_guide_rbac.html",
        };
      } else {
        error_message = {
          status: "failure",
          message:
            "Error, something went quite wrong while loading a TrackMe component, this likely indicates a corrupted Virtual Tenant or something wrong in your environment.",
          remediation_message:
            "If the error is due to a corrupted Virtual Tenant, the faulty tenant name appears as the exception in the rest_call_details http_response. If so, please run the following command to clear out any traces from this faulty tenant and fix this issue, then reload TrackMe.",
          remediation_command:
            "| trackme url=/services/trackme/v2/vtenants/admin/del_tenant mode=delete body=\"{'tenant_id': 'mytenant', 'force': 'true'}\"",
          rest_call_details: {
            endpoint: ajaxurl,
            http_mode: ajaxType,
            http_response: error,
          },
        };
      }
      $("#modal_generic_error")
        .find(".modal-error-message p")
        .text(JSON.stringify(error_message, null, 2));
      $("#modal_generic_error").modal();
    }
  }

  //
  // Verify TrackMe requirements
  //

  var doAsync = asyncAjax(
    getSplunkUrl(
      "/splunkd/__raw/services/trackme/v2/configuration/trackme_check_dependencies"
    ),
    "GET"
  ).then(function (resultCall) {
    var depsMet = resultCall["action"];
    var trackme_conf = resultCall["trackme_conf"];

    //
    // if dependencies are not met, avoid executing the page and show a message
    //

    if (depsMet == "failure") {
      $("#cssloader").remove();
      $("#badges-tenant-count-loader").css("visibility", "hidden");
      message = JSON.stringify(resultCall, null, 2);
      $("#modal_dep_error").find(".modal-error-message p").text(message);
      $("#modal_dep_error").modal();
    }
    //
    // If dependencies are met, process
    //
    else if (depsMet == "success") {
      //
      // All dependencies are met, start execution
      //

      var defaultTokenModel = mvc.Components.getInstance("default", {
        create: true,
      });
      var submittedTokenModel = mvc.Components.getInstance("submitted", {
        create: true,
      });

      function setToken(name, value) {
        defaultTokenModel.set(name, value);
        submittedTokenModel.set(name, value);
      }

      function getToken(name) {
        var ret = null;
        if (defaultTokenModel.get(name) != undefined) {
          ret = defaultTokenModel.get(name);
        } else if (submittedTokenModel.get(name) != undefined) {
          ret = submittedTokenModel.get(name);
        }
        return ret;
      }

      function unsetToken(name) {
        defaultTokenModel.unset(name);
        submittedTokenModel.unset(name);
      }

      // get trackmeload_mode from trackmeconf
      var trackmeload_mode =
        trackme_conf["trackme_conf"]["trackme_theme_default"][
          "trackmeload_mode"
        ];
      var trackmeload_url;
      if (trackmeload_mode === "rest") {
        trackmeload_url = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/vtenants/trackmeload"
        );
      } else if (trackmeload_mode === "legacy") {
        trackmeload_url = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/vtenants/trackmeload_legacy"
        );
      }

      function loadTabulatorTheme(tabulator_theme) {
        if (tabulator_theme === "dark_site") {
          loadCss(
            Splunk.util.make_url(
              "/static/app/trackme/tabulator/css/tabulator_site_dark.css"
            )
          );
        } else if (tabulator_theme === "dark_midnight") {
          loadCss(
            Splunk.util.make_url(
              "/static/app/trackme/tabulator/css/tabulator_midnight.css"
            )
          );
        } else if (tabulator_theme === "light") {
          loadCss(
            Splunk.util.make_url(
              "/static/app/trackme/tabulator/css/tabulator.css"
            )
          );
        } else if (tabulator_theme === "light_site") {
          loadCss(
            Splunk.util.make_url(
              "/static/app/trackme/tabulator/css/tabulator_site.css"
            )
          );
        } else if (tabulator_theme === "light_modern") {
          loadCss(
            Splunk.util.make_url(
              "/static/app/trackme/tabulator/css/tabulator_modern.css"
            )
          );
        }
      }

      function loadCss(href) {
        const link = document.createElement("link");
        link.href = href;
        link.type = "text/css";
        link.rel = "stylesheet";
        document.head.appendChild(link);
      }

      var doAsync = asyncAjax(trackmeload_url, "POST", { mode: "full" }).then(
        function (resultCall) {
          // Privileges level
          userLevel = resultCall["user_level"];
          setToken("userLevel", userLevel);
          // hide the tenant creation access button
          if (userLevel === "user" || userLevel === "power") {
            $("#btn_start_create_tenant").prop("disabled", true);
            $("#btn_start_create_tenant").css("display", "none");
            $("#btn_start_create_tenant_replica").prop("disabled", true);
            $("#btn_start_create_tenant_replica").css("display", "none");
          }

          // Tenants count
          var tenantsCount = resultCall["vtenants_count"];
          var tenantsCountActive = resultCall["vtenants_count_active"];

          //
          // Gen vtenants active count
          //

          // set the div id badges-tenant-count-load to be not visible using display:none
          $("#badges-tenant-count-loader").css("visibility", "hidden");

          // set the div id content
          var content =
            '<h1 style="font-size: 60px; font-weight: bold; letter-spacing: normal; text-align: center;">' +
            tenantsCountActive +
            "</h1>" +
            '<div id="divSubTenantOpsCount" style="text-align: center; margin-top: 20px;">' +
            '<text class="under-label" style="letter-spacing: normal; font-size: 12px; font-weight: normal; fill: rgb(195, 203, 212); opacity: 1;">NUMBER OF ACTIVE TENANTS</text></div>';
          $("#badges-tenant-count").html(content);

          // Tenants JSON
          var tenantsJson = resultCall["tenants_json"];

          // Position
          var userPositionPrefs = resultCall["position_prefs"];

          // theme preferences
          var icons_state_mode = resultCall["icons_state_mode_vtenant_ui"];
          var show_tenants_mgmt_header = resultCall["show_tenants_mgmt_header"];
          var flex_width_default = resultCall["flex_width_default"];
          var flex_show_desc = resultCall["flex_show_desc"];
          var flex_show_summary = resultCall["flex_show_summary"];
          var colorTheme = resultCall["colorTheme"];
          var colorThemeStyleAlert = resultCall["colorThemeStyleAlert"];
          var dynTheme = resultCall["dynTheme"];
          var dynThemeCondition = resultCall["dynThemeCondition"];

          // load Tabulator theme
          document.addEventListener(
            "DOMContentLoaded",
            loadTabulatorTheme(resultCall["tabulator_theme_vtenant_ui"])
          );

          var userPrefs = {
            icons_state_mode: icons_state_mode,
            show_tenants_mgmt_header: show_tenants_mgmt_header,
            flex_width_default: flex_width_default,
            flex_show_desc: flex_show_desc,
            flex_show_summary: flex_show_summary,
            colorTheme: colorTheme,
            colorThemeStyleAlert: colorThemeStyleAlert,
            dynTheme: dynTheme,
            dynThemeCondition: dynThemeCondition,
          };

          // Preset the user preferences
          $("#edit_prefs_tabulator_theme").val(
            resultCall["tabulator_theme_vtenant_ui"]
          );
          $("#edit_prefs_icon_theme").val(icons_state_mode);

          // close all opened modals
          function closeModals() {
            $(".modal.in").modal("hide");
          }

          //
          // Get comment from textaread
          //

          function getComment(inputId) {
            // Retrieve update comment if any
            var tk_comment = document.getElementById(inputId).value;

            // if is not defined, give it a value and override text box content
            if (tk_comment == "null") {
              tk_comment = "No comments for update.";
            } else if (tk_comment == "update note") {
              tk_comment = "No comment for update.";
            }
            return tk_comment;
          }

          //
          // turn boolean into integer
          //

          function booleanToInteger(bool) {
            return bool ? 1 : 0;
          }

          //
          // check tenant id
          //

          function checkTenantId(value) {
            // trim the tenant_name
            value = value.trim();
            // make it lowercase
            value = value.toLowerCase().replace(/\s+/g, "-");
            // avoid ending with multiple underscores in the tenant id
            value = value.replace(/_+/g, "_");
            // replace any underscore with a hyphen
            value = value.replace(/_/g, "-");
            // replace anything that is not a letter, number or hyphen with a hyphen
            value = value.replace(/[^a-zA-Z0-9-]/g, "-");

            return value;
          }

          // Function to generate 8 random alphanumeric characters (digits and lowercase letters)
          function generateRandomString() {
            return Math.random().toString(36).substring(2, 10);
          }

          //
          //
          // semiCircleDonut custom viz

          // semicircle donut custom viz
          var semiCircleDonut = VisualizationRegistry.getVisualizer(
            "semicircle_donut",
            "semicircle_donut"
          );

          //
          // Function to show error modal and pretty printed message
          //

          function showErrorModal(
            modalId,
            errorTitle,
            xhr,
            textStatus,
            errorThrown
          ) {
            // Remove any spinner or loading indicator if needed
            if (typeof cssloaderremove === "function") {
              cssloaderremove();
            }

            // Format the error message nicely
            let message = "";
            try {
              const json = JSON.parse(xhr.responseText);
              message = JSON.stringify(json, null, 2);
            } catch (e) {
              message =
                "Server Response:\n" +
                xhr.responseText +
                "\n\nHTTP Error:\n" +
                (errorThrown || textStatus);
            }

            const $modal = $(`#${modalId}`);

            // Replace existing content with a styled <textarea>
            const $errorContainer = $modal.find(".modal-error-message");
            $errorContainer.html(
              `<textarea readonly="readonly" rows="20">${message}</textarea>`
            );

            // Optional: update modal title, if you want to reuse it for multiple contexts
            if (errorTitle) {
              $modal
                .find(".modal-header h1")
                .html(
                  `<span class="glyphicon glyphicon-lock"></span> ${errorTitle}`
                );
            }

            closeModals(); // Close any open ones, if needed
            $modal.modal(); // Open the error modal
          }

          //
          // Show spl message
          //

          /**
           * Populate an SPL message container with a formatted <textarea>.
           *
           * @param {string} containerSelector - A selector for the SPL message container (e.g., ".modal-spl-message" or "#child_create_tenant_spl_command").
           * @param {string|object} response - The SPL content, either plain text or a JSON object/string.
           */
          function showSplMessage(containerSelector, response) {
            let message = "";

            if (typeof response === "object") {
              message = JSON.stringify(response, null, 2);
            } else {
              try {
                const json = JSON.parse(response);
                message = JSON.stringify(json, null, 2);
              } catch (e) {
                message = response;
              }
            }

            const $container = $(containerSelector);

            $container.html(
              `<textarea readonly="readonly" rows="10">${message}</textarea>`
            );
          }

          //
          // Show Info / Success Message
          //

          /**
           * Show a modal with a success or informational message.
           *
           * @param {string} modalId - ID of the modal to show (e.g., "modal_alert_creation_success").
           * @param {string} containerSelector - Selector for the container (e.g., ".modal-success-message", ".modal-info-message").
           * @param {string} [title] - Optional new modal title (can include icons).
           * @param {string|object} response - The message content to display.
           */
          function showStatusModal(
            modalId,
            containerSelector,
            title,
            response
          ) {
            // Remove loading spinner if present
            if (typeof cssloaderremove === "function") {
              cssloaderremove();
            }

            // Format the message
            let message = "";
            if (typeof response === "object") {
              message = JSON.stringify(response, null, 2);
            } else {
              try {
                const json = JSON.parse(response);
                message = JSON.stringify(json, null, 2);
              } catch (e) {
                message = response;
              }
            }

            const $modal = $(`#${modalId}`);
            const $container = $modal.find(containerSelector);

            // Inject formatted message using a <textarea>
            $container.html(
              `<textarea readonly="readonly" rows="20">${message}</textarea>`
            );

            // Optionally update modal title
            if (title) {
              $modal.find(".modal-header h1").html(title);
            }

            // Close others if needed, then show modal
            if (typeof closeModals === "function") {
              closeModals();
            }

            $modal.modal();
          }

          //
          // Notify
          //

          function notify(varCss, varPosition, varHtml, vardelay) {
            require([
              "jquery",
              Splunk.util.make_url(
                "/static/app/trackme/notifybar/jquery.notifyBar.js"
              ),
            ], function ($) {
              //code here
              jQuery(function () {
                jQuery.notifyBar({
                  cssClass: varCss,
                  position: varPosition,
                  html: varHtml,
                  delay: vardelay,
                });
              });
            });
          }

          function removeNotify() {
            require([
              "jquery",
              Splunk.util.make_url(
                "/static/app/trackme/notifybar/jquery.notifyBar.js"
              ),
            ], function ($) {
              //code here
              jQuery(function () {
                jQuery.hideNB();
              });
            });
          }

          //
          // epochtime second to human readable
          //

          function epochToHumanReadable(epoch) {
            // Convert epoch time from seconds to milliseconds
            const epochMilliseconds = epoch * 1000;

            // Create a new Date object using the epoch time value in milliseconds
            const date = new Date(epochMilliseconds);

            // Format the date as a human-readable string
            const humanReadableDate = date.toLocaleString();

            return humanReadableDate;
          }

          //
          // decode object: a simple function to decode backslashes encoded in unicode
          //

          function decodeObject(str) {
            if (str.includes("\\u005c")) {
              str = str.replace(/\\u005c/g, "\\");
            }
            return str;
          }

          //
          // Tabulator grouping functions
          //

          function convertCsvToArray(inputString) {
            try {
              // Attempt to parse as JSON array
              var parsedArray = JSON.parse(inputString);
              if (Array.isArray(parsedArray)) {
                return parsedArray;
              }
            } catch (e) {
              // If parsing fails, assume it's a CSV string and split it
              return inputString.split(",").map((item) => item.trim());
            }
          }

          function tabulatorGroupBy(context, data) {
            // Check if context is an expression
            if (typeof context === "string" && context.includes("data.")) {
              // Evaluate the expression using data
              return eval(context);
            } else {
              // Assume context is a string or a CSV string, convert it to an array and return
              var TabulatorGroupBy = convertCsvToArray(context);
              return TabulatorGroupBy;
            }
          }

          //
          // Set bootstrap based status icons
          //

          function setEmojiStatusIcons(status) {
            switch (status) {
              case "001":
                return "🟢";
              case "002":
                return "👀 🟢";
              case "003":
                return "🟢";
              case "004":
                return "🔴";
              case "005":
                return "👀 🔴";
              case "006":
                return "🔴";
              case "007":
                return "🟠";
              case "008":
                return "👀 🟠";
              case "009":
                return "🟠";
              case "010":
                return "🔵";
              case "011":
                return "👀 🔵";
              case "012":
                return "🔵";
              case "unknown":
                return "⚪";
              default:
                return "⚫"; // Default icon for undefined status
            }
          }

          //
          // Set bootstrap based status icons
          //

          function setBootstrapStatusIcons(status) {
            switch (status) {
              case "001":
                return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
              case "002":
                return "<i class='bi bi-eye-fill icon-state-green'></i>";
              case "003":
                return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
              case "004":
                return "<i class='bi bi-x-circle-fill icon-state-red'></i>";
              case "005":
                return "<i class='bi bi-eye-fill icon-state-red'></i>";
              case "006":
                return "<i class='bi bi-x-circle-fill icon-state-red'></i>";
              case "007":
                return "<i class='bi bi-exclamation-triangle-fill icon-state-orange'></i>";
              case "008":
                return "<i class='bi bi-eye-fill icon-state-orange'></i>";
              case "009":
                return "<i class='bi bi-exclamation-triangle-fill icon-state-orange'></i>";
              case "010":
                return "<i class='bi bi-info-circle-fill icon-state-blue'></i>";
              case "011":
                return "<i class='bi bi-eye-fill icon-state-blue'></i>";
              case "012":
                return "<i class='bi bi-info-circle-fill icon-state-blue'></i>";
              case "unknown":
                return "<i class='bi bi-question-circle-fill icon-state-grey'></i>";
              default:
                return "<i class='bi bi-slash-circle icon-state-black'></i>"; // Default icon for undefined status
            }
          }

          // popup formatter (ack)
          var rowPopupFormatterAck = function (e, row, onRendered) {
            var data = row.getData();

            // We have the following Ack fields:
            // ack_comment, ack_expiration, ack_mtime, ack_state, ack_type

            var ack_comment = data.ack_comment;
            var ack_expiration = data.ack_expiration;
            var ack_mtime = data.ack_mtime;
            var ack_state = data.ack_state;
            var ack_type = data.ack_type;

            // if ack_expiration is not null, convert from epoch to human readable
            if (ack_expiration != "N/A") {
              ack_expiration = epochToHumanReadable(ack_expiration);
            } else {
              ack_expiration = "N/A";
            }

            // if ack_mtime is not null, convert from epoch to human readable
            if (ack_mtime != "N/A") {
              ack_mtime = epochToHumanReadable(ack_mtime);
            } else {
              ack_mtime = "N/A";
            }

            (container = document.createElement("div")),
              // Add all fields to the popup
              (contents =
                "<strong style='font-size:1.2em; color: black;'>Acknowledement Details</strong><br/>");
            contents +=
              "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
            contents +=
              "<li><strong>Acknowledgement state:</strong> " +
              ack_state +
              "</li>";
            contents +=
              "<li><strong>Acknowledgement type:</strong> " +
              ack_type +
              "</li>";
            contents +=
              "<li><strong>Acknowledgement expiration:</strong> " +
              ack_expiration +
              "</li>";
            contents +=
              "<li><strong>Acknowledgement comment:</strong> " +
              ack_comment +
              "</li>";
            contents +=
              "<li><strong>Acknowledgement last modified:</strong> " +
              ack_mtime +
              "</li>";
            contents += "</ul></div>";

            container.innerHTML = contents;

            return container;
          };

          //
          // setStatusIcon
          //

          function setStatusIcon(status, icons_state_mode) {
            if (status == "operational") {
              if (icons_state_mode == "bootstrap") {
                return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
              } else if (icons_state_mode == "emoji") {
                return "🟢";
              }
            } else if (status == "degraded") {
              if (icons_state_mode == "bootstrap") {
                return "<i class='bi bi-exclamation-triangle-fill icon-state-red'></i>";
              } else if (icons_state_mode == "emoji") {
                return "❌";
              }
            } else if (status == "disabled") {
              if (icons_state_mode == "bootstrap") {
                return "<i class='bi bi-exclamation-triangle-fill icon-state-black'></i>";
              } else if (icons_state_mode == "emoji") {
                return "⚫";
              }
            }
          }

          // render custom table emoji icons
          function renderTableIcon(element) {
            var CustomIconRenderer = TableView.BaseCellRenderer.extend({
              canRender: function (cell) {
                if (typeof cell.value === "string") {
                  return cell.value && cell.value.substr(0, 5) === "icon|";
                }
              },
              render: function ($td, cell) {
                var parts = cell.value.split("|");

                // green
                if (parts[1] === "ico_good ico_small") {
                  $td
                    .css({
                      "text-align": "center",
                    })
                    .html("<div>🟢</div>");
                }
                // red
                else if (parts[1] === "ico_error ico_small") {
                  $td
                    .css({
                      "text-align": "center",
                    })
                    .html("<div>🔴</div>");
                }
                // orange
                else if (parts[1] === "ico_warn ico_small") {
                  $td
                    .css({
                      "text-align": "center",
                    })
                    .html("<div>🟠</div>");
                }
                // blue
                else if (parts[1] === "ico_unknown ico_small") {
                  $td
                    .css({
                      "text-align": "center",
                    })
                    .html("<div>🔵</div>");
                }
                // Ack
                else if (parts[1] === "ico_ack ico_small") {
                  $td
                    .css({
                      "text-align": "center",
                    })
                    .html("<div>👀 🔴</div>");
                }
                if (parts.length > 3) {
                  $td.attr("title", parts[3]);
                }
              },
            });

            element.addCellRenderer(new CustomIconRenderer());
          }

          //
          // splk-feeds - testing hybrid trackers
          //

          // splk-dsm

          var searchSplkDsmSimulation = new SearchManager(
            {
              id: "searchSplkDsmSimulation",
              autostart: false,
              earliest_time: "$tk_splk_dsm_simulation_earliest$",
              cancelOnUnload: true,
              sample_ratio: null,
              latest_time: "$tk_splk_dsm_simulation_latest$",
              search:
                "$tk_splk_dsm_simulation_search$ | `trackme_hybrid_tracker_simulation`",
              status_buckets: 0,
              app: "trackme",
              auto_cancel: 90,
              preview: true,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          // enable/disable the creation button

          searchSplkDsmSimulation.on("search:start", function (properties) {
            // set the div id divSplkDsmSimulation to be visbile
            $("#divSplkDsmSimulation").css("display", "inherit");
            // spinner
            $("#cssloader").remove();
            $("body").append(
              '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
            );
          });

          searchSplkDsmSimulation.on("search:failed", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkDsmSimulation.on("search:error", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkDsmSimulation.on("search:done", function (properties) {
            $("#cssloader").remove();
            // notify
            var eventCount = properties.content.eventCount;
            if (eventCount > 0) {
              notify(
                "success",
                "bottom",
                "Hybrid tracker simulation finished successfully, verify the results before proceeding to its creation",
                "10"
              );
            } else {
              notify(
                "warning",
                "bottom",
                "The Hybrid tracker simulation finished successfully but sadly no entities were returned, verify your search constraint!",
                "10"
              );
            }
          });

          var tableSplkDsmSimulation = new TableView(
            {
              id: "tableSplkDsmSimulation",
              count: 1,
              drilldown: "none",
              "refresh.display": "none",
              wrap: "false",
              managerid: "searchSplkDsmSimulation",
              el: $("#tableSplkDsmSimulation"),
            },
            {
              tokens: true,
            }
          ).render();

          // render icons
          renderTableIcon(tableSplkDsmSimulation);

          var resultsLinktableSplkDsmSimulation = new ResultsLinkView({
            id: "resultsLinktableSplkDsmSimulation",
            managerid: "searchSplkDsmSimulation",
            "link.exportResults.visible": false,
            el: $("#resultsLinktableSplkDsmSimulation"),
          });

          resultsLinktableSplkDsmSimulation
            .render()
            .$el.appendTo($("resultsLinktableSplkDsmSimulation"));

          // splk-dhm

          var searchSplkDhmSimulation = new SearchManager(
            {
              id: "searchSplkDhmSimulation",
              autostart: false,
              earliest_time: "$tk_splk_dhm_simulation_earliest$",
              cancelOnUnload: true,
              sample_ratio: null,
              latest_time: "$tk_splk_dhm_simulation_latest$",
              search:
                "$tk_splk_dhm_simulation_search$ | `trackme_hybrid_tracker_simulation`",
              status_buckets: 0,
              app: "trackme",
              auto_cancel: 90,
              preview: true,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          // enable/disable the creation button

          searchSplkDhmSimulation.on("search:start", function (properties) {
            // set the div id divSplkDhmSimulation to be visbile
            $("#divSplkDhmSimulation").css("display", "inherit");
            // spinner
            $("#cssloader").remove();
            $("body").append(
              '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
            );
          });

          searchSplkDhmSimulation.on("search:failed", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkDhmSimulation.on("search:error", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkDhmSimulation.on("search:done", function (properties) {
            $("#cssloader").remove();
            // notify
            var eventCount = properties.content.eventCount;
            if (eventCount > 0) {
              notify(
                "success",
                "bottom",
                "Hybrid tracker simulation finished successfully, verify the results before proceeding to its creation",
                "10"
              );
            } else {
              notify(
                "warning",
                "bottom",
                "The Hybrid tracker simulation finished successfully but sadly no entities were returned, verify your search constraint!",
                "10"
              );
            }
          });

          var tableSplkDhmSimulation = new TableView(
            {
              id: "tableSplkDhmSimulation",
              count: 1,
              drilldown: "none",
              "refresh.display": "none",
              wrap: "false",
              managerid: "searchSplkDhmSimulation",
              el: $("#tableSplkDhmSimulation"),
            },
            {
              tokens: true,
            }
          ).render();

          // render icons
          renderTableIcon(tableSplkDhmSimulation);

          var resultsLinktableSplkDhmSimulation = new ResultsLinkView({
            id: "resultsLinktableSplkDhmSimulation",
            managerid: "searchSplkDhmSimulation",
            "link.exportResults.visible": false,
            el: $("#resultsLinktableSplkDhmSimulation"),
          });

          resultsLinktableSplkDhmSimulation
            .render()
            .$el.appendTo($("resultsLinktableSplkDhmSimulation"));

          // splk-mhm

          var searchSplkMhmSimulation = new SearchManager(
            {
              id: "searchSplkMhmSimulation",
              autostart: false,
              earliest_time: "$tk_splk_mhm_simulation_earliest$",
              cancelOnUnload: true,
              sample_ratio: null,
              latest_time: "$tk_splk_mhm_simulation_latest$",
              search:
                "$tk_splk_mhm_simulation_search$ | `trackme_hybrid_tracker_simulation`",
              status_buckets: 0,
              app: "trackme",
              auto_cancel: 90,
              preview: true,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          // enable/disable the creation button

          searchSplkMhmSimulation.on("search:start", function (properties) {
            // set the div id divSplkMhmSimulation to be visbile
            $("#divSplkMhmSimulation").css("display", "inherit");
            // spinner
            $("#cssloader").remove();
            $("body").append(
              '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
            );
          });

          searchSplkMhmSimulation.on("search:failed", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkMhmSimulation.on("search:error", function (properties) {
            $("#cssloader").remove();
            // notify
            notify(
              "error",
              "bottom",
              "Oops, Hybrid tracker simulation failed, review the search output!",
              "5"
            );
          });

          searchSplkMhmSimulation.on("search:done", function (properties) {
            $("#cssloader").remove();
            // notify
            var eventCount = properties.content.eventCount;
            if (eventCount > 0) {
              notify(
                "success",
                "bottom",
                "Hybrid tracker simulation finished successfully, verify the results before proceeding to its creation",
                "10"
              );
            } else {
              notify(
                "warning",
                "bottom",
                "The Hybrid tracker simulation finished successfully but sadly no entities were returned, verify your search constraint!",
                "10"
              );
            }
          });

          var tableSplkMhmSimulation = new TableView(
            {
              id: "tableSplkMhmSimulation",
              count: 1,
              drilldown: "none",
              "refresh.display": "none",
              wrap: "false",
              managerid: "searchSplkMhmSimulation",
              el: $("#tableSplkMhmSimulation"),
            },
            {
              tokens: true,
            }
          ).render();

          // render icons
          renderTableIcon(tableSplkMhmSimulation);

          var resultsLinktableSplkMhmSimulation = new ResultsLinkView({
            id: "resultsLinktableSplkMhmSimulation",
            managerid: "searchSplkMhmSimulation",
            "link.exportResults.visible": false,
            el: $("#resultsLinktableSplkMhmSimulation"),
          });

          resultsLinktableSplkMhmSimulation
            .render()
            .$el.appendTo($("resultsLinktableSplkMhmSimulation"));

          //
          // tenant overview
          //

          var searchTenantTrackerDsm = new SearchManager(
            {
              id: "searchTenantTrackerDsm",
              search:
                '| savedsearch "trackme_dsm_tracker_tenant_$clickedTenantId$"',
              earliest_time: "-4h",
              latest_time: "+4h",
              autostart: false,
            },
            { tokens: true }
          );

          var searchTenantOverviewDsm = new SearchManager(
            {
              id: "searchTenantOverviewDsm",
              search: "| `tenant_get_info($clickedTenantId$, dsm)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewDsm",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDsmEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          //
          // splk-dsm Overview screen
          //

          var searchSplkDsmMain = new SearchManager(
            {
              id: "searchSplkDsmMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=dsm mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkDsmDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkDsmMain",
              id: "searchSingleSplkDsmDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkDsmDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkDsmMain",
              id: "searchSingleSplkDsmDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkDsmCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkDsmCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkDsmDonutPriorities",
              el: $("#DonutSplkDsmCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkDsmCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkDsmCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkDsmDonutAlerts",
              el: $("#DonutSplkDsmCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-dhm Overview screen
          //

          var searchSplkDhmMain = new SearchManager(
            {
              id: "searchSplkDhmMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=dhm mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkDhmDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkDhmMain",
              id: "searchSingleSplkDhmDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkDhmDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority" | transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkDhmMain",
              id: "searchSingleSplkDhmDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkDhmCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkDhmCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkDhmDonutPriorities",
              el: $("#DonutSplkDhmCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkDhmCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkDhmCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkDhmDonutAlerts",
              el: $("#DonutSplkDhmCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-mhm Overview screen
          //

          var searchSplkMhmMain = new SearchManager(
            {
              id: "searchSplkMhmMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=mhm mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkMhmDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkMhmMain",
              id: "searchSingleSplkMhmDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkMhmDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkMhmMain",
              id: "searchSingleSplkMhmDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkMhmCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkMhmCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkMhmDonutPriorities",
              el: $("#DonutSplkMhmCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkMhmCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkMhmCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkMhmDonutAlerts",
              el: $("#DonutSplkMhmCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-flx Overview screen
          //

          var searchSplkFlxMain = new SearchManager(
            {
              id: "searchSplkFlxMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=flx mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkFlxDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkFlxMain",
              id: "searchSingleSplkFlxDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkFlxDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkFlxMain",
              id: "searchSingleSplkFlxDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkFlxCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkFlxCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkFlxDonutPriorities",
              el: $("#DonutSplkFlxCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkFlxCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkFlxCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkFlxDonutAlerts",
              el: $("#DonutSplkFlxCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-fqm Overview screen
          //

          var searchSplkFqmMain = new SearchManager(
            {
              id: "searchSplkFqmMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=fqm mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkFqmDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkFqmMain",
              id: "searchSingleSplkFqmDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkFqmDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkFqmMain",
              id: "searchSingleSplkFqmDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkFqmCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkFqmCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkFqmDonutPriorities",
              el: $("#DonutSplkFqmCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkFqmCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkFqmCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkFqmDonutAlerts",
              el: $("#DonutSplkFqmCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-wlk Overview screen
          //

          var searchSplkWlkMain = new SearchManager(
            {
              id: "searchSplkWlkMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=wlk mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkWlkDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkWlkMain",
              id: "searchSingleSplkWlkDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkWlkDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkWlkMain",
              id: "searchSingleSplkWlkDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkWlkCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkWlkCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkWlkDonutPriorities",
              el: $("#DonutSplkWlkCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkWlkCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkWlkCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkWlkDonutAlerts",
              el: $("#DonutSplkWlkCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // splk-cim Overview screen
          //

          var searchSplkCimMain = new SearchManager(
            {
              id: "searchSplkCimMain",
              earliest_time: "-5m",
              latest_time: "+5m",
              search:
                "| trackmegetcoll tenant_id=$clickedTenantId$ component=cim mode=cachedstats | table count_green_enabled, count_blue_enabled, count_critical_enabled, count_high_enabled, count_low_enabled, count_medium_enabled, count_orange_enabled, count_red_critical_priority_enabled, count_red_high_priority_enabled, count_red_other_priority_enabled, count_total, count_total_disabled, count_total_critical_priority_red, count_total_high_priority_red, count_total_in_alert",
              status_buckets: 0,
              auto_cancel: 90,
              autostart: false,
              preview: true,
              cache: false,
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkCimDonutPriorities = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_low_enabled, count_medium_enabled, count_high_enabled, count_critical_enabled | rename count_low_enabled as low, count_medium_enabled as medium, count_high_enabled as high, count_critical_enabled as critical | transpose | rename column as priority, "row 1" as count | `trackme_donut_alert_by_priority`',
              managerid: "searchSplkCimMain",
              id: "searchSingleSplkCimDonutPriorities",
            },
            {
              tokens: true,
            }
          );

          var searchSingleSplkCimDonutAlerts = new PostProcessManager(
            {
              tokenDependencies: {},
              search:
                'fields count_green_enabled, count_blue_enabled, count_orange_enabled, count_red_other_priority_enabled, count_red_high_priority_enabled, count_red_critical_priority_enabled | rename count_green_enabled as green, count_blue_enabled as blue, count_orange_enabled as orange, count_red_other_priority_enabled as "red - other priority", count_red_high_priority_enabled as "red - high priority", count_red_critical_priority_enabled as "red - critical priority"\n| transpose | rename column as state, "row 1" as count | `trackme_donut_alert_by_type(state)`',
              managerid: "searchSplkCimMain",
              id: "searchSingleSplkCimDonutAlerts",
            },
            {
              tokens: true,
            }
          );

          var DonutSplkCimCountByPriority = new semiCircleDonut(
            {
              id: "DonutSplkCimCountByPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkCimDonutPriorities",
              el: $("#DonutSplkCimCountByPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          var DonutSplkCimCountByStateAndPriority = new semiCircleDonut(
            {
              id: "DonutSplkCimCountByStateAndPriority",
              type: "semicircle_donut.semicircle_donut",
              resizable: true,
              drilldown: "all",
              height: "120",
              "refresh.display": "progressbar",
              "semicircle_donut.semicircle_donut.colorField": "color",
              "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
              "semicircle_donut.semicircle_donut.legendPosition": "top",
              "semicircle_donut.semicircle_donut.type": "half",
              "trellis.enabled": "0",
              "trellis.scales.shared": "1",
              "trellis.size": "medium",
              managerid: "searchSingleSplkCimDonutAlerts",
              el: $("#DonutSplkCimCountByStateAndPriority"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          //
          //

          var searchTenantOverviewCim = new SearchManager(
            {
              id: "searchTenantOverviewCim",
              search: "| `tenant_get_info($clickedTenantId$, cim)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewCim",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdCimEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          var searchTenantOverviewFlx = new SearchManager(
            {
              id: "searchTenantOverviewFlx",
              search: "| `tenant_get_info($clickedTenantId$, flx)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewFlx",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFlxEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          var searchTenantOverviewFqm = new SearchManager(
            {
              id: "searchTenantOverviewFqm",
              search: "| `tenant_get_info($clickedTenantId$, fqm)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewFqm",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdFqmEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          var searchTenantOverviewWlk = new SearchManager(
            {
              id: "searchTenantOverviewWlk",
              search: "| `tenant_get_info($clickedTenantId$, wlk)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewWlk",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdWlkEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          var searchTenantOverviewDhm = new SearchManager(
            {
              id: "searchTenantOverviewDhm",
              search: "| `tenant_get_info($clickedTenantId$, dhm)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewDhm",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdDhmEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          var searchTenantOverviewMhm = new SearchManager(
            {
              id: "searchTenantOverviewMhm",
              search: "| `tenant_get_info($clickedTenantId$, mhm)`",
              earliest_time: "-5m",
              latest_time: "now",
              autostart: false,
            },
            { tokens: true }
          );

          new SearchEventHandler({
            managerid: "searchTenantOverviewMhm",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntities",
                    value: "$result.count$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesStatusGreen",
                    value: "$result.count_green$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesStatusRed",
                    value: "$result.count_red$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesStatusOthers",
                    value: "$result.count_others$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesPriorityLow",
                    value: "$result.count_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesPriorityMedium",
                    value: "$result.count_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesPriorityHigh",
                    value: "$result.count_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesPriorityCritical",
                    value: "$result.count_critical_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesRedPriorityLow",
                    value: "$result.count_red_low_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesRedPriorityMedium",
                    value: "$result.count_red_medium_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesRedPriorityHigh",
                    value: "$result.count_red_high_priority$",
                  },
                  {
                    type: "set",
                    token: "clickedTenantIdMhmEntitiesRedPriorityCritical",
                    value: "$result.count_red_critical_priority$",
                  },
                ],
              },
            ],
          });

          //
          // tenants dropdown for Virtual Tenants Operation Status clean up
          //

          var searchListTenants = new SearchManager({
            id: "searchListTenants",
            search:
              '| inputlookup trackme_virtual_tenants where tenant_status="enabled" | eval keyid=_key | stats count by tenant_id | table tenant_id | sort 0 tenant_id',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          var inputListTenants = new MultiDropdownView(
            {
              searchWhenChanged: true,
              id: "inputListTenants",
              managerid: "searchListTenants",
              default: "*",
              choices: [
                {
                  label: "any",
                  value: "*",
                },
              ],
              labelField: "tenant_id",
              valueField: "tenant_id",
              value: "$tk_tenants_scope$",
              el: $("#inputListTenants"),
            },
            {
              tokens: true,
            }
          ).render();

          //
          // SEARCHES
          //

          // to avoid being tagged with all time searches (such as WLM rules), all searches should have a time range even if not required in theory

          var searchListComponents = new SearchManager({
            id: "searchListComponents",
            search:
              '| makeresults | eval components="splk-dsm|splk-dhm|splk-mhm|splk-cim|splk-flx|splk-fqm|splk-wlk" | fields - _time | makemv components delim="|" | mvexpand components',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          var searchListRoles = new SearchManager({
            id: "searchListRoles",
            search:
              "| rest splunk_server=local count=0 /services/authorization/roles | table title | sort 0 title",
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          var searchListUsers = new SearchManager({
            id: "searchListUsers",
            search:
              '| trackme mode=get url="/services/trackme/v2/configuration/list_local_users" | spath | rename "users{}" as title | mvexpand title | table title | sort 0 title',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          var searchListIdxSummary = new SearchManager({
            id: "searchListIdxSummary",
            search:
              '| rest splunk_server=local count=0 /services/trackme_settings/index_settings | fields trackme_summary_idx | rename trackme_summary_idx as title | append [ | rest splunk_server=local "/services/data/indexes" count=0 | table title ] | search [ | rest splunk_server=local /services/trackme_settings/index_settings count=0 | table trackme_idx_search_filter | rename trackme_idx_search_filter as title | return title ] | dedup title | sort 0 title',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          new SearchEventHandler({
            managerid: "searchListIdxSummary",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "tk_default_tenant_idx_summary",
                    value: "$result.title$",
                  },
                ],
              },
            ],
          });

          var searchListIdxAudit = new SearchManager({
            id: "searchListIdxAudit",
            search:
              '| rest splunk_server=local count=0 /services/trackme_settings/index_settings | fields trackme_audit_idx | rename trackme_audit_idx as title | append [ | rest splunk_server=local "/services/data/indexes" count=0 | table title ] | search [ | rest splunk_server=local /services/trackme_settings/index_settings count=0 | table trackme_idx_search_filter | rename trackme_idx_search_filter as title | return title ] | dedup title | sort 0 title',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          new SearchEventHandler({
            managerid: "searchListIdxAudit",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "tk_default_tenant_idx_audit",
                    value: "$result.title$",
                  },
                ],
              },
            ],
          });

          var searchListIdxNotable = new SearchManager({
            id: "searchListIdxNotable",
            search:
              '| rest splunk_server=local count=0 /services/trackme_settings/index_settings | fields trackme_notable_idx | rename trackme_notable_idx as title | append [ | rest splunk_server=local "/services/data/indexes" count=0 | table title ] | search [ | rest splunk_server=local /services/trackme_settings/index_settings count=0 | table trackme_idx_search_filter | rename trackme_idx_search_filter as title | return title ] | dedup title | sort 0 title',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          new SearchEventHandler({
            managerid: "searchListIdxNotable",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "tk_default_tenant_idx_notable",
                    value: "$result.title$",
                  },
                ],
              },
            ],
          });

          var searchListIdxMetric = new SearchManager({
            id: "searchListIdxMetric",
            search:
              '| rest splunk_server=local count=0 /services/trackme_settings/index_settings | fields trackme_metric_idx | rename trackme_metric_idx as title | append [ | rest splunk_server=local "/services/data/indexes?datatype=metric" count=0 | table title ] | search [ | rest splunk_server=local /services/trackme_settings/index_settings count=0 | table trackme_idx_search_filter | rename trackme_idx_search_filter as title | return title ] | dedup title | sort 0 title',
            earliest_time: "-5m",
            latest_time: "now",
            autostart: false,
          });

          new SearchEventHandler({
            managerid: "searchListIdxMetric",
            event: "progress",
            conditions: [
              {
                attr: "any",
                value: "*",
                actions: [
                  {
                    type: "set",
                    token: "tk_default_tenant_idx_metric",
                    value: "$result.title$",
                  },
                ],
              },
            ],
          });

          // Scheduler status

          var searchSchedulerStatus = new SavedSearchManager({
            id: "searchSchedulerStatus",
            searchname: "trackme_scheduler_completness",
            cache: false,
            preview: true,
            "dispatch.earliest_time": "-15m",
            "dispatch.latest_time": "now",
            app: "trackme",
            refreshType: "delay",
            refresh: "5m",
          });

          // set the label visibility
          searchSchedulerStatus.on("change", function (newValue) {
            $("#vizSchedulerStatusLabel").css("display", "inherit");
          });

          // Ops status

          var searchOpsStatus = new SavedSearchManager({
            id: "searchOpsStatus",
            searchname: "trackme_ops_status",
            cache: false,
            preview: true,
            "dispatch.earliest_time": "-5m",
            "dispatch.latest_time": "now",
            app: "trackme",
            refreshType: "delay",
            refresh: "5m",
          });

          // set the label visibility
          searchOpsStatus.on("change", function (newValue) {
            $("#vizOpsStatusLabel").css("display", "inherit");
          });

          // populate Splunk accounts
          // searchPopulateConfigurationAccounts

          var searchPopulateConfigurationAccounts = new SearchManager(
            {
              id: "searchPopulateConfigurationAccounts",
              earliest_time: "-5m",
              cancelOnUnload: true,
              latest_time: "+5m",
              search: "| `trackme_list_accounts`",
              auto_cancel: 90,
              autostart: false,
              preview: true,
              tokenDependencies: {
                //depends: "$show_configuration_account_dsm$",
              },
              runWhenTimeIsUndefined: false,
            },
            {
              tokens: true,
            }
          );

          function get_entities_summary(
            infoMsg,
            context,
            tenantId,
            status,
            priority
          ) {
            // Create the service
            var service = mvc.createService({
              owner: "nobody",
            });

            // Define the query
            var searchQuery =
              "| `get_tenant_entities_summary(" +
              tenantId +
              ", " +
              context +
              ", " +
              status +
              ", " +
              priority +
              ")`";

            // Set the search parameters--specify a time range
            var searchParams = {
              earliest_time: "-5m",
              latest_time: "now",
            };

            // Run a blocking search and get back a job
            service.search(searchQuery, searchParams, function (err, job) {
              // Shall the search fail before we can get properties
              if (job == null) {
                let errorStr = "Unknown Error!";
                if (
                  err &&
                  err.data &&
                  err.data.messages &&
                  err.data.messages[0]["text"]
                ) {
                  errorStr = err.data.messages[0]["text"];
                } else if (err && err.data && err.data.messages) {
                  errorStr = JSON.stringify(err.data.messages);
                }
                // notify error
                message =
                  "ERROR: hum, something went quite wrong there! Splunk returned an error while while attempting to run the search: " +
                  errorStr;
                notify("error", "bottom", message, "30");
                console.error("Review the Splunk search query: " + searchQuery);
              } else {
                // Poll the status of the search job
                job.track(
                  {
                    period: 200,
                  },
                  {
                    done: function (job) {
                      // Get the results
                      job.results({}, function (err, results, job) {
                        var fields = results.fields;
                        var rows = results.rows;
                        var jobResult;
                        for (var i = 0; i < rows.length; i++) {
                          var values = rows[i];
                          for (var j = 0; j < values.length; j++) {
                            var field = fields[j];
                            var value = values[j];
                            // get the _raw
                            if (field === "_raw") {
                              jobResult = value;
                            }
                          }
                          // notify
                          message = "ℹ️ last 10 flipped entities: " + jobResult;
                          notify("info", "bottom", message, "30");
                        }

                        // no results were found or we have no _raw
                        if (
                          jobResult == "" ||
                          typeof jobResult === "undefined" ||
                          jobResult == "null"
                        ) {
                          message =
                            "ERROR: hum, something went quite wrong there! The search was sucessfully executed but we got no results! ";
                          notify("error", "bottom", message, "30");
                        }
                      });
                    },
                    failed: function (properties) {
                      let errorStr = "Unknown Error!";
                      if (
                        properties &&
                        properties._properties &&
                        properties._properties.messages &&
                        properties._properties.messages[0]["text"]
                      ) {
                        errorStr = properties._properties.messages[0]["text"];
                      } else if (
                        properties &&
                        properties._properties &&
                        properties._properties.messages
                      ) {
                        errorStr = JSON.stringify(
                          properties._properties.messages
                        );
                      }
                      message =
                        "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                        errorStr;
                      notify("error", "bottom", message, "30");
                    },
                    error: function (err) {
                      done(err);
                      message =
                        "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                        err;
                      notify("error", "bottom", message, "30");
                    },
                  }
                );
              }
            });
          }

          function get_entities_summary_wlk(
            infoMsg,
            context,
            tenantId,
            status,
            priority
          ) {
            // Create the service
            var service = mvc.createService({
              owner: "nobody",
            });

            // Define the query
            var searchQuery =
              "| `get_tenant_entities_summary_wlk(" +
              tenantId +
              ", " +
              context +
              ", " +
              status +
              ", " +
              priority +
              ")`";

            // Set the search parameters--specify a time range
            var searchParams = {
              earliest_time: "-5m",
              latest_time: "now",
            };

            // Run a blocking search and get back a job
            service.search(searchQuery, searchParams, function (err, job) {
              // Shall the search fail before we can get properties
              if (job == null) {
                let errorStr = "Unknown Error!";
                if (
                  err &&
                  err.data &&
                  err.data.messages &&
                  err.data.messages[0]["text"]
                ) {
                  errorStr = err.data.messages[0]["text"];
                } else if (err && err.data && err.data.messages) {
                  errorStr = JSON.stringify(err.data.messages);
                }
                // notify error
                message =
                  "ERROR: hum, something went quite wrong there! Splunk returned an error while while attempting to run the search: " +
                  errorStr;
                notify("error", "bottom", message, "30");
                console.error("Review the Splunk search query: " + searchQuery);
              } else {
                // Poll the status of the search job
                job.track(
                  {
                    period: 200,
                  },
                  {
                    done: function (job) {
                      // Get the results
                      job.results({}, function (err, results, job) {
                        var fields = results.fields;
                        var rows = results.rows;
                        var jobResult;
                        for (var i = 0; i < rows.length; i++) {
                          var values = rows[i];
                          for (var j = 0; j < values.length; j++) {
                            var field = fields[j];
                            var value = values[j];
                            // get the _raw
                            if (field === "_raw") {
                              jobResult = value;
                            }
                          }
                          // notify
                          message = "ℹ️ last 10 flipped entities: " + jobResult;
                          notify("info", "bottom", message, "30");
                        }

                        // no results were found or we have no _raw
                        if (
                          jobResult == "" ||
                          typeof jobResult === "undefined" ||
                          jobResult == "null"
                        ) {
                          message =
                            "ERROR: hum, something went quite wrong there! The search was sucessfully executed but we got no results! ";
                          notify("error", "bottom", message, "30");
                        }
                      });
                    },
                    failed: function (properties) {
                      let errorStr = "Unknown Error!";
                      if (
                        properties &&
                        properties._properties &&
                        properties._properties.messages &&
                        properties._properties.messages[0]["text"]
                      ) {
                        errorStr = properties._properties.messages[0]["text"];
                      } else if (
                        properties &&
                        properties._properties &&
                        properties._properties.messages
                      ) {
                        errorStr = JSON.stringify(
                          properties._properties.messages
                        );
                      }
                      message =
                        "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                        errorStr;
                      notify("error", "bottom", message, "30");
                    },
                    error: function (err) {
                      done(err);
                      message =
                        "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                        err;
                      notify("error", "bottom", message, "30");
                    },
                  }
                );
              }
            });
          }

          function removeNotify() {
            $(".jquery-notify-bar").remove();
          }

          function genTenantsElements(
            tenantsDict,
            userPrefs,
            userPositionPrefs,
            showMessage,
            checkCount
          ) {
            // remove loader
            $("#cssloader").remove();
            $("#dyntenants").remove();
            $("#dyntenantsub").remove();
            $("#dyntenants-container").append(
              '<div id="dyntenants" style="min-height: 450px;"></div>'
            );

            var dict = tenantsDict;
            var tenants = {};
            var tenantsArray = [];

            for (var i = 0, tenant; i < dict.tenants.length; i++) {
              tenant = dict.tenants[i];
              tenants[tenant.tenant_id] = tenant;
              tenantsArray.push(tenant);
            }

            // sort
            tenantsArray = tenantsArray.sort();

            // Theme preferences

            var show_tenants_mgmt_header =
              userPrefs["show_tenants_mgmt_header"];
            var flex_width_default = userPrefs["flex_width_default"];
            var flex_show_desc = userPrefs["flex_show_desc"];
            var flex_show_summary = userPrefs["flex_show_summary"];
            var colorTheme = userPrefs["colorTheme"];
            var colorThemeStyleAlert = userPrefs["colorThemeStyleAlert"];
            var dynTheme = userPrefs["dynTheme"];
            var dynThemeCondition = userPrefs["dynThemeCondition"];

            // define the css class target for high/critical priority in alerts tenants
            var colorThemeStyleAlertCss = "flex-items-alert-red";
            if (colorThemeStyleAlert == "red") {
              colorThemeStyleAlertCss = "flex-items-alert-red";
            } else if (colorThemeStyleAlert == "yellow") {
              colorThemeStyleAlertCss = "flex-items-alert-yellow";
            } else if (colorThemeStyleAlert == "blue") {
              colorThemeStyleAlertCss = "flex-items-alert-blue";
            } else if (colorThemeStyleAlert == "orange") {
              colorThemeStyleAlertCss = "flex-items-alert-orange";
            } else if (colorThemeStyleAlert == "green") {
              colorThemeStyleAlertCss = "flex-items-alert-green";
            }

            // update dropdowns

            //
            // color theme preferences and behaviour
            //

            $("#edit_prefs_color_theme").val(colorTheme);
            $("#edit_prefs_color_theme_alert").val(colorThemeStyleAlert);
            $("#edit_prefs_dynamic_color").val(dynTheme);
            $("#edit_prefs_dynamic_color_condition").val(dynThemeCondition);

            //
            // Flex boxes size and show/hide preferences
            //

            $("#edit_prefs_tenants_status_header").val(
              show_tenants_mgmt_header
            );
            $("#edit_prefs_flex_width_default").val(flex_width_default);
            $("#edit_prefs_flex_show_desc").val(flex_show_desc);
            $("#edit_prefs_flex_show_summary").val(flex_show_summary);

            // User positions
            if (userPositionPrefs == "None" && showMessage == "true") {
              if (showMessage == "true") {
                if (getToken("userLevel") != "admin") {
                  notify(
                    "info",
                    "bottom",
                    "Welcome! You can drag and drop trackMe tenants to order them up to your preference, then click on save your profile. Double click to access Virtual Tenants!",
                    "60"
                  );
                } else {
                  notify(
                    "info",
                    "bottom",
                    "Welcome! You can drag and drop trackMe tenants to order them up to your preference, then click on save your profile. Double click on any existing tenant, or create new tenants as needed!",
                    "60"
                  );
                }
              }
            } else {
              if (showMessage == "true") {
                // Welcome message
                notify(
                  "info",
                  "bottom",
                  "Welcome! We have loaded your saved user space, remember that you can drag and drop tenants and save your profile. Double click to access Virtual Tenants!",
                  "60"
                );
              }
            }

            // If there are Vtenants created yet
            if (tenantsCount == 0 && checkCount === "true") {
              // disable position management
              $("#edit_tenants_position").prop("disabled", true);
              $("#save_tenants_position").prop("disabled", true);
              $("#reset_tenants_position").prop("disabled", true);
              // show modal
              closeModals();
              // ensure the last remaining tenant card was removed
              $("#item1").remove();
              // show welcome modal
              $("#modal_create_tenant_welcome").modal();
              // start related searches
              searchListRoles.startSearch();
              searchListUsers.startSearch();
              searchListIdxSummary.startSearch();
              searchListIdxAudit.startSearch();
              searchListIdxNotable.startSearch();
              searchListIdxMetric.startSearch();
              // remove loader
              $("#cssloader").remove();
              // show message
              notify(
                "info",
                "bottom",
                "Hands up! It looks like it's time for some configuration, follow the guide and get started!",
                "60"
              );
            }

            // user profile dict
            var userProfile = [];
            // array to store divs
            var userProfileTenants = [];
            // user profile tenant order dict
            var userTenantsOrderDict = {};
            // user profile tenant visibility dict
            var userTenantsVisibilityDict = {};

            // detect if we have a profile
            if (
              userPositionPrefs == "" ||
              userPositionPrefs == "None" ||
              typeof userPositionPrefs === "undefined"
            ) {
              // always return 0 as the order, we have no preferences yet
              function getOrder(tenant) {
                return 0;
              }
              function getVisibility(tenant) {
                return "True";
              }
            } else {
              // parse to the dict
              userPositionPrefs = JSON.parse(userPositionPrefs);
              userProfile = JSON.parse(userPositionPrefs["payload"]);

              // loop
              for (var i = 0, divName; i < userProfile.profile.length; i++) {
                // full object (divId, divOrder, divTenant
                divName = userProfile.profile[i];
                userProfileTenants.push(divName.divTenant);

                // Add to the dict and define the function
                userTenantsOrderDict[divName.divTenant] = divName.divOrder;
                function getOrder(tenant) {
                  return userTenantsOrderDict[tenant];
                }

                // Add to the dict and define the function
                userTenantsVisibilityDict[divName.divTenant] =
                  divName.isVisible;
                function getVisibility(tenant) {
                  return userTenantsVisibilityDict[tenant];
                }
              }
            }

            // show or hide tenant management css translation
            var show_tenants_mgmt_header_css = "grid important;";
            if (show_tenants_mgmt_header == 0) {
              show_tenants_mgmt_header_css = "none !important;";
            } else if (show_tenants_mgmt_header == 1) {
              show_tenants_mgmt_header_css = "grid !important;";
            }

            // show or hide desc css translation
            var flex_show_desc_css = "inherit important;";
            if (flex_show_desc == 0) {
              flex_show_desc_css = "none !important;";
            } else if (flex_show_desc == 1) {
              flex_show_desc_css = "inherit !important;";
            }

            // show or hide summary css translation
            var flex_show_summary_css = "inherit important;";
            if (flex_show_summary == 0) {
              flex_show_summary_css = "none !important;";
            } else if (flex_show_summary == 1) {
              flex_show_summary_css = "inherit !important;";
            }

            // dynamic style element
            $("#dyntenants").append(
              '<style id="dynstyle" type="text/css">' +
                ".parent-vtenant-top-header { display: " +
                show_tenants_mgmt_header_css +
                "px;" +
                "}" +
                "\n" +
                ".flex-items { max-width:" +
                flex_width_default +
                "px;" +
                "}" +
                "\n" +
                ".flex-items-desc { display: " +
                flex_show_desc_css +
                "}" +
                "\n" +
                ".flex-items-list { display: " +
                flex_show_summary_css +
                "}" +
                "\n" +
                ".flex-items-color { background-color:" +
                colorTheme +
                "}" +
                "</style>"
            );

            // handle alert style
            if (colorThemeStyleAlert == "red") {
              $("#dynstyle").addClass("flex-items-alert-red");
            } else if (colorThemeStyleAlert == "yellow") {
              $("#dynstyle").addClass("flex-items-alert-yellow");
            } else if (colorThemeStyleAlert == "blue") {
              $("#dynstyle").addClass("flex-items-alert-blue");
            } else if (colorThemeStyleAlert == "orange") {
              $("#dynstyle").addClass("flex-items-alert-orange");
            } else if (colorThemeStyleAlert == "green") {
              $("#dynstyle").addClass("flex-items-alert-green");
            }

            // create the container
            $("#dyntenants").append(
              '<div id="dyntenantsub" class="flex-container"></div>'
            );

            // loop through the array and handle elements
            var counter = 0;
            tenantsArray.forEach(function (item, index) {
              // consider the tenant only if it contains at least one component enabled
              if (
                item.tenant_dsm_enabled == 1 ||
                item.tenant_cim_enabled == 1 ||
                item.tenant_flx_enabled == 1 ||
                item.tenant_fqm_enabled == 1 ||
                item.tenant_wlk_enabled == 1 ||
                item.tenant_dhm_enabled == 1 ||
                item.tenant_mhm_enabled == 1
              ) {
                // divId
                counter += 1;
                itemDivId = "#item" + counter;
                itemDiv = "item" + counter;

                function isNumeric(n) {
                  return !isNaN(parseFloat(n)) && isFinite(n);
                }

                function getVar(varName) {
                  if (
                    varName == "" ||
                    varName === "null" ||
                    typeof varName === "undefined"
                  ) {
                    varName = 0;
                  } else if (!isNaN(varName)) {
                    varName = parseFloat(varName);
                  }
                  return varName;
                }

                function isNumeric(n) {
                  return !isNaN(parseFloat(n)) && isFinite(n);
                }

                function formatDateTime(date) {
                  const days = [
                    "Sun",
                    "Mon",
                    "Tue",
                    "Wed",
                    "Thu",
                    "Fri",
                    "Sat",
                  ];
                  const months = [
                    "Jan",
                    "Feb",
                    "Mar",
                    "Apr",
                    "May",
                    "Jun",
                    "Jul",
                    "Aug",
                    "Sep",
                    "Oct",
                    "Nov",
                    "Dec",
                  ];
                  const day = days[date.getDay()];
                  const month = months[date.getMonth()];
                  const dateNum = date.getDate().toString().padStart(2, "0");
                  const hours = date.getHours().toString().padStart(2, "0");
                  const minutes = date.getMinutes().toString().padStart(2, "0");
                  const seconds = date.getSeconds().toString().padStart(2, "0");
                  const year = date.getFullYear();

                  return `${day} ${month} ${dateNum} ${hours}:${minutes}:${seconds} ${year}`;
                }

                function getLastExec(varName) {
                  if (varName == "" || typeof varName === "undefined") {
                    varName = "Unknown";
                  } else if (isNumeric(varName)) {
                    var date = new Date(parseInt(varName) * 1000);
                    varName = formatDateTime(date);
                  }
                  return varName;
                }

                function getIcon(varName, icons_state_mode) {
                  var varIcon;
                  if (varName > 0) {
                    if (icons_state_mode == "emoji") {
                      varIcon = "❌";
                    } else if (icons_state_mode == "bootstrap") {
                      varIcon =
                        "<i class='bi bi-exclamation-triangle-fill icon-state-red'></i>";
                    }
                  } else {
                    varIcon = "";
                  }
                  return varIcon;
                }

                // gen the element
                if (item.tenant_status == "enabled") {
                  //
                  // get info from the tenant summary
                  //
                  // total number of entities
                  var dsm_entities = getVar(item.dsm_entities);
                  var cim_entities = getVar(item.cim_entities);
                  var flx_entities = getVar(item.flx_entities);
                  var fqm_entities = getVar(item.fqm_entities);
                  var wlk_entities = getVar(item.wlk_entities);
                  var dhm_entities = getVar(item.dhm_entities);
                  var mhm_entities = getVar(item.mhm_entities);
                  var summary_entities;

                  // sum all entities
                  summary_entities =
                    dsm_entities +
                    cim_entities +
                    dhm_entities +
                    mhm_entities +
                    flx_entities +
                    fqm_entities +
                    wlk_entities;

                  // dsm priority red entities
                  var dsm_low_red_priority = getVar(item.dsm_low_red_priority);
                  var dsm_medium_red_priority = getVar(
                    item.dsm_medium_red_priority
                  );
                  var dsm_high_red_priority = getVar(
                    item.dsm_high_red_priority
                  );
                  var dsm_critical_red_priority = getVar(
                    item.dsm_critical_red_priority
                  );

                  // cim priority red entities
                  var cim_low_red_priority = getVar(item.cim_low_red_priority);
                  var cim_medium_red_priority = getVar(
                    item.cim_medium_red_priority
                  );
                  var cim_high_red_priority = getVar(
                    item.cim_high_red_priority
                  );
                  var cim_critical_red_priority = getVar(
                    item.cim_critical_red_priority
                  );

                  // flx priority red entities
                  var flx_low_red_priority = getVar(item.flx_low_red_priority);
                  var flx_medium_red_priority = getVar(
                    item.flx_medium_red_priority
                  );
                  var flx_high_red_priority = getVar(
                    item.flx_high_red_priority
                  );
                  var flx_critical_red_priority = getVar(
                    item.flx_critical_red_priority
                  );

                  // fqm priority red entities
                  var fqm_low_red_priority = getVar(item.fqm_low_red_priority);
                  var fqm_medium_red_priority = getVar(
                    item.fqm_medium_red_priority
                  );
                  var fqm_high_red_priority = getVar(
                    item.fqm_high_red_priority
                  );
                  var fqm_critical_red_priority = getVar(
                    item.fqm_critical_red_priority
                  );

                  // wlk priority red entities
                  var wlk_low_red_priority = getVar(item.wlk_low_red_priority);
                  var wlk_medium_red_priority = getVar(
                    item.wlk_medium_red_priority
                  );
                  var wlk_high_red_priority = getVar(
                    item.wlk_high_red_priority
                  );
                  var wlk_critical_red_priority = getVar(
                    item.wlk_critical_red_priority
                  );

                  // dhm priority red entities
                  var dhm_low_red_priority = getVar(item.dsm_low_red_priority);
                  var dhm_medium_red_priority = getVar(
                    item.dhm_medium_red_priority
                  );
                  var dhm_high_red_priority = getVar(
                    item.dhm_high_red_priority
                  );
                  var dhm_critical_red_priority = getVar(
                    item.dhm_critical_red_priority
                  );

                  // mhm priority red entities
                  var mhm_low_red_priority = getVar(item.mhm_low_red_priority);
                  var mhm_medium_red_priority = getVar(
                    item.mhm_medium_red_priority
                  );
                  var mhm_high_red_priority = getVar(
                    item.mhm_high_red_priority
                  );
                  var mhm_critical_red_priority = getVar(
                    item.mhm_critical_red_priority
                  );

                  // for all
                  var low_red_priority =
                    dsm_low_red_priority +
                    cim_low_red_priority +
                    flx_low_red_priority +
                    fqm_low_red_priority +
                    wlk_low_red_priority +
                    dhm_low_red_priority +
                    mhm_low_red_priority;
                  var medium_red_priority =
                    dsm_medium_red_priority +
                    cim_medium_red_priority +
                    flx_medium_red_priority +
                    fqm_medium_red_priority +
                    wlk_medium_red_priority +
                    dhm_medium_red_priority +
                    mhm_medium_red_priority;
                  var high_red_priority =
                    dsm_high_red_priority +
                    cim_high_red_priority +
                    flx_high_red_priority +
                    fqm_high_red_priority +
                    wlk_high_red_priority +
                    dhm_high_red_priority +
                    mhm_high_red_priority;
                  var critical_red_priority =
                    dsm_critical_red_priority +
                    cim_critical_red_priority +
                    flx_critical_red_priority +
                    fqm_critical_red_priority +
                    wlk_critical_red_priority +
                    dhm_critical_red_priority +
                    mhm_critical_red_priority;

                  // sum all red entities for the tenant
                  var summary_red_entities =
                    low_red_priority +
                    medium_red_priority +
                    high_red_priority +
                    critical_red_priority;

                  // sum medium and high priorities entities for the tenant
                  var summary_highmedium_red_entities =
                    medium_red_priority + high_red_priority;

                  // ascii emoji
                  var low_red_priority_icon = getIcon(
                    low_red_priority,
                    icons_state_mode
                  );
                  var medium_red_priority_icon = getIcon(
                    medium_red_priority,
                    icons_state_mode
                  );
                  var high_red_priority_icon = getIcon(
                    high_red_priority,
                    icons_state_mode
                  );
                  var critical_red_priority_icon = getIcon(
                    critical_red_priority,
                    icons_state_mode
                  );

                  // last exec: define if the tenant is operational or degraded
                  var dsm_status = item.dsm_status;
                  var dhm_status = item.dhm_status;
                  var mhm_status = item.mhm_status;
                  var cim_status = item.cim_status;
                  var flx_status = item.flx_status;
                  var fqm_status = item.fqm_status;
                  var wlk_status = item.wlk_status;
                  var tenant_status;

                  // only affect the status if the component is enabled
                  if (item.tenant_dsm_enabled == 0) {
                    dsm_status = 0;
                  }
                  if (item.tenant_dhm_enabled == 0) {
                    dhm_status = 0;
                  }
                  if (item.tenant_mhm_enabled == 0) {
                    mhm_status = 0;
                  }
                  if (item.tenant_cim_enabled == 0) {
                    cim_status = 0;
                  }
                  if (item.tenant_flx_enabled == 0) {
                    flx_status = 0;
                  }
                  if (item.tenant_fqm_enabled == 0) {
                    fqm_status = 0;
                  }
                  if (item.tenant_wlk_enabled == 0) {
                    wlk_status = 0;
                  }

                  // if any of the component has not been refreshed since more than 10 minutes, assume it is degraded
                  if (
                    dsm_status > 0 ||
                    dhm_status > 0 ||
                    mhm_status > 0 ||
                    flx_status > 0 ||
                    fqm_status > 0 ||
                    wlk_status > 0 ||
                    cim_status > 0
                  ) {
                    tenant_status = setStatusIcon("degraded", icons_state_mode);
                    tenant_is_degraded = 1;
                  } else {
                    tenant_status = setStatusIcon(
                      "operational",
                      icons_state_mode
                    );
                    tenant_is_degraded = 0;
                  }

                  // however, shall a component be enabled with no status
                  if (
                    typeof dsm_status === "undefined" ||
                    typeof dhm_status === "undefined" ||
                    typeof mhm_status === "undefined" ||
                    typeof flx_status === "undefined" ||
                    typeof fqm_status === "undefined" ||
                    typeof wlk_status === "undefined" ||
                    typeof cim_status === "undefined"
                  ) {
                    tenant_status = setStatusIcon("degraded", icons_state_mode);
                    tenant_is_degraded = 1;
                  }

                  // last exec human
                  var dsm_last_exec_human = getLastExec(item.dsm_last_exec);
                  var cim_last_exec_human = getLastExec(item.cim_last_exec);
                  var dhm_last_exec_human = getLastExec(item.dhm_last_exec);
                  var mhm_last_exec_human = getLastExec(item.mhm_last_exec);
                  var flx_last_exec_human = getLastExec(item.flx_last_exec);
                  var fqm_last_exec_human = getLastExec(item.fqm_last_exec);
                  var wlk_last_exec_human = getLastExec(item.wlk_last_exec);

                  // getOrder: if the user has saved preferences, otherwise we return 0
                  var divOrder = getOrder(item.tenant_id);

                  // getVisbility: if the user has saved preferences, otherwise we return visible
                  var divVisibility;
                  var isVisible = getVisibility(item.tenant_id);

                  if (isVisible === "True") {
                    divVisibility = "block";
                  } else if (isVisible === "False") {
                    divVisibility = "none";
                  } else {
                    divVisibility = "block";
                  }

                  // dynclass
                  var dynclass;
                  if (summary_red_entities > 0 && dynTheme == "1") {
                    // dynTheme condition
                    if (dynThemeCondition == "any") {
                      dynclass = colorThemeStyleAlertCss;
                    } else if (
                      dynThemeCondition == "critical_priority" &&
                      critical_red_priority > 0
                    ) {
                      dynclass = colorThemeStyleAlertCss;
                    } else if (
                      dynThemeCondition == "high_priority" &&
                      (high_red_priority > 0 || critical_red_priority > 0)
                    ) {
                      dynclass = colorThemeStyleAlertCss;
                    } else if (
                      dynThemeCondition == "medium_priority" &&
                      summary_highmedium_red_entities > 0
                    ) {
                      dynclass = colorThemeStyleAlertCss;
                    } else {
                      dynclass = "flex-items-color";
                    }
                  } else {
                    dynclass = "flex-items-color";
                  }

                  $("#dyntenantsub").append(
                    '<div id="' +
                      itemDiv +
                      '" data-href="#" style="cursor: pointer; order: ' +
                      divOrder +
                      "; display:" +
                      divVisibility +
                      ';" ' +
                      'data-tenant="' +
                      item.tenant_id +
                      '" data-tenant-alias="' +
                      item.tenant_alias +
                      '" data-tenant-desc="' +
                      item.tenant_desc +
                      '" data-tenant-dsm-enabled="' +
                      item.tenant_dsm_enabled +
                      '" data-tenant-cim-enabled="' +
                      item.tenant_cim_enabled +
                      '" data-tenant-flx-enabled="' +
                      item.tenant_flx_enabled +
                      '" data-tenant-fqm-enabled="' +
                      item.tenant_fqm_enabled +
                      '" data-tenant-wlk-enabled="' +
                      item.tenant_wlk_enabled +
                      '" data-tenant-dhm-enabled="' +
                      item.tenant_dhm_enabled +
                      '" data-tenant-mhm-enabled="' +
                      item.tenant_mhm_enabled +
                      '" data-tenant-owner="' +
                      item.tenant_owner +
                      '" splk_dsm_tabulator_groupby="' +
                      item["vtenant_account"]["splk_dsm_tabulator_groupby"] +
                      '" splk_dhm_tabulator_groupby="' +
                      item["vtenant_account"]["splk_dhm_tabulator_groupby"] +
                      '" splk_mhm_tabulator_groupby="' +
                      item["vtenant_account"]["splk_mhm_tabulator_groupby"] +
                      '" splk_wlk_tabulator_groupby="' +
                      item["vtenant_account"]["splk_wlk_tabulator_groupby"] +
                      '" splk_flx_tabulator_groupby="' +
                      item["vtenant_account"]["splk_flx_tabulator_groupby"] +
                      '" splk_fqm_tabulator_groupby="' +
                      item["vtenant_account"]["splk_fqm_tabulator_groupby"] +
                      '" splk_cim_tabulator_groupby="' +
                      item["vtenant_account"]["splk_cim_tabulator_groupby"] +
                      '" sampling="' +
                      item["vtenant_account"]["sampling"] +
                      '" mloutliers="' +
                      item["vtenant_account"]["mloutliers"] +
                      '" adaptive_delay="' +
                      item["vtenant_account"]["adaptive_delay"] +
                      '" data-tenant-dsm-create-trackers="' +
                      item.tenant_dsm_create_trackers +
                      '" data-tenant-dsm-last-exec="' +
                      dsm_last_exec_human +
                      '" data-tenant-flx-last-exec="' +
                      flx_last_exec_human +
                      '" data-tenant-fqm-last-exec="' +
                      fqm_last_exec_human +
                      '" data-tenant-wlk-last-exec="' +
                      wlk_last_exec_human +
                      '" data-tenant-cim-last-exec="' +
                      cim_last_exec_human +
                      '" data-tenant-dhm-last-exec="' +
                      dhm_last_exec_human +
                      '" data-tenant-mhm-last-exec="' +
                      mhm_last_exec_human +
                      '" data-tenant-dsm-last-status="' +
                      dsm_status +
                      '" data-tenant-flx-last-status="' +
                      flx_status +
                      '" data-tenant-fqm-last-status="' +
                      fqm_status +                      
                      '" data-tenant-wlk-last-status="' +
                      wlk_status +
                      '" data-tenant-cim-last-status="' +
                      cim_status +
                      '" data-tenant-dhm-last-status="' +
                      dhm_status +
                      '" data-tenant-mhm-last-status="' +
                      mhm_status +
                      '" data-tenant-status="' +
                      item.tenant_status +
                      '" data-tenant-degraded="' +
                      tenant_is_degraded +
                      '" class="flex-items-dragg flex-items ' +
                      dynclass +
                      ' flex-item-containers"><div class="flex-items-container">' +
                      item.tenant_alias +
                      ": " +
                      tenant_status +
                      "</div></div>"
                  );

                  // tenant description
                  if (
                    item.tenant_desc !== null &&
                    typeof item.tenant_desc !== "undefined"
                  ) {
                    if (item.tenant_desc.length > 0) {
                      $(itemDivId).append(
                        '<div class="flex-items-desc"><h2>' +
                          item.tenant_desc +
                          "</h2></div>"
                      );
                    }
                  } else {
                    $(itemDivId).append(
                      '<div class="flex-items-desc"><h2></h2></div>'
                    );
                  }

                  // add the entities summary
                  $(itemDivId).append(
                    '<div style="margin-bottom: 10px;" class="flex-items-list"><h2><lu><li>Number of enabled entities: ' +
                      summary_entities +
                      "</li>" +
                      "<li>Low priority red status: " +
                      low_red_priority_icon +
                      low_red_priority +
                      "</li>" +
                      "<li>Medium priority red status: " +
                      medium_red_priority_icon +
                      medium_red_priority +
                      "</li>" +
                      "<li>High priority red status: " +
                      high_red_priority_icon +
                      high_red_priority +
                      "</li>" +
                      "<li>Critical priority red status: " +
                      critical_red_priority_icon +
                      critical_red_priority +
                      "</li>" +
                      "</lu></h2></div>"
                  );
                } else if (item.tenant_status == "disabled") {
                  // getOrder: if the user has saved preferences, otherwise we return 0
                  var divOrder = getOrder(item.tenant_id);

                  // getVisbility: if the user has saved preferences, otherwise we return visible
                  var divVisibility;
                  var isVisible = getVisibility(item.tenant_id);

                  if (isVisible === "True") {
                    divVisibility = "block";
                  } else if (isVisible === "False") {
                    divVisibility = "none";
                  } else {
                    divVisibility = "block";
                  }

                  $("#dyntenantsub").append(
                    '<div id="' +
                      itemDiv +
                      '" data-href="#" style="cursor: pointer; order: ' +
                      divOrder +
                      "; display: " +
                      divVisibility +
                      ';" ' +
                      'data-tenant="' +
                      item.tenant_id +
                      '" data-tenant-alias="' +
                      item.tenant_alias +
                      '" data-tenant-desc="' +
                      item.tenant_desc +
                      '" data-tenant-dsm-enabled="' +
                      item.tenant_dsm_enabled +
                      '" data-tenant-cim-enabled="' +
                      item.tenant_cim_enabled +
                      '" data-tenant-flx-enabled="' +
                      item.tenant_flx_enabled +
                      '" data-tenant-fqm-enabled="' +
                      item.tenant_fqm_enabled +
                      '" data-tenant-wlk-enabled="' +
                      item.tenant_wlk_enabled +
                      '" data-tenant-dhm-enabled="' +
                      item.tenant_dhm_enabled +
                      '" data-tenant-mhm-enabled="' +
                      item.tenant_mhm_enabled +
                      '" data-tenant-owner="' +
                      item.tenant_owner +
                      '" data-tenant-status="' +
                      item.tenant_status +
                      '" class="flex-items-dragg flex-items flex-items-disabled ' +
                      dynclass +
                      ' flex-item-containers"><div class="flex-items-container">' +
                      item.tenant_alias +
                      ": " +
                      setStatusIcon("disabled", icons_state_mode) +
                      "</div></div>"
                  );
                  if (
                    item.tenant_desc !== null &&
                    typeof item.tenant_desc !== "undefined"
                  ) {
                    if (item.tenant_desc.length > 0) {
                      $(itemDivId).append(
                        '<div class="flex-items-desc"><h2>' +
                          item.tenant_desc +
                          "</h2></div>"
                      );
                    }
                  } else {
                    $(itemDivId).append(
                      '<div class="flex-items-desc"><h2></h2></div>'
                    );
                  }
                }
              }
            });

            // track over events
            $(".flex-items").on("mouseenter", function () {
              var tenant_id = $(this).attr("data-tenant");
              var tenant_dsm_enabled = $(this).attr("data-tenant-dsm-enabled");
              var tenant_cim_enabled = $(this).attr("data-tenant-cim-enabled");
              var tenant_flx_enabled = $(this).attr("data-tenant-flx-enabled");
              var tenant_fqm_enabled = $(this).attr("data-tenant-fqm-enabled");
              var tenant_wlk_enabled = $(this).attr("data-tenant-wlk-enabled");
              var tenant_dhm_enabled = $(this).attr("data-tenant-dhm-enabled");
              var tenant_mhm_enabled = $(this).attr("data-tenant-mhm-enabled");
              var tenant_dsm_last_exec_human = $(this).attr(
                "data-tenant-dsm-last-exec"
              );
              if (
                tenant_dsm_last_exec_human == "undefined" ||
                tenant_dsm_last_exec_human == null ||
                tenant_dsm_last_exec_human == "null"
              ) {
                tenant_dsm_last_exec_human = "Unknown";
              }
              var tenant_dhm_last_exec_human = $(this).attr(
                "data-tenant-dhm-last-exec"
              );
              if (
                tenant_dhm_last_exec_human == "undefined" ||
                tenant_dhm_last_exec_human == null ||
                tenant_dhm_last_exec_human == "null"
              ) {
                tenant_dhm_last_exec_human = "Unknown";
              }
              var tenant_cim_last_exec_human = $(this).attr(
                "data-tenant-cim-last-exec"
              );
              if (
                tenant_cim_last_exec_human == "undefined" ||
                tenant_cim_last_exec_human == null ||
                tenant_cim_last_exec_human == "null"
              ) {
                tenant_cim_last_exec_human = "Unknown";
              }
              var tenant_flx_last_exec_human = $(this).attr(
                "data-tenant-flx-last-exec"
              );
              if (
                tenant_flx_last_exec_human == "undefined" ||
                tenant_flx_last_exec_human == null ||
                tenant_flx_last_exec_human == "null"
              ) {
                tenant_flx_last_exec_human = "Unknown";
              }
              var tenant_fqm_last_exec_human = $(this).attr(
                "data-tenant-fqm-last-exec"
              );
              if (
                tenant_fqm_last_exec_human == "undefined" ||
                tenant_fqm_last_exec_human == null ||
                tenant_fqm_last_exec_human == "null"
              ) {
                tenant_fqm_last_exec_human = "Unknown";
              }
              var tenant_wlk_last_exec_human = $(this).attr(
                "data-tenant-wlk-last-exec"
              );
              if (
                tenant_wlk_last_exec_human == "undefined" ||
                tenant_wlk_last_exec_human == null
              ) {
                tenant_wlk_last_exec_human = "Unknown";
              }
              var tenant_mhm_last_exec_human = $(this).attr(
                "data-tenant-mhm-last-exec"
              );
              if (
                tenant_mhm_last_exec_human == "undefined" ||
                tenant_mhm_last_exec_human == null ||
                tenant_mhm_last_exec_human == "null"
              ) {
                tenant_mhm_last_exec_human = "Unknown";
              }
              var tenant_dsm_status = $(this).attr(
                "data-tenant-dsm-last-status"
              );
              var tenant_cim_status = $(this).attr(
                "data-tenant-cim-last-status"
              );
              var tenant_flx_status = $(this).attr(
                "data-tenant-flx-last-status"
              );
              var tenant_fqm_status = $(this).attr(
                "data-tenant-fqm-last-status"
              );
              var tenant_wlk_status = $(this).attr(
                "data-tenant-wlk-last-status"
              );
              var tenant_dhm_status = $(this).attr(
                "data-tenant-dhm-last-status"
              );
              var tenant_mhm_last_status = $(this).attr(
                "data-tenant-mhm-last-status"
              );

              var message = "";
              var status;

              function formatStatus(status, icons_state_mode) {
                if (status == 0) {
                  if (icons_state_mode == "emoji") {
                    status = "🟢 ";
                  } else if (icons_state_mode == "bootstrap") {
                    status =
                      "<i class='bi bi-check-circle-fill icon-state-green'></i> ";
                  }
                } else {
                  if (icons_state_mode == "emoji") {
                    status = "❌ ";
                  } else if (icons_state_mode == "bootstrap") {
                    status =
                      "<i class='bi bi-exclamation-triangle-fill icon-state-red'></i> ";
                  }
                }
                return status;
              }

              if (tenant_dsm_enabled == 1) {
                status = formatStatus(tenant_dsm_status, icons_state_mode);
                message =
                  message +
                  " / DSM last exec: " +
                  status +
                  tenant_dsm_last_exec_human;
              }
              if (tenant_cim_enabled == 1) {
                status = formatStatus(tenant_cim_status, icons_state_mode);
                message =
                  message +
                  " / CIM last exec: " +
                  status +
                  tenant_cim_last_exec_human;
              }
              if (tenant_flx_enabled == 1) {
                status = formatStatus(tenant_flx_status, icons_state_mode);
                message =
                  message +
                  " / FLX last exec: " +
                  status +
                  tenant_flx_last_exec_human;
              }
              if (tenant_fqm_enabled == 1) {
                status = formatStatus(tenant_fqm_status, icons_state_mode);
                message =
                  message +
                  " / FQM last exec: " +
                  status +
                  tenant_fqm_last_exec_human;
              }
              if (tenant_wlk_enabled == 1) {
                status = formatStatus(tenant_wlk_status, icons_state_mode);
                message =
                  message +
                  " / WLK last exec: " +
                  status +
                  tenant_wlk_last_exec_human;
              }
              if (tenant_dhm_enabled == 1) {
                status = formatStatus(tenant_dhm_status, icons_state_mode);
                message =
                  message +
                  " / DHM last exec: " +
                  status +
                  tenant_dhm_last_exec_human;
              }
              if (tenant_mhm_enabled == 1) {
                status = formatStatus(tenant_mhm_last_status, icons_state_mode);
                message =
                  message +
                  " / MHM last exec: " +
                  status +
                  tenant_mhm_last_exec_human;
              }

              notify(
                "info",
                "bottom",
                "ℹ️ Double-Click to open the tenant: " +
                  tenant_id +
                  " " +
                  message,
                "5"
              );
            });

            // draggable flex boxes
            $(function () {
              $(".flex-items-dragg").draggable({
                start: function (event, ui) {
                  let target = document.getElementById(this.id);
                  target.style.zIndex = 100;
                  target.style.opacity = "50%";
                },

                stop: function (event, ui) {
                  let target = document.getElementById(this.id);
                  target.style.opacity = "100%";

                  let newPosition = $(".flex-items-dragg")
                    .map(function () {
                      return {
                        name: this.id,
                        top: this.offsetTop, // Capture vertical position
                        left: this.offsetLeft, // Capture horizontal position
                      };
                    })
                    .get();

                  // **Sort by row first (`top`), then by column (`left`)**
                  newPosition.sort((a, b) => {
                    if (a.top !== b.top) return a.top - b.top; // Sort by row first
                    return a.left - b.left; // Sort by column within row
                  });

                  // Assign new order values
                  newPosition.forEach((item, index) => {
                    let tmpItem = document.getElementById(item.name);
                    tmpItem.style.order = index;
                    tmpItem.style.left = "0px";
                    tmpItem.style.top = "0px";
                  });

                  // Reset z-index
                  target.style.zIndex = 0;
                },
              });
            });

            // show knowledge objects function
            function showTenantKos(ajaxUrl, ajaxType, ajaxData) {
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait loading the tenant knowledge objects..."></div>'
              );
              // Run the ajax promise
              var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(
                function (resultCall) {
                  tabulatorElement = "#showKosTabulator";

                  function jsonFormatter(cell, formatterParams, onRendered) {
                    cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                    return JSON.stringify(cell.getValue(), null, 4); //return JSON formatted cell
                  }

                  // count the number of items in the array and update the title
                  var no_items = resultCall.length;
                  var no_collections = 0;
                  var no_lookups = 0;
                  var no_savedsearches_scheduled = 0;
                  var no_savedsearches_not_scheduled = 0;
                  var no_macros = 0;
                  var no_alerts = 0;
                  var type_ko;
                  var ko_properties;

                  for (var i = 0; i < resultCall.length; i++) {
                    type_ko = resultCall[i].type;
                    ko_properties = resultCall[i].properties;
                    if (type_ko === "kvstore_collections") {
                      no_collections++;
                    } else if (type_ko === "lookup_definitions") {
                      no_lookups++;
                    } else if (type_ko === "savedsearches") {
                      // Check if "is_scheduled" exists and is set to 1
                      if (ko_properties && ko_properties.is_scheduled === 1) {
                        no_savedsearches_scheduled++;
                      } else {
                        no_savedsearches_not_scheduled++;
                      }
                    } else if (type_ko === "macros") {
                      no_macros++;
                    } else if (type_ko === "alerts") {
                      no_alerts++;
                    }
                  }

                  $("#divTitleKos1").html(
                    "<h1>" + ajaxData["tenant_id"] + ":</h1>"
                  );

                  $("#divTitleKos2").html(
                    '<h1><span style="color: #a7c7e7;">' +
                      no_items +
                      " Knowledge Object(s) / " +
                      no_collections +
                      " KVstore(s) / " +
                      no_lookups +
                      " Lookup(s) / " +
                      no_savedsearches_scheduled +
                      " Scheduled Report(s) / " +
                      no_savedsearches_not_scheduled +
                      " Non Scheduled Report(s) / " +
                      no_alerts +
                      " Alert(s) / " +
                      no_macros +
                      " Macro(s)" +
                      "</span></h1>"
                  );

                  var table = new TabulatorFull(tabulatorElement, {
                    data: resultCall,
                    index: "title",
                    layout: "fitDataStretch", //fit columns to width of table
                    responsiveLayout: "hide", //hide columns that dont fit on the table
                    movableRows: true, // allow rows to be moved
                    addRowPos: "top", //when adding a new row, add it to the top of the table
                    history: true, //allow undo and redo actions on the table
                    pagination: "local", //paginate the data
                    paginationSize: 10, //allow 5 rows per page of data
                    paginationCounter: "rows", //display count of paginated rows in footer
                    movableColumns: true, //allow column order to be changed
                    resizableRows: true, //allow row order to be changed
                    maxHeight: "600px",
                    groupBy: "component",
                    initialSort: [
                      //set the initial sort order of the data
                      { column: "type", dir: "asc" },
                    ],

                    columns: [
                      //define the table columns
                      {
                        title: "Component",
                        field: "component",
                        editor: false,
                        headerFilter: true,
                        sorter: "string",
                      },
                      {
                        title: "Type",
                        field: "type",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "Title",
                        field: "title",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "Properties",
                        field: "properties",
                        formatter: jsonFormatter,
                        variableHeight: true,
                        editor: false,
                        headerFilter: true,
                      },
                    ],
                  });

                  table.on("tableBuilt", function () {
                    // remove spinner
                    $("#cssloader").remove();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Tenant's knowledge objects list successfully loaded!",
                      "5"
                    );
                  });

                  // "btn-ko-show-only-savedsearches" button
                  $("#btn-ko-show-only-savedsearches")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                      table.setFilter([
                        { field: "type", type: "=", value: "savedsearches" },
                      ]);
                    });

                  // "btn-ko-show-only-alerts" button
                  $("#btn-ko-show-only-alerts")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                      table.setFilter([
                        { field: "type", type: "=", value: "alerts" },
                      ]);
                    });

                  // "btn-ko-show-only-kvstore_collections" button
                  $("#btn-ko-show-only-kvstore_collections")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                      table.setFilter([
                        {
                          field: "type",
                          type: "=",
                          value: "kvstore_collections",
                        },
                      ]);
                    });

                  // "btn-ko-show-only-lookup_definitions" button
                  $("#btn-ko-show-only-lookup_definitions")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                      table.setFilter([
                        {
                          field: "type",
                          type: "=",
                          value: "lookup_definitions",
                        },
                      ]);
                    });

                  // "btn-ko-show-only-macros" button
                  $("#btn-ko-show-only-macros")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                      table.setFilter([
                        { field: "type", type: "=", value: "macros" },
                      ]);
                    });

                  // "btn-ko-show-only-all" button
                  $("#btn-ko-show-only-all")
                    .unbind()
                    .click(function () {
                      table.clearFilter(true);
                    });
                }
              );
            }

            // show knowledge objects button
            $("#show_tenant_kos")
              .unbind()
              .click(function () {
                $(this).blur();
                // set the tenant id
                var clickedTenantId = getToken("clickedTenantId");
                // set the open in search link
                $("#btn_modal_open_kos").attr(
                  "href",
                  encodeURI(
                    'search?q=| trackmegetkos tenant_id="' +
                      clickedTenantId +
                      '"'
                  )
                );
                // get table
                showTenantKos(
                  getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/configuration/get_tenant_knowledge_objects"
                  ),
                  "post",
                  { tenant_id: clickedTenantId }
                );
                // open modal
                $("#modal_show_tenant_kos").modal();
              });

            // edit position profile
            function show_profile() {
              // retrieve all div from the class, build a dictionnary of tenants_id / order
              var jsonDict = [];
              var divId;
              var divOrder;
              var isVisible;

              $(".flex-items-dragg").each(function (index, value) {
                divId = `${this.id}`;
                divOrder = $(this).css("order");
                divVisibility = $(this).css("display");
                divTenant = $(this).attr("data-tenant");
                if (divVisibility == "block") {
                  isVisible = "True";
                } else {
                  isVisible = "False";
                }

                jsonDict.push({
                  divTenant: divTenant,
                  divOrder: divOrder,
                  isVisible: isVisible,
                });

                //
              });

              // loop through the object
              initialJsonDict = [];
              Object.entries(jsonDict).forEach(([k, v]) => {
                initialJsonDict.push({
                  divTenant: v["divTenant"],
                  isVisible: v["isVisible"],
                  divOrder: k,
                });
              });

              // tabulator profile
              function editProfileTable(jsonDict) {
                tabulatorElement = "#editProfileTabulator";
                var table = new TabulatorFull(tabulatorElement, {
                  data: jsonDict,
                  index: "divTenant",
                  layout: "fitColumns", //fit columns to width of table
                  responsiveLayout: "hide", //hide columns that dont fit on the table
                  movableRows: true, // allow rows to be moved
                  addRowPos: "top", //when adding a new row, add it to the top of the table
                  history: false, //allow undo and redo actions on the table
                  pagination: "local", //paginate the data
                  paginationSize: 10, //allow 5 rows per page of data
                  paginationCounter: "rows", //display count of paginated rows in footer
                  movableColumns: true, //allow column order to be changed
                  resizableRows: true, //allow row order to be changed
                  //groupValues: [["block", "none"]],
                  groupBy: "isVisible",
                  initialSort: [
                    //set the initial sort order of the data
                    { column: "divOrder", dir: "asc" },
                  ],

                  columns: [
                    //define the table columns
                    {
                      rowHandle: true,
                      formatter: "handle",
                      headerSort: false,
                      frozen: true,
                      width: 30,
                      minWidth: 30,
                    },
                    {
                      title: "tenant_id",
                      field: "divTenant",
                      editor: false,
                      headerFilter: true,
                      sorter: "string",
                    },
                    {
                      title: "Position order",
                      field: "divOrder",
                      editor: false,
                      headerFilter: true,
                      sorter: "number",
                    },
                    {
                      title: "Is visible",
                      field: "isVisible",
                      hozAlign: "center",
                      formatter: "tickCross",
                      editor: "list",
                      editorParams: { values: ["True", "False"] },
                      headerFilter: false,
                      headerSort: false,
                    },
                  ],
                });

                // detect inline edit
                table.on("cellEdited", function (cell) {
                  //e - the click event object
                  //row - row component
                  $("#btn_modal_edit_profile").prop("disabled", false);
                });

                //listen for row move
                table.on("rowMoved", function (row) {
                  // loop through the object
                  var newJsonDict = [];
                  var selectedData = table.getData("active");
                  Object.entries(selectedData).forEach(([k, v]) => {
                    newJsonDict.push({
                      divTenant: v["divTenant"],
                      isVisible: v["isVisible"],
                      divOrder: k,
                    });
                  });

                  // replace data table
                  table.replaceData(JSON.stringify(newJsonDict));

                  // enable the button
                  $("#btn_modal_edit_profile").prop("disabled", false);
                });

                // update
                $("#btn_modal_edit_profile")
                  .unbind("click")
                  .click(function () {
                    var selectedData = table.getData("active");

                    // loop through the object
                    var newJsonDict = [];
                    Object.entries(selectedData).forEach(([k, v]) => {
                      newJsonDict.push({
                        divTenant: v["divTenant"],
                        isVisible: v["isVisible"],
                        divOrder: k,
                      });
                    });

                    // Get current user
                    var currentUser = Splunk.util.getConfigValue("USERNAME");

                    var myendpoint_URl = getSplunkUrl(
                      "/splunkd/__raw/services/trackme/v2/configuration/update_vtenants_user_prefs"
                    );

                    var postJsonData = {
                      target_user: currentUser,
                      target_prefs: "position",
                      json_data: newJsonDict,
                    };

                    $.ajax({
                      url: myendpoint_URl,
                      type: "POST",
                      async: true,
                      data: JSON.stringify(postJsonData),
                      contentType: "application/json",
                      success: function (returneddata) {
                        returneddata = JSON.parse(returneddata);
                        payload = JSON.parse(returneddata["payload"]);
                        profile = payload["profile"];

                        // replace data table
                        table.replaceData(JSON.stringify(profile));
                        // refresh flex boxes
                        getTenantsList("false", "true");
                        // notify
                        notify(
                          "success",
                          "bottom",
                          "OK! your user profile has been updated successfully",
                          "5"
                        );
                      },
                      error: function (xhr, textStatus, error) {
                        showErrorModal(
                          "modal_generic_error",
                          "Oops!",
                          xhr,
                          textStatus,
                          error
                        );
                      },
                    });
                  });
              }

              editProfileTable(initialJsonDict);
            }

            // edit profile button
            $("#edit_tenants_position")
              .unbind()
              .click(function () {
                $(this).blur();
                // get current
                show_profile();
                $("#modal_edit_profile").modal();
              });

            // hide a tenant (and save profile)

            function hide_tenant(successMsg, tenant_id) {
              // Create the service
              var service = mvc.createService({
                owner: "nobody",
              });

              // Get current user
              var currentUser = Splunk.util.getConfigValue("USERNAME");

              // retrieve all div from the class, build a dictionnary of tenants_id / order
              var jsonDict = [];
              var divId;
              var divOrder;
              var isVisible;

              $(".flex-items-dragg").each(function (index, value) {
                divId = `${this.id}`;
                divOrder = $(this).css("order");
                divTenant = $(this).attr("data-tenant");

                // if target
                if (divTenant == tenant_id) {
                  $("#" + divId).css("display", "none");
                  divVisibility = "none";
                  isVisible = "False";
                } else {
                  divVisibility = $(this).css("display");
                  isVisible = "True";
                }

                jsonDict.push({
                  divTenant: divTenant,
                  isVisible: isVisible,
                  divOrder: divOrder,
                });

                //
              });

              // Get current user
              var currentUser = Splunk.util.getConfigValue("USERNAME");

              var myendpoint_URl = getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/configuration/update_vtenants_user_prefs"
              );

              var postJsonData = {
                target_user: currentUser,
                target_prefs: "position",
                json_data: jsonDict,
              };

              $.ajax({
                url: myendpoint_URl,
                type: "POST",
                async: true,
                data: JSON.stringify(postJsonData),
                contentType: "application/json",
                success: function (returneddata) {
                  // notify
                  notify("success", "bottom", successMsg, "5");
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });

              //
            }

            // save position profile

            function save_profile(successMsg) {
              // Get current user
              var currentUser = Splunk.util.getConfigValue("USERNAME");

              // retrieve all div from the class, build a dictionnary of tenants_id / order
              var jsonDict = [];
              var divId;
              var divOrder;
              var isVisible;

              $(".flex-items-dragg").each(function (index, value) {
                divId = `${this.id}`;
                divOrder = $(this).css("order");
                divVisibility = $(this).css("display");
                if (divVisibility === "block") {
                  isVisible = "True";
                } else {
                  isVisible = "False";
                }
                divTenant = $(this).attr("data-tenant");

                jsonDict.push({
                  divTenant: divTenant,
                  divVisibility: divVisibility,
                  isVisible: isVisible,
                  divOrder: divOrder,
                });

                //
              });

              // Get current user
              var currentUser = Splunk.util.getConfigValue("USERNAME");

              var myendpoint_URl = getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/configuration/update_vtenants_user_prefs"
              );

              var postJsonData = {
                target_user: currentUser,
                target_prefs: "position",
                json_data: jsonDict,
              };

              $.ajax({
                url: myendpoint_URl,
                type: "POST",
                async: true,
                data: JSON.stringify(postJsonData),
                contentType: "application/json",
                success: function (returneddata) {
                  // refresh
                  getTenantsList("false", "true");
                  // notify
                  notify(
                    "success",
                    "bottom",
                    "OK! your user profile has been updated successfully",
                    "5"
                  );
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });

              //
            }

            // save profile button
            $("#save_tenants_position")
              .unbind()
              .click(function () {
                $(this).blur();
                $("#modal_save_profile").modal();
              });

            $("#btn_modal_save_profile")
              .unbind()
              .click(function () {
                $(this).blur();
                // call the function
                save_profile(
                  "OK! Your preferences have been saved successfully"
                );
              });

            // reset position profile
            $("#reset_tenants_position")
              .unbind()
              .click(function () {
                $(this).blur();
                $("#modal_reset_profile").modal();
              });

            $("#btn_modal_reset_profile")
              .unbind()
              .click(function () {
                $(this).blur();

                var dataJson = {
                  vtenant_position_userpref: "True",
                  vtenant_theme_userpref: "True",
                };

                // function
                function deletePreferences(urlTarget) {
                  $.ajax({
                    url: urlTarget,
                    type: "POST",
                    async: true,
                    contentType: "application/json",
                    dataType: "text",
                    data: JSON.stringify(dataJson),
                    success: function () {
                      // Refresh
                      getTenantsList("false", "true");
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "OK! We've erased your user profiles, tenants cards position and visibility, as well as color theme and behaviour preferences were reverted to default",
                        "5"
                      );
                    },
                    error: function (xhr, textStatus, error) {
                      showErrorModal(
                        "modal_generic_error",
                        "Oops!",
                        xhr,
                        textStatus,
                        error
                      );
                    },
                  });
                }

                var myendpoint_URl = getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/configuration/reset_vtenants_prefs"
                );

                // Call the API endpoint
                deletePreferences(myendpoint_URl);
                //
              });

            $("#btn_modal_reset_profile_position_only")
              .unbind()
              .click(function () {
                $(this).blur();

                var dataJson = {
                  vtenant_position_userpref: "True",
                  vtenant_theme_userpref: "False",
                };

                // function
                function deletePreferences(urlTarget) {
                  $.ajax({
                    url: urlTarget,
                    type: "POST",
                    async: true,
                    contentType: "application/json",
                    dataType: "text",
                    data: JSON.stringify(dataJson),
                    success: function () {
                      // Refresh
                      getTenantsList("false", "true");
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "OK! Tenants flex boses position and visibility preferences were reverted to default",
                        "5"
                      );
                    },
                    error: function (xhr, textStatus, error) {
                      showErrorModal(
                        "modal_generic_error",
                        "Oops!",
                        xhr,
                        textStatus,
                        error
                      );
                    },
                  });
                }

                var myendpoint_URl = getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/configuration/reset_vtenants_prefs"
                );

                // Call the API endpoint
                deletePreferences(myendpoint_URl);
                //
              });

            $("#btn_modal_reset_profile_theme_only")
              .unbind()
              .click(function () {
                $(this).blur();

                var dataJson = {
                  vtenant_position_userpref: "False",
                  vtenant_theme_userpref: "True",
                };

                // function
                function deletePreferences(urlTarget) {
                  $.ajax({
                    url: urlTarget,
                    type: "POST",
                    async: true,
                    contentType: "application/json",
                    dataType: "text",
                    data: JSON.stringify(dataJson),
                    success: function () {
                      // Refresh
                      getTenantsList("true", "true");
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "OK! Color theme and behaviour preferences were reverted to default",
                        "5"
                      );
                    },
                    error: function (xhr, textStatus, error) {
                      showErrorModal(
                        "modal_generic_error",
                        "Oops!",
                        xhr,
                        textStatus,
                        error
                      );
                    },
                  });
                }

                var myendpoint_URl = getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/configuration/reset_vtenants_prefs"
                );

                // Call the API endpoint
                deletePreferences(myendpoint_URl);
                //
              });

            // hide tenant from profile button
            $("#hide_tenant_confirmed")
              .unbind()
              .click(function () {
                $(this).blur();
                var tenant_id = defaultTokenModel.get("clickedTenantId");
                // call function
                hide_tenant(
                  "OK! The tenant has been hiden successfully. This configuration is stored in your user profile, you can reset your user profile if you wish to revert this.",
                  tenant_id
                );
              });

            //
            // Load tenant Flex function
            //
            function load_tenant_flex(
              clickedTenantId,
              clickedTenantDsmEnabled,
              clickedTenantCimEnabled,
              clickedTenantDhmEnabled,
              clickedTenantMhmEnabled,
              clickedTenantFlxEnabled,
              clickedTenantFqmEnabled,
              clickedTenantWlkEnabled
            ) {
              // Initialize the div container for span elements
              var spanTenantsEnablement = $(
                '<div style="max-height: 30px;"></div>'
              );

              // DSM Component
              if (clickedTenantDsmEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-dsm-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-DSM is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-dsm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Data Source Monitoring component (DSM) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-dsm-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-DSM is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-dsm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Data Source Monitoring component (DSM) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // CIM Component
              if (clickedTenantCimEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-cim-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-CIM is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-cim-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Common Information Model Tracking component (SPLK-CIM) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-cim-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-CIM is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-cim-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Common Information Model Tracking component (SPLK-CIM) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // FLX Component
              if (clickedTenantFlxEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-flx-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-FLX is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-flx-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Flex object Tracking component (SPLK-FLX) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-flx-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-FLX is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-flx-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Flex Object Tracking component (SPLK-FLX) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // FQM Component
              if (clickedTenantFqmEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-fqm-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-FQM is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-fqm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Flex object Tracking component (SPLK-FQM) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-fqm-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-FQM is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-fqm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Flex Object Tracking component (SPLK-FQM) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // WLK Component
              if (clickedTenantWlkEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-wlk-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-WLK is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-wlk-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Splunk Workload component (SPLK-WLK) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-wlk-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-WLK is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-wlk-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Splunk Workload component (SPLK-WLK) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // DHM Component
              if (clickedTenantDhmEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-dhm-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-DHM is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-dhm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Data Host Monitoring component (DHM) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-dhm-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-DHM is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-dhm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Data Host Monitoring component (DHM) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // MHM Component
              if (clickedTenantMhmEnabled == 0) {
                spanTenantsEnablement.append(
                  '<span id="badge-mhm-component-status" style="margin-right: 10px;" class="badge badge-disabled">SPLK-MHM is disabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-mhm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Metric Host Monitoring component (MHM) was not enabled for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              } else {
                spanTenantsEnablement.append(
                  '<span id="badge-mhm-component-status" style="margin-right: 10px;" class="badge badge-enabled">SPLK-MHM is enabled</span>'
                );
                spanTenantsEnablement
                  .find("#badge-mhm-component-status")
                  .on("mouseover", function () {
                    notify(
                      "info",
                      "bottom",
                      "ℹ️ The Metric Host Monitoring component (MHM) was activated for this tenant, you can add or remove components in the Virtual Tenant management UI",
                      "10"
                    );
                  });
              }

              // Finally, append the built div to #dynmodal
              $("#dynmodal").append(spanTenantsEnablement);
            }

            // track click events
            $(".flex-items").dblclick(function () {
              window.location = $(this).attr("data-href");
              var item = $(this).attr("data-tenant");

              // set the open tenant link
              $("#open_tenant").attr(
                "href",
                encodeURI("trackMe_home?tenant_id=" + item)
              );

              // set the open SLA link
              $("#open_sla").attr(
                "href",
                encodeURI("trackMe_sla?form.tk_tenant_id=" + item)
              );

              // set tokens
              defaultTokenModel.unset("clickedTenantId");
              defaultTokenModel.unset("clickedTenantIdDsmEntities");
              defaultTokenModel.unset("clickedTenantIdCimEntities");
              defaultTokenModel.unset("clickedTenantIdFlxEntities");
              defaultTokenModel.unset("clickedTenantIdFqmEntities");
              defaultTokenModel.unset("clickedTenantIdWlkEntities");
              defaultTokenModel.unset("clickedTenantIdDhmEntities");
              defaultTokenModel.unset("clickedTenantIdMhmEntities");
              defaultTokenModel.set("clickedTenantId", item);

              // for badges
              var clickedTenantDsmEnabled = $(this).attr(
                "data-tenant-dsm-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantDsmEnabled",
                clickedTenantDsmEnabled
              );
              var clickedTenantCimEnabled = $(this).attr(
                "data-tenant-cim-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantCimEnabled",
                clickedTenantCimEnabled
              );
              var clickedTenantFlxEnabled = $(this).attr(
                "data-tenant-flx-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantFlxEnabled",
                clickedTenantFlxEnabled
              );
              var clickedTenantFqmEnabled = $(this).attr(
                "data-tenant-fqm-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantFqmEnabled",
                clickedTenantFqmEnabled
              );
              var clickedTenantWlkEnabled = $(this).attr(
                "data-tenant-wlk-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantWlkEnabled",
                clickedTenantWlkEnabled
              );
              var clickedTenantDhmEnabled = $(this).attr(
                "data-tenant-dhm-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantDhmEnabled",
                clickedTenantDhmEnabled
              );
              var clickedTenantMhmEnabled = $(this).attr(
                "data-tenant-mhm-enabled"
              );
              defaultTokenModel.set(
                "clickedTenantMhmEnabled",
                clickedTenantMhmEnabled
              );

              // groupby tabulator
              defaultTokenModel.set(
                "clickedTenantDsmTabulatorGroupBy",
                $(this).attr("splk_dsm_tabulator_groupby")
              );
              defaultTokenModel.set(
                "clickedTenantDhmTabulatorGroupBy",
                $(this).attr("splk_dhm_tabulator_groupby")
              );
              defaultTokenModel.set(
                "clickedTenantMhmTabulatorGroupBy",
                $(this).attr("splk_mhm_tabulator_groupby")
              );
              defaultTokenModel.set(
                "clickedTenantFlxTabulatorGroupBy",
                $(this).attr("splk_flx_tabulator_groupby")
              );
              defaultTokenModel.set(
                "clickedTenantFqmTabulatorGroupBy",
                $(this).attr("splk_fqm_tabulator_groupby")
              );              
              defaultTokenModel.set(
                "clickedTenantWlkTabulatorGroupBy",
                $(this).attr("splk_wlk_tabulator_groupby")
              );
              defaultTokenModel.set(
                "clickedTenantCimTabulatorGroupBy",
                $(this).attr("splk_cim_tabulator_groupby")
              );

              // sampling boolean
              clickedTenantSampling = $(this).attr("sampling") === "1";
              defaultTokenModel.set(
                "clickedTenantSampling",
                clickedTenantSampling
              );

              // mloutliers boolean
              clickedTenantMlOutliers = $(this).attr("mloutliers") === "1";
              defaultTokenModel.set(
                "clickedTenantMlOutliers",
                clickedTenantMlOutliers
              );

              // adaptive_delay boolean
              clickedTenantAdaptiveDelay =
                $(this).attr("adaptive_delay") === "1";
              defaultTokenModel.set(
                "clickedTenantAdaptiveDelay",
                clickedTenantAdaptiveDelay
              );

              // for RBAC update prefill
              var clickedTenantOwner = $(this).attr("data-tenant-owner");
              defaultTokenModel.set("clickedTenantOwner", clickedTenantOwner);

              // prefill dropdown input for RBAC updates (multiselect cannot be prefilled)
              defaultTokenModel.set(
                "tk_update_tenant_owner",
                clickedTenantOwner
              );

              // set var
              var clickedTenantId = $(this).attr("data-tenant");
              var clickedTenantAlias = $(this).attr("data-tenant-alias");
              var clickedTenantDescription = $(this).attr("data-tenant-desc");
              var tenantStatus = $(this).attr("data-tenant-status");
              var TenantIsDegraded = $(this).attr("data-tenant-degraded");

              // compose the object name conditionally
              var clickedObject;
              var notifyMsg;

              if (
                clickedTenantDescription == null ||
                typeof clickedTenantDescription == "undefined" ||
                clickedTenantDescription == "undefined"
              ) {
                clickedObject = clickedTenantId;
                notifyMsg = "ℹ️ Overview of the tenant id: ";
                clickedTenantId +
                  " / alias: " +
                  clickedTenantAlias +
                  " - Get tenant activity insights and manage its life cycle from this screen";
              } else {
                if (clickedTenantDescription.length > 1) {
                  clickedObject =
                    clickedTenantId +
                    " / alias: " +
                    clickedTenantAlias +
                    " / " +
                    clickedTenantDescription;
                  notifyMsg =
                    "ℹ️ Overview of the tenant id: " +
                    clickedTenantId +
                    " / " +
                    clickedTenantDescription +
                    " - Get tenant activity insights and manage its life cycle from this screen";
                } else {
                  clickedObject = clickedTenantId;
                  notifyMsg =
                    "ℹ️ Overview of the tenant id: " +
                    clickedTenantId +
                    " / alias:" +
                    clickedTenantAlias +
                    " - Get tenant activity insights and manage its life cycle from this screen";
                }
              }

              // Show message
              notify("info", "bottom", notifyMsg, "10");

              // create element for tenant overview
              $("#dynmodal").remove();
              $("#modal_tenant_overview_body").prepend(
                '<div id="dynmodal"><h1>Overview of the tenant id: ' +
                  clickedObject +
                  "</h1>" +
                  "</div>"
              );

              // badges
              $("#dynmodal").append(
                '<div style="margin-top: 20px;" id="badges">'
              );

              if (tenantStatus == "enabled") {
                // show button id open_tenant (display none)
                $("#open_tenant").css("display", "block");
                // show button id open_sla
                $("#open_sla").css("display", "block");
                // call function
                load_tenant_flex(
                  clickedTenantId,
                  clickedTenantDsmEnabled,
                  clickedTenantCimEnabled,
                  clickedTenantDhmEnabled,
                  clickedTenantMhmEnabled,
                  clickedTenantFlxEnabled,
                  clickedTenantFqmEnabled,
                  clickedTenantWlkEnabled
                );

                // If degraded, add a message and link
                if (TenantIsDegraded == 1) {
                  $("#dynmodal").append("<br />");
                  $("#dynmodal").append(
                    "<h2><i class='bi bi-exclamation-triangle-fill icon-state-red'></i> This tenant operational status is currently degraded, this means that TrackMe detected an issue affecting the Virtual Tenant, click <a href='#' class='ops-status-link'>here</a> to review Virtual Tenants issues. <i class='bi bi-exclamation-triangle-fill icon-state-red'></i></h2>"
                  );
                  $("#dynmodal").append("<br />");

                  // Attach event listener for dynamically added ops-status-link
                  $(document).on("click", ".ops-status-link", function (e) {
                    // 'e' as the event object
                    e.preventDefault(); // Prevent default link behavior

                    // close the current modal
                    $("#modal_tenant_overview").modal("hide");

                    // click on button id btn_ops_status
                    $("#btn_ops_status").click();

                    //
                  });
                }
              } else {
                // hide button id open_tenant (display none)
                $("#open_tenant").css("display", "none");
                // hide button id open_sla
                $("#open_sla").css("display", "none");
                // set the min heigh of the div id div_body_tenant_overview to be 200px
                $("#div_body_tenant_overview").css("min-height", "200px");
                // append the badge
                $("#dynmodal").append("<br />");
                $("#dynmodal").append(
                  "<h2><i class='bi bi-exclamation-triangle-fill icon-state-red'></i> This tenant is currently disabled, all related knowledge objects and trackers are disabled. <i class='bi bi-exclamation-triangle-fill icon-state-red'></i></h2>"
                );
                $("#dynmodal").append(
                  '<h2>You can manage the tenant and choose to re-enable or destroy it, click on the button "Manage this tenant".</h2>'
                );
                $("#dynmodal").append("<br />");
                // notify
                notify(
                  "warning",
                  "bottom",
                  "WARN: This tenant is currently disabled and therefore inactive, if you wish to do so you can re-enable the tenant in this screen",
                  "10"
                );
              }

              // append links to the tenant indexes

              var searchIdxMetrics =
                "| mpreview `trackme_metrics_idx(" +
                clickedTenantId +
                ')` filter="tenant_id="' +
                clickedTenantId +
                '""';
              var searchIdxNotable =
                "search `trackme_notable_idx(" +
                clickedTenantId +
                ')` tenant_id="' +
                clickedTenantId +
                '"';
              var searchIdxAudit =
                "search `trackme_audit_idx(" +
                clickedTenantId +
                ')` tenant_id="' +
                clickedTenantId +
                '"';
              var searchIdxSummary =
                "search `trackme_idx(" +
                clickedTenantId +
                ')` tenant_id="' +
                clickedTenantId +
                '"';

              var divObject =
                '<div style="margin-top: 15px; margin-bottom: 80px; margin-left: 30px; margin-right: 30px;">' +
                '<div style="margin-right: 15px; float: right;"><a class="btn btn-outline-info" id="btn_search_metrics_idx" target="_blank" href="search?q=' +
                encodeURI(searchIdxMetrics) +
                '" role="button"><i class="bi bi-search text-primary"></i> Metrics index</a></div>' +
                '<div style="margin-right: 15px; float: right;"><a class="btn btn-outline-info" id="btn_search_notable_idx" target="_blank" href="search?q=' +
                encodeURI(searchIdxNotable) +
                '" role="button"><i class="bi bi-search text-primary"></i> Notable index</a></div>' +
                '<div style="margin-right: 15px; float: right;"><a class="btn btn-outline-info" id="btn_search_audit_idx" target="_blank" href="search?q=' +
                encodeURI(searchIdxAudit) +
                '" role="button"><i class="bi bi-search text-primary"></i> Audit index</a></div>' +
                '<div style="margin-right: 15px; float: right;"><a class="btn btn-outline-info" id="btn_search_summary_idx" target="_blank" href="search?q=' +
                encodeURI(searchIdxSummary) +
                '" role="button"><i class="bi bi-search text-primary"></i> Summary index</a></div>' +
                "</div>";

              $("#dynmodal").append(divObject);

              $("#btn_search_summary_idx").hover(function () {
                // show message
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Click to open in Splunk Search UI the data for the TrackMe summary index, this index contains state events as well as other types of TrackMe events.",
                  "5"
                );
              });

              $("#btn_search_audit_idx").hover(function () {
                // show message
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Click to open in Splunk Search UI the data for the TrackMe audit index, this index contains audit events generated when modifications are made to TrackMe and its entities, as well as health audit events.",
                  "5"
                );
              });

              $("#btn_search_notable_idx").hover(function () {
                // show message
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Click to open in Splunk Search UI TrackMe notable events, the notable index contains highly valuable events correlated when TrackMe triggers alerts on TrackMe entities, for alerting and notification purposes.",
                  "5"
                );
              });

              $("#btn_search_metrics_idx").hover(function () {
                // show message
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Click to open in Splunk Search UI TrackMe metrics using mpreview, metrics are at the root of the TrackMe concepts and support many features from detection to Machine Learning detection.",
                  "5"
                );
              });

              if (tenantStatus == "enabled") {
                $("#dynmodal").append("</div>");

                // DSM overview if enabled
                if (clickedTenantDsmEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewDsm.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Data Source Monitoring (SPLK-DSM) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-dsm-container" style="height: 40px;"><div id="badges-dsm" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-dsm").append(
                    '<div id="badges-dsm-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdDsmEntities = defaultTokenModel.get(
                      "clickedTenantIdDsmEntities"
                    );
                    var clickedTenantIdDsmEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesStatusGreen"
                      );
                    var clickedTenantIdDsmEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesStatusRed"
                      );
                    var clickedTenantIdDsmEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesStatusOthers"
                      );
                    var clickedTenantIdDsmEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesPriorityLow"
                      );
                    var clickedTenantIdDsmEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesPriorityMedium"
                      );
                    var clickedTenantIdDsmEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesPriorityHigh"
                      );
                    var clickedTenantIdDsmEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesPriorityCritical"
                      );
                    var clickedTenantIdDsmEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdDsmEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdDsmEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdDsmEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdDsmEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdDsmEntities !== "undefined") {
                      // remove loader
                      $("#badges-dsm-loader").remove();
                      //
                      // Update DOM
                      //

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-dsm").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="dsm_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#dsm_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-dsm tabulator
                      function splkDsmHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#dsmOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantDsmTabulatorGroupBy"
                        );

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: dodgerblue; font-style: italic;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Sourcetype:</h3>";
                          contents +=
                            "<li><strong>Index:</strong> " +
                            data.data_index +
                            "</li>";
                          contents +=
                            "<li><strong>Sourcetype:</strong> " +
                            data.data_sourcetype +
                            "</li>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>AnomalyReason:</strong> " +
                            data.anomaly_reason +
                            "</li>";
                          contents +=
                            "<li><strong>Outliers anomaly detection state:</strong> " +
                            data.OutliersStatus +
                            "</li>";
                          contents +=
                            "<li><strong>Data sampling anomaly detection state:</strong> " +
                            data.SamplingStatus +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Delay & Latency:</h3>";
                          contents +=
                            "<li><strong>Lagging summary:</strong> " +
                            data.lag_summary +
                            "</li>";
                          contents +=
                            "<li><strong>Last ingest:</strong> " +
                            data.last_ingest +
                            "</li>";
                          contents +=
                            "<li><strong>Last event:</strong> " +
                            data.last_time +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Thresholds & Configuration</h3>";
                          contents +=
                            "<li><strong>Max latency allowed:</strong> " +
                            data.data_max_lag_allowed +
                            " seconds</li>";
                          contents +=
                            "<li><strong>Max delay allowed:</strong> " +
                            data.data_max_delay_allowed +
                            " seconds</li>";
                          contents +=
                            "<li><strong>Hosts distinct count:</strong> " +
                            data.dcount_host +
                            "</li>";
                          contents +=
                            "<li><strong>Min hosts distinct count:</strong> " +
                            data.min_dcount_host +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring days:</strong> " +
                            data.isUnderMonitoringDays +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring hours:</strong> " +
                            data.isUnderMonitoringHours +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        //
                        // Row popup formatter for Sampling
                        //

                        // popup formatter
                        var rowPopupFormatterSampling = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // SamplingIsOk (0 for False, 1 for True), data_sample_anomaly_reason

                          var SamplingIsOk = data.SamplingIsOk;
                          var data_sample_anomaly_reason =
                            data.data_sample_anomaly_reason;

                          // Turn SamplingIsOk from 0 to False, 1 to True
                          if (SamplingIsOk == "0") {
                            SamplingIsOk = "False";
                          } else if (SamplingIsOk == "1") {
                            SamplingIsOk = "True";
                          } else {
                            SamplingIsOk = "N/A";
                          }

                          // for all fields, if null, set to N/A
                          if (data_sample_anomaly_reason == "null") {
                            data_sample_anomaly_reason = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>SamplingIsOk:</strong> " +
                            SamplingIsOk +
                            "</li>";
                          contents +=
                            "<li><strong>Sampling Anomaly Reason:</strong> " +
                            data_sample_anomaly_reason +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "dsm",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "data_index", dir: "asc" },
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=dsm&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "index",
                                  field: "data_index",
                                  visible: false,
                                },
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Current statistics and main indexing information",
                              columns: [
                                {
                                  title: "lag (delay / latency)",
                                  field: "lag_summary",
                                  width: 160,
                                },
                                {
                                  title: "Latest event",
                                  field: "last_time",
                                  width: 140,
                                },
                                {
                                  title: "Latest ingest",
                                  field: "last_ingest",
                                  width: 140,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Thresholds and features status",
                              columns: [
                                {
                                  title: "Delay (sec)",
                                  field: "data_max_delay_allowed",
                                  width: 125,
                                },
                                {
                                  title: "Duration",
                                  field: "data_max_delay_allowed_duration",
                                  width: 110,
                                },
                                {
                                  title: "Latency (sec)",
                                  field: "data_max_lag_allowed",
                                  width: 125,
                                },
                                {
                                  title: "Duration",
                                  field: "data_max_lag_allowed_duration",
                                  width: 110,
                                },
                                {
                                  title: "Adaptive delay",
                                  field: "allow_adaptive_delay",
                                  width: 140,
                                  visible: getToken(
                                    "clickedTenantAdaptiveDelay"
                                  ),
                                },
                                {
                                  title: "Class override",
                                  field: "data_override_lagging_class",
                                  width: 140,
                                },
                                {
                                  title: "Alert over",
                                  field: "data_lag_alert_kpis",
                                  headerFilter: "input",
                                  width: 140,
                                },
                                {
                                  title: "Outliers",
                                  field: "OutliersIsOk",
                                  contextPopup: rowPopupFormatterOutliers, //add click popup to row
                                  hozAlign: "center",
                                  formatter: "tickCross",
                                  width: 100,
                                  visible: getToken("clickedTenantMlOutliers"),
                                },
                                {
                                  title: "Sampling",
                                  field: "SamplingIsOk",
                                  contextPopup: rowPopupFormatterSampling, //add click popup to row
                                  hozAlign: "center",
                                  formatter: "tickCross",
                                  width: 100,
                                  visible: getToken("clickedTenantSampling"),
                                },
                              ],
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkDsmCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-dsm-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkDsmCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-dsm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-dsm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-dsm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-dsm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-dsm-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-dsm-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-dsm-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-dsm-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by priority" button
                        document
                          .getElementById(
                            "splk-dsm-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by index" button
                        document
                          .getElementById("splk-dsm-table-update-groupby-index")
                          .addEventListener("click", function () {
                            table.setGroupBy([["data_index"]]);
                          });

                        // Event listener for "Group by sourcetype" button
                        document
                          .getElementById(
                            "splk-dsm-table-update-groupby-sourcetype"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["data_sourcetype"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-dsm-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-dsm-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-dsm-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=dsm"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#dsm_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#DsmOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkDsmMain.startSearch();

                        // load Tabulator
                        splkDsmHandlerTable(clickedTenantId);

                        // open modal id model_dsm_overview
                        $("#model_dsm_overview").modal("show");
                      });

                      // back
                      $("#DsmOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-dsm").append(
                        '<span id="badge-dsm-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdDsmEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-dsm-entities").on("mouseover", function () {
                        if (clickedTenantIdDsmEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "dsm",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdDsmEntitiesStatusGreen > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdDsmEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "dsm",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesStatusRed > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdDsmEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "dsm",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesStatusOthers > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdDsmEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "dsm",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesPriorityLow > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdDsmEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "dsm",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesPriorityMedium > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdDsmEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "dsm",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesPriorityHigh > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdDsmEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "dsm",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesPriorityCritical > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdDsmEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "dsm",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesRedPriorityLow > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdDsmEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "dsm",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesRedPriorityMedium > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdDsmEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "dsm",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesRedPriorityHigh > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdDsmEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "dsm",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDsmEntitiesRedPriorityCritical > 0) {
                        $("#badges-dsm").append(
                          '<span id="badge-dsm-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdDsmEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-dsm-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "dsm",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-dsm").append("</div>");
                }

                // CIM overview if enabled
                if (clickedTenantCimEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewCim.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Common Information Model Tracking (SPLK-CIM) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-cim-container" style="height: 40px;"><div id="badges-cim" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-cim").append(
                    '<div id="badges-cim-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdCimEntities = defaultTokenModel.get(
                      "clickedTenantIdCimEntities"
                    );
                    var clickedTenantIdCimEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesStatusGreen"
                      );
                    var clickedTenantIdCimEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesStatusRed"
                      );
                    var clickedTenantIdCimEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesStatusOthers"
                      );
                    var clickedTenantIdCimEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesPriorityLow"
                      );
                    var clickedTenantIdCimEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesPriorityMedium"
                      );
                    var clickedTenantIdCimEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesPriorityHigh"
                      );
                    var clickedTenantIdCimEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesPriorityCritical"
                      );
                    var clickedTenantIdCimEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdCimEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdCimEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdCimEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdCimEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdCimEntities !== "undefined") {
                      // remove loader
                      $("#badges-cim-loader").remove();
                      //
                      // Update DOM
                      //

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-cim").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="cim_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#cim_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-cim tabulator
                      function splkCimHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#cimOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantCimTabulatorGroupBy"
                        );

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";
                          if (modeView === "minimal") {
                            return "right click for popup";
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              2
                            ); //return JSON formatted cell
                          }
                        }

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>DataModel details:</h3>";
                          contents +=
                            "<li><strong>Account:</strong> " +
                            data.account +
                            "</li>";
                          contents +=
                            "<li><strong>Datamodel name:</strong> " +
                            data.cim_datamodel_name +
                            "</li>";
                          contents +=
                            "<li><strong>Datamodel node:</strong> " +
                            data.cim_datamodel_nodename +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>CIM fields in alert:</strong> " +
                            data.cim_fields_red +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<li><strong>Latest flip time:</strong> " +
                            data.latest_flip_time +
                            "</li>";
                          contents +=
                            "<li><strong>Latest flip state:</strong> " +
                            data.latest_flip_state +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Tracker Key Information:</h3>";
                          contents +=
                            "<li><strong>Tracker name:</strong> " +
                            data.tracker_name +
                            "</li>";
                          contents +=
                            "<li><strong>Tracker runtime:</strong> " +
                            data.tracker_runtime +
                            "</li>";
                          contents +=
                            "<li><strong>Tracker last duration:</strong> " +
                            data.tracker_last_duration +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterRulesDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.cim_tracking_rules);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
                            border-radius: 8px;
                            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                          ">
                            <div class="status-popup-title" style="
                              padding: 12px 16px;
                              background: #111;
                              font-size: 1.2em;
                              font-weight: bold;
                              border-bottom: 1px solid #333;
                              border-radius: 8px 8px 0 0;
                              color: #1e90ff;
                            ">
                              Rules Details
                            </div>
                            <div style="
                              overflow: auto;
                              max-height: 440px;
                              padding: 16px;
                              word-break: break-word;
                              white-space: pre-wrap;
                            ">
                              <code class="language-json" style="
                                display: block;
                                white-space: pre-wrap;
                                word-break: break-word;
                              ">${Prism.highlight(
                                prettyJson,
                                Prism.languages.json,
                                "json"
                              )}</code>
                            </div>
                          </div>
                        `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterResultsDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.cim_tracking_results);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Rules Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "cim",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=cim&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  minWidth: 350,
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  editor: true,
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: getToken(
                                    "show_state_icons_bootstrap"
                                  ),
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: getToken("show_state_icons_emoji"),
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  editor: "list",
                                  editorParams: {
                                    values: [
                                      "low",
                                      "medium",
                                      "high",
                                      "critical",
                                    ],
                                  },
                                  headerFilter: "input",
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Tracking rules and results",
                              columns: [
                                {
                                  title: "Rules",
                                  field: "cim_tracking_rules",
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterRulesDetails,
                                  minWidth: 350,
                                  variableHeight: true,
                                  editor: false,
                                  headerFilter: false,
                                },
                                {
                                  title: "Results",
                                  field: "cim_tracking_results",
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterResultsDetails,
                                  minWidth: 350,
                                  variableHeight: true,
                                  editor: false,
                                  headerFilter: false,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Tracker information",
                              columns: [
                                {
                                  title: "Run time",
                                  field: "tracker_runtime (translated)",
                                  width: 160,
                                  editor: false,
                                  headerFilter: false,
                                },
                                {
                                  title: "Last duration",
                                  field: "tracker_last_duration",
                                  width: 140,
                                  editor: false,
                                  headerFilter: false,
                                },
                              ],
                            },
                            {
                              title: "Outliers",
                              field: "OutliersIsOk",
                              contextPopup: rowPopupFormatterOutliers, //add click popup to row
                              hozAlign: "center",
                              formatter: "tickCross",
                              width: 100,
                              visible: getToken("clickedTenantMlOutliers"),
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkCimCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-cim-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkCimCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-cim-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-cim-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-cim-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-cim-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-cim-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-cim-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by datamodel" button
                        document
                          .getElementById(
                            "splk-cim-table-update-groupby-datamodel"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["cim_datamodel_name"]]);
                          });

                        // Event listener for "Group by cimfields" button
                        document
                          .getElementById(
                            "splk-cim-table-update-groupby-cimfields"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["cim_fields"]]);
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-cim-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-cim-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by priority" button
                        document
                          .getElementById(
                            "splk-cim-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-cim-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-cim-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-cim-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=cim"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#cim_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#CimOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkCimMain.startSearch();

                        // load Tabulator
                        splkCimHandlerTable(clickedTenantId);

                        // open modal id model_cim_overview
                        $("#model_cim_overview").modal("show");
                      });

                      // back
                      $("#CimOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-cim").append(
                        '<span id="badge-cim-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdCimEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-cim-entities").on("mouseover", function () {
                        if (clickedTenantIdCimEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "cim",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdCimEntitiesStatusGreen > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdCimEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "cim",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesStatusRed > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdCimEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "cim",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesStatusOthers > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdCimEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "cim",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesPriorityLow > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdCimEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "cim",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesPriorityMedium > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdCimEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "cim",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesPriorityHigh > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdCimEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "cim",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesPriorityCritical > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdCimEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "cim",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesRedPriorityLow > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdCimEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "cim",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesRedPriorityMedium > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdCimEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "cim",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesRedPriorityHigh > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdCimEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "cim",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdCimEntitiesRedPriorityCritical > 0) {
                        $("#badges-cim").append(
                          '<span id="badge-cim-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdCimEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-cim-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "cim",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-cim").append("</div>");
                }

                // FLX overview if enabled
                if (clickedTenantFlxEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewFlx.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Flex Objects Tracking (SPLK-FLX) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-flx-container" style="height: 40px;"><div id="badges-flx" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-flx").append(
                    '<div id="badges-flx-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdFlxEntities = defaultTokenModel.get(
                      "clickedTenantIdFlxEntities"
                    );
                    var clickedTenantIdFlxEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesStatusGreen"
                      );
                    var clickedTenantIdFlxEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesStatusRed"
                      );
                    var clickedTenantIdFlxEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesStatusOthers"
                      );
                    var clickedTenantIdFlxEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesPriorityLow"
                      );
                    var clickedTenantIdFlxEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesPriorityMedium"
                      );
                    var clickedTenantIdFlxEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesPriorityHigh"
                      );
                    var clickedTenantIdFlxEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesPriorityCritical"
                      );
                    var clickedTenantIdFlxEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdFlxEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdFlxEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdFlxEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdFlxEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdFlxEntities !== "undefined") {
                      // remove loader
                      $("#badges-flx-loader").remove();
                      //
                      // Update DOM
                      //

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-flx").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="flx_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#flx_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-flx tabulator
                      function splkFlxHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#flxOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantFlxTabulatorGroupBy"
                        );

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";
                          if (modeView === "minimal") {
                            return "right click for popup";
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              1
                            ).replace(/\\/g, ""); //return JSON formatted cell
                          }
                        }

                        // popup formatter
                        var rowPopupFormatterMetricsDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.metrics);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Metrics Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Object description:</strong> " +
                            data.object_description +
                            "</li>";
                          contents +=
                            "<li><strong>Status:</strong> " +
                            data.status +
                            "</li>";
                          contents +=
                            "<li><strong>Status description:</strong> " +
                            data.status_description +
                            "</li>";
                          contents +=
                            "<li><strong>AnomalyReason:</strong> " +
                            data.anomaly_reason +
                            "</li>";
                          contents +=
                            "<li><strong>Outliers anomaly detection state:</strong> " +
                            data.OutliersStatus +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring days:</strong> " +
                            data.isUnderMonitoringDays +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring hours:</strong> " +
                            data.isUnderMonitoringHours +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter (status)
                        var rowPopupFormatterStatusDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.status_message_json);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Status Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "flx",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=flx&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "group",
                                  field: "group",
                                  visible: false,
                                },
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  minWidth: 350,
                                  editor: true,
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  editor: "list",
                                  editorParams: {
                                    values: [
                                      "low",
                                      "medium",
                                      "high",
                                      "critical",
                                    ],
                                  },
                                  headerFilter: "input",
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Status and description",
                              columns: [
                                {
                                  title: "Status",
                                  field: "status",
                                  width: 100,
                                  editor: false,
                                  headerFilter: true,
                                },
                                {
                                  title: "Status description",
                                  field: "status_description_short",
                                  contextPopup: rowPopupFormatterStatusDetails, //add click popup to row
                                  minWidth: 350,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Metrics",
                              columns: [
                                {
                                  title: "Last metrics",
                                  field: "metrics",
                                  width: 200,
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterMetricsDetails,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Tracking information",
                              columns: [
                                {
                                  title: "Tracker runtime",
                                  field: "tracker_runtime (translated)",
                                  width: 150,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              title: "Outliers",
                              field: "OutliersIsOk",
                              contextPopup: rowPopupFormatterOutliers, //add click popup to row
                              hozAlign: "center",
                              formatter: "tickCross",
                              width: 100,
                              visible: getToken("clickedTenantMlOutliers"),
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkFlxCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-flx-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkFlxCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-flx-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-flx-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-flx-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-flx-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-flx-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-flx-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-flx-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-flx-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by priority" button
                        document
                          .getElementById(
                            "splk-flx-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-flx-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-flx-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-flx-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=flx"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#flx_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#FlxOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkFlxMain.startSearch();

                        // load Tabulator
                        splkFlxHandlerTable(clickedTenantId);

                        // open modal id model_flx_overview
                        $("#model_flx_overview").modal("show");
                      });

                      // back
                      $("#FlxOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-flx").append(
                        '<span id="badge-flx-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdFlxEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-flx-entities").on("mouseover", function () {
                        if (clickedTenantIdFlxEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "flx",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdFlxEntitiesStatusGreen > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdFlxEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "flx",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesStatusRed > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdFlxEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "flx",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesStatusOthers > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdFlxEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "flx",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesPriorityLow > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdFlxEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "flx",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesPriorityMedium > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdFlxEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "flx",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesPriorityHigh > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdFlxEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "flx",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesPriorityCritical > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdFlxEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "flx",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesRedPriorityLow > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdFlxEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "flx",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesRedPriorityMedium > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdFlxEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "flx",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesRedPriorityHigh > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdFlxEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "flx",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFlxEntitiesRedPriorityCritical > 0) {
                        $("#badges-flx").append(
                          '<span id="badge-flx-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdFlxEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-flx-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "flx",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-flx").append("</div>");
                }

                // FQM overview if enabled
                if (clickedTenantFqmEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewFqm.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Fields Quality Monitoring (SPLK-FQM) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-fqm-container" style="height: 40px;"><div id="badges-fqm" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-fqm").append(
                    '<div id="badges-fqm-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdFqmEntities = defaultTokenModel.get(
                      "clickedTenantIdFqmEntities"
                    );
                    var clickedTenantIdFqmEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesStatusGreen"
                      );
                    var clickedTenantIdFqmEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesStatusRed"
                      );
                    var clickedTenantIdFqmEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesStatusOthers"
                      );
                    var clickedTenantIdFqmEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesPriorityLow"
                      );
                    var clickedTenantIdFqmEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesPriorityMedium"
                      );
                    var clickedTenantIdFqmEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesPriorityHigh"
                      );
                    var clickedTenantIdFqmEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesPriorityCritical"
                      );
                    var clickedTenantIdFqmEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdFqmEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdFqmEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdFqmEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdFqmEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdFqmEntities !== "undefined") {
                      // remove loader
                      $("#badges-fqm-loader").remove();
                      //
                      // Update DOM
                      //

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-fqm").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="fqm_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#fqm_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-fqm tabulator
                      function splkFqmHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#fqmOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantFqmTabulatorGroupBy"
                        );

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";
                          if (modeView === "minimal") {
                            return "right click for popup";
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              1
                            ).replace(/\\/g, ""); //return JSON formatted cell
                          }
                        }

                        // popup formatter
                        var rowPopupFormatterMetricsDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.metrics);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Metrics Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Object description:</strong> " +
                            data.object_description +
                            "</li>";
                          contents +=
                            "<li><strong>Status:</strong> " +
                            data.status +
                            "</li>";
                          contents +=
                            "<li><strong>Status description:</strong> " +
                            data.status_description +
                            "</li>";
                          contents +=
                            "<li><strong>AnomalyReason:</strong> " +
                            data.anomaly_reason +
                            "</li>";
                          contents +=
                            "<li><strong>Outliers anomaly detection state:</strong> " +
                            data.OutliersStatus +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring days:</strong> " +
                            data.isUnderMonitoringDays +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring hours:</strong> " +
                            data.isUnderMonitoringHours +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter (status)
                        var rowPopupFormatterStatusDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.status_message_json);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Status Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "fqm",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=fqm&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "group",
                                  field: "group",
                                  visible: false,
                                },
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  minWidth: 350,
                                  editor: true,
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  editor: "list",
                                  editorParams: {
                                    values: [
                                      "low",
                                      "medium",
                                      "high",
                                      "critical",
                                    ],
                                  },
                                  headerFilter: "input",
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Status and description",
                              columns: [
                                {
                                  title: "Status",
                                  field: "status",
                                  width: 100,
                                  editor: false,
                                  headerFilter: true,
                                },
                                {
                                  title: "Status description",
                                  field: "status_description_short",
                                  contextPopup: rowPopupFormatterStatusDetails, //add click popup to row
                                  minWidth: 350,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Metrics",
                              columns: [
                                {
                                  title: "Last metrics",
                                  field: "metrics",
                                  width: 200,
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterMetricsDetails,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Tracking information",
                              columns: [
                                {
                                  title: "Tracker runtime",
                                  field: "tracker_runtime (translated)",
                                  width: 150,
                                  editor: false,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              title: "Outliers",
                              field: "OutliersIsOk",
                              contextPopup: rowPopupFormatterOutliers, //add click popup to row
                              hozAlign: "center",
                              formatter: "tickCross",
                              width: 100,
                              visible: getToken("clickedTenantMlOutliers"),
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkFqmCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-fqm-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkFqmCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-fqm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-fqm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-fqm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-fqm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-fqm-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-fqm-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-fqm-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-fqm-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by priority" button
                        document
                          .getElementById(
                            "splk-fqm-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-fqm-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-fqm-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-fqm-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=fqm"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#fqm_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#FqmOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkFqmMain.startSearch();

                        // load Tabulator
                        splkFqmHandlerTable(clickedTenantId);

                        // open modal id model_fqm_overview
                        $("#model_fqm_overview").modal("show");
                      });

                      // back
                      $("#FqmOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-fqm").append(
                        '<span id="badge-fqm-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdFqmEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-fqm-entities").on("mouseover", function () {
                        if (clickedTenantIdFqmEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "fqm",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdFqmEntitiesStatusGreen > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdFqmEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "fqm",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesStatusRed > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdFqmEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "fqm",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesStatusOthers > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdFqmEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "fqm",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesPriorityLow > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdFqmEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "fqm",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesPriorityMedium > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdFqmEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "fqm",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesPriorityHigh > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdFqmEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "fqm",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesPriorityCritical > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdFqmEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "fqm",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesRedPriorityLow > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdFqmEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "fqm",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesRedPriorityMedium > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdFqmEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "fqm",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesRedPriorityHigh > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdFqmEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "fqm",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdFqmEntitiesRedPriorityCritical > 0) {
                        $("#badges-fqm").append(
                          '<span id="badge-fqm-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdFqmEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-fqm-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "fqm",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-fqm").append("</div>");
                }

                // WLK overview if enabled
                if (clickedTenantWlkEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewWlk.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Splunk Workload (SPLK-WLK) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-wlk-container" style="height: 40px;"><div id="badges-wlk" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-wlk").append(
                    '<div id="badges-wlk-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdWlkEntities = defaultTokenModel.get(
                      "clickedTenantIdWlkEntities"
                    );
                    var clickedTenantIdWlkEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesStatusGreen"
                      );
                    var clickedTenantIdWlkEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesStatusRed"
                      );
                    var clickedTenantIdWlkEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesStatusOthers"
                      );
                    var clickedTenantIdWlkEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesPriorityLow"
                      );
                    var clickedTenantIdWlkEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesPriorityMedium"
                      );
                    var clickedTenantIdWlkEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesPriorityHigh"
                      );
                    var clickedTenantIdWlkEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesPriorityCritical"
                      );
                    var clickedTenantIdWlkEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdWlkEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdWlkEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdWlkEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdWlkEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdWlkEntities !== "undefined") {
                      // remove loader
                      $("#badges-wlk-loader").remove();
                      //
                      // Update DOM
                      //

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-wlk").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="wlk_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#wlk_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-wlk tabulator
                      function splkWlkHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#wlkOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantWlkTabulatorGroupBy"
                        );

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Search Information:</h3>";
                          contents +=
                            "<li><strong>Application namespace:</strong> " +
                            data.app +
                            "</li>";
                          contents +=
                            "<li><strong>Owner user:</strong> " +
                            data.user +
                            "</li>";
                          contents +=
                            "<li><strong>Account:</strong> " +
                            data.account +
                            "</li>";
                          contents +=
                            "<li><strong>Last execution seen:</strong> " +
                            epochToHumanReadable(data.last_seen) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Object description:</strong> " +
                            data.object_description +
                            "</li>";
                          contents +=
                            "<li><strong>Status:</strong> " +
                            data.status +
                            "</li>";
                          contents +=
                            "<li><strong>Anomaly reason:</strong> " +
                            data.anomaly_reason +
                            "</li>";
                          contents +=
                            "<li><strong>Status description:</strong> " +
                            data.status_description +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterMetricsDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.metrics);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Metrics Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";
                          if (modeView === "minimal") {
                            return "right click for popup";
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              1
                            ).replace(/\\/g, ""); //return JSON formatted cell
                          }
                        }

                        function AnomalyReasonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var cellValue = cell.getValue();
                          // if cellaValue is a pipe separated string, turn it into a list and pretty print it
                          if (cellValue.includes("|")) {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            cellValue = JSON.stringify(
                              cellValue.split("|"),
                              null,
                              1
                            );
                          }
                          return cellValue;
                        }

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "wlk",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=wlk&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  minWidth: 300,
                                  maxWidth: 600,
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                                ,
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Status",
                              columns: [
                                {
                                  title: "Status",
                                  field: "status",
                                  width: 80,
                                  headerFilter: true,
                                },
                                {
                                  title: "Anomaly reason",
                                  field: "anomaly_reason",
                                  width: 210,
                                  formatter: AnomalyReasonFormatter,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Metrics",
                              columns: [
                                {
                                  title: "Metrics summary (24h)",
                                  field: "metrics",
                                  width: 200,
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterMetricsDetails,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Time information",
                              columns: [
                                {
                                  title: "Last time seen",
                                  field: "last_seen_human",
                                  width: 150,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              title: "Outliers",
                              field: "OutliersIsOk",
                              contextPopup: rowPopupFormatterOutliers, //add click popup to row
                              hozAlign: "center",
                              formatter: "tickCross",
                              width: 100,
                              visible: getToken("clickedTenantMlOutliers"),
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkWlkCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-wlk-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkWlkCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-wlk-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-wlk-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-wlk-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-wlk-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-wlk-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-wlk-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by app" button
                        document
                          .getElementById("splk-wlk-table-update-groupby-app")
                          .addEventListener("click", function () {
                            table.setGroupBy([["app"]]);
                          });

                        // Event listener for "Group by user" button
                        document
                          .getElementById("splk-wlk-table-update-groupby-user")
                          .addEventListener("click", function () {
                            table.setGroupBy([["user"]]);
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-wlk-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-wlk-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by priority" button
                        document
                          .getElementById(
                            "splk-wlk-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-wlk-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-wlk-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-wlk-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=wlk"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#wlk_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#WlkOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkWlkMain.startSearch();

                        // load Tabulator
                        splkWlkHandlerTable(clickedTenantId);

                        // open modal id model_wlk_overview
                        $("#model_wlk_overview").modal("show");
                      });

                      // back
                      $("#WlkOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-wlk").append(
                        '<span id="badge-wlk-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdWlkEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-wlk-entities").on("mouseover", function () {
                        if (clickedTenantIdWlkEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary_wlk(
                            "'status': 'any', 'priority': 'any'",
                            "wlk",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdWlkEntitiesStatusGreen > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdWlkEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'green', 'priority': 'any'",
                            "wlk",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesStatusRed > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdWlkEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'red', 'priority': 'any'",
                            "wlk",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesStatusOthers > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdWlkEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'other', 'priority': 'any'",
                            "wlk",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesPriorityLow > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdWlkEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'any', 'priority': 'low'",
                            "wlk",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesPriorityMedium > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdWlkEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'any', 'priority': 'medium'",
                            "wlk",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesPriorityHigh > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdWlkEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'any', 'priority': 'high'",
                            "wlk",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesPriorityCritical > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdWlkEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "wlk",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesRedPriorityLow > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdWlkEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "'status': 'red', 'priority': 'low'",
                            "wlk",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesRedPriorityMedium > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdWlkEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "status: red, priority: medium",
                            "wlk",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesRedPriorityHigh > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdWlkEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "status: red, priority: high",
                            "wlk",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdWlkEntitiesRedPriorityCritical > 0) {
                        $("#badges-wlk").append(
                          '<span id="badge-wlk-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdWlkEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-wlk-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary_wlk(
                            "status: red, priority: critical",
                            "wlk",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-wlk").append("</div>");
                }

                // DHM overview if enabled
                if (clickedTenantDhmEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewDhm.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Event Endpoint Monitoring (SPLK-DHM) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-dhm-container" style="height: 40px;"><div id="badges-dhm" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-dhm").append(
                    '<div id="badges-dhm-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdDhmEntities = defaultTokenModel.get(
                      "clickedTenantIdDhmEntities"
                    );
                    var clickedTenantIdDhmEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesStatusGreen"
                      );
                    var clickedTenantIdDhmEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesStatusRed"
                      );
                    var clickedTenantIdDhmEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesStatusOthers"
                      );
                    var clickedTenantIdDhmEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesPriorityLow"
                      );
                    var clickedTenantIdDhmEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesPriorityMedium"
                      );
                    var clickedTenantIdDhmEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesPriorityHigh"
                      );
                    var clickedTenantIdDhmEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesPriorityCritical"
                      );
                    var clickedTenantIdDhmEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdDhmEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdDhmEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdDhmEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdDhmEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdDhmEntities !== "undefined") {
                      // remove loader
                      $("#badges-dhm-loader").remove();
                      // Update DOM

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-dhm").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="dhm_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#dhm_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-dhm tabulator
                      function splkDhmHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#dhmOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantDhmTabulatorGroupBy"
                        );

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";

                          if (modeView === "minimal") {
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              4
                            );
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              4
                            );
                          }
                        }

                        // popup formatter
                        var rowPopupFormatterSourcetypesDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(
                            data.splk_dhm_st_summary_full
                          );
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Sourcetypes Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Sourcetype:</h3>";
                          contents +=
                            "<li><strong>Index(es):</strong> " +
                            data.data_index +
                            "</li>";
                          contents +=
                            "<li><strong>Sourcetype(s):</strong> " +
                            data.data_sourcetype +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>AnomalyReason:</strong> " +
                            data.anomaly_reason +
                            "</li>";
                          contents +=
                            "<li><strong>Outliers anomaly detection state:</strong> " +
                            data.OutliersStatus +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Delay & Latency:</h3>";
                          contents +=
                            "<li><strong>Lagging summary:</strong> " +
                            data.lag_summary +
                            "</li>";
                          contents +=
                            "<li><strong>Last ingest:</strong> " +
                            data.last_ingest +
                            "</li>";
                          contents +=
                            "<li><strong>Last event:</strong> " +
                            data.last_time +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Thresholds & Configuration</h3>";
                          contents +=
                            "<li><strong>Max latency allowed:</strong> " +
                            data.data_max_lag_allowed +
                            " seconds</li>";
                          contents +=
                            "<li><strong>Max delay allowed:</strong> " +
                            data.data_max_delay_allowed +
                            " seconds</li>";
                          contents +=
                            "<li><strong>Currently under monitoring days:</strong> " +
                            data.isUnderMonitoringDays +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring hours:</strong> " +
                            data.isUnderMonitoringHours +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterOutliers = function (
                          e,
                          row,
                          onRendered
                        ) {
                          var data = row.getData();

                          // We have the following fields:
                          // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

                          var isOutlier = data.isOutlier;
                          var isOutlierReason = data.isOutlierReason;
                          var outliers_readiness = data.outliers_readiness;
                          var models_in_anomaly = data.models_in_anomaly;

                          // Turn isOutlier from 0 to False, 1 to True
                          if (isOutlier == "0") {
                            isOutlier = "False";
                          } else {
                            isOutlier = "True";
                          }

                          // for all fields, if null, set to N/A
                          if (isOutlierReason == "null") {
                            isOutlierReason = "N/A";
                          }

                          if (outliers_readiness == "null") {
                            outliers_readiness = "N/A";
                          }

                          if (models_in_anomaly == "null") {
                            models_in_anomaly = "N/A";
                          }

                          (container = document.createElement("div")),
                            // Add all fields to the popup
                            (contents =
                              "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
                          contents +=
                            "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<li><strong>isOutlier:</strong> " +
                            isOutlier +
                            "</li>";
                          contents +=
                            "<li><strong>Outlier Readiness:</strong> " +
                            outliers_readiness +
                            "</li>";
                          contents +=
                            "<li><strong>isOutlierReason:</strong> " +
                            isOutlierReason +
                            "</li>";
                          contents +=
                            "<li><strong>Models in Anomaly:</strong> " +
                            models_in_anomaly +
                            "</li>";
                          contents += "</ul></div>";
                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "dhm",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=dhm&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  minWidth: 400,
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  headerFilter: true,
                                },
                                {
                                  title: "Monitoring",
                                  field: "monitored_state",
                                  width: 110,
                                  headerFilter: true,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Indexes and sourcetypes",
                              columns: [
                                {
                                  title:
                                    "Summary (right click to show full details popup)",
                                  field: "sourcetype_summary",
                                  width: 200,
                                  formatter: jsonFormatter,
                                  contextPopup:
                                    rowPopupFormatterSourcetypesDetails,
                                  variableHeight: true,
                                  editor: false,
                                  headerFilter: false,
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Current statistics and main indexing information",
                              columns: [
                                {
                                  title: "lag (delay / latency)",
                                  field: "lag_summary",
                                  width: 160,
                                },
                                {
                                  title: "Latest event",
                                  field: "last_time",
                                  width: 140,
                                },
                                {
                                  title: "Latest ingest",
                                  field: "last_ingest",
                                  width: 140,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Thresholds and features status",
                              columns: [
                                {
                                  title: "Delay (sec)",
                                  field: "data_max_delay_allowed",
                                  width: 125,
                                },
                                {
                                  title: "Duration",
                                  field: "data_max_delay_allowed_duration",
                                  width: 110,
                                },
                                {
                                  title: "Latency (sec)",
                                  field: "data_max_lag_allowed",
                                  width: 125,
                                },
                                {
                                  title: "Duration",
                                  field: "data_max_lag_allowed_duration",
                                  width: 110,
                                },
                                {
                                  title: "Adaptive delay",
                                  field: "allow_adaptive_delay",
                                  width: 140,
                                  visible: getToken(
                                    "clickedTenantAdaptiveDelay"
                                  ),
                                },
                                {
                                  title: "Class override",
                                  field: "data_override_lagging_class",
                                  width: 140,
                                },
                                {
                                  title: "Alert over",
                                  field: "data_lag_alert_kpis",
                                  width: 140,
                                },
                                {
                                  title: "Alerting policy",
                                  field: "splk_dhm_alerting_policy",
                                  width: 140,
                                },
                                {
                                  title: "Outliers",
                                  field: "OutliersIsOk",
                                  contextPopup: rowPopupFormatterOutliers, //add click popup to row
                                  hozAlign: "center",
                                  formatter: "tickCross",
                                  width: 100,
                                  visible: getToken("clickedTenantMlOutliers"),
                                },
                              ],
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkDhmCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-dhm-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkDhmCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-dhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-dhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-dhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-dhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-dhm-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-dhm-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-dhm-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-dhm-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById(
                            "splk-dhm-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by index" button
                        document
                          .getElementById("splk-dhm-table-update-groupby-index")
                          .addEventListener("click", function () {
                            table.setGroupBy([["data_index"]]);
                          });

                        // Event listener for "Group by sourcetype" button
                        document
                          .getElementById(
                            "splk-dhm-table-update-groupby-sourcetype"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["data_sourcetype"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-dhm-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-dhm-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-dhm-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=dhm"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#dhm_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#DhmOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkDhmMain.startSearch();

                        // load Tabulator
                        splkDhmHandlerTable(clickedTenantId);

                        // open modal id model_dhm_overview
                        $("#model_dhm_overview").modal("show");
                      });

                      // back
                      $("#DhmOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-dhm").append(
                        '<span id="badge-dhm-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdDhmEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-dhm-entities").on("mouseover", function () {
                        if (clickedTenantIdDhmEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "dhm",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdDhmEntitiesStatusGreen > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdDhmEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "dhm",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesStatusRed > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdDhmEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "dhm",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesStatusOthers > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdDhmEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "dhm",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesPriorityLow > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdDhmEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "dhm",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesPriorityMedium > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdDhmEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "dhm",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesPriorityHigh > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdDhmEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "dhm",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesPriorityCritical > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdDhmEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "dhm",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesRedPriorityLow > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdDhmEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "dhm",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesRedPriorityMedium > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdDhmEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "dhm",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesRedPriorityHigh > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdDhmEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "dhm",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdDhmEntitiesRedPriorityCritical > 0) {
                        $("#badges-dhm").append(
                          '<span id="badge-dhm-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdDhmEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-dhm-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "dhm",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-dhm").append("</div>");
                }

                // DHM overview if enabled
                if (clickedTenantMhmEnabled == 1) {
                  // Allow the search to start
                  searchTenantOverviewMhm.startSearch();

                  $("#dynmodal").append(
                    '<fieldset style="margin-top: 60px;"><legend class="legends legends-large">SPLK Metric Endpoint Monitoring (SPLK-MHM) component overview</legend></fieldset>'
                  );

                  $("#dynmodal").append(
                    '<div id="badges-mhm-container" style="height: 40px;"><div id="badges-mhm" style="margin-top:14px; height: 40px;">'
                  );

                  // Add loader
                  $("#badges-mhm").append(
                    '<div id="badges-mhm-loader" class="lds-dual-ring"></div>'
                  );

                  // Wait for first variable from results and add info
                  function waitForElement() {
                    // get all tokens
                    var clickedTenantIdMhmEntities = defaultTokenModel.get(
                      "clickedTenantIdMhmEntities"
                    );
                    var clickedTenantIdMhmEntitiesStatusGreen =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesStatusGreen"
                      );
                    var clickedTenantIdMhmEntitiesStatusRed =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesStatusRed"
                      );
                    var clickedTenantIdMhmEntitiesStatusOthers =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesStatusOthers"
                      );
                    var clickedTenantIdMhmEntitiesPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesPriorityLow"
                      );
                    var clickedTenantIdMhmEntitiesPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesPriorityMedium"
                      );
                    var clickedTenantIdMhmEntitiesPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesPriorityHigh"
                      );
                    var clickedTenantIdMhmEntitiesPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesPriorityCritical"
                      );
                    var clickedTenantIdMhmEntitiesRedPriorityLow =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesRedPriorityLow"
                      );
                    var clickedTenantIdMhmEntitiesRedPriorityMedium =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesRedPriorityMedium"
                      );
                    var clickedTenantIdMhmEntitiesRedPriorityHigh =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesRedPriorityHigh"
                      );
                    var clickedTenantIdMhmEntitiesRedPriorityCritical =
                      defaultTokenModel.get(
                        "clickedTenantIdMhmEntitiesRedPriorityCritical"
                      );

                    // wait for first variable which indicates all results are available
                    if (typeof clickedTenantIdMhmEntities !== "undefined") {
                      // remove loader
                      $("#badges-mhm-loader").remove();
                      // Update DOM

                      //
                      // Tenants Overview Tabulator
                      //

                      // Add overview access
                      $("#badges-mhm").append(
                        '<div style="text-align: center; margin-bottom: 15px;">' +
                          '<button style="width: 20%; margin: 0 auto;" class="btn btn-outline-primary" id="mhm_overview_screen" type="button" data-dismiss="modal">' +
                          '<i class="bi bi-display text-primary"></i> Open Overview Tabulator' +
                          "</button>" +
                          "</div>"
                      );

                      // over
                      $("#mhm_overview_screen").on("mouseover", function () {
                        notify(
                          "info",
                          "bottom",
                          "ℹ️ Click to open the Entities Overview screen, this modal view provides readonly access to the tenants entities key information without leaving the Virtual Tenant UI.",
                          "10"
                        );
                      });

                      // splk-mhm tabulator
                      function splkMhmHandlerTable(tenant_id) {
                        // set the table div
                        var tabulatorElement = "#mhmOverviewTabulator";

                        // handle bootstrap vs emoji
                        var show_state_icons_emoji = false;
                        var show_state_icons_bootstrap = false;
                        if (icons_state_mode == "emoji") {
                          show_state_icons_emoji = true;
                        } else if (icons_state_mode == "bootstrap") {
                          show_state_icons_bootstrap = true;
                        }

                        //Generate open icon
                        var openIcon = function (cell, formatterParams) {
                          return "<i class='bi bi-box-arrow-up-right'></i>";
                        };

                        // get groupByContext
                        var groupByContext = getToken(
                          "clickedTenantMhmTabulatorGroupBy"
                        );

                        function jsonFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          // get mode
                          var modeView = "minimal";

                          if (modeView === "minimal") {
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              4
                            );
                          } else {
                            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                            return JSON.stringify(
                              JSON.parse(cell.getValue()),
                              null,
                              4
                            );
                          }
                        }

                        function csvFormatter(
                          cell,
                          formatterParams,
                          onRendered
                        ) {
                          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
                          obj = cell.getValue().toString().split(",");
                          return JSON.stringify(obj, null, 1); //return JSON formatted cell
                        }

                        // popup formatter
                        var rowPopupFormatter = function (e, row, onRendered) {
                          var data = row.getData(),
                            container = document.createElement("div"),
                            contents =
                              "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
                          contents +=
                            "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
                          contents +=
                            "<li><strong>Entity name:</strong> " +
                            decodeObject(data.object) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity alias:</strong> " +
                            decodeObject(data.alias) +
                            "</li>";
                          contents +=
                            "<li><strong>Entity keyid:</strong> " +
                            data.keyid +
                            "</li>";
                          contents +=
                            "<li><strong>Priority:</strong> " +
                            data.priority +
                            "</li>";
                          contents +=
                            "<li><strong>Date and time of last inspection:</strong> " +
                            epochToHumanReadable(data.tracker_runtime) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Metrics:</h3>";
                          contents +=
                            "<li><strong>Index(es):</strong> " +
                            JSON.stringify(
                              data.metric_index.toString().split(","),
                              null,
                              1
                            ) +
                            "</li>";
                          contents +=
                            "<li><strong>Metric categorie(s):</strong> " +
                            JSON.stringify(
                              data.metric_category.toString().split(","),
                              null,
                              1
                            ) +
                            "</li>";
                          contents +=
                            "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
                          contents +=
                            "<li><strong>State:</strong> " +
                            data.object_state +
                            "</li>";
                          contents +=
                            "<li><strong>Acknowledgement state:</strong> " +
                            data.ack_state +
                            "</li>";
                          contents +=
                            "<li><strong>Status message:</strong> " +
                            data.status_message +
                            "</li>";
                          contents +=
                            "<li><strong>Lagging summary:</strong> " +
                            data.lag_summary +
                            "</li>";
                          contents +=
                            "<li><strong>Last metric:</strong> " +
                            data.last_time +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring days:</strong> " +
                            data.isUnderMonitoringDays +
                            "</li>";
                          contents +=
                            "<li><strong>Currently under monitoring hours:</strong> " +
                            data.isUnderMonitoringHours +
                            "</li>";

                          contents += "</ul></div>";

                          container.innerHTML = contents;

                          return container;
                        };

                        // popup formatter
                        var rowPopupFormatterMetricsDetails = function (
                          e,
                          row,
                          onRendered
                        ) {
                          const data = row.getData();
                          const container = document.createElement("div");

                          // Safely unwrap deeply nested JSON
                          function safeParse(json) {
                            let current = json;
                            try {
                              while (typeof current === "string") {
                                current = JSON.parse(current);
                              }
                            } catch (err) {}
                            return current;
                          }

                          const parsed = safeParse(data.metric_details_full);
                          const prettyJson =
                            typeof parsed === "object"
                              ? JSON.stringify(parsed, null, 2)
                              : String(parsed);

                          const contents = `
                            <div class="trackme-popup-content" style="
                              font-family: Menlo, Consolas, 'Courier New', monospace;
                              font-size: 13px;
                              line-height: 1.4em;
                              color: #f8f8f2;
                              background-color: #1e1e1e;
                              max-height: 500px;
                              max-width: 800px;
                              min-width: 500px;
                              overflow: hidden;
                              padding: 0;
                              border-radius: 8px;
                              box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
                            ">
                              <div class="status-popup-title" style="
                                padding: 12px 16px;
                                background: #111;
                                font-size: 1.2em;
                                font-weight: bold;
                                border-bottom: 1px solid #333;
                                border-radius: 8px 8px 0 0;
                                color: #1e90ff;
                              ">
                                Metrics Details
                              </div>
                              <div style="
                                overflow: auto;
                                max-height: 440px;
                                padding: 16px;
                                word-break: break-word;
                                white-space: pre-wrap;
                              ">
                                <code class="language-json" style="
                                  display: block;
                                  white-space: pre-wrap;
                                  word-break: break-word;
                                ">${Prism.highlight(
                                  prettyJson,
                                  Prism.languages.json,
                                  "json"
                                )}</code>
                              </div>
                            </div>
                          `;

                          container.innerHTML = contents;
                          return container;
                        };

                        // Determine if context is an expression or a list of fields
                        var isExpression =
                          typeof groupByContext === "string" &&
                          groupByContext.includes("data.");

                        var table = new TabulatorFull(tabulatorElement, {
                          pagination: true, //enable pagination
                          paginationMode: "local", // pagination mode from parameters
                          //progressiveLoad:"load", //enable progressive loading
                          ajaxURL: getSplunkUrl(
                            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
                          ), //set url for ajax request
                          ajaxParams: {
                            tenant_id: tenant_id,
                            component: "mhm",
                            pagination_mode: "local",
                          },
                          initialFilter: [
                            {
                              field: "monitored_state",
                              type: "in",
                              value: ["enabled"],
                            },
                          ],
                          index: "keyid",
                          layout: "fitDataFill", //fit columns to width of table
                          addRowPos: "top", //when adding a new row, add it to the top of the table
                          history: true, //allow undo and redo actions on the table
                          paginationSize: 10000, //pagination size from parameters
                          paginationCounter: "rows", //display count of paginated rows in footer
                          movableColumns: true, //allow column order to be changed
                          resizableRows: true, //allow row order to be changed
                          height: "100%", // height
                          filterMode: "local", // remote filtering
                          groupBy: isExpression
                            ? function (data) {
                                return tabulatorGroupBy(groupByContext, data);
                              }
                            : convertCsvToArray(groupByContext),
                          initialSort: [
                            //set the initial sort order of the data
                            { column: "object", dir: "asc" },
                          ],

                          columns: [
                            {
                              //create column group
                              title: "Actions",
                              columns: [
                                // open
                                {
                                  formatter: openIcon,
                                  width: 80,
                                  hozAlign: "center",
                                  headerSort: false,
                                  cellClick: function (e, cell) {
                                    // Open this entity in Home UI
                                    url = encodeURI(
                                      "trackMe_home?tenant_id=" +
                                        clickedTenantId +
                                        "&component=mhm&object=" +
                                        cell.getRow().getData().object
                                    );
                                    window.open(url, "_blank");
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title:
                                "Identifier/state (click: rename/right click: info)",
                              columns: [
                                //define the table columns
                                {
                                  title: "object",
                                  field: "object",
                                  visible: false,
                                },
                                {
                                  title: "Entity",
                                  field: "alias",
                                  contextPopup: rowPopupFormatter, //add click popup to row
                                  minWidth: 350,
                                  editor: true,
                                  headerFilter: true,
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_bootstrap,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setBootstrapStatusIcons(status);
                                  },
                                },
                                {
                                  title: "",
                                  field: "state_icon_code",
                                  contextPopup: rowPopupFormatterAck, //add click popup to row
                                  visible: show_state_icons_emoji,
                                  hozAlign: "center",
                                  width: 60,
                                  formatter: function (cell, formatterParams) {
                                    var status = cell.getValue();
                                    return setEmojiStatusIcons(status);
                                  },
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Priority",
                              columns: [
                                {
                                  title: "Priority",
                                  field: "priority",
                                  width: 110,
                                  editor: "list",
                                  editorParams: {
                                    values: [
                                      "low",
                                      "medium",
                                      "high",
                                      "critical",
                                    ],
                                  },
                                  headerFilter: "input",
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Indexes and metric details",
                              columns: [
                                {
                                  title: "Index(es)",
                                  field: "metric_index",
                                  width: 160,
                                  formatter: csvFormatter,
                                  editor: false,
                                  headerFilter: false,
                                },
                                {
                                  title:
                                    "Summary (right click to show full details popup)",
                                  field: "metric_details",
                                  width: 350,
                                  formatter: jsonFormatter,
                                  contextPopup: rowPopupFormatterMetricsDetails,
                                  variableHeight: true,
                                  editor: false,
                                  headerFilter: false,
                                },
                              ],
                            },
                            {
                              //create column group
                              title: "Current stats and main indexing info",
                              columns: [
                                {
                                  title: "Metric lag",
                                  field: "lag_summary",
                                  width: 160,
                                  editor: false,
                                  headerFilter: false,
                                },
                                {
                                  title: "Metric latest",
                                  field: "last_time",
                                  width: 160,
                                  editor: false,
                                  headerFilter: false,
                                },
                              ],
                            },
                          ],
                        });

                        // donut drilldown
                        DonutSplkMhmCountByPriority.on("click", function (e) {
                          if (e.field !== undefined) {
                            e.preventDefault();
                            // update dropdown
                            $("#splk-mhm-table-filter-field").val("alias");
                            // set filters
                            table.setFilter([
                              {
                                field: "object_state",
                                type: "like",
                                value: "",
                              },
                              {
                                field: "priority",
                                type: "like",
                                value: e.data["row.priority"],
                              },
                              {
                                field: "monitored_state",
                                type: "=",
                                value: "enabled",
                              },
                            ]);
                            // notify
                            notify(
                              "success",
                              "bottom",
                              "Filtering on any state monitored entities with priority: " +
                                e.data["row.priority"],
                              "5"
                            );
                          }
                        });

                        // donut drilldown
                        DonutSplkMhmCountByStateAndPriority.on(
                          "click",
                          function (e) {
                            if (e.field !== undefined) {
                              e.preventDefault();

                              // set clicked_state
                              clicked_state = e.data["row.state"];

                              if (
                                clicked_state === "green" ||
                                clicked_state === "blue" ||
                                clicked_state === "orange" ||
                                clicked_state === "red"
                              ) {
                                // update dropdown
                                $("#splk-mhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: clicked_state,
                                  },
                                  {
                                    field: "priority",
                                    type: "like",
                                    value: "",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on any priority monitored entities with state: " +
                                    clicked_state,
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - other priority"
                              ) {
                                // update dropdown
                                $("#splk-mhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "in",
                                    value: ["low", "medium"],
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on low or medium priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - high priority"
                              ) {
                                // update dropdown
                                $("#splk-mhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "high",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on high priority monitored entities with state: red",
                                  "5"
                                );
                              } else if (
                                clicked_state === "red - critical priority"
                              ) {
                                // update dropdown
                                $("#splk-mhm-table-filter-field").val("alias");
                                // set filters
                                table.setFilter([
                                  {
                                    field: "object_state",
                                    type: "=",
                                    value: "red",
                                  },
                                  {
                                    field: "priority",
                                    type: "=",
                                    value: "critical",
                                  },
                                  {
                                    field: "monitored_state",
                                    type: "=",
                                    value: "enabled",
                                  },
                                ]);
                                // notify
                                notify(
                                  "success",
                                  "bottom",
                                  "Filtering on critical priority monitored entities with state: red",
                                  "5"
                                );
                              }
                            }
                          }
                        );

                        // Event listener for "Expand all" button
                        document
                          .getElementById("splk-mhm-table-expand-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(true);
                            table.replaceData();
                          });

                        // Event listener for "Collapse all" button
                        document
                          .getElementById("splk-mhm-table-collapse-all")
                          .addEventListener("click", function () {
                            table.setGroupStartOpen(false);
                            table.replaceData();
                          });

                        // Event listener for "Group by anomaly" button
                        document
                          .getElementById(
                            "splk-mhm-table-update-groupby-anomaly"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["anomaly_reason"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById("splk-mhm-table-update-groupby-state")
                          .addEventListener("click", function () {
                            table.setGroupBy([["object_state"]]);
                          });

                        // Event listener for "Group by state" button
                        document
                          .getElementById(
                            "splk-mhm-table-update-groupby-priority"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["priority"]]);
                          });

                        // Event listener for "Group by index" button
                        document
                          .getElementById("splk-mhm-table-update-groupby-index")
                          .addEventListener("click", function () {
                            table.setGroupBy([["metric_index"]]);
                          });

                        // Event listener for "Group by metric category" button
                        document
                          .getElementById(
                            "splk-mhm-table-update-groupby-metric-category"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy([["metric_category"]]);
                          });

                        // Event listener for "Group by tags" button
                        document
                          .getElementById("splk-mhm-table-update-groupby-tags")
                          .addEventListener("click", function () {
                            table.setGroupBy([["tags"]]);
                          });

                        // Event listener for "Group by default" button
                        document
                          .getElementById(
                            "splk-mhm-table-update-groupby-default"
                          )
                          .addEventListener("click", function () {
                            table.setGroupBy(
                              isExpression
                                ? function (data) {
                                    return tabulatorGroupBy(
                                      groupByContext,
                                      data
                                    );
                                  }
                                : convertCsvToArray(groupByContext)
                            );
                          });

                        // Event listener for "Search" button
                        document
                          .getElementById("splk-mhm-table-search")
                          .addEventListener("click", function () {
                            href_link =
                              "search?q=" +
                              encodeURIComponent(
                                "| trackmegetcoll tenant_id=" +
                                  getToken("clickedTenantId") +
                                  " component=mhm"
                              );
                            // open in a new Web browser tab this href
                            window.open(href_link, "_blank");
                          });

                        //
                        // end
                        //
                      }

                      $("#mhm_overview_screen").click(function () {
                        $(this).blur();

                        // define href
                        $("#MhmOverviewOpenTenant").attr(
                          "href",
                          encodeURI("trackMe_home?tenant_id=" + clickedTenantId)
                        );

                        // start search
                        searchSplkMhmMain.startSearch();

                        // load Tabulator
                        splkMhmHandlerTable(clickedTenantId);

                        // open modal id model_mhm_overview
                        $("#model_mhm_overview").modal("show");
                      });

                      // back
                      $("#MhmOverviewBack").click(function () {
                        $("#modal_tenant_overview").modal("show");
                      });

                      // badge
                      $("#badges-mhm").append(
                        '<span id="badge-mhm-entities" style="margin-right: 10px;" class="badge badge-purple">' +
                          clickedTenantIdMhmEntities +
                          " enabled entities</span>"
                      );
                      // over
                      $("#badge-mhm-entities").on("mouseover", function () {
                        if (clickedTenantIdMhmEntities == 0) {
                          notify(
                            "info",
                            "bottom",
                            "ℹ️ There are no entities yet for this tenant and component, if it was newly created you can run the trackers now to first populate the component",
                            "10"
                          );
                        } else {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'any'",
                            "mhm",
                            clickedTenantId,
                            "*",
                            "*"
                          );
                        }
                      });

                      // badge
                      if (clickedTenantIdMhmEntitiesStatusGreen > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-status-green" style="margin-right: 10px;" class="badge badge-green">' +
                            clickedTenantIdMhmEntitiesStatusGreen +
                            " status green</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-status-green").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'green', 'priority': 'any'",
                            "mhm",
                            clickedTenantId,
                            "green",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesStatusRed > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-status-red" style="margin-right: 10px;" class="badge badge-red">' +
                            clickedTenantIdMhmEntitiesStatusRed +
                            " status red</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-status-red").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'any'",
                            "mhm",
                            clickedTenantId,
                            "red",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesStatusOthers > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-status-other" style="margin-right: 10px;" class="badge badge-yellow">' +
                            clickedTenantIdMhmEntitiesStatusOthers +
                            " status other</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-status-other").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'other', 'priority': 'any'",
                            "mhm",
                            clickedTenantId,
                            "other",
                            "*"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesPriorityLow > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdMhmEntitiesPriorityLow +
                            " low priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'low'",
                            "mhm",
                            clickedTenantId,
                            "*",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesPriorityMedium > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdMhmEntitiesPriorityMedium +
                            " medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'medium'",
                            "mhm",
                            clickedTenantId,
                            "*",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesPriorityHigh > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdMhmEntitiesPriorityHigh +
                            " high priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'high'",
                            "mhm",
                            clickedTenantId,
                            "*",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesPriorityCritical > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-critical" style="margin-right: 10px;" class="badge badge-critical-priority">' +
                            clickedTenantIdMhmEntitiesPriorityCritical +
                            " critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'any', 'priority': 'critical'",
                            "mhm",
                            clickedTenantId,
                            "*",
                            "critical"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesRedPriorityLow > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-red-low" style="margin-right: 10px;" class="badge badge-low-priority">' +
                            clickedTenantIdMhmEntitiesRedPriorityLow +
                            " red low priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-red-low").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "'status': 'red', 'priority': 'low'",
                            "mhm",
                            clickedTenantId,
                            "red",
                            "low"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesRedPriorityMedium > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-red-medium" style="margin-right: 10px;" class="badge badge-medium-priority">' +
                            clickedTenantIdMhmEntitiesRedPriorityMedium +
                            " red medium priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-red-medium").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: medium",
                            "mhm",
                            clickedTenantId,
                            "red",
                            "medium"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesRedPriorityHigh > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-red-high" style="margin-right: 10px;" class="badge badge-high-priority">' +
                            clickedTenantIdMhmEntitiesRedPriorityHigh +
                            " red high priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-red-high").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: high",
                            "mhm",
                            clickedTenantId,
                            "red",
                            "high"
                          );
                        }
                      );

                      // badge
                      if (clickedTenantIdMhmEntitiesRedPriorityCritical > 0) {
                        $("#badges-mhm").append(
                          '<span id="badge-mhm-entities-priority-red-critical" style="margin-right: 10px;" class="badge badge-critical">' +
                            clickedTenantIdMhmEntitiesRedPriorityCritical +
                            " red critical priority</span>"
                        );
                      }
                      // over
                      $("#badge-mhm-entities-priority-red-critical").on(
                        "mouseover",
                        function () {
                          get_entities_summary(
                            "status: red, priority: critical",
                            "mhm",
                            clickedTenantId,
                            "red",
                            "critical"
                          );
                        }
                      );

                      //variable exists, do what you want
                    } else {
                      setTimeout(waitForElement, 250);
                    }
                  }

                  // call the function
                  waitForElement();

                  // close the div
                  $("#badges-mhm").append("</div>");
                }
              }

              // create element for tenant mgmt
              $("#dynmodal2").remove();
              $("#modal_tenant_mgmt_body").prepend(
                '<div id="dynmodal2"><h1>Management of the tenant: ' +
                  clickedTenantId +
                  "</h1>" +
                  "</div>"
              );

              // dynamically create the enable / disable button
              if (tenantStatus == "enabled") {
                $("#div_enable_tenant").hide();
                $("#div_disable_tenant").show();
              } else if (tenantStatus == "disabled") {
                $("#div_disable_tenant").hide();
                $("#div_enable_tenant").show();
              }

              // disable various privileged accesses if the connected user is not a TrackMe admin
              if (getToken("userLevel") != "admin") {
                $("#update_tenant").prop("disabled", false);
                $("#update_tenant").css("display", "none");

                $("#rbac_tenant").prop("disabled", false);
                $("#rbac_tenant").css("display", "none");

                $("#enable_tenant").prop("disabled", false);
                $("#enable_tenant").css("display", "none");

                $("#disable_tenant").prop("disabled", false);
                $("#disable_tenant").css("display", "none");

                $("#delete_tenant").prop("disabled", false);
                $("#delete_tenant").css("display", "none");

                $("#tenant_mgmt_child").html(
                  "<h2>As a TrackMe user, you can access to the Virtual Tenants, as well as accessing to the knowledge objects related to this Virtual Tenant:</h2><lu><li><b>Show knowledge objects:</b> review in read only all Splunk knowledge objecs composing the TrackMe tenant</li></lu>"
                );
              }

              // show overview modal
              $("#modal_tenant_overview").modal();

              return false;
            });
          }

          // Call now
          genTenantsElements(
            tenantsJson,
            userPrefs,
            userPositionPrefs,
            "true",
            "true"
          );

          // For refresh and dynamic changes purposes
          function getTenantsList(showMessage, removeSpinner) {
            // any existing, add a loader
            $(".flex-items").each(function () {
              $(this).html(
                '<div id="badges-tenant-count-loader" class="lds-dual-ring" style="margin-left: 47%; height: 156px; min-height: 156px; max-height: 156px;"></div>'
              );
            });

            var doAsync = asyncAjax(trackmeload_url, "POST", {
              mode: "full",
            }).then(function (resultCall) {
              // Tenants JSON
              var tenantsJson = resultCall["tenants_json"];

              // Position
              var userPositionPrefs = resultCall["position_prefs"];

              // theme preferences
              var show_tenants_mgmt_header =
                resultCall["show_tenants_mgmt_header"];
              var flex_width_default = resultCall["flex_width_default"];
              var flex_show_desc = resultCall["flex_show_desc"];
              var flex_show_summary = resultCall["flex_show_summary"];
              var colorTheme = resultCall["colorTheme"];
              var colorThemeStyleAlert = resultCall["colorThemeStyleAlert"];
              var dynTheme = resultCall["dynTheme"];
              var dynThemeCondition = resultCall["dynThemeCondition"];

              var userPrefs = {
                show_tenants_mgmt_header: show_tenants_mgmt_header,
                flex_width_default: flex_width_default,
                flex_show_desc: flex_show_desc,
                flex_show_summary: flex_show_summary,
                colorTheme: colorTheme,
                colorThemeStyleAlert: colorThemeStyleAlert,
                dynTheme: dynTheme,
                dynThemeCondition: dynThemeCondition,
              };

              var tenantsCountActive = resultCall["vtenants_count_active"];

              // set the div id badges-tenant-count-load to be not visible using display:none
              $("#badges-tenant-count-loader").css("visibility", "hidden");

              // set the div id content
              var content =
                '<h1 style="font-size: 60px; font-weight: bold; letter-spacing: normal; text-align: center;">' +
                tenantsCountActive +
                "</h1>" +
                '<div id="divSubTenantOpsCount" style="text-align: center; margin-top: 20px;">' +
                '<text class="under-label" style="letter-spacing: normal; font-size: 12px; font-weight: normal; fill: rgb(195, 203, 212); opacity: 1;">NUMBER OF ACTIVE TENANTS</text></div>';
              $("#badges-tenant-count").html(content);

              // Call now
              genTenantsElements(
                tenantsJson,
                userPrefs,
                userPositionPrefs,
                showMessage,
                "false"
              );
            });
          }

          //
          // Check licensing status
          //
          var doAsync = asyncAjax(
            getSplunkUrl(
              "/splunkd/__raw/services/trackme/v2/licensing/license_status"
            ),
            "GET"
          ).then(function (licenseCall) {
            var trackme_version = licenseCall["trackme_version"];
            var trackme_version_add_string = " - Version: " + trackme_version;
            var license_is_valid = licenseCall["license_is_valid"];
            var licenseSubscriptionClass =
              licenseCall["license_subscription_class"];
            var license_expiration = licenseCall["license_expiration"];
            var license_expiration_countdown_sec =
              licenseCall["license_expiration_countdown_sec"];
            var licenseLabel;
            if (license_is_valid == 1) {
              if (licenseCall["license_type"] === "subscription") {
                if (licenseSubscriptionClass === "unlimited") {
                  licenseLabel = "Unlimited";
                } else if (licenseSubscriptionClass === "enterprise") {
                  licenseLabel = "Enterprise";
                } else if (licenseSubscriptionClass === "free_extended") {
                  licenseLabel = "Free extended";
                }
                // Home info
                $("#licenseInfo").append(
                  '<a href="#">' +
                    licenseLabel +
                    " edition" +
                    trackme_version_add_string +
                    "</a>"
                );
                // Summary info
                $("#licenseInfoSummary").append(
                  '<div style="margin-top:14px; height: 40px;">' +
                    '<h2 style="color: dodgerblue;">License info: TrackMe is currently registered and operating in ' +
                    licenseLabel +
                    " edition:</h2>" +
                    "<h3>Expiration: " +
                    license_expiration +
                    "</h3>" +
                    "</div>"
                );
                // Countdown: if the license is valid, and the expiration is less than 15 days ahead, popup a message
                if (license_expiration_countdown_sec < 1296000) {
                  // popup a message
                  $("#modal_licensing_expiring_soon")
                    .find(".modal-info-message p")
                    .text(
                    "License info: TrackMe is currently registered and operating in " +
                    licenseLabel +
                    " edition:" +
                    ", expiration: " +
                    license_expiration
                    );
                  // open the modal id modal_licensing_expiring_soon
                  $("#modal_licensing_expiring_soon").modal();
                }
                //
              } else if (licenseCall["license_type"] === "trial") {
                // Home info
                $("#licenseInfo").append(
                  '<a href="#">Trial registered edition' +
                    trackme_version_add_string +
                    "</a>"
                );
                // Summary info
                $("#licenseInfoSummary").append(
                  '<div style="margin-top:14px; height: 40px;">' +
                    '<h2 style="color: dodgerblue;">License info: TrackMe is currently registered and operating in Trial edition:</h2>' +
                    "<h3>Expiration: " +
                    license_expiration +
                    "</h3>" +
                    "</div>"
                );
              } else if (licenseCall["license_type"] === "developer") {
                // Home info
                $("#licenseInfo").append(
                  '<a href="#">Developer mode' +
                    trackme_version_add_string +
                    "</a>"
                );
                // Summary info
                $("#licenseInfoSummary").append(
                  '<div style="margin-top:14px; height: 40px;">' +
                    '<h2 style="color: dodgerblue;">License info: TrackMe is currently registered and operating in Developer mode:</h2>' +
                    "<h3>Expiration: " +
                    license_expiration +
                    "</h3>" +
                    "<h3>You are free to use all features with no resttrictions for a personal usage only, using the developer mode in a Production environment is a breach to the EULA aggreement.</h3>" +
                    "</div>"
                );
              }
            } else {
              // Home info
              $("#licenseInfo").append(
                '<a href="#">Free limited edition' +
                  trackme_version_add_string +
                  "</a>"
              );
              // Summary info
              $("#licenseInfoSummary").append(
                '<div style="margin-top: 15px; margin-bottom: 15px; height: 40px;">' +
                  '<h2 style="color: dodgerblue;">License info: TrackMe is not currently registered and operating in Free limited edition.</h2>' +
                  "</div>"
              );
            }

            // get the number of active tenants
            var license_active_tenants = licenseCall["license_active_tenants"];

            //
            // Proceed
            //

            // syntax highlighting for JSON
            function syntaxHighlight(json) {
              json = json
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;");
              return json.replace(
                /("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,
                function (match) {
                  var cls = "json-preview-number";
                  if (/^"/.test(match)) {
                    if (/:$/.test(match)) {
                      cls = "json-preview-key";
                    } else {
                      cls = "json-preview-string";
                    }
                  } else if (/true|false/.test(match)) {
                    cls = "json-preview-boolean";
                  } else if (/null/.test(match)) {
                    cls = "json-preview-null";
                  }
                  return '<span class="' + cls + '">' + match + "</span>";
                }
              );
            }

            //
            // function to check the remote connectivity
            //

            // check the remote account connectivity
            function checkSplkFeedsRemoteAccount(component, account) {
              // Set the element ids
              if (component === "dsm") {
                parentDiv =
                  "divParentCreateDsmHybridValidateRemoteConnectivity";
                spinnerDiv =
                  "divCreateDsmHybridValidateRemoteConnectivityLoader";
                childDiv = "divCreateDsmHybridValidateRemoteConnectivity";
              } else if (component === "dhm") {
                parentDiv =
                  "divParentCreateDhmHybridValidateRemoteConnectivity";
                spinnerDiv =
                  "divCreateDhmHybridValidateRemoteConnectivityLoader";
                childDiv = "divCreateDhmHybridValidateRemoteConnectivity";
              } else if (component === "mhm") {
                parentDiv =
                  "divParentCreateMhmHybridValidateRemoteConnectivity";
                spinnerDiv =
                  "divCreateMhmHybridValidateRemoteConnectivityLoader";
                childDiv = "divCreateMhmHybridValidateRemoteConnectivity";
              } else if (component === "wlk") {
                parentDiv =
                  "divParentCreateWlkHybridValidateRemoteConnectivity";
                spinnerDiv =
                  "divCreateWlkHybridValidateRemoteConnectivityLoader";
                childDiv = "divCreateWlkHybridValidateRemoteConnectivity";
              }

              // notify
              notify(
                "info",
                "bottom",
                "Please wait while we verify the connectivity and authentication to the remote Splunk deployment, this can take a few minutes if the target cannot be reached, hold on...",
                "150"
              );
              // Show the parent
              $("#" + parentDiv).css("display", "inherit");
              // Show the spinner
              $("#" + spinnerDiv).css("display", "inherit");
              // hide the result viewer
              $("#" + childDiv).css("display", "none");

              // Create the endpoint URL
              var myendpoint_URl = getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/configuration/test_remote_account"
              );

              // Create a dictionary to store the field names and values
              var record = {
                account: account,
              };

              $.ajax({
                url: myendpoint_URl,
                type: "POST",
                async: true,
                contentType: "application/json",
                dataType: "json",
                data: JSON.stringify(record),
                success: function (returneddata) {
                  // hide
                  $("#" + spinnerDiv).css("display", "none");
                  // notify
                  notify(
                    "success",
                    "bottom",
                    "Successfully passed the connectivity check to the remote Splunk deployment.",
                    "5"
                  );
                  // show
                  // creation via template
                  $("#" + childDiv).html(
                    '<pre class="create-cim-json-rules-preview">' +
                      syntaxHighlight(JSON.stringify(returneddata, null, 2)) +
                      "</pre>"
                  );
                  $("#" + childDiv).css("display", "inherit");
                },
                error: function (xhr, textStatus, error) {
                  // hide
                  $("#" + spinnerDiv).css("display", "none");
                  // notify
                  notify(
                    "error",
                    "bottom",
                    "Failed to verify the connectivity to the Splunk remote deployment.",
                    "5"
                  );
                  // creation via template
                  $("#" + childDiv).html(
                    '<pre class="create-cim-json-rules-preview">' +
                      syntaxHighlight(JSON.stringify(xhr, null, 2)) +
                      "</pre>"
                  );
                  $("#" + childDiv).css("display", "inherit");
                },
              });
            }

            //
            // get default theme - This is used as a fallback if something goes wrong when refreshing the cards
            //

            // ajax promise for default UI theme settings
            async function doAjaxSetThemeDefault(ajaxurl) {
              var defaultSettings;

              try {
                defaultSettings = await $.ajax({
                  url: ajaxurl,
                  type: "GET",
                });
                // return defaultSettings
                return defaultSettings;
              } catch (error) {
                defaultSettings = {
                  show_tenants_mgmt_header: "1",
                  flex_width_default: "374",
                  flex_show_desc: "1",
                  flex_show_summary: "1",
                  colorTheme: "dodgerblue",
                  colorThemeStyleAlert: "red",
                  dynTheme: "true",
                  dynThemeCondition: "any",
                };
                return defaultSettings;
              }
            }

            doAjaxSetThemeDefault(
              getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/configuration/trackme_theme_settings"
              )
            ).then(function (defaultSettings) {
              show_tenants_mgmt_header =
                defaultSettings["show_tenants_mgmt_header"];
              setToken("show_tenants_mgmt_header", show_tenants_mgmt_header);
              flex_width_default = defaultSettings["flex_width_default"];
              setToken("flex_width_default", flex_width_default);
              flex_show_desc = defaultSettings["flex_show_desc"];
              setToken("flex_show_desc", flex_show_desc);
              flex_show_summary = defaultSettings["flex_show_summary"];
              setToken("flex_show_summary", flex_show_summary);
              colorTheme = defaultSettings["color_theme_default"];
              setToken("defaultColorTheme", colorTheme);
              colorThemeStyleAlert =
                defaultSettings["color_theme_alert_default"];
              setToken("defaultColorThemeAlert", colorThemeStyleAlert);
              dynTheme = defaultSettings["color_dyn_default"];
              if (dynTheme == "false") {
                dynTheme = "0";
              } else if (dynTheme == "true") {
                dynTheme = "1";
              }
              setToken("defaultDynTheme", dynTheme);
              dynThemeCondition = defaultSettings["color_dyn_condition"];
              setToken("defaultDynThemeCondition", dynThemeCondition);
            });

            //
            // Copy to clipboard
            //

            function copyToClipboard(content) {
              // Copy the text inside the text field
              navigator.clipboard.writeText(content);
              notify("success", "bottom", "Copy to clipboard done!", "5");
            }

            //
            // Handle search elements
            //

            $(".view-elements").hover(
              function () {
                var divid = "#" + this.id;
                var childdiv = "#resultsLink" + this.id;
                $(childdiv).attr("style", "display:block !important");
              },
              function () {
                var childdiv = "#resultsLink" + this.id;

                $(childdiv).hover(
                  function () {
                    $(childdiv).attr("style", "display:block !important");
                  },
                  function () {
                    $(childdiv).attr("style", "display:block !none");
                  }
                );

                $(childdiv).attr("style", "display:block !none");
              }
            );

            //
            // mouse over: various actions buttons
            //

            $("#btn_start_create_tenant").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the new Virtual Tenant creation wizard.",
                "5"
              );
            });

            $("#btn_start_create_tenant_replica").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to create a replica Virtual Tenants, this type of Tenants doesn't do active monitoring but can be used to provided selected ranges of mirrored entities from any Virtual Tenant.",
                "5"
              );
            });

            $("#btn_refresh_all").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to force refresh all Virtual Tenants information.",
                "5"
              );
            });

            $("#edit_preferences").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to edit your personal profile preferences, these preferences are stored in a profile linked to your owner user and does not apply to other TrackMe users.",
                "5"
              );
            });

            $("#edit_tenants_position").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to update the Virtual Tenants Flex Boses positions for your own personal profile, these preferences are stored in your personal profile and do not influence other TrackMe users.",
                "5"
              );
            });

            $("#save_tenants_position").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to save the current position of the Virtual Tenants Flex Boses into your own personal profile, these preferences are stored in your personal profile and do not influence other TrackMe users.",
                "5"
              );
            });

            $("#reset_tenants_position").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to reset your personal preferences for the UI and Virtual Tenants position to the system wide default, these preferences are stored in your personal profile and do not influence other TrackMe users.",
                "5"
              );
            });

            //
            // mouse over TrackMe logo
            //

            $("#trackmeLogo").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ © Copyright. 2022 - 2024. TrackMe Limited. All rights reserved. TRACKME® is a registered trade mark of TrackMe Limited, in both word and logo form. Any unauthorised use or reproduction of these marks is strictly prohibited and may result in legal action.",
                "5"
              );
            });

            //
            // mouse over licenseInfo
            //

            $("#divParentLicenseInfo").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click on the link to open Virtual Tenants schema update overview and quick shortcuts.",
                "5"
              );
            });

            //
            // mouse over donuts
            //

            $("#divVizSchedulerStatus").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click on the chart to open detailed information about the TrackMe scheduler health and statistics.",
                "5"
              );
            });

            $("#divVizOpsStatus").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click on the chart to open detailed information about the TrackMe tenants health and statistics.",
                "5"
              );
            });

            //
            // mouse over donuts for overview components
            //

            $(".overviewDonutPriority").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Filter against the priority - Click on donut chart zone to filter the Tabulator accordingly, you can also click on the legend to remove categories from the chart.",
                "5"
              );
            });

            $(".overviewDonutPriorityState").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Filter against priority and state - Click on donut chart zone to filter the Tabulator accordingly, you can also click on the legend to remove categories from the chart.",
                "5"
              );
            });

            $(".btnOpenTenant").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the Home UI view for the Virtual Tenant, where you can manage and investigate TrackMe entities and components.",
                "5"
              );
            });

            // mouse over scheduler overview

            $("#btn-scheduler-open-perfs").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the Performance DeepDive TrackMe dashboard, and investigate the performance of trackers over time.",
                "5"
              );
            });

            $("#btn-scheduler-open-logs").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open Splunk internal scheduler logs, and investigate scheduler skipping events.",
                "5"
              );
            });

            $("#scheduler-status-table-status-success").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only trackers with 100% completed execution ratio.",
                "5"
              );
            });

            $("#scheduler-status-table-status-failure").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only trackers with more than 0% skipped execution ratio.",
                "5"
              );
            });

            $("#scheduler-status-table-status-all").hover(function () {
              // show message
              notify("info", "bottom", "ℹ️ Click to show all trackers.", "5");
            });

            // mouse over Schema Version status

            $("#btn-schema-update-open-logs").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click open all Schema Upgrade logs in a new tab.",
                "5"
              );
            });

            $("#update-status-table-status-success").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only updated Virtual Tenants.",
                "5"
              );
            });

            $("#update-status-table-status-failure").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only Virtual Tenants with a pending status.",
                "5"
              );
            });

            $("#update-status-table-status-all").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show all Virtual Tenants.",
                "5"
              );
            });

            // mouse over tenants Ops status

            $("#btn-tenants-ops-clear-status").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to force clearing the currently known status of TrackMe trackers for all or selected tenants, once cleared, the knowledge will be rebuilt automatically as soon as TrackMe detected their execution.",
                "5"
              );
            });

            $("#btn-scheduler-open-logs").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open TrackMe health audit events, you can use these events to review and investigate the status of TrackMe trackers over time.",
                "5"
              );
            });

            $("#ops-status-table-status-success").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only trackers with a successful execution status.",
                "5"
              );
            });

            $("#ops-status-table-status-failure").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to show only trackers with a failing execution status.",
                "5"
              );
            });

            $("#ops-status-table-status-all").hover(function () {
              // show message
              notify("info", "bottom", "ℹ️ Click to show all trackers.", "5");
            });

            // mouse over tenant access

            $("#btn-tenant-access-open").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the TrackMe Home UI for this tenant, this is the main UI where you can review, ingestigate, configure and manage TrackMe entities of all kinds.",
                "5"
              );
            });

            $("#btn-tenant-access-sla").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the TrackMe SLA dashboard in a new tab, SLA metrics are generated by TrackMe and be used to review the level of the quality of the Splunk service, through the lens of TrackMe.",
                "5"
              );
            });

            $("#btn-tenant-access-manage").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to manage the Virtual Tenant in this UI, you can perform administrative operations such as disabling or deleting the tenant, modify RBAC and so forth.",
                "5"
              );
            });

            $("#btn-tenant-access-hide").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open hide / unhide this Virtual Tenants in your personal profile, the Virtual Tenant will be left untouched for others, but if you do not care about this tenant, it will not appear anymore for yourself.",
                "5"
              );
            });

            // mouse over tenant manage

            $("#btn-tenant-manage-kos").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to open the knowledge objects management screen, where you can easily view all knowledge objects related to this Virtual Tenant.",
                "5"
              );
            });

            $("#btn-tenant-manage-components").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to manage TrackMe components for this Virtual Tenant, you can choose to add or remove a given component for this specific tenant.",
                "5"
              );
            });

            $("#btn-tenant-manage-rbac").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to manage the RBAC configuration for this Virtual Tenant, TrackMe automatically define ownership and permissions for the tenant related objects according to this configuration.",
                "5"
              );
            });

            $("#div_disable_tenant").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to disable the Virtual Tenant, when a tenant is disabled, all related knowledge objects are disabled in Splunk, there will no more execution of its trackers but nothing will be deleted.",
                "5"
              );
            });

            $("#div_enable_tenant").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to enable a previously disabled Virtual Tenant, TrackMe will re-enable all related knowledge objects and trackers execution will be permitted again.",
                "5"
              );
            });

            $("#btn-tenant-manage-delete").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Click to permanently delete a Virtual Tenant, TrackMe will remove all related knowledge objects including the KVstore data, this action cannot be undone without performing a restoration.",
                "5"
              );
            });

            // mouse over close
            $(".btn-close").hover(function () {
              // hide message
              removeNotify();
            });

            // mouse over back
            $(".btn-back").hover(function () {
              // hide message
              removeNotify();
            });

            // mouse over next
            $(".btn-next").hover(function () {
              // hide message
              removeNotify();
            });

            // mouse over tenant creation wizard

            $(".btn-advanced").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Edit advanced options for this component.",
                "5"
              );
            });

            $(".btn-test").hover(function () {
              // show message
              notify("info", "bottom", "ℹ️ Test this configuration now.", "5");
            });

            $(".btn-validate").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Validate this configuration now.",
                "5"
              );
            });

            // mouse over Tabulator quick actions

            $(".btn-tabulator-overview-quickactions").hover(function () {
              // show message
              notify(
                "info",
                "bottom",
                "ℹ️ Quick actions handler for the Tabulator view, click to collapse, expand, handle entities grouping or access to realtime data in Search.",
                "5"
              );
            });

            //
            // FORMS
            //

            //
            // splk-wlk
            //

            // deployment selector for splk-dsm
            var inputSplkWlkEnvironmentType = new DropdownView(
              {
                id: "inputSplkWlkEnvironmentType",
                choices: [
                  {
                    label: "Splunk Enterprise",
                    value: "splunk_enterprise",
                  },
                  {
                    label: "Splunk Cloud",
                    value: "splunk_cloud",
                  },
                ],
                default: "splunk_enterprise",
                initialValue: "splunk_enterprise",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: false,
                value: "$tk_splk_wlk_env_type$",
                el: $("#inputSplkWlkEnvironmentType"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkWlkEnvironmentType.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                setToken("tk_splk_wlk_env_type", newValue);
              }
            });

            // Search Head Accounts

            var inputSplkWlkSearchHeadAccounts = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputSplkWlkSearchHeadAccounts",
                managerid: "searchPopulateConfigurationAccounts",
                default: "local",
                labelField: "account",
                valueField: "account",
                value: "$tk_splk_wlk_accounts$",
                el: $("#inputSplkWlkSearchHeadAccounts"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkWlkSearchHeadAccounts.on("change", function (newValue) {
              // check connectivity
              if (newValue != undefined && newValue != "") {
                // enable next
                $("#create_tenant_splk_wlk_step2").prop("disabled", false);
                if (newValue != "local") {
                  checkSplkFeedsRemoteAccount("wlk", newValue);
                } else {
                  $("#divParentCreateWlkHybridValidateRemoteConnectivity").css(
                    "display",
                    "none"
                  );
                }
              } else {
                // disable next
                $("#create_tenant_splk_wlk_step2").prop("disabled", true);
              }
            });

            // Outliers metrics default
            var inputSplkWlkDefaultOutliersMetrics = new DropdownView(
              {
                id: "inputSplkWlkDefaultOutliersMetrics",
                choices: [
                  {
                    label: "elapsed",
                    value:
                      "eval outliers_metrics=\"{'elapsed': {'alert_lower_breached': 0, 'alert_upper_breached': 1, 'time_factor': 'none'}}\"",
                  },
                  {
                    label: "pct_cpu",
                    value:
                      "eval outliers_metrics=\"{'pct_cpu': {'alert_lower_breached': 0, 'alert_upper_breached': 1, 'time_factor': 'none'}}\"",
                  },
                  {
                    label: "splunkcloud_svc",
                    value:
                      "eval outliers_metrics=\"{'svc_usage': {'alert_lower_breached': 0, 'alert_upper_breached': 1, 'time_factor': 'none'}}\"",
                  },
                  {
                    label: "count_completed",
                    value:
                      "eval outliers_metrics=\"{'count_completed': {'alert_lower_breached': 1, 'alert_upper_breached': 0, 'time_factor': 'none'}}\"",
                  },
                  {
                    label: "none",
                    value: 'eval outliers_metrics="{}"',
                  },
                ],
                default:
                  "eval outliers_metrics=\"{'elapsed': {'alert_lower_breached': 0, 'alert_upper_breached': 1, 'time_factor': 'none'}}\"",
                initialValue:
                  "eval outliers_metrics=\"{'elapsed': {'alert_lower_breached': 0, 'alert_upper_breached': 1, 'time_factor': 'none'}}\"",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: false,
                value: "$tk_splk_wlk_outliers_metrics$",
                el: $("#inputSplkWlkDefaultOutliersMetrics"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkWlkDefaultOutliersMetrics.on(
              "change",
              function (newValue) {
                // check the connectivity if the account is not local
                if (newValue != undefined) {
                  setToken("tk_splk_wlk_outliers_metrics", newValue);
                }
              }
            );

            // notable tracker
            var inputSplkWlkNotableTracker = new DropdownView(
              {
                id: "inputSplkWlkNotableTracker",
                choices: [
                  {
                    label: "False",
                    value: "false",
                  },
                  {
                    label: "True",
                    value: "true",
                  },
                ],
                default: "false",
                initialValue: "false",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: false,
                value: "$tk_splk_wlk_track_notable$",
                el: $("#inputSplkWlkNotableTracker"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkWlkNotableTracker.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                setToken("tk_splk_wlk_track_notable", newValue);
              }
            });

            // Delete inactive entities
            var inputSplkWlkInactiveInspector = new DropdownView(
              {
                id: "inputSplkWlkInactiveInspector",
                choices: [
                  {
                    label: "More than 7 days",
                    value: "7",
                  },
                  {
                    label: "More than 15 days",
                    value: "15",
                  },
                  {
                    label: "More than 30 days",
                    value: "30",
                  },
                  {
                    label: "More than 45 days",
                    value: "45",
                  },
                  {
                    label: "More than 60 days",
                    value: "60",
                  },
                  {
                    label: "More than 90 days",
                    value: "90",
                  },
                ],
                default: "15",
                initialValue: "15",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: false,
                value: "$tk_splk_wlk_inactive_inspector$",
                el: $("#inputSplkWlkInactiveInspector"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkWlkInactiveInspector.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                setToken("tk_splk_wlk_inactive_inspector", newValue);
              }
            });

            //
            // splk-feeds
            //

            // deployment selector for splk-dsm
            var inputSplkDsmListDeployments = new DropdownView(
              {
                id: "inputSplkDsmListDeployments",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: true,
                minimumResultsForSearch: 100,
                labelField: "account",
                valueField: "account",
                managerid: "searchPopulateConfigurationAccounts",
                value: "$tk_splk_dsm_deployment$",
                el: $("#inputSplkDsmListDeployments"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkDsmListDeployments.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                if (newValue != "local") {
                  checkSplkFeedsRemoteAccount("dsm", newValue);
                } else {
                  $("#divParentCreateDsmHybridValidateRemoteConnectivity").css(
                    "display",
                    "none"
                  );
                }
              }
            });

            // deployment selector for splk-dhm
            var inputSplkDhmListDeployments = new DropdownView(
              {
                id: "inputSplkDhmListDeployments",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: true,
                minimumResultsForSearch: 100,
                labelField: "account",
                valueField: "account",
                managerid: "searchPopulateConfigurationAccounts",
                value: "$tk_splk_dhm_deployment$",
                el: $("#inputSplkDhmListDeployments"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkDhmListDeployments.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                if (newValue != "local") {
                  checkSplkFeedsRemoteAccount("dhm", newValue);
                } else {
                  $("#divParentCreateDhmHybridValidateRemoteConnectivity").css(
                    "display",
                    "none"
                  );
                }
              }
            });

            // deployment selector for splk-mhm
            var inputSplkMhmListDeployments = new DropdownView(
              {
                id: "inputSplkMhmListDeployments",
                searchWhenChanged: false,
                showClearButton: true,
                selectFirstChoice: true,
                minimumResultsForSearch: 100,
                labelField: "account",
                valueField: "account",
                managerid: "searchPopulateConfigurationAccounts",
                value: "$tk_splk_mhm_deployment$",
                el: $("#inputSplkMhmListDeployments"),
              },
              {
                tokens: true,
              }
            ).render();

            inputSplkMhmListDeployments.on("change", function (newValue) {
              // check the connectivity if the account is not local
              if (newValue != undefined) {
                if (newValue != "local") {
                  checkSplkFeedsRemoteAccount("mhm", newValue);
                } else {
                  $("#divParentCreateMhmHybridValidateRemoteConnectivity").css(
                    "display",
                    "none"
                  );
                }
              }
            });

            var inputListRolesAdminSplkFeeds = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkFeeds",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_feeds$",
                el: $("#inputListRolesAdminSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkFeeds = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkFeeds",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_feeds$",
                el: $("#inputListRolesPowerSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkFeeds = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkFeeds",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_feeds$",
                el: $("#inputListRolesUserSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkFeeds = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkFeeds",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_feeds$",
                el: $("#inputListUserSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkFeeds = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkFeeds",
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_feeds$",
                el: $("#inputTenantIdxSummarySplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkFeeds = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkFeeds",
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_feeds$",
                el: $("#inputTenantIdxAuditSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkFeeds = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkFeeds",
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_feeds$",
                el: $("#inputTenantIdxMetricSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkFeeds = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkFeeds",
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_feeds$",
                el: $("#inputTenantIdxNotableSplkFeeds"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // splk-cim
            //

            var inputListRolesAdminSplkCim = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkCim",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_cim$",
                el: $("#inputListRolesAdminSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkCim = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkCim",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_cim$",
                el: $("#inputListRolesPowerSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkCim = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkCim",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_cim$",
                el: $("#inputListRolesUserSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkCim = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkCim",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_cim$",
                el: $("#inputListUserSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkCim = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkCim",
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_cim$",
                el: $("#inputTenantIdxSummarySplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkCim = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkCim",
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_cim$",
                el: $("#inputTenantIdxAuditSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkCim = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkCim",
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_cim$",
                el: $("#inputTenantIdxMetricSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkCim = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkCim",
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_cim$",
                el: $("#inputTenantIdxNotableSplkCim"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // splk-flx
            //

            var inputListRolesAdminSplkFlx = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkFlx",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_flx$",
                el: $("#inputListRolesAdminSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkFlx = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkFlx",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_flx$",
                el: $("#inputListRolesPowerSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkFlx = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkFlx",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_flx$",
                el: $("#inputListRolesUserSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkFlx = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkFlx",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_flx$",
                el: $("#inputListUserSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkFlx = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkFlx",
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_flx$",
                el: $("#inputTenantIdxSummarySplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkFlx = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkFlx",
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_flx$",
                el: $("#inputTenantIdxAuditSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkFlx = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkFlx",
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_flx$",
                el: $("#inputTenantIdxMetricSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkFlx = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkFlx",
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_flx$",
                el: $("#inputTenantIdxNotableSplkFlx"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // splk-fqm
            //

            var inputListRolesAdminSplkFqm = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkFqm",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_fqm$",
                el: $("#inputListRolesAdminSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkFqm = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkFqm",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_fqm$",
                el: $("#inputListRolesPowerSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkFqm = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkFqm",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_fqm$",
                el: $("#inputListRolesUserSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkFqm = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkFqm",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_fqm$",
                el: $("#inputListUserSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkFqm = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkFqm",
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_fqm$",
                el: $("#inputTenantIdxSummarySplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkFqm = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkFqm",
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_fqm$",
                el: $("#inputTenantIdxAuditSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkFqm = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkFqm",
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_fqm$",
                el: $("#inputTenantIdxMetricSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkFqm = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkFqm",
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_fqm$",
                el: $("#inputTenantIdxNotableSplkFqm"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // splk-replica
            //

            var inputListComponentsSplkReplica = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListComponentsSplkReplica",
                managerid: "searchListComponents",
                default: "splk-dsm",
                labelField: "components",
                valueField: "components",
                value: "$tk_tenant_replica_components$",
                el: $("#inputListComponentsSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesAdminSplkReplica = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkReplica",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_replica$",
                el: $("#inputListRolesAdminSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkReplica = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkReplica",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_replica$",
                el: $("#inputListRolesPowerSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkReplica = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkReplica",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_replica$",
                el: $("#inputListRolesUserSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkReplica = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkReplica",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_replica$",
                el: $("#inputListUserSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkReplica = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkReplica",
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_replica$",
                el: $("#inputTenantIdxSummarySplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkReplica = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkReplica",
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_replica$",
                el: $("#inputTenantIdxAuditSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkReplica = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkReplica",
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_replica$",
                el: $("#inputTenantIdxMetricSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkReplica = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkReplica",
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_replica$",
                el: $("#inputTenantIdxNotableSplkReplica"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // splk-wlk
            //

            var inputListRolesAdminSplkWlk = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesAdminSplkWlk",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_admin_splk_wlk$",
                el: $("#inputListRolesAdminSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesPowerSplkWlk = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesPowerSplkWlk",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_power_splk_wlk$",
                el: $("#inputListRolesPowerSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListRolesUserSplkWlk = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputListRolesUserSplkWlk",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_roles_user_splk_wlk$",
                el: $("#inputListRolesUserSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputListUserSplkWlk = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputListUserSplkWlk",
                managerid: "searchListUsers",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_owner_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_owner_splk_wlk$",
                el: $("#inputListUserSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            // List indexes
            var inputTenantIdxSummarySplkWlk = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxSummarySplkWlk",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_summary_idx"
                  ],
                managerid: "searchListIdxSummary",
                selectFirstChoice: "false",
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_summary_splk_wlk$",
                el: $("#inputTenantIdxSummarySplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxAuditSplkWlk = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxAuditSplkWlk",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_audit_idx"
                  ],
                managerid: "searchListIdxAudit",
                selectFirstChoice: "false",
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_audit_splk_wlk$",
                el: $("#inputTenantIdxAuditSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxMetricSplkWlk = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxMetricSplkWlk",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_metric_idx"
                  ],
                managerid: "searchListIdxMetric",
                selectFirstChoice: "false",
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_metric_splk_wlk$",
                el: $("#inputTenantIdxMetricSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputTenantIdxNotableSplkWlk = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputTenantIdxNotableSplkWlk",
                default:
                  trackme_conf["trackme_conf"]["index_settings"][
                    "trackme_notable_idx"
                  ],
                managerid: "searchListIdxNotable",
                selectFirstChoice: "false",
                minimumResultsForSearch: 100,
                width: 250,
                labelField: "title",
                valueField: "title",
                value: "$tk_tenant_idx_notable_splk_wlk$",
                el: $("#inputTenantIdxNotableSplkWlk"),
              },
              {
                tokens: true,
              }
            ).render();

            // update RBAC

            var inputUpdateListRolesAdmin = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputUpdateListRolesAdmin",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_admin_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_update_tenant_roles_admin$",
                el: $("#inputUpdateListRolesAdmin"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputUpdateListRolesPower = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputUpdateListRolesPower",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_power_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_update_tenant_roles_power$",
                el: $("#inputUpdateListRolesPower"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputUpdateListRolesUser = new MultiDropdownView(
              {
                searchWhenChanged: true,
                id: "inputUpdateListRolesUser",
                managerid: "searchListRoles",
                default:
                  trackme_conf["trackme_conf"]["trackme_general"][
                    "trackme_user_role_default"
                  ],
                labelField: "title",
                valueField: "title",
                value: "$tk_update_tenant_roles_user$",
                el: $("#inputUpdateListRolesUser"),
              },
              {
                tokens: true,
              }
            ).render();

            var inputUpdateListUser = new DropdownView(
              {
                searchWhenChanged: true,
                id: "inputUpdateListUser",
                managerid: "searchListUsers",
                default: "nobody",
                labelField: "title",
                valueField: "title",
                value: "$tk_update_tenant_owner$",
                el: $("#inputUpdateListUser"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // VIEW COMPONENTS
            //

            var vizSchedulerStatus = new semiCircleDonut(
              {
                id: "vizSchedulerStatus",
                type: "semicircle_donut.semicircle_donut",
                resizable: true,
                drilldown: "all",
                height: "140",
                "refresh.display": "progressbar",
                "semicircle_donut.semicircle_donut.colorField": "color",
                "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
                "semicircle_donut.semicircle_donut.legendPosition": "top",
                "semicircle_donut.semicircle_donut.type": "half",
                "trellis.enabled": "0",
                "trellis.scales.shared": "1",
                "trellis.size": "medium",
                managerid: "searchSchedulerStatus",
                el: $("#vizSchedulerStatus"),
              },
              { tokens: true, tokenNamespace: "submitted" }
            ).render();

            //
            // Open Scheduler Status
            //

            function openSchedulerStatus() {
              // Set token to start searches, and Open modal
              searchTimeChartSchedulerPerTenantStatus.startSearch();

              // show tenants Scheduler status
              function showTenantsSchedulerStatus(ajaxUrl, ajaxType) {
                // Add the loader
                $("#tenant-scheduler-status-loader").css("display", "block");
                $("#showTenantSchedulerTabulator").css("display", "none");

                // Run the ajax promise
                var doAsync = asyncAjax(ajaxUrl, ajaxType).then(function (
                  resultCall
                ) {
                  tabulatorElement = "#showTenantSchedulerTabulator";

                  var openReportIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-box-arrow-up-right'></i>";
                  };

                  var openAuditIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-search'></i>";
                  };

                  var openPerfsIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-bar-chart-line'></i>";
                  };

                  var table = new TabulatorFull(tabulatorElement, {
                    data: resultCall, //load row data from array
                    index: "tenant_id",
                    layout: "fitDataFill", //fit columns to width of table
                    //responsiveLayout: "hide", //hide columns that dont fit on the table
                    movableRows: true, // allow rows to be moved
                    addRowPos: "top", //when adding a new row, add it to the top of the table
                    history: true, //allow undo and redo actions on the table
                    pagination: "local", //paginate the data
                    paginationSize: 100, //allow 5 rows per page of data
                    paginationCounter: "rows", //display count of paginated rows in footer
                    movableColumns: true, //allow column order to be changed
                    resizableRows: true, //allow row order to be changed
                    maxHeight: "400px",
                    groupBy: ["tenant_id", "status"],
                    initialSort: [
                      //set the initial sort order of the data
                      { column: "tenant_id", dir: "asc" },
                    ],

                    columns: [
                      //define the table columns
                      {
                        title: "report",
                        formatter: openReportIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openInSplunkWeb(cell.getRow().getData());
                        },
                      },
                      {
                        title: "audit",
                        formatter: openAuditIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openAuditLogs(cell.getRow().getData());
                        },
                      },
                      {
                        title: "logs",
                        formatter: openAuditIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openLogsInspector(cell.getRow().getData());
                        },
                      },
                      {
                        title: "perfs",
                        formatter: openPerfsIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openPerfsDeepDive(cell.getRow().getData());
                        },
                      },
                      {
                        title: "Tenant ID",
                        field: "tenant_id",
                        editor: false,
                        headerFilter: true,
                        sorter: "string",
                        minWidth: 150,
                      },
                      {
                        title: "Status",
                        field: "status",
                        editor: false,
                        headerFilter: true,
                        minWidth: 150,
                      },
                      {
                        title: "Report",
                        field: "report",
                        editor: false,
                        headerFilter: true,
                        minWidth: 350,
                      },
                      {
                        title: "% Completed",
                        field: "pct_completed",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "",
                        field: "pct_completed_icon",
                        editor: false,
                        headerFilter: false,
                      },
                      {
                        title: "Count execution",
                        field: "count",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "Count completed",
                        field: "count_completed",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "Count skipped",
                        field: "count_skipped",
                        editor: false,
                        headerFilter: true,
                      },
                    ],
                  });

                  // Open in Splunk Web function
                  function openInSplunkWeb(jsonData) {
                    // Define the target URL
                    var report_name = jsonData["report"];
                    var splunkweb_url;
                    splunkweb_url =
                      getSplunkUrl(
                        "/manager/trackme/saved/searches?app=trackme&count=10&offset=0&itemType=&owner=*&search="
                      ) + report_name;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      splunkweb_url;
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Audit Logs
                  function openAuditLogs(jsonData) {
                    // Define the target URL
                    var tenant_id = jsonData["tenant_id"];
                    var report_name = jsonData["report"];
                    var reportSearchStr;
                    // report search tring
                    // if the report contains "_wrapper_tenant_", then create a search string as report=<original report name> OR report=<original report name with _tracker_tenant_> instead
                    if (report_name.includes("_wrapper_tenant_")) {
                      var report_name_tracker = report_name.replace(
                        "_wrapper_tenant_",
                        "_tracker_tenant_"
                      );
                      reportSearchStr =
                        "report=" +
                        report_name +
                        " OR report=" +
                        report_name_tracker;
                    } else if (report_name.includes("_tracker_tenant_")) {
                      var report_name_wrapper = report_name.replace(
                        "_tracker_tenant_",
                        "_wrapper_tenant_"
                      );
                      reportSearchStr =
                        "report=" +
                        report_name +
                        " OR report=" +
                        report_name_wrapper;
                    } else {
                      reportSearchStr = "report=" + report_name;
                    }
                    var url =
                      getSplunkUrl("/app/trackme/search?q=") +
                      '`trackme_audit_idx("' +
                      tenant_id +
                      '")` tenant_id="' +
                      tenant_id +
                      '" ' +
                      reportSearchStr;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Perfs DeepDive
                  function openPerfsDeepDive(jsonData) {
                    // Define the target URL
                    var tenant_id = jsonData["tenant_id"];
                    var report_name = jsonData["report"];

                    // if the report contains "_tracker_tenant_", then replace it with "_wrapper_tenant_"
                    if (report_name.includes("_tracker_tenant_")) {
                      if (
                        !report_name.includes("health_tracker") &&
                        !report_name.includes("adaptive_delay_tracker") &&
                        !report_name.includes("data_sampling_tracker") &&
                        !report_name.includes("outliers_mltrain_tracker") &&
                        !report_name.includes("outliers_mlmonitor_tracker") &&
                        !report_name.includes("shared_elastic_tracker") &&
                        !report_name.includes("sla_trackers") &&
                        !report_name.includes("tags_tracker") &&
                        !report_name.includes("priority_tracker") &&
                        !report_name.includes("inactive_entities_tracker")
                      ) {
                        report_name = report_name.replace(
                          "_tracker_tenant_",
                          "_wrapper_tenant_"
                        );
                      }
                    }

                    var url =
                      getSplunkUrl(
                        "/app/trackme/trackMe_audit_trackers_perf?"
                      ) +
                      "form.tk_tenant_id=" +
                      tenant_id +
                      "&form.tk_tracker=" +
                      report_name;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Logs Inspector
                  function openLogsInspector(jsonData) {
                    // Define the target URL
                    var report_name = jsonData["report"];
                    var reportSearchStr;
                    // report search tring
                    // if the report contains "_wrapper_tenant_", then create a search string as <original report name> OR <original report name with _tracker_tenant_> instead
                    if (report_name.includes("_wrapper_tenant_")) {
                      var report_name_tracker = report_name.replace(
                        "_wrapper_tenant_",
                        "_tracker_tenant_"
                      );
                      reportSearchStr =
                        report_name + " OR " + report_name_tracker;
                    } else if (report_name.includes("_tracker_tenant_")) {
                      var report_name_wrapper = report_name.replace(
                        "_tracker_tenant_",
                        "_wrapper_tenant_"
                      );
                      reportSearchStr =
                        report_name + " OR " + report_name_wrapper;
                    } else {
                      reportSearchStr = report_name;
                    }
                    var url =
                      getSplunkUrl(
                        "/app/trackme/trackMe_commands_log_inspector?form.tk_search="
                      ) + reportSearchStr;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  table.on("tableBuilt", function () {
                    $("#tenant-scheduler-status-loader").css("display", "none");
                    $("#showTenantSchedulerTabulator").css("display", "block");
                  });

                  // Event listener for "Success" button
                  document
                    .getElementById("scheduler-status-table-status-success")
                    .addEventListener("click", function () {
                      table.setFilter([
                        { field: "status", type: "like", value: "completed" },
                      ]);
                    });

                  // Event listener for "Failure" button
                  document
                    .getElementById("scheduler-status-table-status-failure")
                    .addEventListener("click", function () {
                      table.setFilter([
                        { field: "status", type: "like", value: "skipped" },
                      ]);
                    });

                  // Event listener for "all" button
                  document
                    .getElementById("scheduler-status-table-status-all")
                    .addEventListener("click", function () {
                      table.setFilter([
                        { field: "status", type: "like", value: "" },
                      ]);
                    });
                });
              }

              // get table
              showTenantsSchedulerStatus(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/configuration/get_tenant_scheduler_status"
                ),
                "get"
              );

              $("#modal_scheduler_status").modal();
              // Show message
              notify(
                "info",
                "bottom",
                "ℹ️ The scheduler overview provides key performance indicators about the activity of the Splunk scheduler when it comes to the execution of the trackers, anything bellow 100% completed likely indicates issues!",
                "10"
              );
            }

            // If chart is clicked
            vizSchedulerStatus.on("click", function (e) {
              e.preventDefault();
              openSchedulerStatus();
            });

            // If button is clicked
            $("#btn_scheduler_status")
              .unbind()
              .click(function () {
                openSchedulerStatus();
              });

            //
            // Vtenants Upgrade Status
            //

            var searchDonutChartUpdatePerTenantStatus = new SearchManager(
              {
                id: "searchDonutChartUpdatePerTenantStatus",
                autostart: false,
                search:
                  '| trackmetenantstatus output="tenants" | stats count by tenant_updated_status',
                earliest_time: "-5m",
                latest_time: "now",
              },
              {
                tokens: true,
              }
            );

            var donutUpdatePerTenantStatus = new semiCircleDonut(
              {
                id: "donutUpdatePerTenantStatus",
                type: "semicircle_donut.semicircle_donut",
                resizable: true,
                drilldown: "none",
                height: "120",
                "refresh.display": "progressbar",
                "semicircle_donut.semicircle_donut.colorField": "color",
                "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
                "semicircle_donut.semicircle_donut.legendPosition": "top",
                "semicircle_donut.semicircle_donut.type": "half",
                "trellis.enabled": "0",
                "trellis.scales.shared": "1",
                "trellis.size": "medium",
                managerid: "searchDonutChartUpdatePerTenantStatus",
                el: $("#donutUpdatePerTenantStatus"),
              },
              {
                tokens: true,
              }
            ).render();

            // show tenants Ops status
            function showTenantsUpdateStatus(ajaxUrl, ajaxType) {
              // Run the ajax promise
              var doAsync = asyncAjax(ajaxUrl, ajaxType).then(function (
                resultCall
              ) {
                tabulatorElement = "#showTenantsUpdateTabulator";

                // Generate search icon
                var searchIcon = function (cell, formatterParams) {
                  return "<i class='bi bi-search'></i>";
                };

                var table = new TabulatorFull(tabulatorElement, {
                  data: resultCall, //load row data from array
                  index: "tenant_id",
                  layout: "fitColumns",
                  //responsiveLayout: "hide", //hide columns that dont fit on the table
                  movableRows: true, // allow rows to be moved
                  addRowPos: "top", //when adding a new row, add it to the top of the table
                  history: true, //allow undo and redo actions on the table
                  pagination: "local", //paginate the data
                  paginationSize: 100, //allow 5 rows per page of data
                  paginationCounter: "rows", //display count of paginated rows in footer
                  movableColumns: true, //allow column order to be changed
                  resizableRows: true, //allow row order to be changed
                  maxHeight: "400px",
                  groupBy: "tenant_id",
                  initialSort: [
                    //set the initial sort order of the data
                    { column: "tenant_id", dir: "asc" },
                  ],

                  columns: [
                    //define the table columns
                    // open
                    {
                      formatter: searchIcon,
                      width: 40,
                      hozAlign: "center",
                      headerSort: false,
                      cellClick: function (e, cell) {
                        // Open the entity modal
                        searchTenantUpdateLogs(cell.getRow().getData());
                      },
                    },
                    {
                      title: "Tenant ID",
                      field: "tenant_id",
                      editor: false,
                      headerFilter: true,
                      sorter: "string",
                      minWidth: 150,
                    },
                    {
                      title: "schema_version",
                      field: "schema_version",
                      editor: false,
                      headerFilter: true,
                    },
                    {
                      title: "schema_version_required",
                      field: "schema_version_required",
                      editor: false,
                      headerFilter: true,
                      minWidth: 150,
                    },
                    {
                      title: "tenant_updated_status",
                      field: "tenant_updated_status",
                      editor: false,
                      headerFilter: true,
                      minWidth: 350,
                    },
                    {
                      title: "schema_version_mtime",
                      field: "schema_version_mtime",
                      editor: false,
                      headerFilter: true,
                    },
                  ],
                });

                table.on("tableBuilt", function () {
                  $("#tenant-update-status-loader").css("display", "none");
                  $("#showTenantsUpdateTabulator").css("display", "block");
                });

                // Event listener for "updated" button
                document
                  .getElementById("update-status-table-status-success")
                  .addEventListener("click", function () {
                    table.setFilter([
                      {
                        field: "tenant_updated_status",
                        type: "like",
                        value: "updated",
                      },
                    ]);
                  });

                // Event listener for "pending" button
                document
                  .getElementById("update-status-table-status-failure")
                  .addEventListener("click", function () {
                    table.setFilter([
                      {
                        field: "tenant_updated_status",
                        type: "like",
                        value: "pending",
                      },
                    ]);
                  });

                // Event listener for "all" button
                document
                  .getElementById("update-status-table-status-all")
                  .addEventListener("click", function () {
                    table.setFilter([
                      {
                        field: "tenant_updated_status",
                        type: "like",
                        value: "",
                      },
                    ]);
                  });
              });
            }

            function searchTenantUpdateLogs(jsonData) {
              var selected_tenant = jsonData["tenant_id"];
              href_link =
                "search?q=" +
                encodeURIComponent(
                  "index=_internal sourcetype=trackme:custom_commands:trackmetrackerhealth task=schema_upgrade tenant_id=" +
                    selected_tenant
                );
              // open in a new Web browser tab this href
              window.open(href_link, "_blank");
            }

            $("#licenseInfo")
              .unbind()
              .click(function () {
                $(this).blur();
                // get table
                showTenantsUpdateStatus(
                  getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/vtenants/show_tenants"
                  ),
                  "get"
                );
                searchDonutChartUpdatePerTenantStatus.startSearch();
                // open modal
                $("#modal_tenant_update_status").modal("show");
              });

            //
            // Vtenants Ops Status
            //

            var vizOpsStatus = new semiCircleDonut(
              {
                id: "vizOpsStatus",
                type: "semicircle_donut.semicircle_donut",
                resizable: true,
                drilldown: "all",
                height: "140",
                "refresh.display": "progressbar",
                "semicircle_donut.semicircle_donut.colorField": "color",
                "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
                "semicircle_donut.semicircle_donut.legendPosition": "top",
                "semicircle_donut.semicircle_donut.type": "half",
                "trellis.enabled": "0",
                "trellis.scales.shared": "1",
                "trellis.size": "medium",
                managerid: "searchOpsStatus",
                el: $("#vizOpsStatus"),
              },
              { tokens: true, tokenNamespace: "submitted" }
            ).render();

            //
            // Ops Status function
            //

            function openOpsStatus() {
              //
              setToken("showOpsStatusModal", "true");
              // Start the searches
              searchTimeChartOpsPerTenantStatus.startSearch();
              searchDonutChartOpsPerTenantStatus.startSearch();
              searchOpsPerTenantStatus.startSearch();
              // Open modal
              $("#modal_tenant_ops_status").modal();

              // show tenants Ops status
              function showTenantsOpsStatus(ajaxUrl, ajaxType) {
                // Add the loader
                $("#tenant-ops-status-loader").css("display", "block");
                $("#showTenantOpsTabulator").css("display", "none");

                // Run the ajax promise
                var doAsync = asyncAjax(ajaxUrl, ajaxType).then(function (
                  resultCall
                ) {
                  tabulatorElement = "#showTenantOpsTabulator";

                  // get componentRegister from resultCall, if resultCall is empty, set componentRegister to empty array
                  var tableData = [];
                  if (resultCall.length == 0) {
                    tableData = [];
                  } else {
                    // loop through resultCall, extract the value of job_component_register which is an array
                    // loop through the array and push to tableData
                    for (var i = 0; i < resultCall.length; i++) {
                      var job_component_register = JSON.parse(
                        resultCall[i].job_component_register
                      );
                      for (var j = 0; j < job_component_register.length; j++) {
                        tableData.push(job_component_register[j]);
                      }
                    }
                  }

                  var openReportIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-box-arrow-up-right'></i>";
                  };

                  var openAuditIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-search'></i>";
                  };

                  var openPerfsIcon = function (cell, formatterParams) {
                    return "<i class='bi bi-bar-chart-line'></i>";
                  };

                  var table = new TabulatorFull(tabulatorElement, {
                    data: JSON.parse(JSON.stringify(tableData)), //load row data from array
                    index: "tenant_id",
                    layout: "fitDataFill", //fit columns to width of table
                    //responsiveLayout: "hide", //hide columns that dont fit on the table
                    movableRows: true, // allow rows to be moved
                    addRowPos: "top", //when adding a new row, add it to the top of the table
                    history: true, //allow undo and redo actions on the table
                    pagination: "local", //paginate the data
                    paginationSize: 100, //allow 5 rows per page of data
                    paginationCounter: "rows", //display count of paginated rows in footer
                    movableColumns: true, //allow column order to be changed
                    resizableRows: true, //allow row order to be changed
                    maxHeight: "450px",
                    groupBy: ["tenant_id", "last_status"],
                    initialSort: [
                      //set the initial sort order of the data
                      { column: "tenant_id", dir: "asc" },
                    ],

                    columns: [
                      //define the table columns
                      {
                        title: "report",
                        formatter: openReportIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openInSplunkWeb(cell.getRow().getData());
                        },
                      },
                      {
                        title: "audit",
                        formatter: openAuditIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openAuditLogs(cell.getRow().getData());
                        },
                      },
                      {
                        title: "logs",
                        formatter: openAuditIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openLogsInspector(cell.getRow().getData());
                        },
                      },
                      {
                        title: "perfs",
                        formatter: openPerfsIcon,
                        headerSort: false,
                        width: 60,
                        hozAlign: "center",
                        cellClick: function (e, cell) {
                          openPerfsDeepDive(cell.getRow().getData());
                        },
                      },
                      {
                        title: "Tenant ID",
                        field: "tenant_id",
                        editor: false,
                        headerFilter: true,
                        sorter: "string",
                        minWidth: 150,
                      },
                      {
                        title: "Component",
                        field: "component",
                        editor: false,
                        headerFilter: true,
                      },
                      {
                        title: "Status",
                        field: "last_status",
                        editor: false,
                        headerFilter: true,
                        minWidth: 150,
                      },
                      {
                        title: "Report",
                        field: "report",
                        editor: false,
                        headerFilter: true,
                        minWidth: 350,
                      },
                      {
                        title: "Last result",
                        field: "last_result",
                        editor: false,
                        headerFilter: true,
                        minWidth: 450,
                      },
                      {
                        title: "Last execution",
                        field: "last_exec",
                        editor: false,
                        headerFilter: true,
                        minWidth: 200,
                      },
                      {
                        title: "Last duration (sec)",
                        field: "last_duration",
                        editor: false,
                        headerFilter: true,
                        minWidth: 150,
                      },
                    ],
                  });

                  // Open in Splunk Web function
                  function openInSplunkWeb(jsonData) {
                    // Define the target URL
                    var report_name = jsonData["report"];
                    var splunkweb_url;
                    splunkweb_url =
                      getSplunkUrl(
                        "/manager/trackme/saved/searches?app=trackme&count=10&offset=0&itemType=&owner=*&search="
                      ) + report_name;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      splunkweb_url;
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Audit Logs
                  function openAuditLogs(jsonData) {
                    // Define the target URL
                    var tenant_id = jsonData["tenant_id"];
                    var report_name = jsonData["report"];
                    var reportSearchStr;
                    // report search tring
                    // if the report contains "_wrapper_tenant_", then create a search string as report=<original report name> OR report=<original report name with _tracker_tenant_> instead
                    if (report_name.includes("_wrapper_tenant_")) {
                      var report_name_tracker = report_name.replace(
                        "_wrapper_tenant_",
                        "_tracker_tenant_"
                      );
                      reportSearchStr =
                        "report=" +
                        report_name +
                        " OR report=" +
                        report_name_tracker;
                    } else if (report_name.includes("_tracker_tenant_")) {
                      var report_name_wrapper = report_name.replace(
                        "_tracker_tenant_",
                        "_wrapper_tenant_"
                      );
                      reportSearchStr =
                        "report=" +
                        report_name +
                        " OR report=" +
                        report_name_wrapper;
                    } else {
                      reportSearchStr = "report=" + report_name;
                    }
                    var url =
                      getSplunkUrl("/app/trackme/search?q=") +
                      '`trackme_audit_idx("' +
                      tenant_id +
                      '")` tenant_id="' +
                      tenant_id +
                      '" ' +
                      reportSearchStr;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Perfs DeepDive
                  function openPerfsDeepDive(jsonData) {
                    // Define the target URL
                    var tenant_id = jsonData["tenant_id"];
                    var report_name = jsonData["report"];
                    var url =
                      getSplunkUrl(
                        "/app/trackme/trackMe_audit_trackers_perf?"
                      ) +
                      "form.tk_tenant_id=" +
                      tenant_id +
                      "&form.tk_tracker=" +
                      report_name;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  // Open Logs Inspector
                  function openLogsInspector(jsonData) {
                    // Define the target URL
                    var report_name = jsonData["report"];
                    var reportSearchStr;
                    // report search tring
                    // if the report contains "_wrapper_tenant_", then create a search string as <original report name> OR <original report name with _tracker_tenant_> instead
                    if (report_name.includes("_wrapper_tenant_")) {
                      var report_name_tracker = report_name.replace(
                        "_wrapper_tenant_",
                        "_tracker_tenant_"
                      );
                      reportSearchStr =
                        report_name + " OR " + report_name_tracker;
                    } else if (report_name.includes("_tracker_tenant_")) {
                      var report_name_wrapper = report_name.replace(
                        "_tracker_tenant_",
                        "_wrapper_tenant_"
                      );
                      reportSearchStr =
                        report_name + " OR " + report_name_wrapper;
                    } else {
                      reportSearchStr = report_name;
                    }
                    var url =
                      getSplunkUrl(
                        "/app/trackme/trackMe_commands_log_inspector?form.tk_search="
                      ) + reportSearchStr;
                    var target_url =
                      location.protocol +
                      "//" +
                      location.hostname +
                      (location.port ? ":" + location.port : "") +
                      encodeURI(url);
                    // Open the target url in a new tab
                    window.open(target_url, "_blank");
                  }

                  table.on("tableBuilt", function () {
                    $("#tenant-ops-status-loader").css("display", "none");
                    $("#showTenantOpsTabulator").css("display", "block");
                  });

                  // Event listener for "Success" button
                  document
                    .getElementById("ops-status-table-status-success")
                    .addEventListener("click", function () {
                      table.setFilter([
                        {
                          field: "last_status",
                          type: "like",
                          value: "success",
                        },
                      ]);
                    });

                  // Event listener for "Failure" button
                  document
                    .getElementById("ops-status-table-status-failure")
                    .addEventListener("click", function () {
                      table.setFilter([
                        {
                          field: "last_status",
                          type: "like",
                          value: "failure",
                        },
                      ]);
                    });

                  // Event listener for "all" button
                  document
                    .getElementById("ops-status-table-status-all")
                    .addEventListener("click", function () {
                      table.setFilter([
                        { field: "last_status", type: "like", value: "" },
                      ]);
                    });
                });
              }

              // get table
              showTenantsOpsStatus(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/configuration/get_tenant_ops_status"
                ),
                "post"
              );

              // Show message
              notify(
                "info",
                "bottom",
                "ℹ️ The Tenants health operational overview provides quick insights on the status of your TrackMe tenants, analysing for instance if their activity is delayed or missing!",
                "10"
              );
            }

            // Open Ops status when chart is clicked
            vizOpsStatus.on("click", function (e) {
              e.preventDefault();
              openOpsStatus();
              //
            });

            // Open Ops status when button is clicked (id=btn_ops_status)
            $("#btn_ops_status")
              .unbind()
              .click(function () {
                openOpsStatus();
              });

            // Clear Virtual Tenants Operation Status
            $("#btn_clear_virtual_tenant_status")
              .unbind()
              .click(function () {
                // kick search in
                searchListTenants.startSearch();

                // Open modal modal_clear_virtual_tenant_status
                $("#modal_clear_virtual_tenant_status").modal();
              });

            // Clear Virtual Tenants Operation Status confirmed
            $("#btn_confirm_clear_virtual_tenant_status")
              .unbind()
              .click(function () {
                $("body").append(
                  '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while clearing Virtual Tenants Operational Status, this might take some time and will continue in the back ground if this window disappears..."></div>'
                );

                var tenants = getToken("tk_tenants_scope");
                var run_healthtracker = $("#inputRunHealthCheckTracker").val();
                var update_comment = getComment(
                  "input_clear_exec_summary_comment"
                );

                data = {
                  tenants: tenants,
                  run_healthtracker: run_healthtracker,
                  update_comment: update_comment,
                };

                var myendpoint_URl = getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/vtenants/admin/clear_exec_summary"
                );
                $.ajax({
                  url: myendpoint_URl,
                  type: "POST",
                  async: true,
                  data: JSON.stringify(data),
                  contentType: "application/json",
                  success: function (returneddata) {
                    $("#cssloader").remove();
                    notify(
                      "success",
                      "bottom",
                      "OK! Virtual Tenant(s) operational status reset was successful!",
                      "5"
                    );
                    // Refresh
                    $("#btn_refresh_all").click();
                  },
                  error: function (xhr, textStatus, error) {
                    showErrorModal(
                      "modal_generic_error",
                      "Oops!",
                      xhr,
                      textStatus,
                      error
                    );
                  },
                });
              });

            //
            // MODAL SCHEDULER OVERVIEW
            //

            var searchTimeChartSchedulerPerTenantStatus =
              new SavedSearchManager({
                id: "searchTimeChartSchedulerPerTenantStatus",
                searchname: "trackme_scheduler_completness_overtime",
                cache: false,
                preview: true,
                autostart: false,
                "dispatch.earliest_time": "-24h",
                "dispatch.latest_time": "now",
                app: "trackme",
              });

            var resultsLinktimeChartSchedulerPerTenantStatus =
              new ResultsLinkView({
                id: "resultsLinktimeChartSchedulerPerTenantStatus",
                managerid: "searchTimeChartSchedulerPerTenantStatus",
                "link.exportResults.visible": false,
                el: $("#resultsLinktimeChartSchedulerPerTenantStatus"),
              });

            resultsLinktimeChartSchedulerPerTenantStatus
              .render()
              .$el.appendTo($("searchTimeChartSchedulerPerTenantStatus"));

            var timeChartSchedulerPerTenantStatus = new ChartView(
              {
                id: "timeChartSchedulerPerTenantStatus",
                managerid: "searchTimeChartSchedulerPerTenantStatus",
                resizable: true,
                height: "180",
                type: "column",
                "charting.chart.stackMode": "stacked",
                "charting.legend.placement": "right",
                "charting.axisTitleX.visibility": "collapsed",
                "charting.fieldColors":
                  '{"completed": 0x45D4BA,"skipped": 0xFBC02D,"deferred": 0xe85b79}',
                el: $("#timeChartSchedulerPerTenantStatus"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            // MODAL OPS OVERVIEW
            //

            var searchOpsPerTenantStatus = new SearchManager(
              {
                id: "searchOpsPerTenantStatus",
                tokenDependencies: {
                  depends: "$showOpsStatusModal$",
                },
                search: "| `per_tenant_ops_statusv2(*)`",
                autostart: false,
                earliest_time: "-60m",
                latest_time: "now",
              },
              {
                tokens: true,
              }
            );

            var tableOpsPerTenantStatus = new TableView(
              {
                id: "tableOpsPerTenantStatus",
                tokenDependencies: {
                  depends: "$showOpsStatusModal$",
                },
                drilldown: "row",
                managerid: "searchOpsPerTenantStatus",
                pageSize: "5",
                el: $("#tableOpsPerTenantStatus"),
              },
              {
                tokens: true,
              }
            ).render();

            var resultsLinktableOpsPerTenantStatus = new ResultsLinkView({
              id: "resultsLinktableOpsPerTenantStatus",
              managerid: "searchOpsPerTenantStatus",
              "link.exportResults.visible": false,
              el: $("#resultsLinktableOpsPerTenantStatus"),
            });

            resultsLinktableOpsPerTenantStatus
              .render()
              .$el.appendTo($("searchTimeChartOpsPerTenantStatus"));

            var searchTimeChartOpsPerTenantStatus = new SearchManager(
              {
                id: "searchTimeChartOpsPerTenantStatus",
                tokenDependencies: {
                  depends: "$showOpsStatusModal$",
                },
                autostart: false,
                search: "`per_tenant_ops_summary_activity`",
                earliest_time: "-4h",
                latest_time: "now",
              },
              {
                tokens: true,
              }
            );

            searchTimeChartOpsPerTenantStatus.on(
              "search:start",
              function (properties) {
                // hide messages
                $("#timeChartOpsPerTenantStatusResultsFound").css(
                  "display",
                  "none"
                );
                $("#timeChartOpsPerTenantStatusNoResults").css(
                  "display",
                  "none"
                );
              }
            );

            searchTimeChartOpsPerTenantStatus.on(
              "search:done",
              function (properties) {
                // Print the search job properties
                var eventCount = properties.content.eventCount;
                if (eventCount > 0) {
                  $("#parentTimeChartOpsPerTenantStatus").css(
                    "display",
                    "inherit"
                  );
                  $("#timeChartOpsPerTenantStatusResultsFound").css(
                    "display",
                    "inherit"
                  );
                  $("#timeChartOpsPerTenantStatusNoResults").css(
                    "display",
                    "none"
                  );
                } else {
                  $("#parentTimeChartOpsPerTenantStatus").css(
                    "display",
                    "none"
                  );
                  $("#timeChartOpsPerTenantStatusResultsFound").css(
                    "display",
                    "none"
                  );
                  $("#timeChartOpsPerTenantStatusNoResults").css(
                    "display",
                    "inherit"
                  );
                }
              }
            );

            var resultsLinktimeChartOpsPerTenantStatus = new ResultsLinkView({
              id: "resultsLinktimeChartOpsPerTenantStatus",
              managerid: "searchTimeChartOpsPerTenantStatus",
              "link.exportResults.visible": false,
              el: $("#resultsLinktimeChartOpsPerTenantStatus"),
            });

            resultsLinktimeChartOpsPerTenantStatus
              .render()
              .$el.appendTo($("searchTimeChartOpsPerTenantStatus"));

            var searchDonutChartOpsPerTenantStatus = new SearchManager(
              {
                id: "searchDonutChartOpsPerTenantStatus",
                tokenDependencies: {
                  depends: "$showOpsStatusModal$",
                },
                autostart: false,
                search: "| savedsearch trackme_ops_status",
                earliest_time: "-5m",
                latest_time: "now",
              },
              {
                tokens: true,
              }
            );

            var donutOpsPerTenantStatus = new semiCircleDonut(
              {
                id: "donutOpsPerTenantStatus",
                type: "semicircle_donut.semicircle_donut",
                resizable: true,
                drilldown: "none",
                height: "120",
                "refresh.display": "progressbar",
                "semicircle_donut.semicircle_donut.colorField": "color",
                "semicircle_donut.semicircle_donut.cutoutPercentage": "50",
                "semicircle_donut.semicircle_donut.legendPosition": "top",
                "semicircle_donut.semicircle_donut.type": "half",
                "trellis.enabled": "0",
                "trellis.scales.shared": "1",
                "trellis.size": "medium",
                managerid: "searchDonutChartOpsPerTenantStatus",
                el: $("#donutOpsPerTenantStatus"),
              },
              {
                tokens: true,
              }
            ).render();

            var timeChartOpsPerTenantStatus = new ChartView(
              {
                id: "timeChartOpsPerTenantStatus",
                tokenDependencies: {
                  depends: "$showOpsStatusModal$",
                },
                height: "140",
                managerid: "searchTimeChartOpsPerTenantStatus",
                resizable: true,
                type: "column",
                "charting.chart.stackMode": "stacked",
                "charting.legend.placement": "right",
                "charting.axisTitleX.visibility": "collapsed",
                "charting.axisLabelsY.majorUnit": "1",
                el: $("#timeChartOpsPerTenantStatus"),
              },
              {
                tokens: true,
              }
            ).render();

            //
            //
            //

            //
            // START
            //

            // get the tenant Ops status
            function getTenantsOpsStatus() {
              // Create the service
              var service = mvc.createService({
                owner: "nobody",
              });

              // Define the query
              var searchQuery = "| `tenants_ops_globalstatus`";

              // Set the search parameters--specify a time range
              var searchParams = {
                earliest_time: "-5m",
                latest_time: "now",
              };

              // Run a blocking search and get back a job
              // spinner
              // $("#cssloader").remove();
              // $("body").append(
              //   '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
              // );
              service.search(searchQuery, searchParams, function (err, job) {
                // Shall the search fail before we can get properties
                if (job == null) {
                  let errorStr = "Unknown Error!";
                  if (
                    err &&
                    err.data &&
                    err.data.messages &&
                    err.data.messages[0]["text"]
                  ) {
                    errorStr = err.data.messages[0]["text"];
                  } else if (err && err.data && err.data.messages) {
                    errorStr = JSON.stringify(err.data.messages);
                  }
                  // notify error
                  // $("#cssloader").remove();
                  message =
                    "ERROR: hum, something went quite wrong there! Splunk returned an error while while attempting to run the search: " +
                    errorStr;
                  // remove loader
                  $("#cssloader").remove();
                  notify("error", "bottom", message, "30");
                } else {
                  // Poll the status of the search job
                  job.track(
                    {
                      period: 200,
                    },
                    {
                      done: function (job) {
                        // Get the results
                        job.results({}, function (err, results, job) {
                          var fields = results.fields;
                          var rows = results.rows;
                          var jobResult;
                          for (var i = 0; i < rows.length; i++) {
                            var values = rows[i];
                            for (var j = 0; j < values.length; j++) {
                              var field = fields[j];
                              var value = values[j];
                              // get the _raw
                              if (field === "status_code") {
                                statusCode = value;
                              }
                              if (field === "status") {
                                statusValue = value;
                              }
                              if (field === "dcount_tenants") {
                                statusCount = value;
                              }
                            }
                          }
                        });
                      },
                      failed: function (properties) {
                        let errorStr = "Unknown Error!";
                        if (
                          properties &&
                          properties._properties &&
                          properties._properties.messages &&
                          properties._properties.messages[0]["text"]
                        ) {
                          errorStr = properties._properties.messages[0]["text"];
                        } else if (
                          properties &&
                          properties._properties &&
                          properties._properties.messages
                        ) {
                          errorStr = JSON.stringify(
                            properties._properties.messages
                          );
                        }
                        message =
                          "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                          errorStr;
                        // remove loader
                        $("#cssloader").remove();
                        notify("error", "bottom", message, "30");
                      },
                      error: function (err) {
                        done(err);
                        message =
                          "ERROR: hum, something went quite wrong there! Splunk returned the following errors: " +
                          err;
                        // remove loader
                        $("#cssloader").remove();
                        notify("error", "bottom", message, "30");
                      },
                    }
                  );
                }
              });
            }

            // call if now
            getTenantsOpsStatus();

            //
            // tenants management UI functions
            //

            // Audit record
            function auditRecord(
              tenant_id,
              action,
              change_type,
              object,
              object_category,
              object_attrs,
              result,
              comment
            ) {
              // Audit changes
              var currentUser = Splunk.util.getConfigValue("USERNAME");
              setToken("currentUser", currentUser);
              var auditendpoint_URl = getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/audit/audit_event"
              );

              var time = new Date().getTime();
              var audit_record = {
                time: time,
                tenant_id: tenant_id,
                action: action,
                user: currentUser,
                change_type: change_type,
                object: object,
                object_category: object_category,
                object_attrs: object_attrs,
                result: result,
                comment: comment,
              };
              $.ajax({
                url: auditendpoint_URl,
                type: "POST",
                async: true,
                contentType: "application/json",
                data: JSON.stringify(audit_record),
                success: function (returneddata) {
                  // Run the search again to update the table
                },
              });
            }

            //
            // Handle html textarea
            //

            $(".custom-textarea").each(function () {
              var $text_group = $(this);
              $text_group.find("textarea").on("click", function () {
                var $text = $(this);
                if (this.value == this.defaultValue) this.value = "";
                $(this).blur(function () {
                  if (this.value == "") this.value = this.defaultValue;
                });
              });
            });

            //
            // Create tenants
            //

            //
            // splk-cim
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_cim").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_cim_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_cim_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_cim_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_cim_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_cim_step1").prop("disabled", true);
                    },
                  });
                }
              });
            });

            //
            // splk-flx
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_flx").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_flx_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_flx_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_flx_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_flx_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_flx_step1").prop("disabled", true);
                    },
                  });
                }
              });
            });

            //
            // splk-fqm
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_fqm").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_fqm_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_fqm_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_fqm_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_fqm_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_fqm_step1").prop("disabled", true);
                    },
                  });
                }
              });
            });

            //
            // splk-replica
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_replica").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_replica_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_replica_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_replica_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_replica_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_replica_step1").prop(
                        "disabled",
                        true
                      );
                    },
                  });
                }
              });
            });

            //
            // splk-wlk
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_wlk").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_wlk_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_wlk_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_wlk_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_wlk_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_wlk_step1").prop("disabled", true);
                    },
                  });
                }
              });
            });

            //
            // splk-feeds
            //

            // enable next button once user provided tenant_id input
            $(function () {
              $("#input_tenant_name_splk_feeds").keyup(function () {
                if ($(this).val() == "") {
                  // Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_feeds_step1").prop("disabled", true);
                } else if ($(this).val().length > 20) {
                  // 10 chars max
                  $("#create_tenant_splk_feeds_step1").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "ERROR: The tenant name is limited to 20 characters max!",
                    "600"
                  );
                } else {
                  // Perform a query and verify if this tenant exists already

                  var tenant_id = $(this).val();
                  // replace empty chars, underscore and make it lower case
                  tenant_id = tenant_id.replace(/" "/g, "-");
                  tenant_id = tenant_id.replace(/"_"/g, "-");
                  tenant_id = tenant_id.toLowerCase();

                  var queryString = encodeURI(
                    '{ "tenant_id": "' + tenant_id + '" }'
                  );
                  var myendpoint_URl =
                    getSplunkUrl(
                      "/splunkd/__raw/servicesNS/nobody/trackme/storage/collections/data/kv_trackme_virtual_tenants?query="
                    ) + queryString;
                  $.ajax({
                    url: myendpoint_URl,
                    type: "GET",
                    async: true,
                    contentType: "application/json",
                    success: function (returneddata) {
                      if (returneddata.length > 0) {
                        notify(
                          "error",
                          "bottom",
                          "ERROR: A tenant with the same identifier already exists!",
                          "600"
                        );
                        $("#create_tenant_splk_feeds_step1").prop(
                          "disabled",
                          true
                        );
                      } else {
                        notify(
                          "success",
                          "bottom",
                          "OK! This tenant identifier is valid and does not exist yet",
                          "5"
                        );
                        $("#create_tenant_splk_feeds_step1").prop(
                          "disabled",
                          false
                        );
                      }
                    },
                    error: function (xhr, textStatus, error) {
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error;
                      notify(
                        "error",
                        "bottom",
                        "ERROR: failure to communicate with Splunk daemon! " +
                          message,
                        "600"
                      );
                      $("#create_tenant_splk_feeds_step1").prop(
                        "disabled",
                        true
                      );
                    },
                  });
                }
              });
            });

            // constraint is required to continue
            $(function () {
              $("#input_tenant_dsm_root_constraint").keyup(function () {
                if ($(this).val() == "") {
                  //Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_feeds_step2_test").prop(
                    "disabled",
                    true
                  );
                  $("#create_tenant_splk_feeds_step2").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "Hold On! A search constraint is required for Data Source Monitoring, you can include any valid indexed fields patterns",
                    "5"
                  );
                } else {
                  //If there is text in the input, then enable the button if other conditions are met
                  if (
                    $("#tenant_dsm_discovery").hasClass("btn-outline-danger")
                  ) {
                    var tenant_dsm_discovery_list_values = $(
                      "#tenant_dsm_discovery_list"
                    ).tagsinput("items");
                    if (tenant_dsm_discovery_list_values.length < 1) {
                      $("#create_tenant_splk_feeds_step2_test").prop(
                        "disabled",
                        true
                      );
                      $("#create_tenant_splk_feeds_step2").prop(
                        "disabled",
                        true
                      );
                    } else {
                      $("#create_tenant_splk_feeds_step2_test").prop(
                        "disabled",
                        false
                      );
                      $("#create_tenant_splk_feeds_step2").prop(
                        "disabled",
                        false
                      );
                    }
                  } else {
                    $("#create_tenant_splk_feeds_step2_test").prop(
                      "disabled",
                      false
                    );
                    $("#create_tenant_splk_feeds_step2").prop(
                      "disabled",
                      false
                    );
                  }
                }
              });
            });

            // help message
            $("#input_tenant_dsm_root_constraint").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can set any valid indexed field constraint for the tenant, only the data that can be returned via the root constraint will be taken into account for the discovery of entities",
                "10"
              );
            });

            // constraint is required to continue
            $(function () {
              $("#input_tenant_dhm_root_constraint").keyup(function () {
                if ($(this).val() == "") {
                  //Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_feeds_step3_test").prop(
                    "disabled",
                    true
                  );
                  $("#create_tenant_splk_feeds_step3").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "Hold On! A search constraint is required for Data Host Monitoring, you can include any valid indexed fields patterns",
                    "5"
                  );
                } else {
                  //If there is text in the input, then enable the button if other conditions are met
                  if (
                    $("#tenant_dhm_discovery").hasClass("btn-outline-danger")
                  ) {
                    var tenant_dhm_discovery_list_values = $(
                      "#tenant_dhm_discovery_list"
                    ).tagsinput("items");
                    if (tenant_dhm_discovery_list_values.length < 1) {
                      $("#create_tenant_splk_feeds_step3_test").prop(
                        "disabled",
                        true
                      );
                      $("#create_tenant_splk_feeds_step3").prop(
                        "disabled",
                        true
                      );
                    } else {
                      $("#create_tenant_splk_feeds_step3_test").prop(
                        "disabled",
                        false
                      );
                      $("#create_tenant_splk_feeds_step3").prop(
                        "disabled",
                        false
                      );
                    }
                  } else {
                    $("#create_tenant_splk_feeds_step3_test").prop(
                      "disabled",
                      false
                    );
                    $("#create_tenant_splk_feeds_step3").prop(
                      "disabled",
                      false
                    );
                  }
                }
              });
            });

            // help message
            $("#input_tenant_dhm_root_constraint").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can set any valid indexed field constraint for the tenant, only the data that can be returned via the root constraint will be taken into account for the discovery of entities",
                "10"
              );
            });

            // constraint is required to continue
            $(function () {
              $("#input_tenant_mhm_root_constraint").keyup(function () {
                if ($(this).val() == "") {
                  //Check to see if there is any text entered
                  // If there is no text within the input ten disable the button
                  $("#create_tenant_splk_feeds_step4_test").prop(
                    "disabled",
                    true
                  );
                  $("#create_tenant_splk_feeds_step5").prop("disabled", true);
                  notify(
                    "error",
                    "bottom",
                    "Hold On! A search constraint is required for Metric Host Monitoring, you can include any valid indexed fields patterns",
                    "5"
                  );
                } else {
                  //If there is text in the input, then enable the button if other conditions are met
                  if (
                    $("#tenant_mhm_discovery").hasClass("btn-outline-danger")
                  ) {
                    var tenant_mhm_discovery_list_values = $(
                      "#tenant_mhm_discovery_list"
                    ).tagsinput("items");
                    if (tenant_mhm_discovery_list_values.length < 1) {
                      $("#create_tenant_splk_feeds_step4_test").prop(
                        "disabled",
                        true
                      );
                      $("#create_tenant_splk_feeds_step5").prop(
                        "disabled",
                        true
                      );
                    } else {
                      $("#create_tenant_splk_feeds_step4_test").prop(
                        "disabled",
                        false
                      );
                      $("#create_tenant_splk_feeds_step5").prop(
                        "disabled",
                        false
                      );
                    }
                  } else {
                    $("#create_tenant_splk_feeds_step4_test").prop(
                      "disabled",
                      false
                    );
                    $("#create_tenant_splk_feeds_step5").prop(
                      "disabled",
                      false
                    );
                  }
                }
              });
            });

            $("#input_tenant_mhm_root_constraint").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can set any valid indexed field constraint for the tenant, only the data that can be returned via the root constraint will be taken into account for the discovery of entities",
                "10"
              );
            });

            //
            // DSM
            //

            // Show message
            $("#tenant_dsm_enabled").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can choose to enable (default) or disable a component, at least one component needs to be enabled for the tenant to be created",
                "10"
              );
            });

            // track changes on the components inputs
            $("#tenant_dsm_enabled").on("click", function () {
              if ($(this).hasClass("btn-outline-primary")) {
                $(this).toggleClass("btn-outline-primary btn-outline-danger");
                $(this).addClass("tenant_dsm_disabled");
                $(this).removeClass("tenant_dsm_enabled");
                $(this).text("SPLK-DSM is Disabled - click to enable");
                $("#input_tenant_dsm_root_constraint").prop("disabled", true);
                $("#input_tenant_dsm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  true
                );
                $("#btn_create_tenant_dsm_advanced_options").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_advanced_create_trackers").prop(
                  "disabled",
                  true
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Data Source Monitoring component will be disabled for this tenant.",
                  "5"
                );
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-primary");
                $(this).removeClass("tenant_dsm_disabled");
                $(this).addClass("tenant_dsm_enabled");
                $(this).text("SPLK-DSM is Enabled - click to disable");
                $("#input_tenant_dsm_root_constraint").prop("disabled", false);
                $("#input_tenant_dsm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  false
                );
                $("#btn_create_tenant_dsm_advanced_options").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_advanced_create_trackers").prop(
                  "disabled",
                  false
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Data Source Monitoring component will be enabled for this tenant.",
                  "5"
                );
              }
            });

            // show message
            $("#tenant_dsm_advanced_create_trackers").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Choose wether you want to use ouf the box tracker with the tenant, or if you want to start with a empty DSM tenant and create Hybrid or Elastic Sources as needed",
                  "10"
                );
              }
            );

            // track change
            $("#tenant_dsm_advanced_create_trackers").on("change", function () {
              currentValue = $(this).val();
              if (currentValue === "True") {
                setToken(
                  "tk_tenant_dsm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_dsm_root_constraint").prop("disabled", false);
                $("#input_tenant_dsm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_advanced_search_mode").prop("disabled", false);
                $("#tenant_dsm_advanced_mode").prop("disabled", false);
                $("#tenant_dsm_advanced_mode_earliest").prop("disabled", false);
                $("#tenant_dsm_advanced_mode_latest").prop("disabled", false);
                $("#tenant_dsm_advanced_mode_index_earliest").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_advanced_mode_index_latest").prop(
                  "disabled",
                  false
                );
                $("#tenant_dsm_advanced_mode_cron").prop("disabled", false);
                $("#tenant_dsm_advanced_tstats_root_span").prop(
                  "disabled",
                  false
                );
                $(
                  "#tenant_dsm_advanced_tstats_root_include_splunk_server"
                ).prop("disabled", false);
                $("#tenant_dsm_advanced_tstats_root_include_host").prop(
                  "disabled",
                  false
                );
              } else if (currentValue === "False") {
                setToken(
                  "tk_tenant_dsm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_dsm_root_constraint").prop("disabled", true);
                $("#input_tenant_dsm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_advanced_search_mode").prop("disabled", true);
                $("#tenant_dsm_advanced_mode").prop("disabled", true);
                $("#tenant_dsm_advanced_mode_earliest").prop("disabled", true);
                $("#tenant_dsm_advanced_mode_latest").prop("disabled", true);
                $("#tenant_dsm_advanced_mode_index_earliest").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_advanced_mode_index_latest").prop(
                  "disabled",
                  true
                );
                $("#tenant_dsm_advanced_mode_cron").prop("disabled", true);
                $("#tenant_dsm_advanced_tstats_root_span").prop(
                  "disabled",
                  true
                );
                $(
                  "#tenant_dsm_advanced_tstats_root_include_splunk_server"
                ).prop("disabled", true);
                $("#tenant_dsm_advanced_tstats_root_include_host").prop(
                  "disabled",
                  true
                );
                notify(
                  "success",
                  "bottom",
                  "SPLK-DSM: When creating without OOTB trackers, you can use Hybrid trackers and Elastic Sources trackers to match your exact needs.",
                  "5"
                );
              }
            });

            // show message
            $("#tenant_dsm_discovery").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The default behaviour is to discover data in every index reacheable from the root constraints, you can in addition restrict the indexes discovery using index patterns at any time of the tenant life cycle",
                "10"
              );
            });

            $("#tenant_dsm_discovery").on("click", function () {
              if ($(this).hasClass("btn-outline-info")) {
                $(this).toggleClass("btn-outline-info btn-outline-danger");
                $(this).text(
                  "Discovery is restricted - click to remove restrictions"
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be restricted for this tenant.",
                  "5"
                );
                $("#tenant_dsm_discovery_list").prop("disabled", false);
                $("#div_tenant_dsm_discovery_list").css("opacity", "100%");
                $("#create_tenant_splk_feeds_step2").prop("disabled", true);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  true
                );
                // create tokens
                defaultTokenModel.set("tk_tenant_dsm_discovery", "restricted");
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-info");
                $(this).text("Discovery is unrestricted - click to restrict");
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be unrestricted for this tenant.",
                  "5"
                );
                $("#tenant_dsm_discovery_list").prop("disabled", true);
                $("#div_tenant_dsm_discovery_list").css("opacity", "50%");
                $("#create_tenant_splk_feeds_step2").prop("disabled", false);
                $("#create_tenant_splk_feeds_step2_test").prop(
                  "disabled",
                  false
                );
                // create tokens
                defaultTokenModel.set(
                  "tk_tenant_dsm_discovery",
                  "unrestricted"
                );
              }
            });

            // Indexes discovery

            $("#tenant_dsm_discovery_list").on(
              "change keyup paste",
              function () {
                var values = $(this).tagsinput("items");
                defaultTokenModel.set("tk_tenant_dsm_discovery_list", values);
                // enable test now button if we have inputs
                if (values.length < 1) {
                  $("#create_tenant_splk_feeds_step2").prop("disabled", true);
                  $("#create_tenant_splk_feeds_step2_test").prop(
                    "disabled",
                    true
                  );
                } else {
                  $("#create_tenant_splk_feeds_step2").prop("disabled", false);
                  $("#create_tenant_splk_feeds_step2_test").prop(
                    "disabled",
                    false
                  );
                }
              }
            );

            // Test now button
            $("#create_tenant_splk_feeds_step2_test").on("click", function () {
              notify(
                "info",
                "bottom",
                "Hold on! Starting the verification search now, please wait...",
                "60"
              );

              // Get the Splunk account
              var tk_account = getToken("tk_splk_dsm_deployment");

              // Get tenant_dsm_root_constraint
              var tk_tenant_dsm_root_constraint = document.getElementById(
                "input_tenant_dsm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_dsm_discovery = getToken("tk_tenant_dsm_discovery");
              var tk_tenant_dsm_discovery_list = getToken(
                "tk_tenant_dsm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_dsm_discovery == "restricted") {
                tk_tenant_dsm_discovery_list =
                  'index="' +
                  tk_tenant_dsm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_dsm_discovery == "unrestricted") {
                tk_tenant_dsm_discovery_list = "(index=* OR index=_*)";
              } else {
                tk_tenant_dsm_discovery = "unrestricted";
                tk_tenant_dsm_discovery_list = "(index=* OR index=_*)";
              }

              // get dsm mode
              var tk_tenant_dsm_advanced_mode = document.getElementById(
                "tenant_dsm_advanced_mode"
              ).value;
              var tk_tenant_dsm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_dsm_advanced_mode_custom_fields"
                ).value;
              var tk_tenant_dsm_advanced_mode_custom_fields_include_st =
                document.getElementById(
                  "tenant_dsm_advanced_mode_custom_fields_include_st"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_dsm_root_constraint =
                tk_tenant_dsm_discovery_list +
                " " +
                tk_tenant_dsm_root_constraint;

              // init record
              var record = {
                run_simulation: false,
                component: "dsm",
                account: tk_account,
                search_mode: document.getElementById(
                  "tenant_dsm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_latest"
                ).value,
                cron_schedule: document.getElementById(
                  "tenant_dsm_advanced_mode_cron"
                ).value,
                index_earliest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_index_earliest"
                ).value,
                index_latest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_index_latest"
                ).value,
                search_constraint: tk_tenant_dsm_root_constraint,
              };

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_dsm_advanced_mode == "split") {
                breakby_field = "none";
                // add to record
                record["breakby_field"] = breakby_field;
              } else if (tk_tenant_dsm_advanced_mode == "merged") {
                breakby_field = "merged";
                // add to record
                record["breakby_field"] = breakby_field;
              } else {
                breakby_field = tk_tenant_dsm_advanced_mode_custom_fields;

                // convert to an array
                breakby_field_array = breakby_field.split(",");

                // remove index if present
                if (breakby_field_array.includes("index")) {
                  breakby_field_array.splice(
                    breakby_field_array.indexOf("index"),
                    1
                  ); //deleting
                }

                // remove sourcetype if present
                if (breakby_field_array.includes("sourcetype")) {
                  breakby_field_array.splice(
                    breakby_field_array.indexOf("sourcetype"),
                    1
                  ); //deleting
                }

                // convert back
                breakby_field = String(breakby_field_array);

                // add to record
                record["breakby_field"] = breakby_field;

                // add breakby_field_include_sourcetype
                record["breakby_field_include_sourcetype"] =
                  tk_tenant_dsm_advanced_mode_custom_fields_include_st;
              }

              // Retrieve entity info from REST and set actions
              $.ajax({
                url: getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/splk_hybrid_trackers/admin/hybrid_tracker_simulation"
                ),
                type: "POST",
                async: true,
                contentType: "application/json",
                data: JSON.stringify(record),
                success: function (returneddata) {
                  // get the search definition
                  simulation_search = returneddata["tracker_simulation_search"];
                  // get the search earliest time
                  simulation_earliest_time = returneddata["earliest_time"];
                  // get the search latest time
                  simulation_latest_time = returneddata["latest_time"];

                  // set tokens
                  setToken("tk_splk_dsm_simulation_search", simulation_search);
                  setToken(
                    "tk_splk_dsm_simulation_earliest",
                    simulation_earliest_time
                  );
                  setToken(
                    "tk_splk_dsm_simulation_latest",
                    simulation_latest_time
                  );

                  // start the search
                  searchSplkDsmSimulation.startSearch();

                  // show the div
                  $("#divSplkDsmSimulation").css("display", "inherit");
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });
            });

            // advanced configuration

            // on over
            $("#tenant_dsm_advanced_search_mode").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ For best performances at the lowest computing costs, use tstats mode in priority, raw can be a good fit for well scoped use cases as it allows using any kind of fields (while tstats required all fields to be indexed)",
                "5"
              );
            });

            // on over
            $("#tenant_dsm_advanced_mode").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The splk-dsm component tracks entities by index/sourcetype by default, however you can as well either track data for the whole index or use a custom additional field which properly describe concepts like pipelines, companies etc...",
                "5"
              );
            });

            // on over
            $("#tenant_dsm_advanced_mode_custom_fields").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Define a comma separated list of fields to be taken into account for the break by sequence when identifying entities, in tstats mode all fields must be indexed fields, in raw mode fields can be indexed or search time extracted fields.",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dsm_advanced_mode_custom_fields_include_st").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ When the custom fields include sourcetype is enabled, the sourcetype field will be included in the break by sequence, if it disabled, the sourcetype is not taken into account and replace with a pattern of any, in which case any sourcetype will be taken into account in the scope of associated entities.",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dsm_advanced_mode_earliest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The earliest time quantifier for the hybrid tracker, this scopes how far in the past the tracker will look for upstream data for the main hybrid tracker workflow, 7 days in the past is a good catch for most of the use cases",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dsm_advanced_mode_latest").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The latest time quantifier for the hybrid tracker, make sure to set a latest time in the future to be able to detect data suspiciously in the future",
                "5"
              );
            });

            // on over
            $("#tenant_dsm_advanced_mode_cron").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The cron schedule for the tracker, usually defaults to every 5 minutes, TrackMe applies a randomization of the cron schedule to dispatch searches for optimization purposes",
                "5"
              );
            });

            // on over
            $("#tenant_dsm_advanced_mode_index_earliest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The earliest indexed time quantifier for the hybrid tracker, this scopes how far in the past, from the indexed time perspective, the tracker will look for upstream data for the main hybrid tracker workflow, 4 hours in the past is a good catch for most of the use cases",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dsm_advanced_mode_index_latest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The latest time quantifier for the hybrid tracker, make sure to set a latest time in the future to be able to detect data suspiciously in the future",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dsm_advanced_data_sampling_obfuscation").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ When the data sampling obfuscation mode is enabled, events stored in a non readable fashion such that raw events cannot be read by anyone, including high privileged users",
                  "5"
                );
              }
            );

            // monitor for the mode selected
            $(function () {
              $("#tenant_dsm_advanced_mode").change(function () {
                // set the token in any case
                setToken("tk_tenant_dsm_advanced_mode", $(this).val());
                if ($(this).val() == "split") {
                  $("#tenant_dsm_advanced_mode_custom_fields").prop(
                    "disabled",
                    true
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields_include_st").prop(
                    "disabled",
                    true
                  );
                  notify(
                    "info",
                    "bottom",
                    'ℹ️ In split mode, entities are created automatically based on the combination of the index + ":" + sourcetype, you will get as many entities as there are sourcestypes searcheable per index',
                    "5"
                  );
                  // css hide div id div_tenant_dsm_advanced_mode_custom_fields_include_st
                  $(
                    "#div_tenant_dsm_advanced_mode_custom_fields_include_st"
                  ).attr("style", "display: none");
                  $("#label_tenant_dsm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields").val("none");
                } else if ($(this).val() == "merged") {
                  $("#tenant_dsm_advanced_mode_custom_fields").prop(
                    "disabled",
                    true
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields_include_st").prop(
                    "disabled",
                    true
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In merged mode, data sources represent all sourcestypes available on a per index basis in respect with constraints parameters, you will get as many entities as there are indexes seacheable",
                    "5"
                  );
                  // css hide div id div_tenant_dsm_advanced_mode_custom_fields_include_st
                  $(
                    "#div_tenant_dsm_advanced_mode_custom_fields_include_st"
                  ).attr("style", "display: none");
                  $("#label_tenant_dsm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields").val("none");
                } else if ($(this).val() == "custom") {
                  $("#tenant_dsm_advanced_mode_custom_fields").prop(
                    "disabled",
                    false
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields_include_st").prop(
                    "disabled",
                    false
                  );
                  // css hide div id div_tenant_dsm_advanced_mode_custom_fields_include_st
                  $(
                    "#div_tenant_dsm_advanced_mode_custom_fields_include_st"
                  ).attr("style", "display: inherit");
                  $("#label_tenant_dsm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 100%"
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In custom mode, you need to specify a custom field that will be used in the break by logic, this field needs to be an indexed field if running in tstats mode, and either a search time or indexed time in raw mode.",
                    "5"
                  );
                  $("#tenant_dsm_advanced_mode_custom_fields").val("");
                } else {
                  // block - should not be reached
                  "#tenant_dsm_advanced_mode_custom_fields".prop(
                    "disabled",
                    trye
                  );
                  // css hide div id div_tenant_dsm_advanced_mode_custom_fields_include_st
                  $(
                    "#div_tenant_dsm_advanced_mode_custom_fields_include_st"
                  ).attr("style", "display: none");
                  $("#label_tenant_dsm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                }
              });
            });

            //
            // DHM
            //

            // show message
            $("#tenant_dhm_advanced_create_trackers").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Choose wether you want to use ouf the box tracker with the tenant, or if you want to start with a empty DHM tenant and create Hybrid trackers as needed",
                  "10"
                );
              }
            );

            // track change
            $("#tenant_dhm_advanced_create_trackers").on("change", function () {
              currentValue = $(this).val();
              if (currentValue === "True") {
                setToken(
                  "tk_tenant_dhm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_dhm_root_constraint").prop("disabled", false);
                $("#input_tenant_dhm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_advanced_search_mode").prop("disabled", false);
                $("#tenant_dhm_advanced_mode").prop("disabled", false);
                $("#tenant_dhm_advanced_mode_earliest").prop("disabled", false);
                $("#tenant_dhm_advanced_mode_latest").prop("disabled", false);
                $("#tenant_dhm_advanced_mode_index_earliest").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_advanced_mode_index_latest").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_advanced_mode_cron").prop("disabled", false);
                $("#tenant_dhm_advanced_tstats_root_span").prop(
                  "disabled",
                  false
                );
                $(
                  "#tenant_dhm_advanced_tstats_root_include_splunk_server"
                ).prop("disabled", false);
              } else if (currentValue === "False") {
                setToken(
                  "tk_tenant_dhm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_dhm_root_constraint").prop("disabled", true);
                $("#input_tenant_dhm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_advanced_search_mode").prop("disabled", true);
                $("#tenant_dhm_advanced_mode").prop("disabled", true);
                $("#tenant_dhm_advanced_mode_index_earliest").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_advanced_mode_index_latest").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_advanced_mode_cron").prop("disabled", true);
                $("#tenant_dhm_advanced_tstats_root_span").prop(
                  "disabled",
                  true
                );
                $(
                  "#tenant_dhm_advanced_tstats_root_include_splunk_server"
                ).prop("disabled", true);
                notify(
                  "success",
                  "bottom",
                  "SPLK-DHM: When creating without OOTB trackers, you can use Hybrid trackers to match your exact needs.",
                  "5"
                );
              }
            });

            $(function () {
              $("#tenant_dhm_advanced_mode").change(function () {
                // set the token in any case
                setToken("tk_tenant_dhm_advanced_mode", $(this).val());
                if ($(this).val() == "host") {
                  $("#tenant_dhm_advanced_mode_custom_fields").prop(
                    "disabled",
                    true
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In host mode, entities are created automatically based on the host metadata, you will get as many entities as there are hosts searcheable for the data scope",
                    "5"
                  );
                  $("#label_tenant_dhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                  $("#tenant_dhm_advanced_mode_custom_fields").val("none");
                } else if ($(this).val() == "custom") {
                  $("#tenant_dhm_advanced_mode_custom_fields").prop(
                    "disabled",
                    false
                  );
                  $("#label_tenant_dhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 100%"
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In custom mode, you need to specify a custom field that will be used in the break by logic, this field needs to be an indexed field if running in tstats mode, and either a search time or indexed time in raw mode.",
                    "5"
                  );
                  $("#tenant_dhm_advanced_mode_custom_fields").val("");
                } else {
                  // block - should not be reached
                  "#tenant_dhm_advanced_mode_custom_fields".prop(
                    "disabled",
                    trye
                  );
                  $("#label_tenant_dhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                }
              });
            });

            // Advanced

            // on over
            $("#tenant_dhm_advanced_search_mode").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ For best performances at the lowest computing costs, use tstats mode in priority, raw can be a good fit for well scoped use cases as it allows using any kind of fields (while tstats required all fields to be indexed)",
                "5"
              );
            });

            // on over
            $("#tenant_dhm_advanced_mode").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The splk-dhm component by default tracks data relying on the host Metadata, however you can as well use a custom break by field to change this behaviour and use this key for the breakby statement instead",
                "5"
              );
            });

            // on over
            $("#tenant_dhm_advanced_mode_earliest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The earliest time quantifier for the hybrid tracker, this scopes how far in the past the tracker will look for upstream data for the main hybrid tracker workflow, 7 days in the past is a good catch for most of the use cases",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dhm_advanced_mode_latest").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The latest time quantifier for the hybrid tracker, make sure to set a latest time in the future to be able to detect data suspiciously in the future",
                "5"
              );
            });

            // on over
            $("#tenant_dhm_advanced_mode_cron").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The cron schedule for the tracker, usually defaults to every 5 minutes, TrackMe applies a randomization of the cron schedule to dispatch searches for optimization purposes",
                "5"
              );
            });

            // on over
            $("#tenant_dhm_advanced_mode_index_earliest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The earliest indexed time quantifier for the hybrid tracker, this scopes how far in the past, from the indexed time perspective, the tracker will look for upstream data for the main hybrid tracker workflow, 4 hours in the past is a good catch for most of the use cases",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dhm_advanced_mode_index_latest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The latest time quantifier for the hybrid tracker, make sure to set a latest time in the future to be able to detect data suspiciously in the future",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_dhm_advanced_alerting_policy").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ When data host alerting per host is set, a monitored host will change its status only when there no more sourcetype meeting the monitoring rules, while when data host alerting per sourcetype is set, a monitored host will change its status if any sourcetype does not meet the monitoring rules",
                  "5"
                );
              }
            );

            //
            // MHM
            //

            // show message
            $("#tenant_mhm_advanced_create_trackers").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ Choose wether you want to use ouf the box tracker with the tenant, or if you want to start with a empty MHM tenant and create Hybrid trackers as needed",
                  "10"
                );
              }
            );

            // track change
            $("#tenant_mhm_advanced_create_trackers").on("change", function () {
              currentValue = $(this).val();
              if (currentValue === "True") {
                setToken(
                  "tk_tenant_mhm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_mhm_root_constraint").prop("disabled", false);
                $("#input_tenant_mhm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_mhm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  false
                );
                $("#tenant_mhm_advanced_search_mode").prop("disabled", false);
                $("#tenant_mhm_advanced_mode").prop("disabled", false);
                $("#tenant_mhm_advanced_mode_earliest").prop("disabled", false);
                $("#tenant_mhm_advanced_mode_latest").prop("disabled", false);
                $("#tenant_mhm_advanced_mode_cron").prop("disabled", false);
              } else if (currentValue === "False") {
                setToken(
                  "tk_tenant_mhm_advanced_create_trackers",
                  currentValue
                );
                $("#input_tenant_mhm_root_constraint").prop("disabled", true);
                $("#input_tenant_mhm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_mhm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  true
                );
                $("#tenant_mhm_advanced_search_mode").prop("disabled", true);
                $("#tenant_mhm_advanced_mode").prop("disabled", true);
                $("#tenant_mhm_advanced_mode_earliest").prop("disabled", true);
                $("#tenant_mhm_advanced_mode_latest").prop("disabled", true);
                $("#tenant_mhm_advanced_mode_cron").prop("disabled", true);
                notify(
                  "success",
                  "bottom",
                  "SPLK-MHM: When creating without OOTB trackers, you can use Hybrid trackers to match your exact needs.",
                  "5"
                );
              }
            });

            $(function () {
              $("#tenant_mhm_advanced_mode").change(function () {
                // set the token in any case
                setToken("tk_tenant_mhm_advanced_mode", $(this).val());
                if ($(this).val() == "host") {
                  $("#tenant_mhm_advanced_mode_custom_fields").prop(
                    "disabled",
                    true
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In host mode, entities are created automatically based on the host dimension, you will get as many entities as there are hosts searcheable for the metric scope",
                    "5"
                  );
                  $("#label_tenant_mhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                  $("#tenant_mhm_advanced_mode_custom_fields").val("none");
                } else if ($(this).val() == "custom") {
                  $("#tenant_mhm_advanced_mode_custom_fields").prop(
                    "disabled",
                    false
                  );
                  $("#label_tenant_mhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 100%"
                  );
                  notify(
                    "info",
                    "bottom",
                    "ℹ️ In custom mode, you need to specify a custom dimension field that will be used in the break by logic.",
                    "5"
                  );
                  $("#tenant_mhm_advanced_mode_custom_fields").val("");
                } else {
                  // block - should not be reached
                  "#tenant_mhm_advanced_mode_custom_fields".prop(
                    "disabled",
                    trye
                  );
                  $("#label_tenant_mhm_advanced_mode_custom_fields").attr(
                    "style",
                    "opacity: 50%"
                  );
                }
              });
            });

            // Advanced

            // on over
            $("#tenant_mhm_advanced_mode").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The splk-mhm component by default tracks metrics relying on the host dimension, however you can as well use a custom break by field to change this behaviour and use this key for the breakby dimension instead",
                "5"
              );
            });

            // on over
            $("#tenant_mhm_advanced_mode_earliest").on(
              "mouseover",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ The earliest time quantifier for the hybrid tracker, this scopes how far in the past the tracker will look for upstream metrics, in the context of this component, the earliest time should remain restricted to relatively limited time ranges",
                  "5"
                );
              }
            );

            // on over
            $("#tenant_mhm_advanced_mode_latest").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The latest time quantifier for the hybrid tracker, make sure to set a latest time in the future to be able to detect metrics suspiciously in the future",
                "5"
              );
            });

            // on over
            $("#tenant_mhm_advanced_mode_cron").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The cron schedule for the tracker, usually defaults to every 5 minutes, TrackMe applies a randomization of the cron schedule to dispatch searches for optimization purposes",
                "5"
              );
            });

            //
            //
            //

            // Show message
            $("#tenant_dhm_enabled").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can choose to enable (default) or disable a component, at least one component needs to be enabled for the tenant to be created",
                "10"
              );
            });

            // track changes on the components inputs
            $("#tenant_dhm_enabled").on("click", function () {
              if ($(this).hasClass("btn-outline-primary")) {
                $(this).toggleClass("btn-outline-primary btn-outline-danger");
                $(this).addClass("tenant_dhm_disabled");
                $(this).removeClass("tenant_dhm_enabled");
                $(this).text("SPLK-DHM is Disabled - click to enable");
                $("#input_tenant_dhm_root_constraint").prop("disabled", true);
                $("#input_tenant_dhm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  true
                );
                $("#btn_create_tenant_dhm_advanced_options").prop(
                  "disabled",
                  true
                );
                $("#tenant_dhm_advanced_create_trackers").prop(
                  "disabled",
                  true
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Data Host Monitoring component will be disabled for this tenant.",
                  "5"
                );
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-primary");
                $(this).removeClass("tenant_dhm_disabled");
                $(this).addClass("tenant_dhm_enabled");
                $(this).text("SPLK-DHM is Enabled - click to disable");
                $("#input_tenant_dhm_root_constraint").prop("disabled", false);
                $("#input_tenant_dhm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  false
                );
                $("#btn_create_tenant_dhm_advanced_options").prop(
                  "disabled",
                  false
                );
                $("#tenant_dhm_advanced_create_trackers").prop(
                  "disabled",
                  false
                );
                // preset the value of id tenant_dhm_advanced_tstats_root_span to 1m
                $("#tenant_dhm_advanced_tstats_root_span").val("1m");
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Data Host Monitoring component will be enabled for this tenant.",
                  "5"
                );
              }
            });

            // show message
            $("#tenant_dhm_discovery").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The default behaviour is to discover data in every index reacheable from the root constraints, you can in addition restrict the indexes discovery using index patterns at any time of the tenant life cycle",
                "10"
              );
            });

            $("#tenant_dhm_discovery").on("click", function () {
              if ($(this).hasClass("btn-outline-info")) {
                $(this).toggleClass("btn-outline-info btn-outline-danger");
                $(this).text(
                  "Discovery is restricted - click to remove restrictions"
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be restricted for this tenant.",
                  "5"
                );
                $("#tenant_dhm_discovery_list").prop("disabled", false);
                $("#div_tenant_dhm_discovery_list").css("opacity", "100%");
                $("#create_tenant_splk_feeds_step3").prop("disabled", true);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  true
                );
                // create tokens
                defaultTokenModel.set("tk_tenant_dhm_discovery", "restricted");
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-info");
                $(this).text("Discovery is unrestricted - click to restrict");
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be unrestricted for this tenant.",
                  "5"
                );
                $("#tenant_dhm_discovery_list").prop("disabled", true);
                $("#div_tenant_dhm_discovery_list").css("opacity", "50%");
                $("#create_tenant_splk_feeds_step3").prop("disabled", false);
                $("#create_tenant_splk_feeds_step3_test").prop(
                  "disabled",
                  false
                );
                // create tokens
                defaultTokenModel.set(
                  "tk_tenant_dhm_discovery",
                  "unrestricted"
                );
              }
            });

            // Indexes discovery

            $("#tenant_dhm_discovery_list").on(
              "change keyup paste",
              function () {
                var values = $(this).tagsinput("items");
                defaultTokenModel.set("tk_tenant_dhm_discovery_list", values);
                // enable test now button if we have inputs
                if (values.length < 1) {
                  $("#create_tenant_splk_feeds_step3").prop("disabled", true);
                  $("#create_tenant_splk_feeds_step3_test").prop(
                    "disabled",
                    true
                  );
                } else {
                  $("#create_tenant_splk_feeds_step3").prop("disabled", false);
                  $("#create_tenant_splk_feeds_step3_test").prop(
                    "disabled",
                    false
                  );
                }
              }
            );

            // Test now button
            $("#create_tenant_splk_feeds_step3_test").on("click", function () {
              notify(
                "info",
                "bottom",
                "Hold on! Starting the verification search now, please wait...",
                "60"
              );

              // Get the Splunk account
              var tk_account = getToken("tk_splk_dhm_deployment");

              // Get tenant_dhm_root_constraint
              var tk_tenant_dhm_root_constraint = document.getElementById(
                "input_tenant_dhm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_dhm_discovery = getToken("tk_tenant_dhm_discovery");
              var tk_tenant_dhm_discovery_list = getToken(
                "tk_tenant_dhm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_dhm_discovery == "restricted") {
                tk_tenant_dhm_discovery_list =
                  'index="' +
                  tk_tenant_dhm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_dhm_discovery == "unrestricted") {
                tk_tenant_dhm_discovery_list = "(index=* OR index=_*)";
              } else {
                tk_tenant_dhm_discovery = "unrestricted";
                tk_tenant_dhm_discovery_list = "(index=* OR index=_*)";
              }

              // get dhm mode
              var tk_tenant_dhm_advanced_mode = document.getElementById(
                "tenant_dhm_advanced_mode"
              ).value;
              var tk_tenant_dhm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_dhm_advanced_mode_custom_fields"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_dhm_root_constraint =
                tk_tenant_dhm_discovery_list +
                " " +
                tk_tenant_dhm_root_constraint;

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_dhm_advanced_mode == "split") {
                breakby_field = "none";
              } else if (tk_tenant_dhm_advanced_mode == "merged") {
                breakby_field = "merged";
              } else {
                breakby_field = tk_tenant_dhm_advanced_mode_custom_fields;
              }

              var record = {
                run_simulation: true,
                component: "dhm",
                account: tk_account,
                search_mode: document.getElementById(
                  "tenant_dhm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_latest"
                ).value,
                index_earliest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_earliest"
                ).value,
                index_latest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_latest"
                ).value,
                search_constraint: tk_tenant_dhm_root_constraint,
                breakby_field: breakby_field,
              };

              // spinner
              $("#cssloader").remove();
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
              );

              // Retrieve entity info from REST and set actions
              $.ajax({
                url: getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/splk_hybrid_trackers/admin/hybrid_tracker_simulation"
                ),
                type: "POST",
                async: true,
                contentType: "application/json",
                data: JSON.stringify(record),
                success: function (returneddata) {
                  // get the search definition
                  simulation_search = returneddata["tracker_simulation_search"];
                  // get the search earliest time
                  simulation_earliest_time = returneddata["earliest_time"];
                  // get the search latest time
                  simulation_latest_time = returneddata["latest_time"];

                  // set tokens
                  setToken("tk_splk_dhm_simulation_search", simulation_search);
                  setToken(
                    "tk_splk_dhm_simulation_earliest",
                    simulation_earliest_time
                  );
                  setToken(
                    "tk_splk_dhm_simulation_latest",
                    simulation_latest_time
                  );

                  // start the search
                  searchSplkDhmSimulation.startSearch();

                  // show the div
                  $("#divSplkDhmSimulation").css("display", "inherit");
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });
            });

            //
            // MHM
            //

            // Show message
            $("#tenant_mhm_enabled").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ You can choose to enable (default) or disable a component, at least one component needs to be enabled for the tenant to be created",
                "10"
              );
            });

            // track changes on the components inputs
            $("#tenant_mhm_enabled").on("click", function () {
              if ($(this).hasClass("btn-outline-primary")) {
                $(this).toggleClass("btn-outline-primary btn-outline-danger");
                $(this).addClass("tenant_mhm_disabled");
                $(this).removeClass("tenant_mhm_enabled");
                $(this).text("SPLK-MHM is Disabled - click to enable");
                $("#input_tenant_mhm_root_constraint").prop("disabled", true);
                $("#input_tenant_mhm_restrict_discovery").prop(
                  "disabled",
                  true
                );
                $("#tenant_mhm_discovery").prop("disabled", true);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  true
                );
                $("#btn_create_tenant_mhm_advanced_options").prop(
                  "disabled",
                  true
                );
                $("#tenant_mhm_advanced_create_trackers").prop(
                  "disabled",
                  true
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Metric Host Monitoring component will be disabled for this tenant.",
                  "5"
                );
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-primary");
                $(this).removeClass("tenant_mhm_disabled");
                $(this).addClass("tenant_mhm_enabled");
                $(this).text("SPLK-MHM is Enabled - click to disable");
                $("#input_tenant_mhm_root_constraint").prop("disabled", false);
                $("#input_tenant_mhm_restrict_discovery").prop(
                  "disabled",
                  false
                );
                $("#tenant_mhm_discovery").prop("disabled", false);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  false
                );
                $("#btn_create_tenant_mhm_advanced_options").prop(
                  "disabled",
                  false
                );
                $("#tenant_mhm_advanced_create_trackers").prop(
                  "disabled",
                  false
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Metric Host Monitoring component will be enabled for this tenant.",
                  "5"
                );
              }
            });

            // show message
            $("#tenant_mhm_discovery").on("mouseover", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ The default behaviour is to discover data in every index reacheable from the root constraints, you can in addition restrict the indexes discovery using index patterns at any time of the tenant life cycle",
                "10"
              );
            });

            $("#tenant_mhm_discovery").on("click", function () {
              if ($(this).hasClass("btn-outline-info")) {
                $(this).toggleClass("btn-outline-info btn-outline-danger");
                $(this).text(
                  "Discovery is restricted - click to remove restrictions"
                );
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be restricted for this tenant.",
                  "5"
                );
                $("#tenant_mhm_discovery_list").prop("disabled", false);
                $("#div_tenant_mhm_discovery_list").css("opacity", "100%");
                $("#create_tenant_splk_feeds_step5").prop("disabled", true);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  true
                );
                // create tokens
                defaultTokenModel.set("tk_tenant_mhm_discovery", "restricted");
              } else if ($(this).hasClass("btn-outline-danger")) {
                $(this).toggleClass("btn-outline-danger btn-outline-info");
                $(this).text("Discovery is unrestricted - click to restrict");
                $(this).blur();
                notify(
                  "success",
                  "bottom",
                  "Indexes discovery will be unrestricted for this tenant.",
                  "5"
                );
                $("#tenant_mhm_discovery_list").prop("disabled", true);
                $("#div_tenant_mhm_discovery_list").css("opacity", "50%");
                $("#create_tenant_splk_feeds_step5").prop("disabled", false);
                $("#create_tenant_splk_feeds_step4_test").prop(
                  "disabled",
                  false
                );
                // create tokens
                defaultTokenModel.set(
                  "tk_tenant_mhm_discovery",
                  "unrestricted"
                );
              }
            });

            // Indexes discovery

            $("#tenant_mhm_discovery_list").on(
              "change keyup paste",
              function () {
                var values = $(this).tagsinput("items");
                defaultTokenModel.set("tk_tenant_mhm_discovery_list", values);
                // enable test now button if we have inputs
                if (values.length < 1) {
                  $("#create_tenant_splk_feeds_step5").prop("disabled", true);
                  $("#create_tenant_splk_feeds_step4_test").prop(
                    "disabled",
                    true
                  );
                } else {
                  $("#create_tenant_splk_feeds_step5").prop("disabled", false);
                  $("#create_tenant_splk_feeds_step4_test").prop(
                    "disabled",
                    false
                  );
                }
              }
            );

            // Test now button
            $("#create_tenant_splk_feeds_step4_test").on("click", function () {
              notify(
                "info",
                "bottom",
                "Hold on! Starting the verification search now, please wait...",
                "60"
              );

              // Get the Splunk account
              var tk_account = getToken("tk_splk_mhm_deployment");

              // Get tenant_mhm_root_constraint
              var tk_tenant_mhm_root_constraint = document.getElementById(
                "input_tenant_mhm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_mhm_discovery = getToken("tk_tenant_mhm_discovery");
              var tk_tenant_mhm_discovery_list = getToken(
                "tk_tenant_mhm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_mhm_discovery == "restricted") {
                tk_tenant_mhm_discovery_list =
                  'index="' +
                  tk_tenant_mhm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_mhm_discovery == "unrestricted") {
                tk_tenant_mhm_discovery_list = "(index=* OR index=_*)";
              } else {
                tk_tenant_mhm_discovery = "unrestricted";
                tk_tenant_mhm_discovery_list = "(index=* OR index=_*)";
              }

              // get mhm mode
              var tk_tenant_mhm_advanced_mode = document.getElementById(
                "tenant_mhm_advanced_mode"
              ).value;
              var tk_tenant_mhm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_mhm_advanced_mode_custom_fields"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_mhm_root_constraint =
                tk_tenant_mhm_discovery_list +
                " " +
                tk_tenant_mhm_root_constraint;

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_mhm_advanced_mode == "split") {
                breakby_field = "none";
              } else if (tk_tenant_mhm_advanced_mode == "merged") {
                breakby_field = "merged";
              } else {
                breakby_field = tk_tenant_mhm_advanced_mode_custom_fields;
              }

              var record = {
                run_simulation: true,
                component: "mhm",
                account: tk_account,
                search_mode: document.getElementById(
                  "tenant_mhm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_mhm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_mhm_advanced_mode_latest"
                ).value,
                cron_schedule: document.getElementById(
                  "tenant_mhm_advanced_mode_cron"
                ).value,
                search_constraint: tk_tenant_mhm_root_constraint,
                breakby_field: breakby_field,
              };

              // spinner
              $("#cssloader").remove();
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while we are running some Splunky searches..."></div>'
              );

              // Retrieve entity info from REST and set actions
              $.ajax({
                url: getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/splk_hybrid_trackers/admin/hybrid_tracker_simulation"
                ),
                type: "POST",
                async: true,
                contentType: "application/json",
                data: JSON.stringify(record),
                success: function (returneddata) {
                  // get the search definition
                  simulation_search = returneddata["tracker_simulation_search"];
                  // get the search earliest time
                  simulation_earliest_time = returneddata["earliest_time"];
                  // get the search latest time
                  simulation_latest_time = returneddata["latest_time"];

                  // set tokens
                  setToken("tk_splk_mhm_simulation_search", simulation_search);
                  setToken(
                    "tk_splk_mhm_simulation_earliest",
                    simulation_earliest_time
                  );
                  setToken(
                    "tk_splk_mhm_simulation_latest",
                    simulation_latest_time
                  );

                  // start the search
                  searchSplkMhmSimulation.startSearch();

                  // show the div
                  $("#divSplkMhmSimulation").css("display", "inherit");
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });
            });

            //
            // COMPONENTS ENABLED VERIFICATIONS
            //

            // At step 4 of the tenant creation, we need to verify that at least one component was enabled
            $("#create_tenant_splk_feeds_step4")
              .unbind()
              .click(function () {
                // Get tenant_dsm_enabled
                var tk_tenant_dsm_enabled;
                if ($("#tenant_dsm_enabled").is(".tenant_dsm_enabled")) {
                  tk_tenant_dsm_enabled = true;
                } else {
                  tk_tenant_dsm_enabled = false;
                }

                // Get tenant_dhm_enabled
                var tk_tenant_dhm_enabled;
                if ($("#tenant_dhm_enabled").is(".tenant_dhm_enabled")) {
                  tk_tenant_dhm_enabled = true;
                } else {
                  tk_tenant_dhm_enabled = false;
                }

                // Get tenant_mhm_enabled
                var tk_tenant_mhm_enabled;
                if ($("#tenant_mhm_enabled").is(".tenant_mhm_enabled")) {
                  tk_tenant_mhm_enabled = true;
                } else {
                  tk_tenant_mhm_enabled = false;
                }

                if (
                  !tk_tenant_dsm_enabled &&
                  !tk_tenant_dhm_enabled &&
                  !tk_tenant_mhm_enabled
                ) {
                  var errorStr =
                    "At least one component needs to be enabled for the tenant to be created, components that can be enabled are: Data Source Monitoring / Data Host Monitoring / Metric Host Monitoring";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_feeds_main4"
                  );

                  $("#modal_create_tenant_splk_feeds_main5").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_feeds_main4"
                  );
                  $("#modal_create_tenant_splk_feeds_main5").modal();
                }
              });

            //
            // RBAC INPUTS VERIFICATIONS
            //

            // Verify RBAC input

            //
            // splk-feeds
            //

            $("#create_tenant_splk_feeds_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_feeds"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_feeds"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_feeds"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_power.length < 1 ||
                  tk_tenant_roles_power == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute("href", "#modal_create_tenant_main5");

                  $("#modal_create_tenant_splk_feeds_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute("href", "#modal_create_tenant_main5");
                  $("#modal_create_tenant_splk_feeds_confirm").modal();
                }
              });

            //
            // splk-cim
            //

            $("#create_tenant_splk_cim_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_cim"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_cim"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_cim"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_power.length < 1 ||
                  tk_tenant_roles_power == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_cim_main3"
                  );

                  $("#modal_create_tenant_splk_cim_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_cim_main3"
                  );
                  $("#modal_create_tenant_splk_cim_confirm").modal();
                }
              });

            //
            // splk-flx
            //

            $("#create_tenant_splk_flx_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_flx"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_flx"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_flx"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_power.length < 1 ||
                  tk_tenant_roles_power == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_flx_main3"
                  );

                  $("#modal_create_tenant_splk_flx_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_flx_main3"
                  );
                  $("#modal_create_tenant_splk_flx_confirm").modal();
                }
              });

            //
            // splk-fqm
            //

            $("#create_tenant_splk_fqm_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_fqm"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_fqm"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_fqm"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_power.length < 1 ||
                  tk_tenant_roles_power == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_fqm_main3"
                  );

                  $("#modal_create_tenant_splk_fqm_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_fqm_main3"
                  );
                  $("#modal_create_tenant_splk_fqm_confirm").modal();
                }
              });

            //
            // splk-replica
            //

            $("#create_tenant_splk_replica_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_replica"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_replica"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_replica"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_power.length < 1 ||
                  tk_tenant_roles_power == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_replica_main3"
                  );

                  $("#modal_create_tenant_splk_replica_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_replica_main3"
                  );
                  $("#modal_create_tenant_splk_replica_confirm").modal();
                }
              });

            // Vendor components
            $("#btn_start_create_tenant").on("click", function () {
              // check licensing
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the number of active tenants
                var license_is_valid = licenseCall["license_is_valid"];
                var license_active_tenants =
                  licenseCall["license_active_tenants"];
                var license_subscription_class =
                  licenseCall["license_subscription_class"];

                // proceed
                if (license_active_tenants >= 2 && license_is_valid != 1) {
                  $("#modal_licensing_max_tenants")
                    .find(".modal-info-message p")
                    .text(
                      "There are " +
                        license_active_tenants +
                        " active tenants and this deployment is currently running in Free limited edition mode. The Free limited edition mode is limited to 2 active tenants at a time." +
                        " To create a new tenant, you can disable or delete an existing tenant, register a valid license or start a Trial period."
                    );
                  closeModals();
                  $("#modal_licensing_max_tenants").modal();
                } else if (
                  license_active_tenants >= 2 &&
                  license_subscription_class == "free_extended"
                ) {
                  $("#modal_licensing_max_tenants")
                    .find(".modal-info-message p")
                    .text(
                      "There are " +
                        license_active_tenants +
                        " active tenants and this deployment is currently running in Free extended edition mode. The Free extended edition mode is limited to 2 active tenants at a time." +
                        " To create a new tenant, you can disable or delete an existing tenant, register a valid license or start a Trial period."
                    );
                  closeModals();
                  $("#modal_licensing_max_tenants").modal();
                } else if (
                  license_active_tenants >= 6 &&
                  license_subscription_class == "enterprise"
                ) {
                  $("#modal_licensing_max_tenants")
                    .find(".modal-info-message p")
                    .text(
                      "There are " +
                        license_active_tenants +
                        " active tenants and this deployment is currently running in Enterprise edition mode. The Enterprise limited edition mode is limited to 6 active tenants at a time." +
                        " To create a new tenant, you can disable or delete an existing tenant, or register a valid Unlimited license."
                    );
                  closeModals();
                  $("#modal_licensing_max_tenants").modal();
                } else {
                  $("#modal_type_tenant").modal();
                  notify(
                    "info",
                    "bottom",
                    "Welcome! Choose a component to start the creation a new TracKme tenant, and track the great value in your big data",
                    "60"
                  );
                  // Start the account populating search
                  searchPopulateConfigurationAccounts.startSearch();
                }
              });
            });

            //
            // splk-wlk
            //

            $("#link_wlk_check_scheduler")
              .unbind()
              .click(function (e) {
                // Prevent the default action
                e.preventDefault();
                var search;
                var tk_tenant_wlk_root_constraint = document.getElementById(
                  "input_tenant_wlk_root_constraint_scheduler"
                ).value;
                // set the search
                var rootsearch =
                  '(index=_internal sourcetype=scheduler) | eval alert_actions=if((isnull(alert_actions) OR (alert_actions == "")), "none", alert_actions) | rex field=savedsearch_id "^(?<user_alt>[^;]*);(?<app_alt>[^;]*);(?<savedsearch_name_alt>.*)" | eval user=coalesce(user, user_alt), app=coalesce(app, app_alt), savedsearch_name=coalesce(savedsearch_name, savedsearch_name_alt) | search ' +
                  tk_tenant_wlk_root_constraint;
                // Get account
                var tk_splk_wlk_accounts = getToken("tk_splk_wlk_accounts");
                // Set the search
                if (tk_splk_wlk_accounts != "local") {
                  rootsearch =
                    'splunkremotesearch account="' +
                    tk_splk_wlk_accounts +
                    '" search="' +
                    rootsearch.replace(/\"/g, '\\"') +
                    '"';
                  search =
                    "search" +
                    "?q=%7C%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                } else {
                  search =
                    "search" +
                    "?q=search%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                }
                // Open
                window.open(search, "_blank");
              });

            $("#link_wlk_check_introspection")
              .unbind()
              .click(function (e) {
                // Prevent the default action
                e.preventDefault();
                var search;
                var tk_tenant_wlk_root_constraint = document.getElementById(
                  "input_tenant_wlk_root_constraint_introspection"
                ).value;
                // set the search
                var rootsearch =
                  '(index=_introspection sourcetype=splunk_resource_usage) component=PerProcess data.process_type="search" data.search_props.user="*" data.search_props.app="*" data.search_props.label="*" ' +
                  tk_tenant_wlk_root_constraint;
                // Get account
                var tk_splk_wlk_accounts = getToken("tk_splk_wlk_accounts");
                // Set the search
                if (tk_splk_wlk_accounts != "local") {
                  rootsearch =
                    'splunkremotesearch account="' +
                    tk_splk_wlk_accounts +
                    '" search="' +
                    rootsearch.replace(/\"/g, '\\"') +
                    '"';
                  search =
                    "search" +
                    "?q=%7C%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                } else {
                  search =
                    "search" +
                    "?q=search%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                }
                // Open
                window.open(search, "_blank");
              });

            $("#link_wlk_check_svc")
              .unbind()
              .click(function (e) {
                // Prevent the default action
                e.preventDefault();
                var search;
                var tk_tenant_wlk_root_constraint = document.getElementById(
                  "input_tenant_wlk_root_constraint_svc"
                ).value;
                // set the search
                var rootsearch =
                  '(index=summary source="splunk-svc-search-attribution") (search_type!="ad-hoc") svc_usage=* svc_consumer=search search_label=* ' +
                  tk_tenant_wlk_root_constraint;
                // Get account
                var tk_splk_wlk_accounts = getToken("tk_splk_wlk_accounts");
                // Set the search
                if (tk_splk_wlk_accounts != "local") {
                  rootsearch =
                    'splunkremotesearch account="' +
                    tk_splk_wlk_accounts +
                    '" search="' +
                    rootsearch.replace(/\"/g, '\\"') +
                    '"';
                  search =
                    "search" +
                    "?q=%7C%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                } else {
                  search =
                    "search" +
                    "?q=search%20" +
                    encodeURIComponent(rootsearch) +
                    "&earliest=" +
                    encodeURI("-24h") +
                    "&latest=" +
                    encodeURI("now");
                }
                // Open
                window.open(search, "_blank");
              });

            $("#create_tenant_splk_wlk_confirm")
              .unbind()
              .click(function () {
                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_wlk"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_wlk"
                );

                if (
                  tk_tenant_roles_admin.length < 1 ||
                  tk_tenant_roles_admin == "null" ||
                  tk_tenant_roles_user.length < 1 ||
                  tk_tenant_roles_user == "null"
                ) {
                  var errorStr =
                    "The RBAC configuration is invalid, at least one role for administration and one role for users have to be configured";
                  $("#modal_invalid_selection")
                    .find(".modal-error-message p")
                    .text(errorStr);

                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_wlk_main3"
                  );

                  $("#modal_create_tenant_splk_wlk_confirm").modal("hide");
                  $("#modal_invalid_selection").modal();
                } else {
                  var link = document.getElementById(
                    "invalid_selection_return_to_screen"
                  );
                  link.setAttribute(
                    "href",
                    "#modal_create_tenant_splk_wlk_main3"
                  );
                  $("#modal_create_tenant_splk_wlk_confirm").modal();
                }
              });

            // Vendor components
            $("#btn_start_create_tenant").on("click", function () {
              // check licensing
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the number of active tenants
                var license_is_valid = licenseCall["license_is_valid"];
                var license_active_tenants =
                  licenseCall["license_active_tenants"];
                var license_subscription_class =
                  licenseCall["license_subscription_class"];

                // proceed
                if (license_active_tenants >= 2 && license_is_valid != 1) {
                  $("#modal_licensing_max_tenants")
                    .find(".modal-info-message p")
                    .text(
                      "There are " +
                        license_active_tenants +
                        " active tenants and this deployment is currently running in Free limited edition mode. The Free limited edition mode is limited to 2 active tenants at a time." +
                        " To create a new tenant, you can disable or delete an existing tenant, register a valid license or start a Trial period."
                    );
                  closeModals();
                  $("#modal_licensing_max_tenants").modal();
                } else if (
                  license_active_tenants >= 6 &&
                  license_subscription_class == "enterprise"
                ) {
                  $("#modal_licensing_max_tenants")
                    .find(".modal-info-message p")
                    .text(
                      "There are " +
                        license_active_tenants +
                        " active tenants and this deployment is currently running in Enterprise edition mode. The Enterprise limited edition mode is limited to 6 active tenants at a time." +
                        " To create a new tenant, you can disable or delete an existing tenant, or register a valid Unlimited license."
                    );
                  closeModals();
                  $("#modal_licensing_max_tenants").modal();
                } else {
                  $("#modal_type_tenant").modal();
                  notify(
                    "info",
                    "bottom",
                    "Welcome! Choose a component to start the creation a new TracKme tenant, and track the great value in your big data",
                    "60"
                  );
                  // Start the account populating search
                  searchPopulateConfigurationAccounts.startSearch();
                }
              });
            });

            // Start from scratch
            $("#btn_start_creation_from_scratch").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Choose a component to start the creation a new TracKme tenant, and track the great value in your big data",
                "60"
              );
              // Start the account populating search
              searchPopulateConfigurationAccounts.startSearch();
            });

            //
            // Start message
            //

            // splk-feeds

            $("#vendor-splunk-data-feeds").on("click", function () {
              // by default,  DHM/MHM components are disabled

              // if button has class tenant_dhm_enabled, then click it
              var current_tenant_dhm_enabled =
                document.getElementById("tenant_dhm_enabled");
              if (
                current_tenant_dhm_enabled.classList.contains(
                  "tenant_dhm_enabled"
                )
              ) {
                tenant_dhm_enabled.click();
              }

              // if button has class tenant_mhm_enabled, then click it
              var current_tenant_mhm_enabled =
                document.getElementById("tenant_mhm_enabled");
              if (
                current_tenant_mhm_enabled.classList.contains(
                  "tenant_mhm_enabled"
                )
              ) {
                tenant_mhm_enabled.click();
              }

              // Start related searches
              searchListRoles.startSearch();
              searchListUsers.startSearch();
              searchListIdxSummary.startSearch();
              searchListIdxAudit.startSearch();
              searchListIdxNotable.startSearch();
              searchListIdxMetric.startSearch();
              // clear out textarea
              document.getElementById("input_tenant_name_splk_feeds").value =
                "";
              document.getElementById("input_tenant_alias_splk_feeds").value =
                "";
              document.getElementById(
                "input_tenant_description_splk_feeds"
              ).value = "";
              // next should be disabled by default
              $("#create_tenant_splk_feeds_step1").prop("disabled", true);
              notify(
                "info",
                "bottom",
                "Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            // splk-cim

            $("#vendor-splunk-data-cim").on("click", function () {
              // check licensing
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Getting ready, please wait..."></div>'
              );
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the license status
                var license_is_valid = licenseCall["license_is_valid"];
                // get the subscription class
                var license_subscription_class =
                  licenseCall["license_subscription_class"];
                // proceed
                $("#cssloader").remove();
                if (
                  license_is_valid != 1 &&
                  license_subscription_class != "free_extended"
                ) {
                  $("#modal_licensing_restricted_component").modal();
                } else {
                  // Open modal
                  $("#modal_create_tenant_splk_cim_main1").modal();
                  // Start related searches
                  searchListRoles.startSearch();
                  searchListUsers.startSearch();
                  searchListIdxSummary.startSearch();
                  searchListIdxAudit.startSearch();
                  searchListIdxNotable.startSearch();
                  searchListIdxMetric.startSearch();
                  // clear out textarea
                  document.getElementById("input_tenant_name_splk_cim").value =
                    "";
                  document.getElementById("input_tenant_alias_splk_cim").value =
                    "";
                  document.getElementById(
                    "input_tenant_description_splk_cim"
                  ).value = "";
                  // next should be disabled by default
                  $("#create_tenant_splk_cim_step1").prop("disabled", true);
                  notify(
                    "info",
                    "bottom",
                    "Enter the tenant identifier and a description to start the tenant creation process!",
                    "60"
                  );
                }
              });
            });

            $("#back_create_tenant_splk_cim_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            // splk-flx

            $("#vendor-splunk-data-flx").on("click", function () {
              // check licensing
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Getting ready, please wait..."></div>'
              );
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the license status
                var license_is_valid = licenseCall["license_is_valid"];
                // get the subscription class
                var license_subscription_class =
                  licenseCall["license_subscription_class"];
                // proceed
                $("#cssloader").remove();
                if (
                  license_is_valid != 1 &&
                  license_subscription_class != "free_extended"
                ) {
                  $("#modal_licensing_restricted_component").modal();
                } else {
                  // Open modal
                  $("#modal_create_tenant_splk_flx_main1").modal();
                  // Start related searches
                  searchListRoles.startSearch();
                  searchListUsers.startSearch();
                  searchListIdxSummary.startSearch();
                  searchListIdxAudit.startSearch();
                  searchListIdxNotable.startSearch();
                  searchListIdxMetric.startSearch();
                  // clear out textarea
                  document.getElementById("input_tenant_name_splk_flx").value =
                    "";
                  document.getElementById("input_tenant_alias_splk_flx").value =
                    "";
                  document.getElementById(
                    "input_tenant_description_splk_flx"
                  ).value = "";
                  // next should be disabled by default
                  $("#create_tenant_splk_flx_step1").prop("disabled", true);
                  notify(
                    "info",
                    "bottom",
                    "Enter the tenant identifier and a description to start the tenant creation process!",
                    "60"
                  );
                }
              });
            });

            $("#back_create_tenant_splk_flx_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            // splk-fqm

            $("#vendor-splunk-data-fqm").on("click", function () {
              // check licensing
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Getting ready, please wait..."></div>'
              );
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the license status
                var license_is_valid = licenseCall["license_is_valid"];
                // get the subscription class
                var license_subscription_class =
                  licenseCall["license_subscription_class"];
                // proceed
                $("#cssloader").remove();
                if (
                  license_is_valid != 1 &&
                  license_subscription_class != "free_extended"
                ) {
                  $("#modal_licensing_restricted_component").modal();
                } else {
                  // Open modal
                  $("#modal_create_tenant_splk_fqm_main1").modal();
                  // Start related searches
                  searchListRoles.startSearch();
                  searchListUsers.startSearch();
                  searchListIdxSummary.startSearch();
                  searchListIdxAudit.startSearch();
                  searchListIdxNotable.startSearch();
                  searchListIdxMetric.startSearch();
                  // clear out textarea
                  document.getElementById("input_tenant_name_splk_fqm").value =
                    "";
                  document.getElementById("input_tenant_alias_splk_fqm").value =
                    "";
                  document.getElementById(
                    "input_tenant_description_splk_fqm"
                  ).value = "";
                  // next should be disabled by default
                  $("#create_tenant_splk_fqm_step1").prop("disabled", true);
                  notify(
                    "info",
                    "bottom",
                    "Enter the tenant identifier and a description to start the tenant creation process!",
                    "60"
                  );
                }
              });
            });

            $("#back_create_tenant_splk_fqm_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            // splk-replica

            $("#btn_start_create_tenant_replica").on("click", function () {
              // check licensing
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Getting ready, please wait..."></div>'
              );
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the license status
                var license_is_valid = licenseCall["license_is_valid"];
                // get the subscription class
                var license_subscription_class =
                  licenseCall["license_subscription_class"];
                // proceed
                $("#cssloader").remove();
                if (
                  license_is_valid != 1 &&
                  license_subscription_class != "free_extended"
                ) {
                  $("#modal_licensing_restricted_component").modal();
                } else {
                  // Open modal
                  $("#modal_create_tenant_splk_replica_main1").modal();
                  // Start related searches
                  searchListRoles.startSearch();
                  searchListUsers.startSearch();
                  searchListIdxSummary.startSearch();
                  searchListIdxAudit.startSearch();
                  searchListIdxNotable.startSearch();
                  searchListIdxMetric.startSearch();
                  searchListComponents.startSearch();
                  // clear out textarea
                  document.getElementById(
                    "input_tenant_name_splk_replica"
                  ).value = "";
                  document.getElementById(
                    "input_tenant_alias_splk_replica"
                  ).value = "";
                  document.getElementById(
                    "input_tenant_description_splk_replica"
                  ).value = "";
                  // next should be disabled by default
                  $("#create_tenant_splk_replica_step1").prop("disabled", true);
                  notify(
                    "info",
                    "bottom",
                    "Enter the tenant identifier and a description to start the tenant creation process!",
                    "60"
                  );
                }
              });
            });

            $("#back_create_tenant_splk_replica_step2").on(
              "click",
              function () {
                notify(
                  "info",
                  "bottom",
                  "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                  "60"
                );
              }
            );

            // splk-wlk

            $("#vendor-splunk-data-wlk").on("click", function () {
              // check licensing
              $("body").append(
                '<div id="cssloader" class="loader loader-default is-active" data-text="Getting ready, please wait..."></div>'
              );
              var doAsync = asyncAjax(
                getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/licensing/license_status"
                ),
                "GET"
              ).then(function (licenseCall) {
                // get the license status
                var license_is_valid = licenseCall["license_is_valid"];
                // proceed
                $("#cssloader").remove();
                if (license_is_valid != 1) {
                  $("#modal_licensing_restricted_component").modal();
                } else {
                  // Open modal
                  $("#modal_create_tenant_splk_wlk_main1").modal();
                  // Start related searches
                  searchListRoles.startSearch();
                  searchListUsers.startSearch();
                  searchListIdxSummary.startSearch();
                  searchListIdxAudit.startSearch();
                  searchListIdxNotable.startSearch();
                  searchListIdxMetric.startSearch();
                  // clear out textarea
                  document.getElementById("input_tenant_name_splk_wlk").value =
                    "";
                  document.getElementById("input_tenant_alias_splk_wlk").value =
                    "";
                  document.getElementById(
                    "input_tenant_description_splk_wlk"
                  ).value = "";
                  // next should be disabled by default
                  $("#create_tenant_splk_wlk_step1").prop("disabled", true);
                  notify(
                    "info",
                    "bottom",
                    "Enter the tenant identifier and a description to start the tenant creation process!",
                    "60"
                  );
                }
              });
            });

            $("#back_create_tenant_splk_wlk_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "Welcome! Enter the tenant identifier and a description to start the tenant creation process!",
                "60"
              );
            });

            //
            // splk-feeds
            //

            // Step 1 message
            $("#create_tenant_splk_feeds_step1").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Data Sources Tracking: choose if the component should be enabled for this tenant and configure its main options, click on the test now button to verify your settings and get a preview!",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds_step3").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Data Sources Tracking: choose if the component should be enabled for this tenant and configure its main options, click on the test now button to verify your settings and get a preview!",
                "60"
              );
            });

            // Step 2 message
            $("#create_tenant_splk_feeds_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Common Information Model (CIM) Tracking: choose if the component should be enabled for this tenant and configure its main options",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds_step3").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Common Information Model (CIM) Tracking: choose if the component should be enabled for this tenant and configure its main options",
                "60"
              );
            });

            // Step 2 message
            $("#create_tenant_splk_feeds_step3").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Event Endpoint Tracking: monitoring events from the endpoint perspective, click on the test now button to verify your settings and get a preview!",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds_step4").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Event Endpoint Tracking: monitoring events from the endpoint perspective, click on the test now button to verify your settings and get a preview!",
                "60"
              );
            });

            // Step 3 message
            $("#create_tenant_splk_feeds_step3").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ SPLK Metric Endpoint Tracking: monitoring metrics from the endpoint perspective, click on the test now button to verify your settings and get a preview!",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds_confirm").on(
              "click",
              function () {
                notify(
                  "info",
                  "bottom",
                  "ℹ️ SPLK Metric Endpoint Tracking: monitoring metrics from the endpoint perspective, click on the test now button to verify your settings and get a preview!",
                  "60"
                );
              }
            );

            // Step 5 messages
            $("#create_tenant_splk_feeds_step5").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            $("#back_create_tenant_splk_feeds").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            // Step final messages
            $("#create_tenant_splk_feeds_confirm").on("click", function () {
              notify(
                "info",
                "bottom",
                "Ready! The tenant is now ready to be created, all knowledge objects dedicated to this tenant are going to be created dynamically, at the end of the process the new tenant is active and ready to be used!",
                "60"
              );
            });

            //
            // splk-cim
            //

            // Step 2 messages
            $("#create_tenant_splk_cim_step2").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            $("#back_create_tenant_splk_cim").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            $("#back_create_tenant_splk_flx").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            $("#back_create_tenant_splk_wlk").on("click", function () {
              notify(
                "info",
                "bottom",
                "ℹ️ Configure the RBAC settings for the tenant, you can setup the Splunk roles which provide administrative privileges, the roles for standard users and the Splunk owner of the tenant knowledge objects",
                "60"
              );
            });

            // Step final messages
            $("#create_tenant_splk_cim_confirm").on("click", function () {
              notify(
                "info",
                "bottom",
                "Ready! The tenant is now ready to be created, all knowledge objects dedicated to this tenant are going to be created dynamically, at the end of the process the new tenant is active and ready to be used!",
                "60"
              );
            });

            $("#create_tenant_splk_flx_confirm").on("click", function () {
              notify(
                "info",
                "bottom",
                "Ready! The tenant is now ready to be created, all knowledge objects dedicated to this tenant are going to be created dynamically, at the end of the process the new tenant is active and ready to be used!",
                "60"
              );
            });

            $("#create_tenant_splk_wlk_confirm").on("click", function () {
              notify(
                "info",
                "bottom",
                "Ready! The tenant is now ready to be created, all knowledge objects dedicated to this tenant are going to be created dynamically, at the end of the process the new tenant is active and ready to be used!",
                "60"
              );
            });

            //
            // go creation
            //

            // splk-feeds

            // splk-dsm

            function goSplkDsmCreateHybridTrackerReturnDict(tenant_id, owner) {
              // Get the Splunk account
              var tk_account = getToken("tk_splk_dsm_deployment");

              // Get tenant_dsm_root_constraint
              var tk_tenant_dsm_root_constraint = document.getElementById(
                "input_tenant_dsm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_dsm_discovery = getToken("tk_tenant_dsm_discovery");
              var tk_tenant_dsm_discovery_list = getToken(
                "tk_tenant_dsm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_dsm_discovery == "restricted") {
                tk_tenant_dsm_discovery_list =
                  'index="' +
                  tk_tenant_dsm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_dsm_discovery == "unrestricted") {
                tk_tenant_dsm_discovery_list = "(index=* OR index=_*)";
              } else {
                tk_tenant_dsm_discovery = "unrestricted";
                tk_tenant_dsm_discovery_list = "(index=* OR index=_*)";
              }

              // get dsm mode
              var tk_tenant_dsm_advanced_mode = document.getElementById(
                "tenant_dsm_advanced_mode"
              ).value;
              var tk_tenant_dsm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_dsm_advanced_mode_custom_fields"
                ).value;
              var tk_tenant_dsm_advanced_mode_custom_fields_include_st =
                document.getElementById(
                  "tenant_dsm_advanced_mode_custom_fields_include_st"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_dsm_root_constraint =
                tk_tenant_dsm_discovery_list +
                " " +
                tk_tenant_dsm_root_constraint;

              // set the tracker_name
              tk_tracker_name = "tracker-" + generateRandomString();

              var record = {
                tenant_id: tenant_id,
                component: "dsm",
                tracker_name: tk_tracker_name,
                account: tk_account,
                owner: owner,
                search_mode: document.getElementById(
                  "tenant_dsm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_latest"
                ).value,
                index_earliest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_index_earliest"
                ).value,
                index_latest_time: document.getElementById(
                  "tenant_dsm_advanced_mode_index_latest"
                ).value,
                root_constraint: tk_tenant_dsm_root_constraint,
                dsm_tstats_root_time_span: document.getElementById(
                  "tenant_dsm_advanced_tstats_root_span"
                ).value,
                dsm_tstats_root_breakby_include_splunk_server:
                  document.getElementById(
                    "tenant_dsm_advanced_tstats_root_include_splunk_server"
                  ).value,
                dsm_tstats_root_breakby_include_host: document.getElementById(
                  "tenant_dsm_advanced_tstats_root_include_host"
                ).value,
              };

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_dsm_advanced_mode == "split") {
                breakby_field = "none";
                // add to record
                record["breakby_field"] = breakby_field;
              } else if (tk_tenant_dsm_advanced_mode == "merged") {
                breakby_field = "merged";
                // add to record
                record["breakby_field"] = breakby_field;
              } else {
                breakby_field = tk_tenant_dsm_advanced_mode_custom_fields;

                var breakby_field_array;

                // convert to an array
                breakby_field_array = breakby_field.split(",");

                // remove index if present
                if (breakby_field_array.includes("index")) {
                  breakby_field_array.splice(
                    breakby_field_array.indexOf("index"),
                    1
                  ); //deleting
                }

                // remove sourcetype if present
                if (breakby_field_array.includes("sourcetype")) {
                  breakby_field_array.splice(
                    breakby_field_array.indexOf("sourcetype"),
                    1
                  ); //deleting
                }

                // convert back
                breakby_field = String(breakby_field_array);

                // add to record
                record["breakby_field"] = breakby_field;

                // add breakby_field_include_sourcetype
                record["breakby_field_include_sourcetype"] =
                  tk_tenant_dsm_advanced_mode_custom_fields_include_st;
              }

              // return
              return record;
            }

            // splk-dhm

            function goSplkDhmCreateHybridTrackerReturnDict(tenant_id, owner) {
              // Get the Splunk account
              var tk_account = getToken("tk_splk_dhm_deployment");

              // Get tenant_dhm_root_constraint
              var tk_tenant_dhm_root_constraint = document.getElementById(
                "input_tenant_dhm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_dhm_discovery = getToken("tk_tenant_dhm_discovery");
              var tk_tenant_dhm_discovery_list = getToken(
                "tk_tenant_dhm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_dhm_discovery == "restricted") {
                tk_tenant_dhm_discovery_list =
                  'index="' +
                  tk_tenant_dhm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_dhm_discovery == "unrestricted") {
                tk_tenant_dhm_discovery_list = "(index=main OR index=_*)";
              } else {
                tk_tenant_dhm_discovery = "unrestricted";
                tk_tenant_dhm_discovery_list = "(index=main OR index=_*)";
              }

              // get dhm mode
              var tk_tenant_dhm_advanced_mode = document.getElementById(
                "tenant_dhm_advanced_mode"
              ).value;
              var tk_tenant_dhm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_dhm_advanced_mode_custom_fields"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_dhm_root_constraint =
                tk_tenant_dhm_discovery_list +
                " " +
                tk_tenant_dhm_root_constraint;

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_dhm_advanced_mode == "split") {
                breakby_field = "none";
              } else if (tk_tenant_dhm_advanced_mode == "merged") {
                breakby_field = "merged";
              } else {
                breakby_field = tk_tenant_dhm_advanced_mode_custom_fields;
              }

              // set the tracker_name
              tk_tracker_name = "tracker-" + generateRandomString();

              var record = {
                tenant_id: tenant_id,
                component: "dhm",
                tracker_name: tk_tracker_name,
                account: tk_account,
                owner: owner,
                search_mode: document.getElementById(
                  "tenant_dhm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_latest"
                ).value,
                cron_schedule: document.getElementById(
                  "tenant_dhm_advanced_mode_cron"
                ).value,
                index_earliest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_earliest"
                ).value,
                index_latest_time: document.getElementById(
                  "tenant_dhm_advanced_mode_index_latest"
                ).value,
                root_constraint: tk_tenant_dhm_root_constraint,
                breakby_field: breakby_field,
                dhm_tstats_root_time_span: document.getElementById(
                  "tenant_dhm_advanced_tstats_root_span"
                ).value,
                tenant_dhm_advanced_tstats_root_include_splunk_server:
                  document.getElementById(
                    "tenant_dhm_advanced_tstats_root_include_splunk_server"
                  ).value,
              };

              // return
              return record;
            }

            // splk-mhm

            function goSplkMhmCreateHybridTrackerReturnDict(tenant_id, owner) {
              // Get the Splunk account
              var tk_account = getToken("tk_splk_mhm_deployment");

              // Get tenant_mhm_root_constraint
              var tk_tenant_mhm_root_constraint = document.getElementById(
                "input_tenant_mhm_root_constraint"
              ).value;

              // Get indexes discovery configuration
              var tk_tenant_mhm_discovery = getToken("tk_tenant_mhm_discovery");
              var tk_tenant_mhm_discovery_list = getToken(
                "tk_tenant_mhm_discovery_list"
              );

              // if index discovery is configured, the list of restricted indexes is a CSV list of patterns
              if (tk_tenant_mhm_discovery == "restricted") {
                tk_tenant_mhm_discovery_list =
                  'index="' +
                  tk_tenant_mhm_discovery_list
                    .toString()
                    .replace(/,/g, '" OR index="') +
                  '"';
              } else if (tk_tenant_mhm_discovery == "unrestricted") {
                tk_tenant_mhm_discovery_list = "(index=* OR index=_*)";
              } else {
                tk_tenant_mhm_discovery = "unrestricted";
                tk_tenant_mhm_discovery_list = "(index=* OR index=_*)";
              }

              // get mhm mode
              var tk_tenant_mhm_advanced_mode = document.getElementById(
                "tenant_mhm_advanced_mode"
              ).value;
              var tk_tenant_mhm_advanced_mode_custom_fields =
                document.getElementById(
                  "tenant_mhm_advanced_mode_custom_fields"
                ).value;

              // form the search constraint (indexes restrictions and search constraint)
              tk_tenant_mhm_root_constraint =
                tk_tenant_mhm_discovery_list +
                " " +
                tk_tenant_mhm_root_constraint;

              // form the breakby logic
              var breakby_field;
              if (tk_tenant_mhm_advanced_mode == "split") {
                breakby_field = "none";
              } else if (tk_tenant_mhm_advanced_mode == "merged") {
                breakby_field = "merged";
              } else {
                breakby_field = tk_tenant_mhm_advanced_mode_custom_fields;
              }

              // set the tracker_name
              tk_tracker_name = "tracker-" + generateRandomString();

              var record = {
                tenant_id: tenant_id,
                component: "mhm",
                tracker_name: tk_tracker_name,
                account: tk_account,
                owner: owner,
                search_mode: document.getElementById(
                  "tenant_mhm_advanced_search_mode"
                ).value,
                earliest_time: document.getElementById(
                  "tenant_mhm_advanced_mode_earliest"
                ).value,
                latest_time: document.getElementById(
                  "tenant_mhm_advanced_mode_latest"
                ).value,
                root_constraint: tk_tenant_mhm_root_constraint,
                breakby_field: breakby_field,
              };

              // return
              return record;
            }

            $("#create_tenant_splk_feeds")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_feeds"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_feeds"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_feeds"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_dsm_enabled
                var tk_tenant_dsm_enabled;
                if ($("#tenant_dsm_enabled").is(".tenant_dsm_enabled")) {
                  tk_tenant_dsm_enabled = true;
                } else {
                  tk_tenant_dsm_enabled = false;
                }

                // Get hybrid creation at tenant creation time
                var tk_tenant_dsm_advanced_create_trackers =
                  document.getElementById(
                    "tenant_dsm_advanced_create_trackers"
                  ).value;

                // Get tenant_dhm_enabled
                var tk_tenant_dhm_enabled;
                if ($("#tenant_dhm_enabled").is(".tenant_dhm_enabled")) {
                  tk_tenant_dhm_enabled = true;
                } else {
                  tk_tenant_dhm_enabled = false;
                }

                // Get hybrid creation at tenant creation time
                var tk_tenant_dhm_advanced_create_trackers =
                  document.getElementById(
                    "tenant_dhm_advanced_create_trackers"
                  ).value;

                // Get tenant_mhm_enabled
                var tk_tenant_mhm_enabled;
                if ($("#tenant_mhm_enabled").is(".tenant_mhm_enabled")) {
                  tk_tenant_mhm_enabled = true;
                } else {
                  tk_tenant_mhm_enabled = false;
                }

                // Get hybrid creation at tenant creation time
                var tk_tenant_mhm_advanced_create_trackers =
                  document.getElementById(
                    "tenant_mhm_advanced_create_trackers"
                  ).value;

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_feeds"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_feeds"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_feeds"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_feeds");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_feeds"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_feeds"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_feeds"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_feeds"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_feeds"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // Tenants level options

                // tenant_data_sampling_set_state
                // tenant_outliers_set_state
                // tenant_sampling_obfuscation
                // tenant_adaptive_delay
                // tenant_mloutliers
                // tenant_cmdb_lookup

                record["tenant_data_sampling_set_state"] =
                  document.getElementById(
                    "input_tenant_option_data_sampling_set_state_splk_feeds"
                  ).value;

                record["tenant_outliers_set_state"] = document.getElementById(
                  "input_tenant_option_outliers_set_state_splk_feeds"
                ).value;

                record["tenant_sampling_obfuscation"] = document.getElementById(
                  "input_tenant_option_data_sampling_obfuscation_splk_feeds"
                ).value;

                record["tenant_adaptive_delay"] = document.getElementById(
                  "input_tenant_option_adaptive_delay_splk_feeds"
                ).value;

                record["tenant_mloutliers"] = document.getElementById(
                  "input_tenant_option_mloutliers_splk_feeds"
                ).value;

                record["tenant_cmdb_lookup"] = document.getElementById(
                  "input_tenant_option_cmdb_lookup_splk_feeds"
                ).value;

                record["tenant_default_priority"] = document.getElementById(
                  "input_tenant_option_default_priority_splk_feeds"
                ).value;

                // If component is enabled
                if (tk_tenant_dsm_enabled) {
                  record["tenant_dsm_enabled"] = booleanToInteger(
                    tk_tenant_dsm_enabled
                  );
                }

                // If component is enabled
                if (tk_tenant_dhm_enabled) {
                  record["tenant_dhm_enabled"] = booleanToInteger(
                    tk_tenant_dhm_enabled
                  );
                  record["tenant_dhm_alerting_policy"] =
                    document.getElementById(
                      "tenant_dhm_advanced_alerting_policy"
                    ).value;
                }

                // If component is enabled
                if (tk_tenant_mhm_enabled) {
                  record["tenant_mhm_enabled"] = booleanToInteger(
                    tk_tenant_mhm_enabled
                  );
                }

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                final_record = {};
                hybrid_objects = [];

                // If splk-dsm and hybrid creation was requested
                if (
                  tk_tenant_dsm_enabled &&
                  tk_tenant_dsm_advanced_create_trackers == "True"
                ) {
                  hybrid_objects.push(
                    goSplkDsmCreateHybridTrackerReturnDict(
                      tk_tenant_name,
                      tk_tenant_owner
                    )
                  );
                }

                // If splk-dhm and hybrid creation was requested
                if (
                  tk_tenant_dhm_enabled &&
                  tk_tenant_dhm_advanced_create_trackers == "True"
                ) {
                  hybrid_objects.push(
                    goSplkDhmCreateHybridTrackerReturnDict(
                      tk_tenant_name,
                      tk_tenant_owner
                    )
                  );
                }

                // If splk-mhm and hybrid creation was requested
                if (
                  tk_tenant_mhm_enabled &&
                  tk_tenant_mhm_advanced_create_trackers == "True"
                ) {
                  hybrid_objects.push(
                    goSplkMhmCreateHybridTrackerReturnDict(
                      tk_tenant_name,
                      tk_tenant_owner
                    )
                  );
                }

                // Add the tenant record
                final_record["tenant_dict"] = record;

                // Add the hybrid array
                final_record["hybrid_objects"] = hybrid_objects;

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/vtenants/admin/add_tenant_multiops"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(final_record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // splk-cim
            //

            $("#create_tenant_splk_cim")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_cim"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_cim"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_cim"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_cim_enabled
                tk_tenant_cim_enabled = "true";

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_cim"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_cim"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_cim"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_cim");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_cim"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_cim"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_cim"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_cim"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_cim"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // tenant_outliers_set_state
                // tenant_mloutliers
                // tenant_cmdb_lookup

                record["tenant_outliers_set_state"] = document.getElementById(
                  "input_tenant_option_outliers_set_state_splk_cim"
                ).value;

                record["tenant_mloutliers"] = document.getElementById(
                  "input_tenant_option_mloutliers_splk_cim"
                ).value;

                record["tenant_cmdb_lookup"] = document.getElementById(
                  "input_tenant_option_cmdb_lookup_splk_cim"
                ).value;

                record["tenant_default_priority"] = document.getElementById(
                  "input_tenant_option_default_priority_splk_cim"
                ).value;

                // If component is enabled
                if (tk_tenant_cim_enabled) {
                  record["tenant_cim_enabled"] = booleanToInteger(
                    tk_tenant_cim_enabled
                  );
                }

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw//services/trackme/v2/vtenants/admin/add_tenant"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // splk-flx
            //

            $("#create_tenant_splk_flx")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_flx"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_flx"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_flx"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_flx_enabled
                var tk_tenant_flx_enabled = "true";

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_flx"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_flx"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_flx"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_flx");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_flx"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_flx"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_flx"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_flx"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_flx"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // Tenants level options

                // tenant_outliers_set_state
                // tenant_mloutliers
                // tenant_cmdb_lookup

                record["tenant_outliers_set_state"] = document.getElementById(
                  "input_tenant_option_outliers_set_state_splk_flx"
                ).value;

                record["tenant_mloutliers"] = document.getElementById(
                  "input_tenant_option_mloutliers_splk_flx"
                ).value;

                record["tenant_cmdb_lookup"] = document.getElementById(
                  "input_tenant_option_cmdb_lookup_splk_flx"
                ).value;

                record["tenant_default_priority"] = document.getElementById(
                  "input_tenant_option_default_priority_splk_flx"
                ).value;

                // If component is enabled
                if (tk_tenant_flx_enabled) {
                  record["tenant_flx_enabled"] = booleanToInteger(
                    tk_tenant_flx_enabled
                  );
                }

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw//services/trackme/v2/vtenants/admin/add_tenant"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // splk-fqm
            //

            $("#create_tenant_splk_fqm")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_fqm"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_fqm"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_fqm"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_fqm_enabled
                var tk_tenant_fqm_enabled = "true";

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_fqm"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_fqm"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_fqm"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_fqm");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_fqm"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_fqm"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_fqm"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_fqm"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_fqm"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // Tenants level options

                // tenant_outliers_set_state
                // tenant_mloutliers
                // tenant_cmdb_lookup

                record["tenant_outliers_set_state"] = document.getElementById(
                  "input_tenant_option_outliers_set_state_splk_fqm"
                ).value;

                record["tenant_mloutliers"] = document.getElementById(
                  "input_tenant_option_mloutliers_splk_fqm"
                ).value;

                record["tenant_cmdb_lookup"] = document.getElementById(
                  "input_tenant_option_cmdb_lookup_splk_fqm"
                ).value;

                record["tenant_default_priority"] = document.getElementById(
                  "input_tenant_option_default_priority_splk_fqm"
                ).value;

                // If component is enabled
                if (tk_tenant_fqm_enabled) {
                  record["tenant_fqm_enabled"] = booleanToInteger(
                    tk_tenant_fqm_enabled
                  );
                }

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw//services/trackme/v2/vtenants/admin/add_tenant"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // splk-replica
            //

            $("#create_tenant_splk_replica")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_replica"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_replica"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_replica"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_replica_enabled
                var tk_tenant_replica_enabled = "true";

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_replica"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_replica"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_replica"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_replica");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_replica"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_replica"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_replica"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_replica"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                // get the list of components to be enabled
                var tk_tenant_replica_components = getToken(
                  "tk_tenant_replica_components"
                );

                // Convert it to a string
                tk_tenant_replica_components = String(
                  tk_tenant_replica_components
                );

                // split the CSV string into an array
                var enabledComponents = tk_tenant_replica_components.split(",");

                // list of all possible components
                var allComponents = [
                  "splk-dsm",
                  "splk-dhm",
                  "splk-mhm",
                  "splk-flx",
                  "splk-fqm",
                  "splk-wlk",
                  "splk-cim",
                ];

                // object to hold the status of each component
                var componentsStatus = {};

                // loop over all components
                for (var i = 0; i < allComponents.length; i++) {
                  // check if the component is in the enabledComponents array
                  if (enabledComponents.includes(allComponents[i])) {
                    // if it is, set the corresponding status to "True"
                    componentsStatus[allComponents[i]] = 1;
                  } else {
                    // if it is not, set the corresponding status to "False"
                    componentsStatus[allComponents[i]] = 0;
                  }
                }

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_replica"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // Replica tenant
                record["tenant_replica"] = 1;

                // set each component
                record["tenant_dsm_enabled"] = booleanToInteger(
                  componentsStatus["splk-dsm"]
                );
                record["tenant_dhm_enabled"] = booleanToInteger(
                  componentsStatus["splk-dhm"]
                );
                record["tenant_mhm_enabled"] = booleanToInteger(
                  componentsStatus["splk-mhm"]
                );
                record["tenant_flx_enabled"] = booleanToInteger(
                  componentsStatus["splk-flx"]
                );
                record["tenant_fqm_enabled"] = booleanToInteger(
                  componentsStatus["splk-fqm"]
                );
                record["tenant_wlk_enabled"] = booleanToInteger(
                  componentsStatus["splk-wlk"]
                );
                record["tenant_cim_enabled"] = booleanToInteger(
                  componentsStatus["splk-cim"]
                );

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/vtenants/admin/add_tenant"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // splk-wlk
            //

            $("#create_tenant_splk_wlk")
              .unbind()
              .click(function () {
                // Stop auto-refresh
                vtenantStopInterval();

                // Get tenant_name
                var tk_tenant_name = document.getElementById(
                  "input_tenant_name_splk_wlk"
                ).value;
                tk_tenant_name = checkTenantId(tk_tenant_name);

                // Get tenant_alias, if empty use tenant_name
                var tk_tenant_alias = document.getElementById(
                  "input_tenant_alias_splk_wlk"
                ).value;
                if (tk_tenant_alias.length < 1) {
                  tk_tenant_alias = tk_tenant_name;
                }

                // Get tenant_description
                var tk_tenant_description = document.getElementById(
                  "input_tenant_description_splk_wlk"
                ).value;

                // some replacements
                tk_tenant_description = tk_tenant_description.replace(
                  /\'/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\"/g,
                  ""
                );
                tk_tenant_description = tk_tenant_description.replace(
                  /\\/g,
                  ""
                );

                // Get tenant_roles_admin
                var tk_tenant_roles_admin = getToken(
                  "tk_tenant_roles_admin_splk_wlk"
                );

                // Get tenant_roles_power
                var tk_tenant_roles_power = getToken(
                  "tk_tenant_roles_power_splk_wlk"
                );

                // Get tenant_roles_user
                var tk_tenant_roles_user = getToken(
                  "tk_tenant_roles_user_splk_wlk"
                );

                // Get tenant_owner
                var tk_tenant_owner = getToken("tk_tenant_owner_splk_wlk");

                // Get indexes
                var tk_tenant_idx_settings;

                // local settings
                var tk_tenant_idx_summary = getToken(
                  "tk_tenant_idx_summary_splk_wlk"
                );
                var tk_tenant_idx_audit = getToken(
                  "tk_tenant_idx_audit_splk_wlk"
                );
                var tk_tenant_idx_metric = getToken(
                  "tk_tenant_idx_metric_splk_wlk"
                );
                var tk_tenant_idx_notable = getToken(
                  "tk_tenant_idx_notable_splk_wlk"
                );

                // global settings
                var tk_default_tenant_idx_summary = getToken(
                  "tk_default_tenant_idx_summary"
                );
                var tk_default_tenant_idx_audit = getToken(
                  "tk_default_tenant_idx_audit"
                );
                var tk_default_tenant_idx_metric = getToken(
                  "tk_default_tenant_idx_metric"
                );
                var tk_default_tenant_idx_notable = getToken(
                  "tk_default_tenant_idx_notable"
                );

                if (
                  tk_tenant_idx_summary.length < 1 ||
                  tk_tenant_idx_summary == "null" ||
                  tk_tenant_idx_audit.length < 1 ||
                  tk_tenant_idx_audit == "null" ||
                  tk_tenant_idx_metric.length < 1 ||
                  tk_tenant_idx_metric == "null" ||
                  tk_tenant_idx_notable.length < 1 ||
                  tk_tenant_idx_notable == "null"
                ) {
                  tk_tenant_idx_settings = "global";
                } else if (
                  tk_tenant_idx_summary === tk_default_tenant_idx_summary &&
                  tk_tenant_idx_audit === tk_default_tenant_idx_audit &&
                  tk_tenant_idx_metric === tk_default_tenant_idx_metric &&
                  tk_tenant_idx_notable === tk_default_tenant_idx_notable
                ) {
                  tk_tenant_idx_settings = "global";
                } else {
                  tk_tenant_idx_settings =
                    '{"trackme_summary_idx": "' +
                    tk_tenant_idx_summary +
                    '", "trackme_audit_idx": "' +
                    tk_tenant_idx_audit +
                    '", "trackme_notable_idx": "' +
                    tk_tenant_idx_notable +
                    '", "trackme_metric_idx": "' +
                    tk_tenant_idx_metric +
                    '"}';
                }

                // Get update note
                var tk_comment = document.getElementById(
                  "input_comment_create_tenant_splk_wlk"
                ).value;

                // Get accounts
                // convert
                var tk_splk_wlk_accounts = getToken("tk_splk_wlk_accounts");
                tk_splk_wlk_accounts = tk_splk_wlk_accounts
                  .toString()
                  .split(",");

                // Get environment type
                var tk_splk_wlk_env_type = getToken("tk_splk_wlk_env_type");

                // Get track notable
                var tk_splk_wlk_track_notable = getToken(
                  "tk_splk_wlk_track_notable"
                );

                // Get the root constraint
                var tk_tenant_wlk_root_constraint_scheduler =
                  document.getElementById(
                    "input_tenant_wlk_root_constraint_scheduler"
                  ).value;

                // Get the root constraint
                var tk_tenant_wlk_root_constraint_introspection =
                  document.getElementById(
                    "input_tenant_wlk_root_constraint_introspection"
                  ).value;

                // Get the root constraint
                var tk_tenant_wlk_root_constraint_svc = document.getElementById(
                  "input_tenant_wlk_root_constraint_svc"
                ).value;

                // Get the overgroup
                var tk_tenant_wlk_overgroup = document.getElementById(
                  "input_tenant_wlk_overgroup"
                ).value;

                // Prepare the JSON record
                var record = {};

                // Add main settings first
                record["tenant_alias"] = tk_tenant_alias;
                record["tenant_desc"] = tk_tenant_description;
                record["tenant_name"] = tk_tenant_name;
                record["tenant_roles_admin"] = tk_tenant_roles_admin;
                record["tenant_roles_power"] = tk_tenant_roles_power;
                record["tenant_roles_user"] = tk_tenant_roles_user;
                record["tenant_owner"] = tk_tenant_owner;
                record["tenant_idx_settings"] = tk_tenant_idx_settings;

                // Tenants level options

                // tenant_outliers_set_state
                // tenant_mloutliers
                // tenant_cmdb_lookup

                record["tenant_outliers_set_state"] = document.getElementById(
                  "input_tenant_option_outliers_set_state_splk_wlk"
                ).value;

                record["tenant_mloutliers"] = document.getElementById(
                  "input_tenant_option_mloutliers_splk_wlk"
                ).value;

                record["tenant_cmdb_lookup"] = document.getElementById(
                  "input_tenant_option_cmdb_lookup_splk_wlk"
                ).value;

                record["tenant_default_priority"] = document.getElementById(
                  "input_tenant_option_default_priority_splk_wlk"
                ).value;

                // outliers metrics preferences
                record["tenant_wlk_outliers_metrics"] = getToken(
                  "tk_splk_wlk_outliers_metrics"
                );

                // Enable component
                record["tenant_wlk_enabled"] = 1;

                // Add comment
                if (tk_comment != "Enter your audit message") {
                  record["update_comment"] = tk_comment;
                }

                // info
                $("#cssloader").remove();
                notify(
                  "info",
                  "bottom",
                  "The tenant creation has been requested and is running in the background, you will be notified when it is completed.",
                  "5"
                );
                $("#modal_creation_requested").modal();

                final_record = {};
                hybrid_objects = [];

                // Push the main tracker first
                hybrid_objects.push({
                  tenant_id: tk_tenant_name,
                  tracker_type: "main",
                  account: "local",
                  environment_type: tk_splk_wlk_env_type,
                  overgroup: tk_tenant_wlk_overgroup,
                });

                // Push the metadata tracker, it will always be local as it performs operations remotely, if necessary
                hybrid_objects.push({
                  tenant_id: tk_tenant_name,
                  tracker_type: "metadata",
                  account: "local",
                  overgroup: tk_tenant_wlk_overgroup,
                });

                // orphan has to honour account
                hybrid_objects.push({
                  tenant_id: tk_tenant_name,
                  tracker_type: "orphan",
                  account: getToken("tk_splk_wlk_accounts"),
                  overgroup: tk_tenant_wlk_overgroup,
                });

                // Add the inactive_entities
                hybrid_objects.push({
                  tenant_id: tk_tenant_name,
                  tracker_type: "inactive_entities",
                  account: "local",
                  inactive_entities_max_age_days: getToken(
                    "tk_splk_wlk_inactive_inspector"
                  ),
                  overgroup: tk_tenant_wlk_overgroup,
                });

                // loop trough the accounts
                for (var i = 0; i < tk_splk_wlk_accounts.length; i++) {
                  // tracker_type: introspection
                  hybrid_objects.push({
                    tenant_id: tk_tenant_name,
                    environment_type: tk_splk_wlk_env_type,
                    tracker_type: "introspection",
                    account: tk_splk_wlk_accounts[i],
                    root_constraint:
                      tk_tenant_wlk_root_constraint_introspection,
                    overgroup: tk_tenant_wlk_overgroup,
                  });

                  // tracker_type: scheduler
                  hybrid_objects.push({
                    tenant_id: tk_tenant_name,
                    environment_type: tk_splk_wlk_env_type,
                    tracker_type: "scheduler",
                    account: tk_splk_wlk_accounts[i],
                    root_constraint: tk_tenant_wlk_root_constraint_scheduler,
                    overgroup: tk_tenant_wlk_overgroup,
                  });

                  // environment type: if running on Splunk Cloud, include the option explicitely and create the tracker too
                  if (tk_splk_wlk_env_type === "splunk_cloud") {
                    hybrid_objects.push({
                      tenant_id: tk_tenant_name,
                      environment_type: tk_splk_wlk_env_type,
                      tracker_type: "splunkcloud_svc",
                      account: tk_splk_wlk_accounts[i],
                      root_constraint: tk_tenant_wlk_root_constraint_svc,
                      overgroup: tk_tenant_wlk_overgroup,
                    });
                  }

                  // track notable
                  if (tk_splk_wlk_track_notable === "true") {
                    hybrid_objects.push({
                      tenant_id: tk_tenant_name,
                      environment_type: tk_splk_wlk_env_type,
                      tracker_type: "notable",
                      account: tk_splk_wlk_accounts[i],
                      overgroup: tk_tenant_wlk_overgroup,
                    });
                  }
                }

                // Add the tenant record
                final_record["tenant_dict"] = record;

                // Add the hybrid array
                final_record["hybrid_objects"] = hybrid_objects;

                // Create the virtual tenant
                $.ajax({
                  url: getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/vtenants/admin/add_tenant_wlk_multiops"
                  ),
                  type: "POST",
                  async: true,
                  contentType: "application/json",
                  data: JSON.stringify(final_record),
                  timeout: 600000,
                  success: function (returneddata) {
                    //
                    // if previously ran
                    $("#div_create_tenant_spl_command").attr(
                      "style",
                      "display: None !important"
                    );
                    // Audit success is made by the API
                    // If click on show SPL command
                    $("#btn_create_tenant_show_spl").on("click", function () {
                      $(this).blur();
                      const searchQuery =
                        '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                        JSON.stringify(record).replace(/\"/g, "'") +
                        '"';
                      showSplMessage(
                        "#div_create_tenant_spl_command .modal-spl-message",
                        searchQuery
                      );
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: block !important"
                      );
                      $("#btn_create_tenant_copy_clipboard").attr(
                        "style",
                        "display: block !important"
                      );
                    });
                    // if click on copy to clipboard
                    $("#btn_create_tenant_copy_clipboard").on(
                      "click",
                      function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        copyToClipboard(searchQuery);
                      }
                    );
                    $("#cssloader").remove();
                    $("#modal_creation_success").modal();
                    // Refresh and restart interval
                    $("#btn_refresh_all").click();
                    // notify
                    notify(
                      "success",
                      "bottom",
                      "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                      "5"
                    );
                    //
                  },
                  error: function (xhr, textStatus, error) {
                    // A timeout can occur on Splunk Cloud especially with very long operations
                    // this is begign and does mean the operation has failed, assume things are ok
                    if (error == "timeout" || error == "GATEWAY_TIMEOUT") {
                      //
                      // if previously ran
                      $("#div_create_tenant_spl_command").attr(
                        "style",
                        "display: None !important"
                      );
                      // Audit success is made by the API
                      // If click on show SPL command
                      $("#btn_create_tenant_show_spl").on("click", function () {
                        $(this).blur();
                        const searchQuery =
                          '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                          JSON.stringify(record).replace(/\"/g, "'") +
                          '"';
                        showSplMessage(
                          "#div_create_tenant_spl_command .modal-spl-message",
                          searchQuery
                        );
                        $("#div_create_tenant_spl_command").attr(
                          "style",
                          "display: block !important"
                        );
                        $("#btn_create_tenant_copy_clipboard").attr(
                          "style",
                          "display: block !important"
                        );
                      });
                      // if click on copy to clipboard
                      $("#btn_create_tenant_copy_clipboard").on(
                        "click",
                        function () {
                          $(this).blur();
                          const searchQuery =
                            '| trackme url="/services/trackme/v2/vtenants/admin/add_tenant" mode="post" body="' +
                            JSON.stringify(record).replace(/\"/g, "'") +
                            '"';
                          showSplMessage(
                            "#div_create_tenant_spl_command .modal-spl-message",
                            searchQuery
                          );
                          copyToClipboard(searchQuery);
                        }
                      );
                      $("#cssloader").remove();
                      $("#modal_creation_success").modal();
                      // Refresh and restart interval
                      $("#btn_refresh_all").click();
                      // notify
                      notify(
                        "success",
                        "bottom",
                        "Congratulations! The new tenant was successfully created and is ready to use, click on the table to open it immediately or perform administration tasks!",
                        "5"
                      );
                      //
                    } else {
                      $("#cssloader").remove();
                      message =
                        "server response: " +
                        xhr.responseText +
                        "\n - http response: " +
                        error +
                        "\n - text status: " +
                        textStatus;
                      $("#modal_generic_error")
                        .find(".modal-error-message p")
                        .text(message);
                      $("#modal_generic_error").modal();
                    }
                  },
                });
              });

            //
            // end go creation tenants
            //

            $("#delete_tenant_confirmed").click(function () {
              // Stop auto-refresh
              vtenantStopInterval();

              // Create the service
              var service = mvc.createService({
                owner: "nobody",
              });

              // Get current user
              var currentUser = Splunk.util.getConfigValue("USERNAME");

              // Get tenant context
              var clickedTenantId = getToken("clickedTenantId");

              // Get update note
              var tk_comment = document.getElementById(
                "input_comment_delete_tenant"
              ).value;

              // Prepare the command
              var record;
              record = "{ 'tenant_id': '" + clickedTenantId + "'";

              // insert comment and close
              if (tk_comment != "Enter your audit message") {
                record = record + ", 'update_comment': '" + tk_comment + "'}";
              } else {
                record = record + "}";
              }

              // Define the query
              var searchQuery =
                '| trackme url=/services/trackme/v2/vtenants/admin/del_tenant mode=delete body="' +
                record +
                '"';

              // Set the search parameters--specify a time range
              var searchParams = {
                earliest_time: "-5m",
                latest_time: "now",
              };

              // Run a blocking search and get back a job
              service.search(searchQuery, searchParams, function (err, job) {
                // spinner
                $("#cssloader").remove();
                $("body").append(
                  '<div id="cssloader" class="loader loader-default is-active" data-text="Please wait while the tenant is being deleted, this might take some time..."></div>'
                );

                // Shall the search fail before we can get properties
                if (job == null) {
                  let errorStr = "Unknown Error!";
                  if (
                    err &&
                    err.data &&
                    err.data.messages &&
                    err.data.messages[0]["text"]
                  ) {
                    errorStr = err.data.mess