#!/usr/bin/env python
# coding=utf-8

__author__ = "TrackMe Limited"
__copyright__ = "Copyright 2023-2025, TrackMe Limited, U.K."
__credits__ = "TrackMe Limited, U.K."
__license__ = "TrackMe Limited, all rights reserved"
__version__ = "0.1.0"
__maintainer__ = "TrackMe Limited, U.K."
__email__ = "support@trackme-solutions.com"
__status__ = "PRODUCTION"

# default remote account configuration settings
remote_account_default = {
    "app_namespace": "search",
    "rbac_roles": "admin,sc_admin,trackme_user,trackme_power,trackme_admin",
    "timeout_connect_check": "15",
    "timeout_search_check": "600",
    "token_rotation_enablement": "1",
    "token_rotation_frequency": "7",
}

# default vtenant account configuration settings
vtenant_account_default = {
    "ui_default_timerange": "24h",
    "ui_min_object_width": 300,
    "data_sampling_set_state": 1,
    "outliers_set_state": 1,
    "data_sampling_obfuscation": 0,
    "ui_expand_metrics": 0,
    "ui_home_tabs_order": "dsm,flx,dhm,mhm,wlk,flip,audit,alerts",
    "adaptive_delay": 1,
    "mloutliers": 1,
    "mloutliers_allowlist": "dsm,dhm,flx,wlk,fqm",
    "sampling": 1,
    "adaptive_delay": 1,
    "indexed_constraint": "",
    "splk_feeds_auto_disablement_period": "90d",
    "splk_feeds_delayed_inspector_24hours_range_min_sec": "14400",
    "splk_feeds_delayed_inspector_7days_range_min_sec": "43200",
    "splk_feeds_delayed_inspector_until_disabled_range_min_sec": "172800",
    "cmdb_lookup": 1,
    "splk_dsm_cmdb_search": "",
    "splk_dhm_cmdb_search": "",
    "splk_mhm_cmdb_search": "",
    "splk_flx_cmdb_search": "",
    "splk_fqm_cmdb_search": "",
    "splk_wlk_cmdb_search": "",
    "default_priority": "medium",
    "monitoring_time_policy": "all_time",
    "pagination_mode": "local",
    "pagination_size": 10000,
    "splk_dsm_tabulator_groupby": "data_index",
    "splk_dhm_tabulator_groupby": "tenant_id",
    "splk_mhm_tabulator_groupby": "tenant_id",
    "splk_flx_tabulator_groupby": "group",
    "splk_fqm_tabulator_groupby": "metadata_datamodel,metadata_index,metadata_sourcetype",
    "splk_wlk_tabulator_groupby": "overgroup",
    "default_disruption_min_time_sec": 0,
}

# main and shared collections
collections_list_main = [
    "trackme_virtual_tenants",
    "trackme_virtual_tenants_entities_summary",
    "trackme_maintenance_mode",
    "trackme_maintenance_kdb",
    "trackme_backup_archives_info",
]

# splk-flx allowed uc_ref listing
splk_flx_allowed_uc_ref = [
    "cribl_logstream_health_inputs",
    "cribl_logstream_health_outputs",
    "cribl_logstream_hosts_cpu_usage",
    "cribl_logstream_output_destination_pressure",
    "cribl_logstream_pipeline",
    "cribl_logstream_route_traffic",
    "cribl_logstream_total_traffic_inputs",
    "cribl_logstream_total_traffic_outputs",
    "splk_bundle_size",
    "splk_dbconnect",
    "splk_deployment_server_clients",
    "splk_detect_daily_variations_volume_global",
    "splk_detect_daily_variations_volume_index",
    "splk_detect_drop_events_count_absolute",
    "splk_detect_drop_events_count_rolling",
    "splk_dma",
    "splk_good_practices_alltime_scheduled",
    "splk_good_practices_detect_dynamic_sourcetype",
    "splk_good_practices_run_as_user_scheduled",
    "splk_hosts_tracking",
    "splk_kvstore_size",
    "splk_kvstore_status",
    "splk_large_lookup_files",
    "splk_lastchanceindex",
    "splk_license_pool_usage",
    "splk_license_usage_per_index_splunkcloud",
    "splk_license_usage_per_index_splunkenterprise",
    "splk_queues_filling",
    "splk_search_head_activity",
    "splk_search_head_healthmon_artifact_count_remote",
    "splk_soar_actions_adhocs_failures",
    "splk_soar_actions_playbooks_failures",
    "splk_soar_assets_health",
    "splk_soar_automation_brokers_manage",
    "splk_soar_automation_brokers_monitor",
    "splk_soar_forwarding_splunk",
    "splk_soar_infra_load",
    "splk_soar_infra_memory",
    "splk_soar_services_health",
    "splk_soar_concurrent_playbooks",
    "splk_splunk_cloud_storage_usage",
    "splk_splunk_cloud_svc_usage",
    "splk_splunk_cloud_svc_usage_by_app",
    "splk_splunk_cloud_svc_usage_by_consumer_service",
    "splk_splunk_enterprise_cluster_peers_status",
    "splk_splunk_enterprise_cluster_status",
    "splk_splunk_infra_cpu_used",
    "splk_splunk_infra_log_level_variations",
    "splk_splunk_infra_mem_used",
    "splk_splunk_shc_global_status",
    "splk_splunk_shc_members_status",
    "splk_volume_ingested_per_day",
    "splk_uf_clients_versions_tracking",
    "splk_splunk_fields_quality",
    "splk_splunk_hec_errors",
]

# dict of collections
collections_dict = dict(
    [
        (
            "trackme_dsm",
            "_key, ctime, mtime, search_mode, tenant_id, object_category, alias, data_index, data_last_lag_seen, data_last_ingestion_lag_seen, data_eventcount, data_last_lag_seen_idx, data_first_time_seen, data_last_time_seen, data_last_ingest, data_last_time_seen_idx, data_max_lag_allowed, data_max_delay_allowed, future_tolerance, data_lag_alert_kpis, monitored_state, object, data_sourcetype, monitoring_time_policy, monitoring_time_rules, data_monitoring_wdays, isUnderMonitoringDays, data_monitoring_hours_ranges, isUnderMonitoringHours, data_override_lagging_class, allow_adaptive_delay, object_state, tracker_runtime, tracker_health_runtime, object_previous_state, data_previous_tracker_runtime, dcount_host, min_dcount_host, min_dcount_field, min_dcount_threshold, avg_dcount_host_5m, latest_dcount_host_5m, perc95_dcount_host_5m, stdev_dcount_host_5m, global_dcount_host, isAnomaly, data_sample_lastrun, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, status_message, anomaly_reason, outliers_readiness, tenant_parent",
        ),
        (
            "trackme_dsm_elastic_shared",
            "_key, object, alias, search_constraint, search_mode, elastic_index, elastic_sourcetype, earliest, latest",
        ),
        (
            "trackme_dsm_elastic_dedicated",
            "_key, object, alias, search_constraint, search_mode, elastic_index, elastic_sourcetype, elastic_wrapper, elastic_report",
        ),
        ("trackme_dsm_hybrid_trackers", "_key, tracker_name, knowledge_objects"),
        (
            "trackme_dsm_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_dsm_data_sampling",
            "_key, object, raw_sample, events_count, min_time_btw_iterations_seconds, pct_min_major_inclusive_model_match, pct_max_exclusive_model_match, pct_max_exclusive_model_match, relative_time_window_seconds, data_sample_mtime, data_sample_last_entity_epoch_processed, data_sample_model_matched_summary, data_sample_feature, data_sample_iteration, data_sample_anomaly_reason, data_sample_status_colour, data_sample_anomaly_detected, data_sample_status_message, multiformat_detected, current_detected_format, current_detected_format_id, current_detected_format_dcount, current_detected_major_format, previous_detected_format, previous_detected_format_id, previous_detected_format_dcount, previous_detected_major_format",
        ),
        (
            "trackme_dsm_data_sampling_custom_models",
            "_key, model_id, model_name, model_regex, model_type, sourcetype_scope, mtime",
        ),
        ("trackme_dsm_knowledge", "_key, object, doc_link, doc_note"),
        (
            "trackme_dsm_outliers_entity_rules",
            "_key, object_category, object, mtime, is_disabled, entities_outliers, last_exec, confidence, confidence_reason",
        ),
        (
            "trackme_dsm_outliers_entity_data",
            "_key, object_category, object, mtime, isOutlier, isOutlierReason, models_in_anomaly, models_summary",
        ),
        (
            "trackme_dsm_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_dsm_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_dsm_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_dsm_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_dsm_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_dsm_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_dsm_sla_notifications",
            "_key, mtime",
        ),
        (
            "trackme_dsm_delayed_entities_inspector",
            "_key, mtime, object, inspector_exec_counters, inspector_error_counters, inspector_last_error, inspector_last_status",
        ),
        (
            "trackme_flx",
            "_key, ctime, mtime, tenant_id, group, subgroup, object, object_category, object_state, object_description, alias, monitored_state, account, tracker_name, tracker_runtime, status, status_description_short, status_description, metrics, outliers_metrics, extra_attributes, monitoring_time_policy, monitoring_time_rules, monitoring_wdays, isUnderMonitoringDays, monitoring_hours_ranges, isUnderMonitoringHours, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, status_message, anomaly_reason, outliers_readiness, tenant_parent, max_sec_inactive, flx_type",
        ),
        (
            "trackme_flx_hybrid_trackers",
            "_key, tracker_id, tracker_name, knowledge_objects",
        ),
        (
            "trackme_flx_outliers_entity_rules",
            "_key, object_category, object, mtime, is_disabled, entities_outliers, last_exec, confidence, confidence_reason",
        ),
        (
            "trackme_flx_outliers_entity_data",
            "_key, object_category, object, mtime, isOutlier, isOutlierReason, models_in_anomaly, models_summary",
        ),
        (
            "trackme_flx_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_flx_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_flx_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_flx_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_flx_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_flx_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_flx_sla_notifications",
            "_key, mtime",
        ),
        (
            "trackme_flx_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_flx_last_seen_activity",
            "_key, object, last_seen_metrics",
        ),
        (
            "trackme_flx_thresholds",
            "_key, object_id, metric_name, value, operator, condition_true, mtime, comment",
        ),
        (
            "trackme_fqm",
            "_key, ctime, mtime, tenant_id, metadata_datamodel, metadata_nodename, metadata_index, metadata_sourcetype, object, object_category, object_state, object_description, alias, fieldname, fields_quality_summary, monitored_state, account, tracker_name, tracker_runtime, tracker_name, tracker_index, status, status_description_short, status_description, metrics, outliers_metrics, monitoring_time_policy, monitoring_time_rules, monitoring_wdays, isUnderMonitoringDays, monitoring_hours_ranges, isUnderMonitoringHours, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, status_message, anomaly_reason, outliers_readiness, tenant_parent, max_sec_inactive, fqm_type, percent_success, percent_coverage",
        ),
        (
            "trackme_fqm_hybrid_trackers",
            "_key, tracker_id, tracker_name, knowledge_objects",
        ),
        (
            "trackme_fqm_outliers_entity_rules",
            "_key, object_category, object, mtime, is_disabled, entities_outliers, last_exec, confidence, confidence_reason",
        ),
        (
            "trackme_fqm_outliers_entity_data",
            "_key, object_category, object, mtime, isOutlier, isOutlierReason, models_in_anomaly, models_summary",
        ),
        (
            "trackme_fqm_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_fqm_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_fqm_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_fqm_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_fqm_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_fqm_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_fqm_sla_notifications",
            "_key, mtime",
        ),
        (
            "trackme_fqm_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_fqm_last_seen_activity",
            "_key, object, last_seen_metrics",
        ),
        (
            "trackme_fqm_thresholds",
            "_key, object_id, metric_name, value, operator, condition_true, mtime, comment",
        ),
        (
            "trackme_fqm_data_dictionary",
            "_key, mtime, name, label, json_dict",
        ),
        (
            "trackme_wlk",
            "_key, ctime, mtime, tenant_id, overgroup, group, app, user, savedsearch_name, object, object_category, object_state, object_description, alias, monitored_state, account, tracker_name, tracker_runtime, status, status_description, metrics, metrics_extended, outliers_metrics, monitoring_time_policy, monitoring_time_rules, monitoring_wdays, isUnderMonitoringDays, monitoring_hours_ranges, isUnderMonitoringHours, first_seen, last_seen, sec_since_lastexec, skipped_pct, skipped_pct_last_60m, skipped_pct_last_4h, skipped_pct_last_24h, count_errors, count_errors_last_60m, count_errors_last_4h, count_errors_last_24h, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, tags, status_message, anomaly_reason, outliers_readiness, tenant_parent",
        ),
        (
            "trackme_wlk_hybrid_trackers",
            "_key, tracker_id, tracker_name, knowledge_objects",
        ),
        (
            "trackme_wlk_outliers_entity_rules",
            "_key, object_category, object, mtime, is_disabled, entities_outliers, last_exec, confidence, confidence_reason",
        ),
        (
            "trackme_wlk_outliers_entity_data",
            "_key, object_category, object, mtime, isOutlier, isOutlierReason, models_in_anomaly, models_summary",
        ),
        (
            "trackme_wlk_versioning",
            "_key, mtime, object, version_dict, description, current_version_id, cron_exec_sequence_sec",
        ),
        ("trackme_wlk_orphan_status", "_key, mtime, object, user, app, orphan"),
        ("trackme_wlk_apps_enablement", "_key, mtime, app, enabled"),
        (
            "trackme_wlk_last_seen_activity",
            "_key, account, object, last_seen_scheduler, last_seen_introspection, last_seen_notable, last_seen_splunkcloud_svc",
        ),
        (
            "trackme_wlk_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_wlk_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_wlk_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_wlk_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_wlk_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_wlk_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_wlk_sla_notifications",
            "_key, mtime",
        ),
        (
            "trackme_wlk_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_dhm",
            "_key, ctime, mtime, search_mode, tenant_id, object_category, object, alias, data_index, data_sourcetype, data_last_lag_seen, data_last_ingestion_lag_seen, data_eventcount, data_first_time_seen, data_last_time_seen, data_last_ingest, data_max_lag_allowed, data_max_delay_allowed, future_tolerance, data_lag_alert_kpis, monitored_state, monitoring_time_policy, monitoring_time_rules, data_monitoring_wdays, isUnderMonitoringDays, data_monitoring_hours_ranges, isUnderMonitoringHours, data_override_lagging_class, allow_adaptive_delay, object_state, tracker_runtime, tracker_health_runtime, object_previous_state, data_previous_tracker_runtime, splk_dhm_st_summary, splk_dhm_st_summary_full, splk_dhm_st_summary_compact, splk_dhm_st_summary_minimal, splk_dhm_alerting_policy, host_idx_blocklists, host_st_blocklists, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, status_message, anomaly_reason, outliers_readiness, tenant_parent",
        ),
        (
            "trackme_dhm_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_dhm_outliers_entity_rules",
            "_key, object_category, object, mtime, is_disabled, entities_outliers, last_exec, confidence, confidence_reason",
        ),
        (
            "trackme_dhm_outliers_entity_data",
            "_key, object_category, object, mtime, isOutlier, isOutlierReason, models_in_anomaly, models_summary",
        ),
        (
            "trackme_dhm_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_dhm_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_dhm_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_dhm_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_dhm_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_dhm_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_dhm_sla_notifications",
            "_key, mtime",
        ),
        ("trackme_dhm_hybrid_trackers", "_key, tracker_name, knowledge_objects"),
        (
            "trackme_dhm_delayed_entities_inspector",
            "_key, mtime, object, inspector_exec_counters, inspector_error_counters, inspector_last_error, inspector_last_status",
        ),
        (
            "trackme_mhm",
            "_key, ctime, mtime, tenant_id, object_category, object, alias, metric_index, metric_category, metric_details, metric_details_full, metric_details_compact, metric_details_minimal, metric_last_lag_seen, metric_first_time_seen, metric_last_time_seen, metric_max_lag_allowed, monitored_state, metric_override_lagging_class, object_state, tracker_runtime, object_previous_state, metric_previous_tracker_runtime, tags, tags_manual, latest_flip_state, latest_flip_time, priority, priority_updated, priority_external, priority_reason, sla_class, sla_notification_mtime, status_message, anomaly_reason, outliers_readiness, tenant_parent",
        ),
        (
            "trackme_mhm_allowlist",
            "_key, object_category, object, is_rex, action, comment, mtime",
        ),
        (
            "trackme_common_lagging_classes",
            "_key, level, name, object, value_lag, value_delay, comment, mtime",
        ),
        (
            "trackme_stateful_alerting",
            "_key, object_id, object, object_category, object_state, incident_id, message_id, messages, reference_chain, delivery_type, alert_status, ctime, mtime, opened_anomaly_reason, updated_anomaly_reason",
        ),
        (
            "trackme_stateful_alerting_charts",
            "_key, object_id, object, object_category, incident_id, message_id, ctime, chart_id, chart_description, chart_svg_base64",
        ),
        (
            "trackme_mhm_lagging_classes",
            "_key, metric_category, metric_max_lag_allowed, comment, mtime",
        ),
        ("trackme_mhm_hybrid_trackers", "_key, tracker_name, knowledge_objects"),
        (
            "trackme_common_audit_changes",
            "_key, time, action, change_type, object, object_category, object_attrs, user, result, comment",
        ),
        (
            "trackme_mhm_tags",
            "_key, object, tags_auto",
        ),
        (
            "trackme_mhm_tags_policies",
            "_key, tags_policy_id, tags_policy_value, tags_policy_regex, mtime",
        ),
        (
            "trackme_mhm_priority",
            "_key, object, priority, priority_reason, mtime",
        ),
        (
            "trackme_mhm_priority_policies",
            "_key, priority_policy_id, priority_policy_value, priority_policy_regex, mtime",
        ),
        (
            "trackme_mhm_sla",
            "_key, object, sla_class, sla_reason, mtime",
        ),
        (
            "trackme_mhm_sla_policies",
            "_key, sla_policy_id, sla_policy_value, sla_policy_regex, mtime",
        ),
        (
            "trackme_mhm_sla_notifications",
            "_key, mtime",
        ),
        (
            "trackme_common_alerts_ack",
            "_key, object, object_category, anomaly_reason, ack_source, ack_mtime, ack_expiration, ack_state, ack_type, ack_comment",
        ),
        (
            "trackme_common_logical_group",
            "_key, object_group_name, object_group_min_green_percent, object_group_members, object_group_members_green, object_group_members_red, object_group_mtime",
        ),
        (
            "trackme_common_permanently_deleted_objects",
            "_key, object, object_category, ctime",
        ),
        ("trackme_common_replica_trackers", "_key, tracker_name, knowledge_objects"),
        (
            "trackme_common_smartstatus_alert_action_last_seen_activity",
            "_key, object_category, object, last_seen_activity",
        ),
        (
            "trackme_common_disruption_queue",
            "_key, is_system_default, disruption_min_time_sec, disruption_start_epoch, object_state, mtime",
        ),
        (
            "trackme_notes",
            "_key, object_id, note, created_by, mtime",
        ),
        (
            "trackme_flx_drilldown_searches",
            "_key, tracker_name, drilldown_search, drilldown_search_earliest, drilldown_search_latest",
        ),
        (
            "trackme_flx_default_metric",
            "_key, tracker_name, metric_name",
        ),
    ]
)

# DSM
collections_list_dsm = [
    "trackme_dsm",
    "trackme_dsm_elastic_shared",
    "trackme_dsm_elastic_dedicated",
    "trackme_dsm_hybrid_trackers",
    "trackme_dsm_allowlist",
    "trackme_dsm_data_sampling",
    "trackme_dsm_data_sampling_custom_models",
    "trackme_dsm_knowledge",
    "trackme_dsm_outliers_entity_rules",
    "trackme_dsm_outliers_entity_data",
    "trackme_dsm_tags",
    "trackme_dsm_tags_policies",
    "trackme_dsm_priority",
    "trackme_dsm_priority_policies",
    "trackme_dsm_sla",
    "trackme_dsm_sla_policies",
    "trackme_dsm_sla_notifications",
    "trackme_dsm_delayed_entities_inspector",
]

persistent_fields_dsm = [
    "alias",
    "allow_adaptive_delay",
    "data_lag_alert_kpis",
    "data_max_delay_allowed",
    "data_max_lag_allowed",
    "monitoring_time_policy",
    "monitoring_time_rules",
    "data_monitoring_hours_ranges",
    "data_monitoring_wdays",
    "data_override_lagging_class",
    "future_tolerance",
    "min_dcount_field",
    "min_dcount_host",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "tags_manual",
]

# FLX
collections_list_flx = [
    "trackme_flx",
    "trackme_flx_hybrid_trackers",
    "trackme_flx_outliers_entity_rules",
    "trackme_flx_outliers_entity_data",
    "trackme_flx_tags",
    "trackme_flx_tags_policies",
    "trackme_flx_priority",
    "trackme_flx_priority_policies",
    "trackme_flx_sla",
    "trackme_flx_sla_policies",
    "trackme_flx_sla_notifications",
    "trackme_flx_allowlist",
    "trackme_flx_last_seen_activity",
    "trackme_flx_thresholds",
    "trackme_flx_drilldown_searches",
    "trackme_flx_default_metric",
]

persistent_fields_flx = [
    "alias",
    "monitoring_hours_ranges",
    "monitoring_time_policy",
    "monitoring_time_rules",
    "monitoring_wdays",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "tags_manual",
]

# FQM
collections_list_fqm = [
    "trackme_fqm",
    "trackme_fqm_hybrid_trackers",
    "trackme_fqm_outliers_entity_rules",
    "trackme_fqm_outliers_entity_data",
    "trackme_fqm_tags",
    "trackme_fqm_tags_policies",
    "trackme_fqm_priority",
    "trackme_fqm_priority_policies",
    "trackme_fqm_sla",
    "trackme_fqm_sla_policies",
    "trackme_fqm_sla_notifications",
    "trackme_fqm_allowlist",
    "trackme_fqm_last_seen_activity",
    "trackme_fqm_thresholds",
    "trackme_fqm_data_dictionary",
]

persistent_fields_fqm = [
    "alias",
    "monitoring_hours_ranges",
    "monitoring_time_policy",
    "monitoring_time_rules",
    "monitoring_wdays",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "tags_manual",
]

# DHM
collections_list_dhm = [
    "trackme_dhm",
    "trackme_dhm_allowlist",
    "trackme_dhm_outliers_entity_rules",
    "trackme_dhm_outliers_entity_data",
    "trackme_dhm_hybrid_trackers",
    "trackme_dhm_tags",
    "trackme_dhm_tags_policies",
    "trackme_dhm_priority",
    "trackme_dhm_priority_policies",
    "trackme_dhm_sla",
    "trackme_dhm_sla_policies",
    "trackme_dhm_sla_notifications",
    "trackme_dhm_delayed_entities_inspector",
]

persistent_fields_dhm = [
    "alias",
    "allow_adaptive_delay",
    "data_lag_alert_kpis",
    "data_max_delay_allowed",
    "data_max_lag_allowed",
    "monitoring_time_policy",
    "monitoring_time_rules",
    "data_monitoring_hours_ranges",
    "data_monitoring_wdays",
    "data_override_lagging_class",
    "future_tolerance",
    "host_idx_blocklists",
    "host_st_blocklists",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "splk_dhm_alerting_policy",
    "splk_dhm_st_summary_compact",
    "splk_dhm_st_summary_full",
    "tags_manual",
]

# MHM
collections_list_mhm = [
    "trackme_mhm",
    "trackme_mhm_allowlist",
    "trackme_mhm_lagging_classes",
    "trackme_mhm_hybrid_trackers",
    "trackme_mhm_tags",
    "trackme_mhm_tags_policies",
    "trackme_mhm_priority",
    "trackme_mhm_priority_policies",
    "trackme_mhm_sla",
    "trackme_mhm_sla_policies",
    "trackme_mhm_sla_notifications",
]

persistent_fields_mhm = [
    "alias",
    "metric_details_compact",
    "metric_details_full",
    "metric_max_lag_allowed",
    "metric_override_lagging_class",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "tags_manual",
]

# WLK
collections_list_wlk = [
    "trackme_wlk",
    "trackme_wlk_hybrid_trackers",
    "trackme_wlk_outliers_entity_rules",
    "trackme_wlk_outliers_entity_data",
    "trackme_wlk_versioning",
    "trackme_wlk_orphan_status",
    "trackme_wlk_apps_enablement",
    "trackme_wlk_last_seen_activity",
    "trackme_wlk_tags",
    "trackme_wlk_tags_policies",
    "trackme_wlk_priority",
    "trackme_wlk_priority_policies",
    "trackme_wlk_sla",
    "trackme_wlk_sla_policies",
    "trackme_wlk_sla_notifications",
    "trackme_wlk_allowlist",
]

persistent_fields_wlk = [
    "alias",
    "monitoring_hours_ranges",
    "monitoring_time_policy",
    "monitoring_time_rules",
    "monitoring_wdays",
    "monitored_state",
    "priority",
    "priority_updated",
    "priority_external",
    "priority_reason",
    "sla_class",
    "tags_manual",
]

# COMMON
collections_list_common = [
    "trackme_common_lagging_classes",
    "trackme_common_audit_changes",
    "trackme_common_alerts_ack",
    "trackme_common_logical_group",
    "trackme_common_permanently_deleted_objects",
    "trackme_common_replica_trackers",
    "trackme_common_smartstatus_alert_action_last_seen_activity",
    "trackme_common_disruption_queue",
    "trackme_notes",
    "trackme_stateful_alerting",
    "trackme_stateful_alerting_charts",
]
