
import import_declare_test

from splunktaucclib.rest_handler.endpoint import (
    field,
    validator,
    RestModel,
    MultipleModel,
)
from splunktaucclib.rest_handler import admin_external, util
from splunktaucclib.rest_handler.admin_external import AdminExternalHandler
import logging

util.remove_http_proxy_env_vars()


fields_trackme_general = [
    field.RestField(
        'max_multi_thread_workers',
        required=True,
        encrypted=False,
        default='16',
        validator=validator.Pattern(
            regex=r"""^[1-9][0-9]*$""", 
        )
    ), 
    field.RestField(
        'pagination_mode',
        required=True,
        encrypted=False,
        default='local',
        validator=validator.Pattern(
            regex=r"""^(local|remote)$""", 
        )
    ), 
    field.RestField(
        'pagination_size',
        required=True,
        encrypted=False,
        default='10000',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'trackme_default_sharing',
        required=True,
        encrypted=False,
        default='app',
        validator=validator.Pattern(
            regex=r"""^(app|global)$""", 
        )
    ), 
    field.RestField(
        'trackme_owner_default',
        required=True,
        encrypted=False,
        default='admin',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'trackme_admin_role_default',
        required=True,
        encrypted=False,
        default='trackme_admin',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'trackme_power_role_default',
        required=True,
        encrypted=False,
        default='trackme_power',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'trackme_user_role_default',
        required=True,
        encrypted=False,
        default='trackme_power',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'state_events_minimal',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'state_events_allowlist',
        required=True,
        encrypted=False,
        default='alias,anomaly_reason,keyid,object,object_category,priority,state,status_message,tags,tenant_id',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-,]+$""", 
        )
    ), 
    field.RestField(
        'state_events_blocklist',
        required=True,
        encrypted=False,
        default='_raw,info_max_time,info_min_time,info_search_time,info_sid,splk_dhm_st_summary,splk_dhm_st_summary_compact,splk_dhm_st_summary_full,metric_details,object_state,tracker_runtime,previous_tracker_runtime',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-,]+$""", 
        )
    ), 
    field.RestField(
        'enable_conf_manager_receiver',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'trackme_stateful_records_expiration_days',
        required=True,
        encrypted=False,
        default='30',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'trackme_stateful_charts_records_expiration_days',
        required=True,
        encrypted=False,
        default='2',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'trackme_ack_duration_default',
        required=True,
        encrypted=False,
        default='86400',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'trackme_ack_remove_on_reason_change',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'trackme_ack_remove_on_reason_change_min_time_sec',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'trackme_ack_remove_on_reason_change_auto_ack_only',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'trackme_ack_remove_when_green',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'allowed_email_domains',
        required=False,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'sender_email',
        required=True,
        encrypted=False,
        default='splunk',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'email_format',
        required=False,
        encrypted=False,
        default='html',
        validator=validator.Pattern(
            regex=r"""^(html|text)$""", 
        )
    ), 
    field.RestField(
        'email_footer',
        required=True,
        encrypted=False,
        default='This is an automated email, please do not reply directly to this email.',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    )
]
model_trackme_general = RestModel(fields_trackme_general, name='trackme_general')


fields_index_settings = [
    field.RestField(
        'trackme_idx_search_filter',
        required=True,
        encrypted=False,
        default='trackme_*',
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'trackme_notable_idx',
        required=True,
        encrypted=False,
        default='trackme_notable',
        validator=validator.String(
            max_len=80, 
            min_len=1, 
        )
    ), 
    field.RestField(
        'trackme_summary_idx',
        required=True,
        encrypted=False,
        default='trackme_summary',
        validator=validator.String(
            max_len=80, 
            min_len=1, 
        )
    ), 
    field.RestField(
        'trackme_metric_idx',
        required=True,
        encrypted=False,
        default='trackme_metrics',
        validator=validator.String(
            max_len=80, 
            min_len=1, 
        )
    ), 
    field.RestField(
        'trackme_audit_idx',
        required=True,
        encrypted=False,
        default='trackme_audit',
        validator=validator.String(
            max_len=80, 
            min_len=1, 
        )
    )
]
model_index_settings = RestModel(fields_index_settings, name='index_settings')


fields_trackme_ui_defaults = [
    field.RestField(
        'default_theme',
        required=True,
        encrypted=False,
        default='dark',
        validator=validator.Pattern(
            regex=r"""^(dark|light)$""", 
        )
    ), 
    field.RestField(
        'auto_refresh',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'auto_refresh_interval_seconds',
        required=True,
        encrypted=False,
        default='5',
        validator=validator.Pattern(
            regex=r"""^([5-9]|[1-9]\d|[12]\d{2}|300)$""", 
        )
    ), 
    field.RestField(
        'vtenants_card_detail_level',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    )
]
model_trackme_ui_defaults = RestModel(fields_trackme_ui_defaults, name='trackme_ui_defaults')


fields_splk_general = [
    field.RestField(
        'splk_general_idx_filter',
        required=True,
        encrypted=False,
        default='host=*',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_dsm_threshold_default',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_dsm_delay_default',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_dhm_threshold_default',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_dhm_delay_default',
        required=True,
        encrypted=False,
        default='86400',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_mhm_threshold_default',
        required=True,
        encrypted=False,
        default='900',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_feeds_future_tolerance',
        required=True,
        encrypted=False,
        default='-600',
        validator=validator.Pattern(
            regex=r"""^\-[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_feeds_delayed_inspector_24hours_range_min_sec',
        required=True,
        encrypted=False,
        default='14400',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_feeds_delayed_inspector_7days_range_min_sec',
        required=True,
        encrypted=False,
        default='43200',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_feeds_delayed_inspector_until_disabled_range_min_sec',
        required=True,
        encrypted=False,
        default='172800',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_feeds_auto_disablement_period',
        required=True,
        encrypted=False,
        default='60d',
        validator=validator.Pattern(
            regex=r"""^[0-9]*d$""", 
        )
    ), 
    field.RestField(
        'splk_general_elastic_max_concurrent',
        required=True,
        encrypted=False,
        default='3',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_workload_version_id_keys',
        required=True,
        encrypted=False,
        default='search,dispatch.earliest,dispatch.latest,description,cron_schedule,disabled,is_scheduled',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_,\.]*$""", 
        )
    ), 
    field.RestField(
        'splk_general_dsm_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (index="$data_index$" AND sourcetype="$data_sourcetype$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_dhm_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (host="$alias$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_mhm_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (host="$alias$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_flx_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (object="$object$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_fqm_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (object="$object$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_wlk_cmdb_search',
        required=True,
        encrypted=False,
        default='| inputlookup my_cmdb where (savedsearch_name="$savedsearch_name$")',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_dsm_docs_note_global',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_general_dsm_docs_link_global',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^https://.+$""", 
        )
    )
]
model_splk_general = RestModel(fields_splk_general, name='splk_general')


fields_splk_data_sampling = [
    field.RestField(
        'splk_data_sampling_min_time_btw_iterations_seconds',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_no_records_per_entity',
        required=True,
        encrypted=False,
        default='10000',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_no_records_saved_kvrecord',
        required=True,
        encrypted=False,
        default='10',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_records_kvrecord_truncate_size',
        required=True,
        encrypted=False,
        default='40000',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_pct_min_major_inclusive_model_match',
        required=True,
        encrypted=False,
        default='98',
        validator=validator.Pattern(
            regex=r"""^[0-9]*\.{0,1}[0-9]{0,2}$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_pct_max_exclusive_model_match',
        required=True,
        encrypted=False,
        default='95',
        validator=validator.Pattern(
            regex=r"""^[0-9]*\.{0,1}[0-9]{0,2}$""", 
        )
    ), 
    field.RestField(
        'splk_data_sampling_relative_time_window_seconds',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^[0-9]*$""", 
        )
    )
]
model_splk_data_sampling = RestModel(fields_splk_data_sampling, name='splk_data_sampling')


fields_splk_outliers_detection = [
    field.RestField(
        'splk_outliers_min_days_history',
        required=True,
        encrypted=False,
        default='7',
        validator=validator.Pattern(
            regex=r"""^\d*\.{0,1}\d{0,}$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_time_train_mlmodels_default',
        required=True,
        encrypted=False,
        default='604800',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_time_monitor_mlmodels_default',
        required=True,
        encrypted=False,
        default='3600',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_max_runtime_train_mlmodels_default',
        required=True,
        encrypted=False,
        default='900',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_max_days_since_last_train_default',
        required=True,
        encrypted=False,
        default='15',
        validator=validator.Pattern(
            regex=r"""^\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_disable_default',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_calculation_default',
        required=True,
        encrypted=False,
        default='stdev',
        validator=validator.Pattern(
            regex=r"""^(stdev|avg|max|min|sum|perc95|latest)$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_density_lower_threshold_default',
        required=True,
        encrypted=False,
        default='0.005',
        validator=validator.Pattern(
            regex=r"""^[\d|\.]*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_density_upper_threshold_default',
        required=True,
        encrypted=False,
        default='0.005',
        validator=validator.Pattern(
            regex=r"""^[\d|\.]*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_alert_lower_threshold_volume_default',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^[0-9]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_alert_upper_threshold_volume_default',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^[0-9]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_alert_lower_threshold_latency_default',
        required=True,
        encrypted=False,
        default='0',
        validator=validator.Pattern(
            regex=r"""^[0-9]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_alert_upper_threshold_latency_default',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^[0-9]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_period_default',
        required=True,
        encrypted=False,
        default='-30d',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_period_latest_default',
        required=True,
        encrypted=False,
        default='-1d',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_timefactor_default',
        required=True,
        encrypted=False,
        default='-30d',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_latency_kpi_metric_default',
        required=True,
        encrypted=False,
        default='None',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_detection_volume_kpi_metric_default',
        required=True,
        encrypted=False,
        default='splk.feeds.avg_eventcount_5m',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_auto_correct',
        required=True,
        encrypted=False,
        default='1',
        validator=validator.Pattern(
            regex=r"""^(1|0)$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_perc_min_lowerbound_deviation_default',
        required=True,
        encrypted=False,
        default='5.0',
        validator=validator.Pattern(
            regex=r"""^\d*\.\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_perc_min_upperbound_deviation_default',
        required=True,
        encrypted=False,
        default='5.0',
        validator=validator.Pattern(
            regex=r"""^\d*\.\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_mltk_algorithms_list',
        required=True,
        encrypted=False,
        default='DensityFunction',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-,]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_mltk_algorithms_default',
        required=True,
        encrypted=False,
        default='DensityFunction',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_fit_extra_parameters',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_apply_extra_parameters',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_boundaries_extraction_macro_default',
        required=True,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_boundaries_extraction_macros_list',
        required=True,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-,]+$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_static_lower_threshold_default',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^\d*\.\d*$""", 
        )
    ), 
    field.RestField(
        'splk_outliers_static_upper_threshold_default',
        required=False,
        encrypted=False,
        default='',
        validator=validator.Pattern(
            regex=r"""^\d*\.\d*$""", 
        )
    )
]
model_splk_outliers_detection = RestModel(fields_splk_outliers_detection, name='splk_outliers_detection')


fields_sla = [
    field.RestField(
        'sla_classes',
        required=True,
        encrypted=False,
        default='{"gold": {"sla_threshold": 14400, "rank": 3}, "silver": {"sla_threshold": 86400, "rank": 2}, "platinum": {"sla_threshold": 172800, "rank": 1}}',
        validator=validator.Pattern(
            regex=r"""^\{.*\}$""", 
        )
    ), 
    field.RestField(
        'sla_default_class',
        required=True,
        encrypted=False,
        default='silver',
        validator=validator.Pattern(
            regex=r"""^[a-zA-Z0-9_\-]+$""", 
        )
    ), 
    field.RestField(
        'sla_breaches_events_frequency',
        required=True,
        encrypted=False,
        default=604800,
        validator=validator.Pattern(
            regex=r"""^\d+$""", 
        )
    )
]
model_sla = RestModel(fields_sla, name='sla')


fields_maintenance = [
    field.RestField(
        'maintenance_kdb_exclusion_behaviour',
        required=True,
        encrypted=False,
        default='planned',
        validator=validator.Pattern(
            regex=r"""^(exclude|include)$""", 
        )
    )
]
model_maintenance = RestModel(fields_maintenance, name='maintenance')


fields_logging = [
    field.RestField(
        'loglevel',
        required=True,
        encrypted=False,
        default='INFO',
        validator=validator.Pattern(
            regex=r"""^DEBUG|INFO|WARNING|ERROR|CRITICAL$""", 
        )
    )
]
model_logging = RestModel(fields_logging, name='logging')


endpoint = MultipleModel(
    'trackme_settings',
    models=[
        model_trackme_general, 
        model_index_settings, 
        model_trackme_ui_defaults, 
        model_splk_general, 
        model_splk_data_sampling, 
        model_splk_outliers_detection, 
        model_sla, 
        model_maintenance, 
        model_logging
    ],
    need_reload=False,
)


if __name__ == '__main__':
    logging.getLogger().addHandler(logging.NullHandler())
    admin_external.handle(
        endpoint,
        handler=AdminExternalHandler,
    )
