require([
  "underscore",
  "jquery",
  "splunkjs/mvc",
  "splunkjs/mvc/searchmanager",
  "splunkjs/mvc/searchbarview",
  "splunkjs/mvc/eventsviewerview",
  "splunkjs/mvc/tableview",
  "splunkjs/mvc/resultslinkview",
  "splunkjs/mvc/simplexml/ready!",
], function (
  _,
  $,
  mvc,
  SearchManager,
  SearchBarView,
  EventsViewer,
  TableView,
  ResultsLinkView
) {
  //
  // Tokens
  //

  var defaultTokenModel = mvc.Components.getInstance("default", {
    create: true,
  });
  var submittedTokenModel = mvc.Components.getInstance("submitted", {
    create: true,
  });

  function setToken(name, value) {
    defaultTokenModel.set(name, value);
    submittedTokenModel.set(name, value);
  }

  //
  // Handle search elements
  //

  $(".view-elements").hover(
    function () {
      var childdiv = "#resultsLink" + this.id;
      $(childdiv).attr("style", "display: inline-block !important");
    },
    function () {
      var childdiv = "#resultsLink" + this.id;

      $(childdiv).hover(
        function () {
          $(childdiv).attr("style", "display: inline-block !important");
        },
        function () {
          $(childdiv).attr("style", "display: none !important");
        }
      );

      $(childdiv).attr("style", "display: none !important");
    }
  );

  //
  // Search Managers
  //

  var searchApiCli = new SearchManager(
    {
      id: "searchApiCli",
      search:
        '| trackmeapiautodocs target="endpoints" | search resource_group="$tk_resource_group$"',
      earliest_time: "-5m",
      latest_time: "now",
      autostart: true,
    },
    { tokens: true }
  );

  var searchTrackmeCli = new SearchManager({
    id: "searchTrackmeCli",
    search:
      '| trackme url="/services/trackme/v2/vtenants/show_tenants" mode="get"',
    earliest_time: "-5m",
    latest_time: "now",
    autostart: true,
  });

  var searchApiCliGrps = new SearchManager(
    {
      id: "searchApiCliGrps",
      search:
        '| trackmeapiautodocs target="groups" | where isnotnull(resource_group) | table resource_group, resource_desc | sort 0 resource_group',
      earliest_time: "-5m",
      latest_time: "now",
      autostart: true,
    },
    { tokens: true }
  );

  //
  //
  //

  // API docs groups

  var tableApiCliGrps = new TableView(
    {
      id: "tableApiCliGrps",
      drilldown: "row",
      managerid: "searchApiCliGrps",
      pageSize: "50",
      wrap: "true",
      el: $("#tableApiCliGrps"),
    },
    {
      tokens: true,
    }
  ).render();

  tableApiCliGrps.on("click", function (e) {
    if (e.field !== undefined) {
      e.preventDefault();
      setToken("tk_resource_group", e.data["row.resource_group"]);
      searchApiCli.startSearch();
      searchBarApiCli.val(
        '| trackmeapiautodocs target="endpoints" | search resource_group="' +
          e.data["row.resource_group"] +
          '"'
      );
    }
  });

  var resultsLinktableApiCliGrps = new ResultsLinkView({
    id: "resultsLinktableApiCliGrps",
    managerid: "searchApiCliGrps",
    "link.exportResults.visible": false,
    el: $("#resultsLinktableApiCliGrps"),
  });

  resultsLinktableApiCliGrps
    .render()
    .$el.appendTo($("resultsLinktableApiCliGrps"));

  //
  //
  //

  // API docs Search bar

  var searchBarApiCli = new SearchBarView({
    searchWhenChanged: true,
    id: "searchBarApiCli",
    managerid: "searchApiCli",
    el: $("#searchBarApiCli"),
  }).render();

  searchBarApiCli.on("change", function () {
    searchApiCli.set("search", searchBarApiCli.val());
  });

  var timeRangeApiCli = searchBarApiCli.timerange;

  timeRangeApiCli.on("change", function () {
    searchApiCli.search.set(timeRangeApiCli.val());
  });

  var eventViewerApiCli = new EventsViewer({
    searchWhenChanged: true,
    id: "eventViewerApiCli",
    drilldown: "none",
    managerid: "searchApiCli",
    rowNumbers: false,
    count: 5,
    el: $("#eventViewerApiCli"),
  }).render();

  var resultsLinkeventViewerApiCli = new ResultsLinkView({
    id: "resultsLinkeventViewerApiCli",
    managerid: "searchApiCli",
    "link.exportResults.visible": false,
    el: $("#resultsLinkeventViewerApiCli"),
  });

  resultsLinkeventViewerApiCli
    .render()
    .$el.appendTo($("resultsLinkeventViewerApiCli"));

  //
  //
  //

  // trackme Search bar
  var searchBarTrackmeCli = new SearchBarView({
    searchWhenChanged: true,
    id: "searchBarTrackmeCli",
    managerid: "searchTrackmeCli",
    el: $("#searchBarTrackmeCli"),
  }).render();

  searchBarTrackmeCli.on("change", function () {
    searchTrackmeCli.set("search", searchBarTrackmeCli.val());
  });

  var timeRangeTrackmeCli = searchBarTrackmeCli.timerange;

  timeRangeTrackmeCli.on("change", function () {
    searchTrackmeCli.search.set(timeRangeTrackmeCli.val());
  });

  var eventViewerTrackmeCli = new EventsViewer({
    searchWhenChanged: true,
    id: "eventViewerTrackmeCli",
    managerid: "searchTrackmeCli",
    rowNumbers: false,
    el: $("#eventViewerTrackmeCli"),
  }).render();

  var resultsLinkeventViewerTrackmeCli = new ResultsLinkView({
    id: "resultsLinkeventViewerTrackmeCli",
    managerid: "searchTrackmeCli",
    "link.exportResults.visible": false,
    el: $("#resultsLinkeventViewerTrackmeCli"),
  });

  resultsLinkeventViewerTrackmeCli
    .render()
    .$el.appendTo($("resultsLinkeventViewerTrackmeCli"));

  //
  //
  //
});
