const { Callbacks } = require("jquery");

require([
  "jquery",
  "underscore",
  "splunkjs/mvc",
  "splunkjs/mvc/simplexml/ready!",
], function ($, _, mvc) {

  function getSplunkUrl(path) {
    return Splunk.util.make_url(path);
  }

  //
  // ajax promise for API calls
  //

  async function asyncAjax(ajaxurl, ajaxType, ajaxdata) {
    var resultCall;
    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
        data: JSON.stringify(ajaxdata),
      });
      return resultCall;
    } catch (error) {
      // notify error
      cssloaderremove();
      message =
        "ERROR: hum, something went quite wrong while attempting the REST call: " +
        JSON.stringify(error);
      $("#modal_generic_error").find(".modal-error-message p").text(message);
      $("#modal_generic_error").modal();
    }
  }

  // syntax highlighting for JSON
  function syntaxHighlight(json) {
    json = json
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;");
    return json.replace(
      /("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,
      function (match) {
        var cls = "json-preview-number";
        if (/^"/.test(match)) {
          if (/:$/.test(match)) {
            cls = "json-preview-key";
          } else {
            cls = "json-preview-string";
          }
        } else if (/true|false/.test(match)) {
          cls = "json-preview-boolean";
        } else if (/null/.test(match)) {
          cls = "json-preview-null";
        }
        return '<span class="' + cls + '">' + match + "</span>";
      }
    );
  }

  function download(file, text) {
    //creating an invisible element
    var element = document.createElement("a");
    element.setAttribute(
      "href",
      "data:text/plain;charset=utf-8, " + encodeURIComponent(text)
    );
    element.setAttribute("download", file);
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
  }

  //
  // cssloader
  //

  function cssloader(msg) {
    $("#cssloader").remove();
    $("body").append(
      '<div id="cssloader" class="loader loader-default is-active" data-text="' +
        msg +
        '"></div>'
    );
  }

  function cssloaderremove() {
    $("#cssloader").remove();
  }

  //
  // check level of permissions, disable tenant creation and management if the user does not have the proper level of privileges
  //

  async function checkPrivileges() {
    var ajaxurl =
      getSplunkUrl("/splunkd/__raw/services/trackme/v2/configuration/trackme_check_privileges_level");
    var ajaxType = "GET";
    var resultCall;

    var defaultTokenModel = mvc.Components.getInstance("default", {
      create: true,
    });
    var submittedTokenModel = mvc.Components.getInstance("submitted", {
      create: true,
    });

    function setToken(name, value) {
      defaultTokenModel.set(name, value);
      submittedTokenModel.set(name, value);
    }

    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
      });
      userLevel = resultCall.user_level;
      setToken("userLevel", userLevel);
      if (userLevel != "admin") {
        $("#btn_set_license").prop("disabled", true);
        $("#modal_authorization_error").modal();
        return "stop";
      }
      return resultCall;
    } catch (error) {
      console.error(error);
    }
  }

  function verifyLicense() {
    // Set license
    $.ajax({
      url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/license_status"),
      type: "GET",
      async: true,
      contentType: "application/json",
      success: function (resultCall) {
        var licenseIsValid = resultCall["license_is_valid"];
        var licenseType = resultCall["license_type"];
        var licenseSubscriptionClass = resultCall["license_subscription_class"];

        // Empty
        $("#licenseInfo").empty();

        // Check
        if (licenseIsValid == 1) {
          var licenseLabel;
          if (licenseSubscriptionClass === "unlimited") {
            licenseLabel = "Unlimited";
          } else if (licenseSubscriptionClass === "enterprise") {
            licenseLabel = "Enterprise";
          } else if (licenseSubscriptionClass === "free_extended") {
            licenseLabel = "Free extended";
          }
          //
          if (licenseType === "subscription") {
            $("#licenseInfo").append(
              '<div style="margin-top:14px; height: 40px;">' +
                '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in ' +
                licenseLabel +
                " edition:</h2>" +
                "<h3>Expiration: " +
                resultCall["license_expiration"] +
                "</h3>" +
                '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
                "</div>"
            );
            // enable download license file
            $("#btn_download_licensefile").prop("disabled", false);
          } else if (licenseType === "trial") {
            $("#licenseInfo").append(
              '<div style="margin-top:14px; height: 40px;">' +
                '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in Trial edition:</h2>' +
                "<h3>Expiration: " +
                resultCall["license_expiration"] +
                "</h3>" +
                '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
                "</div>"
            );
            // enable download license file
            $("#btn_download_licensefile").prop("disabled", false);
          } else if (licenseType === "developer") {
            $("#licenseInfo").append(
              '<div style="margin-top:14px; height: 40px;">' +
                '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in Developer mode:</h2>' +
                "<h3>Expiration: " +
                resultCall["license_expiration"] +
                "</h3>" +
                "<h3>You are free to use all features with no resttrictions for a personal usage only, using the developer mode in a Production environment is a breach to the EULA aggreement.</h3>" +
                '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
                "</div>"
            );
            // disable download license file
            $("#btn_download_licensefile").prop("disabled", true);
          }

          $("#btn_confirm_license_key").prop("disabled", false);
          $("#btn_request_trial").prop("disabled", true);
          $("#btn_request_developer").prop("disabled", true);
          // show license signature
          $("#current-license-signature").html(
            '<pre class="create-json-preview">' +
              syntaxHighlight(JSON.stringify(resultCall, null, 2)) +
              "</pre>"
          );
          $("#current-license").css("display", "inherit");

          // Start file download.
          document.getElementById("btn_download_licensefile").addEventListener(
            "click",
            function () {
              var text = JSON.stringify(
                JSON.parse(resultCall["license_string"])
              );
              var filename = "trackme_license.txt";
              download(filename, text);
            },
            false
          );

          //
        } else {
          //
          $("#licenseInfo").append(
            '<div style="margin-top: 15px; margin-bottom: 15px; height: 40px;">' +
              '<h2 style="color: dodgerblue;">TrackMe is not currently registered and operating in Free limited edition.</h2>' +
              "<h3>Use the add license key button to activate a valid license key, or use the Trial service to immediately start a 30 days trial of TrackMe. (for a standalone Search Head or Search Head Cluster)<h3>" +
              "<h3>At the end of the trial period and if you have not entered a valid license key, TrackMe will return to the Free limited edition mode.</h3>" +
              '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
              "</div>"
          );
          $("#btn_confirm_license_key").prop("disabled", false);
          $("#btn_request_trial").prop("disabled", false);
          $("#btn_request_developer").prop("disabled", false);
          $("#current-license").css("display", "none");
          //
        }
        //
      },
      error: function (xhr, textStatus, error) {
        cssloaderremove();
        message =
          "server response: " +
          xhr.responseText +
          "\n - http response: " +
          error +
          "\n - text status: " +
          textStatus;
        $("#modal_generic_error").find(".modal-error-message p").text(message);
        $("#modal_generic_error").modal();
      },
    });
  }

  //
  // Verify License Status
  //

  var doAsync = asyncAjax(
    getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/license_status"),
    "GET"
  ).then(function (resultCall) {
    cssloaderremove();
    var licenseIsValid = resultCall["license_is_valid"];
    var licenseType = resultCall["license_type"];
    var licenseSubscriptionClass = resultCall["license_subscription_class"];

    // token model
    var defaultTokenModel = mvc.Components.getInstance("default", {
      create: true,
    });
    var submittedTokenModel = mvc.Components.getInstance("submitted", {
      create: true,
    });

    function getToken(name) {
      var ret = null;
      if (defaultTokenModel.get(name) != undefined) {
        ret = defaultTokenModel.get(name);
      } else if (submittedTokenModel.get(name) != undefined) {
        ret = submittedTokenModel.get(name);
      }
      return ret;
    }

    //
    if (licenseIsValid == 1) {
      var licenseLabel;
      if (licenseSubscriptionClass === "unlimited") {
        licenseLabel = "Unlimited";
      } else if (licenseSubscriptionClass === "enterprise") {
        licenseLabel = "Enterprise";
      } else if (licenseSubscriptionClass === "free_extended") {
        licenseLabel = "Free extended";
      }
      //
      if (licenseType === "subscription") {
        $("#licenseInfo").append(
          '<div style="margin-top:14px; height: 40px;">' +
            '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in ' +
            licenseLabel +
            " edition:</h2>" +
            "<h3>Expiration: " +
            resultCall["license_expiration"] +
            "</h3>" +
            '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
            "</div>"
        );
        // enable download license file
        $("#btn_download_licensefile").prop("disabled", false);
      } else if (licenseType === "trial") {
        $("#licenseInfo").append(
          '<div style="margin-top:14px; height: 40px;">' +
            '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in Trial edition:</h2>' +
            "<h3>Expiration: " +
            resultCall["license_expiration"] +
            "</h3>" +
            '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
            "</div>"
        );
        // enable download license file
        $("#btn_download_licensefile").prop("disabled", false);
      } else if (licenseType === "developer") {
        $("#licenseInfo").append(
          '<div style="margin-top:14px; height: 40px;">' +
            '<h2 style="color: dodgerblue;">TrackMe is currently registered and operating in Developer mode:</h2>' +
            "<h3>Expiration: " +
            resultCall["license_expiration"] +
            "</h3>" +
            "<h3>You are free to use all features with no resttrictions for a personal usage only, using the developer mode in a Production environment is a breach to the EULA aggreement.</h3>" +
            '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
            "</div>"
        );
        // disable download license file
        $("#btn_download_licensefile").prop("disabled", true);
      }
      $("#btn_confirm_license_key").prop("disabled", false);
      $("#btn_request_trial").prop("disabled", true);
      $("#btn_request_developer").prop("disabled", true);
      // show license signature
      $("#current-license-signature").html(
        '<pre class="create-json-preview">' +
          syntaxHighlight(JSON.stringify(resultCall, null, 2)) +
          "</pre>"
      );
      $("#current-license").css("display", "inherit");
      // Start file download.
      $("#btn_download_licensefile")
        .unbind()
        .click(function () {
          var text = JSON.stringify(JSON.parse(resultCall["license_string"]));
          var filename = "trackme_license.txt";
          download(filename, text);
        });
      //
    } else {
      //
      $("#licenseInfo").append(
        '<div style="margin-top: 15px; margin-bottom: 15px; height: 40px;">' +
          '<h2 style="color: dodgerblue;">TrackMe is not currently registered and operating in Free limited edition.</h2>' +
          "<h3>Use the add license key button to activate a valid license key, or use the Trial service to immediately start a 30 days trial of TrackMe. (for a standalone Search Head or Search Head Cluster)<h3>" +
          "<h3>At the end of the trial period and if you have not entered a valid license key, TrackMe will return to the Free limited edition mode.</h3>" +
          '<h3>Contact us at: <a href="mailto:support@trackme-solutions.com">support@trackme-solutions.com</a></h3>' +
          "</div>"
      );
      $("#btn_confirm_license_key").prop("disabled", false);
      $("#btn_request_trial").prop("disabled", false);
      $("#btn_request_developer").prop("disabled", false);
      $("#current-license").css("display", "none");
      //
    }

    // Verify the user privileges, and stop here if needed
    checkPrivileges();
    //if (getToken("userLevel") != "admin") {
    //  $("#modal_authorization_error").modal();
    // return "stop";
    //}

    // Set license
    $(function () {
      $("#input_license_key").keyup(function () {
        if ($(this).val() == "") {
          // Check to see if there is any text entered
          $("#btn_confirm_license_key").prop("disabled", true);
        } else {
          $("#btn_confirm_license_key").prop("disabled", false);
        }
      });
    });

    //
    // Open license main modal
    //

    $("#btn_set_license")
      .unbind()
      .click(function () {
        $("#modal_main_license").modal();
      });

    // Open license upload modal
    $("#btn_modal_upload_licensefile")
      .unbind()
      .click(function () {
        $("#modal_upload_license").modal();
      });

    // Open modal for license file upload
    $("#btn_online_license_key")
      .unbind()
      .click(function () {
        $("#modal_enter_license").modal();
      });

    // Handle fileupload

    function uploadLicenseFile(id) {
      var [file] = document.getElementById(id).files;
      var reader = new FileReader();

      reader.addEventListener(
        "load",
        () => {
          // return the file content and update the textarea
          var licenseStr = reader.result;

          // cssloader
          cssloader("Please wait while activating the license...");

          // Run the REST call
          // Set license
          $.ajax({
            url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/admin/upload_license_file"),
            type: "POST",
            async: true,
            contentType: "application/json",
            data: JSON.stringify({ license_file: licenseStr }),
            success: function (returneddata) {
              // cssloader
              cssloaderremove();
              // update
              verifyLicense();
              // notify
              notify(
                "success",
                "bottom",
                "Thank you, TrackMe is now successfully registered.",
                "5"
              );
              // show modal
              $("#modal_license_success").modal();
              //
            },
            error: function (xhr, textStatus, error) {
              $("#cssloader").remove();
              message =
                "server response: " +
                xhr.responseText +
                "\n - http response: " +
                error +
                "\n - text status: " +
                textStatus;
              $("#modal_generic_error")
                .find(".modal-error-message p")
                .text(message);
              $("#modal_generic_error").modal();
            },
          });
        },
        false
      );

      if (file) {
        reader.readAsText(file);
      }
    }

    $("#btn_confirm_upload")
      .unbind()
      .click(function () {
        uploadLicenseFile("input_fileupload");
      });

    // Open modal for license key input
    $("#btn_online_license_key")
      .unbind()
      .click(function () {
        $("#modal_enter_license").modal();
      });

    // Proceed set license
    $("#btn_confirm_license_key")
      .unbind()
      .click(function () {
        // cssloader
        cssloader("Please wait while activating the license...");

        // Get license key
        var new_license_key =
          document.getElementById("input_license_key").value;

        // Set license
        $.ajax({
          url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/admin/set_license"),
          type: "POST",
          async: true,
          contentType: "application/json",
          data: JSON.stringify({ license_key: new_license_key }),
          success: function (returneddata) {
            // cssloader
            cssloaderremove();
            // update
            verifyLicense();
            // notify
            notify(
              "success",
              "bottom",
              "Thank you, TrackMe is now successfully registered.",
              "5"
            );
            // show modal
            $("#modal_license_success").modal();
            //
          },
          error: function (xhr, textStatus, error) {
            $("#cssloader").remove();
            message =
              "server response: " +
              xhr.responseText +
              "\n - http response: " +
              error +
              "\n - text status: " +
              textStatus;
            $("#modal_generic_error")
              .find(".modal-error-message p")
              .text(message);
            $("#modal_generic_error").modal();
          },
        });
      });

    // Open modal for Trial request
    $("#btn_request_trial")
      .unbind()
      .click(function () {
        $("#modal_trial_confirm").modal();
      });

    // Proceed Trial
    $("#btn_start_trial")
      .unbind()
      .click(function () {
        // cssloader
        cssloader("Please wait while setting up the trial license...");
        // Set license
        $.ajax({
          url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/admin/start_trial"),
          type: "POST",
          async: true,
          contentType: "application/json",
          success: function (returneddata) {
            // cssloader
            cssloaderremove();
            // update
            verifyLicense();
            // notify
            notify(
              "success",
              "bottom",
              "Thank you, your Trial period has been successfully registered, TrackMe is now registered for the time being of the Trial.",
              "5"
            );
            // show modal
            $("#modal_trial_success").modal();
            //
          },
          error: function (xhr, textStatus, error) {
            cssloaderremove();
            message =
              "server response: " +
              xhr.responseText +
              "\n - http response: " +
              error +
              "\n - text status: " +
              textStatus;
            $("#modal_generic_error")
              .find(".modal-error-message p")
              .text(message);
            $("#modal_generic_error").modal();
          },
        });
      });

    // Open modal for Developer mode
    $("#btn_request_developer")
      .unbind()
      .click(function () {
        $("#modal_developer_confirm").modal();
      });

    // Proceed developer mode
    $("#btn_confirm_developer")
      .unbind()
      .click(function () {
        // cssloader
        cssloader("Please wait while setting up the developer mode...");
        // Set license
        $.ajax({
          url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/admin/enable_developer_license"),
          type: "POST",
          async: true,
          contentType: "application/json",
          success: function (returneddata) {
            // cssloader
            cssloaderremove();
            // update
            verifyLicense();
            // notify
            notify(
              "success",
              "bottom",
              "Thank you, TrackMe is now registered in developer mode for the time being of the initial period, come back to this screen to re-enable the developer mode after its expiration.",
              "5"
            );
            // show modal
            $("#modal_developer_mode_success").modal();
            //
          },
          error: function (xhr, textStatus, error) {
            cssloaderremove();
            message =
              "server response: " +
              xhr.responseText +
              "\n - http response: " +
              error +
              "\n - text status: " +
              textStatus;
            $("#modal_generic_error")
              .find(".modal-error-message p")
              .text(message);
            $("#modal_generic_error").modal();
          },
        });
      });

    // Open modal for licensing status reset
    $("#btn_reset_license")
      .unbind()
      .click(function () {
        $("#modal_reset_confirm").modal();
      });

    // Proceed reset
    $("#btn_confirm_reset")
      .unbind()
      .click(function () {
        // cssloader
        cssloader(
          "Please wait while reseting the license registration status..."
        );
        // Set license
        $.ajax({
          url: getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/admin/reset_license"),
          type: "POST",
          async: true,
          contentType: "application/json",
          success: function (returneddata) {
            // cssloader
            cssloaderremove();
            // update
            verifyLicense();
            // notify
            notify(
              "success",
              "bottom",
              "TrackMe license status registration was successfully reset.",
              "5"
            );
            // show modal
            $("#modal_reset_success").modal();
            //
          },
          error: function (xhr, textStatus, error) {
            cssloaderremove();
            message =
              "server response: " +
              xhr.responseText +
              "\n - http response: " +
              error +
              "\n - text status: " +
              textStatus;
            $("#modal_generic_error")
              .find(".modal-error-message p")
              .text(message);
            $("#modal_generic_error").modal();
          },
        });
      });

    //
    // Notify
    //

    function notify(varCss, varPosition, varHtml, vardelay) {
      require([
        "jquery",
        getSplunkUrl("/static/app/trackme/notifybar/jquery.notifyBar.js"),
      ], function ($) {
        //code here
        jQuery(function () {
          jQuery.notifyBar({
            cssClass: varCss,
            position: varPosition,
            html: varHtml,
            delay: vardelay,
          });
        });
      });
    }

    //
    // END
    //
  });
});
