const { Callbacks } = require("jquery");

require([
  "jquery",
  "underscore",
  "splunkjs/mvc",
  "splunkjs/mvc/utils",
  "splunkjs/mvc/searchmanager",
  "splunkjs/mvc/postprocessmanager",
  "splunkjs/mvc/singleview",
  "splunkjs/mvc/multidropdownview",
  "splunkjs/mvc/simplexml/searcheventhandler",
  Splunk.util.make_url("/static/app/trackme/momentjs/moment.js"),
  Splunk.util.make_url("/static/app/trackme/tabulator/js/tabulator.js"),
  "splunkjs/mvc/simplexml/ready!",
], function (
  $,
  _,
  mvc,
  utils,
  SearchManager,
  PostProcessManager,
  SingleView,
  MultiDropdownView,
  SearchEventHandler,
  moment,
  TabulatorFull
) {
  //
  // Functions
  //

  function getSplunkUrl(path) {
    return Splunk.util.make_url(path);
  }

  // TOKENS

  var defaultTokenModel = mvc.Components.getInstance("default", {
    create: true,
  });

  var submittedTokenModel = mvc.Components.getInstance("submitted", {
    create: true,
  });

  function setToken(name, value) {
    defaultTokenModel.set(name, value);
    submittedTokenModel.set(name, value);
  }

  function getToken(name) {
    var ret = null;
    if (defaultTokenModel.get(name) != undefined) {
      ret = defaultTokenModel.get(name);
    } else if (submittedTokenModel.get(name) != undefined) {
      ret = submittedTokenModel.get(name);
    }
    return ret;
  }

  function unsetToken(name) {
    defaultTokenModel.unset(name);
    submittedTokenModel.unset(name);
  }

  function loadTabulatorTheme(tabulator_theme) {
    if (tabulator_theme === "dark_site") {
      loadCss(Splunk.util.make_url("/static/app/trackme/tabulator/css/tabulator_site_dark.css"));
    } else if (tabulator_theme === "dark_midnight") {
      loadCss(Splunk.util.make_url("/static/app/trackme/tabulator/css/tabulator_midnight.css"));
    } else if (tabulator_theme === "light") {
      loadCss(Splunk.util.make_url("/static/app/trackme/tabulator/css/tabulator.css"));
    } else if (tabulator_theme === "light_site") {
      loadCss(Splunk.util.make_url("/static/app/trackme/tabulator/css/tabulator_site.css"));
    } else if (tabulator_theme === "light_modern") {
      loadCss(Splunk.util.make_url("/static/app/trackme/tabulator/css/tabulator_modern.css"));
    }
  }

  function loadCss(href) {
    const link = document.createElement("link");
    link.href = href;
    link.type = "text/css";
    link.rel = "stylesheet";
    document.head.appendChild(link);
  }

  //
  // ajax promise for API calls
  //

  async function asyncAjax(ajaxurl, ajaxType, ajaxdata) {
    var resultCall;
    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
        data: JSON.stringify(ajaxdata),
      });
      return resultCall;
    } catch (error) {
      closeModals();
      $("#modal_update_collection_failure_return")
        .find(".modal-error-message p")
        .text(JSON.stringify(error));
      $("#modal_update_collection_failure_return").modal();
    }
  }

  //
  // Notify
  //

  function notify(varCss, varPosition, varHtml, vardelay) {
    require([
      "jquery",
      getSplunkUrl("/static/app/trackme/notifybar/jquery.notifyBar.js"),
    ], function ($) {
      //code here
      jQuery(function () {
        jQuery.notifyBar({
          cssClass: varCss,
          position: varPosition,
          html: varHtml,
          delay: vardelay,
        });
      });
    });
  }

  //
  // Close all modals
  //

  function closeModals() {
    $(".modal").modal("hide");
  }

  //
  // Get comment from textaread
  //

  function getComment(inputId) {
    // Retrieve update comment if any
    var tk_comment = document.getElementById(inputId).value;

    // if is not defined, give it a value and override text box content
    if (tk_comment == "null") {
      tk_comment = "No comments for update.";
    } else if (tk_comment == "update note") {
      tk_comment = "No comment for update.";
    }
    return tk_comment;
  }

  function cssloader(msg) {
    $("#cssloader").remove();
    $("body").append(
      '<div id="cssloader" class="loader loader-default is-active" data-text="' +
        msg +
        '"></div>'
    );
  }

  function cssloaderremove() {
    $("#cssloader").remove();
  }

  //
  // check level of permissions, disable tenant creation and management if the user does not have the proper level of privileges
  //

  async function checkPrivileges() {
    var ajaxurl =
      getSplunkUrl("/splunkd/__raw/services/trackme/v2/configuration/trackme_check_privileges_level");
    var ajaxType = "GET";
    var resultCall;

    var defaultTokenModel = mvc.Components.getInstance("default", {
      create: true,
    });
    var submittedTokenModel = mvc.Components.getInstance("submitted", {
      create: true,
    });

    function setToken(name, value) {
      defaultTokenModel.set(name, value);
      submittedTokenModel.set(name, value);
    }

    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
      });
      userLevel = resultCall.user_level;
      setToken("userLevel", userLevel);

      // load user preferences
      var user_prefs_conf = resultCall.user_prefs;

      // load Tabulator theme
      document.addEventListener(
        "DOMContentLoaded",
        loadTabulatorTheme(user_prefs_conf.tabulator_theme_vtenant_ui)
      );

      // hide buttons based on user level
      if (userLevel === "user") {
        $("#div-actions").hide();
      } else if (userLevel === "power") {
        $("#div-actions").show();
      } else {
        $("#div-actions").show();
      }
      return resultCall;
    } catch (error) {
      console.error(error);
    }
  }

  // verify user privileges level
  checkPrivileges();

  //
  // tenants dropdown
  //

  var searchListTenants = new SearchManager({
    id: "searchListTenants",
    search:
      '| inputlookup trackme_virtual_tenants where tenant_status="enabled" | eval keyid=_key | stats count by tenant_id | table tenant_id | sort 0 tenant_id',
    earliest_time: "-5m",
    latest_time: "now",
    autostart: true,
  });

  var inputListTenants = new MultiDropdownView(
    {
      searchWhenChanged: true,
      id: "inputListTenants",
      managerid: "searchListTenants",
      default: "*",
      choices: [
        {
          label: "any",
          value: "*",
        },
      ],
      labelField: "tenant_id",
      valueField: "tenant_id",
      value: "$tk_tenants_scope$",
      el: $("#inputListTenants"),
    },
    {
      tokens: true,
    }
  ).render();

  //
  // Handle html textarea
  //

  $(".custom-textarea").each(function () {
    var $text_group = $(this);
    $text_group.find("textarea").on("click", function () {
      var $text = $(this);
      if (this.value == this.defaultValue) this.value = "";
      $(this).blur(function () {
        if (this.value == "") this.value = this.defaultValue;
      });
    });
  });

  // maintenance-kdb tabulator
  function maintenanceKdbHandlerTable(ajaxUrl, ajaxType, ajaxData) {
    // Run the ajax promise
    var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
      resultCall
    ) {
      // count the number of item in the array and update the title
      var no_items = resultCall.length;
      $("#divTitleCount").html(
        '<h1><span style="color: #a7c7e7;">' +
          no_items +
          " record(s) in the Maintenance Knowledge DataBase currently</span></h1>"
      );

      function tenantsScopeFormatter(cell, formatterParams, onRendered) {
        var cellValue = cell.getValue();

        // Check if cellValue is already an object
        if (typeof cellValue === "object") {
          if (cellValue.length === 1 && cellValue[0].trim() === "*") {
            cellValue = "*";
          } else {
            cell.getElement().style.whiteSpace = "pre-wrap"; // allow cell to take up multiple lines of text
            cellValue = JSON.stringify(cellValue, null, 1);
          }
        } else if (typeof cellValue === "string" && cellValue.includes(",")) {
          // if cellValue is a comma-separated string, turn it into a list
          var cellValueArray = cellValue.split(",");

          // Check if the array has only one value which is "*"
          if (cellValueArray.length === 1 && cellValueArray[0].trim() === "*") {
            cellValue = "*";
          } else {
            cell.getElement().style.whiteSpace = "pre-wrap"; // allow cell to take up multiple lines of text
            cellValue = JSON.stringify(cellValueArray, null, 1);
          }
        }
        console.log("cellValue: ", cellValue);
        return cellValue;
      }

      // set the table div
      var tabulatorElement = "#" + "maintenance-kdb-table";

      var table = new TabulatorFull(tabulatorElement, {
        data: resultCall,
        index: "_key",
        layout: "fitDataStretch", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        pagination: "local", //paginate the data
        paginationSize: 50, //allow 50 rows per page of data
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // fixed height
        initialSort: [
          //set the initial sort order of the data
          { column: "time_end_epoch", dir: "desc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Current records in the database",
            columns: [
              //define the table columns
              {
                title: "record_id",
                field: "_key",
              },
              {
                title: "tenants_scope",
                field: "tenants_scope",
                headerFilter: true,
                formatter: tenantsScopeFormatter,
              },
              {
                title: "Enabled",
                field: "enabled",
                hozAlign: "center",
                formatter: "tickCross",
                width: 100,
                headerFilter: "input",
                editor: "list",
                editorParams: { values: [false, true] },
              },
              {
                title: "Type",
                field: "type",
                headerFilter: "input",
                editor: "list",
                editorParams: { values: ["planned", "unplanned"] },
              },
              {
                title: "Time Start",
                field: "time_start",
                headerFilter: true,
                minWidth: 200,
              },
              {
                title: "Time End",
                field: "time_end",
                headerFilter: true,
                minWidth: 200,
              },
              {
                title: "Time End Epoch",
                field: "time_end_epoch",
                visible: false,
              },
              {
                title: "Time Expiration",
                field: "time_expiration",
                headerFilter: true,
                minWidth: 200,
              },
              {
                title: "Reason",
                field: "reason",
                headerFilter: true,
                editor: true,
                minWidth: 400,
              },
              {
                title: "Add information",
                field: "add_info",
                headerFilter: true,
                editor: true,
                minWidth: 400,
              },
              {
                title: "Created by",
                field: "src_user",
                headerFilter: true,
              },
              {
                title: "Creation time",
                field: "ctime",
                headerFilter: true,
                minWidth: 200,
              },
              {
                title: "Mod time",
                field: "mtime",
                headerFilter: true,
                minWidth: 200,
              },
            ],
          },
        ],
      });

      // Refresh
      $("#maintenance-kdb-table-refresh")
        .unbind()
        .click(function () {
          var doAsync = asyncAjax(
            getSplunkUrl("/splunkd/__raw/services/trackme/v2/maintenance_kdb/maintenance_kdb_get_records"),
            "POST",
            { time_format: "human" }
          ).then(function (resultCall) {
            // count the number of item in the array and update the title
            var no_items = resultCall.length;
            $("#divTitleCount").html(
              '<h1><span style="color: #a7c7e7;">' +
                no_items +
                " record(s) in the Maintenance Knowledge DataBase currently</span></h1>"
            );
            // clear filters
            table.clearFilter(true);
            // refresh data
            table.replaceData(resultCall);
            // notify
            notify("info", "bottom", "Refreshed performed successfully.", "5");
          });
        });

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // disable the button id btn_save and btn_cancel
        $("#maintenance-kdb-table-save").prop("disabled", true);
        $("#maintenance-kdb-table-cancel").prop("disabled", true);
        $("#maintenance-kdb-table-delete").prop("disabled", true);
        // enable the button id add
        $("#maintenance-kdb-table-addnew").prop("disabled", false);
        // remove the loader
        cssloaderremove();
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#maintenance-kdb-table-delete").prop("disabled", false);
        } else {
          $("#maintenance-kdb-table-delete").prop("disabled", true);
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#maintenance-kdb-table-save").prop("disabled", false);
        $("#maintenance-kdb-table-cancel").prop("disabled", false);
      });

      // save inline edit, ask confirmation open modal id maintenance-kdb-table-save-confirm-modal when clicked maintenance-kdb-table-save
      $("#maintenance-kdb-table-save")
        .unbind()
        .click(function () {
          // open modal
          $("#maintenance-kdb-table-save-confirm-modal").modal();
        });

      // save inline edit
      $("#maintenance-kdb-table-save-confirm")
        .unbind()
        .click(function () {
          // close modal
          closeModals();

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            // create the JSON object

            // if enabled is true, set is_disabled = 0, else set is_disabled = 1
            var is_disabled = 0;
            if (selectedData[i].enabled == false) {
              is_disabled = 1;
            }

            record_object = {
              _key: selectedData[i]._key,
              is_disabled: is_disabled,
              reason: selectedData[i].reason,
              add_info: selectedData[i].add_info,
              type: selectedData[i].type,
            };
            // push to the array
            itemList.push(record_object);
          }

          // Create the endpoint URL
          var myendpoint_URl =
            getSplunkUrl("/splunkd/__raw/services/trackme/v2/maintenance_kdb/admin/maintenance_kdb_bulk_edit");

          // Create a dictionary to store the field names and values
          var record = {
            json_data: itemList,
            update_comment: getComment("maintenance-kdb-table-save-comment"),
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // refresh tabulator
              $("#maintenance-kdb-table-refresh").click();
              // notify
              notify(
                "success",
                "bottom",
                "bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#maintenance-kdb-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              // spinner
              cssloaderremove();
              message =
                "server response: " +
                xhr.responseText +
                "\n - http response: " +
                error;
              $("#modal_update_collection_failure_return")
                .find(".modal-error-message p")
                .text(message);
              $("#modal_update_collection_failure_return").modal();
            },
          });
        });

      // cancel inline edit
      $("#maintenance-kdb-table-cancel")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#maintenance-kdb-table-save").prop("disabled", true);
          // refresh the table
          $("#maintenance-kdb-table-refresh-hidden").click();
        });

      // delete - open modal confirmation maintenance-kdb-table-delete-confirm-modal
      $("#maintenance-kdb-table-delete")
        .unbind()
        .click(function () {
          // get filters
          var allFilters = table.getFilters(true);

          // get selected rows
          var selectedData = table.getSelectedData(allFilters);

          // count the number of item in the array and update the title
          var no_items = selectedData.length;
          $("#divTitleDeleteCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              no_items +
              " record(s) selected</span></h1>"
          );

          // open modal
          $("#maintenance-kdb-table-delete-confirm-modal").modal();
        });

      // delete confirmed
      $("#maintenance-kdb-table-delete-confirm")
        .unbind()
        .click(function () {
          // close modal
          closeModals();

          // get filters
          var allFilters = table.getFilters(true);

          // get selected rows
          var selectedData = table.getSelectedData(allFilters);

          // get data according to all filters and store in its array
          var searchData = table.searchData(allFilters);

          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i]._key);
          }

          // loop and create a list of keys
          var itemKeys = [];

          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i]._key)) {
              itemKeys.push(selectedData[i]._key);
            }
          }

          // Create the endpoint URL
          var myendpoint_URl =
            getSplunkUrl("/splunkd/__raw/services/trackme/v2/maintenance_kdb/admin/maintenance_kdb_manage_record");

          // Create a dictionary to store the field names and values
          // convert itemKeys to a comma separated string
          itemKeys = itemKeys.join(",");

          // call the rest endpoint
          var record = {
            action: "delete",
            record_id: itemKeys,
            update_comment: getComment("maintenance-kdb-table-delete-comment"),
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // close modals
              closeModals();
              // spinner
              cssloaderremove();
              // refresh tabulator
              $("#maintenance-kdb-table-refresh").click();
              // notify
              notify(
                "success",
                "bottom",
                "Record(s) removed successfully.",
                "5"
              );
              return;
            },
            error: function (xhr, textStatus, error) {
              // spinner
              cssloaderremove();
              message =
                "server response: " +
                xhr.responseText +
                "\n - http response: " +
                error;
              $("#modal_update_collection_failure_return")
                .find(".modal-error-message p")
                .text(message);
              closeModals();
              $("#modal_update_collection_failure_return").modal();
            },
          });
        });

      // add new record, open modal id maintenance-kdb-table-addnew-modal when button id maintenance-kdb-table-addnew is clicked
      $("#maintenance-kdb-table-addnew")
        .unbind()
        .click(function () {
          // open modal
          $("#maintenance-kdb-table-addnew-modal").modal();
        });

      // when clicked id maintenance-kdb-table-addnew-request, open modal id maintenance-kdb-table-delete-confirm-addnew
      $("#maintenance-kdb-table-addnew-request")
        .unbind()
        .click(function () {
          // open modal
          $("#maintenance-kdb-table-addnew-confirm-modal").modal();
        });

      // confirm add new record
      $("#maintenance-kdb-table-create-confirm")
        .unbind()
        .click(function () {
          // close modal
          closeModals();

          // Retrieve the tenants scope
          var tenants_scope = getToken("tk_tenants_scope");

          // Function to adjust date time to local with timezone offset and format as YYYY-MM-DDTHH:MM
          function adjustDateTimeToLocalISO(date, time) {
            var tzOffset = new Date().getTimezoneOffset() * 60000; // offset in milliseconds
            var combinedDateTime = new Date(
              new Date(date + "T" + time).getTime() - tzOffset
            );
            // Format as YYYY-MM-DDTHH:MM
            var localISOTime = combinedDateTime.toISOString().slice(0, 16); // Removes seconds and milliseconds
            return localISOTime;
          }

          // get the values from the modal
          var tk_type = $("#maintenance-kdb-table-addnew-type").val();

          var tk_date_start = $(
            "#maintenance-kdb-table-addnew-date_start"
          ).val();
          var tk_time_start = $(
            "#maintenance-kdb-table-addnew-time_start"
          ).val();
          var startDateTime = adjustDateTimeToLocalISO(
            tk_date_start,
            tk_time_start
          );

          var tk_date_end = $("#maintenance-kdb-table-addnew-date_end").val();
          var tk_time_end = $("#maintenance-kdb-table-addnew-time_end").val();
          var endDateTime = adjustDateTimeToLocalISO(tk_date_end, tk_time_end);

          var tk_no_days_validity = $(
            "#maintenance-kdb-table-addnew-no-days-validity"
          ).val();
          var tk_reason = $("#maintenance-kdb-table-addnew-reason").val();
          var tk_add_info = $("#maintenance-kdb-table-addnew-add_info").val();

          // Create the endpoint URL
          var myendpoint_URl =
            getSplunkUrl("/splunkd/__raw/services/trackme/v2/maintenance_kdb/admin/maintenance_kdb_add_record");

          // call the rest endpoint
          var record = {
            tenants_scope: tenants_scope,
            type: tk_type,
            time_format: "datestring",
            time_start: startDateTime,
            time_end: endDateTime,
            reason: tk_reason,
            update_comment: getComment("maintenance-kdb-table-addnew-comment"),
          };

          // if tk_add_info is not equal to the default "optional, additional information or references", add to the record
          if (tk_add_info != "optional, additional information or references") {
            record.add_info = tk_add_info;
          }

          // if tk_no_days_validity is defined and is a number, add to the record
          if (tk_no_days_validity != "" && !isNaN(tk_no_days_validity)) {
            record.no_days_validity = tk_no_days_validity;
          }

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // refresh tabulator
              $("#maintenance-kdb-table-refresh").click();
              // notify
              notify("success", "bottom", "Record added successfully.", "5");
              return;
            },
            error: function (xhr, textStatus, error) {
              // spinner
              cssloaderremove();
              message =
                "server response: " +
                xhr.responseText +
                "\
                n - http response: " +
                error;
              $("#modal_update_collection_failure_return")
                .find(".modal-error-message p")
                .text(message);
              $("#modal_update_collection_failure_return").modal();
            },
          });
        });

      //
      // end
      //
    });
  }

  // Call it now
  maintenanceKdbHandlerTable(
    getSplunkUrl("/splunkd/__raw/services/trackme/v2/maintenance_kdb/maintenance_kdb_get_records"),
    "POST",
    { time_format: "human" }
  );

  //
  // END
  //
});
