const { Callbacks } = require("jquery");

require([
  "jquery",
  "underscore",
  "splunkjs/mvc",
  "splunkjs/mvc/utils",
  "splunkjs/mvc/searchmanager",
  "splunkjs/mvc/postprocessmanager",
  "splunkjs/mvc/singleview",
  "splunkjs/mvc/multidropdownview",
  "splunkjs/mvc/simplexml/searcheventhandler",
  Splunk.util.make_url("/static/app/trackme/momentjs/moment.js"),
  "splunkjs/mvc/simplexml/ready!",
  "splunkjs/mvc/simpleform/input/multiselect",
], function (
  $,
  _,
  mvc,
  utils,
  SearchManager,
  PostProcessManager,
  SingleView,
  MultiDropdownView,
  SearchEventHandler,
  moment
) {
  //
  // Functions
  //

  function getSplunkUrl(path) {
    return Splunk.util.make_url(path);
  }

  //
  // Tokens management
  //

  var defaultTokenModel = mvc.Components.getInstance("default", {
    create: true,
  });
  var submittedTokenModel = mvc.Components.getInstance("submitted", {
    create: true,
  });

  function setToken(name, value) {
    defaultTokenModel.set(name, value);
    submittedTokenModel.set(name, value);
  }

  function getToken(name) {
    var ret = null;
    if (defaultTokenModel.get(name) != undefined) {
      ret = defaultTokenModel.get(name);
    } else if (submittedTokenModel.get(name) != undefined) {
      ret = submittedTokenModel.get(name);
    }
    return ret;
  }

  function unsetToken(name) {
    defaultTokenModel.unset(name);
    submittedTokenModel.unset(name);
  }

  //
  // Get comment from textaread
  //

  function getComment(inputId) {
    // Retrieve update comment if any
    var tk_comment = document.getElementById(inputId).value;

    // if is not defined, give it a value and override text box content
    if (tk_comment == "null") {
      tk_comment = "No comments for update.";
    } else if (tk_comment == "update note") {
      tk_comment = "No comment for update.";
    }
    return tk_comment;
  }

  function cssloaderremove() {
    $("#cssloader").remove();
  }

  // close all opened modals
  function closeModals() {
    $(".modal").modal("hide");
  }

  // syntax highlighting for JSON
  function syntaxHighlight(json) {
    json = json
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;");
    return json.replace(
      /("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,
      function (match) {
        var cls = "json-preview-number";
        if (/^"/.test(match)) {
          if (/:$/.test(match)) {
            cls = "json-preview-key";
          } else {
            cls = "json-preview-string";
          }
        } else if (/true|false/.test(match)) {
          cls = "json-preview-boolean";
        } else if (/null/.test(match)) {
          cls = "json-preview-null";
        }
        return '<span class="' + cls + '">' + match + "</span>";
      }
    );
  }

  //
  // tenants dropdown
  //

  var searchListTenants = new SearchManager({
    id: "searchListTenants",
    search:
      '| inputlookup trackme_virtual_tenants where tenant_status="enabled" | eval keyid=_key | stats count by tenant_id | table tenant_id | sort 0 tenant_id',
    earliest_time: "-5m",
    latest_time: "now",
    autostart: true,
  });

  var inputListTenants = new MultiDropdownView(
    {
      searchWhenChanged: true,
      id: "inputListTenants",
      managerid: "searchListTenants",
      default: "*",
      choices: [
        {
          label: "any",
          value: "*",
        },
      ],
      labelField: "tenant_id",
      valueField: "tenant_id",
      value: "$tk_tenants_scope$",
      el: $("#inputListTenants"),
    },
    {
      tokens: true,
    }
  ).render();

  //
  // MAINTENANCE MODE
  //

  var search_maintenance_mode_mainsearch = new SearchManager(
    {
      id: "search_maintenance_mode_mainsearch",
      sample_ratio: 1,
      search: "| inputlookup trackme_maintenance_mode",
      status_buckets: 0,
      earliest_time: "-24h@h",
      cancelOnUnload: true,
      latest_time: "now",
      app: utils.getCurrentApp(),
      auto_cancel: 90,
      preview: true,
      tokenDependencies: {},
      runWhenTimeIsUndefined: false,
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  );

  new SearchEventHandler({
    managerid: "search_maintenance_mode_mainsearch",
    event: "progress",
    conditions: [
      {
        attr: "match",
        value: "'result.maintenance_mode'==\"enabled\"",
        actions: [
          {
            type: "set",
            token: "maintenance_enabled",
            value: "true",
          },
          {
            type: "unset",
            token: "maintenance_scheduled",
          },
        ],
      },
      {
        attr: "match",
        value: "'result.maintenance_mode'==\"scheduled\"",
        actions: [
          {
            type: "set",
            token: "maintenance_scheduled",
            value: "true",
          },
          {
            type: "unset",
            token: "maintenance_enabled",
          },
        ],
      },
      {
        attr: "match",
        value: "'result.maintenance_mode'==\"disabled\"",
        actions: [
          {
            type: "unset",
            token: "maintenance_scheduled",
          },
          {
            type: "unset",
            token: "maintenance_enabled",
          },
        ],
      },
    ],
  });

  var search_maintenance_state = new PostProcessManager(
    {
      managerid: "search_maintenance_mode_mainsearch",
      id: "search_maintenance_state",
      search:
        'fields maintenance_mode | eval maintenance=case(match(maintenance_mode, "enabled"), 1, match(maintenance_mode, "disabled"), 0, match(maintenance_mode, "scheduled"), 2), maintenance_mode=upper(maintenance_mode) | rangemap field=maintenance low=0-0 severe=1-1 high=2-2 default=severe',
      tokenDependencies: {},
      runWhenTimeIsUndefined: false,
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  );

  var search_maintenance_state_reactivation = new PostProcessManager(
    {
      managerid: "search_maintenance_mode_mainsearch",
      id: "search_maintenance_state_reactivation",
      search:
        'eval maintenance_mode_end=strftime(maintenance_mode_end, "%d %b %H:%M") | eval maintenance = "Ends on: " . maintenance_mode_end . " (local time)" | fields maintenance',
      tokenDependencies: {},
      runWhenTimeIsUndefined: false,
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  );

  var search_maintenance_state_scheduled = new PostProcessManager(
    {
      managerid: "search_maintenance_mode_mainsearch",
      id: "search_maintenance_state_scheduled",
      search:
        'eval maintenance_mode_start=strftime(maintenance_mode_start, "%d %b %H:%M"), maintenance_mode_end=strftime(maintenance_mode_end, "%d %b %H:%M") | eval maintenance = "Starts on: " . maintenance_mode_start . " / " . "Ends on: " . maintenance_mode_end . " (local time)"| fields maintenance',
      tokenDependencies: {},
      runWhenTimeIsUndefined: false,
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  );

  // views

  var element_maintenance_state = new SingleView(
    {
      id: "element_maintenance_state",
      drilldown: "none",
      colorMode: "block",
      "link.visible": "false",
      numberPrecision: "0",
      useColors: "0",
      underLabel: "MAINTENANCE MODE STATUS",
      colorBy: "value",
      height: "100",
      managerid: "search_maintenance_state",
      el: $("#element_maintenance_state"),
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  ).render();

  var element_maintenance_state_reactivation = new SingleView(
    {
      id: "element_maintenance_state_reactivation",
      drilldown: "none",
      colorMode: "block",
      "link.visible": "false",
      numberPrecision: "0",
      useColors: "0",
      underLabel:
        "ESTIMATED DATE FOR AUTO-DEACTIVATION OF THE MAINTENANCE MODE",
      colorBy: "value",
      height: "60",
      managerid: "search_maintenance_state_reactivation",
      el: $("#element_maintenance_state_reactivation"),
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  ).render();

  var element_maintenance_state_scheduled = new SingleView(
    {
      id: "element_maintenance_state_scheduled",
      drilldown: "none",
      colorMode: "block",
      "link.visible": "false",
      numberPrecision: "0",
      useColors: "0",
      underLabel: "MAINTENANCE MODE HAS BEEN SCHEDULED",
      colorBy: "value",
      height: "60",
      managerid: "search_maintenance_state_scheduled",
      el: $("#element_maintenance_state_scheduled"),
    },
    {
      tokens: true,
      tokenNamespace: "submitted",
    }
  ).render();

  //
  // BEGIN OPERATIONS
  //

  //
  // Handle html textarea
  //

  $(".custom-textarea").each(function () {
    var $text_group = $(this);
    $text_group.find("textarea").on("click", function () {
      var $text = $(this);
      if (this.value == this.defaultValue) this.value = "";
      $(this).blur(function () {
        if (this.value == "") this.value = this.defaultValue;
      });
    });
  });

  function get_maintenance_mode() {
    // Manage buttons states dynamically

    //
    // Verify the current status
    //

    // Endpoint URI
    var myendpoint_URl = getSplunkUrl(
      "/splunkd/__raw/services/trackme/v2/maintenance/check_global_maintenance_status"
    );

    //
    // Call TrackMe API endpoint
    //

    // API call
    $.ajax({
      url: myendpoint_URl,
      type: "GET",
      async: true,
      contentType: "application/json",
      success: function (returneddata) {
        // Refresh
        var current_maintenance_mode = returneddata["maintenance_mode"];

        // remove loader
        cssloaderremove();

        //
        if (!current_maintenance_mode) {
          $("#modal_loading_maintenance_mode_failure").modal();
          document.getElementById(
            "btn_main_enable_maintenance"
          ).disabled = true;
          document.getElementById(
            "btn_main_disable_maintenance"
          ).disabled = true;
          return;
        }

        // Dynamically manage buttons states
        if (current_maintenance_mode == "disabled") {
          // show btn enable
          $("#divEnableBtn").attr("style", "display: inherit !important");
          // hide btn disable
          $("#divDisableBtn").attr("style", "display: none !important");
          //
        } else if (current_maintenance_mode == "scheduled") {
          // hide btn enable
          $("#divEnableBtn").attr("style", "display: none !important");
          // show btn disable
          $("#divDisableBtn").attr("style", "display: inherit !important");
          //
        } else if (current_maintenance_mode == "enabled") {
          // hide btn enable
          $("#divEnableBtn").attr("style", "display: none !important");
          // show btn disable
          $("#divDisableBtn").attr("style", "display: inherit !important");
          //
        } else {
          // show btn enable
          $("#divEnableBtn").attr("style", "display: inherit !important");
          // show btn disable
          $("#divDisableBtn").attr("style", "display: inherit !important");
          //
        }

        // update content
        $("#divChildJsonPreview").html(
          '<pre class="json-preview">' +
            syntaxHighlight(JSON.stringify(returneddata, null, 2)) +
            "</pre>"
        );

        // show json preview
        $("#divJsonPreview").css("display", "inherit");
      },
      error: function (xhr, textStatus, error) {
        // if error containts "insufficient permission"
        if (JSON.stringify(xhr).includes("insufficient permission")) {
          closeModals();
          cssloaderremove();
          $("#modal_maintenance_mode_info").modal();
        } else {
          $("#modal_update_collection_failure_return")
            .find(".modal-error-message p")
            .text(JSON.stringify(xhr));
          closeModals();
          cssloaderremove();
          $("#modal_update_collection_failure_return").modal();
        }
      },
    });
    //
  }

  // splk-dsm refresh timer
  var MaintenanceStatusIntervalId;
  var UpdateTimeIntervalId;

  function RefreshInfo() {
    // Clear the existing interval if it's already set
    if (UpdateTimeIntervalId) {
      clearInterval(UpdateTimeIntervalId);
      UpdateTimeIntervalId = null;
    }

    var myDate = new Date();
    var LastRefresh = document.getElementById("LastRefresh");

    function updateTime() {
      LastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
    }

    // Update immediately before setting the interval
    updateTime();

    // Set a new interval for updating the time
    UpdateTimeIntervalId = setInterval(updateTime, 60000); // update every minute
  }

  // splk-dsm get table
  function getMaintenanceStatus() {
    get_maintenance_mode();
    search_maintenance_mode_mainsearch.startSearch();
    search_maintenance_state.startSearch();
  }

  // Initialize refresh intervals
  function initializeRefreshIntervals() {
    getMaintenanceStatus();
    RefreshInfo();

    // Clear the existing interval if it's already set
    if (MaintenanceStatusIntervalId) {
      clearInterval(MaintenanceStatusIntervalId);
      MaintenanceStatusIntervalId = null;
    }

    // Set a new interval for getting maintenance status
    MaintenanceStatusIntervalId = setInterval(function () {
      getMaintenanceStatus();
      RefreshInfo();
    }, 300000); // every 5 minutes
  }

  // Initialize intervals
  initializeRefreshIntervals();

  //
  // REFRESH
  //

  $("#btn_refresh")
    .unbind()
    .click(function () {
      initializeRefreshIntervals();
    });

  //
  // ENABLE MAINTENANCE MODE BUTTON
  //

  // Open modal
  $("#btn_main_enable_maintenance")
    .unbind()
    .click(function () {
      // Get today's date
      var now = new Date();

      // Format date as YYYY-MM-DD, taking into account the timezone offset
      var tzOffset = now.getTimezoneOffset() * 60000; // offset in milliseconds
      var localISOTime = new Date(now - tzOffset).toISOString().slice(0, -1);
      var todayDate = localISOTime.slice(0, 10); // YYYY-MM-DD format
      var currentTime = localISOTime.slice(11, 16); // HH:MM format

      // Set the min attribute for date inputs to today
      document.getElementById("inputStartDate").setAttribute("min", todayDate);
      document.getElementById("inputEndDate").setAttribute("min", todayDate);

      // Optionally, set the current time as default for time inputs
      document.getElementById("inputStartTime").value = currentTime;
      document.getElementById("inputEndTime").value = currentTime;

      // open modal
      $("#modal_enable_maintenance").modal();
    });

  // Proceed
  $("#btn_confirm_enable_maintenance")
    .unbind()
    .click(function () {
      // Function to adjust date time to UTC and format as YYYY-MM-DDTHH:MM
      function toUTCDateString(date, time) {
        // date: 'YYYY-MM-DD', time: 'HH:MM'
        var localDate = new Date(date + "T" + time);
        // Format as YYYY-MM-DDTHH:MM in UTC
        var pad = function (n) {
          return n.toString().padStart(2, "0");
        };
        return (
          localDate.getUTCFullYear() +
          "-" +
          pad(localDate.getUTCMonth() + 1) +
          "-" +
          pad(localDate.getUTCDate()) +
          "T" +
          pad(localDate.getUTCHours()) +
          ":" +
          pad(localDate.getUTCMinutes())
        );
      }

      // Retrieve the tenants scope
      var tenants_scope = getToken("tk_tenants_scope");

      // Retrieve start and end date and time, and convert them to UTC
      var inputStartDate = document.getElementById("inputStartDate").value;
      var inputStartTime = document.getElementById("inputStartTime").value;
      var startDateTime = toUTCDateString(inputStartDate, inputStartTime);

      var inputEndDate = document.getElementById("inputEndDate").value;
      var inputEndTime = document.getElementById("inputEndTime").value;
      var endDateTime = toUTCDateString(inputEndDate, inputEndTime);

      if (inputStartDate && inputStartTime && inputEndDate && inputEndTime) {
        // Endpoint URI
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/maintenance/global_maintenance_enable"
        );
        var record = {
          time_format: "datestring",
          maintenance_mode_start: startDateTime,
          maintenance_mode_end: endDateTime,
          tenants_scope: tenants_scope,
          update_comment: getComment("input_enable_comment"),
        };

        //
        // Call TrackMe API endpoint
        //

        // API call
        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Refresh

            // Update single
            search_maintenance_mode_mainsearch.startSearch();
            search_maintenance_state.startSearch();

            // hide btn enable
            $("#divEnableBtn").attr("style", "display: none !important");
            // show btn disable
            $("#divDisableBtn").attr("style", "display: inherit !important");

            // refresh info
            initializeRefreshIntervals();

            // Show final modal
            var current_status = returneddata["maintenance_mode"];
            if (current_status === "enabled") {
              $("#modal_maintenance_mode_confirmed").modal();
            } else if (current_status === "scheduled") {
              $("#modal_maintenance_mode_scheduled").modal();
            }
          },
          error: function (xhr, textStatus, error) {
            $("#modal_update_collection_failure_return")
              .find(".modal-error-message p")
              .text(JSON.stringify(xhr));
            closeModals();
            $("#modal_update_collection_failure_return").modal();
          },
        });
      }

      // end modal calendar selection
    });

  //
  // DISABLE MAINTENANCE MODE BUTTON
  //

  // Open modal
  $("#btn_main_disable_maintenance")
    .unbind()
    .click(function () {
      $("#modal_disable_maintenance").modal();
    });

  // Proceed
  $("#btn_confirm_disable_maintenance")
    .unbind()
    .click(function () {
      // Endpoint URI
      var myendpoint_URl = getSplunkUrl(
        "/splunkd/__raw/services/trackme/v2/maintenance/maintenance_disable"
      );
      var record = {
        update_comment: getComment("input_disable_comment"),
      };

      //
      // Call TrackMe API endpoint
      //

      // API call
      $.ajax({
        url: myendpoint_URl,
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify(record),
        success: function (returneddata) {
          // Refresh

          // Update single
          search_maintenance_mode_mainsearch.startSearch();
          search_maintenance_state.startSearch();

          // show btn enable
          $("#divEnableBtn").attr("style", "display: inherit !important");
          // disable btn disable
          $("#divDisableBtn").attr("style", "display: none !important");

          // refresh info
          initializeRefreshIntervals();

          // Show final modal
          $("#modal_maintenance_mode_disabled").modal();
        },
        error: function (xhr, textStatus, error) {
          $("#modal_update_collection_failure_return")
            .find(".modal-error-message p")
            .text(JSON.stringify(xhr));
          closeModals();
          $("#modal_update_collection_failure_return").modal();
        },
      });
    });

  //
  // END
  //
});
