const { Callbacks, getJSON, get } = require("jquery");

require([
  "jquery",
  "underscore",
  "splunkjs/mvc",
  "splunkjs/mvc/utils",
  "splunkjs/mvc/searchcontrolsview",
  "splunkjs/mvc/searchmanager",
  "splunkjs/mvc/postprocessmanager",
  "splunkjs/mvc/dropdownview",
  "splunkjs/mvc/multidropdownview",
  "splunkjs/mvc/tableview",
  "splunkjs/mvc/eventsviewerview",
  "splunkjs/mvc/textinputview",
  "splunkjs/mvc/singleview",
  "splunkjs/mvc/chartview",
  "splunkjs/mvc/resultslinkview",
  "splunkjs/mvc/simplexml/searcheventhandler",
  "splunkjs/mvc/visualizationregistry",
  "splunkjs/mvc/simpleform/input/linklist",
  "splunkjs/mvc/simpleform/input/text",
  "splunkjs/mvc/simpleform/input/timerange",
  "splunkjs/mvc/simpleform/input/multiselect",
  "splunkjs/mvc/simpleform/input/dropdown",
  "splunkjs/mvc/simpleform/input/checkboxgroup",
  "splunkjs/mvc/simplexml/element/table",
  "splunkjs/mvc/simplexml/element/single",
  "splunkjs/mvc/simplexml/element/event",
  "splunkjs/mvc/simplexml/element/visualization",
  "splunkjs/mvc/simpleform/formutils",
  "splunkjs/mvc/simplexml/eventhandler",
  "splunkjs/mvc/simplexml/searcheventhandler",
  Splunk.util.make_url("/static/app/trackme/tabulator/js/tabulator.js"),
  Splunk.util.make_url("/static/app/trackme/momentjs/moment.js"),
  "splunkjs/mvc/simplexml/ready!",
], function (
  $,
  _,
  mvc,
  utils,
  SearchControlsView,
  SearchManager,
  PostProcessManager,
  DropdownView,
  MultiDropdownView,
  TableView,
  EventsViewer,
  TextInputView,
  SingleView,
  ChartView,
  ResultsLinkView,
  SearchEventHandler,
  VisualizationRegistry,
  LinkListInput,
  TextInput,
  TimeRangeInput,
  MultiSelectInput,
  DropdownInput,
  CheckboxGroupInput,
  TableElement,
  VisualizationElement,
  SingleElement,
  EventElement,
  FormUtils,
  EventHandler,
  SearchEventHandler,
  TabulatorFull,
  moment
) {
  function getSplunkUrl(path) {
    return Splunk.util.make_url(path);
  }

  //
  // ajax promise for API calls
  //

  async function asyncAjax(ajaxurl, ajaxType, ajaxdata) {
    var resultCall;
    try {
      resultCall = await $.ajax({
        url: ajaxurl,
        type: ajaxType,
        data: JSON.stringify(ajaxdata),
      });
      return resultCall;
    } catch (error) {
      closeModals();
      $("#modal_generic_error")
        .find(".modal-error-message p")
        .text(JSON.stringify(error));
      $("#modal_generic_error").modal();
    }
  }

  var doAsync = asyncAjax(
    getSplunkUrl("/splunkd/__raw/services/trackme/v2/licensing/license_status"),
    "GET"
  ).then(function (licenseCall) {
    var license_is_valid = licenseCall["license_is_valid"];
    var license_active_hybrid_trackers =
      licenseCall["license_active_hybrid_trackers"];
    var license_subscription_class = licenseCall["license_subscription_class"];

    // TOKENS

    var defaultTokenModel = mvc.Components.getInstance("default", {
      create: true,
    });

    var submittedTokenModel = mvc.Components.getInstance("submitted", {
      create: true,
    });

    function setToken(name, value) {
      defaultTokenModel.set(name, value);
      submittedTokenModel.set(name, value);
    }

    function getToken(name) {
      var ret = null;
      if (defaultTokenModel.get(name) != undefined) {
        ret = defaultTokenModel.get(name);
      } else if (submittedTokenModel.get(name) != undefined) {
        ret = submittedTokenModel.get(name);
      }
      return ret;
    }

    function unsetToken(name) {
      defaultTokenModel.unset(name);
      submittedTokenModel.unset(name);
    }

    function loadTabulatorTheme(tabulator_theme) {
      if (tabulator_theme === "dark_site") {
        loadCss(
          Splunk.util.make_url(
            "/static/app/trackme/tabulator/css/tabulator_site_dark.css"
          )
        );
      } else if (tabulator_theme === "dark_midnight") {
        loadCss(
          Splunk.util.make_url(
            "/static/app/trackme/tabulator/css/tabulator_midnight.css"
          )
        );
      } else if (tabulator_theme === "light") {
        loadCss(
          Splunk.util.make_url(
            "/static/app/trackme/tabulator/css/tabulator.css"
          )
        );
      } else if (tabulator_theme === "light_site") {
        loadCss(
          Splunk.util.make_url(
            "/static/app/trackme/tabulator/css/tabulator_site.css"
          )
        );
      } else if (tabulator_theme === "light_modern") {
        loadCss(
          Splunk.util.make_url(
            "/static/app/trackme/tabulator/css/tabulator_modern.css"
          )
        );
      }
    }

    function loadCss(href) {
      const link = document.createElement("link");
      link.href = href;
      link.type = "text/css";
      link.rel = "stylesheet";
      document.head.appendChild(link);
    }

    //
    // tenant_id
    //

    // immediately save the origin tenant_id
    setToken("root_tenant_id", getToken("tenant_id"));

    // Update the banner tenant
    $("#infoBannerTenant").html(
      '<h1 style="margin-top: -2px;"">' + getToken("tenant_id") + "</h1>"
    );
    $("#tenant-banner-loader").css("display", "none");

    //
    // FUNCTIONS
    //

    //
    // Get comment from textaread
    //

    function getComment(inputId) {
      // Retrieve update comment if any
      var tk_comment = document.getElementById(inputId).value;

      // if is not defined, give it a value and override text box content
      if (tk_comment == "null") {
        tk_comment = "No comments for update.";
      } else if (tk_comment == "update note") {
        tk_comment = "No comment for update.";
      }
      return tk_comment;
    }

    function download(file, text) {
      //creating an invisible element
      var element = document.createElement("a");
      element.setAttribute(
        "href",
        "data:text/plain;charset=utf-8, " + encodeURIComponent(text)
      );
      element.setAttribute("download", file);

      // Above code is equivalent to
      // <a href="path of file" download="file name">

      document.body.appendChild(element);

      //onClick property
      element.click();

      document.body.removeChild(element);
    }

    //
    // check level of permissions, disable tenant creation and management if the user does not have the proper level of privileges
    //

    async function checkPrivileges() {
      var ajaxurl = getSplunkUrl(
        "/splunkd/__raw/services/trackme/v2/configuration/trackme_check_privileges_level"
      );
      var ajaxType = "GET";
      var resultCall;

      var defaultTokenModel = mvc.Components.getInstance("default", {
        create: true,
      });
      var submittedTokenModel = mvc.Components.getInstance("submitted", {
        create: true,
      });

      function setToken(name, value) {
        defaultTokenModel.set(name, value);
        submittedTokenModel.set(name, value);
      }

      try {
        resultCall = await $.ajax({
          url: ajaxurl,
          type: ajaxType,
        });
        userLevel = resultCall.user_level;
        setToken("userLevel", userLevel);

        // load user preferences
        var user_prefs_conf = resultCall.user_prefs;

        // load Tabulator theme
        document.addEventListener(
          "DOMContentLoaded",
          loadTabulatorTheme(user_prefs_conf.tabulator_theme_home_ui)
        );

        // default mode for state icons compatibility
        ui_prefs_state_icons_mode = user_prefs_conf.icons_state_mode_home_ui;

        if (ui_prefs_state_icons_mode == "emoji") {
          setToken("show_state_icons_emoji", 1);
          setToken("show_state_icons_bootstrap", 0);
        } else if (ui_prefs_state_icons_mode == "bootstrap") {
          setToken("show_state_icons_emoji", 0);
          setToken("show_state_icons_bootstrap", 1);
        } else {
          setToken("show_state_icons_emoji", 1);
          setToken("show_state_icons_bootstrap", 0);
        }

        // hide the tenant creation access button
        if (userLevel === "user") {
          setToken("update_icon_visible", false);
          setToken("update_icon_alert_visible", false);
          //
          // splk-dsm
          //
          $("#splk_dsm_manage_btns").css("display", "none");
          $("#splk_dsm_manage_btns2").css("display", "none");
          $("#splk-dsm-table-bulk").css("display", "none");
          $("#splk-dsm-table-save").css("display", "none");
          $("#splk-dsm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring").css("display", "none");
          $("#btn_disable_monitoring").css("display", "none");
          $("#btn_delete_splk_dsm").css("display", "none");
          $("#btn_modify_splk_dsm").css("display", "none");
          $("#btn_ack_splk_dsm").css("display", "none");
          //
          // splk-dhm
          //
          $("#splk_dhm_manage_btns").css("display", "none");
          $("#splk_dhm_manage_btns2").css("display", "none");
          $("#splk-dhm-table-bulk").css("display", "none");
          $("#splk-dhm-table-save").css("display", "none");
          $("#splk-dhm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_host").css("display", "none");
          $("#btn_disable_monitoring_host").css("display", "none");
          $("#btn_delete_splk_dhm").css("display", "none");
          $("#btn_modify_splk_dhm").css("display", "none");
          $("#btn_ack_splk_dhm").css("display", "none");
          //
          // splk-mhm
          //
          $("#splk_mhm_manage_btns").css("display", "none");
          $("#splk_mhm_manage_btns2").css("display", "none");
          $("#splk-mhm-table-bulk").css("display", "none");
          $("#splk-mhm-table-save").css("display", "none");
          $("#splk-mhm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_mhm").css("display", "none");
          $("#btn_disable_monitoring_splk_mhm").css("display", "none");
          $("#btn_delete_splk_mhm").css("display", "none");
          $("#btn_modify_splk_mhm").css("display", "none");
          $("#btn_ack_splk_mhm").css("display", "none");
          //
          // splk-cim
          //
          $("#btn_manage_cim_trackers").css("display", "none");
          $("#splk-cim-table-bulk").css("display", "none");
          $("#splk-cim-table-save").css("display", "none");
          $("#splk-cim-table-cancel").css("display", "none");
          $("#btn_run_object").css("display", "none");
          $("#btn_enable_cim").css("display", "none");
          $("#btn_disable_cim").css("display", "none");
          $("#btn_delete_cim").css("display", "none");
          $("#btn_modify_cim").css("display", "none");
          $("#btn_ack_splk_cim").css("display", "none");
          //
          // splk-wlk
          //
          $("#btn_modify_hybrid_trackers_wlk_main").css("display", "none");
          $("#btn_modify_apps_wlk_main").css("display", "none");
          $("#splk-wlk-table-bulk").css("display", "none");
          $("#splk-wlk-table-save").css("display", "none");
          $("#splk-wlk-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_wlk").css("display", "none");
          $("#btn_disable_monitoring_splk_wlk").css("display", "none");
          $("#btn_delete_splk_wlk").css("display", "none");
          $("#btn_modify_splk_wlk").css("display", "none");
          $("#btn_ack_splk_wlk").css("display", "none");
          //
          // splk-flx
          //
          $("#btn_modify_hybrid_trackers_flx_main").css("display", "none");
          $("#btn_run_tracker_flx").css("display", "none");
          $("#splk-flx-table-bulk").css("display", "none");
          $("#splk-flx-table-save").css("display", "none");
          $("#splk-flx-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_flx").css("display", "none");
          $("#btn_disable_monitoring_splk_flx").css("display", "none");
          $("#btn_delete_splk_flx").css("display", "none");
          $("#btn_modify_splk_flx").css("display", "none");
          $("#btn_ack_splk_flx").css("display", "none");
          //
          // splk-fqm
          //
          $("#btn_modify_hybrid_trackers_fqm_main").css("display", "none");
          $("#btn_run_tracker_fqm").css("display", "none");
          $("#splk-fqm-table-bulk").css("display", "none");
          $("#splk-fqm-table-save").css("display", "none");
          $("#splk-fqm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_fqm").css("display", "none");
          $("#btn_disable_monitoring_splk_fqm").css("display", "none");
          $("#btn_delete_splk_fqm").css("display", "none");
          $("#btn_modify_splk_fqm").css("display", "none");
          $("#btn_ack_splk_fqm").css("display", "none");
          //
          // alerts
          //
          $("#btn_create_alert").css("display", "none");
        } else if (userLevel === "power") {
          setToken("update_icon_visible", true);
          setToken("update_icon_alert_visible", true);
          //
          // splk-dsm
          //
          $("#splk_dsm_manage_hybrid_trackers").css("display", "none");
          $("#splk_dsm_manage_elastic_trackers").css("display", "none");
          //
          // splk-dhm
          //
          $("#splk_dhm_manage_hybrid_trackers").css("display", "none");
          //
          // splk-mhm
          //
          $("#splk_mhm_manage_hybrid_trackers").css("display", "none");
          //
          // splk-cim
          //
          $("#btn_manage_cim_trackers").css("display", "none");
          //
          // splk-wlk
          //
          $("#btn_modify_hybrid_trackers_wlk_main").css("display", "none");
          //
          // splk-flx
          //
          $("#btn_modify_hybrid_trackers_flx_main").css("display", "none");
          //
          // splk-fqm
          //
          $("#btn_modify_hybrid_trackers_fqm_main").css("display", "none");
          //
          // alerts
          //
          $("#btn_create_alert").css("display", "none");
          //
          //
          //
        } else {
          setToken("update_icon_visible", true);
          setToken("update_icon_alert_visible", true);
        }

        //
        // list input
        //

        function genLinkMainInputReturnChoices(components) {
          var choices = [];

          // Add components based on their status (1 = enabled)
          if (components.componentSplkDsms === 1) {
            choices.push({
              value: "show_splk_dsm_tracker",
              label: "SPLK-DSM - DATA SOURCES TRACKING",
              key: "dsm",
            });
          }

          if (components.componentCimTracking === 1) {
            choices.push({
              value: "show_cim_tracker",
              label: "SPLK-CIM - CIM COMPLIANCY TRACKING",
              key: "cim",
            });
          }

          if (components.componentSplkFlxs === 1) {
            choices.push({
              value: "show_splk_flx_tracker",
              label: "SPLK-FLX - FLEX OBJECTS TRACKING",
              key: "flx",
            });
          }

          if (components.componentSplkFqms === 1) {
            choices.push({
              value: "show_splk_fqm_tracker",
              label: "SPLK-FQM - FIELDS QUALITY TRACKING",
              key: "fqm",
            });
          }

          if (components.componentSplkWlks === 1) {
            choices.push({
              value: "show_splk_wlk_tracker",
              label: "SPLK-WLK - SPLUNK WORKLOAD",
              key: "wlk",
            });
          }

          if (components.componentSplkDhms === 1) {
            choices.push({
              value: "show_splk_dhm_tracker",
              label: "SPLK-DHM - EVENT ENDPOINTS TRACKING",
              key: "dhm",
            });
          }

          if (components.componentSplkMhms === 1) {
            choices.push({
              value: "show_splk_mhm_tracker",
              label: "SPLK-MHM - METRIC ENDPOINTS TRACKING",
              key: "mhm",
            });
          }

          // Push mandatory components with appropriate keys
          choices.push({
            value: "show_audit_flip",
            label: "INVESTIGATE STATUS FLIPPING",
            key: "flip",
          });

          choices.push({
            value: "show_audit_changes",
            label: "INVESTIGATE AUDIT CHANGES",
            key: "audit",
          });

          choices.push({
            value: "show_alerts",
            label: "TRACKING ALERTS",
            key: "alerts",
          });

          return choices;
        }

        function genLinkMainInput() {
          // Retrieve the tenant_id
          tenant_id = getToken("tenant_id");

          // Get URL params, if any
          var urlParams = getUrlParamsWithWildcards();
          var paramComponent = urlParams["component"]; // Retrieve the 'component' parameter from the URL

          // Get url submitted earliest, if any
          var submitted_earliest = urlParams["earliest"];
          // if submitted_earliest is not * and starts by a - then remove it
          if (submitted_earliest !== "*") {
            if (submitted_earliest.startsWith("-")) {
              submitted_earliest = submitted_earliest.substring(1);
            }
          }

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/configuration/components"
          );

          var data = {
            tenant_id: tenant_id,
          };

          // Get the KV entry content first
          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            dataType: "json",
            data: JSON.stringify(data),
            contentType: "application/json",
            success: function (returneddata) {
              var components = {
                componentSplkDsms: returneddata.component_splk_dsm,
                componentSplkDhms: returneddata.component_splk_dhm,
                componentSplkMhms: returneddata.component_splk_mhm,
                componentCimTracking: returneddata.component_splk_cim,
                componentSplkFlxs: returneddata.component_splk_flx,
                componentSplkFqms: returneddata.component_splk_fqm,
                componentSplkWlks: returneddata.component_splk_wlk,
              };

              // Set various UI tokens and configurations
              setToken("pagination_mode", returneddata.pagination_mode);
              setToken("pagination_size", returneddata.pagination_size);

              // Set default time range for all components
              if (submitted_earliest == "*") {
                setToken(
                  "form.modalActionTime",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeHost",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeSplkMhm",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeSplkFlx",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeSplkFqm",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeSplkWlk",
                  returneddata.ui_default_timerange
                );
                setToken(
                  "form.modalActionTimeCim",
                  returneddata.ui_default_timerange
                );
              } else {
                setToken("form.modalActionTime", submitted_earliest);
                setToken("form.modalActionTimeHost", submitted_earliest);
                setToken("form.modalActionTimeSplkMhm", submitted_earliest);
                setToken("form.modalActionTimeSplkFlx", submitted_earliest);
                setToken("form.modalActionTimeSplkFqm", submitted_earliest);
                setToken("form.modalActionTimeSplkWlk", submitted_earliest);
                setToken("form.modalActionTimeCim", submitted_earliest);
              }

              // mloutliers
              setToken("mloutliers", returneddata.mloutliers);
              setToken("mloutliers_dsm", returneddata.mloutliers_dsm);
              setToken("mloutliers_dhm", returneddata.mloutliers_dhm);
              setToken("mloutliers_wlk", returneddata.mloutliers_wlk);
              setToken("mloutliers_cim", returneddata.mloutliers_cim);
              setToken("mloutliers_flx", returneddata.mloutliers_flx);
              setToken("mloutliers_fqm", returneddata.mloutliers_fqm);

              // others
              setToken("ui_min_object_width", returneddata.ui_min_object_width);
              setToken("ui_expand_metrics", returneddata.ui_expand_metrics);
              setToken("cmdb_lookup", returneddata.cmdb_lookup);
              setToken("sampling", returneddata.sampling);
              setToken("adaptive_delay", returneddata.adaptive_delay);
              setToken("indexed_constraint", returneddata.indexed_constraint);
              setToken("tk_tenant_owner", returneddata.component_owner);

              // group by
              setToken(
                "splk_dsm_tabulator_groupby",
                returneddata.splk_dsm_tabulator_groupby
              );
              setToken(
                "splk_dhm_tabulator_groupby",
                returneddata.splk_dhm_tabulator_groupby
              );
              setToken(
                "splk_mhm_tabulator_groupby",
                returneddata.splk_mhm_tabulator_groupby
              );
              setToken(
                "splk_flx_tabulator_groupby",
                returneddata.splk_flx_tabulator_groupby
              );
              setToken(
                "splk_fqm_tabulator_groupby",
                returneddata.splk_fqm_tabulator_groupby
              );
              setToken(
                "splk_wlk_tabulator_groupby",
                returneddata.splk_wlk_tabulator_groupby
              );
              setToken(
                "splk_cim_tabulator_groupby",
                returneddata.splk_cim_tabulator_groupby
              );

              // Process the ui_home_tabs_order and split into an array
              var ui_home_tabs_order =
                returneddata.ui_home_tabs_order.split(",");

              // Get the choices array
              var choicesArray = genLinkMainInputReturnChoices(components);

              // Filter the choicesArray to include only items that are in ui_home_tabs_order
              choicesArray = choicesArray.filter(function (choice) {
                return ui_home_tabs_order.includes(choice.key);
              });

              // Sort the choices based on the ui_home_tabs_order using the added 'key'
              choicesArray = choicesArray.sort(function (a, b) {
                return (
                  ui_home_tabs_order.indexOf(a.key) -
                  ui_home_tabs_order.indexOf(b.key)
                );
              });

              // Clear the existing buttons and generate new ones
              var linkChoicesDiv = $("#linkChoices");
              linkChoicesDiv.empty(); // Clear existing buttons, if any

              // Generate buttons dynamically for each choice
              choicesArray.forEach(function (choice) {
                var button = $("<button>", {
                  text: choice.label,
                  class: "btn btn-outline-primary",
                  click: function () {
                    // Set the active class when a button is clicked
                    $("#linkChoices button").removeClass("active");
                    $(this).addClass("active");
                    handleComponentChange(choice.value);
                  },
                });

                linkChoicesDiv.append(button);

                // Automatically "click" the button that matches 'paramComponent', if found
                if (choice.key === paramComponent) {
                  button.addClass("active"); // Make the button active
                  button.click(); // Simulates the button being clicked
                }
              });

              // If no matching 'paramComponent', click the first button (default behavior)
              if (
                !$("#linkChoices button.active").length &&
                choicesArray.length
              ) {
                $("#linkChoices button").first().addClass("active").click();
              }
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        }

        function handleComponentChange(value) {
          setToken("tenant_id", getToken("root_tenant_id"));

          // Unset all trackers except the selected one and call corresponding function
          if (value === "show_splk_dsm_tracker") {
            activateTracker("dsm", "show_splk_dsm_tracker", getSplkDsmTable);
          } else if (value === "show_cim_tracker") {
            activateTracker("cim", "show_cim_tracker", getSplkCimTable);
          } else if (value === "show_splk_flx_tracker") {
            activateTracker("flx", "show_splk_flx_tracker", getSplkFlxTable);
          } else if (value === "show_splk_fqm_tracker") {
            activateTracker("fqm", "show_splk_fqm_tracker", getSplkFqmTable);
          } else if (value === "show_splk_dhm_tracker") {
            activateTracker("dhm", "show_splk_dhm_tracker", getSplkDhmTable);
          } else if (value === "show_splk_mhm_tracker") {
            activateTracker("mhm", "show_splk_mhm_tracker", getSplkMhmTable);
          } else if (value === "show_splk_wlk_tracker") {
            activateTracker("wlk", "show_splk_wlk_tracker", getSplkWlkTable);
          } else if (value === "show_audit_flip") {
            activateTracker(null, "show_audit_flip");
          } else if (value === "show_audit_changes") {
            activateTracker(null, "show_audit_changes");
          } else if (value === "show_alerts") {
            activateTracker(null, "show_alerts", getAlertTable);
          }
        }

        function activateTracker(component, trackerToken, tableFunction) {
          if (component) {
            setToken("tk_component", component);
          }
          setToken(trackerToken, "true");
          unsetAllTrackersExcept(trackerToken);
          if (tableFunction) {
            tableFunction();
          }
        }

        function unsetAllTrackersExcept(activeTracker) {
          var trackers = [
            "show_splk_dsm_tracker",
            "show_cim_tracker",
            "show_splk_dhm_tracker",
            "show_splk_flx_tracker",
            "show_splk_fqm_tracker",
            "show_splk_wlk_tracker",
            "show_splk_mhm_tracker",
            "show_audit_flip",
            "show_audit_changes",
            "show_alerts",
          ];

          trackers.forEach(function (tracker) {
            if (tracker !== activeTracker) {
              unsetToken(tracker);
            }
          });
        }

        // Generate the input links on page load
        genLinkMainInput();

        // Remove the css spinner at this stage
        cssloaderremove();

        return resultCall;
      } catch (error) {
        console.error(error);
      }
    }

    // verify user privileges level
    checkPrivileges();

    //
    // check tenant replica
    //

    async function checkReplica() {
      var ajaxurl = getSplunkUrl(
        "/splunkd/__raw/services/trackme/v2/vtenants/show_tenant"
      );
      var ajaxType = "POST";
      var resultCall;

      var defaultTokenModel = mvc.Components.getInstance("default", {
        create: true,
      });
      var submittedTokenModel = mvc.Components.getInstance("submitted", {
        create: true,
      });

      function setToken(name, value) {
        defaultTokenModel.set(name, value);
        submittedTokenModel.set(name, value);
      }

      var data = { tenant_id: getToken("tenant_id") };

      try {
        resultCall = await $.ajax({
          url: ajaxurl,
          type: ajaxType,
          data: JSON.stringify(data),
        });

        // retrieve vtenant_account
        var vtenant_account = resultCall.vtenant_account;

        // default tenant account time range
        setToken("ui_default_timerange", vtenant_account.ui_default_timerange);

        tenant_replica = resultCall.tenant_replica;
        setToken("tenant_replica", tenant_replica);
        // hide the tenant creation access button
        if (tenant_replica) {
          //
          setToken("update_icon_visible", false);
          //
          //
          // splk-dsm
          //
          // show replica
          $("#btn_modify_replica_trackers_dsm_main").css("display", "inherit");
          //
          $("#splk_dsm_manage_btns").css("display", "none");
          $("#splk_dsm_manage_btns2").css("display", "none");
          $("#splk-dsm-table-bulk").css("display", "none");
          $("#splk-dsm-table-save").css("display", "none");
          $("#splk-dsm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring").css("display", "none");
          $("#btn_disable_monitoring").css("display", "none");
          $("#btn_delete_splk_dsm").css("display", "none");
          $("#btn_modify_splk_dsm").css("display", "none");
          $("#btn_ack_splk_dsm").css("display", "none");
          $("#btn_splk_dsm_manage_outliers").css("display", "none");
          //
          // splk-dhm
          //
          // show replica
          $("#btn_modify_replica_trackers_dhm_main").css("display", "inherit");
          //
          $("#splk_dhm_manage_btns").css("display", "none");
          $("#splk_dhm_manage_btns2").css("display", "none");
          $("#splk-dhm-table-bulk").css("display", "none");
          $("#splk-dhm-table-save").css("display", "none");
          $("#splk-dhm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_host").css("display", "none");
          $("#btn_disable_monitoring_host").css("display", "none");
          $("#btn_delete_splk_dhm").css("display", "none");
          $("#btn_modify_splk_dhm").css("display", "none");
          $("#btn_ack_splk_dhm").css("display", "none");
          $("#btn_splk_dhm_manage_outliers").css("display", "none");
          //
          // splk-mhm
          //
          // show replica
          $("#btn_modify_replica_trackers_mhm_main").css("display", "inherit");
          //
          $("#splk_mhm_manage_btns").css("display", "none");
          $("#splk_mhm_manage_btns2").css("display", "none");
          $("#splk-mhm-table-bulk").css("display", "none");
          $("#splk-mhm-table-save").css("display", "none");
          $("#splk-mhm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_mhm").css("display", "none");
          $("#btn_disable_monitoring_splk_mhm").css("display", "none");
          $("#btn_delete_splk_mhm").css("display", "none");
          $("#btn_modify_splk_mhm").css("display", "none");
          $("#btn_ack_splk_mhm").css("display", "none");
          //
          // splk-cim
          //
          // show replica
          $("#btn_modify_replica_trackers_cim_main").css("display", "inherit");
          //
          $("#btn_manage_cim_trackers").css("display", "none");
          $("#splk-cim-table-bulk").css("display", "none");
          $("#splk-cim-table-save").css("display", "none");
          $("#splk-cim-table-cancel").css("display", "none");
          $("#btn_run_object").css("display", "none");
          $("#btn_enable_cim").css("display", "none");
          $("#btn_disable_cim").css("display", "none");
          $("#btn_delete_cim").css("display", "none");
          $("#btn_modify_cim").css("display", "none");
          $("#btn_ack_splk_cim").css("display", "none");
          $("#btn_splk_cim_manage_outliers").css("display", "none");
          //
          // splk-wlk
          //
          // show replica
          $("#btn_modify_replica_trackers_wlk_main").css("display", "inherit");
          //
          $("#btn_modify_hybrid_trackers_wlk_main").css("display", "none");
          $("#btn_modify_apps_wlk_main").css("display", "none");
          $("#splk-wlk-table-bulk").css("display", "none");
          $("#splk-wlk-table-save").css("display", "none");
          $("#splk-wlk-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_wlk").css("display", "none");
          $("#btn_disable_monitoring_splk_wlk").css("display", "none");
          $("#btn_delete_splk_wlk").css("display", "none");
          $("#btn_modify_splk_wlk").css("display", "none");
          $("#btn_ack_splk_cim").css("display", "none");
          $("#btn_splk_wlk_manage_outliers").css("display", "none");
          //
          // splk-flx
          //
          // show replica
          $("#btn_modify_replica_trackers_flx_main").css("display", "inherit");
          //
          $("#btn_modify_hybrid_trackers_flx_main").css("display", "none");
          $("#btn_run_tracker_flx").css("display", "none");
          $("#splk-flx-table-bulk").css("display", "none");
          $("#splk-flx-table-save").css("display", "none");
          $("#splk-flx-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_flx").css("display", "none");
          $("#btn_disable_monitoring_splk_flx").css("display", "none");
          $("#btn_delete_splk_flx").css("display", "none");
          $("#btn_modify_splk_flx").css("display", "none");
          $("#btn_ack_splk_flx").css("display", "none");
          $("#btn_splk_flx_manage_outliers").css("display", "none");
          //
          // splk-fqm
          //
          // show replica
          $("#btn_modify_replica_trackers_fqm_main").css("display", "inherit");
          //
          $("#btn_modify_hybrid_trackers_fqm_main").css("display", "none");
          $("#btn_run_tracker_fqm").css("display", "none");
          $("#splk-fqm-table-bulk").css("display", "none");
          $("#splk-fqm-table-save").css("display", "none");
          $("#splk-fqm-table-cancel").css("display", "none");
          $("#btn_enable_monitoring_splk_fqm").css("display", "none");
          $("#btn_disable_monitoring_splk_fqm").css("display", "none");
          $("#btn_delete_splk_fqm").css("display", "none");
          $("#btn_modify_splk_fqm").css("display", "none");
          $("#btn_ack_splk_fqm").css("display", "none");
          $("#btn_splk_fqm_manage_outliers").css("display", "none");
        } else {
          setToken("update_icon_visible", true);
        }
        return resultCall;
      } catch (error) {
        console.error(error);
      }
    }

    // verify if the tenant is a replica tenant
    checkReplica();

    //
    // Return TrackMe Config as an object
    //

    async function getTrackmeConf() {
      var ajaxurl = getSplunkUrl(
        "/splunkd/__raw/services/trackme/v2/configuration/request_info"
      );
      var ajaxType = "GET";
      var resultCall;

      try {
        resultCall = await $.ajax({
          url: ajaxurl,
          type: ajaxType,
        });
        return resultCall["trackme_conf"];
      } catch (error) {
        console.error(error);
      }
    }

    //
    // For Machine Learning, returns the list of available alrogithms
    //

    async function getMachineLearningAlgo() {
      try {
        const trackmeConf = await getTrackmeConf(); // This calls the existing function
        if (trackmeConf) {
          // Access the 'splk_outliers_detection' object and then the 'splk_outliers_mltk_algorithms_list' property
          const algorithmsDefault =
            trackmeConf.splk_outliers_detection
              .splk_outliers_mltk_algorithms_default;

          return algorithmsDefault; // Return the formatted array
        } else {
          return "DensityFunction"; // Return empty array if configuration is not found
        }
      } catch (error) {
        console.error(
          "Error retrieving the machine learning algorithms:",
          error
        );
        return "DensityFunction"; // Return empty array in case of error
      }
    }

    //
    // cssloader
    //

    function cssloader(msg) {
      $("#cssloader").remove();
      $("body").append(
        '<div id="cssloader" class="loader loader-default is-active" data-text="' +
          msg +
          '"></div>'
      );
    }

    function cssloaderremove() {
      $("#cssloader").remove();
    }

    //
    // Function to show error modal and pretty printed message
    //

    function showErrorModal(modalId, errorTitle, xhr, textStatus, errorThrown) {
      // Remove any spinner or loading indicator if needed
      if (typeof cssloaderremove === "function") {
        cssloaderremove();
      }

      // Format the error message nicely
      let message = "";
      try {
        const json = JSON.parse(xhr.responseText);
        message = JSON.stringify(json, null, 2);
      } catch (e) {
        message =
          "Server Response:\n" +
          xhr.responseText +
          "\n\nHTTP Error:\n" +
          (errorThrown || textStatus);
      }

      const $modal = $(`#${modalId}`);

      // Replace existing content with a styled <textarea>
      const $errorContainer = $modal.find(".modal-error-message p");
      $errorContainer.html(
        `<textarea readonly="readonly" rows="20">${message}</textarea>`
      );

      // Optional: update modal title, if you want to reuse it for multiple contexts
      if (errorTitle) {
        $modal
          .find(".modal-header h1")
          .html(`<span class="glyphicon glyphicon-lock"></span> ${errorTitle}`);
      }

      closeModals(); // Close any open ones, if needed
      $modal.modal(); // Open the error modal
    }

    //
    // Simple Function to show error modal manually (bad inputs detected, etc)
    //

    function showSimpleErrorModal(modalId, errorTitle, errorContent) {
      // Remove any spinner or loading indicator if needed
      if (typeof cssloaderremove === "function") {
        cssloaderremove();
      }

      // Format the error message nicely
      let message = "";
      try {
        const json = JSON.parse(errorContent);
        message = JSON.stringify(json, null, 2);
      } catch (e) {
        message = errorContent;
      }

      const $modal = $(`#${modalId}`);

      // Replace existing content with a styled <textarea>
      const $errorContainer = $modal.find(".modal-error-message p");
      $errorContainer.html(
        `<textarea readonly="readonly" rows="20">${message}</textarea>`
      );

      // Optional: update modal title, if you want to reuse it for multiple contexts
      if (errorTitle) {
        $modal
          .find(".modal-header h1")
          .html(`<span class="glyphicon glyphicon-lock"></span> ${errorTitle}`);
      }

      closeModals(); // Close any open ones, if needed
      $modal.modal(); // Open the error modal
    }

    //
    // Show Info / Success Message
    //

    /**
     * Show a modal with a success or informational message.
     *
     * @param {string} modalId - ID of the modal to show (e.g., "modal_alert_creation_success").
     * @param {string} containerSelector - Selector for the container (e.g., ".modal-success-message", ".modal-info-message").
     * @param {string} [title] - Optional new modal title (can include icons).
     * @param {string|object} response - The message content to display.
     */
    function showStatusModal(modalId, containerSelector, title, response) {
      // Remove loading spinner if present
      if (typeof cssloaderremove === "function") {
        cssloaderremove();
      }

      // Format the message
      let message = "";
      if (typeof response === "object") {
        message = JSON.stringify(response, null, 2);
      } else {
        try {
          const json = JSON.parse(response);
          message = JSON.stringify(json, null, 2);
        } catch (e) {
          message = response;
        }
      }

      const $modal = $(`#${modalId}`);
      const $container = $modal.find(containerSelector);

      // Inject formatted message using a <textarea>
      $container.html(
        `<textarea readonly="readonly" rows="20">${message}</textarea>`
      );

      // Optionally update modal title
      if (title) {
        $modal.find(".modal-header h1").html(title);
      }

      // Close others if needed, then show modal
      if (typeof closeModals === "function") {
        closeModals();
      }

      $modal.modal();
    }

    //
    // Notify
    //

    function notify(varCss, varPosition, varHtml, vardelay) {
      require([
        "jquery",
        Splunk.util.make_url(
          "/static/app/trackme/notifybar/jquery.notifyBar.js"
        ),
      ], function ($) {
        //code here
        jQuery(function () {
          jQuery.notifyBar({
            cssClass: varCss,
            position: varPosition,
            html: varHtml,
            delay: vardelay,
          });
        });
      });
    }

    //
    // Dynamic resize
    //

    // Add function to recalculate chart heights on window resize
    function recalculateModalChartHeights() {
      var newHeight = Math.max(400, Math.min(800, window.innerHeight * 0.6));

      // Update all chart heights in modals
      $(".modal-tenant-overview .view-elements").each(function () {
        if ($(this).find("svg").length > 0) {
          // Check if it's a chart
          $(this).css("height", newHeight + "px");
        }
      });
    }

    // Bind to window resize event
    $(window).on("resize", function () {
      recalculateModalChartHeights();
    });

    //
    // Convert time to seconds
    //

    function convertTimeToSeconds(timeValue) {
      // If it's already a number, return it
      if (typeof timeValue === "number") {
        return timeValue;
      }

      // If it's a string, try to parse the unit
      if (typeof timeValue === "string") {
        // Remove any whitespace
        timeValue = timeValue.trim();

        // Check if it ends with a unit
        if (timeValue.endsWith("h")) {
          return Math.floor(parseFloat(timeValue.slice(0, -1)) * 3600); // hours to seconds
        } else if (timeValue.endsWith("d")) {
          return Math.floor(parseFloat(timeValue.slice(0, -1)) * 86400); // days to seconds
        } else if (timeValue.endsWith("w")) {
          return Math.floor(parseFloat(timeValue.slice(0, -1)) * 604800); // weeks to seconds
        } else {
          // Try to convert to integer (assumed to be seconds)
          return Math.floor(parseFloat(timeValue));
        }
      }

      throw new Error(
        `Invalid time value format: ${timeValue}. Expected format: number or string with unit suffix (h/d/w)`
      );
    }

    //
    // Tabulator grouping functions
    //

    function convertCsvToArray(inputString) {
      try {
        // Attempt to parse as JSON array
        var parsedArray = JSON.parse(inputString);
        if (Array.isArray(parsedArray)) {
          return parsedArray;
        }
      } catch (e) {
        // If parsing fails, assume it's a CSV string and split it
        return inputString.split(",").map((item) => item.trim());
      }
    }

    function tabulatorGroupBy(context, data) {
      // Check if context is an expression
      if (typeof context === "string" && context.includes("data.")) {
        // Evaluate the expression using data
        return eval(context);
      } else {
        // Assume context is a string or a CSV string, convert it to an array and return
        var TabulatorGroupBy = convertCsvToArray(context);
        return TabulatorGroupBy;
      }
    }
    //
    // decode object: a simple function to decode backslashes encoded in unicode
    //

    function decodeObject(str) {
      if (str.includes("\\u005c")) {
        str = str.replace(/\\u005c/g, "\\");
      }
      return str;
    }

    // function to return show or not disabled entities
    function showDisableEntities(component) {
      var filterEnabledEl = $(
        "#splk-" + component + "-table-filter-enabled"
      ).val();
      if (filterEnabledEl === "true") {
        return "true";
      } else if (filterEnabledEl === "false") {
        return "false";
      }
    }

    // Function to return the Splunk Web base URL
    function getBaseURL() {
      // Parse the current URL
      const url = new URL(window.location.href);
      const final_url = `${url.protocol}//${url.host}${Splunk.util.make_url()}`;
      // the url contains the language as the last segment: https://<splunk_url>/en-US
      // we need to remove it
      return final_url.replace(/\/[a-zA-Z]{2}-[A-Z]{2}$/, "");
    }

    // Function to investigate key allowed parameters in the URL and return them in an object
    function getUrlParamsWithWildcards() {
      // Define the parameters to check in the URL
      const paramsToCheck = [
        "component",
        "keyid",
        "object",
        "alias",
        "priority",
        "earliest",
      ];
      const wildcard = "*"; // Define the wildcard value to use if a parameter isn't found

      // Retrieve the current URL
      const currentUrl = window.location.href;

      // Create a URL object
      const url = new URL(currentUrl);

      // Use URLSearchParams to work with the query string
      const searchParams = new URLSearchParams(url.search);

      // Object to store the results
      const paramsValues = {};

      // Loop through the list of parameters to check
      paramsToCheck.forEach((param) => {
        // Check if the parameter exists and retrieve its value, or use the wildcard
        paramsValues[param] = searchParams.has(param)
          ? searchParams.get(param)
          : wildcard;
      });

      // Return the object containing the parameter values or wildcards
      return paramsValues;
    }

    // Debounce function to limit the rate at which a function is executed
    function debounce(func, wait) {
      var timeout;
      return function () {
        var context = this,
          args = arguments;
        var later = function () {
          timeout = null;
          func.apply(context, args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
      };
    }

    //
    // For Outliers, return the list of available algorithms
    //

    function returnArrayFromCsv(csvString) {
      // Split the CSV string into an array
      var results = Array.isArray(csvString) ? csvString : csvString.split(",");

      // return
      return results;
    }

    //
    // For tags management
    //

    function setTagsFromCSV(csvString) {
      // if csvString is undefined, set an empty string
      if (csvString == undefined) {
        csvString = "";
      }

      // Selector for your tags input
      var $tagsInput = $("#tags_manual_input");

      // Clear all existing tags
      $tagsInput.tagsinput("removeAll");

      // Split the CSV string into an array of tags if it's not already an array
      var tags = Array.isArray(csvString) ? csvString : csvString.split(",");

      // Add each tag to the input
      tags.forEach(function (tag) {
        // Trim the tag to remove any leading or trailing spaces
        var trimmedTag = tag.trim();

        // Add the trimmed tag if it's not empty
        if (trimmedTag) {
          $tagsInput.tagsinput("add", trimmedTag);
        }
      });
    }

    //
    // fqm - dictionary preview
    //

    // a simple function to wrap the rest call generating the preview data dictionary
    function genFqmDataDictionaryPreview() {
      // Set the endpoint URL
      var myendpoint_URl = getSplunkUrl(
        "/splunkd/__raw/services/trackme/v2/splk_fqm/fqm_return_data_dictionary"
      );

      // set divs
      parentDiv = "divCreateFqmJsonPreview";
      spinnerDiv = "divChildCreateFqmJsonPreviewSpinner";
      childDiv = "divChildCreateFqmJsonPreview";

      // Show the parent
      $("#" + parentDiv).css("display", "inherit");
      // Show the spinner
      $("#" + spinnerDiv).css("display", "inherit");
      // hide the result viewer
      $("#" + childDiv).css("display", "none");

      // get the value of html dropdown modal_input_fqm_simulate_collect_job_recommended_fields
      var show_recommended_fields_only = $(
        "#fqm_generate_new_dictionary_recommended_fields"
      ).val();

      // set the record, if select_dictionary is "new", we rely on the provided options
      var record = {};
      if (
        getToken("tk_input_fqm_simulate_collect_job_select_dictionary") == "new"
      ) {
        record["datamodel"] = getToken(
          "tk_input_fqm_simulate_collect_job_datamodel"
        );
        record["recommended_fields"] = show_recommended_fields_only;
        record["allow_unknown"] = getToken(
          "tk_input_fqm_simulate_collect_job_new_dictionary_allow_unknown"
        );
        record["allow_empty_or_missing"] = getToken(
          "tk_input_fqm_simulate_collect_job_new_dictionary_allow_missing_or_null"
        );
      } else {
        record["from_name"] = getToken(
          "tk_input_fqm_simulate_collect_job_select_dictionary"
        );
        record["tenant_id"] = getToken("tenant_id");
      }

      $.ajax({
        url: myendpoint_URl,
        type: "POST",
        async: true,
        dataType: "json",
        data: JSON.stringify(record),
        contentType: "application/json",
        success: function (returneddata) {
          // hide
          $("#" + spinnerDiv).css("display", "none");
          // show
          // creation via template
          $("#" + childDiv).html(
            '<pre class="create-cim-json-rules-preview">' +
              syntaxHighlight(JSON.stringify(returneddata, null, 2)) +
              "</pre>"
          );
          $("#" + childDiv).css("display", "inherit");
          // store as a token
          setToken(
            "tk_input_fqm_simulate_collect_job_dictionary_json",
            JSON.stringify(returneddata)
          );
        },
        error: function (xhr, textStatus, error) {
          // hide
          $("#" + spinnerDiv).css("display", "none");
          // notify
          notify(
            "error",
            "bottom",
            "Failed to generate the data dictionary preview.",
            "5"
          );
          // creation via template
          $("#" + childDiv).html(
            '<pre class="create-cim-json-rules-preview">' +
              syntaxHighlight(JSON.stringify(xhr, null, 2)) +
              "</pre>"
          );
          $("#" + childDiv).css("display", "inherit");
        },
      });
    }

    //
    // For splk-dhm blocklist management
    //

    function setDhmBlocklistItemsFromCSV(csvString, context) {
      // Selector for your tags input
      if (context == "index") {
        var $tagsInput = $("#splk_dhm_per_host_idx_blocklist");
      } else if (context == "sourcetype") {
        var $tagsInput = $("#splk_dhm_per_host_st_blocklist");
      }

      // Clear all existing tags
      $tagsInput.tagsinput("removeAll");

      // if csvString is not null or undefined
      if (csvString) {
        // Split the CSV string into an array of tags if it's not already an array
        var tags = Array.isArray(csvString) ? csvString : csvString.split(",");

        // Add each tag to the input
        tags.forEach(function (tag) {
          // Trim the tag to remove any leading or trailing spaces
          var trimmedTag = tag.trim();

          // Add the trimmed tag if it's not empty
          if (trimmedTag) {
            $tagsInput.tagsinput("add", trimmedTag);
          }
        });
      }
    }

    //
    // getValueFromDropdown: create a function which returns the value of a dropdown by its id
    //

    function getValueFromDropdown(dropdownId) {
      var value = document.getElementById(dropdownId).value;
      return value;
    }

    //
    // Row popup formatter for Acknowledgements
    //

    // popup formatter (ack)
    var rowPopupFormatterAck = function (e, row, onRendered) {
      var data = row.getData();

      // We have the following Ack fields:
      // ack_comment, ack_expiration, ack_mtime, ack_state, ack_type

      var ack_comment = data.ack_comment;
      var ack_expiration = data.ack_expiration;
      var ack_mtime = data.ack_mtime;
      var ack_state = data.ack_state;
      var ack_type = data.ack_type;

      // if ack_expiration is not null, convert from epoch to human readable
      if (ack_expiration != "N/A") {
        ack_expiration = epochToHumanReadable(ack_expiration);
      } else {
        ack_expiration = "N/A";
      }

      // if ack_mtime is not null, convert from epoch to human readable
      if (ack_mtime != "N/A") {
        ack_mtime = epochToHumanReadable(ack_mtime);
      } else {
        ack_mtime = "N/A";
      }

      (container = document.createElement("div")),
        // Add all fields to the popup
        (contents =
          "<strong style='font-size:1.2em; color: black;'>Acknowledement Details</strong><br/>");
      contents +=
        "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
      contents +=
        "<li><strong>Acknowledgement state:</strong> " + ack_state + "</li>";
      contents +=
        "<li><strong>Acknowledgement type:</strong> " + ack_type + "</li>";
      contents +=
        "<li><strong>Acknowledgement expiration:</strong> " +
        ack_expiration +
        "</li>";
      contents +=
        "<li><strong>Acknowledgement comment:</strong> " +
        ack_comment +
        "</li>";
      contents +=
        "<li><strong>Acknowledgement last modified:</strong> " +
        ack_mtime +
        "</li>";
      contents += "</ul></div>";

      container.innerHTML = contents;

      return container;
    };

    //
    // Row popup formatter for Outliers
    //

    // popup formatter
    var rowPopupFormatterOutliers = function (e, row, onRendered) {
      var data = row.getData();

      // We have the following fields:
      // isOutlier, isOutlierReason, outliers_readiness, models_in_anomaly

      var isOutlier = data.isOutlier;
      var isOutlierReason = data.isOutlierReason;
      var outliers_readiness = data.outliers_readiness;
      var models_in_anomaly = data.models_in_anomaly;

      // Turn isOutlier from 0 to False, 1 to True
      if (isOutlier == "0") {
        isOutlier = "False";
      } else {
        isOutlier = "True";
      }

      // for all fields, if null, set to N/A
      if (isOutlierReason == "null") {
        isOutlierReason = "N/A";
      }

      if (outliers_readiness == "null") {
        outliers_readiness = "N/A";
      }

      if (models_in_anomaly == "null") {
        models_in_anomaly = "N/A";
      }

      (container = document.createElement("div")),
        // Add all fields to the popup
        (contents =
          "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
      contents +=
        "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
      contents += "<li><strong>isOutlier:</strong> " + isOutlier + "</li>";
      contents +=
        "<li><strong>Outlier Readiness:</strong> " +
        outliers_readiness +
        "</li>";
      contents +=
        "<li><strong>isOutlierReason:</strong> " + isOutlierReason + "</li>";
      contents +=
        "<li><strong>Models in Anomaly:</strong> " +
        models_in_anomaly +
        "</li>";
      contents += "</ul></div>";
      container.innerHTML = contents;
      return container;
    };

    //
    // Row popup formatter for Sampling
    //

    // popup formatter
    var rowPopupFormatterSampling = function (e, row, onRendered) {
      var data = row.getData();

      // We have the following fields:
      // SamplingIsOk (0 for False, 1 for True), data_sample_anomaly_reason

      var SamplingIsOk = data.SamplingIsOk;
      var data_sample_anomaly_reason = data.data_sample_anomaly_reason;

      // Turn SamplingIsOk from 0 to False, 1 to True
      if (SamplingIsOk == "0") {
        SamplingIsOk = "False";
      } else if (SamplingIsOk == "1") {
        SamplingIsOk = "True";
      } else {
        SamplingIsOk = "N/A";
      }

      // for all fields, if null, set to N/A
      if (data_sample_anomaly_reason == "null") {
        data_sample_anomaly_reason = "N/A";
      }

      (container = document.createElement("div")),
        // Add all fields to the popup
        (contents =
          "<strong style='font-size:1.2em; color: black;'>Outliers Details)</strong><br/>");
      contents +=
        "<div style='max-height: 600px; min-width: 600px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
      contents +=
        "<li><strong>SamplingIsOk:</strong> " + SamplingIsOk + "</li>";
      contents +=
        "<li><strong>Sampling Anomaly Reason:</strong> " +
        data_sample_anomaly_reason +
        "</li>";
      contents += "</ul></div>";
      container.innerHTML = contents;
      return container;
    };

    //
    // Set bootstrap based status icons
    //

    function setEmojiStatusIcons(status) {
      switch (status) {
        case "001":
          return "🟢";
        case "002":
          return "👀 🟢";
        case "003":
          return "🟢";
        case "004":
          return "🔴";
        case "005":
          return "👀 🔴";
        case "006":
          return "🔴";
        case "007":
          return "🟠";
        case "008":
          return "👀 🟠";
        case "009":
          return "🟠";
        case "010":
          return "🔵";
        case "011":
          return "👀 🔵";
        case "012":
          return "🔵";
        case "unknown":
          return "⚪";
        default:
          return "⚫"; // Default icon for undefined status
      }
    }

    //
    // Set bootstrap based status icons
    //

    function setBootstrapStatusIcons(status) {
      switch (status) {
        case "001":
          return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
        case "002":
          return "<i class='bi bi-eye-fill icon-state-green'></i>";
        case "003":
          return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
        case "004":
          return "<i class='bi bi-x-circle-fill icon-state-red'></i>";
        case "005":
          return "<i class='bi bi-eye-fill icon-state-red'></i>";
        case "006":
          return "<i class='bi bi-x-circle-fill icon-state-red'></i>";
        case "007":
          return "<i class='bi bi-exclamation-triangle-fill icon-state-orange'></i>";
        case "008":
          return "<i class='bi bi-eye-fill icon-state-orange'></i>";
        case "009":
          return "<i class='bi bi-exclamation-triangle-fill icon-state-orange'></i>";
        case "010":
          return "<i class='bi bi-info-circle-fill icon-state-blue'></i>";
        case "011":
          return "<i class='bi bi-eye-fill icon-state-blue'></i>";
        case "012":
          return "<i class='bi bi-info-circle-fill icon-state-blue'></i>";
        case "unknown":
          return "<i class='bi bi-question-circle-fill icon-state-grey'></i>";
        default:
          return "<i class='bi bi-slash-circle icon-state-black'></i>"; // Default icon for undefined status
      }
    }

    //
    // Set emoji based status icons
    //

    function setEmojiAlertStatusIcons(status) {
      switch (status) {
        case "0":
          return "🟢";
        case "1":
          return "🔴";
        case "unknown":
          return "⚪";
        default:
          return "⚫"; // Default icon for undefined status
      }
    }

    //
    // Set bootstrap based status icons
    //

    function setBootstrapAlertStatusIcons(status) {
      switch (status) {
        case "0":
          return "<i class='bi bi-check-circle-fill icon-state-green'></i>";
        case "1":
          return "<i class='bi bi-x-circle-fill icon-state-red'></i>";
        case "unknown":
          return "<i class='bi bi-question-circle-fill icon-state-grey'></i>";
        default:
          return "<i class='bi bi-slash-circle icon-state-black'></i>"; // Default icon for undefined status
      }
    }

    //
    // Truncate
    //

    function truncate(str, num) {
      if (typeof str === "undefined") {
        return "";
      }
      return str.length <= num ? str : str.slice(0, num) + "...";
    }

    //
    // Copy clipboard
    //

    function copyToClipboard(content) {
      // Copy the text inside the text field
      navigator.clipboard.writeText(content);
      notify("success", "bottom", "Copy to clipboard done!", "5");
    }

    //
    // epochtime second to human readable
    //

    function epochToHumanReadable(epoch) {
      // Convert epoch time from seconds to milliseconds
      const epochMilliseconds = epoch * 1000;

      // Create a new Date object using the epoch time value in milliseconds
      const date = new Date(epochMilliseconds);

      // Format the date as a human-readable string
      const humanReadableDate = date.toLocaleString();

      return humanReadableDate;
    }

    //
    // Invalid entry
    //

    function invalidEntry() {
      closeModals();
      $("#modal_entry_update_invalid").modal();
    }

    // disable the bulk edit button
    $("#splk-dsm-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-dsm-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-dsm-table-cancel").prop("disabled", true);

    // alert tabulator
    function alertHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // set the table div
        var tabulatorElement = "#" + "trackme-alerts-table";

        //Generate open icon
        var openIcon = function (cell, formatterParams) {
          return "<i class='bi bi-box-arrow-up-right'></i>";
        };

        //Generate tool icon
        var toolIcon = function (cell, formatterParams) {
          return "<i class='bi bi-tools'></i>";
        };

        // json formatter
        function csvToJsonFormatter(cell, formatterParams, onRendered) {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(cell.getValue().split(","), null, 4).replace(
            /\\/g,
            ""
          ); //return JSON formatted cell
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "id",
          layout: "fitDataStretch", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 50, //allow 50 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          height: "100%", // fixed height
          initialSort: [
            //set the initial sort order of the data
            { column: "title", dir: "asc" },
          ],

          columns: [
            {
              //create column group
              title: "Actions",
              columns: [
                // open
                {
                  formatter: openIcon,
                  width: 40,
                  hozAlign: "center",
                  headerSort: false,
                  cellClick: function (e, cell) {
                    // Open the entity modal
                    showAlertModal(cell.getRow().getData(), "view");
                  },
                },
                // tool
                {
                  formatter: toolIcon,
                  width: 40,
                  hozAlign: "center",
                  visible: getToken("update_icon_alert_visible"),
                  cellClick: function (e, cell) {
                    // Open the entity modal modify
                    showAlertModal(cell.getRow().getData(), "edit");
                  },
                },
              ],
            },
            {
              //create column group
              title: "Alert details",
              columns: [
                //define the table columns
                {
                  title: "",
                  field: "disabled",
                  visible: getToken("show_state_icons_bootstrap"),
                  hozAlign: "center",
                  width: 60,
                  formatter: function (cell, formatterParams) {
                    var status = cell.getValue();
                    return setBootstrapAlertStatusIcons(status);
                  },
                },
                {
                  title: "",
                  field: "disabled",
                  visible: getToken("show_state_icons_emoji"),
                  editor: false,
                  hozAlign: "center",
                  formatter: function (cell, formatterParams) {
                    var status = cell.getValue();
                    return setEmojiAlertStatusIcons(status);
                  },
                },
                {
                  title: "title",
                  field: "title",
                  editor: true,
                  headerFilter: true,
                },
                {
                  title: "cron_schedule",
                  field: "cron_schedule",
                  editor: false,
                },
                {
                  title: "schedule_window",
                  field: "schedule_window",
                  editor: false,
                },
                {
                  title: "suppress_fields",
                  field: "suppress_fields",
                  editor: false,
                },
                {
                  title: "suppress_period",
                  field: "suppress_period",
                  editor: false,
                },
                {
                  title: "actions",
                  field: "actions",
                  editor: false,
                  formatter: csvToJsonFormatter,
                },
                {
                  title: "disabled",
                  field: "disabled",
                  editor: false,
                },
                {
                  title: "next_scheduled_time",
                  field: "next_scheduled_time",
                  editor: false,
                },
              ],
            },
          ],
        });

        //
        // end
        //
      });
    }

    function showAlertModal(jsonData, action) {
      var tk_alert_title = jsonData["title"];
      // Token is required for further searches
      setToken("tk_alert_title", tk_alert_title);

      var tk_alert_cron_schedule = jsonData["cron_schedule"];
      var tk_alert_schedule_window = jsonData["schedule_window"];
      var tk_alert_suppress_fields = jsonData["suppress_fields"];
      var tk_alert_suppress_period = jsonData["suppress_period"];
      var tk_alert_disabled = jsonData["disabled"];
      var tk_alert_next_scheduled_time = jsonData["next_scheduled_time"];
      var tk_alert_actions = jsonData["actions"];

      // Update the divs
      $("#child-alert-tracking-info-panel-title").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for alert: <span>' +
          tk_alert_title +
          "</span></h1>"
      );

      $("#child-alert-tracking-info-panel1").html(
        '<h3>Disabled: <span style="color: dodgerblue;">' +
          tk_alert_disabled +
          "</h3></span>" +
          '<h3>Cron Schedule: <span style="color: dodgerblue;">' +
          tk_alert_cron_schedule +
          "</h3></span>" +
          '<h3>Schedule window: <span style="color: dodgerblue;">' +
          tk_alert_schedule_window +
          "</h3></span>"
      );

      $("#child-alert-tracking-info-panel2").html(
        '<h3>Suppress fields: <span style="color: dodgerblue;">' +
          tk_alert_suppress_fields +
          "</h3></span>" +
          '<h3>Suppress period: <span style="color: dodgerblue;">' +
          tk_alert_suppress_period +
          "</h3></span>"
      );

      $("#child-alert-tracking-info-panel3").html(
        '<h3>Next scheduled time: <span style="color: dodgerblue;">' +
          tk_alert_next_scheduled_time +
          "</h3></span>" +
          '<h3>Alert actions: <span style="color: dodgerblue;">' +
          tk_alert_actions +
          "</h3></span>"
      );

      // Define the alert URL
      var alert_id = jsonData["id"];
      var alert_url =
        "/app/trackme/alert?s=%2FservicesNS%2Fnobody%2Ftrackme%2Fsaved%2Fsearches%2F" +
        alert_id;

      // Define the URL target
      document.getElementById("btn_url_modal_manage_alert").href = alert_url;

      // Define the history search
      var alert_search_history =
        "/app/trackme/search" +
        '?q=search%20index%3D_audit%20action%3D"alert_fired"%20ss_app%3D"trackme"%20ss_name%3D"' +
        encodeURI(tk_alert_title) +
        '"';

      // Define the URL target
      document.getElementById("btn_url_modal_history_alert").href =
        alert_search_history;

      // Enable modal context

      if (action == "view") {
        setToken("show_alerts_overview", "true");
        searchAlertTriggeredOverTimePerAlert.startSearch();
        searchAlertActionsOverTimePerAlert.startSearch();
        $("#modal_manage_alerts").modal();
      } else if (action == "edit") {
        document.getElementById("btn_url_modal_manage_alert").click();
      }
    }

    // alert get table
    function getAlertTable() {
      var tk_tenant_id = getToken("tenant_id");
      alertHandlerTable(
        getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/alerting/get_tenant_alerts"
        ),
        "POST",
        {
          tenant_id: tk_tenant_id,
        }
      );
    }

    // global auto-refresh interval
    var tableRefreshIntervalId;

    // splk-dsm tabulator
    function splkDsmHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-dsm-table";

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-dsm-table-filter-field");
      var typeEl = document.getElementById("splk-dsm-table-filter-type");
      var valueEl = document.getElementById("splk-dsm-table-filter-value");
      var enabledEl = document.getElementById("splk-dsm-table-filter-enabled");

      // custom functions

      // Standard filters
      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      // specific filters
      function customFilterLatencyTresholdAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
          ]);
        }
      }

      function customFilterDelayTresholdAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "delay_threshold_breached",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "delay_threshold_breached",
            },
          ]);
        }
      }

      function customFilterHostDcountAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "anomaly_reason", type: "=", value: "min_hosts_dcount" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "anomaly_reason", type: "=", value: "min_hosts_dcount" },
          ]);
        }
      }

      function customFilterOutliersAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
          ]);
        }
      }

      function customFilterSamplingAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "data_sampling_anomaly",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "data_sampling_anomaly",
            },
          ]);
        }
      }

      function customFilterFuture(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
          ]);
        }
      }

      // free filter
      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("dsm");
        var enteredValue = document.getElementById(
          "splk-dsm-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_blue_state") {
          customFilterBlueState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // specific filters
        } else if (filterVal == "function_lagthreshold_anomaly") {
          customFilterLatencyTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_future") {
          customFilterFuture(showDisabled);
        } else if (filterVal == "function_lagthreshold_anomaly") {
          customFilterLatencyTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_delaythreshold_anomaly") {
          customFilterDelayTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_hostdcount_anomaly") {
          customFilterHostDcountAnomaly(showDisabled);
        } else if (filterVal == "function_outliers_anomaly") {
          customFilterOutliersAnomaly(showDisabled);
        } else if (filterVal == "function_sampling_anomaly") {
          customFilterSamplingAnomaly(showDisabled);
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkDsm.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkDsmAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val("function_alert_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkDsmAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkDsmAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkDsmDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkDsmCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dsm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkDsmCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-dsm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-dsm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-dsm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-dsm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-dsm-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-dsm-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-dsm-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: dodgerblue; font-style: italic;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Sourcetype:</h3>";
        contents += "<li><strong>Index:</strong> " + data.data_index + "</li>";
        contents +=
          "<li><strong>Sourcetype:</strong> " + data.data_sourcetype + "</li>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>AnomalyReason:</strong> " +
          data.anomaly_reason +
          "</li>";
        contents +=
          "<li><strong>Outliers anomaly detection state:</strong> " +
          data.OutliersStatus +
          "</li>";
        contents +=
          "<li><strong>Data sampling anomaly detection state:</strong> " +
          data.SamplingStatus +
          "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Delay & Latency:</h3>";
        contents +=
          "<li><strong>Lagging summary:</strong> " + data.lag_summary + "</li>";
        contents +=
          "<li><strong>Last ingest:</strong> " + data.last_ingest + "</li>";
        contents +=
          "<li><strong>Last event:</strong> " + data.last_time + "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Thresholds & Configuration</h3>";
        contents +=
          "<li><strong>Max latency allowed:</strong> " +
          data.data_max_lag_allowed +
          " seconds</li>";
        contents +=
          "<li><strong>Max delay allowed:</strong> " +
          data.data_max_delay_allowed +
          " seconds</li>";
        contents +=
          "<li><strong>Hosts distinct count:</strong> " +
          data.dcount_host +
          "</li>";
        contents +=
          "<li><strong>Min hosts distinct count:</strong> " +
          data.min_dcount_host +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring days:</strong> " +
          data.isUnderMonitoringDays +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring hours:</strong> " +
          data.isUnderMonitoringHours +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_dsm_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        //progressiveLoad:"load", //enable progressive loading
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        index: "keyid",
        layout: "fitDataFill", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "data_index", dir: "asc" },
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkDsmEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_dsm",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkDsmEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_dsm_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkDsmEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_dsm",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "index",
                field: "data_index",
                visible: false,
              },
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                contextPopup: rowPopupFormatter, //add click popup to row
                minWidth: getToken("ui_min_object_width"),
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Current statistics and main indexing information",
            columns: [
              {
                title: "lag (delay / latency)",
                field: "lag_summary",
                width: 160,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Latest event",
                field: "last_time",
                width: 140,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Latest ingest",
                field: "last_ingest",
                width: 140,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            //create column group
            title: "Thresholds and features status",
            columns: [
              {
                title: "Delay (sec)",
                field: "data_max_delay_allowed",
                editor: "number",
                editorParams: {
                  min: 0,
                  step: 300,
                  verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
                },
                headerFilter: false,
                width: 125,
              },
              {
                title: "Duration",
                field: "data_max_delay_allowed_duration",
                headerFilter: false,
                width: 110,
              },
              {
                title: "Latency (sec)",
                field: "data_max_lag_allowed",
                editor: "number",
                editorParams: {
                  min: 0,
                  step: 300,
                  verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
                },
                headerFilter: false,
                width: 125,
              },
              {
                title: "Duration",
                field: "data_max_lag_allowed_duration",
                headerFilter: false,
                width: 110,
              },
              {
                title: "Adaptive delay",
                field: "allow_adaptive_delay",
                editor: "list",
                editorParams: { values: ["true", "false"] },
                headerFilter: "input",
                width: 140,
                visible: getToken("adaptive_delay"),
              },
              {
                title: "Class override",
                field: "data_override_lagging_class",
                editor: "list",
                editorParams: { values: ["true", "false"] },
                headerFilter: "input",
                width: 140,
              },
              {
                title: "Alert over",
                field: "data_lag_alert_kpis",
                editor: "list",
                editorParams: {
                  values: ["all_kpis", "lag_event_kpi", "lag_ingestion_kpi"],
                },
                headerFilter: "input",
                width: 140,
              },
              {
                title: "Outliers",
                field: "OutliersIsOk",
                contextPopup: rowPopupFormatterOutliers, //add click popup to row
                hozAlign: "center",
                formatter: "tickCross",
                width: 100,
                visible: getToken("mloutliers_dsm"),
              },
              {
                title: "Sampling",
                field: "SamplingIsOk",
                contextPopup: rowPopupFormatterSampling, //add click popup to row
                hozAlign: "center",
                formatter: "tickCross",
                width: 100,
                visible: getToken("sampling"),
              },
            ],
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-dsm-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-dsm-table-filter-field").val("keyid");
            $("#splk-dsm-table-filter-type").val("=");
            $("#splk-dsm-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkDsmEntityModal(
                currentData[0],
                "modal_manage_splk_dsm",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-dsm-table-filter-field").val("alias");
              $("#splk-dsm-table-filter-type").val("=");
              $("#splk-dsm-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkDsmEntityModal(
                  currentData[0],
                  "modal_manage_splk_dsm",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-dsm-table-filter-field").val("object");
              $("#splk-dsm-table-filter-type").val("=");
              $("#splk-dsm-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkDsmEntityModal(
                  currentData[0],
                  "modal_manage_splk_dsm",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-dsm-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-dsm-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-dsm-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-dsm-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-dsm-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by priority" button
        document
          .getElementById("splk-dsm-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by index" button
        document
          .getElementById("splk-dsm-table-update-groupby-index")
          .addEventListener("click", function () {
            table.setGroupBy([["data_index"]]);
          });

        // Event listener for "Group by sourcetype" button
        document
          .getElementById("splk-dsm-table-update-groupby-sourcetype")
          .addEventListener("click", function () {
            table.setGroupBy([["data_sourcetype"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-dsm-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-dsm-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-dsm-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-dsm-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=dsm"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-dsm-table-bulk").prop("disabled", false);
          splkDsmPauseRefreshInfo();
        } else {
          $("#splk-dsm-table-bulk").prop("disabled", true);
          document.getElementById("splkDsmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkDsmResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-dsm-table-save").prop("disabled", false);
        $("#splk-dsm-table-cancel").prop("disabled", false);
        splkDsmPauseRefreshInfo();
      });

      // set the timer
      splkDsmRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-dsm-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-dsm-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkDsmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // auto hidden refresh
      $("#splk-dsm-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkDsmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-dsm-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkDsmBulkObjs", itemList.toString());
          setToken("splkDsmBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divDsmBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_dsm").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-dsm-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkDsmMain.startSearch();
              // refresh tabulator
              $("#splk-dsm-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-dsm-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-dsm-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkDsmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-dsm-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-dsm-table-refresh-hidden").click();
          splkDsmResumeTableRefresh();
        });

      // priority: create a function to limit code repetition
      function splkDsmBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dsm",
          keys_list: splkDsmBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        //spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // spinner
            cssloaderremove();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_dsm_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkDsmBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_dsm_bulk_priority_high")
        .unbind()
        .click(function () {
          splkDsmBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_dsm_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkDsmBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_dsm_bulk_priority_low")
        .unbind()
        .click(function () {
          splkDsmBulkPriority("low");
        });

      // priority: create a function to limit code repetition
      function splkDsmBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkObjs = getToken("splkDsmBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_dsm_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_dsm_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_dsm_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_dsm_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-dsm",
            object_list: splkDsmBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-dsm",
            object_list: splkDsmBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // lag policies: create a function to limit code repetition
      function splkDsmBulkLagPolicyUpdate(
        fieldName,
        fieldValue,
        successMessage
      ) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkObjs = getToken("splkDsmBulkObjs");
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw//services/trackme/v2/splk_dsm/write/ds_update_lag_policy"
        );

        // Create record with only the specific field being updated
        var record = {
          tenant_id: tk_tenant_id,
          object_list: splkDsmBulkObjs,
          update_comment: tk_comment,
        };

        // Add the specific field to the record
        record[fieldName] = fieldValue;

        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            cssloaderremove();
            searchSplkDsmMain.startSearch();
            $("#splk-dsm-table-refresh-hidden").click();
            notify("success", "bottom", successMessage, "5");
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // Event handlers for individual apply buttons
      $("#btn_splk_dsm_bulk_latency_threshold_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "data_max_lag_allowed",
            $("#btn_splk_dsm_bulk_latency_threshold").val(),
            "Latency threshold updated successfully."
          );
        });

      $("#btn_splk_dsm_bulk_delay_threshold_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "data_max_delay_allowed",
            $("#btn_splk_dsm_bulk_delay_threshold").val(),
            "Delay threshold updated successfully."
          );
        });

      $("#btn_splk_dsm_bulk_override_lagging_classes_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "data_override_lagging_class",
            $("#btn_splk_dsm_bulk_override_lagging_classes").val(),
            "Override lagging classes updated successfully."
          );
        });

      $("#btn_splk_dsm_bulk_allow_adaptive_delay_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "allow_adaptive_delay",
            $("#btn_splk_dsm_bulk_allow_adaptive_delay").val(),
            "Allow adaptive delay updated successfully."
          );
        });

      $("#btn_splk_dsm_bulk_alert_over_kpis_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "data_lag_alert_kpis",
            $("#btn_splk_dsm_bulk_alert_over_kpis").val(),
            "Alert over KPIs updated successfully."
          );
        });

      $("#btn_splk_dsm_bulk_future_tolerance_apply")
        .unbind()
        .click(function () {
          splkDsmBulkLagPolicyUpdate(
            "future_tolerance",
            $("#btn_splk_dsm_bulk_future_tolerance").val(),
            "Future tolerance updated successfully."
          );
        });

      // bulk ack enable
      $("#btn_splk_dsm_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkDsmBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_dsm_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkDsmBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkDsmBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dsm",
          keys_list: splkDsmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_dsm_bulk_enable")
        .unbind()
        .click(function () {
          splkDsmBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_dsm_bulk_disable")
        .unbind()
        .click(function () {
          splkDsmBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkDsmBulkDelete(actionTarget) {
        var splkDsmBulkIds = getToken("splkDsmBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkDsmBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_dsm_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkDsmBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_dsm_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkDsmBulkDelete("permanent");
        });

      // bulk manual tags: create a function to limit code repetition
      function splkDsmBulkManualTags(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_update_manual_tags"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dsm",
          keys_list: splkDsmBulkIds,
          update_comment: tk_comment,
        };

        // Set depending on action
        if (actionTarget == "set_tags") {
          var tk_tags_manual = $("#btn_splk_dsm_bulk_tags_list").tagsinput(
            "items"
          );
        } else if (actionTarget == "clear_tags") {
          var tk_tags_manual = "";
        }

        // update record
        record.tags_manual = tk_tags_manual;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_dsm_bulk_create_manual_tags)
      $("#btn_splk_dsm_bulk_create_manual_tags")
        .unbind()
        .click(function () {
          splkDsmBulkManualTags("set_tags");
        });

      // call (button btn_splk_dsm_bulk_clear_manual_tags)
      $("#btn_splk_dsm_bulk_clear_manual_tags")
        .unbind()
        .click(function () {
          splkDsmBulkManualTags("clear_tags");
        });

      // associate new logical group: create a function to limit code repetition
      function splkDsmBulkAssociateNewLogicalGroup() {
        var splkDsmBulkObjs = getToken("splkDsmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDsmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dsm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_get", "True");

        // hide this action
        $("#btn_associate_logical_group_add_group_back").hide();
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group_add_group").modal();
      }

      // bulk
      $("#btn_splk_dsm_bulk_associate_new_logical_group")
        .unbind()
        .click(function () {
          splkDsmBulkAssociateNewLogicalGroup();
        });

      // associate existing logical group: create a function to limit code repetition
      function splkDsmBulkAssociateExistingLogicalGroup() {
        var splkDsmBulkObjs = getToken("splkDsmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDsmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dsm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_add", "True");

        // Start search
        searchLogicalGroupTableAddMember.startSearch();

        // hide this action
        $("#btn_associate_logical_group_add_member_back").hide();

        // Open modal
        $("#logical_group_add_member").modal();
      }

      // bulk
      $("#btn_splk_dsm_bulk_associate_existing_logical_group")
        .unbind()
        .click(function () {
          splkDsmBulkAssociateExistingLogicalGroup();
        });

      // unassociate logical group: create a function to limit code repetition
      function splkDsmBulkUnassociateLogicalGroup() {
        var splkDsmBulkObjs = getToken("splkDsmBulkObjs");

        // Free the search
        setToken("tk_start_logical_member_get", "true");

        // Start the search
        searchLogicalGroupTable.startSearch();

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDsmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dsm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // hide this action
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group").modal();
      }

      // bulk
      $("#btn_splk_dsm_bulk_unassociate_logical_group")
        .unbind()
        .click(function () {
          splkDsmBulkUnassociateLogicalGroup();
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkDsmBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "dsm",
          keys_list: splkDsmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_dsm_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkDsmBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_dsm_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkDsmBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_dsm_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkDsmBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_dsm_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkDsmBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_dsm_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkDsmBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkDsmBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "dsm",
          keys_list: splkDsmBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metric
      $("#btn_splk_dsm_bulk_outliers_kpi_metric")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_kpi_metric_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_kpi_metric_value"
          ).val();
          // set actionField
          var actionField = "kpi_metric";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_dsm_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_dsm_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_dsm_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_dsm_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_dsm_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_dsm_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_dsm_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_dsm_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_dsm_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dsm_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_dsm_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_dsm_bulk_outliers_custom_key
          var actionField = $("#btn_splk_dsm_bulk_outliers_custom_key").val();
          splkDsmBulkOutliersRules(actionField, actionValue);
        });

      // Sampling management: create a function to limit code repetition
      function splkDsmBulkSampling(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDsmBulkIds = getToken("splkDsmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dsm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/write/ds_manage_data_sampling"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "dsm",
          keys_list: splkDsmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDsmMain.startSearch();
            // refresh tabulator
            $("#splk-dsm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_dsm_bulk_sampling_enable")
        .unbind()
        .click(function () {
          splkDsmBulkSampling("enable");
        });

      // bulk disable
      $("#btn_splk_dsm_bulk_sampling_disable")
        .unbind()
        .click(function () {
          splkDsmBulkSampling("disable");
        });

      // bulk run
      $("#btn_splk_dsm_bulk_sampling_run")
        .unbind()
        .click(function () {
          splkDsmBulkSampling("run");
        });

      // bulk reset
      $("#btn_splk_dsm_bulk_sampling_reset")
        .unbind()
        .click(function () {
          splkDsmBulkSampling("reset");
        });

      //
      // end
      //
    }

    // splk-dsm get table
    function getSplkDsmTable() {
      // avoid causing double interval
      clearInterval(splkDsmIntervalId);
      splkDsmHandlerTable();
    }

    // splk-dsm refresh timer
    var splkDsmIntervalId;

    function splkDsmRefreshInfo() {
      var myDate = new Date();
      var splkDsmLastRefresh = document.getElementById("splkDsmLastRefresh");
      function updateTime() {
        splkDsmLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkDsmIntervalId = setInterval(updateTime, 2000);
    }

    function splkDsmResetRefreshInfo() {
      clearInterval(splkDsmIntervalId);
      // release our intervalID from the variable
      splkDsmIntervalId = null;
      splkDsmRefreshInfo();
    }

    function splkDsmPauseRefreshInfo() {
      clearInterval(splkDsmIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkDsmIntervalId = null;
      tableRefreshIntervalId = null;
      splkDsmLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkDsmResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-dsm-table-refresh-hidden").click();
        }, 300000);
      }
    }

    //
    // splk-cim tabulator
    //

    // disable the bulk edit button
    $("#splk-cim-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-cim-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-cim-table-cancel").prop("disabled", true);

    function splkCimHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-cim-table";

      // get tenant level preference
      var ui_expand_metrics = getToken("ui_expand_metrics");
      if (ui_expand_metrics == 1) {
        var fieldEl = getValueFromDropdown("splk-cim-table-mode");
        fieldEl.value = "full";
      }

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-cim-table-mode");
        if (modeView === "minimal") {
          return "right click for popup";
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 2); //return JSON formatted cell
        }
      }

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-cim-table-filter-field");
      var typeEl = document.getElementById("splk-cim-table-filter-type");
      var valueEl = document.getElementById("splk-cim-table-filter-value");
      var enabledEl = document.getElementById("splk-cim-table-filter-enabled");

      // listen for a change
      $("#splk-cim-table-mode").change(function () {
        table.setData(
          getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
          ),
          {
            tenant_id: getToken("tenant_id"),
            component: getToken("tk_component"),
            mode_view: getValueFromDropdown("splk-cim-table-mode"),
            pagination_mode: getToken("pagination_mode"),
          }
        );
      });

      // custom functions

      // Standard filters
      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      // free filter
      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("cim");
        var enteredValue = document.getElementById(
          "splk-cim-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalCimEntities.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-cim-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalCimEntitiesAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-cim-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalCimEntitiesAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-cim-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalCimEntitiesDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-cim-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutCimCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-cim-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutCimCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-cim-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-cim-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-cim-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-cim-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-cim-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-cim-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-cim-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>DataModel details:</h3>";
        contents += "<li><strong>Account:</strong> " + data.account + "</li>";
        contents +=
          "<li><strong>Datamodel name:</strong> " +
          data.cim_datamodel_name +
          "</li>";
        contents +=
          "<li><strong>Datamodel node:</strong> " +
          data.cim_datamodel_nodename +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>CIM fields in alert:</strong> " +
          data.cim_fields_red +
          "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<li><strong>Latest flip time:</strong> " +
          data.latest_flip_time +
          "</li>";
        contents +=
          "<li><strong>Latest flip state:</strong> " +
          data.latest_flip_state +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Tracker Key Information:</h3>";
        contents +=
          "<li><strong>Tracker name:</strong> " + data.tracker_name + "</li>";
        contents +=
          "<li><strong>Tracker runtime:</strong> " +
          data.tracker_runtime +
          "</li>";
        contents +=
          "<li><strong>Tracker last duration:</strong> " +
          data.tracker_last_duration +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // popup formatter
      var rowPopupFormatterRulesDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.cim_tracking_rules);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Rules Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // popup formatter
      var rowPopupFormatterResultsDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.cim_tracking_results);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Rules Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_cim_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        //progressiveLoad:"load", //enable progressive loading
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        index: "keyid",
        layout: "fitDataFill", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkSplkCimModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_cim",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkSplkCimModal(
                    cell.getRow().getData(),
                    "btn_modify_cim",
                    "click"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkSplkCimModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_cim",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                minWidth: getToken("ui_min_object_width"),
                contextPopup: rowPopupFormatter, //add click popup to row
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Tracking rules and results",
            columns: [
              {
                title: "Rules",
                field: "cim_tracking_rules",
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterRulesDetails,
                minWidth: 350,
                variableHeight: true,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Results",
                field: "cim_tracking_results",
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterResultsDetails,
                minWidth: 350,
                variableHeight: true,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            //create column group
            title: "Tracker information",
            columns: [
              {
                title: "Run time",
                field: "tracker_runtime (translated)",
                width: 160,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Last duration",
                field: "tracker_last_duration",
                width: 140,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            title: "Outliers",
            field: "OutliersIsOk",
            contextPopup: rowPopupFormatterOutliers, //add click popup to row
            hozAlign: "center",
            formatter: "tickCross",
            width: 100,
            visible: getToken("mloutliers_cim"),
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-cim-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-cim-table-filter-field").val("keyid");
            $("#splk-cim-table-filter-type").val("=");
            $("#splk-cim-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkSplkCimModal(
                currentData[0],
                "modal_manage_splk_cim",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-cim-table-filter-field").val("alias");
              $("#splk-cim-table-filter-type").val("=");
              $("#splk-cim-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkSplkCimModal(
                  currentData[0],
                  "modal_manage_splk_cim",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-cim-table-filter-field").val("object");
              $("#splk-cim-table-filter-type").val("=");
              $("#splk-cim-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkSplkCimModal(
                  currentData[0],
                  "modal_manage_splk_cim",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-cim-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-cim-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-cim-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by datamodel" button
        document
          .getElementById("splk-cim-table-update-groupby-datamodel")
          .addEventListener("click", function () {
            table.setGroupBy([["cim_datamodel_name"]]);
          });

        // Event listener for "Group by cimfields" button
        document
          .getElementById("splk-cim-table-update-groupby-cimfields")
          .addEventListener("click", function () {
            table.setGroupBy([["cim_fields"]]);
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-cim-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-cim-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by priority" button
        document
          .getElementById("splk-cim-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-cim-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-cim-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-cim-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-cim-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=cim"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-cim-table-bulk").prop("disabled", false);
          splkCimPauseRefreshInfo();
        } else {
          $("#splk-cim-table-bulk").prop("disabled", true);
          document.getElementById("splkCimLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkCimResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-cim-table-save").prop("disabled", false);
        $("#splk-cim-table-cancel").prop("disabled", false);
        splkCimPauseRefreshInfo();
      });

      // set the timer
      splkCimRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-cim-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-cim-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkCimResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      $("#splk-cim-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkCimResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-cim-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkCimBulkObjs", itemList.toString());
          setToken("splkCimBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divCimBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_cim").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-cim-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_cim/write/cim_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkCimMain.startSearch();
              // refresh tabulator
              $("#splk-cim-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-cim-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-cim-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkCimLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-cim-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-cim-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkCimBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkCimBulkIds = getToken("splkCimBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_cim_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_cim/write/cim_tracker_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-cim",
          keys_list: splkCimBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkCimMain.startSearch();
            // refresh tabulator
            $("#splk-cim-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_cim_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkCimBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_cim_bulk_priority_high")
        .unbind()
        .click(function () {
          splkCimBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_cim_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkCimBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_cim_bulk_priority_low")
        .unbind()
        .click(function () {
          splkCimBulkPriority("low");
        });

      // priority: create a function to limit code repetition
      function splkCimBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkCimBulkObjs = getToken("splkCimBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_cim_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_cim_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_cim_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_cim_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_cim_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-cim",
            object_list: splkCimBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-cim",
            object_list: splkCimBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkCimMain.startSearch();
            // refresh tabulator
            $("#splk-cim-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk ack enable
      $("#btn_splk_cim_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkCimBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_cim_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkCimBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkCimBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkCimBulkIds = getToken("splkCimBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_cim_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_cim/admin/cim_tracker_enablement"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkCimBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkCimMain.startSearch();
            // refresh tabulator
            $("#splk-cim-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_cim_bulk_enable")
        .unbind()
        .click(function () {
          splkCimBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_cim_bulk_disable")
        .unbind()
        .click(function () {
          splkCimBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkCimBulkDelete() {
        object_manage(
          "delete",
          getToken("splkCimBulkObjs"),
          "none",
          "input_splk_cim_bulk_comment",
          "none"
        );
      }

      // bulk delete
      $("#btn_splk_cim_bulk_deletion")
        .unbind()
        .click(function () {
          splkCimBulkDelete();
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkCimBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkCimBulkIds = getToken("splkCimBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_cim_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "cim",
          keys_list: splkCimBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkCimMain.startSearch();
            // refresh tabulator
            $("#splk-cim-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_cim_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkCimBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_cim_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkCimBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_cim_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkCimBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_cim_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkCimBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_cim_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkCimBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkCimBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkCimBulkIds = getToken("splkCimBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_cim_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "cim",
          keys_list: splkCimBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkCimMain.startSearch();
            // refresh tabulator
            $("#splk-cim-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metric
      $("#btn_splk_cim_bulk_outliers_kpi_metric")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_kpi_metric_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_kpi_metric_value"
          ).val();
          // set actionField
          var actionField = "kpi_metric";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_cim_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_cim_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_cim_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_cim_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_cim_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_cim_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_cim_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_cim_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_cim_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_cim_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_cim_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_cim_bulk_outliers_custom_key
          var actionField = $("#btn_splk_cim_bulk_outliers_custom_key").val();
          splkCimBulkOutliersRules(actionField, actionValue);
        });

      //
      // end
      //
    }

    // splk-cim get table
    function getSplkCimTable() {
      // avoid causing double interval
      clearInterval(splkCimIntervalId);
      splkCimHandlerTable();
    }

    // splk-cim refresh timer
    var splkCimIntervalId;

    function splkCimRefreshInfo() {
      var myDate = new Date();
      var splkCimLastRefresh = document.getElementById("splkCimLastRefresh");
      function updateTime() {
        splkCimLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkCimIntervalId = setInterval(updateTime, 2000);
    }

    function splkCimResetRefreshInfo() {
      clearInterval(splkCimIntervalId);
      // release our intervalID from the variable
      splkCimIntervalId = null;
      splkCimRefreshInfo();
    }

    function splkCimPauseRefreshInfo() {
      clearInterval(splkCimIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkCimIntervalId = null;
      tableRefreshIntervalId = null;
      splkCimLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkCimResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-cim-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-cim modal entity view

    function showSplkSplkCimModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];

      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);

      // Get tenant and manage replica
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      var tk_object = jsonData["object"];
      var tk_alias = jsonData["alias"];
      // token is required
      setToken("tk_object", tk_object);
      setToken("tk_object_category", jsonData["object_category"]);

      var tk_tracker_name = jsonData["tracker_name"];
      // token is required
      setToken("tk_tracker_name", tk_tracker_name);

      var tk_account = jsonData["account"];
      // token is required
      setToken("tk_account", tk_account);

      // get the tracking rules as an object
      var cim_tracking_rules = JSON.parse(jsonData["cim_tracking_rules"]);

      // from it, retrieve the breakby and set it as a token
      var cim_breakby = cim_tracking_rules["cim_breakby"];

      // if unused, will be set to none, override this to be cim_entity_zone
      if (cim_breakby == "none") {
        cim_breakby = "cim_entity_zone";
      }

      // Set as a token
      setToken("tk_cim_breakby", cim_breakby);

      // define an information span
      var tk_location;
      if (tk_account === "local") {
        tk_location = "local";
      } else {
        tk_location = "remote (account=" + tk_account + ")";
      }

      var tk_object_state = jsonData["object_state"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];
      var tk_cim_monitored_state = jsonData["monitored_state"];
      var tk_cim_datamodel_name = jsonData["cim_datamodel_name"];
      var tk_cim_datamodel_nodename = jsonData["cim_datamodel_nodename"];
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_cim_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_cim_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_cim_set_threshold_value"
        ).value = "";
      }

      // wdays - hours_range
      var monitoring_wdays = jsonData["monitoring_wdays"];
      setToken("form.tk_input_wdays_cim", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["monitoring_hours_ranges"];
      setToken("form.tk_input_splk_cim_hours_ranges", monitoring_hours_ranges);

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      setToken("form.tk_input_splk_cim_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkCim").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkCim").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkCim").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkCim").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkCim").html("");
      }

      var tk_tracker_runtime = jsonData["tracker_runtime (translated)"];
      var tk_tracker_last_duration = jsonData["tracker_last_duration"];

      // pre-fill current wdays input
      setToken("form.tk_input_wdays_cim", jsonData["monitoring_wdays"]);

      // pre-fill current hours ranges
      setToken(
        "form.tk_input_splk_cim_hours_ranges",
        jsonData["monitoring_hours_ranges"]
      );

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divCimOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divCimOutliersSimulationInfo").css("display", "none");
        $("#divCimOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_cim_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_cim_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divCimOutliersInfo").css("display", "inherit");
        $("#child-cim-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divCimOutliersSimulationInfo").css("display", "inherit");
        $("#divCimOutliersSimulationRender").css("display", "none");
        $("#child-cim-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_cim_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_cim_save").prop("disabled", true);
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_cim").disabled = false;
        $("#btn_ack_splk_cim").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_cim").disabled = false;
        $("#btn_ack_splk_cim").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_cim").disabled = false;
        $("#btn_ack_splk_cim").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_cim").disabled = true;
        $("#btn_ack_splk_cim").html("Ack alert");
      }

      // Define the history search
      var search_cim_tracking =
        '| from datamodel:"' +
        tk_cim_datamodel_name +
        "." +
        tk_cim_datamodel_nodename +
        '"';
      // handle local vs remote searches
      if (tk_account != "local") {
        search_cim_tracking =
          '| splunkremotesearch account="' +
          tk_account +
          '" search="' +
          search_cim_tracking.replace(/\"/g, '\\"') +
          ' | head 10000 | fields *" earliest="-60m" latest="now"';
      }
      // update the href
      search_cim_tracking =
        "search" +
        "?q=" +
        encodeURI(search_cim_tracking) +
        "&earliest=-15m&latest=now";

      // Define the URL target
      document.getElementById("btn_search_cim").href = search_cim_tracking;

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_cim_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_cim_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_cim_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_cim_status_message_class = "status_message_json_red";
      } else {
        tk_object_state_class = "title_grey";
        tk_cim_status_message_class = "status_message_json_grey";
      }

      // sla
      var tk_cim_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_cim_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_cim_sla_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // Dynamically manage buttons states
      var tk_cim_monitored_state_class;
      if (tk_cim_monitored_state == "enabled") {
        document.getElementById("btn_enable_cim").disabled = true;
        document.getElementById("btn_disable_cim").disabled = false;
        tk_cim_monitored_state_class = "title_green";
      } else {
        document.getElementById("btn_enable_cim").disabled = false;
        document.getElementById("btn_disable_cim").disabled = true;
        tk_cim_monitored_state_class = "title_grey";
      }

      // replace info panels
      $("#parent-cim-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for CIM entity: ' +
          tk_object +
          " (alias: " +
          tk_alias +
          ")" +
          "</h1>"
      );

      $("#child-cim-top-info1").html(
        '<h3>monitored state:</b> <span class="' +
          tk_cim_monitored_state_class +
          '">' +
          tk_cim_monitored_state +
          "</span></h3>" +
          '<h3>entity state:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></h3>"
      );

      $("#child-cim-top-info2").html(
        '<h3>latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">'
      );

      $("#child-cim-top-info3").html(
        '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span>" +
          '<h3>location: <span style="color: dodgerblue;">' +
          tk_location +
          "</span></h3>"
      );

      $("#child-cim-top-info4").html(
        '<h3>tracker last runtime: <span style="color: dodgerblue;">' +
          tk_tracker_runtime +
          '<span style="color: dodgerblue;">' +
          '<h3>tracker last duration: <span style="color: dodgerblue;">' +
          tk_tracker_last_duration +
          '<span style="color: dodgerblue;">'
      );

      $("#child-cim-top-docs-tags").html(
        '<h3><span><a id="tags_splk_cim" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-cim-status-message").html(
        '<div class="' +
          tk_cim_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-cim-sla-message").html(
        '<div class="' +
          tk_cim_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // Start searches
      searchHostTableMSplkCim.startSearch();

      // Run
      if (
        getToken("userLevel") === "user" &&
        actionTarget.startsWith("modal_modify_")
      ) {
        $("#modal_user_restricted").modal();
      } else {
        if (actionType === "modal") {
          if (actionTarget === "modal_cmdb_splk_cim") {
            searchCmdbSplkCim.startSearch();
          }
          $("#" + actionTarget).modal();
        } else if (actionType === "click") {
          $("#" + actionTarget).click();
        }
      }
    }

    //
    // splk-dhm
    //

    // disable the bulk edit button
    $("#splk-dhm-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-dhm-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-dhm-table-cancel").prop("disabled", true);

    // splk-dhm tabulator
    function splkDhmHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-dhm-table";

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-dhm-table-mode");

        if (modeView === "minimal") {
          return JSON.stringify(JSON.parse(cell.getValue()), null, 4);
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 4);
        }
      }

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-dhm-table-filter-field");
      var typeEl = document.getElementById("splk-dhm-table-filter-type");
      var valueEl = document.getElementById("splk-dhm-table-filter-value");
      var enabledEl = document.getElementById("splk-dhm-table-filter-enabled");

      // listen for a change
      $("#splk-dhm-table-mode").change(function () {
        table.setData(
          getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
          ),
          {
            tenant_id: getToken("tenant_id"),
            component: getToken("tk_component"),
            mode_view: getValueFromDropdown("splk-dhm-table-mode"),
            pagination_mode: getToken("pagination_mode"),
          }
        );
        //table.replaceData();
      });

      // custom functions

      // standard filters
      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      // specific filters

      function customFilterLatencyTresholdAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
          ]);
        }
      }

      function customFilterDelayTresholdAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "delay_threshold_breached",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "delay_threshold_breached",
            },
          ]);
        }
      }

      function customFilterOutliersAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
          ]);
        }
      }

      function customFilterFuture(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
          ]);
        }
      }

      // free filter

      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("dhm");
        var enteredValue = document.getElementById(
          "splk-dhm-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_blue_state") {
          customFilterBlueState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // specific filters
        } else if (filterVal == "function_lagthreshold_anomaly") {
          customFilterLatencyTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_delaythreshold_anomaly") {
          customFilterDelayTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_outliers_anomaly") {
          customFilterOutliersAnomaly(showDisabled);
        } else if (filterVal == "function_future") {
          customFilterFuture(showDisabled);
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkDhm.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkDhmAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkDhmAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkDhmAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkDhmDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkDhmCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-dhm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkDhmCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-dhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-dhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-dhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-dhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-dhm-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-dhm-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-dhm-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Sourcetype:</h3>";
        contents +=
          "<li><strong>Index(es):</strong> " + data.data_index + "</li>";
        contents +=
          "<li><strong>Sourcetype(s):</strong> " +
          data.data_sourcetype +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>AnomalyReason:</strong> " +
          data.anomaly_reason +
          "</li>";
        contents +=
          "<li><strong>Outliers anomaly detection state:</strong> " +
          data.OutliersStatus +
          "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Delay & Latency:</h3>";
        contents +=
          "<li><strong>Lagging summary:</strong> " + data.lag_summary + "</li>";
        contents +=
          "<li><strong>Last ingest:</strong> " + data.last_ingest + "</li>";
        contents +=
          "<li><strong>Last event:</strong> " + data.last_time + "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Thresholds & Configuration</h3>";
        contents +=
          "<li><strong>Max latency allowed:</strong> " +
          data.data_max_lag_allowed +
          " seconds</li>";
        contents +=
          "<li><strong>Max delay allowed:</strong> " +
          data.data_max_delay_allowed +
          " seconds</li>";
        contents +=
          "<li><strong>Currently under monitoring days:</strong> " +
          data.isUnderMonitoringDays +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring hours:</strong> " +
          data.isUnderMonitoringHours +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // popup formatter
      var rowPopupFormatterSourcetypesDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.splk_dhm_st_summary_full);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Sourcetypes Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_dhm_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          mode_view: getValueFromDropdown("splk-dhm-table-mode"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        index: "keyid",
        layout: "fitDataFill", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkDhmEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_dhm",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkDhmEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_dhm_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkDhmEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_dhm",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                minWidth: getToken("ui_min_object_width"),
                contextPopup: rowPopupFormatter, //add click popup to row
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Indexes and sourcetypes",
            columns: [
              {
                title: "Summary (right click to show full details popup)",
                field: "sourcetype_summary",
                width: 450,
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterSourcetypesDetails,
                variableHeight: true,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            //create column group
            title: "Current statistics and main indexing information",
            columns: [
              {
                title: "lag (delay / latency)",
                field: "lag_summary",
                width: 160,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Latest event",
                field: "last_time",
                width: 140,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Latest ingest",
                field: "last_ingest",
                width: 140,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            //create column group
            title: "Thresholds and features status",
            columns: [
              {
                title: "Delay (sec)",
                field: "data_max_delay_allowed",
                editor: "number",
                editorParams: {
                  min: 0,
                  step: 300,
                  verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
                },
                headerFilter: false,
                width: 125,
              },
              {
                title: "Duration",
                field: "data_max_delay_allowed_duration",
                headerFilter: false,
                width: 110,
              },
              {
                title: "Latency (sec)",
                field: "data_max_lag_allowed",
                editor: "number",
                editorParams: {
                  min: 0,
                  step: 300,
                  verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
                },
                headerFilter: false,
                width: 125,
              },
              {
                title: "Duration",
                field: "data_max_lag_allowed_duration",
                headerFilter: false,
                width: 110,
              },
              {
                title: "Adaptive delay",
                field: "allow_adaptive_delay",
                editor: "list",
                editorParams: { values: ["true", "false"] },
                headerFilter: "input",
                width: 140,
                visible: getToken("adaptive_delay"),
              },
              {
                title: "Class override",
                field: "data_override_lagging_class",
                editor: "list",
                editorParams: { values: ["true", "false"] },
                headerFilter: "input",
                width: 140,
              },
              {
                title: "Alert over",
                field: "data_lag_alert_kpis",
                editor: "list",
                editorParams: {
                  values: ["all_kpis", "lag_event_kpi", "lag_ingestion_kpi"],
                },
                headerFilter: "input",
                width: 140,
              },
              {
                title: "Alerting policy",
                field: "splk_dhm_alerting_policy",
                editor: "list",
                editorParams: {
                  values: [
                    "global_policy",
                    "track_per_sourcetype",
                    "track_per_host",
                  ],
                },
                headerFilter: "input",
                width: 140,
              },
              {
                title: "Outliers",
                field: "OutliersIsOk",
                contextPopup: rowPopupFormatterOutliers, //add click popup to row
                hozAlign: "center",
                formatter: "tickCross",
                width: 100,
                visible: getToken("mloutliers_dhm"),
              },
            ],
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-dhm-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-dhm-table-filter-field").val("keyid");
            $("#splk-dhm-table-filter-type").val("=");
            $("#splk-dhm-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkDhmEntityModal(
                currentData[0],
                "modal_manage_splk_dhm",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-dhm-table-filter-field").val("alias");
              $("#splk-dhm-table-filter-type").val("=");
              $("#splk-dhm-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkDhmEntityModal(
                  currentData[0],
                  "modal_manage_splk_dhm",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-dhm-table-filter-field").val("object");
              $("#splk-dhm-table-filter-type").val("=");
              $("#splk-dhm-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkDhmEntityModal(
                  currentData[0],
                  "modal_manage_splk_dhm",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-dhm-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-dhm-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-dhm-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-dhm-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-dhm-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-dhm-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by index" button
        document
          .getElementById("splk-dhm-table-update-groupby-index")
          .addEventListener("click", function () {
            table.setGroupBy([["data_index"]]);
          });

        // Event listener for "Group by sourcetype" button
        document
          .getElementById("splk-dhm-table-update-groupby-sourcetype")
          .addEventListener("click", function () {
            table.setGroupBy([["data_sourcetype"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-dhm-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-dhm-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-dhm-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-dhm-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=dhm"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-dhm-table-bulk").prop("disabled", false);
          splkDhmPauseRefreshInfo();
        } else {
          $("#splk-dhm-table-bulk").prop("disabled", true);
          document.getElementById("splkDhmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkDhmResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-dhm-table-save").prop("disabled", false);
        $("#splk-dhm-table-cancel").prop("disabled", false);
        splkDhmPauseRefreshInfo();
      });

      // set the timer
      splkDhmRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-dhm-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-dhm-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkDhmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      $("#splk-dhm-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkDhmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-dhm-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkDhmBulkObjs", itemList.toString());
          setToken("splkDhmBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divDhmBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_dhm").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-dhm-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkDhmMain.startSearch();
              // refresh tabulator
              $("#splk-dhm-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-dhm-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-dhm-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkDhmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-dhm-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-dhm-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkDhmBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dhm",
          keys_list: splkDhmBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_dhm_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkDhmBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_dhm_bulk_priority_high")
        .unbind()
        .click(function () {
          splkDhmBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_dhm_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkDhmBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_dhm_bulk_priority_low")
        .unbind()
        .click(function () {
          splkDhmBulkPriority("low");
        });

      // reset: create a function to limit code repetition
      function splkDhmBulkreset() {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_reset"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dhm",
          keys_list: splkDhmBulkIds,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk reset
      $("#btn_splk_dhm_bulk_reset")
        .unbind()
        .click(function () {
          splkDhmBulkreset();
        });

      // priority: create a function to limit code repetition
      function splkDhmBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkObjs = getToken("splkDhmBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_dhm_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_dhm_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_dhm_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_dhm_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-dhm",
            object_list: splkDhmBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-dhm",
            object_list: splkDhmBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // Single function for DHM lag policy updates with parameters
      function splkDhmBulkLagPolicyUpdate(
        fieldName,
        fieldValue,
        successMessage
      ) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkObjs = getToken("splkDhmBulkObjs");
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw//services/trackme/v2/splk_dhm/write/dh_update_lag_policy"
        );

        // Create record with only the specific field being updated
        var record = {
          tenant_id: tk_tenant_id,
          object_list: splkDhmBulkObjs,
          update_comment: tk_comment,
        };

        // Add the specific field to the record
        record[fieldName] = fieldValue;

        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            cssloaderremove();
            searchSplkDhmMain.startSearch();
            $("#splk-dhm-table-refresh-hidden").click();
            notify("success", "bottom", successMessage, "5");
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // Event handlers for DHM individual apply buttons
      $("#btn_splk_dhm_bulk_latency_threshold_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "data_max_lag_allowed",
            $("#btn_splk_dhm_bulk_latency_threshold").val(),
            "Latency threshold updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_delay_threshold_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "data_max_delay_allowed",
            $("#btn_splk_dhm_bulk_delay_threshold").val(),
            "Delay threshold updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_override_lagging_classes_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "data_override_lagging_class",
            $("#btn_splk_dhm_bulk_override_lagging_classes").val(),
            "Override lagging classes updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_allow_adaptive_delay_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "allow_adaptive_delay",
            $("#btn_splk_dhm_bulk_allow_adaptive_delay").val(),
            "Allow adaptive delay updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_alert_over_kpis_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "data_lag_alert_kpis",
            $("#btn_splk_dhm_bulk_alert_over_kpis").val(),
            "Alert over KPIs updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_alerting_policy_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "splk_dhm_alerting_policy",
            $("#btn_splk_dhm_bulk_alerting_policy").val(),
            "Alerting policy updated successfully."
          );
        });

      $("#btn_splk_dhm_bulk_future_tolerance_apply")
        .unbind()
        .click(function () {
          splkDhmBulkLagPolicyUpdate(
            "future_tolerance",
            $("#btn_splk_dhm_bulk_future_tolerance").val(),
            "Future tolerance updated successfully."
          );
        });

      // bulk ack enable
      $("#btn_splk_dhm_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkDhmBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_dhm_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkDhmBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkDhmBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dhm",
          keys_list: splkDhmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_dhm_bulk_enable")
        .unbind()
        .click(function () {
          splkDhmBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_dhm_bulk_disable")
        .unbind()
        .click(function () {
          splkDhmBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkDhmBulkDelete(actionTarget) {
        var splkDhmBulkIds = getToken("splkDhmBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkDhmBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Update
            $("#splk-dhm-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_dhm_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkDhmBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_dhm_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkDhmBulkDelete("permanent");
        });

      // bulk manual tags: create a function to limit code repetition
      function splkDhmBulkManualTags(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/write/dh_update_manual_tags"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-dhm",
          keys_list: splkDhmBulkIds,
          update_comment: tk_comment,
        };

        // Set depending on action
        if (actionTarget == "set_tags") {
          var tk_tags_manual = $("#btn_splk_dhm_bulk_tags_list").tagsinput(
            "items"
          );
        } else if (actionTarget == "clear_tags") {
          var tk_tags_manual = "";
        }

        // update record
        record.tags_manual = tk_tags_manual;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_dhm_bulk_create_manual_tags)
      $("#btn_splk_dhm_bulk_create_manual_tags")
        .unbind()
        .click(function () {
          splkDhmBulkManualTags("set_tags");
        });

      // call (button btn_splk_dhm_bulk_clear_manual_tags)
      $("#btn_splk_dhm_bulk_clear_manual_tags")
        .unbind()
        .click(function () {
          splkDhmBulkManualTags("clear_tags");
        });

      // associate new logical group: create a function to limit code repetition
      function splkDhmBulkAssociateNewLogicalGroup() {
        var splkDhmBulkObjs = getToken("splkDhmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_get", "True");

        // hide this action
        $("#btn_associate_logical_group_add_group_back").hide();
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group_add_group").modal();
      }

      // bulk
      $("#btn_splk_dhm_bulk_associate_new_logical_group")
        .unbind()
        .click(function () {
          splkDhmBulkAssociateNewLogicalGroup();
        });

      // associate existing logical group: create a function to limit code repetition
      function splkDhmBulkAssociateExistingLogicalGroup() {
        var splkDhmBulkObjs = getToken("splkDhmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_add", "True");

        // Start search
        searchLogicalGroupTableAddMember.startSearch();

        // hide this action
        $("#btn_associate_logical_group_add_member_back").hide();

        // Open modal
        $("#logical_group_add_member").modal();
      }

      // bulk
      $("#btn_splk_dhm_bulk_associate_existing_logical_group")
        .unbind()
        .click(function () {
          splkDhmBulkAssociateExistingLogicalGroup();
        });

      // unassociate logical group: create a function to limit code repetition
      function splkDhmBulkUnassociateLogicalGroup() {
        var splkDhmBulkObjs = getToken("splkDhmBulkObjs");

        // Free the search
        setToken("tk_start_logical_member_get", "true");

        // Start the search
        searchLogicalGroupTable.startSearch();

        // this token is expected by the target
        setToken("tk_logical_group_target", splkDhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-dhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // hide this action
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group").modal();
      }

      // bulk
      $("#btn_splk_dhm_bulk_unassociate_logical_group")
        .unbind()
        .click(function () {
          splkDhmBulkUnassociateLogicalGroup();
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkDhmBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "dhm",
          keys_list: splkDhmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_dhm_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkDhmBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_dhm_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkDhmBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_dhm_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkDhmBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_dhm_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkDhmBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_dhm_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkDhmBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkDhmBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkDhmBulkIds = getToken("splkDhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_dhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "dhm",
          keys_list: splkDhmBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkDhmMain.startSearch();
            // refresh tabulator
            $("#splk-dhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metric
      $("#btn_splk_dhm_bulk_outliers_kpi_metric")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_kpi_metric_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_kpi_metric_value"
          ).val();
          // set actionField
          var actionField = "kpi_metric";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_dhm_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_dhm_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_dhm_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_dhm_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_dhm_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_dhm_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_dhm_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_dhm_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_dhm_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_dhm_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_dhm_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_dhm_bulk_outliers_custom_key
          var actionField = $("#btn_splk_dhm_bulk_outliers_custom_key").val();
          splkDhmBulkOutliersRules(actionField, actionValue);
        });

      //
      // end
      //
    }

    // splk-dhm get table
    function getSplkDhmTable() {
      // avoid causing double interval
      clearInterval(splkDhmIntervalId);
      // get data
      splkDhmHandlerTable();
    }

    // splk-dhm refresh timer
    var splkDhmIntervalId;

    function splkDhmRefreshInfo() {
      var myDate = new Date();
      var splkDhmLastRefresh = document.getElementById("splkDhmLastRefresh");
      function updateTime() {
        splkDhmLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkDhmIntervalId = setInterval(updateTime, 2000);
    }

    function splkDhmResetRefreshInfo() {
      clearInterval(splkDhmIntervalId);
      // release our intervalID from the variable
      splkDhmIntervalId = null;
      splkDhmRefreshInfo();
    }

    function splkDhmPauseRefreshInfo() {
      clearInterval(splkDhmIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkDhmIntervalId = null;
      tableRefreshIntervalId = null;
      splkDhmLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkDhmResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-dhm-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-dhm modal entity view

    function showSplkDhmEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);

      // Get tenant and manage replica
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      // get entity details
      var tk_splk_dhm = jsonData["object"];
      var tk_alias = jsonData["alias"];
      var tk_object = tk_splk_dhm;
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];
      var tk_object_state = jsonData["object_state"];
      var tk_data_monitored_state = jsonData["monitored_state"];
      var tk_data_lag_summary = jsonData["lag_summary"];
      var tk_data_last_ingest_human = jsonData["last_ingest"];
      var tk_data_last_time_seen_human = jsonData["last_time"];
      var tk_data_max_lag_allowed = jsonData["data_max_lag_allowed"];
      var tk_data_max_lag_allowed_duration =
        jsonData["data_max_lag_allowed_duration"];
      var tk_data_max_delay_allowed = jsonData["data_max_delay_allowed"];
      var tk_data_max_delay_allowed_duration =
        jsonData["data_max_delay_allowed_duration"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];
      // token required for auto lagging
      setToken("tk_data_max_lag_allowed", tk_data_max_lag_allowed);
      setToken("tk_data_max_delay_allowed", tk_data_max_delay_allowed);
      var tk_data_override_lagging_class =
        jsonData["data_override_lagging_class"];
      // required for auto lagging
      setToken(
        "tk_data_override_lagging_class",
        tk_data_override_lagging_class
      );

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_dhm_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_dhm_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_dhm_set_threshold_value"
        ).value = "";
      }

      // wdays - hours_range
      var monitoring_wdays = jsonData["data_monitoring_wdays"];
      setToken("form.tk_input_wdays_host", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["data_monitoring_hours_ranges"];
      setToken("$form.tk_input_splk_dhm_hours_ranges", monitoring_hours_ranges);

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divDhmOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divDhmOutliersSimulationInfo").css("display", "none");
        $("#divDhmOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_dhm_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_dhm_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divDhmOutliersInfo").css("display", "inherit");
        $("#child-dhm-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divDhmOutliersSimulationInfo").css("display", "inherit");
        $("#divDhmOutliersSimulationRender").css("display", "none");
        $("#child-dhm-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_dhm_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_dhm_save").prop("disabled", true);
      }

      // required for various purposes
      setToken("tk_keyid", tk_keyid);
      setToken("tk_splk_dhm", tk_splk_dhm);
      setToken("tk_object", tk_object);
      setToken("tk_object_category", tk_object_category);

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage buttons states
      if (tk_data_monitored_state == "enabled") {
        document.getElementById("btn_enable_monitoring_host").disabled = true;
        document.getElementById("btn_disable_monitoring_host").disabled = false;
        // show/hide accordingly
        document.getElementById("btn_enable_monitoring_host").style.display =
          "inherit";
        document.getElementById("btn_disable_monitoring_host").style.display =
          "none";
        tk_data_monitored_state_class = "title_green";
      } else {
        document.getElementById("btn_enable_monitoring_host").disabled = false;
        document.getElementById("btn_disable_monitoring_host").disabled = true;
        // show/hide accordingly
        document.getElementById("btn_enable_monitoring_host").style.display =
          "none";
        document.getElementById("btn_disable_monitoring_host").style.display =
          "inherit";
        tk_data_monitored_state_class = "title_grey";
      }

      // Dynamically manage state color
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_dhm_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_dhm_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_dhm_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_dhm_status_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // sla
      var tk_splk_dhm_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_dhm_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_dhm_sla_message_class = "status_message_json_red";
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_dhm").disabled = false;
        $("#btn_ack_splk_dhm").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_dhm").disabled = false;
        $("#btn_ack_splk_dhm").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_dhm").disabled = false;
        $("#btn_ack_splk_dhm").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_dhm").disabled = true;
        $("#btn_ack_splk_dhm").html("Ack alert");
      }

      // replace info panels
      $("#parent-data-host-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_splk_dhm) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-data-host-top-info1").html(
        '<h3>Delay event / latency ingestion: ([D+]HH:MM:SS) <span style="color: dodgerblue;">' +
          tk_data_lag_summary +
          '<span style="color: dodgerblue;">' +
          '<h3>Last time seen: <span style="color: dodgerblue;">' +
          tk_data_last_time_seen_human +
          '<span style="color: dodgerblue;">' +
          '<h3>Last ingest: <span style="color: dodgerblue;">' +
          tk_data_last_ingest_human +
          '<span style="color: dodgerblue;">'
      );

      $("#child-data-host-top-info2").html(
        '<h3>Threshold lag ingestion / delay: <span style="color: dodgerblue;">' +
          tk_data_max_lag_allowed +
          " sec (" +
          tk_data_max_lag_allowed_duration +
          ") / " +
          tk_data_max_delay_allowed +
          " sec (" +
          tk_data_max_delay_allowed_duration +
          ")" +
          '<span style="color: dodgerblue;">' +
          '<h3>Monitored state:</b> <span class="' +
          tk_data_monitored_state_class +
          '">' +
          tk_data_monitored_state +
          "</span></h3>" +
          '<h3>State:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></p>"
      );

      $("#child-data-host-top-info3").html(
        '<h3>Latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>Latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">' +
          '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></p>"
      );

      $("#child-splk-dhm-top-docs-tags").html(
        '<h3><span><a id="tags_splk_dhm" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-data-host-status-message").html(
        '<div class="' +
          tk_splk_dhm_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-data-host-sla-message").html(
        '<div class="' +
          tk_splk_dhm_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // pre-fill current lagging input
      setToken("form.tk_input_lag_host", jsonData["data_max_lag_allowed"]);

      // pre-fill current delay input
      setToken("form.tk_input_delay_host", jsonData["data_max_delay_allowed"]);

      // pre-fill future tolerance
      setToken(
        "form.tk_input_future_tolerance_host",
        jsonData["future_tolerance"]
      );

      // pre-fill current wdays input
      setToken("form.tk_input_wdays_host", jsonData["data_monitoring_wdays"]);

      // pre-fill current hours ranges
      setToken(
        "form.tk_input_splk_dhm_hours_ranges",
        jsonData["data_monitoring_hours_ranges"]
      );

      // pre-fill current priority
      setToken("form.tk_input_host_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkDhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkDhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkDhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkDhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkDhm").html("");
      }

      // pre-fill lagging class override
      setToken(
        "form.modal_input_lag_override_class_host",
        jsonData["data_override_lagging_class"]
      );

      // pre-fill allow_adaptive_delay
      setToken(
        "form.modal_input_allow_adaptive_delay_host",
        jsonData["allow_adaptive_delay"]
      );
      // if getToken("adaptive_delay") == 0, set the div id modal_input_allow_adaptive_delay_host display to none
      if (getToken("adaptive_delay") == 0) {
        document.getElementById(
          "modal_input_allow_adaptive_delay_host"
        ).style.display = "none";
      }

      // pre-fill alert over kpis
      setToken(
        "form.tk_input_data_lag_alert_kpis_host",
        jsonData["data_lag_alert_kpis"]
      );

      // pre-fill alerting policy
      setToken(
        "form.tk_input_host_alerting_policy",
        jsonData["splk_dhm_alerting_policy"]
      );

      // pre-fill per host blocklists
      setDhmBlocklistItemsFromCSV(jsonData["host_idx_blocklists"], "index");
      setDhmBlocklistItemsFromCSV(jsonData["host_st_blocklists"], "sourcetype");

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // Retrieve entity info from REST and set actions
      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dhm/dh_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();

          // get from the json response

          // Set some tokens first
          var splk_dhm_raw_search = returneddata["splk_dhm_raw_search"];

          // get the selected data provider
          var splk_dhm_data_provider = getToken(
            "tk_input_splk_dhm_overview_data_provider"
          );

          // get
          var splk_dhm_overview_trackme_single_stats =
            returneddata["splk_dhm_overview_trackme_single_stats"];
          setToken(
            "tk_splk_dhm_overview_trackme_single_stats",
            splk_dhm_overview_trackme_single_stats
          );

          var splk_dhm_overview_trackme_pie_root_search =
            returneddata["splk_dhm_overview_trackme_pie_root_search"];
          setToken(
            "tk_splk_dhm_overview_trackme_pie_root_search",
            splk_dhm_overview_trackme_pie_root_search
          );

          var splk_dhm_overview_trackme_timechart =
            returneddata["splk_dhm_overview_trackme_timechart"];
          setToken(
            "tk_splk_dhm_overview_trackme_timechart",
            splk_dhm_overview_trackme_timechart
          );

          var splk_dhm_overview_splunk_pie_root_search =
            returneddata["splk_dhm_overview_splunk_pie_root_search"];
          setToken(
            "tk_splk_dhm_overview_splunk_pie_root_search",
            splk_dhm_overview_splunk_pie_root_search
          );

          var splk_dhm_overview_splunk_timechart =
            returneddata["splk_dhm_overview_splunk_timechart"];
          setToken(
            "tk_splk_dhm_overview_splunk_timechart",
            splk_dhm_overview_splunk_timechart
          );

          var splk_dhm_overview_splunk_single_stats =
            returneddata["splk_dhm_overview_splunk_single_stats"];
          setToken(
            "tk_splk_dhm_overview_splunk_single_stats",
            splk_dhm_overview_splunk_single_stats
          );

          // set searches dynamically
          if (splk_dhm_data_provider === "trackme") {
            setToken(
              "tk_splk_dhm_overview_single_stats",
              splk_dhm_overview_trackme_single_stats
            );
            setToken(
              "tk_splk_dhm_overview_pie_root_search",
              splk_dhm_overview_trackme_pie_root_search
            );
            setToken(
              "tk_splk_dhm_overview_timechart",
              splk_dhm_overview_trackme_timechart
            );
          } else if (splk_dhm_data_provider === "splunk") {
            setToken(
              "tk_splk_dhm_overview_single_stats",
              splk_dhm_overview_splunk_single_stats
            );
            setToken(
              "tk_splk_dhm_overview_pie_root_search",
              splk_dhm_overview_splunk_pie_root_search
            );
            setToken(
              "tk_splk_dhm_overview_timechart",
              splk_dhm_overview_splunk_timechart
            );
          } else {
            setToken(
              "tk_splk_dhm_overview_single_stats",
              splk_dhm_overview_trackme_single_stats
            );
            setToken(
              "tk_splk_dhm_overview_pie_root_search",
              splk_dhm_overview_trackme_pie_root_search
            );
            setToken(
              "tk_splk_dhm_overview_timechart",
              splk_dhm_overview_trackme_timechart
            );
          }

          // required if an indexed constraint is set the Virtual Tenant level
          var indexed_constraint = getToken("indexed_constraint");

          // if indexed_constraints is set (non empty), add it to the search
          if (indexed_constraint) {
            splk_dhm_raw_search =
              splk_dhm_raw_search.trim() + " " + indexed_constraint;
          }

          // Define the URL target
          document.getElementById("btn_search_splk_dhm").href =
            splk_dhm_raw_search;
          // token is required for dynamic override
          setToken("tk_splk_dhm_raw_search", splk_dhm_raw_search);
          // Run
          if (
            getToken("userLevel") === "user" &&
            actionTarget.startsWith("modal_modify_")
          ) {
            $("#modal_user_restricted").modal();
          } else {
            if (actionType === "modal") {
              if (actionTarget === "modal_cmdb_splk_dhm") {
                searchCmdbSplkDhm.startSearch();
              }
              $("#" + actionTarget).modal();
            } else if (actionType === "click") {
              $("#" + actionTarget).click();
            }
          }
          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });
    }

    //
    // splk-mhm
    //

    // disable the bulk edit button
    $("#splk-mhm-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-mhm-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-mhm-table-cancel").prop("disabled", true);

    // splk-mhm tabulator
    function splkMhmHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-mhm-table";

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-mhm-table-mode");

        if (modeView === "minimal") {
          return JSON.stringify(JSON.parse(cell.getValue()), null, 4);
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 4);
        }
      }

      function csvFormatter(cell, formatterParams, onRendered) {
        cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
        obj = cell.getValue().toString().split(",");
        return JSON.stringify(obj, null, 1); //return JSON formatted cell
      }

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-mhm-table-filter-field");
      var typeEl = document.getElementById("splk-mhm-table-filter-type");
      var valueEl = document.getElementById("splk-mhm-table-filter-value");
      var enabledEl = document.getElementById("splk-mhm-table-filter-enabled");

      // listen for a change
      $("#splk-mhm-table-mode").change(function () {
        table.setData(
          getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
          ),
          {
            tenant_id: getToken("tenant_id"),
            component: getToken("tk_component"),
            mode_view: getValueFromDropdown("splk-mhm-table-mode"),
            pagination_mode: getToken("pagination_mode"),
          }
        );
      });

      // custom functions

      // Standard filters
      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      // specific filters

      function customFilterLatencyTresholdAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "lag_threshold_breached",
            },
          ]);
        }
      }

      function customFilterFuture(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "future_over_tolerance",
            },
          ]);
        }
      }

      // free filter
      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("mhm");
        var enteredValue = document.getElementById(
          "splk-mhm-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_blue_state") {
          customFilterBlueState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // specific filters
        } else if (filterVal == "function_lagthreshold_anomaly") {
          customFilterLatencyTresholdAnomaly(showDisabled);
        } else if (filterVal == "function_future") {
          customFilterFuture(showDisabled);
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkMhm.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkMhmAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkMhmAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkMhmAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkMhmDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkMhmCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-mhm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkMhmCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-mhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-mhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-mhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-mhm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-mhm-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-mhm-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-mhm-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Splunk Index & Metrics:</h3>";
        contents +=
          "<li><strong>Index(es):</strong> " +
          JSON.stringify(data.metric_index.toString().split(","), null, 1) +
          "</li>";
        contents +=
          "<li><strong>Metric categorie(s):</strong> " +
          JSON.stringify(data.metric_category.toString().split(","), null, 1) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<li><strong>Lagging summary:</strong> " + data.lag_summary + "</li>";
        contents +=
          "<li><strong>Last metric:</strong> " + data.last_time + "</li>";
        contents +=
          "<li><strong>Currently under monitoring days:</strong> " +
          data.isUnderMonitoringDays +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring hours:</strong> " +
          data.isUnderMonitoringHours +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // popup formatter
      var rowPopupFormatterMetricsDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.metric_details_full);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Metrics Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_mhm_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        //progressiveLoad:"load", //enable progressive loading
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          mode_view: getValueFromDropdown("splk-mhm-table-mode"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        index: "keyid",
        layout: "fitColumns", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkMhmEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_mhm",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkMhmEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_mhm_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkMhmEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_mhm",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                contextPopup: rowPopupFormatter, //add click popup to row
                minWidth: getToken("ui_min_object_width"),
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Indexes and metric details",
            columns: [
              {
                title: "Index(es)",
                field: "metric_index",
                width: 160,
                formatter: csvFormatter,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Summary (right click to show full details popup)",
                field: "metric_details",
                width: 650,
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterMetricsDetails,
                variableHeight: true,
                editor: false,
                headerFilter: false,
              },
            ],
          },
          {
            //create column group
            title: "Current stats and main indexing info",
            columns: [
              {
                title: "Metric lag",
                field: "lag_summary",
                width: 160,
                editor: false,
                headerFilter: false,
              },
              {
                title: "Metric latest",
                field: "last_time",
                width: 160,
                editor: false,
                headerFilter: false,
              },
            ],
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-mhm-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-mhm-table-filter-field").val("keyid");
            $("#splk-mhm-table-filter-type").val("=");
            $("#splk-mhm-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkMhmEntityModal(
                currentData[0],
                "modal_manage_splk_mhm",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-mhm-table-filter-field").val("alias");
              $("#splk-mhm-table-filter-type").val("=");
              $("#splk-mhm-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkMhmEntityModal(
                  currentData[0],
                  "modal_manage_splk_mhm",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-mhm-table-filter-field").val("object");
              $("#splk-mhm-table-filter-type").val("=");
              $("#splk-mhm-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkMhmEntityModal(
                  currentData[0],
                  "modal_manage_splk_mhm",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-mhm-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-mhm-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-mhm-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-mhm-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-mhm-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-mhm-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by index" button
        document
          .getElementById("splk-mhm-table-update-groupby-index")
          .addEventListener("click", function () {
            table.setGroupBy([["metric_index"]]);
          });

        // Event listener for "Group by metric category" button
        document
          .getElementById("splk-mhm-table-update-groupby-metric-category")
          .addEventListener("click", function () {
            table.setGroupBy([["metric_category"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-mhm-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-mhm-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-mhm-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-mhm-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=mhm"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-mhm-table-bulk").prop("disabled", false);
          splkMhmPauseRefreshInfo();
        } else {
          $("#splk-mhm-table-bulk").prop("disabled", true);
          document.getElementById("splkMhmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkMhmResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-mhm-table-save").prop("disabled", false);
        $("#splk-mhm-table-cancel").prop("disabled", false);
        splkMhmPauseRefreshInfo();
      });

      // set the timer
      splkMhmRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-mhm-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-mhm-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkMhmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // auto hidden refresh
      $("#splk-mhm-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkMhmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-mhm-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkMhmBulkObjs", itemList.toString());
          setToken("splkMhmBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divMhmBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_mhm").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-mhm-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkMhmMain.startSearch();
              // refresh tabulator
              $("#splk-mhm-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-mhm-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-mhm-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkMhmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-mhm-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-mhm-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkMhmBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkMhmBulkIds = getToken("splkMhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-mhm",
          keys_list: splkMhmBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
            // refresh tabulator
            $("#splk-mhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_mhm_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkMhmBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_mhm_bulk_priority_high")
        .unbind()
        .click(function () {
          splkMhmBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_mhm_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkMhmBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_mhm_bulk_priority_low")
        .unbind()
        .click(function () {
          splkMhmBulkPriority("low");
        });

      // reset: create a function to limit code repetition
      function splkMhmBulkreset() {
        var tk_tenant_id = getToken("tenant_id");
        var splkMhmBulkIds = getToken("splkMhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_reset"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-mhm",
          keys_list: splkMhmBulkIds,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
            // refresh tabulator
            $("#splk-mhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk reset
      $("#btn_splk_mhm_bulk_reset")
        .unbind()
        .click(function () {
          splkMhmBulkreset();
        });

      // priority: create a function to limit code repetition
      function splkMhmBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkMhmBulkObjs = getToken("splkMhmBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_mhm_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_mhm_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_mhm_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_mhm_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-mhm",
            object_list: splkMhmBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-mhm",
            object_list: splkMhmBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
            // refresh tabulator
            $("#splk-mhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk ack enable
      $("#btn_splk_mhm_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkMhmBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_mhm_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkMhmBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkMhmBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkMhmBulkIds = getToken("splkMhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-mhm",
          keys_list: splkMhmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
            // refresh tabulator
            $("#splk-mhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_mhm_bulk_enable")
        .unbind()
        .click(function () {
          splkMhmBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_mhm_bulk_disable")
        .unbind()
        .click(function () {
          splkMhmBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkMhmBulkDelete(actionTarget) {
        var splkMhmBulkIds = getToken("splkMhmBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkMhmBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Update
            $("#splk-mhm-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_mhm_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkMhmBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_mhm_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkMhmBulkDelete("permanent");
        });

      // bulk manual tags: create a function to limit code repetition
      function splkMhmBulkManualTags(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkMhmBulkIds = getToken("splkMhmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/write/mh_update_manual_tags"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-mhm",
          keys_list: splkMhmBulkIds,
          update_comment: tk_comment,
        };

        // Set depending on action
        if (actionTarget == "set_tags") {
          var tk_tags_manual = $("#btn_splk_mhm_bulk_tags_list").tagsinput(
            "items"
          );
        } else if (actionTarget == "clear_tags") {
          var tk_tags_manual = "";
        }

        // update record
        record.tags_manual = tk_tags_manual;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkMhmMain.startSearch();
            // refresh tabulator
            $("#splk-mhm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_mhm_bulk_create_manual_tags)
      $("#btn_splk_mhm_bulk_create_manual_tags")
        .unbind()
        .click(function () {
          splkMhmBulkManualTags("set_tags");
        });

      // call (button btn_splk_mhm_bulk_clear_manual_tags)
      $("#btn_splk_mhm_bulk_clear_manual_tags")
        .unbind()
        .click(function () {
          splkMhmBulkManualTags("clear_tags");
        });

      // associate new logical group: create a function to limit code repetition
      function splkMhmBulkAssociateNewLogicalGroup() {
        var splkMhmBulkObjs = getToken("splkMhmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkMhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-mhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_get", "True");

        // hide this action
        $("#btn_associate_logical_group_add_group_back").hide();
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group_add_group").modal();
      }

      // bulk
      $("#btn_splk_mhm_bulk_associate_new_logical_group")
        .unbind()
        .click(function () {
          splkMhmBulkAssociateNewLogicalGroup();
        });

      // associate existing logical group: create a function to limit code repetition
      function splkMhmBulkAssociateExistingLogicalGroup() {
        var splkMhmBulkObjs = getToken("splkMhmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkMhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-mhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_add", "True");

        // Start search
        searchLogicalGroupTableAddMember.startSearch();

        // hide this action
        $("#btn_associate_logical_group_add_member_back").hide();

        // Open modal
        $("#logical_group_add_member").modal();
      }

      // bulk
      $("#btn_splk_mhm_bulk_associate_existing_logical_group")
        .unbind()
        .click(function () {
          splkMhmBulkAssociateExistingLogicalGroup();
        });

      // unassociate logical group: create a function to limit code repetition
      function splkMhmBulkUnassociateLogicalGroup() {
        var splkMhmBulkObjs = getToken("splkMhmBulkObjs");

        // Free the search
        setToken("tk_start_logical_member_get", "true");

        // Start the search
        searchLogicalGroupTable.startSearch();

        // this token is expected by the target
        setToken("tk_logical_group_target", splkMhmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-mhm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_mhm_bulk_comment");

        // hide this action
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group").modal();
      }

      // bulk
      $("#btn_splk_mhm_bulk_unassociate_logical_group")
        .unbind()
        .click(function () {
          splkMhmBulkUnassociateLogicalGroup();
        });

      //
      // end
      //
    }

    // splk-mhm get table
    function getSplkMhmTable() {
      var tk_tenant_id = getToken("tenant_id");
      // avoid causing double interval
      clearInterval(splkMhmIntervalId);
      // get viz mode
      var modeView = getValueFromDropdown("splk-mhm-table-mode");
      // get data
      splkMhmHandlerTable(
        getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/mh_get_table"
        ),
        "POST",
        { tenant_id: tk_tenant_id, mode: modeView, key_id: "*" }
      );
    }

    // splk-mhm refresh timer
    var splkMhmIntervalId;

    function splkMhmRefreshInfo() {
      var myDate = new Date();
      var splkMhmLastRefresh = document.getElementById("splkMhmLastRefresh");
      function updateTime() {
        splkMhmLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkMhmIntervalId = setInterval(updateTime, 2000);
    }

    function splkMhmResetRefreshInfo() {
      clearInterval(splkMhmIntervalId);
      // release our intervalID from the variable
      splkMhmIntervalId = null;
      splkMhmRefreshInfo();
    }

    function splkMhmPauseRefreshInfo() {
      clearInterval(splkMhmIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkMhmIntervalId = null;
      tableRefreshIntervalId = null;
      splkMhmLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkMhmResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-mhm-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-mhm modal entity view

    function showSplkMhmEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      // get tenant_id
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];
      // get entity details
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      var tk_splk_mhm = jsonData["object"];
      setToken("tk_splk_mhm", tk_splk_mhm);
      var tk_object = tk_splk_mhm;
      var tk_alias = jsonData["alias"];
      // token is required
      setToken("tk_object", tk_object);
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];
      var tk_object_state = jsonData["object_state"];
      var tk_metric_monitored_state = jsonData["monitored_state"];
      var tk_metric_last_time_seen_human = jsonData["last_time"];
      var tk_metric_last_lag_seen = jsonData["last_lag_seen"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_mhm_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_mhm_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_mhm_set_threshold_value"
        ).value = "";
      }

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // pre-fill current priority
      setToken("form.tk_input_splk_mhm_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkMhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkMhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkMhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkMhm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkMhm").html("");
      }

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      // get entity info
      // Retrieve entity info from REST and set actions
      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_mhm/mh_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();
          // get from the json response
          document.getElementById("btn_search_splk_mhm").href =
            returneddata["splk_mhm_mctalog_search"];
          //
          document.getElementById("btn_mpreview_splk_mhm").href =
            returneddata["splk_mhn_mpreview"];
          //
          document.getElementById("btn_search_splk_mhm_live_report").href =
            returneddata["splk_mhn_metrics_report"];
          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage buttons states
      var tk_metric_monitored_state_class;
      if (tk_metric_monitored_state == "enabled") {
        document.getElementById(
          "btn_enable_monitoring_splk_mhm"
        ).disabled = true;
        document.getElementById(
          "btn_disable_monitoring_splk_mhm"
        ).disabled = false;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_mhm"
        ).style.display = "none";
        document.getElementById(
          "btn_disable_monitoring_splk_mhm"
        ).style.display = "inherit";
        tk_metric_monitored_state_class = "title_green";
      } else {
        document.getElementById(
          "btn_enable_monitoring_splk_mhm"
        ).disabled = false;
        document.getElementById(
          "btn_disable_monitoring_splk_mhm"
        ).disabled = true;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_mhm"
        ).style.display = "inherit";
        document.getElementById(
          "btn_disable_monitoring_splk_mhm"
        ).style.display = "none";
        tk_metric_monitored_state_class = "title_grey";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_mhm_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_mhm_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_mhm_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_mhm_status_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // sla
      var tk_splk_mhm_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_mhm_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_mhm_sla_message_class = "status_message_json_red";
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_mhm").disabled = false;
        $("#btn_ack_splk_mhm").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_mhm").disabled = false;
        $("#btn_ack_splk_mhm").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_mhm").disabled = false;
        $("#btn_ack_splk_mhm").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_mhm").disabled = true;
        $("#btn_ack_splk_mhm").html("Ack alert");
      }

      // replace info panels
      $("#parent-metric-host-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_splk_mhm) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-metric-host-top-info1").html(
        '<h3>last lag seen: <span style="color: dodgerblue;">' +
          tk_metric_last_lag_seen +
          '<span style="color: dodgerblue;">' +
          '<h3>last time seen: <span style="color: dodgerblue;">' +
          tk_metric_last_time_seen_human +
          '<span style="color: dodgerblue;">'
      );

      $("#child-metric-host-top-info2").html(
        '<h3>monitored state:</b> <span class="' +
          tk_metric_monitored_state_class +
          '">' +
          tk_metric_monitored_state +
          "</span></h3>" +
          '<h3>entity state:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></h3>"
      );

      $("#child-metric-host-top-info3").html(
        '<h3>latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">'
      );

      $("#child-metric-host-top-info4").html(
        '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></p>"
      );

      $("#child-splk-mhm-top-docs-tags").html(
        '<h3><span><a id="tags_splk_mhm" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-metric-host-status-message").html(
        '<div class="' +
          tk_splk_mhm_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-metric-host-sla-message").html(
        '<div class="' +
          tk_splk_mhm_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // Run
      if (
        getToken("userLevel") === "user" &&
        actionTarget.startsWith("modal_modify_")
      ) {
        $("#modal_user_restricted").modal();
      } else {
        if (actionType === "modal") {
          if (actionTarget === "modal_cmdb_splk_mhm") {
            searchCmdbSplkMhm.startSearch();
          }
          $("#" + actionTarget).modal();
        } else if (actionType === "click") {
          $("#" + actionTarget).click();
        }
      }
    }

    //
    // splk-flx
    //

    // disable the bulk edit button
    $("#splk-flx-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-flx-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-flx-table-cancel").prop("disabled", true);

    // splk-flx tabulator
    function splkFlxHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-flx-table";

      // get tenant level preference
      var ui_expand_metrics = getToken("ui_expand_metrics");
      if (ui_expand_metrics == 1) {
        var fieldEl = document.getElementById("splk-flx-table-mode");
        fieldEl.value = "full";
      }

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-flx-table-mode");
        if (modeView === "minimal") {
          return "right click for popup";
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 1).replace(
            /\\/g,
            ""
          ); //return JSON formatted cell
        }
      }

      // popup formatter
      var rowPopupFormatterStatusDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.status_message_json);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Status Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // popup formatter
      var rowPopupFormatterMetricsDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.metrics);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Metrics Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-flx-table-filter-field");
      var typeEl = document.getElementById("splk-flx-table-filter-type");
      var valueEl = document.getElementById("splk-flx-table-filter-value");
      var enabledEl = document.getElementById("splk-flx-table-filter-enabled");

      // listen for a change
      $("#splk-flx-table-mode").change(function () {
        var newmodeView = document.getElementById("splk-flx-table-mode").value;
        table.replaceData(resultCall);
      });

      // custom functions

      // standard filters

      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("flx");
        var enteredValue = document.getElementById(
          "splk-flx-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_blue_state") {
          customFilterBlueState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkFlx.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkFlxAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkFlxAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkFlxAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkFlxDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkFlxCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-flx-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkFlxCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-flx-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-flx-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-flx-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-flx-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-flx-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-flx-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-flx-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Object description:</strong> " +
          data.object_description +
          "</li>";
        contents += "<li><strong>Status:</strong> " + data.status + "</li>";
        contents +=
          "<li><strong>Status description:</strong> " +
          data.status_description +
          "</li>";
        contents +=
          "<li><strong>AnomalyReason:</strong> " +
          data.anomaly_reason +
          "</li>";
        contents +=
          "<li><strong>Outliers anomaly detection state:</strong> " +
          data.OutliersStatus +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring days:</strong> " +
          data.isUnderMonitoringDays +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring hours:</strong> " +
          data.isUnderMonitoringHours +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_flx_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        //progressiveLoad:"load", //enable progressive loading
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        reactiveData: true,
        index: "_key",
        layout: "fitColumns", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkFlxEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_flx",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkFlxEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_flx_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkFlxEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_flx",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "group",
                field: "group",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                contextPopup: rowPopupFormatter, //add click popup to row
                minWidth: getToken("ui_min_object_width"),
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Status description (right click: info)",
            columns: [
              {
                title: "Status",
                field: "status",
                width: 80,
                editor: false,
                headerFilter: true,
                visible: false,
              },
              {
                title: "Status description",
                field: "status_description_short",
                contextPopup: rowPopupFormatterStatusDetails, //add click popup to row
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Metrics",
            columns: [
              {
                title: "Last metrics",
                field: "metrics",
                width: 200,
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterMetricsDetails,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Tracking information",
            columns: [
              {
                title: "Tracker runtime",
                field: "tracker_runtime (translated)",
                width: 150,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            title: "Outliers",
            field: "OutliersIsOk",
            contextPopup: rowPopupFormatterOutliers, //add click popup to row
            hozAlign: "center",
            formatter: "tickCross",
            width: 100,
            visible: getToken("mloutliers_flx"),
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-flx-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-flx-table-filter-field").val("keyid");
            $("#splk-flx-table-filter-type").val("=");
            $("#splk-flx-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkFlxEntityModal(
                currentData[0],
                "modal_manage_splk_flx",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-flx-table-filter-field").val("alias");
              $("#splk-flx-table-filter-type").val("=");
              $("#splk-flx-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkFlxEntityModal(
                  currentData[0],
                  "modal_manage_splk_flx",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-flx-table-filter-field").val("object");
              $("#splk-flx-table-filter-type").val("=");
              $("#splk-flx-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkFlxEntityModal(
                  currentData[0],
                  "modal_manage_splk_flx",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-flx-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-flx-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-flx-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-flx-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-flx-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by priority" button
        document
          .getElementById("splk-flx-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-flx-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-flx-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-flx-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-flx-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=flx"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-flx-table-bulk").prop("disabled", false);
          splkFlxPauseRefreshInfo();
        } else {
          $("#splk-flx-table-bulk").prop("disabled", true);
          document.getElementById("splkFlxLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkFlxResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-flx-table-save").prop("disabled", false);
        $("#splk-flx-table-cancel").prop("disabled", false);
        splkFlxPauseRefreshInfo();
      });

      // set the timer
      splkFlxRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-flx-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-flx-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkFlxResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // auto hidden refresh
      $("#splk-flx-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkFlxResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-flx-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkFlxBulkObjs", itemList.toString());
          setToken("splkFlxBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divFlxBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_flx").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-flx-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkFlxMain.startSearch();
              // refresh tabulator
              $("#splk-flx-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-flx-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-flx-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkFlxLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-flx-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-flx-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkFlxBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-flx",
          keys_list: splkFlxBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_flx_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkFlxBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_flx_bulk_priority_high")
        .unbind()
        .click(function () {
          splkFlxBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_flx_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkFlxBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_flx_bulk_priority_low")
        .unbind()
        .click(function () {
          splkFlxBulkPriority("low");
        });

      // priority: create a function to limit code repetition
      function splkFlxBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkObjs = getToken("splkFlxBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_flx_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_flx_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_flx_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_flx_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-flx",
            object_list: splkFlxBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-flx",
            object_list: splkFlxBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloaderremove();

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk ack enable
      $("#btn_splk_flx_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkFlxBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_flx_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkFlxBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkFlxBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-flx",
          keys_list: splkFlxBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_flx_bulk_enable")
        .unbind()
        .click(function () {
          splkFlxBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_flx_bulk_disable")
        .unbind()
        .click(function () {
          splkFlxBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkFlxBulkDelete(actionTarget) {
        var splkFlxBulkIds = getToken("splkFlxBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkFlxBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Update
            $("#splk-flx-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_flx_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkFlxBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_flx_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkFlxBulkDelete("permanent");
        });

      // Thresholds bulk update: create a function to limit code repetition
      function splkFlxBulkThresholds(actionRecord) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_thresholds_update_bulk"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "flx",
          keys_list: splkFlxBulkIds,
          record_changes: actionRecord,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_flx_bulk_thresholds)
      $("#btn_splk_flx_bulk_thresholds")
        .unbind()
        .click(function () {
          // set the record_changes
          var record_changes = {
            kpi_metric_name: $(
              "#btn_splk_flx_bulk_thresholds_kpi_metric_name"
            ).val(),
            kpi_metric_value: $(
              "#btn_splk_flx_bulk_thresholds_kpi_metric_value"
            ).val(),
            operator: $("#btn_splk_flx_bulk_thresholds_operator").val(),
            condition_true: $(
              "#btn_splk_flx_bulk_thresholds_condition_true"
            ).val(),
          };
          splkFlxBulkThresholds(record_changes);
        });

      // bulk manual tags: create a function to limit code repetition
      function splkFlxBulkManualTags(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/write/flx_update_manual_tags"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-flx",
          keys_list: splkFlxBulkIds,
          update_comment: tk_comment,
        };

        // Set depending on action
        if (actionTarget == "set_tags") {
          var tk_tags_manual = $("#btn_splk_flx_bulk_tags_list").tagsinput(
            "items"
          );
        } else if (actionTarget == "clear_tags") {
          var tk_tags_manual = "";
        }

        // update record
        record.tags_manual = tk_tags_manual;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_flx_bulk_create_manual_tags)
      $("#btn_splk_flx_bulk_create_manual_tags")
        .unbind()
        .click(function () {
          splkFlxBulkManualTags("set_tags");
        });

      // call (button btn_splk_flx_bulk_clear_manual_tags)
      $("#btn_splk_flx_bulk_clear_manual_tags")
        .unbind()
        .click(function () {
          splkFlxBulkManualTags("clear_tags");
        });

      // associate new logical group: create a function to limit code repetition
      function splkFlxBulkAssociateNewLogicalGroup() {
        var splkFlxBulkObjs = getToken("splkFlxBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFlxBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-flx");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_get", "True");

        // hide this action
        $("#btn_associate_logical_group_add_group_back").hide();
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group_add_group").modal();
      }

      // bulk
      $("#btn_splk_flx_bulk_associate_new_logical_group")
        .unbind()
        .click(function () {
          splkFlxBulkAssociateNewLogicalGroup();
        });

      // associate existing logical group: create a function to limit code repetition
      function splkFlxBulkAssociateExistingLogicalGroup() {
        var splkFlxBulkObjs = getToken("splkFlxBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFlxBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-flx");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_add", "True");

        // Start search
        searchLogicalGroupTableAddMember.startSearch();

        // hide this action
        $("#btn_associate_logical_group_add_member_back").hide();

        // Open modal
        $("#logical_group_add_member").modal();
      }

      // bulk
      $("#btn_splk_flx_bulk_associate_existing_logical_group")
        .unbind()
        .click(function () {
          splkFlxBulkAssociateExistingLogicalGroup();
        });

      // unassociate logical group: create a function to limit code repetition
      function splkFlxBulkUnassociateLogicalGroup() {
        var splkFlxBulkObjs = getToken("splkFlxBulkObjs");

        // Free the search
        setToken("tk_start_logical_member_get", "true");

        // Start the search
        searchLogicalGroupTable.startSearch();

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFlxBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-flx");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // hide this action
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group").modal();
      }

      // bulk
      $("#btn_splk_flx_bulk_unassociate_logical_group")
        .unbind()
        .click(function () {
          splkFlxBulkUnassociateLogicalGroup();
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkFlxBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "flx",
          keys_list: splkFlxBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_flx_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkFlxBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_flx_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkFlxBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_flx_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkFlxBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_flx_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkFlxBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_flx_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkFlxBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkFlxBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFlxBulkIds = getToken("splkFlxBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_flx_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "flx",
          keys_list: splkFlxBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFlxMain.startSearch();
            // refresh tabulator
            $("#splk-flx-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metric
      $("#btn_splk_flx_bulk_outliers_kpi_metric")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_kpi_metric_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_kpi_metric_value"
          ).val();
          // set actionField
          var actionField = "kpi_metric";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_flx_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_flx_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_flx_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_flx_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_flx_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_flx_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_flx_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_flx_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_flx_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_flx_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_flx_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_flx_bulk_outliers_custom_key
          var actionField = $("#btn_splk_flx_bulk_outliers_custom_key").val();
          splkFlxBulkOutliersRules(actionField, actionValue);
        });

      //
      // end
      //
    }

    // splk-flx get table
    function getSplkFlxTable() {
      // avoid causing double interval
      clearInterval(splkFlxIntervalId);
      // get data
      splkFlxHandlerTable();
    }

    // splk-flx refresh timer
    var splkFlxIntervalId;

    function splkFlxRefreshInfo() {
      var myDate = new Date();
      var splkFlxLastRefresh = document.getElementById("splkFlxLastRefresh");
      function updateTime() {
        splkFlxLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkFlxIntervalId = setInterval(updateTime, 2000);
    }

    function splkFlxResetRefreshInfo() {
      clearInterval(splkFlxIntervalId);
      // release our intervalID from the variable
      splkFlxIntervalId = null;
      splkFlxRefreshInfo();
    }

    function splkFlxPauseRefreshInfo() {
      clearInterval(splkFlxIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkFlxIntervalId = null;
      tableRefreshIntervalId = null;
      splkFlxLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkFlxResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-flx-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-flx modal entity view

    function showSplkFlxEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      // get tenant_id
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];
      // get entity details
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      var tk_splk_flx = jsonData["object"];
      setToken("tk_splk_flx", tk_splk_flx);
      var tk_object = tk_splk_flx;
      var tk_alias = jsonData["alias"];
      // token is required
      setToken("tk_object", tk_object);
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];
      var tk_object_state = jsonData["object_state"];
      var tk_monitored_state = jsonData["monitored_state"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_flx_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_flx_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_flx_set_threshold_value"
        ).value = "";
      }

      // wdays - hours_range
      var monitoring_wdays = jsonData["monitoring_wdays"];
      setToken("form.tk_input_wdays_flx", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["monitoring_hours_ranges"];
      setToken("form.tk_input_splk_flx_hours_ranges", monitoring_hours_ranges);

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // specific to splk-flx
      var tk_status = jsonData["status"];
      var tk_status_description = jsonData["status_description"];
      var tk_description = jsonData["object_description"];

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divFlxOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divFlxOutliersSimulationInfo").css("display", "none");
        $("#divFlxOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_flx_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_flx_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divFlxOutliersInfo").css("display", "inherit");
        $("#child-flx-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divFlxOutliersSimulationInfo").css("display", "inherit");
        $("#divFlxOutliersSimulationRender").css("display", "none");
        $("#child-flx-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_flx_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_flx_save").prop("disabled", true);
      }

      // pre-fill current priority
      setToken("form.tk_input_splk_flx_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkFlx").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkFlx").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkFlx").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkFlx").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkFlx").html("");
      }

      // drilldown search (optional, might not be set)
      var tk_drilldown_search = jsonData["drilldown_search"];
      var tk_drilldown_search_earliest = jsonData["drilldown_search_earliest"];
      var tk_drilldown_search_latest = jsonData["drilldown_search_latest"];

      // if set, show the drilldown search button and assign the href (while the drilldown search needs to be url encoded)
      if (tk_drilldown_search) {
        $("#btn_search_splk_flx_drilldown_search").css("display", "inherit");
        $("#btn_search_splk_flx_drilldown_search").attr(
          "href",
          tk_drilldown_search
        );
        // update href
        tk_drilldown_search =
          "search" +
          "?q=" +
          encodeURI(tk_drilldown_search) +
          "&earliest=" +
          tk_drilldown_search_earliest +
          "&latest=" +
          tk_drilldown_search_latest;
        document.getElementById("btn_search_splk_flx_drilldown_search").href =
          tk_drilldown_search;
      } else {
        $("#btn_search_splk_flx_drilldown_search").css("display", "none");
      }

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      // Preset the default value in the multiselect dropdown
      modal_input_splk_flx_metrics_multiselect.val(jsonData["default_metric"]);

      // get entity info
      // Retrieve entity info from REST and set actions
      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_flx/flx_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();
          // get from the json response
          document.getElementById("btn_search_splk_flx").href =
            returneddata["splk_flx_mctalog_search"];
          //
          document.getElementById("btn_mpreview_splk_flx").href =
            returneddata["splk_flx_mpreview"];
          //
          document.getElementById("btn_search_splk_flx_live_report").href =
            returneddata["splk_flx_metrics_report"];
          // Set and start the populating search for metrics
          setToken(
            "splk_flx_metrics_populate_search",
            returneddata["splk_flx_metrics_populate_search"]
          );
          searchPopulateSplkFlxMetrics.startSearch();
          searchPopulateSplkFlxMetricsAddentity.startSearch();

          // call the function
          generateFlxChartSearch(tenant_id, tk_keyid);

          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage buttons states
      var tk_monitored_state_class;
      if (tk_monitored_state == "enabled") {
        document.getElementById(
          "btn_enable_monitoring_splk_flx"
        ).disabled = true;
        document.getElementById(
          "btn_disable_monitoring_splk_flx"
        ).disabled = false;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_flx"
        ).style.display = "none";
        document.getElementById(
          "btn_disable_monitoring_splk_flx"
        ).style.display = "inherit";
        tk_monitored_state_class = "title_green";
      } else {
        document.getElementById(
          "btn_enable_monitoring_splk_flx"
        ).disabled = false;
        document.getElementById(
          "btn_disable_monitoring_splk_flx"
        ).disabled = true;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_flx"
        ).style.display = "inherit";
        document.getElementById(
          "btn_disable_monitoring_splk_flx"
        ).style.display = "none";
        tk_monitored_state_class = "title_grey";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_flx_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_flx_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_flx_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_flx_status_message_class = "status_message_json_red";
      }

      // sla
      var tk_splk_flx_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_flx_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_flx_sla_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_flx").disabled = false;
        $("#btn_ack_splk_flx").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_flx").disabled = false;
        $("#btn_ack_splk_flx").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_flx").disabled = false;
        $("#btn_ack_splk_flx").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_flx").disabled = true;
        $("#btn_ack_splk_flx").html("Ack alert");
      }

      // replace info panels
      $("#parent-splk-flx-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_splk_flx) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-splk-flx-top-info1").html(
        '<h3>Status: <span style="color: dodgerblue;">' +
          tk_status +
          '<span style="color: dodgerblue;">' +
          '<h3>Status description: <span style="color: dodgerblue;">' +
          truncate(tk_status_description, 200) +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-flx-top-info2").html(
        '<h3>monitored state:</b> <span class="' +
          tk_monitored_state_class +
          '">' +
          tk_monitored_state +
          "</span></h3>" +
          '<h3>entity state:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></h3>"
      );

      $("#child-splk-flx-top-info3").html(
        '<h3>latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-flx-top-info4").html(
        '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></h3>" +
          '<h3>Description: <span style="color: dodgerblue;">' +
          truncate(tk_description, 200) +
          "</span></h3>"
      );

      $("#child-splk-flx-top-docs-tags").html(
        '<h3><span><a id="tags_splk_flx" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-splk-flx-status-message").html(
        '<div class="' +
          tk_splk_flx_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-splk-flx-sla-message").html(
        '<div class="' +
          tk_splk_flx_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // Run
      if (
        getToken("userLevel") === "user" &&
        actionTarget.startsWith("modal_modify_")
      ) {
        $("#modal_user_restricted").modal();
      } else {
        if (actionType === "modal") {
          if (actionTarget === "modal_cmdb_splk_flx") {
            searchCmdbSplkFlx.startSearch();
            $("#" + actionTarget).modal();
          } else if (actionTarget === "modal_modify_splk_flx_unified") {
            searchPopulateSplkFlxMetricsThresholds.startSearch();
            SplkFlxThresholdsHandlerTable(
              getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/splk_flx/flx_get_thresholds"
              ),
              "POST",
              {
                tenant_id: getToken("tenant_id"),
                keys_list: getToken("tk_keyid"),
              },
              "thresholds_splk_flx"
            );
          } else {
            $("#" + actionTarget).modal();
          }
        } else if (actionType === "click") {
          $("#" + actionTarget).click();
        }
      }
    }

    //
    // splk-fqm
    //

    // disable the bulk edit button
    $("#splk-fqm-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-fqm-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-fqm-table-cancel").prop("disabled", true);

    // splk-fqm tabulator
    function splkFqmHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-fqm-table";

      // get tenant level preference
      var ui_expand_metrics = getToken("ui_expand_metrics");
      if (ui_expand_metrics == 1) {
        var fieldEl = document.getElementById("splk-fqm-table-mode");
        fieldEl.value = "full";
      }

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-fqm-table-mode");
        if (modeView === "minimal") {
          return "right click for popup";
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 1).replace(
            /\\/g,
            ""
          ); //return JSON formatted cell
        }
      }

      // popup formatter
      var rowPopupFormatterStatusDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.status_message_json);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Status Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // popup formatter
      var rowPopupFormatterMetricsDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.metrics);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Metrics Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-fqm-table-filter-field");
      var typeEl = document.getElementById("splk-fqm-table-filter-type");
      var valueEl = document.getElementById("splk-fqm-table-filter-value");
      var enabledEl = document.getElementById("splk-fqm-table-filter-enabled");

      // listen for a change
      $("#splk-fqm-table-mode").change(function () {
        var newmodeView = document.getElementById("splk-fqm-table-mode").value;
        table.replaceData(resultCall);
      });

      // custom functions

      // standard filters

      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("fqm");
        var enteredValue = document.getElementById(
          "splk-fqm-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled();
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_blue_state") {
          customFilterBlueState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkFqm.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkFqmAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkFqmAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkFqmAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkFqmDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkFqmCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-fqm-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkFqmCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-fqm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-fqm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-fqm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-fqm-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-fqm-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-fqm-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-fqm-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Object description:</strong> " +
          data.object_description +
          "</li>";
        contents += "<li><strong>Status:</strong> " + data.status + "</li>";
        contents +=
          "<li><strong>Status description:</strong> " +
          data.status_description +
          "</li>";
        contents +=
          "<li><strong>AnomalyReason:</strong> " +
          data.anomaly_reason +
          "</li>";
        contents +=
          "<li><strong>Outliers anomaly detection state:</strong> " +
          data.OutliersStatus +
          "</li>";
        contents +=
          "<li><strong>Status message:</strong> " +
          data.status_message +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring days:</strong> " +
          data.isUnderMonitoringDays +
          "</li>";
        contents +=
          "<li><strong>Currently under monitoring hours:</strong> " +
          data.isUnderMonitoringHours +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_fqm_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        //progressiveLoad:"load", //enable progressive loading
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        reactiveData: true,
        index: "_key",
        layout: "fitColumns", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkFqmEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_fqm",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkFqmEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_fqm_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkFqmEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_fqm",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "group",
                field: "group",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                contextPopup: rowPopupFormatter, //add click popup to row
                minWidth: getToken("ui_min_object_width"),
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Status description (right click: info)",
            columns: [
              {
                title: "Status",
                field: "status",
                width: 80,
                editor: false,
                headerFilter: true,
                visible: false,
              },
              {
                title: "Status description",
                field: "status_description_short",
                contextPopup: rowPopupFormatterStatusDetails, //add click popup to row
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Metrics",
            columns: [
              {
                title: "Last metrics",
                field: "metrics",
                width: 200,
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterMetricsDetails,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Tracking information",
            columns: [
              {
                title: "Tracker runtime",
                field: "tracker_runtime (translated)",
                width: 150,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            title: "Outliers",
            field: "OutliersIsOk",
            contextPopup: rowPopupFormatterOutliers, //add click popup to row
            hozAlign: "center",
            formatter: "tickCross",
            width: 100,
            visible: getToken("mloutliers_fqm"),
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-fqm-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-fqm-table-filter-field").val("keyid");
            $("#splk-fqm-table-filter-type").val("=");
            $("#splk-fqm-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkFqmEntityModal(
                currentData[0],
                "modal_manage_splk_fqm",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-fqm-table-filter-field").val("alias");
              $("#splk-fqm-table-filter-type").val("=");
              $("#splk-fqm-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkFqmEntityModal(
                  currentData[0],
                  "modal_manage_splk_fqm",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-fqm-table-filter-field").val("object");
              $("#splk-fqm-table-filter-type").val("=");
              $("#splk-fqm-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkFqmEntityModal(
                  currentData[0],
                  "modal_manage_splk_fqm",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-fqm-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-fqm-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-fqm-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-fqm-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-fqm-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by priority" button
        document
          .getElementById("splk-fqm-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-fqm-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-fqm-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-fqm-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-fqm-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=fqm"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-fqm-table-bulk").prop("disabled", false);
          splkFqmPauseRefreshInfo();
        } else {
          $("#splk-fqm-table-bulk").prop("disabled", true);
          document.getElementById("splkFqmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkFqmResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-fqm-table-save").prop("disabled", false);
        $("#splk-fqm-table-cancel").prop("disabled", false);
        splkFqmPauseRefreshInfo();
      });

      // set the timer
      splkFqmRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-fqm-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-fqm-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkFqmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // auto hidden refresh
      $("#splk-fqm-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkFqmResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-fqm-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkFqmBulkObjs", itemList.toString());
          setToken("splkFqmBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divFqmBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_fqm").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-fqm-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkFqmMain.startSearch();
              // refresh tabulator
              $("#splk-fqm-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-fqm-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-fqm-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkFqmLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-fqm-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-fqm-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkFqmBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-fqm",
          keys_list: splkFqmBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_fqm_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkFqmBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_fqm_bulk_priority_high")
        .unbind()
        .click(function () {
          splkFqmBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_fqm_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkFqmBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_fqm_bulk_priority_low")
        .unbind()
        .click(function () {
          splkFqmBulkPriority("low");
        });

      // priority: create a function to limit code repetition
      function splkFqmBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkObjs = getToken("splkFqmBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_fqm_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_fqm_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_fqm_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_fqm_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-fqm",
            object_list: splkFqmBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-fqm",
            object_list: splkFqmBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloaderremove();

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk ack enable
      $("#btn_splk_fqm_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkFqmBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_fqm_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkFqmBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkFqmBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-fqm",
          keys_list: splkFqmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_fqm_bulk_enable")
        .unbind()
        .click(function () {
          splkFqmBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_fqm_bulk_disable")
        .unbind()
        .click(function () {
          splkFqmBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkFqmBulkDelete(actionTarget) {
        var splkFqmBulkIds = getToken("splkFqmBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkFqmBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Update
            $("#splk-fqm-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_fqm_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkFqmBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_fqm_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkFqmBulkDelete("permanent");
        });

      // Thresholds bulk update: create a function to limit code repetition
      function splkFqmBulkThresholds(actionRecord) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_thresholds_update_bulk"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "fqm",
          keys_list: splkFqmBulkIds,
          record_changes: actionRecord,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_fqm_bulk_thresholds)
      $("#btn_splk_fqm_bulk_thresholds")
        .unbind()
        .click(function () {
          // set the record_changes
          var record_changes = {
            kpi_metric_name: $(
              "#btn_splk_fqm_bulk_thresholds_kpi_metric_name"
            ).val(),
            kpi_metric_value: $(
              "#btn_splk_fqm_bulk_thresholds_kpi_metric_value"
            ).val(),
            operator: $("#btn_splk_fqm_bulk_thresholds_operator").val(),
            condition_true: $(
              "#btn_splk_fqm_bulk_thresholds_condition_true"
            ).val(),
          };
          splkFqmBulkThresholds(record_changes);
        });

      // bulk manual tags: create a function to limit code repetition
      function splkFqmBulkManualTags(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/write/fqm_update_manual_tags"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-fqm",
          keys_list: splkFqmBulkIds,
          update_comment: tk_comment,
        };

        // Set depending on action
        if (actionTarget == "set_tags") {
          var tk_tags_manual = $("#btn_splk_fqm_bulk_tags_list").tagsinput(
            "items"
          );
        } else if (actionTarget == "clear_tags") {
          var tk_tags_manual = "";
        }

        // update record
        record.tags_manual = tk_tags_manual;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // call (button btn_splk_fqm_bulk_create_manual_tags)
      $("#btn_splk_fqm_bulk_create_manual_tags")
        .unbind()
        .click(function () {
          splkFqmBulkManualTags("set_tags");
        });

      // call (button btn_splk_fqm_bulk_clear_manual_tags)
      $("#btn_splk_fqm_bulk_clear_manual_tags")
        .unbind()
        .click(function () {
          splkFqmBulkManualTags("clear_tags");
        });

      // associate new logical group: create a function to limit code repetition
      function splkFqmBulkAssociateNewLogicalGroup() {
        var splkFqmBulkObjs = getToken("splkFqmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFqmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-fqm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_get", "True");

        // hide this action
        $("#btn_associate_logical_group_add_group_back").hide();
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group_add_group").modal();
      }

      // bulk
      $("#btn_splk_fqm_bulk_associate_new_logical_group")
        .unbind()
        .click(function () {
          splkFqmBulkAssociateNewLogicalGroup();
        });

      // associate existing logical group: create a function to limit code repetition
      function splkFqmBulkAssociateExistingLogicalGroup() {
        var splkFqmBulkObjs = getToken("splkFqmBulkObjs");

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFqmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-fqm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Set required tokens
        setToken("tk_start_logical_member_add", "True");

        // Start search
        searchLogicalGroupTableAddMember.startSearch();

        // hide this action
        $("#btn_associate_logical_group_add_member_back").hide();

        // Open modal
        $("#logical_group_add_member").modal();
      }

      // bulk
      $("#btn_splk_fqm_bulk_associate_existing_logical_group")
        .unbind()
        .click(function () {
          splkFqmBulkAssociateExistingLogicalGroup();
        });

      // unassociate logical group: create a function to limit code repetition
      function splkFqmBulkUnassociateLogicalGroup() {
        var splkFqmBulkObjs = getToken("splkFqmBulkObjs");

        // Free the search
        setToken("tk_start_logical_member_get", "true");

        // Start the search
        searchLogicalGroupTable.startSearch();

        // this token is expected by the target
        setToken("tk_logical_group_target", splkFqmBulkObjs);

        // logical group dynamically handle searches
        setToken("tk_object_category", "splk-fqm");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // hide this action
        $("#btn_associate_logical_group_back").hide();

        // Open modal
        $("#logical_group").modal();
      }

      // bulk
      $("#btn_splk_fqm_bulk_unassociate_logical_group")
        .unbind()
        .click(function () {
          splkFqmBulkUnassociateLogicalGroup();
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkFqmBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "fqm",
          keys_list: splkFqmBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_fqm_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkFqmBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_fqm_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkFqmBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_fqm_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkFqmBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_fqm_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkFqmBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_fqm_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkFqmBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkFqmBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkFqmBulkIds = getToken("splkFqmBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_fqm_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "fqm",
          keys_list: splkFqmBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkFqmMain.startSearch();
            // refresh tabulator
            $("#splk-fqm-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metric
      $("#btn_splk_fqm_bulk_outliers_kpi_metric")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_kpi_metric_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_kpi_metric_value"
          ).val();
          // set actionField
          var actionField = "kpi_metric";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_fqm_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_fqm_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_fqm_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_fqm_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_fqm_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_fqm_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_fqm_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_fqm_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_fqm_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_fqm_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_fqm_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_fqm_bulk_outliers_custom_key
          var actionField = $("#btn_splk_fqm_bulk_outliers_custom_key").val();
          splkFqmBulkOutliersRules(actionField, actionValue);
        });

      //
      // end
      //
    }

    // splk-fqm get table
    function getSplkFqmTable() {
      // avoid causing double interval
      clearInterval(splkFqmIntervalId);
      // get data
      splkFqmHandlerTable();
    }

    // splk-fqm refresh timer
    var splkFqmIntervalId;

    function splkFqmRefreshInfo() {
      var myDate = new Date();
      var splkFqmLastRefresh = document.getElementById("splkFqmLastRefresh");
      function updateTime() {
        splkFqmLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkFqmIntervalId = setInterval(updateTime, 2000);
    }

    function splkFqmResetRefreshInfo() {
      clearInterval(splkFqmIntervalId);
      // release our intervalID from the variable
      splkFqmIntervalId = null;
      splkFqmRefreshInfo();
    }

    function splkFqmPauseRefreshInfo() {
      clearInterval(splkFqmIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkFqmIntervalId = null;
      tableRefreshIntervalId = null;
      splkFqmLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkFqmResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-fqm-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-fqm modal entity view
    function showSplkFqmEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      // get tenant_id
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];
      // get entity details
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      var tk_splk_fqm = jsonData["object"];
      setToken("tk_splk_fqm", tk_splk_fqm);
      var tk_object = tk_splk_fqm;
      var tk_alias = jsonData["alias"];
      // token is required
      setToken("tk_object", tk_object);
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];
      var tk_object_state = jsonData["object_state"];
      var tk_monitored_state = jsonData["monitored_state"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_fqm_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_fqm_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_fqm_set_threshold_value"
        ).value = "";
      }

      // wdays - hours_range
      var monitoring_wdays = jsonData["monitoring_wdays"];
      setToken("form.tk_input_wdays_fqm", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["monitoring_hours_ranges"];
      setToken("form.tk_input_splk_fqm_hours_ranges", monitoring_hours_ranges);

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // specific to splk-fqm
      var tk_status = jsonData["status"];
      var tk_status_description = jsonData["status_description"];
      var tk_description = jsonData["object_description"];

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divFqmOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divFqmOutliersSimulationInfo").css("display", "none");
        $("#divFqmOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_fqm_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_fqm_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divFqmOutliersInfo").css("display", "inherit");
        $("#child-fqm-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divFqmOutliersSimulationInfo").css("display", "inherit");
        $("#divFqmOutliersSimulationRender").css("display", "none");
        $("#child-fqm-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_fqm_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_fqm_save").prop("disabled", true);
      }

      // pre-fill current priority
      setToken("form.tk_input_splk_fqm_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkFqm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkFqm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkFqm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkFqm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkFqm").html("");
      }

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      // get entity info
      // Retrieve entity info from REST and set actions
      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_fqm/fqm_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();
          // fqm_type
          var fqm_type = returneddata["fqm_type"];
          setToken("tk_fqm_type", fqm_type);

          // handle dynamic view
          if (fqm_type == "global") {
            // hide id parent-splk-fqm-overview-pie-field
            $("#parent-splk-fqm-overview-pie-field").css("display", "none");
            // hide id parent-splk-fqm-overview-singles-field
            $("#parent-splk-fqm-overview-singles-field").css("display", "none");
            // show id parent-splk-fqm-overview-pie-global
            $("#parent-splk-fqm-overview-pie-global").css("display", "inherit");
            // show id parent-splk-fqm-overview-singles-global
            $("#parent-splk-fqm-overview-singles-global").css(
              "display",
              "inherit"
            );
          } else {
            // show id parent-splk-fqm-overview-pie-field
            $("#parent-splk-fqm-overview-pie-field").css("display", "inherit");
            // hide id parent-splk-fqm-overview-pie-global
            $("#parent-splk-fqm-overview-pie-global").css("display", "none");
            // show id parent-splk-fqm-overview-singles-field
            $("#parent-splk-fqm-overview-singles-field").css(
              "display",
              "inherit"
            );
            // show id parent-splk-fqm-overview-singles-global
            $("#parent-splk-fqm-overview-singles-global").css(
              "display",
              "none"
            );
          }

          // set the search sample events url
          document.getElementById("btn_search_sample_splk_fqm").href =
            returneddata["splk_fqm_search_sample_events"];
          // set the search sample not matching regex events url
          document.getElementById(
            "btn_search_sample_not_matching_regex_splk_fqm"
          ).href =
            returneddata["splk_fqm_search_sample_not_matching_regex_events"];
          // get from the json response
          document.getElementById("btn_search_splk_fqm").href =
            returneddata["splk_fqm_mctalog_search"];
          //
          document.getElementById("btn_mpreview_splk_fqm").href =
            returneddata["splk_fqm_mpreview"];
          //
          document.getElementById("btn_search_splk_fqm_live_report").href =
            returneddata["splk_fqm_metrics_report"];
          // Set and start the populating search for metrics
          setToken(
            "splk_fqm_metrics_populate_search",
            returneddata["splk_fqm_metrics_populate_search"]
          );
          searchPopulateSplkFqmMetrics.startSearch();
          searchPopulateSplkFqmMetricsAddentity.startSearch();

          // call the function
          generateFqmChartSearch(tenant_id, tk_keyid);

          // also directly set tokens for
          // splk_fqm_chart_values_search
          setToken(
            "splk_fqm_chart_values_search",
            returneddata["splk_fqm_chart_values_search"]
          );
          // splk_fqm_chart_description_search
          setToken(
            "splk_fqm_chart_description_search",
            returneddata["splk_fqm_chart_description_search"]
          );
          // splk_fqm_chart_status_search
          setToken(
            "splk_fqm_chart_status_search",
            returneddata["splk_fqm_chart_status_search"]
          );
          // splk_fqm_table_summary_search
          setToken(
            "splk_fqm_table_summary_search",
            returneddata["splk_fqm_table_summary_search"]
          );
          // splk_fqm_table_summary_formated_search
          setToken(
            "splk_fqm_table_summary_formated_search",
            returneddata["splk_fqm_table_summary_formated_search"]
          );
          // splk_fqm_metrics_success_overtime
          setToken(
            "splk_fqm_metrics_success_overtime",
            returneddata["splk_fqm_metrics_success_overtime"]
          );
          // splk_fqm_search_sample_events_raw
          setToken(
            "splk_fqm_search_sample_events_raw",
            returneddata["splk_fqm_search_sample_events_raw"]
          );

          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage buttons states
      var tk_monitored_state_class;
      if (tk_monitored_state == "enabled") {
        document.getElementById(
          "btn_enable_monitoring_splk_fqm"
        ).disabled = true;
        document.getElementById(
          "btn_disable_monitoring_splk_fqm"
        ).disabled = false;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_fqm"
        ).style.display = "none";
        document.getElementById(
          "btn_disable_monitoring_splk_fqm"
        ).style.display = "inherit";
        tk_monitored_state_class = "title_green";
      } else {
        document.getElementById(
          "btn_enable_monitoring_splk_fqm"
        ).disabled = false;
        document.getElementById(
          "btn_disable_monitoring_splk_fqm"
        ).disabled = true;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_fqm"
        ).style.display = "inherit";
        document.getElementById(
          "btn_disable_monitoring_splk_fqm"
        ).style.display = "none";
        tk_monitored_state_class = "title_grey";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_fqm_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_fqm_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_fqm_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_fqm_status_message_class = "status_message_json_red";
      }

      // sla
      var tk_splk_fqm_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_fqm_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_fqm_sla_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_fqm").disabled = false;
        $("#btn_ack_splk_fqm").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_fqm").disabled = false;
        $("#btn_ack_splk_fqm").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_fqm").disabled = false;
        $("#btn_ack_splk_fqm").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_fqm").disabled = true;
        $("#btn_ack_splk_fqm").html("Ack alert");
      }

      // replace info panels
      $("#parent-splk-fqm-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_splk_fqm) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-splk-fqm-top-info1").html(
        '<h3>Status: <span style="color: dodgerblue;">' +
          tk_status +
          '<span style="color: dodgerblue;">' +
          '<h3>Status description: <span style="color: dodgerblue;">' +
          truncate(tk_status_description, 200) +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-fqm-top-info2").html(
        '<h3>monitored state:</b> <span class="' +
          tk_monitored_state_class +
          '">' +
          tk_monitored_state +
          "</span></h3>" +
          '<h3>entity state:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></h3>"
      );

      $("#child-splk-fqm-top-info3").html(
        '<h3>latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-fqm-top-info4").html(
        '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></h3>" +
          '<h3>Description: <span style="color: dodgerblue;">' +
          truncate(tk_description, 200) +
          "</span></h3>"
      );

      $("#child-splk-fqm-top-docs-tags").html(
        '<h3><span><a id="tags_splk_fqm" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-splk-fqm-status-message").html(
        '<div class="' +
          tk_splk_fqm_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-splk-fqm-sla-message").html(
        '<div class="' +
          tk_splk_fqm_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // Run
      if (
        getToken("userLevel") === "user" &&
        actionTarget.startsWith("modal_modify_")
      ) {
        $("#modal_user_restricted").modal();
      } else {
        if (actionType === "modal") {
          if (actionTarget === "modal_cmdb_splk_fqm") {
            searchCmdbSplkFqm.startSearch();
            $("#" + actionTarget).modal();
          } else if (actionTarget === "modal_modify_splk_fqm_unified") {
            searchPopulateSplkFqmMetricsThresholds.startSearch();
            SplkFqmThresholdsHandlerTable(
              getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/splk_fqm/fqm_get_thresholds"
              ),
              "POST",
              {
                tenant_id: getToken("tenant_id"),
                keys_list: getToken("tk_keyid"),
              },
              "thresholds_splk_fqm"
            );
          } else {
            $("#" + actionTarget).modal();
          }
        } else if (actionType === "click") {
          $("#" + actionTarget).click();
        }
      }
    }

    //
    // splk-wlk
    //

    // disable the bulk edit button
    $("#splk-wlk-table-bulk").prop("disabled", true);

    // disable the inline save button
    $("#splk-wlk-table-save").prop("disabled", true);

    // disable the inline cancel button
    $("#splk-wlk-table-cancel").prop("disabled", true);

    // splk-wlk tabulator
    function splkWlkHandlerTable() {
      // set the table div
      var tabulatorElement = "#" + "splk-wlk-table";

      // get tenant level preference
      var ui_expand_metrics = getToken("ui_expand_metrics");
      if (ui_expand_metrics == 1) {
        var fieldEl = document.getElementById("splk-wlk-table-mode");
        fieldEl.value = "full";
      }

      function jsonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var modeView = getValueFromDropdown("splk-wlk-table-mode");
        if (modeView === "minimal") {
          return "right click for popup";
        } else {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(JSON.parse(cell.getValue()), null, 1).replace(
            /\\/g,
            ""
          ); //return JSON formatted cell
        }
      }

      function AnomalyReasonFormatter(cell, formatterParams, onRendered) {
        // get mode
        var cellValue = cell.getValue();
        // if cellaValue is a pipe separated string, turn it into a list and pretty print it
        if (cellValue.includes("|")) {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          cellValue = JSON.stringify(cellValue.split("|"), null, 1);
        }
        return cellValue;
      }

      //Generate open icon
      var openIcon = function (cell, formatterParams) {
        return "<i class='bi bi-box-arrow-up-right'></i>";
      };

      //Generate tool icon
      var toolIcon = function (cell, formatterParams) {
        return "<i class='bi bi-tools'></i>";
      };

      //Generate cmdb icon
      var cmdbIcon = function (cell, formatterParams) {
        return "<i class='bi bi-database-fill-gear'></i>";
      };

      // filters
      //Define variables for input elements

      var fieldEl = document.getElementById("splk-wlk-table-filter-field");
      var typeEl = document.getElementById("splk-wlk-table-filter-type");
      var valueEl = document.getElementById("splk-wlk-table-filter-value");
      var enabledEl = document.getElementById("splk-wlk-table-filter-enabled");

      // listen for a change
      $("#splk-wlk-table-mode").change(function () {
        table.setData(
          getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/component/load_component_data"
          ),
          {
            tenant_id: getToken("tenant_id"),
            component: getToken("tk_component"),
            mode_view: getValueFromDropdown("splk-wlk-table-mode"),
            pagination_mode: getToken("pagination_mode"),
          }
        );
      });

      // custom functions

      // standard filters

      function customFilterRedState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "object_state", type: "=", value: "red" }]);
        }
      }

      function customFilterOrangeState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "orange" },
          ]);
        }
      }

      function customFilterGreenState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "green" },
          ]);
        }
      }

      function customFilterBlueState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "blue" },
          ]);
        }
      }

      function customFilterAlertState(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: ["red", "orange"] },
          ]);
        }
      }

      function customFilterRedStateCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterRedStateHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
          ]);
        }
      }

      function customFilterRedStateMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "medium" },
          ]);
        }
      }

      function customFilterRedStateLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "low" },
          ]);
        }
      }

      function customFilterCriticalPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "priority", type: "=", value: "critical" },
          ]);
        }
      }

      function customFilterHighPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "high" }]);
        }
      }

      function customFilterMediumPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "medium" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "medium" }]);
        }
      }

      function customFilterLowPriority(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "priority", type: "=", value: "low" },
            { field: "monitored_state", type: "like", value: "enabled" },
          ]);
        } else {
          table.setFilter([{ field: "priority", type: "=", value: "low" }]);
        }
      }

      function customFilterEnabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "enabled" },
        ]);
      }

      function customFilterDisabled() {
        table.setFilter([
          { field: "monitored_state", type: "=", value: "disabled" },
        ]);
      }

      function customFilterAckActive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "active" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      function customFilterAckInactive(showDisabled, priority) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "monitored_state", type: "=", value: "enabled" },
            { field: "priority", type: "like", value: priority },
          ]);
        } else {
          table.setFilter([
            { field: "ack_state", type: "=", value: "inactive" },
            { field: "priority", type: "like", value: priority },
          ]);
        }
      }

      // specific filters

      function customFilterSkippingSearches(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "skipping_searches_detected",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "skipping_searches_detected",
            },
          ]);
        }
      }

      function customFilterOrphan(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "orphan_search_detected",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "orphan_search_detected",
            },
          ]);
        }
      }

      function customFilterExecutionErrors(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "execution_errors_detected",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "execution_errors_detected",
            },
          ]);
        }
      }

      function customFilterExecutionDelayed(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: "anomaly_reason", type: "=", value: "execution_delayed" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: "anomaly_reason", type: "=", value: "execution_delayed" },
          ]);
        }
      }

      function customFilterOutliersAnomaly(showDisabled) {
        if (showDisabled == "false") {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            {
              field: "anomaly_reason",
              type: "=",
              value: "ml_outliers_detection",
            },
          ]);
        }
      }

      function customSelective(showDisabled, filterVal, typeVal, enteredValue) {
        if (showDisabled == "false") {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
        } else {
          table.setFilter([
            { field: filterVal, type: typeVal, value: enteredValue },
          ]);
        }
      }

      //Trigger setFilter function with correct parameters
      function updateFilter() {
        var filterVal = fieldEl.options[fieldEl.selectedIndex].value;
        var typeVal = typeEl.options[typeEl.selectedIndex].value;
        var showDisabled = showDisableEntities("wlk");
        var enteredValue = document.getElementById(
          "splk-wlk-table-filter-value"
        ).value;
        // standard filters
        if (filterVal == "function_critical_priority") {
          customFilterCriticalPriority(showDisabled);
        } else if (filterVal == "function_high_priority") {
          customFilterHighPriority(showDisabled);
        } else if (filterVal == "function_medium_priority") {
          customFilterMediumPriority(showDisabled);
        } else if (filterVal == "function_low_priority") {
          customFilterLowPriority(showDisabled);
        } else if (filterVal == "function_red_state_critical_priority") {
          customFilterRedStateCriticalPriority(showDisabled);
        } else if (filterVal == "function_red_state_high_priority") {
          customFilterRedStateHighPriority(showDisabled);
        } else if (filterVal == "function_red_state_medium_priority") {
          customFilterRedStateMediumPriority(showDisabled);
        } else if (filterVal == "function_red_state_low_priority") {
          customFilterRedStateLowPriority(showDisabled);
        } else if (filterVal == "function_enabled") {
          customFilterEnabled();
        } else if (filterVal == "function_disabled") {
          customFilterDisabled(showDisabled);
        } else if (filterVal == "function_red_state") {
          customFilterRedState(showDisabled);
        } else if (filterVal == "function_orange_state") {
          customFilterOrangeState(showDisabled);
        } else if (filterVal == "function_green_state") {
          customFilterGreenState(showDisabled);
        } else if (filterVal == "function_alert_state") {
          customFilterAlertState(showDisabled);
        } else if (filterVal == "function_ack_active") {
          customFilterAckActive(showDisabled, "");
        } else if (filterVal == "function_ack_inactive") {
          customFilterAckInactive(showDisabled, "");
        } else if (filterVal == "function_ack_active_critical_priority") {
          customFilterAckActive(showDisabled, "critical");
        } else if (filterVal == "function_ack_active_high_priority") {
          customFilterAckActive(showDisabled, "high");
        } else if (filterVal == "function_ack_active_medium_priority") {
          customFilterAckActive(showDisabled, "medium");
        } else if (filterVal == "function_ack_active_low_priority") {
          customFilterAckActive(showDisabled, "low");
        } else if (filterVal == "function_ack_inactive_critical_priority") {
          customFilterAckInactive(showDisabled, "critical");
        } else if (filterVal == "function_ack_inactive_high_priority") {
          customFilterAckInactive(showDisabled, "high");
        } else if (filterVal == "function_ack_inactive_medium_priority") {
          customFilterAckInactive(showDisabled, "medium");
        } else if (filterVal == "function_ack_inactive_low_priority") {
          customFilterAckInactive(showDisabled, "low");
          // specific filters
        } else if (filterVal == "function_skipping_searches_detected") {
          customFilterSkippingSearches(showDisabled);
        } else if (filterVal == "function_orphan_search_detected") {
          customFilterOrphan(showDisabled);
        } else if (filterVal == "function_execution_errors_detected") {
          customFilterExecutionErrors(showDisabled);
        } else if (filterVal == "function_execution_delayed") {
          customFilterExecutionDelayed(showDisabled);
        } else if (filterVal == "function_outliers_anomaly") {
          customFilterOutliersAnomaly(showDisabled);
          // free filter
        } else {
          customSelective(showDisabled, filterVal, typeVal, enteredValue);
        }
      }

      // Drilldown click from single all entities
      singleFormTotalSplkWlk.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "like", value: "" },
          ]);
          // notify
          notify("success", "bottom", "Filtering on all entities.", "5");
        }
      });

      singleFormTotalSplkWlkAlerts.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val("function_red_state");
          // set filters
          table.setFilter([
            {
              field: "object_state",
              type: "in",
              value: ["red", "orange", "blue"],
            },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on enabled entities in alert (red, orange, blue).",
            "5"
          );
        }
      });

      // Drilldown click from single high priority red
      singleFormTotalSplkWlkAlertsHighPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val(
            "function_red_state_high_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "high" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on high priority red entities.",
            "5"
          );
        }
      });

      // Drilldown click from single critical priority red
      singleFormTotalSplkWlkAlertsCriticalPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val(
            "function_red_state_critical_priority"
          );
          // set filters
          table.setFilter([
            { field: "object_state", type: "=", value: "red" },
            { field: "priority", type: "=", value: "critical" },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on critical priority red entities.",
            "5"
          );
        }
      });

      singleFormTotalSplkWlkDisabled.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val("function_disabled");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            { field: "priority", type: "like", value: "" },
            { field: "monitored_state", type: "=", value: "disabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on all disabled entities.",
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkWlkCountByPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();
          // update dropdown
          $("#splk-wlk-table-filter-field").val("alias");
          // set filters
          table.setFilter([
            { field: "object_state", type: "like", value: "" },
            {
              field: "priority",
              type: "like",
              value: e.data["row.priority"],
            },
            { field: "monitored_state", type: "=", value: "enabled" },
          ]);
          // notify
          notify(
            "success",
            "bottom",
            "Filtering on any state monitored entities with priority: " +
              e.data["row.priority"],
            "5"
          );
        }
      });

      // donut drilldown
      DonutSplkWlkCountByStateAndPriority.on("click", function (e) {
        if (e.field !== undefined) {
          e.preventDefault();

          // set clicked_state
          clicked_state = e.data["row.state"];

          if (
            clicked_state === "green" ||
            clicked_state === "blue" ||
            clicked_state === "orange" ||
            clicked_state === "red"
          ) {
            // update dropdown
            $("#splk-wlk-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: clicked_state },
              {
                field: "priority",
                type: "like",
                value: "",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on any priority monitored entities with state: " +
                clicked_state,
              "5"
            );
          } else if (clicked_state === "red - other priority") {
            // update dropdown
            $("#splk-wlk-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "in",
                value: ["low", "medium"],
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on low or medium priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - high priority") {
            // update dropdown
            $("#splk-wlk-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "high",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on high priority monitored entities with state: red",
              "5"
            );
          } else if (clicked_state === "red - critical priority") {
            // update dropdown
            $("#splk-wlk-table-filter-field").val("alias");
            // set filters
            table.setFilter([
              { field: "object_state", type: "=", value: "red" },
              {
                field: "priority",
                type: "=",
                value: "critical",
              },
              { field: "monitored_state", type: "=", value: "enabled" },
            ]);
            // notify
            notify(
              "success",
              "bottom",
              "Filtering on critical priority monitored entities with state: red",
              "5"
            );
          }
        }
      });

      //Update filters on value change
      document
        .getElementById("splk-wlk-table-filter-field")
        .addEventListener("change", updateFilter);
      document
        .getElementById("splk-wlk-table-filter-type")
        .addEventListener("change", updateFilter);

      // Use the globally available debounce function
      var debouncedUpdateFilter = debounce(function () {
        updateFilter();
      }, 600); // 600 ms delay

      // Replace the direct event listener with the debounced version
      valueEl.addEventListener("keyup", debouncedUpdateFilter);

      //Clear filters on "Clear Filters" button click
      document
        .getElementById("splk-wlk-table-filter-clear")
        .addEventListener("click", function () {
          fieldEl.value = "alias";
          typeEl.value = "like";
          valueEl.value = "";
          enabledEl.value = "false";
          table.clearFilter(true);
          table.setFilter("monitored_state", "=", "enabled");
          typeEl.disabled = false;
          valueEl.disabled = false;
          // notify
          notify(
            "success",
            "bottom",
            "Tabulator filters were reset successfully.",
            "5"
          );
        });

      // popup formatter
      var rowPopupFormatter = function (e, row, onRendered) {
        var data = row.getData(),
          container = document.createElement("div"),
          contents =
            "<strong style='font-size:1.2em; color: black;'>Entity Details</strong><br/>";
        contents +=
          "<div style='max-height: 600px; width: 800px; overflow: auto;'><pre><code style='font-size:1.2em;'>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Key information:</h3>";
        contents +=
          "<li><strong>Entity name:</strong> " +
          decodeObject(data.object) +
          "</li>";
        contents +=
          "<li><strong>Entity alias:</strong> " +
          decodeObject(data.alias) +
          "</li>";
        contents +=
          "<li><strong>Entity keyid:</strong> " + data.keyid + "</li>";
        contents += "<li><strong>Priority:</strong> " + data.priority + "</li>";
        contents +=
          "<li><strong>Date and time of last inspection:</strong> " +
          epochToHumanReadable(data.tracker_runtime) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Search Information:</h3>";
        contents +=
          "<li><strong>Application namespace:</strong> " + data.app + "</li>";
        contents += "<li><strong>Owner user:</strong> " + data.user + "</li>";
        contents += "<li><strong>Account:</strong> " + data.account + "</li>";
        contents +=
          "<li><strong>Last execution seen:</strong> " +
          epochToHumanReadable(data.last_seen) +
          "</li>";
        contents +=
          "<h3 style='color: dodgerblue; font-style: italic;'>Status:</h3>";
        contents +=
          "<li><strong>State:</strong> " + data.object_state + "</li>";
        contents +=
          "<li><strong>Acknowledgement state:</strong> " +
          data.ack_state +
          "</li>";
        contents +=
          "<li><strong>Object description:</strong> " +
          data.object_description +
          "</li>";
        contents += "<li><strong>Status:</strong> " + data.status + "</li>";
        contents +=
          "<li><strong>Anomaly reason:</strong> " +
          data.anomaly_reason +
          "</li>";
        contents +=
          "<li><strong>Status description:</strong> " +
          data.status_description +
          "</li>";

        contents += "</ul></div>";

        container.innerHTML = contents;

        return container;
      };

      // popup formatter
      var rowPopupFormatterMetricsDetails = function (e, row, onRendered) {
        const data = row.getData();
        const container = document.createElement("div");

        // Safely unwrap deeply nested JSON
        function safeParse(json) {
          let current = json;
          try {
            while (typeof current === "string") {
              current = JSON.parse(current);
            }
          } catch (err) {}
          return current;
        }

        const parsed = safeParse(data.metrics);
        const prettyJson =
          typeof parsed === "object"
            ? JSON.stringify(parsed, null, 2)
            : String(parsed);

        const contents = `
          <div class="trackme-popup-content" style="
            font-family: Menlo, Consolas, 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4em;
            color: #f8f8f2;
            background-color: #1e1e1e;
            max-height: 500px;
            max-width: 800px;
            min-width: 500px;
            overflow: hidden;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.8);
          ">
            <div class="status-popup-title" style="
              padding: 12px 16px;
              background: #111;
              font-size: 1.2em;
              font-weight: bold;
              border-bottom: 1px solid #333;
              border-radius: 8px 8px 0 0;
              color: #1e90ff;
            ">
              Metrics Details
            </div>
            <div style="
              overflow: auto;
              max-height: 440px;
              padding: 16px;
              word-break: break-word;
              white-space: pre-wrap;
            ">
              <code class="language-json" style="
                display: block;
                white-space: pre-wrap;
                word-break: break-word;
              ">${Prism.highlight(
                prettyJson,
                Prism.languages.json,
                "json"
              )}</code>
            </div>
          </div>
        `;

        container.innerHTML = contents;
        return container;
      };

      // get groupByContext
      var groupByContext = getToken("splk_wlk_tabulator_groupby");

      // Determine if context is an expression or a list of fields
      var isExpression =
        typeof groupByContext === "string" && groupByContext.includes("data.");

      // init group state
      let groupState = {};

      var table = new TabulatorFull(tabulatorElement, {
        pagination: true, //enable pagination
        paginationMode: getToken("pagination_mode"), // pagination mode from parameters
        ajaxURL: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/component/load_component_data"
        ), //set url for ajax request
        ajaxParams: {
          tenant_id: getToken("tenant_id"),
          component: getToken("tk_component"),
          mode_view: getValueFromDropdown("splk-wlk-table-mode"),
          pagination_mode: getToken("pagination_mode"),
        },
        initialFilter: [
          { field: "monitored_state", type: "in", value: ["enabled"] },
        ],
        index: "keyid",
        layout: "fitColumns", //fit columns to width of table
        addRowPos: "top", //when adding a new row, add it to the top of the table
        history: true, //allow undo and redo actions on the table
        paginationSize: getToken("pagination_size"), //pagination size from parameters
        paginationCounter: "rows", //display count of paginated rows in footer
        movableColumns: true, //allow column order to be changed
        resizableRows: true, //allow row order to be changed
        height: "100%", // height
        filterMode: getToken("pagination_mode"), // remote filtering
        groupBy: isExpression
          ? function (data) {
              return tabulatorGroupBy(groupByContext, data);
            }
          : convertCsvToArray(groupByContext),
        groupStartOpen: function (value, count, data, group) {
          const groupField = group.getField();
          const key = groupField + "_" + value;
          // default to open if no previous state
          return groupState[key] !== false;
        },
        initialSort: [
          //set the initial sort order of the data
          { column: "object", dir: "asc" },
        ],

        columns: [
          //tickbox
          {
            formatter: "rowSelection",
            titleFormatter: "rowSelection",
            hozAlign: "center",
            headerSort: false,
            width: 20,
            cellClick: function (e, cell) {
              cell.getRow().toggleSelect();
            },
          },
          {
            //create column group
            title: "Actions",
            columns: [
              // open
              {
                formatter: openIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                cellClick: function (e, cell) {
                  // Open the entity modal
                  showSplkWlkEntityModal(
                    cell.getRow().getData(),
                    "modal_manage_splk_wlk",
                    "modal"
                  );
                },
              },
              // tool
              {
                formatter: toolIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("update_icon_visible"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkWlkEntityModal(
                    cell.getRow().getData(),
                    "modal_modify_splk_wlk_unified",
                    "modal"
                  );
                },
              },
              // cmdb
              {
                formatter: cmdbIcon,
                width: 40,
                hozAlign: "center",
                headerSort: false,
                visible: getToken("cmdb_lookup"),
                cellClick: function (e, cell) {
                  // Open the entity modal modify
                  showSplkWlkEntityModal(
                    cell.getRow().getData(),
                    "modal_cmdb_splk_wlk",
                    "modal"
                  );
                },
              },
            ],
          },
          {
            //create column group
            title: "Identifier/state (click: rename/right click: info)",
            columns: [
              //define the table columns
              {
                title: "keyid",
                field: "keyid",
                visible: false,
              },
              {
                title: "object",
                field: "object",
                visible: false,
              },
              {
                title: "Entity",
                field: "alias",
                contextPopup: rowPopupFormatter, //add click popup to row
                minWidth: getToken("ui_min_object_width"),
                editor: true,
                headerFilter: true,
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_bootstrap"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setBootstrapStatusIcons(status);
                },
              },
              {
                title: "",
                field: "state_icon_code",
                contextPopup: rowPopupFormatterAck, //add click popup to row
                visible: getToken("show_state_icons_emoji"),
                hozAlign: "center",
                width: 60,
                formatter: function (cell, formatterParams) {
                  var status = cell.getValue();
                  return setEmojiStatusIcons(status);
                },
              },
              ,
            ],
          },
          {
            //create column group
            title: "Priority and monitoring state",
            columns: [
              {
                title: "Priority",
                field: "priority",
                width: 110,
                editor: "list",
                editorParams: {
                  values: ["low", "medium", "high", "critical", "pending"],
                },
                headerFilter: "input",
              },
              {
                title: "Monitoring",
                field: "monitored_state",
                width: 110,
                editor: "list",
                editorParams: { values: ["disabled", "enabled"] },
                headerFilter: "input",
              },
            ],
          },
          {
            //create column group
            title: "Status",
            columns: [
              {
                title: "Status",
                field: "status",
                width: 80,
                editor: false,
                headerFilter: true,
              },
              {
                title: "Anomaly reason",
                field: "anomaly_reason",
                width: 210,
                formatter: AnomalyReasonFormatter,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Metrics",
            columns: [
              {
                title: "Metrics summary (24h)",
                field: "metrics",
                width: 200,
                formatter: jsonFormatter,
                contextPopup: rowPopupFormatterMetricsDetails,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            //create column group
            title: "Time information",
            columns: [
              {
                title: "Last time seen",
                field: "last_seen_human",
                width: 150,
                editor: false,
                headerFilter: true,
              },
            ],
          },
          {
            title: "Outliers",
            field: "OutliersIsOk",
            contextPopup: rowPopupFormatterOutliers, //add click popup to row
            hozAlign: "center",
            formatter: "tickCross",
            width: 100,
            visible: getToken("mloutliers_wlk"),
          },
        ],
      });

      // save group state
      function saveGroupState(table) {
        groupState = {}; // reset
        let groups = table.getGroups();
        groups.forEach((group) => {
          let key = group.getField() + "_" + group.getKey();
          groupState[key] = group.isVisible();
        });
      }

      // handle show/hide disabled entities
      function handleShowDisabledEntities() {
        var filterEnabledEl = document.getElementById(
          "splk-wlk-table-filter-enabled"
        ).value;
        if (filterEnabledEl == "true") {
          table.setFilter("monitored_state", "in", ["enabled", "disabled"]);
        } else if (filterEnabledEl == "false") {
          table.setFilter("monitored_state", "in", ["enabled"]);
        }
      }

      // Call it only once the table is built
      table.on("tableBuilt", function () {
        // Get URL and investigate params
        var urlParams = getUrlParamsWithWildcards();
        var paramKeyId = urlParams["keyid"];
        var paramObject = urlParams["object"];
        var paramAlias = urlParams["alias"];
        var paramPriority = urlParams["priority"];

        if (
          paramKeyId !== "*" ||
          paramAlias !== "*" ||
          paramObject !== "*" ||
          paramPriority !== "*"
        ) {
          if (paramKeyId !== "*") {
            $("#splk-wlk-table-filter-field").val("keyid");
            $("#splk-wlk-table-filter-type").val("=");
            $("#splk-wlk-table-filter-value").val(paramKeyId);
            updateFilter();
            currentData = table.searchData("keyid", "=", paramKeyId);
            itemCount = currentData.length;
            if (itemCount == 1) {
              showSplkWlkEntityModal(
                currentData[0],
                "modal_manage_splk_wlk",
                "modal"
              );
            }
          } else if (paramAlias !== "*" || paramObject !== "*") {
            if (paramAlias !== "*") {
              $("#splk-wlk-table-filter-field").val("alias");
              $("#splk-wlk-table-filter-type").val("=");
              $("#splk-wlk-table-filter-value").val(paramAlias);
              updateFilter();
              currentData = table.searchData("alias", "=", paramAlias);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkWlkEntityModal(
                  currentData[0],
                  "modal_manage_splk_wlk",
                  "modal"
                );
              }
            }
            if (paramObject !== "*") {
              $("#splk-wlk-table-filter-field").val("object");
              $("#splk-wlk-table-filter-type").val("=");
              $("#splk-wlk-table-filter-value").val(paramObject);
              updateFilter();
              currentData = table.searchData("object", "=", paramObject);
              itemCount = currentData.length;
              if (itemCount == 1) {
                showSplkWlkEntityModal(
                  currentData[0],
                  "modal_manage_splk_wlk",
                  "modal"
                );
              }
            }
          }
          if (paramPriority !== "*") {
            table.setHeaderFilterValue("priority", paramPriority);
          }
        }

        // create the change listener
        document
          .getElementById("splk-wlk-table-filter-enabled")
          .addEventListener("change", handleShowDisabledEntities);

        // Expand All button
        document
          .getElementById("splk-wlk-table-expand-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = true; // expanded
            });

            table.replaceData(); // triggers groupStartOpen with updated groupState
          });

        // Collapse All button
        document
          .getElementById("splk-wlk-table-collapse-all")
          .addEventListener("click", function () {
            const groups = table.getGroups();
            groupState = {};
            groups.forEach((group) => {
              const key = group.getField() + "_" + group.getKey();
              groupState[key] = false; // collapsed
            });

            table.replaceData();
          });

        // Event listener for "Group by app" button
        document
          .getElementById("splk-wlk-table-update-groupby-app")
          .addEventListener("click", function () {
            table.setGroupBy([["app"]]);
          });

        // Event listener for "Group by user" button
        document
          .getElementById("splk-wlk-table-update-groupby-user")
          .addEventListener("click", function () {
            table.setGroupBy([["user"]]);
          });

        // Event listener for "Group by anomaly" button
        document
          .getElementById("splk-wlk-table-update-groupby-anomaly")
          .addEventListener("click", function () {
            table.setGroupBy([["anomaly_reason"]]);
          });

        // Event listener for "Group by state" button
        document
          .getElementById("splk-wlk-table-update-groupby-state")
          .addEventListener("click", function () {
            table.setGroupBy([["object_state"]]);
          });

        // Event listener for "Group by priority" button
        document
          .getElementById("splk-wlk-table-update-groupby-priority")
          .addEventListener("click", function () {
            table.setGroupBy([["priority"]]);
          });

        // Event listener for "Group by tags" button
        document
          .getElementById("splk-wlk-table-update-groupby-tags")
          .addEventListener("click", function () {
            table.setGroupBy([["tags"]]);
          });

        // Event listener for "Group by default" button
        document
          .getElementById("splk-wlk-table-update-groupby-default")
          .addEventListener("click", function () {
            table.setGroupBy(
              isExpression
                ? function (data) {
                    return tabulatorGroupBy(groupByContext, data);
                  }
                : convertCsvToArray(groupByContext)
            );
          });

        // Event listener for "Download" button
        document
          .getElementById("splk-wlk-table-download")
          .addEventListener("click", function () {
            table.download("csv", "data.csv", { delimiter: "," });
          });

        // Event listener for "Search" button
        document
          .getElementById("splk-wlk-table-search")
          .addEventListener("click", function () {
            href_link =
              "search?q=" +
              encodeURIComponent(
                "| trackmegetcoll tenant_id=" +
                  getToken("tenant_id") +
                  " component=wlk"
              );
            // open in a new Web browser tab this href
            window.open(href_link, "_blank");
          });
      });

      // detect selection
      table.on("rowSelectionChanged", function (data, rows) {
        //rows - array of row components for the selected rows in order of selection
        //data - array of data objects for the selected rows in order of selection
        len = rows.length;
        if (rows.length > 0) {
          $("#splk-wlk-table-bulk").prop("disabled", false);
          splkWlkPauseRefreshInfo();
        } else {
          $("#splk-wlk-table-bulk").prop("disabled", true);
          document.getElementById("splkWlkLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          splkWlkResumeTableRefresh();
        }
      });

      // detect inline edit
      table.on("cellEdited", function (cell) {
        //e - the click event object
        //row - row component
        $("#splk-wlk-table-save").prop("disabled", false);
        $("#splk-wlk-table-cancel").prop("disabled", false);
        splkWlkPauseRefreshInfo();
      });

      // set the timer
      splkWlkRefreshInfo();

      // auto-refresh
      tableRefreshIntervalId = setInterval(function () {
        $("#splk-wlk-table-refresh-hidden").click();
      }, 300000);

      // manual refresh
      $("#splk-wlk-table-refresh")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          notify("info", "bottom", "Please wait while refreshing...", "5");
          table
            .replaceData()
            .then(() => {
              notify(
                "success",
                "bottom",
                "Tabulator was refreshed successfully.",
                "5"
              );
              splkWlkResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // auto hidden refresh
      $("#splk-wlk-table-refresh-hidden")
        .unbind()
        .click(function () {
          saveGroupState(table); // capture before refreshing
          table
            .replaceData()
            .then(() => {
              // refresh the timer
              splkWlkResetRefreshInfo();
            })
            .catch((error) => {
              console.error("Error replacing data:", error);
            });
        });

      // bulk edit
      $("#splk-wlk-table-bulk")
        .unbind()
        .click(function () {
          // get selected rows
          var selectedData = table.getSelectedData();

          // get data according to all filters and store in its array
          var searchData = table.searchData(table.getFilters(true));
          var searchList = [];
          for (var i = 0; i < searchData.length; i++) {
            searchList.push(searchData[i].keyid);
          }

          // loop and create a list of keys ensuring these are parts of the searched entities
          var itemList = [];
          var itemKeys = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (searchList.includes(selectedData[i].keyid)) {
              itemList.push(selectedData[i].object);
              itemKeys.push(selectedData[i].keyid);
            }
          }

          // set a token for later usage
          setToken("splkWlkBulkObjs", itemList.toString());
          setToken("splkWlkBulkIds", itemKeys.toString());

          // count the number of selected entities and add to the bulk edit modal
          itemCount = itemList.length;
          $("#divWlkBulkdCount").html(
            '<h1><span style="color: #a7c7e7;">' +
              itemCount +
              " entities selected currently</span></h1>"
          );

          // open modal
          closeModals();
          $("#modal_entry_bulk_splk_wlk").modal();
        });

      // Function to mark records as modified
      function markRecordAsModified(record) {
        record.modified = true; // Add a property to indicate the record has been modified
      }

      // Example of how you might hook into the Tabulator to mark records as modified
      table.on("cellEdited", function (cell) {
        var row = cell.getRow();
        var data = row.getData();
        markRecordAsModified(data);
      });

      // save inline edit
      $("#splk-wlk-table-save")
        .unbind()
        .click(function () {
          // disable the button
          $(this).prop("disabled", true);

          var selectedData = table.getData("active");
          // loop and create a list of keys
          var itemList = [];
          for (var i = 0; i < selectedData.length; i++) {
            if (selectedData[i].modified) {
              // Only process modified records
              // push to the array
              itemList.push(selectedData[i]);
            }
          }
          // run the rest call
          var tk_tenant_id = getToken("tenant_id");

          // Create the endpoint URL
          var myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/splk_wlk/write/wlk_bulk_edit"
          );

          // Create a dictionary to store the field names and values
          var record = {
            tenant_id: tk_tenant_id,
            json_data: itemList,
          };

          // spinner
          cssloader("Requested action is in progress, please wait...");

          $.ajax({
            url: myendpoint_URl,
            type: "POST",
            async: true,
            contentType: "application/json",
            dataType: "text",
            beforeSend: function (xhr) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined");
            },
            data: JSON.stringify(record),
            success: function (returneddata) {
              // spinner
              cssloaderremove();
              // Run the search again to update the table
              searchSplkWlkMain.startSearch();
              // refresh tabulator
              $("#splk-wlk-table-refresh-hidden").click();
              // notify
              notify(
                "success",
                "bottom",
                "Entities bulk edit was performed successfully.",
                "5"
              );
              // disable the cancel button
              $("#splk-wlk-table-cancel").prop("disabled", true);
              return;
            },
            error: function (xhr, textStatus, error) {
              showErrorModal(
                "modal_generic_error",
                "Oops!",
                xhr,
                textStatus,
                error
              );
            },
          });
        });

      // cancel inline edit
      $("#splk-wlk-table-cancel")
        .unbind()
        .click(function () {
          document.getElementById("splkWlkLastRefresh").innerHTML =
            "auto-refresh will restart shortly";
          // disable the button
          $(this).prop("disabled", true);
          // notify
          notify(
            "info",
            "bottom",
            "Inline changes canceled, refreshing the table.",
            "5"
          );
          // disable the save button
          $("#splk-wlk-table-save").prop("disabled", true);
          // refresh the table
          $("#splk-wlk-table-refresh-hidden").click();
        });

      // priority: create a function to limit code repetition
      function splkWlkBulkPriority(priority) {
        var tk_tenant_id = getToken("tenant_id");
        var splkWlkBulkIds = getToken("splkWlkBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_wlk/write/wlk_update_priority"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-wlk",
          keys_list: splkWlkBulkIds,
          priority: priority,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
            // refresh tabulator
            $("#splk-wlk-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk priority critical
      $("#btn_splk_wlk_bulk_priority_critical")
        .unbind()
        .click(function () {
          splkWlkBulkPriority("critical");
        });

      // bulk priority high
      $("#btn_splk_wlk_bulk_priority_high")
        .unbind()
        .click(function () {
          splkWlkBulkPriority("high");
        });

      // bulk priority medium
      $("#btn_splk_wlk_bulk_priority_medium")
        .unbind()
        .click(function () {
          splkWlkBulkPriority("medium");
        });

      // bulk priority low
      $("#btn_splk_wlk_bulk_priority_low")
        .unbind()
        .click(function () {
          splkWlkBulkPriority("low");
        });

      // priority: create a function to limit code repetition
      function splkWlkBulkAck(action) {
        var tk_tenant_id = getToken("tenant_id");
        var splkWlkBulkObjs = getToken("splkWlkBulkObjs");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL and record
        var myendpoint_URl;
        var record;

        if (action == "enable") {
          // retrieve the Ack second value from html selector id btn_splk_wlk_bulk_priority_enable_ack_days
          var ack_days = $("#btn_splk_wlk_bulk_priority_enable_ack_days").val();
          var ack_second = ack_days * 86400;
          // retrieve the Ack type value from html selector ud btn_splk_wlk_bulk_priority_enable_ack_type
          var ack_type = $("#btn_splk_wlk_bulk_priority_enable_ack_type").val();
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "enable",
            object_category: "splk-wlk",
            object_list: splkWlkBulkObjs,
            ack_period: ack_second,
            ack_type: ack_type,
            ack_source: "user_ack",
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        } else if (action == "disable") {
          myendpoint_URl = getSplunkUrl(
            "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
          );
          record = {
            tenant_id: tk_tenant_id,
            action: "disable",
            object_category: "splk-wlk",
            object_list: splkWlkBulkObjs,
            ack_comment: tk_comment,
            update_comment: tk_comment,
          };
        }

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
            // refresh tabulator
            $("#splk-wlk-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk ack enable
      $("#btn_splk_wlk_bulk_priority_enable_ack")
        .unbind()
        .click(function () {
          splkWlkBulkAck("enable");
        });

      // bulk ack disable
      $("#btn_splk_wlk_bulk_priority_disable_ack")
        .unbind()
        .click(function () {
          splkWlkBulkAck("disable");
        });

      // monitoring: create a function to limit code repetition
      function splkWlkBulkMonitoring(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkWlkBulkIds = getToken("splkWlkBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_wlk/write/wlk_monitoring"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          object_category: "splk-wlk",
          keys_list: splkWlkBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
            // refresh tabulator
            $("#splk-wlk-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_wlk_bulk_enable")
        .unbind()
        .click(function () {
          splkWlkBulkMonitoring("enable");
        });

      // bulk disable
      $("#btn_splk_wlk_bulk_disable")
        .unbind()
        .click(function () {
          splkWlkBulkMonitoring("disable");
        });

      // delete: create a function to limit code repetition
      function splkWlkBulkDelete(actionTarget) {
        var splkWlkBulkIds = getToken("splkWlkBulkIds");
        var tk_tenant_id = getToken("tenant_id");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_wlk/write/wlk_delete"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          keys_list: splkWlkBulkIds,
          deletion_type: actionTarget,
          update_comment: tk_comment,
        };

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Update
            $("#splk-wlk-table-refresh-hidden").click();
            var msg = "Entities bulk edit was performed successfully.";
            notify("success", "bottom", msg, "5");
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk delete temporary
      $("#btn_splk_wlk_bulk_deletion_temporary")
        .unbind()
        .click(function () {
          splkWlkBulkDelete("temporary");
        });

      // bulk delete permanent
      $("#btn_splk_wlk_bulk_deletion_permanent")
        .unbind()
        .click(function () {
          splkWlkBulkDelete("permanent");
        });

      // Outliers detection enablement: create a function to limit code repetition
      function splkWlkBulkOutliers(actionTarget) {
        var tk_tenant_id = getToken("tenant_id");
        var splkWlkBulkIds = getToken("splkWlkBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_action"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "wlk",
          keys_list: splkWlkBulkIds,
          action: actionTarget,
          update_comment: tk_comment,
        };

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
            // refresh tabulator
            $("#splk-wlk-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Outliers bulk actions were requested successfully and will be executed in background.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk enable
      $("#btn_splk_wlk_bulk_outliers_enable")
        .unbind()
        .click(function () {
          splkWlkBulkOutliers("enable");
        });

      // bulk disable
      $("#btn_splk_wlk_bulk_outliers_disable")
        .unbind()
        .click(function () {
          splkWlkBulkOutliers("disable");
        });

      // bulk enable
      $("#btn_splk_wlk_bulk_outliers_reset_status")
        .unbind()
        .click(function () {
          splkWlkBulkOutliers("reset_status");
        });

      // bulk enable
      $("#btn_splk_wlk_bulk_outliers_mltrain")
        .unbind()
        .click(function () {
          splkWlkBulkOutliers("mltrain");
        });

      // bulk enable
      $("#btn_splk_wlk_bulk_outliers_mlmonitor")
        .unbind()
        .click(function () {
          splkWlkBulkOutliers("mlmonitor");
        });

      // Outliers detection rules: create a function to limit code repetition
      function splkWlkBulkOutliersRules(actionField, actionValue) {
        var tk_tenant_id = getToken("tenant_id");
        var splkWlkBulkIds = getToken("splkWlkBulkIds");

        // Retrieve update comment if any
        var tk_comment = getComment("input_splk_wlk_bulk_comment");

        // Create the endpoint URL
        var myendpoint_URl = getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_outliers_engine/write/outliers_bulk_rules_update"
        );

        // Create a dictionary to store the field names and values
        var record = {
          tenant_id: tk_tenant_id,
          component: "wlk",
          keys_list: splkWlkBulkIds,
          update_comment: tk_comment,
        };

        // add the actionField and actionValue
        record[actionField] = actionValue;

        // spinner
        cssloader("Requested action is in progress, please wait...");

        $.ajax({
          url: myendpoint_URl,
          type: "POST",
          async: true,
          contentType: "application/json",
          dataType: "text",
          beforeSend: function (xhr) {
            xhr.overrideMimeType("text/plain; charset=x-user-defined");
          },
          data: JSON.stringify(record),
          success: function (returneddata) {
            // spinner
            cssloaderremove();
            // Run the search again to update the table
            searchSplkWlkMain.startSearch();
            // refresh tabulator
            $("#splk-wlk-table-refresh-hidden").click();
            // notify
            notify(
              "success",
              "bottom",
              "Entities bulk edit rules was performed successfully.",
              "5"
            );
            return;
          },
          error: function (xhr, textStatus, error) {
            showErrorModal(
              "modal_generic_error",
              "Oops!",
              xhr,
              textStatus,
              error
            );
          },
        });
      }

      // bulk kpi_metrics
      $("#btn_splk_wlk_bulk_outliers_kpi_metrics")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_kpi_metrics_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_kpi_metrics_value"
          ).val();
          // set actionField
          var actionField = "kpi_metrics";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk kpi_span
      $("#btn_splk_wlk_bulk_outliers_kpi_span")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_kpi_span_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_kpi_span_value"
          ).val();
          // set actionField
          var actionField = "kpi_span";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk method_calculation
      $("#btn_splk_wlk_bulk_outliers_method_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_method_calculation_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_method_calculation_value"
          ).val();
          // set actionField
          var actionField = "method_calculation";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk period_calculation
      $("#btn_splk_wlk_bulk_outliers_period_calculation")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_period_calculation_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_period_calculation_value"
          ).val();
          // set actionField
          var actionField = "period_calculation";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk time_factor
      $("#btn_splk_wlk_bulk_outliers_time_factor")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_time_factor_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_time_factor_value"
          ).val();
          // set actionField
          var actionField = "time_factor";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_lowerthreshold
      $("#btn_splk_wlk_bulk_outliers_density_lowerthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_density_lowerthreshold_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_density_lowerthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_lowerthreshold";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk density_upperthreshold
      $("#btn_splk_wlk_bulk_outliers_density_upperthreshold")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_density_upperthreshold_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_density_upperthreshold_value"
          ).val();
          // set actionField
          var actionField = "density_upperthreshold";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk auto_correct
      $("#btn_splk_wlk_bulk_outliers_auto_correct")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_auto_correct_value
          var actionValue = $(
            "#btn_splk_wlk_bulk_outliers_auto_correct_value"
          ).val();
          // set actionField
          var actionField = "auto_correct";
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      // bulk custom
      $("#btn_splk_wlk_bulk_outliers_custom")
        .unbind()
        .click(function () {
          // get value from html input id btn_splk_wlk_bulk_outliers_custom_value
          var actionValue = $("#btn_splk_wlk_bulk_outliers_custom_value").val();
          // set actionField from html input id btn_splk_wlk_bulk_outliers_custom_key
          var actionField = $("#btn_splk_wlk_bulk_outliers_custom_key").val();
          splkWlkBulkOutliersRules(actionField, actionValue);
        });

      //
      // end
      //
    }

    // splk-wlk get table
    function getSplkWlkTable() {
      // avoid causing double interval
      clearInterval(splkWlkIntervalId);
      // get data
      splkWlkHandlerTable();
    }

    // splk-wlk refresh timer
    var splkWlkIntervalId;

    function splkWlkRefreshInfo() {
      var myDate = new Date();
      var splkWlkLastRefresh = document.getElementById("splkWlkLastRefresh");
      function updateTime() {
        splkWlkLastRefresh.innerText = moment(myDate).fromNow(); // which returns something like: "2 seconds ago"
      }

      splkWlkIntervalId = setInterval(updateTime, 2000);
    }

    function splkWlkResetRefreshInfo() {
      clearInterval(splkWlkIntervalId);
      // release our intervalID from the variable
      splkWlkIntervalId = null;
      splkWlkRefreshInfo();
    }

    function splkWlkPauseRefreshInfo() {
      clearInterval(splkWlkIntervalId);
      clearInterval(tableRefreshIntervalId);
      // release our intervalID from the variable
      splkWlkIntervalId = null;
      tableRefreshIntervalId = null;
      splkWlkLastRefresh.innerText =
        "auto-refresh table is paused until inline changes are saved or cancelled";
    }

    function splkWlkResumeTableRefresh() {
      if (!tableRefreshIntervalId) {
        tableRefreshIntervalId = setInterval(function () {
          $("#splk-wlk-table-refresh-hidden").click();
        }, 300000);
      }
    }

    // splk-wlk modal entity view

    function showSplkWlkEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      // get tenant_id
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];
      // get entity details
      var tk_keyid = jsonData["keyid"];
      // token is required
      setToken("tk_keyid", tk_keyid);
      var tk_splk_wlk = jsonData["object"];
      setToken("tk_splk_wlk", tk_splk_wlk);
      var tk_object = tk_splk_wlk;
      var tk_alias = jsonData["alias"];
      // token is required
      setToken("tk_object", tk_object);
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_priority = jsonData["priority"];
      // token required for priority audit change
      setToken("tk_priority", tk_priority);
      var tk_status_message_json = jsonData["status_message_json"];
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];
      var tk_object_state = jsonData["object_state"];
      var tk_monitored_state = jsonData["monitored_state"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_wlk_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_wlk_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_wlk_set_threshold_value"
        ).value = "";
      }

      // wdays - hours_range
      var monitoring_wdays = jsonData["monitoring_wdays"];
      setToken("form.tk_input_wdays_wlk", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["monitoring_hours_ranges"];
      setToken("form.tk_input_splk_wlk_hours_ranges", monitoring_hours_ranges);

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // specific to splk-wlk
      var tk_status = jsonData["status"];
      var tk_status_description = jsonData["status_description"];
      var tk_description = jsonData["object_description"];

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divWlkOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divWlkOutliersSimulationInfo").css("display", "none");
        $("#divWlkOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_wlk_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_wlk_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divWlkOutliersInfo").css("display", "inherit");
        $("#child-wlk-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divWlkOutliersSimulationInfo").css("display", "inherit");
        $("#divWlkOutliersSimulationRender").css("display", "none");
        $("#child-wlk-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_wlk_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_wlk_save").prop("disabled", true);
      }

      // pre-fill current priority
      setToken("form.tk_input_splk_wlk_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkWlk").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkWlk").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkWlk").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkWlk").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkWlk").html("");
      }

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      // get entity info
      // Retrieve entity info from REST and set actions
      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_wlk/wlk_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();
          // get from the json response
          document.getElementById("btn_search_splk_wlk").href =
            returneddata["splk_wlk_mctalog_search"];
          //
          document.getElementById("btn_mpreview_splk_wlk").href =
            returneddata["splk_wlk_mpreview"];
          //
          document.getElementById("btn_search_splk_wlk_live_report").href =
            returneddata["splk_wlk_metrics_report"];

          // set search links
          document.getElementById("btn_search_splk_wlk_skipping_events").href =
            returneddata["splk_wlk_scheduler_skipping_search"];

          // set search links
          document.getElementById("btn_search_splk_wlk_scheduler_errors").href =
            returneddata["splk_wlk_scheduler_errors_search"];

          // Set and start the populating search for metrics
          setToken(
            "splk_wlk_metrics_populate_search",
            returneddata["splk_wlk_metrics_populate_search"]
          );
          searchPopulateSplkWlkMetrics.startSearch();
          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage buttons states
      var tk_monitored_state_class;
      if (tk_monitored_state == "enabled") {
        document.getElementById(
          "btn_enable_monitoring_splk_wlk"
        ).disabled = true;
        document.getElementById(
          "btn_disable_monitoring_splk_wlk"
        ).disabled = false;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_wlk"
        ).style.display = "none";
        document.getElementById(
          "btn_disable_monitoring_splk_wlk"
        ).style.display = "inherit";
        tk_monitored_state_class = "title_green";
      } else {
        document.getElementById(
          "btn_enable_monitoring_splk_wlk"
        ).disabled = false;
        document.getElementById(
          "btn_disable_monitoring_splk_wlk"
        ).disabled = true;
        // show/hide accordingly
        document.getElementById(
          "btn_enable_monitoring_splk_wlk"
        ).style.display = "inherit";
        document.getElementById(
          "btn_disable_monitoring_splk_wlk"
        ).style.display = "none";
        tk_monitored_state_class = "title_grey";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_wlk_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_wlk_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_wlk_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_wlk_status_message_class = "status_message_json_red";
      }

      // sla
      var tk_splk_wlk_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_wlk_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_wlk_sla_message_class = "status_message_json_red";
      }

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_wlk").disabled = false;
        $("#btn_ack_splk_wlk").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_wlk").disabled = false;
        $("#btn_ack_splk_wlk").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_wlk").disabled = false;
        $("#btn_ack_splk_wlk").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_wlk").disabled = true;
        $("#btn_ack_splk_wlk").html("Ack alert");
      }

      // replace info panels
      $("#parent-splk-wlk-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_splk_wlk) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-splk-wlk-top-info1").html(
        '<h3>Status: <span style="color: dodgerblue;">' +
          tk_status +
          '<span style="color: dodgerblue;">' +
          '<h3>Status description: <span style="color: dodgerblue;">' +
          truncate(tk_status_description, 200) +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-wlk-top-info2").html(
        '<h3>monitored state:</b> <span class="' +
          tk_monitored_state_class +
          '">' +
          tk_monitored_state +
          "</span></h3>" +
          '<h3>entity state:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></h3>"
      );

      $("#child-splk-wlk-top-info3").html(
        '<h3>latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">'
      );

      $("#child-splk-wlk-top-info4").html(
        '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></h3>" +
          '<h3>Description: <span style="color: dodgerblue;">' +
          truncate(tk_description, 200) +
          "</span></h3>"
      );

      $("#child-splk-wlk-top-docs-tags").html(
        '<h3><span><a id="tags_splk_wlk" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-splk-wlk-status-message").html(
        '<div class="' +
          tk_splk_wlk_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-splk-wlk-sla-message").html(
        '<div class="' +
          tk_splk_wlk_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // Run
      if (
        getToken("userLevel") === "user" &&
        actionTarget.startsWith("modal_modify_")
      ) {
        $("#modal_user_restricted").modal();
      } else {
        if (actionType === "modal") {
          if (actionTarget === "modal_cmdb_splk_wlk") {
            searchCmdbSplkWlk.startSearch();
          }
          $("#" + actionTarget).modal();
        } else if (actionType === "click") {
          $("#" + actionTarget).click();
        }
      }
    }

    // splk-dsm modal entity view

    function showSplkDsmEntityModal(jsonData, actionTarget, actionType) {
      // mainTokens
      var tk_tenant_id = getToken("tenant_id");
      var tk_parent_tenant_id = jsonData["tenant_parent"];
      var tk_keyid = jsonData["keyid"];
      var tk_object = jsonData["object"];
      var tk_object_category = jsonData["object_category"];
      // token is required
      setToken("tk_object_category", tk_object_category);
      var tk_alias = jsonData["alias"];
      var tk_data_index = jsonData["data_index"];
      // token required for operations
      setToken("tk_data_index", tk_data_index);
      var tk_splk_dsmtype = jsonData["data_sourcetype"];
      // token required for operations
      setToken("tk_splk_dsmtype", tk_splk_dsmtype);
      var tk_data_lag_summary = jsonData["lag_summary"];
      var tk_data_last_time_seen_human = jsonData["last_time"];
      var tk_data_last_ingest_human = jsonData["last_ingest"];
      var tk_data_max_lag_allowed = jsonData["data_max_lag_allowed"];
      var tk_data_max_lag_allowed_duration =
        jsonData["data_max_lag_allowed_duration"];
      var tk_data_max_delay_allowed = jsonData["data_max_delay_allowed"];
      var tk_data_max_delay_allowed_duration =
        jsonData["data_max_delay_allowed_duration"];
      // token required for auto lagging
      setToken("tk_data_max_lag_allowed", tk_data_max_lag_allowed);
      setToken("tk_data_max_delay_allowed", tk_data_max_delay_allowed);
      var tk_data_monitored_state = jsonData["monitored_state"];
      var tk_data_override_lagging_class =
        jsonData["data_override_lagging_class"];
      // required for auto lagging
      setToken(
        "tk_data_override_lagging_class",
        tk_data_override_lagging_class
      );
      var tk_object_state = jsonData["object_state"];
      var tk_latest_flip_state = jsonData["latest_flip_state"];
      var tk_latest_flip_time_human = jsonData["latest_flip_time_human"];
      var tk_priority = jsonData["priority"];

      // wdays - hours_range
      var monitoring_wdays = jsonData["data_monitoring_wdays"];
      setToken("form.tk_input_wdays_host", monitoring_wdays);
      var monitoring_hours_ranges = jsonData["data_monitoring_hours_ranges"];
      setToken("form.tk_input_splk_dhm_hours_ranges", monitoring_hours_ranges);

      // doc href
      var tk_doc_link = jsonData["doc_link"];
      var tk_doc_note = jsonData["doc_note"];
      var tk_doc_identity_card_is_global = jsonData["doc_is_global"];

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);
      // token required for tags operations
      setToken("tk_tags", tk_tags);

      // status
      var tk_status_message_json = jsonData["status_message_json"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_dsm_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_dsm_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_dsm_set_threshold_value"
        ).value = "";
      }

      // sla
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];

      var tk_splk_dsm_sla_message_class;
      if (tk_sla_is_breached == 0) {
        tk_splk_dsm_sla_message_class = "status_message_json_green";
      } else if (tk_sla_is_breached == 1) {
        tk_splk_dsm_sla_message_class = "status_message_json_red";
      }

      // required for various purposes
      setToken("tk_keyid", tk_keyid);
      setToken("tk_object", tk_object);
      var tk_object_category = jsonData["object_category"];
      setToken("tk_object_category", tk_object_category);

      // Dynamically manage priority color
      var tk_priority_class;
      if (tk_priority == "low") {
        tk_priority_class = "title_low_priority";
      } else if (tk_priority == "medium") {
        tk_priority_class = "title_medium_priority";
      } else if (tk_priority == "high") {
        tk_priority_class = "title_high_priority";
      } else if (tk_priority == "critical") {
        tk_priority_class = "title_critical_priority";
      } else if (tk_priority == "pending") {
        tk_priority_class = "title_pending_priority";
      }

      // Dynamically manage state color
      var tk_object_state_class;
      var tk_splk_dsm_status_message_class;
      if (tk_object_state == "green") {
        tk_object_state_class = "title_green";
        tk_splk_dsm_status_message_class = "status_message_json_green";
      } else if (tk_object_state == "orange") {
        tk_object_state_class = "title_orange";
        tk_splk_dsm_status_message_class = "status_message_json_orange";
      } else if (tk_object_state == "blue") {
        tk_object_state_class = "title_blue";
        tk_splk_dsm_status_message_class = "status_message_json_blue";
      } else if (tk_object_state == "red") {
        tk_object_state_class = "title_red";
        tk_splk_dsm_status_message_class = "status_message_json_red";
      }

      // Dynamically manage buttons states
      var tk_data_monitored_state_class;
      if (tk_data_monitored_state == "enabled") {
        document.getElementById("btn_enable_monitoring").disabled = true;
        document.getElementById("btn_disable_monitoring").disabled = false;
        // show/hide accordingly
        document.getElementById("btn_enable_monitoring").style.display =
          "inherit";
        document.getElementById("btn_disable_monitoring").style.display =
          "none";
        tk_data_monitored_state_class = "title_green";
      } else {
        document.getElementById("btn_enable_monitoring").disabled = false;
        document.getElementById("btn_disable_monitoring").disabled = true;
        // show/hide accordingly
        document.getElementById("btn_enable_monitoring").style.display = "none";
        document.getElementById("btn_disable_monitoring").style.display =
          "inherit";
        tk_data_monitored_state_class = "title_grey";
      }

      // href docs
      var tk_doc_link_main;
      var tk_doc_modal_target;

      // If the documentation reference has not been set, define the href format
      if (tk_doc_link == "N/A") {
        tk_doc_link_main = "Click here to define a documentation reference";
        tk_doc_modal_target = "define_identity_card";
        // replace the textinput for modification requests
        document.getElementById("input_doc_link").value =
          "link to documentation";
      } else {
        tk_doc_link_main = "Show data source identity card";
        tk_doc_modal_target = "manage_identity_card";
        // replace the textinput for modification requests
        document.getElementById("input_doc_link").value = tk_doc_link;
      }

      if (tk_doc_note == "N/A") {
        tk_doc_link = "No documentation defined.";
        // replace the textarea for modification requests
        document.getElementById("input_doc_note").value = "documentation note";
      } else {
        // replace the textarea for modification requests
        document.getElementById("input_doc_note").value = tk_doc_note;
      }

      // If the identity card info is global, disable the delete card
      var tk_msg_doc_identity_card_is_global;
      if (tk_doc_identity_card_is_global == "True") {
        document.getElementById(
          "btn_delete_manage_identity_card"
        ).disabled = true;
        document.getElementById(
          "btn_modify_manage_identity_card"
        ).disabled = false;
        tk_msg_doc_identity_card_is_global =
          "Information: this is a default identity card configured at the system level, you cannot delete this card but you can create a new card linked to this specific entity.";
      } else {
        document.getElementById(
          "btn_delete_manage_identity_card"
        ).disabled = false;
        document.getElementById(
          "btn_modify_manage_identity_card"
        ).disabled = false;
        tk_msg_doc_identity_card_is_global =
          "Information: this identity card was associated to this entity, you can update or delete this card.";
      }

      // Update the div
      $("#child-data-source-identity-card1").html(
        '<h2 style="font-weight: bold; color: darkslategray;">' +
          tk_doc_note +
          "</h2>"
      );

      $("#child-data-source-identity-card2").html(
        '<a target="_blank" href=' + tk_doc_link + ">" + tk_doc_link + "</a>"
      );

      $("#child-data-source-identity-card3").html(
        "<i>" + tk_msg_doc_identity_card_is_global + "</i>"
      );

      // tags
      var tk_tags_link_main;
      // define the href depending on the tags
      if (tk_tags == "N/A") {
        var tk_tags_link_main = "Click here to define tags";
        var tk_tags_modal_target = "manage_tags";
        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        var tk_json = {
          tags: "No tags defined, click on Update tags to define one or more tags to be associated with this entity.",
        };
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      } else {
        tk_tags_link_main = "Show tags";
        tk_tags_modal_target = "manage_tags";

        // Check if tk_tags is already an array
        if (Array.isArray(tk_tags)) {
          // If tk_tags is already an array, use it directly
          tk_json = {
            tags: tk_tags,
          };
        } else {
          // If tk_tags is not an array, split it into an array
          var tk_tags_list = tk_tags.split(",");
          tk_json = {
            tags: tk_tags_list,
          };
        }

        $("#child-tag-header").html(
          '<h1 style="font-size: 18px;">Tags for entity: ' + tk_object + "</h1>"
        );
        $("#child-tag-content").html(
          '<div class="status_message_json_blue">' +
            '<div><pre class="create-cim-json-rules-preview">' +
            syntaxHighlight(JSON.stringify(tk_json, null, 2)) +
            "</pre></div>" +
            "</div>"
        );
      }

      // Dynamically manage Ack button
      var tk_ack_state = jsonData["ack_state"];
      if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state != "active"
      ) {
        document.getElementById("btn_ack_splk_dsm").disabled = false;
        $("#btn_ack_splk_dsm").html("Ack alert");
      } else if (
        (tk_object_state == "red" ||
          tk_object_state == "orange" ||
          tk_object_state == "blue") &&
        tk_ack_state == "active"
      ) {
        document.getElementById("btn_ack_splk_dsm").disabled = false;
        $("#btn_ack_splk_dsm").html("Manage Ack");
      } else if (tk_ack_state == "active") {
        document.getElementById("btn_ack_splk_dsm").disabled = false;
        $("#btn_ack_splk_dsm").html("Manage Ack");
      } else {
        document.getElementById("btn_ack_splk_dsm").disabled = true;
        $("#btn_ack_splk_dsm").html("Ack alert");
      }

      // replace info panels
      $("#parent-data-source-main").html(
        '<h1><i class="bi bi-display text-primary"></i> Actions for entity: ' +
          decodeObject(tk_object) +
          " (alias: " +
          decodeObject(tk_alias) +
          ")" +
          "</h1>"
      );

      $("#child-data-source-top-info1").html(
        '<h3>Index: <span style="color: dodgerblue;">' +
          tk_data_index +
          "</span></h3>" +
          '<h3>Sourcetype: <span style="color: dodgerblue;">' +
          tk_splk_dsmtype +
          '<span style="color: dodgerblue;">' +
          '<h3>Delay event / latency ingestion: ([D+]HH:MM:SS) <span style="color: dodgerblue;">' +
          tk_data_lag_summary +
          '<span style="color: dodgerblue;">' +
          '<h3>Last time seen: <span style="color: dodgerblue;">' +
          tk_data_last_time_seen_human +
          '<span style="color: dodgerblue;">'
      );

      $("#child-data-source-top-info2").html(
        '<h3>Last ingest: <span style="color: dodgerblue;">' +
          tk_data_last_ingest_human +
          '<span style="color: dodgerblue;">' +
          "</span></h3>" +
          '<h3>Threshold latency ingestion: <span style="color: dodgerblue;">' +
          tk_data_max_lag_allowed +
          " sec (duration: " +
          tk_data_max_lag_allowed_duration +
          ")" +
          "</span></h3>" +
          '<h3>Threshold events delay: <span style="color: dodgerblue;">' +
          tk_data_max_delay_allowed +
          " sec (duration: " +
          tk_data_max_delay_allowed_duration +
          ")" +
          "</span></h3>" +
          '<h3>Monitored state:</b> <span class="' +
          tk_data_monitored_state_class +
          '">' +
          tk_data_monitored_state +
          "</span></h3>"
      );

      $("#child-data-source-top-info3").html(
        '<h3>Latest flip time: <span style="color: dodgerblue;">' +
          tk_latest_flip_time_human +
          '<span style="color: dodgerblue;">' +
          '<h3>Latest flip state: <span style="color: dodgerblue;">' +
          tk_latest_flip_state +
          '<span style="color: dodgerblue;">' +
          '<h3>State:</b> <span class="' +
          tk_object_state_class +
          '">' +
          tk_object_state +
          "</span></p>" +
          '<h3>Priority:</b> <span class="' +
          tk_priority_class +
          '">' +
          tk_priority +
          "</span></p>"
      );

      $("#child-data-source-top-docs-tags").html(
        '<h3><span><a id="doc_link_splk_dsm" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_doc_modal_target +
          '">' +
          tk_doc_link_main +
          "</a>" +
          " / " +
          '<a id="tags_splk_dsm" data-toggle="modal" data-dismiss="modal" data-target="#' +
          tk_tags_modal_target +
          '">' +
          tk_tags_link_main +
          "</a>" +
          "</span>" +
          "</h3>"
      );

      $("#child-data-source-status-message").html(
        '<div class="' +
          tk_splk_dsm_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_status_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      $("#child-data-source-sla-message").html(
        '<div class="' +
          tk_splk_dsm_sla_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(JSON.stringify(tk_sla_message_json, null, 2)) +
          "</pre></div>" +
          "</div>"
      );

      // data sampling
      var tk_data_sampling_status_message =
        jsonData["data_sample_status_message"];
      var tk_data_sampling_status_colour =
        jsonData["data_sample_status_colour"];
      var tk_data_sampling_status_message_class;
      if (tk_data_sampling_status_colour == "green") {
        var tk_data_sampling_status_message_class = "status_message_json_green";
      } else if (tk_data_sampling_status_colour == "orange") {
        var tk_data_sampling_status_message_class =
          "status_message_json_orange";
      } else if (tk_data_sampling_status_colour == "blue") {
        var tk_data_sampling_status_message_class = "status_message_json_blue";
      } else if (tk_data_sampling_status_colour == "red") {
        var tk_data_sampling_status_message_class = "status_message_json_red";
      } else {
        var tk_data_sampling_status_message_class = "status_message_json_blue";
      }

      // replace the panel
      $("#child-data-source-data-sampling").html(
        '<div class="' +
          tk_data_sampling_status_message_class +
          '">' +
          '<div><pre class="create-cim-json-rules-preview">' +
          syntaxHighlight(
            JSON.stringify(tk_data_sampling_status_message, null, 2)
          ) +
          "</pre></div>" +
          "</div>"
      );

      // status message
      var tk_status_message_json = jsonData["status_message_json"];

      // disruption
      var tk_disruption_min_time_sec = jsonData["disruption_min_time_sec"];
      // if not null and > 0, update the html input modal_input_splk_dsm_set_threshold_value
      if (tk_disruption_min_time_sec && tk_disruption_min_time_sec > 0) {
        document.getElementById(
          "modal_input_splk_dsm_set_threshold_value"
        ).value = tk_disruption_min_time_sec;
      } else {
        document.getElementById(
          "modal_input_splk_dsm_set_threshold_value"
        ).value = "";
      }

      // sla message
      var tk_sla_is_breached = jsonData["sla_is_breached"];
      var tk_sla_message_json = jsonData["sla_message_json"];

      // dcount hosts
      setToken(
        "form.tk_input_splk_dsm_dcount_host",
        jsonData["min_dcount_host"]
      );

      setToken(
        "form.tk_input_splk_dsm_dcount_field",
        jsonData["min_dcount_field"]
      );

      // outlier
      var tk_outliers_readiness = jsonData["outliers_readiness"];
      setToken("tk_outliers_readiness", tk_outliers_readiness);

      if (tk_outliers_readiness === "True") {
        // Outliers render
        $("#divDsmOutliersInfo").css("display", "none");
        // Outliers settings
        $("#divDsmOutliersSimulationInfo").css("display", "none");
        $("#divDsmOutliersSimulationRender").css("display", "inherit");
        $("#btn_outlier_config_splk_dsm_simulate").prop("disabled", false);
        $("#btn_outlier_config_splk_dsm_save").prop("disabled", false);
        //
      } else if (tk_outliers_readiness === "False") {
        // Outliers render
        $("#divDsmOutliersInfo").css("display", "inherit");
        $("#child-dsm-outliers-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning Outliers Anomaly Detection is not ready yet for this entity, models need to be trained first or there are no models defined yet . Click on Manage outliers detection to manage it now.</h2></div>'
        );
        // Outliers settings
        $("#divDsmOutliersSimulationInfo").css("display", "inherit");
        $("#divDsmOutliersSimulationRender").css("display", "none");
        $("#child-dsm-outliers-simulation-info").html(
          '<div class="status_message status_message_orange"><h2 style="font-weight: bold; color: darkslategray;">Machine Learning models have not been trained yet for this entity as models need to be trained first, if needed, perform the models settings and click on Train ML models now before you can start any simulation.</h2></div>'
        );
        $("#btn_outlier_config_splk_dsm_simulate").prop("disabled", true);
        $("#btn_outlier_config_splk_dsm_save").prop("disabled", true);
      }

      // doc href
      var tk_doc_link = jsonData["doc_link"];
      var tk_doc_note = jsonData["doc_note"];
      var tk_doc_identity_card_is_global =
        jsonData["doc_identity_card_is_global"];

      // tags
      var tk_tags = jsonData["tags"];
      var tk_tags_manual = jsonData["tags_manual"];
      setTagsFromCSV(tk_tags_manual);

      // pre-fill current lagging input
      setToken("form.tk_input_lag", jsonData["data_max_lag_allowed"]);
      setToken(
        "form.tk_input_splk_dsm_simulate_latency",
        jsonData["data_max_lag_allowed"]
      );

      // pre-fill current delay input
      setToken("form.tk_input_delay", jsonData["data_max_delay_allowed"]);
      setToken(
        "form.tk_input_splk_dsm_simulate_delay",
        jsonData["data_max_delay_allowed"]
      );

      // pre-fill future tolerance
      setToken("form.tk_input_future_tolerance", jsonData["future_tolerance"]);

      // pre-fill current wdays input
      setToken("form.tk_input_wdays", jsonData["data_monitoring_wdays"]);

      // pre-fill current hours ranges
      setToken(
        "form.tk_input_hours_ranges",
        jsonData["data_monitoring_hours_ranges"]
      );

      // pre-fill current priority
      setToken("form.tk_input_priority", tk_priority);

      // manage priority
      var tk_priority_external = jsonData["priority_external"];
      var tk_priority_policy_id = jsonData["priority_policy_id"];
      var tk_priority_policy_value = jsonData["priority_policy_value"];
      var tk_priority_reason = jsonData["priority_reason"];

      // if the priority is managed by policy:
      if (tk_priority_policy_id) {
        if (tk_priority == tk_priority_policy_value) {
          $("#divInfoPrioritySplkDsm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently managed by policy, and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkDsm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was managed by policy but was since updated manually which overridded the policy. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_policy_value +
              ")</p>"
          );
        }
      } else if (tk_priority_external) {
        if (tk_priority == tk_priority_external) {
          $("#divInfoPrioritySplkDsm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority is currently externally managed and can be overridden here at entity level. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        } else {
          $("#divInfoPrioritySplkDsm").html(
            '<p><i class="bi bi-info-circle icon-state-red"></i> priority was externally managed but was since updated manually which overridded the external priority definition. (' +
              tk_priority_reason +
              ", requested priority: " +
              tk_priority_external +
              ")</p>"
          );
        }
      } else {
        // clear the div content
        $("#divInfoPrioritySplkDsm").html("");
      }

      // pre-fill lagging class override
      setToken(
        "form.modal_input_lag_override_class",
        jsonData["data_override_lagging_class"]
      );

      // pre-fill allow_adaptive_delay
      setToken(
        "form.modal_input_allow_adaptive_delay",
        jsonData["allow_adaptive_delay"]
      );
      // if getToken("adaptive_delay") == 0, set the div id modal_input_allow_adaptive_delay display to none
      if (getToken("adaptive_delay") == 0) {
        document.getElementById(
          "modal_input_allow_adaptive_delay"
        ).style.display = "none";
      }

      // pre-fill alert over kpis
      setToken(
        "form.tk_input_data_lag_alert_kpis",
        jsonData["data_lag_alert_kpis"]
      );

      // get data provider

      // spinner
      cssloader("Requested action is in progress, please wait...");

      // Retrieve entity info from REST and set actions

      // handle replica
      var target_tenant_id = tk_parent_tenant_id || tk_tenant_id;
      if (tk_parent_tenant_id) {
        setToken("tenant_id", target_tenant_id);
      }

      $.ajax({
        url: getSplunkUrl(
          "/splunkd/__raw/services/trackme/v2/splk_dsm/ds_entity_info"
        ),
        type: "POST",
        async: true,
        contentType: "application/json",
        data: JSON.stringify({
          tenant_id: target_tenant_id,
          object_id: tk_keyid,
        }),
        success: function (returneddata) {
          // spinner
          cssloaderremove();

          //
          // get from the json response
          //

          setToken(
            "tk_splk_dsm_overview_root_search",
            returneddata["splk_dsm_overview_root_search"]
          );

          // get the selected data provider
          var splk_dsm_data_provider = getToken(
            "tk_input_splk_dsm_overview_data_provider"
          );

          // get
          var splk_dsm_overview_trackme_single_stats =
            returneddata["splk_dsm_overview_trackme_single_stats"];
          setToken(
            "tk_splk_dsm_overview_trackme_single_stats",
            splk_dsm_overview_trackme_single_stats
          );

          var splk_dsm_overview_trackme_timechart =
            returneddata["splk_dsm_overview_trackme_timechart"];
          setToken(
            "tk_splk_dsm_overview_trackme_timechart",
            splk_dsm_overview_trackme_timechart
          );

          var splk_dsm_overview_splunk_single_stats =
            returneddata["splk_dsm_overview_splunk_single_stats"];
          setToken(
            "tk_splk_dsm_overview_splunk_single_stats",
            splk_dsm_overview_splunk_single_stats
          );

          var splk_dsm_overview_splunk_timechart =
            returneddata["splk_dsm_overview_splunk_timechart"];
          setToken(
            "tk_splk_dsm_overview_splunk_timechart",
            splk_dsm_overview_splunk_timechart
          );

          // set searches dynamically
          if (splk_dsm_data_provider === "trackme") {
            setToken(
              "tk_splk_dsm_overview_single_stats",
              splk_dsm_overview_trackme_single_stats
            );
            setToken(
              "tk_splk_dsm_overview_timechart",
              splk_dsm_overview_trackme_timechart
            );
          } else if (splk_dsm_data_provider === "splunk") {
            setToken(
              "tk_splk_dsm_overview_single_stats",
              splk_dsm_overview_splunk_single_stats
            );
            setToken(
              "tk_splk_dsm_overview_timechart",
              splk_dsm_overview_splunk_timechart
            );
          } else {
            setToken(
              "tk_splk_dsm_overview_single_stats",
              splk_dsm_overview_trackme_single_stats
            );
            setToken(
              "tk_splk_dsm_overview_timechart",
              splk_dsm_overview_trackme_timechart
            );
          }

          var splk_dsm_raw_search = returneddata["splk_dsm_raw_search"];

          // required if an indexed constraint is set the Virtual Tenant level
          var indexed_constraint = getToken("indexed_constraint");

          // if indexed_constraints is set (non empty), add it to the search
          if (indexed_constraint) {
            splk_dsm_raw_search =
              splk_dsm_raw_search.trim() + " " + indexed_constraint;
          }

          // Define the URL target
          document.getElementById("btn_search_splk_dsm").href =
            splk_dsm_raw_search;
          // token is required for dynamic override
          setToken("tk_splk_dsm_raw_search", splk_dsm_raw_search);
          // Run
          if (
            getToken("userLevel") === "user" &&
            actionTarget.startsWith("modal_modify_")
          ) {
            $("#modal_user_restricted").modal();
          } else {
            if (actionType === "modal") {
              // start the CMDB search if requested
              if (actionTarget === "modal_cmdb_splk_dsm") {
                searchCmdbSplkDsm.startSearch();
              }
              $("#" + actionTarget).modal();
            } else if (actionType === "click") {
              $("#" + actionTarget).click();
            }
          }
          //
        },
        error: function (xhr, textStatus, error) {
          showErrorModal(
            "modal_generic_error",
            "Oops!",
            xhr,
            textStatus,
            error
          );
        },
      });

      //
      //
      //
    }

    // Lagging Classes handler
    function laggingClassesHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleLaggingClasses" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Lagging Classes currently</span></h1>"
        );

        var tabulatorElement;
        if (component === "dsmdhm") {
          tabulatorElement = "#" + "dsmdhm-laggingclasses-table";
        } else if (component === "mhm") {
          tabulatorElement = "#" + "mhm-laggingclasses-table";
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 5, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          groupBy: "object_category",
          initialSort: [
            //set the initial sort order of the data
            { column: "name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Name",
              field: "name",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Level (applies to)",
              field: "level",
              editor: "list",
              editorParams: { values: ["sourcetype", "index", "priority"] },
              headerFilter: "input",
            },
            {
              title: "Object (component)",
              field: "object",
              editor: "list",
              editorParams: { values: ["splk-dsm", "splk-dhm", "all"] },
              headerFilter: "input",
            },
            {
              title: "Threshold delay value (seconds)",
              field: "value_delay",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Threshold latency value (seconds)",
              field: "value_lag",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Comment",
              field: "comment",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Created/Updated",
              field: "mtime",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn = "#" + "btn_modal_laggingclasses_" + component + "_save";
        var deleteBtn =
          "#" + "btn_modal_laggingclasses_" + component + "_delete";
        var saveToken = "tk_laggingclasses_" + component + "_update";
        var deleteToken = "tk_laggingclasses_" + component + "_delete";
        var saveConfirmModal =
          "#modal_laggingclasses_" + component + "_confirm_save";
        var deleteConfirmModal =
          "#modal_laggingclasses_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#modify_custom_lagging").modal();
        });
      });
    }

    // Lagging Classes handler
    function laggingClassesMetricsHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleLaggingClasses" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Lagging Classes currently</span></h1>"
        );

        var tabulatorElement;
        if (component === "mhm") {
          tabulatorElement = "#" + "mhm-laggingclasses-table";
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 5, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "metric_category", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "metric_category",
              field: "metric_category",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Threshold value (seconds)",
              field: "metric_max_lag_allowed",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Comment",
              field: "comment",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Created/Updated",
              field: "mtime",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn = "#" + "btn_modal_laggingclasses_" + component + "_save";
        var deleteBtn =
          "#" + "btn_modal_laggingclasses_" + component + "_delete";
        var saveToken = "tk_laggingclasses_" + component + "_update";
        var deleteToken = "tk_laggingclasses_" + component + "_delete";
        var saveConfirmModal =
          "#modal_laggingclasses_" + component + "_confirm_save";
        var deleteConfirmModal =
          "#modal_laggingclasses_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // on table build
        table.on("tableBuilt", function () {
          // Open modal
          $("#modal_metric_lagging_policies").modal();
        });
      });
    }

    // Tags Policies handler
    function tagsPoliciesHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // static component
        var component = "dsm";

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleTagsPolicies" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Tags policies currently</span></h1>"
        );

        var tabulatorElement;
        if (component === "dsm") {
          tabulatorElement = "#" + "dsm-tagspolicies-table";
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "tags_policy_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "tags_policy_id",
              field: "tags_policy_id",
              editor: true,
              headerFilter: true,
            },
            {
              title: "tags_policy_regex",
              field: "tags_policy_regex",
              editor: true,
              headerFilter: true,
            },
            {
              title: "tags_policy_value",
              field: "tags_policy_value",
              editor: true,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn = "#" + "btn_modal_tagspolicies_" + component + "_save";
        var deleteBtn = "#" + "btn_modal_tagspolicies_" + component + "_delete";
        var saveToken = "tk_tagspolicies_" + component + "_update";
        var deleteToken = "tk_tagspolicies_" + component + "_delete";
        var saveConfirmModal =
          "#modal_tagspolicies_" + component + "_confirm_save";
        var deleteConfirmModal =
          "#modal_tagspolicies_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].tags_policy_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          // update href
          var href_tags_policies =
            "search" +
            "?q=" +
            encodeURI(
              "| inputlookup trackme_dsm_tags_tenant_" +
                getToken("tenant_id") +
                " | eval key=_key"
            );
          document.getElementById("href_link_tags_policies_lookup").href =
            href_tags_policies;
          // Open modal
          $("#manage_tags_policies").modal();
        });
      });
    }

    // Priority Policies handler
    function priorityPoliciesHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // static component
        var tk_component = getToken("tk_component");

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitlePriorityPoliciesManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Priority policies currently</span></h1>"
        );

        var tabulatorElement = "#priority-policies-table";
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "priority_policy_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "priority_policy_id",
              field: "priority_policy_id",
              editor: true,
              headerFilter: true,
            },
            {
              title: "priority_policy_regex",
              field: "priority_policy_regex",
              editor: true,
              headerFilter: true,
            },
            {
              title: "priority_policy_value",
              field: "priority_policy_value",
              editor: "list",
              editorParams: {
                values: ["low", "medium", "high", "critical", "pending"],
              },
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn = "#" + "btn_modal_priority_policies_save";
        var deleteBtn = "#" + "btn_modal_priority_policies_delete";
        var saveToken = "tk_priority_policies_update";
        var deleteToken = "tk_priority_policies_delete";
        var saveConfirmModal = "#modal_priority_policies_confirm_save";
        var deleteConfirmModal = "#modal_priority_policies_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].priority_policy_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          // update href
          var href_priority_policies =
            "search" +
            "?q=" +
            encodeURI(
              "| inputlookup trackme_" +
                tk_component +
                "_priority_policies_tenant_" +
                getToken("tenant_id") +
                " | eval key=_key"
            );
          document.getElementById("href_link_priority_policies_lookup").href =
            href_priority_policies;
          // update href
          var href_priority_results =
            "search" +
            "?q=" +
            encodeURI(
              "| inputlookup trackme_" +
                tk_component +
                "_priority_tenant_" +
                getToken("tenant_id") +
                " | eval key=_key"
            );
          document.getElementById("href_link_priority_results_lookup").href =
            href_priority_results;

          // Open modal
          $("#manage_priority_policies").modal();
        });
      });
    }

    // SLA Policies handler
    function slaPoliciesHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // static component
        var tk_component = getToken("tk_component");

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSlaPoliciesManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " SLA policies currently</span></h1>"
        );

        var tabulatorElement = "#sla-policies-table";
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "sla_policy_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "sla_policy_id",
              field: "sla_policy_id",
              editor: true,
              headerFilter: true,
            },
            {
              title: "sla_policy_regex",
              field: "sla_policy_regex",
              editor: true,
              headerFilter: true,
            },
            {
              title: "sla_policy_value",
              field: "sla_policy_value",
              editor: "list",
              editorParams: {
                valuesURL: getSplunkUrl(
                  "/splunkd/__raw/services/trackme/v2/splk_sla_policies/sla_classes_show_list"
                ),
              },
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn = "#" + "btn_modal_sla_policies_save";
        var deleteBtn = "#" + "btn_modal_sla_policies_delete";
        var saveToken = "tk_sla_policies_update";
        var deleteToken = "tk_sla_policies_delete";
        var saveConfirmModal = "#modal_sla_policies_confirm_save";
        var deleteConfirmModal = "#modal_sla_policies_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].sla_policy_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          // update href
          var href_sla_policies =
            "search" +
            "?q=" +
            encodeURI(
              "| inputlookup trackme_" +
                tk_component +
                "_sla_policies_tenant_" +
                getToken("tenant_id") +
                " | eval key=_key"
            );
          document.getElementById("href_link_sla_policies_lookup").href =
            href_sla_policies;
          // update href
          var href_sla_results =
            "search" +
            "?q=" +
            encodeURI(
              "| inputlookup trackme_" +
                tk_component +
                "_sla_tenant_" +
                getToken("tenant_id") +
                " | eval key=_key"
            );
          document.getElementById("href_link_sla_results_lookup").href =
            href_sla_results;

          // Open modal
          $("#manage_sla_policies").modal();
        });
      });
    }

    // Manage Permanently Deleted entities handler
    function permDeletedEntitiesHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitlePermDeletedEntitiesCount").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " entities currently</span></h1>"
        );

        var tabulatorElement = "#perm-deleted-entities-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
              headerFilter: false,
            },
            {
              title: "object_category",
              field: "object_category",
              editor: false,
              headerFilter: false,
            },
            {
              title: "object",
              field: "object",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctime",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_modal_perm_deleted_entities_delete";
        var deleteToken = "tk_perm_deleted";
        var deleteConfirmModal = "#modal_perm_deleted_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#manage_perm_deleted").modal();
        });
      });
    }

    // Manage Logical Groups handler
    function logicalGroupsHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleLogicalGroupsCount").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Logical Group(s) currently</span></h1>"
        );

        var tabulatorElement = "#logical-groups-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object_group_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
              headerFilter: false,
              width: 200,
            },
            {
              title: "Name",
              field: "object_group_name",
              editor: true,
              headerFilter: true,
              width: 200,
            },
            {
              title: "Members",
              field: "object_group_members",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Min green %",
              field: "object_group_min_green_percent",
              editor: "number",
              editorParams: {
                min: 0,
                max: 100,
                step: 0.1,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              width: 150,
              headerFilter: true,
            },
            {
              title: "mtime",
              field: "object_group_mtime_human",
              editor: false,
              headerFilter: true,
              width: 170,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_modal_logical_groups_entities_delete";
        var deleteToken = "tk_logical_groups";
        var deleteConfirmModal = "#modal_logical_groups_confirm_delete";

        var updateBtn = "#btn_modal_logical_groups_entities_update";
        var updateToken = "tk_logical_groups";
        var updateConfirmModal = "#modal_logical_groups_confirm_update";

        var createBtn = "#btn_modal_logical_groups_entities_addnew";
        var createConfirmModal = "#modal_logical_groups_confirm_addnew";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the update button
        $(updateBtn).prop("disabled", true);

        // add
        $(createBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(createConfirmModal).modal();
          });

        // update
        $(updateBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(updateToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(updateConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(updateBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#manage_logical_groups").modal();
        });
      });
    }

    // Manage Ack handler
    function ackHandlerTable(ajaxUrl, ajaxType, ajaxData, openModal) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        var tabulatorElement = "#ack-entities-table";
        // copy resultCall to originalData
        var originalData = JSON.parse(JSON.stringify(resultCall));

        function AnomalyReasonFormatter(cell, formatterParams, onRendered) {
          // get mode
          var cellValue = cell.getValue();
          // if cellValue is an array, return stringify if it has more than 1 element, otherwise return a string with this element
          if (Array.isArray(cellValue)) {
            cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
            if (cellValue.length > 1) {
              return JSON.stringify(cellValue, null, 1);
            } else {
              return cellValue[0];
            }
          } else {
            return cellValue;
          }
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
              headerFilter: false,
              visible: false,
            },
            {
              title: "object",
              field: "object",
              editor: false,
              headerFilter: false,
            },
            {
              title: "ack_mtime",
              field: "ack_mtime_datetime",
              editor: false,
              headerFilter: false,
            },
            {
              title: "ack_expiration",
              field: "ack_expiration_datetime",
              editor: false,
              headerFilter: false,
            },
            {
              title: "ack_source",
              field: "ack_source",
              editor: false,
              headerFilter: false,
            },
            {
              title: "ack_type",
              field: "ack_type",
              headerFilter: false,
              editor: "list",
              editorParams: { values: ["sticky", "unsticky"] },
            },
            {
              title: "anomaly_reason",
              field: "anomaly_reason",
              formatter: AnomalyReasonFormatter,
              width: 210,
              headerFilter: false,
              editor: false,
              headerFilter: false,
            },
            {
              title: "ack_comment",
              field: "ack_comment",
              editor: true,
              headerFilter: false,
            },
            {
              title: "enabled",
              field: "ack_is_enabled",
              headerFilter: false,
              hozAlign: "center",
              formatter: "tickCross",
              width: 100,
              editor: "list",
              editorParams: { values: ["True", "False"] },
            },
          ],
        });

        // Add Ack
        var addBtn = "#btn_modal_ack_add";

        // delete Ack
        var deleteBtn = "#btn_modal_ack_disable";

        // save Ack changes
        var saveBtn = "#btn_modal_ack_save";

        // cancel Ack changes
        var cancelBtn = "#btn_modal_ack_cancel";

        // back button
        var backBtn = "#btn_modal_ack_back";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // disable the inline save button
        $(cancelBtn).prop("disabled", true);

        // In resultCall, get the first record and get the value ack_type, then sent the token value for form.input_ack_type
        if (resultCall.length > 0) {
          var ack_type = resultCall[0].ack_type;
          setToken("form.input_ack_type", ack_type);
        }

        // return to main
        $(backBtn)
          .unbind()
          .click(function () {
            // retrieve token
            var tk_object_category = getToken("tk_object_category");
            // conditional modal target
            if (tk_object_category === "splk-dsm") {
              $("#modal_manage_splk_dsm").modal();
            } else if (tk_object_category === "splk-dhm") {
              $("#modal_manage_splk_dhm").modal();
            } else if (tk_object_category === "splk-mhm") {
              $("#modal_manage_splk_mhm").modal();
            } else if (tk_object_category === "splk-cim") {
              $("#modal_manage_splk_cim").modal();
            } else if (tk_object_category === "splk-flx") {
              $("#modal_manage_splk_flx").modal();
            } else if (tk_object_category === "splk-wlk") {
              $("#modal_manage_splk_wlk").modal();
            }
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            // Create the endpoint URL
            var myendpoint_URl = getSplunkUrl(
              "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
            );

            // Create a dictionary to store the field names and values
            var record = {
              tenant_id: getToken("tenant_id"),
              action: "disable",
              object_category: getToken("tk_object_category"),
              object_list: getToken("tk_object"),
              update_comment: getComment("input_ack_comment"),
            };

            // spinner
            cssloader("Requested action is in progress, please wait...");

            $.ajax({
              url: myendpoint_URl,
              type: "POST",
              async: true,
              contentType: "application/json",
              dataType: "text",
              beforeSend: function (xhr) {
                xhr.overrideMimeType("text/plain; charset=x-user-defined");
              },
              data: JSON.stringify(record),
              success: function (returneddata) {
                // spinner
                cssloaderremove();
                // Refresh the main search
                tk_object_category = getToken("tk_object_category");
                if (tk_object_category == "splk-dsm") {
                  searchSplkDsmMain.startSearch();
                  // refresh tabulator
                  $("#splk-dsm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-cim") {
                  searchSplkCimMain.startSearch();
                  // refresh tabulator
                  $("#splk-cim-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-dhm") {
                  searchSplkDhmMain.startSearch();
                  // refresh tabulator
                  $("#splk-dhm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-mhm") {
                  searchSplkMhmMain.startSearch();
                  // refresh tabulator
                  $("#splk-mhm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-flx") {
                  searchSplkFlxMain.startSearch();
                  // refresh tabulator
                  $("#splk-flx-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-wlk") {
                  searchSplkWlkMain.startSearch();
                  // refresh tabulator
                  $("#splk-wlk-table-refresh-hidden").click();
                }

                // refresh the ack table
                ackHandlerTable(
                  getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/ack/get_ack_for_object"
                  ),
                  "POST",
                  {
                    tenant_id: getToken("tenant_id"),
                    object_category: getToken("tk_object_category"),
                    object_list: getToken("tk_object"),
                  },
                  "false"
                );

                // notify
                notify("success", "bottom", "Ack disabled successfully", "5");
              },
              error: function (xhr, textStatus, error) {
                showErrorModal(
                  "modal_generic_error",
                  "Oops!",
                  xhr,
                  textStatus,
                  error
                );
              },
            });
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
          $(cancelBtn).prop("disabled", false);
        });

        // Open modal
        if (openModal == "true") {
          table.on("tableBuilt", function () {
            $("#confirm_ack").modal();
          });
        }

        // Save inline changes
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // lopp through the records in selectedData, get the value for ack_is_enabled and log
            for (var i = 0; i < selectedData.length; i++) {
              var record_ack_is_enabled = selectedData[i].ack_is_enabled;
              var record_ack_comment = selectedData[i].ack_comment;
              var record_ack_type = selectedData[i].ack_type;
              if (record_ack_type == "N/A") {
                record_ack_type = "unsticky";
              }
              //var record_ack_expiration = selectedData[i].ack_expiration;
              //var record_ack_mtime = selectedData[i].ack_mtime;
              var record_object = selectedData[i].object;
              var record_object_category = selectedData[i].object_category;
              //var record_tenant_id = selectedData[i].tenant_id;
              //var _key = selectedData[i]._key;

              var record_ack_action;
              if (
                record_ack_is_enabled == "True" ||
                record_ack_is_enabled == 1
              ) {
                record_ack_action = "enable";
              } else {
                record_ack_action = "disable";
              }

              // get ack_period, if null set to 86400
              var record_ack_period = getToken("input_ack_duration");
              if (record_ack_period == null) {
                record_ack_period = 86400;
              }

              // get ack_source
              var record_ack_source = selectedData[i].ack_source;

              var record = {
                tenant_id: getToken("tenant_id"),
                action: record_ack_action,
                ack_is_enabled: record_ack_is_enabled,
                object_category: record_object_category,
                object_list: record_object,
                ack_period: record_ack_period,
                ack_type: record_ack_type,
                ack_source: record_ack_source,
                ack_comment: record_ack_comment,
                update_comment: record_ack_comment,
              };

              // Create the endpoint URL
              var myendpoint_URl = getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
              );

              $.ajax({
                url: myendpoint_URl,
                type: "POST",
                async: true,
                contentType: "application/json",
                dataType: "text",
                beforeSend: function (xhr) {
                  xhr.overrideMimeType("text/plain; charset=x-user-defined");
                },
                data: JSON.stringify(record),
                success: function (returneddata) {
                  // spinner
                  cssloaderremove();
                  // Refresh the main search
                  tk_object_category = getToken("tk_object_category");
                  if (tk_object_category == "splk-dsm") {
                    searchSplkDsmMain.startSearch();
                    // refresh tabulator
                    $("#splk-dsm-table-refresh-hidden").click();
                  } else if (tk_object_category == "splk-cim") {
                    searchSplkCimMain.startSearch();
                    // refresh tabulator
                    $("#splk-cim-table-refresh-hidden").click();
                  } else if (tk_object_category == "splk-dhm") {
                    searchSplkDhmMain.startSearch();
                    // refresh tabulator
                    $("#splk-dhm-table-refresh-hidden").click();
                  } else if (tk_object_category == "splk-mhm") {
                    searchSplkMhmMain.startSearch();
                    // refresh tabulator
                    $("#splk-mhm-table-refresh-hidden").click();
                  } else if (tk_object_category == "splk-flx") {
                    searchSplkFlxMain.startSearch();
                    // refresh tabulator
                    $("#splk-flx-table-refresh-hidden").click();
                  } else if (tk_object_category == "splk-wlk") {
                    searchSplkWlkMain.startSearch();
                    // refresh tabulator
                    $("#splk-wlk-table-refresh-hidden").click();
                  }

                  // refresh the ack table
                  ackHandlerTable(
                    getSplunkUrl(
                      "/splunkd/__raw/services/trackme/v2/ack/get_ack_for_object"
                    ),
                    "POST",
                    {
                      tenant_id: getToken("tenant_id"),
                      object_category: getToken("tk_object_category"),
                      object_list: getToken("tk_object"),
                    },
                    "false"
                  );
                },
                error: function (xhr, textStatus, error) {
                  showErrorModal(
                    "modal_generic_error",
                    "Oops!",
                    xhr,
                    textStatus,
                    error
                  );
                },
              });
            }

            // notify
            notify("success", "bottom", "Ack saved successfully", "5");
            $(saveBtn).prop("disabled", true);
            $(cancelBtn).prop("disabled", true);
          });

        // Cancel inline changes
        $(cancelBtn)
          .unbind()
          .click(function () {
            ackHandlerTable(
              getSplunkUrl(
                "/splunkd/__raw/services/trackme/v2/ack/get_ack_for_object"
              ),
              "POST",
              {
                tenant_id: getToken("tenant_id"),
                object_category: getToken("tk_object_category"),
                object_list: getToken("tk_object"),
              },
              "false"
            );

            $(saveBtn).prop("disabled", true);
            $(cancelBtn).prop("disabled", true);
          });

        // Add new Ack
        $(addBtn)
          .unbind()
          .click(function () {
            // Create the endpoint URL
            var myendpoint_URl = getSplunkUrl(
              "/splunkd/__raw/services/trackme/v2/ack/ack_manage"
            );

            // get ack_period, if null set to 86400
            var record_ack_period = getToken("input_ack_duration");
            if (record_ack_period == null) {
              record_ack_period = 86400;
            }

            // get ack_type, if null set to unsticky
            var record_ack_type = getToken("input_ack_type");
            if (record_ack_type == null) {
              record_ack_type = "unsticky";
            }

            // Create a dictionary to store the field names and values
            var record = {
              tenant_id: getToken("tenant_id"),
              action: "enable",
              object_category: getToken("tk_object_category"),
              object_list: getToken("tk_object"),
              ack_period: record_ack_period,
              ack_type: record_ack_type,
              ack_source: "user_ack",
              update_comment: getComment("input_ack_comment"),
            };

            // spinner
            cssloader("Requested action is in progress, please wait...");

            $.ajax({
              url: myendpoint_URl,
              type: "POST",
              async: true,
              contentType: "application/json",
              dataType: "text",
              beforeSend: function (xhr) {
                xhr.overrideMimeType("text/plain; charset=x-user-defined");
              },
              data: JSON.stringify(record),
              success: function (returneddata) {
                // spinner
                cssloaderremove();
                // Refresh the main search
                tk_object_category = getToken("tk_object_category");
                if (tk_object_category == "splk-dsm") {
                  searchSplkDsmMain.startSearch();
                  // refresh tabulator
                  $("#splk-dsm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-cim") {
                  searchSplkCimMain.startSearch();
                  // refresh tabulator
                  $("#splk-cim-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-dhm") {
                  searchSplkDhmMain.startSearch();
                  // refresh tabulator
                  $("#splk-dhm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-mhm") {
                  searchSplkMhmMain.startSearch();
                  // refresh tabulator
                  $("#splk-mhm-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-flx") {
                  searchSplkFlxMain.startSearch();
                  // refresh tabulator
                  $("#splk-flx-table-refresh-hidden").click();
                } else if (tk_object_category == "splk-wlk") {
                  searchSplkWlkMain.startSearch();
                  // refresh tabulator
                  $("#splk-wlk-table-refresh-hidden").click();
                }

                // refresh the ack table
                ackHandlerTable(
                  getSplunkUrl(
                    "/splunkd/__raw/services/trackme/v2/ack/get_ack_for_object"
                  ),
                  "POST",
                  {
                    tenant_id: getToken("tenant_id"),
                    object_category: getToken("tk_object_category"),
                    object_list: getToken("tk_object"),
                  },
                  "false"
                );

                // notify
                notify("success", "bottom", "Ack added successfully", "5");
              },
              error: function (xhr, textStatus, error) {
                showErrorModal(
                  "modal_generic_error",
                  "Oops!",
                  xhr,
                  textStatus,
                  error
                );
              },
            });
          });
      });
    }

    // Data sampling out of the box handler
    function dataSamplingHandlerootbModelsTable(ajaxUrl, ajaxType) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, {}).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleDataSamplingModelsOotbInfo").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Data sampling out of the box models</span></h1>"
        );

        var tabulatorElement = "#dsm-datasampling-ootb-models-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 10 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_order", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "model_id",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "model_name",
              field: "model_name",
              editor: false,
              headerFilter: true,
            },
            {
              title: "model_regex",
              field: "model_regex",
              editor: false,
              headerFilter: true,
            },
            {
              title: "model_type",
              field: "model_type",
              visible: false,
            },
            {
              title: "sourcetype_scope",
              field: "sourcetype_scope",
              visible: false,
            },
          ],
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#data_sampling_show_ootb_rules").modal();
        });
      });
    }

    // Data sampling custom model handler
    function dataSamplingHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // static component
        var component = "dsm";

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleDataSamplingModels" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Data sampling custom models currently</span></h1>"
        );

        var tabulatorElement;
        if (component === "dsm") {
          tabulatorElement = "#" + "dsm-datasamplingmodels-table";
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "model_id",
              field: "model_id",
              editor: true,
              headerFilter: true,
            },
            {
              title: "model_name",
              field: "model_name",
              editor: true,
              headerFilter: true,
            },
            {
              title: "model_regex",
              field: "model_regex",
              editor: true,
              headerFilter: true,
            },
            {
              title: "model_type",
              field: "model_type",
              editor: "list",
              editorParams: { values: ["inclusive", "exclusive"] },
              headerFilter: "input",
            },
            {
              title: "sourcetype_scope",
              field: "sourcetype_scope",
              editor: true,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var saveBtn =
          "#" + "btn_modal_datasamplingmodels_" + component + "_save";
        var deleteBtn =
          "#" + "btn_modal_datasamplingmodels_" + component + "_delete";
        var saveToken = "tk_datasamplingmodels_" + component + "_update";
        var deleteToken = "tk_datasamplingmodels_" + component + "_delete";
        var saveConfirmModal =
          "#modal_datasamplingmodels_" + component + "_confirm_save";
        var deleteConfirmModal =
          "#modal_datasamplingmodels_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#data_sampling_show_custom_rules").modal();
        });
      });
    }

    // blocklist handler
    function blockListHandlerTable(ajaxUrl, ajaxType, ajaxData, component) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleBlockList" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Blocklist(s) currently</span></h1>"
        );

        var tabulatorElement;
        if (component === "dsm") {
          tabulatorElement = "#" + "dsm-blocklist-table";
        } else if (component === "dhm") {
          tabulatorElement = "#" + "dhm-blocklist-table";
        } else if (component === "mhm") {
          tabulatorElement = "#" + "mhm-blocklist-table";
        } else if (component === "flx") {
          tabulatorElement = "#" + "flx-blocklist-table";
        } else if (component === "fqm") {
          tabulatorElement = "#" + "fqm-blocklist-table";
        } else if (component === "wlk") {
          tabulatorElement = "#" + "wlk-blocklist-table";
        } else if (component === "fqm") {
          tabulatorElement = "#" + "fqm-blocklist-table";
        }

        // create a function which returns the list of valid choices for the input object
        // if the component is dsm or dhm: alias, object, index, sourcetype
        // if the component is mhm: alias, object, index, metric_category
        function getValidChoices(component) {
          if (component === "dsm" || component === "dhm") {
            return ["alias", "object", "index", "sourcetype"];
          } else if (component === "mhm") {
            return ["alias", "object", "index", "metric_category"];
          } else {
            return ["alias", "object"];
          }
        }

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          groupBy: "object_category",
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
            },
            {
              title: "Object category",
              field: "object_category",
              editor: "list",
              editorParams: { values: getValidChoices(component) },
              headerFilter: true,
            },
            {
              title: "Value",
              field: "object",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Action",
              field: "action",
              visible: false,
              editor: false,
              headerFilter: false,
            },
            {
              title: "Is regular expression based",
              field: "is_rex",
              editor: "list",
              editorParams: { values: ["true", "false"] },
              headerFilter: "input",
            },
            {
              title: "Comment",
              field: "comment",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Created/Updated",
              field: "mtime",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var addBtn = "#" + "btn_modal_blocklist_" + component + "_add";
        var saveBtn = "#" + "btn_modal_blocklist_" + component + "_save";
        var deleteBtn = "#" + "btn_modal_blocklist_" + component + "_delete";
        var saveToken = "tk_blocklist_" + component + "_update";
        var deleteToken = "tk_blocklist_" + component + "_delete";
        var addConfirmModal = "#modal_blocklist_" + component + "_confirm_add";
        var saveConfirmModal =
          "#modal_blocklist_" + component + "_confirm_save";
        var deleteConfirmModal =
          "#modal_blocklist_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          if (component === "dsm") {
            $("#modal_dsm_blocklist_handler").modal();
          } else if (component === "dhm") {
            $("#modal_dhm_blocklist_handler").modal();
          } else if (component === "mhm") {
            $("#modal_mhm_blocklist_handler").modal();
          } else if (component === "flx") {
            $("#modal_flx_blocklist_handler").modal();
          } else if (component === "fqm") {
            $("#modal_fqm_blocklist_handler").modal();
          } else if (component === "wlk") {
            $("#modal_wlk_blocklist_handler").modal();
          } else if (component === "fqm") {
            $("#modal_fqm_blocklist_handler").modal();
          }
        });
      });
    }

    // Drilldown searches handler for splk-flx
    function drilldownSearchesHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleFlxDrilldownSearches").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Definition(s) currently</span></h1>"
        );

        var tabulatorElement = "#flx-drilldown-searches-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "tracker_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
              visible: false,
            },
            {
              title: "Tracker name",
              field: "tracker_name",
              editor: true,
              headerFilter: true,
              maxWidth: 300,
            },
            {
              title: "Drilldown search",
              field: "drilldown_search",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Drilldown search earliest",
              field: "drilldown_search_earliest",
              editor: true,
              headerFilter: true,
              maxWidth: 150,
            },
            {
              title: "Drilldown search latest",
              field: "drilldown_search_latest",
              editor: true,
              headerFilter: true,
              maxWidth: 150,
            },
          ],
        });

        // actions per component
        var addBtn = "#btn_flx_drilldown_searches_add";
        var saveBtn = "#btn_flx_drilldown_searches_save";
        var deleteBtn = "#btn_flx_drilldown_searches_delete";
        var saveToken = "tk_drilldown_searches_update";
        var deleteToken = "tk_drilldown_searches_delete";
        var addConfirmModal = "#modal_splk_flx_drilldown_searches_confirm_add";
        var saveConfirmModal =
          "#modal_splk_flx_drilldown_searches_confirm_save";
        var deleteConfirmModal =
          "#modal_splk_flx_drilldown_searches_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          // start populating search
          searchFlxManageDrilldownSearchesSelectTracker.startSearch();
          $("#modal_splk_flx_manage_drilldown_searches").modal();
        });
      });
    }

    // Default metrics handler for splk-flx
    function defaultMetricsHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleFlxDefaultMetrics").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Definition(s) currently</span></h1>"
        );

        var tabulatorElement = "#flx-default-metrics-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "tracker_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "_key",
              field: "_key",
              editor: false,
              visible: false,
            },
            {
              title: "Tracker name",
              field: "tracker_name",
              editor: true,
              headerFilter: true,
            },
            {
              title: "Metric name",
              field: "metric_name",
              editor: true,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var addBtn = "#btn_flx_default_metrics_add";
        var saveBtn = "#btn_flx_default_metrics_save";
        var deleteBtn = "#btn_flx_default_metrics_delete";
        var saveToken = "tk_default_metrics_update";
        var deleteToken = "tk_default_metrics_delete";
        var addConfirmModal = "#modal_splk_flx_default_metrics_confirm_add";
        var saveConfirmModal = "#modal_splk_flx_default_metrics_confirm_save";
        var deleteConfirmModal =
          "#modal_splk_flx_default_metrics_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i]._key);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          // start populating search
          searchFlxManageDefaultMetricsSelectTracker.startSearch();
          $("#modal_splk_flx_manage_default_metrics").modal();
        });
      });
    }

    // CIM tracking handler
    function cimTrackingHandlerTable(ajaxUrl, ajaxType, ajaxData, component) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleCimManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " CIM tracker(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#cim-table";

        var openIcon = function (cell, formatterParams) {
          return "<i class='bi bi-box-arrow-up-right'></i>";
        };

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            {
              title: "Reports",
              formatter: openIcon,
              width: 80,
              hozAlign: "center",
              headerSort: false,
              cellClick: function (e, cell) {
                openInSplunkWeb(cell.getRow().getData(), "reports");
              },
            },
            //define the table columns
            {
              title: "account",
              field: "account",
              editor: false,
              headerFilter: true,
              width: 120,
            },
            {
              title: "object",
              field: "object",
              editor: false,
              headerFilter: true,
            },
            {
              title: "tracker_name",
              field: "tracker_name",
              editor: false,
              headerFilter: true,
            },
            {
              title: "priority",
              field: "priority",
              editor: "list",
              editorParams: {
                values: ["low", "medium", "high", "critical", "pending"],
              },
              headerFilter: "input",
              width: 120,
            },
            {
              title: "monitored_state",
              field: "monitored_state",
              editor: "list",
              editorParams: { values: ["enabled", "disabled"] },
              headerFilter: "input",
              width: 120,
            },
          ],
        });

        // Open in Splunk Web function
        function openInSplunkWeb(jsonData, typeObj) {
          // Define the target URL
          var tracker_name = jsonData["tracker_name"];
          var splunkweb_url;
          if (typeObj === "reports") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/saved/searches?app=trackme&count=10&offset=0&itemType=&owner=*&search="
              ) + tracker_name;
          } else if (typeObj === "macros") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/data/macros?ns=trackme&app_only=1&pwnr=*&search="
              ) + tracker_name;
          }
          var target_url =
            location.protocol +
            "//" +
            location.hostname +
            (location.port ? ":" + location.port : "") +
            splunkweb_url;
          // Open the target url in a new tab
          window.open(target_url, "_blank");
        }

        // actions per component
        var deleteBtn = "#" + "btn_modal_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var saveBtn = "#" + "btn_modal_" + component + "_save";
        var saveToken = "tk_" + component + "_update";
        var saveConfirmModal = "#modal_" + component + "_confirm_save";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var selectedEntity = selectedData[i].object;
              var selectedPriority = selectedData[i].priority;
              var selectedMonitoredState = selectedData[i].monitored_state;

              var subDict = {
                object: selectedEntity,
                priority: selectedPriority,
                monitored_state: selectedMonitoredState,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].object);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#modify_cim_trackers").modal();
        });
      });
    }

    //
    // splk-wlk
    //

    // Apps management handler
    function splkWlkAppsManageTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // static component
        var component = "wlk";

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleWlkAppsManagement").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Apps policies currently</span></h1>"
        );

        var tabulatorElement;
        tabulatorElement = "#wlk-apps-management-table";

        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 5 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "app", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "app",
              field: "app",
              editor: true,
              headerFilter: true,
            },
            {
              title: "enabled",
              field: "enabled",
              hozAlign: "center",
              formatter: "tickCross",
              editor: "list",
              editorParams: { values: ["True", "False"] },
              headerFilter: false,
              headerSort: false,
            },
          ],
        });

        // actions per component
        var saveBtn = "#btn_modal_wlk_apps_management_save";
        var deleteBtn = "#btn_modal_wlk_apps_management_delete";
        var saveToken = "tk_wlk_apps_management_update";
        var deleteToken = "tk_wlk_apps_management_delete";
        var saveConfirmModal = "#modal_wlk_apps_enablement_confirm_save";
        var deleteConfirmModal = "#modal_wlk_apps_enablement_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");
            setToken(saveToken, JSON.stringify(selectedData));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].app);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#manage_wlk_apps_enablement").modal();
        });
      });
    }

    //
    // replica tracking handler
    //

    function replicaTrackingHandlerTable(ajaxUrl, ajaxType, ajaxData) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;

        $("#divTitleReplicaManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " replica tracker(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#replica-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "tracker_name",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "tracker_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "tracker_name",
              field: "tracker_name",
              editor: false,
              headerFilter: true,
            },
            {
              title: "knowledge_objects",
              field: "knowledge_objects",
              editor: false,
              headerFilter: false,
              formatter: "textarea",
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_modal_replica_delete";
        var deleteToken = "tk_replica_delete";
        var deleteConfirmModal = "#modal_replica_confirm_delete";
        var saveBtn = "#btn_modal_replica_save";
        var saveToken = "tk_replica_update";
        var saveConfirmModal = "#modal_replica_confirm_save";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var selectedEntity = selectedData[i].object;
              var selectedPriority = selectedData[i].priority;
              var selectedMonitoredState = selectedData[i].monitored_state;

              var subDict = {
                object: selectedEntity,
                priority: selectedPriority,
                monitored_state: selectedMonitoredState,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].tracker_name);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#manage_replica_trackers").modal();
        });
      });
    }

    //
    // hybrid tracking handler
    //

    // dsm

    function hybridTrackingHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;

        var divTitleInfo;
        if (component === "dsm") {
          divTitleInfo = "divTitleHybridDsmManage";
          macroLinkVisible = true;
        } else if (component === "dhm") {
          divTitleInfo = "divTitleHybridDhmManage";
          macroLinkVisible = true;
        } else if (component === "mhm") {
          divTitleInfo = "divTitleHybridMhmManage";
          macroLinkVisible = true;
        } else if (component === "flx") {
          divTitleInfo = "divTitleHybridFlxManage";
          macroLinkVisible = false;
        } else if (component === "wlk") {
          divTitleInfo = "divTitleHybridWlkManage";
          macroLinkVisible = false;
        } else if (component === "fqm") {
          divTitleInfo = "divTitleHybridFqmManage";
          macroLinkVisible = false;
        }

        $("#" + divTitleInfo).html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " hybrid tracker(s) currently</span></h1>"
        );

        // json formatter
        function jsonFormatter(cell, formatterParams, onRendered) {
          cell.getElement().style.whiteSpace = "pre-wrap"; //allow cell to take up multiple lines of text
          return JSON.stringify(cell.getValue(), null, 4); //return JSON formatted cell
        }

        var openIcon = function (cell, formatterParams) {
          return "<i class='bi bi-box-arrow-up-right'></i>";
        };

        // the element
        var tabulatorElement = "#hybrid-" + component + "-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "tracker_name",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "tracker_name", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            {
              title: "Reports",
              formatter: openIcon,
              width: 80,
              hozAlign: "center",
              headerSort: false,
              cellClick: function (e, cell) {
                openInSplunkWeb(cell.getRow().getData(), "reports");
              },
            },
            {
              title: "Macro",
              formatter: openIcon,
              width: 80,
              hozAlign: "center",
              headerSort: false,
              cellClick: function (e, cell) {
                openInSplunkWeb(cell.getRow().getData(), "macros");
              },
              visible: macroLinkVisible,
            },
            //define the table columns
            {
              title: "tracker_name",
              field: "tracker_name",
              width: 300,
              editor: false,
              headerFilter: true,
            },
            {
              title: "knowledge_objects",
              field: "knowledge_objects",
              editor: false,
              headerFilter: false,
              formatter: jsonFormatter,
            },
          ],
        });

        // Open in Splunk Web function
        function openInSplunkWeb(jsonData, typeObj) {
          // Define the target URL
          var tracker_name = jsonData["tracker_name"];
          var splunkweb_url;
          if (typeObj === "reports") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/saved/searches?app=trackme&count=10&offset=0&itemType=&owner=*&search="
              ) + tracker_name;
          } else if (typeObj === "macros") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/data/macros?ns=trackme&app_only=1&pwnr=*&search="
              ) + tracker_name;
          }
          var target_url =
            location.protocol +
            "//" +
            location.hostname +
            (location.port ? ":" + location.port : "") +
            splunkweb_url;
          // Open the target url in a new tab
          window.open(target_url, "_blank");
        }

        // actions per component
        var deleteBtn = "#" + "btn_modal_hybrid_" + component + "_delete";
        var deleteToken = "tk_hybrid_" + component + "_delete";
        var deleteConfirmModal =
          "#modal_hybrid_" + component + "_confirm_delete";
        var saveBtn = "#" + "btn_modal_hybrid_" + component + "_save";
        var saveToken = "tk_hybrid_" + component + "_update";
        var saveConfirmModal = "#modal_hybrid_" + component + "_confirm_save";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var selectedEntity = selectedData[i].object;
              var selectedPriority = selectedData[i].priority;
              var selectedMonitoredState = selectedData[i].monitored_state;

              var subDict = {
                object: selectedEntity,
                priority: selectedPriority,
                monitored_state: selectedMonitoredState,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].tracker_name);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });

        // Open modal
        table.on("tableBuilt", function () {
          if (component === "dsm") {
            $("#manage_hybrid_trackers_dsm").modal();
          } else if (component === "dhm") {
            $("#manage_hybrid_trackers_dhm").modal();
          } else if (component === "mhm") {
            $("#manage_hybrid_trackers_mhm").modal();
          } else if (component === "flx") {
            $("#manage_hybrid_trackers_flx").modal();
          } else if (component === "wlk") {
            $("#manage_hybrid_trackers_wlk").modal();
          } else if (component === "fqm") {
            $("#manage_hybrid_trackers_fqm").modal();
          }
        });
      });
    }

    // Shared Elastic Source tracking handler
    function elasticSharedHandlerTable(ajaxUrl, ajaxType, ajaxData, component) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitle" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Elastic Source(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#elasticshared-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "object",
              field: "object",
              editor: false,
              headerFilter: true,
            },
            {
              title: "search_mode",
              field: "search_mode",
              editor: false,
              headerFilter: true,
            },
            {
              title: "search_constraint",
              field: "search_constraint",
              editor: false,
              headerFilter: true,
            },
            {
              title: "elastic_index",
              field: "elastic_index",
              editor: false,
              headerFilter: true,
            },
            {
              title: "elastic_sourcetype",
              field: "elastic_sourcetype",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#" + "btn_modal_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].object);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#modify_elastic_sources_shared").modal();
        });
      });
    }

    // Dedicated Elastic Source tracking handler
    function elasticDedicatedHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitle" + component + "Manage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Elastic Source(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#elasticdedicated-table";

        //Generate open icon
        var openIcon = function (cell, formatterParams) {
          return "<i class='bi bi-box-arrow-up-right'></i>";
        };

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "_key",
          layout: "fitColumns", //fit columns to width of table
          responsiveLayout: "hide", //hide columns that dont fit on the table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          pagination: "local", //paginate the data
          paginationSize: 7, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "object", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            {
              title: "Reports",
              formatter: openIcon,
              width: 80,
              hozAlign: "center",
              headerSort: false,
              cellClick: function (e, cell) {
                openInSplunkWeb(cell.getRow().getData(), "reports");
              },
            },
            //define the table columns
            {
              title: "elastic_report",
              field: "elastic_report",
              editor: false,
              headerFilter: true,
              minWidth: 350,
            },
            {
              title: "object",
              field: "object",
              editor: false,
              headerFilter: true,
            },
            {
              title: "search_mode",
              field: "search_mode",
              editor: false,
              headerFilter: true,
            },
            {
              title: "search_constraint",
              field: "search_constraint",
              editor: false,
              headerFilter: true,
            },
            {
              title: "elastic_index",
              field: "elastic_index",
              editor: false,
              headerFilter: true,
            },
            {
              title: "elastic_sourcetype",
              field: "elastic_sourcetype",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // Open in Splunk Web function
        function openInSplunkWeb(jsonData, typeObj) {
          // Define the target URL
          var tracker_name = jsonData["elastic_report"];
          var splunkweb_url;
          if (typeObj === "reports") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/saved/searches?app=trackme&count=10&offset=0&itemType=&owner=*&search="
              ) + tracker_name;
          } else if (typeObj === "macros") {
            splunkweb_url =
              getSplunkUrl(
                "/manager/trackme/data/macros?ns=trackme&app_only=1&pwnr=*&search="
              ) + tracker_name;
          }
          var target_url =
            location.protocol +
            "//" +
            location.hostname +
            (location.port ? ":" + location.port : "") +
            splunkweb_url;
          // Open the target url in a new tab
          window.open(target_url, "_blank");
        }

        // actions per component
        var deleteBtn = "#" + "btn_modal_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].object);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // Open modal
        table.on("tableBuilt", function () {
          $("#modify_elastic_sources_dedicated").modal();
        });
      });
    }

    // Outliers anomaly detection splk-dsm handler
    function OutliersAnomalySplkDsmHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // from the first record in resultCall, get the value for confidence and confidence_reason
        if (resultCall.length > 0) {
          var confidence = resultCall[0].confidence;
          var confidence_reason = resultCall[0].confidence_reason;

          if (confidence == "low") {
            $("#divTitleSplkDsmOutliersModelManageMainTitle").html(
              '<h2><span style="color: #ffb347;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          } else {
            $("#divTitleSplkDsmOutliersModelManageMainTitle").html(
              '<h2><span style="color: #45d4ba;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          }
        } else {
          // Handle the case where resultCall is empty
          $("#divTitleSplkDsmOutliersModelManageMainTitle").html(
            '<h2><span style="color: #ffb347">Confidence: Unknown, reason: Pending for model(s) definition</span></h2>'
          );
        }

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkDsmOutliersModelManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Machine Learning Outliers Model(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-dsm-outliers-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitDataStretch", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 2, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: false,
            },
            {
              title: "kpi_metric",
              field: "kpi_metric",
              editor: "list",
              editorParams: {
                values: [
                  "splk.feeds.avg_eventcount_5m",
                  "splk.feeds.latest_eventcount_5m",
                  "splk.feeds.perc95_eventcount_5m",
                  "splk.feeds.stdev_eventcount_5m",
                  "splk.feeds.avg_latency_5m",
                  "splk.feeds.latest_latency_5m",
                  "splk.feeds.perc95_latency_5m",
                  "splk.feeds.stdev_latency_5m",
                  "splk.feeds.avg_dcount_host_5m",
                  "splk.feeds.latest_dcount_host_5m",
                  "splk.feeds.perc95_dcount_host_5m",
                  "splk.feeds.stdev_dcount_host_5m",
                  "splk.feeds.global_dcount_host",
                  "splk.feeds.eventcount_4h",
                  "splk.feeds.hostcount_4h",
                  "splk.feeds.lag_event_sec",
                  "splk.feeds.lag_ingestion_sec",
                ],
              },
              headerFilter: false,
            },
            {
              title: "kpi_span",
              field: "kpi_span",
              editor: "list",
              editorParams: {
                values: [
                  "5m",
                  "10m",
                  "15m",
                  "30m",
                  "1h",
                  "4h",
                  "8h",
                  "12h",
                  "24h",
                ],
              },
              headerFilter: false,
            },
            {
              title: "method_calculation",
              field: "method_calculation",
              editor: "list",
              editorParams: {
                values: [
                  "stdev",
                  "avg",
                  "perc95",
                  "latest",
                  "max",
                  "min",
                  "sum",
                ],
              },
              headerFilter: false,
            },
            {
              title: "period_calculation",
              field: "period_calculation",
              editor: true,
              headerFilter: false,
            },
            {
              title: "period_calculation_latest",
              field: "period_calculation_latest",
              editor: true,
              headerFilter: false,
            },
            {
              title: "time_factor",
              field: "time_factor",
              editor: "list",
              editorParams: {
                values: ["%H", "%H%M", "%w%H", "%w%H%M", "%w", "none"],
              },
              headerFilter: false,
            },
            {
              title: "density_lowerthreshold",
              field: "density_lowerthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "density_upperthreshold",
              field: "density_upperthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "alert_lower_breached",
              field: "alert_lower_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "alert_upper_breached",
              field: "alert_upper_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "auto_correct",
              field: "auto_correct",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "perc_min_lowerbound_deviation",
              field: "perc_min_lowerbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "perc_min_upperbound_deviation",
              field: "perc_min_upperbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_lowerbound_breached",
              field: "min_value_for_lowerbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_upperbound_breached",
              field: "min_value_for_upperbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_lower_threshold",
              field: "static_lower_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_upper_threshold",
              field: "static_upper_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "algorithm",
              field: "algorithm",
              minWidth: 150,
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(rowData.algorithms_list),
                };
              },
              headerFilter: false,
            },
            {
              title: "boundaries_extraction_macro",
              field: "boundaries_extraction_macro",
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(
                    rowData.boundaries_extraction_macros_list
                  ),
                };
              },
              headerFilter: false,
            },
            {
              title: "fit_extra_parameters",
              field: "fit_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "apply_extra_parameters",
              field: "apply_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "is_disabled",
              field: "is_disabled",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var saveBtn = "#btn_" + component + "_save";
        var saveToken = "tk_" + component + "_update";
        var simulateBtn = "#btn_" + component + "_simulate";
        var resetBtn = "#btn_" + component + "_reset";
        var saveConfirmModal = "#modal_" + component + "_confirm_save";
        var resetConfirmModal = "#modal_" + component + "_confirm_reset";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // simulate
        $(simulateBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // get the selected model_id
            var selectedModelId = getToken(
              "tk_input_splk_dsm_outliers_model_id_settings_dropdown"
            );

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: time_factor,
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              // push the model definition if equals to the selectedModelId
              if (model_id === selectedModelId) {
                itemList.push(subDict);
              }
            }

            setToken(saveToken, JSON.stringify(itemList[0]));

            // set the simulation JSON model def
            setToken(
              "tk_splk_dsm_simulation_model_def",
              JSON.stringify(itemList[0]).replace(/\"/g, '\\"')
            );

            // set the token the search depends on
            setToken("start_outliers_simulation_splk_dsm", "true");

            // explicitly start the search
            searchOutlierDetectionSingleDsmSimulation.startSearch();
            searchOutlierDetectionChartSimulationDsm.startSearch();

            //
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: encodeURI(time_factor),
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // reset
        $(resetBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(resetConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].model_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });
      });
    }

    // Outliers anomaly detection splk-flx handler
    function OutliersAnomalySplkFlxHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;

        // from the first record in resultCall, get the value for confidence and confidence_reason
        if (resultCall.length > 0) {
          var confidence = resultCall[0].confidence;
          var confidence_reason = resultCall[0].confidence_reason;

          if (confidence == "low") {
            $("#divTitleSplkFlxOutliersModelManageMainTitle").html(
              '<h2><span style="color: #ffb347;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          } else {
            $("#divTitleSplkFlxOutliersModelManageMainTitle").html(
              '<h2><span style="color: #45d4ba;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          }
        } else {
          // Handle the case where resultCall is empty
          $("#divTitleSplkFlxOutliersModelManageMainTitle").html(
            '<h2><span style="color: #ffb347">Confidence: Unknown, reason: Pending for model(s) definition</span></h2>'
          );
        }

        $("#divTitleSplkFlxOutliersModelManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Machine Learning Outliers Model(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-flx-outliers-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitDataStretch", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 2, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: false,
            },
            {
              title: "kpi_metric",
              field: "kpi_metric",
              editor: true,
              headerFilter: false,
            },
            {
              title: "kpi_span",
              field: "kpi_span",
              editor: "list",
              editorParams: {
                values: [
                  "5m",
                  "10m",
                  "15m",
                  "30m",
                  "1h",
                  "4h",
                  "8h",
                  "12h",
                  "24h",
                ],
              },
              headerFilter: false,
            },
            {
              title: "method_calculation",
              field: "method_calculation",
              editor: "list",
              editorParams: {
                values: [
                  "stdev",
                  "avg",
                  "perc95",
                  "latest",
                  "max",
                  "min",
                  "sum",
                ],
              },
              headerFilter: false,
            },
            {
              title: "period_calculation",
              field: "period_calculation",
              editor: true,
              headerFilter: false,
            },
            {
              title: "period_calculation_latest",
              field: "period_calculation_latest",
              editor: true,
              headerFilter: false,
            },
            {
              title: "time_factor",
              field: "time_factor",
              editor: "list",
              editorParams: {
                values: ["%H", "%H%M", "%w%H", "%w%H%M", "%w", "none"],
              },
              headerFilter: false,
            },
            {
              title: "density_lowerthreshold",
              field: "density_lowerthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "density_upperthreshold",
              field: "density_upperthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "alert_lower_breached",
              field: "alert_lower_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "alert_upper_breached",
              field: "alert_upper_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "auto_correct",
              field: "auto_correct",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "perc_min_lowerbound_deviation",
              field: "perc_min_lowerbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "perc_min_upperbound_deviation",
              field: "perc_min_upperbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_lowerbound_breached",
              field: "min_value_for_lowerbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_upperbound_breached",
              field: "min_value_for_upperbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_lower_threshold",
              field: "static_lower_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_upper_threshold",
              field: "static_upper_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "algorithm",
              field: "algorithm",
              minWidth: 150,
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(rowData.algorithms_list),
                };
              },
              headerFilter: false,
            },
            {
              title: "boundaries_extraction_macro",
              field: "boundaries_extraction_macro",
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(
                    rowData.boundaries_extraction_macros_list
                  ),
                };
              },
              headerFilter: false,
            },
            {
              title: "fit_extra_parameters",
              field: "fit_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "apply_extra_parameters",
              field: "apply_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "is_disabled",
              field: "is_disabled",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var saveBtn = "#btn_" + component + "_save";
        var saveToken = "tk_" + component + "_update";
        var simulateBtn = "#btn_" + component + "_simulate";
        var resetBtn = "#btn_" + component + "_reset";
        var saveConfirmModal = "#modal_" + component + "_confirm_save";
        var resetConfirmModal = "#modal_" + component + "_confirm_reset";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // simulate
        $(simulateBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // get the selected model_id
            var selectedModelId = getToken(
              "tk_input_splk_flx_outliers_model_id_settings_dropdown"
            );

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: time_factor,
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              // push the model definition if equals to the selectedModelId
              if (model_id === selectedModelId) {
                itemList.push(subDict);
              }
            }

            setToken(saveToken, JSON.stringify(itemList[0]));

            // set the simulation JSON model def
            setToken(
              "tk_splk_flx_simulation_model_def",
              JSON.stringify(itemList[0]).replace(/\"/g, '\\"')
            );

            // set the token the search depends on
            setToken("start_outliers_simulation_splk_flx", "true");

            // explicitly start the search
            searchOutlierDetectionSingleFlxSimulation.startSearch();
            searchOutlierDetectionChartSimulationFlx.startSearch();

            //
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: encodeURI(time_factor),
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // reset
        $(resetBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(resetConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].model_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });
      });
    }

    // Outliers anomaly detection splk-fqm handler
    function OutliersAnomalySplkFqmHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;

        // from the first record in resultCall, get the value for confidence and confidence_reason
        if (resultCall.length > 0) {
          var confidence = resultCall[0].confidence;
          var confidence_reason = resultCall[0].confidence_reason;

          if (confidence == "low") {
            $("#divTitleSplkFqmOutliersModelManageMainTitle").html(
              '<h2><span style="color: #ffb347;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          } else {
            $("#divTitleSplkFqmOutliersModelManageMainTitle").html(
              '<h2><span style="color: #45d4ba;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          }
        } else {
          // Handle the case where resultCall is empty
          $("#divTitleSplkFqmOutliersModelManageMainTitle").html(
            '<h2><span style="color: #ffb347">Confidence: Unknown, reason: Pending for model(s) definition</span></h2>'
          );
        }

        $("#divTitleSplkFqmOutliersModelManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Machine Learning Outliers Model(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-fqm-outliers-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitDataStretch", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 2, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: false,
            },
            {
              title: "kpi_metric",
              field: "kpi_metric",
              editor: true,
              headerFilter: false,
            },
            {
              title: "kpi_span",
              field: "kpi_span",
              editor: "list",
              editorParams: {
                values: [
                  "5m",
                  "10m",
                  "15m",
                  "30m",
                  "1h",
                  "4h",
                  "8h",
                  "12h",
                  "24h",
                ],
              },
              headerFilter: false,
            },
            {
              title: "method_calculation",
              field: "method_calculation",
              editor: "list",
              editorParams: {
                values: [
                  "stdev",
                  "avg",
                  "perc95",
                  "latest",
                  "max",
                  "min",
                  "sum",
                ],
              },
              headerFilter: false,
            },
            {
              title: "period_calculation",
              field: "period_calculation",
              editor: true,
              headerFilter: false,
            },
            {
              title: "period_calculation_latest",
              field: "period_calculation_latest",
              editor: true,
              headerFilter: false,
            },
            {
              title: "time_factor",
              field: "time_factor",
              editor: "list",
              editorParams: {
                values: ["%H", "%H%M", "%w%H", "%w%H%M", "%w", "none"],
              },
              headerFilter: false,
            },
            {
              title: "density_lowerthreshold",
              field: "density_lowerthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "density_upperthreshold",
              field: "density_upperthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "alert_lower_breached",
              field: "alert_lower_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "alert_upper_breached",
              field: "alert_upper_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "auto_correct",
              field: "auto_correct",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "perc_min_lowerbound_deviation",
              field: "perc_min_lowerbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "perc_min_upperbound_deviation",
              field: "perc_min_upperbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_lowerbound_breached",
              field: "min_value_for_lowerbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_upperbound_breached",
              field: "min_value_for_upperbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_lower_threshold",
              field: "static_lower_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_upper_threshold",
              field: "static_upper_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "algorithm",
              field: "algorithm",
              minWidth: 150,
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(rowData.algorithms_list),
                };
              },
              headerFilter: false,
            },
            {
              title: "boundaries_extraction_macro",
              field: "boundaries_extraction_macro",
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(
                    rowData.boundaries_extraction_macros_list
                  ),
                };
              },
              headerFilter: false,
            },
            {
              title: "fit_extra_parameters",
              field: "fit_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "apply_extra_parameters",
              field: "apply_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "is_disabled",
              field: "is_disabled",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var saveBtn = "#btn_" + component + "_save";
        var saveToken = "tk_" + component + "_update";
        var simulateBtn = "#btn_" + component + "_simulate";
        var resetBtn = "#btn_" + component + "_reset";
        var saveConfirmModal = "#modal_" + component + "_confirm_save";
        var resetConfirmModal = "#modal_" + component + "_confirm_reset";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // simulate
        $(simulateBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // get the selected model_id
            var selectedModelId = getToken(
              "tk_input_splk_fqm_outliers_model_id_settings_dropdown"
            );

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: time_factor,
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              // push the model definition if equals to the selectedModelId
              if (model_id === selectedModelId) {
                itemList.push(subDict);
              }
            }

            setToken(saveToken, JSON.stringify(itemList[0]));

            // set the simulation JSON model def
            setToken(
              "tk_splk_fqm_simulation_model_def",
              JSON.stringify(itemList[0]).replace(/\"/g, '\\"')
            );

            // set the token the search depends on
            setToken("start_outliers_simulation_splk_fqm", "true");

            // explicitly start the search
            searchOutlierDetectionSingleFqmSimulation.startSearch();
            searchOutlierDetectionChartSimulationFqm.startSearch();

            //
          });

        // update
        $(saveBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              var fit_extra_parameters = selectedData[i].fit_extra_parameters;
              var apply_extra_parameters =
                selectedData[i].apply_extra_parameters;
              var is_disabled = selectedData[i].is_disabled;

              var subDict = {
                model_id: model_id,
                kpi_metric: kpi_metric,
                kpi_span: kpi_span,
                method_calculation: method_calculation,
                period_calculation: period_calculation,
                period_calculation_latest: period_calculation_latest,
                time_factor: encodeURI(time_factor),
                density_lowerthreshold: density_lowerthreshold,
                density_upperthreshold: density_upperthreshold,
                alert_lower_breached: alert_lower_breached,
                alert_upper_breached: alert_upper_breached,
                auto_correct: auto_correct,
                perc_min_lowerbound_deviation: perc_min_lowerbound_deviation,
                perc_min_upperbound_deviation: perc_min_upperbound_deviation,
                min_value_for_lowerbound_breached:
                  min_value_for_lowerbound_breached,
                min_value_for_upperbound_breached:
                  min_value_for_upperbound_breached,
                static_lower_threshold: static_lower_threshold,
                static_upper_threshold: static_upper_threshold,
                algorithm: algorithm,
                boundaries_extraction_macro: boundaries_extraction_macro,
                fit_extra_parameters: fit_extra_parameters,
                apply_extra_parameters: apply_extra_parameters,
                is_disabled: is_disabled,
              };

              itemList.push(subDict);
            }

            setToken(saveToken, JSON.stringify(itemList));
            // open modal
            closeModals();
            $(saveConfirmModal).modal();
          });

        // reset
        $(resetBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(resetConfirmModal).modal();
          });

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].model_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // detect inline edit
        table.on("cellEdited", function (cell) {
          //e - the click event object
          //row - row component
          $(saveBtn).prop("disabled", false);
        });
      });
    }

    // Outliers anomaly detection splk-cim periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkCimHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkCimOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-cim-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_cim_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-flx periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkFlxHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkFlxOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-flx-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_flx_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-fqm periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkFqmHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkFqmOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-fqm-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_fqm_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-dsm periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkDsmHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkDsmOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-dsm-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_dsm_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-dhm periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkDhmHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkDhmOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-dhm-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_dhm_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-wlk periods exclusion handler
    function OutliersAnomalyPeriodsExclusionSplkWlkHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkWlkOutliersModelPeriodsExclusions").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Periods Exclusions configured currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-wlk-outliers-periods-exclusions-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitColumns", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 10, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "ctime", dir: "desc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "period_exclusion_id",
              field: "period_exclusion_id",
              editor: false,
              headerFilter: true,
            },
            {
              title: "earliest",
              field: "earliest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "latest",
              field: "latest_human",
              editor: false,
              headerFilter: true,
            },
            {
              title: "ctim",
              field: "ctime",
              visible: false,
            },
            {
              title: "Creation time",
              field: "ctime_human",
              editor: false,
              headerFilter: true,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var addBtn = "#btn_" + component + "_add";
        var addConfirmModal = "#modal_" + component + "_confirm_add";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // delete
        $(deleteBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getSelectedData();
            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              itemList.push(selectedData[i].period_exclusion_id);
            }
            setToken(deleteToken, itemList.toString());
            // open modal
            closeModals();
            $(deleteConfirmModal).modal();
          });

        // add
        $(addBtn)
          .unbind()
          .click(function () {
            // open modal
            closeModals();
            $(addConfirmModal).modal();
          });

        // detect selection
        table.on("rowSelectionChanged", function (data, rows) {
          //rows - array of row components for the selected rows in order of selection
          //data - array of data objects for the selected rows in order of selection
          len = rows.length;
          if (rows.length > 0) {
            $(deleteBtn).prop("disabled", false);
          } else {
            $(deleteBtn).prop("disabled", true);
          }
        });

        // open modal
        table.on("tableBuilt", function () {
          cssloaderremove();
          $("#splk_wlk_outliers_periods_exclusions").modal();
        });
      });
    }

    // Outliers anomaly detection splk-wlk handler
    function OutliersAnomalySplkWlkHandlerTable(
      ajaxUrl,
      ajaxType,
      ajaxData,
      component
    ) {
      // Run the ajax promise
      var doAsync = asyncAjax(ajaxUrl, ajaxType, ajaxData).then(function (
        resultCall
      ) {
        // from the first record in resultCall, get the value for confidence and confidence_reason
        if (resultCall.length > 0) {
          var confidence = resultCall[0].confidence;
          var confidence_reason = resultCall[0].confidence_reason;

          if (confidence == "low") {
            $("#divTitleSplkWlkOutliersModelManageMainTitle").html(
              '<h2><span style="color: #ffb347;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          } else {
            $("#divTitleSplkWlkOutliersModelManageMainTitle").html(
              '<h2><span style="color: #45d4ba;">Confidence: ' +
                confidence +
                " , reason: " +
                confidence_reason +
                "</span></h2>"
            );
          }
        } else {
          // Handle the case where resultCall is empty
          $("#divTitleSplkWlkOutliersModelManageMainTitle").html(
            '<h2><span style="color: #ffb347">Confidence: Unknown, reason: Pending for model(s) definition</span></h2>'
          );
        }

        // count the number of item in the array and update the title
        var no_items = resultCall.length;
        $("#divTitleSplkWlkOutliersModelManage").html(
          '<h1><span style="color: #a7c7e7;">' +
            no_items +
            " Machine Learning Outliers Model(s) currently</span></h1>"
        );

        // the element
        var tabulatorElement = "#splk-wlk-outliers-table";

        // the table
        var table = new TabulatorFull(tabulatorElement, {
          data: resultCall,
          index: "model_id",
          layout: "fitDataStretch", //fit columns to width of table
          addRowPos: "top", //when adding a new row, add it to the top of the table
          history: true, //allow undo and redo actions on the table
          maxHeight: "100%", //do not let table get bigger than the height of its parent element
          pagination: "local", //paginate the data
          paginationSize: 2, //allow 7 rows per page of data
          paginationCounter: "rows", //display count of paginated rows in footer
          movableColumns: true, //allow column order to be changed
          resizableRows: true, //allow row order to be changed
          initialSort: [
            //set the initial sort order of the data
            { column: "model_id", dir: "asc" },
          ],

          columns: [
            //tickbox
            {
              formatter: "rowSelection",
              titleFormatter: "rowSelection",
              hozAlign: "center",
              headerSort: false,
              width: 20,
              cellClick: function (e, cell) {
                cell.getRow().toggleSelect();
              },
            },
            //define the table columns
            {
              title: "Model",
              field: "model_id",
              editor: false,
              headerFilter: false,
            },
            {
              title: "kpi_metric",
              field: "kpi_metric",
              editor: "list",
              editorParams: {
                values: [
                  "splk.wlk.count_completed",
                  "splk.wlk.count_errors",
                  "splk.wlk.count_ess_notable",
                  "splk.wlk.count_execution",
                  "splk.wlk.count_skipped",
                  "splk.wlk.elapsed",
                  "splk.wlk.pct_cpu",
                  "splk.wlk.pct_memory",
                  "splk.wlk.scan_count",
                ],
              },
              headerFilter: false,
            },
            {
              title: "kpi_span",
              field: "kpi_span",
              editor: "list",
              editorParams: {
                values: [
                  "5m",
                  "10m",
                  "15m",
                  "30m",
                  "1h",
                  "4h",
                  "8h",
                  "12h",
                  "24h",
                ],
              },
              headerFilter: false,
            },
            {
              title: "method_calculation",
              field: "method_calculation",
              editor: "list",
              editorParams: {
                values: [
                  "stdev",
                  "avg",
                  "perc95",
                  "latest",
                  "max",
                  "min",
                  "sum",
                ],
              },
              headerFilter: false,
            },
            {
              title: "period_calculation",
              field: "period_calculation",
              editor: true,
              headerFilter: false,
            },
            {
              title: "period_calculation_latest",
              field: "period_calculation_latest",
              editor: true,
              headerFilter: false,
            },
            {
              title: "time_factor",
              field: "time_factor",
              editor: "list",
              editorParams: {
                values: ["%H", "%H%M", "%w%H", "%w%H%M", "%w", "none"],
              },
              headerFilter: false,
            },
            {
              title: "density_lowerthreshold",
              field: "density_lowerthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "density_upperthreshold",
              field: "density_upperthreshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.001,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "alert_lower_breached",
              field: "alert_lower_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "alert_upper_breached",
              field: "alert_upper_breached",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "auto_correct",
              field: "auto_correct",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
            {
              title: "perc_min_lowerbound_deviation",
              field: "perc_min_lowerbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "perc_min_upperbound_deviation",
              field: "perc_min_upperbound_deviation",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_lowerbound_breached",
              field: "min_value_for_lowerbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "min_value_for_upperbound_breached",
              field: "min_value_for_upperbound_breached",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_lower_threshold",
              field: "static_lower_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "static_upper_threshold",
              field: "static_upper_threshold",
              editor: "number",
              editorParams: {
                min: 0,
                step: 0.5,
                verticalNavigation: "table", //up and down arrow keys navigate away from cell without changing value
              },
              headerFilter: false,
            },
            {
              title: "algorithm",
              field: "algorithm",
              minWidth: 150,
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(rowData.algorithms_list),
                };
              },
              headerFilter: false,
            },
            {
              title: "boundaries_extraction_macro",
              field: "boundaries_extraction_macro",
              editor: "list",
              editorParams: function (cell) {
                // Get the row data
                var rowData = cell.getRow().getData();
                return {
                  values: returnArrayFromCsv(
                    rowData.boundaries_extraction_macros_list
                  ),
                };
              },
              headerFilter: false,
            },
            {
              title: "fit_extra_parameters",
              field: "fit_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "apply_extra_parameters",
              field: "apply_extra_parameters",
              editor: true,
              headerFilter: false,
            },
            {
              title: "is_disabled",
              field: "is_disabled",
              editor: "list",
              editorParams: {
                values: ["0", "1"],
              },
              headerFilter: false,
            },
          ],
        });

        // actions per component
        var deleteBtn = "#btn_" + component + "_delete";
        var deleteToken = "tk_" + component + "_delete";
        var deleteConfirmModal = "#modal_" + component + "_confirm_delete";
        var saveBtn = "#btn_" + component + "_save";
        var saveToken = "tk_" + component + "_update";
        var simulateBtn = "#btn_" + component + "_simulate";
        var resetBtn = "#btn_" + component + "_reset";
        var saveConfirmModal = "#modal_" + component + "_confirm_save";
        var resetConfirmModal = "#modal_" + component + "_confirm_reset";

        // disable the delete edit button
        $(deleteBtn).prop("disabled", true);

        // disable the inline save button
        $(saveBtn).prop("disabled", true);

        // simulate
        $(simulateBtn)
          .unbind()
          .click(function () {
            var selectedData = table.getData("active");

            // get the selected model_id
            var selectedModelId = getToken(
              "tk_input_splk_wlk_outliers_model_id_settings_dropdown"
            );

            // loop and create a list of keys
            var itemList = [];
            for (var i = 0; i < selectedData.length; i++) {
              var model_id = selectedData[i].model_id;
              var kpi_metric = selectedData[i].kpi_metric;
              var kpi_span = selectedData[i].kpi_span;
              var method_calculation = selectedData[i].method_calculation;
              var period_calculation = selectedData[i].period_calculation;
              var period_calculation_latest =
                selectedData[i].period_calculation_latest;
              var time_factor = selectedData[i].time_factor;
              var density_lowerthreshold =
                selectedData[i].density_lowerthreshold;
              var density_upperthreshold =
                selectedData[i].density_upperthreshold;
              var alert_lower_breached = selectedData[i].alert_lower_breached;
              var alert_upper_breached = selectedData[i].alert_upper_breached;
              var auto_correct = selectedData[i].auto_correct;
              var perc_min_lowerbound_deviation =
                selectedData[i].perc_min_lowerbound_deviation;
              var perc_min_upperbound_deviation =
                selectedData[i].perc_min_upperbound_deviation;
              var min_value_for_lowerbound_breached =
                selectedData[i].min_value_for_lowerbound_breached;
              var min_value_for_upperbound_breached =
                selectedData[i].min_value_for_upperbound_breached;
              var static_lower_threshold =
                selectedData[i].static_lower_threshold;
              var static_upper_threshold =
                selectedData[i].static_upper_threshold;
              var algorithm = selectedData[i].algorithm;
              var boundaries_extraction_macro =
                selectedData[i].boundaries_extraction_macro;
              va