(()=>{var __webpack_modules__={91:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar baseFlatten = __webpack_require__(25371);\n\n/**\n * Flattens `array` a single level deep.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Array\n * @param {Array} array The array to flatten.\n * @returns {Array} Returns the new flattened array.\n * @example\n *\n * _.flatten([1, [2, [3, [4]], 5]]);\n * // => [1, 2, [3, [4]], 5]\n */\nfunction flatten(array) {\n  var length = array == null ? 0 : array.length;\n  return length ? baseFlatten(array, 1) : [];\n}\n\nmodule.exports = flatten;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOTEuanMiLCJtYXBwaW5ncyI6Ijs7OztBQUFBLGtCQUFrQixtQkFBTyxDQUFDLEtBQWdCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQHNwbHVuay90cmFja21lLy4uLy4uL25vZGVfbW9kdWxlcy9sb2Rhc2gvZmxhdHRlbi5qcz9kNzE4Il0sInNvdXJjZXNDb250ZW50IjpbInZhciBiYXNlRmxhdHRlbiA9IHJlcXVpcmUoJy4vX2Jhc2VGbGF0dGVuJyk7XG5cbi8qKlxuICogRmxhdHRlbnMgYGFycmF5YCBhIHNpbmdsZSBsZXZlbCBkZWVwLlxuICpcbiAqIEBzdGF0aWNcbiAqIEBtZW1iZXJPZiBfXG4gKiBAc2luY2UgMC4xLjBcbiAqIEBjYXRlZ29yeSBBcnJheVxuICogQHBhcmFtIHtBcnJheX0gYXJyYXkgVGhlIGFycmF5IHRvIGZsYXR0ZW4uXG4gKiBAcmV0dXJucyB7QXJyYXl9IFJldHVybnMgdGhlIG5ldyBmbGF0dGVuZWQgYXJyYXkuXG4gKiBAZXhhbXBsZVxuICpcbiAqIF8uZmxhdHRlbihbMSwgWzIsIFszLCBbNF1dLCA1XV0pO1xuICogLy8gPT4gWzEsIDIsIFszLCBbNF1dLCA1XVxuICovXG5mdW5jdGlvbiBmbGF0dGVuKGFycmF5KSB7XG4gIHZhciBsZW5ndGggPSBhcnJheSA9PSBudWxsID8gMCA6IGFycmF5Lmxlbmd0aDtcbiAgcmV0dXJuIGxlbmd0aCA/IGJhc2VGbGF0dGVuKGFycmF5LCAxKSA6IFtdO1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGZsYXR0ZW47XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///91\n\n}")},198:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar isSymbol = __webpack_require__(54825);\n\n/**\n * The base implementation of methods like `_.max` and `_.min` which accepts a\n * `comparator` to determine the extremum value.\n *\n * @private\n * @param {Array} array The array to iterate over.\n * @param {Function} iteratee The iteratee invoked per iteration.\n * @param {Function} comparator The comparator used to compare values.\n * @returns {*} Returns the extremum value.\n */\nfunction baseExtremum(array, iteratee, comparator) {\n  var index = -1,\n      length = array.length;\n\n  while (++index < length) {\n    var value = array[index],\n        current = iteratee(value);\n\n    if (current != null && (computed === undefined\n          ? (current === current && !isSymbol(current))\n          : comparator(current, computed)\n        )) {\n      var computed = current,\n          result = value;\n    }\n  }\n  return result;\n}\n\nmodule.exports = baseExtremum;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTk4LmpzIiwibWFwcGluZ3MiOiI7Ozs7QUFBQSxlQUFlLG1CQUFPLENBQUMsS0FBWSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvbG9kYXNoL19iYXNlRXh0cmVtdW0uanM/MjQ0OSJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgaXNTeW1ib2wgPSByZXF1aXJlKCcuL2lzU3ltYm9sJyk7XG5cbi8qKlxuICogVGhlIGJhc2UgaW1wbGVtZW50YXRpb24gb2YgbWV0aG9kcyBsaWtlIGBfLm1heGAgYW5kIGBfLm1pbmAgd2hpY2ggYWNjZXB0cyBhXG4gKiBgY29tcGFyYXRvcmAgdG8gZGV0ZXJtaW5lIHRoZSBleHRyZW11bSB2YWx1ZS5cbiAqXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtBcnJheX0gYXJyYXkgVGhlIGFycmF5IHRvIGl0ZXJhdGUgb3Zlci5cbiAqIEBwYXJhbSB7RnVuY3Rpb259IGl0ZXJhdGVlIFRoZSBpdGVyYXRlZSBpbnZva2VkIHBlciBpdGVyYXRpb24uXG4gKiBAcGFyYW0ge0Z1bmN0aW9ufSBjb21wYXJhdG9yIFRoZSBjb21wYXJhdG9yIHVzZWQgdG8gY29tcGFyZSB2YWx1ZXMuXG4gKiBAcmV0dXJucyB7Kn0gUmV0dXJucyB0aGUgZXh0cmVtdW0gdmFsdWUuXG4gKi9cbmZ1bmN0aW9uIGJhc2VFeHRyZW11bShhcnJheSwgaXRlcmF0ZWUsIGNvbXBhcmF0b3IpIHtcbiAgdmFyIGluZGV4ID0gLTEsXG4gICAgICBsZW5ndGggPSBhcnJheS5sZW5ndGg7XG5cbiAgd2hpbGUgKCsraW5kZXggPCBsZW5ndGgpIHtcbiAgICB2YXIgdmFsdWUgPSBhcnJheVtpbmRleF0sXG4gICAgICAgIGN1cnJlbnQgPSBpdGVyYXRlZSh2YWx1ZSk7XG5cbiAgICBpZiAoY3VycmVudCAhPSBudWxsICYmIChjb21wdXRlZCA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgPyAoY3VycmVudCA9PT0gY3VycmVudCAmJiAhaXNTeW1ib2woY3VycmVudCkpXG4gICAgICAgICAgOiBjb21wYXJhdG9yKGN1cnJlbnQsIGNvbXB1dGVkKVxuICAgICAgICApKSB7XG4gICAgICB2YXIgY29tcHV0ZWQgPSBjdXJyZW50LFxuICAgICAgICAgIHJlc3VsdCA9IHZhbHVlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gcmVzdWx0O1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGJhc2VFeHRyZW11bTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///198\n\n}")},234:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar OuterSubscriber = (function (_super) {\n    __extends(OuterSubscriber, _super);\n    function OuterSubscriber() {\n        _super.apply(this, arguments);\n    }\n    OuterSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {\n        this.destination.next(innerValue);\n    };\n    OuterSubscriber.prototype.notifyError = function (error, innerSub) {\n        this.destination.error(error);\n    };\n    OuterSubscriber.prototype.notifyComplete = function (innerSub) {\n        this.destination.complete();\n    };\n    return OuterSubscriber;\n}(Subscriber_1.Subscriber));\nexports.OuterSubscriber = OuterSubscriber;\n//# sourceMappingURL=OuterSubscriber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///234\n\n}")},250:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar windowWhen_1 = __webpack_require__(45918);\nObservable_1.Observable.prototype.windowWhen = windowWhen_1.windowWhen;\n//# sourceMappingURL=windowWhen.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjUwLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsbUJBQW1CLG1CQUFPLENBQUMsS0FBa0I7QUFDN0MsbUJBQW1CLG1CQUFPLENBQUMsS0FBMkI7QUFDdEQ7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcnhqcy9hZGQvb3BlcmF0b3Ivd2luZG93V2hlbi5qcz9jODVhIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xudmFyIE9ic2VydmFibGVfMSA9IHJlcXVpcmUoJy4uLy4uL09ic2VydmFibGUnKTtcbnZhciB3aW5kb3dXaGVuXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci93aW5kb3dXaGVuJyk7XG5PYnNlcnZhYmxlXzEuT2JzZXJ2YWJsZS5wcm90b3R5cGUud2luZG93V2hlbiA9IHdpbmRvd1doZW5fMS53aW5kb3dXaGVuO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9d2luZG93V2hlbi5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///250\n\n}")},286:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\n/**\n * Returns an Observable that skips the first `count` items emitted by the source Observable.\n *\n * <img src="./img/skip.png" width="100%">\n *\n * @param {Number} count - The number of times, items emitted by source Observable should be skipped.\n * @return {Observable} An Observable that skips values emitted by the source Observable.\n *\n * @method skip\n * @owner Observable\n */\nfunction skip(count) {\n    return function (source) { return source.lift(new SkipOperator(count)); };\n}\nexports.skip = skip;\nvar SkipOperator = (function () {\n    function SkipOperator(total) {\n        this.total = total;\n    }\n    SkipOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new SkipSubscriber(subscriber, this.total));\n    };\n    return SkipOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar SkipSubscriber = (function (_super) {\n    __extends(SkipSubscriber, _super);\n    function SkipSubscriber(destination, total) {\n        _super.call(this, destination);\n        this.total = total;\n        this.count = 0;\n    }\n    SkipSubscriber.prototype._next = function (x) {\n        if (++this.count > this.total) {\n            this.destination.next(x);\n        }\n    };\n    return SkipSubscriber;\n}(Subscriber_1.Subscriber));\n//# sourceMappingURL=skip.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///286\n\n}')},311:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/**\n * This method returns the first argument it receives.\n *\n * @static\n * @since 0.1.0\n * @memberOf _\n * @category Util\n * @param {*} value Any value.\n * @returns {*} Returns `value`.\n * @example\n *\n * var object = { 'a': 1 };\n *\n * console.log(_.identity(object) === object);\n * // => true\n */\nfunction identity(value) {\n  return value;\n}\n\nmodule.exports = identity;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9pZGVudGl0eS5qcz9jZDY4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhpcyBtZXRob2QgcmV0dXJucyB0aGUgZmlyc3QgYXJndW1lbnQgaXQgcmVjZWl2ZXMuXG4gKlxuICogQHN0YXRpY1xuICogQHNpbmNlIDAuMS4wXG4gKiBAbWVtYmVyT2YgX1xuICogQGNhdGVnb3J5IFV0aWxcbiAqIEBwYXJhbSB7Kn0gdmFsdWUgQW55IHZhbHVlLlxuICogQHJldHVybnMgeyp9IFJldHVybnMgYHZhbHVlYC5cbiAqIEBleGFtcGxlXG4gKlxuICogdmFyIG9iamVjdCA9IHsgJ2EnOiAxIH07XG4gKlxuICogY29uc29sZS5sb2coXy5pZGVudGl0eShvYmplY3QpID09PSBvYmplY3QpO1xuICogLy8gPT4gdHJ1ZVxuICovXG5mdW5jdGlvbiBpZGVudGl0eSh2YWx1ZSkge1xuICByZXR1cm4gdmFsdWU7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gaWRlbnRpdHk7XG4iXSwiZmlsZSI6IjMxMS5qcyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///311\n\n}")},491:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar root_1 = __webpack_require__(26854);\nvar tryCatch_1 = __webpack_require__(36786);\nvar errorObject_1 = __webpack_require__(70817);\nvar Observable_1 = __webpack_require__(91638);\nvar Subscriber_1 = __webpack_require__(42741);\nvar map_1 = __webpack_require__(15471);\nfunction getCORSRequest() {\n    if (root_1.root.XMLHttpRequest) {\n        return new root_1.root.XMLHttpRequest();\n    }\n    else if (!!root_1.root.XDomainRequest) {\n        return new root_1.root.XDomainRequest();\n    }\n    else {\n        throw new Error('CORS is not supported by your browser');\n    }\n}\nfunction getXMLHttpRequest() {\n    if (root_1.root.XMLHttpRequest) {\n        return new root_1.root.XMLHttpRequest();\n    }\n    else {\n        var progId = void 0;\n        try {\n            var progIds = ['Msxml2.XMLHTTP', 'Microsoft.XMLHTTP', 'Msxml2.XMLHTTP.4.0'];\n            for (var i = 0; i < 3; i++) {\n                try {\n                    progId = progIds[i];\n                    if (new root_1.root.ActiveXObject(progId)) {\n                        break;\n                    }\n                }\n                catch (e) {\n                }\n            }\n            return new root_1.root.ActiveXObject(progId);\n        }\n        catch (e) {\n            throw new Error('XMLHttpRequest is not supported by your browser');\n        }\n    }\n}\nfunction ajaxGet(url, headers) {\n    if (headers === void 0) { headers = null; }\n    return new AjaxObservable({ method: 'GET', url: url, headers: headers });\n}\nexports.ajaxGet = ajaxGet;\n;\nfunction ajaxPost(url, body, headers) {\n    return new AjaxObservable({ method: 'POST', url: url, body: body, headers: headers });\n}\nexports.ajaxPost = ajaxPost;\n;\nfunction ajaxDelete(url, headers) {\n    return new AjaxObservable({ method: 'DELETE', url: url, headers: headers });\n}\nexports.ajaxDelete = ajaxDelete;\n;\nfunction ajaxPut(url, body, headers) {\n    return new AjaxObservable({ method: 'PUT', url: url, body: body, headers: headers });\n}\nexports.ajaxPut = ajaxPut;\n;\nfunction ajaxPatch(url, body, headers) {\n    return new AjaxObservable({ method: 'PATCH', url: url, body: body, headers: headers });\n}\nexports.ajaxPatch = ajaxPatch;\n;\nvar mapResponse = map_1.map(function (x, index) { return x.response; });\nfunction ajaxGetJSON(url, headers) {\n    return mapResponse(new AjaxObservable({\n        method: 'GET',\n        url: url,\n        responseType: 'json',\n        headers: headers\n    }));\n}\nexports.ajaxGetJSON = ajaxGetJSON;\n;\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @extends {Ignored}\n * @hide true\n */\nvar AjaxObservable = (function (_super) {\n    __extends(AjaxObservable, _super);\n    function AjaxObservable(urlOrRequest) {\n        _super.call(this);\n        var request = {\n            async: true,\n            createXHR: function () {\n                return this.crossDomain ? getCORSRequest.call(this) : getXMLHttpRequest();\n            },\n            crossDomain: false,\n            withCredentials: false,\n            headers: {},\n            method: 'GET',\n            responseType: 'json',\n            timeout: 0\n        };\n        if (typeof urlOrRequest === 'string') {\n            request.url = urlOrRequest;\n        }\n        else {\n            for (var prop in urlOrRequest) {\n                if (urlOrRequest.hasOwnProperty(prop)) {\n                    request[prop] = urlOrRequest[prop];\n                }\n            }\n        }\n        this.request = request;\n    }\n    /** @deprecated internal use only */ AjaxObservable.prototype._subscribe = function (subscriber) {\n        return new AjaxSubscriber(subscriber, this.request);\n    };\n    /**\n     * Creates an observable for an Ajax request with either a request object with\n     * url, headers, etc or a string for a URL.\n     *\n     * @example\n     * source = Rx.Observable.ajax('/products');\n     * source = Rx.Observable.ajax({ url: 'products', method: 'GET' });\n     *\n     * @param {string|Object} request Can be one of the following:\n     *   A string of the URL to make the Ajax call.\n     *   An object with the following properties\n     *   - url: URL of the request\n     *   - body: The body of the request\n     *   - method: Method of the request, such as GET, POST, PUT, PATCH, DELETE\n     *   - async: Whether the request is async\n     *   - headers: Optional headers\n     *   - crossDomain: true if a cross domain request, else false\n     *   - createXHR: a function to override if you need to use an alternate\n     *   XMLHttpRequest implementation.\n     *   - resultSelector: a function to use to alter the output value type of\n     *   the Observable. Gets {@link AjaxResponse} as an argument.\n     * @return {Observable} An observable sequence containing the XMLHttpRequest.\n     * @static true\n     * @name ajax\n     * @owner Observable\n    */\n    AjaxObservable.create = (function () {\n        var create = function (urlOrRequest) {\n            return new AjaxObservable(urlOrRequest);\n        };\n        create.get = ajaxGet;\n        create.post = ajaxPost;\n        create.delete = ajaxDelete;\n        create.put = ajaxPut;\n        create.patch = ajaxPatch;\n        create.getJSON = ajaxGetJSON;\n        return create;\n    })();\n    return AjaxObservable;\n}(Observable_1.Observable));\nexports.AjaxObservable = AjaxObservable;\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar AjaxSubscriber = (function (_super) {\n    __extends(AjaxSubscriber, _super);\n    function AjaxSubscriber(destination, request) {\n        _super.call(this, destination);\n        this.request = request;\n        this.done = false;\n        var headers = request.headers = request.headers || {};\n        // force CORS if requested\n        if (!request.crossDomain && !headers['X-Requested-With']) {\n            headers['X-Requested-With'] = 'XMLHttpRequest';\n        }\n        // ensure content type is set\n        if (!('Content-Type' in headers) && !(root_1.root.FormData && request.body instanceof root_1.root.FormData) && typeof request.body !== 'undefined') {\n            headers['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';\n        }\n        // properly serialize body\n        request.body = this.serializeBody(request.body, request.headers['Content-Type']);\n        this.send();\n    }\n    AjaxSubscriber.prototype.next = function (e) {\n        this.done = true;\n        var _a = this, xhr = _a.xhr, request = _a.request, destination = _a.destination;\n        var response = new AjaxResponse(e, xhr, request);\n        destination.next(response);\n    };\n    AjaxSubscriber.prototype.send = function () {\n        var _a = this, request = _a.request, _b = _a.request, user = _b.user, method = _b.method, url = _b.url, async = _b.async, password = _b.password, headers = _b.headers, body = _b.body;\n        var createXHR = request.createXHR;\n        var xhr = tryCatch_1.tryCatch(createXHR).call(request);\n        if (xhr === errorObject_1.errorObject) {\n            this.error(errorObject_1.errorObject.e);\n        }\n        else {\n            this.xhr = xhr;\n            // set up the events before open XHR\n            // https://developer.mozilla.org/en/docs/Web/API/XMLHttpRequest/Using_XMLHttpRequest\n            // You need to add the event listeners before calling open() on the request.\n            // Otherwise the progress events will not fire.\n            this.setupEvents(xhr, request);\n            // open XHR\n            var result = void 0;\n            if (user) {\n                result = tryCatch_1.tryCatch(xhr.open).call(xhr, method, url, async, user, password);\n            }\n            else {\n                result = tryCatch_1.tryCatch(xhr.open).call(xhr, method, url, async);\n            }\n            if (result === errorObject_1.errorObject) {\n                this.error(errorObject_1.errorObject.e);\n                return null;\n            }\n            // timeout, responseType and withCredentials can be set once the XHR is open\n            if (async) {\n                xhr.timeout = request.timeout;\n                xhr.responseType = request.responseType;\n            }\n            if ('withCredentials' in xhr) {\n                xhr.withCredentials = !!request.withCredentials;\n            }\n            // set headers\n            this.setHeaders(xhr, headers);\n            // finally send the request\n            result = body ? tryCatch_1.tryCatch(xhr.send).call(xhr, body) : tryCatch_1.tryCatch(xhr.send).call(xhr);\n            if (result === errorObject_1.errorObject) {\n                this.error(errorObject_1.errorObject.e);\n                return null;\n            }\n        }\n        return xhr;\n    };\n    AjaxSubscriber.prototype.serializeBody = function (body, contentType) {\n        if (!body || typeof body === 'string') {\n            return body;\n        }\n        else if (root_1.root.FormData && body instanceof root_1.root.FormData) {\n            return body;\n        }\n        if (contentType) {\n            var splitIndex = contentType.indexOf(';');\n            if (splitIndex !== -1) {\n                contentType = contentType.substring(0, splitIndex);\n            }\n        }\n        switch (contentType) {\n            case 'application/x-www-form-urlencoded':\n                return Object.keys(body).map(function (key) { return (encodeURIComponent(key) + \"=\" + encodeURIComponent(body[key])); }).join('&');\n            case 'application/json':\n                return JSON.stringify(body);\n            default:\n                return body;\n        }\n    };\n    AjaxSubscriber.prototype.setHeaders = function (xhr, headers) {\n        for (var key in headers) {\n            if (headers.hasOwnProperty(key)) {\n                xhr.setRequestHeader(key, headers[key]);\n            }\n        }\n    };\n    AjaxSubscriber.prototype.setupEvents = function (xhr, request) {\n        var progressSubscriber = request.progressSubscriber;\n        function xhrTimeout(e) {\n            var _a = xhrTimeout, subscriber = _a.subscriber, progressSubscriber = _a.progressSubscriber, request = _a.request;\n            if (progressSubscriber) {\n                progressSubscriber.error(e);\n            }\n            subscriber.error(new AjaxTimeoutError(this, request)); //TODO: Make betterer.\n        }\n        ;\n        xhr.ontimeout = xhrTimeout;\n        xhrTimeout.request = request;\n        xhrTimeout.subscriber = this;\n        xhrTimeout.progressSubscriber = progressSubscriber;\n        if (xhr.upload && 'withCredentials' in xhr) {\n            if (progressSubscriber) {\n                var xhrProgress_1;\n                xhrProgress_1 = function (e) {\n                    var progressSubscriber = xhrProgress_1.progressSubscriber;\n                    progressSubscriber.next(e);\n                };\n                if (root_1.root.XDomainRequest) {\n                    xhr.onprogress = xhrProgress_1;\n                }\n                else {\n                    xhr.upload.onprogress = xhrProgress_1;\n                }\n                xhrProgress_1.progressSubscriber = progressSubscriber;\n            }\n            var xhrError_1;\n            xhrError_1 = function (e) {\n                var _a = xhrError_1, progressSubscriber = _a.progressSubscriber, subscriber = _a.subscriber, request = _a.request;\n                if (progressSubscriber) {\n                    progressSubscriber.error(e);\n                }\n                subscriber.error(new AjaxError('ajax error', this, request));\n            };\n            xhr.onerror = xhrError_1;\n            xhrError_1.request = request;\n            xhrError_1.subscriber = this;\n            xhrError_1.progressSubscriber = progressSubscriber;\n        }\n        function xhrReadyStateChange(e) {\n            var _a = xhrReadyStateChange, subscriber = _a.subscriber, progressSubscriber = _a.progressSubscriber, request = _a.request;\n            if (this.readyState === 4) {\n                // normalize IE9 bug (http://bugs.jquery.com/ticket/1450)\n                var status_1 = this.status === 1223 ? 204 : this.status;\n                var response = (this.responseType === 'text' ? (this.response || this.responseText) : this.response);\n                // fix status code when it is 0 (0 status is undocumented).\n                // Occurs when accessing file resources or on Android 4.1 stock browser\n                // while retrieving files from application cache.\n                if (status_1 === 0) {\n                    status_1 = response ? 200 : 0;\n                }\n                if (200 <= status_1 && status_1 < 300) {\n                    if (progressSubscriber) {\n                        progressSubscriber.complete();\n                    }\n                    subscriber.next(e);\n                    subscriber.complete();\n                }\n                else {\n                    if (progressSubscriber) {\n                        progressSubscriber.error(e);\n                    }\n                    subscriber.error(new AjaxError('ajax error ' + status_1, this, request));\n                }\n            }\n        }\n        ;\n        xhr.onreadystatechange = xhrReadyStateChange;\n        xhrReadyStateChange.subscriber = this;\n        xhrReadyStateChange.progressSubscriber = progressSubscriber;\n        xhrReadyStateChange.request = request;\n    };\n    AjaxSubscriber.prototype.unsubscribe = function () {\n        var _a = this, done = _a.done, xhr = _a.xhr;\n        if (!done && xhr && xhr.readyState !== 4 && typeof xhr.abort === 'function') {\n            xhr.abort();\n        }\n        _super.prototype.unsubscribe.call(this);\n    };\n    return AjaxSubscriber;\n}(Subscriber_1.Subscriber));\nexports.AjaxSubscriber = AjaxSubscriber;\n/**\n * A normalized AJAX response.\n *\n * @see {@link ajax}\n *\n * @class AjaxResponse\n */\nvar AjaxResponse = (function () {\n    function AjaxResponse(originalEvent, xhr, request) {\n        this.originalEvent = originalEvent;\n        this.xhr = xhr;\n        this.request = request;\n        this.status = xhr.status;\n        this.responseType = xhr.responseType || request.responseType;\n        this.response = parseXhrResponse(this.responseType, xhr);\n    }\n    return AjaxResponse;\n}());\nexports.AjaxResponse = AjaxResponse;\n/**\n * A normalized AJAX error.\n *\n * @see {@link ajax}\n *\n * @class AjaxError\n */\nvar AjaxError = (function (_super) {\n    __extends(AjaxError, _super);\n    function AjaxError(message, xhr, request) {\n        _super.call(this, message);\n        this.message = message;\n        this.xhr = xhr;\n        this.request = request;\n        this.status = xhr.status;\n        this.responseType = xhr.responseType || request.responseType;\n        this.response = parseXhrResponse(this.responseType, xhr);\n    }\n    return AjaxError;\n}(Error));\nexports.AjaxError = AjaxError;\nfunction parseXhrResponse(responseType, xhr) {\n    switch (responseType) {\n        case 'json':\n            if ('response' in xhr) {\n                //IE does not support json as responseType, parse it internally\n                return xhr.responseType ? xhr.response : JSON.parse(xhr.response || xhr.responseText || 'null');\n            }\n            else {\n                // HACK(benlesh): TypeScript shennanigans\n                // tslint:disable-next-line:no-any latest TS seems to think xhr is \"never\" here.\n                return JSON.parse(xhr.responseText || 'null');\n            }\n        case 'xml':\n            return xhr.responseXML;\n        case 'text':\n        default:\n            // HACK(benlesh): TypeScript shennanigans\n            // tslint:disable-next-line:no-any latest TS seems to think xhr is \"never\" here.\n            return ('response' in xhr) ? xhr.response : xhr.responseText;\n    }\n}\n/**\n * @see {@link ajax}\n *\n * @class AjaxTimeoutError\n */\nvar AjaxTimeoutError = (function (_super) {\n    __extends(AjaxTimeoutError, _super);\n    function AjaxTimeoutError(xhr, request) {\n        _super.call(this, 'ajax timeout', xhr, request);\n    }\n    return AjaxTimeoutError;\n}(AjaxError));\nexports.AjaxTimeoutError = AjaxTimeoutError;\n//# sourceMappingURL=AjaxObservable.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///491\n\n}")},524:(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\n\nif (true) {\n  module.exports = __webpack_require__(90320);\n} else // removed by dead control flow\n{}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTI0LmpzIiwibWFwcGluZ3MiOiJBQUFhOztBQUViLElBQUksSUFBcUM7QUFDekMsRUFBRSwyQ0FBNEQ7QUFDOUQsRUFBRSxLQUFLO0FBQUEsRUFFTiIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcmVhY3QtaXMvaW5kZXguanM/OTJmNSJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViA9PT0gJ3Byb2R1Y3Rpb24nKSB7XG4gIG1vZHVsZS5leHBvcnRzID0gcmVxdWlyZSgnLi9janMvcmVhY3QtaXMucHJvZHVjdGlvbi5taW4uanMnKTtcbn0gZWxzZSB7XG4gIG1vZHVsZS5leHBvcnRzID0gcmVxdWlyZSgnLi9janMvcmVhY3QtaXMuZGV2ZWxvcG1lbnQuanMnKTtcbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///524\n\n}")},583:(module,__unused_webpack_exports,__webpack_require__)=>{eval('{/******/ (() => {\n    // webpackBootstrap\n    /******/ "use strict";\n    /******/ // The require scope\n    /******/    var e = {};\n    /******/\n    /************************************************************************/\n    /******/ /* webpack/runtime/compat get default export */\n    /******/    (() => {\n        /******/ // getDefaultExport function for compatibility with non-harmony modules\n        /******/ e.n = r => {\n            /******/ var n = r && r.__esModule ? \n            /******/ () => r["default"]\n            /******/ : () => r\n            /******/;\n            e.d(n, {\n                a: n\n            });\n            /******/            return n;\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/define property getters */\n    /******/    (() => {\n        /******/ // define getter functions for harmony exports\n        /******/ e.d = (r, n) => {\n            /******/ for (var t in n) {\n                /******/ if (e.o(n, t) && !e.o(r, t)) {\n                    /******/ Object.defineProperty(r, t, {\n                        enumerable: true,\n                        get: n[t]\n                    });\n                    /******/                }\n                /******/            }\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/hasOwnProperty shorthand */\n    /******/    (() => {\n        /******/ e.o = (e, r) => Object.prototype.hasOwnProperty.call(e, r)\n        /******/;\n    })();\n    /******/\n    /******/ /* webpack/runtime/make namespace object */\n    /******/    (() => {\n        /******/ // define __esModule on exports\n        /******/ e.r = e => {\n            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {\n                /******/ Object.defineProperty(e, Symbol.toStringTag, {\n                    value: "Module"\n                });\n                /******/            }\n            /******/            Object.defineProperty(e, "__esModule", {\n                value: true\n            });\n            /******/        };\n        /******/    })();\n    /******/\n    /************************************************************************/    var r = {};\n    // ESM COMPAT FLAG\n        e.r(r);\n    // EXPORTS\n        e.d(r, {\n        VirtualizedResultsMenu: () => /* reexport */ Re,\n        default: () => /* reexport */ B\n    });\n    // CONCATENATED MODULE: external "react"\n    const n = __webpack_require__(14041);\n    var t =  e.n(n);\n    // CONCATENATED MODULE: external "prop-types"\n    const o = __webpack_require__(39067);\n    var a =  e.n(o);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Divider"\n    const i = __webpack_require__(13339);\n    var u =  e.n(i);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Menu"\n    const l = __webpack_require__(7343);\n    var c =  e.n(l);\n    // CONCATENATED MODULE: external "@splunk/react-ui/ScreenReaderContent"\n    const s = __webpack_require__(30762);\n    var f =  e.n(s);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/i18n"\n    const d = __webpack_require__(41454);\n    // CONCATENATED MODULE: external "styled-components"\n    const v = __webpack_require__(53057);\n    var m =  e.n(v);\n    // CONCATENATED MODULE: external "@splunk/react-ui/WaitSpinner"\n    const b = __webpack_require__(33772);\n    var p =  e.n(b);\n    // CONCATENATED MODULE: external "@splunk/themes"\n    const y = __webpack_require__(18672);\n    // CONCATENATED MODULE: ./src/ResultsMenu/ResultsMenuStyles.ts\n    var g = m()(c()).withConfig({\n        displayName: "ResultsMenuStyles__StyledMenu",\n        componentId: "avbhl8-0"\n    })([ "overflow:auto;flex-direction:column;" ]);\n    var h = m().div.withConfig({\n        displayName: "ResultsMenuStyles__Styled",\n        componentId: "avbhl8-1"\n    })([ "", ";flex-direction:column;max-height:calc(100vh - 20px);border-radius:", ";background-color:", ";& > ", ":not(:first-child){border-start-start-radius:0;border-start-end-radius:0;}& > ", ":not(:last-child){border-end-start-radius:0;border-end-end-radius:0;}" ], y.mixins.reset("flex"), y.variables.borderRadius, y.variables.backgroundColorPopup, g, g);\n    var S = m().div.withConfig({\n        displayName: "ResultsMenuStyles__StyledFooter",\n        componentId: "avbhl8-2"\n    })([ "padding:", " ", ";color:", ";" ], y.variables.spacingSmall, y.variables.spacingLarge, y.variables.contentColorDefault);\n    var E = m().li.withConfig({\n        displayName: "ResultsMenuStyles__StyledLoading",\n        componentId: "avbhl8-3"\n    })([ "", ";padding:", " ", ";gap:", ";" ], y.mixins.reset("flex"), y.variables.spacingSmall, y.variables.spacingLarge, y.variables.spacingXSmall);\n    var O = m()(c().Item).withConfig({\n        displayName: "ResultsMenuStyles__StyledNoOptions",\n        componentId: "avbhl8-4"\n    })([ "&[disabled],&[aria-disabled=\'true\']{color:", ";}" ], y.variables.contentColorDefault);\n    var M = m()(p()).withConfig({\n        displayName: "ResultsMenuStyles__StyledWait",\n        componentId: "avbhl8-5"\n    })([ "flex:0 0 auto;" ]);\n    var w = m().div.withConfig({\n        displayName: "ResultsMenuStyles__StyledLoadingMessage",\n        componentId: "avbhl8-6"\n    })([ "flex:1 0 0;color:", ";" ], y.variables.contentColorDefault);\n    // CONCATENATED MODULE: ./src/utils/updateReactRef.ts\n    /**\n * Updates a React ref. Callback refs and object refs (from `createRef` and `useRef`) are supported.\n *\n * @param ref - The React callback or object ref. Can be `null` or `undefined`.\n * @param current - The new value of the ref.\n */\n    function C(e, r) {\n        if (e) {\n            if (typeof e === "function") {\n                e(r);\n            } else {\n                // the public signature of this util uses React.Ref<T> to mirror the way React types refs.\n                // the intention here is to signal "we will take care of setting \'current\', not you".\n                e.current = r;\n // eslint-disable-line no-param-reassign\n                        }\n        }\n    }\n    // CONCATENATED MODULE: ./src/ResultsMenu/ResultsMenu.tsx\n    function k() {\n        return k = Object.assign ? Object.assign.bind() : function(e) {\n            for (var r = 1; r < arguments.length; r++) {\n                var n = arguments[r];\n                for (var t in n) {\n                    ({}).hasOwnProperty.call(n, t) && (e[t] = n[t]);\n                }\n            }\n            return e;\n        }, k.apply(null, arguments);\n    }\n    function j(e, r) {\n        return A(e) || x(e, r) || R(e, r) || I();\n    }\n    function I() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function R(e, r) {\n        if (e) {\n            if ("string" == typeof e) return P(e, r);\n            var n = {}.toString.call(e).slice(8, -1);\n            return "Object" === n && e.constructor && (n = e.constructor.name), "Map" === n || "Set" === n ? Array.from(e) : "Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n) ? P(e, r) : void 0;\n        }\n    }\n    function P(e, r) {\n        (null == r || r > e.length) && (r = e.length);\n        for (var n = 0, t = Array(r); n < r; n++) {\n            t[n] = e[n];\n        }\n        return t;\n    }\n    function x(e, r) {\n        var n = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != n) {\n            var t, o, a, i, u = [], l = !0, c = !1;\n            try {\n                if (a = (n = n.call(e)).next, 0 === r) {\n                    if (Object(n) !== n) return;\n                    l = !1;\n                } else for (;!(l = (t = a.call(n)).done) && (u.push(t.value), u.length !== r); l = !0) {\n                }\n            } catch (e) {\n                c = !0, o = e;\n            } finally {\n                try {\n                    if (!l && null != n["return"] && (i = n["return"](), Object(i) !== i)) return;\n                } finally {\n                    if (c) throw o;\n                }\n            }\n            return u;\n        }\n    }\n    function A(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function T(e, r) {\n        if (null == e) return {};\n        var n, t, o = L(e, r);\n        if (Object.getOwnPropertySymbols) {\n            var a = Object.getOwnPropertySymbols(e);\n            for (t = 0; t < a.length; t++) {\n                n = a[t], -1 === r.indexOf(n) && {}.propertyIsEnumerable.call(e, n) && (o[n] = e[n]);\n            }\n        }\n        return o;\n    }\n    function L(e, r) {\n        if (null == e) return {};\n        var n = {};\n        for (var t in e) {\n            if ({}.hasOwnProperty.call(e, t)) {\n                if (-1 !== r.indexOf(t)) continue;\n                n[t] = e[t];\n            }\n        }\n        return n;\n    }\n    var _ = {\n        animateLoading: a().bool,\n        children: a().node,\n        childrenStart: a().node,\n        elementRef: a().oneOfType([ a().func, a().object ]),\n        focusMode: a().oneOf([ "roving", "normal", "never" ]),\n        footerMessage: a().node,\n        isLoading: a().bool,\n        loadingMessage: a().node,\n        menuId: a().string,\n        noOptionsMessage: a().node,\n        onScroll: a().func,\n        onScrollBottom: a().func,\n        placement: a().string\n    };\n    var q = (0, d._)("Loading...");\n    var D = (0, d._)("No matches");\n    // The remaining amount of pixels when scrolled from bottom of menu to trigger onScrollBottom().\n        var N = 400;\n    var H = 28;\n    function F(e) {\n        var r = e.animateLoading, o = e["aria-multiselectable"], a = e.children, i = e.childrenStart, c = e.elementRef, s = e.focusMode, d = e.footerMessage, v = e.isLoading, m = e.labelledBy, b = e.loadingMessage, p = b === void 0 ? q : b, y = e.menuId, I = e.noOptionsMessage, R = I === void 0 ? D : I, P = e.onScroll, x = e.onScrollBottom, A = e.placement, L = e.style, _ = e.tabIndex, F = T(e, [ "animateLoading", "aria-multiselectable", "children", "childrenStart", "elementRef", "focusMode", "footerMessage", "isLoading", "labelledBy", "loadingMessage", "menuId", "noOptionsMessage", "onScroll", "onScrollBottom", "placement", "style", "tabIndex" ]);\n        // @docs-props-type ResultsMenuPropsBase\n                var B = (0, n.useState)(undefined), U = j(B, 2), z = U[0], V = U[1];\n        var K = (0, n.useState)(null), W = j(K, 2), $ = W[0], G = W[1];\n        var X = (0, n.useState)(null), J = j(X, 2), Q = J[0], Y = J[1];\n        var Z = (0, n.useState)(0), ee = j(Z, 2), re = ee[0], ne = ee[1];\n        var te = (0, n.useState)(0), oe = j(te, 2), ae = oe[0], ie = oe[1];\n        var ue = (0, n.useState)(false), le = j(ue, 2), ce = le[0], se = le[1];\n        var fe = (0, n.useCallback)((function(e) {\n            Y(e);\n        }), []);\n        var de = (0, n.useCallback)((function(e) {\n            G(e);\n            C(c, e);\n        }), [ c ]);\n        var ve = (0, n.useCallback)((function() {\n            ie(document.documentElement.scrollTop);\n        }), []);\n        var me = (0, n.useCallback)((function() {\n            ie(document.documentElement.scrollTop);\n        }), []);\n        var be = (0, n.useCallback)((function(e) {\n            // Safety net to ensure window doesn\'t scroll if menu is scrolled pass the numberOfItemsLoaded at high velocity.\n            e.stopPropagation();\n            document.documentElement.scrollTop = ae;\n        }), [ ae ]);\n        var pe = (0, n.useCallback)((function() {\n            return !!Q && Q.scrollHeight === Q.offsetHeight;\n        }), [ Q ]);\n        var ye = (0, n.useCallback)((function(e) {\n            if (!ce) {\n                se(true);\n                x === null || x === void 0 ? void 0 : x(e);\n            }\n        }), [ ce, x ]);\n        var ge = (0, n.useCallback)((function(e) {\n            if (x && e.target && Q) {\n                var r = Q.scrollHeight - Q.offsetHeight - N;\n                // Adding 1 due to border of menu item.\n                                if (Q.scrollTop + 1 >= r) {\n                    ye(e);\n                }\n            }\n            P === null || P === void 0 ? void 0 : P(e);\n        }), [ ye, Q, P, x ]);\n        var he = (0, n.useCallback)((function() {\n            var e = n.Children.count(a);\n            // If menu is full length, load more items.\n                        if (pe()) {\n                ye(null);\n            }\n            // Avoid triggering this logic if this.state.childrenCount is null\n            // because that\'s not a real change in the number of children\n            // and thus we want to avoid resetting the value of scrollBottomTriggered\n                        if (z != null && e !== z) {\n                ne(e - (z !== null && z !== void 0 ? z : 0));\n                se(false);\n            }\n            if (e !== z) {\n                V(e);\n            }\n        }), [ pe, a, z, ye ]);\n        (0, n.useEffect)((function() {\n            if (!$ || !Q) {\n                return;\n            }\n            // If onScrollBottom is defined, determine if it should be triggered.\n                        if (x && a) {\n                he();\n            }\n        }), [ $, Q, a, x, he ]);\n        // Assumption: that you cannot be filtered if you are a result\n                var Se = n.Children.toArray(a).filter(n.isValidElement).some((function(e) {\n            var r = e.type;\n            return !(r.as === "Divider" && r.filterFirst || (r.as === "Divider" || r.as === "Heading") && (r.filterLast || r.filterConsecutive));\n        }));\n        var Ee = pe();\n        var Oe = (0, n.useMemo)((function() {\n            return {\n                height: ce ? re * H : 0\n            };\n        }), [ ce, re ]);\n        var Me = !Se && !!R && !v;\n        var we = (0, n.useCallback)((function() {\n            return {\n                role: "listbox",\n                preventFocus: s === "never"\n            };\n        }), [ s ]);\n        var Ce = (0, n.useCallback)((function() {\n            var e = !!n.Children.toArray(a).length;\n            return d && e &&  t().createElement(t().Fragment, null, A !== "above" &&  t().createElement(u(), null),  t().createElement(S, {\n                "data-test": "footer-message",\n                key: "footer"\n            }, d), A === "above" &&  t().createElement(u(), null));\n        }), [ d, a, A ]);\n        \n        return t().createElement(h, k({\n            "data-test": "results-menu",\n            key: "wrapper",\n            ref: de,\n            onWheel: x ? be : undefined,\n            onMouseEnter: x ? ve : undefined,\n            onMouseLeave: x ? me : undefined\n        }, F, {\n            style: L\n        }), A !== "above" && i, A === "above" && Ce(),  t().createElement(l.MenuContext.Provider, {\n            value: we()\n        },  t().createElement(g, {\n            "aria-multiselectable": o,\n            "aria-labelledby": m,\n            elementRef: fe,\n            focusMode: s,\n            id: y,\n            key: "menu",\n            onScroll: ge,\n            stopScrollPropagation: true,\n            tabIndex: _\n        }, Me &&  t().createElement(O, {\n            "data-test": "no-results-message",\n            disabled: true\n        }, R), a, x && !Ee && \n        \n        // Bottom spacer fills in the space of new items being loaded by using the minimum possible height x menuItems.\n        t().createElement("div", {\n            "data-test": "results-menu-bottom-spacer",\n            style: Oe\n        }), v &&  t().createElement(E, null, r &&  t().createElement(M, null),  t().createElement(w, null, p)))),  t().createElement(f(), {\n            "aria-live": "polite"\n        }, Me && R), A !== "above" && Ce(), A === "above" && i);\n    }\n    F.propTypes = _;\n    /* harmony default export */    const B = F;\n    // CONCATENATED MODULE: external "lodash/omit"\n    const U = __webpack_require__(36728);\n    var z =  e.n(U);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/focus"\n    const V = __webpack_require__(14412);\n    // CONCATENATED MODULE: ./src/ResultsMenu/VirtualizedResultsMenu/groupChildren.ts\n    // Cheap(er than processing potentially thousands of array elements) memoization\n    var K = {\n        result: []\n    };\n    /**\n * Given component children, restructure them into an array of arrays, each of length `groupSize`.\n *\n * The last array is not guaranteed to be full, it will have a length in the range `[1, groupSize]`\n *\n * @example\n * ```js\n * groupChildren([1, 2, 3, 4, 5, 6, 7], 2);\n * // > [[1, 2], [3, 4], [5, 6], [7]]\n * ```\n * @param {Array} children One node, or an array of nodes, to be divided into groups\n * @param {number} groupSize The size of each group to be created\n * @returns A 2d array where each inner-array is a group of size `groupSize` of children\n * and the order of the `children` received equals the order of the flattened result\n */    var W = function e(r, t) {\n        if (K.children === r && K.groupSize === t) {\n            return K.result;\n        }\n        K.children = r;\n        K.groupSize = t;\n        if (t <= 1) {\n            if (false) // removed by dead control flow\n{}\n            // don\'t break in non-__DEV__ and return one big group\n                        K.result = [ n.Children.toArray(r) ];\n        } else {\n            K.result = n.Children.toArray(r).reduce((function(e, r, n) {\n                var o = Math.floor(n / t);\n                if (!Array.isArray(e[o])) {\n                    // eslint-disable-next-line no-param-reassign\n                    e[o] = [];\n                }\n                e[o].push(r);\n                return e;\n            }), []);\n        }\n        return K.result;\n    };\n    // CONCATENATED MODULE: external "@splunk/ui-utils/id"\n    const $ = __webpack_require__(66115);\n    // CONCATENATED MODULE: ./src/ResultsMenu/VirtualizedResultsMenu/VirtualizedItem.ts\n    // This wrapper should only be used with Menu.Item/derivatives thereof, so omitting Heading/Divider is fine\n    var G = {\n        children: a().node,\n        onMount: a().func.isRequired,\n        onUnmount: a().func.isRequired\n    };\n    /** @private Used by `VirtualizedResultsMenu` */    var X =  t().forwardRef((function(e, r) {\n        var t = e.children, o = e.onMount, a = e.onUnmount;\n        // @docs-props-type VirtualizedItemPropsBase\n                var i = (0, n.useRef)(null);\n        (0, n.useEffect)((function() {\n            var e = i.current;\n            if (e) {\n                o(e);\n            }\n            return function() {\n                if (e) {\n                    a(e);\n                }\n            };\n        }), [ o, a ]);\n        var u = n.Children.only(t);\n        if (!u) {\n            if (false) // removed by dead control flow\n{}\n            return null;\n        }\n        \n        return (0, n.cloneElement)(u, {\n            elementRef: function e(n) {\n                i.current = n;\n                C(r, n);\n            }\n        });\n    }));\n    X.propTypes = G;\n    X.as = "Item";\n    // CONCATENATED MODULE: ./src/ResultsMenu/VirtualizedResultsMenu/injectVirtualizedItem.tsx\n    /**\n * Find the index of an array element which is nearest to targetIndex and is a Menu.Item component\n * @param {Array} elements An array to search\n * @param {Number} targetIndex The target index. This is the ideal value to return.\n * @returns The index in the array of the nearest `Menu.Item` component to `targetIndex`, or -1 if no element is a `Menu.Item` component\n */\n    var J = function e(r, n) {\n        var t = -1;\n        var o = -1;\n        r.forEach((function(e, r) {\n            var a = Math.abs(n - r);\n            if (t >= 0 && t < a) {\n                return;\n            }\n            if (e.type !== l.Divider && e.type !== l.Heading) {\n                t = a;\n                o = r;\n            }\n        }));\n        return o;\n    };\n    /**\n * @private Keep the injection of `VirtualizedItem` DRY. Will always replace the middle-most non-divider/heading\n * with a VirtualizedItem instance.\n * - If `trackFirstElement` the **FIRST** non-divider/heading item will also be replaced.\n * - If `trackLastElement` the **LAST** non-divider/heading item will also be replaced.\n */    var Q = function e(r, n, o) {\n        var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {}, i = a.trackFirstElement, u = a.trackLastElement;\n        if (!Array.isArray(r)) {\n            return [];\n        }\n        var l = J(r, Math.floor(r.length / 2));\n        var c = i && J(r, 0);\n        var s = u && J(r, r.length - 1);\n        return r.map((function(e, r) {\n            if (r === l || r === c || r === s) {\n                \n                return t().createElement(X, {\n                    key: (0, $.createGUID)(),\n                    onMount: n,\n                    onUnmount: o\n                }, e);\n            }\n            return e;\n        }));\n    };\n    // CONCATENATED MODULE: ./src/ResultsMenu/VirtualizedResultsMenu/VirtualizedResultsMenu.tsx\n    function Y(e) {\n        "@babel/helpers - typeof";\n        return Y = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {\n            return typeof e;\n        } : function(e) {\n            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;\n        }, Y(e);\n    }\n    function Z() {\n        return Z = Object.assign ? Object.assign.bind() : function(e) {\n            for (var r = 1; r < arguments.length; r++) {\n                var n = arguments[r];\n                for (var t in n) {\n                    ({}).hasOwnProperty.call(n, t) && (e[t] = n[t]);\n                }\n            }\n            return e;\n        }, Z.apply(null, arguments);\n    }\n    function ee(e) {\n        return te(e) || ne(e) || ie(e) || re();\n    }\n    function re() {\n        throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function ne(e) {\n        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) return Array.from(e);\n    }\n    function te(e) {\n        if (Array.isArray(e)) return ue(e);\n    }\n    function oe(e, r) {\n        return ce(e) || le(e, r) || ie(e, r) || ae();\n    }\n    function ae() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function ie(e, r) {\n        if (e) {\n            if ("string" == typeof e) return ue(e, r);\n            var n = {}.toString.call(e).slice(8, -1);\n            return "Object" === n && e.constructor && (n = e.constructor.name), "Map" === n || "Set" === n ? Array.from(e) : "Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n) ? ue(e, r) : void 0;\n        }\n    }\n    function ue(e, r) {\n        (null == r || r > e.length) && (r = e.length);\n        for (var n = 0, t = Array(r); n < r; n++) {\n            t[n] = e[n];\n        }\n        return t;\n    }\n    function le(e, r) {\n        var n = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != n) {\n            var t, o, a, i, u = [], l = !0, c = !1;\n            try {\n                if (a = (n = n.call(e)).next, 0 === r) {\n                    if (Object(n) !== n) return;\n                    l = !1;\n                } else for (;!(l = (t = a.call(n)).done) && (u.push(t.value), u.length !== r); l = !0) {\n                }\n            } catch (e) {\n                c = !0, o = e;\n            } finally {\n                try {\n                    if (!l && null != n["return"] && (i = n["return"](), Object(i) !== i)) return;\n                } finally {\n                    if (c) throw o;\n                }\n            }\n            return u;\n        }\n    }\n    function ce(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function se(e, r) {\n        if (null == e) return {};\n        var n, t, o = fe(e, r);\n        if (Object.getOwnPropertySymbols) {\n            var a = Object.getOwnPropertySymbols(e);\n            for (t = 0; t < a.length; t++) {\n                n = a[t], -1 === r.indexOf(n) && {}.propertyIsEnumerable.call(e, n) && (o[n] = e[n]);\n            }\n        }\n        return o;\n    }\n    function fe(e, r) {\n        if (null == e) return {};\n        var n = {};\n        for (var t in e) {\n            if ({}.hasOwnProperty.call(e, t)) {\n                if (-1 !== r.indexOf(t)) continue;\n                n[t] = e[t];\n            }\n        }\n        return n;\n    }\n    function de(e, r) {\n        var n = Object.keys(e);\n        if (Object.getOwnPropertySymbols) {\n            var t = Object.getOwnPropertySymbols(e);\n            r && (t = t.filter((function(r) {\n                return Object.getOwnPropertyDescriptor(e, r).enumerable;\n            }))), n.push.apply(n, t);\n        }\n        return n;\n    }\n    function ve(e) {\n        for (var r = 1; r < arguments.length; r++) {\n            var n = null != arguments[r] ? arguments[r] : {};\n            r % 2 ? de(Object(n), !0).forEach((function(r) {\n                me(e, r, n[r]);\n            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(n)) : de(Object(n)).forEach((function(r) {\n                Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(n, r));\n            }));\n        }\n        return e;\n    }\n    function me(e, r, n) {\n        return (r = be(r)) in e ? Object.defineProperty(e, r, {\n            value: n,\n            enumerable: !0,\n            configurable: !0,\n            writable: !0\n        }) : e[r] = n, e;\n    }\n    function be(e) {\n        var r = pe(e, "string");\n        return "symbol" == Y(r) ? r : r + "";\n    }\n    function pe(e, r) {\n        if ("object" != Y(e) || !e) return e;\n        var n = e[Symbol.toPrimitive];\n        if (void 0 !== n) {\n            var t = n.call(e, r || "default");\n            if ("object" != Y(t)) return t;\n            throw new TypeError("@@toPrimitive must return a primitive value.");\n        }\n        return ("string" === r ? String : Number)(e);\n    }\n    // eslint-disable-next-line no-relative-imports-of-published -- TODO(SUI-8190): VirtualizedResultsMenu wraps ResultsMenu, using external import creates circular dependency\n    // TODO(SUI-5920): add transitions to this component in React 18\n        var ye = ve(ve({}, z()(_, "onDownKeyPress", "onEndKeyPress", "onHomeKeyPress", "onUpKeyPress")), {}, {\n        virtualization: a().number\n    });\n    var ge = [];\n    /**\n * A wrapper for `ResultsMenu` which virtualizes the `children`. The received `children` array will be split into **"panes"** each with `virtualization` entries\n * and, at any given time, 3 or fewer of these panes will be rendered in the DOM.\n *\n * Given the children `[1, 2, 3, 4, 5, 6, 7, 8, 9]` and `virtualization=4`, then at first only elements `[1, 2, 3, 4, 5, 6, 7, 8]` will be added to the DOM.\n * Once either child `6` or `8` intersect the `Menu` rendered by `ResultsMenu` the next pane of children will also be included and, if needed, the oldest pane\n * will be removed.\n *\n * In effect this means the menu will show the "central" content at pane index _`n`_, a previous-content-buffer comprised of pane index _`n - 1`_,\n * and an upcoming-content-buffer comprised of pane index _`n + 1`_.\n *\n * An `IntersectionObserver` will observe the first node in the _`n - 1`_ pane, the last node in the _`n + 1`_ pane, and the central node in both _`n ± 1`_ panes\n * for intersections with the rendered `Menu` and trigger a *pane change* upon that intersection. As such, in SSR or other environments which don\'t support `IntersectionObserver`\n * this component should not be used and will be replaced by the barrel file with a vanilla `ResultsMenu`.\n *\n * @throws in `__DEV__` when `virtualization` is too small as compared to the menu height (`virtualization` must be greater than the number of visible items in the rendered menu)\n * @throws in `__DEV__` when `virtualization` is less than or equal to 1 (`virtualization` must be ≥ 2)\n * @throws in `__DEV__` when `virtualization` is changed during the lifecycle of the `VirtualizedResultsMenu` component\n */    function he(e) {\n        var r = e.virtualization, o = r === void 0 ? 2 : r, a = e.elementRef, i = e.children, u = e.focusMode, l = u === void 0 ? "normal" : u, c = se(e, [ "virtualization", "elementRef", "children", "focusMode" ]);\n        // @docs-props-type VirtualizedResultsMenuPropsBase\n                var s = (0, n.useRef)(o);\n        // If a user tries to set virtualization to a value smaller than the number of options\n        // visible at a given moment then the menu will flicker endlessly. This state is set in\n        // the IntersectionObserver to fix the issue, but in `__DEV__` an error is thrown.\n                var f = (0, n.useState)(o), d = oe(f, 2), v = d[0], m = d[1];\n // these refs keep track of whether we need to focus the first/last\n        // element after the next render\n                var b = (0, n.useRef)(false);\n        var p = (0, n.useRef)(false);\n        var y = (0, n.useRef)(i);\n        // this code makes the "Home" and "End" keys work by injecting\n        // an elementRef callback function into the first and last item\n        // that will attempt to focus the first/last item if appropriate\n        // we need to do this because if we call focus() right after changePane()\n        // the new pane won\'t be in the DOM yet, so the wrong element will end up focused\n                (0, n.useMemo)((function() {\n            var e = n.Children.toArray(i);\n            var r = J(e, 0);\n            var t = J(e, e.length - 1);\n            y.current = e.map((function(e, o) {\n                var a = e;\n                if (o === r) {\n                    a =  (0, n.isValidElement)(e) ?  (0, n.cloneElement)(e, {\n                        elementRef: function e(r) {\n                            if (b === null || b === void 0 ? void 0 : b.current) {\n                                b.current = false;\n                                r === null || r === void 0 ? void 0 : r.focus();\n                            }\n                        }\n                    }) : e;\n                } else if (o === t) {\n                    a =  (0, n.isValidElement)(e) ?  (0, n.cloneElement)(e, {\n                        elementRef: function e(r) {\n                            if (p === null || p === void 0 ? void 0 : p.current) {\n                                p.current = false;\n                                r === null || r === void 0 ? void 0 : r.focus();\n                            }\n                        }\n                    }) : e;\n                }\n                return a;\n            }));\n        }), [ i ]);\n        var g = y.current;\n        (0, n.useEffect)((function() {\n            if (false) // removed by dead control flow\n{}\n        }), [ o ]);\n        // `useRef` will recompute its initial value every render cycle.\n        // To avoid the array processing we can provide an initialization function to useState and init the ref with the result\n                var h = (0, n.useState)((function() {\n            return W(g, v);\n        })), S = oe(h, 1), E = S[0];\n // NOSONAR\n        // `windowPanes` is an array of arrays, each of length `virtualization`. Each "pane" is just a subset of\n        // `children` which will be rendered in a chunk, and at most 3 of these panes will render at any given time.\n                var O = (0, n.useRef)(E);\n        var M = (0, n.useRef)(0);\n        var w = (0, n.useRef)(null);\n        // An IntersectionObserver is used to detect when pane changes are needed.\n        // When loadPrevPaneRef or loadNextPaneRef entries intersect the menu, the currentPaneId will be updated.\n                var k = (0, n.useRef)();\n        var j = (0, n.useRef)(ge);\n        var I = (0, n.useRef)(ge);\n        var R = (0, n.useCallback)((function() {\n            var e;\n            var r = O.current, n = r === void 0 ? [] : r;\n            var t = M.current;\n            /**\n     * create onMount for an child of the menu which will be used to trigger pane\n     * changes upon intersection with the menu\'s visible bounds\n     */            var o = function e(r) {\n                return function(e) {\n                    var n;\n                    if (!e) {\n                        return;\n                    }\n                    r.current.push(e);\n                    (n = k.current) === null || n === void 0 ? void 0 : n.observe(e);\n                };\n            };\n            /**\n     * onUnmount to cleanup the operations of `onVirtualizeMount`\n     */            var a = function e(r) {\n                var n;\n                if (!r) {\n                    return;\n                }\n                var t = I.current.indexOf(r);\n                if (t >= 0) {\n                    I.current.splice(t, 1);\n                }\n                var o = j.current.indexOf(r);\n                if (o) {\n                    j.current.splice(o, 1);\n                }\n                (n = k.current) === null || n === void 0 ? void 0 : n.unobserve(r);\n            };\n            return [].concat(ee(Q(n[t - 1], o(I), a, {\n                trackFirstElement: true\n            })), ee((e = n[t]) !== null && e !== void 0 ? e : []), ee(Q(n[t + 1], o(j), a, {\n                trackLastElement: true\n            })));\n        }), []);\n        var P = (0, n.useState)(R), x = oe(P, 2), A = x[0], T = x[1];\n        var L = (0, n.useCallback)((function(e) {\n            var r = M.current;\n            M.current = Math.max(0, Math.min(e, O.current.length - 1));\n            if (r === M.current) {\n                // no change in current pane\n                return;\n            }\n            T(R);\n        }), [ R ]);\n        // Link an IntersectionObserver instance with the menu children to be observed\n                var _ = (0, n.useCallback)((function(e) {\n            var r;\n            C(a, e);\n            w.current = e;\n            // This is overly defensive and could probably be removed\n                        (r = k.current) === null || r === void 0 ? void 0 : r.disconnect();\n            if (!e) {\n                return;\n            }\n            I.current = [];\n            j.current = [];\n            // Run the observation flow\n                        k.current = new IntersectionObserver((function(r) {\n                var n;\n                var t = M.current;\n                var o = e.firstElementChild;\n                if (!!o && o.scrollHeight < e.clientHeight) {\n                    var a;\n                    // If the first element doesn\'t require a scrollbar then it\'s likely a filter input\n                                        o = (a = o) === null || a === void 0 ? void 0 : a.nextElementSibling;\n                }\n                if (((n = o) === null || n === void 0 ? void 0 : n.scrollTop) === 0 && t === 0 && O.current.length > 1 && r.some((function(e) {\n                    return e.isIntersecting;\n                }))) {\n                    // The menu hasn\'t scrolled, is on pane 0, and already has an intersection, the `virtualization` prop is too small\n                    m((function(e) {\n                        return e + 10;\n                    }));\n                    if (false) // removed by dead control flow\n{}\n                    return;\n                }\n                var i = false;\n                r.forEach((function(e) {\n                    if (i || !e.isIntersecting) {\n                        // don\'t process if the pane changed or the entry isn\'t intersecting\n                        return;\n                    }\n                    if (I.current.includes(e.target)) {\n                        i = true;\n                        L(t - 1);\n                    } else if (j.current.includes(e.target)) {\n                        i = true;\n                        L(t + 1);\n                    }\n                }));\n            }), {\n                root: e\n            });\n        }), [ a, L ]);\n        var q = (0, n.useCallback)((function(e) {\n            var r = w.current;\n            if (!r) {\n                return;\n            }\n            e.preventDefault();\n            var n = e.key;\n            if (n === "Home") {\n                var t = M.current === 0;\n                if (t) {\n                    var o;\n                    // if the first pane is already rendered, find the first element and focus it\n                                        var a = (0, V.getSortedTabbableElements)(r, {\n                        ignoreTabIndex: true\n                    });\n                    var i = a[0];\n                    i === null || i === void 0 ? void 0 : (o = i.focus) === null || o === void 0 ? void 0 : o.call(i);\n                } else {\n                    // if it\'s not rendered, set up focusing it after the next render\n                    b.current = true;\n                    // then call changePane() to trigger the render\n                                        L(0);\n                }\n                return;\n            }\n            var u = O.current.length - 1;\n            if (n === "End") {\n                var l = M.current === u;\n                if (l) {\n                    var c;\n                    // if the last pane is already rendered, find the first element and focus it\n                                        var s = (0, V.getSortedTabbableElements)(r, {\n                        ignoreTabIndex: true\n                    });\n                    var f = s[s.length - 1];\n                    f === null || f === void 0 ? void 0 : (c = f.focus) === null || c === void 0 ? void 0 : c.call(f);\n                } else {\n                    // if it\'s not rendered, set up focusing it after the next render\n                    p.current = true;\n                    // then call changePane() to trigger the render\n                                        L(u);\n                }\n                return;\n            }\n            var d = (0, V.getSortedTabbableElements)(r, {\n                ignoreTabIndex: true\n            });\n            var v = (e === null || e === void 0 ? void 0 : e.target) instanceof Element ? e.target : null;\n            var m = r === null || r === void 0 ? void 0 : r.querySelector(":focus");\n            var y = v || m;\n            var g = y ? d.indexOf(y) : -1;\n            (0, V.handleFocus)(n, d, g, {\n                enableLoop: false,\n                // VirtualizedResultsMenu does not support looping focus\n                orientation: "vertical",\n                enableTab: false,\n                enableHomeEnd: false\n            });\n        }), [ L ]);\n        (0, n.useEffect)((function() {\n            m((function(e) {\n                if (false) // removed by dead control flow\n{}\n                return o;\n            }));\n        }), [ o ]);\n        (0, n.useEffect)((function() {\n            O.current = W(g, v);\n            T(R);\n        }), [ g, v, R ]);\n        (0, n.useEffect)((function() {\n            return function() {\n                var e;\n                return (e = k.current) === null || e === void 0 ? void 0 : e.disconnect();\n            };\n        }), []);\n        (0, n.useEffect)((function() {\n            if (l === "never") {\n                return undefined;\n            }\n            var e = w.current;\n            if (e) {\n                e.addEventListener("keydown", q);\n            }\n            return function() {\n                e === null || e === void 0 ? void 0 : e.removeEventListener("keydown", q);\n            };\n        }), [ q, l ]);\n        \n        return t().createElement(B, Z({\n            elementRef: _,\n            focusMode: l\n        }, c), A);\n    }\n    he.propTypes = ye;\n    // CONCATENATED MODULE: ./src/utils/ssrDocument.ts\n    /* eslint-disable @typescript-eslint/no-empty-function */\n    var Se = {\n        body: {\n            appendChild: function e() {\n                return [];\n            }\n        },\n        addEventListener: function e() {},\n        removeEventListener: function e() {},\n        activeElement: {\n            blur: function e() {},\n            nodeName: ""\n        },\n        querySelector: function e() {\n            return null;\n        },\n        querySelectorAll: function e() {\n            return [];\n        },\n        getElementById: function e() {\n            return null;\n        },\n        createEvent: function e() {\n            return {\n                initEvent: function e() {}\n            };\n        },\n        createElement: function e() {\n            return {\n                children: [],\n                childNodes: [],\n                style: {},\n                setAttribute: function e() {},\n                getElementsByTagName: function e() {\n                    return [];\n                }\n            };\n        },\n        createElementNS: function e() {\n            return {};\n        },\n        importNode: function e() {\n            return null;\n        },\n        location: {\n            hash: "",\n            host: "",\n            hostname: "",\n            href: "",\n            origin: "",\n            pathname: "",\n            protocol: "",\n            search: ""\n        }\n    };\n    function Ee() {\n        var e = typeof document !== "undefined" ? document : Se;\n        return e;\n    }\n    var Oe = Ee();\n    /* harmony default export */    const Me = /* unused pure expression or super */ null && 0;\n    // CONCATENATED MODULE: ./src/utils/ssrWindow.ts\n    /* eslint-disable @typescript-eslint/no-empty-function */\n    var we = {\n        document: Se,\n        navigator: {\n            userAgent: ""\n        },\n        location: {\n            hash: "",\n            host: "",\n            hostname: "",\n            href: "",\n            origin: "",\n            pathname: "",\n            protocol: "",\n            search: ""\n        },\n        history: {\n            replaceState: function e() {},\n            pushState: function e() {},\n            go: function e() {},\n            back: function e() {}\n        },\n        CustomEvent: function e() {\n            return this;\n        },\n        addEventListener: function e() {},\n        removeEventListener: function e() {},\n        getComputedStyle: function e() {\n            return {\n                getPropertyValue: function e() {\n                    return "";\n                }\n            };\n        },\n        Image: function e() {},\n        Date: function e() {},\n        screen: {},\n        setTimeout: function e() {},\n        clearTimeout: function e() {},\n        matchMedia: function e() {\n            return {};\n        },\n        requestAnimationFrame: function e(r) {\n            if (typeof setTimeout === "undefined") {\n                r();\n                return null;\n            }\n            return setTimeout(r, 0);\n        },\n        cancelAnimationFrame: function e(r) {\n            if (typeof setTimeout === "undefined") {\n                return;\n            }\n            clearTimeout(r);\n        }\n    };\n    function Ce() {\n        var e = typeof window !== "undefined" ? window : we;\n        return e;\n    }\n    var ke = Ce();\n    /* harmony default export */    const je = /* unused pure expression or super */ null && 0;\n    // CONCATENATED MODULE: ./src/ResultsMenu/VirtualizedResultsMenu/index.ts\n    // eslint-disable-next-line no-relative-imports-of-published --  TODO(SUI-8190): VirtualizedResultsMenu wraps ResultsMenu, using external import creates circular dependency\n    // In environments without IntersectionObserver support this should just export ResultsMenu\n    var Ie = "IntersectionObserver" in Ce() ? he : B;\n    /* harmony default export */    const Re = Ie;\n    // CONCATENATED MODULE: ./src/ResultsMenu/index.ts\n    module.exports = r;\n    /******/})();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTgzLmpzIiwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQU87QUFDN0I7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFZO0FBQ2xDO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBMEI7QUFDaEQ7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxJQUF1QjtBQUM3QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQXNDO0FBQzVEO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBdUI7QUFDN0M7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBbUI7QUFDekM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUE4QjtBQUNwRDtBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQWdCO0FBQ3RDO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyxtQkFBbUIsc0JBQXNCO0FBQzlDO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVSxzQkFBc0IsOEJBQThCLG1CQUFtQixzQkFBc0IsMkJBQTJCLDRCQUE0QiwyQkFBMkIsMEJBQTBCLDBCQUEwQix5QkFBeUI7QUFDM1E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx1QkFBdUIsV0FBVztBQUN2QztBQUNBO0FBQ0E7QUFDQSxLQUFLLFVBQVUsa0JBQWtCLFNBQVM7QUFDMUM7QUFDQTtBQUNBO0FBQ0EsS0FBSyx5Q0FBeUMsWUFBWTtBQUMxRDtBQUNBO0FBQ0E7QUFDQSxLQUFLLG1CQUFtQjtBQUN4QjtBQUNBO0FBQ0E7QUFDQSxLQUFLLGdCQUFnQixXQUFXO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw0QkFBNEIsc0JBQXNCO0FBQ2xEO0FBQ0E7QUFDQSx1QkFBdUI7QUFDdkI7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQ0FBc0MsT0FBTztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IsV0FBVyxrRUFBa0U7QUFDL0Y7QUFDQSxjQUFjO0FBQ2Q7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBLFNBQVM7QUFDVDtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQWE7QUFDbkM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUF3QjtBQUM5QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEIsV0FBVyxRQUFRO0FBQ25CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGdCQUFnQixLQUFLLEVBQUU7QUFBQSxFQUFFO0FBQ3pCO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFxQjtBQUMzQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLGdCQUFnQixLQUFLLEVBQUU7QUFBQSxFQUFFO0FBQ3pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1QsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEIsV0FBVyxRQUFRO0FBQ25CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNGQUFzRjtBQUN0RjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSw0QkFBNEIsc0JBQXNCO0FBQ2xEO0FBQ0E7QUFDQSx1QkFBdUI7QUFDdkI7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQ0FBc0MsT0FBTztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IsV0FBVyxrRUFBa0U7QUFDL0Y7QUFDQSxjQUFjO0FBQ2Q7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLHNCQUFzQjtBQUM5QztBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5QkFBeUIsa0ZBQWtGO0FBQzNHO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQixrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBLGdCQUFnQixLQUFLLEVBQUU7QUFBQSxFQUFFO0FBQ3pCLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0EsYUFBYTtBQUNiLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQix3QkFBd0IsS0FBSyxFQUFFO0FBQUEsRUFBRTtBQUNqQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQixhQUFhO0FBQ2I7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQSxvQkFBb0IsS0FBSyxFQUFFO0FBQUEsRUFBRTtBQUM3QjtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1QseUNBQXlDO0FBQ3pDLDRDQUE0QztBQUM1QztBQUNBLGlDQUFpQztBQUNqQztBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlCQUF5QjtBQUN6Qiw2Q0FBNkM7QUFDN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNkZBQTZGLENBQUU7QUFDL0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBLHlDQUF5QztBQUN6QyxzQ0FBc0M7QUFDdEMsK0JBQStCO0FBQy9CO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1QseUNBQXlDO0FBQ3pDLDRDQUE0QztBQUM1QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1QsOEJBQThCO0FBQzlCLDZCQUE2QjtBQUM3QixrQkFBa0I7QUFDbEIsbUNBQW1DO0FBQ25DLHFDQUFxQztBQUNyQztBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw2RkFBNkYsQ0FBRTtBQUMvRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWEiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL0BzcGx1bmsvcmVhY3QtdWkvUmVzdWx0c01lbnUuanM/NzFhNyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqLyAoKCkgPT4ge1xuICAgIC8vIHdlYnBhY2tCb290c3RyYXBcbiAgICAvKioqKioqLyBcInVzZSBzdHJpY3RcIjtcbiAgICAvKioqKioqLyAvLyBUaGUgcmVxdWlyZSBzY29wZVxuICAgIC8qKioqKiovICAgIHZhciBlID0ge307XG4gICAgLyoqKioqKi9cbiAgICAvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqL1xuICAgIC8qKioqKiovIC8qIHdlYnBhY2svcnVudGltZS9jb21wYXQgZ2V0IGRlZmF1bHQgZXhwb3J0ICovXG4gICAgLyoqKioqKi8gICAgKCgpID0+IHtcbiAgICAgICAgLyoqKioqKi8gLy8gZ2V0RGVmYXVsdEV4cG9ydCBmdW5jdGlvbiBmb3IgY29tcGF0aWJpbGl0eSB3aXRoIG5vbi1oYXJtb255IG1vZHVsZXNcbiAgICAgICAgLyoqKioqKi8gZS5uID0gciA9PiB7XG4gICAgICAgICAgICAvKioqKioqLyB2YXIgbiA9IHIgJiYgci5fX2VzTW9kdWxlID8gXG4gICAgICAgICAgICAvKioqKioqLyAoKSA9PiByW1wiZGVmYXVsdFwiXVxuICAgICAgICAgICAgLyoqKioqKi8gOiAoKSA9PiByXG4gICAgICAgICAgICAvKioqKioqLztcbiAgICAgICAgICAgIGUuZChuLCB7XG4gICAgICAgICAgICAgICAgYTogblxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAvKioqKioqLyAgICAgICAgICAgIHJldHVybiBuO1xuICAgICAgICAgICAgLyoqKioqKi8gICAgICAgIH07XG4gICAgICAgIC8qKioqKiovICAgIH0pKCk7XG4gICAgLyoqKioqKi9cbiAgICAvKioqKioqLyAvKiB3ZWJwYWNrL3J1bnRpbWUvZGVmaW5lIHByb3BlcnR5IGdldHRlcnMgKi9cbiAgICAvKioqKioqLyAgICAoKCkgPT4ge1xuICAgICAgICAvKioqKioqLyAvLyBkZWZpbmUgZ2V0dGVyIGZ1bmN0aW9ucyBmb3IgaGFybW9ueSBleHBvcnRzXG4gICAgICAgIC8qKioqKiovIGUuZCA9IChyLCBuKSA9PiB7XG4gICAgICAgICAgICAvKioqKioqLyBmb3IgKHZhciB0IGluIG4pIHtcbiAgICAgICAgICAgICAgICAvKioqKioqLyBpZiAoZS5vKG4sIHQpICYmICFlLm8ociwgdCkpIHtcbiAgICAgICAgICAgICAgICAgICAgLyoqKioqKi8gT2JqZWN0LmRlZmluZVByb3BlcnR5KHIsIHQsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGVudW1lcmFibGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBnZXQ6IG5bdF1cbiAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgIC8qKioqKiovICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAvKioqKioqLyAgICAgICAgICAgIH1cbiAgICAgICAgICAgIC8qKioqKiovICAgICAgICB9O1xuICAgICAgICAvKioqKioqLyAgICB9KSgpO1xuICAgIC8qKioqKiovXG4gICAgLyoqKioqKi8gLyogd2VicGFjay9ydW50aW1lL2hhc093blByb3BlcnR5IHNob3J0aGFuZCAqL1xuICAgIC8qKioqKiovICAgICgoKSA9PiB7XG4gICAgICAgIC8qKioqKiovIGUubyA9IChlLCByKSA9PiBPYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5LmNhbGwoZSwgcilcbiAgICAgICAgLyoqKioqKi87XG4gICAgfSkoKTtcbiAgICAvKioqKioqL1xuICAgIC8qKioqKiovIC8qIHdlYnBhY2svcnVudGltZS9tYWtlIG5hbWVzcGFjZSBvYmplY3QgKi9cbiAgICAvKioqKioqLyAgICAoKCkgPT4ge1xuICAgICAgICAvKioqKioqLyAvLyBkZWZpbmUgX19lc01vZHVsZSBvbiBleHBvcnRzXG4gICAgICAgIC8qKioqKiovIGUuciA9IGUgPT4ge1xuICAgICAgICAgICAgLyoqKioqKi8gaWYgKHR5cGVvZiBTeW1ib2wgIT09IFwidW5kZWZpbmVkXCIgJiYgU3ltYm9sLnRvU3RyaW5nVGFnKSB7XG4gICAgICAgICAgICAgICAgLyoqKioqKi8gT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIFN5bWJvbC50b1N0cmluZ1RhZywge1xuICAgICAgICAgICAgICAgICAgICB2YWx1ZTogXCJNb2R1bGVcIlxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIC8qKioqKiovICAgICAgICAgICAgfVxuICAgICAgICAgICAgLyoqKioqKi8gICAgICAgICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgXCJfX2VzTW9kdWxlXCIsIHtcbiAgICAgICAgICAgICAgICB2YWx1ZTogdHJ1ZVxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAvKioqKioqLyAgICAgICAgfTtcbiAgICAgICAgLyoqKioqKi8gICAgfSkoKTtcbiAgICAvKioqKioqL1xuICAgIC8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiovICAgIHZhciByID0ge307XG4gICAgLy8gRVNNIENPTVBBVCBGTEFHXG4gICAgICAgIGUucihyKTtcbiAgICAvLyBFWFBPUlRTXG4gICAgICAgIGUuZChyLCB7XG4gICAgICAgIFZpcnR1YWxpemVkUmVzdWx0c01lbnU6ICgpID0+IC8qIHJlZXhwb3J0ICovIFJlLFxuICAgICAgICBkZWZhdWx0OiAoKSA9PiAvKiByZWV4cG9ydCAqLyBCXG4gICAgfSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJyZWFjdFwiXG4gICAgY29uc3QgbiA9IHJlcXVpcmUoXCJyZWFjdFwiKTtcbiAgICB2YXIgdCA9ICBlLm4obik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJwcm9wLXR5cGVzXCJcbiAgICBjb25zdCBvID0gcmVxdWlyZShcInByb3AtdHlwZXNcIik7XG4gICAgdmFyIGEgPSAgZS5uKG8pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS9EaXZpZGVyXCJcbiAgICBjb25zdCBpID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtdWkvRGl2aWRlclwiKTtcbiAgICB2YXIgdSA9ICBlLm4oaSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL01lbnVcIlxuICAgIGNvbnN0IGwgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9NZW51XCIpO1xuICAgIHZhciBjID0gIGUubihsKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvU2NyZWVuUmVhZGVyQ29udGVudFwiXG4gICAgY29uc3QgcyA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL1NjcmVlblJlYWRlckNvbnRlbnRcIik7XG4gICAgdmFyIGYgPSAgZS5uKHMpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay91aS11dGlscy9pMThuXCJcbiAgICBjb25zdCBkID0gcmVxdWlyZShcIkBzcGx1bmsvdWktdXRpbHMvaTE4blwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcInN0eWxlZC1jb21wb25lbnRzXCJcbiAgICBjb25zdCB2ID0gcmVxdWlyZShcInN0eWxlZC1jb21wb25lbnRzXCIpO1xuICAgIHZhciBtID0gIGUubih2KTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvV2FpdFNwaW5uZXJcIlxuICAgIGNvbnN0IGIgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9XYWl0U3Bpbm5lclwiKTtcbiAgICB2YXIgcCA9ICBlLm4oYik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3RoZW1lc1wiXG4gICAgY29uc3QgeSA9IHJlcXVpcmUoXCJAc3BsdW5rL3RoZW1lc1wiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9SZXN1bHRzTWVudS9SZXN1bHRzTWVudVN0eWxlcy50c1xuICAgIHZhciBnID0gbSgpKGMoKSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJlc3VsdHNNZW51U3R5bGVzX19TdHlsZWRNZW51XCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImF2YmhsOC0wXCJcbiAgICB9KShbIFwib3ZlcmZsb3c6YXV0bztmbGV4LWRpcmVjdGlvbjpjb2x1bW47XCIgXSk7XG4gICAgdmFyIGggPSBtKCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJSZXN1bHRzTWVudVN0eWxlc19fU3R5bGVkXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImF2YmhsOC0xXCJcbiAgICB9KShbIFwiXCIsIFwiO2ZsZXgtZGlyZWN0aW9uOmNvbHVtbjttYXgtaGVpZ2h0OmNhbGMoMTAwdmggLSAyMHB4KTtib3JkZXItcmFkaXVzOlwiLCBcIjtiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjsmID4gXCIsIFwiOm5vdCg6Zmlyc3QtY2hpbGQpe2JvcmRlci1zdGFydC1zdGFydC1yYWRpdXM6MDtib3JkZXItc3RhcnQtZW5kLXJhZGl1czowO30mID4gXCIsIFwiOm5vdCg6bGFzdC1jaGlsZCl7Ym9yZGVyLWVuZC1zdGFydC1yYWRpdXM6MDtib3JkZXItZW5kLWVuZC1yYWRpdXM6MDt9XCIgXSwgeS5taXhpbnMucmVzZXQoXCJmbGV4XCIpLCB5LnZhcmlhYmxlcy5ib3JkZXJSYWRpdXMsIHkudmFyaWFibGVzLmJhY2tncm91bmRDb2xvclBvcHVwLCBnLCBnKTtcbiAgICB2YXIgUyA9IG0oKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJlc3VsdHNNZW51U3R5bGVzX19TdHlsZWRGb290ZXJcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwiYXZiaGw4LTJcIlxuICAgIH0pKFsgXCJwYWRkaW5nOlwiLCBcIiBcIiwgXCI7Y29sb3I6XCIsIFwiO1wiIF0sIHkudmFyaWFibGVzLnNwYWNpbmdTbWFsbCwgeS52YXJpYWJsZXMuc3BhY2luZ0xhcmdlLCB5LnZhcmlhYmxlcy5jb250ZW50Q29sb3JEZWZhdWx0KTtcbiAgICB2YXIgRSA9IG0oKS5saS53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiUmVzdWx0c01lbnVTdHlsZXNfX1N0eWxlZExvYWRpbmdcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwiYXZiaGw4LTNcIlxuICAgIH0pKFsgXCJcIiwgXCI7cGFkZGluZzpcIiwgXCIgXCIsIFwiO2dhcDpcIiwgXCI7XCIgXSwgeS5taXhpbnMucmVzZXQoXCJmbGV4XCIpLCB5LnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsIHkudmFyaWFibGVzLnNwYWNpbmdMYXJnZSwgeS52YXJpYWJsZXMuc3BhY2luZ1hTbWFsbCk7XG4gICAgdmFyIE8gPSBtKCkoYygpLkl0ZW0pLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJSZXN1bHRzTWVudVN0eWxlc19fU3R5bGVkTm9PcHRpb25zXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImF2YmhsOC00XCJcbiAgICB9KShbIFwiJltkaXNhYmxlZF0sJlthcmlhLWRpc2FibGVkPSd0cnVlJ117Y29sb3I6XCIsIFwiO31cIiBdLCB5LnZhcmlhYmxlcy5jb250ZW50Q29sb3JEZWZhdWx0KTtcbiAgICB2YXIgTSA9IG0oKShwKCkpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJSZXN1bHRzTWVudVN0eWxlc19fU3R5bGVkV2FpdFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJhdmJobDgtNVwiXG4gICAgfSkoWyBcImZsZXg6MCAwIGF1dG87XCIgXSk7XG4gICAgdmFyIHcgPSBtKCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJSZXN1bHRzTWVudVN0eWxlc19fU3R5bGVkTG9hZGluZ01lc3NhZ2VcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwiYXZiaGw4LTZcIlxuICAgIH0pKFsgXCJmbGV4OjEgMCAwO2NvbG9yOlwiLCBcIjtcIiBdLCB5LnZhcmlhYmxlcy5jb250ZW50Q29sb3JEZWZhdWx0KTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy91dGlscy91cGRhdGVSZWFjdFJlZi50c1xuICAgIC8qKlxuICogVXBkYXRlcyBhIFJlYWN0IHJlZi4gQ2FsbGJhY2sgcmVmcyBhbmQgb2JqZWN0IHJlZnMgKGZyb20gYGNyZWF0ZVJlZmAgYW5kIGB1c2VSZWZgKSBhcmUgc3VwcG9ydGVkLlxuICpcbiAqIEBwYXJhbSByZWYgLSBUaGUgUmVhY3QgY2FsbGJhY2sgb3Igb2JqZWN0IHJlZi4gQ2FuIGJlIGBudWxsYCBvciBgdW5kZWZpbmVkYC5cbiAqIEBwYXJhbSBjdXJyZW50IC0gVGhlIG5ldyB2YWx1ZSBvZiB0aGUgcmVmLlxuICovXG4gICAgZnVuY3Rpb24gQyhlLCByKSB7XG4gICAgICAgIGlmIChlKSB7XG4gICAgICAgICAgICBpZiAodHlwZW9mIGUgPT09IFwiZnVuY3Rpb25cIikge1xuICAgICAgICAgICAgICAgIGUocik7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIHRoZSBwdWJsaWMgc2lnbmF0dXJlIG9mIHRoaXMgdXRpbCB1c2VzIFJlYWN0LlJlZjxUPiB0byBtaXJyb3IgdGhlIHdheSBSZWFjdCB0eXBlcyByZWZzLlxuICAgICAgICAgICAgICAgIC8vIHRoZSBpbnRlbnRpb24gaGVyZSBpcyB0byBzaWduYWwgXCJ3ZSB3aWxsIHRha2UgY2FyZSBvZiBzZXR0aW5nICdjdXJyZW50Jywgbm90IHlvdVwiLlxuICAgICAgICAgICAgICAgIGUuY3VycmVudCA9IHI7XG4gLy8gZXNsaW50LWRpc2FibGUtbGluZSBuby1wYXJhbS1yZWFzc2lnblxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1Jlc3VsdHNNZW51L1Jlc3VsdHNNZW51LnRzeFxuICAgIGZ1bmN0aW9uIGsoKSB7XG4gICAgICAgIHJldHVybiBrID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgciA9IDE7IHIgPCBhcmd1bWVudHMubGVuZ3RoOyByKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgbiA9IGFyZ3VtZW50c1tyXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciB0IGluIG4pIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKG4sIHQpICYmIChlW3RdID0gblt0XSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIGsuYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gaihlLCByKSB7XG4gICAgICAgIHJldHVybiBBKGUpIHx8IHgoZSwgcikgfHwgUihlLCByKSB8fCBJKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEkoKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gZGVzdHJ1Y3R1cmUgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFIoZSwgcikge1xuICAgICAgICBpZiAoZSkge1xuICAgICAgICAgICAgaWYgKFwic3RyaW5nXCIgPT0gdHlwZW9mIGUpIHJldHVybiBQKGUsIHIpO1xuICAgICAgICAgICAgdmFyIG4gPSB7fS50b1N0cmluZy5jYWxsKGUpLnNsaWNlKDgsIC0xKTtcbiAgICAgICAgICAgIHJldHVybiBcIk9iamVjdFwiID09PSBuICYmIGUuY29uc3RydWN0b3IgJiYgKG4gPSBlLmNvbnN0cnVjdG9yLm5hbWUpLCBcIk1hcFwiID09PSBuIHx8IFwiU2V0XCIgPT09IG4gPyBBcnJheS5mcm9tKGUpIDogXCJBcmd1bWVudHNcIiA9PT0gbiB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdChuKSA/IFAoZSwgcikgOiB2b2lkIDA7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gUChlLCByKSB7XG4gICAgICAgIChudWxsID09IHIgfHwgciA+IGUubGVuZ3RoKSAmJiAociA9IGUubGVuZ3RoKTtcbiAgICAgICAgZm9yICh2YXIgbiA9IDAsIHQgPSBBcnJheShyKTsgbiA8IHI7IG4rKykge1xuICAgICAgICAgICAgdFtuXSA9IGVbbl07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIGZ1bmN0aW9uIHgoZSwgcikge1xuICAgICAgICB2YXIgbiA9IG51bGwgPT0gZSA/IG51bGwgOiBcInVuZGVmaW5lZFwiICE9IHR5cGVvZiBTeW1ib2wgJiYgZVtTeW1ib2wuaXRlcmF0b3JdIHx8IGVbXCJAQGl0ZXJhdG9yXCJdO1xuICAgICAgICBpZiAobnVsbCAhPSBuKSB7XG4gICAgICAgICAgICB2YXIgdCwgbywgYSwgaSwgdSA9IFtdLCBsID0gITAsIGMgPSAhMTtcbiAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgaWYgKGEgPSAobiA9IG4uY2FsbChlKSkubmV4dCwgMCA9PT0gcikge1xuICAgICAgICAgICAgICAgICAgICBpZiAoT2JqZWN0KG4pICE9PSBuKSByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIGwgPSAhMTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgZm9yICg7IShsID0gKHQgPSBhLmNhbGwobikpLmRvbmUpICYmICh1LnB1c2godC52YWx1ZSksIHUubGVuZ3RoICE9PSByKTsgbCA9ICEwKSB7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgIGMgPSAhMCwgbyA9IGU7XG4gICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIGlmICghbCAmJiBudWxsICE9IG5bXCJyZXR1cm5cIl0gJiYgKGkgPSBuW1wicmV0dXJuXCJdKCksIE9iamVjdChpKSAhPT0gaSkpIHJldHVybjtcbiAgICAgICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoYykgdGhyb3cgbztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdTtcbiAgICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBBKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBUKGUsIHIpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgbiwgdCwgbyA9IEwoZSwgcik7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgYSA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICBmb3IgKHQgPSAwOyB0IDwgYS5sZW5ndGg7IHQrKykge1xuICAgICAgICAgICAgICAgIG4gPSBhW3RdLCAtMSA9PT0gci5pbmRleE9mKG4pICYmIHt9LnByb3BlcnR5SXNFbnVtZXJhYmxlLmNhbGwoZSwgbikgJiYgKG9bbl0gPSBlW25dKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbztcbiAgICB9XG4gICAgZnVuY3Rpb24gTChlLCByKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIG4gPSB7fTtcbiAgICAgICAgZm9yICh2YXIgdCBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCB0KSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gci5pbmRleE9mKHQpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICBuW3RdID0gZVt0XTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbjtcbiAgICB9XG4gICAgdmFyIF8gPSB7XG4gICAgICAgIGFuaW1hdGVMb2FkaW5nOiBhKCkuYm9vbCxcbiAgICAgICAgY2hpbGRyZW46IGEoKS5ub2RlLFxuICAgICAgICBjaGlsZHJlblN0YXJ0OiBhKCkubm9kZSxcbiAgICAgICAgZWxlbWVudFJlZjogYSgpLm9uZU9mVHlwZShbIGEoKS5mdW5jLCBhKCkub2JqZWN0IF0pLFxuICAgICAgICBmb2N1c01vZGU6IGEoKS5vbmVPZihbIFwicm92aW5nXCIsIFwibm9ybWFsXCIsIFwibmV2ZXJcIiBdKSxcbiAgICAgICAgZm9vdGVyTWVzc2FnZTogYSgpLm5vZGUsXG4gICAgICAgIGlzTG9hZGluZzogYSgpLmJvb2wsXG4gICAgICAgIGxvYWRpbmdNZXNzYWdlOiBhKCkubm9kZSxcbiAgICAgICAgbWVudUlkOiBhKCkuc3RyaW5nLFxuICAgICAgICBub09wdGlvbnNNZXNzYWdlOiBhKCkubm9kZSxcbiAgICAgICAgb25TY3JvbGw6IGEoKS5mdW5jLFxuICAgICAgICBvblNjcm9sbEJvdHRvbTogYSgpLmZ1bmMsXG4gICAgICAgIHBsYWNlbWVudDogYSgpLnN0cmluZ1xuICAgIH07XG4gICAgdmFyIHEgPSAoMCwgZC5fKShcIkxvYWRpbmcuLi5cIik7XG4gICAgdmFyIEQgPSAoMCwgZC5fKShcIk5vIG1hdGNoZXNcIik7XG4gICAgLy8gVGhlIHJlbWFpbmluZyBhbW91bnQgb2YgcGl4ZWxzIHdoZW4gc2Nyb2xsZWQgZnJvbSBib3R0b20gb2YgbWVudSB0byB0cmlnZ2VyIG9uU2Nyb2xsQm90dG9tKCkuXG4gICAgICAgIHZhciBOID0gNDAwO1xuICAgIHZhciBIID0gMjg7XG4gICAgZnVuY3Rpb24gRihlKSB7XG4gICAgICAgIHZhciByID0gZS5hbmltYXRlTG9hZGluZywgbyA9IGVbXCJhcmlhLW11bHRpc2VsZWN0YWJsZVwiXSwgYSA9IGUuY2hpbGRyZW4sIGkgPSBlLmNoaWxkcmVuU3RhcnQsIGMgPSBlLmVsZW1lbnRSZWYsIHMgPSBlLmZvY3VzTW9kZSwgZCA9IGUuZm9vdGVyTWVzc2FnZSwgdiA9IGUuaXNMb2FkaW5nLCBtID0gZS5sYWJlbGxlZEJ5LCBiID0gZS5sb2FkaW5nTWVzc2FnZSwgcCA9IGIgPT09IHZvaWQgMCA/IHEgOiBiLCB5ID0gZS5tZW51SWQsIEkgPSBlLm5vT3B0aW9uc01lc3NhZ2UsIFIgPSBJID09PSB2b2lkIDAgPyBEIDogSSwgUCA9IGUub25TY3JvbGwsIHggPSBlLm9uU2Nyb2xsQm90dG9tLCBBID0gZS5wbGFjZW1lbnQsIEwgPSBlLnN0eWxlLCBfID0gZS50YWJJbmRleCwgRiA9IFQoZSwgWyBcImFuaW1hdGVMb2FkaW5nXCIsIFwiYXJpYS1tdWx0aXNlbGVjdGFibGVcIiwgXCJjaGlsZHJlblwiLCBcImNoaWxkcmVuU3RhcnRcIiwgXCJlbGVtZW50UmVmXCIsIFwiZm9jdXNNb2RlXCIsIFwiZm9vdGVyTWVzc2FnZVwiLCBcImlzTG9hZGluZ1wiLCBcImxhYmVsbGVkQnlcIiwgXCJsb2FkaW5nTWVzc2FnZVwiLCBcIm1lbnVJZFwiLCBcIm5vT3B0aW9uc01lc3NhZ2VcIiwgXCJvblNjcm9sbFwiLCBcIm9uU2Nyb2xsQm90dG9tXCIsIFwicGxhY2VtZW50XCIsIFwic3R5bGVcIiwgXCJ0YWJJbmRleFwiIF0pO1xuICAgICAgICAvLyBAZG9jcy1wcm9wcy10eXBlIFJlc3VsdHNNZW51UHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIEIgPSAoMCwgbi51c2VTdGF0ZSkodW5kZWZpbmVkKSwgVSA9IGooQiwgMiksIHogPSBVWzBdLCBWID0gVVsxXTtcbiAgICAgICAgdmFyIEsgPSAoMCwgbi51c2VTdGF0ZSkobnVsbCksIFcgPSBqKEssIDIpLCAkID0gV1swXSwgRyA9IFdbMV07XG4gICAgICAgIHZhciBYID0gKDAsIG4udXNlU3RhdGUpKG51bGwpLCBKID0gaihYLCAyKSwgUSA9IEpbMF0sIFkgPSBKWzFdO1xuICAgICAgICB2YXIgWiA9ICgwLCBuLnVzZVN0YXRlKSgwKSwgZWUgPSBqKFosIDIpLCByZSA9IGVlWzBdLCBuZSA9IGVlWzFdO1xuICAgICAgICB2YXIgdGUgPSAoMCwgbi51c2VTdGF0ZSkoMCksIG9lID0gaih0ZSwgMiksIGFlID0gb2VbMF0sIGllID0gb2VbMV07XG4gICAgICAgIHZhciB1ZSA9ICgwLCBuLnVzZVN0YXRlKShmYWxzZSksIGxlID0gaih1ZSwgMiksIGNlID0gbGVbMF0sIHNlID0gbGVbMV07XG4gICAgICAgIHZhciBmZSA9ICgwLCBuLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgWShlKTtcbiAgICAgICAgfSksIFtdKTtcbiAgICAgICAgdmFyIGRlID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBHKGUpO1xuICAgICAgICAgICAgQyhjLCBlKTtcbiAgICAgICAgfSksIFsgYyBdKTtcbiAgICAgICAgdmFyIHZlID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIGllKGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5zY3JvbGxUb3ApO1xuICAgICAgICB9KSwgW10pO1xuICAgICAgICB2YXIgbWUgPSAoMCwgbi51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgaWUoZG9jdW1lbnQuZG9jdW1lbnRFbGVtZW50LnNjcm9sbFRvcCk7XG4gICAgICAgIH0pLCBbXSk7XG4gICAgICAgIHZhciBiZSA9ICgwLCBuLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgLy8gU2FmZXR5IG5ldCB0byBlbnN1cmUgd2luZG93IGRvZXNuJ3Qgc2Nyb2xsIGlmIG1lbnUgaXMgc2Nyb2xsZWQgcGFzcyB0aGUgbnVtYmVyT2ZJdGVtc0xvYWRlZCBhdCBoaWdoIHZlbG9jaXR5LlxuICAgICAgICAgICAgZS5zdG9wUHJvcGFnYXRpb24oKTtcbiAgICAgICAgICAgIGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5zY3JvbGxUb3AgPSBhZTtcbiAgICAgICAgfSksIFsgYWUgXSk7XG4gICAgICAgIHZhciBwZSA9ICgwLCBuLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4gISFRICYmIFEuc2Nyb2xsSGVpZ2h0ID09PSBRLm9mZnNldEhlaWdodDtcbiAgICAgICAgfSksIFsgUSBdKTtcbiAgICAgICAgdmFyIHllID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBpZiAoIWNlKSB7XG4gICAgICAgICAgICAgICAgc2UodHJ1ZSk7XG4gICAgICAgICAgICAgICAgeCA9PT0gbnVsbCB8fCB4ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB4KGUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBjZSwgeCBdKTtcbiAgICAgICAgdmFyIGdlID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBpZiAoeCAmJiBlLnRhcmdldCAmJiBRKSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSBRLnNjcm9sbEhlaWdodCAtIFEub2Zmc2V0SGVpZ2h0IC0gTjtcbiAgICAgICAgICAgICAgICAvLyBBZGRpbmcgMSBkdWUgdG8gYm9yZGVyIG9mIG1lbnUgaXRlbS5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKFEuc2Nyb2xsVG9wICsgMSA+PSByKSB7XG4gICAgICAgICAgICAgICAgICAgIHllKGUpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFAgPT09IG51bGwgfHwgUCA9PT0gdm9pZCAwID8gdm9pZCAwIDogUChlKTtcbiAgICAgICAgfSksIFsgeWUsIFEsIFAsIHggXSk7XG4gICAgICAgIHZhciBoZSA9ICgwLCBuLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICB2YXIgZSA9IG4uQ2hpbGRyZW4uY291bnQoYSk7XG4gICAgICAgICAgICAvLyBJZiBtZW51IGlzIGZ1bGwgbGVuZ3RoLCBsb2FkIG1vcmUgaXRlbXMuXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAocGUoKSkge1xuICAgICAgICAgICAgICAgIHllKG51bGwpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgLy8gQXZvaWQgdHJpZ2dlcmluZyB0aGlzIGxvZ2ljIGlmIHRoaXMuc3RhdGUuY2hpbGRyZW5Db3VudCBpcyBudWxsXG4gICAgICAgICAgICAvLyBiZWNhdXNlIHRoYXQncyBub3QgYSByZWFsIGNoYW5nZSBpbiB0aGUgbnVtYmVyIG9mIGNoaWxkcmVuXG4gICAgICAgICAgICAvLyBhbmQgdGh1cyB3ZSB3YW50IHRvIGF2b2lkIHJlc2V0dGluZyB0aGUgdmFsdWUgb2Ygc2Nyb2xsQm90dG9tVHJpZ2dlcmVkXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoeiAhPSBudWxsICYmIGUgIT09IHopIHtcbiAgICAgICAgICAgICAgICBuZShlIC0gKHogIT09IG51bGwgJiYgeiAhPT0gdm9pZCAwID8geiA6IDApKTtcbiAgICAgICAgICAgICAgICBzZShmYWxzZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoZSAhPT0geikge1xuICAgICAgICAgICAgICAgIFYoZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIHBlLCBhLCB6LCB5ZSBdKTtcbiAgICAgICAgKDAsIG4udXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoISQgfHwgIVEpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICAvLyBJZiBvblNjcm9sbEJvdHRvbSBpcyBkZWZpbmVkLCBkZXRlcm1pbmUgaWYgaXQgc2hvdWxkIGJlIHRyaWdnZXJlZC5cbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICh4ICYmIGEpIHtcbiAgICAgICAgICAgICAgICBoZSgpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyAkLCBRLCBhLCB4LCBoZSBdKTtcbiAgICAgICAgLy8gQXNzdW1wdGlvbjogdGhhdCB5b3UgY2Fubm90IGJlIGZpbHRlcmVkIGlmIHlvdSBhcmUgYSByZXN1bHRcbiAgICAgICAgICAgICAgICB2YXIgU2UgPSBuLkNoaWxkcmVuLnRvQXJyYXkoYSkuZmlsdGVyKG4uaXNWYWxpZEVsZW1lbnQpLnNvbWUoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciByID0gZS50eXBlO1xuICAgICAgICAgICAgcmV0dXJuICEoci5hcyA9PT0gXCJEaXZpZGVyXCIgJiYgci5maWx0ZXJGaXJzdCB8fCAoci5hcyA9PT0gXCJEaXZpZGVyXCIgfHwgci5hcyA9PT0gXCJIZWFkaW5nXCIpICYmIChyLmZpbHRlckxhc3QgfHwgci5maWx0ZXJDb25zZWN1dGl2ZSkpO1xuICAgICAgICB9KSk7XG4gICAgICAgIHZhciBFZSA9IHBlKCk7XG4gICAgICAgIHZhciBPZSA9ICgwLCBuLnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgaGVpZ2h0OiBjZSA/IHJlICogSCA6IDBcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIGNlLCByZSBdKTtcbiAgICAgICAgdmFyIE1lID0gIVNlICYmICEhUiAmJiAhdjtcbiAgICAgICAgdmFyIHdlID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgcm9sZTogXCJsaXN0Ym94XCIsXG4gICAgICAgICAgICAgICAgcHJldmVudEZvY3VzOiBzID09PSBcIm5ldmVyXCJcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIHMgXSk7XG4gICAgICAgIHZhciBDZSA9ICgwLCBuLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICB2YXIgZSA9ICEhbi5DaGlsZHJlbi50b0FycmF5KGEpLmxlbmd0aDtcbiAgICAgICAgICAgIHJldHVybiBkICYmIGUgJiYgIHQoKS5jcmVhdGVFbGVtZW50KHQoKS5GcmFnbWVudCwgbnVsbCwgQSAhPT0gXCJhYm92ZVwiICYmICB0KCkuY3JlYXRlRWxlbWVudCh1KCksIG51bGwpLCAgdCgpLmNyZWF0ZUVsZW1lbnQoUywge1xuICAgICAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiZm9vdGVyLW1lc3NhZ2VcIixcbiAgICAgICAgICAgICAgICBrZXk6IFwiZm9vdGVyXCJcbiAgICAgICAgICAgIH0sIGQpLCBBID09PSBcImFib3ZlXCIgJiYgIHQoKS5jcmVhdGVFbGVtZW50KHUoKSwgbnVsbCkpO1xuICAgICAgICB9KSwgWyBkLCBhLCBBIF0pO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIHQoKS5jcmVhdGVFbGVtZW50KGgsIGsoe1xuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJyZXN1bHRzLW1lbnVcIixcbiAgICAgICAgICAgIGtleTogXCJ3cmFwcGVyXCIsXG4gICAgICAgICAgICByZWY6IGRlLFxuICAgICAgICAgICAgb25XaGVlbDogeCA/IGJlIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgb25Nb3VzZUVudGVyOiB4ID8gdmUgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBvbk1vdXNlTGVhdmU6IHggPyBtZSA6IHVuZGVmaW5lZFxuICAgICAgICB9LCBGLCB7XG4gICAgICAgICAgICBzdHlsZTogTFxuICAgICAgICB9KSwgQSAhPT0gXCJhYm92ZVwiICYmIGksIEEgPT09IFwiYWJvdmVcIiAmJiBDZSgpLCAgdCgpLmNyZWF0ZUVsZW1lbnQobC5NZW51Q29udGV4dC5Qcm92aWRlciwge1xuICAgICAgICAgICAgdmFsdWU6IHdlKClcbiAgICAgICAgfSwgIHQoKS5jcmVhdGVFbGVtZW50KGcsIHtcbiAgICAgICAgICAgIFwiYXJpYS1tdWx0aXNlbGVjdGFibGVcIjogbyxcbiAgICAgICAgICAgIFwiYXJpYS1sYWJlbGxlZGJ5XCI6IG0sXG4gICAgICAgICAgICBlbGVtZW50UmVmOiBmZSxcbiAgICAgICAgICAgIGZvY3VzTW9kZTogcyxcbiAgICAgICAgICAgIGlkOiB5LFxuICAgICAgICAgICAga2V5OiBcIm1lbnVcIixcbiAgICAgICAgICAgIG9uU2Nyb2xsOiBnZSxcbiAgICAgICAgICAgIHN0b3BTY3JvbGxQcm9wYWdhdGlvbjogdHJ1ZSxcbiAgICAgICAgICAgIHRhYkluZGV4OiBfXG4gICAgICAgIH0sIE1lICYmICB0KCkuY3JlYXRlRWxlbWVudChPLCB7XG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcIm5vLXJlc3VsdHMtbWVzc2FnZVwiLFxuICAgICAgICAgICAgZGlzYWJsZWQ6IHRydWVcbiAgICAgICAgfSwgUiksIGEsIHggJiYgIUVlICYmIFxuICAgICAgICBcbiAgICAgICAgLy8gQm90dG9tIHNwYWNlciBmaWxscyBpbiB0aGUgc3BhY2Ugb2YgbmV3IGl0ZW1zIGJlaW5nIGxvYWRlZCBieSB1c2luZyB0aGUgbWluaW11bSBwb3NzaWJsZSBoZWlnaHQgeCBtZW51SXRlbXMuXG4gICAgICAgIHQoKS5jcmVhdGVFbGVtZW50KFwiZGl2XCIsIHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwicmVzdWx0cy1tZW51LWJvdHRvbS1zcGFjZXJcIixcbiAgICAgICAgICAgIHN0eWxlOiBPZVxuICAgICAgICB9KSwgdiAmJiAgdCgpLmNyZWF0ZUVsZW1lbnQoRSwgbnVsbCwgciAmJiAgdCgpLmNyZWF0ZUVsZW1lbnQoTSwgbnVsbCksICB0KCkuY3JlYXRlRWxlbWVudCh3LCBudWxsLCBwKSkpKSwgIHQoKS5jcmVhdGVFbGVtZW50KGYoKSwge1xuICAgICAgICAgICAgXCJhcmlhLWxpdmVcIjogXCJwb2xpdGVcIlxuICAgICAgICB9LCBNZSAmJiBSKSwgQSAhPT0gXCJhYm92ZVwiICYmIENlKCksIEEgPT09IFwiYWJvdmVcIiAmJiBpKTtcbiAgICB9XG4gICAgRi5wcm9wVHlwZXMgPSBfO1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3QgQiA9IEY7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvb21pdFwiXG4gICAgY29uc3QgVSA9IHJlcXVpcmUoXCJsb2Rhc2gvb21pdFwiKTtcbiAgICB2YXIgeiA9ICBlLm4oVSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3VpLXV0aWxzL2ZvY3VzXCJcbiAgICBjb25zdCBWID0gcmVxdWlyZShcIkBzcGx1bmsvdWktdXRpbHMvZm9jdXNcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvUmVzdWx0c01lbnUvVmlydHVhbGl6ZWRSZXN1bHRzTWVudS9ncm91cENoaWxkcmVuLnRzXG4gICAgLy8gQ2hlYXAoZXIgdGhhbiBwcm9jZXNzaW5nIHBvdGVudGlhbGx5IHRob3VzYW5kcyBvZiBhcnJheSBlbGVtZW50cykgbWVtb2l6YXRpb25cbiAgICB2YXIgSyA9IHtcbiAgICAgICAgcmVzdWx0OiBbXVxuICAgIH07XG4gICAgLyoqXG4gKiBHaXZlbiBjb21wb25lbnQgY2hpbGRyZW4sIHJlc3RydWN0dXJlIHRoZW0gaW50byBhbiBhcnJheSBvZiBhcnJheXMsIGVhY2ggb2YgbGVuZ3RoIGBncm91cFNpemVgLlxuICpcbiAqIFRoZSBsYXN0IGFycmF5IGlzIG5vdCBndWFyYW50ZWVkIHRvIGJlIGZ1bGwsIGl0IHdpbGwgaGF2ZSBhIGxlbmd0aCBpbiB0aGUgcmFuZ2UgYFsxLCBncm91cFNpemVdYFxuICpcbiAqIEBleGFtcGxlXG4gKiBgYGBqc1xuICogZ3JvdXBDaGlsZHJlbihbMSwgMiwgMywgNCwgNSwgNiwgN10sIDIpO1xuICogLy8gPiBbWzEsIDJdLCBbMywgNF0sIFs1LCA2XSwgWzddXVxuICogYGBgXG4gKiBAcGFyYW0ge0FycmF5fSBjaGlsZHJlbiBPbmUgbm9kZSwgb3IgYW4gYXJyYXkgb2Ygbm9kZXMsIHRvIGJlIGRpdmlkZWQgaW50byBncm91cHNcbiAqIEBwYXJhbSB7bnVtYmVyfSBncm91cFNpemUgVGhlIHNpemUgb2YgZWFjaCBncm91cCB0byBiZSBjcmVhdGVkXG4gKiBAcmV0dXJucyBBIDJkIGFycmF5IHdoZXJlIGVhY2ggaW5uZXItYXJyYXkgaXMgYSBncm91cCBvZiBzaXplIGBncm91cFNpemVgIG9mIGNoaWxkcmVuXG4gKiBhbmQgdGhlIG9yZGVyIG9mIHRoZSBgY2hpbGRyZW5gIHJlY2VpdmVkIGVxdWFscyB0aGUgb3JkZXIgb2YgdGhlIGZsYXR0ZW5lZCByZXN1bHRcbiAqLyAgICB2YXIgVyA9IGZ1bmN0aW9uIGUociwgdCkge1xuICAgICAgICBpZiAoSy5jaGlsZHJlbiA9PT0gciAmJiBLLmdyb3VwU2l6ZSA9PT0gdCkge1xuICAgICAgICAgICAgcmV0dXJuIEsucmVzdWx0O1xuICAgICAgICB9XG4gICAgICAgIEsuY2hpbGRyZW4gPSByO1xuICAgICAgICBLLmdyb3VwU2l6ZSA9IHQ7XG4gICAgICAgIGlmICh0IDw9IDEpIHtcbiAgICAgICAgICAgIGlmIChmYWxzZSkge31cbiAgICAgICAgICAgIC8vIGRvbid0IGJyZWFrIGluIG5vbi1fX0RFVl9fIGFuZCByZXR1cm4gb25lIGJpZyBncm91cFxuICAgICAgICAgICAgICAgICAgICAgICAgSy5yZXN1bHQgPSBbIG4uQ2hpbGRyZW4udG9BcnJheShyKSBdO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgSy5yZXN1bHQgPSBuLkNoaWxkcmVuLnRvQXJyYXkocikucmVkdWNlKChmdW5jdGlvbihlLCByLCBuKSB7XG4gICAgICAgICAgICAgICAgdmFyIG8gPSBNYXRoLmZsb29yKG4gLyB0KTtcbiAgICAgICAgICAgICAgICBpZiAoIUFycmF5LmlzQXJyYXkoZVtvXSkpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXBhcmFtLXJlYXNzaWduXG4gICAgICAgICAgICAgICAgICAgIGVbb10gPSBbXTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZVtvXS5wdXNoKHIpO1xuICAgICAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICAgICAgfSksIFtdKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gSy5yZXN1bHQ7XG4gICAgfTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvdWktdXRpbHMvaWRcIlxuICAgIGNvbnN0ICQgPSByZXF1aXJlKFwiQHNwbHVuay91aS11dGlscy9pZFwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9SZXN1bHRzTWVudS9WaXJ0dWFsaXplZFJlc3VsdHNNZW51L1ZpcnR1YWxpemVkSXRlbS50c1xuICAgIC8vIFRoaXMgd3JhcHBlciBzaG91bGQgb25seSBiZSB1c2VkIHdpdGggTWVudS5JdGVtL2Rlcml2YXRpdmVzIHRoZXJlb2YsIHNvIG9taXR0aW5nIEhlYWRpbmcvRGl2aWRlciBpcyBmaW5lXG4gICAgdmFyIEcgPSB7XG4gICAgICAgIGNoaWxkcmVuOiBhKCkubm9kZSxcbiAgICAgICAgb25Nb3VudDogYSgpLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgICAgb25Vbm1vdW50OiBhKCkuZnVuYy5pc1JlcXVpcmVkXG4gICAgfTtcbiAgICAvKiogQHByaXZhdGUgVXNlZCBieSBgVmlydHVhbGl6ZWRSZXN1bHRzTWVudWAgKi8gICAgdmFyIFggPSAgdCgpLmZvcndhcmRSZWYoKGZ1bmN0aW9uKGUsIHIpIHtcbiAgICAgICAgdmFyIHQgPSBlLmNoaWxkcmVuLCBvID0gZS5vbk1vdW50LCBhID0gZS5vblVubW91bnQ7XG4gICAgICAgIC8vIEBkb2NzLXByb3BzLXR5cGUgVmlydHVhbGl6ZWRJdGVtUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIGkgPSAoMCwgbi51c2VSZWYpKG51bGwpO1xuICAgICAgICAoMCwgbi51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHZhciBlID0gaS5jdXJyZW50O1xuICAgICAgICAgICAgaWYgKGUpIHtcbiAgICAgICAgICAgICAgICBvKGUpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgICAgIGlmIChlKSB7XG4gICAgICAgICAgICAgICAgICAgIGEoZSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgbywgYSBdKTtcbiAgICAgICAgdmFyIHUgPSBuLkNoaWxkcmVuLm9ubHkodCk7XG4gICAgICAgIGlmICghdSkge1xuICAgICAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cbiAgICAgICAgXG4gICAgICAgIHJldHVybiAoMCwgbi5jbG9uZUVsZW1lbnQpKHUsIHtcbiAgICAgICAgICAgIGVsZW1lbnRSZWY6IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgICAgIGkuY3VycmVudCA9IG47XG4gICAgICAgICAgICAgICAgQyhyLCBuKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgfSkpO1xuICAgIFgucHJvcFR5cGVzID0gRztcbiAgICBYLmFzID0gXCJJdGVtXCI7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvUmVzdWx0c01lbnUvVmlydHVhbGl6ZWRSZXN1bHRzTWVudS9pbmplY3RWaXJ0dWFsaXplZEl0ZW0udHN4XG4gICAgLyoqXG4gKiBGaW5kIHRoZSBpbmRleCBvZiBhbiBhcnJheSBlbGVtZW50IHdoaWNoIGlzIG5lYXJlc3QgdG8gdGFyZ2V0SW5kZXggYW5kIGlzIGEgTWVudS5JdGVtIGNvbXBvbmVudFxuICogQHBhcmFtIHtBcnJheX0gZWxlbWVudHMgQW4gYXJyYXkgdG8gc2VhcmNoXG4gKiBAcGFyYW0ge051bWJlcn0gdGFyZ2V0SW5kZXggVGhlIHRhcmdldCBpbmRleC4gVGhpcyBpcyB0aGUgaWRlYWwgdmFsdWUgdG8gcmV0dXJuLlxuICogQHJldHVybnMgVGhlIGluZGV4IGluIHRoZSBhcnJheSBvZiB0aGUgbmVhcmVzdCBgTWVudS5JdGVtYCBjb21wb25lbnQgdG8gYHRhcmdldEluZGV4YCwgb3IgLTEgaWYgbm8gZWxlbWVudCBpcyBhIGBNZW51Lkl0ZW1gIGNvbXBvbmVudFxuICovXG4gICAgdmFyIEogPSBmdW5jdGlvbiBlKHIsIG4pIHtcbiAgICAgICAgdmFyIHQgPSAtMTtcbiAgICAgICAgdmFyIG8gPSAtMTtcbiAgICAgICAgci5mb3JFYWNoKChmdW5jdGlvbihlLCByKSB7XG4gICAgICAgICAgICB2YXIgYSA9IE1hdGguYWJzKG4gLSByKTtcbiAgICAgICAgICAgIGlmICh0ID49IDAgJiYgdCA8IGEpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoZS50eXBlICE9PSBsLkRpdmlkZXIgJiYgZS50eXBlICE9PSBsLkhlYWRpbmcpIHtcbiAgICAgICAgICAgICAgICB0ID0gYTtcbiAgICAgICAgICAgICAgICBvID0gcjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSkpO1xuICAgICAgICByZXR1cm4gbztcbiAgICB9O1xuICAgIC8qKlxuICogQHByaXZhdGUgS2VlcCB0aGUgaW5qZWN0aW9uIG9mIGBWaXJ0dWFsaXplZEl0ZW1gIERSWS4gV2lsbCBhbHdheXMgcmVwbGFjZSB0aGUgbWlkZGxlLW1vc3Qgbm9uLWRpdmlkZXIvaGVhZGluZ1xuICogd2l0aCBhIFZpcnR1YWxpemVkSXRlbSBpbnN0YW5jZS5cbiAqIC0gSWYgYHRyYWNrRmlyc3RFbGVtZW50YCB0aGUgKipGSVJTVCoqIG5vbi1kaXZpZGVyL2hlYWRpbmcgaXRlbSB3aWxsIGFsc28gYmUgcmVwbGFjZWQuXG4gKiAtIElmIGB0cmFja0xhc3RFbGVtZW50YCB0aGUgKipMQVNUKiogbm9uLWRpdmlkZXIvaGVhZGluZyBpdGVtIHdpbGwgYWxzbyBiZSByZXBsYWNlZC5cbiAqLyAgICB2YXIgUSA9IGZ1bmN0aW9uIGUociwgbiwgbykge1xuICAgICAgICB2YXIgYSA9IGFyZ3VtZW50cy5sZW5ndGggPiAzICYmIGFyZ3VtZW50c1szXSAhPT0gdW5kZWZpbmVkID8gYXJndW1lbnRzWzNdIDoge30sIGkgPSBhLnRyYWNrRmlyc3RFbGVtZW50LCB1ID0gYS50cmFja0xhc3RFbGVtZW50O1xuICAgICAgICBpZiAoIUFycmF5LmlzQXJyYXkocikpIHtcbiAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgbCA9IEoociwgTWF0aC5mbG9vcihyLmxlbmd0aCAvIDIpKTtcbiAgICAgICAgdmFyIGMgPSBpICYmIEoociwgMCk7XG4gICAgICAgIHZhciBzID0gdSAmJiBKKHIsIHIubGVuZ3RoIC0gMSk7XG4gICAgICAgIHJldHVybiByLm1hcCgoZnVuY3Rpb24oZSwgcikge1xuICAgICAgICAgICAgaWYgKHIgPT09IGwgfHwgciA9PT0gYyB8fCByID09PSBzKSB7XG4gICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgcmV0dXJuIHQoKS5jcmVhdGVFbGVtZW50KFgsIHtcbiAgICAgICAgICAgICAgICAgICAga2V5OiAoMCwgJC5jcmVhdGVHVUlEKSgpLFxuICAgICAgICAgICAgICAgICAgICBvbk1vdW50OiBuLFxuICAgICAgICAgICAgICAgICAgICBvblVubW91bnQ6IG9cbiAgICAgICAgICAgICAgICB9LCBlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9KSk7XG4gICAgfTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9SZXN1bHRzTWVudS9WaXJ0dWFsaXplZFJlc3VsdHNNZW51L1ZpcnR1YWxpemVkUmVzdWx0c01lbnUudHN4XG4gICAgZnVuY3Rpb24gWShlKSB7XG4gICAgICAgIFwiQGJhYmVsL2hlbHBlcnMgLSB0eXBlb2ZcIjtcbiAgICAgICAgcmV0dXJuIFkgPSBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBcInN5bWJvbFwiID09IHR5cGVvZiBTeW1ib2wuaXRlcmF0b3IgPyBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICByZXR1cm4gdHlwZW9mIGU7XG4gICAgICAgIH0gOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICByZXR1cm4gZSAmJiBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBlLmNvbnN0cnVjdG9yID09PSBTeW1ib2wgJiYgZSAhPT0gU3ltYm9sLnByb3RvdHlwZSA/IFwic3ltYm9sXCIgOiB0eXBlb2YgZTtcbiAgICAgICAgfSwgWShlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gWigpIHtcbiAgICAgICAgcmV0dXJuIFogPSBPYmplY3QuYXNzaWduID8gT2JqZWN0LmFzc2lnbi5iaW5kKCkgOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmb3IgKHZhciByID0gMTsgciA8IGFyZ3VtZW50cy5sZW5ndGg7IHIrKykge1xuICAgICAgICAgICAgICAgIHZhciBuID0gYXJndW1lbnRzW3JdO1xuICAgICAgICAgICAgICAgIGZvciAodmFyIHQgaW4gbikge1xuICAgICAgICAgICAgICAgICAgICAoe30pLmhhc093blByb3BlcnR5LmNhbGwobiwgdCkgJiYgKGVbdF0gPSBuW3RdKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfSwgWi5hcHBseShudWxsLCBhcmd1bWVudHMpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBlZShlKSB7XG4gICAgICAgIHJldHVybiB0ZShlKSB8fCBuZShlKSB8fCBpZShlKSB8fCByZSgpO1xuICAgIH1cbiAgICBmdW5jdGlvbiByZSgpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkludmFsaWQgYXR0ZW1wdCB0byBzcHJlYWQgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIG5lKGUpIHtcbiAgICAgICAgaWYgKFwidW5kZWZpbmVkXCIgIT0gdHlwZW9mIFN5bWJvbCAmJiBudWxsICE9IGVbU3ltYm9sLml0ZXJhdG9yXSB8fCBudWxsICE9IGVbXCJAQGl0ZXJhdG9yXCJdKSByZXR1cm4gQXJyYXkuZnJvbShlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gdGUoZSkge1xuICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShlKSkgcmV0dXJuIHVlKGUpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBvZShlLCByKSB7XG4gICAgICAgIHJldHVybiBjZShlKSB8fCBsZShlLCByKSB8fCBpZShlLCByKSB8fCBhZSgpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBhZSgpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkludmFsaWQgYXR0ZW1wdCB0byBkZXN0cnVjdHVyZSBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gaWUoZSwgcikge1xuICAgICAgICBpZiAoZSkge1xuICAgICAgICAgICAgaWYgKFwic3RyaW5nXCIgPT0gdHlwZW9mIGUpIHJldHVybiB1ZShlLCByKTtcbiAgICAgICAgICAgIHZhciBuID0ge30udG9TdHJpbmcuY2FsbChlKS5zbGljZSg4LCAtMSk7XG4gICAgICAgICAgICByZXR1cm4gXCJPYmplY3RcIiA9PT0gbiAmJiBlLmNvbnN0cnVjdG9yICYmIChuID0gZS5jb25zdHJ1Y3Rvci5uYW1lKSwgXCJNYXBcIiA9PT0gbiB8fCBcIlNldFwiID09PSBuID8gQXJyYXkuZnJvbShlKSA6IFwiQXJndW1lbnRzXCIgPT09IG4gfHwgL14oPzpVaXxJKW50KD86OHwxNnwzMikoPzpDbGFtcGVkKT9BcnJheSQvLnRlc3QobikgPyB1ZShlLCByKSA6IHZvaWQgMDtcbiAgICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiB1ZShlLCByKSB7XG4gICAgICAgIChudWxsID09IHIgfHwgciA+IGUubGVuZ3RoKSAmJiAociA9IGUubGVuZ3RoKTtcbiAgICAgICAgZm9yICh2YXIgbiA9IDAsIHQgPSBBcnJheShyKTsgbiA8IHI7IG4rKykge1xuICAgICAgICAgICAgdFtuXSA9IGVbbl07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGxlKGUsIHIpIHtcbiAgICAgICAgdmFyIG4gPSBudWxsID09IGUgPyBudWxsIDogXCJ1bmRlZmluZWRcIiAhPSB0eXBlb2YgU3ltYm9sICYmIGVbU3ltYm9sLml0ZXJhdG9yXSB8fCBlW1wiQEBpdGVyYXRvclwiXTtcbiAgICAgICAgaWYgKG51bGwgIT0gbikge1xuICAgICAgICAgICAgdmFyIHQsIG8sIGEsIGksIHUgPSBbXSwgbCA9ICEwLCBjID0gITE7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIGlmIChhID0gKG4gPSBuLmNhbGwoZSkpLm5leHQsIDAgPT09IHIpIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKE9iamVjdChuKSAhPT0gbikgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICBsID0gITE7XG4gICAgICAgICAgICAgICAgfSBlbHNlIGZvciAoOyEobCA9ICh0ID0gYS5jYWxsKG4pKS5kb25lKSAmJiAodS5wdXNoKHQudmFsdWUpLCB1Lmxlbmd0aCAhPT0gcik7IGwgPSAhMCkge1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgICAgICAgICBjID0gITAsIG8gPSBlO1xuICAgICAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoIWwgJiYgbnVsbCAhPSBuW1wicmV0dXJuXCJdICYmIChpID0gbltcInJldHVyblwiXSgpLCBPYmplY3QoaSkgIT09IGkpKSByZXR1cm47XG4gICAgICAgICAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKGMpIHRocm93IG87XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHU7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gY2UoZSkge1xuICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShlKSkgcmV0dXJuIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIHNlKGUsIHIpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgbiwgdCwgbyA9IGZlKGUsIHIpO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGEgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yICh0ID0gMDsgdCA8IGEubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgICAgICBuID0gYVt0XSwgLTEgPT09IHIuaW5kZXhPZihuKSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIG4pICYmIChvW25dID0gZVtuXSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG87XG4gICAgfVxuICAgIGZ1bmN0aW9uIGZlKGUsIHIpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgbiA9IHt9O1xuICAgICAgICBmb3IgKHZhciB0IGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIHQpKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSByLmluZGV4T2YodCkpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIG5bdF0gPSBlW3RdO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBuO1xuICAgIH1cbiAgICBmdW5jdGlvbiBkZShlLCByKSB7XG4gICAgICAgIHZhciBuID0gT2JqZWN0LmtleXMoZSk7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgdCA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICByICYmICh0ID0gdC5maWx0ZXIoKGZ1bmN0aW9uKHIpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcihlLCByKS5lbnVtZXJhYmxlO1xuICAgICAgICAgICAgfSkpKSwgbi5wdXNoLmFwcGx5KG4sIHQpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBuO1xuICAgIH1cbiAgICBmdW5jdGlvbiB2ZShlKSB7XG4gICAgICAgIGZvciAodmFyIHIgPSAxOyByIDwgYXJndW1lbnRzLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICB2YXIgbiA9IG51bGwgIT0gYXJndW1lbnRzW3JdID8gYXJndW1lbnRzW3JdIDoge307XG4gICAgICAgICAgICByICUgMiA/IGRlKE9iamVjdChuKSwgITApLmZvckVhY2goKGZ1bmN0aW9uKHIpIHtcbiAgICAgICAgICAgICAgICBtZShlLCByLCBuW3JdKTtcbiAgICAgICAgICAgIH0pKSA6IE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3JzID8gT2JqZWN0LmRlZmluZVByb3BlcnRpZXMoZSwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMobikpIDogZGUoT2JqZWN0KG4pKS5mb3JFYWNoKChmdW5jdGlvbihyKSB7XG4gICAgICAgICAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIHIsIE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IobiwgcikpO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBtZShlLCByLCBuKSB7XG4gICAgICAgIHJldHVybiAociA9IGJlKHIpKSBpbiBlID8gT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIHIsIHtcbiAgICAgICAgICAgIHZhbHVlOiBuLFxuICAgICAgICAgICAgZW51bWVyYWJsZTogITAsXG4gICAgICAgICAgICBjb25maWd1cmFibGU6ICEwLFxuICAgICAgICAgICAgd3JpdGFibGU6ICEwXG4gICAgICAgIH0pIDogZVtyXSA9IG4sIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGJlKGUpIHtcbiAgICAgICAgdmFyIHIgPSBwZShlLCBcInN0cmluZ1wiKTtcbiAgICAgICAgcmV0dXJuIFwic3ltYm9sXCIgPT0gWShyKSA/IHIgOiByICsgXCJcIjtcbiAgICB9XG4gICAgZnVuY3Rpb24gcGUoZSwgcikge1xuICAgICAgICBpZiAoXCJvYmplY3RcIiAhPSBZKGUpIHx8ICFlKSByZXR1cm4gZTtcbiAgICAgICAgdmFyIG4gPSBlW1N5bWJvbC50b1ByaW1pdGl2ZV07XG4gICAgICAgIGlmICh2b2lkIDAgIT09IG4pIHtcbiAgICAgICAgICAgIHZhciB0ID0gbi5jYWxsKGUsIHIgfHwgXCJkZWZhdWx0XCIpO1xuICAgICAgICAgICAgaWYgKFwib2JqZWN0XCIgIT0gWSh0KSkgcmV0dXJuIHQ7XG4gICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFwiQEB0b1ByaW1pdGl2ZSBtdXN0IHJldHVybiBhIHByaW1pdGl2ZSB2YWx1ZS5cIik7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIChcInN0cmluZ1wiID09PSByID8gU3RyaW5nIDogTnVtYmVyKShlKTtcbiAgICB9XG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXJlbGF0aXZlLWltcG9ydHMtb2YtcHVibGlzaGVkIC0tIFRPRE8oU1VJLTgxOTApOiBWaXJ0dWFsaXplZFJlc3VsdHNNZW51IHdyYXBzIFJlc3VsdHNNZW51LCB1c2luZyBleHRlcm5hbCBpbXBvcnQgY3JlYXRlcyBjaXJjdWxhciBkZXBlbmRlbmN5XG4gICAgLy8gVE9ETyhTVUktNTkyMCk6IGFkZCB0cmFuc2l0aW9ucyB0byB0aGlzIGNvbXBvbmVudCBpbiBSZWFjdCAxOFxuICAgICAgICB2YXIgeWUgPSB2ZSh2ZSh7fSwgeigpKF8sIFwib25Eb3duS2V5UHJlc3NcIiwgXCJvbkVuZEtleVByZXNzXCIsIFwib25Ib21lS2V5UHJlc3NcIiwgXCJvblVwS2V5UHJlc3NcIikpLCB7fSwge1xuICAgICAgICB2aXJ0dWFsaXphdGlvbjogYSgpLm51bWJlclxuICAgIH0pO1xuICAgIHZhciBnZSA9IFtdO1xuICAgIC8qKlxuICogQSB3cmFwcGVyIGZvciBgUmVzdWx0c01lbnVgIHdoaWNoIHZpcnR1YWxpemVzIHRoZSBgY2hpbGRyZW5gLiBUaGUgcmVjZWl2ZWQgYGNoaWxkcmVuYCBhcnJheSB3aWxsIGJlIHNwbGl0IGludG8gKipcInBhbmVzXCIqKiBlYWNoIHdpdGggYHZpcnR1YWxpemF0aW9uYCBlbnRyaWVzXG4gKiBhbmQsIGF0IGFueSBnaXZlbiB0aW1lLCAzIG9yIGZld2VyIG9mIHRoZXNlIHBhbmVzIHdpbGwgYmUgcmVuZGVyZWQgaW4gdGhlIERPTS5cbiAqXG4gKiBHaXZlbiB0aGUgY2hpbGRyZW4gYFsxLCAyLCAzLCA0LCA1LCA2LCA3LCA4LCA5XWAgYW5kIGB2aXJ0dWFsaXphdGlvbj00YCwgdGhlbiBhdCBmaXJzdCBvbmx5IGVsZW1lbnRzIGBbMSwgMiwgMywgNCwgNSwgNiwgNywgOF1gIHdpbGwgYmUgYWRkZWQgdG8gdGhlIERPTS5cbiAqIE9uY2UgZWl0aGVyIGNoaWxkIGA2YCBvciBgOGAgaW50ZXJzZWN0IHRoZSBgTWVudWAgcmVuZGVyZWQgYnkgYFJlc3VsdHNNZW51YCB0aGUgbmV4dCBwYW5lIG9mIGNoaWxkcmVuIHdpbGwgYWxzbyBiZSBpbmNsdWRlZCBhbmQsIGlmIG5lZWRlZCwgdGhlIG9sZGVzdCBwYW5lXG4gKiB3aWxsIGJlIHJlbW92ZWQuXG4gKlxuICogSW4gZWZmZWN0IHRoaXMgbWVhbnMgdGhlIG1lbnUgd2lsbCBzaG93IHRoZSBcImNlbnRyYWxcIiBjb250ZW50IGF0IHBhbmUgaW5kZXggX2BuYF8sIGEgcHJldmlvdXMtY29udGVudC1idWZmZXIgY29tcHJpc2VkIG9mIHBhbmUgaW5kZXggX2BuIC0gMWBfLFxuICogYW5kIGFuIHVwY29taW5nLWNvbnRlbnQtYnVmZmVyIGNvbXByaXNlZCBvZiBwYW5lIGluZGV4IF9gbiArIDFgXy5cbiAqXG4gKiBBbiBgSW50ZXJzZWN0aW9uT2JzZXJ2ZXJgIHdpbGwgb2JzZXJ2ZSB0aGUgZmlyc3Qgbm9kZSBpbiB0aGUgX2BuIC0gMWBfIHBhbmUsIHRoZSBsYXN0IG5vZGUgaW4gdGhlIF9gbiArIDFgXyBwYW5lLCBhbmQgdGhlIGNlbnRyYWwgbm9kZSBpbiBib3RoIF9gbiDCsSAxYF8gcGFuZXNcbiAqIGZvciBpbnRlcnNlY3Rpb25zIHdpdGggdGhlIHJlbmRlcmVkIGBNZW51YCBhbmQgdHJpZ2dlciBhICpwYW5lIGNoYW5nZSogdXBvbiB0aGF0IGludGVyc2VjdGlvbi4gQXMgc3VjaCwgaW4gU1NSIG9yIG90aGVyIGVudmlyb25tZW50cyB3aGljaCBkb24ndCBzdXBwb3J0IGBJbnRlcnNlY3Rpb25PYnNlcnZlcmBcbiAqIHRoaXMgY29tcG9uZW50IHNob3VsZCBub3QgYmUgdXNlZCBhbmQgd2lsbCBiZSByZXBsYWNlZCBieSB0aGUgYmFycmVsIGZpbGUgd2l0aCBhIHZhbmlsbGEgYFJlc3VsdHNNZW51YC5cbiAqXG4gKiBAdGhyb3dzIGluIGBfX0RFVl9fYCB3aGVuIGB2aXJ0dWFsaXphdGlvbmAgaXMgdG9vIHNtYWxsIGFzIGNvbXBhcmVkIHRvIHRoZSBtZW51IGhlaWdodCAoYHZpcnR1YWxpemF0aW9uYCBtdXN0IGJlIGdyZWF0ZXIgdGhhbiB0aGUgbnVtYmVyIG9mIHZpc2libGUgaXRlbXMgaW4gdGhlIHJlbmRlcmVkIG1lbnUpXG4gKiBAdGhyb3dzIGluIGBfX0RFVl9fYCB3aGVuIGB2aXJ0dWFsaXphdGlvbmAgaXMgbGVzcyB0aGFuIG9yIGVxdWFsIHRvIDEgKGB2aXJ0dWFsaXphdGlvbmAgbXVzdCBiZSDiiaUgMilcbiAqIEB0aHJvd3MgaW4gYF9fREVWX19gIHdoZW4gYHZpcnR1YWxpemF0aW9uYCBpcyBjaGFuZ2VkIGR1cmluZyB0aGUgbGlmZWN5Y2xlIG9mIHRoZSBgVmlydHVhbGl6ZWRSZXN1bHRzTWVudWAgY29tcG9uZW50XG4gKi8gICAgZnVuY3Rpb24gaGUoZSkge1xuICAgICAgICB2YXIgciA9IGUudmlydHVhbGl6YXRpb24sIG8gPSByID09PSB2b2lkIDAgPyAyIDogciwgYSA9IGUuZWxlbWVudFJlZiwgaSA9IGUuY2hpbGRyZW4sIHUgPSBlLmZvY3VzTW9kZSwgbCA9IHUgPT09IHZvaWQgMCA/IFwibm9ybWFsXCIgOiB1LCBjID0gc2UoZSwgWyBcInZpcnR1YWxpemF0aW9uXCIsIFwiZWxlbWVudFJlZlwiLCBcImNoaWxkcmVuXCIsIFwiZm9jdXNNb2RlXCIgXSk7XG4gICAgICAgIC8vIEBkb2NzLXByb3BzLXR5cGUgVmlydHVhbGl6ZWRSZXN1bHRzTWVudVByb3BzQmFzZVxuICAgICAgICAgICAgICAgIHZhciBzID0gKDAsIG4udXNlUmVmKShvKTtcbiAgICAgICAgLy8gSWYgYSB1c2VyIHRyaWVzIHRvIHNldCB2aXJ0dWFsaXphdGlvbiB0byBhIHZhbHVlIHNtYWxsZXIgdGhhbiB0aGUgbnVtYmVyIG9mIG9wdGlvbnNcbiAgICAgICAgLy8gdmlzaWJsZSBhdCBhIGdpdmVuIG1vbWVudCB0aGVuIHRoZSBtZW51IHdpbGwgZmxpY2tlciBlbmRsZXNzbHkuIFRoaXMgc3RhdGUgaXMgc2V0IGluXG4gICAgICAgIC8vIHRoZSBJbnRlcnNlY3Rpb25PYnNlcnZlciB0byBmaXggdGhlIGlzc3VlLCBidXQgaW4gYF9fREVWX19gIGFuIGVycm9yIGlzIHRocm93bi5cbiAgICAgICAgICAgICAgICB2YXIgZiA9ICgwLCBuLnVzZVN0YXRlKShvKSwgZCA9IG9lKGYsIDIpLCB2ID0gZFswXSwgbSA9IGRbMV07XG4gLy8gdGhlc2UgcmVmcyBrZWVwIHRyYWNrIG9mIHdoZXRoZXIgd2UgbmVlZCB0byBmb2N1cyB0aGUgZmlyc3QvbGFzdFxuICAgICAgICAvLyBlbGVtZW50IGFmdGVyIHRoZSBuZXh0IHJlbmRlclxuICAgICAgICAgICAgICAgIHZhciBiID0gKDAsIG4udXNlUmVmKShmYWxzZSk7XG4gICAgICAgIHZhciBwID0gKDAsIG4udXNlUmVmKShmYWxzZSk7XG4gICAgICAgIHZhciB5ID0gKDAsIG4udXNlUmVmKShpKTtcbiAgICAgICAgLy8gdGhpcyBjb2RlIG1ha2VzIHRoZSBcIkhvbWVcIiBhbmQgXCJFbmRcIiBrZXlzIHdvcmsgYnkgaW5qZWN0aW5nXG4gICAgICAgIC8vIGFuIGVsZW1lbnRSZWYgY2FsbGJhY2sgZnVuY3Rpb24gaW50byB0aGUgZmlyc3QgYW5kIGxhc3QgaXRlbVxuICAgICAgICAvLyB0aGF0IHdpbGwgYXR0ZW1wdCB0byBmb2N1cyB0aGUgZmlyc3QvbGFzdCBpdGVtIGlmIGFwcHJvcHJpYXRlXG4gICAgICAgIC8vIHdlIG5lZWQgdG8gZG8gdGhpcyBiZWNhdXNlIGlmIHdlIGNhbGwgZm9jdXMoKSByaWdodCBhZnRlciBjaGFuZ2VQYW5lKClcbiAgICAgICAgLy8gdGhlIG5ldyBwYW5lIHdvbid0IGJlIGluIHRoZSBET00geWV0LCBzbyB0aGUgd3JvbmcgZWxlbWVudCB3aWxsIGVuZCB1cCBmb2N1c2VkXG4gICAgICAgICAgICAgICAgKDAsIG4udXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgdmFyIGUgPSBuLkNoaWxkcmVuLnRvQXJyYXkoaSk7XG4gICAgICAgICAgICB2YXIgciA9IEooZSwgMCk7XG4gICAgICAgICAgICB2YXIgdCA9IEooZSwgZS5sZW5ndGggLSAxKTtcbiAgICAgICAgICAgIHkuY3VycmVudCA9IGUubWFwKChmdW5jdGlvbihlLCBvKSB7XG4gICAgICAgICAgICAgICAgdmFyIGEgPSBlO1xuICAgICAgICAgICAgICAgIGlmIChvID09PSByKSB7XG4gICAgICAgICAgICAgICAgICAgIGEgPSAgKDAsIG4uaXNWYWxpZEVsZW1lbnQpKGUpID8gICgwLCBuLmNsb25lRWxlbWVudCkoZSwge1xuICAgICAgICAgICAgICAgICAgICAgICAgZWxlbWVudFJlZjogZnVuY3Rpb24gZShyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGIgPT09IG51bGwgfHwgYiA9PT0gdm9pZCAwID8gdm9pZCAwIDogYi5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGIuY3VycmVudCA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByID09PSBudWxsIHx8IHIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHIuZm9jdXMoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0pIDogZTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKG8gPT09IHQpIHtcbiAgICAgICAgICAgICAgICAgICAgYSA9ICAoMCwgbi5pc1ZhbGlkRWxlbWVudCkoZSkgPyAgKDAsIG4uY2xvbmVFbGVtZW50KShlLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBlbGVtZW50UmVmOiBmdW5jdGlvbiBlKHIpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAocCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwLmN1cnJlbnQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcC5jdXJyZW50ID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHIgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5mb2N1cygpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfSkgOiBlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICByZXR1cm4gYTtcbiAgICAgICAgICAgIH0pKTtcbiAgICAgICAgfSksIFsgaSBdKTtcbiAgICAgICAgdmFyIGcgPSB5LmN1cnJlbnQ7XG4gICAgICAgICgwLCBuLnVzZUVmZmVjdCkoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICB9KSwgWyBvIF0pO1xuICAgICAgICAvLyBgdXNlUmVmYCB3aWxsIHJlY29tcHV0ZSBpdHMgaW5pdGlhbCB2YWx1ZSBldmVyeSByZW5kZXIgY3ljbGUuXG4gICAgICAgIC8vIFRvIGF2b2lkIHRoZSBhcnJheSBwcm9jZXNzaW5nIHdlIGNhbiBwcm92aWRlIGFuIGluaXRpYWxpemF0aW9uIGZ1bmN0aW9uIHRvIHVzZVN0YXRlIGFuZCBpbml0IHRoZSByZWYgd2l0aCB0aGUgcmVzdWx0XG4gICAgICAgICAgICAgICAgdmFyIGggPSAoMCwgbi51c2VTdGF0ZSkoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIFcoZywgdik7XG4gICAgICAgIH0pKSwgUyA9IG9lKGgsIDEpLCBFID0gU1swXTtcbiAvLyBOT1NPTkFSXG4gICAgICAgIC8vIGB3aW5kb3dQYW5lc2AgaXMgYW4gYXJyYXkgb2YgYXJyYXlzLCBlYWNoIG9mIGxlbmd0aCBgdmlydHVhbGl6YXRpb25gLiBFYWNoIFwicGFuZVwiIGlzIGp1c3QgYSBzdWJzZXQgb2ZcbiAgICAgICAgLy8gYGNoaWxkcmVuYCB3aGljaCB3aWxsIGJlIHJlbmRlcmVkIGluIGEgY2h1bmssIGFuZCBhdCBtb3N0IDMgb2YgdGhlc2UgcGFuZXMgd2lsbCByZW5kZXIgYXQgYW55IGdpdmVuIHRpbWUuXG4gICAgICAgICAgICAgICAgdmFyIE8gPSAoMCwgbi51c2VSZWYpKEUpO1xuICAgICAgICB2YXIgTSA9ICgwLCBuLnVzZVJlZikoMCk7XG4gICAgICAgIHZhciB3ID0gKDAsIG4udXNlUmVmKShudWxsKTtcbiAgICAgICAgLy8gQW4gSW50ZXJzZWN0aW9uT2JzZXJ2ZXIgaXMgdXNlZCB0byBkZXRlY3Qgd2hlbiBwYW5lIGNoYW5nZXMgYXJlIG5lZWRlZC5cbiAgICAgICAgLy8gV2hlbiBsb2FkUHJldlBhbmVSZWYgb3IgbG9hZE5leHRQYW5lUmVmIGVudHJpZXMgaW50ZXJzZWN0IHRoZSBtZW51LCB0aGUgY3VycmVudFBhbmVJZCB3aWxsIGJlIHVwZGF0ZWQuXG4gICAgICAgICAgICAgICAgdmFyIGsgPSAoMCwgbi51c2VSZWYpKCk7XG4gICAgICAgIHZhciBqID0gKDAsIG4udXNlUmVmKShnZSk7XG4gICAgICAgIHZhciBJID0gKDAsIG4udXNlUmVmKShnZSk7XG4gICAgICAgIHZhciBSID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHZhciBlO1xuICAgICAgICAgICAgdmFyIHIgPSBPLmN1cnJlbnQsIG4gPSByID09PSB2b2lkIDAgPyBbXSA6IHI7XG4gICAgICAgICAgICB2YXIgdCA9IE0uY3VycmVudDtcbiAgICAgICAgICAgIC8qKlxuICAgICAqIGNyZWF0ZSBvbk1vdW50IGZvciBhbiBjaGlsZCBvZiB0aGUgbWVudSB3aGljaCB3aWxsIGJlIHVzZWQgdG8gdHJpZ2dlciBwYW5lXG4gICAgICogY2hhbmdlcyB1cG9uIGludGVyc2VjdGlvbiB3aXRoIHRoZSBtZW51J3MgdmlzaWJsZSBib3VuZHNcbiAgICAgKi8gICAgICAgICAgICB2YXIgbyA9IGZ1bmN0aW9uIGUocikge1xuICAgICAgICAgICAgICAgIHJldHVybiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciBuO1xuICAgICAgICAgICAgICAgICAgICBpZiAoIWUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICByLmN1cnJlbnQucHVzaChlKTtcbiAgICAgICAgICAgICAgICAgICAgKG4gPSBrLmN1cnJlbnQpID09PSBudWxsIHx8IG4gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG4ub2JzZXJ2ZShlKTtcbiAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIC8qKlxuICAgICAqIG9uVW5tb3VudCB0byBjbGVhbnVwIHRoZSBvcGVyYXRpb25zIG9mIGBvblZpcnR1YWxpemVNb3VudGBcbiAgICAgKi8gICAgICAgICAgICB2YXIgYSA9IGZ1bmN0aW9uIGUocikge1xuICAgICAgICAgICAgICAgIHZhciBuO1xuICAgICAgICAgICAgICAgIGlmICghcikge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHZhciB0ID0gSS5jdXJyZW50LmluZGV4T2Yocik7XG4gICAgICAgICAgICAgICAgaWYgKHQgPj0gMCkge1xuICAgICAgICAgICAgICAgICAgICBJLmN1cnJlbnQuc3BsaWNlKHQsIDEpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB2YXIgbyA9IGouY3VycmVudC5pbmRleE9mKHIpO1xuICAgICAgICAgICAgICAgIGlmIChvKSB7XG4gICAgICAgICAgICAgICAgICAgIGouY3VycmVudC5zcGxpY2UobywgMSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIChuID0gay5jdXJyZW50KSA9PT0gbnVsbCB8fCBuID09PSB2b2lkIDAgPyB2b2lkIDAgOiBuLnVub2JzZXJ2ZShyKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICByZXR1cm4gW10uY29uY2F0KGVlKFEoblt0IC0gMV0sIG8oSSksIGEsIHtcbiAgICAgICAgICAgICAgICB0cmFja0ZpcnN0RWxlbWVudDogdHJ1ZVxuICAgICAgICAgICAgfSkpLCBlZSgoZSA9IG5bdF0pICE9PSBudWxsICYmIGUgIT09IHZvaWQgMCA/IGUgOiBbXSksIGVlKFEoblt0ICsgMV0sIG8oaiksIGEsIHtcbiAgICAgICAgICAgICAgICB0cmFja0xhc3RFbGVtZW50OiB0cnVlXG4gICAgICAgICAgICB9KSkpO1xuICAgICAgICB9KSwgW10pO1xuICAgICAgICB2YXIgUCA9ICgwLCBuLnVzZVN0YXRlKShSKSwgeCA9IG9lKFAsIDIpLCBBID0geFswXSwgVCA9IHhbMV07XG4gICAgICAgIHZhciBMID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgciA9IE0uY3VycmVudDtcbiAgICAgICAgICAgIE0uY3VycmVudCA9IE1hdGgubWF4KDAsIE1hdGgubWluKGUsIE8uY3VycmVudC5sZW5ndGggLSAxKSk7XG4gICAgICAgICAgICBpZiAociA9PT0gTS5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgLy8gbm8gY2hhbmdlIGluIGN1cnJlbnQgcGFuZVxuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFQoUik7XG4gICAgICAgIH0pLCBbIFIgXSk7XG4gICAgICAgIC8vIExpbmsgYW4gSW50ZXJzZWN0aW9uT2JzZXJ2ZXIgaW5zdGFuY2Ugd2l0aCB0aGUgbWVudSBjaGlsZHJlbiB0byBiZSBvYnNlcnZlZFxuICAgICAgICAgICAgICAgIHZhciBfID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgcjtcbiAgICAgICAgICAgIEMoYSwgZSk7XG4gICAgICAgICAgICB3LmN1cnJlbnQgPSBlO1xuICAgICAgICAgICAgLy8gVGhpcyBpcyBvdmVybHkgZGVmZW5zaXZlIGFuZCBjb3VsZCBwcm9iYWJseSBiZSByZW1vdmVkXG4gICAgICAgICAgICAgICAgICAgICAgICAociA9IGsuY3VycmVudCkgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5kaXNjb25uZWN0KCk7XG4gICAgICAgICAgICBpZiAoIWUpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBJLmN1cnJlbnQgPSBbXTtcbiAgICAgICAgICAgIGouY3VycmVudCA9IFtdO1xuICAgICAgICAgICAgLy8gUnVuIHRoZSBvYnNlcnZhdGlvbiBmbG93XG4gICAgICAgICAgICAgICAgICAgICAgICBrLmN1cnJlbnQgPSBuZXcgSW50ZXJzZWN0aW9uT2JzZXJ2ZXIoKGZ1bmN0aW9uKHIpIHtcbiAgICAgICAgICAgICAgICB2YXIgbjtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IE0uY3VycmVudDtcbiAgICAgICAgICAgICAgICB2YXIgbyA9IGUuZmlyc3RFbGVtZW50Q2hpbGQ7XG4gICAgICAgICAgICAgICAgaWYgKCEhbyAmJiBvLnNjcm9sbEhlaWdodCA8IGUuY2xpZW50SGVpZ2h0KSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciBhO1xuICAgICAgICAgICAgICAgICAgICAvLyBJZiB0aGUgZmlyc3QgZWxlbWVudCBkb2Vzbid0IHJlcXVpcmUgYSBzY3JvbGxiYXIgdGhlbiBpdCdzIGxpa2VseSBhIGZpbHRlciBpbnB1dFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG8gPSAoYSA9IG8pID09PSBudWxsIHx8IGEgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGEubmV4dEVsZW1lbnRTaWJsaW5nO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBpZiAoKChuID0gbykgPT09IG51bGwgfHwgbiA9PT0gdm9pZCAwID8gdm9pZCAwIDogbi5zY3JvbGxUb3ApID09PSAwICYmIHQgPT09IDAgJiYgTy5jdXJyZW50Lmxlbmd0aCA+IDEgJiYgci5zb21lKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBlLmlzSW50ZXJzZWN0aW5nO1xuICAgICAgICAgICAgICAgIH0pKSkge1xuICAgICAgICAgICAgICAgICAgICAvLyBUaGUgbWVudSBoYXNuJ3Qgc2Nyb2xsZWQsIGlzIG9uIHBhbmUgMCwgYW5kIGFscmVhZHkgaGFzIGFuIGludGVyc2VjdGlvbiwgdGhlIGB2aXJ0dWFsaXphdGlvbmAgcHJvcCBpcyB0b28gc21hbGxcbiAgICAgICAgICAgICAgICAgICAgbSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGUgKyAxMDtcbiAgICAgICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgICAgICBpZiAoZmFsc2UpIHt9XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdmFyIGkgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICByLmZvckVhY2goKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKGkgfHwgIWUuaXNJbnRlcnNlY3RpbmcpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIGRvbid0IHByb2Nlc3MgaWYgdGhlIHBhbmUgY2hhbmdlZCBvciB0aGUgZW50cnkgaXNuJ3QgaW50ZXJzZWN0aW5nXG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKEkuY3VycmVudC5pbmNsdWRlcyhlLnRhcmdldCkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGkgPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICAgICAgTCh0IC0gMSk7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoai5jdXJyZW50LmluY2x1ZGVzKGUudGFyZ2V0KSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgaSA9IHRydWU7XG4gICAgICAgICAgICAgICAgICAgICAgICBMKHQgKyAxKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0pKTtcbiAgICAgICAgICAgIH0pLCB7XG4gICAgICAgICAgICAgICAgcm9vdDogZVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pLCBbIGEsIEwgXSk7XG4gICAgICAgIHZhciBxID0gKDAsIG4udXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgciA9IHcuY3VycmVudDtcbiAgICAgICAgICAgIGlmICghcikge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgIHZhciBuID0gZS5rZXk7XG4gICAgICAgICAgICBpZiAobiA9PT0gXCJIb21lXCIpIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IE0uY3VycmVudCA9PT0gMDtcbiAgICAgICAgICAgICAgICBpZiAodCkge1xuICAgICAgICAgICAgICAgICAgICB2YXIgbztcbiAgICAgICAgICAgICAgICAgICAgLy8gaWYgdGhlIGZpcnN0IHBhbmUgaXMgYWxyZWFkeSByZW5kZXJlZCwgZmluZCB0aGUgZmlyc3QgZWxlbWVudCBhbmQgZm9jdXMgaXRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgYSA9ICgwLCBWLmdldFNvcnRlZFRhYmJhYmxlRWxlbWVudHMpKHIsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlnbm9yZVRhYkluZGV4OiB0cnVlXG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICB2YXIgaSA9IGFbMF07XG4gICAgICAgICAgICAgICAgICAgIGkgPT09IG51bGwgfHwgaSA9PT0gdm9pZCAwID8gdm9pZCAwIDogKG8gPSBpLmZvY3VzKSA9PT0gbnVsbCB8fCBvID09PSB2b2lkIDAgPyB2b2lkIDAgOiBvLmNhbGwoaSk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gaWYgaXQncyBub3QgcmVuZGVyZWQsIHNldCB1cCBmb2N1c2luZyBpdCBhZnRlciB0aGUgbmV4dCByZW5kZXJcbiAgICAgICAgICAgICAgICAgICAgYi5jdXJyZW50ID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAgICAgLy8gdGhlbiBjYWxsIGNoYW5nZVBhbmUoKSB0byB0cmlnZ2VyIHRoZSByZW5kZXJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBMKDApO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgdSA9IE8uY3VycmVudC5sZW5ndGggLSAxO1xuICAgICAgICAgICAgaWYgKG4gPT09IFwiRW5kXCIpIHtcbiAgICAgICAgICAgICAgICB2YXIgbCA9IE0uY3VycmVudCA9PT0gdTtcbiAgICAgICAgICAgICAgICBpZiAobCkge1xuICAgICAgICAgICAgICAgICAgICB2YXIgYztcbiAgICAgICAgICAgICAgICAgICAgLy8gaWYgdGhlIGxhc3QgcGFuZSBpcyBhbHJlYWR5IHJlbmRlcmVkLCBmaW5kIHRoZSBmaXJzdCBlbGVtZW50IGFuZCBmb2N1cyBpdFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBzID0gKDAsIFYuZ2V0U29ydGVkVGFiYmFibGVFbGVtZW50cykociwge1xuICAgICAgICAgICAgICAgICAgICAgICAgaWdub3JlVGFiSW5kZXg6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgIHZhciBmID0gc1tzLmxlbmd0aCAtIDFdO1xuICAgICAgICAgICAgICAgICAgICBmID09PSBudWxsIHx8IGYgPT09IHZvaWQgMCA/IHZvaWQgMCA6IChjID0gZi5mb2N1cykgPT09IG51bGwgfHwgYyA9PT0gdm9pZCAwID8gdm9pZCAwIDogYy5jYWxsKGYpO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIGlmIGl0J3Mgbm90IHJlbmRlcmVkLCBzZXQgdXAgZm9jdXNpbmcgaXQgYWZ0ZXIgdGhlIG5leHQgcmVuZGVyXG4gICAgICAgICAgICAgICAgICAgIHAuY3VycmVudCA9IHRydWU7XG4gICAgICAgICAgICAgICAgICAgIC8vIHRoZW4gY2FsbCBjaGFuZ2VQYW5lKCkgdG8gdHJpZ2dlciB0aGUgcmVuZGVyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgTCh1KTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdmFyIGQgPSAoMCwgVi5nZXRTb3J0ZWRUYWJiYWJsZUVsZW1lbnRzKShyLCB7XG4gICAgICAgICAgICAgICAgaWdub3JlVGFiSW5kZXg6IHRydWVcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgdmFyIHYgPSAoZSA9PT0gbnVsbCB8fCBlID09PSB2b2lkIDAgPyB2b2lkIDAgOiBlLnRhcmdldCkgaW5zdGFuY2VvZiBFbGVtZW50ID8gZS50YXJnZXQgOiBudWxsO1xuICAgICAgICAgICAgdmFyIG0gPSByID09PSBudWxsIHx8IHIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHIucXVlcnlTZWxlY3RvcihcIjpmb2N1c1wiKTtcbiAgICAgICAgICAgIHZhciB5ID0gdiB8fCBtO1xuICAgICAgICAgICAgdmFyIGcgPSB5ID8gZC5pbmRleE9mKHkpIDogLTE7XG4gICAgICAgICAgICAoMCwgVi5oYW5kbGVGb2N1cykobiwgZCwgZywge1xuICAgICAgICAgICAgICAgIGVuYWJsZUxvb3A6IGZhbHNlLFxuICAgICAgICAgICAgICAgIC8vIFZpcnR1YWxpemVkUmVzdWx0c01lbnUgZG9lcyBub3Qgc3VwcG9ydCBsb29waW5nIGZvY3VzXG4gICAgICAgICAgICAgICAgb3JpZW50YXRpb246IFwidmVydGljYWxcIixcbiAgICAgICAgICAgICAgICBlbmFibGVUYWI6IGZhbHNlLFxuICAgICAgICAgICAgICAgIGVuYWJsZUhvbWVFbmQ6IGZhbHNlXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSksIFsgTCBdKTtcbiAgICAgICAgKDAsIG4udXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBtKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICAgICAgICAgIHJldHVybiBvO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICB9KSwgWyBvIF0pO1xuICAgICAgICAoMCwgbi51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIE8uY3VycmVudCA9IFcoZywgdik7XG4gICAgICAgICAgICBUKFIpO1xuICAgICAgICB9KSwgWyBnLCB2LCBSIF0pO1xuICAgICAgICAoMCwgbi51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiBmdW5jdGlvbigpIHtcbiAgICAgICAgICAgICAgICB2YXIgZTtcbiAgICAgICAgICAgICAgICByZXR1cm4gKGUgPSBrLmN1cnJlbnQpID09PSBudWxsIHx8IGUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGUuZGlzY29ubmVjdCgpO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFtdKTtcbiAgICAgICAgKDAsIG4udXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAobCA9PT0gXCJuZXZlclwiKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhciBlID0gdy5jdXJyZW50O1xuICAgICAgICAgICAgaWYgKGUpIHtcbiAgICAgICAgICAgICAgICBlLmFkZEV2ZW50TGlzdGVuZXIoXCJrZXlkb3duXCIsIHEpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgICAgIGUgPT09IG51bGwgfHwgZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogZS5yZW1vdmVFdmVudExpc3RlbmVyKFwia2V5ZG93blwiLCBxKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIHEsIGwgXSk7XG4gICAgICAgIFxuICAgICAgICByZXR1cm4gdCgpLmNyZWF0ZUVsZW1lbnQoQiwgWih7XG4gICAgICAgICAgICBlbGVtZW50UmVmOiBfLFxuICAgICAgICAgICAgZm9jdXNNb2RlOiBsXG4gICAgICAgIH0sIGMpLCBBKTtcbiAgICB9XG4gICAgaGUucHJvcFR5cGVzID0geWU7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvdXRpbHMvc3NyRG9jdW1lbnQudHNcbiAgICAvKiBlc2xpbnQtZGlzYWJsZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tZW1wdHktZnVuY3Rpb24gKi9cbiAgICB2YXIgU2UgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIGFwcGVuZENoaWxkOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgYWRkRXZlbnRMaXN0ZW5lcjogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICByZW1vdmVFdmVudExpc3RlbmVyOiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIGFjdGl2ZUVsZW1lbnQ6IHtcbiAgICAgICAgICAgIGJsdXI6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIG5vZGVOYW1lOiBcIlwiXG4gICAgICAgIH0sXG4gICAgICAgIHF1ZXJ5U2VsZWN0b3I6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfSxcbiAgICAgICAgcXVlcnlTZWxlY3RvckFsbDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgfSxcbiAgICAgICAgZ2V0RWxlbWVudEJ5SWQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfSxcbiAgICAgICAgY3JlYXRlRXZlbnQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIGluaXRFdmVudDogZnVuY3Rpb24gZSgpIHt9XG4gICAgICAgICAgICB9O1xuICAgICAgICB9LFxuICAgICAgICBjcmVhdGVFbGVtZW50OiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBjaGlsZHJlbjogW10sXG4gICAgICAgICAgICAgICAgY2hpbGROb2RlczogW10sXG4gICAgICAgICAgICAgICAgc3R5bGU6IHt9LFxuICAgICAgICAgICAgICAgIHNldEF0dHJpYnV0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICAgICAgICAgIGdldEVsZW1lbnRzQnlUYWdOYW1lOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gW107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgY3JlYXRlRWxlbWVudE5TOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHt9O1xuICAgICAgICB9LFxuICAgICAgICBpbXBvcnROb2RlOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH0sXG4gICAgICAgIGxvY2F0aW9uOiB7XG4gICAgICAgICAgICBoYXNoOiBcIlwiLFxuICAgICAgICAgICAgaG9zdDogXCJcIixcbiAgICAgICAgICAgIGhvc3RuYW1lOiBcIlwiLFxuICAgICAgICAgICAgaHJlZjogXCJcIixcbiAgICAgICAgICAgIG9yaWdpbjogXCJcIixcbiAgICAgICAgICAgIHBhdGhuYW1lOiBcIlwiLFxuICAgICAgICAgICAgcHJvdG9jb2w6IFwiXCIsXG4gICAgICAgICAgICBzZWFyY2g6IFwiXCJcbiAgICAgICAgfVxuICAgIH07XG4gICAgZnVuY3Rpb24gRWUoKSB7XG4gICAgICAgIHZhciBlID0gdHlwZW9mIGRvY3VtZW50ICE9PSBcInVuZGVmaW5lZFwiID8gZG9jdW1lbnQgOiBTZTtcbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfVxuICAgIHZhciBPZSA9IEVlKCk7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBNZSA9IC8qIHVudXNlZCBwdXJlIGV4cHJlc3Npb24gb3Igc3VwZXIgKi8gbnVsbCAmJiBPZTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy91dGlscy9zc3JXaW5kb3cudHNcbiAgICAvKiBlc2xpbnQtZGlzYWJsZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tZW1wdHktZnVuY3Rpb24gKi9cbiAgICB2YXIgd2UgPSB7XG4gICAgICAgIGRvY3VtZW50OiBTZSxcbiAgICAgICAgbmF2aWdhdG9yOiB7XG4gICAgICAgICAgICB1c2VyQWdlbnQ6IFwiXCJcbiAgICAgICAgfSxcbiAgICAgICAgbG9jYXRpb246IHtcbiAgICAgICAgICAgIGhhc2g6IFwiXCIsXG4gICAgICAgICAgICBob3N0OiBcIlwiLFxuICAgICAgICAgICAgaG9zdG5hbWU6IFwiXCIsXG4gICAgICAgICAgICBocmVmOiBcIlwiLFxuICAgICAgICAgICAgb3JpZ2luOiBcIlwiLFxuICAgICAgICAgICAgcGF0aG5hbWU6IFwiXCIsXG4gICAgICAgICAgICBwcm90b2NvbDogXCJcIixcbiAgICAgICAgICAgIHNlYXJjaDogXCJcIlxuICAgICAgICB9LFxuICAgICAgICBoaXN0b3J5OiB7XG4gICAgICAgICAgICByZXBsYWNlU3RhdGU6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIHB1c2hTdGF0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICAgICAgZ286IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIGJhY2s6IGZ1bmN0aW9uIGUoKSB7fVxuICAgICAgICB9LFxuICAgICAgICBDdXN0b21FdmVudDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzO1xuICAgICAgICB9LFxuICAgICAgICBhZGRFdmVudExpc3RlbmVyOiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIHJlbW92ZUV2ZW50TGlzdGVuZXI6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgZ2V0Q29tcHV0ZWRTdHlsZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgZ2V0UHJvcGVydHlWYWx1ZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFwiXCI7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgSW1hZ2U6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgRGF0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICBzY3JlZW46IHt9LFxuICAgICAgICBzZXRUaW1lb3V0OiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIGNsZWFyVGltZW91dDogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICBtYXRjaE1lZGlhOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHt9O1xuICAgICAgICB9LFxuICAgICAgICByZXF1ZXN0QW5pbWF0aW9uRnJhbWU6IGZ1bmN0aW9uIGUocikge1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBzZXRUaW1lb3V0ID09PSBcInVuZGVmaW5lZFwiKSB7XG4gICAgICAgICAgICAgICAgcigpO1xuICAgICAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHNldFRpbWVvdXQociwgMCk7XG4gICAgICAgIH0sXG4gICAgICAgIGNhbmNlbEFuaW1hdGlvbkZyYW1lOiBmdW5jdGlvbiBlKHIpIHtcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygc2V0VGltZW91dCA9PT0gXCJ1bmRlZmluZWRcIikge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGNsZWFyVGltZW91dChyKTtcbiAgICAgICAgfVxuICAgIH07XG4gICAgZnVuY3Rpb24gQ2UoKSB7XG4gICAgICAgIHZhciBlID0gdHlwZW9mIHdpbmRvdyAhPT0gXCJ1bmRlZmluZWRcIiA/IHdpbmRvdyA6IHdlO1xuICAgICAgICByZXR1cm4gZTtcbiAgICB9XG4gICAgdmFyIGtlID0gQ2UoKTtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IGplID0gLyogdW51c2VkIHB1cmUgZXhwcmVzc2lvbiBvciBzdXBlciAqLyBudWxsICYmIGtlO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1Jlc3VsdHNNZW51L1ZpcnR1YWxpemVkUmVzdWx0c01lbnUvaW5kZXgudHNcbiAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tcmVsYXRpdmUtaW1wb3J0cy1vZi1wdWJsaXNoZWQgLS0gIFRPRE8oU1VJLTgxOTApOiBWaXJ0dWFsaXplZFJlc3VsdHNNZW51IHdyYXBzIFJlc3VsdHNNZW51LCB1c2luZyBleHRlcm5hbCBpbXBvcnQgY3JlYXRlcyBjaXJjdWxhciBkZXBlbmRlbmN5XG4gICAgLy8gSW4gZW52aXJvbm1lbnRzIHdpdGhvdXQgSW50ZXJzZWN0aW9uT2JzZXJ2ZXIgc3VwcG9ydCB0aGlzIHNob3VsZCBqdXN0IGV4cG9ydCBSZXN1bHRzTWVudVxuICAgIHZhciBJZSA9IFwiSW50ZXJzZWN0aW9uT2JzZXJ2ZXJcIiBpbiBDZSgpID8gaGUgOiBCO1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3QgUmUgPSBJZTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9SZXN1bHRzTWVudS9pbmRleC50c1xuICAgIG1vZHVsZS5leHBvcnRzID0gcjtcbiAgICAvKioqKioqL30pKCk7Il0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///583\n\n}')},740:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("{\nvar root_1 = __webpack_require__(26854);\nvar isArrayLike_1 = __webpack_require__(37166);\nvar isPromise_1 = __webpack_require__(35117);\nvar isObject_1 = __webpack_require__(19469);\nvar Observable_1 = __webpack_require__(91638);\nvar iterator_1 = __webpack_require__(78380);\nvar InnerSubscriber_1 = __webpack_require__(98261);\nvar observable_1 = __webpack_require__(85999);\nfunction subscribeToResult(outerSubscriber, result, outerValue, outerIndex) {\n    var destination = new InnerSubscriber_1.InnerSubscriber(outerSubscriber, outerValue, outerIndex);\n    if (destination.closed) {\n        return null;\n    }\n    if (result instanceof Observable_1.Observable) {\n        if (result._isScalar) {\n            destination.next(result.value);\n            destination.complete();\n            return null;\n        }\n        else {\n            destination.syncErrorThrowable = true;\n            return result.subscribe(destination);\n        }\n    }\n    else if (isArrayLike_1.isArrayLike(result)) {\n        for (var i = 0, len = result.length; i < len && !destination.closed; i++) {\n            destination.next(result[i]);\n        }\n        if (!destination.closed) {\n            destination.complete();\n        }\n    }\n    else if (isPromise_1.isPromise(result)) {\n        result.then(function (value) {\n            if (!destination.closed) {\n                destination.next(value);\n                destination.complete();\n            }\n        }, function (err) { return destination.error(err); })\n            .then(null, function (err) {\n            // Escaping the Promise trap: globally throw unhandled errors\n            root_1.root.setTimeout(function () { throw err; });\n        });\n        return destination;\n    }\n    else if (result && typeof result[iterator_1.iterator] === 'function') {\n        var iterator = result[iterator_1.iterator]();\n        do {\n            var item = iterator.next();\n            if (item.done) {\n                destination.complete();\n                break;\n            }\n            destination.next(item.value);\n            if (destination.closed) {\n                break;\n            }\n        } while (true);\n    }\n    else if (result && typeof result[observable_1.observable] === 'function') {\n        var obs = result[observable_1.observable]();\n        if (typeof obs.subscribe !== 'function') {\n            destination.error(new TypeError('Provided object does not correctly implement Symbol.observable'));\n        }\n        else {\n            return obs.subscribe(new InnerSubscriber_1.InnerSubscriber(outerSubscriber, outerValue, outerIndex));\n        }\n    }\n    else {\n        var value = isObject_1.isObject(result) ? 'an invalid object' : \"'\" + result + \"'\";\n        var msg = (\"You provided \" + value + \" where a stream was expected.\")\n            + ' You can provide an Observable, Promise, Array, or Iterable.';\n        destination.error(new TypeError(msg));\n    }\n    return null;\n}\nexports.subscribeToResult = subscribeToResult;\n//# sourceMappingURL=subscribeToResult.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///740\n\n}")},922:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/** Used to detect hot functions by number of calls within a span of milliseconds. */\nvar HOT_COUNT = 800,\n    HOT_SPAN = 16;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeNow = Date.now;\n\n/**\n * Creates a function that'll short out and invoke `identity` instead\n * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`\n * milliseconds.\n *\n * @private\n * @param {Function} func The function to restrict.\n * @returns {Function} Returns the new shortable function.\n */\nfunction shortOut(func) {\n  var count = 0,\n      lastCalled = 0;\n\n  return function() {\n    var stamp = nativeNow(),\n        remaining = HOT_SPAN - (stamp - lastCalled);\n\n    lastCalled = stamp;\n    if (remaining > 0) {\n      if (++count >= HOT_COUNT) {\n        return arguments[0];\n      }\n    } else {\n      count = 0;\n    }\n    return func.apply(undefined, arguments);\n  };\n}\n\nmodule.exports = shortOut;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9fc2hvcnRPdXQuanM/OTA2ZCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogVXNlZCB0byBkZXRlY3QgaG90IGZ1bmN0aW9ucyBieSBudW1iZXIgb2YgY2FsbHMgd2l0aGluIGEgc3BhbiBvZiBtaWxsaXNlY29uZHMuICovXG52YXIgSE9UX0NPVU5UID0gODAwLFxuICAgIEhPVF9TUEFOID0gMTY7XG5cbi8qIEJ1aWx0LWluIG1ldGhvZCByZWZlcmVuY2VzIGZvciB0aG9zZSB3aXRoIHRoZSBzYW1lIG5hbWUgYXMgb3RoZXIgYGxvZGFzaGAgbWV0aG9kcy4gKi9cbnZhciBuYXRpdmVOb3cgPSBEYXRlLm5vdztcblxuLyoqXG4gKiBDcmVhdGVzIGEgZnVuY3Rpb24gdGhhdCdsbCBzaG9ydCBvdXQgYW5kIGludm9rZSBgaWRlbnRpdHlgIGluc3RlYWRcbiAqIG9mIGBmdW5jYCB3aGVuIGl0J3MgY2FsbGVkIGBIT1RfQ09VTlRgIG9yIG1vcmUgdGltZXMgaW4gYEhPVF9TUEFOYFxuICogbWlsbGlzZWNvbmRzLlxuICpcbiAqIEBwcml2YXRlXG4gKiBAcGFyYW0ge0Z1bmN0aW9ufSBmdW5jIFRoZSBmdW5jdGlvbiB0byByZXN0cmljdC5cbiAqIEByZXR1cm5zIHtGdW5jdGlvbn0gUmV0dXJucyB0aGUgbmV3IHNob3J0YWJsZSBmdW5jdGlvbi5cbiAqL1xuZnVuY3Rpb24gc2hvcnRPdXQoZnVuYykge1xuICB2YXIgY291bnQgPSAwLFxuICAgICAgbGFzdENhbGxlZCA9IDA7XG5cbiAgcmV0dXJuIGZ1bmN0aW9uKCkge1xuICAgIHZhciBzdGFtcCA9IG5hdGl2ZU5vdygpLFxuICAgICAgICByZW1haW5pbmcgPSBIT1RfU1BBTiAtIChzdGFtcCAtIGxhc3RDYWxsZWQpO1xuXG4gICAgbGFzdENhbGxlZCA9IHN0YW1wO1xuICAgIGlmIChyZW1haW5pbmcgPiAwKSB7XG4gICAgICBpZiAoKytjb3VudCA+PSBIT1RfQ09VTlQpIHtcbiAgICAgICAgcmV0dXJuIGFyZ3VtZW50c1swXTtcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgY291bnQgPSAwO1xuICAgIH1cbiAgICByZXR1cm4gZnVuYy5hcHBseSh1bmRlZmluZWQsIGFyZ3VtZW50cyk7XG4gIH07XG59XG5cbm1vZHVsZS5leHBvcnRzID0gc2hvcnRPdXQ7XG4iXSwiZmlsZSI6IjkyMi5qcyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///922\n\n}")},973:(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nif (true) {\n  module.exports = __webpack_require__(94315)\n} else // removed by dead control flow\n{}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOTczLmpzIiwibWFwcGluZ3MiOiJBQUFZO0FBQ1osSUFBSSxJQUFxQztBQUN6QyxFQUFFLDJDQUFrRTtBQUNwRSxFQUFFLEtBQUs7QUFBQSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvQHJlYWN0LXNwcmluZy9yYWZ6L2Rpc3QvY2pzL2luZGV4LmpzP2VkOTMiXSwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgPT09ICdwcm9kdWN0aW9uJykge1xuICBtb2R1bGUuZXhwb3J0cyA9IHJlcXVpcmUoJy4vcmVhY3Qtc3ByaW5nX3JhZnoucHJvZHVjdGlvbi5taW4uY2pzJylcbn0gZWxzZSB7XG4gIG1vZHVsZS5leHBvcnRzID0gcmVxdWlyZSgnLi9yZWFjdC1zcHJpbmdfcmFmei5kZXZlbG9wbWVudC5janMnKVxufSJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///973\n\n}")},1431:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar Stack = __webpack_require__(41082),\n    equalArrays = __webpack_require__(47804),\n    equalByTag = __webpack_require__(77051),\n    equalObjects = __webpack_require__(58144),\n    getTag = __webpack_require__(90276),\n    isArray = __webpack_require__(85100),\n    isBuffer = __webpack_require__(50439),\n    isTypedArray = __webpack_require__(1676);\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1;\n\n/** `Object#toString` result references. */\nvar argsTag = '[object Arguments]',\n    arrayTag = '[object Array]',\n    objectTag = '[object Object]';\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * A specialized version of `baseIsEqual` for arrays and objects which performs\n * deep comparisons and tracks traversed objects enabling objects with circular\n * references to be compared.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} [stack] Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {\n  var objIsArr = isArray(object),\n      othIsArr = isArray(other),\n      objTag = objIsArr ? arrayTag : getTag(object),\n      othTag = othIsArr ? arrayTag : getTag(other);\n\n  objTag = objTag == argsTag ? objectTag : objTag;\n  othTag = othTag == argsTag ? objectTag : othTag;\n\n  var objIsObj = objTag == objectTag,\n      othIsObj = othTag == objectTag,\n      isSameTag = objTag == othTag;\n\n  if (isSameTag && isBuffer(object)) {\n    if (!isBuffer(other)) {\n      return false;\n    }\n    objIsArr = true;\n    objIsObj = false;\n  }\n  if (isSameTag && !objIsObj) {\n    stack || (stack = new Stack);\n    return (objIsArr || isTypedArray(object))\n      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)\n      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);\n  }\n  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {\n    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),\n        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');\n\n    if (objIsWrapped || othIsWrapped) {\n      var objUnwrapped = objIsWrapped ? object.value() : object,\n          othUnwrapped = othIsWrapped ? other.value() : other;\n\n      stack || (stack = new Stack);\n      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);\n    }\n  }\n  if (!isSameTag) {\n    return false;\n  }\n  stack || (stack = new Stack);\n  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);\n}\n\nmodule.exports = baseIsEqualDeep;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///1431\n\n}")},1542:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\nvar tryCatch_1 = __webpack_require__(36786);\nvar errorObject_1 = __webpack_require__(70817);\n/**\n * Compares all values of two observables in sequence using an optional comparor function\n * and returns an observable of a single boolean value representing whether or not the two sequences\n * are equal.\n *\n * <span class="informal">Checks to see of all values emitted by both observables are equal, in order.</span>\n *\n * <img src="./img/sequenceEqual.png" width="100%">\n *\n * `sequenceEqual` subscribes to two observables and buffers incoming values from each observable. Whenever either\n * observable emits a value, the value is buffered and the buffers are shifted and compared from the bottom\n * up; If any value pair doesn\'t match, the returned observable will emit `false` and complete. If one of the\n * observables completes, the operator will wait for the other observable to complete; If the other\n * observable emits before completing, the returned observable will emit `false` and complete. If one observable never\n * completes or emits after the other complets, the returned observable will never complete.\n *\n * @example <caption>figure out if the Konami code matches</caption>\n * var code = Rx.Observable.from([\n *  "ArrowUp",\n *  "ArrowUp",\n *  "ArrowDown",\n *  "ArrowDown",\n *  "ArrowLeft",\n *  "ArrowRight",\n *  "ArrowLeft",\n *  "ArrowRight",\n *  "KeyB",\n *  "KeyA",\n *  "Enter" // no start key, clearly.\n * ]);\n *\n * var keys = Rx.Observable.fromEvent(document, \'keyup\')\n *  .map(e => e.code);\n * var matches = keys.bufferCount(11, 1)\n *  .mergeMap(\n *    last11 =>\n *      Rx.Observable.from(last11)\n *        .sequenceEqual(code)\n *   );\n * matches.subscribe(matched => console.log(\'Successful cheat at Contra? \', matched));\n *\n * @see {@link combineLatest}\n * @see {@link zip}\n * @see {@link withLatestFrom}\n *\n * @param {Observable} compareTo The observable sequence to compare the source sequence to.\n * @param {function} [comparor] An optional function to compare each value pair\n * @return {Observable} An Observable of a single boolean value representing whether or not\n * the values emitted by both observables were equal in sequence.\n * @method sequenceEqual\n * @owner Observable\n */\nfunction sequenceEqual(compareTo, comparor) {\n    return function (source) { return source.lift(new SequenceEqualOperator(compareTo, comparor)); };\n}\nexports.sequenceEqual = sequenceEqual;\nvar SequenceEqualOperator = (function () {\n    function SequenceEqualOperator(compareTo, comparor) {\n        this.compareTo = compareTo;\n        this.comparor = comparor;\n    }\n    SequenceEqualOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new SequenceEqualSubscriber(subscriber, this.compareTo, this.comparor));\n    };\n    return SequenceEqualOperator;\n}());\nexports.SequenceEqualOperator = SequenceEqualOperator;\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar SequenceEqualSubscriber = (function (_super) {\n    __extends(SequenceEqualSubscriber, _super);\n    function SequenceEqualSubscriber(destination, compareTo, comparor) {\n        _super.call(this, destination);\n        this.compareTo = compareTo;\n        this.comparor = comparor;\n        this._a = [];\n        this._b = [];\n        this._oneComplete = false;\n        this.add(compareTo.subscribe(new SequenceEqualCompareToSubscriber(destination, this)));\n    }\n    SequenceEqualSubscriber.prototype._next = function (value) {\n        if (this._oneComplete && this._b.length === 0) {\n            this.emit(false);\n        }\n        else {\n            this._a.push(value);\n            this.checkValues();\n        }\n    };\n    SequenceEqualSubscriber.prototype._complete = function () {\n        if (this._oneComplete) {\n            this.emit(this._a.length === 0 && this._b.length === 0);\n        }\n        else {\n            this._oneComplete = true;\n        }\n    };\n    SequenceEqualSubscriber.prototype.checkValues = function () {\n        var _c = this, _a = _c._a, _b = _c._b, comparor = _c.comparor;\n        while (_a.length > 0 && _b.length > 0) {\n            var a = _a.shift();\n            var b = _b.shift();\n            var areEqual = false;\n            if (comparor) {\n                areEqual = tryCatch_1.tryCatch(comparor)(a, b);\n                if (areEqual === errorObject_1.errorObject) {\n                    this.destination.error(errorObject_1.errorObject.e);\n                }\n            }\n            else {\n                areEqual = a === b;\n            }\n            if (!areEqual) {\n                this.emit(false);\n            }\n        }\n    };\n    SequenceEqualSubscriber.prototype.emit = function (value) {\n        var destination = this.destination;\n        destination.next(value);\n        destination.complete();\n    };\n    SequenceEqualSubscriber.prototype.nextB = function (value) {\n        if (this._oneComplete && this._a.length === 0) {\n            this.emit(false);\n        }\n        else {\n            this._b.push(value);\n            this.checkValues();\n        }\n    };\n    return SequenceEqualSubscriber;\n}(Subscriber_1.Subscriber));\nexports.SequenceEqualSubscriber = SequenceEqualSubscriber;\nvar SequenceEqualCompareToSubscriber = (function (_super) {\n    __extends(SequenceEqualCompareToSubscriber, _super);\n    function SequenceEqualCompareToSubscriber(destination, parent) {\n        _super.call(this, destination);\n        this.parent = parent;\n    }\n    SequenceEqualCompareToSubscriber.prototype._next = function (value) {\n        this.parent.nextB(value);\n    };\n    SequenceEqualCompareToSubscriber.prototype._error = function (err) {\n        this.parent.error(err);\n    };\n    SequenceEqualCompareToSubscriber.prototype._complete = function () {\n        this.parent._complete();\n    };\n    return SequenceEqualCompareToSubscriber;\n}(Subscriber_1.Subscriber));\n//# sourceMappingURL=sequenceEqual.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///1542\n\n}')},1607:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar copyObject = __webpack_require__(43390),\n    createAssigner = __webpack_require__(63634),\n    keysIn = __webpack_require__(22498);\n\n/**\n * This method is like `_.assign` except that it iterates over own and\n * inherited source properties.\n *\n * **Note:** This method mutates `object`.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @alias extend\n * @category Object\n * @param {Object} object The destination object.\n * @param {...Object} [sources] The source objects.\n * @returns {Object} Returns `object`.\n * @see _.assign\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n * }\n *\n * function Bar() {\n *   this.c = 3;\n * }\n *\n * Foo.prototype.b = 2;\n * Bar.prototype.d = 4;\n *\n * _.assignIn({ 'a': 0 }, new Foo, new Bar);\n * // => { 'a': 1, 'b': 2, 'c': 3, 'd': 4 }\n */\nvar assignIn = createAssigner(function(object, source) {\n  copyObject(source, keysIn(source), object);\n});\n\nmodule.exports = assignIn;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTYwNy5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsaUJBQWlCLG1CQUFPLENBQUMsS0FBZSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvbG9kYXNoL2Fzc2lnbkluLmpzP2QyODgiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIGNvcHlPYmplY3QgPSByZXF1aXJlKCcuL19jb3B5T2JqZWN0JyksXG4gICAgY3JlYXRlQXNzaWduZXIgPSByZXF1aXJlKCcuL19jcmVhdGVBc3NpZ25lcicpLFxuICAgIGtleXNJbiA9IHJlcXVpcmUoJy4va2V5c0luJyk7XG5cbi8qKlxuICogVGhpcyBtZXRob2QgaXMgbGlrZSBgXy5hc3NpZ25gIGV4Y2VwdCB0aGF0IGl0IGl0ZXJhdGVzIG92ZXIgb3duIGFuZFxuICogaW5oZXJpdGVkIHNvdXJjZSBwcm9wZXJ0aWVzLlxuICpcbiAqICoqTm90ZToqKiBUaGlzIG1ldGhvZCBtdXRhdGVzIGBvYmplY3RgLlxuICpcbiAqIEBzdGF0aWNcbiAqIEBtZW1iZXJPZiBfXG4gKiBAc2luY2UgNC4wLjBcbiAqIEBhbGlhcyBleHRlbmRcbiAqIEBjYXRlZ29yeSBPYmplY3RcbiAqIEBwYXJhbSB7T2JqZWN0fSBvYmplY3QgVGhlIGRlc3RpbmF0aW9uIG9iamVjdC5cbiAqIEBwYXJhbSB7Li4uT2JqZWN0fSBbc291cmNlc10gVGhlIHNvdXJjZSBvYmplY3RzLlxuICogQHJldHVybnMge09iamVjdH0gUmV0dXJucyBgb2JqZWN0YC5cbiAqIEBzZWUgXy5hc3NpZ25cbiAqIEBleGFtcGxlXG4gKlxuICogZnVuY3Rpb24gRm9vKCkge1xuICogICB0aGlzLmEgPSAxO1xuICogfVxuICpcbiAqIGZ1bmN0aW9uIEJhcigpIHtcbiAqICAgdGhpcy5jID0gMztcbiAqIH1cbiAqXG4gKiBGb28ucHJvdG90eXBlLmIgPSAyO1xuICogQmFyLnByb3RvdHlwZS5kID0gNDtcbiAqXG4gKiBfLmFzc2lnbkluKHsgJ2EnOiAwIH0sIG5ldyBGb28sIG5ldyBCYXIpO1xuICogLy8gPT4geyAnYSc6IDEsICdiJzogMiwgJ2MnOiAzLCAnZCc6IDQgfVxuICovXG52YXIgYXNzaWduSW4gPSBjcmVhdGVBc3NpZ25lcihmdW5jdGlvbihvYmplY3QsIHNvdXJjZSkge1xuICBjb3B5T2JqZWN0KHNvdXJjZSwga2V5c0luKHNvdXJjZSksIG9iamVjdCk7XG59KTtcblxubW9kdWxlLmV4cG9ydHMgPSBhc3NpZ25JbjtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///1607\n\n}")},1676:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar baseIsTypedArray = __webpack_require__(76940),\n    baseUnary = __webpack_require__(77118),\n    nodeUtil = __webpack_require__(27896);\n\n/* Node.js helper references. */\nvar nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;\n\n/**\n * Checks if `value` is classified as a typed array.\n *\n * @static\n * @memberOf _\n * @since 3.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.\n * @example\n *\n * _.isTypedArray(new Uint8Array);\n * // => true\n *\n * _.isTypedArray([]);\n * // => false\n */\nvar isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;\n\nmodule.exports = isTypedArray;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTY3Ni5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsdUJBQXVCLG1CQUFPLENBQUMsS0FBcUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9pc1R5cGVkQXJyYXkuanM/NDFkZCJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgYmFzZUlzVHlwZWRBcnJheSA9IHJlcXVpcmUoJy4vX2Jhc2VJc1R5cGVkQXJyYXknKSxcbiAgICBiYXNlVW5hcnkgPSByZXF1aXJlKCcuL19iYXNlVW5hcnknKSxcbiAgICBub2RlVXRpbCA9IHJlcXVpcmUoJy4vX25vZGVVdGlsJyk7XG5cbi8qIE5vZGUuanMgaGVscGVyIHJlZmVyZW5jZXMuICovXG52YXIgbm9kZUlzVHlwZWRBcnJheSA9IG5vZGVVdGlsICYmIG5vZGVVdGlsLmlzVHlwZWRBcnJheTtcblxuLyoqXG4gKiBDaGVja3MgaWYgYHZhbHVlYCBpcyBjbGFzc2lmaWVkIGFzIGEgdHlwZWQgYXJyYXkuXG4gKlxuICogQHN0YXRpY1xuICogQG1lbWJlck9mIF9cbiAqIEBzaW5jZSAzLjAuMFxuICogQGNhdGVnb3J5IExhbmdcbiAqIEBwYXJhbSB7Kn0gdmFsdWUgVGhlIHZhbHVlIHRvIGNoZWNrLlxuICogQHJldHVybnMge2Jvb2xlYW59IFJldHVybnMgYHRydWVgIGlmIGB2YWx1ZWAgaXMgYSB0eXBlZCBhcnJheSwgZWxzZSBgZmFsc2VgLlxuICogQGV4YW1wbGVcbiAqXG4gKiBfLmlzVHlwZWRBcnJheShuZXcgVWludDhBcnJheSk7XG4gKiAvLyA9PiB0cnVlXG4gKlxuICogXy5pc1R5cGVkQXJyYXkoW10pO1xuICogLy8gPT4gZmFsc2VcbiAqL1xudmFyIGlzVHlwZWRBcnJheSA9IG5vZGVJc1R5cGVkQXJyYXkgPyBiYXNlVW5hcnkobm9kZUlzVHlwZWRBcnJheSkgOiBiYXNlSXNUeXBlZEFycmF5O1xuXG5tb2R1bGUuZXhwb3J0cyA9IGlzVHlwZWRBcnJheTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///1676\n\n}")},1752:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\nvar root_1 = __webpack_require__(26854);\nfunction minimalSetImpl() {\n    // THIS IS NOT a full impl of Set, this is just the minimum\n    // bits of functionality we need for this library.\n    return (function () {\n        function MinimalSet() {\n            this._values = [];\n        }\n        MinimalSet.prototype.add = function (value) {\n            if (!this.has(value)) {\n                this._values.push(value);\n            }\n        };\n        MinimalSet.prototype.has = function (value) {\n            return this._values.indexOf(value) !== -1;\n        };\n        Object.defineProperty(MinimalSet.prototype, "size", {\n            get: function () {\n                return this._values.length;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        MinimalSet.prototype.clear = function () {\n            this._values.length = 0;\n        };\n        return MinimalSet;\n    }());\n}\nexports.minimalSetImpl = minimalSetImpl;\nexports.Set = root_1.root.Set || minimalSetImpl();\n//# sourceMappingURL=Set.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTc1Mi5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLGFBQWEsbUJBQU8sQ0FBQyxLQUFRO0FBQzdCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0Esc0JBQXNCO0FBQ3RCLFdBQVc7QUFDWCIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcnhqcy91dGlsL1NldC5qcz8zY2Q2Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xudmFyIHJvb3RfMSA9IHJlcXVpcmUoJy4vcm9vdCcpO1xuZnVuY3Rpb24gbWluaW1hbFNldEltcGwoKSB7XG4gICAgLy8gVEhJUyBJUyBOT1QgYSBmdWxsIGltcGwgb2YgU2V0LCB0aGlzIGlzIGp1c3QgdGhlIG1pbmltdW1cbiAgICAvLyBiaXRzIG9mIGZ1bmN0aW9uYWxpdHkgd2UgbmVlZCBmb3IgdGhpcyBsaWJyYXJ5LlxuICAgIHJldHVybiAoZnVuY3Rpb24gKCkge1xuICAgICAgICBmdW5jdGlvbiBNaW5pbWFsU2V0KCkge1xuICAgICAgICAgICAgdGhpcy5fdmFsdWVzID0gW107XG4gICAgICAgIH1cbiAgICAgICAgTWluaW1hbFNldC5wcm90b3R5cGUuYWRkID0gZnVuY3Rpb24gKHZhbHVlKSB7XG4gICAgICAgICAgICBpZiAoIXRoaXMuaGFzKHZhbHVlKSkge1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZhbHVlcy5wdXNoKHZhbHVlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfTtcbiAgICAgICAgTWluaW1hbFNldC5wcm90b3R5cGUuaGFzID0gZnVuY3Rpb24gKHZhbHVlKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5fdmFsdWVzLmluZGV4T2YodmFsdWUpICE9PSAtMTtcbiAgICAgICAgfTtcbiAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KE1pbmltYWxTZXQucHJvdG90eXBlLCBcInNpemVcIiwge1xuICAgICAgICAgICAgZ2V0OiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuX3ZhbHVlcy5sZW5ndGg7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgICAgICAgICAgIGNvbmZpZ3VyYWJsZTogdHJ1ZVxuICAgICAgICB9KTtcbiAgICAgICAgTWluaW1hbFNldC5wcm90b3R5cGUuY2xlYXIgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICB0aGlzLl92YWx1ZXMubGVuZ3RoID0gMDtcbiAgICAgICAgfTtcbiAgICAgICAgcmV0dXJuIE1pbmltYWxTZXQ7XG4gICAgfSgpKTtcbn1cbmV4cG9ydHMubWluaW1hbFNldEltcGwgPSBtaW5pbWFsU2V0SW1wbDtcbmV4cG9ydHMuU2V0ID0gcm9vdF8xLnJvb3QuU2V0IHx8IG1pbmltYWxTZXRJbXBsKCk7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1TZXQuanMubWFwIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///1752\n\n}')},1769:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\nvar merge_1 = __webpack_require__(90257);\nvar merge_2 = __webpack_require__(90257);\nexports.mergeStatic = merge_2.merge;\n/* tslint:enable:max-line-length */\n/**\n * Creates an output Observable which concurrently emits all values from every\n * given input Observable.\n *\n * <span class="informal">Flattens multiple Observables together by blending\n * their values into one Observable.</span>\n *\n * <img src="./img/merge.png" width="100%">\n *\n * `merge` subscribes to each given input Observable (either the source or an\n * Observable given as argument), and simply forwards (without doing any\n * transformation) all the values from all the input Observables to the output\n * Observable. The output Observable only completes once all input Observables\n * have completed. Any error delivered by an input Observable will be immediately\n * emitted on the output Observable.\n *\n * @example <caption>Merge together two Observables: 1s interval and clicks</caption>\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var timer = Rx.Observable.interval(1000);\n * var clicksOrTimer = clicks.merge(timer);\n * clicksOrTimer.subscribe(x => console.log(x));\n *\n * @example <caption>Merge together 3 Observables, but only 2 run concurrently</caption>\n * var timer1 = Rx.Observable.interval(1000).take(10);\n * var timer2 = Rx.Observable.interval(2000).take(6);\n * var timer3 = Rx.Observable.interval(500).take(10);\n * var concurrent = 2; // the argument\n * var merged = timer1.merge(timer2, timer3, concurrent);\n * merged.subscribe(x => console.log(x));\n *\n * @see {@link mergeAll}\n * @see {@link mergeMap}\n * @see {@link mergeMapTo}\n * @see {@link mergeScan}\n *\n * @param {ObservableInput} other An input Observable to merge with the source\n * Observable. More than one input Observables may be given as argument.\n * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of input\n * Observables being subscribed to concurrently.\n * @param {Scheduler} [scheduler=null] The IScheduler to use for managing\n * concurrency of input Observables.\n * @return {Observable} An Observable that emits items that are the result of\n * every input Observable.\n * @method merge\n * @owner Observable\n */\nfunction merge() {\n    var observables = [];\n    for (var _i = 0; _i < arguments.length; _i++) {\n        observables[_i - 0] = arguments[_i];\n    }\n    return function (source) { return source.lift.call(merge_1.merge.apply(void 0, [source].concat(observables))); };\n}\nexports.merge = merge;\n//# sourceMappingURL=merge.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTc2OS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLGNBQWMsbUJBQU8sQ0FBQyxLQUFxQjtBQUMzQyxjQUFjLG1CQUFPLENBQUMsS0FBcUI7QUFDM0MsbUJBQW1CO0FBQ25CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1QsU0FBUztBQUNULFNBQVM7QUFDVCxTQUFTO0FBQ1Q7QUFDQSxXQUFXLGlCQUFpQjtBQUM1QjtBQUNBLFdBQVcsUUFBUTtBQUNuQjtBQUNBLFdBQVcsV0FBVztBQUN0QjtBQUNBLFlBQVksWUFBWTtBQUN4QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUIsdUJBQXVCO0FBQzVDO0FBQ0E7QUFDQSwrQkFBK0I7QUFDL0I7QUFDQSxhQUFhO0FBQ2IiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvb3BlcmF0b3JzL21lcmdlLmpzP2Y2OTciXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgbWVyZ2VfMSA9IHJlcXVpcmUoJy4uL29ic2VydmFibGUvbWVyZ2UnKTtcbnZhciBtZXJnZV8yID0gcmVxdWlyZSgnLi4vb2JzZXJ2YWJsZS9tZXJnZScpO1xuZXhwb3J0cy5tZXJnZVN0YXRpYyA9IG1lcmdlXzIubWVyZ2U7XG4vKiB0c2xpbnQ6ZW5hYmxlOm1heC1saW5lLWxlbmd0aCAqL1xuLyoqXG4gKiBDcmVhdGVzIGFuIG91dHB1dCBPYnNlcnZhYmxlIHdoaWNoIGNvbmN1cnJlbnRseSBlbWl0cyBhbGwgdmFsdWVzIGZyb20gZXZlcnlcbiAqIGdpdmVuIGlucHV0IE9ic2VydmFibGUuXG4gKlxuICogPHNwYW4gY2xhc3M9XCJpbmZvcm1hbFwiPkZsYXR0ZW5zIG11bHRpcGxlIE9ic2VydmFibGVzIHRvZ2V0aGVyIGJ5IGJsZW5kaW5nXG4gKiB0aGVpciB2YWx1ZXMgaW50byBvbmUgT2JzZXJ2YWJsZS48L3NwYW4+XG4gKlxuICogPGltZyBzcmM9XCIuL2ltZy9tZXJnZS5wbmdcIiB3aWR0aD1cIjEwMCVcIj5cbiAqXG4gKiBgbWVyZ2VgIHN1YnNjcmliZXMgdG8gZWFjaCBnaXZlbiBpbnB1dCBPYnNlcnZhYmxlIChlaXRoZXIgdGhlIHNvdXJjZSBvciBhblxuICogT2JzZXJ2YWJsZSBnaXZlbiBhcyBhcmd1bWVudCksIGFuZCBzaW1wbHkgZm9yd2FyZHMgKHdpdGhvdXQgZG9pbmcgYW55XG4gKiB0cmFuc2Zvcm1hdGlvbikgYWxsIHRoZSB2YWx1ZXMgZnJvbSBhbGwgdGhlIGlucHV0IE9ic2VydmFibGVzIHRvIHRoZSBvdXRwdXRcbiAqIE9ic2VydmFibGUuIFRoZSBvdXRwdXQgT2JzZXJ2YWJsZSBvbmx5IGNvbXBsZXRlcyBvbmNlIGFsbCBpbnB1dCBPYnNlcnZhYmxlc1xuICogaGF2ZSBjb21wbGV0ZWQuIEFueSBlcnJvciBkZWxpdmVyZWQgYnkgYW4gaW5wdXQgT2JzZXJ2YWJsZSB3aWxsIGJlIGltbWVkaWF0ZWx5XG4gKiBlbWl0dGVkIG9uIHRoZSBvdXRwdXQgT2JzZXJ2YWJsZS5cbiAqXG4gKiBAZXhhbXBsZSA8Y2FwdGlvbj5NZXJnZSB0b2dldGhlciB0d28gT2JzZXJ2YWJsZXM6IDFzIGludGVydmFsIGFuZCBjbGlja3M8L2NhcHRpb24+XG4gKiB2YXIgY2xpY2tzID0gUnguT2JzZXJ2YWJsZS5mcm9tRXZlbnQoZG9jdW1lbnQsICdjbGljaycpO1xuICogdmFyIHRpbWVyID0gUnguT2JzZXJ2YWJsZS5pbnRlcnZhbCgxMDAwKTtcbiAqIHZhciBjbGlja3NPclRpbWVyID0gY2xpY2tzLm1lcmdlKHRpbWVyKTtcbiAqIGNsaWNrc09yVGltZXIuc3Vic2NyaWJlKHggPT4gY29uc29sZS5sb2coeCkpO1xuICpcbiAqIEBleGFtcGxlIDxjYXB0aW9uPk1lcmdlIHRvZ2V0aGVyIDMgT2JzZXJ2YWJsZXMsIGJ1dCBvbmx5IDIgcnVuIGNvbmN1cnJlbnRseTwvY2FwdGlvbj5cbiAqIHZhciB0aW1lcjEgPSBSeC5PYnNlcnZhYmxlLmludGVydmFsKDEwMDApLnRha2UoMTApO1xuICogdmFyIHRpbWVyMiA9IFJ4Lk9ic2VydmFibGUuaW50ZXJ2YWwoMjAwMCkudGFrZSg2KTtcbiAqIHZhciB0aW1lcjMgPSBSeC5PYnNlcnZhYmxlLmludGVydmFsKDUwMCkudGFrZSgxMCk7XG4gKiB2YXIgY29uY3VycmVudCA9IDI7IC8vIHRoZSBhcmd1bWVudFxuICogdmFyIG1lcmdlZCA9IHRpbWVyMS5tZXJnZSh0aW1lcjIsIHRpbWVyMywgY29uY3VycmVudCk7XG4gKiBtZXJnZWQuc3Vic2NyaWJlKHggPT4gY29uc29sZS5sb2coeCkpO1xuICpcbiAqIEBzZWUge0BsaW5rIG1lcmdlQWxsfVxuICogQHNlZSB7QGxpbmsgbWVyZ2VNYXB9XG4gKiBAc2VlIHtAbGluayBtZXJnZU1hcFRvfVxuICogQHNlZSB7QGxpbmsgbWVyZ2VTY2FufVxuICpcbiAqIEBwYXJhbSB7T2JzZXJ2YWJsZUlucHV0fSBvdGhlciBBbiBpbnB1dCBPYnNlcnZhYmxlIHRvIG1lcmdlIHdpdGggdGhlIHNvdXJjZVxuICogT2JzZXJ2YWJsZS4gTW9yZSB0aGFuIG9uZSBpbnB1dCBPYnNlcnZhYmxlcyBtYXkgYmUgZ2l2ZW4gYXMgYXJndW1lbnQuXG4gKiBAcGFyYW0ge251bWJlcn0gW2NvbmN1cnJlbnQ9TnVtYmVyLlBPU0lUSVZFX0lORklOSVRZXSBNYXhpbXVtIG51bWJlciBvZiBpbnB1dFxuICogT2JzZXJ2YWJsZXMgYmVpbmcgc3Vic2NyaWJlZCB0byBjb25jdXJyZW50bHkuXG4gKiBAcGFyYW0ge1NjaGVkdWxlcn0gW3NjaGVkdWxlcj1udWxsXSBUaGUgSVNjaGVkdWxlciB0byB1c2UgZm9yIG1hbmFnaW5nXG4gKiBjb25jdXJyZW5jeSBvZiBpbnB1dCBPYnNlcnZhYmxlcy5cbiAqIEByZXR1cm4ge09ic2VydmFibGV9IEFuIE9ic2VydmFibGUgdGhhdCBlbWl0cyBpdGVtcyB0aGF0IGFyZSB0aGUgcmVzdWx0IG9mXG4gKiBldmVyeSBpbnB1dCBPYnNlcnZhYmxlLlxuICogQG1ldGhvZCBtZXJnZVxuICogQG93bmVyIE9ic2VydmFibGVcbiAqL1xuZnVuY3Rpb24gbWVyZ2UoKSB7XG4gICAgdmFyIG9ic2VydmFibGVzID0gW107XG4gICAgZm9yICh2YXIgX2kgPSAwOyBfaSA8IGFyZ3VtZW50cy5sZW5ndGg7IF9pKyspIHtcbiAgICAgICAgb2JzZXJ2YWJsZXNbX2kgLSAwXSA9IGFyZ3VtZW50c1tfaV07XG4gICAgfVxuICAgIHJldHVybiBmdW5jdGlvbiAoc291cmNlKSB7IHJldHVybiBzb3VyY2UubGlmdC5jYWxsKG1lcmdlXzEubWVyZ2UuYXBwbHkodm9pZCAwLCBbc291cmNlXS5jb25jYXQob2JzZXJ2YWJsZXMpKSk7IH07XG59XG5leHBvcnRzLm1lcmdlID0gbWVyZ2U7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1tZXJnZS5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///1769\n\n}')},1800:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar baseGetAllKeys = __webpack_require__(18494),\n    getSymbolsIn = __webpack_require__(62366),\n    keysIn = __webpack_require__(22498);\n\n/**\n * Creates an array of own and inherited enumerable property names and\n * symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction getAllKeysIn(object) {\n  return baseGetAllKeys(object, keysIn, getSymbolsIn);\n}\n\nmodule.exports = getAllKeysIn;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTgwMC5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEscUJBQXFCLG1CQUFPLENBQUMsS0FBbUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9fZ2V0QWxsS2V5c0luLmpzP2NjNWUiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIGJhc2VHZXRBbGxLZXlzID0gcmVxdWlyZSgnLi9fYmFzZUdldEFsbEtleXMnKSxcbiAgICBnZXRTeW1ib2xzSW4gPSByZXF1aXJlKCcuL19nZXRTeW1ib2xzSW4nKSxcbiAgICBrZXlzSW4gPSByZXF1aXJlKCcuL2tleXNJbicpO1xuXG4vKipcbiAqIENyZWF0ZXMgYW4gYXJyYXkgb2Ygb3duIGFuZCBpbmhlcml0ZWQgZW51bWVyYWJsZSBwcm9wZXJ0eSBuYW1lcyBhbmRcbiAqIHN5bWJvbHMgb2YgYG9iamVjdGAuXG4gKlxuICogQHByaXZhdGVcbiAqIEBwYXJhbSB7T2JqZWN0fSBvYmplY3QgVGhlIG9iamVjdCB0byBxdWVyeS5cbiAqIEByZXR1cm5zIHtBcnJheX0gUmV0dXJucyB0aGUgYXJyYXkgb2YgcHJvcGVydHkgbmFtZXMgYW5kIHN5bWJvbHMuXG4gKi9cbmZ1bmN0aW9uIGdldEFsbEtleXNJbihvYmplY3QpIHtcbiAgcmV0dXJuIGJhc2VHZXRBbGxLZXlzKG9iamVjdCwga2V5c0luLCBnZXRTeW1ib2xzSW4pO1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGdldEFsbEtleXNJbjtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///1800\n\n}")},1823:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar OuterSubscriber_1 = __webpack_require__(234);\nvar subscribeToResult_1 = __webpack_require__(740);\n/**\n * Converts a higher-order Observable into a first-order Observable by dropping\n * inner Observables while the previous inner Observable has not yet completed.\n *\n * <span class="informal">Flattens an Observable-of-Observables by dropping the\n * next inner Observables while the current inner is still executing.</span>\n *\n * <img src="./img/exhaust.png" width="100%">\n *\n * `exhaust` subscribes to an Observable that emits Observables, also known as a\n * higher-order Observable. Each time it observes one of these emitted inner\n * Observables, the output Observable begins emitting the items emitted by that\n * inner Observable. So far, it behaves like {@link mergeAll}. However,\n * `exhaust` ignores every new inner Observable if the previous Observable has\n * not yet completed. Once that one completes, it will accept and flatten the\n * next inner Observable and repeat this process.\n *\n * @example <caption>Run a finite timer for each click, only if there is no currently active timer</caption>\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000).take(5));\n * var result = higherOrder.exhaust();\n * result.subscribe(x => console.log(x));\n *\n * @see {@link combineAll}\n * @see {@link concatAll}\n * @see {@link switch}\n * @see {@link mergeAll}\n * @see {@link exhaustMap}\n * @see {@link zipAll}\n *\n * @return {Observable} An Observable that takes a source of Observables and propagates the first observable\n * exclusively until it completes before subscribing to the next.\n * @method exhaust\n * @owner Observable\n */\nfunction exhaust() {\n    return function (source) { return source.lift(new SwitchFirstOperator()); };\n}\nexports.exhaust = exhaust;\nvar SwitchFirstOperator = (function () {\n    function SwitchFirstOperator() {\n    }\n    SwitchFirstOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new SwitchFirstSubscriber(subscriber));\n    };\n    return SwitchFirstOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar SwitchFirstSubscriber = (function (_super) {\n    __extends(SwitchFirstSubscriber, _super);\n    function SwitchFirstSubscriber(destination) {\n        _super.call(this, destination);\n        this.hasCompleted = false;\n        this.hasSubscription = false;\n    }\n    SwitchFirstSubscriber.prototype._next = function (value) {\n        if (!this.hasSubscription) {\n            this.hasSubscription = true;\n            this.add(subscribeToResult_1.subscribeToResult(this, value));\n        }\n    };\n    SwitchFirstSubscriber.prototype._complete = function () {\n        this.hasCompleted = true;\n        if (!this.hasSubscription) {\n            this.destination.complete();\n        }\n    };\n    SwitchFirstSubscriber.prototype.notifyComplete = function (innerSub) {\n        this.remove(innerSub);\n        this.hasSubscription = false;\n        if (this.hasCompleted) {\n            this.destination.complete();\n        }\n    };\n    return SwitchFirstSubscriber;\n}(OuterSubscriber_1.OuterSubscriber));\n//# sourceMappingURL=exhaust.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///1823\n\n}')},1853:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar root = __webpack_require__(23488);\n\n/**\n * Gets the timestamp of the number of milliseconds that have elapsed since\n * the Unix epoch (1 January 1970 00:00:00 UTC).\n *\n * @static\n * @memberOf _\n * @since 2.4.0\n * @category Date\n * @returns {number} Returns the timestamp.\n * @example\n *\n * _.defer(function(stamp) {\n *   console.log(_.now() - stamp);\n * }, _.now());\n * // => Logs the number of milliseconds it took for the deferred invocation.\n */\nvar now = function() {\n  return root.Date.now();\n};\n\nmodule.exports = now;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTg1My5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsV0FBVyxtQkFBTyxDQUFDLEtBQVMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9ub3cuanM/MTBkMSJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgcm9vdCA9IHJlcXVpcmUoJy4vX3Jvb3QnKTtcblxuLyoqXG4gKiBHZXRzIHRoZSB0aW1lc3RhbXAgb2YgdGhlIG51bWJlciBvZiBtaWxsaXNlY29uZHMgdGhhdCBoYXZlIGVsYXBzZWQgc2luY2VcbiAqIHRoZSBVbml4IGVwb2NoICgxIEphbnVhcnkgMTk3MCAwMDowMDowMCBVVEMpLlxuICpcbiAqIEBzdGF0aWNcbiAqIEBtZW1iZXJPZiBfXG4gKiBAc2luY2UgMi40LjBcbiAqIEBjYXRlZ29yeSBEYXRlXG4gKiBAcmV0dXJucyB7bnVtYmVyfSBSZXR1cm5zIHRoZSB0aW1lc3RhbXAuXG4gKiBAZXhhbXBsZVxuICpcbiAqIF8uZGVmZXIoZnVuY3Rpb24oc3RhbXApIHtcbiAqICAgY29uc29sZS5sb2coXy5ub3coKSAtIHN0YW1wKTtcbiAqIH0sIF8ubm93KCkpO1xuICogLy8gPT4gTG9ncyB0aGUgbnVtYmVyIG9mIG1pbGxpc2Vjb25kcyBpdCB0b29rIGZvciB0aGUgZGVmZXJyZWQgaW52b2NhdGlvbi5cbiAqL1xudmFyIG5vdyA9IGZ1bmN0aW9uKCkge1xuICByZXR1cm4gcm9vdC5EYXRlLm5vdygpO1xufTtcblxubW9kdWxlLmV4cG9ydHMgPSBub3c7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///1853\n\n}")},2020:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar filter_1 = __webpack_require__(64472);\nObservable_1.Observable.prototype.filter = filter_1.filter;\n//# sourceMappingURL=filter.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjAyMC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLGVBQWUsbUJBQU8sQ0FBQyxLQUF1QjtBQUM5QztBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQHNwbHVuay90cmFja21lLy4uLy4uL25vZGVfbW9kdWxlcy9yeGpzL2FkZC9vcGVyYXRvci9maWx0ZXIuanM/MWU4NSJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbnZhciBPYnNlcnZhYmxlXzEgPSByZXF1aXJlKCcuLi8uLi9PYnNlcnZhYmxlJyk7XG52YXIgZmlsdGVyXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9maWx0ZXInKTtcbk9ic2VydmFibGVfMS5PYnNlcnZhYmxlLnByb3RvdHlwZS5maWx0ZXIgPSBmaWx0ZXJfMS5maWx0ZXI7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1maWx0ZXIuanMubWFwIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///2020\n\n}")},2404:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar Symbol = __webpack_require__(85484),\n    isArguments = __webpack_require__(22865),\n    isArray = __webpack_require__(85100);\n\n/** Built-in value references. */\nvar spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;\n\n/**\n * Checks if `value` is a flattenable `arguments` object or array.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.\n */\nfunction isFlattenable(value) {\n  return isArray(value) || isArguments(value) ||\n    !!(spreadableSymbol && value && value[spreadableSymbol]);\n}\n\nmodule.exports = isFlattenable;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjQwNC5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsYUFBYSxtQkFBTyxDQUFDLEtBQVciLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9faXNGbGF0dGVuYWJsZS5qcz9hMDI0Il0sInNvdXJjZXNDb250ZW50IjpbInZhciBTeW1ib2wgPSByZXF1aXJlKCcuL19TeW1ib2wnKSxcbiAgICBpc0FyZ3VtZW50cyA9IHJlcXVpcmUoJy4vaXNBcmd1bWVudHMnKSxcbiAgICBpc0FycmF5ID0gcmVxdWlyZSgnLi9pc0FycmF5Jyk7XG5cbi8qKiBCdWlsdC1pbiB2YWx1ZSByZWZlcmVuY2VzLiAqL1xudmFyIHNwcmVhZGFibGVTeW1ib2wgPSBTeW1ib2wgPyBTeW1ib2wuaXNDb25jYXRTcHJlYWRhYmxlIDogdW5kZWZpbmVkO1xuXG4vKipcbiAqIENoZWNrcyBpZiBgdmFsdWVgIGlzIGEgZmxhdHRlbmFibGUgYGFyZ3VtZW50c2Agb2JqZWN0IG9yIGFycmF5LlxuICpcbiAqIEBwcml2YXRlXG4gKiBAcGFyYW0geyp9IHZhbHVlIFRoZSB2YWx1ZSB0byBjaGVjay5cbiAqIEByZXR1cm5zIHtib29sZWFufSBSZXR1cm5zIGB0cnVlYCBpZiBgdmFsdWVgIGlzIGZsYXR0ZW5hYmxlLCBlbHNlIGBmYWxzZWAuXG4gKi9cbmZ1bmN0aW9uIGlzRmxhdHRlbmFibGUodmFsdWUpIHtcbiAgcmV0dXJuIGlzQXJyYXkodmFsdWUpIHx8IGlzQXJndW1lbnRzKHZhbHVlKSB8fFxuICAgICEhKHNwcmVhZGFibGVTeW1ib2wgJiYgdmFsdWUgJiYgdmFsdWVbc3ByZWFkYWJsZVN5bWJvbF0pO1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGlzRmxhdHRlbmFibGU7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///2404\n\n}")},2426:(module,__unused_webpack_exports,__webpack_require__)=>{eval('{/******/ (() => {\n    // webpackBootstrap\n    /******/ "use strict";\n    /******/ // The require scope\n    /******/    var e = {};\n    /******/\n    /************************************************************************/\n    /******/ /* webpack/runtime/compat get default export */\n    /******/    (() => {\n        /******/ // getDefaultExport function for compatibility with non-harmony modules\n        /******/ e.n = n => {\n            /******/ var t = n && n.__esModule ? \n            /******/ () => n["default"]\n            /******/ : () => n\n            /******/;\n            e.d(t, {\n                a: t\n            });\n            /******/            return t;\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/define property getters */\n    /******/    (() => {\n        /******/ // define getter functions for harmony exports\n        /******/ e.d = (n, t) => {\n            /******/ for (var r in t) {\n                /******/ if (e.o(t, r) && !e.o(n, r)) {\n                    /******/ Object.defineProperty(n, r, {\n                        enumerable: true,\n                        get: t[r]\n                    });\n                    /******/                }\n                /******/            }\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/hasOwnProperty shorthand */\n    /******/    (() => {\n        /******/ e.o = (e, n) => Object.prototype.hasOwnProperty.call(e, n)\n        /******/;\n    })();\n    /******/\n    /******/ /* webpack/runtime/make namespace object */\n    /******/    (() => {\n        /******/ // define __esModule on exports\n        /******/ e.r = e => {\n            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {\n                /******/ Object.defineProperty(e, Symbol.toStringTag, {\n                    value: "Module"\n                });\n                /******/            }\n            /******/            Object.defineProperty(e, "__esModule", {\n                value: true\n            });\n            /******/        };\n        /******/    })();\n    /******/\n    /************************************************************************/    var n = {};\n    // ESM COMPAT FLAG\n        e.r(n);\n    // EXPORTS\n        e.d(n, {\n        Body: () => /* reexport */ J,\n        Caption: () => /* reexport */ de,\n        Cell: () => /* reexport */ xe,\n        Head: () => /* reexport */ er,\n        HeadCell: () => /* reexport */ zn,\n        HeadDropdownCell: () => /* reexport */ xr,\n        Row: () => /* reexport */ Lt,\n        default: () => /* reexport */ Qo\n    });\n    // CONCATENATED MODULE: external "react"\n    const t = __webpack_require__(14041);\n    var r =  e.n(t);\n    // CONCATENATED MODULE: external "@dnd-kit/core"\n    const o = __webpack_require__(81380);\n    // CONCATENATED MODULE: external "@dnd-kit/modifiers"\n    const i = __webpack_require__(5414);\n    // CONCATENATED MODULE: external "@dnd-kit/sortable"\n    const a = __webpack_require__(37626);\n    // CONCATENATED MODULE: external "lodash/forEach"\n    const l = __webpack_require__(22539);\n    var u =  e.n(l);\n    // CONCATENATED MODULE: external "lodash/has"\n    const s = __webpack_require__(28541);\n    // CONCATENATED MODULE: external "lodash/indexOf"\n    const c = __webpack_require__(37980);\n    var d =  e.n(c);\n    // CONCATENATED MODULE: external "lodash/isEqual"\n    const f = __webpack_require__(33429);\n    var v =  e.n(f);\n    // CONCATENATED MODULE: external "lodash/isNumber"\n    const p = __webpack_require__(92288);\n    // CONCATENATED MODULE: external "lodash/omit"\n    const m = __webpack_require__(36728);\n    var b =  e.n(m);\n    // CONCATENATED MODULE: external "lodash/throttle"\n    const h = __webpack_require__(56505);\n    var y =  e.n(h);\n    // CONCATENATED MODULE: external "prop-types"\n    const g = __webpack_require__(39067);\n    var w =  e.n(g);\n    // CONCATENATED MODULE: external "@splunk/react-ui/EventListener"\n    const C = __webpack_require__(38282);\n    var x =  e.n(C);\n    // CONCATENATED MODULE: external "@splunk/react-ui/ScrollContainerContext"\n    const S = __webpack_require__(46387);\n    // CONCATENATED MODULE: external "@splunk/react-ui/usePrevious"\n    const O = __webpack_require__(50824);\n    var k =  e.n(O);\n    // CONCATENATED MODULE: external "@splunk/react-ui/useResizeObserver"\n    const R = __webpack_require__(68795);\n    var E =  e.n(R);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/format"\n    const I = __webpack_require__(2841);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/i18n"\n    const T = __webpack_require__(41454);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/id"\n    const j = __webpack_require__(66115);\n    // CONCATENATED MODULE: external "lodash/includes"\n    const D = __webpack_require__(60856);\n    var q =  e.n(D);\n    // CONCATENATED MODULE: external "lodash/without"\n    const A = __webpack_require__(60909);\n    var P =  e.n(A);\n    // CONCATENATED MODULE: external "styled-components"\n    const _ = __webpack_require__(53057);\n    var z =  e.n(_);\n    // CONCATENATED MODULE: external "@splunk/themes"\n    const M = __webpack_require__(18672);\n    // CONCATENATED MODULE: ./src/Table/BodyStyles.ts\n    var $ = z().tbody.withConfig({\n        displayName: "BodyStyles__Styled",\n        componentId: "sc-1k5p6pq-0"\n    })([ "", " z-index:0;" ], M.mixins.reset("table-row-group"));\n    // CONCATENATED MODULE: ./src/utils/updateReactRef.ts\n    /**\n * Updates a React ref. Callback refs and object refs (from `createRef` and `useRef`) are supported.\n *\n * @param ref - The React callback or object ref. Can be `null` or `undefined`.\n * @param current - The new value of the ref.\n */\n    function N(e, n) {\n        if (e) {\n            if (typeof e === "function") {\n                e(n);\n            } else {\n                // the public signature of this util uses React.Ref<T> to mirror the way React types refs.\n                // the intention here is to signal "we will take care of setting \'current\', not you".\n                e.current = n;\n // eslint-disable-line no-param-reassign\n                        }\n        }\n    }\n    // CONCATENATED MODULE: ./src/Table/Body.tsx\n    function L() {\n        return L = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, L.apply(null, arguments);\n    }\n    function W(e, n) {\n        return F(e) || V(e, n) || K(e, n) || H();\n    }\n    function H() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function K(e, n) {\n        if (e) {\n            if ("string" == typeof e) return B(e, n);\n            var t = {}.toString.call(e).slice(8, -1);\n            return "Object" === t && e.constructor && (t = e.constructor.name), "Map" === t || "Set" === t ? Array.from(e) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? B(e, n) : void 0;\n        }\n    }\n    function B(e, n) {\n        (null == n || n > e.length) && (n = e.length);\n        for (var t = 0, r = Array(n); t < n; t++) {\n            r[t] = e[t];\n        }\n        return r;\n    }\n    function V(e, n) {\n        var t = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != t) {\n            var r, o, i, a, l = [], u = !0, s = !1;\n            try {\n                if (i = (t = t.call(e)).next, 0 === n) {\n                    if (Object(t) !== t) return;\n                    u = !1;\n                } else for (;!(u = (r = i.call(t)).done) && (l.push(r.value), l.length !== n); u = !0) {\n                }\n            } catch (e) {\n                s = !0, o = e;\n            } finally {\n                try {\n                    if (!u && null != t["return"] && (a = t["return"](), Object(a) !== a)) return;\n                } finally {\n                    if (s) throw o;\n                }\n            }\n            return l;\n        }\n    }\n    function F(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function U(e, n) {\n        if (null == e) return {};\n        var t, r, o = X(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function X(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var Y = {\n        /** @private. Generally passed by Table rather than added directly. */\n        actions: w().bool,\n        children: w().node,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        /** @private. Generally passed by Table rather than added directly. */\n        movableColumns: w().bool,\n        /** @private. Generally passed by Table rather than added directly. */\n        rowExpansion: w().oneOf([ "single", "multi", "none", "controlled" ]),\n        /** @private. Generally passed by Table rather than added directly. */\n        onRequestMoveRow: w().func,\n        /** @private. Generally passed by Table rather than added directly. */\n        primaryColumnIndex: w().number,\n        /** @private. Generally passed by Table rather than added directly. */\n        stripeRows: w().bool\n    };\n    function G(e) {\n        var n = e.actions, o = e.children, i = e.elementRef, a = e.movableColumns, l = e.onRequestMoveRow, u = e.rowExpansion, s = u === void 0 ? "none" : u, c = e.primaryColumnIndex, d = e.stripeRows, f = U(e, [ "actions", "children", "elementRef", "movableColumns", "onRequestMoveRow", "rowExpansion", "primaryColumnIndex", "stripeRows" ]);\n // @docs-props-type BodyPropsBase\n                var v = [];\n        var p = (0, t.useState)([]), m = W(p, 2), b = m[0], h = m[1];\n        var y = (0, t.useRef)(null);\n        var g = (0, t.useCallback)((function(e) {\n            y.current = e;\n            N(i, e);\n        }), [ i, y ]);\n        var w = function e(n, t, r) {\n            var o = b;\n            if (s === "single") {\n                if (q()(o, t)) {\n                    h([]);\n                } else {\n                    h([ t ]);\n                }\n            } else if (s === "multi") {\n                if (q()(o, t)) {\n                    h(P()(o, t));\n                } else {\n                    h(o === null || o === void 0 ? void 0 : o.concat(t));\n                }\n            }\n            r === null || r === void 0 ? void 0 : r(n);\n        };\n        var C = t.Children.toArray(o).filter(t.isValidElement);\n        var x = (0, t.useState)(new Map), S = W(x, 2), O = S[0], k = S[1];\n        r().useEffect((function() {\n            k((function(e) {\n                var n = new Map(e);\n                var r = false;\n                C.forEach((function(o) {\n                    var i;\n                    if (!o.props.expansionRow) return;\n                    var a = (i = o.key) !== null && i !== void 0 ? i : C.indexOf(o);\n                    var l = t.Children.count(o.props.expansionRow);\n                    var u = e.get(a);\n                    if (!u || u.length !== l) {\n                        n.set(a, Array.from({\n                            length: l\n                        }, (function() {\n                            return (0, j.createDOMID)();\n                        })));\n                        r = true;\n                    }\n                }));\n                return r ? n : e;\n            }));\n        }), [ C ]);\n        C.forEach((function(e, r) {\n            if (e) {\n                var o, i;\n                if (false) // removed by dead control flow\n{}\n                var u = (o = e.key) !== null && o !== void 0 ? o : r;\n                var f = r % 2 ? "even" : "odd";\n                var p = d ? f : "none";\n                var m = s === "controlled" ? e.props.expanded : q()(b, u);\n                var h = function n(t) {\n                    w(t, u, e.props.onExpansion);\n                };\n                var y = e.props.expansionRow ? (i = O.get(u)) === null || i === void 0 ? void 0 : i.join(" ") : undefined;\n                v.push( (0, t.cloneElement)(e, {\n                    stripe: p,\n                    actions: n,\n                    expanded: m,\n                    expansionRowIds: y,\n                    expandable: s !== "none",\n                    isDraggable: !!l,\n                    movableColumns: a,\n                    primaryColumnIndex: c,\n                    onExpansion: h,\n                    key: e.key || r\n                }));\n                if (m && e.props.expansionRow) {\n                    t.Children.forEach(e.props.expansionRow, (function(e, n) {\n                        var r;\n                        var o = (r = O.get(u)) === null || r === void 0 ? void 0 : r[n];\n                        v.push( (0, t.cloneElement)(e, {\n                            key: o,\n                            id: o,\n                            stripe: p,\n                            movableColumns: a,\n                            "data-expansion-row": "true"\n                        }));\n                    }));\n                }\n            }\n        }));\n        if (v.length === 0) {\n            return null;\n        }\n        \n        return r().createElement($, L({\n            "data-test": "body"\n        }, f, {\n            ref: g\n        }), v);\n    }\n    G.propTypes = Y;\n    G.splunkUiType = "Table.Body";\n    /* harmony default export */    const J = G;\n    // CONCATENATED MODULE: ./src/Table/TableStyles.ts\n    var Q = z().div.withConfig({\n        displayName: "TableStyles__Styled",\n        componentId: "sc-1cmfss7-0"\n    })([ "", ";max-width:100%;position:relative;z-index:1;@media print{max-height:none !important;}" ], M.mixins.reset("block"));\n    var Z = z().div.withConfig({\n        displayName: "TableStyles__StyledTableContainer",\n        componentId: "sc-1cmfss7-1"\n    })([ "overflow:auto;", " &::before{content:\'\';width:100%;height:0;top:0;position:absolute;}" ], (function(e) {\n        var n = e.$dragging;\n        return n && (0, _.css)([ "overflow:hidden;" ]);\n    }));\n    var ee = z().table.withConfig({\n        displayName: "TableStyles__StyledTable",\n        componentId: "sc-1cmfss7-2"\n    })([ "", ";position:relative;border-collapse:collapse;border-spacing:0;min-width:100%;z-index:0;height:1px;&[data-fixed-column=\'true\']{table-layout:fixed;min-width:0;width:0;}", " @media print{width:100%;max-width:100%;table-layout:auto;}" ], M.mixins.reset("table"), (function(e) {\n        var n = e.$resizableFillLayout;\n        return n && (0, _.css)([ "width:100%;min-width:100%;table-layout:fixed;" ]);\n    }));\n    var ne = z().div.withConfig({\n        displayName: "TableStyles__StyledDockedScrollbar",\n        componentId: "sc-1cmfss7-3"\n    })([ "position:fixed;bottom:0;overflow:auto;z-index:calc(", " + 1);" ], M.variables.zindexFixedNavbar);\n    var te = z().div.withConfig({\n        displayName: "TableStyles__StyledDockedScrollbarContent",\n        componentId: "sc-1cmfss7-4"\n    })([ "height:1px;" ]);\n    var re = z().caption.withConfig({\n        displayName: "TableStyles__StyledTableCaption",\n        componentId: "sc-1cmfss7-5"\n    })([ "padding:", " 0;font-size:", ";caption-side:", ";" ], M.variables.spacingXSmall, M.variables.fontSizeLarge, (function(e) {\n        var n = e.side;\n        return n;\n    }));\n    var oe = z().table.withConfig({\n        displayName: "TableStyles__StyledDragShadowTable",\n        componentId: "sc-1cmfss7-6"\n    })([ "display:block;background:", ";border-collapse:collapse;height:", ";width:", ";" ], M.variables.interactiveColorOverlayDrag, (function(e) {\n        var n = e.$height;\n        return "".concat(n, "px");\n    }), (function(e) {\n        var n = e.$width;\n        return "".concat(n, "px");\n    }));\n    var ie = z().div.withConfig({\n        displayName: "TableStyles__StyledGuideLine",\n        componentId: "sc-1cmfss7-7"\n    })([ "position:absolute;width:1px;left:", ";top:0;height:", ";pointer-events:none;background-color:", ";" ], (function(e) {\n        var n = e.$left;\n        return "".concat(n, "px");\n    }), (function(e) {\n        var n = e.$height;\n        return "".concat(n, "px");\n    }), M.variables.interactiveColorAccent);\n    // CONCATENATED MODULE: ./src/Table/Caption.tsx\n    function ae() {\n        return ae = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, ae.apply(null, arguments);\n    }\n    function le(e, n) {\n        if (null == e) return {};\n        var t, r, o = ue(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function ue(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var se = {\n        children: w().node.isRequired,\n        side: w().oneOf([ "top", "bottom" ])\n    };\n    /**\n * Tables that use a docked header must place the caption on the bottom side.\n * Tables that use a fixed header cannot use captions.\n */    function ce(e) {\n        var n = e.children, t = e.side, o = t === void 0 ? "top" : t, i = le(e, [ "children", "side" ]);\n        // @docs-props-type CaptionPropsBase\n                \n        return r().createElement(re, ae({\n            "data-test": "caption",\n            side: o\n        }, i), n);\n    }\n    ce.propTypes = se;\n    ce.splunkUiType = "Table.Caption";\n    /* harmony default export */    const de = ce;\n    // CONCATENATED MODULE: external "@splunk/react-ui/ButtonSimple"\n    const fe = __webpack_require__(8710);\n    // CONCATENATED MODULE: ./src/Table/CellStyles.ts\n    var ve = "2px";\n    var pe = (0, _.css)([ "box-shadow:", ";" ], M.variables.focusShadowInset);\n    var me = z().td.withConfig({\n        displayName: "CellStyles__Styled",\n        componentId: "sc-1955xk2-0"\n    })([ "", " line-height:", ";padding:", " ", ";border-left:0 solid transparent;border-right:0 solid transparent;color:", ";word-wrap:break-word;vertical-align:top;*:where(button):focus,&& *:is(:has(> input:focus)):not([disabled]){box-shadow:", ";}padding-block:", ";padding-inline:", ";", " ", " ", " [data-expansion-row=\'true\'] > &:first-child{padding-top:8px;}[data-expansion-row=\'true\'] > &:last-child{padding-bottom:14px;}" ], M.mixins.reset("table-cell"), M.variables.lineHeightSpacious, ve, M.variables.spacingSmall, M.variables.contentColorDefault, M.variables.focusShadowInset, (0, \n    M.pick)({\n        comfortable: "8px",\n        compact: "6px"\n    }), M.variables.spacingSmall, (0, M.pickVariant)("$variant", {\n        expand: (0, _.css)([ "height:100%;padding:0;" ]),\n        toggle: (0, _.css)([ "height:100%;padding:0;" ])\n    }), (function(e) {\n        var n = e.$variant, t = e.$isPrimaryCell;\n        return (0, M.pickVariant)("$appearance", {\n            data: (0, _.css)([ "", "" ], n === "actions" && (0, _.css)([ "cursor:default;padding-block:", ";padding-inline:", ";*:where(button){", " &:focus{box-shadow:", ";}}" ], ve, M.variables.spacingSmall, (0, \n            fe.buttonMixin)("subtle", {\n                color: M.variables.contentColorDefault\n            }), M.variables.focusShadowInset)),\n            rowLink: (0, _.css)([ "color:", ";*:hover > &&{cursor:pointer;", "}" ], M.variables.contentColorActive, t && (0, \n            _.css)([ "text-decoration:underline;" ])),\n            link: (0, _.css)([ "color:", ";&:hover{cursor:pointer;text-decoration:underline;}&:focus{text-decoration:underline;box-shadow:", ";}" ], M.variables.contentColorLink, M.variables.focusShadowInset)\n        });\n    }), (function(e) {\n        var n = e.$clickable, t = e.$focusWithin, r = e.$stripe;\n        return n && (0, _.css)([ "cursor:pointer;&:hover{background-color:", ";}&:focus{", " background-color:", ";}", "" ], r === "even" ? M.variables.neutral300 : M.variables.neutral100, pe, r === "even" ? M.variables.neutral300 : M.variables.neutral100, t && (0, \n        _.css)([ "&:focus-within{", " background-color:", ";}" ], pe, r === "even" ? M.variables.neutral300 : M.variables.neutral100));\n    }));\n    /*\n * A wrapper ensures that the Table Cell contents align to the top while staying within the height of inputHeight.\n * This allows text to align properly with expand and select icons when other cell contents are larger.\n */    var be = z().div.withConfig({\n        displayName: "CellStyles__StyledCellContent",\n        componentId: "sc-1955xk2-1"\n    })([ "display:flex;align-items:flex-start;word-break:break-word;", " ", "" ], (0, \n    M.pickVariant)("$variant", {\n        expand: (0, _.css)([ "height:100%;" ]),\n        toggle: (0, _.css)([ "height:100%;" ])\n    }), (function(e) {\n        var n = e.$variant, t = e.$align;\n        return n ? (0, _.css)([ "display:block;text-align:", ";" ], t) : (0, _.css)([ "justify-content:", ";text-align:", ";" ], t, t);\n    }));\n    // CONCATENATED MODULE: ./src/Table/Cell.tsx\n    function he() {\n        return he = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, he.apply(null, arguments);\n    }\n    function ye(e, n) {\n        if (null == e) return {};\n        var t, r, o = ge(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function ge(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    /** @public */    var we = {\n        align: w().oneOf([ "left", "center", "right" ]),\n        /** @private */\n        appearance: w().oneOf([ "data", "link", "rowLink" ]),\n        /** @private Used to set the $clickable appearance without an onClick */\n        appearClickable: w().bool,\n        children: w().node,\n        data: w().any,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        /** @private */\n        isPrimaryCell: w().bool,\n        onClick: w().func,\n        /** @private */\n        onKeyDown: w().func,\n        /** @private */\n        disabled: w().bool,\n        /** @private. */\n        expand: w().bool,\n        /** @private. */\n        stripe: w().oneOf([ "odd", "even", "none" ]),\n        /** @private. */\n        variant: w().oneOf([ "toggle", "expand", "drag", "actions" ])\n    };\n    function Ce(e) {\n        var n = e.align, o = n === void 0 ? "left" : n, i = e.appearance, a = e.appearClickable, l = e.children, u = e.data, s = e.disabled, c = e.elementRef, d = e.isPrimaryCell, f = e.onClick, v = e.onKeyDown, p = e.stripe, m = e.variant, b = ye(e, [ "align", "appearance", "appearClickable", "children", "data", "disabled", "elementRef", "isPrimaryCell", "onClick", "onKeyDown", "stripe", "variant" ]);\n        // @docs-props-type CellPropsBase\n                var h = f !== undefined;\n        var y = a || h;\n        var g = y ? "link" : "data";\n        var w = (0, t.useCallback)((function(e) {\n            N(c, e);\n        }), [ c ]);\n        var C = (0, t.useCallback)((function(e) {\n            if (m === "actions") {\n                // Action buttons have their own onClicks inside the cell so we don\'t want Row onClick to fire\n                e.stopPropagation();\n            }\n            f === null || f === void 0 ? void 0 : f(e, u);\n        }), [ u, f, m ]);\n        var x = (0, t.useCallback)((function(e) {\n            if (e.key === "Enter") {\n                f === null || f === void 0 ? void 0 : f(e, u);\n            }\n            v === null || v === void 0 ? void 0 : v(e);\n        }), [ u, f, v ]);\n        \n        return r().createElement(me, he({\n            "data-test": "cell",\n            $appearance: i || g,\n            $clickable: y ? true : undefined,\n            $disabled: !!s,\n            $focusWithin: a,\n            $isPrimaryCell: d,\n            $stripe: p,\n            $variant: m,\n            onClick: C,\n            onKeyDown: x,\n            ref: w,\n            tabIndex: h ? 0 : undefined\n        }, b),  r().createElement(be, {\n            $align: o,\n            $variant: m\n        }, l));\n    }\n    Ce.propTypes = we;\n    Ce.splunkUiType = "Table.Cell";\n    /* harmony default export */    const xe = Ce;\n    // CONCATENATED MODULE: external "lodash/isString"\n    const Se = __webpack_require__(52804);\n    var Oe =  e.n(Se);\n    // CONCATENATED MODULE: external "lodash/merge"\n    const ke = __webpack_require__(63085);\n    var Re =  e.n(ke);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ParallelDots"\n    const Ee = __webpack_require__(87895);\n    var Ie =  e.n(Ee);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Tooltip"\n    const Te = __webpack_require__(26361);\n    var je =  e.n(Te);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Divider"\n    const De = __webpack_require__(13339);\n    var qe =  e.n(De);\n    // CONCATENATED MODULE: ./src/Table/HeadInnerStyles.ts\n    var Ae = 4;\n    var Pe = Ae;\n // While this could theoretically be different, it helps for cohesivity in look and feel when some columns are truncated and others are not.\n        var _e = (0, _.css)([ "display:inline-flex;align-items:center;grid-row:1;height:1lh;" ]);\n    var ze = z().span.withConfig({\n        displayName: "HeadInnerStyles__StyledIcon",\n        componentId: "sc-1sa0wng-0"\n    })([ "", " grid-column:icon;" ], _e);\n    var Me = z().span.withConfig({\n        displayName: "HeadInnerStyles__StyledTooltipIcon",\n        componentId: "sc-1sa0wng-1"\n    })([ "", " grid-column:tooltip;" ], _e);\n    var $e = z().span.withConfig({\n        displayName: "HeadInnerStyles__StyledLabel",\n        componentId: "sc-1sa0wng-2"\n    })([ "grid-column:label;grid-row:1 / -1;position:relative;height:100%;", " ", " ", " ", "" ], (function(e) {\n        var n = e.$variant;\n        return n === "toggleAll" && (0, _.css)([ "grid-column:1 / -1;" ]);\n    }), (function(e) {\n        var n = e.$labelLength;\n        return n && n > Pe && (0, _.css)([ "word-wrap:break-word;word-break:break-word;" ]);\n    }), (function(e) {\n        var n = e.$truncate, t = e.$labelLength;\n        return n && t && t > Ae && (0, _.css)([ "", " min-width:4ch;" ], M.mixins.ellipsis());\n    }), (0, M.pickVariant)("$align", {\n        right: (0, _.css)([ "& > &{text-align:right;}" ]),\n        left: (0, _.css)([ "& > &{text-align:left;}" ]),\n        center: (0, _.css)([ "& > &{text-align:center;}" ])\n    }));\n    var Ne = (0, _.css)([ "box-shadow:", ";outline:none;color:", ";text-decoration:underline;" ], M.variables.focusShadowInset, M.variables.contentColorActive);\n    var Le = z().div.withConfig({\n        displayName: "HeadInnerStyles__Styled",\n        componentId: "sc-1sa0wng-3"\n    })([ "", ";", ";", ";position:relative;", " grid-template-rows:1lh 1fr;align-items:start;flex-grow:1;height:100%;padding-block:", ";padding-inline:", ";justify-content:", ";", " ", " @media print{background-image:none;}", "" ], M.mixins.reset("grid"), M.mixins.clearfix(), M.mixins.typography("body", {\n        weight: "bold"\n    }), (function(e) {\n        var n = e.$hasTooltip, t = e.$hasIcon;\n        return (0, _.css)([ "grid-template-columns:[label] auto ", " ", ";column-gap:", ";" ], n ? "[tooltip] min-content" : "", t ? "[icon] min-content" : "", n || t ? M.variables.spacingXSmall : 0);\n    }), (0, M.pick)({\n        comfortable: "8px",\n        compact: "6px"\n    }), M.variables.spacingSmall, (0, M.pickVariant)("$align", {\n        center: "center",\n        left: "flex-start",\n        right: "flex-end"\n    }), (function(e) {\n        var n = e.$variant;\n        return n && (0, _.css)([ "grid-template-columns:1fr;grid-template-rows:1fr;" ]);\n    }), (0, M.pickVariant)("$variant", {\n        toggleAll: (0, _.css)([ "padding:0;" ]),\n        actions: (0, _.css)([ "padding-block:2px;" ])\n    }), (function(e) {\n        var n = e.$clickable, t = e.$focusWithin;\n        return n && (0, _.css)([ "cursor:pointer;&:focus{", "}", " &:hover{outline:none;text-decoration:underline;color:", ";}" ], Ne, t && (0, \n        _.css)([ "&:focus-within{", "}" ], Ne), M.variables.contentColorActive);\n    }));\n    var We = z()(qe()).withConfig({\n        displayName: "HeadInnerStyles__StyledResize",\n        componentId: "sc-1sa0wng-4"\n    })([ "", ";position:absolute;right:-5px;width:9px;top:0;bottom:0;z-index:1;cursor:col-resize;th:last-child > div > ", " > &{right:1px;width:4px;}&:hover{outline:none;&::before{content:\'\';background:", ";position:absolute;left:4px;width:1px;top:0;bottom:0;}}&:focus{outline:none;&::before{content:\'\';position:absolute;background:", ";box-shadow:", ";left:4px;width:1px;top:0;bottom:0;}}" ], M.mixins.reset("block"), /* sc-sel */ Le, M.variables.borderColorStrong, M.variables.focusColor, M.variables.focusShadow);\n    // CONCATENATED MODULE: ./src/Table/HeadCellStyles.ts\n    var He = z().div.withConfig({\n        displayName: "HeadCellStyles__StyledInnerWrapper",\n        componentId: "sc-1hj81sa-0"\n    })([ "display:flex;height:100%;align-items:flex-start;" ]);\n    var Ke = z().th.withConfig({\n        displayName: "HeadCellStyles__Styled",\n        componentId: "sc-1hj81sa-1"\n    })([ "", " line-height:", ";background-color:", ";box-sizing:content-box;text-align:left;vertical-align:", ";position:relative;height:100%;&:not(:first-child,:has(", ")){", "{border-left:1px solid ", ";}}&:has(", "){", "{border-right:1px solid ", ";}}&:nth-last-child(2):has(", ") + &:last-child{", "{border-left:none;}}*:where(button):focus{box-shadow:", ";}", " ", " ", "" ], M.mixins.reset("table-cell"), M.variables.lineHeightSpacious, M.variables.neutral100, (function(e) {\n        var n = e.$variant;\n        return n ? "middle" : "top";\n    }), We, /* sc-sel */ He, M.variables.borderColorWeak, We, /* sc-sel */ He, M.variables.borderColor, We, /* sc-sel */ He, M.variables.focusShadowInset, (function(e) {\n        var n = e.$isDragging;\n        return n && (0, _.css)([ "background-color:", ";&:focus{box-shadow:none;}" ], M.variables.backgroundColorPage);\n    }), (function(e) {\n        var n = e.$variant;\n        return n && (0, _.css)([ "&:first-child + &{", "{border-left:1px solid ", ";}}" ], He, M.variables.borderColorWeak);\n    }), (0, M.pickVariant)("$variant", {\n        actions: (0, _.css)([ "*:where(button){", " &:focus{box-shadow:", ";}}" ], (0, fe.buttonMixin)("subtle", {\n            color: M.variables.contentColorDefault\n        }), M.variables.focusShadowInset)\n    }));\n    var Be = z().div.withConfig({\n        displayName: "HeadCellStyles__StyledIcon",\n        componentId: "sc-1hj81sa-2"\n    })([ "display:inline-flex;align-items:center;height:1lh;" ]);\n    // TODO(SUI-7400): Refactor the drag handler of re-order column\n        var Ve = z().div.withConfig({\n        displayName: "HeadCellStyles__StyledDragHandler",\n        componentId: "sc-1hj81sa-3"\n    })([ "display:inline-flex;align-items:start;align-self:stretch;justify-content:center;min-width:20px;cursor:move;padding-block:", ";-webkit-user-select:none;-moz-user-select:none;user-select:none;&:hover{background:", ";color:", ";}&:focus{background:", ";box-shadow:", ";color:", ";}" ], (0, \n    M.pick)({\n        comfortable: "8px",\n        compact: "6px"\n    }), M.variables.interactiveColorOverlayHover, M.variables.contentColorActive, M.variables.interactiveColorOverlayDrag, M.variables.focusShadowInset, M.variables.contentColorActive);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ArrowDown"\n    const Fe = __webpack_require__(93427);\n    var Ue =  e.n(Fe);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ArrowUp"\n    const Xe = __webpack_require__(79958);\n    var Ye =  e.n(Xe);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ArrowUpDown"\n    const Ge = __webpack_require__(37670);\n    var Je =  e.n(Ge);\n    // CONCATENATED MODULE: external "@splunk/react-icons/CaretSmallDown"\n    const Qe = __webpack_require__(90274);\n    var Ze =  e.n(Qe);\n    // CONCATENATED MODULE: external "@splunk/react-icons/InformationCircle"\n    const en = __webpack_require__(77996);\n    var nn =  e.n(en);\n    // CONCATENATED MODULE: ./src/utils/ssrDocument.ts\n    /* eslint-disable @typescript-eslint/no-empty-function */\n    var tn = {\n        body: {\n            appendChild: function e() {\n                return [];\n            }\n        },\n        addEventListener: function e() {},\n        removeEventListener: function e() {},\n        activeElement: {\n            blur: function e() {},\n            nodeName: ""\n        },\n        querySelector: function e() {\n            return null;\n        },\n        querySelectorAll: function e() {\n            return [];\n        },\n        getElementById: function e() {\n            return null;\n        },\n        createEvent: function e() {\n            return {\n                initEvent: function e() {}\n            };\n        },\n        createElement: function e() {\n            return {\n                children: [],\n                childNodes: [],\n                style: {},\n                setAttribute: function e() {},\n                getElementsByTagName: function e() {\n                    return [];\n                }\n            };\n        },\n        createElementNS: function e() {\n            return {};\n        },\n        importNode: function e() {\n            return null;\n        },\n        location: {\n            hash: "",\n            host: "",\n            hostname: "",\n            href: "",\n            origin: "",\n            pathname: "",\n            protocol: "",\n            search: ""\n        }\n    };\n    function rn() {\n        var e = typeof document !== "undefined" ? document : tn;\n        return e;\n    }\n    var on = rn();\n    /* harmony default export */    const an = /* unused pure expression or super */ null && 0;\n    // CONCATENATED MODULE: ./src/utils/ssrWindow.ts\n    /* eslint-disable @typescript-eslint/no-empty-function */\n    var ln = {\n        document: tn,\n        navigator: {\n            userAgent: ""\n        },\n        location: {\n            hash: "",\n            host: "",\n            hostname: "",\n            href: "",\n            origin: "",\n            pathname: "",\n            protocol: "",\n            search: ""\n        },\n        history: {\n            replaceState: function e() {},\n            pushState: function e() {},\n            go: function e() {},\n            back: function e() {}\n        },\n        CustomEvent: function e() {\n            return this;\n        },\n        addEventListener: function e() {},\n        removeEventListener: function e() {},\n        getComputedStyle: function e() {\n            return {\n                getPropertyValue: function e() {\n                    return "";\n                }\n            };\n        },\n        Image: function e() {},\n        Date: function e() {},\n        screen: {},\n        setTimeout: function e() {},\n        clearTimeout: function e() {},\n        matchMedia: function e() {\n            return {};\n        },\n        requestAnimationFrame: function e(n) {\n            if (typeof setTimeout === "undefined") {\n                n();\n                return null;\n            }\n            return setTimeout(n, 0);\n        },\n        cancelAnimationFrame: function e(n) {\n            if (typeof setTimeout === "undefined") {\n                return;\n            }\n            clearTimeout(n);\n        }\n    };\n    function un() {\n        var e = typeof window !== "undefined" ? window : ln;\n        return e;\n    }\n    var sn = un();\n    /* harmony default export */    const cn = /* unused pure expression or super */ null && 0;\n    // CONCATENATED MODULE: ./src/Table/HeadInner.tsx\n    function dn() {\n        return dn = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, dn.apply(null, arguments);\n    }\n    function fn(e) {\n        return mn(e) || pn(e) || yn(e) || vn();\n    }\n    function vn() {\n        throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function pn(e) {\n        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) return Array.from(e);\n    }\n    function mn(e) {\n        if (Array.isArray(e)) return gn(e);\n    }\n    function bn(e, n) {\n        return Cn(e) || wn(e, n) || yn(e, n) || hn();\n    }\n    function hn() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function yn(e, n) {\n        if (e) {\n            if ("string" == typeof e) return gn(e, n);\n            var t = {}.toString.call(e).slice(8, -1);\n            return "Object" === t && e.constructor && (t = e.constructor.name), "Map" === t || "Set" === t ? Array.from(e) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? gn(e, n) : void 0;\n        }\n    }\n    function gn(e, n) {\n        (null == n || n > e.length) && (n = e.length);\n        for (var t = 0, r = Array(n); t < n; t++) {\n            r[t] = e[t];\n        }\n        return r;\n    }\n    function wn(e, n) {\n        var t = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != t) {\n            var r, o, i, a, l = [], u = !0, s = !1;\n            try {\n                if (i = (t = t.call(e)).next, 0 === n) {\n                    if (Object(t) !== t) return;\n                    u = !1;\n                } else for (;!(u = (r = i.call(t)).done) && (l.push(r.value), l.length !== n); u = !0) {\n                }\n            } catch (e) {\n                s = !0, o = e;\n            } finally {\n                try {\n                    if (!u && null != t["return"] && (a = t["return"](), Object(a) !== a)) return;\n                } finally {\n                    if (s) throw o;\n                }\n            }\n            return l;\n        }\n    }\n    function Cn(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function xn(e, n) {\n        if (null == e) return {};\n        var t, r, o = Sn(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function Sn(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var On = {\n        align: w().oneOf([ "left", "center", "right" ]),\n        cellId: w().string,\n        clickable: w().bool,\n        columnId: w().string,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        focusWithin: w().bool,\n        hasTooltip: w().bool,\n        index: w().number,\n        isMenu: w().bool,\n        label: w().node,\n        onAutosizeColumn: w().func,\n        onRequestResize: w().func,\n        resizable: w().bool,\n        sortDir: w().oneOf([ "none", "asc", "desc" ]),\n        truncate: w().bool,\n        width: w().oneOfType([ w().number, w().oneOf([ "auto" ]) ]),\n        variant: w().oneOf([ "toggleAll", "info", "actions" ])\n    };\n    var kn = new Set([ "none", "asc", "desc" ]);\n    var Rn = Object.freeze({\n        none: (0, T._)("Click to sort"),\n        asc: (0, T._)("Press to sort descending"),\n        desc: (0, T._)("Press to sort ascending")\n    });\n    var En = Object.freeze({\n        none: Je(),\n        asc: Ye(),\n        desc: Ue()\n    });\n    function In(e) {\n        var n = e.align, o = n === void 0 ? "left" : n, i = e.clickable, a = e.cellId, l = e.columnId, u = e.elementRef, s = e.focusWithin, c = e.hasTooltip, d = e.index, f = e.isMenu, v = e.label, p = e.onAutosizeColumn, m = e.onRequestResize, h = e.resizable, y = h === void 0 ? true : h, g = e.sortDir, w = e.truncate, C = w === void 0 ? true : w, S = e.variant, O = e.width, k = xn(e, [ "align", "clickable", "cellId", "columnId", "elementRef", "focusWithin", "hasTooltip", "index", "isMenu", "label", "onAutosizeColumn", "onRequestResize", "resizable", "sortDir", "truncate", "variant", "width" ]);\n        // @docs-props-type HeadInnerPropsBase\n                var R = (0, T._)("Click to open menu");\n        var E = (0, t.useMemo)((function() {\n            return typeof v === "string" ? v.length : 0;\n        }), [ v ]);\n        var j = (0, t.useState)(false), D = bn(j, 2), q = D[0], A = D[1];\n        var P = (0, t.useState)(0), _ = bn(P, 2), z = _[0], M = _[1];\n        var $ = (0, t.useState)(0), L = bn($, 2), W = L[0], H = L[1];\n        var K = (0, t.useRef)(null);\n        var B = (0, t.useRef)(O === "auto" ? undefined : O);\n        var V;\n        var F;\n        if (g !== undefined && kn.has(g)) {\n            V = En[g];\n            F = Rn[g];\n        }\n        if (O === "auto") {\n            var U;\n            var X = K.current;\n            var Y = X === null || X === void 0 ? void 0 : (U = X.parentElement) === null || U === void 0 ? void 0 : U.getBoundingClientRect();\n            B.current = Y === null || Y === void 0 ? void 0 : Y.width;\n        } else {\n            B.current = O;\n        }\n        var G = (0, t.useCallback)((function(e) {\n            K.current = e;\n            N(u, e);\n        }), [ u, K ]);\n        var J = (0, t.useCallback)((function(e) {\n            var n = e.key;\n            if (m === undefined || d === undefined) {\n                return;\n            }\n            if (O === "auto") {\n                var t;\n                var r = K.current;\n                var o = r === null || r === void 0 ? void 0 : (t = r.parentElement) === null || t === void 0 ? void 0 : t.getBoundingClientRect();\n                B.current = o === null || o === void 0 ? void 0 : o.width;\n            } else {\n                B.current = O;\n            }\n            if (B.current === undefined) {\n                return;\n            }\n            if (n === "ArrowLeft") {\n                e.preventDefault();\n // prevent text selection\n                                var i = Math.max(B.current - 10, 20);\n                m(e, {\n                    index: d,\n                    columnId: l,\n                    id: a,\n                    width: i\n                });\n            }\n            if (n === "ArrowRight") {\n                e.preventDefault();\n // prevent text selection\n                                var u = B.current + 10;\n                m(e, {\n                    index: d,\n                    columnId: l,\n                    id: a,\n                    width: u\n                });\n            }\n            if (n === "Enter") {\n                e.preventDefault();\n // SUI-7320: prevent sorting and dropdown opening\n                        }\n        }), [ l, a, d, m, O ]);\n        var Q = (0, t.useCallback)((function(e) {\n            if (O === "auto") {\n                var n;\n                var t = K.current;\n                var r = t === null || t === void 0 ? void 0 : (n = t.parentElement) === null || n === void 0 ? void 0 : n.getBoundingClientRect();\n                B.current = r === null || r === void 0 ? void 0 : r.width;\n            } else {\n                B.current = O;\n            }\n            if (B.current === undefined) {\n                return;\n            }\n            e.preventDefault();\n // prevent text selection\n                        M(e.clientX);\n            H(B.current || 0);\n            A(true);\n        }), [ O ]);\n        var Z = function e(n) {\n            var t = z - n.clientX;\n            var r = Math.max(W - t, 16);\n            if (d !== undefined) {\n                m === null || m === void 0 ? void 0 : m(n, {\n                    index: d,\n                    columnId: l,\n                    id: a,\n                    width: r\n                });\n            }\n        };\n        var ee = function e() {\n            A(false);\n        };\n        var ne = (0, t.useCallback)((function(e) {\n            if (d !== undefined) {\n                p === null || p === void 0 ? void 0 : p(e, {\n                    index: d,\n                    columnId: l,\n                    id: a\n                });\n            }\n        }), [ a, l, d, p ]);\n        var te = un();\n        var re = B.current ? (0, I.sprintf)((0, T._)("%(width)d pixels"), {\n            width: B.current\n        }) : undefined;\n        \n        return r().createElement(Le, dn({\n            as: i ? "button" : "div",\n            ref: G,\n            $align: o,\n            $clickable: i,\n            $focusWithin: s,\n            $hasIcon: !!f || !!g,\n            $hasTooltip: !!c,\n            $variant: S,\n            $labelLength: E\n        }, b()(k, [].concat(fn(Object.keys(In.propTypes)), [ "id" ]))), q &&  r().createElement(r().Fragment, null,  r().createElement(x(), {\n            target: te,\n            eventType: "mouseup",\n            listener: ee\n        }),  r().createElement(x(), {\n            target: te,\n            eventType: "mousemove",\n            listener: Z\n        })), m && y &&  r().createElement(We, {\n            "aria-label": (0, I.sprintf)((0, T._)("Resize %(label)s"), {\n                label: v\n            }),\n            "aria-controls": a,\n            "aria-valuetext": re,\n            "data-test": "resize",\n            onMouseDown: Q,\n            onDoubleClick: ne,\n            onKeyDown: J,\n            orientation: "vertical",\n            tabIndex: 0\n        }),  r().createElement($e, {\n            $align: o,\n            $truncate: C,\n            $variant: S,\n            $labelLength: E\n        }, v), c &&  r().createElement(Me, null,  r().createElement(nn(), {\n            "data-test": "tooltip-icon"\n        })), f &&  r().createElement(ze, null,  r().createElement(Ze(), {\n            "data-test": "caret-down",\n            "aria-label": R\n        })), g &&  r().createElement(ze, null, V !== undefined &&  r().createElement(V, {\n            "aria-hidden": false,\n            "aria-label": F\n        })));\n    }\n    In.propTypes = On;\n    /* harmony default export */    const Tn = In;\n    // CONCATENATED MODULE: ./src/Table/HeadCell.tsx\n    function jn() {\n        return jn = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, jn.apply(null, arguments);\n    }\n    function Dn(e, n) {\n        if (null == e) return {};\n        var t, r, o = qn(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function qn(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    /** @public */\n    /** @public */    var An = {\n        align: w().oneOf([ "left", "center", "right" ]),\n        /** @private Used to set the $clickable appearance without an onClick */\n        appearClickable: w().bool,\n        children: w().node,\n        columnId: w().string,\n        /** @private. */\n        dragId: w().oneOfType([ w().string, w().number ]),\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        headCellScreenReaderText: w().string,\n        /** @private The index of the cell, skipping the info column. */\n        index: w().number,\n        /** @private. */\n        onAutosizeColumn: w().func,\n        /** @private. */\n        onClick: w().func,\n        /**\n   * @private. Passed through and works as expected.\n   */\n        onKeyDown: w().func,\n        /** @private. */\n        onRequestMoveColumn: w().func,\n        /** @private. */\n        onRequestResize: w().func,\n        onSort: w().func,\n        resizable: w().bool,\n        sortDir: w().oneOf([ "asc", "desc", "none" ]),\n        sortKey: w().string,\n        tooltip: w().node,\n        truncate: w().bool,\n        /** @private. */\n        variant: w().oneOf([ "toggleAll", "info", "actions" ]),\n        /**\n   * Used internally to suppress focus and id when this `HeadCell` is superseded by one in an\n   * overlaid `HeadTable` for user interactions.\n   * @private\n   */\n        visible: w().bool,\n        width: w().oneOfType([ w().number, w().oneOf([ "auto" ]) ])\n    };\n    var Pn = {\n        asc: "ascending",\n        desc: "descending",\n        none: "none"\n    };\n    function _n(e) {\n        var n;\n        var o = e.align, i = o === void 0 ? "left" : o, l = e.appearClickable, u = e.children, s = e.columnId, c = e.elementRef, d = e.dragId, f = e.headCellScreenReaderText, v = e.id, p = e.index, m = e.onAutosizeColumn, b = e.onClick, h = e.onKeyDown, y = e.onRequestMoveColumn, g = e.onRequestResize, w = e.onSort, C = e.resizable, x = C === void 0 ? true : C, S = e.sortDir, O = S === void 0 ? "none" : S, k = e.sortKey, R = e.style, E = e.tooltip, D = e.truncate, q = D === void 0 ? true : D, A = e.variant, P = e.visible, _ = P === void 0 ? true : P, z = e.width, M = Dn(e, [ "align", "appearClickable", "children", "columnId", "elementRef", "dragId", "headCellScreenReaderText", "id", "index", "onAutosizeColumn", "onClick", "onKeyDown", "onRequestMoveColumn", "onRequestResize", "onSort", "resizable", "sortDir", "sortKey", "style", "tooltip", "truncate", "variant", "visible", "width" ]);\n        // @docs-props-type HeadCellPropsBase\n                var $ = !!y;\n        var L = (0, a.useSortable)({\n            // dragId is optional in HeadCell but required by useSortable\n            // since it is always set in Table, use a type assertion here to avoid TypeScript error\n            id: d\n        }), W = L.attributes, H = L.isDragging, K = L.listeners, B = L.setNodeRef;\n        var V = (0, t.useCallback)((function(e) {\n            N(c, e);\n            if ($) {\n                B(e);\n            }\n        }), [ $, c, B ]);\n        var F = (0, t.useCallback)((function(e) {\n            // ignore clicks on the resize handle\n            if (e.target.getAttribute("data-test") !== "resize" && w && p !== undefined) {\n                w(e, {\n                    sortKey: k,\n                    sortDir: O,\n                    id: v,\n                    columnId: s,\n                    index: p\n                });\n            }\n            b === null || b === void 0 ? void 0 : b();\n        }), [ s, v, p, b, w, O, k ]);\n        var U = (0, t.useCallback)((function(e) {\n            if (p !== undefined) {\n                h === null || h === void 0 ? void 0 : h(e, {\n                    index: p,\n                    columnId: s\n                });\n            }\n        }), [ s, p, h ]);\n        var X = !!w && !!O;\n        var Y = b !== undefined;\n        var G = A === "actions" ? false : q;\n        var J = (0, t.useMemo)((function() {\n            return Re()({}, R, {\n                width: z\n            });\n        }), [ R, z ]);\n        var Q;\n        if (f) {\n            Q = f;\n        } else if (Oe()(u)) {\n            Q = u;\n        }\n        var Z = (n = v !== null && v !== void 0 ? v : s) !== null && n !== void 0 ? n : (0, \n        j.createDOMID)("headCellId-");\n        var ee = (0, t.useMemo)((function() {\n            return {\n                align: i,\n                clickable: l || X || Y,\n                columnId: s,\n                focusWithin: l,\n                label: u,\n                cellId: Z,\n                index: p,\n                onAutosizeColumn: m,\n                onClick: w || Y ? F : undefined,\n                onKeyDown: w || Y ? U : undefined,\n                onRequestResize: g,\n                resizable: _ && x,\n                sortDir: w && O,\n                truncate: G,\n                variant: A,\n                width: z\n            };\n        }), [ i, l, X, Y, s, u, Z, p, m, w, F, U, g, _, x, O, G, A, z ]);\n        var ne = (0, t.useCallback)((function(e) {\n            \n            return r().createElement(Tn, jn({}, e, ee, {\n                hasTooltip: true\n            }));\n        }), [ ee ]);\n        \n        return r().createElement(Ke, jn({\n            style: J,\n            ref: V,\n            "aria-sort": w && (Pn[O] || "none"),\n            "data-test": "head-cell",\n            "data-test-label": Oe()(u) ? u : undefined,\n            "data-test-sort-dir": w && O,\n            id: _ ? Z : undefined,\n            $isDragging: $ && H,\n            $variant: A\n        }, M),  r().createElement(He, null, $ &&  r().createElement(Ve, jn({\n            "aria-label": (0, I.sprintf)((0, T._)("Reorder %(labelString)s"), {\n                labelString: Q\n            }),\n            "data-test": "drag",\n            draggable: true\n        }, W, K),  r().createElement(Be, null,  r().createElement(Ie(), null))), E ?  r().createElement(je(), {\n            content: E,\n            renderAnchor: ne\n        }) :  r().createElement(Tn, ee)));\n    }\n    _n.propTypes = An;\n    _n.splunkUiType = "Table.HeadCell";\n    /* harmony default export */    const zn = _n;\n    // CONCATENATED MODULE: ./src/Table/HeadStyles.ts\n    var Mn = z().thead.withConfig({\n        displayName: "HeadStyles__Styled",\n        componentId: "iap21t-0"\n    })([ "", ";", "" ], M.mixins.reset("table-header-group"), (function(e) {\n        var n = e.$isFixed, t = e.$zIndex;\n        return n && (0, _.css)([ "position:sticky;top:0;z-index:", ";" ], t);\n    }));\n    var $n = z()(zn).withConfig({\n        displayName: "HeadStyles__StyledToggleAll",\n        componentId: "iap21t-1"\n    })([ "width:32px;" ]);\n    var Nn = z()(zn).withConfig({\n        displayName: "HeadStyles__StyledInfo",\n        componentId: "iap21t-2"\n    })([ "width:32px;" ]);\n    var Ln = z()(zn).withConfig({\n        displayName: "HeadStyles__StyledDragRow",\n        componentId: "iap21t-3"\n    })([ "width:32px;" ]);\n    // CONCATENATED MODULE: external "@dnd-kit/utilities"\n    const Wn = __webpack_require__(56550);\n    // CONCATENATED MODULE: external "@splunk/react-icons/DotsThreeVertical"\n    const Hn = __webpack_require__(31912);\n    var Kn =  e.n(Hn);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Button"\n    const Bn = __webpack_require__(64852);\n    var Vn =  e.n(Bn);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Dropdown"\n    const Fn = __webpack_require__(33689);\n    var Un =  e.n(Fn);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ChevronRight"\n    const Xn = __webpack_require__(38315);\n    var Yn =  e.n(Xn);\n    // CONCATENATED MODULE: ./src/Table/ExpandButtonStyles.ts\n    var Gn = z().button.withConfig({\n        displayName: "ExpandButtonStyles__StyledButton",\n        componentId: "sc-7nlw5q-0"\n    })([ "", ";height:100%;width:100%;cursor:pointer;justify-content:center;color:", ";&:hover{color:", ";}&:focus{color:", ";box-shadow:", ";}" ], M.mixins.reset("flex"), M.variables.contentColorDefault, M.variables.contentColorActive, M.variables.contentColorActive, M.variables.focusShadowInset);\n    var Jn = z()(Yn()).withConfig({\n        displayName: "ExpandButtonStyles__StyledChevron",\n        componentId: "sc-7nlw5q-1"\n    })([ "padding-block:", ";transition:transform 200ms;", "" ], (0, M.pick)({\n        comfortable: "10px",\n        compact: "8px"\n    }), (function(e) {\n        var n = e.$expanded;\n        return n && (0, _.css)([ "transform:rotate(90deg);" ]);\n    }));\n    // CONCATENATED MODULE: ./src/Table/ExpandButton.tsx\n    function Qn() {\n        return Qn = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, Qn.apply(null, arguments);\n    }\n    function Zn(e, n) {\n        if (null == e) return {};\n        var t, r, o = et(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function et(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var nt = {\n        expanded: w().bool\n    };\n    var tt = function e(n) {\n        var t = n.expanded, o = Zn(n, [ "expanded" ]);\n        // @docs-props-type ExpandButtonPropsBase\n                \n        return r().createElement(Gn, Qn({\n            title: t ? (0, T._)("Collapse row") : (0, T._)("Expand row")\n        }, o),  r().createElement(Jn, {\n            $expanded: t\n        }));\n    };\n    tt.propTypes = nt;\n    /* harmony default export */    const rt = tt;\n    // CONCATENATED MODULE: ./src/Table/RowDragCellStyles.ts\n    var ot = z().td.withConfig({\n        displayName: "RowDragCellStyles__StyledCell",\n        componentId: "sc-9kbaj2-0"\n    })([ "", " cursor:move;touch-action:none;position:relative;vertical-align:middle;" ], M.mixins.reset("table-cell"));\n    var it = z().div.withConfig({\n        displayName: "RowDragCellStyles__StyledDrag",\n        componentId: "sc-9kbaj2-1"\n    })([ "", " ", ";justify-content:center;cursor:move;-webkit-user-drag:element;user-select:none;align-items:center;position:absolute;width:100%;top:0;bottom:0;&:focus{outline:0;box-shadow:", ";}&:hover{background-color:", ";outline:none;}&:active{background-color:", ";box-shadow:", ";}& > div{margin:0;}@media print{background-image:none;}" ], M.mixins.reset("flex"), M.mixins.clearfix(), M.variables.focusShadowInset, M.variables.interactiveColorOverlayDrag, M.variables.interactiveColorOverlayActive, M.variables.focusShadowInset);\n    // CONCATENATED MODULE: ./src/Table/RowDragCell.tsx\n    function at() {\n        return at = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, at.apply(null, arguments);\n    }\n    function lt(e, n) {\n        if (null == e) return {};\n        var t, r, o = ut(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function ut(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var st = {\n        setActivatorNodeRef: w().func.isRequired,\n        listeners: w().objectOf(w().func)\n    };\n    function ct(e) {\n        var n = e.listeners, t = e.setActivatorNodeRef, o = lt(e, [ "listeners", "setActivatorNodeRef" ]);\n        // @docs-props-type RowDragCellPropsBase\n                \n        return r().createElement(ot, {\n            "data-helper": true\n        },  r().createElement(it, at({\n            "data-test": "drag",\n            draggable: true,\n            ref: t,\n            tabIndex: 0\n        }, n, o),  r().createElement(Ie(), null)));\n    }\n    ct.propTypes = st;\n    /* harmony default export */    const dt = ct;\n    // CONCATENATED MODULE: ./src/Table/RowStyles.ts\n    var ft = z().tr.withConfig({\n        displayName: "RowStyles__StyledStripeNone",\n        componentId: "f0igqq-0"\n    })([ "", ";", ";", " @media print{background-color:none;}" ], M.mixins.reset("table-row"), (function(e) {\n        var n = e.$clickable;\n        return n && (0, _.css)([ "cursor:pointer;&:hover{background-color:", ";}&:focus{background-color:", ";box-shadow:", ";}" ], M.variables.neutral100, M.variables.neutral100, M.variables.focusShadowInset);\n    }), (function(e) {\n        var n = e.disabled, t = e.$expandable, r = e.$isDraggable;\n        return !n && !t && r && (0, _.css)([ "&:hover{background-color:", ";}" ], M.variables.interactiveColorOverlayHover);\n    }));\n    var vt = z()(ft).withConfig({\n        displayName: "RowStyles__StyledStripeEven",\n        componentId: "f0igqq-1"\n    })([ "background-color:", ";", ";" ], M.variables.neutral50, (function(e) {\n        var n = e.$clickable;\n        return n && (0, _.css)([ "cursor:pointer;&:hover,&:focus{background-color:", ";}" ], M.variables.neutral300);\n    }));\n    // CONCATENATED MODULE: external "@splunk/react-ui/Checkbox"\n    const pt = __webpack_require__(14729);\n    var mt =  e.n(pt);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Clickable"\n    const bt = __webpack_require__(43594);\n    var ht =  e.n(bt);\n    // CONCATENATED MODULE: ./src/Table/ToggleStyles.ts\n    var yt = z()(ht()).withConfig({\n        displayName: "ToggleStyles__StyledClickable",\n        componentId: "sc-1x3ikch-0"\n    })([ "height:100%;width:100%;display:flex;justify-content:center;&[disabled]{cursor:not-allowed;}" ]);\n    var gt = z()(mt()).withConfig({\n        displayName: "ToggleStyles__StyledCheckbox",\n        componentId: "sc-1x3ikch-1"\n    })([ "align-items:flex-start;padding-block:", ";" ], (0, M.pick)({\n        comfortable: "8px",\n        compact: "6px"\n    }));\n    // CONCATENATED MODULE: ./src/Table/Toggle.tsx\n    function wt() {\n        return wt = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, wt.apply(null, arguments);\n    }\n    function Ct(e, n) {\n        if (null == e) return {};\n        var t, r, o = xt(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function xt(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var St = {\n        disabled: w().bool,\n        onClick: w().func,\n        selected: w().oneOf([ true, false, "some" ])\n    };\n    function Ot(e) {\n        var n = e.disabled, t = e.onClick, o = e.selected, i = Ct(e, [ "disabled", "onClick", "selected" ]);\n        // @docs-props-type TogglePropsBase\n                var a = n === true ? "disabled" : undefined;\n        \n        // we use a Clickable around the inert Checkbox (which can seem ironic) so that the whole table cell is clickable\n        // we cannot use the Cell\'s onClick itself because of a11y issues we have faced in the past (see SUI-5958).\n        return r().createElement(yt, wt({\n            "aria-checked": o === "some" ? "mixed" : o,\n            disabled: a,\n            onClick: t,\n            role: "checkbox"\n        }, i),  r().createElement(gt, {\n            checked: o === "some" ? "indeterminate" : o,\n            disabled: !!a,\n            inert: true\n        }));\n    }\n    Ot.propTypes = St;\n    /* harmony default export */    const kt = Ot;\n    // CONCATENATED MODULE: ./src/Table/Row.tsx\n    function Rt(e) {\n        "@babel/helpers - typeof";\n        return Rt = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {\n            return typeof e;\n        } : function(e) {\n            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;\n        }, Rt(e);\n    }\n    function Et(e, n) {\n        var t = Object.keys(e);\n        if (Object.getOwnPropertySymbols) {\n            var r = Object.getOwnPropertySymbols(e);\n            n && (r = r.filter((function(n) {\n                return Object.getOwnPropertyDescriptor(e, n).enumerable;\n            }))), t.push.apply(t, r);\n        }\n        return t;\n    }\n    function It(e) {\n        for (var n = 1; n < arguments.length; n++) {\n            var t = null != arguments[n] ? arguments[n] : {};\n            n % 2 ? Et(Object(t), !0).forEach((function(n) {\n                Tt(e, n, t[n]);\n            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : Et(Object(t)).forEach((function(n) {\n                Object.defineProperty(e, n, Object.getOwnPropertyDescriptor(t, n));\n            }));\n        }\n        return e;\n    }\n    function Tt(e, n, t) {\n        return (n = jt(n)) in e ? Object.defineProperty(e, n, {\n            value: t,\n            enumerable: !0,\n            configurable: !0,\n            writable: !0\n        }) : e[n] = t, e;\n    }\n    function jt(e) {\n        var n = Dt(e, "string");\n        return "symbol" == Rt(n) ? n : n + "";\n    }\n    function Dt(e, n) {\n        if ("object" != Rt(e) || !e) return e;\n        var t = e[Symbol.toPrimitive];\n        if (void 0 !== t) {\n            var r = t.call(e, n || "default");\n            if ("object" != Rt(r)) return r;\n            throw new TypeError("@@toPrimitive must return a primitive value.");\n        }\n        return ("string" === n ? String : Number)(e);\n    }\n    function qt(e, n) {\n        if (null == e) return {};\n        var t, r, o = At(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function At(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    function Pt() {\n        return Pt = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, Pt.apply(null, arguments);\n    }\n    var _t = {\n        odd: ft,\n        even: vt,\n        none: ft\n    };\n    /** @public */\n    /** @public */\n    /** @public */\n    /** @public */\n    /** @public */    var zt = {\n        /** @private. Generally passed by Table rather than added directly. */\n        activeElementId: w().string,\n        actionPrimary: w().element,\n        actionsSecondary: w().element,\n        children: w().node,\n        data: w().any,\n        disabled: w().bool,\n        /** @private. Generally passed by Table rather than added directly. */\n        isDraggable: w().bool,\n        /** @private. Generally passed by Table rather than added directly. */\n        dragId: w().oneOfType([ w().string, w().number ]),\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        /** @private. */\n        expandable: w().bool,\n        expanded: w().bool,\n        /** @private. Identifies the unique id (or ids) for an expanded row (or rows). In expandable rows `ExpansionRowIcon` uses `expansionRowId` for accessibility aria attributes. */\n        expansionRowIds: w().string,\n        expansionRow: w().oneOfType([ w().element, w().arrayOf(w().element) ]),\n        /** @private. Indicates whether the table has an actions column. */\n        actions: w().bool,\n        /** @private. Generally passed by `Table` rather than added directly. */\n        index: w().number,\n        /** @private. Generally passed by `Table` rather than added directly. */\n        movableColumns: w().bool,\n        onClick: w().func,\n        onExpansion: w().func,\n        /** @private. This is passed through and works as expected. */\n        onKeyDown: w().func,\n        /** @private. Generally passed by `Table` rather than added directly. */\n        onRequestMoveRow: w().func,\n        onRequestToggle: w().func,\n        /** @private. Generally passed by `Table` rather than added directly. */\n        primaryColumnIndex: w().number,\n        rowScreenReaderText: w().string,\n        selected: w().bool,\n        /** @private. */\n        stripe: w().oneOf([ "odd", "even", "none" ])\n    };\n    var Mt =  r().createElement(Kn(), null);\n    var $t =  r().forwardRef((function(e, n) {\n        \n        return r().createElement(je(), Pt({\n            content: (0, T._)("Actions"),\n            contentRelationship: "label"\n        }, e),  r().createElement(Vn(), {\n            appearance: "subtle",\n            "data-test": "actions-secondary-toggle",\n            icon: Mt,\n            elementRef: n\n        }));\n    }));\n    function Nt(e) {\n        var n;\n        var o = e.actions, i = e.actionPrimary, l = e.actionsSecondary, u = e.children, s = e.data, c = e.dragId, d = e.disabled, f = e.isDraggable, v = e.elementRef, p = e.expandable, m = e.expanded, h = e.expansionRowIds, y = e.expansionRow, g = e.index, w = e.movableColumns, C = e.onClick, x = e.onExpansion, S = e.onKeyDown, O = e.onRequestToggle, k = e.primaryColumnIndex, R = k === void 0 ? 0 : k, E = e.rowScreenReaderText, D = e.selected, q = e.stripe, A = q === void 0 ? "none" : q, P = e.style, _ = qt(e, [ "actions", "actionPrimary", "actionsSecondary", "children", "data", "dragId", "disabled", "isDraggable", "elementRef", "expandable", "expanded", "expansionRowIds", "expansionRow", "index", "movableColumns", "onClick", "onExpansion", "onKeyDown", "onRequestToggle", "primaryColumnIndex", "rowScreenReaderText", "selected", "stripe", "style" ]);\n // @docs-props-type RowPropsBase\n                var z = (0, t.useMemo)((function() {\n            return {\n                id: f ? c : (0, j.createGUID)(),\n                disabled: !f\n            };\n        }), [ f, c ]);\n        var M = (0, a.useSortable)(z), $ = M.attributes, L = M.listeners, W = M.transform, H = M.transition, K = M.setNodeRef, B = M.setActivatorNodeRef;\n        var V = (0, t.useMemo)((function() {\n            return f ? It(It({}, P), {}, {\n                transform: Wn.CSS.Translate.toString(W),\n                transition: H\n            }) : P;\n        }), [ f, W, H, P ]);\n        var F = (0, t.useRef)(null);\n        var U = (0, t.useCallback)((function(e) {\n            var n = e.target;\n            while (n) {\n                if (F.current === n) {\n                    break;\n                }\n                // Ignore clicks on row-actions\n                                if (n.tagName === "BUTTON" || n.tagName === "A") {\n                    return;\n                }\n                n = n.parentNode;\n            }\n            if (!e.defaultPrevented) {\n                C === null || C === void 0 ? void 0 : C(e, s);\n            }\n        }), [ s, C ]);\n        var X = (0, t.useCallback)((function(e) {\n            if (e.key === "Enter" && C) {\n                C(e, s);\n            }\n            S === null || S === void 0 ? void 0 : S(e);\n        }), [ s, C, S ]);\n        var Y = (0, t.useCallback)((function(e) {\n            if (!d) {\n                e.preventDefault();\n                O === null || O === void 0 ? void 0 : O(e, s);\n            }\n        }), [ s, d, O ]);\n        var G = (0, t.useCallback)((function(e) {\n            e.preventDefault();\n            x === null || x === void 0 ? void 0 : x(e, s);\n        }), [ s, x ]);\n        var J = function n() {\n            if (i && i.props.onClick) {\n                \n                return (0, t.cloneElement)(i, {\n                    onClick: function n(t) {\n                        var r, o;\n                        t.preventDefault();\n                        return (r = (o = i.props).onClick) === null || r === void 0 ? void 0 : r.call(o, t, e.data);\n                    }\n                });\n            }\n            return i;\n        };\n        var Q = function n() {\n            if (l && l.props.children) {\n                var r = t.Children.toArray(l.props.children).filter(t.isValidElement);\n                var o = r.map((function(n) {\n                    if (n.props.onClick) {\n                        \n                        return (0, t.cloneElement)(n, {\n                            onClick: function t(r) {\n                                var o, i;\n                                r.preventDefault();\n                                return (o = (i = n.props).onClick) === null || o === void 0 ? void 0 : o.call(i, r, e.data);\n                            }\n                        });\n                    }\n                    return n;\n                }));\n                \n                return (0, t.cloneElement)(l, {\n                    children: o\n                });\n            }\n            return l;\n        };\n        function Z(e) {\n            F.current = e;\n            N(v, e);\n            if (f) {\n                K(e);\n            }\n        }\n        var ee = t.Children.toArray(u).map((function(e, n) {\n            \n            return (0, t.cloneElement)(e, {\n                appearance: C ? "rowLink" : e.props.appearance,\n                disabled: d,\n                isPrimaryCell: R === n,\n                stripe: A\n            });\n        }));\n        var ne;\n        if (E) {\n            ne = E;\n        } else if ((n = ee[R]) === null || n === void 0 ? void 0 : n.props.children) {\n            var te;\n            ne = "".concat((te = ee[R]) === null || te === void 0 ? void 0 : te.props.children);\n        } else {\n            var re;\n            ne = "".concat((re = ee[0]) === null || re === void 0 ? void 0 : re.props.children);\n            if (false) // removed by dead control flow\n{}\n        }\n        var oe = (0, I.sprintf)((0, T._)("%(selected)s"), {\n            selected: D ? "selected" : "unselected"\n        });\n        var ie = _t[A];\n        var ae = m ? t.Children.count(y) + 1 : undefined;\n        var le = w ? "false" : undefined;\n        var ue = function e() {\n            \n            return r().createElement($t, null);\n        };\n        var se = (0, I.sprintf)((0, T._)("Collapse row - %(rowLabelValue)s"), {\n            rowLabelValue: ne\n        });\n        var ce = (0, I.sprintf)((0, T._)("Expand row - %(rowLabelValue)s"), {\n            rowLabelValue: ne\n        });\n        \n        return r().createElement(ie, Pt({\n            "data-test": "row",\n            "data-test-selected": O ? D : undefined,\n            $clickable: !!C,\n            "data-has-movable-columns": w ? "true" : undefined,\n            disabled: !!d,\n            $expandable: !!p,\n            $isDraggable: !!f,\n            ref: Z,\n            tabIndex: C ? 0 : undefined\n        }, b()(_, "data"), {\n            onClick: C ? U : undefined,\n            onKeyDown: X,\n            $rowSelected: !!(O && D),\n            style: V\n        }), f && g != null &&  r().createElement(dt, Pt({\n            "aria-label": (0, I.sprintf)((0, T._)("Reorder %(rowLabelValue)s"), {\n                rowLabelValue: ne\n            }),\n            setActivatorNodeRef: B,\n            listeners: L\n        }, $)), O &&  r().createElement(xe, {\n            align: "center",\n            appearance: C ? "rowLink" : "data",\n            disabled: d,\n            variant: "toggle",\n            "data-movable-column": le,\n            rowSpan: ae,\n            "data-test": "toggle"\n        },  r().createElement(kt, {\n            "aria-label": (0, I.sprintf)((0, T._)("%(rowLabelValue)s %(selectedString)s"), {\n                rowLabelValue: ne,\n                selectedString: oe\n            }),\n            disabled: d,\n            onClick: Y,\n            selected: D\n        })), p && y &&  r().createElement(xe, {\n            align: "center",\n            appearance: "data",\n            "data-movable-column": le,\n            "data-test": "expand",\n            expand: m,\n            rowSpan: ae,\n            variant: "expand"\n        },  r().createElement(rt, {\n            expanded: m,\n            onClick: G,\n            title: m ? se : ce,\n            "aria-controls": m ? h : undefined,\n            "aria-expanded": m\n        })), p && !y &&  r().createElement(xe, {\n            variant: "expand",\n            "data-movable-column": le\n        }), ee, o && !i && !l &&  r().createElement(xe, {\n            align: "right",\n            appearance: C ? "rowLink" : "data",\n            "data-test": "row-actions",\n            variant: "actions",\n            "data-movable-column": le\n        }), (i || l) &&  r().createElement(xe, {\n            align: "right",\n            appearance: "data",\n            "data-test": "row-actions",\n            variant: "actions",\n            "data-movable-column": le\n        }, i && J(), l &&  r().createElement(Un(), {\n            toggle: ue()\n        }, Q())));\n    }\n    Nt.propTypes = zt;\n    Nt.splunkUiType = "Table.Row";\n    /* harmony default export */    const Lt = Nt;\n    // CONCATENATED MODULE: ./src/Table/TableContext.ts\n    var Wt =  (0, t.createContext)({});\n    Wt.displayName = "Table";\n    /* harmony default export */    const Ht = Wt;\n    // CONCATENATED MODULE: ./src/Table/Head.tsx\n    function Kt() {\n        return Kt = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, Kt.apply(null, arguments);\n    }\n    function Bt(e, n) {\n        if (null == e) return {};\n        var t, r, o = Vt(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function Vt(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var Ft = {\n        /** @private. */\n        actions: w().arrayOf(w().node),\n        /** @private. */\n        actionsColumnWidth: w().number,\n        /** @private */\n        cellMinWidth: w().number,\n        children: w().node,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        /** @private. */\n        hasDragColumn: w().bool,\n        /** @private. */\n        hasInfoColumn: w().bool,\n        /** @private. */\n        onAutosizeColumn: w().func,\n        /** @private. */\n        onRequestMoveColumn: w().func,\n        /** @private. */\n        onRequestResizeColumn: w().func,\n        /** @private. */\n        onRequestToggleAllRows: w().func,\n        /** @private. */\n        rowSelection: w().oneOf([ "all", "some", "none" ])\n    };\n    var Ut = 1;\n    var Xt = {\n        all: true,\n        none: false,\n        some: "some"\n    };\n    var Yt = (0, T._)("No rows selected");\n    var Gt = (0, T._)("Some rows selected");\n    var Jt = (0, T._)("All rows selected");\n    var Qt = function e(n) {\n        var t, r;\n        var o = un();\n        if (!n) {\n            return [];\n        }\n        return Array.from((t = (r = n.firstElementChild) === null || r === void 0 ? void 0 : r.children) !== null && t !== void 0 ? t : []).map((function(e) {\n            var n = o.getComputedStyle(e);\n            return e.clientWidth - parseFloat(n.getPropertyValue("padding-right")) - parseFloat(n.getPropertyValue("padding-left"));\n        }));\n    };\n    function Zt(e) {\n        var n = e.actions, o = n === void 0 ? [] : n, i = e.actionsColumnWidth, a = e.cellMinWidth, l = a === void 0 ? 60 : a, u = e.children, s = e.elementRef, c = e.hasDragColumn, d = e.hasInfoColumn, f = e.onAutosizeColumn, v = e.onRequestMoveColumn, p = e.onRequestResizeColumn, m = e.onRequestToggleAllRows, b = e.rowSelection, h = Bt(e, [ "actions", "actionsColumnWidth", "cellMinWidth", "children", "elementRef", "hasDragColumn", "hasInfoColumn", "onAutosizeColumn", "onRequestMoveColumn", "onRequestResizeColumn", "onRequestToggleAllRows", "rowSelection" ]);\n        // @docs-props-type HeadPropsBase\n                var y = (0, t.useContext)(Ht), g = y.headType, w = y.tableContainerWidthWithoutBorders, C = y.resizableFillLayout;\n        var x = (0, t.useRef)(null);\n        var S = (0, t.useRef)([]);\n        (0, t.useEffect)((function() {\n            // Validate children width\n            if (false) // removed by dead control flow\n{ var e; }\n        }), [ u, p, C ]);\n        var O = (0, t.useCallback)((function(e) {\n            var n = e.fromIndex, r = e.toIndex;\n            if (r < t.Children.toArray(u).length) {\n                // HeadCell never requests less than zero\n                v === null || v === void 0 ? void 0 : v({\n                    fromIndex: n,\n                    toIndex: r\n                });\n            }\n        }), [ u, v ]);\n        var k = (0, t.useCallback)((function(e, n) {\n            var t = n.columnId, r = n.id, o = n.index, i = n.width;\n            var a = Qt(x.current);\n            if (o >= a.length) {\n                p === null || p === void 0 ? void 0 : p(e, n);\n                return;\n            }\n            var u = a[o];\n            var s = i - u;\n            if (s <= 0) {\n                // handle shrinking\n                if (i >= l) {\n                    p === null || p === void 0 ? void 0 : p(e, n);\n                } else {\n                    // shrink the cell as small as we can\n                    p === null || p === void 0 ? void 0 : p(e, {\n                        columnId: t,\n                        id: r,\n                        index: o,\n                        width: l\n                    });\n                }\n            } else {\n                // handle expansion\n                var c = [];\n                var d = 0;\n                var f = true;\n                if (S.current.length !== a.length) {\n                    p === null || p === void 0 ? void 0 : p(e, n);\n                    return;\n                }\n                S.current.forEach((function(e, n) {\n                    if (e === "auto") {\n                        d += 1;\n                        c.push(n);\n                    }\n                }));\n                if (d > 0) {\n                    // if there are auto width cells, check if shrinking them by changePerEachAutoCell make them smaller than cellMinWidth\n                    var v = s / d;\n                    c.every((function(e) {\n                        if (e < a.length && a[e] - v < l) {\n                            f = false;\n                            return false;\n                        }\n                        return true;\n                    }));\n                    if (f) {\n                        p === null || p === void 0 ? void 0 : p(e, n);\n                    } else {\n                        // make the cell as big as we can without letting any cells go below cellMinWidth\n                        // that means all auto cells are at cellMinWidth and all the set width cells stay the same size\n                        var m = 0;\n                        c.forEach((function(e) {\n                            if (e < a.length) {\n                                m += Math.max(a[e] - l, 0);\n                            }\n                        }));\n                        var b = a[o] + m;\n                        p === null || p === void 0 ? void 0 : p(e, {\n                            columnId: t,\n                            id: r,\n                            index: o,\n                            width: b\n                        });\n                    }\n                } else if (w != null) {\n                    // if there are no auto width cells, check if shrinking the last cell by requested change makes it smaller than cellMinWidth\n                    /**\n         * We need to calculate the percieved width of the last cell, because if the user modifies the size of the last head cell,\n         * the width of the last cell will technically be whatever they made it, but the last cell will get cut off if it extends past\n         * the table container\'s width.\n         */\n                    var h = a.slice(0, a.length - 1);\n                    var y = h.reduce((function(e, n) {\n                        return e + n;\n                    }));\n                    var g = w - y;\n                    if (g - s >= l) {\n                        p === null || p === void 0 ? void 0 : p(e, n);\n                    } else {\n                        // make the cell as big as we can without letting perceivedWidthOfLastCell go below cellMinWidth\n                        var C = g - l;\n                        var O = u + C;\n                        p === null || p === void 0 ? void 0 : p(e, {\n                            columnId: t,\n                            id: r,\n                            index: o,\n                            width: O\n                        });\n                    }\n                } else {\n                    /**\n         * If tableContainerWidthWithoutBorders == null, there isn\'t a way to correctly calculate\n         * the perceived width so this case will result in columns possibly going offscreen. In testing,\n         * tableContainerWidthWithoutBorders attains a value quickly enough that it isn\'t a problem.\n         */\n                    p === null || p === void 0 ? void 0 : p(e, n);\n                }\n            }\n        }), [ l, p, w ]);\n        var R = (0, t.useCallback)((function(e) {\n            N(s, e);\n            x.current = e;\n        }), [ s ]);\n        var E = (0, t.useMemo)((function() {\n            return t.Children.toArray(u).filter(t.isValidElement);\n        }), [ u ]);\n        var I = E.length + (o.length || i ? 1 : 0);\n        var T = (0, t.useMemo)((function() {\n            var e = [];\n            var n = E.map((function(n, r) {\n                e.push(n.props.width);\n                \n                return (0, t.cloneElement)(n, {\n                    index: r,\n                    onRequestResize: C ? k : p,\n                    onRequestMoveColumn: v ? O : undefined,\n                    onAutosizeColumn: f,\n                    key: n.key || n.props.columnId || r\n                });\n            }));\n            S.current = e;\n            return n;\n        }), [ E, C, k, p, v, O, f ]);\n        var j = b === undefined ? undefined : Xt[b];\n        var D = i || 48;\n        var q = g === "fixed" ? "fixed-head" : "head";\n        var A;\n        if (j === "some") {\n            A = Gt;\n        } else if (j) {\n            A = Jt;\n        } else {\n            A = Yt;\n        }\n        var P = (0, t.useMemo)((function() {\n            return {\n                minWidth: D\n            };\n        }), [ D ]);\n        var _ = (0, t.useMemo)((function() {\n            return {\n                minWidth: i\n            };\n        }), [ i ]);\n        \n        return r().createElement(Mn, Kt({\n            ref: R,\n            "data-test": q,\n            $isFixed: g === "fixed",\n            $zIndex: I + Ut\n        }, h),  r().createElement(Lt, null, c &&  r().createElement(Ln, {\n            key: "drag_rows_head_cell",\n            "data-test": "drag-rows-head-cell",\n            align: "center",\n            resizable: false\n        }), m &&  r().createElement($n, {\n            key: "toggle_all",\n            resizable: false,\n            align: "center",\n            variant: "toggleAll",\n            truncate: false,\n            "data-test": "toggle-all"\n        },  r().createElement(kt, {\n            "aria-label": A,\n            onClick: m,\n            selected: j\n        })), d &&  r().createElement(Nn, {\n            key: "more_info_head_cell",\n            "data-test": "more-info-head-cell",\n            resizable: false,\n            variant: "info"\n        }), T, o.length > 0 &&  r().createElement(zn, {\n            key: "actions_head_cell",\n            "data-test": "actions-head-cell",\n            align: "right",\n            resizable: false,\n            width: D,\n            style: P,\n            variant: "actions"\n        }, o), o.length === 0 && i &&  r().createElement(zn, {\n            key: "actions_head_cell",\n            "data-test": "actions-head-cell",\n            align: "right",\n            resizable: false,\n            width: i,\n            style: _,\n            variant: "actions"\n        }, " ")));\n    }\n    Zt.propTypes = Ft;\n    Zt.splunkUiType = "Table.Head";\n    /* harmony default export */    const er = Zt;\n    // CONCATENATED MODULE: external "lodash/isFinite"\n    const nr = __webpack_require__(41694);\n    var tr =  e.n(nr);\n    // CONCATENATED MODULE: external "lodash/isFunction"\n    const rr = __webpack_require__(91573);\n    var or =  e.n(rr);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Popover"\n    const ir = __webpack_require__(57959);\n    var ar =  e.n(ir);\n    // CONCATENATED MODULE: external "@splunk/react-ui/useControlled"\n    const lr = __webpack_require__(91659);\n    var ur =  e.n(lr);\n    // CONCATENATED MODULE: ./src/Table/HeadDropdownCell.tsx\n    function sr() {\n        return sr = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, sr.apply(null, arguments);\n    }\n    function cr(e, n) {\n        return mr(e) || pr(e, n) || fr(e, n) || dr();\n    }\n    function dr() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function fr(e, n) {\n        if (e) {\n            if ("string" == typeof e) return vr(e, n);\n            var t = {}.toString.call(e).slice(8, -1);\n            return "Object" === t && e.constructor && (t = e.constructor.name), "Map" === t || "Set" === t ? Array.from(e) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? vr(e, n) : void 0;\n        }\n    }\n    function vr(e, n) {\n        (null == n || n > e.length) && (n = e.length);\n        for (var t = 0, r = Array(n); t < n; t++) {\n            r[t] = e[t];\n        }\n        return r;\n    }\n    function pr(e, n) {\n        var t = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != t) {\n            var r, o, i, a, l = [], u = !0, s = !1;\n            try {\n                if (i = (t = t.call(e)).next, 0 === n) {\n                    if (Object(t) !== t) return;\n                    u = !1;\n                } else for (;!(u = (r = i.call(t)).done) && (l.push(r.value), l.length !== n); u = !0) {\n                }\n            } catch (e) {\n                s = !0, o = e;\n            } finally {\n                try {\n                    if (!u && null != t["return"] && (a = t["return"](), Object(a) !== a)) return;\n                } finally {\n                    if (s) throw o;\n                }\n            }\n            return l;\n        }\n    }\n    function mr(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function br(e, n) {\n        if (null == e) return {};\n        var t, r, o = hr(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function hr(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    /** @public */\n    /** @public */\n    /** @public */    var yr = [ "clickAway", "contentClick", "escapeKey", "offScreen", "tabKey", "toggleClick" ];\n    var gr = {\n        align: w().oneOf([ "left", "center", "right" ]),\n        buttonRef: w().oneOfType([ w().func, w().object ]),\n        canCoverHead: w().bool,\n        children: w().node.isRequired,\n        closeReasons: w().arrayOf(w().oneOf(yr)),\n        columnId: w().string,\n        /** @private. */\n        dragId: w().oneOfType([ w().string, w().number ]),\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        headCellScreenReaderText: w().string,\n        focusToggleReasons: w().arrayOf(w().oneOf(yr)),\n        /** @private The index of the cell, skipping the info column. */\n        index: w().number,\n        label: w().node,\n        /** @private. */\n        onAutosizeColumn: w().func,\n        /**\n   * @private. This will be passed through, and will work as expected.\n   */\n        onKeyDown: w().func,\n        onRequestClose: w().func,\n        /** @private. */\n        onRequestMoveColumn: w().func,\n        onRequestOpen: w().func,\n        /** @private. */\n        onRequestResize: w().func,\n        open: w().bool,\n        repositionMode: w().oneOf([ "none", "flip", "any" ]),\n        resizable: w().bool,\n        retainFocus: w().bool,\n        takeFocus: w().bool,\n        truncate: w().bool,\n        /**\n   * @private\n   * Used internally to suppress focus when this `HeadDropdownCell` is superseded by one in an\n   * overlaid `HeadTable` for user interactions.\n   */\n        visible: w().bool,\n        width: w().number,\n        /** @private. */\n        variant: w().oneOf([ "toggleAll", "info", "actions" ])\n    };\n    var wr = [ "contentClick", "escapeKey", "toggleClick" ];\n    function Cr(e) {\n        var n;\n        var o = e.align, i = o === void 0 ? "left" : o, l = e.buttonRef, u = e.canCoverHead, s = u === void 0 ? true : u, c = e.children, d = e.closeReasons, f = d === void 0 ? yr : d, v = e.columnId, p = e.dragId, m = e.elementRef, b = e.headCellScreenReaderText, h = e.focusToggleReasons, y = h === void 0 ? wr : h, g = e.id, w = e.index, C = e.label, x = e.onAutosizeColumn, S = e.onKeyDown, O = e.onRequestClose, R = e.onRequestMoveColumn, E = e.onRequestOpen, D = e.onRequestResize, A = e.open, P = e.repositionMode, _ = P === void 0 ? "flip" : P, z = e.resizable, M = z === void 0 ? true : z, $ = e.retainFocus, L = e.style, W = e.takeFocus, H = W === void 0 ? true : W, K = e.truncate, B = K === void 0 ? true : K, V = e.variant, F = e.visible, U = F === void 0 ? true : F, X = e.width, Y = br(e, [ "align", "buttonRef", "canCoverHead", "children", "closeReasons", "columnId", "dragId", "elementRef", "headCellScreenReaderText", "focusToggleReasons", "id", "index", "label", "onAutosizeColumn", "onKeyDown", "onRequestClose", "onRequestMoveColumn", "onRequestOpen", "onRequestResize", "open", "repositionMode", "resizable", "retainFocus", "style", "takeFocus", "truncate", "variant", "visible", "width" ]);\n        // @docs-props-type HeadDropdownCellPropsBase\n                var G = ur()({\n            componentName: "HeadDropdownCell",\n            /* eslint-disable-next-line prefer-rest-params */\n            componentProps: arguments[0],\n            // see SUI-7028\n            valuePropName: "open"\n        });\n        var J = (0, t.useState)(), Q = cr(J, 2), Z = Q[0], ee = Q[1];\n        var ne = (0, t.useState)(null), te = cr(ne, 2), re = te[0], oe = te[1];\n        var ie = (0, t.useState)(null), ae = cr(ie, 2), le = ae[0], ue = ae[1];\n        var se = (0, t.useState)(false), ce = cr(se, 2), de = ce[0], fe = ce[1];\n        var ve = (0, j.createDOMID)("popover");\n        var pe = !!R;\n        var me = (0, a.useSortable)({\n            // dragId is optional in HeadCell but required by useSortable\n            // since it is always set in Table, use a type assertion here to avoid TypeScript error\n            id: p\n        }), be = me.attributes, he = me.listeners, ye = me.setNodeRef, ge = me.isDragging;\n        var we = (0, t.useMemo)((function() {\n            return G ? A : de;\n        }), [ G, de, A ]);\n        var Ce = k()(U);\n        var xe = (n = g !== null && g !== void 0 ? g : v) !== null && n !== void 0 ? n : (0, \n        j.createDOMID)("headCellId-");\n        (0, t.useEffect)((function() {\n            if (false) // removed by dead control flow\n{}\n        }), [ D, B ]);\n        var Se = (0, t.useCallback)((function(e) {\n            var n = e.reason, t = e.event;\n            if (n === "clickAway" && t !== undefined) {\n                var r = t.target;\n                while (r) {\n                    // Ignore clicks on toggle.\n                    if (r === le) {\n                        return;\n                    }\n                    r = r.parentNode;\n                }\n            }\n            if (we && q()(f, n) && w !== undefined) {\n                if (q()(y, n)) {\n                    le === null || le === void 0 ? void 0 : le.focus();\n                }\n                if (!G) {\n                    fe(false);\n                }\n                O === null || O === void 0 ? void 0 : O(t, {\n                    index: w,\n                    reason: n,\n                    columnId: v\n                });\n            }\n        }), [ f, v, y, w, le, G, we, O ]);\n        (0, t.useEffect)((function() {\n            if (Ce && !U) {\n                Se({\n                    reason: "offScreen"\n                });\n            }\n        }), [ Se, Ce, U ]);\n        var Oe = (0, t.useCallback)((function(e) {\n            N(m, e);\n            if (pe) {\n                ye(e);\n            }\n        }), [ pe, m, ye ]);\n        var ke = (0, t.useCallback)((function(e) {\n            ue(e);\n            oe(e);\n            N(l, e);\n        }), [ l ]);\n        var Ee = (0, t.useCallback)((function(e) {\n            e.stopPropagation();\n            // ignore clicks on the resize handle\n                        if (e.target.getAttribute("data-test") === "resize") {\n                return;\n            }\n            if (!we) {\n                ee(e.clientX || undefined);\n            }\n            if (we) {\n                Se === null || Se === void 0 ? void 0 : Se({\n                    reason: "toggleClick",\n                    event: e\n                });\n            } else if (w !== undefined) {\n                E === null || E === void 0 ? void 0 : E(e, {\n                    reason: "toggleClick",\n                    columnId: v,\n                    index: w\n                });\n                if (!G) {\n                    fe(true);\n                }\n            }\n        }), [ v, Se, w, G, we, E ]);\n        var Te = (0, t.useCallback)((function(e) {\n            if (w !== undefined) {\n                S === null || S === void 0 ? void 0 : S(e, {\n                    index: w,\n                    columnId: v\n                });\n            }\n        }), [ v, w, S ]);\n        var je = (0, t.useCallback)((function(e) {\n            Se({\n                reason: "contentClick",\n                event: e\n            });\n        }), [ Se ]);\n        var De = (0, t.useMemo)((function() {\n            if (Z !== undefined && tr()(Z)) {\n                var e;\n                return {\n                    x: Z - ((e = re === null || re === void 0 ? void 0 : re.getBoundingClientRect().left) !== null && e !== void 0 ? e : 0)\n                };\n            }\n            return undefined;\n        }), [ Z, re ]);\n        var qe = (0, t.useMemo)((function() {\n            return Re()({}, L, {\n                width: X\n            });\n        }), [ L, X ]);\n        var Ae;\n        if (b) {\n            Ae = b;\n        } else if (typeof C === "string") {\n            Ae = C;\n        }\n        \n        return r().createElement(Ke, sr({\n            style: qe,\n            "data-test": "head-cell",\n            $isDragging: pe && ge,\n            $variant: V,\n            id: U ? xe : undefined,\n            ref: Oe\n        }, Y),  r().createElement(He, null, pe &&  r().createElement(Ve, sr({\n            "aria-label": (0, I.sprintf)((0, T._)("Reorder %(labelString)s"), {\n                labelString: Ae\n            }),\n            "data-test": "drag"\n        }, be, he),  r().createElement(Be, null,  r().createElement(Ie(), null))),  r().createElement(Tn, {\n            align: i,\n            "aria-expanded": we,\n            "aria-haspopup": true,\n            "aria-owns": ve,\n            clickable: true,\n            columnId: v,\n            elementRef: ke,\n            cellId: xe,\n            index: w,\n            isMenu: true,\n            label: C,\n            resizable: U && M,\n            onAutosizeColumn: x,\n            onRequestResize: D,\n            onClick: Ee,\n            onKeyDown: Te,\n            truncate: B,\n            width: X,\n            "data-test": "inner"\n        }),  r().createElement(ar(), {\n            align: "center",\n            anchor: re,\n            "aria-labelledby": xe,\n            autoCloseWhenOffScreen: q()(f, "offScreen"),\n            canCoverAnchor: s,\n            defaultPlacement: "below",\n            id: ve,\n            onRequestClose: Se,\n            open: !!re && we,\n            pointTo: De,\n            repositionMode: _,\n            retainFocus: $,\n            takeFocus: H\n        }, or()(c) ? function() {\n            \n            // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions\n            return r().createElement("div", {\n                onClick: je\n            }, c.apply(void 0, arguments));\n        } : \n        \n        // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions\n        r().createElement("div", {\n            onClick: je\n        }, c))));\n    }\n    Cr.propTypes = gr;\n    Cr.splunkUiType = "Table.HeadDropdownCell";\n    Cr.possibleCloseReasons = yr;\n    /* harmony default export */    const xr = Cr;\n    // CONCATENATED MODULE: external "lodash/extend"\n    const Sr = __webpack_require__(18873);\n    var Or =  e.n(Sr);\n    // CONCATENATED MODULE: ./src/Table/HeadTableStyles.ts\n    var kr = z()(ee).withConfig({\n        displayName: "HeadTableStyles__Styled",\n        componentId: "g85wgf-0"\n    })([ "min-width:0;table-layout:fixed;" ]);\n    var Rr = z().div.withConfig({\n        displayName: "HeadTableStyles__StyledDockedContainer",\n        componentId: "g85wgf-1"\n    })([ "overflow:hidden;position:fixed;z-index:", ";@media print{display:none;}" ], M.variables.zindexFixedNavbar);\n    var Er = z()(Rr).withConfig({\n        displayName: "HeadTableStyles__StyledFixedContainer",\n        componentId: "g85wgf-2"\n    })([ "position:absolute;box-shadow:none;z-index:1;" ]);\n    // CONCATENATED MODULE: ./src/Table/HeadTable.tsx\n    function Ir() {\n        return Ir = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, Ir.apply(null, arguments);\n    }\n    function Tr(e, n) {\n        if (null == e) return {};\n        var t, r, o = jr(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function jr(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    var Dr = {\n        cellWidths: w().arrayOf(w().number).isRequired,\n        dragIndex: w().number,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        hasDragColumn: w().bool,\n        hasRowExpansion: w().bool,\n        hasRowSelection: w().bool,\n        headType: w().oneOf([ "docked", "fixed" ]).isRequired,\n        horizontalOffset: w().number,\n        isFixedColumn: w().bool,\n        rowSelection: w().oneOf([ "all", "some", "none" ]),\n        tableStyle: w().object,\n        tableWidth: w().number.isRequired,\n        tHead: w().element.isRequired,\n        top: w().number.isRequired,\n        width: w().number.isRequired\n    };\n    /**\n * @private\n * HeadTable is an internal component that provides a detached table head that can\n * then be positioned in different ways outside of the main table.\n */    function qr(e) {\n        var n = e.cellWidths, o = e.elementRef, i = e.hasDragColumn, a = e.hasRowExpansion, l = e.hasRowSelection, u = e.headType, s = e.horizontalOffset, c = s === void 0 ? 0 : s, d = e.isFixedColumn, f = e.tableStyle, v = e.tableWidth, p = e.tHead, m = e.top, h = e.width, y = Tr(e, [ "cellWidths", "elementRef", "hasDragColumn", "hasRowExpansion", "hasRowSelection", "headType", "horizontalOffset", "isFixedColumn", "tableStyle", "tableWidth", "tHead", "top", "width" ]);\n        // @docs-props-type HeadTablePropsBase\n                var g = u === "docked";\n        var w = g ? Rr : Er;\n        var C = (0, t.useRef)(null);\n        var x = (0, t.useCallback)((function(e) {\n            N(C, e);\n        }), [ C ]);\n        var S = 0;\n        if (a) {\n            S += 1;\n        }\n        if (l) {\n            S += 1;\n        }\n        if (i) {\n            S += 1;\n        }\n        // Set the widths of the head cells if not fixed column\n                var O = (0, t.useMemo)((function() {\n            return t.Children.toArray(p.props.children);\n        }), [ p.props.children ]);\n        var k = (0, t.useMemo)((function() {\n            if (d) {\n                // ensure consistent keys\n                return O;\n            }\n            return O.filter(t.isValidElement).map((function(e, r) {\n                \n                return (0, t.cloneElement)(e, {\n                    style: Or()({}, e.props.style, {\n                        width: n[r + S]\n                    })\n                });\n            }));\n        }), [ n, S, d, O ]);\n        var R =  (0, t.cloneElement)(p, {\n            elementRef: x,\n            "data-test": "".concat(u, "-head")\n        }, k);\n        var E = (0, t.useMemo)((function() {\n            return {\n                top: m,\n                width: h\n            };\n        }), [ m, h ]);\n        \n        return r().createElement(w, {\n            style: E,\n            ref: o\n        },  r().createElement(kr, Ir({\n            "data-test": "".concat(u, "-head-table"),\n            "data-fixed-column": d ? "true" : undefined,\n            style: Or()({}, f, {\n                marginLeft: c,\n                width: d ? undefined : v\n            })\n        }, b()(y, "dragIndex")), R));\n    }\n    qr.propTypes = Dr;\n    /* harmony default export */    const Ar = qr;\n    // CONCATENATED MODULE: ./src/Table/KeyboardSensor.ts\n    function Pr(e) {\n        "@babel/helpers - typeof";\n        return Pr = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {\n            return typeof e;\n        } : function(e) {\n            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;\n        }, Pr(e);\n    }\n    function _r(e, n) {\n        return $r(e) || Mr(e, n) || Wr(e, n) || zr();\n    }\n    function zr() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function Mr(e, n) {\n        var t = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != t) {\n            var r, o, i, a, l = [], u = !0, s = !1;\n            try {\n                if (i = (t = t.call(e)).next, 0 === n) {\n                    if (Object(t) !== t) return;\n                    u = !1;\n                } else for (;!(u = (r = i.call(t)).done) && (l.push(r.value), l.length !== n); u = !0) {\n                }\n            } catch (e) {\n                s = !0, o = e;\n            } finally {\n                try {\n                    if (!u && null != t["return"] && (a = t["return"](), Object(a) !== a)) return;\n                } finally {\n                    if (s) throw o;\n                }\n            }\n            return l;\n        }\n    }\n    function $r(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function Nr(e) {\n        return Kr(e) || Hr(e) || Wr(e) || Lr();\n    }\n    function Lr() {\n        throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function Wr(e, n) {\n        if (e) {\n            if ("string" == typeof e) return Br(e, n);\n            var t = {}.toString.call(e).slice(8, -1);\n            return "Object" === t && e.constructor && (t = e.constructor.name), "Map" === t || "Set" === t ? Array.from(e) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? Br(e, n) : void 0;\n        }\n    }\n    function Hr(e) {\n        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) return Array.from(e);\n    }\n    function Kr(e) {\n        if (Array.isArray(e)) return Br(e);\n    }\n    function Br(e, n) {\n        (null == n || n > e.length) && (n = e.length);\n        for (var t = 0, r = Array(n); t < n; t++) {\n            r[t] = e[t];\n        }\n        return r;\n    }\n    function Vr(e, n) {\n        if (!(e instanceof n)) throw new TypeError("Cannot call a class as a function");\n    }\n    function Fr(e, n) {\n        for (var t = 0; t < n.length; t++) {\n            var r = n[t];\n            r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), \n            Object.defineProperty(e, Yr(r.key), r);\n        }\n    }\n    function Ur(e, n, t) {\n        return n && Fr(e.prototype, n), t && Fr(e, t), Object.defineProperty(e, "prototype", {\n            writable: !1\n        }), e;\n    }\n    function Xr(e, n, t) {\n        return (n = Yr(n)) in e ? Object.defineProperty(e, n, {\n            value: t,\n            enumerable: !0,\n            configurable: !0,\n            writable: !0\n        }) : e[n] = t, e;\n    }\n    function Yr(e) {\n        var n = Gr(e, "string");\n        return "symbol" == Pr(n) ? n : n + "";\n    }\n    function Gr(e, n) {\n        if ("object" != Pr(e) || !e) return e;\n        var t = e[Symbol.toPrimitive];\n        if (void 0 !== t) {\n            var r = t.call(e, n || "default");\n            if ("object" != Pr(r)) return r;\n            throw new TypeError("@@toPrimitive must return a primitive value.");\n        }\n        return ("string" === n ? String : Number)(e);\n    }\n    // based on https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/sensors/keyboard/KeyboardSensor.ts\n    // eslint-disable-next-line max-classes-per-file\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/sensors/utilities/Listeners.ts\n        var Jr =  function() {\n        function e(n) {\n            var t = this;\n            Vr(this, e);\n            Xr(this, "listeners", []);\n            Xr(this, "removeAll", (function() {\n                t.listeners.forEach((function(e) {\n                    var n;\n                    return (n = t.target) === null || n === void 0 ? void 0 : n.removeEventListener.apply(n, Nr(e));\n                }));\n            }));\n            this.target = n;\n            this.target = n;\n        }\n        Ur(e, [ {\n            key: "add",\n            value: function e(n, t, r) {\n                var o;\n                (o = this.target) === null || o === void 0 ? void 0 : o.addEventListener(n, t, r);\n                this.listeners.push([ n, t, r ]);\n            }\n        } ]);\n        return e;\n    }();\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/transform/parseTransform.ts\n        function Qr(e) {\n        if (e.startsWith("matrix3d(")) {\n            var n = e.slice(9, -1).split(/, /);\n            return {\n                x: +n[12],\n                y: +n[13],\n                scaleX: +n[0],\n                scaleY: +n[5]\n            };\n        }\n        if (e.startsWith("matrix(")) {\n            var t = e.slice(7, -1).split(/, /);\n            return {\n                x: +t[4],\n                y: +t[5],\n                scaleX: +t[0],\n                scaleY: +t[3]\n            };\n        }\n        return null;\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/transform/inverseTransform.ts\n        function Zr(e, n, t) {\n        var r = Qr(n);\n        if (!r) {\n            return e;\n        }\n        var o = r.scaleX, i = r.scaleY, a = r.x, l = r.y;\n        var u = e.left - a - (1 - o) * parseFloat(t);\n        var s = e.top - l - (1 - i) * parseFloat(t.slice(t.indexOf(" ") + 1));\n        var c = o ? e.width / o : e.width;\n        var d = i ? e.height / i : e.height;\n        return {\n            width: c,\n            height: d,\n            top: s,\n            right: u + c,\n            bottom: s + d,\n            left: u\n        };\n    }\n    var eo = {\n        ignoreTransform: false\n    };\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/rect/getRect.ts\n        function no(e) {\n        var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : eo;\n        var t = e.getBoundingClientRect();\n        if (n.ignoreTransform) {\n            var r = (0, Wn.getWindow)(e).getComputedStyle(e), o = r.transform, i = r.transformOrigin;\n            if (o) {\n                t = Zr(t, o, i);\n            }\n        }\n        var a = t, l = a.top, u = a.left, s = a.width, c = a.height, d = a.bottom, f = a.right;\n        return {\n            top: l,\n            left: u,\n            width: s,\n            height: c,\n            bottom: d,\n            right: f\n        };\n    }\n    function to(e) {\n        if (e === document.scrollingElement) {\n            var n = window, t = n.innerWidth, r = n.innerHeight;\n            return {\n                top: 0,\n                left: 0,\n                right: t,\n                bottom: r,\n                width: t,\n                height: r\n            };\n        }\n        var o = e.getBoundingClientRect(), i = o.top, a = o.left, l = o.right, u = o.bottom;\n        return {\n            top: i,\n            left: a,\n            right: l,\n            bottom: u,\n            width: e.clientWidth,\n            height: e.clientHeight\n        };\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/documentScrollingElement.ts\n        function ro(e) {\n        if (!Wn.canUseDOM || !e) {\n            return false;\n        }\n        return e === document.scrollingElement;\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/getScrollPosition.ts\n        function oo(e) {\n        var n = {\n            x: 0,\n            y: 0\n        };\n        var t = ro(e) ? {\n            height: window.innerHeight,\n            width: window.innerWidth\n        } : {\n            height: e.clientHeight,\n            width: e.clientWidth\n        };\n        var r = {\n            x: e.scrollWidth - t.width,\n            y: e.scrollHeight - t.height\n        };\n        var o = e.scrollTop <= n.y;\n        var i = e.scrollLeft <= n.x;\n        var a = e.scrollTop >= r.y;\n        var l = e.scrollLeft >= r.x;\n        return {\n            isTop: o,\n            isLeft: i,\n            isBottom: a,\n            isRight: l,\n            maxScroll: r,\n            minScroll: n\n        };\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/coordinates/constants.ts\n        var io = {\n        x: 0,\n        y: 0\n    };\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/isFixed.ts\n        function ao(e) {\n        var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, \n        Wn.getWindow)(e).getComputedStyle(e);\n        return n.position === "fixed";\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/isScrollable.ts\n        function lo(e) {\n        var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, \n        Wn.getWindow)(e).getComputedStyle(e);\n        var t = /(auto|scroll|overlay)/;\n        var r = [ "overflow", "overflowX", "overflowY" ];\n        return r.some((function(e) {\n            var r = n[e];\n            return typeof r === "string" ? t.test(r) : false;\n        }));\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/getScrollableAncestors.ts\n        function uo(e, n) {\n        var t = [];\n        function r(o) {\n            if (n != null && t.length >= n) {\n                return t;\n            }\n            if (!o) {\n                return t;\n            }\n            if ((0, Wn.isDocument)(o) && o.scrollingElement != null && !t.includes(o.scrollingElement)) {\n                t.push(o.scrollingElement);\n                return t;\n            }\n            if (!(0, Wn.isHTMLElement)(o) || (0, Wn.isSVGElement)(o)) {\n                return t;\n            }\n            if (t.includes(o)) {\n                return t;\n            }\n            var i = (0, Wn.getWindow)(e).getComputedStyle(o);\n            if (o !== e) {\n                if (lo(o, i)) {\n                    t.push(o);\n                }\n            }\n            if (ao(o, i)) {\n                return t;\n            }\n            return r(o.parentNode);\n        }\n        if (!e) {\n            return t;\n        }\n        return r(e);\n    }\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/getScrollableAncestors.ts\n        function so(e) {\n        var n = uo(e, 1), t = _r(n, 1), r = t[0];\n        return r !== null && r !== void 0 ? r : null;\n    }\n    var co = {\n        start: [ o.KeyboardCode.Space, o.KeyboardCode.Enter ],\n        cancel: [ o.KeyboardCode.Esc ],\n        end: [ o.KeyboardCode.Space, o.KeyboardCode.Enter ]\n    };\n    // https://github.com/clauderic/dnd-kit/blob/694dcc2f62e5269541fc941fa6c9af46ccd682ad/packages/core/src/utilities/scroll/scrollIntoViewIfNeeded.ts\n        function fo(e) {\n        var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : no;\n        if (!e) {\n            return;\n        }\n        var t = n(e), r = t.top, o = t.left, i = t.bottom, a = t.right;\n        var l = so(e);\n        if (!l) {\n            return;\n        }\n        if (i <= 0 || a <= 0 || r >= window.innerHeight || o >= window.innerWidth) {\n            e.scrollIntoView({\n                block: "center",\n                inline: "center"\n            });\n        }\n    }\n    var vo =  function() {\n        function e(n) {\n            Vr(this, e);\n            Xr(this, "autoScrollEnabled", false);\n            Xr(this, "referenceCoordinates", void 0);\n            Xr(this, "listeners", void 0);\n            Xr(this, "windowListeners", void 0);\n            this.props = n;\n            var t = n.event.target;\n            this.props = n;\n            this.listeners = new Jr((0, Wn.getOwnerDocument)(t));\n            this.windowListeners = new Jr((0, Wn.getWindow)(t));\n            this.handleKeyDown = this.handleKeyDown.bind(this);\n            this.handleCancel = this.handleCancel.bind(this);\n            this.attach();\n        }\n        Ur(e, [ {\n            key: "attach",\n            value: function e() {\n                var n = this;\n                this.handleStart();\n                this.windowListeners.add("resize", this.handleCancel);\n                this.windowListeners.add("visibilitychange", this.handleCancel);\n                setTimeout((function() {\n                    return n.listeners.add("keydown", n.handleKeyDown);\n                }));\n            }\n        }, {\n            key: "handleStart",\n            value: function e() {\n                var n = this.props, t = n.activeNode, r = n.onStart;\n                var o = t.node.current;\n                if (o) {\n                    fo(o);\n                }\n                r(io);\n            }\n        }, {\n            key: "handleKeyDown",\n            value: function e(n) {\n                if ((0, Wn.isKeyboardEvent)(n)) {\n                    var t = this.props, r = t.active, i = t.context, a = t.options;\n                    var l = a.keyboardCodes, u = l === void 0 ? co : l, s = a.coordinateGetter, c = a.scrollBehavior, d = c === void 0 ? "smooth" : c;\n                    var f = n.code;\n                    if (u.end.includes(f)) {\n                        this.handleEnd(n);\n                        return;\n                    }\n                    if (u.cancel.includes(f)) {\n                        this.handleCancel(n);\n                        return;\n                    }\n                    var v = i.current.collisionRect;\n                    var p = v ? {\n                        x: v.left,\n                        y: v.top\n                    } : io;\n                    if (!this.referenceCoordinates) {\n                        this.referenceCoordinates = p;\n                    }\n                    var m = s(n, {\n                        active: r,\n                        context: i.current,\n                        currentCoordinates: p\n                    });\n                    if (m) {\n                        var b = (0, Wn.subtract)(m, p);\n                        var h = {\n                            x: 0,\n                            y: 0\n                        };\n                        var y = i.current.scrollableAncestors;\n                        for (var g = 0; g < y.length; g += 1) {\n                            var w = y[g];\n                            var C = n.code;\n                            var x = oo(w), S = x.isTop, O = x.isRight, k = x.isLeft, R = x.isBottom, E = x.maxScroll, I = x.minScroll;\n                            var T = to(w);\n                            // isDraggableNodeVerticallyInView and isDraggableNodeHorizontallyInView are custom\n                            // we want to scroll only when a dragging node will be out of view,\n                            // originally it tries to always place a dragging node in the middle of the container\n                                                        var j = T.top <= m.y && T.bottom >= m.y + ((v === null || v === void 0 ? void 0 : v.height) || 0);\n                            var D = T.left <= m.x && T.right >= m.x + ((v === null || v === void 0 ? void 0 : v.width) || 0);\n                            var q = (C === o.KeyboardCode.Right && !O || C === o.KeyboardCode.Left && !k) && !D;\n                            var A = (C === o.KeyboardCode.Down && !R || C === o.KeyboardCode.Up && !S) && !j;\n                            if (q) {\n                                var P = w.scrollLeft + b.x;\n                                var _ = C === o.KeyboardCode.Right && P <= E.x || C === o.KeyboardCode.Left && P >= I.x;\n                                if (_ && !b.y) {\n                                    // We don\'t need to update coordinates, the scroll adjustment alone will trigger\n                                    // logic to auto-detect the new container we are over\n                                    w.scrollTo({\n                                        left: P,\n                                        behavior: d\n                                    });\n                                    return;\n                                }\n                                if (_) {\n                                    h.x = w.scrollLeft - P;\n                                } else {\n                                    h.x = C === o.KeyboardCode.Right ? w.scrollLeft - E.x : w.scrollLeft - I.x;\n                                }\n                                if (h.x) {\n                                    w.scrollBy({\n                                        left: -h.x,\n                                        behavior: d\n                                    });\n                                }\n                                break;\n                            } else if (A) {\n                                var z = w.scrollTop + b.y;\n                                var M = C === o.KeyboardCode.Down && z <= E.y || C === o.KeyboardCode.Up && z >= I.y;\n                                if (M && !b.x) {\n                                    // We don\'t need to update coordinates, the scroll adjustment alone will trigger\n                                    // logic to auto-detect the new container we are over\n                                    w.scrollTo({\n                                        top: z,\n                                        behavior: d\n                                    });\n                                    return;\n                                }\n                                if (M) {\n                                    h.y = w.scrollTop - z;\n                                } else {\n                                    h.y = C === o.KeyboardCode.Down ? w.scrollTop - E.y : w.scrollTop - I.y;\n                                }\n                                if (h.y) {\n                                    w.scrollBy({\n                                        top: -h.y,\n                                        behavior: d\n                                    });\n                                }\n                                break;\n                            }\n                        }\n                        this.handleMove(n, (0, Wn.add)((0, Wn.subtract)(m, this.referenceCoordinates), h));\n                    }\n                }\n            }\n        }, {\n            key: "handleMove",\n            value: function e(n, t) {\n                var r = this.props.onMove;\n                n.preventDefault();\n                r(t);\n            }\n        }, {\n            key: "handleEnd",\n            value: function e(n) {\n                var t = this.props.onEnd;\n                n.preventDefault();\n                this.detach();\n                t();\n            }\n        }, {\n            key: "handleCancel",\n            value: function e(n) {\n                var t = this.props.onCancel;\n                n.preventDefault();\n                this.detach();\n                t();\n            }\n        }, {\n            key: "detach",\n            value: function e() {\n                this.listeners.removeAll();\n                this.windowListeners.removeAll();\n            }\n        } ]);\n        return e;\n    }();\n    Xr(vo, "activators", [ {\n        eventName: "onKeyDown",\n        handler: function e(n, t, r) {\n            var o = t.keyboardCodes, i = o === void 0 ? co : o, a = t.onActivation;\n            var l = r.active;\n            var u = n.nativeEvent.code;\n            if (i.start.includes(u)) {\n                var s = l.activatorNode.current;\n                if (s && n.target !== s) {\n                    return false;\n                }\n                n.preventDefault();\n                a === null || a === void 0 ? void 0 : a({\n                    event: n.nativeEvent\n                });\n                return true;\n            }\n            return false;\n        }\n    } ]);\n    // CONCATENATED MODULE: ./src/utils/getBoundingClientRect.ts\n    function po(e) {\n        "@babel/helpers - typeof";\n        return po = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {\n            return typeof e;\n        } : function(e) {\n            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;\n        }, po(e);\n    }\n    function mo(e, n) {\n        var t = Object.keys(e);\n        if (Object.getOwnPropertySymbols) {\n            var r = Object.getOwnPropertySymbols(e);\n            n && (r = r.filter((function(n) {\n                return Object.getOwnPropertyDescriptor(e, n).enumerable;\n            }))), t.push.apply(t, r);\n        }\n        return t;\n    }\n    function bo(e) {\n        for (var n = 1; n < arguments.length; n++) {\n            var t = null != arguments[n] ? arguments[n] : {};\n            n % 2 ? mo(Object(t), !0).forEach((function(n) {\n                ho(e, n, t[n]);\n            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : mo(Object(t)).forEach((function(n) {\n                Object.defineProperty(e, n, Object.getOwnPropertyDescriptor(t, n));\n            }));\n        }\n        return e;\n    }\n    function ho(e, n, t) {\n        return (n = yo(n)) in e ? Object.defineProperty(e, n, {\n            value: t,\n            enumerable: !0,\n            configurable: !0,\n            writable: !0\n        }) : e[n] = t, e;\n    }\n    function yo(e) {\n        var n = go(e, "string");\n        return "symbol" == po(n) ? n : n + "";\n    }\n    function go(e, n) {\n        if ("object" != po(e) || !e) return e;\n        var t = e[Symbol.toPrimitive];\n        if (void 0 !== t) {\n            var r = t.call(e, n || "default");\n            if ("object" != po(r)) return r;\n            throw new TypeError("@@toPrimitive must return a primitive value.");\n        }\n        return ("string" === n ? String : Number)(e);\n    }\n    // Checks if browser is Safari\n        function wo() {\n        return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);\n    }\n    // Formats return value to DOMRect\n        function Co(e) {\n        return bo(bo({}, e), {}, {\n            top: e.y,\n            left: e.x,\n            right: e.x + e.width,\n            bottom: e.y + e.height\n        });\n    }\n    /**\n * Provides DOMRect information about the size of an element and its position relative to the viewport.\n * Accounts for Safari\'s use of visual viewport and adds offsets to set as layout viewport.\n * @param {Element} element - The element to be evaluated\n * @param {boolean} offsets - Use when position of element relative to the layout viewport offsets are needed for Safari.\n * @returns {Omit<DOMRect, \'toJSON\'>}\n * @public\n */    function xo(e, n) {\n        var t, r;\n        var o = e.getBoundingClientRect();\n        var i = wo();\n        if (!n || !i) {\n            return o;\n        }\n        var a = un();\n        var l = o.left + (((t = a.visualViewport) === null || t === void 0 ? void 0 : t.offsetLeft) || 0);\n        var u = o.top + (((r = a.visualViewport) === null || r === void 0 ? void 0 : r.offsetTop) || 0);\n        var s = o.width, c = o.height;\n        return Co({\n            width: s,\n            height: c,\n            x: l,\n            y: u\n        });\n    }\n    // CONCATENATED MODULE: ./src/utils/types.ts\n    // see https://github.com/DefinitelyTyped/DefinitelyTyped/issues/31245 for details\n    // regarding the css prop. certain (versions of) libraries included in the compilation\n    // - such as storybook->emotion - introduce the css prop using a global augmentation,\n    // which causes the prop to end up in our declaration files (via JSX.IntrinsicElements).\n    // it\'s difficult to control all nested dependencies and their types, which is why the\n    // css prop is omitted in the two prop helpers above - this ensures the css prop isn\'t\n    // erroneously included in react-ui\'s public api.\n    // see https://github.com/microsoft/TypeScript/pull/12253\n    // see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-3-7.html\n    function So(e, n) {\n        if (e === undefined || e === null) {\n            throw new Error(n !== null && n !== void 0 ? n : "Unexpected undefined or null");\n        }\n    }\n    // CONCATENATED MODULE: ./src/Table/Table.tsx\n    function Oo() {\n        return Oo = Object.assign ? Object.assign.bind() : function(e) {\n            for (var n = 1; n < arguments.length; n++) {\n                var t = arguments[n];\n                for (var r in t) {\n                    ({}).hasOwnProperty.call(t, r) && (e[r] = t[r]);\n                }\n            }\n            return e;\n        }, Oo.apply(null, arguments);\n    }\n    function ko(e) {\n        return Io(e) || Eo(e) || Do(e) || Ro();\n    }\n    function Ro() {\n        throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function Eo(e) {\n        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) return Array.from(e);\n    }\n    function Io(e) {\n        if (Array.isArray(e)) return qo(e);\n    }\n    function To(e, n) {\n        return Po(e) || Ao(e, n) || Do(e, n) || jo();\n    }\n    function jo() {\n        throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n    }\n    function Do(e, n) {\n        if (e) {\n            if ("string" == typeof e) return qo(e, n);\n            var t = {}.toString.call(e).slice(8, -1);\n            return "Object" === t && e.constructor && (t = e.constructor.name), "Map" === t || "Set" === t ? Array.from(e) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? qo(e, n) : void 0;\n        }\n    }\n    function qo(e, n) {\n        (null == n || n > e.length) && (n = e.length);\n        for (var t = 0, r = Array(n); t < n; t++) {\n            r[t] = e[t];\n        }\n        return r;\n    }\n    function Ao(e, n) {\n        var t = null == e ? null : "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];\n        if (null != t) {\n            var r, o, i, a, l = [], u = !0, s = !1;\n            try {\n                if (i = (t = t.call(e)).next, 0 === n) {\n                    if (Object(t) !== t) return;\n                    u = !1;\n                } else for (;!(u = (r = i.call(t)).done) && (l.push(r.value), l.length !== n); u = !0) {\n                }\n            } catch (e) {\n                s = !0, o = e;\n            } finally {\n                try {\n                    if (!u && null != t["return"] && (a = t["return"](), Object(a) !== a)) return;\n                } finally {\n                    if (s) throw o;\n                }\n            }\n            return l;\n        }\n    }\n    function Po(e) {\n        if (Array.isArray(e)) return e;\n    }\n    function _o(e, n) {\n        if (null == e) return {};\n        var t, r, o = zo(e, n);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (r = 0; r < i.length; r++) {\n                t = i[r], -1 === n.indexOf(t) && {}.propertyIsEnumerable.call(e, t) && (o[t] = e[t]);\n            }\n        }\n        return o;\n    }\n    function zo(e, n) {\n        if (null == e) return {};\n        var t = {};\n        for (var r in e) {\n            if ({}.hasOwnProperty.call(e, r)) {\n                if (-1 !== n.indexOf(r)) continue;\n                t[r] = e[r];\n            }\n        }\n        return t;\n    }\n    // Exposed as static members of the Table class\n    // Internal Helper Modules\n    /** @public */\n    /** @public */\n    /** @public */    var Mo = {\n        actions: w().arrayOf(w().element),\n        actionsColumnWidth: w().number,\n        children: w().node,\n        dockOffset: w().number,\n        dockScrollBar: w().bool,\n        elementRef: w().oneOfType([ w().func, w().object ]),\n        headType: w().oneOf([ "docked", "fixed", "inline" ]),\n        innerStyle: w().object,\n        onRequestToggleAllRows: w().func,\n        onScroll: w().func,\n        outerStyle: w().object,\n        primaryColumnIndex: w().number,\n        rowExpansion: w().oneOf([ "single", "multi", "controlled", "none" ]),\n        rowSelection: w().oneOf([ "all", "some", "none" ]),\n        stripeRows: w().bool,\n        tableStyle: w().object,\n        onRequestMoveColumn: w().func,\n        onRequestMoveRow: w().func,\n        onRequestResizeColumn: w().func,\n        resizableFillLayout: w().bool\n    };\n    var $o = function e(n) {\n        return n === "inline";\n    };\n    var No = function e(n) {\n        return n === "docked";\n    };\n    var Lo = function e(n) {\n        return n === "fixed";\n    };\n    var Wo = function e(n) {\n        var t = un();\n        var r = xo(n);\n        return {\n            top: r.top + t.pageYOffset,\n            left: r.left + t.pageXOffset\n        };\n    };\n    var Ho = function e(n) {\n        var t = rn();\n        if (n === undefined || n === null) {\n            return undefined;\n        }\n        var r = n.children[0].children;\n        var o = d()(r, t.activeElement);\n        if (o > -1) {\n            return {\n                target: "headCell",\n                index: o\n            };\n        }\n        var i = n.querySelectorAll("[data-test=resize]");\n        var a = d()(i, t.activeElement);\n        if (a > -1) {\n            return {\n                target: "resizeButton",\n                index: a\n            };\n        }\n        return undefined;\n    };\n    var Ko = function e(n, t) {\n        return n.indexOf(t) + 1;\n    };\n    var Bo = function e(n, t) {\n        return n.indexOf(t) + 1;\n    };\n    var Vo = {\n        coordinateGetter: a.sortableKeyboardCoordinates\n    };\n    var Fo = {\n        draggable: (0, T._)("To pick up a sortable row, press space or enter.\\n            Use the up and down arrow keys to update the position of the row.\\n            Press space or enter again to drop the row in its new position, or press escape to cancel.")\n    };\n    var Uo = {\n        draggable: (0, T._)("To pick up a sortable column, press space or enter.\\n            Use the left and right arrow keys to update the position of the column.\\n            Press space or enter again to drop the column in its new position, or press escape to cancel.")\n    };\n    /**\n * @private\n * @private\n * Applies the provided `headFocusState` to the provided `head`.\n * @param head - A reference to a mounted `Head` component.\n * @param {Object} headFocusState\n * @param {String} headFocusState.target - Focus can be applied to a \'headCell\' or a\n * \'resizeButton\'.\n * @param {Number} headFocusState.index - The index of the element to set focus on.\n */    function Xo(e, n) {\n        var t, r;\n        var o = n.target, i = n.index;\n        if (false) // removed by dead control flow\n{}\n        var a;\n        if (o === "headCell") {\n            a = e === null || e === void 0 ? void 0 : e.children[0].children[i];\n        } else if (o === "resizeButton") {\n            a = e === null || e === void 0 ? void 0 : e.querySelectorAll("[data-test=resize]")[i];\n        }\n        if (false) // removed by dead control flow\n{}\n        (t = a) === null || t === void 0 ? void 0 : (r = t.focus) === null || r === void 0 ? void 0 : r.call(t);\n    }\n    var Yo = {\n        passive: false,\n        capture: true\n    };\n    var Go = [];\n    function Jo(e) {\n        var n = e.actions, l = n === void 0 ? Go : n, s = e.actionsColumnWidth, c = e.children, d = e.dockOffset, f = d === void 0 ? 0 : d, p = e.dockScrollBar, m = e.elementRef, h = e.headType, g = h === void 0 ? "inline" : h, w = e.innerStyle, C = e.onRequestMoveColumn, O = e.onRequestMoveRow, R = e.onRequestResizeColumn, D = e.onRequestToggleAllRows, q = e.onScroll, A = e.outerStyle, P = e.primaryColumnIndex, _ = P === void 0 ? 0 : P, z = e.resizableFillLayout, M = e.rowExpansion, $ = M === void 0 ? "none" : M, L = e.rowSelection, W = L === void 0 ? "none" : L, H = e.stripeRows, K = e.tableStyle, B = _o(e, [ "actions", "actionsColumnWidth", "children", "dockOffset", "dockScrollBar", "elementRef", "headType", "innerStyle", "onRequestMoveColumn", "onRequestMoveRow", "onRequestResizeColumn", "onRequestToggleAllRows", "onScroll", "outerStyle", "primaryColumnIndex", "resizableFillLayout", "rowExpansion", "rowSelection", "stripeRows", "tableStyle" ]);\n // @docs-props-type TablePropsBase\n                var V = (0, t.useState)([]), F = To(V, 2), U = F[0], X = F[1];\n        var Y = (0, t.useState)(), G = To(Y, 2), J = G[0], re = G[1];\n        var ae = (0, t.useState)(), le = To(ae, 2), ue = le[0], se = le[1];\n        var ce = (0, t.useState)(), de = To(ce, 2), fe = de[0], ve = de[1];\n        var pe = (0, t.useState)(), me = To(pe, 2), be = me[0], he = me[1];\n        var ye = (0, t.useRef)(true);\n        var ge = (0, t.useContext)(S.ScrollContainerContext);\n        var we = (0, o.useSensors)((0, o.useSensor)(o.MouseSensor, {}), (0, o.useSensor)(o.TouchSensor, {}), (0, \n        o.useSensor)(vo, Vo));\n        var Ce = (0, t.useState)([]), xe = To(Ce, 2), Se = xe[0], Oe = xe[1];\n        var ke = (0, t.useState)(-1), Re = To(ke, 2), Ee = Re[0], Ie = Re[1];\n        var Te = (0, t.useRef)();\n        var je = (0, t.useRef)();\n        var De = (0, t.useState)(), qe = To(De, 2), Ae = qe[0], Pe = qe[1];\n        var _e = (0, t.useRef)(null);\n        var ze = (0, t.useRef)(null);\n        var Me = (0, t.useRef)();\n        var $e = (0, t.useRef)(null);\n        var Ne = (0, t.useRef)();\n        var Le = (0, t.useRef)(null);\n        var We = (0, t.useRef)(null);\n        var He = k()(g);\n        var Ke = (0, t.useRef)([]);\n        var Be = (0, t.useRef)([]);\n        var Ve = (0, t.useRef)([]);\n        var Fe = (0, t.useRef)([]);\n        var Ue = Be.current;\n        var Xe = Ke.current;\n        var Ye = Fe.current;\n        var Ge = (0, t.useCallback)((function() {\n            var e;\n            var n = un();\n            if ($o(g)) {\n                return;\n            }\n            var t = We.current;\n            var r = ze.current;\n            var o = Le.current;\n            if (!o || !r) {\n                return;\n            }\n            var i = Qt(ze.current);\n            var a = (e = ze.current) === null || e === void 0 ? void 0 : e.clientHeight;\n            var l = Wo(o).top - n.pageYOffset - (a || 0) + o.offsetHeight;\n            var u = Math.min(l, Number(f));\n            he(t === null || t === void 0 ? void 0 : t.clientWidth);\n            se(o === null || o === void 0 ? void 0 : o.clientWidth);\n            X(i);\n            ve(u);\n        }), [ f, g ]);\n        (0, t.useEffect)((function() {\n            var e = ze.current;\n            var n = $e.current;\n            if (e && n) {\n                var t = Qt(ze.current);\n                if (!v()(U, t)) {\n                    Ge();\n                }\n            }\n            if (He === "inline" && g === "inline") {\n                Ge();\n            }\n            if (false) // removed by dead control flow\n{}\n        }), [ U, g, He, e, Ge ]);\n        var Je = (0, t.useCallback)((function(e) {\n            var n = We.current;\n            q === null || q === void 0 ? void 0 : q(e);\n            if ((Lo(g) || No(g)) && n) {\n                re(-n.scrollLeft);\n            }\n            if (_e.current && Ne.current !== "dockedScrollBar" && n) {\n                Ne.current = "container";\n                _e.current.scrollLeft = n.scrollLeft;\n            } else {\n                Ne.current = undefined;\n            }\n        }), [ g, q ]);\n        var Qe = function e() {\n            var n = We.current;\n            if (Ne.current !== "container" && n && _e.current) {\n                Ne.current = "dockedScrollBar";\n                n.scrollLeft = _e.current.scrollLeft;\n            } else {\n                Ne.current = undefined;\n            }\n        };\n        var Ze = y()(Ge, 0);\n        var en = (0, t.useCallback)((function() {\n            Ge();\n        }), [ Ge ]);\n        var nn = (0, t.useMemo)((function() {\n            return y()(en, 50);\n        }), [ en ]);\n        E()(We, nn);\n        (0, t.useEffect)((function() {\n            // Using the return value of useCallback to recreate componentWillUnmount\n            return function() {\n                Ze.cancel();\n                nn.cancel();\n            };\n        }));\n        var tn = function e(n) {\n            return function(e) {\n                ze.current = e;\n                N(n.props.elementRef, e);\n            };\n        };\n        var on = function e(n) {\n            if (n) {\n                // On mount, focus the applicable docked head cell if a primary head cell was focused.\n                if (Me.current) {\n                    Xo($e.current, Me.current);\n                    Me.current = undefined;\n                }\n            } else {\n                // On unmount, focus the applicable primary head cell if a docked head cell was focused.\n                var t = Ho($e.current);\n                if (t) {\n                    Xo(ze.current, t);\n                }\n            }\n            $e.current = n;\n        };\n        var an = function e(n) {\n            var t = We.current;\n            if (!$e.current || !t || n.key !== "Tab") {\n                return;\n            }\n            var r = $e.current.scrollLeft;\n            if (r !== 0) {\n                $e.current.scrollLeft = 0;\n                t.scrollLeft += r;\n            }\n        };\n        var ln = function e(n, t) {\n            var r, o;\n            var i = t.columnId, a = t.index, l = t.id;\n            var s = rn();\n            if (a === undefined) {\n                return;\n            }\n            var c = $ === "none" ? 1 : 2;\n            var d = (r = We.current) === null || r === void 0 ? void 0 : r.querySelectorAll("thead th:nth-child(".concat(a + c, "), tbody td:nth-child(").concat(a + c, ")"));\n            var f = s.createElement("div");\n            // TODO: find a styled-components compliant way to do this\n                        f.style["float"] = "left";\n            f.style.position = "fixed";\n            f.style.top = "-100";\n            f.style.left = "0";\n            f.style.maxHeight = "10px";\n            f.style.overflow = "hidden";\n            u()(d, (function(e) {\n                var n = e.cloneNode(true);\n // TS: this seems safe to assume?\n                                n.style.display = "block";\n                n.style.width = "auto";\n                f.appendChild(n);\n            }));\n            s.body.appendChild(f);\n            R === null || R === void 0 ? void 0 : R(n, {\n                columnId: i,\n                id: l,\n                index: a,\n                width: f.clientWidth + 1\n            });\n            (o = f.parentNode) === null || o === void 0 ? void 0 : o.removeChild(f);\n        };\n        var sn = (0, t.useCallback)((function(e) {\n            var n = e.active;\n            var t = n.id;\n            Te.current = Ye.indexOf(t);\n            Pe(t);\n        }), [ Ye ]);\n        var cn = (0, t.useCallback)((function(e) {\n            if (e.over) {\n                var n = e.over.id;\n                var t = Ye.indexOf(n);\n                var r = t;\n                if (Te.current !== undefined && t > Te.current) {\n                    r = t + 1;\n                }\n                Ie(r);\n            } else {\n                Ie(-1);\n            }\n        }), [ Ye ]);\n        // these are useMemo rather than useCallback so that ESLint can correctly analyze the dependencies\n        // see https://github.com/facebook/react/issues/19240#issuecomment-652945246\n                var dn = (0, t.useMemo)((function() {\n            return y()(cn, 100);\n        }), [ cn ]);\n        (0, t.useEffect)((function() {\n            return function() {\n                dn.cancel();\n            };\n        }), [ dn ]);\n        var fn = (0, t.useCallback)((function(e) {\n            var n = e.active, t = e.over;\n            if (t && n.id !== t.id) {\n                var r = Ye.indexOf(n.id);\n                var o = Ye.indexOf(t === null || t === void 0 ? void 0 : t.id);\n                C === null || C === void 0 ? void 0 : C({\n                    fromIndex: r,\n                    toIndex: o\n                });\n            }\n            Pe(undefined);\n            Ie(-1);\n            je.current = undefined;\n            Te.current = undefined;\n        }), [ Ye, C ]);\n        var vn = (0, t.useCallback)((function(e) {\n            var n = e.active, t = e.over;\n            ye.current = true;\n            if (t && n.id !== t.id) {\n                var r = Ue.indexOf(n.id);\n                var o = Ue.indexOf(t === null || t === void 0 ? void 0 : t.id);\n                O === null || O === void 0 ? void 0 : O({\n                    fromIndex: r,\n                    toIndex: o\n                });\n            }\n        }), [ Ue, O ]);\n        var pn = (0, t.useCallback)((function() {\n            ye.current = true;\n        }), []);\n        var mn = (0, t.useRef)({});\n        var bn = function e(n) {\n            var r = [];\n            var o = [];\n            var i = t.Children.toArray(n.props.children).filter(t.isValidElement).map((function(e, n) {\n                var i = e;\n                var a = i.key || (0, j.createDOMID)("col-");\n                a = String(a);\n                // `col-` prefix is necessary to distinguish row or column reordering.\n                // Append the `col-` prefix if is missing from dragId\n                                if (!a.startsWith("col-")) {\n                    a = "col-".concat(a);\n                }\n                r.push(i);\n                o.push(a);\n                \n                return (0, t.cloneElement)(i, {\n                    index: n,\n                    dragId: a,\n                    elementRef: function e(n) {\n                        mn.current[a] = n;\n                        N(i.props.elementRef, n);\n                    }\n                });\n            }));\n            Ve.current = r;\n            Ye = o;\n            var a = l === null || l === void 0 ? void 0 : l.filter(t.isValidElement);\n            var u =  (0, t.cloneElement)(n, {\n                actions: a,\n                actionsColumnWidth: s,\n                hasInfoColumn: $ !== "none",\n                hasDragColumn: !!O,\n                onAutosizeColumn: ln,\n                onRequestMoveColumn: C,\n                onRequestResizeColumn: R,\n                onRequestToggleAllRows: D,\n                elementRef: tn(n),\n                rowSelection: W\n            }, i);\n            return u;\n        };\n        var hn = (0, t.useMemo)((function() {\n            var e, n;\n            if (Ee === -1 || !ze.current || !We.current) return null;\n            var t = !!O;\n            var o = $ !== "none";\n            var i = Array.from((e = (n = ze.current.firstElementChild) === null || n === void 0 ? void 0 : n.children) !== null && e !== void 0 ? e : []).slice(o ? 1 : 0).slice(t ? 1 : 0).slice(D ? 1 : 0);\n            var a;\n            if (Ee === 0) {\n                var l;\n                a = ((l = i[0]) === null || l === void 0 ? void 0 : l.offsetLeft) || 0;\n            } else if (Ee >= i.length) {\n                var u = i[i.length - 1];\n                a = ((u === null || u === void 0 ? void 0 : u.offsetLeft) || 0) + ((u === null || u === void 0 ? void 0 : u.offsetWidth) || 0) - 1;\n // -1 makes the last guideline visible\n                        } else {\n                var s;\n                a = ((s = i[Ee]) === null || s === void 0 ? void 0 : s.offsetLeft) || 0;\n            }\n            \n            return r().createElement(ie, {\n                $height: We.current.clientHeight,\n                $left: a\n            });\n        }), [ Ee, O, $, D ]);\n        var yn = function e(n) {\n            var r = (l === null || l === void 0 ? void 0 : l.filter(t.isValidElement).length) > 0;\n            var o = false;\n            var i = [];\n            var a = [];\n            t.Children.toArray(n === null || n === void 0 ? void 0 : n.props.children).filter(t.isValidElement).forEach((function(e, n) {\n                var r, l;\n                if (((r = e.props) === null || r === void 0 ? void 0 : r.actionPrimary) || ((l = e.props) === null || l === void 0 ? void 0 : l.actionsSecondary)) {\n                    o = true;\n                }\n                var u = e.key || (0, j.createDOMID)("row-");\n                u = String(u);\n                // `row-` prefix is necessary to distinguish row or column reordering.\n                // Append the `row-` prefix if is missing from dragId\n                                if (!u.startsWith("row-")) {\n                    u = "row-".concat(u);\n                }\n                i.push( (0, t.cloneElement)(e, {\n                    index: n,\n                    dragId: u\n                }));\n                a.push(u);\n            }));\n            var u = r || o || !!s;\n            Xe = i;\n            Ue = a;\n            \n            return (0, t.cloneElement)(n, {\n                actions: u,\n                movableColumns: !!C,\n                onRequestMoveRow: O,\n                primaryColumnIndex: _,\n                rowExpansion: $,\n                stripeRows: H\n            }, Xe);\n        };\n        var gn = function e() {\n            var n = We.current;\n            var t = un();\n            if (!No(g) || !Le.current || !ze.current || !n) {\n                return false;\n            }\n            var r = Wo(n).top;\n            return t.pageYOffset >= r - (f || 0);\n        };\n        var wn = function e() {\n            var n = un();\n            var t = We.current;\n            if (!p || !Le.current || !t) {\n                return false;\n            }\n            var r = xo(t);\n            return r.bottom > n.innerHeight && r.top < n.innerHeight;\n        };\n        var Cn = function e(n, o) {\n            if (gn()) {\n                // FIXME: handle inline\n                // Save the current head focus state so that it can be applied to the docked version\n                // after the `HeadTable` mounts.\n                Me.current = Ho(ze.current);\n                if (U === undefined || ue === undefined || fe === undefined || be === undefined) {\n                    return false;\n                }\n                var i =  (0, t.cloneElement)(n);\n                \n                return r().createElement(Ar, {\n                    headType: "docked",\n                    tHead: i,\n                    cellWidths: U,\n                    horizontalOffset: J,\n                    tableWidth: ue,\n                    top: fe,\n                    width: be,\n                    tableStyle: K,\n                    isFixedColumn: o,\n                    onKeyUp: an,\n                    elementRef: on,\n                    hasDragColumn: !!O,\n                    hasRowExpansion: $ !== "none",\n                    hasRowSelection: !!D\n                });\n            }\n            return false;\n        };\n        var xn = (0, t.useMemo)((function() {\n            var e, n, t;\n            if (!_e.current || !ze.current || !Le.current) {\n                return 0;\n            }\n            var r = un();\n            var o = (e = xo(Le.current).top) !== null && e !== void 0 ? e : 0;\n            var i = (n = (t = ze.current) === null || t === void 0 ? void 0 : t.offsetHeight) !== null && n !== void 0 ? n : 0;\n            var a = r.innerHeight - o - i;\n            return Math.min(a - _e.current.offsetHeight, 0);\n        }), []);\n        var Sn = (0, t.useMemo)((function() {\n            return {\n                width: be,\n                marginBottom: xn\n            };\n        }), [ be, xn ]);\n        var On = (0, t.useMemo)((function() {\n            return {\n                width: ue\n            };\n        }), [ ue ]);\n        var kn = function e() {\n            if (!wn()) {\n                return false;\n            }\n            \n            return r().createElement(ne, {\n                style: Sn,\n                onScroll: Qe,\n                "data-test": "docked-scroll-bar",\n                ref: _e\n            },  r().createElement(te, {\n                style: On,\n                "data-test": "docked-scroll-content"\n            }));\n        };\n        var Rn = function e() {\n            var n = ze.current;\n            var t = We.current;\n            /**\n     * there is slightly less space for the table than tableContainer\'s width,\n     * because there is a 1 px border added to every column but the first\n     */            if (n) {\n                var r = Qt(ze.current);\n                var o = r === null || r === void 0 ? void 0 : r.length;\n                var i = t === null || t === void 0 ? void 0 : t.clientWidth;\n                if (i != null) {\n                    var a = Math.max(0, o - 1);\n                    return i - a;\n                }\n            }\n            return null;\n        };\n        var En;\n        var In;\n        var Tn;\n        var jn = !!R;\n        t.Children.toArray(c).forEach((function(e) {\n            var n = e.type.splunkUiType;\n            if (n === "Table.Head") {\n                En = bn(e);\n                // Check if all HeadCells have a defined width (making the table fixed width)\n                                var r = t.Children.toArray(e.props.children).filter(t.isValidElement);\n                var o = r.every((function(e) {\n                    return e.props.width && e.props.width !== undefined;\n                }));\n                jn = o;\n            } else if (n === "Table.Body") {\n                In = yn(e);\n            } else if (n === "Table.Caption") {\n                // the html spec mandates that a caption must be the first table child.\n                // catch the caption here so that it can be placed first later. note: a\n                // caption can be placed on the bottom side of a table by adjusting the\n                // caption\'s side prop.\n                Tn = e;\n            }\n        }));\n        So(En, "A Table.Head is required.");\n        var Dn = Cn(En, jn);\n        // When a `headTable` is used, suppress focus interactions in the primary `Head`. Focus\n        // interactions will be handled by the overlaid `headTable` instead.\n                var qn = t.Children.toArray(En.props.children).filter(t.isValidElement).map((function(e) {\n            \n            // TS: onClick is different for regular/dropdown head cells, that\'s ok\n            return (0, t.cloneElement)(e, {\n                visible: !Dn\n            });\n        }));\n        En =  (0, t.cloneElement)(En, {}, qn);\n        var An = ge || un();\n        var Pn = Lo(g) ? We.current : An;\n        if (z) {\n            jn = false;\n        }\n        var _n = Rn();\n        var zn = (0, t.useMemo)((function() {\n            return {\n                headType: g,\n                resizableFillLayout: z,\n                tableContainerWidthWithoutBorders: _n\n            };\n        }), [ g, z, _n ]);\n        var Mn = (0, t.useMemo)((function() {\n            if (!O) {\n                return {\n                    onDragStart: function e() {\n                        return undefined;\n                    },\n                    onDragOver: function e() {\n                        return undefined;\n                    },\n                    onDragEnd: function e() {\n                        return undefined;\n                    },\n                    onDragCancel: function e() {\n                        return undefined;\n                    }\n                };\n            }\n            return {\n                onDragStart: function e(n) {\n                    var t = n.active.id;\n                    if (t === undefined) {\n                        return undefined;\n                    }\n                    var r = Ko(Ue, t);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Picked up sortable row in position %(pos)d of %(total)d."), {\n                        pos: r,\n                        total: Ue.length\n                    }) : undefined;\n                },\n                onDragOver: function e(n) {\n                    var t = n.active, r = n.over;\n                    if (ye.current) {\n                        ye.current = false;\n                        return undefined;\n                    }\n                    if (!t.id || !(r === null || r === void 0 ? void 0 : r.id)) {\n                        return undefined;\n                    }\n                    var o = Ko(Ue, t.id);\n                    var i = Ko(Ue, r.id);\n                    return (0, I.sprintf)((0, T._)("Row moved from position %(from)d to position %(to)d of %(total)d."), {\n                        from: o,\n                        to: i,\n                        total: Ue.length\n                    });\n                },\n                onDragEnd: function e(n) {\n                    var t = n.over;\n                    if (!(t === null || t === void 0 ? void 0 : t.id)) {\n                        return undefined;\n                    }\n                    var r = Ko(Ue, t.id);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Row dropped at position %(pos)d of %(total)d."), {\n                        pos: r,\n                        total: Ue.length\n                    }) : undefined;\n                },\n                onDragCancel: function e(n) {\n                    var t = n.active.id;\n                    if (t === undefined) {\n                        return undefined;\n                    }\n                    var r = Ko(Ue, t);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Row returned to its starting position of %(pos)d."), {\n                        pos: r\n                    }) : undefined;\n                }\n            };\n        }), [ Ue, O ]);\n        var $n = (0, t.useMemo)((function() {\n            if (!C) {\n                return {\n                    onDragStart: function e() {\n                        return undefined;\n                    },\n                    onDragOver: function e() {\n                        return undefined;\n                    },\n                    onDragEnd: function e() {\n                        return undefined;\n                    },\n                    onDragCancel: function e() {\n                        return undefined;\n                    }\n                };\n            }\n            return {\n                onDragStart: function e(n) {\n                    var t = n.active.id;\n                    if (t === undefined) {\n                        return undefined;\n                    }\n                    var r = Bo(Ye, t);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Picked up sortable column in position %(pos)d of %(total)d."), {\n                        pos: r,\n                        total: Ye.length\n                    }) : undefined;\n                },\n                onDragOver: function e(n) {\n                    var t = n.active, r = n.over;\n                    if (ye.current) {\n                        ye.current = false;\n                        return undefined;\n                    }\n                    if (!t.id || !(r === null || r === void 0 ? void 0 : r.id)) {\n                        return undefined;\n                    }\n                    var o = Bo(Ye, t.id);\n                    var i = Bo(Ye, r.id);\n                    if (typeof o !== "number" || typeof i !== "number") return undefined;\n                    return (0, I.sprintf)((0, T._)("Column moved from position %(from)d to position %(to)d of %(total)d."), {\n                        from: o,\n                        to: i,\n                        total: Ye.length\n                    });\n                },\n                onDragEnd: function e(n) {\n                    var t = n.over;\n                    if (!(t === null || t === void 0 ? void 0 : t.id)) {\n                        return undefined;\n                    }\n                    var r = Bo(Ye, t.id);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Column dropped at position %(pos)d of %(total)d."), {\n                        pos: r,\n                        total: Ye.length\n                    }) : undefined;\n                },\n                onDragCancel: function e(n) {\n                    var t = n.active.id;\n                    if (t === undefined) {\n                        return undefined;\n                    }\n                    var r = Bo(Ye, t);\n                    return typeof r === "number" ? (0, I.sprintf)((0, T._)("Column returned to its starting position of %(pos)d."), {\n                        pos: r\n                    }) : undefined;\n                }\n            };\n        }), [ Ye, C ]);\n        var Nn = (0, t.useMemo)((function() {\n            return {\n                screenReaderInstructions: O ? Fo : Uo,\n                announcements: O ? Mn : $n\n            };\n        }), [ Mn, $n, O ]);\n        var Ln = (0, t.useCallback)((function(e) {\n            var n = e.active.id;\n            if (n.startsWith("col-") && C) {\n                Oe([ i.restrictToHorizontalAxis ]);\n                sn(e);\n            } else if (n.startsWith("row-") && O) {\n                Oe([ i.restrictToVerticalAxis ]);\n            }\n        }), [ C, O, sn ]);\n        var Wn = (0, t.useCallback)((function(e) {\n            Oe([]);\n            var n = e.active.id;\n            if (n.startsWith("col-") && C) {\n                fn(e);\n            } else if (n.startsWith("row-") && O) {\n                vn(e);\n            }\n        }), [ fn, vn, C, O ]);\n        var Hn = (0, t.useCallback)((function(e) {\n            var n = e.active.id;\n            if (n.startsWith("col-") && C) {\n                dn(e);\n            }\n        }), [ dn, C ]);\n        var Kn = (0, t.useCallback)((function(e) {\n            Oe([]);\n            var n = e.active.id;\n            if (n.startsWith("row-") && O) {\n                pn();\n            }\n        }), [ pn, O ]);\n        var Bn = (0, t.useMemo)((function() {\n            return function(e) {\n                var n = (0, o.pointerWithin)(e);\n                // Collision detection algorithms return an array of collisions\n                                if (n.length > 0) {\n                    return n;\n                }\n                // If there are no collisions with the pointer, return rectangle intersections\n                                return (0, o.rectIntersection)(e);\n            };\n        }), []);\n        var Vn = Ae ? mn.current[Ae] : null;\n        var Fn = Vn ? xo(Vn).width : undefined;\n        var Un = We.current ? xo(We.current).height : undefined;\n        \n        return r().createElement(Q, Oo({\n            "data-test": "table",\n            ref: m,\n            style: A,\n            "data-test-row-selection": D ? W : undefined\n        }, b()(B, [].concat(ko(Object.keys(Mo)), [ "style" ]))),  r().createElement(x(), {\n            target: un(),\n            eventType: "scroll",\n            listener: Ze,\n            options: Yo\n        }),  r().createElement(Ht.Provider, {\n            value: zn\n        }, Dn,  r().createElement(Z, {\n            "data-test": "scroll-container",\n            onScroll: Je,\n            ref: We,\n            style: w,\n            $dragging: !!Ae\n        },  r().createElement(S.ScrollContainerProvider, {\n            value: Pn\n        },  r().createElement(o.DndContext, {\n            accessibility: Nn,\n            collisionDetection: Bn,\n            modifiers: Se,\n            onDragCancel: Kn,\n            onDragEnd: Wn,\n            onDragOver: Hn,\n            onDragStart: Ln,\n            sensors: we\n        },  r().createElement(ee, {\n            ref: Le,\n            "data-test": "main-table",\n            style: K,\n            "data-fixed-column": jn ? "true" : undefined,\n            $resizableFillLayout: z\n        }, Tn, C ?  r().createElement(a.SortableContext, {\n            items: Ye,\n            strategy: a.horizontalListSortingStrategy\n        }, En) : En, O ?  r().createElement(a.SortableContext, {\n            items: Ue,\n            strategy: a.verticalListSortingStrategy\n        }, In) : In), Ae &&  r().createElement(o.DragOverlay, null,  r().createElement(oe, {\n            $width: Fn,\n            $height: Un\n        })), Ae && hn))), kn()));\n    }\n    Jo.propTypes = Mo;\n    Jo.Body = J;\n    Jo.Caption = de;\n    Jo.Cell = xe;\n    Jo.Head = er;\n    Jo.HeadCell = zn;\n    Jo.HeadDropdownCell = xr;\n    Jo.Row = Lt;\n    /* harmony default export */    const Qo = Jo;\n    // CONCATENATED MODULE: ./src/Table/index.ts\n    module.exports = n;\n    /******/})();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjQyNi5qcyIsIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFPO0FBQzdCO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBZTtBQUNyQztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxJQUFvQjtBQUMxQztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFtQjtBQUN6QztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFnQjtBQUN0QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQVk7QUFDbEM7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBZ0I7QUFDdEM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFnQjtBQUN0QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQWlCO0FBQ3ZDO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQWE7QUFDbkM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFpQjtBQUN2QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQVk7QUFDbEM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFnQztBQUN0RDtBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQXlDO0FBQy9EO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQThCO0FBQ3BEO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBb0M7QUFDMUQ7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxJQUF5QjtBQUMvQztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUF1QjtBQUM3QztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFxQjtBQUMzQztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFpQjtBQUN2QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQWdCO0FBQ3RDO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBbUI7QUFDekM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFnQjtBQUN0QztBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssb0JBQW9CO0FBQ3pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw0QkFBNEIsc0JBQXNCO0FBQ2xEO0FBQ0E7QUFDQSx1QkFBdUI7QUFDdkI7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQ0FBc0MsT0FBTztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IsV0FBVyxrRUFBa0U7QUFDL0Y7QUFDQSxjQUFjO0FBQ2Q7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlCQUF5QjtBQUN6QjtBQUNBLHlCQUF5QjtBQUN6QjtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0EsYUFBYTtBQUNiLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxvQkFBb0IsS0FBSyxFQUFFO0FBQUEsRUFBRTtBQUM3QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlCQUF5QjtBQUN6QixxQkFBcUI7QUFDckI7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVSxlQUFlLGtCQUFrQixVQUFVLGFBQWEsNEJBQTRCO0FBQ25HO0FBQ0E7QUFDQTtBQUNBLEtBQUssbUJBQW1CLGVBQWUsV0FBVyxXQUFXLFNBQVMsTUFBTSxtQkFBbUI7QUFDL0Y7QUFDQSxrREFBa0Q7QUFDbEQsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVSxrQkFBa0IseUJBQXlCLGlCQUFpQixlQUFlLFVBQVUsV0FBVyw0QkFBNEIsbUJBQW1CLFlBQVksU0FBUyxrQkFBa0IsV0FBVyxlQUFlLG1CQUFtQjtBQUNsUDtBQUNBLDZDQUE2QyxlQUFlLG1CQUFtQjtBQUMvRSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsS0FBSyxvQkFBb0IsU0FBUyxjQUFjLHVCQUF1QjtBQUN2RTtBQUNBO0FBQ0E7QUFDQSxLQUFLLGdCQUFnQjtBQUNyQjtBQUNBO0FBQ0E7QUFDQSxLQUFLLG9CQUFvQixlQUFlLGtCQUFrQjtBQUMxRDtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUssbUJBQW1CLGdCQUFnQix5QkFBeUIsWUFBWSxXQUFXO0FBQ3hGO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLLHVCQUF1QixVQUFVLFVBQVUsTUFBTSxZQUFZLG9CQUFvQixzQkFBc0I7QUFDNUc7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLElBQStCO0FBQ3REO0FBQ0E7QUFDQSwyQ0FBMkM7QUFDM0M7QUFDQTtBQUNBO0FBQ0EsS0FBSywyQkFBMkIsa0JBQWtCLGdDQUFnQyxpQ0FBaUMsV0FBVyxxQkFBcUIsbUJBQW1CLG1FQUFtRSxpQkFBaUIsbUJBQW1CLG9CQUFvQiwyREFBMkQsaUJBQWlCLDJDQUEyQyxxQkFBcUI7QUFDN2E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMLDBDQUEwQyxVQUFVO0FBQ3BELDBDQUEwQyxVQUFVO0FBQ3BELEtBQUs7QUFDTDtBQUNBO0FBQ0EseUZBQXlGLG1CQUFtQixvQkFBb0IsZ0JBQWdCLGFBQWEsa0JBQWtCO0FBQy9LO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsOENBQThDLGFBQWEsZUFBZSxLQUFLO0FBQy9FLGdEQUFnRDtBQUNoRCwyQ0FBMkMsUUFBUSxlQUFlLDJCQUEyQixRQUFRLDBCQUEwQixpQkFBaUI7QUFDaEosU0FBUztBQUNULEtBQUs7QUFDTDtBQUNBLGlEQUFpRCxRQUFRLHVCQUF1QixRQUFRLDRCQUE0QjtBQUNwSCxpQ0FBaUMsNEJBQTRCO0FBQzdELEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLGtCQUFrQix1QkFBdUIsc0JBQXNCO0FBQ3BFO0FBQ0EsMENBQTBDO0FBQzFDLDBDQUEwQztBQUMxQyxLQUFLO0FBQ0w7QUFDQSwrQ0FBK0MsZ0JBQWdCLDZDQUE2QyxnQkFBZ0I7QUFDNUgsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBaUI7QUFDeEM7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUFjO0FBQ3JDO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBa0M7QUFDekQ7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUEwQjtBQUNqRDtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQTBCO0FBQ2pEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxtREFBbUQsbUJBQW1CLFdBQVcsV0FBVztBQUM1RjtBQUNBO0FBQ0E7QUFDQSxLQUFLLDJCQUEyQjtBQUNoQztBQUNBO0FBQ0E7QUFDQSxLQUFLLDhCQUE4QjtBQUNuQztBQUNBO0FBQ0E7QUFDQSxLQUFLLHVCQUF1QixnQkFBZ0Isa0JBQWtCLFlBQVk7QUFDMUU7QUFDQSxxRUFBcUU7QUFDckUsS0FBSztBQUNMO0FBQ0EsaUVBQWlFLHNCQUFzQjtBQUN2RixLQUFLO0FBQ0w7QUFDQSxvRUFBb0U7QUFDcEUsS0FBSztBQUNMLG1DQUFtQyxrQkFBa0I7QUFDckQsa0NBQWtDLGlCQUFpQjtBQUNuRCxvQ0FBb0MsbUJBQW1CO0FBQ3ZELEtBQUs7QUFDTCwyQ0FBMkMsYUFBYSxXQUFXLDBCQUEwQjtBQUM3RjtBQUNBO0FBQ0E7QUFDQSxLQUFLLFVBQVUsS0FBSyxLQUFLLGtCQUFrQixnQ0FBZ0Msa0JBQWtCLFlBQVksWUFBWSxtQkFBbUIsb0JBQW9CLHFCQUFxQix1QkFBdUIsdUJBQXVCO0FBQy9OO0FBQ0EsS0FBSztBQUNMO0FBQ0EsMEVBQTBFLGdCQUFnQjtBQUMxRixLQUFLO0FBQ0w7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQSw0REFBNEQsdUJBQXVCO0FBQ25GLEtBQUs7QUFDTCwyQ0FBMkM7QUFDM0MsaURBQWlEO0FBQ2pELEtBQUs7QUFDTDtBQUNBLGlEQUFpRCxRQUFRLEtBQUssYUFBYSxhQUFhLDBCQUEwQixZQUFZO0FBQzlILGlDQUFpQyxLQUFLO0FBQ3RDLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLLFVBQVUsa0JBQWtCLFdBQVcsVUFBVSxNQUFNLFNBQVMsVUFBVSxrQkFBa0IsK0JBQStCLFVBQVUsV0FBVyxRQUFRLGFBQWEsVUFBVSxXQUFXLGdCQUFnQixrQkFBa0IsU0FBUyxVQUFVLE1BQU0sV0FBVyxRQUFRLGFBQWEsVUFBVSxXQUFXLGtCQUFrQixnQkFBZ0IsZ0JBQWdCLFNBQVMsVUFBVSxNQUFNLFdBQVc7QUFDclk7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLGtCQUFrQixZQUFZLHVCQUF1QjtBQUMxRDtBQUNBO0FBQ0E7QUFDQSxLQUFLLDJCQUEyQixzQkFBc0IsdUJBQXVCLGdCQUFnQixvQkFBb0Isa0JBQWtCLFlBQVksK0JBQStCLEtBQUssNkJBQTZCLFlBQVksS0FBSyw4QkFBOEIsNkNBQTZDLEtBQUssbUJBQW1CLHNCQUFzQixpQkFBaUI7QUFDM1c7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLHdEQUF3RCxRQUFRLGlCQUFpQjtBQUNqRixLQUFLO0FBQ0w7QUFDQSxvREFBb0QsS0FBSyw2QkFBNkI7QUFDdEYsS0FBSztBQUNMLCtDQUErQyxhQUFhLGtCQUFrQjtBQUM5RTtBQUNBLFNBQVM7QUFDVCxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsS0FBSyx5QkFBeUIsbUJBQW1CLFdBQVc7QUFDNUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLHlCQUF5QixrQkFBa0IsbUJBQW1CLHVCQUF1QixlQUFlLFlBQVksbUJBQW1CLHlCQUF5QixzQkFBc0IsaUJBQWlCLFFBQVEsZ0JBQWdCLFlBQVksUUFBUSxnQkFBZ0IsZ0JBQWdCLFlBQVk7QUFDaFM7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQStCO0FBQ3REO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBNkI7QUFDcEQ7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUFpQztBQUN4RDtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQW9DO0FBQzNEO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBdUM7QUFDOUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCx5Q0FBeUM7QUFDekMsNENBQTRDO0FBQzVDO0FBQ0EsaUNBQWlDO0FBQ2pDO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EseUJBQXlCO0FBQ3pCLDZDQUE2QztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw2RkFBNkYsQ0FBRTtBQUMvRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0EseUNBQXlDO0FBQ3pDLHNDQUFzQztBQUN0QywrQkFBK0I7QUFDL0I7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVCx5Q0FBeUM7QUFDekMsNENBQTRDO0FBQzVDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCw4QkFBOEI7QUFDOUIsNkJBQTZCO0FBQzdCLGtCQUFrQjtBQUNsQixtQ0FBbUM7QUFDbkMscUNBQXFDO0FBQ3JDO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDZGQUE2RixDQUFFO0FBQy9GO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0I7QUFDdEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNDQUFzQyxPQUFPO0FBQzdDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixXQUFXLGtFQUFrRTtBQUMvRjtBQUNBLGNBQWM7QUFDZDtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSwwQkFBMEI7QUFDMUI7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSw4Q0FBOEM7QUFDOUM7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVTtBQUNmO0FBQ0Esa0RBQWtELE1BQU0sYUFBYTtBQUNyRSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsS0FBSyxnQkFBZ0I7QUFDckI7QUFDQTtBQUNBO0FBQ0EsS0FBSyxnQkFBZ0I7QUFDckI7QUFDQTtBQUNBO0FBQ0EsS0FBSyxnQkFBZ0I7QUFDckI7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBb0I7QUFDM0M7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBdUM7QUFDOUQ7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUF5QjtBQUNoRDtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQTJCO0FBQ2xEO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBa0M7QUFDekQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVSxZQUFZLFdBQVcsZUFBZSx1QkFBdUIsV0FBVyxRQUFRLFlBQVksUUFBUSxXQUFXLGlCQUFpQjtBQUMvSTtBQUNBO0FBQ0E7QUFDQSxLQUFLLHdCQUF3QiwyQkFBMkI7QUFDeEQ7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLDBEQUEwRDtBQUMxRCxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLHNCQUFzQixrQkFBa0Isa0JBQWtCLHNCQUFzQjtBQUNyRjtBQUNBO0FBQ0E7QUFDQSxLQUFLLGVBQWUsdUJBQXVCLFlBQVksMEJBQTBCLGlCQUFpQixtQkFBbUIsa0JBQWtCLFdBQVcsTUFBTSxTQUFTLFFBQVEsVUFBVSxpQkFBaUIsUUFBUSxzQkFBc0IsY0FBYyxTQUFTLHNCQUFzQixpQkFBaUIsUUFBUSxVQUFVLGFBQWEsdUJBQXVCO0FBQ3RWO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLFVBQVUsS0FBSyxrQkFBa0IsdUJBQXVCO0FBQzdEO0FBQ0EsaURBQWlELFFBQVEsdUJBQXVCLFFBQVEsc0JBQXNCLGlCQUFpQjtBQUMvSCxLQUFLO0FBQ0w7QUFDQSxzREFBc0QsdUJBQXVCO0FBQzdFLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLLDJCQUEyQixLQUFLO0FBQ3JDO0FBQ0EsaURBQWlELGdCQUFnQix1QkFBdUI7QUFDeEYsS0FBSztBQUNMO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQTJCO0FBQ2xEO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBNEI7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssaUJBQWlCLFdBQVcsYUFBYSx1QkFBdUIsWUFBWSxvQkFBb0I7QUFDckc7QUFDQTtBQUNBO0FBQ0EsS0FBSyw0QkFBNEIsbUJBQW1CO0FBQ3BEO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLHNCQUFzQjtBQUM5QztBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSwrQkFBK0IsUUFBUTtBQUN2QztBQUNBO0FBQ0EsYUFBYTtBQUNiLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5QkFBeUI7QUFDekI7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBLGdCQUFnQixLQUFLLEVBQUU7QUFBQSxFQUFFO0FBQ3pCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFDQUFxQztBQUNyQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZ0JBQWdCLEtBQUssRUFBRTtBQUFBLFVBRVY7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EseUJBQXlCO0FBQ3pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlCQUF5QjtBQUN6QjtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5QkFBeUI7QUFDekI7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakIsYUFBYTtBQUNiO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQWlCO0FBQ3hDO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBbUI7QUFDMUM7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUEwQjtBQUNqRDtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQWdDO0FBQ3ZEO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNCQUFzQjtBQUN0QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0NBQXNDLE9BQU87QUFDN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLFdBQVcsa0VBQWtFO0FBQy9GO0FBQ0EsY0FBYztBQUNkO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHdCQUF3QixjQUFjO0FBQ3RDLG1EQUFtRDtBQUNuRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZ0JBQWdCLEtBQUssRUFBRTtBQUFBLEVBQUU7QUFDekIsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQixjQUFjO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBLDBCQUEwQjtBQUMxQjtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUFlO0FBQ3RDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLGlCQUFpQixtQkFBbUI7QUFDekM7QUFDQTtBQUNBO0FBQ0EsS0FBSyxxQkFBcUIsZUFBZSxhQUFhLGFBQWEsY0FBYztBQUNqRjtBQUNBO0FBQ0E7QUFDQSxLQUFLLHVCQUF1QixnQkFBZ0IsVUFBVTtBQUN0RDtBQUNBO0FBQ0E7QUFDQSw0QkFBNEIsc0JBQXNCO0FBQ2xEO0FBQ0E7QUFDQSx1QkFBdUI7QUFDdkI7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHdCQUF3QixjQUFjO0FBQ3RDLG1EQUFtRDtBQUNuRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtDQUFrQztBQUNsQztBQUNBLHFCQUFxQjtBQUNyQixpQkFBaUI7QUFDakIsYUFBYTtBQUNiLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsMEJBQTBCO0FBQzFCO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLFdBQVcsa0VBQWtFO0FBQy9GO0FBQ0EsY0FBYztBQUNkO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQ0FBc0MsT0FBTztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakIsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0I7QUFDdEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3Q0FBd0MsY0FBYztBQUN0RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EscUNBQXFDO0FBQ3JDO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0NBQWtDO0FBQ2xDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFDQUFxQztBQUNyQztBQUNBO0FBQ0EsOEJBQThCO0FBQzlCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQ0FBcUM7QUFDckM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQ0FBa0M7QUFDbEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EscUNBQXFDO0FBQ3JDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLHNCQUFzQjtBQUM5QztBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVCQUF1QixRQUFRO0FBQy9CO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCLFdBQVcsU0FBUztBQUNwQixhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0I7QUFDdEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNDQUFzQyxPQUFPO0FBQzdDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixXQUFXLGtFQUFrRTtBQUMvRjtBQUNBLGNBQWM7QUFDZDtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLFdBQVcsUUFBUTtBQUNuQjtBQUNBLFdBQVcsUUFBUTtBQUNuQjtBQUNBO0FBQ0E7QUFDQSxZQUFZLEtBQUssRUFBRTtBQUFBLEVBQUU7QUFDckI7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQSxZQUFZLEtBQUssRUFBRTtBQUFBLEVBQUU7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFFQUFxRSxxQ0FBcUM7QUFDMUc7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxnQkFBZ0IsS0FBSyxFQUFFO0FBQUEsRUFBRTtBQUN6QixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakI7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVCxpQ0FBaUM7QUFDakM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakIsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQTtBQUNBLDBCQUEwQjtBQUMxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCO0FBQ2pCO0FBQ0EsY0FBYztBQUNkO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNULHdDQUF3QztBQUN4QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckIsaUJBQWlCO0FBQ2pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQixpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQixpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckIsaUJBQWlCO0FBQ2pCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQixpQkFBaUI7QUFDakI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvQHNwbHVuay9yZWFjdC11aS9UYWJsZS5qcz84ZGU1Il0sInNvdXJjZXNDb250ZW50IjpbIi8qKioqKiovICgoKSA9PiB7XG4gICAgLy8gd2VicGFja0Jvb3RzdHJhcFxuICAgIC8qKioqKiovIFwidXNlIHN0cmljdFwiO1xuICAgIC8qKioqKiovIC8vIFRoZSByZXF1aXJlIHNjb3BlXG4gICAgLyoqKioqKi8gICAgdmFyIGUgPSB7fTtcbiAgICAvKioqKioqL1xuICAgIC8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiovXG4gICAgLyoqKioqKi8gLyogd2VicGFjay9ydW50aW1lL2NvbXBhdCBnZXQgZGVmYXVsdCBleHBvcnQgKi9cbiAgICAvKioqKioqLyAgICAoKCkgPT4ge1xuICAgICAgICAvKioqKioqLyAvLyBnZXREZWZhdWx0RXhwb3J0IGZ1bmN0aW9uIGZvciBjb21wYXRpYmlsaXR5IHdpdGggbm9uLWhhcm1vbnkgbW9kdWxlc1xuICAgICAgICAvKioqKioqLyBlLm4gPSBuID0+IHtcbiAgICAgICAgICAgIC8qKioqKiovIHZhciB0ID0gbiAmJiBuLl9fZXNNb2R1bGUgPyBcbiAgICAgICAgICAgIC8qKioqKiovICgpID0+IG5bXCJkZWZhdWx0XCJdXG4gICAgICAgICAgICAvKioqKioqLyA6ICgpID0+IG5cbiAgICAgICAgICAgIC8qKioqKiovO1xuICAgICAgICAgICAgZS5kKHQsIHtcbiAgICAgICAgICAgICAgICBhOiB0XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIC8qKioqKiovICAgICAgICAgICAgcmV0dXJuIHQ7XG4gICAgICAgICAgICAvKioqKioqLyAgICAgICAgfTtcbiAgICAgICAgLyoqKioqKi8gICAgfSkoKTtcbiAgICAvKioqKioqL1xuICAgIC8qKioqKiovIC8qIHdlYnBhY2svcnVudGltZS9kZWZpbmUgcHJvcGVydHkgZ2V0dGVycyAqL1xuICAgIC8qKioqKiovICAgICgoKSA9PiB7XG4gICAgICAgIC8qKioqKiovIC8vIGRlZmluZSBnZXR0ZXIgZnVuY3Rpb25zIGZvciBoYXJtb255IGV4cG9ydHNcbiAgICAgICAgLyoqKioqKi8gZS5kID0gKG4sIHQpID0+IHtcbiAgICAgICAgICAgIC8qKioqKiovIGZvciAodmFyIHIgaW4gdCkge1xuICAgICAgICAgICAgICAgIC8qKioqKiovIGlmIChlLm8odCwgcikgJiYgIWUubyhuLCByKSkge1xuICAgICAgICAgICAgICAgICAgICAvKioqKioqLyBPYmplY3QuZGVmaW5lUHJvcGVydHkobiwgciwge1xuICAgICAgICAgICAgICAgICAgICAgICAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGdldDogdFtyXVxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAgICAgLyoqKioqKi8gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIC8qKioqKiovICAgICAgICAgICAgfVxuICAgICAgICAgICAgLyoqKioqKi8gICAgICAgIH07XG4gICAgICAgIC8qKioqKiovICAgIH0pKCk7XG4gICAgLyoqKioqKi9cbiAgICAvKioqKioqLyAvKiB3ZWJwYWNrL3J1bnRpbWUvaGFzT3duUHJvcGVydHkgc2hvcnRoYW5kICovXG4gICAgLyoqKioqKi8gICAgKCgpID0+IHtcbiAgICAgICAgLyoqKioqKi8gZS5vID0gKGUsIG4pID0+IE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChlLCBuKVxuICAgICAgICAvKioqKioqLztcbiAgICB9KSgpO1xuICAgIC8qKioqKiovXG4gICAgLyoqKioqKi8gLyogd2VicGFjay9ydW50aW1lL21ha2UgbmFtZXNwYWNlIG9iamVjdCAqL1xuICAgIC8qKioqKiovICAgICgoKSA9PiB7XG4gICAgICAgIC8qKioqKiovIC8vIGRlZmluZSBfX2VzTW9kdWxlIG9uIGV4cG9ydHNcbiAgICAgICAgLyoqKioqKi8gZS5yID0gZSA9PiB7XG4gICAgICAgICAgICAvKioqKioqLyBpZiAodHlwZW9mIFN5bWJvbCAhPT0gXCJ1bmRlZmluZWRcIiAmJiBTeW1ib2wudG9TdHJpbmdUYWcpIHtcbiAgICAgICAgICAgICAgICAvKioqKioqLyBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgU3ltYm9sLnRvU3RyaW5nVGFnLCB7XG4gICAgICAgICAgICAgICAgICAgIHZhbHVlOiBcIk1vZHVsZVwiXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgLyoqKioqKi8gICAgICAgICAgICB9XG4gICAgICAgICAgICAvKioqKioqLyAgICAgICAgICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCBcIl9fZXNNb2R1bGVcIiwge1xuICAgICAgICAgICAgICAgIHZhbHVlOiB0cnVlXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIC8qKioqKiovICAgICAgICB9O1xuICAgICAgICAvKioqKioqLyAgICB9KSgpO1xuICAgIC8qKioqKiovXG4gICAgLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi8gICAgdmFyIG4gPSB7fTtcbiAgICAvLyBFU00gQ09NUEFUIEZMQUdcbiAgICAgICAgZS5yKG4pO1xuICAgIC8vIEVYUE9SVFNcbiAgICAgICAgZS5kKG4sIHtcbiAgICAgICAgQm9keTogKCkgPT4gLyogcmVleHBvcnQgKi8gSixcbiAgICAgICAgQ2FwdGlvbjogKCkgPT4gLyogcmVleHBvcnQgKi8gZGUsXG4gICAgICAgIENlbGw6ICgpID0+IC8qIHJlZXhwb3J0ICovIHhlLFxuICAgICAgICBIZWFkOiAoKSA9PiAvKiByZWV4cG9ydCAqLyBlcixcbiAgICAgICAgSGVhZENlbGw6ICgpID0+IC8qIHJlZXhwb3J0ICovIHpuLFxuICAgICAgICBIZWFkRHJvcGRvd25DZWxsOiAoKSA9PiAvKiByZWV4cG9ydCAqLyB4cixcbiAgICAgICAgUm93OiAoKSA9PiAvKiByZWV4cG9ydCAqLyBMdCxcbiAgICAgICAgZGVmYXVsdDogKCkgPT4gLyogcmVleHBvcnQgKi8gUW9cbiAgICB9KTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcInJlYWN0XCJcbiAgICBjb25zdCB0ID0gcmVxdWlyZShcInJlYWN0XCIpO1xuICAgIHZhciByID0gIGUubih0KTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBkbmQta2l0L2NvcmVcIlxuICAgIGNvbnN0IG8gPSByZXF1aXJlKFwiQGRuZC1raXQvY29yZVwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBkbmQta2l0L21vZGlmaWVyc1wiXG4gICAgY29uc3QgaSA9IHJlcXVpcmUoXCJAZG5kLWtpdC9tb2RpZmllcnNcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAZG5kLWtpdC9zb3J0YWJsZVwiXG4gICAgY29uc3QgYSA9IHJlcXVpcmUoXCJAZG5kLWtpdC9zb3J0YWJsZVwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9mb3JFYWNoXCJcbiAgICBjb25zdCBsID0gcmVxdWlyZShcImxvZGFzaC9mb3JFYWNoXCIpO1xuICAgIHZhciB1ID0gIGUubihsKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9oYXNcIlxuICAgIGNvbnN0IHMgPSByZXF1aXJlKFwibG9kYXNoL2hhc1wiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pbmRleE9mXCJcbiAgICBjb25zdCBjID0gcmVxdWlyZShcImxvZGFzaC9pbmRleE9mXCIpO1xuICAgIHZhciBkID0gIGUubihjKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pc0VxdWFsXCJcbiAgICBjb25zdCBmID0gcmVxdWlyZShcImxvZGFzaC9pc0VxdWFsXCIpO1xuICAgIHZhciB2ID0gIGUubihmKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pc051bWJlclwiXG4gICAgY29uc3QgcCA9IHJlcXVpcmUoXCJsb2Rhc2gvaXNOdW1iZXJcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvb21pdFwiXG4gICAgY29uc3QgbSA9IHJlcXVpcmUoXCJsb2Rhc2gvb21pdFwiKTtcbiAgICB2YXIgYiA9ICBlLm4obSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvdGhyb3R0bGVcIlxuICAgIGNvbnN0IGggPSByZXF1aXJlKFwibG9kYXNoL3Rocm90dGxlXCIpO1xuICAgIHZhciB5ID0gIGUubihoKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcInByb3AtdHlwZXNcIlxuICAgIGNvbnN0IGcgPSByZXF1aXJlKFwicHJvcC10eXBlc1wiKTtcbiAgICB2YXIgdyA9ICBlLm4oZyk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0V2ZW50TGlzdGVuZXJcIlxuICAgIGNvbnN0IEMgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9FdmVudExpc3RlbmVyXCIpO1xuICAgIHZhciB4ID0gIGUubihDKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvU2Nyb2xsQ29udGFpbmVyQ29udGV4dFwiXG4gICAgY29uc3QgUyA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL1Njcm9sbENvbnRhaW5lckNvbnRleHRcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL3VzZVByZXZpb3VzXCJcbiAgICBjb25zdCBPID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtdWkvdXNlUHJldmlvdXNcIik7XG4gICAgdmFyIGsgPSAgZS5uKE8pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS91c2VSZXNpemVPYnNlcnZlclwiXG4gICAgY29uc3QgUiA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL3VzZVJlc2l6ZU9ic2VydmVyXCIpO1xuICAgIHZhciBFID0gIGUubihSKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvdWktdXRpbHMvZm9ybWF0XCJcbiAgICBjb25zdCBJID0gcmVxdWlyZShcIkBzcGx1bmsvdWktdXRpbHMvZm9ybWF0XCIpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay91aS11dGlscy9pMThuXCJcbiAgICBjb25zdCBUID0gcmVxdWlyZShcIkBzcGx1bmsvdWktdXRpbHMvaTE4blwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvdWktdXRpbHMvaWRcIlxuICAgIGNvbnN0IGogPSByZXF1aXJlKFwiQHNwbHVuay91aS11dGlscy9pZFwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pbmNsdWRlc1wiXG4gICAgY29uc3QgRCA9IHJlcXVpcmUoXCJsb2Rhc2gvaW5jbHVkZXNcIik7XG4gICAgdmFyIHEgPSAgZS5uKEQpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwibG9kYXNoL3dpdGhvdXRcIlxuICAgIGNvbnN0IEEgPSByZXF1aXJlKFwibG9kYXNoL3dpdGhvdXRcIik7XG4gICAgdmFyIFAgPSAgZS5uKEEpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwic3R5bGVkLWNvbXBvbmVudHNcIlxuICAgIGNvbnN0IF8gPSByZXF1aXJlKFwic3R5bGVkLWNvbXBvbmVudHNcIik7XG4gICAgdmFyIHogPSAgZS5uKF8pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay90aGVtZXNcIlxuICAgIGNvbnN0IE0gPSByZXF1aXJlKFwiQHNwbHVuay90aGVtZXNcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvQm9keVN0eWxlcy50c1xuICAgIHZhciAkID0geigpLnRib2R5LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJCb2R5U3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMWs1cDZwcS0wXCJcbiAgICB9KShbIFwiXCIsIFwiIHotaW5kZXg6MDtcIiBdLCBNLm1peGlucy5yZXNldChcInRhYmxlLXJvdy1ncm91cFwiKSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvdXRpbHMvdXBkYXRlUmVhY3RSZWYudHNcbiAgICAvKipcbiAqIFVwZGF0ZXMgYSBSZWFjdCByZWYuIENhbGxiYWNrIHJlZnMgYW5kIG9iamVjdCByZWZzIChmcm9tIGBjcmVhdGVSZWZgIGFuZCBgdXNlUmVmYCkgYXJlIHN1cHBvcnRlZC5cbiAqXG4gKiBAcGFyYW0gcmVmIC0gVGhlIFJlYWN0IGNhbGxiYWNrIG9yIG9iamVjdCByZWYuIENhbiBiZSBgbnVsbGAgb3IgYHVuZGVmaW5lZGAuXG4gKiBAcGFyYW0gY3VycmVudCAtIFRoZSBuZXcgdmFsdWUgb2YgdGhlIHJlZi5cbiAqL1xuICAgIGZ1bmN0aW9uIE4oZSwgbikge1xuICAgICAgICBpZiAoZSkge1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBlID09PSBcImZ1bmN0aW9uXCIpIHtcbiAgICAgICAgICAgICAgICBlKG4pO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAvLyB0aGUgcHVibGljIHNpZ25hdHVyZSBvZiB0aGlzIHV0aWwgdXNlcyBSZWFjdC5SZWY8VD4gdG8gbWlycm9yIHRoZSB3YXkgUmVhY3QgdHlwZXMgcmVmcy5cbiAgICAgICAgICAgICAgICAvLyB0aGUgaW50ZW50aW9uIGhlcmUgaXMgdG8gc2lnbmFsIFwid2Ugd2lsbCB0YWtlIGNhcmUgb2Ygc2V0dGluZyAnY3VycmVudCcsIG5vdCB5b3VcIi5cbiAgICAgICAgICAgICAgICBlLmN1cnJlbnQgPSBuO1xuIC8vIGVzbGludC1kaXNhYmxlLWxpbmUgbm8tcGFyYW0tcmVhc3NpZ25cbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9Cb2R5LnRzeFxuICAgIGZ1bmN0aW9uIEwoKSB7XG4gICAgICAgIHJldHVybiBMID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IGFyZ3VtZW50c1tuXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciByIGluIHQpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsIHIpICYmIChlW3JdID0gdFtyXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIEwuYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gVyhlLCBuKSB7XG4gICAgICAgIHJldHVybiBGKGUpIHx8IFYoZSwgbikgfHwgSyhlLCBuKSB8fCBIKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEgoKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gZGVzdHJ1Y3R1cmUgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEsoZSwgbikge1xuICAgICAgICBpZiAoZSkge1xuICAgICAgICAgICAgaWYgKFwic3RyaW5nXCIgPT0gdHlwZW9mIGUpIHJldHVybiBCKGUsIG4pO1xuICAgICAgICAgICAgdmFyIHQgPSB7fS50b1N0cmluZy5jYWxsKGUpLnNsaWNlKDgsIC0xKTtcbiAgICAgICAgICAgIHJldHVybiBcIk9iamVjdFwiID09PSB0ICYmIGUuY29uc3RydWN0b3IgJiYgKHQgPSBlLmNvbnN0cnVjdG9yLm5hbWUpLCBcIk1hcFwiID09PSB0IHx8IFwiU2V0XCIgPT09IHQgPyBBcnJheS5mcm9tKGUpIDogXCJBcmd1bWVudHNcIiA9PT0gdCB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdCh0KSA/IEIoZSwgbikgOiB2b2lkIDA7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gQihlLCBuKSB7XG4gICAgICAgIChudWxsID09IG4gfHwgbiA+IGUubGVuZ3RoKSAmJiAobiA9IGUubGVuZ3RoKTtcbiAgICAgICAgZm9yICh2YXIgdCA9IDAsIHIgPSBBcnJheShuKTsgdCA8IG47IHQrKykge1xuICAgICAgICAgICAgclt0XSA9IGVbdF07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHI7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFYoZSwgbikge1xuICAgICAgICB2YXIgdCA9IG51bGwgPT0gZSA/IG51bGwgOiBcInVuZGVmaW5lZFwiICE9IHR5cGVvZiBTeW1ib2wgJiYgZVtTeW1ib2wuaXRlcmF0b3JdIHx8IGVbXCJAQGl0ZXJhdG9yXCJdO1xuICAgICAgICBpZiAobnVsbCAhPSB0KSB7XG4gICAgICAgICAgICB2YXIgciwgbywgaSwgYSwgbCA9IFtdLCB1ID0gITAsIHMgPSAhMTtcbiAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgaWYgKGkgPSAodCA9IHQuY2FsbChlKSkubmV4dCwgMCA9PT0gbikge1xuICAgICAgICAgICAgICAgICAgICBpZiAoT2JqZWN0KHQpICE9PSB0KSByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIHUgPSAhMTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgZm9yICg7ISh1ID0gKHIgPSBpLmNhbGwodCkpLmRvbmUpICYmIChsLnB1c2goci52YWx1ZSksIGwubGVuZ3RoICE9PSBuKTsgdSA9ICEwKSB7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgIHMgPSAhMCwgbyA9IGU7XG4gICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIGlmICghdSAmJiBudWxsICE9IHRbXCJyZXR1cm5cIl0gJiYgKGEgPSB0W1wicmV0dXJuXCJdKCksIE9iamVjdChhKSAhPT0gYSkpIHJldHVybjtcbiAgICAgICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgICAgICBpZiAocykgdGhyb3cgbztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gbDtcbiAgICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBGKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBVKGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCwgciwgbyA9IFgoZSwgbik7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgaSA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICBmb3IgKHIgPSAwOyByIDwgaS5sZW5ndGg7IHIrKykge1xuICAgICAgICAgICAgICAgIHQgPSBpW3JdLCAtMSA9PT0gbi5pbmRleE9mKHQpICYmIHt9LnByb3BlcnR5SXNFbnVtZXJhYmxlLmNhbGwoZSwgdCkgJiYgKG9bdF0gPSBlW3RdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbztcbiAgICB9XG4gICAgZnVuY3Rpb24gWChlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgdmFyIFkgPSB7XG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gR2VuZXJhbGx5IHBhc3NlZCBieSBUYWJsZSByYXRoZXIgdGhhbiBhZGRlZCBkaXJlY3RseS4gKi9cbiAgICAgICAgYWN0aW9uczogdygpLmJvb2wsXG4gICAgICAgIGNoaWxkcmVuOiB3KCkubm9kZSxcbiAgICAgICAgZWxlbWVudFJlZjogdygpLm9uZU9mVHlwZShbIHcoKS5mdW5jLCB3KCkub2JqZWN0IF0pLFxuICAgICAgICAvKiogQHByaXZhdGUuIEdlbmVyYWxseSBwYXNzZWQgYnkgVGFibGUgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIG1vdmFibGVDb2x1bW5zOiB3KCkuYm9vbCxcbiAgICAgICAgLyoqIEBwcml2YXRlLiBHZW5lcmFsbHkgcGFzc2VkIGJ5IFRhYmxlIHJhdGhlciB0aGFuIGFkZGVkIGRpcmVjdGx5LiAqL1xuICAgICAgICByb3dFeHBhbnNpb246IHcoKS5vbmVPZihbIFwic2luZ2xlXCIsIFwibXVsdGlcIiwgXCJub25lXCIsIFwiY29udHJvbGxlZFwiIF0pLFxuICAgICAgICAvKiogQHByaXZhdGUuIEdlbmVyYWxseSBwYXNzZWQgYnkgVGFibGUgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIG9uUmVxdWVzdE1vdmVSb3c6IHcoKS5mdW5jLFxuICAgICAgICAvKiogQHByaXZhdGUuIEdlbmVyYWxseSBwYXNzZWQgYnkgVGFibGUgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIHByaW1hcnlDb2x1bW5JbmRleDogdygpLm51bWJlcixcbiAgICAgICAgLyoqIEBwcml2YXRlLiBHZW5lcmFsbHkgcGFzc2VkIGJ5IFRhYmxlIHJhdGhlciB0aGFuIGFkZGVkIGRpcmVjdGx5LiAqL1xuICAgICAgICBzdHJpcGVSb3dzOiB3KCkuYm9vbFxuICAgIH07XG4gICAgZnVuY3Rpb24gRyhlKSB7XG4gICAgICAgIHZhciBuID0gZS5hY3Rpb25zLCBvID0gZS5jaGlsZHJlbiwgaSA9IGUuZWxlbWVudFJlZiwgYSA9IGUubW92YWJsZUNvbHVtbnMsIGwgPSBlLm9uUmVxdWVzdE1vdmVSb3csIHUgPSBlLnJvd0V4cGFuc2lvbiwgcyA9IHUgPT09IHZvaWQgMCA/IFwibm9uZVwiIDogdSwgYyA9IGUucHJpbWFyeUNvbHVtbkluZGV4LCBkID0gZS5zdHJpcGVSb3dzLCBmID0gVShlLCBbIFwiYWN0aW9uc1wiLCBcImNoaWxkcmVuXCIsIFwiZWxlbWVudFJlZlwiLCBcIm1vdmFibGVDb2x1bW5zXCIsIFwib25SZXF1ZXN0TW92ZVJvd1wiLCBcInJvd0V4cGFuc2lvblwiLCBcInByaW1hcnlDb2x1bW5JbmRleFwiLCBcInN0cmlwZVJvd3NcIiBdKTtcbiAvLyBAZG9jcy1wcm9wcy10eXBlIEJvZHlQcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICB2YXIgdiA9IFtdO1xuICAgICAgICB2YXIgcCA9ICgwLCB0LnVzZVN0YXRlKShbXSksIG0gPSBXKHAsIDIpLCBiID0gbVswXSwgaCA9IG1bMV07XG4gICAgICAgIHZhciB5ID0gKDAsIHQudXNlUmVmKShudWxsKTtcbiAgICAgICAgdmFyIGcgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHkuY3VycmVudCA9IGU7XG4gICAgICAgICAgICBOKGksIGUpO1xuICAgICAgICB9KSwgWyBpLCB5IF0pO1xuICAgICAgICB2YXIgdyA9IGZ1bmN0aW9uIGUobiwgdCwgcikge1xuICAgICAgICAgICAgdmFyIG8gPSBiO1xuICAgICAgICAgICAgaWYgKHMgPT09IFwic2luZ2xlXCIpIHtcbiAgICAgICAgICAgICAgICBpZiAocSgpKG8sIHQpKSB7XG4gICAgICAgICAgICAgICAgICAgIGgoW10pO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIGgoWyB0IF0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSBpZiAocyA9PT0gXCJtdWx0aVwiKSB7XG4gICAgICAgICAgICAgICAgaWYgKHEoKShvLCB0KSkge1xuICAgICAgICAgICAgICAgICAgICBoKFAoKShvLCB0KSk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgaChvID09PSBudWxsIHx8IG8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG8uY29uY2F0KHQpKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByID09PSBudWxsIHx8IHIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHIobik7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBDID0gdC5DaGlsZHJlbi50b0FycmF5KG8pLmZpbHRlcih0LmlzVmFsaWRFbGVtZW50KTtcbiAgICAgICAgdmFyIHggPSAoMCwgdC51c2VTdGF0ZSkobmV3IE1hcCksIFMgPSBXKHgsIDIpLCBPID0gU1swXSwgayA9IFNbMV07XG4gICAgICAgIHIoKS51c2VFZmZlY3QoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgaygoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgICAgIHZhciBuID0gbmV3IE1hcChlKTtcbiAgICAgICAgICAgICAgICB2YXIgciA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIEMuZm9yRWFjaCgoZnVuY3Rpb24obykge1xuICAgICAgICAgICAgICAgICAgICB2YXIgaTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCFvLnByb3BzLmV4cGFuc2lvblJvdykgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICB2YXIgYSA9IChpID0gby5rZXkpICE9PSBudWxsICYmIGkgIT09IHZvaWQgMCA/IGkgOiBDLmluZGV4T2Yobyk7XG4gICAgICAgICAgICAgICAgICAgIHZhciBsID0gdC5DaGlsZHJlbi5jb3VudChvLnByb3BzLmV4cGFuc2lvblJvdyk7XG4gICAgICAgICAgICAgICAgICAgIHZhciB1ID0gZS5nZXQoYSk7XG4gICAgICAgICAgICAgICAgICAgIGlmICghdSB8fCB1Lmxlbmd0aCAhPT0gbCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgbi5zZXQoYSwgQXJyYXkuZnJvbSh7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbGVuZ3RoOiBsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LCAoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuICgwLCBqLmNyZWF0ZURPTUlEKSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSkpKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHIgPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgIHJldHVybiByID8gbiA6IGU7XG4gICAgICAgICAgICB9KSk7XG4gICAgICAgIH0pLCBbIEMgXSk7XG4gICAgICAgIEMuZm9yRWFjaCgoZnVuY3Rpb24oZSwgcikge1xuICAgICAgICAgICAgaWYgKGUpIHtcbiAgICAgICAgICAgICAgICB2YXIgbywgaTtcbiAgICAgICAgICAgICAgICBpZiAoZmFsc2UpIHt9XG4gICAgICAgICAgICAgICAgdmFyIHUgPSAobyA9IGUua2V5KSAhPT0gbnVsbCAmJiBvICE9PSB2b2lkIDAgPyBvIDogcjtcbiAgICAgICAgICAgICAgICB2YXIgZiA9IHIgJSAyID8gXCJldmVuXCIgOiBcIm9kZFwiO1xuICAgICAgICAgICAgICAgIHZhciBwID0gZCA/IGYgOiBcIm5vbmVcIjtcbiAgICAgICAgICAgICAgICB2YXIgbSA9IHMgPT09IFwiY29udHJvbGxlZFwiID8gZS5wcm9wcy5leHBhbmRlZCA6IHEoKShiLCB1KTtcbiAgICAgICAgICAgICAgICB2YXIgaCA9IGZ1bmN0aW9uIG4odCkge1xuICAgICAgICAgICAgICAgICAgICB3KHQsIHUsIGUucHJvcHMub25FeHBhbnNpb24pO1xuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgdmFyIHkgPSBlLnByb3BzLmV4cGFuc2lvblJvdyA/IChpID0gTy5nZXQodSkpID09PSBudWxsIHx8IGkgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGkuam9pbihcIiBcIikgOiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgdi5wdXNoKCAoMCwgdC5jbG9uZUVsZW1lbnQpKGUsIHtcbiAgICAgICAgICAgICAgICAgICAgc3RyaXBlOiBwLFxuICAgICAgICAgICAgICAgICAgICBhY3Rpb25zOiBuLFxuICAgICAgICAgICAgICAgICAgICBleHBhbmRlZDogbSxcbiAgICAgICAgICAgICAgICAgICAgZXhwYW5zaW9uUm93SWRzOiB5LFxuICAgICAgICAgICAgICAgICAgICBleHBhbmRhYmxlOiBzICE9PSBcIm5vbmVcIixcbiAgICAgICAgICAgICAgICAgICAgaXNEcmFnZ2FibGU6ICEhbCxcbiAgICAgICAgICAgICAgICAgICAgbW92YWJsZUNvbHVtbnM6IGEsXG4gICAgICAgICAgICAgICAgICAgIHByaW1hcnlDb2x1bW5JbmRleDogYyxcbiAgICAgICAgICAgICAgICAgICAgb25FeHBhbnNpb246IGgsXG4gICAgICAgICAgICAgICAgICAgIGtleTogZS5rZXkgfHwgclxuICAgICAgICAgICAgICAgIH0pKTtcbiAgICAgICAgICAgICAgICBpZiAobSAmJiBlLnByb3BzLmV4cGFuc2lvblJvdykge1xuICAgICAgICAgICAgICAgICAgICB0LkNoaWxkcmVuLmZvckVhY2goZS5wcm9wcy5leHBhbnNpb25Sb3csIChmdW5jdGlvbihlLCBuKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgcjtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBvID0gKHIgPSBPLmdldCh1KSkgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogcltuXTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHYucHVzaCggKDAsIHQuY2xvbmVFbGVtZW50KShlLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAga2V5OiBvLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlkOiBvLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0cmlwZTogcCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBtb3ZhYmxlQ29sdW1uczogYSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImRhdGEtZXhwYW5zaW9uLXJvd1wiOiBcInRydWVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9KSk7XG4gICAgICAgIGlmICh2Lmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cbiAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudCgkLCBMKHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiYm9keVwiXG4gICAgICAgIH0sIGYsIHtcbiAgICAgICAgICAgIHJlZjogZ1xuICAgICAgICB9KSwgdik7XG4gICAgfVxuICAgIEcucHJvcFR5cGVzID0gWTtcbiAgICBHLnNwbHVua1VpVHlwZSA9IFwiVGFibGUuQm9keVwiO1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3QgSiA9IEc7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvVGFibGVTdHlsZXMudHNcbiAgICB2YXIgUSA9IHooKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlRhYmxlU3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMWNtZnNzNy0wXCJcbiAgICB9KShbIFwiXCIsIFwiO21heC13aWR0aDoxMDAlO3Bvc2l0aW9uOnJlbGF0aXZlO3otaW5kZXg6MTtAbWVkaWEgcHJpbnR7bWF4LWhlaWdodDpub25lICFpbXBvcnRhbnQ7fVwiIF0sIE0ubWl4aW5zLnJlc2V0KFwiYmxvY2tcIikpO1xuICAgIHZhciBaID0geigpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiVGFibGVTdHlsZXNfX1N0eWxlZFRhYmxlQ29udGFpbmVyXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFjbWZzczctMVwiXG4gICAgfSkoWyBcIm92ZXJmbG93OmF1dG87XCIsIFwiICY6OmJlZm9yZXtjb250ZW50OicnO3dpZHRoOjEwMCU7aGVpZ2h0OjA7dG9wOjA7cG9zaXRpb246YWJzb2x1dGU7fVwiIF0sIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kZHJhZ2dpbmc7XG4gICAgICAgIHJldHVybiBuICYmICgwLCBfLmNzcykoWyBcIm92ZXJmbG93OmhpZGRlbjtcIiBdKTtcbiAgICB9KSk7XG4gICAgdmFyIGVlID0geigpLnRhYmxlLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUYWJsZVN0eWxlc19fU3R5bGVkVGFibGVcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMWNtZnNzNy0yXCJcbiAgICB9KShbIFwiXCIsIFwiO3Bvc2l0aW9uOnJlbGF0aXZlO2JvcmRlci1jb2xsYXBzZTpjb2xsYXBzZTtib3JkZXItc3BhY2luZzowO21pbi13aWR0aDoxMDAlO3otaW5kZXg6MDtoZWlnaHQ6MXB4OyZbZGF0YS1maXhlZC1jb2x1bW49J3RydWUnXXt0YWJsZS1sYXlvdXQ6Zml4ZWQ7bWluLXdpZHRoOjA7d2lkdGg6MDt9XCIsIFwiIEBtZWRpYSBwcmludHt3aWR0aDoxMDAlO21heC13aWR0aDoxMDAlO3RhYmxlLWxheW91dDphdXRvO31cIiBdLCBNLm1peGlucy5yZXNldChcInRhYmxlXCIpLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJHJlc2l6YWJsZUZpbGxMYXlvdXQ7XG4gICAgICAgIHJldHVybiBuICYmICgwLCBfLmNzcykoWyBcIndpZHRoOjEwMCU7bWluLXdpZHRoOjEwMCU7dGFibGUtbGF5b3V0OmZpeGVkO1wiIF0pO1xuICAgIH0pKTtcbiAgICB2YXIgbmUgPSB6KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUYWJsZVN0eWxlc19fU3R5bGVkRG9ja2VkU2Nyb2xsYmFyXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFjbWZzczctM1wiXG4gICAgfSkoWyBcInBvc2l0aW9uOmZpeGVkO2JvdHRvbTowO292ZXJmbG93OmF1dG87ei1pbmRleDpjYWxjKFwiLCBcIiArIDEpO1wiIF0sIE0udmFyaWFibGVzLnppbmRleEZpeGVkTmF2YmFyKTtcbiAgICB2YXIgdGUgPSB6KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUYWJsZVN0eWxlc19fU3R5bGVkRG9ja2VkU2Nyb2xsYmFyQ29udGVudFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xY21mc3M3LTRcIlxuICAgIH0pKFsgXCJoZWlnaHQ6MXB4O1wiIF0pO1xuICAgIHZhciByZSA9IHooKS5jYXB0aW9uLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUYWJsZVN0eWxlc19fU3R5bGVkVGFibGVDYXB0aW9uXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFjbWZzczctNVwiXG4gICAgfSkoWyBcInBhZGRpbmc6XCIsIFwiIDA7Zm9udC1zaXplOlwiLCBcIjtjYXB0aW9uLXNpZGU6XCIsIFwiO1wiIF0sIE0udmFyaWFibGVzLnNwYWNpbmdYU21hbGwsIE0udmFyaWFibGVzLmZvbnRTaXplTGFyZ2UsIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS5zaWRlO1xuICAgICAgICByZXR1cm4gbjtcbiAgICB9KSk7XG4gICAgdmFyIG9lID0geigpLnRhYmxlLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUYWJsZVN0eWxlc19fU3R5bGVkRHJhZ1NoYWRvd1RhYmxlXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFjbWZzczctNlwiXG4gICAgfSkoWyBcImRpc3BsYXk6YmxvY2s7YmFja2dyb3VuZDpcIiwgXCI7Ym9yZGVyLWNvbGxhcHNlOmNvbGxhcHNlO2hlaWdodDpcIiwgXCI7d2lkdGg6XCIsIFwiO1wiIF0sIE0udmFyaWFibGVzLmludGVyYWN0aXZlQ29sb3JPdmVybGF5RHJhZywgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiRoZWlnaHQ7XG4gICAgICAgIHJldHVybiBcIlwiLmNvbmNhdChuLCBcInB4XCIpO1xuICAgIH0pLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJHdpZHRoO1xuICAgICAgICByZXR1cm4gXCJcIi5jb25jYXQobiwgXCJweFwiKTtcbiAgICB9KSk7XG4gICAgdmFyIGllID0geigpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiVGFibGVTdHlsZXNfX1N0eWxlZEd1aWRlTGluZVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xY21mc3M3LTdcIlxuICAgIH0pKFsgXCJwb3NpdGlvbjphYnNvbHV0ZTt3aWR0aDoxcHg7bGVmdDpcIiwgXCI7dG9wOjA7aGVpZ2h0OlwiLCBcIjtwb2ludGVyLWV2ZW50czpub25lO2JhY2tncm91bmQtY29sb3I6XCIsIFwiO1wiIF0sIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kbGVmdDtcbiAgICAgICAgcmV0dXJuIFwiXCIuY29uY2F0KG4sIFwicHhcIik7XG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kaGVpZ2h0O1xuICAgICAgICByZXR1cm4gXCJcIi5jb25jYXQobiwgXCJweFwiKTtcbiAgICB9KSwgTS52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvckFjY2VudCk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvQ2FwdGlvbi50c3hcbiAgICBmdW5jdGlvbiBhZSgpIHtcbiAgICAgICAgcmV0dXJuIGFlID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IGFyZ3VtZW50c1tuXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciByIGluIHQpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsIHIpICYmIChlW3JdID0gdFtyXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIGFlLmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGxlKGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCwgciwgbyA9IHVlKGUsIG4pO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChyID0gMDsgciA8IGkubGVuZ3RoOyByKyspIHtcbiAgICAgICAgICAgICAgICB0ID0gaVtyXSwgLTEgPT09IG4uaW5kZXhPZih0KSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHQpICYmIChvW3RdID0gZVt0XSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG87XG4gICAgfVxuICAgIGZ1bmN0aW9uIHVlKGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCA9IHt9O1xuICAgICAgICBmb3IgKHZhciByIGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIHIpKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSBuLmluZGV4T2YocikpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIHRbcl0gPSBlW3JdO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0O1xuICAgIH1cbiAgICB2YXIgc2UgPSB7XG4gICAgICAgIGNoaWxkcmVuOiB3KCkubm9kZS5pc1JlcXVpcmVkLFxuICAgICAgICBzaWRlOiB3KCkub25lT2YoWyBcInRvcFwiLCBcImJvdHRvbVwiIF0pXG4gICAgfTtcbiAgICAvKipcbiAqIFRhYmxlcyB0aGF0IHVzZSBhIGRvY2tlZCBoZWFkZXIgbXVzdCBwbGFjZSB0aGUgY2FwdGlvbiBvbiB0aGUgYm90dG9tIHNpZGUuXG4gKiBUYWJsZXMgdGhhdCB1c2UgYSBmaXhlZCBoZWFkZXIgY2Fubm90IHVzZSBjYXB0aW9ucy5cbiAqLyAgICBmdW5jdGlvbiBjZShlKSB7XG4gICAgICAgIHZhciBuID0gZS5jaGlsZHJlbiwgdCA9IGUuc2lkZSwgbyA9IHQgPT09IHZvaWQgMCA/IFwidG9wXCIgOiB0LCBpID0gbGUoZSwgWyBcImNoaWxkcmVuXCIsIFwic2lkZVwiIF0pO1xuICAgICAgICAvLyBAZG9jcy1wcm9wcy10eXBlIENhcHRpb25Qcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KHJlLCBhZSh7XG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImNhcHRpb25cIixcbiAgICAgICAgICAgIHNpZGU6IG9cbiAgICAgICAgfSwgaSksIG4pO1xuICAgIH1cbiAgICBjZS5wcm9wVHlwZXMgPSBzZTtcbiAgICBjZS5zcGx1bmtVaVR5cGUgPSBcIlRhYmxlLkNhcHRpb25cIjtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IGRlID0gY2U7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0J1dHRvblNpbXBsZVwiXG4gICAgY29uc3QgZmUgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9CdXR0b25TaW1wbGVcIik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvQ2VsbFN0eWxlcy50c1xuICAgIHZhciB2ZSA9IFwiMnB4XCI7XG4gICAgdmFyIHBlID0gKDAsIF8uY3NzKShbIFwiYm94LXNoYWRvdzpcIiwgXCI7XCIgXSwgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3dJbnNldCk7XG4gICAgdmFyIG1lID0geigpLnRkLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJDZWxsU3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMTk1NXhrMi0wXCJcbiAgICB9KShbIFwiXCIsIFwiIGxpbmUtaGVpZ2h0OlwiLCBcIjtwYWRkaW5nOlwiLCBcIiBcIiwgXCI7Ym9yZGVyLWxlZnQ6MCBzb2xpZCB0cmFuc3BhcmVudDtib3JkZXItcmlnaHQ6MCBzb2xpZCB0cmFuc3BhcmVudDtjb2xvcjpcIiwgXCI7d29yZC13cmFwOmJyZWFrLXdvcmQ7dmVydGljYWwtYWxpZ246dG9wOyo6d2hlcmUoYnV0dG9uKTpmb2N1cywmJiAqOmlzKDpoYXMoPiBpbnB1dDpmb2N1cykpOm5vdChbZGlzYWJsZWRdKXtib3gtc2hhZG93OlwiLCBcIjt9cGFkZGluZy1ibG9jazpcIiwgXCI7cGFkZGluZy1pbmxpbmU6XCIsIFwiO1wiLCBcIiBcIiwgXCIgXCIsIFwiIFtkYXRhLWV4cGFuc2lvbi1yb3c9J3RydWUnXSA+ICY6Zmlyc3QtY2hpbGR7cGFkZGluZy10b3A6OHB4O31bZGF0YS1leHBhbnNpb24tcm93PSd0cnVlJ10gPiAmOmxhc3QtY2hpbGR7cGFkZGluZy1ib3R0b206MTRweDt9XCIgXSwgTS5taXhpbnMucmVzZXQoXCJ0YWJsZS1jZWxsXCIpLCBNLnZhcmlhYmxlcy5saW5lSGVpZ2h0U3BhY2lvdXMsIHZlLCBNLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsIE0udmFyaWFibGVzLmNvbnRlbnRDb2xvckRlZmF1bHQsIE0udmFyaWFibGVzLmZvY3VzU2hhZG93SW5zZXQsICgwLCBcbiAgICBNLnBpY2spKHtcbiAgICAgICAgY29tZm9ydGFibGU6IFwiOHB4XCIsXG4gICAgICAgIGNvbXBhY3Q6IFwiNnB4XCJcbiAgICB9KSwgTS52YXJpYWJsZXMuc3BhY2luZ1NtYWxsLCAoMCwgTS5waWNrVmFyaWFudCkoXCIkdmFyaWFudFwiLCB7XG4gICAgICAgIGV4cGFuZDogKDAsIF8uY3NzKShbIFwiaGVpZ2h0OjEwMCU7cGFkZGluZzowO1wiIF0pLFxuICAgICAgICB0b2dnbGU6ICgwLCBfLmNzcykoWyBcImhlaWdodDoxMDAlO3BhZGRpbmc6MDtcIiBdKVxuICAgIH0pLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJHZhcmlhbnQsIHQgPSBlLiRpc1ByaW1hcnlDZWxsO1xuICAgICAgICByZXR1cm4gKDAsIE0ucGlja1ZhcmlhbnQpKFwiJGFwcGVhcmFuY2VcIiwge1xuICAgICAgICAgICAgZGF0YTogKDAsIF8uY3NzKShbIFwiXCIsIFwiXCIgXSwgbiA9PT0gXCJhY3Rpb25zXCIgJiYgKDAsIF8uY3NzKShbIFwiY3Vyc29yOmRlZmF1bHQ7cGFkZGluZy1ibG9jazpcIiwgXCI7cGFkZGluZy1pbmxpbmU6XCIsIFwiOyo6d2hlcmUoYnV0dG9uKXtcIiwgXCIgJjpmb2N1c3tib3gtc2hhZG93OlwiLCBcIjt9fVwiIF0sIHZlLCBNLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsICgwLCBcbiAgICAgICAgICAgIGZlLmJ1dHRvbk1peGluKShcInN1YnRsZVwiLCB7XG4gICAgICAgICAgICAgICAgY29sb3I6IE0udmFyaWFibGVzLmNvbnRlbnRDb2xvckRlZmF1bHRcbiAgICAgICAgICAgIH0pLCBNLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0KSksXG4gICAgICAgICAgICByb3dMaW5rOiAoMCwgXy5jc3MpKFsgXCJjb2xvcjpcIiwgXCI7Kjpob3ZlciA+ICYme2N1cnNvcjpwb2ludGVyO1wiLCBcIn1cIiBdLCBNLnZhcmlhYmxlcy5jb250ZW50Q29sb3JBY3RpdmUsIHQgJiYgKDAsIFxuICAgICAgICAgICAgXy5jc3MpKFsgXCJ0ZXh0LWRlY29yYXRpb246dW5kZXJsaW5lO1wiIF0pKSxcbiAgICAgICAgICAgIGxpbms6ICgwLCBfLmNzcykoWyBcImNvbG9yOlwiLCBcIjsmOmhvdmVye2N1cnNvcjpwb2ludGVyO3RleHQtZGVjb3JhdGlvbjp1bmRlcmxpbmU7fSY6Zm9jdXN7dGV4dC1kZWNvcmF0aW9uOnVuZGVybGluZTtib3gtc2hhZG93OlwiLCBcIjt9XCIgXSwgTS52YXJpYWJsZXMuY29udGVudENvbG9yTGluaywgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3dJbnNldClcbiAgICAgICAgfSk7XG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kY2xpY2thYmxlLCB0ID0gZS4kZm9jdXNXaXRoaW4sIHIgPSBlLiRzdHJpcGU7XG4gICAgICAgIHJldHVybiBuICYmICgwLCBfLmNzcykoWyBcImN1cnNvcjpwb2ludGVyOyY6aG92ZXJ7YmFja2dyb3VuZC1jb2xvcjpcIiwgXCI7fSY6Zm9jdXN7XCIsIFwiIGJhY2tncm91bmQtY29sb3I6XCIsIFwiO31cIiwgXCJcIiBdLCByID09PSBcImV2ZW5cIiA/IE0udmFyaWFibGVzLm5ldXRyYWwzMDAgOiBNLnZhcmlhYmxlcy5uZXV0cmFsMTAwLCBwZSwgciA9PT0gXCJldmVuXCIgPyBNLnZhcmlhYmxlcy5uZXV0cmFsMzAwIDogTS52YXJpYWJsZXMubmV1dHJhbDEwMCwgdCAmJiAoMCwgXG4gICAgICAgIF8uY3NzKShbIFwiJjpmb2N1cy13aXRoaW57XCIsIFwiIGJhY2tncm91bmQtY29sb3I6XCIsIFwiO31cIiBdLCBwZSwgciA9PT0gXCJldmVuXCIgPyBNLnZhcmlhYmxlcy5uZXV0cmFsMzAwIDogTS52YXJpYWJsZXMubmV1dHJhbDEwMCkpO1xuICAgIH0pKTtcbiAgICAvKlxuICogQSB3cmFwcGVyIGVuc3VyZXMgdGhhdCB0aGUgVGFibGUgQ2VsbCBjb250ZW50cyBhbGlnbiB0byB0aGUgdG9wIHdoaWxlIHN0YXlpbmcgd2l0aGluIHRoZSBoZWlnaHQgb2YgaW5wdXRIZWlnaHQuXG4gKiBUaGlzIGFsbG93cyB0ZXh0IHRvIGFsaWduIHByb3Blcmx5IHdpdGggZXhwYW5kIGFuZCBzZWxlY3QgaWNvbnMgd2hlbiBvdGhlciBjZWxsIGNvbnRlbnRzIGFyZSBsYXJnZXIuXG4gKi8gICAgdmFyIGJlID0geigpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiQ2VsbFN0eWxlc19fU3R5bGVkQ2VsbENvbnRlbnRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMTk1NXhrMi0xXCJcbiAgICB9KShbIFwiZGlzcGxheTpmbGV4O2FsaWduLWl0ZW1zOmZsZXgtc3RhcnQ7d29yZC1icmVhazpicmVhay13b3JkO1wiLCBcIiBcIiwgXCJcIiBdLCAoMCwgXG4gICAgTS5waWNrVmFyaWFudCkoXCIkdmFyaWFudFwiLCB7XG4gICAgICAgIGV4cGFuZDogKDAsIF8uY3NzKShbIFwiaGVpZ2h0OjEwMCU7XCIgXSksXG4gICAgICAgIHRvZ2dsZTogKDAsIF8uY3NzKShbIFwiaGVpZ2h0OjEwMCU7XCIgXSlcbiAgICB9KSwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiR2YXJpYW50LCB0ID0gZS4kYWxpZ247XG4gICAgICAgIHJldHVybiBuID8gKDAsIF8uY3NzKShbIFwiZGlzcGxheTpibG9jazt0ZXh0LWFsaWduOlwiLCBcIjtcIiBdLCB0KSA6ICgwLCBfLmNzcykoWyBcImp1c3RpZnktY29udGVudDpcIiwgXCI7dGV4dC1hbGlnbjpcIiwgXCI7XCIgXSwgdCwgdCk7XG4gICAgfSkpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0NlbGwudHN4XG4gICAgZnVuY3Rpb24gaGUoKSB7XG4gICAgICAgIHJldHVybiBoZSA9IE9iamVjdC5hc3NpZ24gPyBPYmplY3QuYXNzaWduLmJpbmQoKSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGZvciAodmFyIG4gPSAxOyBuIDwgYXJndW1lbnRzLmxlbmd0aDsgbisrKSB7XG4gICAgICAgICAgICAgICAgdmFyIHQgPSBhcmd1bWVudHNbbl07XG4gICAgICAgICAgICAgICAgZm9yICh2YXIgciBpbiB0KSB7XG4gICAgICAgICAgICAgICAgICAgICh7fSkuaGFzT3duUHJvcGVydHkuY2FsbCh0LCByKSAmJiAoZVtyXSA9IHRbcl0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9LCBoZS5hcHBseShudWxsLCBhcmd1bWVudHMpO1xuICAgIH1cbiAgICBmdW5jdGlvbiB5ZShlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSBnZShlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiBnZShlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgLyoqIEBwdWJsaWMgKi8gICAgdmFyIHdlID0ge1xuICAgICAgICBhbGlnbjogdygpLm9uZU9mKFsgXCJsZWZ0XCIsIFwiY2VudGVyXCIsIFwicmlnaHRcIiBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlICovXG4gICAgICAgIGFwcGVhcmFuY2U6IHcoKS5vbmVPZihbIFwiZGF0YVwiLCBcImxpbmtcIiwgXCJyb3dMaW5rXCIgXSksXG4gICAgICAgIC8qKiBAcHJpdmF0ZSBVc2VkIHRvIHNldCB0aGUgJGNsaWNrYWJsZSBhcHBlYXJhbmNlIHdpdGhvdXQgYW4gb25DbGljayAqL1xuICAgICAgICBhcHBlYXJDbGlja2FibGU6IHcoKS5ib29sLFxuICAgICAgICBjaGlsZHJlbjogdygpLm5vZGUsXG4gICAgICAgIGRhdGE6IHcoKS5hbnksXG4gICAgICAgIGVsZW1lbnRSZWY6IHcoKS5vbmVPZlR5cGUoWyB3KCkuZnVuYywgdygpLm9iamVjdCBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlICovXG4gICAgICAgIGlzUHJpbWFyeUNlbGw6IHcoKS5ib29sLFxuICAgICAgICBvbkNsaWNrOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlICovXG4gICAgICAgIG9uS2V5RG93bjogdygpLmZ1bmMsXG4gICAgICAgIC8qKiBAcHJpdmF0ZSAqL1xuICAgICAgICBkaXNhYmxlZDogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgZXhwYW5kOiB3KCkuYm9vbCxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBzdHJpcGU6IHcoKS5vbmVPZihbIFwib2RkXCIsIFwiZXZlblwiLCBcIm5vbmVcIiBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICB2YXJpYW50OiB3KCkub25lT2YoWyBcInRvZ2dsZVwiLCBcImV4cGFuZFwiLCBcImRyYWdcIiwgXCJhY3Rpb25zXCIgXSlcbiAgICB9O1xuICAgIGZ1bmN0aW9uIENlKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLmFsaWduLCBvID0gbiA9PT0gdm9pZCAwID8gXCJsZWZ0XCIgOiBuLCBpID0gZS5hcHBlYXJhbmNlLCBhID0gZS5hcHBlYXJDbGlja2FibGUsIGwgPSBlLmNoaWxkcmVuLCB1ID0gZS5kYXRhLCBzID0gZS5kaXNhYmxlZCwgYyA9IGUuZWxlbWVudFJlZiwgZCA9IGUuaXNQcmltYXJ5Q2VsbCwgZiA9IGUub25DbGljaywgdiA9IGUub25LZXlEb3duLCBwID0gZS5zdHJpcGUsIG0gPSBlLnZhcmlhbnQsIGIgPSB5ZShlLCBbIFwiYWxpZ25cIiwgXCJhcHBlYXJhbmNlXCIsIFwiYXBwZWFyQ2xpY2thYmxlXCIsIFwiY2hpbGRyZW5cIiwgXCJkYXRhXCIsIFwiZGlzYWJsZWRcIiwgXCJlbGVtZW50UmVmXCIsIFwiaXNQcmltYXJ5Q2VsbFwiLCBcIm9uQ2xpY2tcIiwgXCJvbktleURvd25cIiwgXCJzdHJpcGVcIiwgXCJ2YXJpYW50XCIgXSk7XG4gICAgICAgIC8vIEBkb2NzLXByb3BzLXR5cGUgQ2VsbFByb3BzQmFzZVxuICAgICAgICAgICAgICAgIHZhciBoID0gZiAhPT0gdW5kZWZpbmVkO1xuICAgICAgICB2YXIgeSA9IGEgfHwgaDtcbiAgICAgICAgdmFyIGcgPSB5ID8gXCJsaW5rXCIgOiBcImRhdGFcIjtcbiAgICAgICAgdmFyIHcgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIE4oYywgZSk7XG4gICAgICAgIH0pLCBbIGMgXSk7XG4gICAgICAgIHZhciBDID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBpZiAobSA9PT0gXCJhY3Rpb25zXCIpIHtcbiAgICAgICAgICAgICAgICAvLyBBY3Rpb24gYnV0dG9ucyBoYXZlIHRoZWlyIG93biBvbkNsaWNrcyBpbnNpZGUgdGhlIGNlbGwgc28gd2UgZG9uJ3Qgd2FudCBSb3cgb25DbGljayB0byBmaXJlXG4gICAgICAgICAgICAgICAgZS5zdG9wUHJvcGFnYXRpb24oKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGYgPT09IG51bGwgfHwgZiA9PT0gdm9pZCAwID8gdm9pZCAwIDogZihlLCB1KTtcbiAgICAgICAgfSksIFsgdSwgZiwgbSBdKTtcbiAgICAgICAgdmFyIHggPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmIChlLmtleSA9PT0gXCJFbnRlclwiKSB7XG4gICAgICAgICAgICAgICAgZiA9PT0gbnVsbCB8fCBmID09PSB2b2lkIDAgPyB2b2lkIDAgOiBmKGUsIHUpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdiA9PT0gbnVsbCB8fCB2ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB2KGUpO1xuICAgICAgICB9KSwgWyB1LCBmLCB2IF0pO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KG1lLCBoZSh7XG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImNlbGxcIixcbiAgICAgICAgICAgICRhcHBlYXJhbmNlOiBpIHx8IGcsXG4gICAgICAgICAgICAkY2xpY2thYmxlOiB5ID8gdHJ1ZSA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgICRkaXNhYmxlZDogISFzLFxuICAgICAgICAgICAgJGZvY3VzV2l0aGluOiBhLFxuICAgICAgICAgICAgJGlzUHJpbWFyeUNlbGw6IGQsXG4gICAgICAgICAgICAkc3RyaXBlOiBwLFxuICAgICAgICAgICAgJHZhcmlhbnQ6IG0sXG4gICAgICAgICAgICBvbkNsaWNrOiBDLFxuICAgICAgICAgICAgb25LZXlEb3duOiB4LFxuICAgICAgICAgICAgcmVmOiB3LFxuICAgICAgICAgICAgdGFiSW5kZXg6IGggPyAwIDogdW5kZWZpbmVkXG4gICAgICAgIH0sIGIpLCAgcigpLmNyZWF0ZUVsZW1lbnQoYmUsIHtcbiAgICAgICAgICAgICRhbGlnbjogbyxcbiAgICAgICAgICAgICR2YXJpYW50OiBtXG4gICAgICAgIH0sIGwpKTtcbiAgICB9XG4gICAgQ2UucHJvcFR5cGVzID0gd2U7XG4gICAgQ2Uuc3BsdW5rVWlUeXBlID0gXCJUYWJsZS5DZWxsXCI7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCB4ZSA9IENlO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwibG9kYXNoL2lzU3RyaW5nXCJcbiAgICBjb25zdCBTZSA9IHJlcXVpcmUoXCJsb2Rhc2gvaXNTdHJpbmdcIik7XG4gICAgdmFyIE9lID0gIGUubihTZSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvbWVyZ2VcIlxuICAgIGNvbnN0IGtlID0gcmVxdWlyZShcImxvZGFzaC9tZXJnZVwiKTtcbiAgICB2YXIgUmUgPSAgZS5uKGtlKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtaWNvbnMvUGFyYWxsZWxEb3RzXCJcbiAgICBjb25zdCBFZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LWljb25zL1BhcmFsbGVsRG90c1wiKTtcbiAgICB2YXIgSWUgPSAgZS5uKEVlKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvVG9vbHRpcFwiXG4gICAgY29uc3QgVGUgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9Ub29sdGlwXCIpO1xuICAgIHZhciBqZSA9ICBlLm4oVGUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS9EaXZpZGVyXCJcbiAgICBjb25zdCBEZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL0RpdmlkZXJcIik7XG4gICAgdmFyIHFlID0gIGUubihEZSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvSGVhZElubmVyU3R5bGVzLnRzXG4gICAgdmFyIEFlID0gNDtcbiAgICB2YXIgUGUgPSBBZTtcbiAvLyBXaGlsZSB0aGlzIGNvdWxkIHRoZW9yZXRpY2FsbHkgYmUgZGlmZmVyZW50LCBpdCBoZWxwcyBmb3IgY29oZXNpdml0eSBpbiBsb29rIGFuZCBmZWVsIHdoZW4gc29tZSBjb2x1bW5zIGFyZSB0cnVuY2F0ZWQgYW5kIG90aGVycyBhcmUgbm90LlxuICAgICAgICB2YXIgX2UgPSAoMCwgXy5jc3MpKFsgXCJkaXNwbGF5OmlubGluZS1mbGV4O2FsaWduLWl0ZW1zOmNlbnRlcjtncmlkLXJvdzoxO2hlaWdodDoxbGg7XCIgXSk7XG4gICAgdmFyIHplID0geigpLnNwYW4ud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRJbm5lclN0eWxlc19fU3R5bGVkSWNvblwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xc2Ewd25nLTBcIlxuICAgIH0pKFsgXCJcIiwgXCIgZ3JpZC1jb2x1bW46aWNvbjtcIiBdLCBfZSk7XG4gICAgdmFyIE1lID0geigpLnNwYW4ud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRJbm5lclN0eWxlc19fU3R5bGVkVG9vbHRpcEljb25cIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMXNhMHduZy0xXCJcbiAgICB9KShbIFwiXCIsIFwiIGdyaWQtY29sdW1uOnRvb2x0aXA7XCIgXSwgX2UpO1xuICAgIHZhciAkZSA9IHooKS5zcGFuLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJIZWFkSW5uZXJTdHlsZXNfX1N0eWxlZExhYmVsXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFzYTB3bmctMlwiXG4gICAgfSkoWyBcImdyaWQtY29sdW1uOmxhYmVsO2dyaWQtcm93OjEgLyAtMTtwb3NpdGlvbjpyZWxhdGl2ZTtoZWlnaHQ6MTAwJTtcIiwgXCIgXCIsIFwiIFwiLCBcIiBcIiwgXCJcIiBdLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJHZhcmlhbnQ7XG4gICAgICAgIHJldHVybiBuID09PSBcInRvZ2dsZUFsbFwiICYmICgwLCBfLmNzcykoWyBcImdyaWQtY29sdW1uOjEgLyAtMTtcIiBdKTtcbiAgICB9KSwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiRsYWJlbExlbmd0aDtcbiAgICAgICAgcmV0dXJuIG4gJiYgbiA+IFBlICYmICgwLCBfLmNzcykoWyBcIndvcmQtd3JhcDpicmVhay13b3JkO3dvcmQtYnJlYWs6YnJlYWstd29yZDtcIiBdKTtcbiAgICB9KSwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiR0cnVuY2F0ZSwgdCA9IGUuJGxhYmVsTGVuZ3RoO1xuICAgICAgICByZXR1cm4gbiAmJiB0ICYmIHQgPiBBZSAmJiAoMCwgXy5jc3MpKFsgXCJcIiwgXCIgbWluLXdpZHRoOjRjaDtcIiBdLCBNLm1peGlucy5lbGxpcHNpcygpKTtcbiAgICB9KSwgKDAsIE0ucGlja1ZhcmlhbnQpKFwiJGFsaWduXCIsIHtcbiAgICAgICAgcmlnaHQ6ICgwLCBfLmNzcykoWyBcIiYgPiAme3RleHQtYWxpZ246cmlnaHQ7fVwiIF0pLFxuICAgICAgICBsZWZ0OiAoMCwgXy5jc3MpKFsgXCImID4gJnt0ZXh0LWFsaWduOmxlZnQ7fVwiIF0pLFxuICAgICAgICBjZW50ZXI6ICgwLCBfLmNzcykoWyBcIiYgPiAme3RleHQtYWxpZ246Y2VudGVyO31cIiBdKVxuICAgIH0pKTtcbiAgICB2YXIgTmUgPSAoMCwgXy5jc3MpKFsgXCJib3gtc2hhZG93OlwiLCBcIjtvdXRsaW5lOm5vbmU7Y29sb3I6XCIsIFwiO3RleHQtZGVjb3JhdGlvbjp1bmRlcmxpbmU7XCIgXSwgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3dJbnNldCwgTS52YXJpYWJsZXMuY29udGVudENvbG9yQWN0aXZlKTtcbiAgICB2YXIgTGUgPSB6KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJIZWFkSW5uZXJTdHlsZXNfX1N0eWxlZFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xc2Ewd25nLTNcIlxuICAgIH0pKFsgXCJcIiwgXCI7XCIsIFwiO1wiLCBcIjtwb3NpdGlvbjpyZWxhdGl2ZTtcIiwgXCIgZ3JpZC10ZW1wbGF0ZS1yb3dzOjFsaCAxZnI7YWxpZ24taXRlbXM6c3RhcnQ7ZmxleC1ncm93OjE7aGVpZ2h0OjEwMCU7cGFkZGluZy1ibG9jazpcIiwgXCI7cGFkZGluZy1pbmxpbmU6XCIsIFwiO2p1c3RpZnktY29udGVudDpcIiwgXCI7XCIsIFwiIFwiLCBcIiBAbWVkaWEgcHJpbnR7YmFja2dyb3VuZC1pbWFnZTpub25lO31cIiwgXCJcIiBdLCBNLm1peGlucy5yZXNldChcImdyaWRcIiksIE0ubWl4aW5zLmNsZWFyZml4KCksIE0ubWl4aW5zLnR5cG9ncmFwaHkoXCJib2R5XCIsIHtcbiAgICAgICAgd2VpZ2h0OiBcImJvbGRcIlxuICAgIH0pLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJGhhc1Rvb2x0aXAsIHQgPSBlLiRoYXNJY29uO1xuICAgICAgICByZXR1cm4gKDAsIF8uY3NzKShbIFwiZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOltsYWJlbF0gYXV0byBcIiwgXCIgXCIsIFwiO2NvbHVtbi1nYXA6XCIsIFwiO1wiIF0sIG4gPyBcIlt0b29sdGlwXSBtaW4tY29udGVudFwiIDogXCJcIiwgdCA/IFwiW2ljb25dIG1pbi1jb250ZW50XCIgOiBcIlwiLCBuIHx8IHQgPyBNLnZhcmlhYmxlcy5zcGFjaW5nWFNtYWxsIDogMCk7XG4gICAgfSksICgwLCBNLnBpY2spKHtcbiAgICAgICAgY29tZm9ydGFibGU6IFwiOHB4XCIsXG4gICAgICAgIGNvbXBhY3Q6IFwiNnB4XCJcbiAgICB9KSwgTS52YXJpYWJsZXMuc3BhY2luZ1NtYWxsLCAoMCwgTS5waWNrVmFyaWFudCkoXCIkYWxpZ25cIiwge1xuICAgICAgICBjZW50ZXI6IFwiY2VudGVyXCIsXG4gICAgICAgIGxlZnQ6IFwiZmxleC1zdGFydFwiLFxuICAgICAgICByaWdodDogXCJmbGV4LWVuZFwiXG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kdmFyaWFudDtcbiAgICAgICAgcmV0dXJuIG4gJiYgKDAsIF8uY3NzKShbIFwiZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOjFmcjtncmlkLXRlbXBsYXRlLXJvd3M6MWZyO1wiIF0pO1xuICAgIH0pLCAoMCwgTS5waWNrVmFyaWFudCkoXCIkdmFyaWFudFwiLCB7XG4gICAgICAgIHRvZ2dsZUFsbDogKDAsIF8uY3NzKShbIFwicGFkZGluZzowO1wiIF0pLFxuICAgICAgICBhY3Rpb25zOiAoMCwgXy5jc3MpKFsgXCJwYWRkaW5nLWJsb2NrOjJweDtcIiBdKVxuICAgIH0pLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJGNsaWNrYWJsZSwgdCA9IGUuJGZvY3VzV2l0aGluO1xuICAgICAgICByZXR1cm4gbiAmJiAoMCwgXy5jc3MpKFsgXCJjdXJzb3I6cG9pbnRlcjsmOmZvY3Vze1wiLCBcIn1cIiwgXCIgJjpob3ZlcntvdXRsaW5lOm5vbmU7dGV4dC1kZWNvcmF0aW9uOnVuZGVybGluZTtjb2xvcjpcIiwgXCI7fVwiIF0sIE5lLCB0ICYmICgwLCBcbiAgICAgICAgXy5jc3MpKFsgXCImOmZvY3VzLXdpdGhpbntcIiwgXCJ9XCIgXSwgTmUpLCBNLnZhcmlhYmxlcy5jb250ZW50Q29sb3JBY3RpdmUpO1xuICAgIH0pKTtcbiAgICB2YXIgV2UgPSB6KCkocWUoKSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRJbm5lclN0eWxlc19fU3R5bGVkUmVzaXplXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFzYTB3bmctNFwiXG4gICAgfSkoWyBcIlwiLCBcIjtwb3NpdGlvbjphYnNvbHV0ZTtyaWdodDotNXB4O3dpZHRoOjlweDt0b3A6MDtib3R0b206MDt6LWluZGV4OjE7Y3Vyc29yOmNvbC1yZXNpemU7dGg6bGFzdC1jaGlsZCA+IGRpdiA+IFwiLCBcIiA+ICZ7cmlnaHQ6MXB4O3dpZHRoOjRweDt9Jjpob3ZlcntvdXRsaW5lOm5vbmU7Jjo6YmVmb3Jle2NvbnRlbnQ6Jyc7YmFja2dyb3VuZDpcIiwgXCI7cG9zaXRpb246YWJzb2x1dGU7bGVmdDo0cHg7d2lkdGg6MXB4O3RvcDowO2JvdHRvbTowO319Jjpmb2N1c3tvdXRsaW5lOm5vbmU7Jjo6YmVmb3Jle2NvbnRlbnQ6Jyc7cG9zaXRpb246YWJzb2x1dGU7YmFja2dyb3VuZDpcIiwgXCI7Ym94LXNoYWRvdzpcIiwgXCI7bGVmdDo0cHg7d2lkdGg6MXB4O3RvcDowO2JvdHRvbTowO319XCIgXSwgTS5taXhpbnMucmVzZXQoXCJibG9ja1wiKSwgLyogc2Mtc2VsICovIExlLCBNLnZhcmlhYmxlcy5ib3JkZXJDb2xvclN0cm9uZywgTS52YXJpYWJsZXMuZm9jdXNDb2xvciwgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3cpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0hlYWRDZWxsU3R5bGVzLnRzXG4gICAgdmFyIEhlID0geigpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSGVhZENlbGxTdHlsZXNfX1N0eWxlZElubmVyV3JhcHBlclwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xaGo4MXNhLTBcIlxuICAgIH0pKFsgXCJkaXNwbGF5OmZsZXg7aGVpZ2h0OjEwMCU7YWxpZ24taXRlbXM6ZmxleC1zdGFydDtcIiBdKTtcbiAgICB2YXIgS2UgPSB6KCkudGgud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRDZWxsU3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMWhqODFzYS0xXCJcbiAgICB9KShbIFwiXCIsIFwiIGxpbmUtaGVpZ2h0OlwiLCBcIjtiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjtib3gtc2l6aW5nOmNvbnRlbnQtYm94O3RleHQtYWxpZ246bGVmdDt2ZXJ0aWNhbC1hbGlnbjpcIiwgXCI7cG9zaXRpb246cmVsYXRpdmU7aGVpZ2h0OjEwMCU7Jjpub3QoOmZpcnN0LWNoaWxkLDpoYXMoXCIsIFwiKSl7XCIsIFwie2JvcmRlci1sZWZ0OjFweCBzb2xpZCBcIiwgXCI7fX0mOmhhcyhcIiwgXCIpe1wiLCBcIntib3JkZXItcmlnaHQ6MXB4IHNvbGlkIFwiLCBcIjt9fSY6bnRoLWxhc3QtY2hpbGQoMik6aGFzKFwiLCBcIikgKyAmOmxhc3QtY2hpbGR7XCIsIFwie2JvcmRlci1sZWZ0Om5vbmU7fX0qOndoZXJlKGJ1dHRvbik6Zm9jdXN7Ym94LXNoYWRvdzpcIiwgXCI7fVwiLCBcIiBcIiwgXCIgXCIsIFwiXCIgXSwgTS5taXhpbnMucmVzZXQoXCJ0YWJsZS1jZWxsXCIpLCBNLnZhcmlhYmxlcy5saW5lSGVpZ2h0U3BhY2lvdXMsIE0udmFyaWFibGVzLm5ldXRyYWwxMDAsIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kdmFyaWFudDtcbiAgICAgICAgcmV0dXJuIG4gPyBcIm1pZGRsZVwiIDogXCJ0b3BcIjtcbiAgICB9KSwgV2UsIC8qIHNjLXNlbCAqLyBIZSwgTS52YXJpYWJsZXMuYm9yZGVyQ29sb3JXZWFrLCBXZSwgLyogc2Mtc2VsICovIEhlLCBNLnZhcmlhYmxlcy5ib3JkZXJDb2xvciwgV2UsIC8qIHNjLXNlbCAqLyBIZSwgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3dJbnNldCwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiRpc0RyYWdnaW5nO1xuICAgICAgICByZXR1cm4gbiAmJiAoMCwgXy5jc3MpKFsgXCJiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjsmOmZvY3Vze2JveC1zaGFkb3c6bm9uZTt9XCIgXSwgTS52YXJpYWJsZXMuYmFja2dyb3VuZENvbG9yUGFnZSk7XG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kdmFyaWFudDtcbiAgICAgICAgcmV0dXJuIG4gJiYgKDAsIF8uY3NzKShbIFwiJjpmaXJzdC1jaGlsZCArICZ7XCIsIFwie2JvcmRlci1sZWZ0OjFweCBzb2xpZCBcIiwgXCI7fX1cIiBdLCBIZSwgTS52YXJpYWJsZXMuYm9yZGVyQ29sb3JXZWFrKTtcbiAgICB9KSwgKDAsIE0ucGlja1ZhcmlhbnQpKFwiJHZhcmlhbnRcIiwge1xuICAgICAgICBhY3Rpb25zOiAoMCwgXy5jc3MpKFsgXCIqOndoZXJlKGJ1dHRvbil7XCIsIFwiICY6Zm9jdXN7Ym94LXNoYWRvdzpcIiwgXCI7fX1cIiBdLCAoMCwgZmUuYnV0dG9uTWl4aW4pKFwic3VidGxlXCIsIHtcbiAgICAgICAgICAgIGNvbG9yOiBNLnZhcmlhYmxlcy5jb250ZW50Q29sb3JEZWZhdWx0XG4gICAgICAgIH0pLCBNLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0KVxuICAgIH0pKTtcbiAgICB2YXIgQmUgPSB6KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJIZWFkQ2VsbFN0eWxlc19fU3R5bGVkSWNvblwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xaGo4MXNhLTJcIlxuICAgIH0pKFsgXCJkaXNwbGF5OmlubGluZS1mbGV4O2FsaWduLWl0ZW1zOmNlbnRlcjtoZWlnaHQ6MWxoO1wiIF0pO1xuICAgIC8vIFRPRE8oU1VJLTc0MDApOiBSZWZhY3RvciB0aGUgZHJhZyBoYW5kbGVyIG9mIHJlLW9yZGVyIGNvbHVtblxuICAgICAgICB2YXIgVmUgPSB6KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJIZWFkQ2VsbFN0eWxlc19fU3R5bGVkRHJhZ0hhbmRsZXJcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMWhqODFzYS0zXCJcbiAgICB9KShbIFwiZGlzcGxheTppbmxpbmUtZmxleDthbGlnbi1pdGVtczpzdGFydDthbGlnbi1zZWxmOnN0cmV0Y2g7anVzdGlmeS1jb250ZW50OmNlbnRlcjttaW4td2lkdGg6MjBweDtjdXJzb3I6bW92ZTtwYWRkaW5nLWJsb2NrOlwiLCBcIjstd2Via2l0LXVzZXItc2VsZWN0Om5vbmU7LW1vei11c2VyLXNlbGVjdDpub25lO3VzZXItc2VsZWN0Om5vbmU7Jjpob3ZlcntiYWNrZ3JvdW5kOlwiLCBcIjtjb2xvcjpcIiwgXCI7fSY6Zm9jdXN7YmFja2dyb3VuZDpcIiwgXCI7Ym94LXNoYWRvdzpcIiwgXCI7Y29sb3I6XCIsIFwiO31cIiBdLCAoMCwgXG4gICAgTS5waWNrKSh7XG4gICAgICAgIGNvbWZvcnRhYmxlOiBcIjhweFwiLFxuICAgICAgICBjb21wYWN0OiBcIjZweFwiXG4gICAgfSksIE0udmFyaWFibGVzLmludGVyYWN0aXZlQ29sb3JPdmVybGF5SG92ZXIsIE0udmFyaWFibGVzLmNvbnRlbnRDb2xvckFjdGl2ZSwgTS52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlEcmFnLCBNLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0LCBNLnZhcmlhYmxlcy5jb250ZW50Q29sb3JBY3RpdmUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9BcnJvd0Rvd25cIlxuICAgIGNvbnN0IEZlID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvQXJyb3dEb3duXCIpO1xuICAgIHZhciBVZSA9ICBlLm4oRmUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9BcnJvd1VwXCJcbiAgICBjb25zdCBYZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LWljb25zL0Fycm93VXBcIik7XG4gICAgdmFyIFllID0gIGUubihYZSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LWljb25zL0Fycm93VXBEb3duXCJcbiAgICBjb25zdCBHZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LWljb25zL0Fycm93VXBEb3duXCIpO1xuICAgIHZhciBKZSA9ICBlLm4oR2UpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9DYXJldFNtYWxsRG93blwiXG4gICAgY29uc3QgUWUgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC1pY29ucy9DYXJldFNtYWxsRG93blwiKTtcbiAgICB2YXIgWmUgPSAgZS5uKFFlKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtaWNvbnMvSW5mb3JtYXRpb25DaXJjbGVcIlxuICAgIGNvbnN0IGVuID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvSW5mb3JtYXRpb25DaXJjbGVcIik7XG4gICAgdmFyIG5uID0gIGUubihlbik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvdXRpbHMvc3NyRG9jdW1lbnQudHNcbiAgICAvKiBlc2xpbnQtZGlzYWJsZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tZW1wdHktZnVuY3Rpb24gKi9cbiAgICB2YXIgdG4gPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIGFwcGVuZENoaWxkOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgYWRkRXZlbnRMaXN0ZW5lcjogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICByZW1vdmVFdmVudExpc3RlbmVyOiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIGFjdGl2ZUVsZW1lbnQ6IHtcbiAgICAgICAgICAgIGJsdXI6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIG5vZGVOYW1lOiBcIlwiXG4gICAgICAgIH0sXG4gICAgICAgIHF1ZXJ5U2VsZWN0b3I6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfSxcbiAgICAgICAgcXVlcnlTZWxlY3RvckFsbDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgfSxcbiAgICAgICAgZ2V0RWxlbWVudEJ5SWQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfSxcbiAgICAgICAgY3JlYXRlRXZlbnQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIGluaXRFdmVudDogZnVuY3Rpb24gZSgpIHt9XG4gICAgICAgICAgICB9O1xuICAgICAgICB9LFxuICAgICAgICBjcmVhdGVFbGVtZW50OiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBjaGlsZHJlbjogW10sXG4gICAgICAgICAgICAgICAgY2hpbGROb2RlczogW10sXG4gICAgICAgICAgICAgICAgc3R5bGU6IHt9LFxuICAgICAgICAgICAgICAgIHNldEF0dHJpYnV0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICAgICAgICAgIGdldEVsZW1lbnRzQnlUYWdOYW1lOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gW107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgY3JlYXRlRWxlbWVudE5TOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHt9O1xuICAgICAgICB9LFxuICAgICAgICBpbXBvcnROb2RlOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH0sXG4gICAgICAgIGxvY2F0aW9uOiB7XG4gICAgICAgICAgICBoYXNoOiBcIlwiLFxuICAgICAgICAgICAgaG9zdDogXCJcIixcbiAgICAgICAgICAgIGhvc3RuYW1lOiBcIlwiLFxuICAgICAgICAgICAgaHJlZjogXCJcIixcbiAgICAgICAgICAgIG9yaWdpbjogXCJcIixcbiAgICAgICAgICAgIHBhdGhuYW1lOiBcIlwiLFxuICAgICAgICAgICAgcHJvdG9jb2w6IFwiXCIsXG4gICAgICAgICAgICBzZWFyY2g6IFwiXCJcbiAgICAgICAgfVxuICAgIH07XG4gICAgZnVuY3Rpb24gcm4oKSB7XG4gICAgICAgIHZhciBlID0gdHlwZW9mIGRvY3VtZW50ICE9PSBcInVuZGVmaW5lZFwiID8gZG9jdW1lbnQgOiB0bjtcbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfVxuICAgIHZhciBvbiA9IHJuKCk7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBhbiA9IC8qIHVudXNlZCBwdXJlIGV4cHJlc3Npb24gb3Igc3VwZXIgKi8gbnVsbCAmJiBvbjtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy91dGlscy9zc3JXaW5kb3cudHNcbiAgICAvKiBlc2xpbnQtZGlzYWJsZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tZW1wdHktZnVuY3Rpb24gKi9cbiAgICB2YXIgbG4gPSB7XG4gICAgICAgIGRvY3VtZW50OiB0bixcbiAgICAgICAgbmF2aWdhdG9yOiB7XG4gICAgICAgICAgICB1c2VyQWdlbnQ6IFwiXCJcbiAgICAgICAgfSxcbiAgICAgICAgbG9jYXRpb246IHtcbiAgICAgICAgICAgIGhhc2g6IFwiXCIsXG4gICAgICAgICAgICBob3N0OiBcIlwiLFxuICAgICAgICAgICAgaG9zdG5hbWU6IFwiXCIsXG4gICAgICAgICAgICBocmVmOiBcIlwiLFxuICAgICAgICAgICAgb3JpZ2luOiBcIlwiLFxuICAgICAgICAgICAgcGF0aG5hbWU6IFwiXCIsXG4gICAgICAgICAgICBwcm90b2NvbDogXCJcIixcbiAgICAgICAgICAgIHNlYXJjaDogXCJcIlxuICAgICAgICB9LFxuICAgICAgICBoaXN0b3J5OiB7XG4gICAgICAgICAgICByZXBsYWNlU3RhdGU6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIHB1c2hTdGF0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICAgICAgZ286IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgICAgIGJhY2s6IGZ1bmN0aW9uIGUoKSB7fVxuICAgICAgICB9LFxuICAgICAgICBDdXN0b21FdmVudDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzO1xuICAgICAgICB9LFxuICAgICAgICBhZGRFdmVudExpc3RlbmVyOiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIHJlbW92ZUV2ZW50TGlzdGVuZXI6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgZ2V0Q29tcHV0ZWRTdHlsZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgZ2V0UHJvcGVydHlWYWx1ZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFwiXCI7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgSW1hZ2U6IGZ1bmN0aW9uIGUoKSB7fSxcbiAgICAgICAgRGF0ZTogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICBzY3JlZW46IHt9LFxuICAgICAgICBzZXRUaW1lb3V0OiBmdW5jdGlvbiBlKCkge30sXG4gICAgICAgIGNsZWFyVGltZW91dDogZnVuY3Rpb24gZSgpIHt9LFxuICAgICAgICBtYXRjaE1lZGlhOiBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgcmV0dXJuIHt9O1xuICAgICAgICB9LFxuICAgICAgICByZXF1ZXN0QW5pbWF0aW9uRnJhbWU6IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBzZXRUaW1lb3V0ID09PSBcInVuZGVmaW5lZFwiKSB7XG4gICAgICAgICAgICAgICAgbigpO1xuICAgICAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHNldFRpbWVvdXQobiwgMCk7XG4gICAgICAgIH0sXG4gICAgICAgIGNhbmNlbEFuaW1hdGlvbkZyYW1lOiBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygc2V0VGltZW91dCA9PT0gXCJ1bmRlZmluZWRcIikge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGNsZWFyVGltZW91dChuKTtcbiAgICAgICAgfVxuICAgIH07XG4gICAgZnVuY3Rpb24gdW4oKSB7XG4gICAgICAgIHZhciBlID0gdHlwZW9mIHdpbmRvdyAhPT0gXCJ1bmRlZmluZWRcIiA/IHdpbmRvdyA6IGxuO1xuICAgICAgICByZXR1cm4gZTtcbiAgICB9XG4gICAgdmFyIHNuID0gdW4oKTtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IGNuID0gLyogdW51c2VkIHB1cmUgZXhwcmVzc2lvbiBvciBzdXBlciAqLyBudWxsICYmIHNuO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0hlYWRJbm5lci50c3hcbiAgICBmdW5jdGlvbiBkbigpIHtcbiAgICAgICAgcmV0dXJuIGRuID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IGFyZ3VtZW50c1tuXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciByIGluIHQpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsIHIpICYmIChlW3JdID0gdFtyXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIGRuLmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGZuKGUpIHtcbiAgICAgICAgcmV0dXJuIG1uKGUpIHx8IHBuKGUpIHx8IHluKGUpIHx8IHZuKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIHZuKCkge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFwiSW52YWxpZCBhdHRlbXB0IHRvIHNwcmVhZCBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gcG4oZSkge1xuICAgICAgICBpZiAoXCJ1bmRlZmluZWRcIiAhPSB0eXBlb2YgU3ltYm9sICYmIG51bGwgIT0gZVtTeW1ib2wuaXRlcmF0b3JdIHx8IG51bGwgIT0gZVtcIkBAaXRlcmF0b3JcIl0pIHJldHVybiBBcnJheS5mcm9tKGUpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBtbihlKSB7XG4gICAgICAgIGlmIChBcnJheS5pc0FycmF5KGUpKSByZXR1cm4gZ24oZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGJuKGUsIG4pIHtcbiAgICAgICAgcmV0dXJuIENuKGUpIHx8IHduKGUsIG4pIHx8IHluKGUsIG4pIHx8IGhuKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhuKCkge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFwiSW52YWxpZCBhdHRlbXB0IHRvIGRlc3RydWN0dXJlIG5vbi1pdGVyYWJsZSBpbnN0YW5jZS5cXG5JbiBvcmRlciB0byBiZSBpdGVyYWJsZSwgbm9uLWFycmF5IG9iamVjdHMgbXVzdCBoYXZlIGEgW1N5bWJvbC5pdGVyYXRvcl0oKSBtZXRob2QuXCIpO1xuICAgIH1cbiAgICBmdW5jdGlvbiB5bihlLCBuKSB7XG4gICAgICAgIGlmIChlKSB7XG4gICAgICAgICAgICBpZiAoXCJzdHJpbmdcIiA9PSB0eXBlb2YgZSkgcmV0dXJuIGduKGUsIG4pO1xuICAgICAgICAgICAgdmFyIHQgPSB7fS50b1N0cmluZy5jYWxsKGUpLnNsaWNlKDgsIC0xKTtcbiAgICAgICAgICAgIHJldHVybiBcIk9iamVjdFwiID09PSB0ICYmIGUuY29uc3RydWN0b3IgJiYgKHQgPSBlLmNvbnN0cnVjdG9yLm5hbWUpLCBcIk1hcFwiID09PSB0IHx8IFwiU2V0XCIgPT09IHQgPyBBcnJheS5mcm9tKGUpIDogXCJBcmd1bWVudHNcIiA9PT0gdCB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdCh0KSA/IGduKGUsIG4pIDogdm9pZCAwO1xuICAgICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGduKGUsIG4pIHtcbiAgICAgICAgKG51bGwgPT0gbiB8fCBuID4gZS5sZW5ndGgpICYmIChuID0gZS5sZW5ndGgpO1xuICAgICAgICBmb3IgKHZhciB0ID0gMCwgciA9IEFycmF5KG4pOyB0IDwgbjsgdCsrKSB7XG4gICAgICAgICAgICByW3RdID0gZVt0XTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gcjtcbiAgICB9XG4gICAgZnVuY3Rpb24gd24oZSwgbikge1xuICAgICAgICB2YXIgdCA9IG51bGwgPT0gZSA/IG51bGwgOiBcInVuZGVmaW5lZFwiICE9IHR5cGVvZiBTeW1ib2wgJiYgZVtTeW1ib2wuaXRlcmF0b3JdIHx8IGVbXCJAQGl0ZXJhdG9yXCJdO1xuICAgICAgICBpZiAobnVsbCAhPSB0KSB7XG4gICAgICAgICAgICB2YXIgciwgbywgaSwgYSwgbCA9IFtdLCB1ID0gITAsIHMgPSAhMTtcbiAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgaWYgKGkgPSAodCA9IHQuY2FsbChlKSkubmV4dCwgMCA9PT0gbikge1xuICAgICAgICAgICAgICAgICAgICBpZiAoT2JqZWN0KHQpICE9PSB0KSByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIHUgPSAhMTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgZm9yICg7ISh1ID0gKHIgPSBpLmNhbGwodCkpLmRvbmUpICYmIChsLnB1c2goci52YWx1ZSksIGwubGVuZ3RoICE9PSBuKTsgdSA9ICEwKSB7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgIHMgPSAhMCwgbyA9IGU7XG4gICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIGlmICghdSAmJiBudWxsICE9IHRbXCJyZXR1cm5cIl0gJiYgKGEgPSB0W1wicmV0dXJuXCJdKCksIE9iamVjdChhKSAhPT0gYSkpIHJldHVybjtcbiAgICAgICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgICAgICBpZiAocykgdGhyb3cgbztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gbDtcbiAgICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBDbihlKSB7XG4gICAgICAgIGlmIChBcnJheS5pc0FycmF5KGUpKSByZXR1cm4gZTtcbiAgICB9XG4gICAgZnVuY3Rpb24geG4oZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0LCByLCBvID0gU24oZSwgbik7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgaSA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICBmb3IgKHIgPSAwOyByIDwgaS5sZW5ndGg7IHIrKykge1xuICAgICAgICAgICAgICAgIHQgPSBpW3JdLCAtMSA9PT0gbi5pbmRleE9mKHQpICYmIHt9LnByb3BlcnR5SXNFbnVtZXJhYmxlLmNhbGwoZSwgdCkgJiYgKG9bdF0gPSBlW3RdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbztcbiAgICB9XG4gICAgZnVuY3Rpb24gU24oZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0ID0ge307XG4gICAgICAgIGZvciAodmFyIHIgaW4gZSkge1xuICAgICAgICAgICAgaWYgKHt9Lmhhc093blByb3BlcnR5LmNhbGwoZSwgcikpIHtcbiAgICAgICAgICAgICAgICBpZiAoLTEgIT09IG4uaW5kZXhPZihyKSkgY29udGludWU7XG4gICAgICAgICAgICAgICAgdFtyXSA9IGVbcl07XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIHZhciBPbiA9IHtcbiAgICAgICAgYWxpZ246IHcoKS5vbmVPZihbIFwibGVmdFwiLCBcImNlbnRlclwiLCBcInJpZ2h0XCIgXSksXG4gICAgICAgIGNlbGxJZDogdygpLnN0cmluZyxcbiAgICAgICAgY2xpY2thYmxlOiB3KCkuYm9vbCxcbiAgICAgICAgY29sdW1uSWQ6IHcoKS5zdHJpbmcsXG4gICAgICAgIGVsZW1lbnRSZWY6IHcoKS5vbmVPZlR5cGUoWyB3KCkuZnVuYywgdygpLm9iamVjdCBdKSxcbiAgICAgICAgZm9jdXNXaXRoaW46IHcoKS5ib29sLFxuICAgICAgICBoYXNUb29sdGlwOiB3KCkuYm9vbCxcbiAgICAgICAgaW5kZXg6IHcoKS5udW1iZXIsXG4gICAgICAgIGlzTWVudTogdygpLmJvb2wsXG4gICAgICAgIGxhYmVsOiB3KCkubm9kZSxcbiAgICAgICAgb25BdXRvc2l6ZUNvbHVtbjogdygpLmZ1bmMsXG4gICAgICAgIG9uUmVxdWVzdFJlc2l6ZTogdygpLmZ1bmMsXG4gICAgICAgIHJlc2l6YWJsZTogdygpLmJvb2wsXG4gICAgICAgIHNvcnREaXI6IHcoKS5vbmVPZihbIFwibm9uZVwiLCBcImFzY1wiLCBcImRlc2NcIiBdKSxcbiAgICAgICAgdHJ1bmNhdGU6IHcoKS5ib29sLFxuICAgICAgICB3aWR0aDogdygpLm9uZU9mVHlwZShbIHcoKS5udW1iZXIsIHcoKS5vbmVPZihbIFwiYXV0b1wiIF0pIF0pLFxuICAgICAgICB2YXJpYW50OiB3KCkub25lT2YoWyBcInRvZ2dsZUFsbFwiLCBcImluZm9cIiwgXCJhY3Rpb25zXCIgXSlcbiAgICB9O1xuICAgIHZhciBrbiA9IG5ldyBTZXQoWyBcIm5vbmVcIiwgXCJhc2NcIiwgXCJkZXNjXCIgXSk7XG4gICAgdmFyIFJuID0gT2JqZWN0LmZyZWV6ZSh7XG4gICAgICAgIG5vbmU6ICgwLCBULl8pKFwiQ2xpY2sgdG8gc29ydFwiKSxcbiAgICAgICAgYXNjOiAoMCwgVC5fKShcIlByZXNzIHRvIHNvcnQgZGVzY2VuZGluZ1wiKSxcbiAgICAgICAgZGVzYzogKDAsIFQuXykoXCJQcmVzcyB0byBzb3J0IGFzY2VuZGluZ1wiKVxuICAgIH0pO1xuICAgIHZhciBFbiA9IE9iamVjdC5mcmVlemUoe1xuICAgICAgICBub25lOiBKZSgpLFxuICAgICAgICBhc2M6IFllKCksXG4gICAgICAgIGRlc2M6IFVlKClcbiAgICB9KTtcbiAgICBmdW5jdGlvbiBJbihlKSB7XG4gICAgICAgIHZhciBuID0gZS5hbGlnbiwgbyA9IG4gPT09IHZvaWQgMCA/IFwibGVmdFwiIDogbiwgaSA9IGUuY2xpY2thYmxlLCBhID0gZS5jZWxsSWQsIGwgPSBlLmNvbHVtbklkLCB1ID0gZS5lbGVtZW50UmVmLCBzID0gZS5mb2N1c1dpdGhpbiwgYyA9IGUuaGFzVG9vbHRpcCwgZCA9IGUuaW5kZXgsIGYgPSBlLmlzTWVudSwgdiA9IGUubGFiZWwsIHAgPSBlLm9uQXV0b3NpemVDb2x1bW4sIG0gPSBlLm9uUmVxdWVzdFJlc2l6ZSwgaCA9IGUucmVzaXphYmxlLCB5ID0gaCA9PT0gdm9pZCAwID8gdHJ1ZSA6IGgsIGcgPSBlLnNvcnREaXIsIHcgPSBlLnRydW5jYXRlLCBDID0gdyA9PT0gdm9pZCAwID8gdHJ1ZSA6IHcsIFMgPSBlLnZhcmlhbnQsIE8gPSBlLndpZHRoLCBrID0geG4oZSwgWyBcImFsaWduXCIsIFwiY2xpY2thYmxlXCIsIFwiY2VsbElkXCIsIFwiY29sdW1uSWRcIiwgXCJlbGVtZW50UmVmXCIsIFwiZm9jdXNXaXRoaW5cIiwgXCJoYXNUb29sdGlwXCIsIFwiaW5kZXhcIiwgXCJpc01lbnVcIiwgXCJsYWJlbFwiLCBcIm9uQXV0b3NpemVDb2x1bW5cIiwgXCJvblJlcXVlc3RSZXNpemVcIiwgXCJyZXNpemFibGVcIiwgXCJzb3J0RGlyXCIsIFwidHJ1bmNhdGVcIiwgXCJ2YXJpYW50XCIsIFwid2lkdGhcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBIZWFkSW5uZXJQcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICB2YXIgUiA9ICgwLCBULl8pKFwiQ2xpY2sgdG8gb3BlbiBtZW51XCIpO1xuICAgICAgICB2YXIgRSA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB0eXBlb2YgdiA9PT0gXCJzdHJpbmdcIiA/IHYubGVuZ3RoIDogMDtcbiAgICAgICAgfSksIFsgdiBdKTtcbiAgICAgICAgdmFyIGogPSAoMCwgdC51c2VTdGF0ZSkoZmFsc2UpLCBEID0gYm4oaiwgMiksIHEgPSBEWzBdLCBBID0gRFsxXTtcbiAgICAgICAgdmFyIFAgPSAoMCwgdC51c2VTdGF0ZSkoMCksIF8gPSBibihQLCAyKSwgeiA9IF9bMF0sIE0gPSBfWzFdO1xuICAgICAgICB2YXIgJCA9ICgwLCB0LnVzZVN0YXRlKSgwKSwgTCA9IGJuKCQsIDIpLCBXID0gTFswXSwgSCA9IExbMV07XG4gICAgICAgIHZhciBLID0gKDAsIHQudXNlUmVmKShudWxsKTtcbiAgICAgICAgdmFyIEIgPSAoMCwgdC51c2VSZWYpKE8gPT09IFwiYXV0b1wiID8gdW5kZWZpbmVkIDogTyk7XG4gICAgICAgIHZhciBWO1xuICAgICAgICB2YXIgRjtcbiAgICAgICAgaWYgKGcgIT09IHVuZGVmaW5lZCAmJiBrbi5oYXMoZykpIHtcbiAgICAgICAgICAgIFYgPSBFbltnXTtcbiAgICAgICAgICAgIEYgPSBSbltnXTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoTyA9PT0gXCJhdXRvXCIpIHtcbiAgICAgICAgICAgIHZhciBVO1xuICAgICAgICAgICAgdmFyIFggPSBLLmN1cnJlbnQ7XG4gICAgICAgICAgICB2YXIgWSA9IFggPT09IG51bGwgfHwgWCA9PT0gdm9pZCAwID8gdm9pZCAwIDogKFUgPSBYLnBhcmVudEVsZW1lbnQpID09PSBudWxsIHx8IFUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IFUuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7XG4gICAgICAgICAgICBCLmN1cnJlbnQgPSBZID09PSBudWxsIHx8IFkgPT09IHZvaWQgMCA/IHZvaWQgMCA6IFkud2lkdGg7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBCLmN1cnJlbnQgPSBPO1xuICAgICAgICB9XG4gICAgICAgIHZhciBHID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBLLmN1cnJlbnQgPSBlO1xuICAgICAgICAgICAgTih1LCBlKTtcbiAgICAgICAgfSksIFsgdSwgSyBdKTtcbiAgICAgICAgdmFyIEogPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciBuID0gZS5rZXk7XG4gICAgICAgICAgICBpZiAobSA9PT0gdW5kZWZpbmVkIHx8IGQgPT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChPID09PSBcImF1dG9cIikge1xuICAgICAgICAgICAgICAgIHZhciB0O1xuICAgICAgICAgICAgICAgIHZhciByID0gSy5jdXJyZW50O1xuICAgICAgICAgICAgICAgIHZhciBvID0gciA9PT0gbnVsbCB8fCByID09PSB2b2lkIDAgPyB2b2lkIDAgOiAodCA9IHIucGFyZW50RWxlbWVudCkgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTtcbiAgICAgICAgICAgICAgICBCLmN1cnJlbnQgPSBvID09PSBudWxsIHx8IG8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG8ud2lkdGg7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIEIuY3VycmVudCA9IE87XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoQi5jdXJyZW50ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAobiA9PT0gXCJBcnJvd0xlZnRcIikge1xuICAgICAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAvLyBwcmV2ZW50IHRleHQgc2VsZWN0aW9uXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBpID0gTWF0aC5tYXgoQi5jdXJyZW50IC0gMTAsIDIwKTtcbiAgICAgICAgICAgICAgICBtKGUsIHtcbiAgICAgICAgICAgICAgICAgICAgaW5kZXg6IGQsXG4gICAgICAgICAgICAgICAgICAgIGNvbHVtbklkOiBsLFxuICAgICAgICAgICAgICAgICAgICBpZDogYSxcbiAgICAgICAgICAgICAgICAgICAgd2lkdGg6IGlcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChuID09PSBcIkFycm93UmlnaHRcIikge1xuICAgICAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAvLyBwcmV2ZW50IHRleHQgc2VsZWN0aW9uXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciB1ID0gQi5jdXJyZW50ICsgMTA7XG4gICAgICAgICAgICAgICAgbShlLCB7XG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiBkLFxuICAgICAgICAgICAgICAgICAgICBjb2x1bW5JZDogbCxcbiAgICAgICAgICAgICAgICAgICAgaWQ6IGEsXG4gICAgICAgICAgICAgICAgICAgIHdpZHRoOiB1XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAobiA9PT0gXCJFbnRlclwiKSB7XG4gICAgICAgICAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuIC8vIFNVSS03MzIwOiBwcmV2ZW50IHNvcnRpbmcgYW5kIGRyb3Bkb3duIG9wZW5pbmdcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgbCwgYSwgZCwgbSwgTyBdKTtcbiAgICAgICAgdmFyIFEgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmIChPID09PSBcImF1dG9cIikge1xuICAgICAgICAgICAgICAgIHZhciBuO1xuICAgICAgICAgICAgICAgIHZhciB0ID0gSy5jdXJyZW50O1xuICAgICAgICAgICAgICAgIHZhciByID0gdCA9PT0gbnVsbCB8fCB0ID09PSB2b2lkIDAgPyB2b2lkIDAgOiAobiA9IHQucGFyZW50RWxlbWVudCkgPT09IG51bGwgfHwgbiA9PT0gdm9pZCAwID8gdm9pZCAwIDogbi5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTtcbiAgICAgICAgICAgICAgICBCLmN1cnJlbnQgPSByID09PSBudWxsIHx8IHIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHIud2lkdGg7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIEIuY3VycmVudCA9IE87XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoQi5jdXJyZW50ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gLy8gcHJldmVudCB0ZXh0IHNlbGVjdGlvblxuICAgICAgICAgICAgICAgICAgICAgICAgTShlLmNsaWVudFgpO1xuICAgICAgICAgICAgSChCLmN1cnJlbnQgfHwgMCk7XG4gICAgICAgICAgICBBKHRydWUpO1xuICAgICAgICB9KSwgWyBPIF0pO1xuICAgICAgICB2YXIgWiA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgdmFyIHQgPSB6IC0gbi5jbGllbnRYO1xuICAgICAgICAgICAgdmFyIHIgPSBNYXRoLm1heChXIC0gdCwgMTYpO1xuICAgICAgICAgICAgaWYgKGQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgIG0gPT09IG51bGwgfHwgbSA9PT0gdm9pZCAwID8gdm9pZCAwIDogbShuLCB7XG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiBkLFxuICAgICAgICAgICAgICAgICAgICBjb2x1bW5JZDogbCxcbiAgICAgICAgICAgICAgICAgICAgaWQ6IGEsXG4gICAgICAgICAgICAgICAgICAgIHdpZHRoOiByXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH07XG4gICAgICAgIHZhciBlZSA9IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICBBKGZhbHNlKTtcbiAgICAgICAgfTtcbiAgICAgICAgdmFyIG5lID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBpZiAoZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIHtcbiAgICAgICAgICAgICAgICAgICAgaW5kZXg6IGQsXG4gICAgICAgICAgICAgICAgICAgIGNvbHVtbklkOiBsLFxuICAgICAgICAgICAgICAgICAgICBpZDogYVxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBhLCBsLCBkLCBwIF0pO1xuICAgICAgICB2YXIgdGUgPSB1bigpO1xuICAgICAgICB2YXIgcmUgPSBCLmN1cnJlbnQgPyAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIiUod2lkdGgpZCBwaXhlbHNcIiksIHtcbiAgICAgICAgICAgIHdpZHRoOiBCLmN1cnJlbnRcbiAgICAgICAgfSkgOiB1bmRlZmluZWQ7XG4gICAgICAgIFxuICAgICAgICByZXR1cm4gcigpLmNyZWF0ZUVsZW1lbnQoTGUsIGRuKHtcbiAgICAgICAgICAgIGFzOiBpID8gXCJidXR0b25cIiA6IFwiZGl2XCIsXG4gICAgICAgICAgICByZWY6IEcsXG4gICAgICAgICAgICAkYWxpZ246IG8sXG4gICAgICAgICAgICAkY2xpY2thYmxlOiBpLFxuICAgICAgICAgICAgJGZvY3VzV2l0aGluOiBzLFxuICAgICAgICAgICAgJGhhc0ljb246ICEhZiB8fCAhIWcsXG4gICAgICAgICAgICAkaGFzVG9vbHRpcDogISFjLFxuICAgICAgICAgICAgJHZhcmlhbnQ6IFMsXG4gICAgICAgICAgICAkbGFiZWxMZW5ndGg6IEVcbiAgICAgICAgfSwgYigpKGssIFtdLmNvbmNhdChmbihPYmplY3Qua2V5cyhJbi5wcm9wVHlwZXMpKSwgWyBcImlkXCIgXSkpKSwgcSAmJiAgcigpLmNyZWF0ZUVsZW1lbnQocigpLkZyYWdtZW50LCBudWxsLCAgcigpLmNyZWF0ZUVsZW1lbnQoeCgpLCB7XG4gICAgICAgICAgICB0YXJnZXQ6IHRlLFxuICAgICAgICAgICAgZXZlbnRUeXBlOiBcIm1vdXNldXBcIixcbiAgICAgICAgICAgIGxpc3RlbmVyOiBlZVxuICAgICAgICB9KSwgIHIoKS5jcmVhdGVFbGVtZW50KHgoKSwge1xuICAgICAgICAgICAgdGFyZ2V0OiB0ZSxcbiAgICAgICAgICAgIGV2ZW50VHlwZTogXCJtb3VzZW1vdmVcIixcbiAgICAgICAgICAgIGxpc3RlbmVyOiBaXG4gICAgICAgIH0pKSwgbSAmJiB5ICYmICByKCkuY3JlYXRlRWxlbWVudChXZSwge1xuICAgICAgICAgICAgXCJhcmlhLWxhYmVsXCI6ICgwLCBJLnNwcmludGYpKCgwLCBULl8pKFwiUmVzaXplICUobGFiZWwpc1wiKSwge1xuICAgICAgICAgICAgICAgIGxhYmVsOiB2XG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIFwiYXJpYS1jb250cm9sc1wiOiBhLFxuICAgICAgICAgICAgXCJhcmlhLXZhbHVldGV4dFwiOiByZSxcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwicmVzaXplXCIsXG4gICAgICAgICAgICBvbk1vdXNlRG93bjogUSxcbiAgICAgICAgICAgIG9uRG91YmxlQ2xpY2s6IG5lLFxuICAgICAgICAgICAgb25LZXlEb3duOiBKLFxuICAgICAgICAgICAgb3JpZW50YXRpb246IFwidmVydGljYWxcIixcbiAgICAgICAgICAgIHRhYkluZGV4OiAwXG4gICAgICAgIH0pLCAgcigpLmNyZWF0ZUVsZW1lbnQoJGUsIHtcbiAgICAgICAgICAgICRhbGlnbjogbyxcbiAgICAgICAgICAgICR0cnVuY2F0ZTogQyxcbiAgICAgICAgICAgICR2YXJpYW50OiBTLFxuICAgICAgICAgICAgJGxhYmVsTGVuZ3RoOiBFXG4gICAgICAgIH0sIHYpLCBjICYmICByKCkuY3JlYXRlRWxlbWVudChNZSwgbnVsbCwgIHIoKS5jcmVhdGVFbGVtZW50KG5uKCksIHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwidG9vbHRpcC1pY29uXCJcbiAgICAgICAgfSkpLCBmICYmICByKCkuY3JlYXRlRWxlbWVudCh6ZSwgbnVsbCwgIHIoKS5jcmVhdGVFbGVtZW50KFplKCksIHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiY2FyZXQtZG93blwiLFxuICAgICAgICAgICAgXCJhcmlhLWxhYmVsXCI6IFJcbiAgICAgICAgfSkpLCBnICYmICByKCkuY3JlYXRlRWxlbWVudCh6ZSwgbnVsbCwgViAhPT0gdW5kZWZpbmVkICYmICByKCkuY3JlYXRlRWxlbWVudChWLCB7XG4gICAgICAgICAgICBcImFyaWEtaGlkZGVuXCI6IGZhbHNlLFxuICAgICAgICAgICAgXCJhcmlhLWxhYmVsXCI6IEZcbiAgICAgICAgfSkpKTtcbiAgICB9XG4gICAgSW4ucHJvcFR5cGVzID0gT247XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBUbiA9IEluO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0hlYWRDZWxsLnRzeFxuICAgIGZ1bmN0aW9uIGpuKCkge1xuICAgICAgICByZXR1cm4gam4gPSBPYmplY3QuYXNzaWduID8gT2JqZWN0LmFzc2lnbi5iaW5kKCkgOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmb3IgKHZhciBuID0gMTsgbiA8IGFyZ3VtZW50cy5sZW5ndGg7IG4rKykge1xuICAgICAgICAgICAgICAgIHZhciB0ID0gYXJndW1lbnRzW25dO1xuICAgICAgICAgICAgICAgIGZvciAodmFyIHIgaW4gdCkge1xuICAgICAgICAgICAgICAgICAgICAoe30pLmhhc093blByb3BlcnR5LmNhbGwodCwgcikgJiYgKGVbcl0gPSB0W3JdKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfSwgam4uYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gRG4oZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0LCByLCBvID0gcW4oZSwgbik7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgaSA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICBmb3IgKHIgPSAwOyByIDwgaS5sZW5ndGg7IHIrKykge1xuICAgICAgICAgICAgICAgIHQgPSBpW3JdLCAtMSA9PT0gbi5pbmRleE9mKHQpICYmIHt9LnByb3BlcnR5SXNFbnVtZXJhYmxlLmNhbGwoZSwgdCkgJiYgKG9bdF0gPSBlW3RdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbztcbiAgICB9XG4gICAgZnVuY3Rpb24gcW4oZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0ID0ge307XG4gICAgICAgIGZvciAodmFyIHIgaW4gZSkge1xuICAgICAgICAgICAgaWYgKHt9Lmhhc093blByb3BlcnR5LmNhbGwoZSwgcikpIHtcbiAgICAgICAgICAgICAgICBpZiAoLTEgIT09IG4uaW5kZXhPZihyKSkgY29udGludWU7XG4gICAgICAgICAgICAgICAgdFtyXSA9IGVbcl07XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIC8qKiBAcHVibGljICovXG4gICAgLyoqIEBwdWJsaWMgKi8gICAgdmFyIEFuID0ge1xuICAgICAgICBhbGlnbjogdygpLm9uZU9mKFsgXCJsZWZ0XCIsIFwiY2VudGVyXCIsIFwicmlnaHRcIiBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlIFVzZWQgdG8gc2V0IHRoZSAkY2xpY2thYmxlIGFwcGVhcmFuY2Ugd2l0aG91dCBhbiBvbkNsaWNrICovXG4gICAgICAgIGFwcGVhckNsaWNrYWJsZTogdygpLmJvb2wsXG4gICAgICAgIGNoaWxkcmVuOiB3KCkubm9kZSxcbiAgICAgICAgY29sdW1uSWQ6IHcoKS5zdHJpbmcsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgZHJhZ0lkOiB3KCkub25lT2ZUeXBlKFsgdygpLnN0cmluZywgdygpLm51bWJlciBdKSxcbiAgICAgICAgZWxlbWVudFJlZjogdygpLm9uZU9mVHlwZShbIHcoKS5mdW5jLCB3KCkub2JqZWN0IF0pLFxuICAgICAgICBoZWFkQ2VsbFNjcmVlblJlYWRlclRleHQ6IHcoKS5zdHJpbmcsXG4gICAgICAgIC8qKiBAcHJpdmF0ZSBUaGUgaW5kZXggb2YgdGhlIGNlbGwsIHNraXBwaW5nIHRoZSBpbmZvIGNvbHVtbi4gKi9cbiAgICAgICAgaW5kZXg6IHcoKS5udW1iZXIsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25BdXRvc2l6ZUNvbHVtbjogdygpLmZ1bmMsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25DbGljazogdygpLmZ1bmMsXG4gICAgICAgIC8qKlxuICAgKiBAcHJpdmF0ZS4gUGFzc2VkIHRocm91Z2ggYW5kIHdvcmtzIGFzIGV4cGVjdGVkLlxuICAgKi9cbiAgICAgICAgb25LZXlEb3duOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBvblJlcXVlc3RNb3ZlQ29sdW1uOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBvblJlcXVlc3RSZXNpemU6IHcoKS5mdW5jLFxuICAgICAgICBvblNvcnQ6IHcoKS5mdW5jLFxuICAgICAgICByZXNpemFibGU6IHcoKS5ib29sLFxuICAgICAgICBzb3J0RGlyOiB3KCkub25lT2YoWyBcImFzY1wiLCBcImRlc2NcIiwgXCJub25lXCIgXSksXG4gICAgICAgIHNvcnRLZXk6IHcoKS5zdHJpbmcsXG4gICAgICAgIHRvb2x0aXA6IHcoKS5ub2RlLFxuICAgICAgICB0cnVuY2F0ZTogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgdmFyaWFudDogdygpLm9uZU9mKFsgXCJ0b2dnbGVBbGxcIiwgXCJpbmZvXCIsIFwiYWN0aW9uc1wiIF0pLFxuICAgICAgICAvKipcbiAgICogVXNlZCBpbnRlcm5hbGx5IHRvIHN1cHByZXNzIGZvY3VzIGFuZCBpZCB3aGVuIHRoaXMgYEhlYWRDZWxsYCBpcyBzdXBlcnNlZGVkIGJ5IG9uZSBpbiBhblxuICAgKiBvdmVybGFpZCBgSGVhZFRhYmxlYCBmb3IgdXNlciBpbnRlcmFjdGlvbnMuXG4gICAqIEBwcml2YXRlXG4gICAqL1xuICAgICAgICB2aXNpYmxlOiB3KCkuYm9vbCxcbiAgICAgICAgd2lkdGg6IHcoKS5vbmVPZlR5cGUoWyB3KCkubnVtYmVyLCB3KCkub25lT2YoWyBcImF1dG9cIiBdKSBdKVxuICAgIH07XG4gICAgdmFyIFBuID0ge1xuICAgICAgICBhc2M6IFwiYXNjZW5kaW5nXCIsXG4gICAgICAgIGRlc2M6IFwiZGVzY2VuZGluZ1wiLFxuICAgICAgICBub25lOiBcIm5vbmVcIlxuICAgIH07XG4gICAgZnVuY3Rpb24gX24oZSkge1xuICAgICAgICB2YXIgbjtcbiAgICAgICAgdmFyIG8gPSBlLmFsaWduLCBpID0gbyA9PT0gdm9pZCAwID8gXCJsZWZ0XCIgOiBvLCBsID0gZS5hcHBlYXJDbGlja2FibGUsIHUgPSBlLmNoaWxkcmVuLCBzID0gZS5jb2x1bW5JZCwgYyA9IGUuZWxlbWVudFJlZiwgZCA9IGUuZHJhZ0lkLCBmID0gZS5oZWFkQ2VsbFNjcmVlblJlYWRlclRleHQsIHYgPSBlLmlkLCBwID0gZS5pbmRleCwgbSA9IGUub25BdXRvc2l6ZUNvbHVtbiwgYiA9IGUub25DbGljaywgaCA9IGUub25LZXlEb3duLCB5ID0gZS5vblJlcXVlc3RNb3ZlQ29sdW1uLCBnID0gZS5vblJlcXVlc3RSZXNpemUsIHcgPSBlLm9uU29ydCwgQyA9IGUucmVzaXphYmxlLCB4ID0gQyA9PT0gdm9pZCAwID8gdHJ1ZSA6IEMsIFMgPSBlLnNvcnREaXIsIE8gPSBTID09PSB2b2lkIDAgPyBcIm5vbmVcIiA6IFMsIGsgPSBlLnNvcnRLZXksIFIgPSBlLnN0eWxlLCBFID0gZS50b29sdGlwLCBEID0gZS50cnVuY2F0ZSwgcSA9IEQgPT09IHZvaWQgMCA/IHRydWUgOiBELCBBID0gZS52YXJpYW50LCBQID0gZS52aXNpYmxlLCBfID0gUCA9PT0gdm9pZCAwID8gdHJ1ZSA6IFAsIHogPSBlLndpZHRoLCBNID0gRG4oZSwgWyBcImFsaWduXCIsIFwiYXBwZWFyQ2xpY2thYmxlXCIsIFwiY2hpbGRyZW5cIiwgXCJjb2x1bW5JZFwiLCBcImVsZW1lbnRSZWZcIiwgXCJkcmFnSWRcIiwgXCJoZWFkQ2VsbFNjcmVlblJlYWRlclRleHRcIiwgXCJpZFwiLCBcImluZGV4XCIsIFwib25BdXRvc2l6ZUNvbHVtblwiLCBcIm9uQ2xpY2tcIiwgXCJvbktleURvd25cIiwgXCJvblJlcXVlc3RNb3ZlQ29sdW1uXCIsIFwib25SZXF1ZXN0UmVzaXplXCIsIFwib25Tb3J0XCIsIFwicmVzaXphYmxlXCIsIFwic29ydERpclwiLCBcInNvcnRLZXlcIiwgXCJzdHlsZVwiLCBcInRvb2x0aXBcIiwgXCJ0cnVuY2F0ZVwiLCBcInZhcmlhbnRcIiwgXCJ2aXNpYmxlXCIsIFwid2lkdGhcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBIZWFkQ2VsbFByb3BzQmFzZVxuICAgICAgICAgICAgICAgIHZhciAkID0gISF5O1xuICAgICAgICB2YXIgTCA9ICgwLCBhLnVzZVNvcnRhYmxlKSh7XG4gICAgICAgICAgICAvLyBkcmFnSWQgaXMgb3B0aW9uYWwgaW4gSGVhZENlbGwgYnV0IHJlcXVpcmVkIGJ5IHVzZVNvcnRhYmxlXG4gICAgICAgICAgICAvLyBzaW5jZSBpdCBpcyBhbHdheXMgc2V0IGluIFRhYmxlLCB1c2UgYSB0eXBlIGFzc2VydGlvbiBoZXJlIHRvIGF2b2lkIFR5cGVTY3JpcHQgZXJyb3JcbiAgICAgICAgICAgIGlkOiBkXG4gICAgICAgIH0pLCBXID0gTC5hdHRyaWJ1dGVzLCBIID0gTC5pc0RyYWdnaW5nLCBLID0gTC5saXN0ZW5lcnMsIEIgPSBMLnNldE5vZGVSZWY7XG4gICAgICAgIHZhciBWID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBOKGMsIGUpO1xuICAgICAgICAgICAgaWYgKCQpIHtcbiAgICAgICAgICAgICAgICBCKGUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyAkLCBjLCBCIF0pO1xuICAgICAgICB2YXIgRiA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgLy8gaWdub3JlIGNsaWNrcyBvbiB0aGUgcmVzaXplIGhhbmRsZVxuICAgICAgICAgICAgaWYgKGUudGFyZ2V0LmdldEF0dHJpYnV0ZShcImRhdGEtdGVzdFwiKSAhPT0gXCJyZXNpemVcIiAmJiB3ICYmIHAgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgIHcoZSwge1xuICAgICAgICAgICAgICAgICAgICBzb3J0S2V5OiBrLFxuICAgICAgICAgICAgICAgICAgICBzb3J0RGlyOiBPLFxuICAgICAgICAgICAgICAgICAgICBpZDogdixcbiAgICAgICAgICAgICAgICAgICAgY29sdW1uSWQ6IHMsXG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiBwXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBiID09PSBudWxsIHx8IGIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGIoKTtcbiAgICAgICAgfSksIFsgcywgdiwgcCwgYiwgdywgTywgayBdKTtcbiAgICAgICAgdmFyIFUgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmIChwICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICBoID09PSBudWxsIHx8IGggPT09IHZvaWQgMCA/IHZvaWQgMCA6IGgoZSwge1xuICAgICAgICAgICAgICAgICAgICBpbmRleDogcCxcbiAgICAgICAgICAgICAgICAgICAgY29sdW1uSWQ6IHNcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgcywgcCwgaCBdKTtcbiAgICAgICAgdmFyIFggPSAhIXcgJiYgISFPO1xuICAgICAgICB2YXIgWSA9IGIgIT09IHVuZGVmaW5lZDtcbiAgICAgICAgdmFyIEcgPSBBID09PSBcImFjdGlvbnNcIiA/IGZhbHNlIDogcTtcbiAgICAgICAgdmFyIEogPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4gUmUoKSh7fSwgUiwge1xuICAgICAgICAgICAgICAgIHdpZHRoOiB6XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSksIFsgUiwgeiBdKTtcbiAgICAgICAgdmFyIFE7XG4gICAgICAgIGlmIChmKSB7XG4gICAgICAgICAgICBRID0gZjtcbiAgICAgICAgfSBlbHNlIGlmIChPZSgpKHUpKSB7XG4gICAgICAgICAgICBRID0gdTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgWiA9IChuID0gdiAhPT0gbnVsbCAmJiB2ICE9PSB2b2lkIDAgPyB2IDogcykgIT09IG51bGwgJiYgbiAhPT0gdm9pZCAwID8gbiA6ICgwLCBcbiAgICAgICAgai5jcmVhdGVET01JRCkoXCJoZWFkQ2VsbElkLVwiKTtcbiAgICAgICAgdmFyIGVlID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBhbGlnbjogaSxcbiAgICAgICAgICAgICAgICBjbGlja2FibGU6IGwgfHwgWCB8fCBZLFxuICAgICAgICAgICAgICAgIGNvbHVtbklkOiBzLFxuICAgICAgICAgICAgICAgIGZvY3VzV2l0aGluOiBsLFxuICAgICAgICAgICAgICAgIGxhYmVsOiB1LFxuICAgICAgICAgICAgICAgIGNlbGxJZDogWixcbiAgICAgICAgICAgICAgICBpbmRleDogcCxcbiAgICAgICAgICAgICAgICBvbkF1dG9zaXplQ29sdW1uOiBtLFxuICAgICAgICAgICAgICAgIG9uQ2xpY2s6IHcgfHwgWSA/IEYgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICAgICAgb25LZXlEb3duOiB3IHx8IFkgPyBVIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgICAgIG9uUmVxdWVzdFJlc2l6ZTogZyxcbiAgICAgICAgICAgICAgICByZXNpemFibGU6IF8gJiYgeCxcbiAgICAgICAgICAgICAgICBzb3J0RGlyOiB3ICYmIE8sXG4gICAgICAgICAgICAgICAgdHJ1bmNhdGU6IEcsXG4gICAgICAgICAgICAgICAgdmFyaWFudDogQSxcbiAgICAgICAgICAgICAgICB3aWR0aDogelxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgaSwgbCwgWCwgWSwgcywgdSwgWiwgcCwgbSwgdywgRiwgVSwgZywgXywgeCwgTywgRywgQSwgeiBdKTtcbiAgICAgICAgdmFyIG5lID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBcbiAgICAgICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChUbiwgam4oe30sIGUsIGVlLCB7XG4gICAgICAgICAgICAgICAgaGFzVG9vbHRpcDogdHJ1ZVxuICAgICAgICAgICAgfSkpO1xuICAgICAgICB9KSwgWyBlZSBdKTtcbiAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChLZSwgam4oe1xuICAgICAgICAgICAgc3R5bGU6IEosXG4gICAgICAgICAgICByZWY6IFYsXG4gICAgICAgICAgICBcImFyaWEtc29ydFwiOiB3ICYmIChQbltPXSB8fCBcIm5vbmVcIiksXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImhlYWQtY2VsbFwiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3QtbGFiZWxcIjogT2UoKSh1KSA/IHUgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBcImRhdGEtdGVzdC1zb3J0LWRpclwiOiB3ICYmIE8sXG4gICAgICAgICAgICBpZDogXyA/IFogOiB1bmRlZmluZWQsXG4gICAgICAgICAgICAkaXNEcmFnZ2luZzogJCAmJiBILFxuICAgICAgICAgICAgJHZhcmlhbnQ6IEFcbiAgICAgICAgfSwgTSksICByKCkuY3JlYXRlRWxlbWVudChIZSwgbnVsbCwgJCAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoVmUsIGpuKHtcbiAgICAgICAgICAgIFwiYXJpYS1sYWJlbFwiOiAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIlJlb3JkZXIgJShsYWJlbFN0cmluZylzXCIpLCB7XG4gICAgICAgICAgICAgICAgbGFiZWxTdHJpbmc6IFFcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJkcmFnXCIsXG4gICAgICAgICAgICBkcmFnZ2FibGU6IHRydWVcbiAgICAgICAgfSwgVywgSyksICByKCkuY3JlYXRlRWxlbWVudChCZSwgbnVsbCwgIHIoKS5jcmVhdGVFbGVtZW50KEllKCksIG51bGwpKSksIEUgPyAgcigpLmNyZWF0ZUVsZW1lbnQoamUoKSwge1xuICAgICAgICAgICAgY29udGVudDogRSxcbiAgICAgICAgICAgIHJlbmRlckFuY2hvcjogbmVcbiAgICAgICAgfSkgOiAgcigpLmNyZWF0ZUVsZW1lbnQoVG4sIGVlKSkpO1xuICAgIH1cbiAgICBfbi5wcm9wVHlwZXMgPSBBbjtcbiAgICBfbi5zcGx1bmtVaVR5cGUgPSBcIlRhYmxlLkhlYWRDZWxsXCI7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCB6biA9IF9uO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0hlYWRTdHlsZXMudHNcbiAgICB2YXIgTW4gPSB6KCkudGhlYWQud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRTdHlsZXNfX1N0eWxlZFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJpYXAyMXQtMFwiXG4gICAgfSkoWyBcIlwiLCBcIjtcIiwgXCJcIiBdLCBNLm1peGlucy5yZXNldChcInRhYmxlLWhlYWRlci1ncm91cFwiKSwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIG4gPSBlLiRpc0ZpeGVkLCB0ID0gZS4kekluZGV4O1xuICAgICAgICByZXR1cm4gbiAmJiAoMCwgXy5jc3MpKFsgXCJwb3NpdGlvbjpzdGlja3k7dG9wOjA7ei1pbmRleDpcIiwgXCI7XCIgXSwgdCk7XG4gICAgfSkpO1xuICAgIHZhciAkbiA9IHooKSh6bikud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRTdHlsZXNfX1N0eWxlZFRvZ2dsZUFsbFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJpYXAyMXQtMVwiXG4gICAgfSkoWyBcIndpZHRoOjMycHg7XCIgXSk7XG4gICAgdmFyIE5uID0geigpKHpuKS53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSGVhZFN0eWxlc19fU3R5bGVkSW5mb1wiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJpYXAyMXQtMlwiXG4gICAgfSkoWyBcIndpZHRoOjMycHg7XCIgXSk7XG4gICAgdmFyIExuID0geigpKHpuKS53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSGVhZFN0eWxlc19fU3R5bGVkRHJhZ1Jvd1wiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJpYXAyMXQtM1wiXG4gICAgfSkoWyBcIndpZHRoOjMycHg7XCIgXSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAZG5kLWtpdC91dGlsaXRpZXNcIlxuICAgIGNvbnN0IFduID0gcmVxdWlyZShcIkBkbmQta2l0L3V0aWxpdGllc1wiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtaWNvbnMvRG90c1RocmVlVmVydGljYWxcIlxuICAgIGNvbnN0IEhuID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvRG90c1RocmVlVmVydGljYWxcIik7XG4gICAgdmFyIEtuID0gIGUubihIbik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0J1dHRvblwiXG4gICAgY29uc3QgQm4gPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9CdXR0b25cIik7XG4gICAgdmFyIFZuID0gIGUubihCbik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0Ryb3Bkb3duXCJcbiAgICBjb25zdCBGbiA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL0Ryb3Bkb3duXCIpO1xuICAgIHZhciBVbiA9ICBlLm4oRm4pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9DaGV2cm9uUmlnaHRcIlxuICAgIGNvbnN0IFhuID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvQ2hldnJvblJpZ2h0XCIpO1xuICAgIHZhciBZbiA9ICBlLm4oWG4pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0V4cGFuZEJ1dHRvblN0eWxlcy50c1xuICAgIHZhciBHbiA9IHooKS5idXR0b24ud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkV4cGFuZEJ1dHRvblN0eWxlc19fU3R5bGVkQnV0dG9uXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTdubHc1cS0wXCJcbiAgICB9KShbIFwiXCIsIFwiO2hlaWdodDoxMDAlO3dpZHRoOjEwMCU7Y3Vyc29yOnBvaW50ZXI7anVzdGlmeS1jb250ZW50OmNlbnRlcjtjb2xvcjpcIiwgXCI7Jjpob3Zlcntjb2xvcjpcIiwgXCI7fSY6Zm9jdXN7Y29sb3I6XCIsIFwiO2JveC1zaGFkb3c6XCIsIFwiO31cIiBdLCBNLm1peGlucy5yZXNldChcImZsZXhcIiksIE0udmFyaWFibGVzLmNvbnRlbnRDb2xvckRlZmF1bHQsIE0udmFyaWFibGVzLmNvbnRlbnRDb2xvckFjdGl2ZSwgTS52YXJpYWJsZXMuY29udGVudENvbG9yQWN0aXZlLCBNLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0KTtcbiAgICB2YXIgSm4gPSB6KCkoWW4oKSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkV4cGFuZEJ1dHRvblN0eWxlc19fU3R5bGVkQ2hldnJvblwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy03bmx3NXEtMVwiXG4gICAgfSkoWyBcInBhZGRpbmctYmxvY2s6XCIsIFwiO3RyYW5zaXRpb246dHJhbnNmb3JtIDIwMG1zO1wiLCBcIlwiIF0sICgwLCBNLnBpY2spKHtcbiAgICAgICAgY29tZm9ydGFibGU6IFwiMTBweFwiLFxuICAgICAgICBjb21wYWN0OiBcIjhweFwiXG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kZXhwYW5kZWQ7XG4gICAgICAgIHJldHVybiBuICYmICgwLCBfLmNzcykoWyBcInRyYW5zZm9ybTpyb3RhdGUoOTBkZWcpO1wiIF0pO1xuICAgIH0pKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9FeHBhbmRCdXR0b24udHN4XG4gICAgZnVuY3Rpb24gUW4oKSB7XG4gICAgICAgIHJldHVybiBRbiA9IE9iamVjdC5hc3NpZ24gPyBPYmplY3QuYXNzaWduLmJpbmQoKSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGZvciAodmFyIG4gPSAxOyBuIDwgYXJndW1lbnRzLmxlbmd0aDsgbisrKSB7XG4gICAgICAgICAgICAgICAgdmFyIHQgPSBhcmd1bWVudHNbbl07XG4gICAgICAgICAgICAgICAgZm9yICh2YXIgciBpbiB0KSB7XG4gICAgICAgICAgICAgICAgICAgICh7fSkuaGFzT3duUHJvcGVydHkuY2FsbCh0LCByKSAmJiAoZVtyXSA9IHRbcl0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9LCBRbi5hcHBseShudWxsLCBhcmd1bWVudHMpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBabihlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSBldChlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiBldChlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgdmFyIG50ID0ge1xuICAgICAgICBleHBhbmRlZDogdygpLmJvb2xcbiAgICB9O1xuICAgIHZhciB0dCA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICB2YXIgdCA9IG4uZXhwYW5kZWQsIG8gPSBabihuLCBbIFwiZXhwYW5kZWRcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBFeHBhbmRCdXR0b25Qcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KEduLCBRbih7XG4gICAgICAgICAgICB0aXRsZTogdCA/ICgwLCBULl8pKFwiQ29sbGFwc2Ugcm93XCIpIDogKDAsIFQuXykoXCJFeHBhbmQgcm93XCIpXG4gICAgICAgIH0sIG8pLCAgcigpLmNyZWF0ZUVsZW1lbnQoSm4sIHtcbiAgICAgICAgICAgICRleHBhbmRlZDogdFxuICAgICAgICB9KSk7XG4gICAgfTtcbiAgICB0dC5wcm9wVHlwZXMgPSBudDtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IHJ0ID0gdHQ7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvUm93RHJhZ0NlbGxTdHlsZXMudHNcbiAgICB2YXIgb3QgPSB6KCkudGQud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJvd0RyYWdDZWxsU3R5bGVzX19TdHlsZWRDZWxsXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTlrYmFqMi0wXCJcbiAgICB9KShbIFwiXCIsIFwiIGN1cnNvcjptb3ZlO3RvdWNoLWFjdGlvbjpub25lO3Bvc2l0aW9uOnJlbGF0aXZlO3ZlcnRpY2FsLWFsaWduOm1pZGRsZTtcIiBdLCBNLm1peGlucy5yZXNldChcInRhYmxlLWNlbGxcIikpO1xuICAgIHZhciBpdCA9IHooKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJvd0RyYWdDZWxsU3R5bGVzX19TdHlsZWREcmFnXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTlrYmFqMi0xXCJcbiAgICB9KShbIFwiXCIsIFwiIFwiLCBcIjtqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO2N1cnNvcjptb3ZlOy13ZWJraXQtdXNlci1kcmFnOmVsZW1lbnQ7dXNlci1zZWxlY3Q6bm9uZTthbGlnbi1pdGVtczpjZW50ZXI7cG9zaXRpb246YWJzb2x1dGU7d2lkdGg6MTAwJTt0b3A6MDtib3R0b206MDsmOmZvY3Vze291dGxpbmU6MDtib3gtc2hhZG93OlwiLCBcIjt9Jjpob3ZlcntiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjtvdXRsaW5lOm5vbmU7fSY6YWN0aXZle2JhY2tncm91bmQtY29sb3I6XCIsIFwiO2JveC1zaGFkb3c6XCIsIFwiO30mID4gZGl2e21hcmdpbjowO31AbWVkaWEgcHJpbnR7YmFja2dyb3VuZC1pbWFnZTpub25lO31cIiBdLCBNLm1peGlucy5yZXNldChcImZsZXhcIiksIE0ubWl4aW5zLmNsZWFyZml4KCksIE0udmFyaWFibGVzLmZvY3VzU2hhZG93SW5zZXQsIE0udmFyaWFibGVzLmludGVyYWN0aXZlQ29sb3JPdmVybGF5RHJhZywgTS52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlBY3RpdmUsIE0udmFyaWFibGVzLmZvY3VzU2hhZG93SW5zZXQpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL1Jvd0RyYWdDZWxsLnRzeFxuICAgIGZ1bmN0aW9uIGF0KCkge1xuICAgICAgICByZXR1cm4gYXQgPSBPYmplY3QuYXNzaWduID8gT2JqZWN0LmFzc2lnbi5iaW5kKCkgOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmb3IgKHZhciBuID0gMTsgbiA8IGFyZ3VtZW50cy5sZW5ndGg7IG4rKykge1xuICAgICAgICAgICAgICAgIHZhciB0ID0gYXJndW1lbnRzW25dO1xuICAgICAgICAgICAgICAgIGZvciAodmFyIHIgaW4gdCkge1xuICAgICAgICAgICAgICAgICAgICAoe30pLmhhc093blByb3BlcnR5LmNhbGwodCwgcikgJiYgKGVbcl0gPSB0W3JdKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfSwgYXQuYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gbHQoZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0LCByLCBvID0gdXQoZSwgbik7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgaSA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICBmb3IgKHIgPSAwOyByIDwgaS5sZW5ndGg7IHIrKykge1xuICAgICAgICAgICAgICAgIHQgPSBpW3JdLCAtMSA9PT0gbi5pbmRleE9mKHQpICYmIHt9LnByb3BlcnR5SXNFbnVtZXJhYmxlLmNhbGwoZSwgdCkgJiYgKG9bdF0gPSBlW3RdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbztcbiAgICB9XG4gICAgZnVuY3Rpb24gdXQoZSwgbikge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciB0ID0ge307XG4gICAgICAgIGZvciAodmFyIHIgaW4gZSkge1xuICAgICAgICAgICAgaWYgKHt9Lmhhc093blByb3BlcnR5LmNhbGwoZSwgcikpIHtcbiAgICAgICAgICAgICAgICBpZiAoLTEgIT09IG4uaW5kZXhPZihyKSkgY29udGludWU7XG4gICAgICAgICAgICAgICAgdFtyXSA9IGVbcl07XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIHZhciBzdCA9IHtcbiAgICAgICAgc2V0QWN0aXZhdG9yTm9kZVJlZjogdygpLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgICAgbGlzdGVuZXJzOiB3KCkub2JqZWN0T2YodygpLmZ1bmMpXG4gICAgfTtcbiAgICBmdW5jdGlvbiBjdChlKSB7XG4gICAgICAgIHZhciBuID0gZS5saXN0ZW5lcnMsIHQgPSBlLnNldEFjdGl2YXRvck5vZGVSZWYsIG8gPSBsdChlLCBbIFwibGlzdGVuZXJzXCIsIFwic2V0QWN0aXZhdG9yTm9kZVJlZlwiIF0pO1xuICAgICAgICAvLyBAZG9jcy1wcm9wcy10eXBlIFJvd0RyYWdDZWxsUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChvdCwge1xuICAgICAgICAgICAgXCJkYXRhLWhlbHBlclwiOiB0cnVlXG4gICAgICAgIH0sICByKCkuY3JlYXRlRWxlbWVudChpdCwgYXQoe1xuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJkcmFnXCIsXG4gICAgICAgICAgICBkcmFnZ2FibGU6IHRydWUsXG4gICAgICAgICAgICByZWY6IHQsXG4gICAgICAgICAgICB0YWJJbmRleDogMFxuICAgICAgICB9LCBuLCBvKSwgIHIoKS5jcmVhdGVFbGVtZW50KEllKCksIG51bGwpKSk7XG4gICAgfVxuICAgIGN0LnByb3BUeXBlcyA9IHN0O1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3QgZHQgPSBjdDtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9Sb3dTdHlsZXMudHNcbiAgICB2YXIgZnQgPSB6KCkudHIud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJvd1N0eWxlc19fU3R5bGVkU3RyaXBlTm9uZVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJmMGlncXEtMFwiXG4gICAgfSkoWyBcIlwiLCBcIjtcIiwgXCI7XCIsIFwiIEBtZWRpYSBwcmludHtiYWNrZ3JvdW5kLWNvbG9yOm5vbmU7fVwiIF0sIE0ubWl4aW5zLnJlc2V0KFwidGFibGUtcm93XCIpLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgbiA9IGUuJGNsaWNrYWJsZTtcbiAgICAgICAgcmV0dXJuIG4gJiYgKDAsIF8uY3NzKShbIFwiY3Vyc29yOnBvaW50ZXI7Jjpob3ZlcntiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjt9Jjpmb2N1c3tiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjtib3gtc2hhZG93OlwiLCBcIjt9XCIgXSwgTS52YXJpYWJsZXMubmV1dHJhbDEwMCwgTS52YXJpYWJsZXMubmV1dHJhbDEwMCwgTS52YXJpYWJsZXMuZm9jdXNTaGFkb3dJbnNldCk7XG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS5kaXNhYmxlZCwgdCA9IGUuJGV4cGFuZGFibGUsIHIgPSBlLiRpc0RyYWdnYWJsZTtcbiAgICAgICAgcmV0dXJuICFuICYmICF0ICYmIHIgJiYgKDAsIF8uY3NzKShbIFwiJjpob3ZlcntiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjt9XCIgXSwgTS52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlIb3Zlcik7XG4gICAgfSkpO1xuICAgIHZhciB2dCA9IHooKShmdCkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIlJvd1N0eWxlc19fU3R5bGVkU3RyaXBlRXZlblwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJmMGlncXEtMVwiXG4gICAgfSkoWyBcImJhY2tncm91bmQtY29sb3I6XCIsIFwiO1wiLCBcIjtcIiBdLCBNLnZhcmlhYmxlcy5uZXV0cmFsNTAsIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciBuID0gZS4kY2xpY2thYmxlO1xuICAgICAgICByZXR1cm4gbiAmJiAoMCwgXy5jc3MpKFsgXCJjdXJzb3I6cG9pbnRlcjsmOmhvdmVyLCY6Zm9jdXN7YmFja2dyb3VuZC1jb2xvcjpcIiwgXCI7fVwiIF0sIE0udmFyaWFibGVzLm5ldXRyYWwzMDApO1xuICAgIH0pKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvQ2hlY2tib3hcIlxuICAgIGNvbnN0IHB0ID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtdWkvQ2hlY2tib3hcIik7XG4gICAgdmFyIG10ID0gIGUubihwdCk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0NsaWNrYWJsZVwiXG4gICAgY29uc3QgYnQgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9DbGlja2FibGVcIik7XG4gICAgdmFyIGh0ID0gIGUubihidCk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvVG9nZ2xlU3R5bGVzLnRzXG4gICAgdmFyIHl0ID0geigpKGh0KCkpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUb2dnbGVTdHlsZXNfX1N0eWxlZENsaWNrYWJsZVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xeDNpa2NoLTBcIlxuICAgIH0pKFsgXCJoZWlnaHQ6MTAwJTt3aWR0aDoxMDAlO2Rpc3BsYXk6ZmxleDtqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyOyZbZGlzYWJsZWRde2N1cnNvcjpub3QtYWxsb3dlZDt9XCIgXSk7XG4gICAgdmFyIGd0ID0geigpKG10KCkpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJUb2dnbGVTdHlsZXNfX1N0eWxlZENoZWNrYm94XCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTF4M2lrY2gtMVwiXG4gICAgfSkoWyBcImFsaWduLWl0ZW1zOmZsZXgtc3RhcnQ7cGFkZGluZy1ibG9jazpcIiwgXCI7XCIgXSwgKDAsIE0ucGljaykoe1xuICAgICAgICBjb21mb3J0YWJsZTogXCI4cHhcIixcbiAgICAgICAgY29tcGFjdDogXCI2cHhcIlxuICAgIH0pKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9Ub2dnbGUudHN4XG4gICAgZnVuY3Rpb24gd3QoKSB7XG4gICAgICAgIHJldHVybiB3dCA9IE9iamVjdC5hc3NpZ24gPyBPYmplY3QuYXNzaWduLmJpbmQoKSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGZvciAodmFyIG4gPSAxOyBuIDwgYXJndW1lbnRzLmxlbmd0aDsgbisrKSB7XG4gICAgICAgICAgICAgICAgdmFyIHQgPSBhcmd1bWVudHNbbl07XG4gICAgICAgICAgICAgICAgZm9yICh2YXIgciBpbiB0KSB7XG4gICAgICAgICAgICAgICAgICAgICh7fSkuaGFzT3duUHJvcGVydHkuY2FsbCh0LCByKSAmJiAoZVtyXSA9IHRbcl0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9LCB3dC5hcHBseShudWxsLCBhcmd1bWVudHMpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBDdChlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSB4dChlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiB4dChlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgdmFyIFN0ID0ge1xuICAgICAgICBkaXNhYmxlZDogdygpLmJvb2wsXG4gICAgICAgIG9uQ2xpY2s6IHcoKS5mdW5jLFxuICAgICAgICBzZWxlY3RlZDogdygpLm9uZU9mKFsgdHJ1ZSwgZmFsc2UsIFwic29tZVwiIF0pXG4gICAgfTtcbiAgICBmdW5jdGlvbiBPdChlKSB7XG4gICAgICAgIHZhciBuID0gZS5kaXNhYmxlZCwgdCA9IGUub25DbGljaywgbyA9IGUuc2VsZWN0ZWQsIGkgPSBDdChlLCBbIFwiZGlzYWJsZWRcIiwgXCJvbkNsaWNrXCIsIFwic2VsZWN0ZWRcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBUb2dnbGVQcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICB2YXIgYSA9IG4gPT09IHRydWUgPyBcImRpc2FibGVkXCIgOiB1bmRlZmluZWQ7XG4gICAgICAgIFxuICAgICAgICAvLyB3ZSB1c2UgYSBDbGlja2FibGUgYXJvdW5kIHRoZSBpbmVydCBDaGVja2JveCAod2hpY2ggY2FuIHNlZW0gaXJvbmljKSBzbyB0aGF0IHRoZSB3aG9sZSB0YWJsZSBjZWxsIGlzIGNsaWNrYWJsZVxuICAgICAgICAvLyB3ZSBjYW5ub3QgdXNlIHRoZSBDZWxsJ3Mgb25DbGljayBpdHNlbGYgYmVjYXVzZSBvZiBhMTF5IGlzc3VlcyB3ZSBoYXZlIGZhY2VkIGluIHRoZSBwYXN0IChzZWUgU1VJLTU5NTgpLlxuICAgICAgICByZXR1cm4gcigpLmNyZWF0ZUVsZW1lbnQoeXQsIHd0KHtcbiAgICAgICAgICAgIFwiYXJpYS1jaGVja2VkXCI6IG8gPT09IFwic29tZVwiID8gXCJtaXhlZFwiIDogbyxcbiAgICAgICAgICAgIGRpc2FibGVkOiBhLFxuICAgICAgICAgICAgb25DbGljazogdCxcbiAgICAgICAgICAgIHJvbGU6IFwiY2hlY2tib3hcIlxuICAgICAgICB9LCBpKSwgIHIoKS5jcmVhdGVFbGVtZW50KGd0LCB7XG4gICAgICAgICAgICBjaGVja2VkOiBvID09PSBcInNvbWVcIiA/IFwiaW5kZXRlcm1pbmF0ZVwiIDogbyxcbiAgICAgICAgICAgIGRpc2FibGVkOiAhIWEsXG4gICAgICAgICAgICBpbmVydDogdHJ1ZVxuICAgICAgICB9KSk7XG4gICAgfVxuICAgIE90LnByb3BUeXBlcyA9IFN0O1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3Qga3QgPSBPdDtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9Sb3cudHN4XG4gICAgZnVuY3Rpb24gUnQoZSkge1xuICAgICAgICBcIkBiYWJlbC9oZWxwZXJzIC0gdHlwZW9mXCI7XG4gICAgICAgIHJldHVybiBSdCA9IFwiZnVuY3Rpb25cIiA9PSB0eXBlb2YgU3ltYm9sICYmIFwic3ltYm9sXCIgPT0gdHlwZW9mIFN5bWJvbC5pdGVyYXRvciA/IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHJldHVybiB0eXBlb2YgZTtcbiAgICAgICAgfSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHJldHVybiBlICYmIFwiZnVuY3Rpb25cIiA9PSB0eXBlb2YgU3ltYm9sICYmIGUuY29uc3RydWN0b3IgPT09IFN5bWJvbCAmJiBlICE9PSBTeW1ib2wucHJvdG90eXBlID8gXCJzeW1ib2xcIiA6IHR5cGVvZiBlO1xuICAgICAgICB9LCBSdChlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gRXQoZSwgbikge1xuICAgICAgICB2YXIgdCA9IE9iamVjdC5rZXlzKGUpO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIHIgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgbiAmJiAociA9IHIuZmlsdGVyKChmdW5jdGlvbihuKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IoZSwgbikuZW51bWVyYWJsZTtcbiAgICAgICAgICAgIH0pKSksIHQucHVzaC5hcHBseSh0LCByKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgZnVuY3Rpb24gSXQoZSkge1xuICAgICAgICBmb3IgKHZhciBuID0gMTsgbiA8IGFyZ3VtZW50cy5sZW5ndGg7IG4rKykge1xuICAgICAgICAgICAgdmFyIHQgPSBudWxsICE9IGFyZ3VtZW50c1tuXSA/IGFyZ3VtZW50c1tuXSA6IHt9O1xuICAgICAgICAgICAgbiAlIDIgPyBFdChPYmplY3QodCksICEwKS5mb3JFYWNoKChmdW5jdGlvbihuKSB7XG4gICAgICAgICAgICAgICAgVHQoZSwgbiwgdFtuXSk7XG4gICAgICAgICAgICB9KSkgOiBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9ycyA/IE9iamVjdC5kZWZpbmVQcm9wZXJ0aWVzKGUsIE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3JzKHQpKSA6IEV0KE9iamVjdCh0KSkuZm9yRWFjaCgoZnVuY3Rpb24obikge1xuICAgICAgICAgICAgICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCBuLCBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKHQsIG4pKTtcbiAgICAgICAgICAgIH0pKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gZTtcbiAgICB9XG4gICAgZnVuY3Rpb24gVHQoZSwgbiwgdCkge1xuICAgICAgICByZXR1cm4gKG4gPSBqdChuKSkgaW4gZSA/IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCBuLCB7XG4gICAgICAgICAgICB2YWx1ZTogdCxcbiAgICAgICAgICAgIGVudW1lcmFibGU6ICEwLFxuICAgICAgICAgICAgY29uZmlndXJhYmxlOiAhMCxcbiAgICAgICAgICAgIHdyaXRhYmxlOiAhMFxuICAgICAgICB9KSA6IGVbbl0gPSB0LCBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBqdChlKSB7XG4gICAgICAgIHZhciBuID0gRHQoZSwgXCJzdHJpbmdcIik7XG4gICAgICAgIHJldHVybiBcInN5bWJvbFwiID09IFJ0KG4pID8gbiA6IG4gKyBcIlwiO1xuICAgIH1cbiAgICBmdW5jdGlvbiBEdChlLCBuKSB7XG4gICAgICAgIGlmIChcIm9iamVjdFwiICE9IFJ0KGUpIHx8ICFlKSByZXR1cm4gZTtcbiAgICAgICAgdmFyIHQgPSBlW1N5bWJvbC50b1ByaW1pdGl2ZV07XG4gICAgICAgIGlmICh2b2lkIDAgIT09IHQpIHtcbiAgICAgICAgICAgIHZhciByID0gdC5jYWxsKGUsIG4gfHwgXCJkZWZhdWx0XCIpO1xuICAgICAgICAgICAgaWYgKFwib2JqZWN0XCIgIT0gUnQocikpIHJldHVybiByO1xuICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkBAdG9QcmltaXRpdmUgbXVzdCByZXR1cm4gYSBwcmltaXRpdmUgdmFsdWUuXCIpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiAoXCJzdHJpbmdcIiA9PT0gbiA/IFN0cmluZyA6IE51bWJlcikoZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIHF0KGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCwgciwgbyA9IEF0KGUsIG4pO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChyID0gMDsgciA8IGkubGVuZ3RoOyByKyspIHtcbiAgICAgICAgICAgICAgICB0ID0gaVtyXSwgLTEgPT09IG4uaW5kZXhPZih0KSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHQpICYmIChvW3RdID0gZVt0XSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG87XG4gICAgfVxuICAgIGZ1bmN0aW9uIEF0KGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCA9IHt9O1xuICAgICAgICBmb3IgKHZhciByIGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIHIpKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSBuLmluZGV4T2YocikpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIHRbcl0gPSBlW3JdO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0O1xuICAgIH1cbiAgICBmdW5jdGlvbiBQdCgpIHtcbiAgICAgICAgcmV0dXJuIFB0ID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IGFyZ3VtZW50c1tuXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciByIGluIHQpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsIHIpICYmIChlW3JdID0gdFtyXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIFB0LmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIHZhciBfdCA9IHtcbiAgICAgICAgb2RkOiBmdCxcbiAgICAgICAgZXZlbjogdnQsXG4gICAgICAgIG5vbmU6IGZ0XG4gICAgfTtcbiAgICAvKiogQHB1YmxpYyAqL1xuICAgIC8qKiBAcHVibGljICovXG4gICAgLyoqIEBwdWJsaWMgKi9cbiAgICAvKiogQHB1YmxpYyAqL1xuICAgIC8qKiBAcHVibGljICovICAgIHZhciB6dCA9IHtcbiAgICAgICAgLyoqIEBwcml2YXRlLiBHZW5lcmFsbHkgcGFzc2VkIGJ5IFRhYmxlIHJhdGhlciB0aGFuIGFkZGVkIGRpcmVjdGx5LiAqL1xuICAgICAgICBhY3RpdmVFbGVtZW50SWQ6IHcoKS5zdHJpbmcsXG4gICAgICAgIGFjdGlvblByaW1hcnk6IHcoKS5lbGVtZW50LFxuICAgICAgICBhY3Rpb25zU2Vjb25kYXJ5OiB3KCkuZWxlbWVudCxcbiAgICAgICAgY2hpbGRyZW46IHcoKS5ub2RlLFxuICAgICAgICBkYXRhOiB3KCkuYW55LFxuICAgICAgICBkaXNhYmxlZDogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gR2VuZXJhbGx5IHBhc3NlZCBieSBUYWJsZSByYXRoZXIgdGhhbiBhZGRlZCBkaXJlY3RseS4gKi9cbiAgICAgICAgaXNEcmFnZ2FibGU6IHcoKS5ib29sLFxuICAgICAgICAvKiogQHByaXZhdGUuIEdlbmVyYWxseSBwYXNzZWQgYnkgVGFibGUgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIGRyYWdJZDogdygpLm9uZU9mVHlwZShbIHcoKS5zdHJpbmcsIHcoKS5udW1iZXIgXSksXG4gICAgICAgIGVsZW1lbnRSZWY6IHcoKS5vbmVPZlR5cGUoWyB3KCkuZnVuYywgdygpLm9iamVjdCBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBleHBhbmRhYmxlOiB3KCkuYm9vbCxcbiAgICAgICAgZXhwYW5kZWQ6IHcoKS5ib29sLFxuICAgICAgICAvKiogQHByaXZhdGUuIElkZW50aWZpZXMgdGhlIHVuaXF1ZSBpZCAob3IgaWRzKSBmb3IgYW4gZXhwYW5kZWQgcm93IChvciByb3dzKS4gSW4gZXhwYW5kYWJsZSByb3dzIGBFeHBhbnNpb25Sb3dJY29uYCB1c2VzIGBleHBhbnNpb25Sb3dJZGAgZm9yIGFjY2Vzc2liaWxpdHkgYXJpYSBhdHRyaWJ1dGVzLiAqL1xuICAgICAgICBleHBhbnNpb25Sb3dJZHM6IHcoKS5zdHJpbmcsXG4gICAgICAgIGV4cGFuc2lvblJvdzogdygpLm9uZU9mVHlwZShbIHcoKS5lbGVtZW50LCB3KCkuYXJyYXlPZih3KCkuZWxlbWVudCkgXSksXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gSW5kaWNhdGVzIHdoZXRoZXIgdGhlIHRhYmxlIGhhcyBhbiBhY3Rpb25zIGNvbHVtbi4gKi9cbiAgICAgICAgYWN0aW9uczogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gR2VuZXJhbGx5IHBhc3NlZCBieSBgVGFibGVgIHJhdGhlciB0aGFuIGFkZGVkIGRpcmVjdGx5LiAqL1xuICAgICAgICBpbmRleDogdygpLm51bWJlcixcbiAgICAgICAgLyoqIEBwcml2YXRlLiBHZW5lcmFsbHkgcGFzc2VkIGJ5IGBUYWJsZWAgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIG1vdmFibGVDb2x1bW5zOiB3KCkuYm9vbCxcbiAgICAgICAgb25DbGljazogdygpLmZ1bmMsXG4gICAgICAgIG9uRXhwYW5zaW9uOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiBUaGlzIGlzIHBhc3NlZCB0aHJvdWdoIGFuZCB3b3JrcyBhcyBleHBlY3RlZC4gKi9cbiAgICAgICAgb25LZXlEb3duOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiBHZW5lcmFsbHkgcGFzc2VkIGJ5IGBUYWJsZWAgcmF0aGVyIHRoYW4gYWRkZWQgZGlyZWN0bHkuICovXG4gICAgICAgIG9uUmVxdWVzdE1vdmVSb3c6IHcoKS5mdW5jLFxuICAgICAgICBvblJlcXVlc3RUb2dnbGU6IHcoKS5mdW5jLFxuICAgICAgICAvKiogQHByaXZhdGUuIEdlbmVyYWxseSBwYXNzZWQgYnkgYFRhYmxlYCByYXRoZXIgdGhhbiBhZGRlZCBkaXJlY3RseS4gKi9cbiAgICAgICAgcHJpbWFyeUNvbHVtbkluZGV4OiB3KCkubnVtYmVyLFxuICAgICAgICByb3dTY3JlZW5SZWFkZXJUZXh0OiB3KCkuc3RyaW5nLFxuICAgICAgICBzZWxlY3RlZDogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgc3RyaXBlOiB3KCkub25lT2YoWyBcIm9kZFwiLCBcImV2ZW5cIiwgXCJub25lXCIgXSlcbiAgICB9O1xuICAgIHZhciBNdCA9ICByKCkuY3JlYXRlRWxlbWVudChLbigpLCBudWxsKTtcbiAgICB2YXIgJHQgPSAgcigpLmZvcndhcmRSZWYoKGZ1bmN0aW9uKGUsIG4pIHtcbiAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChqZSgpLCBQdCh7XG4gICAgICAgICAgICBjb250ZW50OiAoMCwgVC5fKShcIkFjdGlvbnNcIiksXG4gICAgICAgICAgICBjb250ZW50UmVsYXRpb25zaGlwOiBcImxhYmVsXCJcbiAgICAgICAgfSwgZSksICByKCkuY3JlYXRlRWxlbWVudChWbigpLCB7XG4gICAgICAgICAgICBhcHBlYXJhbmNlOiBcInN1YnRsZVwiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJhY3Rpb25zLXNlY29uZGFyeS10b2dnbGVcIixcbiAgICAgICAgICAgIGljb246IE10LFxuICAgICAgICAgICAgZWxlbWVudFJlZjogblxuICAgICAgICB9KSk7XG4gICAgfSkpO1xuICAgIGZ1bmN0aW9uIE50KGUpIHtcbiAgICAgICAgdmFyIG47XG4gICAgICAgIHZhciBvID0gZS5hY3Rpb25zLCBpID0gZS5hY3Rpb25QcmltYXJ5LCBsID0gZS5hY3Rpb25zU2Vjb25kYXJ5LCB1ID0gZS5jaGlsZHJlbiwgcyA9IGUuZGF0YSwgYyA9IGUuZHJhZ0lkLCBkID0gZS5kaXNhYmxlZCwgZiA9IGUuaXNEcmFnZ2FibGUsIHYgPSBlLmVsZW1lbnRSZWYsIHAgPSBlLmV4cGFuZGFibGUsIG0gPSBlLmV4cGFuZGVkLCBoID0gZS5leHBhbnNpb25Sb3dJZHMsIHkgPSBlLmV4cGFuc2lvblJvdywgZyA9IGUuaW5kZXgsIHcgPSBlLm1vdmFibGVDb2x1bW5zLCBDID0gZS5vbkNsaWNrLCB4ID0gZS5vbkV4cGFuc2lvbiwgUyA9IGUub25LZXlEb3duLCBPID0gZS5vblJlcXVlc3RUb2dnbGUsIGsgPSBlLnByaW1hcnlDb2x1bW5JbmRleCwgUiA9IGsgPT09IHZvaWQgMCA/IDAgOiBrLCBFID0gZS5yb3dTY3JlZW5SZWFkZXJUZXh0LCBEID0gZS5zZWxlY3RlZCwgcSA9IGUuc3RyaXBlLCBBID0gcSA9PT0gdm9pZCAwID8gXCJub25lXCIgOiBxLCBQID0gZS5zdHlsZSwgXyA9IHF0KGUsIFsgXCJhY3Rpb25zXCIsIFwiYWN0aW9uUHJpbWFyeVwiLCBcImFjdGlvbnNTZWNvbmRhcnlcIiwgXCJjaGlsZHJlblwiLCBcImRhdGFcIiwgXCJkcmFnSWRcIiwgXCJkaXNhYmxlZFwiLCBcImlzRHJhZ2dhYmxlXCIsIFwiZWxlbWVudFJlZlwiLCBcImV4cGFuZGFibGVcIiwgXCJleHBhbmRlZFwiLCBcImV4cGFuc2lvblJvd0lkc1wiLCBcImV4cGFuc2lvblJvd1wiLCBcImluZGV4XCIsIFwibW92YWJsZUNvbHVtbnNcIiwgXCJvbkNsaWNrXCIsIFwib25FeHBhbnNpb25cIiwgXCJvbktleURvd25cIiwgXCJvblJlcXVlc3RUb2dnbGVcIiwgXCJwcmltYXJ5Q29sdW1uSW5kZXhcIiwgXCJyb3dTY3JlZW5SZWFkZXJUZXh0XCIsIFwic2VsZWN0ZWRcIiwgXCJzdHJpcGVcIiwgXCJzdHlsZVwiIF0pO1xuIC8vIEBkb2NzLXByb3BzLXR5cGUgUm93UHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIHogPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIGlkOiBmID8gYyA6ICgwLCBqLmNyZWF0ZUdVSUQpKCksXG4gICAgICAgICAgICAgICAgZGlzYWJsZWQ6ICFmXG4gICAgICAgICAgICB9O1xuICAgICAgICB9KSwgWyBmLCBjIF0pO1xuICAgICAgICB2YXIgTSA9ICgwLCBhLnVzZVNvcnRhYmxlKSh6KSwgJCA9IE0uYXR0cmlidXRlcywgTCA9IE0ubGlzdGVuZXJzLCBXID0gTS50cmFuc2Zvcm0sIEggPSBNLnRyYW5zaXRpb24sIEsgPSBNLnNldE5vZGVSZWYsIEIgPSBNLnNldEFjdGl2YXRvck5vZGVSZWY7XG4gICAgICAgIHZhciBWID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIGYgPyBJdChJdCh7fSwgUCksIHt9LCB7XG4gICAgICAgICAgICAgICAgdHJhbnNmb3JtOiBXbi5DU1MuVHJhbnNsYXRlLnRvU3RyaW5nKFcpLFxuICAgICAgICAgICAgICAgIHRyYW5zaXRpb246IEhcbiAgICAgICAgICAgIH0pIDogUDtcbiAgICAgICAgfSksIFsgZiwgVywgSCwgUCBdKTtcbiAgICAgICAgdmFyIEYgPSAoMCwgdC51c2VSZWYpKG51bGwpO1xuICAgICAgICB2YXIgVSA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgdmFyIG4gPSBlLnRhcmdldDtcbiAgICAgICAgICAgIHdoaWxlIChuKSB7XG4gICAgICAgICAgICAgICAgaWYgKEYuY3VycmVudCA9PT0gbikge1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgLy8gSWdub3JlIGNsaWNrcyBvbiByb3ctYWN0aW9uc1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAobi50YWdOYW1lID09PSBcIkJVVFRPTlwiIHx8IG4udGFnTmFtZSA9PT0gXCJBXCIpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBuID0gbi5wYXJlbnROb2RlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKCFlLmRlZmF1bHRQcmV2ZW50ZWQpIHtcbiAgICAgICAgICAgICAgICBDID09PSBudWxsIHx8IEMgPT09IHZvaWQgMCA/IHZvaWQgMCA6IEMoZSwgcyk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIHMsIEMgXSk7XG4gICAgICAgIHZhciBYID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBpZiAoZS5rZXkgPT09IFwiRW50ZXJcIiAmJiBDKSB7XG4gICAgICAgICAgICAgICAgQyhlLCBzKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFMgPT09IG51bGwgfHwgUyA9PT0gdm9pZCAwID8gdm9pZCAwIDogUyhlKTtcbiAgICAgICAgfSksIFsgcywgQywgUyBdKTtcbiAgICAgICAgdmFyIFkgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmICghZCkge1xuICAgICAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgICAgICBPID09PSBudWxsIHx8IE8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IE8oZSwgcyk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIHMsIGQsIE8gXSk7XG4gICAgICAgIHZhciBHID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICB4ID09PSBudWxsIHx8IHggPT09IHZvaWQgMCA/IHZvaWQgMCA6IHgoZSwgcyk7XG4gICAgICAgIH0pLCBbIHMsIHggXSk7XG4gICAgICAgIHZhciBKID0gZnVuY3Rpb24gbigpIHtcbiAgICAgICAgICAgIGlmIChpICYmIGkucHJvcHMub25DbGljaykge1xuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIHJldHVybiAoMCwgdC5jbG9uZUVsZW1lbnQpKGksIHtcbiAgICAgICAgICAgICAgICAgICAgb25DbGljazogZnVuY3Rpb24gbih0KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgciwgbztcbiAgICAgICAgICAgICAgICAgICAgICAgIHQucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiAociA9IChvID0gaS5wcm9wcykub25DbGljaykgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5jYWxsKG8sIHQsIGUuZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBpO1xuICAgICAgICB9O1xuICAgICAgICB2YXIgUSA9IGZ1bmN0aW9uIG4oKSB7XG4gICAgICAgICAgICBpZiAobCAmJiBsLnByb3BzLmNoaWxkcmVuKSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSB0LkNoaWxkcmVuLnRvQXJyYXkobC5wcm9wcy5jaGlsZHJlbikuZmlsdGVyKHQuaXNWYWxpZEVsZW1lbnQpO1xuICAgICAgICAgICAgICAgIHZhciBvID0gci5tYXAoKGZ1bmN0aW9uKG4pIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKG4ucHJvcHMub25DbGljaykge1xuICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gKDAsIHQuY2xvbmVFbGVtZW50KShuLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgb25DbGljazogZnVuY3Rpb24gdChyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBvLCBpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiAobyA9IChpID0gbi5wcm9wcykub25DbGljaykgPT09IG51bGwgfHwgbyA9PT0gdm9pZCAwID8gdm9pZCAwIDogby5jYWxsKGksIHIsIGUuZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIG47XG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIHJldHVybiAoMCwgdC5jbG9uZUVsZW1lbnQpKGwsIHtcbiAgICAgICAgICAgICAgICAgICAgY2hpbGRyZW46IG9cbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBsO1xuICAgICAgICB9O1xuICAgICAgICBmdW5jdGlvbiBaKGUpIHtcbiAgICAgICAgICAgIEYuY3VycmVudCA9IGU7XG4gICAgICAgICAgICBOKHYsIGUpO1xuICAgICAgICAgICAgaWYgKGYpIHtcbiAgICAgICAgICAgICAgICBLKGUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHZhciBlZSA9IHQuQ2hpbGRyZW4udG9BcnJheSh1KS5tYXAoKGZ1bmN0aW9uKGUsIG4pIHtcbiAgICAgICAgICAgIFxuICAgICAgICAgICAgcmV0dXJuICgwLCB0LmNsb25lRWxlbWVudCkoZSwge1xuICAgICAgICAgICAgICAgIGFwcGVhcmFuY2U6IEMgPyBcInJvd0xpbmtcIiA6IGUucHJvcHMuYXBwZWFyYW5jZSxcbiAgICAgICAgICAgICAgICBkaXNhYmxlZDogZCxcbiAgICAgICAgICAgICAgICBpc1ByaW1hcnlDZWxsOiBSID09PSBuLFxuICAgICAgICAgICAgICAgIHN0cmlwZTogQVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pKTtcbiAgICAgICAgdmFyIG5lO1xuICAgICAgICBpZiAoRSkge1xuICAgICAgICAgICAgbmUgPSBFO1xuICAgICAgICB9IGVsc2UgaWYgKChuID0gZWVbUl0pID09PSBudWxsIHx8IG4gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG4ucHJvcHMuY2hpbGRyZW4pIHtcbiAgICAgICAgICAgIHZhciB0ZTtcbiAgICAgICAgICAgIG5lID0gXCJcIi5jb25jYXQoKHRlID0gZWVbUl0pID09PSBudWxsIHx8IHRlID09PSB2b2lkIDAgPyB2b2lkIDAgOiB0ZS5wcm9wcy5jaGlsZHJlbik7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB2YXIgcmU7XG4gICAgICAgICAgICBuZSA9IFwiXCIuY29uY2F0KChyZSA9IGVlWzBdKSA9PT0gbnVsbCB8fCByZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogcmUucHJvcHMuY2hpbGRyZW4pO1xuICAgICAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICB9XG4gICAgICAgIHZhciBvZSA9ICgwLCBJLnNwcmludGYpKCgwLCBULl8pKFwiJShzZWxlY3RlZClzXCIpLCB7XG4gICAgICAgICAgICBzZWxlY3RlZDogRCA/IFwic2VsZWN0ZWRcIiA6IFwidW5zZWxlY3RlZFwiXG4gICAgICAgIH0pO1xuICAgICAgICB2YXIgaWUgPSBfdFtBXTtcbiAgICAgICAgdmFyIGFlID0gbSA/IHQuQ2hpbGRyZW4uY291bnQoeSkgKyAxIDogdW5kZWZpbmVkO1xuICAgICAgICB2YXIgbGUgPSB3ID8gXCJmYWxzZVwiIDogdW5kZWZpbmVkO1xuICAgICAgICB2YXIgdWUgPSBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgXG4gICAgICAgICAgICByZXR1cm4gcigpLmNyZWF0ZUVsZW1lbnQoJHQsIG51bGwpO1xuICAgICAgICB9O1xuICAgICAgICB2YXIgc2UgPSAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIkNvbGxhcHNlIHJvdyAtICUocm93TGFiZWxWYWx1ZSlzXCIpLCB7XG4gICAgICAgICAgICByb3dMYWJlbFZhbHVlOiBuZVxuICAgICAgICB9KTtcbiAgICAgICAgdmFyIGNlID0gKDAsIEkuc3ByaW50ZikoKDAsIFQuXykoXCJFeHBhbmQgcm93IC0gJShyb3dMYWJlbFZhbHVlKXNcIiksIHtcbiAgICAgICAgICAgIHJvd0xhYmVsVmFsdWU6IG5lXG4gICAgICAgIH0pO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KGllLCBQdCh7XG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcInJvd1wiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3Qtc2VsZWN0ZWRcIjogTyA/IEQgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICAkY2xpY2thYmxlOiAhIUMsXG4gICAgICAgICAgICBcImRhdGEtaGFzLW1vdmFibGUtY29sdW1uc1wiOiB3ID8gXCJ0cnVlXCIgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBkaXNhYmxlZDogISFkLFxuICAgICAgICAgICAgJGV4cGFuZGFibGU6ICEhcCxcbiAgICAgICAgICAgICRpc0RyYWdnYWJsZTogISFmLFxuICAgICAgICAgICAgcmVmOiBaLFxuICAgICAgICAgICAgdGFiSW5kZXg6IEMgPyAwIDogdW5kZWZpbmVkXG4gICAgICAgIH0sIGIoKShfLCBcImRhdGFcIiksIHtcbiAgICAgICAgICAgIG9uQ2xpY2s6IEMgPyBVIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgb25LZXlEb3duOiBYLFxuICAgICAgICAgICAgJHJvd1NlbGVjdGVkOiAhIShPICYmIEQpLFxuICAgICAgICAgICAgc3R5bGU6IFZcbiAgICAgICAgfSksIGYgJiYgZyAhPSBudWxsICYmICByKCkuY3JlYXRlRWxlbWVudChkdCwgUHQoe1xuICAgICAgICAgICAgXCJhcmlhLWxhYmVsXCI6ICgwLCBJLnNwcmludGYpKCgwLCBULl8pKFwiUmVvcmRlciAlKHJvd0xhYmVsVmFsdWUpc1wiKSwge1xuICAgICAgICAgICAgICAgIHJvd0xhYmVsVmFsdWU6IG5lXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHNldEFjdGl2YXRvck5vZGVSZWY6IEIsXG4gICAgICAgICAgICBsaXN0ZW5lcnM6IExcbiAgICAgICAgfSwgJCkpLCBPICYmICByKCkuY3JlYXRlRWxlbWVudCh4ZSwge1xuICAgICAgICAgICAgYWxpZ246IFwiY2VudGVyXCIsXG4gICAgICAgICAgICBhcHBlYXJhbmNlOiBDID8gXCJyb3dMaW5rXCIgOiBcImRhdGFcIixcbiAgICAgICAgICAgIGRpc2FibGVkOiBkLFxuICAgICAgICAgICAgdmFyaWFudDogXCJ0b2dnbGVcIixcbiAgICAgICAgICAgIFwiZGF0YS1tb3ZhYmxlLWNvbHVtblwiOiBsZSxcbiAgICAgICAgICAgIHJvd1NwYW46IGFlLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJ0b2dnbGVcIlxuICAgICAgICB9LCAgcigpLmNyZWF0ZUVsZW1lbnQoa3QsIHtcbiAgICAgICAgICAgIFwiYXJpYS1sYWJlbFwiOiAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIiUocm93TGFiZWxWYWx1ZSlzICUoc2VsZWN0ZWRTdHJpbmcpc1wiKSwge1xuICAgICAgICAgICAgICAgIHJvd0xhYmVsVmFsdWU6IG5lLFxuICAgICAgICAgICAgICAgIHNlbGVjdGVkU3RyaW5nOiBvZVxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBkaXNhYmxlZDogZCxcbiAgICAgICAgICAgIG9uQ2xpY2s6IFksXG4gICAgICAgICAgICBzZWxlY3RlZDogRFxuICAgICAgICB9KSksIHAgJiYgeSAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoeGUsIHtcbiAgICAgICAgICAgIGFsaWduOiBcImNlbnRlclwiLFxuICAgICAgICAgICAgYXBwZWFyYW5jZTogXCJkYXRhXCIsXG4gICAgICAgICAgICBcImRhdGEtbW92YWJsZS1jb2x1bW5cIjogbGUsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImV4cGFuZFwiLFxuICAgICAgICAgICAgZXhwYW5kOiBtLFxuICAgICAgICAgICAgcm93U3BhbjogYWUsXG4gICAgICAgICAgICB2YXJpYW50OiBcImV4cGFuZFwiXG4gICAgICAgIH0sICByKCkuY3JlYXRlRWxlbWVudChydCwge1xuICAgICAgICAgICAgZXhwYW5kZWQ6IG0sXG4gICAgICAgICAgICBvbkNsaWNrOiBHLFxuICAgICAgICAgICAgdGl0bGU6IG0gPyBzZSA6IGNlLFxuICAgICAgICAgICAgXCJhcmlhLWNvbnRyb2xzXCI6IG0gPyBoIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgXCJhcmlhLWV4cGFuZGVkXCI6IG1cbiAgICAgICAgfSkpLCBwICYmICF5ICYmICByKCkuY3JlYXRlRWxlbWVudCh4ZSwge1xuICAgICAgICAgICAgdmFyaWFudDogXCJleHBhbmRcIixcbiAgICAgICAgICAgIFwiZGF0YS1tb3ZhYmxlLWNvbHVtblwiOiBsZVxuICAgICAgICB9KSwgZWUsIG8gJiYgIWkgJiYgIWwgJiYgIHIoKS5jcmVhdGVFbGVtZW50KHhlLCB7XG4gICAgICAgICAgICBhbGlnbjogXCJyaWdodFwiLFxuICAgICAgICAgICAgYXBwZWFyYW5jZTogQyA/IFwicm93TGlua1wiIDogXCJkYXRhXCIsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcInJvdy1hY3Rpb25zXCIsXG4gICAgICAgICAgICB2YXJpYW50OiBcImFjdGlvbnNcIixcbiAgICAgICAgICAgIFwiZGF0YS1tb3ZhYmxlLWNvbHVtblwiOiBsZVxuICAgICAgICB9KSwgKGkgfHwgbCkgJiYgIHIoKS5jcmVhdGVFbGVtZW50KHhlLCB7XG4gICAgICAgICAgICBhbGlnbjogXCJyaWdodFwiLFxuICAgICAgICAgICAgYXBwZWFyYW5jZTogXCJkYXRhXCIsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcInJvdy1hY3Rpb25zXCIsXG4gICAgICAgICAgICB2YXJpYW50OiBcImFjdGlvbnNcIixcbiAgICAgICAgICAgIFwiZGF0YS1tb3ZhYmxlLWNvbHVtblwiOiBsZVxuICAgICAgICB9LCBpICYmIEooKSwgbCAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoVW4oKSwge1xuICAgICAgICAgICAgdG9nZ2xlOiB1ZSgpXG4gICAgICAgIH0sIFEoKSkpKTtcbiAgICB9XG4gICAgTnQucHJvcFR5cGVzID0genQ7XG4gICAgTnQuc3BsdW5rVWlUeXBlID0gXCJUYWJsZS5Sb3dcIjtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IEx0ID0gTnQ7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvVGFibGVDb250ZXh0LnRzXG4gICAgdmFyIFd0ID0gICgwLCB0LmNyZWF0ZUNvbnRleHQpKHt9KTtcbiAgICBXdC5kaXNwbGF5TmFtZSA9IFwiVGFibGVcIjtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IEh0ID0gV3Q7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvSGVhZC50c3hcbiAgICBmdW5jdGlvbiBLdCgpIHtcbiAgICAgICAgcmV0dXJuIEt0ID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IGFyZ3VtZW50c1tuXTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciByIGluIHQpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsIHIpICYmIChlW3JdID0gdFtyXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIEt0LmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEJ0KGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCwgciwgbyA9IFZ0KGUsIG4pO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChyID0gMDsgciA8IGkubGVuZ3RoOyByKyspIHtcbiAgICAgICAgICAgICAgICB0ID0gaVtyXSwgLTEgPT09IG4uaW5kZXhPZih0KSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHQpICYmIChvW3RdID0gZVt0XSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG87XG4gICAgfVxuICAgIGZ1bmN0aW9uIFZ0KGUsIG4pIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgdCA9IHt9O1xuICAgICAgICBmb3IgKHZhciByIGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIHIpKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSBuLmluZGV4T2YocikpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIHRbcl0gPSBlW3JdO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0O1xuICAgIH1cbiAgICB2YXIgRnQgPSB7XG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgYWN0aW9uczogdygpLmFycmF5T2YodygpLm5vZGUpLFxuICAgICAgICAvKiogQHByaXZhdGUuICovXG4gICAgICAgIGFjdGlvbnNDb2x1bW5XaWR0aDogdygpLm51bWJlcixcbiAgICAgICAgLyoqIEBwcml2YXRlICovXG4gICAgICAgIGNlbGxNaW5XaWR0aDogdygpLm51bWJlcixcbiAgICAgICAgY2hpbGRyZW46IHcoKS5ub2RlLFxuICAgICAgICBlbGVtZW50UmVmOiB3KCkub25lT2ZUeXBlKFsgdygpLmZ1bmMsIHcoKS5vYmplY3QgXSksXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgaGFzRHJhZ0NvbHVtbjogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgaGFzSW5mb0NvbHVtbjogdygpLmJvb2wsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25BdXRvc2l6ZUNvbHVtbjogdygpLmZ1bmMsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25SZXF1ZXN0TW92ZUNvbHVtbjogdygpLmZ1bmMsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25SZXF1ZXN0UmVzaXplQ29sdW1uOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBvblJlcXVlc3RUb2dnbGVBbGxSb3dzOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICByb3dTZWxlY3Rpb246IHcoKS5vbmVPZihbIFwiYWxsXCIsIFwic29tZVwiLCBcIm5vbmVcIiBdKVxuICAgIH07XG4gICAgdmFyIFV0ID0gMTtcbiAgICB2YXIgWHQgPSB7XG4gICAgICAgIGFsbDogdHJ1ZSxcbiAgICAgICAgbm9uZTogZmFsc2UsXG4gICAgICAgIHNvbWU6IFwic29tZVwiXG4gICAgfTtcbiAgICB2YXIgWXQgPSAoMCwgVC5fKShcIk5vIHJvd3Mgc2VsZWN0ZWRcIik7XG4gICAgdmFyIEd0ID0gKDAsIFQuXykoXCJTb21lIHJvd3Mgc2VsZWN0ZWRcIik7XG4gICAgdmFyIEp0ID0gKDAsIFQuXykoXCJBbGwgcm93cyBzZWxlY3RlZFwiKTtcbiAgICB2YXIgUXQgPSBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgdmFyIHQsIHI7XG4gICAgICAgIHZhciBvID0gdW4oKTtcbiAgICAgICAgaWYgKCFuKSB7XG4gICAgICAgICAgICByZXR1cm4gW107XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIEFycmF5LmZyb20oKHQgPSAociA9IG4uZmlyc3RFbGVtZW50Q2hpbGQpID09PSBudWxsIHx8IHIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHIuY2hpbGRyZW4pICE9PSBudWxsICYmIHQgIT09IHZvaWQgMCA/IHQgOiBbXSkubWFwKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgbiA9IG8uZ2V0Q29tcHV0ZWRTdHlsZShlKTtcbiAgICAgICAgICAgIHJldHVybiBlLmNsaWVudFdpZHRoIC0gcGFyc2VGbG9hdChuLmdldFByb3BlcnR5VmFsdWUoXCJwYWRkaW5nLXJpZ2h0XCIpKSAtIHBhcnNlRmxvYXQobi5nZXRQcm9wZXJ0eVZhbHVlKFwicGFkZGluZy1sZWZ0XCIpKTtcbiAgICAgICAgfSkpO1xuICAgIH07XG4gICAgZnVuY3Rpb24gWnQoZSkge1xuICAgICAgICB2YXIgbiA9IGUuYWN0aW9ucywgbyA9IG4gPT09IHZvaWQgMCA/IFtdIDogbiwgaSA9IGUuYWN0aW9uc0NvbHVtbldpZHRoLCBhID0gZS5jZWxsTWluV2lkdGgsIGwgPSBhID09PSB2b2lkIDAgPyA2MCA6IGEsIHUgPSBlLmNoaWxkcmVuLCBzID0gZS5lbGVtZW50UmVmLCBjID0gZS5oYXNEcmFnQ29sdW1uLCBkID0gZS5oYXNJbmZvQ29sdW1uLCBmID0gZS5vbkF1dG9zaXplQ29sdW1uLCB2ID0gZS5vblJlcXVlc3RNb3ZlQ29sdW1uLCBwID0gZS5vblJlcXVlc3RSZXNpemVDb2x1bW4sIG0gPSBlLm9uUmVxdWVzdFRvZ2dsZUFsbFJvd3MsIGIgPSBlLnJvd1NlbGVjdGlvbiwgaCA9IEJ0KGUsIFsgXCJhY3Rpb25zXCIsIFwiYWN0aW9uc0NvbHVtbldpZHRoXCIsIFwiY2VsbE1pbldpZHRoXCIsIFwiY2hpbGRyZW5cIiwgXCJlbGVtZW50UmVmXCIsIFwiaGFzRHJhZ0NvbHVtblwiLCBcImhhc0luZm9Db2x1bW5cIiwgXCJvbkF1dG9zaXplQ29sdW1uXCIsIFwib25SZXF1ZXN0TW92ZUNvbHVtblwiLCBcIm9uUmVxdWVzdFJlc2l6ZUNvbHVtblwiLCBcIm9uUmVxdWVzdFRvZ2dsZUFsbFJvd3NcIiwgXCJyb3dTZWxlY3Rpb25cIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBIZWFkUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIHkgPSAoMCwgdC51c2VDb250ZXh0KShIdCksIGcgPSB5LmhlYWRUeXBlLCB3ID0geS50YWJsZUNvbnRhaW5lcldpZHRoV2l0aG91dEJvcmRlcnMsIEMgPSB5LnJlc2l6YWJsZUZpbGxMYXlvdXQ7XG4gICAgICAgIHZhciB4ID0gKDAsIHQudXNlUmVmKShudWxsKTtcbiAgICAgICAgdmFyIFMgPSAoMCwgdC51c2VSZWYpKFtdKTtcbiAgICAgICAgKDAsIHQudXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICAvLyBWYWxpZGF0ZSBjaGlsZHJlbiB3aWR0aFxuICAgICAgICAgICAgaWYgKGZhbHNlKSB7XG4gICAgICAgICAgICAgICAgdmFyIGU7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIHUsIHAsIEMgXSk7XG4gICAgICAgIHZhciBPID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgbiA9IGUuZnJvbUluZGV4LCByID0gZS50b0luZGV4O1xuICAgICAgICAgICAgaWYgKHIgPCB0LkNoaWxkcmVuLnRvQXJyYXkodSkubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgLy8gSGVhZENlbGwgbmV2ZXIgcmVxdWVzdHMgbGVzcyB0aGFuIHplcm9cbiAgICAgICAgICAgICAgICB2ID09PSBudWxsIHx8IHYgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHYoe1xuICAgICAgICAgICAgICAgICAgICBmcm9tSW5kZXg6IG4sXG4gICAgICAgICAgICAgICAgICAgIHRvSW5kZXg6IHJcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgdSwgdiBdKTtcbiAgICAgICAgdmFyIGsgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUsIG4pIHtcbiAgICAgICAgICAgIHZhciB0ID0gbi5jb2x1bW5JZCwgciA9IG4uaWQsIG8gPSBuLmluZGV4LCBpID0gbi53aWR0aDtcbiAgICAgICAgICAgIHZhciBhID0gUXQoeC5jdXJyZW50KTtcbiAgICAgICAgICAgIGlmIChvID49IGEubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIG4pO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhciB1ID0gYVtvXTtcbiAgICAgICAgICAgIHZhciBzID0gaSAtIHU7XG4gICAgICAgICAgICBpZiAocyA8PSAwKSB7XG4gICAgICAgICAgICAgICAgLy8gaGFuZGxlIHNocmlua2luZ1xuICAgICAgICAgICAgICAgIGlmIChpID49IGwpIHtcbiAgICAgICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIG4pO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIHNocmluayB0aGUgY2VsbCBhcyBzbWFsbCBhcyB3ZSBjYW5cbiAgICAgICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbHVtbklkOiB0LFxuICAgICAgICAgICAgICAgICAgICAgICAgaWQ6IHIsXG4gICAgICAgICAgICAgICAgICAgICAgICBpbmRleDogbyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHdpZHRoOiBsXG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgLy8gaGFuZGxlIGV4cGFuc2lvblxuICAgICAgICAgICAgICAgIHZhciBjID0gW107XG4gICAgICAgICAgICAgICAgdmFyIGQgPSAwO1xuICAgICAgICAgICAgICAgIHZhciBmID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICBpZiAoUy5jdXJyZW50Lmxlbmd0aCAhPT0gYS5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIG4pO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIFMuY3VycmVudC5mb3JFYWNoKChmdW5jdGlvbihlLCBuKSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChlID09PSBcImF1dG9cIikge1xuICAgICAgICAgICAgICAgICAgICAgICAgZCArPSAxO1xuICAgICAgICAgICAgICAgICAgICAgICAgYy5wdXNoKG4pO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgIGlmIChkID4gMCkge1xuICAgICAgICAgICAgICAgICAgICAvLyBpZiB0aGVyZSBhcmUgYXV0byB3aWR0aCBjZWxscywgY2hlY2sgaWYgc2hyaW5raW5nIHRoZW0gYnkgY2hhbmdlUGVyRWFjaEF1dG9DZWxsIG1ha2UgdGhlbSBzbWFsbGVyIHRoYW4gY2VsbE1pbldpZHRoXG4gICAgICAgICAgICAgICAgICAgIHZhciB2ID0gcyAvIGQ7XG4gICAgICAgICAgICAgICAgICAgIGMuZXZlcnkoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmIChlIDwgYS5sZW5ndGggJiYgYVtlXSAtIHYgPCBsKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZiA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICAgICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICAgICAgICAgIGlmIChmKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwID09PSBudWxsIHx8IHAgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHAoZSwgbik7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAvLyBtYWtlIHRoZSBjZWxsIGFzIGJpZyBhcyB3ZSBjYW4gd2l0aG91dCBsZXR0aW5nIGFueSBjZWxscyBnbyBiZWxvdyBjZWxsTWluV2lkdGhcbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIHRoYXQgbWVhbnMgYWxsIGF1dG8gY2VsbHMgYXJlIGF0IGNlbGxNaW5XaWR0aCBhbmQgYWxsIHRoZSBzZXQgd2lkdGggY2VsbHMgc3RheSB0aGUgc2FtZSBzaXplXG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgbSA9IDA7XG4gICAgICAgICAgICAgICAgICAgICAgICBjLmZvckVhY2goKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoZSA8IGEubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG0gKz0gTWF0aC5tYXgoYVtlXSAtIGwsIDApO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIH0pKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBiID0gYVtvXSArIG07XG4gICAgICAgICAgICAgICAgICAgICAgICBwID09PSBudWxsIHx8IHAgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHAoZSwge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbHVtbklkOiB0LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlkOiByLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluZGV4OiBvLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHdpZHRoOiBiXG4gICAgICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAodyAhPSBudWxsKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIGlmIHRoZXJlIGFyZSBubyBhdXRvIHdpZHRoIGNlbGxzLCBjaGVjayBpZiBzaHJpbmtpbmcgdGhlIGxhc3QgY2VsbCBieSByZXF1ZXN0ZWQgY2hhbmdlIG1ha2VzIGl0IHNtYWxsZXIgdGhhbiBjZWxsTWluV2lkdGhcbiAgICAgICAgICAgICAgICAgICAgLyoqXG4gICAgICAgICAqIFdlIG5lZWQgdG8gY2FsY3VsYXRlIHRoZSBwZXJjaWV2ZWQgd2lkdGggb2YgdGhlIGxhc3QgY2VsbCwgYmVjYXVzZSBpZiB0aGUgdXNlciBtb2RpZmllcyB0aGUgc2l6ZSBvZiB0aGUgbGFzdCBoZWFkIGNlbGwsXG4gICAgICAgICAqIHRoZSB3aWR0aCBvZiB0aGUgbGFzdCBjZWxsIHdpbGwgdGVjaG5pY2FsbHkgYmUgd2hhdGV2ZXIgdGhleSBtYWRlIGl0LCBidXQgdGhlIGxhc3QgY2VsbCB3aWxsIGdldCBjdXQgb2ZmIGlmIGl0IGV4dGVuZHMgcGFzdFxuICAgICAgICAgKiB0aGUgdGFibGUgY29udGFpbmVyJ3Mgd2lkdGguXG4gICAgICAgICAqL1xuICAgICAgICAgICAgICAgICAgICB2YXIgaCA9IGEuc2xpY2UoMCwgYS5sZW5ndGggLSAxKTtcbiAgICAgICAgICAgICAgICAgICAgdmFyIHkgPSBoLnJlZHVjZSgoZnVuY3Rpb24oZSwgbikge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGUgKyBuO1xuICAgICAgICAgICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICAgICAgICAgIHZhciBnID0gdyAtIHk7XG4gICAgICAgICAgICAgICAgICAgIGlmIChnIC0gcyA+PSBsKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwID09PSBudWxsIHx8IHAgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHAoZSwgbik7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAvLyBtYWtlIHRoZSBjZWxsIGFzIGJpZyBhcyB3ZSBjYW4gd2l0aG91dCBsZXR0aW5nIHBlcmNlaXZlZFdpZHRoT2ZMYXN0Q2VsbCBnbyBiZWxvdyBjZWxsTWluV2lkdGhcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBDID0gZyAtIGw7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgTyA9IHUgKyBDO1xuICAgICAgICAgICAgICAgICAgICAgICAgcCA9PT0gbnVsbCB8fCBwID09PSB2b2lkIDAgPyB2b2lkIDAgOiBwKGUsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2x1bW5JZDogdCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZDogcixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpbmRleDogbyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogT1xuICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAvKipcbiAgICAgICAgICogSWYgdGFibGVDb250YWluZXJXaWR0aFdpdGhvdXRCb3JkZXJzID09IG51bGwsIHRoZXJlIGlzbid0IGEgd2F5IHRvIGNvcnJlY3RseSBjYWxjdWxhdGVcbiAgICAgICAgICogdGhlIHBlcmNlaXZlZCB3aWR0aCBzbyB0aGlzIGNhc2Ugd2lsbCByZXN1bHQgaW4gY29sdW1ucyBwb3NzaWJseSBnb2luZyBvZmZzY3JlZW4uIEluIHRlc3RpbmcsXG4gICAgICAgICAqIHRhYmxlQ29udGFpbmVyV2lkdGhXaXRob3V0Qm9yZGVycyBhdHRhaW5zIGEgdmFsdWUgcXVpY2tseSBlbm91Z2ggdGhhdCBpdCBpc24ndCBhIHByb2JsZW0uXG4gICAgICAgICAqL1xuICAgICAgICAgICAgICAgICAgICBwID09PSBudWxsIHx8IHAgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHAoZSwgbik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBsLCBwLCB3IF0pO1xuICAgICAgICB2YXIgUiA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgTihzLCBlKTtcbiAgICAgICAgICAgIHguY3VycmVudCA9IGU7XG4gICAgICAgIH0pLCBbIHMgXSk7XG4gICAgICAgIHZhciBFID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIHQuQ2hpbGRyZW4udG9BcnJheSh1KS5maWx0ZXIodC5pc1ZhbGlkRWxlbWVudCk7XG4gICAgICAgIH0pLCBbIHUgXSk7XG4gICAgICAgIHZhciBJID0gRS5sZW5ndGggKyAoby5sZW5ndGggfHwgaSA/IDEgOiAwKTtcbiAgICAgICAgdmFyIFQgPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICB2YXIgZSA9IFtdO1xuICAgICAgICAgICAgdmFyIG4gPSBFLm1hcCgoZnVuY3Rpb24obiwgcikge1xuICAgICAgICAgICAgICAgIGUucHVzaChuLnByb3BzLndpZHRoKTtcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgICAgICAgICByZXR1cm4gKDAsIHQuY2xvbmVFbGVtZW50KShuLCB7XG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiByLFxuICAgICAgICAgICAgICAgICAgICBvblJlcXVlc3RSZXNpemU6IEMgPyBrIDogcCxcbiAgICAgICAgICAgICAgICAgICAgb25SZXF1ZXN0TW92ZUNvbHVtbjogdiA/IE8gOiB1bmRlZmluZWQsXG4gICAgICAgICAgICAgICAgICAgIG9uQXV0b3NpemVDb2x1bW46IGYsXG4gICAgICAgICAgICAgICAgICAgIGtleTogbi5rZXkgfHwgbi5wcm9wcy5jb2x1bW5JZCB8fCByXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICBTLmN1cnJlbnQgPSBlO1xuICAgICAgICAgICAgcmV0dXJuIG47XG4gICAgICAgIH0pLCBbIEUsIEMsIGssIHAsIHYsIE8sIGYgXSk7XG4gICAgICAgIHZhciBqID0gYiA9PT0gdW5kZWZpbmVkID8gdW5kZWZpbmVkIDogWHRbYl07XG4gICAgICAgIHZhciBEID0gaSB8fCA0ODtcbiAgICAgICAgdmFyIHEgPSBnID09PSBcImZpeGVkXCIgPyBcImZpeGVkLWhlYWRcIiA6IFwiaGVhZFwiO1xuICAgICAgICB2YXIgQTtcbiAgICAgICAgaWYgKGogPT09IFwic29tZVwiKSB7XG4gICAgICAgICAgICBBID0gR3Q7XG4gICAgICAgIH0gZWxzZSBpZiAoaikge1xuICAgICAgICAgICAgQSA9IEp0O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgQSA9IFl0O1xuICAgICAgICB9XG4gICAgICAgIHZhciBQID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBtaW5XaWR0aDogRFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgRCBdKTtcbiAgICAgICAgdmFyIF8gPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIG1pbldpZHRoOiBpXG4gICAgICAgICAgICB9O1xuICAgICAgICB9KSwgWyBpIF0pO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KE1uLCBLdCh7XG4gICAgICAgICAgICByZWY6IFIsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBxLFxuICAgICAgICAgICAgJGlzRml4ZWQ6IGcgPT09IFwiZml4ZWRcIixcbiAgICAgICAgICAgICR6SW5kZXg6IEkgKyBVdFxuICAgICAgICB9LCBoKSwgIHIoKS5jcmVhdGVFbGVtZW50KEx0LCBudWxsLCBjICYmICByKCkuY3JlYXRlRWxlbWVudChMbiwge1xuICAgICAgICAgICAga2V5OiBcImRyYWdfcm93c19oZWFkX2NlbGxcIixcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiZHJhZy1yb3dzLWhlYWQtY2VsbFwiLFxuICAgICAgICAgICAgYWxpZ246IFwiY2VudGVyXCIsXG4gICAgICAgICAgICByZXNpemFibGU6IGZhbHNlXG4gICAgICAgIH0pLCBtICYmICByKCkuY3JlYXRlRWxlbWVudCgkbiwge1xuICAgICAgICAgICAga2V5OiBcInRvZ2dsZV9hbGxcIixcbiAgICAgICAgICAgIHJlc2l6YWJsZTogZmFsc2UsXG4gICAgICAgICAgICBhbGlnbjogXCJjZW50ZXJcIixcbiAgICAgICAgICAgIHZhcmlhbnQ6IFwidG9nZ2xlQWxsXCIsXG4gICAgICAgICAgICB0cnVuY2F0ZTogZmFsc2UsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcInRvZ2dsZS1hbGxcIlxuICAgICAgICB9LCAgcigpLmNyZWF0ZUVsZW1lbnQoa3QsIHtcbiAgICAgICAgICAgIFwiYXJpYS1sYWJlbFwiOiBBLFxuICAgICAgICAgICAgb25DbGljazogbSxcbiAgICAgICAgICAgIHNlbGVjdGVkOiBqXG4gICAgICAgIH0pKSwgZCAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoTm4sIHtcbiAgICAgICAgICAgIGtleTogXCJtb3JlX2luZm9faGVhZF9jZWxsXCIsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcIm1vcmUtaW5mby1oZWFkLWNlbGxcIixcbiAgICAgICAgICAgIHJlc2l6YWJsZTogZmFsc2UsXG4gICAgICAgICAgICB2YXJpYW50OiBcImluZm9cIlxuICAgICAgICB9KSwgVCwgby5sZW5ndGggPiAwICYmICByKCkuY3JlYXRlRWxlbWVudCh6biwge1xuICAgICAgICAgICAga2V5OiBcImFjdGlvbnNfaGVhZF9jZWxsXCIsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImFjdGlvbnMtaGVhZC1jZWxsXCIsXG4gICAgICAgICAgICBhbGlnbjogXCJyaWdodFwiLFxuICAgICAgICAgICAgcmVzaXphYmxlOiBmYWxzZSxcbiAgICAgICAgICAgIHdpZHRoOiBELFxuICAgICAgICAgICAgc3R5bGU6IFAsXG4gICAgICAgICAgICB2YXJpYW50OiBcImFjdGlvbnNcIlxuICAgICAgICB9LCBvKSwgby5sZW5ndGggPT09IDAgJiYgaSAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoem4sIHtcbiAgICAgICAgICAgIGtleTogXCJhY3Rpb25zX2hlYWRfY2VsbFwiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJhY3Rpb25zLWhlYWQtY2VsbFwiLFxuICAgICAgICAgICAgYWxpZ246IFwicmlnaHRcIixcbiAgICAgICAgICAgIHJlc2l6YWJsZTogZmFsc2UsXG4gICAgICAgICAgICB3aWR0aDogaSxcbiAgICAgICAgICAgIHN0eWxlOiBfLFxuICAgICAgICAgICAgdmFyaWFudDogXCJhY3Rpb25zXCJcbiAgICAgICAgfSwgXCIgXCIpKSk7XG4gICAgfVxuICAgIFp0LnByb3BUeXBlcyA9IEZ0O1xuICAgIFp0LnNwbHVua1VpVHlwZSA9IFwiVGFibGUuSGVhZFwiO1xuICAgIC8qIGhhcm1vbnkgZGVmYXVsdCBleHBvcnQgKi8gICAgY29uc3QgZXIgPSBadDtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pc0Zpbml0ZVwiXG4gICAgY29uc3QgbnIgPSByZXF1aXJlKFwibG9kYXNoL2lzRmluaXRlXCIpO1xuICAgIHZhciB0ciA9ICBlLm4obnIpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwibG9kYXNoL2lzRnVuY3Rpb25cIlxuICAgIGNvbnN0IHJyID0gcmVxdWlyZShcImxvZGFzaC9pc0Z1bmN0aW9uXCIpO1xuICAgIHZhciBvciA9ICBlLm4ocnIpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS9Qb3BvdmVyXCJcbiAgICBjb25zdCBpciA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL1BvcG92ZXJcIik7XG4gICAgdmFyIGFyID0gIGUubihpcik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL3VzZUNvbnRyb2xsZWRcIlxuICAgIGNvbnN0IGxyID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtdWkvdXNlQ29udHJvbGxlZFwiKTtcbiAgICB2YXIgdXIgPSAgZS5uKGxyKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9IZWFkRHJvcGRvd25DZWxsLnRzeFxuICAgIGZ1bmN0aW9uIHNyKCkge1xuICAgICAgICByZXR1cm4gc3IgPSBPYmplY3QuYXNzaWduID8gT2JqZWN0LmFzc2lnbi5iaW5kKCkgOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmb3IgKHZhciBuID0gMTsgbiA8IGFyZ3VtZW50cy5sZW5ndGg7IG4rKykge1xuICAgICAgICAgICAgICAgIHZhciB0ID0gYXJndW1lbnRzW25dO1xuICAgICAgICAgICAgICAgIGZvciAodmFyIHIgaW4gdCkge1xuICAgICAgICAgICAgICAgICAgICAoe30pLmhhc093blByb3BlcnR5LmNhbGwodCwgcikgJiYgKGVbcl0gPSB0W3JdKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfSwgc3IuYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gY3IoZSwgbikge1xuICAgICAgICByZXR1cm4gbXIoZSkgfHwgcHIoZSwgbikgfHwgZnIoZSwgbikgfHwgZHIoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZHIoKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gZGVzdHJ1Y3R1cmUgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGZyKGUsIG4pIHtcbiAgICAgICAgaWYgKGUpIHtcbiAgICAgICAgICAgIGlmIChcInN0cmluZ1wiID09IHR5cGVvZiBlKSByZXR1cm4gdnIoZSwgbik7XG4gICAgICAgICAgICB2YXIgdCA9IHt9LnRvU3RyaW5nLmNhbGwoZSkuc2xpY2UoOCwgLTEpO1xuICAgICAgICAgICAgcmV0dXJuIFwiT2JqZWN0XCIgPT09IHQgJiYgZS5jb25zdHJ1Y3RvciAmJiAodCA9IGUuY29uc3RydWN0b3IubmFtZSksIFwiTWFwXCIgPT09IHQgfHwgXCJTZXRcIiA9PT0gdCA/IEFycmF5LmZyb20oZSkgOiBcIkFyZ3VtZW50c1wiID09PSB0IHx8IC9eKD86VWl8SSludCg/Ojh8MTZ8MzIpKD86Q2xhbXBlZCk/QXJyYXkkLy50ZXN0KHQpID8gdnIoZSwgbikgOiB2b2lkIDA7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gdnIoZSwgbikge1xuICAgICAgICAobnVsbCA9PSBuIHx8IG4gPiBlLmxlbmd0aCkgJiYgKG4gPSBlLmxlbmd0aCk7XG4gICAgICAgIGZvciAodmFyIHQgPSAwLCByID0gQXJyYXkobik7IHQgPCBuOyB0KyspIHtcbiAgICAgICAgICAgIHJbdF0gPSBlW3RdO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICBmdW5jdGlvbiBwcihlLCBuKSB7XG4gICAgICAgIHZhciB0ID0gbnVsbCA9PSBlID8gbnVsbCA6IFwidW5kZWZpbmVkXCIgIT0gdHlwZW9mIFN5bWJvbCAmJiBlW1N5bWJvbC5pdGVyYXRvcl0gfHwgZVtcIkBAaXRlcmF0b3JcIl07XG4gICAgICAgIGlmIChudWxsICE9IHQpIHtcbiAgICAgICAgICAgIHZhciByLCBvLCBpLCBhLCBsID0gW10sIHUgPSAhMCwgcyA9ICExO1xuICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICBpZiAoaSA9ICh0ID0gdC5jYWxsKGUpKS5uZXh0LCAwID09PSBuKSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChPYmplY3QodCkgIT09IHQpIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgdSA9ICExO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBmb3IgKDshKHUgPSAociA9IGkuY2FsbCh0KSkuZG9uZSkgJiYgKGwucHVzaChyLnZhbHVlKSwgbC5sZW5ndGggIT09IG4pOyB1ID0gITApIHtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgICAgICAgICAgcyA9ICEwLCBvID0gZTtcbiAgICAgICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCF1ICYmIG51bGwgIT0gdFtcInJldHVyblwiXSAmJiAoYSA9IHRbXCJyZXR1cm5cIl0oKSwgT2JqZWN0KGEpICE9PSBhKSkgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChzKSB0aHJvdyBvO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBsO1xuICAgICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIG1yKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBicihlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSBocihlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiBocihlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgLyoqIEBwdWJsaWMgKi9cbiAgICAvKiogQHB1YmxpYyAqL1xuICAgIC8qKiBAcHVibGljICovICAgIHZhciB5ciA9IFsgXCJjbGlja0F3YXlcIiwgXCJjb250ZW50Q2xpY2tcIiwgXCJlc2NhcGVLZXlcIiwgXCJvZmZTY3JlZW5cIiwgXCJ0YWJLZXlcIiwgXCJ0b2dnbGVDbGlja1wiIF07XG4gICAgdmFyIGdyID0ge1xuICAgICAgICBhbGlnbjogdygpLm9uZU9mKFsgXCJsZWZ0XCIsIFwiY2VudGVyXCIsIFwicmlnaHRcIiBdKSxcbiAgICAgICAgYnV0dG9uUmVmOiB3KCkub25lT2ZUeXBlKFsgdygpLmZ1bmMsIHcoKS5vYmplY3QgXSksXG4gICAgICAgIGNhbkNvdmVySGVhZDogdygpLmJvb2wsXG4gICAgICAgIGNoaWxkcmVuOiB3KCkubm9kZS5pc1JlcXVpcmVkLFxuICAgICAgICBjbG9zZVJlYXNvbnM6IHcoKS5hcnJheU9mKHcoKS5vbmVPZih5cikpLFxuICAgICAgICBjb2x1bW5JZDogdygpLnN0cmluZyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBkcmFnSWQ6IHcoKS5vbmVPZlR5cGUoWyB3KCkuc3RyaW5nLCB3KCkubnVtYmVyIF0pLFxuICAgICAgICBlbGVtZW50UmVmOiB3KCkub25lT2ZUeXBlKFsgdygpLmZ1bmMsIHcoKS5vYmplY3QgXSksXG4gICAgICAgIGhlYWRDZWxsU2NyZWVuUmVhZGVyVGV4dDogdygpLnN0cmluZyxcbiAgICAgICAgZm9jdXNUb2dnbGVSZWFzb25zOiB3KCkuYXJyYXlPZih3KCkub25lT2YoeXIpKSxcbiAgICAgICAgLyoqIEBwcml2YXRlIFRoZSBpbmRleCBvZiB0aGUgY2VsbCwgc2tpcHBpbmcgdGhlIGluZm8gY29sdW1uLiAqL1xuICAgICAgICBpbmRleDogdygpLm51bWJlcixcbiAgICAgICAgbGFiZWw6IHcoKS5ub2RlLFxuICAgICAgICAvKiogQHByaXZhdGUuICovXG4gICAgICAgIG9uQXV0b3NpemVDb2x1bW46IHcoKS5mdW5jLFxuICAgICAgICAvKipcbiAgICogQHByaXZhdGUuIFRoaXMgd2lsbCBiZSBwYXNzZWQgdGhyb3VnaCwgYW5kIHdpbGwgd29yayBhcyBleHBlY3RlZC5cbiAgICovXG4gICAgICAgIG9uS2V5RG93bjogdygpLmZ1bmMsXG4gICAgICAgIG9uUmVxdWVzdENsb3NlOiB3KCkuZnVuYyxcbiAgICAgICAgLyoqIEBwcml2YXRlLiAqL1xuICAgICAgICBvblJlcXVlc3RNb3ZlQ29sdW1uOiB3KCkuZnVuYyxcbiAgICAgICAgb25SZXF1ZXN0T3BlbjogdygpLmZ1bmMsXG4gICAgICAgIC8qKiBAcHJpdmF0ZS4gKi9cbiAgICAgICAgb25SZXF1ZXN0UmVzaXplOiB3KCkuZnVuYyxcbiAgICAgICAgb3BlbjogdygpLmJvb2wsXG4gICAgICAgIHJlcG9zaXRpb25Nb2RlOiB3KCkub25lT2YoWyBcIm5vbmVcIiwgXCJmbGlwXCIsIFwiYW55XCIgXSksXG4gICAgICAgIHJlc2l6YWJsZTogdygpLmJvb2wsXG4gICAgICAgIHJldGFpbkZvY3VzOiB3KCkuYm9vbCxcbiAgICAgICAgdGFrZUZvY3VzOiB3KCkuYm9vbCxcbiAgICAgICAgdHJ1bmNhdGU6IHcoKS5ib29sLFxuICAgICAgICAvKipcbiAgICogQHByaXZhdGVcbiAgICogVXNlZCBpbnRlcm5hbGx5IHRvIHN1cHByZXNzIGZvY3VzIHdoZW4gdGhpcyBgSGVhZERyb3Bkb3duQ2VsbGAgaXMgc3VwZXJzZWRlZCBieSBvbmUgaW4gYW5cbiAgICogb3ZlcmxhaWQgYEhlYWRUYWJsZWAgZm9yIHVzZXIgaW50ZXJhY3Rpb25zLlxuICAgKi9cbiAgICAgICAgdmlzaWJsZTogdygpLmJvb2wsXG4gICAgICAgIHdpZHRoOiB3KCkubnVtYmVyLFxuICAgICAgICAvKiogQHByaXZhdGUuICovXG4gICAgICAgIHZhcmlhbnQ6IHcoKS5vbmVPZihbIFwidG9nZ2xlQWxsXCIsIFwiaW5mb1wiLCBcImFjdGlvbnNcIiBdKVxuICAgIH07XG4gICAgdmFyIHdyID0gWyBcImNvbnRlbnRDbGlja1wiLCBcImVzY2FwZUtleVwiLCBcInRvZ2dsZUNsaWNrXCIgXTtcbiAgICBmdW5jdGlvbiBDcihlKSB7XG4gICAgICAgIHZhciBuO1xuICAgICAgICB2YXIgbyA9IGUuYWxpZ24sIGkgPSBvID09PSB2b2lkIDAgPyBcImxlZnRcIiA6IG8sIGwgPSBlLmJ1dHRvblJlZiwgdSA9IGUuY2FuQ292ZXJIZWFkLCBzID0gdSA9PT0gdm9pZCAwID8gdHJ1ZSA6IHUsIGMgPSBlLmNoaWxkcmVuLCBkID0gZS5jbG9zZVJlYXNvbnMsIGYgPSBkID09PSB2b2lkIDAgPyB5ciA6IGQsIHYgPSBlLmNvbHVtbklkLCBwID0gZS5kcmFnSWQsIG0gPSBlLmVsZW1lbnRSZWYsIGIgPSBlLmhlYWRDZWxsU2NyZWVuUmVhZGVyVGV4dCwgaCA9IGUuZm9jdXNUb2dnbGVSZWFzb25zLCB5ID0gaCA9PT0gdm9pZCAwID8gd3IgOiBoLCBnID0gZS5pZCwgdyA9IGUuaW5kZXgsIEMgPSBlLmxhYmVsLCB4ID0gZS5vbkF1dG9zaXplQ29sdW1uLCBTID0gZS5vbktleURvd24sIE8gPSBlLm9uUmVxdWVzdENsb3NlLCBSID0gZS5vblJlcXVlc3RNb3ZlQ29sdW1uLCBFID0gZS5vblJlcXVlc3RPcGVuLCBEID0gZS5vblJlcXVlc3RSZXNpemUsIEEgPSBlLm9wZW4sIFAgPSBlLnJlcG9zaXRpb25Nb2RlLCBfID0gUCA9PT0gdm9pZCAwID8gXCJmbGlwXCIgOiBQLCB6ID0gZS5yZXNpemFibGUsIE0gPSB6ID09PSB2b2lkIDAgPyB0cnVlIDogeiwgJCA9IGUucmV0YWluRm9jdXMsIEwgPSBlLnN0eWxlLCBXID0gZS50YWtlRm9jdXMsIEggPSBXID09PSB2b2lkIDAgPyB0cnVlIDogVywgSyA9IGUudHJ1bmNhdGUsIEIgPSBLID09PSB2b2lkIDAgPyB0cnVlIDogSywgViA9IGUudmFyaWFudCwgRiA9IGUudmlzaWJsZSwgVSA9IEYgPT09IHZvaWQgMCA/IHRydWUgOiBGLCBYID0gZS53aWR0aCwgWSA9IGJyKGUsIFsgXCJhbGlnblwiLCBcImJ1dHRvblJlZlwiLCBcImNhbkNvdmVySGVhZFwiLCBcImNoaWxkcmVuXCIsIFwiY2xvc2VSZWFzb25zXCIsIFwiY29sdW1uSWRcIiwgXCJkcmFnSWRcIiwgXCJlbGVtZW50UmVmXCIsIFwiaGVhZENlbGxTY3JlZW5SZWFkZXJUZXh0XCIsIFwiZm9jdXNUb2dnbGVSZWFzb25zXCIsIFwiaWRcIiwgXCJpbmRleFwiLCBcImxhYmVsXCIsIFwib25BdXRvc2l6ZUNvbHVtblwiLCBcIm9uS2V5RG93blwiLCBcIm9uUmVxdWVzdENsb3NlXCIsIFwib25SZXF1ZXN0TW92ZUNvbHVtblwiLCBcIm9uUmVxdWVzdE9wZW5cIiwgXCJvblJlcXVlc3RSZXNpemVcIiwgXCJvcGVuXCIsIFwicmVwb3NpdGlvbk1vZGVcIiwgXCJyZXNpemFibGVcIiwgXCJyZXRhaW5Gb2N1c1wiLCBcInN0eWxlXCIsIFwidGFrZUZvY3VzXCIsIFwidHJ1bmNhdGVcIiwgXCJ2YXJpYW50XCIsIFwidmlzaWJsZVwiLCBcIndpZHRoXCIgXSk7XG4gICAgICAgIC8vIEBkb2NzLXByb3BzLXR5cGUgSGVhZERyb3Bkb3duQ2VsbFByb3BzQmFzZVxuICAgICAgICAgICAgICAgIHZhciBHID0gdXIoKSh7XG4gICAgICAgICAgICBjb21wb25lbnROYW1lOiBcIkhlYWREcm9wZG93bkNlbGxcIixcbiAgICAgICAgICAgIC8qIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBwcmVmZXItcmVzdC1wYXJhbXMgKi9cbiAgICAgICAgICAgIGNvbXBvbmVudFByb3BzOiBhcmd1bWVudHNbMF0sXG4gICAgICAgICAgICAvLyBzZWUgU1VJLTcwMjhcbiAgICAgICAgICAgIHZhbHVlUHJvcE5hbWU6IFwib3BlblwiXG4gICAgICAgIH0pO1xuICAgICAgICB2YXIgSiA9ICgwLCB0LnVzZVN0YXRlKSgpLCBRID0gY3IoSiwgMiksIFogPSBRWzBdLCBlZSA9IFFbMV07XG4gICAgICAgIHZhciBuZSA9ICgwLCB0LnVzZVN0YXRlKShudWxsKSwgdGUgPSBjcihuZSwgMiksIHJlID0gdGVbMF0sIG9lID0gdGVbMV07XG4gICAgICAgIHZhciBpZSA9ICgwLCB0LnVzZVN0YXRlKShudWxsKSwgYWUgPSBjcihpZSwgMiksIGxlID0gYWVbMF0sIHVlID0gYWVbMV07XG4gICAgICAgIHZhciBzZSA9ICgwLCB0LnVzZVN0YXRlKShmYWxzZSksIGNlID0gY3Ioc2UsIDIpLCBkZSA9IGNlWzBdLCBmZSA9IGNlWzFdO1xuICAgICAgICB2YXIgdmUgPSAoMCwgai5jcmVhdGVET01JRCkoXCJwb3BvdmVyXCIpO1xuICAgICAgICB2YXIgcGUgPSAhIVI7XG4gICAgICAgIHZhciBtZSA9ICgwLCBhLnVzZVNvcnRhYmxlKSh7XG4gICAgICAgICAgICAvLyBkcmFnSWQgaXMgb3B0aW9uYWwgaW4gSGVhZENlbGwgYnV0IHJlcXVpcmVkIGJ5IHVzZVNvcnRhYmxlXG4gICAgICAgICAgICAvLyBzaW5jZSBpdCBpcyBhbHdheXMgc2V0IGluIFRhYmxlLCB1c2UgYSB0eXBlIGFzc2VydGlvbiBoZXJlIHRvIGF2b2lkIFR5cGVTY3JpcHQgZXJyb3JcbiAgICAgICAgICAgIGlkOiBwXG4gICAgICAgIH0pLCBiZSA9IG1lLmF0dHJpYnV0ZXMsIGhlID0gbWUubGlzdGVuZXJzLCB5ZSA9IG1lLnNldE5vZGVSZWYsIGdlID0gbWUuaXNEcmFnZ2luZztcbiAgICAgICAgdmFyIHdlID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIEcgPyBBIDogZGU7XG4gICAgICAgIH0pLCBbIEcsIGRlLCBBIF0pO1xuICAgICAgICB2YXIgQ2UgPSBrKCkoVSk7XG4gICAgICAgIHZhciB4ZSA9IChuID0gZyAhPT0gbnVsbCAmJiBnICE9PSB2b2lkIDAgPyBnIDogdikgIT09IG51bGwgJiYgbiAhPT0gdm9pZCAwID8gbiA6ICgwLCBcbiAgICAgICAgai5jcmVhdGVET01JRCkoXCJoZWFkQ2VsbElkLVwiKTtcbiAgICAgICAgKDAsIHQudXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoZmFsc2UpIHt9XG4gICAgICAgIH0pLCBbIEQsIEIgXSk7XG4gICAgICAgIHZhciBTZSA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgdmFyIG4gPSBlLnJlYXNvbiwgdCA9IGUuZXZlbnQ7XG4gICAgICAgICAgICBpZiAobiA9PT0gXCJjbGlja0F3YXlcIiAmJiB0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICB2YXIgciA9IHQudGFyZ2V0O1xuICAgICAgICAgICAgICAgIHdoaWxlIChyKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIElnbm9yZSBjbGlja3Mgb24gdG9nZ2xlLlxuICAgICAgICAgICAgICAgICAgICBpZiAociA9PT0gbGUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICByID0gci5wYXJlbnROb2RlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh3ZSAmJiBxKCkoZiwgbikgJiYgdyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgaWYgKHEoKSh5LCBuKSkge1xuICAgICAgICAgICAgICAgICAgICBsZSA9PT0gbnVsbCB8fCBsZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogbGUuZm9jdXMoKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgaWYgKCFHKSB7XG4gICAgICAgICAgICAgICAgICAgIGZlKGZhbHNlKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgTyA9PT0gbnVsbCB8fCBPID09PSB2b2lkIDAgPyB2b2lkIDAgOiBPKHQsIHtcbiAgICAgICAgICAgICAgICAgICAgaW5kZXg6IHcsXG4gICAgICAgICAgICAgICAgICAgIHJlYXNvbjogbixcbiAgICAgICAgICAgICAgICAgICAgY29sdW1uSWQ6IHZcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgZiwgdiwgeSwgdywgbGUsIEcsIHdlLCBPIF0pO1xuICAgICAgICAoMCwgdC51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIGlmIChDZSAmJiAhVSkge1xuICAgICAgICAgICAgICAgIFNlKHtcbiAgICAgICAgICAgICAgICAgICAgcmVhc29uOiBcIm9mZlNjcmVlblwiXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIFNlLCBDZSwgVSBdKTtcbiAgICAgICAgdmFyIE9lID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBOKG0sIGUpO1xuICAgICAgICAgICAgaWYgKHBlKSB7XG4gICAgICAgICAgICAgICAgeWUoZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIHBlLCBtLCB5ZSBdKTtcbiAgICAgICAgdmFyIGtlID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB1ZShlKTtcbiAgICAgICAgICAgIG9lKGUpO1xuICAgICAgICAgICAgTihsLCBlKTtcbiAgICAgICAgfSksIFsgbCBdKTtcbiAgICAgICAgdmFyIEVlID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBlLnN0b3BQcm9wYWdhdGlvbigpO1xuICAgICAgICAgICAgLy8gaWdub3JlIGNsaWNrcyBvbiB0aGUgcmVzaXplIGhhbmRsZVxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGUudGFyZ2V0LmdldEF0dHJpYnV0ZShcImRhdGEtdGVzdFwiKSA9PT0gXCJyZXNpemVcIikge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICghd2UpIHtcbiAgICAgICAgICAgICAgICBlZShlLmNsaWVudFggfHwgdW5kZWZpbmVkKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh3ZSkge1xuICAgICAgICAgICAgICAgIFNlID09PSBudWxsIHx8IFNlID09PSB2b2lkIDAgPyB2b2lkIDAgOiBTZSh7XG4gICAgICAgICAgICAgICAgICAgIHJlYXNvbjogXCJ0b2dnbGVDbGlja1wiLFxuICAgICAgICAgICAgICAgICAgICBldmVudDogZVxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfSBlbHNlIGlmICh3ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICBFID09PSBudWxsIHx8IEUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IEUoZSwge1xuICAgICAgICAgICAgICAgICAgICByZWFzb246IFwidG9nZ2xlQ2xpY2tcIixcbiAgICAgICAgICAgICAgICAgICAgY29sdW1uSWQ6IHYsXG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiB3XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgaWYgKCFHKSB7XG4gICAgICAgICAgICAgICAgICAgIGZlKHRydWUpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgdiwgU2UsIHcsIEcsIHdlLCBFIF0pO1xuICAgICAgICB2YXIgVGUgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmICh3ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICBTID09PSBudWxsIHx8IFMgPT09IHZvaWQgMCA/IHZvaWQgMCA6IFMoZSwge1xuICAgICAgICAgICAgICAgICAgICBpbmRleDogdyxcbiAgICAgICAgICAgICAgICAgICAgY29sdW1uSWQ6IHZcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgdiwgdywgUyBdKTtcbiAgICAgICAgdmFyIGplID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBTZSh7XG4gICAgICAgICAgICAgICAgcmVhc29uOiBcImNvbnRlbnRDbGlja1wiLFxuICAgICAgICAgICAgICAgIGV2ZW50OiBlXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSksIFsgU2UgXSk7XG4gICAgICAgIHZhciBEZSA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIGlmIChaICE9PSB1bmRlZmluZWQgJiYgdHIoKShaKSkge1xuICAgICAgICAgICAgICAgIHZhciBlO1xuICAgICAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgICAgIHg6IFogLSAoKGUgPSByZSA9PT0gbnVsbCB8fCByZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogcmUuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCkubGVmdCkgIT09IG51bGwgJiYgZSAhPT0gdm9pZCAwID8gZSA6IDApXG4gICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgIH0pLCBbIFosIHJlIF0pO1xuICAgICAgICB2YXIgcWUgPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4gUmUoKSh7fSwgTCwge1xuICAgICAgICAgICAgICAgIHdpZHRoOiBYXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSksIFsgTCwgWCBdKTtcbiAgICAgICAgdmFyIEFlO1xuICAgICAgICBpZiAoYikge1xuICAgICAgICAgICAgQWUgPSBiO1xuICAgICAgICB9IGVsc2UgaWYgKHR5cGVvZiBDID09PSBcInN0cmluZ1wiKSB7XG4gICAgICAgICAgICBBZSA9IEM7XG4gICAgICAgIH1cbiAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChLZSwgc3Ioe1xuICAgICAgICAgICAgc3R5bGU6IHFlLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJoZWFkLWNlbGxcIixcbiAgICAgICAgICAgICRpc0RyYWdnaW5nOiBwZSAmJiBnZSxcbiAgICAgICAgICAgICR2YXJpYW50OiBWLFxuICAgICAgICAgICAgaWQ6IFUgPyB4ZSA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHJlZjogT2VcbiAgICAgICAgfSwgWSksICByKCkuY3JlYXRlRWxlbWVudChIZSwgbnVsbCwgcGUgJiYgIHIoKS5jcmVhdGVFbGVtZW50KFZlLCBzcih7XG4gICAgICAgICAgICBcImFyaWEtbGFiZWxcIjogKDAsIEkuc3ByaW50ZikoKDAsIFQuXykoXCJSZW9yZGVyICUobGFiZWxTdHJpbmcpc1wiKSwge1xuICAgICAgICAgICAgICAgIGxhYmVsU3RyaW5nOiBBZVxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImRyYWdcIlxuICAgICAgICB9LCBiZSwgaGUpLCAgcigpLmNyZWF0ZUVsZW1lbnQoQmUsIG51bGwsICByKCkuY3JlYXRlRWxlbWVudChJZSgpLCBudWxsKSkpLCAgcigpLmNyZWF0ZUVsZW1lbnQoVG4sIHtcbiAgICAgICAgICAgIGFsaWduOiBpLFxuICAgICAgICAgICAgXCJhcmlhLWV4cGFuZGVkXCI6IHdlLFxuICAgICAgICAgICAgXCJhcmlhLWhhc3BvcHVwXCI6IHRydWUsXG4gICAgICAgICAgICBcImFyaWEtb3duc1wiOiB2ZSxcbiAgICAgICAgICAgIGNsaWNrYWJsZTogdHJ1ZSxcbiAgICAgICAgICAgIGNvbHVtbklkOiB2LFxuICAgICAgICAgICAgZWxlbWVudFJlZjoga2UsXG4gICAgICAgICAgICBjZWxsSWQ6IHhlLFxuICAgICAgICAgICAgaW5kZXg6IHcsXG4gICAgICAgICAgICBpc01lbnU6IHRydWUsXG4gICAgICAgICAgICBsYWJlbDogQyxcbiAgICAgICAgICAgIHJlc2l6YWJsZTogVSAmJiBNLFxuICAgICAgICAgICAgb25BdXRvc2l6ZUNvbHVtbjogeCxcbiAgICAgICAgICAgIG9uUmVxdWVzdFJlc2l6ZTogRCxcbiAgICAgICAgICAgIG9uQ2xpY2s6IEVlLFxuICAgICAgICAgICAgb25LZXlEb3duOiBUZSxcbiAgICAgICAgICAgIHRydW5jYXRlOiBCLFxuICAgICAgICAgICAgd2lkdGg6IFgsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImlubmVyXCJcbiAgICAgICAgfSksICByKCkuY3JlYXRlRWxlbWVudChhcigpLCB7XG4gICAgICAgICAgICBhbGlnbjogXCJjZW50ZXJcIixcbiAgICAgICAgICAgIGFuY2hvcjogcmUsXG4gICAgICAgICAgICBcImFyaWEtbGFiZWxsZWRieVwiOiB4ZSxcbiAgICAgICAgICAgIGF1dG9DbG9zZVdoZW5PZmZTY3JlZW46IHEoKShmLCBcIm9mZlNjcmVlblwiKSxcbiAgICAgICAgICAgIGNhbkNvdmVyQW5jaG9yOiBzLFxuICAgICAgICAgICAgZGVmYXVsdFBsYWNlbWVudDogXCJiZWxvd1wiLFxuICAgICAgICAgICAgaWQ6IHZlLFxuICAgICAgICAgICAgb25SZXF1ZXN0Q2xvc2U6IFNlLFxuICAgICAgICAgICAgb3BlbjogISFyZSAmJiB3ZSxcbiAgICAgICAgICAgIHBvaW50VG86IERlLFxuICAgICAgICAgICAgcmVwb3NpdGlvbk1vZGU6IF8sXG4gICAgICAgICAgICByZXRhaW5Gb2N1czogJCxcbiAgICAgICAgICAgIHRha2VGb2N1czogSFxuICAgICAgICB9LCBvcigpKGMpID8gZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBcbiAgICAgICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc3gtYTExeS9jbGljay1ldmVudHMtaGF2ZS1rZXktZXZlbnRzLCBqc3gtYTExeS9uby1zdGF0aWMtZWxlbWVudC1pbnRlcmFjdGlvbnNcbiAgICAgICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChcImRpdlwiLCB7XG4gICAgICAgICAgICAgICAgb25DbGljazogamVcbiAgICAgICAgICAgIH0sIGMuYXBwbHkodm9pZCAwLCBhcmd1bWVudHMpKTtcbiAgICAgICAgfSA6IFxuICAgICAgICBcbiAgICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzeC1hMTF5L2NsaWNrLWV2ZW50cy1oYXZlLWtleS1ldmVudHMsIGpzeC1hMTF5L25vLXN0YXRpYy1lbGVtZW50LWludGVyYWN0aW9uc1xuICAgICAgICByKCkuY3JlYXRlRWxlbWVudChcImRpdlwiLCB7XG4gICAgICAgICAgICBvbkNsaWNrOiBqZVxuICAgICAgICB9LCBjKSkpKTtcbiAgICB9XG4gICAgQ3IucHJvcFR5cGVzID0gZ3I7XG4gICAgQ3Iuc3BsdW5rVWlUeXBlID0gXCJUYWJsZS5IZWFkRHJvcGRvd25DZWxsXCI7XG4gICAgQ3IucG9zc2libGVDbG9zZVJlYXNvbnMgPSB5cjtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IHhyID0gQ3I7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvZXh0ZW5kXCJcbiAgICBjb25zdCBTciA9IHJlcXVpcmUoXCJsb2Rhc2gvZXh0ZW5kXCIpO1xuICAgIHZhciBPciA9ICBlLm4oU3IpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0hlYWRUYWJsZVN0eWxlcy50c1xuICAgIHZhciBrciA9IHooKShlZSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRUYWJsZVN0eWxlc19fU3R5bGVkXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImc4NXdnZi0wXCJcbiAgICB9KShbIFwibWluLXdpZHRoOjA7dGFibGUtbGF5b3V0OmZpeGVkO1wiIF0pO1xuICAgIHZhciBSciA9IHooKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRUYWJsZVN0eWxlc19fU3R5bGVkRG9ja2VkQ29udGFpbmVyXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImc4NXdnZi0xXCJcbiAgICB9KShbIFwib3ZlcmZsb3c6aGlkZGVuO3Bvc2l0aW9uOmZpeGVkO3otaW5kZXg6XCIsIFwiO0BtZWRpYSBwcmludHtkaXNwbGF5Om5vbmU7fVwiIF0sIE0udmFyaWFibGVzLnppbmRleEZpeGVkTmF2YmFyKTtcbiAgICB2YXIgRXIgPSB6KCkoUnIpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJIZWFkVGFibGVTdHlsZXNfX1N0eWxlZEZpeGVkQ29udGFpbmVyXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcImc4NXdnZi0yXCJcbiAgICB9KShbIFwicG9zaXRpb246YWJzb2x1dGU7Ym94LXNoYWRvdzpub25lO3otaW5kZXg6MTtcIiBdKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9UYWJsZS9IZWFkVGFibGUudHN4XG4gICAgZnVuY3Rpb24gSXIoKSB7XG4gICAgICAgIHJldHVybiBJciA9IE9iamVjdC5hc3NpZ24gPyBPYmplY3QuYXNzaWduLmJpbmQoKSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGZvciAodmFyIG4gPSAxOyBuIDwgYXJndW1lbnRzLmxlbmd0aDsgbisrKSB7XG4gICAgICAgICAgICAgICAgdmFyIHQgPSBhcmd1bWVudHNbbl07XG4gICAgICAgICAgICAgICAgZm9yICh2YXIgciBpbiB0KSB7XG4gICAgICAgICAgICAgICAgICAgICh7fSkuaGFzT3duUHJvcGVydHkuY2FsbCh0LCByKSAmJiAoZVtyXSA9IHRbcl0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9LCBJci5hcHBseShudWxsLCBhcmd1bWVudHMpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBUcihlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSBqcihlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiBqcihlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgdmFyIERyID0ge1xuICAgICAgICBjZWxsV2lkdGhzOiB3KCkuYXJyYXlPZih3KCkubnVtYmVyKS5pc1JlcXVpcmVkLFxuICAgICAgICBkcmFnSW5kZXg6IHcoKS5udW1iZXIsXG4gICAgICAgIGVsZW1lbnRSZWY6IHcoKS5vbmVPZlR5cGUoWyB3KCkuZnVuYywgdygpLm9iamVjdCBdKSxcbiAgICAgICAgaGFzRHJhZ0NvbHVtbjogdygpLmJvb2wsXG4gICAgICAgIGhhc1Jvd0V4cGFuc2lvbjogdygpLmJvb2wsXG4gICAgICAgIGhhc1Jvd1NlbGVjdGlvbjogdygpLmJvb2wsXG4gICAgICAgIGhlYWRUeXBlOiB3KCkub25lT2YoWyBcImRvY2tlZFwiLCBcImZpeGVkXCIgXSkuaXNSZXF1aXJlZCxcbiAgICAgICAgaG9yaXpvbnRhbE9mZnNldDogdygpLm51bWJlcixcbiAgICAgICAgaXNGaXhlZENvbHVtbjogdygpLmJvb2wsXG4gICAgICAgIHJvd1NlbGVjdGlvbjogdygpLm9uZU9mKFsgXCJhbGxcIiwgXCJzb21lXCIsIFwibm9uZVwiIF0pLFxuICAgICAgICB0YWJsZVN0eWxlOiB3KCkub2JqZWN0LFxuICAgICAgICB0YWJsZVdpZHRoOiB3KCkubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgICAgIHRIZWFkOiB3KCkuZWxlbWVudC5pc1JlcXVpcmVkLFxuICAgICAgICB0b3A6IHcoKS5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICAgICAgd2lkdGg6IHcoKS5udW1iZXIuaXNSZXF1aXJlZFxuICAgIH07XG4gICAgLyoqXG4gKiBAcHJpdmF0ZVxuICogSGVhZFRhYmxlIGlzIGFuIGludGVybmFsIGNvbXBvbmVudCB0aGF0IHByb3ZpZGVzIGEgZGV0YWNoZWQgdGFibGUgaGVhZCB0aGF0IGNhblxuICogdGhlbiBiZSBwb3NpdGlvbmVkIGluIGRpZmZlcmVudCB3YXlzIG91dHNpZGUgb2YgdGhlIG1haW4gdGFibGUuXG4gKi8gICAgZnVuY3Rpb24gcXIoZSkge1xuICAgICAgICB2YXIgbiA9IGUuY2VsbFdpZHRocywgbyA9IGUuZWxlbWVudFJlZiwgaSA9IGUuaGFzRHJhZ0NvbHVtbiwgYSA9IGUuaGFzUm93RXhwYW5zaW9uLCBsID0gZS5oYXNSb3dTZWxlY3Rpb24sIHUgPSBlLmhlYWRUeXBlLCBzID0gZS5ob3Jpem9udGFsT2Zmc2V0LCBjID0gcyA9PT0gdm9pZCAwID8gMCA6IHMsIGQgPSBlLmlzRml4ZWRDb2x1bW4sIGYgPSBlLnRhYmxlU3R5bGUsIHYgPSBlLnRhYmxlV2lkdGgsIHAgPSBlLnRIZWFkLCBtID0gZS50b3AsIGggPSBlLndpZHRoLCB5ID0gVHIoZSwgWyBcImNlbGxXaWR0aHNcIiwgXCJlbGVtZW50UmVmXCIsIFwiaGFzRHJhZ0NvbHVtblwiLCBcImhhc1Jvd0V4cGFuc2lvblwiLCBcImhhc1Jvd1NlbGVjdGlvblwiLCBcImhlYWRUeXBlXCIsIFwiaG9yaXpvbnRhbE9mZnNldFwiLCBcImlzRml4ZWRDb2x1bW5cIiwgXCJ0YWJsZVN0eWxlXCIsIFwidGFibGVXaWR0aFwiLCBcInRIZWFkXCIsIFwidG9wXCIsIFwid2lkdGhcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBIZWFkVGFibGVQcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICB2YXIgZyA9IHUgPT09IFwiZG9ja2VkXCI7XG4gICAgICAgIHZhciB3ID0gZyA/IFJyIDogRXI7XG4gICAgICAgIHZhciBDID0gKDAsIHQudXNlUmVmKShudWxsKTtcbiAgICAgICAgdmFyIHggPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIE4oQywgZSk7XG4gICAgICAgIH0pLCBbIEMgXSk7XG4gICAgICAgIHZhciBTID0gMDtcbiAgICAgICAgaWYgKGEpIHtcbiAgICAgICAgICAgIFMgKz0gMTtcbiAgICAgICAgfVxuICAgICAgICBpZiAobCkge1xuICAgICAgICAgICAgUyArPSAxO1xuICAgICAgICB9XG4gICAgICAgIGlmIChpKSB7XG4gICAgICAgICAgICBTICs9IDE7XG4gICAgICAgIH1cbiAgICAgICAgLy8gU2V0IHRoZSB3aWR0aHMgb2YgdGhlIGhlYWQgY2VsbHMgaWYgbm90IGZpeGVkIGNvbHVtblxuICAgICAgICAgICAgICAgIHZhciBPID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIHQuQ2hpbGRyZW4udG9BcnJheShwLnByb3BzLmNoaWxkcmVuKTtcbiAgICAgICAgfSksIFsgcC5wcm9wcy5jaGlsZHJlbiBdKTtcbiAgICAgICAgdmFyIGsgPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoZCkge1xuICAgICAgICAgICAgICAgIC8vIGVuc3VyZSBjb25zaXN0ZW50IGtleXNcbiAgICAgICAgICAgICAgICByZXR1cm4gTztcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBPLmZpbHRlcih0LmlzVmFsaWRFbGVtZW50KS5tYXAoKGZ1bmN0aW9uKGUsIHIpIHtcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgICAgICAgICByZXR1cm4gKDAsIHQuY2xvbmVFbGVtZW50KShlLCB7XG4gICAgICAgICAgICAgICAgICAgIHN0eWxlOiBPcigpKHt9LCBlLnByb3BzLnN0eWxlLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogbltyICsgU11cbiAgICAgICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0pKTtcbiAgICAgICAgfSksIFsgbiwgUywgZCwgTyBdKTtcbiAgICAgICAgdmFyIFIgPSAgKDAsIHQuY2xvbmVFbGVtZW50KShwLCB7XG4gICAgICAgICAgICBlbGVtZW50UmVmOiB4LFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJcIi5jb25jYXQodSwgXCItaGVhZFwiKVxuICAgICAgICB9LCBrKTtcbiAgICAgICAgdmFyIEUgPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHRvcDogbSxcbiAgICAgICAgICAgICAgICB3aWR0aDogaFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgbSwgaCBdKTtcbiAgICAgICAgXG4gICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudCh3LCB7XG4gICAgICAgICAgICBzdHlsZTogRSxcbiAgICAgICAgICAgIHJlZjogb1xuICAgICAgICB9LCAgcigpLmNyZWF0ZUVsZW1lbnQoa3IsIElyKHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiXCIuY29uY2F0KHUsIFwiLWhlYWQtdGFibGVcIiksXG4gICAgICAgICAgICBcImRhdGEtZml4ZWQtY29sdW1uXCI6IGQgPyBcInRydWVcIiA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHN0eWxlOiBPcigpKHt9LCBmLCB7XG4gICAgICAgICAgICAgICAgbWFyZ2luTGVmdDogYyxcbiAgICAgICAgICAgICAgICB3aWR0aDogZCA/IHVuZGVmaW5lZCA6IHZcbiAgICAgICAgICAgIH0pXG4gICAgICAgIH0sIGIoKSh5LCBcImRyYWdJbmRleFwiKSksIFIpKTtcbiAgICB9XG4gICAgcXIucHJvcFR5cGVzID0gRHI7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBBciA9IHFyO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL0tleWJvYXJkU2Vuc29yLnRzXG4gICAgZnVuY3Rpb24gUHIoZSkge1xuICAgICAgICBcIkBiYWJlbC9oZWxwZXJzIC0gdHlwZW9mXCI7XG4gICAgICAgIHJldHVybiBQciA9IFwiZnVuY3Rpb25cIiA9PSB0eXBlb2YgU3ltYm9sICYmIFwic3ltYm9sXCIgPT0gdHlwZW9mIFN5bWJvbC5pdGVyYXRvciA/IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHJldHVybiB0eXBlb2YgZTtcbiAgICAgICAgfSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHJldHVybiBlICYmIFwiZnVuY3Rpb25cIiA9PSB0eXBlb2YgU3ltYm9sICYmIGUuY29uc3RydWN0b3IgPT09IFN5bWJvbCAmJiBlICE9PSBTeW1ib2wucHJvdG90eXBlID8gXCJzeW1ib2xcIiA6IHR5cGVvZiBlO1xuICAgICAgICB9LCBQcihlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gX3IoZSwgbikge1xuICAgICAgICByZXR1cm4gJHIoZSkgfHwgTXIoZSwgbikgfHwgV3IoZSwgbikgfHwgenIoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24genIoKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gZGVzdHJ1Y3R1cmUgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIE1yKGUsIG4pIHtcbiAgICAgICAgdmFyIHQgPSBudWxsID09IGUgPyBudWxsIDogXCJ1bmRlZmluZWRcIiAhPSB0eXBlb2YgU3ltYm9sICYmIGVbU3ltYm9sLml0ZXJhdG9yXSB8fCBlW1wiQEBpdGVyYXRvclwiXTtcbiAgICAgICAgaWYgKG51bGwgIT0gdCkge1xuICAgICAgICAgICAgdmFyIHIsIG8sIGksIGEsIGwgPSBbXSwgdSA9ICEwLCBzID0gITE7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIGlmIChpID0gKHQgPSB0LmNhbGwoZSkpLm5leHQsIDAgPT09IG4pIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKE9iamVjdCh0KSAhPT0gdCkgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICB1ID0gITE7XG4gICAgICAgICAgICAgICAgfSBlbHNlIGZvciAoOyEodSA9IChyID0gaS5jYWxsKHQpKS5kb25lKSAmJiAobC5wdXNoKHIudmFsdWUpLCBsLmxlbmd0aCAhPT0gbik7IHUgPSAhMCkge1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgICAgICAgICBzID0gITAsIG8gPSBlO1xuICAgICAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoIXUgJiYgbnVsbCAhPSB0W1wicmV0dXJuXCJdICYmIChhID0gdFtcInJldHVyblwiXSgpLCBPYmplY3QoYSkgIT09IGEpKSByZXR1cm47XG4gICAgICAgICAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHMpIHRocm93IG87XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGw7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gJHIoZSkge1xuICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShlKSkgcmV0dXJuIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIE5yKGUpIHtcbiAgICAgICAgcmV0dXJuIEtyKGUpIHx8IEhyKGUpIHx8IFdyKGUpIHx8IExyKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIExyKCkge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFwiSW52YWxpZCBhdHRlbXB0IHRvIHNwcmVhZCBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gV3IoZSwgbikge1xuICAgICAgICBpZiAoZSkge1xuICAgICAgICAgICAgaWYgKFwic3RyaW5nXCIgPT0gdHlwZW9mIGUpIHJldHVybiBCcihlLCBuKTtcbiAgICAgICAgICAgIHZhciB0ID0ge30udG9TdHJpbmcuY2FsbChlKS5zbGljZSg4LCAtMSk7XG4gICAgICAgICAgICByZXR1cm4gXCJPYmplY3RcIiA9PT0gdCAmJiBlLmNvbnN0cnVjdG9yICYmICh0ID0gZS5jb25zdHJ1Y3Rvci5uYW1lKSwgXCJNYXBcIiA9PT0gdCB8fCBcIlNldFwiID09PSB0ID8gQXJyYXkuZnJvbShlKSA6IFwiQXJndW1lbnRzXCIgPT09IHQgfHwgL14oPzpVaXxJKW50KD86OHwxNnwzMikoPzpDbGFtcGVkKT9BcnJheSQvLnRlc3QodCkgPyBCcihlLCBuKSA6IHZvaWQgMDtcbiAgICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBIcihlKSB7XG4gICAgICAgIGlmIChcInVuZGVmaW5lZFwiICE9IHR5cGVvZiBTeW1ib2wgJiYgbnVsbCAhPSBlW1N5bWJvbC5pdGVyYXRvcl0gfHwgbnVsbCAhPSBlW1wiQEBpdGVyYXRvclwiXSkgcmV0dXJuIEFycmF5LmZyb20oZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEtyKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBCcihlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gQnIoZSwgbikge1xuICAgICAgICAobnVsbCA9PSBuIHx8IG4gPiBlLmxlbmd0aCkgJiYgKG4gPSBlLmxlbmd0aCk7XG4gICAgICAgIGZvciAodmFyIHQgPSAwLCByID0gQXJyYXkobik7IHQgPCBuOyB0KyspIHtcbiAgICAgICAgICAgIHJbdF0gPSBlW3RdO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICBmdW5jdGlvbiBWcihlLCBuKSB7XG4gICAgICAgIGlmICghKGUgaW5zdGFuY2VvZiBuKSkgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkNhbm5vdCBjYWxsIGEgY2xhc3MgYXMgYSBmdW5jdGlvblwiKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gRnIoZSwgbikge1xuICAgICAgICBmb3IgKHZhciB0ID0gMDsgdCA8IG4ubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgIHZhciByID0gblt0XTtcbiAgICAgICAgICAgIHIuZW51bWVyYWJsZSA9IHIuZW51bWVyYWJsZSB8fCAhMSwgci5jb25maWd1cmFibGUgPSAhMCwgXCJ2YWx1ZVwiIGluIHIgJiYgKHIud3JpdGFibGUgPSAhMCksIFxuICAgICAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIFlyKHIua2V5KSwgcik7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gVXIoZSwgbiwgdCkge1xuICAgICAgICByZXR1cm4gbiAmJiBGcihlLnByb3RvdHlwZSwgbiksIHQgJiYgRnIoZSwgdCksIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCBcInByb3RvdHlwZVwiLCB7XG4gICAgICAgICAgICB3cml0YWJsZTogITFcbiAgICAgICAgfSksIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFhyKGUsIG4sIHQpIHtcbiAgICAgICAgcmV0dXJuIChuID0gWXIobikpIGluIGUgPyBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgbiwge1xuICAgICAgICAgICAgdmFsdWU6IHQsXG4gICAgICAgICAgICBlbnVtZXJhYmxlOiAhMCxcbiAgICAgICAgICAgIGNvbmZpZ3VyYWJsZTogITAsXG4gICAgICAgICAgICB3cml0YWJsZTogITBcbiAgICAgICAgfSkgOiBlW25dID0gdCwgZTtcbiAgICB9XG4gICAgZnVuY3Rpb24gWXIoZSkge1xuICAgICAgICB2YXIgbiA9IEdyKGUsIFwic3RyaW5nXCIpO1xuICAgICAgICByZXR1cm4gXCJzeW1ib2xcIiA9PSBQcihuKSA/IG4gOiBuICsgXCJcIjtcbiAgICB9XG4gICAgZnVuY3Rpb24gR3IoZSwgbikge1xuICAgICAgICBpZiAoXCJvYmplY3RcIiAhPSBQcihlKSB8fCAhZSkgcmV0dXJuIGU7XG4gICAgICAgIHZhciB0ID0gZVtTeW1ib2wudG9QcmltaXRpdmVdO1xuICAgICAgICBpZiAodm9pZCAwICE9PSB0KSB7XG4gICAgICAgICAgICB2YXIgciA9IHQuY2FsbChlLCBuIHx8IFwiZGVmYXVsdFwiKTtcbiAgICAgICAgICAgIGlmIChcIm9iamVjdFwiICE9IFByKHIpKSByZXR1cm4gcjtcbiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJAQHRvUHJpbWl0aXZlIG11c3QgcmV0dXJuIGEgcHJpbWl0aXZlIHZhbHVlLlwiKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gKFwic3RyaW5nXCIgPT09IG4gPyBTdHJpbmcgOiBOdW1iZXIpKGUpO1xuICAgIH1cbiAgICAvLyBiYXNlZCBvbiBodHRwczovL2dpdGh1Yi5jb20vY2xhdWRlcmljL2RuZC1raXQvYmxvYi82OTRkY2MyZjYyZTUyNjk1NDFmYzk0MWZhNmM5YWY0NmNjZDY4MmFkL3BhY2thZ2VzL2NvcmUvc3JjL3NlbnNvcnMva2V5Ym9hcmQvS2V5Ym9hcmRTZW5zb3IudHNcbiAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbWF4LWNsYXNzZXMtcGVyLWZpbGVcbiAgICAvLyBodHRwczovL2dpdGh1Yi5jb20vY2xhdWRlcmljL2RuZC1raXQvYmxvYi82OTRkY2MyZjYyZTUyNjk1NDFmYzk0MWZhNmM5YWY0NmNjZDY4MmFkL3BhY2thZ2VzL2NvcmUvc3JjL3NlbnNvcnMvdXRpbGl0aWVzL0xpc3RlbmVycy50c1xuICAgICAgICB2YXIgSnIgPSAgZnVuY3Rpb24oKSB7XG4gICAgICAgIGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgdmFyIHQgPSB0aGlzO1xuICAgICAgICAgICAgVnIodGhpcywgZSk7XG4gICAgICAgICAgICBYcih0aGlzLCBcImxpc3RlbmVyc1wiLCBbXSk7XG4gICAgICAgICAgICBYcih0aGlzLCBcInJlbW92ZUFsbFwiLCAoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICAgICAgdC5saXN0ZW5lcnMuZm9yRWFjaCgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgICAgICAgICB2YXIgbjtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIChuID0gdC50YXJnZXQpID09PSBudWxsIHx8IG4gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG4ucmVtb3ZlRXZlbnRMaXN0ZW5lci5hcHBseShuLCBOcihlKSk7XG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgdGhpcy50YXJnZXQgPSBuO1xuICAgICAgICAgICAgdGhpcy50YXJnZXQgPSBuO1xuICAgICAgICB9XG4gICAgICAgIFVyKGUsIFsge1xuICAgICAgICAgICAga2V5OiBcImFkZFwiLFxuICAgICAgICAgICAgdmFsdWU6IGZ1bmN0aW9uIGUobiwgdCwgcikge1xuICAgICAgICAgICAgICAgIHZhciBvO1xuICAgICAgICAgICAgICAgIChvID0gdGhpcy50YXJnZXQpID09PSBudWxsIHx8IG8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG8uYWRkRXZlbnRMaXN0ZW5lcihuLCB0LCByKTtcbiAgICAgICAgICAgICAgICB0aGlzLmxpc3RlbmVycy5wdXNoKFsgbiwgdCwgciBdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBdKTtcbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfSgpO1xuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3RyYW5zZm9ybS9wYXJzZVRyYW5zZm9ybS50c1xuICAgICAgICBmdW5jdGlvbiBRcihlKSB7XG4gICAgICAgIGlmIChlLnN0YXJ0c1dpdGgoXCJtYXRyaXgzZChcIikpIHtcbiAgICAgICAgICAgIHZhciBuID0gZS5zbGljZSg5LCAtMSkuc3BsaXQoLywgLyk7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHg6ICtuWzEyXSxcbiAgICAgICAgICAgICAgICB5OiArblsxM10sXG4gICAgICAgICAgICAgICAgc2NhbGVYOiArblswXSxcbiAgICAgICAgICAgICAgICBzY2FsZVk6ICtuWzVdXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgICAgIGlmIChlLnN0YXJ0c1dpdGgoXCJtYXRyaXgoXCIpKSB7XG4gICAgICAgICAgICB2YXIgdCA9IGUuc2xpY2UoNywgLTEpLnNwbGl0KC8sIC8pO1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICB4OiArdFs0XSxcbiAgICAgICAgICAgICAgICB5OiArdFs1XSxcbiAgICAgICAgICAgICAgICBzY2FsZVg6ICt0WzBdLFxuICAgICAgICAgICAgICAgIHNjYWxlWTogK3RbM11cbiAgICAgICAgICAgIH07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3RyYW5zZm9ybS9pbnZlcnNlVHJhbnNmb3JtLnRzXG4gICAgICAgIGZ1bmN0aW9uIFpyKGUsIG4sIHQpIHtcbiAgICAgICAgdmFyIHIgPSBRcihuKTtcbiAgICAgICAgaWYgKCFyKSB7XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgbyA9IHIuc2NhbGVYLCBpID0gci5zY2FsZVksIGEgPSByLngsIGwgPSByLnk7XG4gICAgICAgIHZhciB1ID0gZS5sZWZ0IC0gYSAtICgxIC0gbykgKiBwYXJzZUZsb2F0KHQpO1xuICAgICAgICB2YXIgcyA9IGUudG9wIC0gbCAtICgxIC0gaSkgKiBwYXJzZUZsb2F0KHQuc2xpY2UodC5pbmRleE9mKFwiIFwiKSArIDEpKTtcbiAgICAgICAgdmFyIGMgPSBvID8gZS53aWR0aCAvIG8gOiBlLndpZHRoO1xuICAgICAgICB2YXIgZCA9IGkgPyBlLmhlaWdodCAvIGkgOiBlLmhlaWdodDtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHdpZHRoOiBjLFxuICAgICAgICAgICAgaGVpZ2h0OiBkLFxuICAgICAgICAgICAgdG9wOiBzLFxuICAgICAgICAgICAgcmlnaHQ6IHUgKyBjLFxuICAgICAgICAgICAgYm90dG9tOiBzICsgZCxcbiAgICAgICAgICAgIGxlZnQ6IHVcbiAgICAgICAgfTtcbiAgICB9XG4gICAgdmFyIGVvID0ge1xuICAgICAgICBpZ25vcmVUcmFuc2Zvcm06IGZhbHNlXG4gICAgfTtcbiAgICAvLyBodHRwczovL2dpdGh1Yi5jb20vY2xhdWRlcmljL2RuZC1raXQvYmxvYi82OTRkY2MyZjYyZTUyNjk1NDFmYzk0MWZhNmM5YWY0NmNjZDY4MmFkL3BhY2thZ2VzL2NvcmUvc3JjL3V0aWxpdGllcy9yZWN0L2dldFJlY3QudHNcbiAgICAgICAgZnVuY3Rpb24gbm8oZSkge1xuICAgICAgICB2YXIgbiA9IGFyZ3VtZW50cy5sZW5ndGggPiAxICYmIGFyZ3VtZW50c1sxXSAhPT0gdW5kZWZpbmVkID8gYXJndW1lbnRzWzFdIDogZW87XG4gICAgICAgIHZhciB0ID0gZS5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTtcbiAgICAgICAgaWYgKG4uaWdub3JlVHJhbnNmb3JtKSB7XG4gICAgICAgICAgICB2YXIgciA9ICgwLCBXbi5nZXRXaW5kb3cpKGUpLmdldENvbXB1dGVkU3R5bGUoZSksIG8gPSByLnRyYW5zZm9ybSwgaSA9IHIudHJhbnNmb3JtT3JpZ2luO1xuICAgICAgICAgICAgaWYgKG8pIHtcbiAgICAgICAgICAgICAgICB0ID0gWnIodCwgbywgaSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgdmFyIGEgPSB0LCBsID0gYS50b3AsIHUgPSBhLmxlZnQsIHMgPSBhLndpZHRoLCBjID0gYS5oZWlnaHQsIGQgPSBhLmJvdHRvbSwgZiA9IGEucmlnaHQ7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB0b3A6IGwsXG4gICAgICAgICAgICBsZWZ0OiB1LFxuICAgICAgICAgICAgd2lkdGg6IHMsXG4gICAgICAgICAgICBoZWlnaHQ6IGMsXG4gICAgICAgICAgICBib3R0b206IGQsXG4gICAgICAgICAgICByaWdodDogZlxuICAgICAgICB9O1xuICAgIH1cbiAgICBmdW5jdGlvbiB0byhlKSB7XG4gICAgICAgIGlmIChlID09PSBkb2N1bWVudC5zY3JvbGxpbmdFbGVtZW50KSB7XG4gICAgICAgICAgICB2YXIgbiA9IHdpbmRvdywgdCA9IG4uaW5uZXJXaWR0aCwgciA9IG4uaW5uZXJIZWlnaHQ7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHRvcDogMCxcbiAgICAgICAgICAgICAgICBsZWZ0OiAwLFxuICAgICAgICAgICAgICAgIHJpZ2h0OiB0LFxuICAgICAgICAgICAgICAgIGJvdHRvbTogcixcbiAgICAgICAgICAgICAgICB3aWR0aDogdCxcbiAgICAgICAgICAgICAgICBoZWlnaHQ6IHJcbiAgICAgICAgICAgIH07XG4gICAgICAgIH1cbiAgICAgICAgdmFyIG8gPSBlLmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpLCBpID0gby50b3AsIGEgPSBvLmxlZnQsIGwgPSBvLnJpZ2h0LCB1ID0gby5ib3R0b207XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB0b3A6IGksXG4gICAgICAgICAgICBsZWZ0OiBhLFxuICAgICAgICAgICAgcmlnaHQ6IGwsXG4gICAgICAgICAgICBib3R0b206IHUsXG4gICAgICAgICAgICB3aWR0aDogZS5jbGllbnRXaWR0aCxcbiAgICAgICAgICAgIGhlaWdodDogZS5jbGllbnRIZWlnaHRcbiAgICAgICAgfTtcbiAgICB9XG4gICAgLy8gaHR0cHM6Ly9naXRodWIuY29tL2NsYXVkZXJpYy9kbmQta2l0L2Jsb2IvNjk0ZGNjMmY2MmU1MjY5NTQxZmM5NDFmYTZjOWFmNDZjY2Q2ODJhZC9wYWNrYWdlcy9jb3JlL3NyYy91dGlsaXRpZXMvc2Nyb2xsL2RvY3VtZW50U2Nyb2xsaW5nRWxlbWVudC50c1xuICAgICAgICBmdW5jdGlvbiBybyhlKSB7XG4gICAgICAgIGlmICghV24uY2FuVXNlRE9NIHx8ICFlKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGUgPT09IGRvY3VtZW50LnNjcm9sbGluZ0VsZW1lbnQ7XG4gICAgfVxuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3Njcm9sbC9nZXRTY3JvbGxQb3NpdGlvbi50c1xuICAgICAgICBmdW5jdGlvbiBvbyhlKSB7XG4gICAgICAgIHZhciBuID0ge1xuICAgICAgICAgICAgeDogMCxcbiAgICAgICAgICAgIHk6IDBcbiAgICAgICAgfTtcbiAgICAgICAgdmFyIHQgPSBybyhlKSA/IHtcbiAgICAgICAgICAgIGhlaWdodDogd2luZG93LmlubmVySGVpZ2h0LFxuICAgICAgICAgICAgd2lkdGg6IHdpbmRvdy5pbm5lcldpZHRoXG4gICAgICAgIH0gOiB7XG4gICAgICAgICAgICBoZWlnaHQ6IGUuY2xpZW50SGVpZ2h0LFxuICAgICAgICAgICAgd2lkdGg6IGUuY2xpZW50V2lkdGhcbiAgICAgICAgfTtcbiAgICAgICAgdmFyIHIgPSB7XG4gICAgICAgICAgICB4OiBlLnNjcm9sbFdpZHRoIC0gdC53aWR0aCxcbiAgICAgICAgICAgIHk6IGUuc2Nyb2xsSGVpZ2h0IC0gdC5oZWlnaHRcbiAgICAgICAgfTtcbiAgICAgICAgdmFyIG8gPSBlLnNjcm9sbFRvcCA8PSBuLnk7XG4gICAgICAgIHZhciBpID0gZS5zY3JvbGxMZWZ0IDw9IG4ueDtcbiAgICAgICAgdmFyIGEgPSBlLnNjcm9sbFRvcCA+PSByLnk7XG4gICAgICAgIHZhciBsID0gZS5zY3JvbGxMZWZ0ID49IHIueDtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGlzVG9wOiBvLFxuICAgICAgICAgICAgaXNMZWZ0OiBpLFxuICAgICAgICAgICAgaXNCb3R0b206IGEsXG4gICAgICAgICAgICBpc1JpZ2h0OiBsLFxuICAgICAgICAgICAgbWF4U2Nyb2xsOiByLFxuICAgICAgICAgICAgbWluU2Nyb2xsOiBuXG4gICAgICAgIH07XG4gICAgfVxuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL2Nvb3JkaW5hdGVzL2NvbnN0YW50cy50c1xuICAgICAgICB2YXIgaW8gPSB7XG4gICAgICAgIHg6IDAsXG4gICAgICAgIHk6IDBcbiAgICB9O1xuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3Njcm9sbC9pc0ZpeGVkLnRzXG4gICAgICAgIGZ1bmN0aW9uIGFvKGUpIHtcbiAgICAgICAgdmFyIG4gPSBhcmd1bWVudHMubGVuZ3RoID4gMSAmJiBhcmd1bWVudHNbMV0gIT09IHVuZGVmaW5lZCA/IGFyZ3VtZW50c1sxXSA6ICgwLCBcbiAgICAgICAgV24uZ2V0V2luZG93KShlKS5nZXRDb21wdXRlZFN0eWxlKGUpO1xuICAgICAgICByZXR1cm4gbi5wb3NpdGlvbiA9PT0gXCJmaXhlZFwiO1xuICAgIH1cbiAgICAvLyBodHRwczovL2dpdGh1Yi5jb20vY2xhdWRlcmljL2RuZC1raXQvYmxvYi82OTRkY2MyZjYyZTUyNjk1NDFmYzk0MWZhNmM5YWY0NmNjZDY4MmFkL3BhY2thZ2VzL2NvcmUvc3JjL3V0aWxpdGllcy9zY3JvbGwvaXNTY3JvbGxhYmxlLnRzXG4gICAgICAgIGZ1bmN0aW9uIGxvKGUpIHtcbiAgICAgICAgdmFyIG4gPSBhcmd1bWVudHMubGVuZ3RoID4gMSAmJiBhcmd1bWVudHNbMV0gIT09IHVuZGVmaW5lZCA/IGFyZ3VtZW50c1sxXSA6ICgwLCBcbiAgICAgICAgV24uZ2V0V2luZG93KShlKS5nZXRDb21wdXRlZFN0eWxlKGUpO1xuICAgICAgICB2YXIgdCA9IC8oYXV0b3xzY3JvbGx8b3ZlcmxheSkvO1xuICAgICAgICB2YXIgciA9IFsgXCJvdmVyZmxvd1wiLCBcIm92ZXJmbG93WFwiLCBcIm92ZXJmbG93WVwiIF07XG4gICAgICAgIHJldHVybiByLnNvbWUoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciByID0gbltlXTtcbiAgICAgICAgICAgIHJldHVybiB0eXBlb2YgciA9PT0gXCJzdHJpbmdcIiA/IHQudGVzdChyKSA6IGZhbHNlO1xuICAgICAgICB9KSk7XG4gICAgfVxuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3Njcm9sbC9nZXRTY3JvbGxhYmxlQW5jZXN0b3JzLnRzXG4gICAgICAgIGZ1bmN0aW9uIHVvKGUsIG4pIHtcbiAgICAgICAgdmFyIHQgPSBbXTtcbiAgICAgICAgZnVuY3Rpb24gcihvKSB7XG4gICAgICAgICAgICBpZiAobiAhPSBudWxsICYmIHQubGVuZ3RoID49IG4pIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICghbykge1xuICAgICAgICAgICAgICAgIHJldHVybiB0O1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKCgwLCBXbi5pc0RvY3VtZW50KShvKSAmJiBvLnNjcm9sbGluZ0VsZW1lbnQgIT0gbnVsbCAmJiAhdC5pbmNsdWRlcyhvLnNjcm9sbGluZ0VsZW1lbnQpKSB7XG4gICAgICAgICAgICAgICAgdC5wdXNoKG8uc2Nyb2xsaW5nRWxlbWVudCk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHQ7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoISgwLCBXbi5pc0hUTUxFbGVtZW50KShvKSB8fCAoMCwgV24uaXNTVkdFbGVtZW50KShvKSkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0O1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHQuaW5jbHVkZXMobykpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhciBpID0gKDAsIFduLmdldFdpbmRvdykoZSkuZ2V0Q29tcHV0ZWRTdHlsZShvKTtcbiAgICAgICAgICAgIGlmIChvICE9PSBlKSB7XG4gICAgICAgICAgICAgICAgaWYgKGxvKG8sIGkpKSB7XG4gICAgICAgICAgICAgICAgICAgIHQucHVzaChvKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoYW8obywgaSkpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiByKG8ucGFyZW50Tm9kZSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCFlKSB7XG4gICAgICAgICAgICByZXR1cm4gdDtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gcihlKTtcbiAgICB9XG4gICAgLy8gaHR0cHM6Ly9naXRodWIuY29tL2NsYXVkZXJpYy9kbmQta2l0L2Jsb2IvNjk0ZGNjMmY2MmU1MjY5NTQxZmM5NDFmYTZjOWFmNDZjY2Q2ODJhZC9wYWNrYWdlcy9jb3JlL3NyYy91dGlsaXRpZXMvc2Nyb2xsL2dldFNjcm9sbGFibGVBbmNlc3RvcnMudHNcbiAgICAgICAgZnVuY3Rpb24gc28oZSkge1xuICAgICAgICB2YXIgbiA9IHVvKGUsIDEpLCB0ID0gX3IobiwgMSksIHIgPSB0WzBdO1xuICAgICAgICByZXR1cm4gciAhPT0gbnVsbCAmJiByICE9PSB2b2lkIDAgPyByIDogbnVsbDtcbiAgICB9XG4gICAgdmFyIGNvID0ge1xuICAgICAgICBzdGFydDogWyBvLktleWJvYXJkQ29kZS5TcGFjZSwgby5LZXlib2FyZENvZGUuRW50ZXIgXSxcbiAgICAgICAgY2FuY2VsOiBbIG8uS2V5Ym9hcmRDb2RlLkVzYyBdLFxuICAgICAgICBlbmQ6IFsgby5LZXlib2FyZENvZGUuU3BhY2UsIG8uS2V5Ym9hcmRDb2RlLkVudGVyIF1cbiAgICB9O1xuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9jbGF1ZGVyaWMvZG5kLWtpdC9ibG9iLzY5NGRjYzJmNjJlNTI2OTU0MWZjOTQxZmE2YzlhZjQ2Y2NkNjgyYWQvcGFja2FnZXMvY29yZS9zcmMvdXRpbGl0aWVzL3Njcm9sbC9zY3JvbGxJbnRvVmlld0lmTmVlZGVkLnRzXG4gICAgICAgIGZ1bmN0aW9uIGZvKGUpIHtcbiAgICAgICAgdmFyIG4gPSBhcmd1bWVudHMubGVuZ3RoID4gMSAmJiBhcmd1bWVudHNbMV0gIT09IHVuZGVmaW5lZCA/IGFyZ3VtZW50c1sxXSA6IG5vO1xuICAgICAgICBpZiAoIWUpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdCA9IG4oZSksIHIgPSB0LnRvcCwgbyA9IHQubGVmdCwgaSA9IHQuYm90dG9tLCBhID0gdC5yaWdodDtcbiAgICAgICAgdmFyIGwgPSBzbyhlKTtcbiAgICAgICAgaWYgKCFsKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGkgPD0gMCB8fCBhIDw9IDAgfHwgciA+PSB3aW5kb3cuaW5uZXJIZWlnaHQgfHwgbyA+PSB3aW5kb3cuaW5uZXJXaWR0aCkge1xuICAgICAgICAgICAgZS5zY3JvbGxJbnRvVmlldyh7XG4gICAgICAgICAgICAgICAgYmxvY2s6IFwiY2VudGVyXCIsXG4gICAgICAgICAgICAgICAgaW5saW5lOiBcImNlbnRlclwiXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgIH1cbiAgICB2YXIgdm8gPSAgZnVuY3Rpb24oKSB7XG4gICAgICAgIGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgVnIodGhpcywgZSk7XG4gICAgICAgICAgICBYcih0aGlzLCBcImF1dG9TY3JvbGxFbmFibGVkXCIsIGZhbHNlKTtcbiAgICAgICAgICAgIFhyKHRoaXMsIFwicmVmZXJlbmNlQ29vcmRpbmF0ZXNcIiwgdm9pZCAwKTtcbiAgICAgICAgICAgIFhyKHRoaXMsIFwibGlzdGVuZXJzXCIsIHZvaWQgMCk7XG4gICAgICAgICAgICBYcih0aGlzLCBcIndpbmRvd0xpc3RlbmVyc1wiLCB2b2lkIDApO1xuICAgICAgICAgICAgdGhpcy5wcm9wcyA9IG47XG4gICAgICAgICAgICB2YXIgdCA9IG4uZXZlbnQudGFyZ2V0O1xuICAgICAgICAgICAgdGhpcy5wcm9wcyA9IG47XG4gICAgICAgICAgICB0aGlzLmxpc3RlbmVycyA9IG5ldyBKcigoMCwgV24uZ2V0T3duZXJEb2N1bWVudCkodCkpO1xuICAgICAgICAgICAgdGhpcy53aW5kb3dMaXN0ZW5lcnMgPSBuZXcgSnIoKDAsIFduLmdldFdpbmRvdykodCkpO1xuICAgICAgICAgICAgdGhpcy5oYW5kbGVLZXlEb3duID0gdGhpcy5oYW5kbGVLZXlEb3duLmJpbmQodGhpcyk7XG4gICAgICAgICAgICB0aGlzLmhhbmRsZUNhbmNlbCA9IHRoaXMuaGFuZGxlQ2FuY2VsLmJpbmQodGhpcyk7XG4gICAgICAgICAgICB0aGlzLmF0dGFjaCgpO1xuICAgICAgICB9XG4gICAgICAgIFVyKGUsIFsge1xuICAgICAgICAgICAga2V5OiBcImF0dGFjaFwiLFxuICAgICAgICAgICAgdmFsdWU6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgdmFyIG4gPSB0aGlzO1xuICAgICAgICAgICAgICAgIHRoaXMuaGFuZGxlU3RhcnQoKTtcbiAgICAgICAgICAgICAgICB0aGlzLndpbmRvd0xpc3RlbmVycy5hZGQoXCJyZXNpemVcIiwgdGhpcy5oYW5kbGVDYW5jZWwpO1xuICAgICAgICAgICAgICAgIHRoaXMud2luZG93TGlzdGVuZXJzLmFkZChcInZpc2liaWxpdHljaGFuZ2VcIiwgdGhpcy5oYW5kbGVDYW5jZWwpO1xuICAgICAgICAgICAgICAgIHNldFRpbWVvdXQoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gbi5saXN0ZW5lcnMuYWRkKFwia2V5ZG93blwiLCBuLmhhbmRsZUtleURvd24pO1xuICAgICAgICAgICAgICAgIH0pKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSwge1xuICAgICAgICAgICAga2V5OiBcImhhbmRsZVN0YXJ0XCIsXG4gICAgICAgICAgICB2YWx1ZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICB2YXIgbiA9IHRoaXMucHJvcHMsIHQgPSBuLmFjdGl2ZU5vZGUsIHIgPSBuLm9uU3RhcnQ7XG4gICAgICAgICAgICAgICAgdmFyIG8gPSB0Lm5vZGUuY3VycmVudDtcbiAgICAgICAgICAgICAgICBpZiAobykge1xuICAgICAgICAgICAgICAgICAgICBmbyhvKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgcihpbyk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sIHtcbiAgICAgICAgICAgIGtleTogXCJoYW5kbGVLZXlEb3duXCIsXG4gICAgICAgICAgICB2YWx1ZTogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgaWYgKCgwLCBXbi5pc0tleWJvYXJkRXZlbnQpKG4pKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciB0ID0gdGhpcy5wcm9wcywgciA9IHQuYWN0aXZlLCBpID0gdC5jb250ZXh0LCBhID0gdC5vcHRpb25zO1xuICAgICAgICAgICAgICAgICAgICB2YXIgbCA9IGEua2V5Ym9hcmRDb2RlcywgdSA9IGwgPT09IHZvaWQgMCA/IGNvIDogbCwgcyA9IGEuY29vcmRpbmF0ZUdldHRlciwgYyA9IGEuc2Nyb2xsQmVoYXZpb3IsIGQgPSBjID09PSB2b2lkIDAgPyBcInNtb290aFwiIDogYztcbiAgICAgICAgICAgICAgICAgICAgdmFyIGYgPSBuLmNvZGU7XG4gICAgICAgICAgICAgICAgICAgIGlmICh1LmVuZC5pbmNsdWRlcyhmKSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5oYW5kbGVFbmQobik7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKHUuY2FuY2VsLmluY2x1ZGVzKGYpKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmhhbmRsZUNhbmNlbChuKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB2YXIgdiA9IGkuY3VycmVudC5jb2xsaXNpb25SZWN0O1xuICAgICAgICAgICAgICAgICAgICB2YXIgcCA9IHYgPyB7XG4gICAgICAgICAgICAgICAgICAgICAgICB4OiB2LmxlZnQsXG4gICAgICAgICAgICAgICAgICAgICAgICB5OiB2LnRvcFxuICAgICAgICAgICAgICAgICAgICB9IDogaW87XG4gICAgICAgICAgICAgICAgICAgIGlmICghdGhpcy5yZWZlcmVuY2VDb29yZGluYXRlcykge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5yZWZlcmVuY2VDb29yZGluYXRlcyA9IHA7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgdmFyIG0gPSBzKG4sIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGFjdGl2ZTogcixcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnRleHQ6IGkuY3VycmVudCxcbiAgICAgICAgICAgICAgICAgICAgICAgIGN1cnJlbnRDb29yZGluYXRlczogcFxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKG0pIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBiID0gKDAsIFduLnN1YnRyYWN0KShtLCBwKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBoID0ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHg6IDAsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgeTogMFxuICAgICAgICAgICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciB5ID0gaS5jdXJyZW50LnNjcm9sbGFibGVBbmNlc3RvcnM7XG4gICAgICAgICAgICAgICAgICAgICAgICBmb3IgKHZhciBnID0gMDsgZyA8IHkubGVuZ3RoOyBnICs9IDEpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgdyA9IHlbZ107XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyIEMgPSBuLmNvZGU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyIHggPSBvbyh3KSwgUyA9IHguaXNUb3AsIE8gPSB4LmlzUmlnaHQsIGsgPSB4LmlzTGVmdCwgUiA9IHguaXNCb3R0b20sIEUgPSB4Lm1heFNjcm9sbCwgSSA9IHgubWluU2Nyb2xsO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBUID0gdG8odyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gaXNEcmFnZ2FibGVOb2RlVmVydGljYWxseUluVmlldyBhbmQgaXNEcmFnZ2FibGVOb2RlSG9yaXpvbnRhbGx5SW5WaWV3IGFyZSBjdXN0b21cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyB3ZSB3YW50IHRvIHNjcm9sbCBvbmx5IHdoZW4gYSBkcmFnZ2luZyBub2RlIHdpbGwgYmUgb3V0IG9mIHZpZXcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gb3JpZ2luYWxseSBpdCB0cmllcyB0byBhbHdheXMgcGxhY2UgYSBkcmFnZ2luZyBub2RlIGluIHRoZSBtaWRkbGUgb2YgdGhlIGNvbnRhaW5lclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgaiA9IFQudG9wIDw9IG0ueSAmJiBULmJvdHRvbSA+PSBtLnkgKyAoKHYgPT09IG51bGwgfHwgdiA9PT0gdm9pZCAwID8gdm9pZCAwIDogdi5oZWlnaHQpIHx8IDApO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBEID0gVC5sZWZ0IDw9IG0ueCAmJiBULnJpZ2h0ID49IG0ueCArICgodiA9PT0gbnVsbCB8fCB2ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB2LndpZHRoKSB8fCAwKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgcSA9IChDID09PSBvLktleWJvYXJkQ29kZS5SaWdodCAmJiAhTyB8fCBDID09PSBvLktleWJvYXJkQ29kZS5MZWZ0ICYmICFrKSAmJiAhRDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgQSA9IChDID09PSBvLktleWJvYXJkQ29kZS5Eb3duICYmICFSIHx8IEMgPT09IG8uS2V5Ym9hcmRDb2RlLlVwICYmICFTKSAmJiAhajtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAocSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgUCA9IHcuc2Nyb2xsTGVmdCArIGIueDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyIF8gPSBDID09PSBvLktleWJvYXJkQ29kZS5SaWdodCAmJiBQIDw9IEUueCB8fCBDID09PSBvLktleWJvYXJkQ29kZS5MZWZ0ICYmIFAgPj0gSS54O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoXyAmJiAhYi55KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyBXZSBkb24ndCBuZWVkIHRvIHVwZGF0ZSBjb29yZGluYXRlcywgdGhlIHNjcm9sbCBhZGp1c3RtZW50IGFsb25lIHdpbGwgdHJpZ2dlclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gbG9naWMgdG8gYXV0by1kZXRlY3QgdGhlIG5ldyBjb250YWluZXIgd2UgYXJlIG92ZXJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHcuc2Nyb2xsVG8oe1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxlZnQ6IFAsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYmVoYXZpb3I6IGRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChfKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBoLnggPSB3LnNjcm9sbExlZnQgLSBQO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaC54ID0gQyA9PT0gby5LZXlib2FyZENvZGUuUmlnaHQgPyB3LnNjcm9sbExlZnQgLSBFLnggOiB3LnNjcm9sbExlZnQgLSBJLng7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGgueCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdy5zY3JvbGxCeSh7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbGVmdDogLWgueCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBiZWhhdmlvcjogZFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIGlmIChBKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciB6ID0gdy5zY3JvbGxUb3AgKyBiLnk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBNID0gQyA9PT0gby5LZXlib2FyZENvZGUuRG93biAmJiB6IDw9IEUueSB8fCBDID09PSBvLktleWJvYXJkQ29kZS5VcCAmJiB6ID49IEkueTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKE0gJiYgIWIueCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gV2UgZG9uJ3QgbmVlZCB0byB1cGRhdGUgY29vcmRpbmF0ZXMsIHRoZSBzY3JvbGwgYWRqdXN0bWVudCBhbG9uZSB3aWxsIHRyaWdnZXJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIGxvZ2ljIHRvIGF1dG8tZGV0ZWN0IHRoZSBuZXcgY29udGFpbmVyIHdlIGFyZSBvdmVyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB3LnNjcm9sbFRvKHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0b3A6IHosXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYmVoYXZpb3I6IGRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChNKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBoLnkgPSB3LnNjcm9sbFRvcCAtIHo7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBoLnkgPSBDID09PSBvLktleWJvYXJkQ29kZS5Eb3duID8gdy5zY3JvbGxUb3AgLSBFLnkgOiB3LnNjcm9sbFRvcCAtIEkueTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoaC55KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB3LnNjcm9sbEJ5KHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0b3A6IC1oLnksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYmVoYXZpb3I6IGRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuaGFuZGxlTW92ZShuLCAoMCwgV24uYWRkKSgoMCwgV24uc3VidHJhY3QpKG0sIHRoaXMucmVmZXJlbmNlQ29vcmRpbmF0ZXMpLCBoKSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sIHtcbiAgICAgICAgICAgIGtleTogXCJoYW5kbGVNb3ZlXCIsXG4gICAgICAgICAgICB2YWx1ZTogZnVuY3Rpb24gZShuLCB0KSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSB0aGlzLnByb3BzLm9uTW92ZTtcbiAgICAgICAgICAgICAgICBuLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICAgICAgcih0KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSwge1xuICAgICAgICAgICAga2V5OiBcImhhbmRsZUVuZFwiLFxuICAgICAgICAgICAgdmFsdWU6IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgICAgIHZhciB0ID0gdGhpcy5wcm9wcy5vbkVuZDtcbiAgICAgICAgICAgICAgICBuLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICAgICAgdGhpcy5kZXRhY2goKTtcbiAgICAgICAgICAgICAgICB0KCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sIHtcbiAgICAgICAgICAgIGtleTogXCJoYW5kbGVDYW5jZWxcIixcbiAgICAgICAgICAgIHZhbHVlOiBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IHRoaXMucHJvcHMub25DYW5jZWw7XG4gICAgICAgICAgICAgICAgbi5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgICAgIHRoaXMuZGV0YWNoKCk7XG4gICAgICAgICAgICAgICAgdCgpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9LCB7XG4gICAgICAgICAgICBrZXk6IFwiZGV0YWNoXCIsXG4gICAgICAgICAgICB2YWx1ZTogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICB0aGlzLmxpc3RlbmVycy5yZW1vdmVBbGwoKTtcbiAgICAgICAgICAgICAgICB0aGlzLndpbmRvd0xpc3RlbmVycy5yZW1vdmVBbGwoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBdKTtcbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfSgpO1xuICAgIFhyKHZvLCBcImFjdGl2YXRvcnNcIiwgWyB7XG4gICAgICAgIGV2ZW50TmFtZTogXCJvbktleURvd25cIixcbiAgICAgICAgaGFuZGxlcjogZnVuY3Rpb24gZShuLCB0LCByKSB7XG4gICAgICAgICAgICB2YXIgbyA9IHQua2V5Ym9hcmRDb2RlcywgaSA9IG8gPT09IHZvaWQgMCA/IGNvIDogbywgYSA9IHQub25BY3RpdmF0aW9uO1xuICAgICAgICAgICAgdmFyIGwgPSByLmFjdGl2ZTtcbiAgICAgICAgICAgIHZhciB1ID0gbi5uYXRpdmVFdmVudC5jb2RlO1xuICAgICAgICAgICAgaWYgKGkuc3RhcnQuaW5jbHVkZXModSkpIHtcbiAgICAgICAgICAgICAgICB2YXIgcyA9IGwuYWN0aXZhdG9yTm9kZS5jdXJyZW50O1xuICAgICAgICAgICAgICAgIGlmIChzICYmIG4udGFyZ2V0ICE9PSBzKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgbi5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgICAgIGEgPT09IG51bGwgfHwgYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogYSh7XG4gICAgICAgICAgICAgICAgICAgIGV2ZW50OiBuLm5hdGl2ZUV2ZW50XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICB9IF0pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL3V0aWxzL2dldEJvdW5kaW5nQ2xpZW50UmVjdC50c1xuICAgIGZ1bmN0aW9uIHBvKGUpIHtcbiAgICAgICAgXCJAYmFiZWwvaGVscGVycyAtIHR5cGVvZlwiO1xuICAgICAgICByZXR1cm4gcG8gPSBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBcInN5bWJvbFwiID09IHR5cGVvZiBTeW1ib2wuaXRlcmF0b3IgPyBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICByZXR1cm4gdHlwZW9mIGU7XG4gICAgICAgIH0gOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICByZXR1cm4gZSAmJiBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBlLmNvbnN0cnVjdG9yID09PSBTeW1ib2wgJiYgZSAhPT0gU3ltYm9sLnByb3RvdHlwZSA/IFwic3ltYm9sXCIgOiB0eXBlb2YgZTtcbiAgICAgICAgfSwgcG8oZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIG1vKGUsIG4pIHtcbiAgICAgICAgdmFyIHQgPSBPYmplY3Qua2V5cyhlKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciByID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIG4gJiYgKHIgPSByLmZpbHRlcigoZnVuY3Rpb24obikge1xuICAgICAgICAgICAgICAgIHJldHVybiBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKGUsIG4pLmVudW1lcmFibGU7XG4gICAgICAgICAgICB9KSkpLCB0LnB1c2guYXBwbHkodCwgcik7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHQ7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGJvKGUpIHtcbiAgICAgICAgZm9yICh2YXIgbiA9IDE7IG4gPCBhcmd1bWVudHMubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgIHZhciB0ID0gbnVsbCAhPSBhcmd1bWVudHNbbl0gPyBhcmd1bWVudHNbbl0gOiB7fTtcbiAgICAgICAgICAgIG4gJSAyID8gbW8oT2JqZWN0KHQpLCAhMCkuZm9yRWFjaCgoZnVuY3Rpb24obikge1xuICAgICAgICAgICAgICAgIGhvKGUsIG4sIHRbbl0pO1xuICAgICAgICAgICAgfSkpIDogT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMgPyBPYmplY3QuZGVmaW5lUHJvcGVydGllcyhlLCBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9ycyh0KSkgOiBtbyhPYmplY3QodCkpLmZvckVhY2goKGZ1bmN0aW9uKG4pIHtcbiAgICAgICAgICAgICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgbiwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcih0LCBuKSk7XG4gICAgICAgICAgICB9KSk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhvKGUsIG4sIHQpIHtcbiAgICAgICAgcmV0dXJuIChuID0geW8obikpIGluIGUgPyBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgbiwge1xuICAgICAgICAgICAgdmFsdWU6IHQsXG4gICAgICAgICAgICBlbnVtZXJhYmxlOiAhMCxcbiAgICAgICAgICAgIGNvbmZpZ3VyYWJsZTogITAsXG4gICAgICAgICAgICB3cml0YWJsZTogITBcbiAgICAgICAgfSkgOiBlW25dID0gdCwgZTtcbiAgICB9XG4gICAgZnVuY3Rpb24geW8oZSkge1xuICAgICAgICB2YXIgbiA9IGdvKGUsIFwic3RyaW5nXCIpO1xuICAgICAgICByZXR1cm4gXCJzeW1ib2xcIiA9PSBwbyhuKSA/IG4gOiBuICsgXCJcIjtcbiAgICB9XG4gICAgZnVuY3Rpb24gZ28oZSwgbikge1xuICAgICAgICBpZiAoXCJvYmplY3RcIiAhPSBwbyhlKSB8fCAhZSkgcmV0dXJuIGU7XG4gICAgICAgIHZhciB0ID0gZVtTeW1ib2wudG9QcmltaXRpdmVdO1xuICAgICAgICBpZiAodm9pZCAwICE9PSB0KSB7XG4gICAgICAgICAgICB2YXIgciA9IHQuY2FsbChlLCBuIHx8IFwiZGVmYXVsdFwiKTtcbiAgICAgICAgICAgIGlmIChcIm9iamVjdFwiICE9IHBvKHIpKSByZXR1cm4gcjtcbiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJAQHRvUHJpbWl0aXZlIG11c3QgcmV0dXJuIGEgcHJpbWl0aXZlIHZhbHVlLlwiKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gKFwic3RyaW5nXCIgPT09IG4gPyBTdHJpbmcgOiBOdW1iZXIpKGUpO1xuICAgIH1cbiAgICAvLyBDaGVja3MgaWYgYnJvd3NlciBpcyBTYWZhcmlcbiAgICAgICAgZnVuY3Rpb24gd28oKSB7XG4gICAgICAgIHJldHVybiAvXigoPyFjaHJvbWV8YW5kcm9pZCkuKSpzYWZhcmkvaS50ZXN0KG5hdmlnYXRvci51c2VyQWdlbnQpO1xuICAgIH1cbiAgICAvLyBGb3JtYXRzIHJldHVybiB2YWx1ZSB0byBET01SZWN0XG4gICAgICAgIGZ1bmN0aW9uIENvKGUpIHtcbiAgICAgICAgcmV0dXJuIGJvKGJvKHt9LCBlKSwge30sIHtcbiAgICAgICAgICAgIHRvcDogZS55LFxuICAgICAgICAgICAgbGVmdDogZS54LFxuICAgICAgICAgICAgcmlnaHQ6IGUueCArIGUud2lkdGgsXG4gICAgICAgICAgICBib3R0b206IGUueSArIGUuaGVpZ2h0XG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAvKipcbiAqIFByb3ZpZGVzIERPTVJlY3QgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHNpemUgb2YgYW4gZWxlbWVudCBhbmQgaXRzIHBvc2l0aW9uIHJlbGF0aXZlIHRvIHRoZSB2aWV3cG9ydC5cbiAqIEFjY291bnRzIGZvciBTYWZhcmkncyB1c2Ugb2YgdmlzdWFsIHZpZXdwb3J0IGFuZCBhZGRzIG9mZnNldHMgdG8gc2V0IGFzIGxheW91dCB2aWV3cG9ydC5cbiAqIEBwYXJhbSB7RWxlbWVudH0gZWxlbWVudCAtIFRoZSBlbGVtZW50IHRvIGJlIGV2YWx1YXRlZFxuICogQHBhcmFtIHtib29sZWFufSBvZmZzZXRzIC0gVXNlIHdoZW4gcG9zaXRpb24gb2YgZWxlbWVudCByZWxhdGl2ZSB0byB0aGUgbGF5b3V0IHZpZXdwb3J0IG9mZnNldHMgYXJlIG5lZWRlZCBmb3IgU2FmYXJpLlxuICogQHJldHVybnMge09taXQ8RE9NUmVjdCwgJ3RvSlNPTic+fVxuICogQHB1YmxpY1xuICovICAgIGZ1bmN0aW9uIHhvKGUsIG4pIHtcbiAgICAgICAgdmFyIHQsIHI7XG4gICAgICAgIHZhciBvID0gZS5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTtcbiAgICAgICAgdmFyIGkgPSB3bygpO1xuICAgICAgICBpZiAoIW4gfHwgIWkpIHtcbiAgICAgICAgICAgIHJldHVybiBvO1xuICAgICAgICB9XG4gICAgICAgIHZhciBhID0gdW4oKTtcbiAgICAgICAgdmFyIGwgPSBvLmxlZnQgKyAoKCh0ID0gYS52aXN1YWxWaWV3cG9ydCkgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5vZmZzZXRMZWZ0KSB8fCAwKTtcbiAgICAgICAgdmFyIHUgPSBvLnRvcCArICgoKHIgPSBhLnZpc3VhbFZpZXdwb3J0KSA9PT0gbnVsbCB8fCByID09PSB2b2lkIDAgPyB2b2lkIDAgOiByLm9mZnNldFRvcCkgfHwgMCk7XG4gICAgICAgIHZhciBzID0gby53aWR0aCwgYyA9IG8uaGVpZ2h0O1xuICAgICAgICByZXR1cm4gQ28oe1xuICAgICAgICAgICAgd2lkdGg6IHMsXG4gICAgICAgICAgICBoZWlnaHQ6IGMsXG4gICAgICAgICAgICB4OiBsLFxuICAgICAgICAgICAgeTogdVxuICAgICAgICB9KTtcbiAgICB9XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvdXRpbHMvdHlwZXMudHNcbiAgICAvLyBzZWUgaHR0cHM6Ly9naXRodWIuY29tL0RlZmluaXRlbHlUeXBlZC9EZWZpbml0ZWx5VHlwZWQvaXNzdWVzLzMxMjQ1IGZvciBkZXRhaWxzXG4gICAgLy8gcmVnYXJkaW5nIHRoZSBjc3MgcHJvcC4gY2VydGFpbiAodmVyc2lvbnMgb2YpIGxpYnJhcmllcyBpbmNsdWRlZCBpbiB0aGUgY29tcGlsYXRpb25cbiAgICAvLyAtIHN1Y2ggYXMgc3Rvcnlib29rLT5lbW90aW9uIC0gaW50cm9kdWNlIHRoZSBjc3MgcHJvcCB1c2luZyBhIGdsb2JhbCBhdWdtZW50YXRpb24sXG4gICAgLy8gd2hpY2ggY2F1c2VzIHRoZSBwcm9wIHRvIGVuZCB1cCBpbiBvdXIgZGVjbGFyYXRpb24gZmlsZXMgKHZpYSBKU1guSW50cmluc2ljRWxlbWVudHMpLlxuICAgIC8vIGl0J3MgZGlmZmljdWx0IHRvIGNvbnRyb2wgYWxsIG5lc3RlZCBkZXBlbmRlbmNpZXMgYW5kIHRoZWlyIHR5cGVzLCB3aGljaCBpcyB3aHkgdGhlXG4gICAgLy8gY3NzIHByb3AgaXMgb21pdHRlZCBpbiB0aGUgdHdvIHByb3AgaGVscGVycyBhYm92ZSAtIHRoaXMgZW5zdXJlcyB0aGUgY3NzIHByb3AgaXNuJ3RcbiAgICAvLyBlcnJvbmVvdXNseSBpbmNsdWRlZCBpbiByZWFjdC11aSdzIHB1YmxpYyBhcGkuXG4gICAgLy8gc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9taWNyb3NvZnQvVHlwZVNjcmlwdC9wdWxsLzEyMjUzXG4gICAgLy8gc2VlIGh0dHBzOi8vd3d3LnR5cGVzY3JpcHRsYW5nLm9yZy9kb2NzL2hhbmRib29rL3JlbGVhc2Utbm90ZXMvdHlwZXNjcmlwdC0zLTcuaHRtbFxuICAgIGZ1bmN0aW9uIFNvKGUsIG4pIHtcbiAgICAgICAgaWYgKGUgPT09IHVuZGVmaW5lZCB8fCBlID09PSBudWxsKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IobiAhPT0gbnVsbCAmJiBuICE9PSB2b2lkIDAgPyBuIDogXCJVbmV4cGVjdGVkIHVuZGVmaW5lZCBvciBudWxsXCIpO1xuICAgICAgICB9XG4gICAgfVxuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL1RhYmxlL1RhYmxlLnRzeFxuICAgIGZ1bmN0aW9uIE9vKCkge1xuICAgICAgICByZXR1cm4gT28gPSBPYmplY3QuYXNzaWduID8gT2JqZWN0LmFzc2lnbi5iaW5kKCkgOiBmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmb3IgKHZhciBuID0gMTsgbiA8IGFyZ3VtZW50cy5sZW5ndGg7IG4rKykge1xuICAgICAgICAgICAgICAgIHZhciB0ID0gYXJndW1lbnRzW25dO1xuICAgICAgICAgICAgICAgIGZvciAodmFyIHIgaW4gdCkge1xuICAgICAgICAgICAgICAgICAgICAoe30pLmhhc093blByb3BlcnR5LmNhbGwodCwgcikgJiYgKGVbcl0gPSB0W3JdKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZTtcbiAgICAgICAgfSwgT28uYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24ga28oZSkge1xuICAgICAgICByZXR1cm4gSW8oZSkgfHwgRW8oZSkgfHwgRG8oZSkgfHwgUm8oKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gUm8oKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gc3ByZWFkIG5vbi1pdGVyYWJsZSBpbnN0YW5jZS5cXG5JbiBvcmRlciB0byBiZSBpdGVyYWJsZSwgbm9uLWFycmF5IG9iamVjdHMgbXVzdCBoYXZlIGEgW1N5bWJvbC5pdGVyYXRvcl0oKSBtZXRob2QuXCIpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBFbyhlKSB7XG4gICAgICAgIGlmIChcInVuZGVmaW5lZFwiICE9IHR5cGVvZiBTeW1ib2wgJiYgbnVsbCAhPSBlW1N5bWJvbC5pdGVyYXRvcl0gfHwgbnVsbCAhPSBlW1wiQEBpdGVyYXRvclwiXSkgcmV0dXJuIEFycmF5LmZyb20oZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIElvKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBxbyhlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gVG8oZSwgbikge1xuICAgICAgICByZXR1cm4gUG8oZSkgfHwgQW8oZSwgbikgfHwgRG8oZSwgbikgfHwgam8oKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gam8oKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gZGVzdHJ1Y3R1cmUgbm9uLWl0ZXJhYmxlIGluc3RhbmNlLlxcbkluIG9yZGVyIHRvIGJlIGl0ZXJhYmxlLCBub24tYXJyYXkgb2JqZWN0cyBtdXN0IGhhdmUgYSBbU3ltYm9sLml0ZXJhdG9yXSgpIG1ldGhvZC5cIik7XG4gICAgfVxuICAgIGZ1bmN0aW9uIERvKGUsIG4pIHtcbiAgICAgICAgaWYgKGUpIHtcbiAgICAgICAgICAgIGlmIChcInN0cmluZ1wiID09IHR5cGVvZiBlKSByZXR1cm4gcW8oZSwgbik7XG4gICAgICAgICAgICB2YXIgdCA9IHt9LnRvU3RyaW5nLmNhbGwoZSkuc2xpY2UoOCwgLTEpO1xuICAgICAgICAgICAgcmV0dXJuIFwiT2JqZWN0XCIgPT09IHQgJiYgZS5jb25zdHJ1Y3RvciAmJiAodCA9IGUuY29uc3RydWN0b3IubmFtZSksIFwiTWFwXCIgPT09IHQgfHwgXCJTZXRcIiA9PT0gdCA/IEFycmF5LmZyb20oZSkgOiBcIkFyZ3VtZW50c1wiID09PSB0IHx8IC9eKD86VWl8SSludCg/Ojh8MTZ8MzIpKD86Q2xhbXBlZCk/QXJyYXkkLy50ZXN0KHQpID8gcW8oZSwgbikgOiB2b2lkIDA7XG4gICAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gcW8oZSwgbikge1xuICAgICAgICAobnVsbCA9PSBuIHx8IG4gPiBlLmxlbmd0aCkgJiYgKG4gPSBlLmxlbmd0aCk7XG4gICAgICAgIGZvciAodmFyIHQgPSAwLCByID0gQXJyYXkobik7IHQgPCBuOyB0KyspIHtcbiAgICAgICAgICAgIHJbdF0gPSBlW3RdO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICBmdW5jdGlvbiBBbyhlLCBuKSB7XG4gICAgICAgIHZhciB0ID0gbnVsbCA9PSBlID8gbnVsbCA6IFwidW5kZWZpbmVkXCIgIT0gdHlwZW9mIFN5bWJvbCAmJiBlW1N5bWJvbC5pdGVyYXRvcl0gfHwgZVtcIkBAaXRlcmF0b3JcIl07XG4gICAgICAgIGlmIChudWxsICE9IHQpIHtcbiAgICAgICAgICAgIHZhciByLCBvLCBpLCBhLCBsID0gW10sIHUgPSAhMCwgcyA9ICExO1xuICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICBpZiAoaSA9ICh0ID0gdC5jYWxsKGUpKS5uZXh0LCAwID09PSBuKSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChPYmplY3QodCkgIT09IHQpIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgdSA9ICExO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBmb3IgKDshKHUgPSAociA9IGkuY2FsbCh0KSkuZG9uZSkgJiYgKGwucHVzaChyLnZhbHVlKSwgbC5sZW5ndGggIT09IG4pOyB1ID0gITApIHtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgICAgICAgICAgcyA9ICEwLCBvID0gZTtcbiAgICAgICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCF1ICYmIG51bGwgIT0gdFtcInJldHVyblwiXSAmJiAoYSA9IHRbXCJyZXR1cm5cIl0oKSwgT2JqZWN0KGEpICE9PSBhKSkgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChzKSB0aHJvdyBvO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBsO1xuICAgICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIFBvKGUpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZSkpIHJldHVybiBlO1xuICAgIH1cbiAgICBmdW5jdGlvbiBfbyhlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQsIHIsIG8gPSB6byhlLCBuKTtcbiAgICAgICAgaWYgKE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMpIHtcbiAgICAgICAgICAgIHZhciBpID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTtcbiAgICAgICAgICAgIGZvciAociA9IDA7IHIgPCBpLmxlbmd0aDsgcisrKSB7XG4gICAgICAgICAgICAgICAgdCA9IGlbcl0sIC0xID09PSBuLmluZGV4T2YodCkgJiYge30ucHJvcGVydHlJc0VudW1lcmFibGUuY2FsbChlLCB0KSAmJiAob1t0XSA9IGVbdF0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvO1xuICAgIH1cbiAgICBmdW5jdGlvbiB6byhlLCBuKSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHQgPSB7fTtcbiAgICAgICAgZm9yICh2YXIgciBpbiBlKSB7XG4gICAgICAgICAgICBpZiAoe30uaGFzT3duUHJvcGVydHkuY2FsbChlLCByKSkge1xuICAgICAgICAgICAgICAgIGlmICgtMSAhPT0gbi5pbmRleE9mKHIpKSBjb250aW51ZTtcbiAgICAgICAgICAgICAgICB0W3JdID0gZVtyXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdDtcbiAgICB9XG4gICAgLy8gRXhwb3NlZCBhcyBzdGF0aWMgbWVtYmVycyBvZiB0aGUgVGFibGUgY2xhc3NcbiAgICAvLyBJbnRlcm5hbCBIZWxwZXIgTW9kdWxlc1xuICAgIC8qKiBAcHVibGljICovXG4gICAgLyoqIEBwdWJsaWMgKi9cbiAgICAvKiogQHB1YmxpYyAqLyAgICB2YXIgTW8gPSB7XG4gICAgICAgIGFjdGlvbnM6IHcoKS5hcnJheU9mKHcoKS5lbGVtZW50KSxcbiAgICAgICAgYWN0aW9uc0NvbHVtbldpZHRoOiB3KCkubnVtYmVyLFxuICAgICAgICBjaGlsZHJlbjogdygpLm5vZGUsXG4gICAgICAgIGRvY2tPZmZzZXQ6IHcoKS5udW1iZXIsXG4gICAgICAgIGRvY2tTY3JvbGxCYXI6IHcoKS5ib29sLFxuICAgICAgICBlbGVtZW50UmVmOiB3KCkub25lT2ZUeXBlKFsgdygpLmZ1bmMsIHcoKS5vYmplY3QgXSksXG4gICAgICAgIGhlYWRUeXBlOiB3KCkub25lT2YoWyBcImRvY2tlZFwiLCBcImZpeGVkXCIsIFwiaW5saW5lXCIgXSksXG4gICAgICAgIGlubmVyU3R5bGU6IHcoKS5vYmplY3QsXG4gICAgICAgIG9uUmVxdWVzdFRvZ2dsZUFsbFJvd3M6IHcoKS5mdW5jLFxuICAgICAgICBvblNjcm9sbDogdygpLmZ1bmMsXG4gICAgICAgIG91dGVyU3R5bGU6IHcoKS5vYmplY3QsXG4gICAgICAgIHByaW1hcnlDb2x1bW5JbmRleDogdygpLm51bWJlcixcbiAgICAgICAgcm93RXhwYW5zaW9uOiB3KCkub25lT2YoWyBcInNpbmdsZVwiLCBcIm11bHRpXCIsIFwiY29udHJvbGxlZFwiLCBcIm5vbmVcIiBdKSxcbiAgICAgICAgcm93U2VsZWN0aW9uOiB3KCkub25lT2YoWyBcImFsbFwiLCBcInNvbWVcIiwgXCJub25lXCIgXSksXG4gICAgICAgIHN0cmlwZVJvd3M6IHcoKS5ib29sLFxuICAgICAgICB0YWJsZVN0eWxlOiB3KCkub2JqZWN0LFxuICAgICAgICBvblJlcXVlc3RNb3ZlQ29sdW1uOiB3KCkuZnVuYyxcbiAgICAgICAgb25SZXF1ZXN0TW92ZVJvdzogdygpLmZ1bmMsXG4gICAgICAgIG9uUmVxdWVzdFJlc2l6ZUNvbHVtbjogdygpLmZ1bmMsXG4gICAgICAgIHJlc2l6YWJsZUZpbGxMYXlvdXQ6IHcoKS5ib29sXG4gICAgfTtcbiAgICB2YXIgJG8gPSBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgcmV0dXJuIG4gPT09IFwiaW5saW5lXCI7XG4gICAgfTtcbiAgICB2YXIgTm8gPSBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgcmV0dXJuIG4gPT09IFwiZG9ja2VkXCI7XG4gICAgfTtcbiAgICB2YXIgTG8gPSBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgcmV0dXJuIG4gPT09IFwiZml4ZWRcIjtcbiAgICB9O1xuICAgIHZhciBXbyA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICB2YXIgdCA9IHVuKCk7XG4gICAgICAgIHZhciByID0geG8obik7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB0b3A6IHIudG9wICsgdC5wYWdlWU9mZnNldCxcbiAgICAgICAgICAgIGxlZnQ6IHIubGVmdCArIHQucGFnZVhPZmZzZXRcbiAgICAgICAgfTtcbiAgICB9O1xuICAgIHZhciBIbyA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICB2YXIgdCA9IHJuKCk7XG4gICAgICAgIGlmIChuID09PSB1bmRlZmluZWQgfHwgbiA9PT0gbnVsbCkge1xuICAgICAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICAgICAgfVxuICAgICAgICB2YXIgciA9IG4uY2hpbGRyZW5bMF0uY2hpbGRyZW47XG4gICAgICAgIHZhciBvID0gZCgpKHIsIHQuYWN0aXZlRWxlbWVudCk7XG4gICAgICAgIGlmIChvID4gLTEpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgdGFyZ2V0OiBcImhlYWRDZWxsXCIsXG4gICAgICAgICAgICAgICAgaW5kZXg6IG9cbiAgICAgICAgICAgIH07XG4gICAgICAgIH1cbiAgICAgICAgdmFyIGkgPSBuLnF1ZXJ5U2VsZWN0b3JBbGwoXCJbZGF0YS10ZXN0PXJlc2l6ZV1cIik7XG4gICAgICAgIHZhciBhID0gZCgpKGksIHQuYWN0aXZlRWxlbWVudCk7XG4gICAgICAgIGlmIChhID4gLTEpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgdGFyZ2V0OiBcInJlc2l6ZUJ1dHRvblwiLFxuICAgICAgICAgICAgICAgIGluZGV4OiBhXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfTtcbiAgICB2YXIgS28gPSBmdW5jdGlvbiBlKG4sIHQpIHtcbiAgICAgICAgcmV0dXJuIG4uaW5kZXhPZih0KSArIDE7XG4gICAgfTtcbiAgICB2YXIgQm8gPSBmdW5jdGlvbiBlKG4sIHQpIHtcbiAgICAgICAgcmV0dXJuIG4uaW5kZXhPZih0KSArIDE7XG4gICAgfTtcbiAgICB2YXIgVm8gPSB7XG4gICAgICAgIGNvb3JkaW5hdGVHZXR0ZXI6IGEuc29ydGFibGVLZXlib2FyZENvb3JkaW5hdGVzXG4gICAgfTtcbiAgICB2YXIgRm8gPSB7XG4gICAgICAgIGRyYWdnYWJsZTogKDAsIFQuXykoXCJUbyBwaWNrIHVwIGEgc29ydGFibGUgcm93LCBwcmVzcyBzcGFjZSBvciBlbnRlci5cXG4gICAgICAgICAgICBVc2UgdGhlIHVwIGFuZCBkb3duIGFycm93IGtleXMgdG8gdXBkYXRlIHRoZSBwb3NpdGlvbiBvZiB0aGUgcm93LlxcbiAgICAgICAgICAgIFByZXNzIHNwYWNlIG9yIGVudGVyIGFnYWluIHRvIGRyb3AgdGhlIHJvdyBpbiBpdHMgbmV3IHBvc2l0aW9uLCBvciBwcmVzcyBlc2NhcGUgdG8gY2FuY2VsLlwiKVxuICAgIH07XG4gICAgdmFyIFVvID0ge1xuICAgICAgICBkcmFnZ2FibGU6ICgwLCBULl8pKFwiVG8gcGljayB1cCBhIHNvcnRhYmxlIGNvbHVtbiwgcHJlc3Mgc3BhY2Ugb3IgZW50ZXIuXFxuICAgICAgICAgICAgVXNlIHRoZSBsZWZ0IGFuZCByaWdodCBhcnJvdyBrZXlzIHRvIHVwZGF0ZSB0aGUgcG9zaXRpb24gb2YgdGhlIGNvbHVtbi5cXG4gICAgICAgICAgICBQcmVzcyBzcGFjZSBvciBlbnRlciBhZ2FpbiB0byBkcm9wIHRoZSBjb2x1bW4gaW4gaXRzIG5ldyBwb3NpdGlvbiwgb3IgcHJlc3MgZXNjYXBlIHRvIGNhbmNlbC5cIilcbiAgICB9O1xuICAgIC8qKlxuICogQHByaXZhdGVcbiAqIEBwcml2YXRlXG4gKiBBcHBsaWVzIHRoZSBwcm92aWRlZCBgaGVhZEZvY3VzU3RhdGVgIHRvIHRoZSBwcm92aWRlZCBgaGVhZGAuXG4gKiBAcGFyYW0gaGVhZCAtIEEgcmVmZXJlbmNlIHRvIGEgbW91bnRlZCBgSGVhZGAgY29tcG9uZW50LlxuICogQHBhcmFtIHtPYmplY3R9IGhlYWRGb2N1c1N0YXRlXG4gKiBAcGFyYW0ge1N0cmluZ30gaGVhZEZvY3VzU3RhdGUudGFyZ2V0IC0gRm9jdXMgY2FuIGJlIGFwcGxpZWQgdG8gYSAnaGVhZENlbGwnIG9yIGFcbiAqICdyZXNpemVCdXR0b24nLlxuICogQHBhcmFtIHtOdW1iZXJ9IGhlYWRGb2N1c1N0YXRlLmluZGV4IC0gVGhlIGluZGV4IG9mIHRoZSBlbGVtZW50IHRvIHNldCBmb2N1cyBvbi5cbiAqLyAgICBmdW5jdGlvbiBYbyhlLCBuKSB7XG4gICAgICAgIHZhciB0LCByO1xuICAgICAgICB2YXIgbyA9IG4udGFyZ2V0LCBpID0gbi5pbmRleDtcbiAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICB2YXIgYTtcbiAgICAgICAgaWYgKG8gPT09IFwiaGVhZENlbGxcIikge1xuICAgICAgICAgICAgYSA9IGUgPT09IG51bGwgfHwgZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogZS5jaGlsZHJlblswXS5jaGlsZHJlbltpXTtcbiAgICAgICAgfSBlbHNlIGlmIChvID09PSBcInJlc2l6ZUJ1dHRvblwiKSB7XG4gICAgICAgICAgICBhID0gZSA9PT0gbnVsbCB8fCBlID09PSB2b2lkIDAgPyB2b2lkIDAgOiBlLnF1ZXJ5U2VsZWN0b3JBbGwoXCJbZGF0YS10ZXN0PXJlc2l6ZV1cIilbaV07XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICAodCA9IGEpID09PSBudWxsIHx8IHQgPT09IHZvaWQgMCA/IHZvaWQgMCA6IChyID0gdC5mb2N1cykgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5jYWxsKHQpO1xuICAgIH1cbiAgICB2YXIgWW8gPSB7XG4gICAgICAgIHBhc3NpdmU6IGZhbHNlLFxuICAgICAgICBjYXB0dXJlOiB0cnVlXG4gICAgfTtcbiAgICB2YXIgR28gPSBbXTtcbiAgICBmdW5jdGlvbiBKbyhlKSB7XG4gICAgICAgIHZhciBuID0gZS5hY3Rpb25zLCBsID0gbiA9PT0gdm9pZCAwID8gR28gOiBuLCBzID0gZS5hY3Rpb25zQ29sdW1uV2lkdGgsIGMgPSBlLmNoaWxkcmVuLCBkID0gZS5kb2NrT2Zmc2V0LCBmID0gZCA9PT0gdm9pZCAwID8gMCA6IGQsIHAgPSBlLmRvY2tTY3JvbGxCYXIsIG0gPSBlLmVsZW1lbnRSZWYsIGggPSBlLmhlYWRUeXBlLCBnID0gaCA9PT0gdm9pZCAwID8gXCJpbmxpbmVcIiA6IGgsIHcgPSBlLmlubmVyU3R5bGUsIEMgPSBlLm9uUmVxdWVzdE1vdmVDb2x1bW4sIE8gPSBlLm9uUmVxdWVzdE1vdmVSb3csIFIgPSBlLm9uUmVxdWVzdFJlc2l6ZUNvbHVtbiwgRCA9IGUub25SZXF1ZXN0VG9nZ2xlQWxsUm93cywgcSA9IGUub25TY3JvbGwsIEEgPSBlLm91dGVyU3R5bGUsIFAgPSBlLnByaW1hcnlDb2x1bW5JbmRleCwgXyA9IFAgPT09IHZvaWQgMCA/IDAgOiBQLCB6ID0gZS5yZXNpemFibGVGaWxsTGF5b3V0LCBNID0gZS5yb3dFeHBhbnNpb24sICQgPSBNID09PSB2b2lkIDAgPyBcIm5vbmVcIiA6IE0sIEwgPSBlLnJvd1NlbGVjdGlvbiwgVyA9IEwgPT09IHZvaWQgMCA/IFwibm9uZVwiIDogTCwgSCA9IGUuc3RyaXBlUm93cywgSyA9IGUudGFibGVTdHlsZSwgQiA9IF9vKGUsIFsgXCJhY3Rpb25zXCIsIFwiYWN0aW9uc0NvbHVtbldpZHRoXCIsIFwiY2hpbGRyZW5cIiwgXCJkb2NrT2Zmc2V0XCIsIFwiZG9ja1Njcm9sbEJhclwiLCBcImVsZW1lbnRSZWZcIiwgXCJoZWFkVHlwZVwiLCBcImlubmVyU3R5bGVcIiwgXCJvblJlcXVlc3RNb3ZlQ29sdW1uXCIsIFwib25SZXF1ZXN0TW92ZVJvd1wiLCBcIm9uUmVxdWVzdFJlc2l6ZUNvbHVtblwiLCBcIm9uUmVxdWVzdFRvZ2dsZUFsbFJvd3NcIiwgXCJvblNjcm9sbFwiLCBcIm91dGVyU3R5bGVcIiwgXCJwcmltYXJ5Q29sdW1uSW5kZXhcIiwgXCJyZXNpemFibGVGaWxsTGF5b3V0XCIsIFwicm93RXhwYW5zaW9uXCIsIFwicm93U2VsZWN0aW9uXCIsIFwic3RyaXBlUm93c1wiLCBcInRhYmxlU3R5bGVcIiBdKTtcbiAvLyBAZG9jcy1wcm9wcy10eXBlIFRhYmxlUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIFYgPSAoMCwgdC51c2VTdGF0ZSkoW10pLCBGID0gVG8oViwgMiksIFUgPSBGWzBdLCBYID0gRlsxXTtcbiAgICAgICAgdmFyIFkgPSAoMCwgdC51c2VTdGF0ZSkoKSwgRyA9IFRvKFksIDIpLCBKID0gR1swXSwgcmUgPSBHWzFdO1xuICAgICAgICB2YXIgYWUgPSAoMCwgdC51c2VTdGF0ZSkoKSwgbGUgPSBUbyhhZSwgMiksIHVlID0gbGVbMF0sIHNlID0gbGVbMV07XG4gICAgICAgIHZhciBjZSA9ICgwLCB0LnVzZVN0YXRlKSgpLCBkZSA9IFRvKGNlLCAyKSwgZmUgPSBkZVswXSwgdmUgPSBkZVsxXTtcbiAgICAgICAgdmFyIHBlID0gKDAsIHQudXNlU3RhdGUpKCksIG1lID0gVG8ocGUsIDIpLCBiZSA9IG1lWzBdLCBoZSA9IG1lWzFdO1xuICAgICAgICB2YXIgeWUgPSAoMCwgdC51c2VSZWYpKHRydWUpO1xuICAgICAgICB2YXIgZ2UgPSAoMCwgdC51c2VDb250ZXh0KShTLlNjcm9sbENvbnRhaW5lckNvbnRleHQpO1xuICAgICAgICB2YXIgd2UgPSAoMCwgby51c2VTZW5zb3JzKSgoMCwgby51c2VTZW5zb3IpKG8uTW91c2VTZW5zb3IsIHt9KSwgKDAsIG8udXNlU2Vuc29yKShvLlRvdWNoU2Vuc29yLCB7fSksICgwLCBcbiAgICAgICAgby51c2VTZW5zb3IpKHZvLCBWbykpO1xuICAgICAgICB2YXIgQ2UgPSAoMCwgdC51c2VTdGF0ZSkoW10pLCB4ZSA9IFRvKENlLCAyKSwgU2UgPSB4ZVswXSwgT2UgPSB4ZVsxXTtcbiAgICAgICAgdmFyIGtlID0gKDAsIHQudXNlU3RhdGUpKC0xKSwgUmUgPSBUbyhrZSwgMiksIEVlID0gUmVbMF0sIEllID0gUmVbMV07XG4gICAgICAgIHZhciBUZSA9ICgwLCB0LnVzZVJlZikoKTtcbiAgICAgICAgdmFyIGplID0gKDAsIHQudXNlUmVmKSgpO1xuICAgICAgICB2YXIgRGUgPSAoMCwgdC51c2VTdGF0ZSkoKSwgcWUgPSBUbyhEZSwgMiksIEFlID0gcWVbMF0sIFBlID0gcWVbMV07XG4gICAgICAgIHZhciBfZSA9ICgwLCB0LnVzZVJlZikobnVsbCk7XG4gICAgICAgIHZhciB6ZSA9ICgwLCB0LnVzZVJlZikobnVsbCk7XG4gICAgICAgIHZhciBNZSA9ICgwLCB0LnVzZVJlZikoKTtcbiAgICAgICAgdmFyICRlID0gKDAsIHQudXNlUmVmKShudWxsKTtcbiAgICAgICAgdmFyIE5lID0gKDAsIHQudXNlUmVmKSgpO1xuICAgICAgICB2YXIgTGUgPSAoMCwgdC51c2VSZWYpKG51bGwpO1xuICAgICAgICB2YXIgV2UgPSAoMCwgdC51c2VSZWYpKG51bGwpO1xuICAgICAgICB2YXIgSGUgPSBrKCkoZyk7XG4gICAgICAgIHZhciBLZSA9ICgwLCB0LnVzZVJlZikoW10pO1xuICAgICAgICB2YXIgQmUgPSAoMCwgdC51c2VSZWYpKFtdKTtcbiAgICAgICAgdmFyIFZlID0gKDAsIHQudXNlUmVmKShbXSk7XG4gICAgICAgIHZhciBGZSA9ICgwLCB0LnVzZVJlZikoW10pO1xuICAgICAgICB2YXIgVWUgPSBCZS5jdXJyZW50O1xuICAgICAgICB2YXIgWGUgPSBLZS5jdXJyZW50O1xuICAgICAgICB2YXIgWWUgPSBGZS5jdXJyZW50O1xuICAgICAgICB2YXIgR2UgPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgdmFyIGU7XG4gICAgICAgICAgICB2YXIgbiA9IHVuKCk7XG4gICAgICAgICAgICBpZiAoJG8oZykpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgdCA9IFdlLmN1cnJlbnQ7XG4gICAgICAgICAgICB2YXIgciA9IHplLmN1cnJlbnQ7XG4gICAgICAgICAgICB2YXIgbyA9IExlLmN1cnJlbnQ7XG4gICAgICAgICAgICBpZiAoIW8gfHwgIXIpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgaSA9IFF0KHplLmN1cnJlbnQpO1xuICAgICAgICAgICAgdmFyIGEgPSAoZSA9IHplLmN1cnJlbnQpID09PSBudWxsIHx8IGUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGUuY2xpZW50SGVpZ2h0O1xuICAgICAgICAgICAgdmFyIGwgPSBXbyhvKS50b3AgLSBuLnBhZ2VZT2Zmc2V0IC0gKGEgfHwgMCkgKyBvLm9mZnNldEhlaWdodDtcbiAgICAgICAgICAgIHZhciB1ID0gTWF0aC5taW4obCwgTnVtYmVyKGYpKTtcbiAgICAgICAgICAgIGhlKHQgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5jbGllbnRXaWR0aCk7XG4gICAgICAgICAgICBzZShvID09PSBudWxsIHx8IG8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG8uY2xpZW50V2lkdGgpO1xuICAgICAgICAgICAgWChpKTtcbiAgICAgICAgICAgIHZlKHUpO1xuICAgICAgICB9KSwgWyBmLCBnIF0pO1xuICAgICAgICAoMCwgdC51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHZhciBlID0gemUuY3VycmVudDtcbiAgICAgICAgICAgIHZhciBuID0gJGUuY3VycmVudDtcbiAgICAgICAgICAgIGlmIChlICYmIG4pIHtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IFF0KHplLmN1cnJlbnQpO1xuICAgICAgICAgICAgICAgIGlmICghdigpKFUsIHQpKSB7XG4gICAgICAgICAgICAgICAgICAgIEdlKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKEhlID09PSBcImlubGluZVwiICYmIGcgPT09IFwiaW5saW5lXCIpIHtcbiAgICAgICAgICAgICAgICBHZSgpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGZhbHNlKSB7fVxuICAgICAgICB9KSwgWyBVLCBnLCBIZSwgZSwgR2UgXSk7XG4gICAgICAgIHZhciBKZSA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgdmFyIG4gPSBXZS5jdXJyZW50O1xuICAgICAgICAgICAgcSA9PT0gbnVsbCB8fCBxID09PSB2b2lkIDAgPyB2b2lkIDAgOiBxKGUpO1xuICAgICAgICAgICAgaWYgKChMbyhnKSB8fCBObyhnKSkgJiYgbikge1xuICAgICAgICAgICAgICAgIHJlKC1uLnNjcm9sbExlZnQpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKF9lLmN1cnJlbnQgJiYgTmUuY3VycmVudCAhPT0gXCJkb2NrZWRTY3JvbGxCYXJcIiAmJiBuKSB7XG4gICAgICAgICAgICAgICAgTmUuY3VycmVudCA9IFwiY29udGFpbmVyXCI7XG4gICAgICAgICAgICAgICAgX2UuY3VycmVudC5zY3JvbGxMZWZ0ID0gbi5zY3JvbGxMZWZ0O1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBOZS5jdXJyZW50ID0gdW5kZWZpbmVkO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBnLCBxIF0pO1xuICAgICAgICB2YXIgUWUgPSBmdW5jdGlvbiBlKCkge1xuICAgICAgICAgICAgdmFyIG4gPSBXZS5jdXJyZW50O1xuICAgICAgICAgICAgaWYgKE5lLmN1cnJlbnQgIT09IFwiY29udGFpbmVyXCIgJiYgbiAmJiBfZS5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgTmUuY3VycmVudCA9IFwiZG9ja2VkU2Nyb2xsQmFyXCI7XG4gICAgICAgICAgICAgICAgbi5zY3JvbGxMZWZ0ID0gX2UuY3VycmVudC5zY3JvbGxMZWZ0O1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBOZS5jdXJyZW50ID0gdW5kZWZpbmVkO1xuICAgICAgICAgICAgfVxuICAgICAgICB9O1xuICAgICAgICB2YXIgWmUgPSB5KCkoR2UsIDApO1xuICAgICAgICB2YXIgZW4gPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgR2UoKTtcbiAgICAgICAgfSksIFsgR2UgXSk7XG4gICAgICAgIHZhciBubiA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB5KCkoZW4sIDUwKTtcbiAgICAgICAgfSksIFsgZW4gXSk7XG4gICAgICAgIEUoKShXZSwgbm4pO1xuICAgICAgICAoMCwgdC51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIC8vIFVzaW5nIHRoZSByZXR1cm4gdmFsdWUgb2YgdXNlQ2FsbGJhY2sgdG8gcmVjcmVhdGUgY29tcG9uZW50V2lsbFVubW91bnRcbiAgICAgICAgICAgIHJldHVybiBmdW5jdGlvbigpIHtcbiAgICAgICAgICAgICAgICBaZS5jYW5jZWwoKTtcbiAgICAgICAgICAgICAgICBubi5jYW5jZWwoKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pKTtcbiAgICAgICAgdmFyIHRuID0gZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICByZXR1cm4gZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgICAgIHplLmN1cnJlbnQgPSBlO1xuICAgICAgICAgICAgICAgIE4obi5wcm9wcy5lbGVtZW50UmVmLCBlKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgIH07XG4gICAgICAgIHZhciBvbiA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgaWYgKG4pIHtcbiAgICAgICAgICAgICAgICAvLyBPbiBtb3VudCwgZm9jdXMgdGhlIGFwcGxpY2FibGUgZG9ja2VkIGhlYWQgY2VsbCBpZiBhIHByaW1hcnkgaGVhZCBjZWxsIHdhcyBmb2N1c2VkLlxuICAgICAgICAgICAgICAgIGlmIChNZS5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgICAgIFhvKCRlLmN1cnJlbnQsIE1lLmN1cnJlbnQpO1xuICAgICAgICAgICAgICAgICAgICBNZS5jdXJyZW50ID0gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgLy8gT24gdW5tb3VudCwgZm9jdXMgdGhlIGFwcGxpY2FibGUgcHJpbWFyeSBoZWFkIGNlbGwgaWYgYSBkb2NrZWQgaGVhZCBjZWxsIHdhcyBmb2N1c2VkLlxuICAgICAgICAgICAgICAgIHZhciB0ID0gSG8oJGUuY3VycmVudCk7XG4gICAgICAgICAgICAgICAgaWYgKHQpIHtcbiAgICAgICAgICAgICAgICAgICAgWG8oemUuY3VycmVudCwgdCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgJGUuY3VycmVudCA9IG47XG4gICAgICAgIH07XG4gICAgICAgIHZhciBhbiA9IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgdmFyIHQgPSBXZS5jdXJyZW50O1xuICAgICAgICAgICAgaWYgKCEkZS5jdXJyZW50IHx8ICF0IHx8IG4ua2V5ICE9PSBcIlRhYlwiKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdmFyIHIgPSAkZS5jdXJyZW50LnNjcm9sbExlZnQ7XG4gICAgICAgICAgICBpZiAociAhPT0gMCkge1xuICAgICAgICAgICAgICAgICRlLmN1cnJlbnQuc2Nyb2xsTGVmdCA9IDA7XG4gICAgICAgICAgICAgICAgdC5zY3JvbGxMZWZ0ICs9IHI7XG4gICAgICAgICAgICB9XG4gICAgICAgIH07XG4gICAgICAgIHZhciBsbiA9IGZ1bmN0aW9uIGUobiwgdCkge1xuICAgICAgICAgICAgdmFyIHIsIG87XG4gICAgICAgICAgICB2YXIgaSA9IHQuY29sdW1uSWQsIGEgPSB0LmluZGV4LCBsID0gdC5pZDtcbiAgICAgICAgICAgIHZhciBzID0gcm4oKTtcbiAgICAgICAgICAgIGlmIChhID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgYyA9ICQgPT09IFwibm9uZVwiID8gMSA6IDI7XG4gICAgICAgICAgICB2YXIgZCA9IChyID0gV2UuY3VycmVudCkgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5xdWVyeVNlbGVjdG9yQWxsKFwidGhlYWQgdGg6bnRoLWNoaWxkKFwiLmNvbmNhdChhICsgYywgXCIpLCB0Ym9keSB0ZDpudGgtY2hpbGQoXCIpLmNvbmNhdChhICsgYywgXCIpXCIpKTtcbiAgICAgICAgICAgIHZhciBmID0gcy5jcmVhdGVFbGVtZW50KFwiZGl2XCIpO1xuICAgICAgICAgICAgLy8gVE9ETzogZmluZCBhIHN0eWxlZC1jb21wb25lbnRzIGNvbXBsaWFudCB3YXkgdG8gZG8gdGhpc1xuICAgICAgICAgICAgICAgICAgICAgICAgZi5zdHlsZVtcImZsb2F0XCJdID0gXCJsZWZ0XCI7XG4gICAgICAgICAgICBmLnN0eWxlLnBvc2l0aW9uID0gXCJmaXhlZFwiO1xuICAgICAgICAgICAgZi5zdHlsZS50b3AgPSBcIi0xMDBcIjtcbiAgICAgICAgICAgIGYuc3R5bGUubGVmdCA9IFwiMFwiO1xuICAgICAgICAgICAgZi5zdHlsZS5tYXhIZWlnaHQgPSBcIjEwcHhcIjtcbiAgICAgICAgICAgIGYuc3R5bGUub3ZlcmZsb3cgPSBcImhpZGRlblwiO1xuICAgICAgICAgICAgdSgpKGQsIChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICAgICAgdmFyIG4gPSBlLmNsb25lTm9kZSh0cnVlKTtcbiAvLyBUUzogdGhpcyBzZWVtcyBzYWZlIHRvIGFzc3VtZT9cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbi5zdHlsZS5kaXNwbGF5ID0gXCJibG9ja1wiO1xuICAgICAgICAgICAgICAgIG4uc3R5bGUud2lkdGggPSBcImF1dG9cIjtcbiAgICAgICAgICAgICAgICBmLmFwcGVuZENoaWxkKG4pO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgcy5ib2R5LmFwcGVuZENoaWxkKGYpO1xuICAgICAgICAgICAgUiA9PT0gbnVsbCB8fCBSID09PSB2b2lkIDAgPyB2b2lkIDAgOiBSKG4sIHtcbiAgICAgICAgICAgICAgICBjb2x1bW5JZDogaSxcbiAgICAgICAgICAgICAgICBpZDogbCxcbiAgICAgICAgICAgICAgICBpbmRleDogYSxcbiAgICAgICAgICAgICAgICB3aWR0aDogZi5jbGllbnRXaWR0aCArIDFcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgKG8gPSBmLnBhcmVudE5vZGUpID09PSBudWxsIHx8IG8gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG8ucmVtb3ZlQ2hpbGQoZik7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBzbiA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgdmFyIG4gPSBlLmFjdGl2ZTtcbiAgICAgICAgICAgIHZhciB0ID0gbi5pZDtcbiAgICAgICAgICAgIFRlLmN1cnJlbnQgPSBZZS5pbmRleE9mKHQpO1xuICAgICAgICAgICAgUGUodCk7XG4gICAgICAgIH0pLCBbIFllIF0pO1xuICAgICAgICB2YXIgY24gPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGlmIChlLm92ZXIpIHtcbiAgICAgICAgICAgICAgICB2YXIgbiA9IGUub3Zlci5pZDtcbiAgICAgICAgICAgICAgICB2YXIgdCA9IFllLmluZGV4T2Yobik7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSB0O1xuICAgICAgICAgICAgICAgIGlmIChUZS5jdXJyZW50ICE9PSB1bmRlZmluZWQgJiYgdCA+IFRlLmN1cnJlbnQpIHtcbiAgICAgICAgICAgICAgICAgICAgciA9IHQgKyAxO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBJZShyKTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgSWUoLTEpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBZZSBdKTtcbiAgICAgICAgLy8gdGhlc2UgYXJlIHVzZU1lbW8gcmF0aGVyIHRoYW4gdXNlQ2FsbGJhY2sgc28gdGhhdCBFU0xpbnQgY2FuIGNvcnJlY3RseSBhbmFseXplIHRoZSBkZXBlbmRlbmNpZXNcbiAgICAgICAgLy8gc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9mYWNlYm9vay9yZWFjdC9pc3N1ZXMvMTkyNDAjaXNzdWVjb21tZW50LTY1Mjk0NTI0NlxuICAgICAgICAgICAgICAgIHZhciBkbiA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB5KCkoY24sIDEwMCk7XG4gICAgICAgIH0pLCBbIGNuIF0pO1xuICAgICAgICAoMCwgdC51c2VFZmZlY3QpKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiBmdW5jdGlvbigpIHtcbiAgICAgICAgICAgICAgICBkbi5jYW5jZWwoKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIGRuIF0pO1xuICAgICAgICB2YXIgZm4gPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciBuID0gZS5hY3RpdmUsIHQgPSBlLm92ZXI7XG4gICAgICAgICAgICBpZiAodCAmJiBuLmlkICE9PSB0LmlkKSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSBZZS5pbmRleE9mKG4uaWQpO1xuICAgICAgICAgICAgICAgIHZhciBvID0gWWUuaW5kZXhPZih0ID09PSBudWxsIHx8IHQgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHQuaWQpO1xuICAgICAgICAgICAgICAgIEMgPT09IG51bGwgfHwgQyA9PT0gdm9pZCAwID8gdm9pZCAwIDogQyh7XG4gICAgICAgICAgICAgICAgICAgIGZyb21JbmRleDogcixcbiAgICAgICAgICAgICAgICAgICAgdG9JbmRleDogb1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgUGUodW5kZWZpbmVkKTtcbiAgICAgICAgICAgIEllKC0xKTtcbiAgICAgICAgICAgIGplLmN1cnJlbnQgPSB1bmRlZmluZWQ7XG4gICAgICAgICAgICBUZS5jdXJyZW50ID0gdW5kZWZpbmVkO1xuICAgICAgICB9KSwgWyBZZSwgQyBdKTtcbiAgICAgICAgdmFyIHZuID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICB2YXIgbiA9IGUuYWN0aXZlLCB0ID0gZS5vdmVyO1xuICAgICAgICAgICAgeWUuY3VycmVudCA9IHRydWU7XG4gICAgICAgICAgICBpZiAodCAmJiBuLmlkICE9PSB0LmlkKSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSBVZS5pbmRleE9mKG4uaWQpO1xuICAgICAgICAgICAgICAgIHZhciBvID0gVWUuaW5kZXhPZih0ID09PSBudWxsIHx8IHQgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHQuaWQpO1xuICAgICAgICAgICAgICAgIE8gPT09IG51bGwgfHwgTyA9PT0gdm9pZCAwID8gdm9pZCAwIDogTyh7XG4gICAgICAgICAgICAgICAgICAgIGZyb21JbmRleDogcixcbiAgICAgICAgICAgICAgICAgICAgdG9JbmRleDogb1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBVZSwgTyBdKTtcbiAgICAgICAgdmFyIHBuID0gKDAsIHQudXNlQ2FsbGJhY2spKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHllLmN1cnJlbnQgPSB0cnVlO1xuICAgICAgICB9KSwgW10pO1xuICAgICAgICB2YXIgbW4gPSAoMCwgdC51c2VSZWYpKHt9KTtcbiAgICAgICAgdmFyIGJuID0gZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICB2YXIgciA9IFtdO1xuICAgICAgICAgICAgdmFyIG8gPSBbXTtcbiAgICAgICAgICAgIHZhciBpID0gdC5DaGlsZHJlbi50b0FycmF5KG4ucHJvcHMuY2hpbGRyZW4pLmZpbHRlcih0LmlzVmFsaWRFbGVtZW50KS5tYXAoKGZ1bmN0aW9uKGUsIG4pIHtcbiAgICAgICAgICAgICAgICB2YXIgaSA9IGU7XG4gICAgICAgICAgICAgICAgdmFyIGEgPSBpLmtleSB8fCAoMCwgai5jcmVhdGVET01JRCkoXCJjb2wtXCIpO1xuICAgICAgICAgICAgICAgIGEgPSBTdHJpbmcoYSk7XG4gICAgICAgICAgICAgICAgLy8gYGNvbC1gIHByZWZpeCBpcyBuZWNlc3NhcnkgdG8gZGlzdGluZ3Vpc2ggcm93IG9yIGNvbHVtbiByZW9yZGVyaW5nLlxuICAgICAgICAgICAgICAgIC8vIEFwcGVuZCB0aGUgYGNvbC1gIHByZWZpeCBpZiBpcyBtaXNzaW5nIGZyb20gZHJhZ0lkXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmICghYS5zdGFydHNXaXRoKFwiY29sLVwiKSkge1xuICAgICAgICAgICAgICAgICAgICBhID0gXCJjb2wtXCIuY29uY2F0KGEpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICByLnB1c2goaSk7XG4gICAgICAgICAgICAgICAgby5wdXNoKGEpO1xuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIHJldHVybiAoMCwgdC5jbG9uZUVsZW1lbnQpKGksIHtcbiAgICAgICAgICAgICAgICAgICAgaW5kZXg6IG4sXG4gICAgICAgICAgICAgICAgICAgIGRyYWdJZDogYSxcbiAgICAgICAgICAgICAgICAgICAgZWxlbWVudFJlZjogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBtbi5jdXJyZW50W2FdID0gbjtcbiAgICAgICAgICAgICAgICAgICAgICAgIE4oaS5wcm9wcy5lbGVtZW50UmVmLCBuKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgVmUuY3VycmVudCA9IHI7XG4gICAgICAgICAgICBZZSA9IG87XG4gICAgICAgICAgICB2YXIgYSA9IGwgPT09IG51bGwgfHwgbCA9PT0gdm9pZCAwID8gdm9pZCAwIDogbC5maWx0ZXIodC5pc1ZhbGlkRWxlbWVudCk7XG4gICAgICAgICAgICB2YXIgdSA9ICAoMCwgdC5jbG9uZUVsZW1lbnQpKG4sIHtcbiAgICAgICAgICAgICAgICBhY3Rpb25zOiBhLFxuICAgICAgICAgICAgICAgIGFjdGlvbnNDb2x1bW5XaWR0aDogcyxcbiAgICAgICAgICAgICAgICBoYXNJbmZvQ29sdW1uOiAkICE9PSBcIm5vbmVcIixcbiAgICAgICAgICAgICAgICBoYXNEcmFnQ29sdW1uOiAhIU8sXG4gICAgICAgICAgICAgICAgb25BdXRvc2l6ZUNvbHVtbjogbG4sXG4gICAgICAgICAgICAgICAgb25SZXF1ZXN0TW92ZUNvbHVtbjogQyxcbiAgICAgICAgICAgICAgICBvblJlcXVlc3RSZXNpemVDb2x1bW46IFIsXG4gICAgICAgICAgICAgICAgb25SZXF1ZXN0VG9nZ2xlQWxsUm93czogRCxcbiAgICAgICAgICAgICAgICBlbGVtZW50UmVmOiB0bihuKSxcbiAgICAgICAgICAgICAgICByb3dTZWxlY3Rpb246IFdcbiAgICAgICAgICAgIH0sIGkpO1xuICAgICAgICAgICAgcmV0dXJuIHU7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBobiA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHZhciBlLCBuO1xuICAgICAgICAgICAgaWYgKEVlID09PSAtMSB8fCAhemUuY3VycmVudCB8fCAhV2UuY3VycmVudCkgcmV0dXJuIG51bGw7XG4gICAgICAgICAgICB2YXIgdCA9ICEhTztcbiAgICAgICAgICAgIHZhciBvID0gJCAhPT0gXCJub25lXCI7XG4gICAgICAgICAgICB2YXIgaSA9IEFycmF5LmZyb20oKGUgPSAobiA9IHplLmN1cnJlbnQuZmlyc3RFbGVtZW50Q2hpbGQpID09PSBudWxsIHx8IG4gPT09IHZvaWQgMCA/IHZvaWQgMCA6IG4uY2hpbGRyZW4pICE9PSBudWxsICYmIGUgIT09IHZvaWQgMCA/IGUgOiBbXSkuc2xpY2UobyA/IDEgOiAwKS5zbGljZSh0ID8gMSA6IDApLnNsaWNlKEQgPyAxIDogMCk7XG4gICAgICAgICAgICB2YXIgYTtcbiAgICAgICAgICAgIGlmIChFZSA9PT0gMCkge1xuICAgICAgICAgICAgICAgIHZhciBsO1xuICAgICAgICAgICAgICAgIGEgPSAoKGwgPSBpWzBdKSA9PT0gbnVsbCB8fCBsID09PSB2b2lkIDAgPyB2b2lkIDAgOiBsLm9mZnNldExlZnQpIHx8IDA7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKEVlID49IGkubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgdmFyIHUgPSBpW2kubGVuZ3RoIC0gMV07XG4gICAgICAgICAgICAgICAgYSA9ICgodSA9PT0gbnVsbCB8fCB1ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB1Lm9mZnNldExlZnQpIHx8IDApICsgKCh1ID09PSBudWxsIHx8IHUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHUub2Zmc2V0V2lkdGgpIHx8IDApIC0gMTtcbiAvLyAtMSBtYWtlcyB0aGUgbGFzdCBndWlkZWxpbmUgdmlzaWJsZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICB2YXIgcztcbiAgICAgICAgICAgICAgICBhID0gKChzID0gaVtFZV0pID09PSBudWxsIHx8IHMgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHMub2Zmc2V0TGVmdCkgfHwgMDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFxuICAgICAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KGllLCB7XG4gICAgICAgICAgICAgICAgJGhlaWdodDogV2UuY3VycmVudC5jbGllbnRIZWlnaHQsXG4gICAgICAgICAgICAgICAgJGxlZnQ6IGFcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KSwgWyBFZSwgTywgJCwgRCBdKTtcbiAgICAgICAgdmFyIHluID0gZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICB2YXIgciA9IChsID09PSBudWxsIHx8IGwgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGwuZmlsdGVyKHQuaXNWYWxpZEVsZW1lbnQpLmxlbmd0aCkgPiAwO1xuICAgICAgICAgICAgdmFyIG8gPSBmYWxzZTtcbiAgICAgICAgICAgIHZhciBpID0gW107XG4gICAgICAgICAgICB2YXIgYSA9IFtdO1xuICAgICAgICAgICAgdC5DaGlsZHJlbi50b0FycmF5KG4gPT09IG51bGwgfHwgbiA9PT0gdm9pZCAwID8gdm9pZCAwIDogbi5wcm9wcy5jaGlsZHJlbikuZmlsdGVyKHQuaXNWYWxpZEVsZW1lbnQpLmZvckVhY2goKGZ1bmN0aW9uKGUsIG4pIHtcbiAgICAgICAgICAgICAgICB2YXIgciwgbDtcbiAgICAgICAgICAgICAgICBpZiAoKChyID0gZS5wcm9wcykgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5hY3Rpb25QcmltYXJ5KSB8fCAoKGwgPSBlLnByb3BzKSA9PT0gbnVsbCB8fCBsID09PSB2b2lkIDAgPyB2b2lkIDAgOiBsLmFjdGlvbnNTZWNvbmRhcnkpKSB7XG4gICAgICAgICAgICAgICAgICAgIG8gPSB0cnVlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB2YXIgdSA9IGUua2V5IHx8ICgwLCBqLmNyZWF0ZURPTUlEKShcInJvdy1cIik7XG4gICAgICAgICAgICAgICAgdSA9IFN0cmluZyh1KTtcbiAgICAgICAgICAgICAgICAvLyBgcm93LWAgcHJlZml4IGlzIG5lY2Vzc2FyeSB0byBkaXN0aW5ndWlzaCByb3cgb3IgY29sdW1uIHJlb3JkZXJpbmcuXG4gICAgICAgICAgICAgICAgLy8gQXBwZW5kIHRoZSBgcm93LWAgcHJlZml4IGlmIGlzIG1pc3NpbmcgZnJvbSBkcmFnSWRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCF1LnN0YXJ0c1dpdGgoXCJyb3ctXCIpKSB7XG4gICAgICAgICAgICAgICAgICAgIHUgPSBcInJvdy1cIi5jb25jYXQodSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGkucHVzaCggKDAsIHQuY2xvbmVFbGVtZW50KShlLCB7XG4gICAgICAgICAgICAgICAgICAgIGluZGV4OiBuLFxuICAgICAgICAgICAgICAgICAgICBkcmFnSWQ6IHVcbiAgICAgICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICAgICAgYS5wdXNoKHUpO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgdmFyIHUgPSByIHx8IG8gfHwgISFzO1xuICAgICAgICAgICAgWGUgPSBpO1xuICAgICAgICAgICAgVWUgPSBhO1xuICAgICAgICAgICAgXG4gICAgICAgICAgICByZXR1cm4gKDAsIHQuY2xvbmVFbGVtZW50KShuLCB7XG4gICAgICAgICAgICAgICAgYWN0aW9uczogdSxcbiAgICAgICAgICAgICAgICBtb3ZhYmxlQ29sdW1uczogISFDLFxuICAgICAgICAgICAgICAgIG9uUmVxdWVzdE1vdmVSb3c6IE8sXG4gICAgICAgICAgICAgICAgcHJpbWFyeUNvbHVtbkluZGV4OiBfLFxuICAgICAgICAgICAgICAgIHJvd0V4cGFuc2lvbjogJCxcbiAgICAgICAgICAgICAgICBzdHJpcGVSb3dzOiBIXG4gICAgICAgICAgICB9LCBYZSk7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBnbiA9IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICB2YXIgbiA9IFdlLmN1cnJlbnQ7XG4gICAgICAgICAgICB2YXIgdCA9IHVuKCk7XG4gICAgICAgICAgICBpZiAoIU5vKGcpIHx8ICFMZS5jdXJyZW50IHx8ICF6ZS5jdXJyZW50IHx8ICFuKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdmFyIHIgPSBXbyhuKS50b3A7XG4gICAgICAgICAgICByZXR1cm4gdC5wYWdlWU9mZnNldCA+PSByIC0gKGYgfHwgMCk7XG4gICAgICAgIH07XG4gICAgICAgIHZhciB3biA9IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICB2YXIgbiA9IHVuKCk7XG4gICAgICAgICAgICB2YXIgdCA9IFdlLmN1cnJlbnQ7XG4gICAgICAgICAgICBpZiAoIXAgfHwgIUxlLmN1cnJlbnQgfHwgIXQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgciA9IHhvKHQpO1xuICAgICAgICAgICAgcmV0dXJuIHIuYm90dG9tID4gbi5pbm5lckhlaWdodCAmJiByLnRvcCA8IG4uaW5uZXJIZWlnaHQ7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBDbiA9IGZ1bmN0aW9uIGUobiwgbykge1xuICAgICAgICAgICAgaWYgKGduKCkpIHtcbiAgICAgICAgICAgICAgICAvLyBGSVhNRTogaGFuZGxlIGlubGluZVxuICAgICAgICAgICAgICAgIC8vIFNhdmUgdGhlIGN1cnJlbnQgaGVhZCBmb2N1cyBzdGF0ZSBzbyB0aGF0IGl0IGNhbiBiZSBhcHBsaWVkIHRvIHRoZSBkb2NrZWQgdmVyc2lvblxuICAgICAgICAgICAgICAgIC8vIGFmdGVyIHRoZSBgSGVhZFRhYmxlYCBtb3VudHMuXG4gICAgICAgICAgICAgICAgTWUuY3VycmVudCA9IEhvKHplLmN1cnJlbnQpO1xuICAgICAgICAgICAgICAgIGlmIChVID09PSB1bmRlZmluZWQgfHwgdWUgPT09IHVuZGVmaW5lZCB8fCBmZSA9PT0gdW5kZWZpbmVkIHx8IGJlID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB2YXIgaSA9ICAoMCwgdC5jbG9uZUVsZW1lbnQpKG4pO1xuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIHJldHVybiByKCkuY3JlYXRlRWxlbWVudChBciwge1xuICAgICAgICAgICAgICAgICAgICBoZWFkVHlwZTogXCJkb2NrZWRcIixcbiAgICAgICAgICAgICAgICAgICAgdEhlYWQ6IGksXG4gICAgICAgICAgICAgICAgICAgIGNlbGxXaWR0aHM6IFUsXG4gICAgICAgICAgICAgICAgICAgIGhvcml6b250YWxPZmZzZXQ6IEosXG4gICAgICAgICAgICAgICAgICAgIHRhYmxlV2lkdGg6IHVlLFxuICAgICAgICAgICAgICAgICAgICB0b3A6IGZlLFxuICAgICAgICAgICAgICAgICAgICB3aWR0aDogYmUsXG4gICAgICAgICAgICAgICAgICAgIHRhYmxlU3R5bGU6IEssXG4gICAgICAgICAgICAgICAgICAgIGlzRml4ZWRDb2x1bW46IG8sXG4gICAgICAgICAgICAgICAgICAgIG9uS2V5VXA6IGFuLFxuICAgICAgICAgICAgICAgICAgICBlbGVtZW50UmVmOiBvbixcbiAgICAgICAgICAgICAgICAgICAgaGFzRHJhZ0NvbHVtbjogISFPLFxuICAgICAgICAgICAgICAgICAgICBoYXNSb3dFeHBhbnNpb246ICQgIT09IFwibm9uZVwiLFxuICAgICAgICAgICAgICAgICAgICBoYXNSb3dTZWxlY3Rpb246ICEhRFxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9O1xuICAgICAgICB2YXIgeG4gPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICB2YXIgZSwgbiwgdDtcbiAgICAgICAgICAgIGlmICghX2UuY3VycmVudCB8fCAhemUuY3VycmVudCB8fCAhTGUuY3VycmVudCkge1xuICAgICAgICAgICAgICAgIHJldHVybiAwO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdmFyIHIgPSB1bigpO1xuICAgICAgICAgICAgdmFyIG8gPSAoZSA9IHhvKExlLmN1cnJlbnQpLnRvcCkgIT09IG51bGwgJiYgZSAhPT0gdm9pZCAwID8gZSA6IDA7XG4gICAgICAgICAgICB2YXIgaSA9IChuID0gKHQgPSB6ZS5jdXJyZW50KSA9PT0gbnVsbCB8fCB0ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB0Lm9mZnNldEhlaWdodCkgIT09IG51bGwgJiYgbiAhPT0gdm9pZCAwID8gbiA6IDA7XG4gICAgICAgICAgICB2YXIgYSA9IHIuaW5uZXJIZWlnaHQgLSBvIC0gaTtcbiAgICAgICAgICAgIHJldHVybiBNYXRoLm1pbihhIC0gX2UuY3VycmVudC5vZmZzZXRIZWlnaHQsIDApO1xuICAgICAgICB9KSwgW10pO1xuICAgICAgICB2YXIgU24gPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHdpZHRoOiBiZSxcbiAgICAgICAgICAgICAgICBtYXJnaW5Cb3R0b206IHhuXG4gICAgICAgICAgICB9O1xuICAgICAgICB9KSwgWyBiZSwgeG4gXSk7XG4gICAgICAgIHZhciBPbiA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgd2lkdGg6IHVlXG4gICAgICAgICAgICB9O1xuICAgICAgICB9KSwgWyB1ZSBdKTtcbiAgICAgICAgdmFyIGtuID0gZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIGlmICghd24oKSkge1xuICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFxuICAgICAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KG5lLCB7XG4gICAgICAgICAgICAgICAgc3R5bGU6IFNuLFxuICAgICAgICAgICAgICAgIG9uU2Nyb2xsOiBRZSxcbiAgICAgICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImRvY2tlZC1zY3JvbGwtYmFyXCIsXG4gICAgICAgICAgICAgICAgcmVmOiBfZVxuICAgICAgICAgICAgfSwgIHIoKS5jcmVhdGVFbGVtZW50KHRlLCB7XG4gICAgICAgICAgICAgICAgc3R5bGU6IE9uLFxuICAgICAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwiZG9ja2VkLXNjcm9sbC1jb250ZW50XCJcbiAgICAgICAgICAgIH0pKTtcbiAgICAgICAgfTtcbiAgICAgICAgdmFyIFJuID0gZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgIHZhciBuID0gemUuY3VycmVudDtcbiAgICAgICAgICAgIHZhciB0ID0gV2UuY3VycmVudDtcbiAgICAgICAgICAgIC8qKlxuICAgICAqIHRoZXJlIGlzIHNsaWdodGx5IGxlc3Mgc3BhY2UgZm9yIHRoZSB0YWJsZSB0aGFuIHRhYmxlQ29udGFpbmVyJ3Mgd2lkdGgsXG4gICAgICogYmVjYXVzZSB0aGVyZSBpcyBhIDEgcHggYm9yZGVyIGFkZGVkIHRvIGV2ZXJ5IGNvbHVtbiBidXQgdGhlIGZpcnN0XG4gICAgICovICAgICAgICAgICAgaWYgKG4pIHtcbiAgICAgICAgICAgICAgICB2YXIgciA9IFF0KHplLmN1cnJlbnQpO1xuICAgICAgICAgICAgICAgIHZhciBvID0gciA9PT0gbnVsbCB8fCByID09PSB2b2lkIDAgPyB2b2lkIDAgOiByLmxlbmd0aDtcbiAgICAgICAgICAgICAgICB2YXIgaSA9IHQgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5jbGllbnRXaWR0aDtcbiAgICAgICAgICAgICAgICBpZiAoaSAhPSBudWxsKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciBhID0gTWF0aC5tYXgoMCwgbyAtIDEpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gaSAtIGE7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH07XG4gICAgICAgIHZhciBFbjtcbiAgICAgICAgdmFyIEluO1xuICAgICAgICB2YXIgVG47XG4gICAgICAgIHZhciBqbiA9ICEhUjtcbiAgICAgICAgdC5DaGlsZHJlbi50b0FycmF5KGMpLmZvckVhY2goKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciBuID0gZS50eXBlLnNwbHVua1VpVHlwZTtcbiAgICAgICAgICAgIGlmIChuID09PSBcIlRhYmxlLkhlYWRcIikge1xuICAgICAgICAgICAgICAgIEVuID0gYm4oZSk7XG4gICAgICAgICAgICAgICAgLy8gQ2hlY2sgaWYgYWxsIEhlYWRDZWxscyBoYXZlIGEgZGVmaW5lZCB3aWR0aCAobWFraW5nIHRoZSB0YWJsZSBmaXhlZCB3aWR0aClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyIHIgPSB0LkNoaWxkcmVuLnRvQXJyYXkoZS5wcm9wcy5jaGlsZHJlbikuZmlsdGVyKHQuaXNWYWxpZEVsZW1lbnQpO1xuICAgICAgICAgICAgICAgIHZhciBvID0gci5ldmVyeSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gZS5wcm9wcy53aWR0aCAmJiBlLnByb3BzLndpZHRoICE9PSB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgIGpuID0gbztcbiAgICAgICAgICAgIH0gZWxzZSBpZiAobiA9PT0gXCJUYWJsZS5Cb2R5XCIpIHtcbiAgICAgICAgICAgICAgICBJbiA9IHluKGUpO1xuICAgICAgICAgICAgfSBlbHNlIGlmIChuID09PSBcIlRhYmxlLkNhcHRpb25cIikge1xuICAgICAgICAgICAgICAgIC8vIHRoZSBodG1sIHNwZWMgbWFuZGF0ZXMgdGhhdCBhIGNhcHRpb24gbXVzdCBiZSB0aGUgZmlyc3QgdGFibGUgY2hpbGQuXG4gICAgICAgICAgICAgICAgLy8gY2F0Y2ggdGhlIGNhcHRpb24gaGVyZSBzbyB0aGF0IGl0IGNhbiBiZSBwbGFjZWQgZmlyc3QgbGF0ZXIuIG5vdGU6IGFcbiAgICAgICAgICAgICAgICAvLyBjYXB0aW9uIGNhbiBiZSBwbGFjZWQgb24gdGhlIGJvdHRvbSBzaWRlIG9mIGEgdGFibGUgYnkgYWRqdXN0aW5nIHRoZVxuICAgICAgICAgICAgICAgIC8vIGNhcHRpb24ncyBzaWRlIHByb3AuXG4gICAgICAgICAgICAgICAgVG4gPSBlO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSk7XG4gICAgICAgIFNvKEVuLCBcIkEgVGFibGUuSGVhZCBpcyByZXF1aXJlZC5cIik7XG4gICAgICAgIHZhciBEbiA9IENuKEVuLCBqbik7XG4gICAgICAgIC8vIFdoZW4gYSBgaGVhZFRhYmxlYCBpcyB1c2VkLCBzdXBwcmVzcyBmb2N1cyBpbnRlcmFjdGlvbnMgaW4gdGhlIHByaW1hcnkgYEhlYWRgLiBGb2N1c1xuICAgICAgICAvLyBpbnRlcmFjdGlvbnMgd2lsbCBiZSBoYW5kbGVkIGJ5IHRoZSBvdmVybGFpZCBgaGVhZFRhYmxlYCBpbnN0ZWFkLlxuICAgICAgICAgICAgICAgIHZhciBxbiA9IHQuQ2hpbGRyZW4udG9BcnJheShFbi5wcm9wcy5jaGlsZHJlbikuZmlsdGVyKHQuaXNWYWxpZEVsZW1lbnQpLm1hcCgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgXG4gICAgICAgICAgICAvLyBUUzogb25DbGljayBpcyBkaWZmZXJlbnQgZm9yIHJlZ3VsYXIvZHJvcGRvd24gaGVhZCBjZWxscywgdGhhdCdzIG9rXG4gICAgICAgICAgICByZXR1cm4gKDAsIHQuY2xvbmVFbGVtZW50KShlLCB7XG4gICAgICAgICAgICAgICAgdmlzaWJsZTogIURuXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSkpO1xuICAgICAgICBFbiA9ICAoMCwgdC5jbG9uZUVsZW1lbnQpKEVuLCB7fSwgcW4pO1xuICAgICAgICB2YXIgQW4gPSBnZSB8fCB1bigpO1xuICAgICAgICB2YXIgUG4gPSBMbyhnKSA/IFdlLmN1cnJlbnQgOiBBbjtcbiAgICAgICAgaWYgKHopIHtcbiAgICAgICAgICAgIGpuID0gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIF9uID0gUm4oKTtcbiAgICAgICAgdmFyIHpuID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBoZWFkVHlwZTogZyxcbiAgICAgICAgICAgICAgICByZXNpemFibGVGaWxsTGF5b3V0OiB6LFxuICAgICAgICAgICAgICAgIHRhYmxlQ29udGFpbmVyV2lkdGhXaXRob3V0Qm9yZGVyczogX25cbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIGcsIHosIF9uIF0pO1xuICAgICAgICB2YXIgTW4gPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoIU8pIHtcbiAgICAgICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgICAgICBvbkRyYWdTdGFydDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIG9uRHJhZ092ZXI6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBvbkRyYWdFbmQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBvbkRyYWdDYW5jZWw6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgb25EcmFnU3RhcnQ6IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgICAgICAgICB2YXIgdCA9IG4uYWN0aXZlLmlkO1xuICAgICAgICAgICAgICAgICAgICBpZiAodCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIHZhciByID0gS28oVWUsIHQpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gdHlwZW9mIHIgPT09IFwibnVtYmVyXCIgPyAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIlBpY2tlZCB1cCBzb3J0YWJsZSByb3cgaW4gcG9zaXRpb24gJShwb3MpZCBvZiAlKHRvdGFsKWQuXCIpLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwb3M6IHIsXG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RhbDogVWUubGVuZ3RoXG4gICAgICAgICAgICAgICAgICAgIH0pIDogdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25EcmFnT3ZlcjogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciB0ID0gbi5hY3RpdmUsIHIgPSBuLm92ZXI7XG4gICAgICAgICAgICAgICAgICAgIGlmICh5ZS5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB5ZS5jdXJyZW50ID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIGlmICghdC5pZCB8fCAhKHIgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5pZCkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgdmFyIG8gPSBLbyhVZSwgdC5pZCk7XG4gICAgICAgICAgICAgICAgICAgIHZhciBpID0gS28oVWUsIHIuaWQpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gKDAsIEkuc3ByaW50ZikoKDAsIFQuXykoXCJSb3cgbW92ZWQgZnJvbSBwb3NpdGlvbiAlKGZyb20pZCB0byBwb3NpdGlvbiAlKHRvKWQgb2YgJSh0b3RhbClkLlwiKSwge1xuICAgICAgICAgICAgICAgICAgICAgICAgZnJvbTogbyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHRvOiBpLFxuICAgICAgICAgICAgICAgICAgICAgICAgdG90YWw6IFVlLmxlbmd0aFxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIG9uRHJhZ0VuZDogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciB0ID0gbi5vdmVyO1xuICAgICAgICAgICAgICAgICAgICBpZiAoISh0ID09PSBudWxsIHx8IHQgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHQuaWQpKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIHZhciByID0gS28oVWUsIHQuaWQpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gdHlwZW9mIHIgPT09IFwibnVtYmVyXCIgPyAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIlJvdyBkcm9wcGVkIGF0IHBvc2l0aW9uICUocG9zKWQgb2YgJSh0b3RhbClkLlwiKSwge1xuICAgICAgICAgICAgICAgICAgICAgICAgcG9zOiByLFxuICAgICAgICAgICAgICAgICAgICAgICAgdG90YWw6IFVlLmxlbmd0aFxuICAgICAgICAgICAgICAgICAgICB9KSA6IHVuZGVmaW5lZDtcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIG9uRHJhZ0NhbmNlbDogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciB0ID0gbi5hY3RpdmUuaWQ7XG4gICAgICAgICAgICAgICAgICAgIGlmICh0ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgdmFyIHIgPSBLbyhVZSwgdCk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiB0eXBlb2YgciA9PT0gXCJudW1iZXJcIiA/ICgwLCBJLnNwcmludGYpKCgwLCBULl8pKFwiUm93IHJldHVybmVkIHRvIGl0cyBzdGFydGluZyBwb3NpdGlvbiBvZiAlKHBvcylkLlwiKSwge1xuICAgICAgICAgICAgICAgICAgICAgICAgcG9zOiByXG4gICAgICAgICAgICAgICAgICAgIH0pIDogdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pLCBbIFVlLCBPIF0pO1xuICAgICAgICB2YXIgJG4gPSAoMCwgdC51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoIUMpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgICAgICBvbkRyYWdTdGFydDogZnVuY3Rpb24gZSgpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIG9uRHJhZ092ZXI6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBvbkRyYWdFbmQ6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBvbkRyYWdDYW5jZWw6IGZ1bmN0aW9uIGUoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgb25EcmFnU3RhcnQ6IGZ1bmN0aW9uIGUobikge1xuICAgICAgICAgICAgICAgICAgICB2YXIgdCA9IG4uYWN0aXZlLmlkO1xuICAgICAgICAgICAgICAgICAgICBpZiAodCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIHZhciByID0gQm8oWWUsIHQpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gdHlwZW9mIHIgPT09IFwibnVtYmVyXCIgPyAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIlBpY2tlZCB1cCBzb3J0YWJsZSBjb2x1bW4gaW4gcG9zaXRpb24gJShwb3MpZCBvZiAlKHRvdGFsKWQuXCIpLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwb3M6IHIsXG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RhbDogWWUubGVuZ3RoXG4gICAgICAgICAgICAgICAgICAgIH0pIDogdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25EcmFnT3ZlcjogZnVuY3Rpb24gZShuKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciB0ID0gbi5hY3RpdmUsIHIgPSBuLm92ZXI7XG4gICAgICAgICAgICAgICAgICAgIGlmICh5ZS5jdXJyZW50KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB5ZS5jdXJyZW50ID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIGlmICghdC5pZCB8fCAhKHIgPT09IG51bGwgfHwgciA9PT0gdm9pZCAwID8gdm9pZCAwIDogci5pZCkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgdmFyIG8gPSBCbyhZZSwgdC5pZCk7XG4gICAgICAgICAgICAgICAgICAgIHZhciBpID0gQm8oWWUsIHIuaWQpO1xuICAgICAgICAgICAgICAgICAgICBpZiAodHlwZW9mIG8gIT09IFwibnVtYmVyXCIgfHwgdHlwZW9mIGkgIT09IFwibnVtYmVyXCIpIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiAoMCwgSS5zcHJpbnRmKSgoMCwgVC5fKShcIkNvbHVtbiBtb3ZlZCBmcm9tIHBvc2l0aW9uICUoZnJvbSlkIHRvIHBvc2l0aW9uICUodG8pZCBvZiAlKHRvdGFsKWQuXCIpLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBmcm9tOiBvLFxuICAgICAgICAgICAgICAgICAgICAgICAgdG86IGksXG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RhbDogWWUubGVuZ3RoXG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25EcmFnRW5kOiBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgICAgICAgICAgICAgdmFyIHQgPSBuLm92ZXI7XG4gICAgICAgICAgICAgICAgICAgIGlmICghKHQgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5pZCkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgdmFyIHIgPSBCbyhZZSwgdC5pZCk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiB0eXBlb2YgciA9PT0gXCJudW1iZXJcIiA/ICgwLCBJLnNwcmludGYpKCgwLCBULl8pKFwiQ29sdW1uIGRyb3BwZWQgYXQgcG9zaXRpb24gJShwb3MpZCBvZiAlKHRvdGFsKWQuXCIpLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwb3M6IHIsXG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RhbDogWWUubGVuZ3RoXG4gICAgICAgICAgICAgICAgICAgIH0pIDogdW5kZWZpbmVkO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25EcmFnQ2FuY2VsOiBmdW5jdGlvbiBlKG4pIHtcbiAgICAgICAgICAgICAgICAgICAgdmFyIHQgPSBuLmFjdGl2ZS5pZDtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHQgPT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB2YXIgciA9IEJvKFllLCB0KTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHR5cGVvZiByID09PSBcIm51bWJlclwiID8gKDAsIEkuc3ByaW50ZikoKDAsIFQuXykoXCJDb2x1bW4gcmV0dXJuZWQgdG8gaXRzIHN0YXJ0aW5nIHBvc2l0aW9uIG9mICUocG9zKWQuXCIpLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwb3M6IHJcbiAgICAgICAgICAgICAgICAgICAgfSkgOiB1bmRlZmluZWQ7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgWWUsIEMgXSk7XG4gICAgICAgIHZhciBObiA9ICgwLCB0LnVzZU1lbW8pKChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgc2NyZWVuUmVhZGVySW5zdHJ1Y3Rpb25zOiBPID8gRm8gOiBVbyxcbiAgICAgICAgICAgICAgICBhbm5vdW5jZW1lbnRzOiBPID8gTW4gOiAkblxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFsgTW4sICRuLCBPIF0pO1xuICAgICAgICB2YXIgTG4gPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIHZhciBuID0gZS5hY3RpdmUuaWQ7XG4gICAgICAgICAgICBpZiAobi5zdGFydHNXaXRoKFwiY29sLVwiKSAmJiBDKSB7XG4gICAgICAgICAgICAgICAgT2UoWyBpLnJlc3RyaWN0VG9Ib3Jpem9udGFsQXhpcyBdKTtcbiAgICAgICAgICAgICAgICBzbihlKTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAobi5zdGFydHNXaXRoKFwicm93LVwiKSAmJiBPKSB7XG4gICAgICAgICAgICAgICAgT2UoWyBpLnJlc3RyaWN0VG9WZXJ0aWNhbEF4aXMgXSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIEMsIE8sIHNuIF0pO1xuICAgICAgICB2YXIgV24gPSAoMCwgdC51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIE9lKFtdKTtcbiAgICAgICAgICAgIHZhciBuID0gZS5hY3RpdmUuaWQ7XG4gICAgICAgICAgICBpZiAobi5zdGFydHNXaXRoKFwiY29sLVwiKSAmJiBDKSB7XG4gICAgICAgICAgICAgICAgZm4oZSk7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKG4uc3RhcnRzV2l0aChcInJvdy1cIikgJiYgTykge1xuICAgICAgICAgICAgICAgIHZuKGUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBmbiwgdm4sIEMsIE8gXSk7XG4gICAgICAgIHZhciBIbiA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgdmFyIG4gPSBlLmFjdGl2ZS5pZDtcbiAgICAgICAgICAgIGlmIChuLnN0YXJ0c1dpdGgoXCJjb2wtXCIpICYmIEMpIHtcbiAgICAgICAgICAgICAgICBkbihlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSksIFsgZG4sIEMgXSk7XG4gICAgICAgIHZhciBLbiA9ICgwLCB0LnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgT2UoW10pO1xuICAgICAgICAgICAgdmFyIG4gPSBlLmFjdGl2ZS5pZDtcbiAgICAgICAgICAgIGlmIChuLnN0YXJ0c1dpdGgoXCJyb3ctXCIpICYmIE8pIHtcbiAgICAgICAgICAgICAgICBwbigpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSwgWyBwbiwgTyBdKTtcbiAgICAgICAgdmFyIEJuID0gKDAsIHQudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgcmV0dXJuIGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgICAgICB2YXIgbiA9ICgwLCBvLnBvaW50ZXJXaXRoaW4pKGUpO1xuICAgICAgICAgICAgICAgIC8vIENvbGxpc2lvbiBkZXRlY3Rpb24gYWxnb3JpdGhtcyByZXR1cm4gYW4gYXJyYXkgb2YgY29sbGlzaW9uc1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAobi5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAvLyBJZiB0aGVyZSBhcmUgbm8gY29sbGlzaW9ucyB3aXRoIHRoZSBwb2ludGVyLCByZXR1cm4gcmVjdGFuZ2xlIGludGVyc2VjdGlvbnNcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuICgwLCBvLnJlY3RJbnRlcnNlY3Rpb24pKGUpO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgfSksIFtdKTtcbiAgICAgICAgdmFyIFZuID0gQWUgPyBtbi5jdXJyZW50W0FlXSA6IG51bGw7XG4gICAgICAgIHZhciBGbiA9IFZuID8geG8oVm4pLndpZHRoIDogdW5kZWZpbmVkO1xuICAgICAgICB2YXIgVW4gPSBXZS5jdXJyZW50ID8geG8oV2UuY3VycmVudCkuaGVpZ2h0IDogdW5kZWZpbmVkO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIHIoKS5jcmVhdGVFbGVtZW50KFEsIE9vKHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwidGFibGVcIixcbiAgICAgICAgICAgIHJlZjogbSxcbiAgICAgICAgICAgIHN0eWxlOiBBLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3Qtcm93LXNlbGVjdGlvblwiOiBEID8gVyA6IHVuZGVmaW5lZFxuICAgICAgICB9LCBiKCkoQiwgW10uY29uY2F0KGtvKE9iamVjdC5rZXlzKE1vKSksIFsgXCJzdHlsZVwiIF0pKSksICByKCkuY3JlYXRlRWxlbWVudCh4KCksIHtcbiAgICAgICAgICAgIHRhcmdldDogdW4oKSxcbiAgICAgICAgICAgIGV2ZW50VHlwZTogXCJzY3JvbGxcIixcbiAgICAgICAgICAgIGxpc3RlbmVyOiBaZSxcbiAgICAgICAgICAgIG9wdGlvbnM6IFlvXG4gICAgICAgIH0pLCAgcigpLmNyZWF0ZUVsZW1lbnQoSHQuUHJvdmlkZXIsIHtcbiAgICAgICAgICAgIHZhbHVlOiB6blxuICAgICAgICB9LCBEbiwgIHIoKS5jcmVhdGVFbGVtZW50KFosIHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwic2Nyb2xsLWNvbnRhaW5lclwiLFxuICAgICAgICAgICAgb25TY3JvbGw6IEplLFxuICAgICAgICAgICAgcmVmOiBXZSxcbiAgICAgICAgICAgIHN0eWxlOiB3LFxuICAgICAgICAgICAgJGRyYWdnaW5nOiAhIUFlXG4gICAgICAgIH0sICByKCkuY3JlYXRlRWxlbWVudChTLlNjcm9sbENvbnRhaW5lclByb3ZpZGVyLCB7XG4gICAgICAgICAgICB2YWx1ZTogUG5cbiAgICAgICAgfSwgIHIoKS5jcmVhdGVFbGVtZW50KG8uRG5kQ29udGV4dCwge1xuICAgICAgICAgICAgYWNjZXNzaWJpbGl0eTogTm4sXG4gICAgICAgICAgICBjb2xsaXNpb25EZXRlY3Rpb246IEJuLFxuICAgICAgICAgICAgbW9kaWZpZXJzOiBTZSxcbiAgICAgICAgICAgIG9uRHJhZ0NhbmNlbDogS24sXG4gICAgICAgICAgICBvbkRyYWdFbmQ6IFduLFxuICAgICAgICAgICAgb25EcmFnT3ZlcjogSG4sXG4gICAgICAgICAgICBvbkRyYWdTdGFydDogTG4sXG4gICAgICAgICAgICBzZW5zb3JzOiB3ZVxuICAgICAgICB9LCAgcigpLmNyZWF0ZUVsZW1lbnQoZWUsIHtcbiAgICAgICAgICAgIHJlZjogTGUsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcIm1haW4tdGFibGVcIixcbiAgICAgICAgICAgIHN0eWxlOiBLLFxuICAgICAgICAgICAgXCJkYXRhLWZpeGVkLWNvbHVtblwiOiBqbiA/IFwidHJ1ZVwiIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgJHJlc2l6YWJsZUZpbGxMYXlvdXQ6IHpcbiAgICAgICAgfSwgVG4sIEMgPyAgcigpLmNyZWF0ZUVsZW1lbnQoYS5Tb3J0YWJsZUNvbnRleHQsIHtcbiAgICAgICAgICAgIGl0ZW1zOiBZZSxcbiAgICAgICAgICAgIHN0cmF0ZWd5OiBhLmhvcml6b250YWxMaXN0U29ydGluZ1N0cmF0ZWd5XG4gICAgICAgIH0sIEVuKSA6IEVuLCBPID8gIHIoKS5jcmVhdGVFbGVtZW50KGEuU29ydGFibGVDb250ZXh0LCB7XG4gICAgICAgICAgICBpdGVtczogVWUsXG4gICAgICAgICAgICBzdHJhdGVneTogYS52ZXJ0aWNhbExpc3RTb3J0aW5nU3RyYXRlZ3lcbiAgICAgICAgfSwgSW4pIDogSW4pLCBBZSAmJiAgcigpLmNyZWF0ZUVsZW1lbnQoby5EcmFnT3ZlcmxheSwgbnVsbCwgIHIoKS5jcmVhdGVFbGVtZW50KG9lLCB7XG4gICAgICAgICAgICAkd2lkdGg6IEZuLFxuICAgICAgICAgICAgJGhlaWdodDogVW5cbiAgICAgICAgfSkpLCBBZSAmJiBobikpKSwga24oKSkpO1xuICAgIH1cbiAgICBKby5wcm9wVHlwZXMgPSBNbztcbiAgICBKby5Cb2R5ID0gSjtcbiAgICBKby5DYXB0aW9uID0gZGU7XG4gICAgSm8uQ2VsbCA9IHhlO1xuICAgIEpvLkhlYWQgPSBlcjtcbiAgICBKby5IZWFkQ2VsbCA9IHpuO1xuICAgIEpvLkhlYWREcm9wZG93bkNlbGwgPSB4cjtcbiAgICBKby5Sb3cgPSBMdDtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IFFvID0gSm87XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvVGFibGUvaW5kZXgudHNcbiAgICBtb2R1bGUuZXhwb3J0cyA9IG47XG4gICAgLyoqKioqKi99KSgpOyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///2426\n\n}')},2571:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("{\nvar race_1 = __webpack_require__(79896);\n// NOTE: to support backwards compatability with 5.4.* and lower\nvar race_2 = __webpack_require__(2944);\nexports.raceStatic = race_2.race;\n/* tslint:enable:max-line-length */\n/**\n * Returns an Observable that mirrors the first source Observable to emit an item\n * from the combination of this Observable and supplied Observables.\n * @param {...Observables} ...observables Sources used to race for which Observable emits first.\n * @return {Observable} An Observable that mirrors the output of the first Observable to emit an item.\n * @method race\n * @owner Observable\n */\nfunction race() {\n    var observables = [];\n    for (var _i = 0; _i < arguments.length; _i++) {\n        observables[_i - 0] = arguments[_i];\n    }\n    return race_1.race.apply(void 0, observables)(this);\n}\nexports.race = race;\n//# sourceMappingURL=race.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjU3MS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLGFBQWEsbUJBQU8sQ0FBQyxLQUFtQjtBQUN4QztBQUNBLGFBQWEsbUJBQU8sQ0FBQyxJQUFvQjtBQUN6QyxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLGdCQUFnQjtBQUMzQixZQUFZLFlBQVk7QUFDeEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQix1QkFBdUI7QUFDNUM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZO0FBQ1oiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvb3BlcmF0b3IvcmFjZS5qcz82NmRmIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xudmFyIHJhY2VfMSA9IHJlcXVpcmUoJy4uL29wZXJhdG9ycy9yYWNlJyk7XG4vLyBOT1RFOiB0byBzdXBwb3J0IGJhY2t3YXJkcyBjb21wYXRhYmlsaXR5IHdpdGggNS40LiogYW5kIGxvd2VyXG52YXIgcmFjZV8yID0gcmVxdWlyZSgnLi4vb2JzZXJ2YWJsZS9yYWNlJyk7XG5leHBvcnRzLnJhY2VTdGF0aWMgPSByYWNlXzIucmFjZTtcbi8qIHRzbGludDplbmFibGU6bWF4LWxpbmUtbGVuZ3RoICovXG4vKipcbiAqIFJldHVybnMgYW4gT2JzZXJ2YWJsZSB0aGF0IG1pcnJvcnMgdGhlIGZpcnN0IHNvdXJjZSBPYnNlcnZhYmxlIHRvIGVtaXQgYW4gaXRlbVxuICogZnJvbSB0aGUgY29tYmluYXRpb24gb2YgdGhpcyBPYnNlcnZhYmxlIGFuZCBzdXBwbGllZCBPYnNlcnZhYmxlcy5cbiAqIEBwYXJhbSB7Li4uT2JzZXJ2YWJsZXN9IC4uLm9ic2VydmFibGVzIFNvdXJjZXMgdXNlZCB0byByYWNlIGZvciB3aGljaCBPYnNlcnZhYmxlIGVtaXRzIGZpcnN0LlxuICogQHJldHVybiB7T2JzZXJ2YWJsZX0gQW4gT2JzZXJ2YWJsZSB0aGF0IG1pcnJvcnMgdGhlIG91dHB1dCBvZiB0aGUgZmlyc3QgT2JzZXJ2YWJsZSB0byBlbWl0IGFuIGl0ZW0uXG4gKiBAbWV0aG9kIHJhY2VcbiAqIEBvd25lciBPYnNlcnZhYmxlXG4gKi9cbmZ1bmN0aW9uIHJhY2UoKSB7XG4gICAgdmFyIG9ic2VydmFibGVzID0gW107XG4gICAgZm9yICh2YXIgX2kgPSAwOyBfaSA8IGFyZ3VtZW50cy5sZW5ndGg7IF9pKyspIHtcbiAgICAgICAgb2JzZXJ2YWJsZXNbX2kgLSAwXSA9IGFyZ3VtZW50c1tfaV07XG4gICAgfVxuICAgIHJldHVybiByYWNlXzEucmFjZS5hcHBseSh2b2lkIDAsIG9ic2VydmFibGVzKSh0aGlzKTtcbn1cbmV4cG9ydHMucmFjZSA9IHJhY2U7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1yYWNlLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///2571\n\n}")},2748:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar OuterSubscriber_1 = __webpack_require__(234);\nvar subscribeToResult_1 = __webpack_require__(740);\n/**\n * Emits the values emitted by the source Observable until a `notifier`\n * Observable emits a value.\n *\n * <span class="informal">Lets values pass until a second Observable,\n * `notifier`, emits something. Then, it completes.</span>\n *\n * <img src="./img/takeUntil.png" width="100%">\n *\n * `takeUntil` subscribes and begins mirroring the source Observable. It also\n * monitors a second Observable, `notifier` that you provide. If the `notifier`\n * emits a value or a complete notification, the output Observable stops\n * mirroring the source Observable and completes.\n *\n * @example <caption>Tick every second until the first click happens</caption>\n * var interval = Rx.Observable.interval(1000);\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var result = interval.takeUntil(clicks);\n * result.subscribe(x => console.log(x));\n *\n * @see {@link take}\n * @see {@link takeLast}\n * @see {@link takeWhile}\n * @see {@link skip}\n *\n * @param {Observable} notifier The Observable whose first emitted value will\n * cause the output Observable of `takeUntil` to stop emitting values from the\n * source Observable.\n * @return {Observable<T>} An Observable that emits the values from the source\n * Observable until such time as `notifier` emits its first value.\n * @method takeUntil\n * @owner Observable\n */\nfunction takeUntil(notifier) {\n    return function (source) { return source.lift(new TakeUntilOperator(notifier)); };\n}\nexports.takeUntil = takeUntil;\nvar TakeUntilOperator = (function () {\n    function TakeUntilOperator(notifier) {\n        this.notifier = notifier;\n    }\n    TakeUntilOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new TakeUntilSubscriber(subscriber, this.notifier));\n    };\n    return TakeUntilOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar TakeUntilSubscriber = (function (_super) {\n    __extends(TakeUntilSubscriber, _super);\n    function TakeUntilSubscriber(destination, notifier) {\n        _super.call(this, destination);\n        this.notifier = notifier;\n        this.add(subscribeToResult_1.subscribeToResult(this, notifier));\n    }\n    TakeUntilSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {\n        this.complete();\n    };\n    TakeUntilSubscriber.prototype.notifyComplete = function () {\n        // noop\n    };\n    return TakeUntilSubscriber;\n}(OuterSubscriber_1.OuterSubscriber));\n//# sourceMappingURL=takeUntil.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///2748\n\n}')},2789:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar mergeAll_1 = __webpack_require__(83737);\nObservable_1.Observable.prototype.mergeAll = mergeAll_1.mergeAll;\n//# sourceMappingURL=mergeAll.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjc4OS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLGlCQUFpQixtQkFBTyxDQUFDLEtBQXlCO0FBQ2xEO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvYWRkL29wZXJhdG9yL21lcmdlQWxsLmpzPzQwYWUiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgT2JzZXJ2YWJsZV8xID0gcmVxdWlyZSgnLi4vLi4vT2JzZXJ2YWJsZScpO1xudmFyIG1lcmdlQWxsXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9tZXJnZUFsbCcpO1xuT2JzZXJ2YWJsZV8xLk9ic2VydmFibGUucHJvdG90eXBlLm1lcmdlQWxsID0gbWVyZ2VBbGxfMS5tZXJnZUFsbDtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPW1lcmdlQWxsLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///2789\n\n}")},2841:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("{\n/**\n * @file\n * Number and String format utilities.\n */\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.sprintf = sprintf;\nexports.abbreviateNumber = abbreviateNumber;\nexports.bytesToFileSize = bytesToFileSize;\nexports.smartTrim = smartTrim;\nconst lodash_1 = __webpack_require__(48808);\nconst i18n_1 = __webpack_require__(41454);\nconst math_1 = __webpack_require__(65776);\nconst sprintf_1 = __webpack_require__(78358);\n/**\n * Returns a formatted string.\n *\n * ```js\n * const text = sprintf('%1$s %2$s a %3$s', 'Polly', 'wants', 'cracker') // 'Polly wants a cracker'\n * ```\n *\n * #### Format Specification\n * The placeholders in the format string are marked by `%` and are followed by one or more of these elements, in this order:\n *\n * * An optional number followed by a `$` sign that selects which argument index to use for the value. If not specified, arguments are placed in the same order as the placeholders in the input string.\n * * An optional `+` sign that forces to preceed the result with a plus or minus sign on numeric values. By default, only the `-` sign is used on negative numbers.\n * * An optional padding specifier that says what character to use for padding, if specified. Possible values are `0` or any other character preceded by a (`'`) (single quote). The default is to pad with *spaces*.\n * * An optional `-` sign that causes `sprintf` to left-align the result of this placeholder. The default is to right-align the result.\n * * An optional number that says how many characters the result has. If the value to be returned is shorter than this number, the result is padded. When used with the `j` (JSON) type specifier, the padding length specifies the tab size used for indentation.\n * * An optional precision modifier, consisting of a `.` (dot) followed by a number, that says how many digits are displayed for floating point numbers. When used with the `g` type specifier, it specifies the number of significant digits. When used on a string, it causes the result to be truncated.\n * * A type specifier that can be any of the following:\n *     * `%` — yields a literal `%` character\n *     * `b` — yields an integer as a binary number\n *     * `c` — yields an integer as the character with that ASCII value\n *     * `d` or `i` — yields an integer as a signed decimal number\n *     * `e` — yields a float using scientific notation\n *     * `u` — yields an integer as an unsigned decimal number\n *     * `f` — yields a float as is; see notes on precision above\n *     * `g` — yields a float as is; see notes on precision above\n *     * `o` — yields an integer as an octal number\n *     * `s` — yields a string as is\n *     * `t` — yields `true` or `false`\n *     * `T` — yields the type of the argument<sup><a href=\"#fn-1\" name=\"fn-ref-1\">1</a></sup>\n *     * `v` — yields the primitive value of the specified argument\n *     * `x` — yields an integer as a hexadecimal number (lower-case)\n *     * `X` — yields an integer as a hexadecimal number (upper-case)\n *     * `j` — yields a JavaScript object or array as a JSON encoded string\n *\n * This utility was adapted from [Alexandru's sprintf-js implementation](https://github.com/alexei/sprintf.js).\n *\n * @param {string} fmt - The string to format and insert values into.\n * @param {Any} values - The values to insert into the format string. See specification above.\n * @public\n */\nfunction sprintf(key, ...rest) {\n    return (0, sprintf_1.sprintfFormat)((0, sprintf_1.sprintfParse)(key), [key, ...rest]);\n}\n/**\n * Abbreviates a number by rounding to no more than three decimal places and by appending a\n * suffix: K/M/B. Additionally, the resulting number is formatted using a given locale.\n *\n * Examples:\n *   * `99549` returns `99.5K`\n *   * `1159000` returns `1.16M`\n *   * `9500`, `de-de` returns `9,5K`\n *\n * @param {Number|String} number The number to abbreviate.\n * @param {String} [locale='en-us']\n * @returns {String} The abbreviated and localized number if `number` is positive. The localized\n *  number if negative.\n * @public\n */\nfunction abbreviateNumber(number, locale = 'en-us') {\n    const value = (0, lodash_1.toNumber)(number);\n    if (value <= 1000) {\n        return value.toLocaleString(locale);\n    }\n    if (value < 10000) {\n        return sprintf((0, i18n_1._)('%sK'), (0, math_1.roundToDecimal)(value / 1000, -2).toLocaleString(locale));\n    }\n    if (value < 100000) {\n        return sprintf((0, i18n_1._)('%sK'), (0, math_1.roundToDecimal)(value / 1000, -1).toLocaleString(locale));\n    }\n    if (value < 999500) {\n        return sprintf((0, i18n_1._)('%sK'), (0, math_1.roundToDecimal)(value / 1000, 0).toLocaleString(locale));\n    }\n    if (value < 10000000) {\n        return sprintf((0, i18n_1._)('%sM'), (0, math_1.roundToDecimal)(value / 1000000, -2).toLocaleString(locale));\n    }\n    if (value < 100000000) {\n        return sprintf((0, i18n_1._)('%sM'), (0, math_1.roundToDecimal)(value / 1000000, -1).toLocaleString(locale));\n    }\n    if (value < 999500000) {\n        return sprintf((0, i18n_1._)('%sM'), (0, math_1.roundToDecimal)(value / 1000000, 0).toLocaleString(locale));\n    }\n    if (value < 10000000000) {\n        return sprintf((0, i18n_1._)('%sB'), (0, math_1.roundToDecimal)(value / 1000000000, -2).toLocaleString(locale));\n    }\n    if (value < 100000000000) {\n        return sprintf((0, i18n_1._)('%sB'), (0, math_1.roundToDecimal)(value / 1000000000, -1).toLocaleString(locale));\n    }\n    return sprintf((0, i18n_1._)('%sB'), (0, math_1.roundToDecimal)(value / 1000000000, 0).toLocaleString(locale));\n}\n/**\n * Abbreviates a number by rounding to no more than two decimal places and by converting to\n * binary prefixes (B/KB/MB/GB/TB). Additionally, the resulting number is formatted using a\n * given locale.\n *\n * Examples:\n *   * `100` returns `100 B`\n *   * `1200` returns `1.17 KB`\n *   * `96619136`, `de-de` returns `92,14 MB`\n *\n * @param  {Number|String} bytes The number of bytes to abbreviate.\n * @param  {String} [locale='en-us']\n * @throws {RangeError} If `bytes` is less than zero.\n * @return {String} The abbreviated and localized number.\n * @public\n */\nfunction bytesToFileSize(bytes, locale = 'en-us') {\n    const bytesNum = (0, lodash_1.toNumber)(bytes);\n    const kbFileSize = (bytesNum || 0) / 1024;\n    if (kbFileSize < 0) {\n        throw new RangeError('bytes must be >= 0');\n    }\n    if (Math.floor(kbFileSize) === 0) {\n        return sprintf((0, i18n_1._)('%s B'), bytes.toLocaleString(locale));\n    }\n    const mbFileSize = kbFileSize / 1024;\n    if (Math.floor(mbFileSize) === 0) {\n        return sprintf((0, i18n_1._)('%s KB'), (0, math_1.roundToDecimal)(kbFileSize, -2).toLocaleString(locale));\n    }\n    const gbFileSize = mbFileSize / 1024;\n    if (Math.floor(gbFileSize) === 0) {\n        return sprintf((0, i18n_1._)('%s MB'), (0, math_1.roundToDecimal)(mbFileSize, -2).toLocaleString(locale));\n    }\n    const tbFileSize = gbFileSize / 1024;\n    if (Math.floor(tbFileSize) === 0) {\n        return sprintf((0, i18n_1._)('%s GB'), (0, math_1.roundToDecimal)(gbFileSize, -2).toLocaleString(locale));\n    }\n    return sprintf((0, i18n_1._)('%s TB'), (0, math_1.roundToDecimal)(tbFileSize, -2).toLocaleString(locale));\n}\n/**\n * Trim a String by replacing characters in the middle with an ellipsis.\n *\n * Examples:\n *   * `1234567890`, `7` returns `123...7890`\n *   * `1234567890`, `10` returns `1234567890`\n *   * `1234567890`, `50` returns `1234567890`\n *   * `1234567890`, `2`, `{ precomposed: true }` returns `1…0`\n *\n * @param {String} string The input string.\n * @param {Number} maxCharsFromString How many characters to take from `string`.\n * @param {Object} [options] * `precomposed`: Use one ellipsis character (…)\n *  instead of three periods. Defaults to `false`.\n * @return {String} The trimmed result. Note that the total length might be up to three characters\n *  more than `maxCharsFromString`. If `string` is falsy or if `maxCharsFromString` is less than 1,\n *  `string` is returned.\n * @public\n */\nfunction smartTrim(string, maxCharsFromString, { precomposed = false } = {}) {\n    if (!string || maxCharsFromString < 1 || string.length <= maxCharsFromString) {\n        return string;\n    }\n    const ellipsis = precomposed ? '…' : '...';\n    if (maxCharsFromString === 1) {\n        return `${string[0]}${ellipsis}`;\n    }\n    const midpoint = Math.ceil(string.length / 2);\n    const toRemove = string.length - maxCharsFromString;\n    const lstrip = Math.ceil(toRemove / 2);\n    const rstrip = toRemove - lstrip;\n    return `${string.substring(0, midpoint - lstrip)}${ellipsis}${string.substring(midpoint + rstrip)}`;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///2841\n\n}")},2895:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\n\nObject.defineProperty(exports, "__esModule", ({\n  value: true\n}));\nexports.clearGetThemeCache = exports["default"] = void 0;\nvar _memoize = _interopRequireDefault(__webpack_require__(85741));\nvar _enterprise = _interopRequireDefault(__webpack_require__(47558));\nvar _prisma = _interopRequireDefault(__webpack_require__(57337));\nvar _utils = __webpack_require__(30281);\nfunction _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }\nfunction _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }\nfunction ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }\nfunction _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }\nfunction _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }\nfunction _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }\nfunction _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }\n/**\n * **NOTE:** Use cases for this function are limited. Instead, use `useSplunkTheme` in React components and `variables` in styled-components\' CSS.\n * This function is for use outside of React and styled-components.\n * @file\n */\n\n/**\n * The `getTheme` function returns all theme variables for a given theme. This function is memoized.\n *\n * ```js\n * import getTheme from \'@splunk/themes/getTheme\';\n *\n * const baseTheme = getTheme({family: \'prisma\', colorScheme: \'light\', density: \'compact\' });\n *\n * console.log(baseTheme.family, baseTheme.focusColor);\n * ```\n * @param {object} [options] - The attributes of the theme as defined below.\n * @param {\'prisma\' | \'enterprise\'} [options.family = \'prisma\']\n * @param {\'dark\' | \'light\'} [options.colorScheme = \'dark\']\n * @param {\'comfortable\' | \'compact\'} [options.density = \'compact\']\n * @param {Boolean} [options.isPrisma = true]\n * @param {Boolean} [options.isEnterprise = false]\n * @param {Boolean} [options.isComfortable = true]\n * @param {Boolean} [options.isCompact = false]\n * @param {Boolean} [options.isDark = true]\n * @param {Boolean} [options.isLight = false]\n * @returns {object} A flat object of all variables and their values.\n * @public\n */\nfunction getTheme() {\n  var settings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n  var _addThemeDefaults = (0, _utils.addThemeDefaults)(settings),\n    family = _addThemeDefaults.family,\n    colorScheme = _addThemeDefaults.colorScheme,\n    density = _addThemeDefaults.density;\n  var isPrisma = family === \'prisma\';\n  var isEnterprise = family === \'enterprise\';\n  var isComfortable = density === \'comfortable\';\n  var isCompact = density === \'compact\';\n  var isDark = colorScheme === \'dark\';\n  var isLight = colorScheme === \'light\';\n  return Object.freeze(_objectSpread({\n    colorScheme: colorScheme,\n    density: density,\n    family: family,\n    isPrisma: isPrisma,\n    isEnterprise: isEnterprise,\n    isComfortable: isComfortable,\n    isCompact: isCompact,\n    isDark: isDark,\n    isLight: isLight\n  }, family === \'enterprise\' ? (0, _enterprise["default"])({\n    colorScheme: colorScheme,\n    density: density\n  }) : (0, _prisma["default"])({\n    colorScheme: colorScheme,\n    density: density\n  })));\n}\nvar getThemeMemoized = (0, _memoize["default"])(getTheme, function () {\n  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n    family = _ref.family,\n    colorScheme = _ref.colorScheme,\n    density = _ref.density;\n  return "".concat(family).concat(colorScheme).concat(density);\n});\nvar clearGetThemeCache = function clearGetThemeCache() {\n  var _getThemeMemoized$cac, _getThemeMemoized$cac2;\n  return (_getThemeMemoized$cac = (_getThemeMemoized$cac2 = getThemeMemoized.cache).clear) === null || _getThemeMemoized$cac === void 0 ? void 0 : _getThemeMemoized$cac.call(_getThemeMemoized$cac2);\n};\nexports.clearGetThemeCache = clearGetThemeCache;\nvar _default = getThemeMemoized;\nexports["default"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjg5NS5qcyIsIm1hcHBpbmdzIjoiQUFBYTs7QUFFYiw4Q0FBNkM7QUFDN0M7QUFDQSxDQUFDLEVBQUM7QUFDRiwwQkFBMEIsR0FBRyxrQkFBa0I7QUFDL0Msc0NBQXNDLG1CQUFPLENBQUMsS0FBZ0I7QUFDOUQseUNBQXlDLG1CQUFPLENBQUMsS0FBYztBQUMvRCxxQ0FBcUMsbUJBQU8sQ0FBQyxLQUFVO0FBQ3ZELGFBQWEsbUJBQU8sQ0FBQyxLQUFTO0FBQzlCLHFDQUFxQyxpQ0FBaUM7QUFDdEUsc0JBQXNCLDJCQUEyQixvR0FBb0csbUJBQW1CLGlCQUFpQixzSEFBc0g7QUFDL1MseUJBQXlCLHdCQUF3QixvQ0FBb0MseUNBQXlDLGtDQUFrQywwREFBMEQsMEJBQTBCO0FBQ3BQLDRCQUE0QixnQkFBZ0Isc0JBQXNCLE9BQU8sa0RBQWtELHNEQUFzRCw4QkFBOEIsbUpBQW1KLHFFQUFxRSxLQUFLO0FBQzVhLG9DQUFvQyxvRUFBb0UsMERBQTBEO0FBQ2xLLDZCQUE2QixtQ0FBbUM7QUFDaEUsOEJBQThCLDRDQUE0QywrQkFBK0Isb0JBQW9CLG1DQUFtQyxzQ0FBc0MsdUVBQXVFO0FBQzdRO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsK0JBQStCLDREQUE0RDtBQUMzRjtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkIsV0FBVyx5QkFBeUI7QUFDcEMsV0FBVyxrQkFBa0I7QUFDN0IsV0FBVywyQkFBMkI7QUFDdEMsV0FBVyxTQUFTO0FBQ3BCLFdBQVcsU0FBUztBQUNwQixXQUFXLFNBQVM7QUFDcEIsV0FBVyxTQUFTO0FBQ3BCLFdBQVcsU0FBUztBQUNwQixXQUFXLFNBQVM7QUFDcEIsYUFBYSxRQUFRO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBLG1GQUFtRjtBQUNuRjtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUM7QUFDRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLDBCQUEwQjtBQUMxQjtBQUNBLGtCQUFrQiIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvQHNwbHVuay90aGVtZXMvZ2V0VGhlbWUuanM/NTE1NyJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcblxuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7XG4gIHZhbHVlOiB0cnVlXG59KTtcbmV4cG9ydHMuY2xlYXJHZXRUaGVtZUNhY2hlID0gZXhwb3J0c1tcImRlZmF1bHRcIl0gPSB2b2lkIDA7XG52YXIgX21lbW9pemUgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KHJlcXVpcmUoXCJsb2Rhc2gvbWVtb2l6ZVwiKSk7XG52YXIgX2VudGVycHJpc2UgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KHJlcXVpcmUoXCIuL2VudGVycHJpc2VcIikpO1xudmFyIF9wcmlzbWEgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KHJlcXVpcmUoXCIuL3ByaXNtYVwiKSk7XG52YXIgX3V0aWxzID0gcmVxdWlyZShcIi4vdXRpbHNcIik7XG5mdW5jdGlvbiBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KGUpIHsgcmV0dXJuIGUgJiYgZS5fX2VzTW9kdWxlID8gZSA6IHsgXCJkZWZhdWx0XCI6IGUgfTsgfVxuZnVuY3Rpb24gX3R5cGVvZihvKSB7IFwiQGJhYmVsL2hlbHBlcnMgLSB0eXBlb2ZcIjsgcmV0dXJuIF90eXBlb2YgPSBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBcInN5bWJvbFwiID09IHR5cGVvZiBTeW1ib2wuaXRlcmF0b3IgPyBmdW5jdGlvbiAobykgeyByZXR1cm4gdHlwZW9mIG87IH0gOiBmdW5jdGlvbiAobykgeyByZXR1cm4gbyAmJiBcImZ1bmN0aW9uXCIgPT0gdHlwZW9mIFN5bWJvbCAmJiBvLmNvbnN0cnVjdG9yID09PSBTeW1ib2wgJiYgbyAhPT0gU3ltYm9sLnByb3RvdHlwZSA/IFwic3ltYm9sXCIgOiB0eXBlb2YgbzsgfSwgX3R5cGVvZihvKTsgfVxuZnVuY3Rpb24gb3duS2V5cyhlLCByKSB7IHZhciB0ID0gT2JqZWN0LmtleXMoZSk7IGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7IHZhciBvID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhlKTsgciAmJiAobyA9IG8uZmlsdGVyKGZ1bmN0aW9uIChyKSB7IHJldHVybiBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKGUsIHIpLmVudW1lcmFibGU7IH0pKSwgdC5wdXNoLmFwcGx5KHQsIG8pOyB9IHJldHVybiB0OyB9XG5mdW5jdGlvbiBfb2JqZWN0U3ByZWFkKGUpIHsgZm9yICh2YXIgciA9IDE7IHIgPCBhcmd1bWVudHMubGVuZ3RoOyByKyspIHsgdmFyIHQgPSBudWxsICE9IGFyZ3VtZW50c1tyXSA/IGFyZ3VtZW50c1tyXSA6IHt9OyByICUgMiA/IG93bktleXMoT2JqZWN0KHQpLCAhMCkuZm9yRWFjaChmdW5jdGlvbiAocikgeyBfZGVmaW5lUHJvcGVydHkoZSwgciwgdFtyXSk7IH0pIDogT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMgPyBPYmplY3QuZGVmaW5lUHJvcGVydGllcyhlLCBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9ycyh0KSkgOiBvd25LZXlzKE9iamVjdCh0KSkuZm9yRWFjaChmdW5jdGlvbiAocikgeyBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgciwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcih0LCByKSk7IH0pOyB9IHJldHVybiBlOyB9XG5mdW5jdGlvbiBfZGVmaW5lUHJvcGVydHkoZSwgciwgdCkgeyByZXR1cm4gKHIgPSBfdG9Qcm9wZXJ0eUtleShyKSkgaW4gZSA/IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCByLCB7IHZhbHVlOiB0LCBlbnVtZXJhYmxlOiAhMCwgY29uZmlndXJhYmxlOiAhMCwgd3JpdGFibGU6ICEwIH0pIDogZVtyXSA9IHQsIGU7IH1cbmZ1bmN0aW9uIF90b1Byb3BlcnR5S2V5KHQpIHsgdmFyIGkgPSBfdG9QcmltaXRpdmUodCwgXCJzdHJpbmdcIik7IHJldHVybiBcInN5bWJvbFwiID09IF90eXBlb2YoaSkgPyBpIDogaSArIFwiXCI7IH1cbmZ1bmN0aW9uIF90b1ByaW1pdGl2ZSh0LCByKSB7IGlmIChcIm9iamVjdFwiICE9IF90eXBlb2YodCkgfHwgIXQpIHJldHVybiB0OyB2YXIgZSA9IHRbU3ltYm9sLnRvUHJpbWl0aXZlXTsgaWYgKHZvaWQgMCAhPT0gZSkgeyB2YXIgaSA9IGUuY2FsbCh0LCByIHx8IFwiZGVmYXVsdFwiKTsgaWYgKFwib2JqZWN0XCIgIT0gX3R5cGVvZihpKSkgcmV0dXJuIGk7IHRocm93IG5ldyBUeXBlRXJyb3IoXCJAQHRvUHJpbWl0aXZlIG11c3QgcmV0dXJuIGEgcHJpbWl0aXZlIHZhbHVlLlwiKTsgfSByZXR1cm4gKFwic3RyaW5nXCIgPT09IHIgPyBTdHJpbmcgOiBOdW1iZXIpKHQpOyB9XG4vKipcbiAqICoqTk9URToqKiBVc2UgY2FzZXMgZm9yIHRoaXMgZnVuY3Rpb24gYXJlIGxpbWl0ZWQuIEluc3RlYWQsIHVzZSBgdXNlU3BsdW5rVGhlbWVgIGluIFJlYWN0IGNvbXBvbmVudHMgYW5kIGB2YXJpYWJsZXNgIGluIHN0eWxlZC1jb21wb25lbnRzJyBDU1MuXG4gKiBUaGlzIGZ1bmN0aW9uIGlzIGZvciB1c2Ugb3V0c2lkZSBvZiBSZWFjdCBhbmQgc3R5bGVkLWNvbXBvbmVudHMuXG4gKiBAZmlsZVxuICovXG5cbi8qKlxuICogVGhlIGBnZXRUaGVtZWAgZnVuY3Rpb24gcmV0dXJucyBhbGwgdGhlbWUgdmFyaWFibGVzIGZvciBhIGdpdmVuIHRoZW1lLiBUaGlzIGZ1bmN0aW9uIGlzIG1lbW9pemVkLlxuICpcbiAqIGBgYGpzXG4gKiBpbXBvcnQgZ2V0VGhlbWUgZnJvbSAnQHNwbHVuay90aGVtZXMvZ2V0VGhlbWUnO1xuICpcbiAqIGNvbnN0IGJhc2VUaGVtZSA9IGdldFRoZW1lKHtmYW1pbHk6ICdwcmlzbWEnLCBjb2xvclNjaGVtZTogJ2xpZ2h0JywgZGVuc2l0eTogJ2NvbXBhY3QnIH0pO1xuICpcbiAqIGNvbnNvbGUubG9nKGJhc2VUaGVtZS5mYW1pbHksIGJhc2VUaGVtZS5mb2N1c0NvbG9yKTtcbiAqIGBgYFxuICogQHBhcmFtIHtvYmplY3R9IFtvcHRpb25zXSAtIFRoZSBhdHRyaWJ1dGVzIG9mIHRoZSB0aGVtZSBhcyBkZWZpbmVkIGJlbG93LlxuICogQHBhcmFtIHsncHJpc21hJyB8ICdlbnRlcnByaXNlJ30gW29wdGlvbnMuZmFtaWx5ID0gJ3ByaXNtYSddXG4gKiBAcGFyYW0geydkYXJrJyB8ICdsaWdodCd9IFtvcHRpb25zLmNvbG9yU2NoZW1lID0gJ2RhcmsnXVxuICogQHBhcmFtIHsnY29tZm9ydGFibGUnIHwgJ2NvbXBhY3QnfSBbb3B0aW9ucy5kZW5zaXR5ID0gJ2NvbXBhY3QnXVxuICogQHBhcmFtIHtCb29sZWFufSBbb3B0aW9ucy5pc1ByaXNtYSA9IHRydWVdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLmlzRW50ZXJwcmlzZSA9IGZhbHNlXVxuICogQHBhcmFtIHtCb29sZWFufSBbb3B0aW9ucy5pc0NvbWZvcnRhYmxlID0gdHJ1ZV1cbiAqIEBwYXJhbSB7Qm9vbGVhbn0gW29wdGlvbnMuaXNDb21wYWN0ID0gZmFsc2VdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLmlzRGFyayA9IHRydWVdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLmlzTGlnaHQgPSBmYWxzZV1cbiAqIEByZXR1cm5zIHtvYmplY3R9IEEgZmxhdCBvYmplY3Qgb2YgYWxsIHZhcmlhYmxlcyBhbmQgdGhlaXIgdmFsdWVzLlxuICogQHB1YmxpY1xuICovXG5mdW5jdGlvbiBnZXRUaGVtZSgpIHtcbiAgdmFyIHNldHRpbmdzID0gYXJndW1lbnRzLmxlbmd0aCA+IDAgJiYgYXJndW1lbnRzWzBdICE9PSB1bmRlZmluZWQgPyBhcmd1bWVudHNbMF0gOiB7fTtcbiAgdmFyIF9hZGRUaGVtZURlZmF1bHRzID0gKDAsIF91dGlscy5hZGRUaGVtZURlZmF1bHRzKShzZXR0aW5ncyksXG4gICAgZmFtaWx5ID0gX2FkZFRoZW1lRGVmYXVsdHMuZmFtaWx5LFxuICAgIGNvbG9yU2NoZW1lID0gX2FkZFRoZW1lRGVmYXVsdHMuY29sb3JTY2hlbWUsXG4gICAgZGVuc2l0eSA9IF9hZGRUaGVtZURlZmF1bHRzLmRlbnNpdHk7XG4gIHZhciBpc1ByaXNtYSA9IGZhbWlseSA9PT0gJ3ByaXNtYSc7XG4gIHZhciBpc0VudGVycHJpc2UgPSBmYW1pbHkgPT09ICdlbnRlcnByaXNlJztcbiAgdmFyIGlzQ29tZm9ydGFibGUgPSBkZW5zaXR5ID09PSAnY29tZm9ydGFibGUnO1xuICB2YXIgaXNDb21wYWN0ID0gZGVuc2l0eSA9PT0gJ2NvbXBhY3QnO1xuICB2YXIgaXNEYXJrID0gY29sb3JTY2hlbWUgPT09ICdkYXJrJztcbiAgdmFyIGlzTGlnaHQgPSBjb2xvclNjaGVtZSA9PT0gJ2xpZ2h0JztcbiAgcmV0dXJuIE9iamVjdC5mcmVlemUoX29iamVjdFNwcmVhZCh7XG4gICAgY29sb3JTY2hlbWU6IGNvbG9yU2NoZW1lLFxuICAgIGRlbnNpdHk6IGRlbnNpdHksXG4gICAgZmFtaWx5OiBmYW1pbHksXG4gICAgaXNQcmlzbWE6IGlzUHJpc21hLFxuICAgIGlzRW50ZXJwcmlzZTogaXNFbnRlcnByaXNlLFxuICAgIGlzQ29tZm9ydGFibGU6IGlzQ29tZm9ydGFibGUsXG4gICAgaXNDb21wYWN0OiBpc0NvbXBhY3QsXG4gICAgaXNEYXJrOiBpc0RhcmssXG4gICAgaXNMaWdodDogaXNMaWdodFxuICB9LCBmYW1pbHkgPT09ICdlbnRlcnByaXNlJyA/ICgwLCBfZW50ZXJwcmlzZVtcImRlZmF1bHRcIl0pKHtcbiAgICBjb2xvclNjaGVtZTogY29sb3JTY2hlbWUsXG4gICAgZGVuc2l0eTogZGVuc2l0eVxuICB9KSA6ICgwLCBfcHJpc21hW1wiZGVmYXVsdFwiXSkoe1xuICAgIGNvbG9yU2NoZW1lOiBjb2xvclNjaGVtZSxcbiAgICBkZW5zaXR5OiBkZW5zaXR5XG4gIH0pKSk7XG59XG52YXIgZ2V0VGhlbWVNZW1vaXplZCA9ICgwLCBfbWVtb2l6ZVtcImRlZmF1bHRcIl0pKGdldFRoZW1lLCBmdW5jdGlvbiAoKSB7XG4gIHZhciBfcmVmID0gYXJndW1lbnRzLmxlbmd0aCA+IDAgJiYgYXJndW1lbnRzWzBdICE9PSB1bmRlZmluZWQgPyBhcmd1bWVudHNbMF0gOiB7fSxcbiAgICBmYW1pbHkgPSBfcmVmLmZhbWlseSxcbiAgICBjb2xvclNjaGVtZSA9IF9yZWYuY29sb3JTY2hlbWUsXG4gICAgZGVuc2l0eSA9IF9yZWYuZGVuc2l0eTtcbiAgcmV0dXJuIFwiXCIuY29uY2F0KGZhbWlseSkuY29uY2F0KGNvbG9yU2NoZW1lKS5jb25jYXQoZGVuc2l0eSk7XG59KTtcbnZhciBjbGVhckdldFRoZW1lQ2FjaGUgPSBmdW5jdGlvbiBjbGVhckdldFRoZW1lQ2FjaGUoKSB7XG4gIHZhciBfZ2V0VGhlbWVNZW1vaXplZCRjYWMsIF9nZXRUaGVtZU1lbW9pemVkJGNhYzI7XG4gIHJldHVybiAoX2dldFRoZW1lTWVtb2l6ZWQkY2FjID0gKF9nZXRUaGVtZU1lbW9pemVkJGNhYzIgPSBnZXRUaGVtZU1lbW9pemVkLmNhY2hlKS5jbGVhcikgPT09IG51bGwgfHwgX2dldFRoZW1lTWVtb2l6ZWQkY2FjID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfZ2V0VGhlbWVNZW1vaXplZCRjYWMuY2FsbChfZ2V0VGhlbWVNZW1vaXplZCRjYWMyKTtcbn07XG5leHBvcnRzLmNsZWFyR2V0VGhlbWVDYWNoZSA9IGNsZWFyR2V0VGhlbWVDYWNoZTtcbnZhciBfZGVmYXVsdCA9IGdldFRoZW1lTWVtb2l6ZWQ7XG5leHBvcnRzW1wiZGVmYXVsdFwiXSA9IF9kZWZhdWx0OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///2895\n\n}')},2915:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar isFunction = __webpack_require__(91573),\n    isLength = __webpack_require__(6085);\n\n/**\n * Checks if `value` is array-like. A value is considered array-like if it's\n * not a function and has a `value.length` that's an integer greater than or\n * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is array-like, else `false`.\n * @example\n *\n * _.isArrayLike([1, 2, 3]);\n * // => true\n *\n * _.isArrayLike(document.body.children);\n * // => true\n *\n * _.isArrayLike('abc');\n * // => true\n *\n * _.isArrayLike(_.noop);\n * // => false\n */\nfunction isArrayLike(value) {\n  return value != null && isLength(value.length) && !isFunction(value);\n}\n\nmodule.exports = isArrayLike;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjkxNS5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsaUJBQWlCLG1CQUFPLENBQUMsS0FBYyIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvbG9kYXNoL2lzQXJyYXlMaWtlLmpzP2Y3MmQiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIGlzRnVuY3Rpb24gPSByZXF1aXJlKCcuL2lzRnVuY3Rpb24nKSxcbiAgICBpc0xlbmd0aCA9IHJlcXVpcmUoJy4vaXNMZW5ndGgnKTtcblxuLyoqXG4gKiBDaGVja3MgaWYgYHZhbHVlYCBpcyBhcnJheS1saWtlLiBBIHZhbHVlIGlzIGNvbnNpZGVyZWQgYXJyYXktbGlrZSBpZiBpdCdzXG4gKiBub3QgYSBmdW5jdGlvbiBhbmQgaGFzIGEgYHZhbHVlLmxlbmd0aGAgdGhhdCdzIGFuIGludGVnZXIgZ3JlYXRlciB0aGFuIG9yXG4gKiBlcXVhbCB0byBgMGAgYW5kIGxlc3MgdGhhbiBvciBlcXVhbCB0byBgTnVtYmVyLk1BWF9TQUZFX0lOVEVHRVJgLlxuICpcbiAqIEBzdGF0aWNcbiAqIEBtZW1iZXJPZiBfXG4gKiBAc2luY2UgNC4wLjBcbiAqIEBjYXRlZ29yeSBMYW5nXG4gKiBAcGFyYW0geyp9IHZhbHVlIFRoZSB2YWx1ZSB0byBjaGVjay5cbiAqIEByZXR1cm5zIHtib29sZWFufSBSZXR1cm5zIGB0cnVlYCBpZiBgdmFsdWVgIGlzIGFycmF5LWxpa2UsIGVsc2UgYGZhbHNlYC5cbiAqIEBleGFtcGxlXG4gKlxuICogXy5pc0FycmF5TGlrZShbMSwgMiwgM10pO1xuICogLy8gPT4gdHJ1ZVxuICpcbiAqIF8uaXNBcnJheUxpa2UoZG9jdW1lbnQuYm9keS5jaGlsZHJlbik7XG4gKiAvLyA9PiB0cnVlXG4gKlxuICogXy5pc0FycmF5TGlrZSgnYWJjJyk7XG4gKiAvLyA9PiB0cnVlXG4gKlxuICogXy5pc0FycmF5TGlrZShfLm5vb3ApO1xuICogLy8gPT4gZmFsc2VcbiAqL1xuZnVuY3Rpb24gaXNBcnJheUxpa2UodmFsdWUpIHtcbiAgcmV0dXJuIHZhbHVlICE9IG51bGwgJiYgaXNMZW5ndGgodmFsdWUubGVuZ3RoKSAmJiAhaXNGdW5jdGlvbih2YWx1ZSk7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gaXNBcnJheUxpa2U7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///2915\n\n}")},2944:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar isArray_1 = __webpack_require__(18033);\nvar ArrayObservable_1 = __webpack_require__(80757);\nvar OuterSubscriber_1 = __webpack_require__(234);\nvar subscribeToResult_1 = __webpack_require__(740);\nfunction race() {\n    var observables = [];\n    for (var _i = 0; _i < arguments.length; _i++) {\n        observables[_i - 0] = arguments[_i];\n    }\n    // if the only argument is an array, it was most likely called with\n    // `race([obs1, obs2, ...])`\n    if (observables.length === 1) {\n        if (isArray_1.isArray(observables[0])) {\n            observables = observables[0];\n        }\n        else {\n            return observables[0];\n        }\n    }\n    return new ArrayObservable_1.ArrayObservable(observables).lift(new RaceOperator());\n}\nexports.race = race;\nvar RaceOperator = (function () {\n    function RaceOperator() {\n    }\n    RaceOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new RaceSubscriber(subscriber));\n    };\n    return RaceOperator;\n}());\nexports.RaceOperator = RaceOperator;\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar RaceSubscriber = (function (_super) {\n    __extends(RaceSubscriber, _super);\n    function RaceSubscriber(destination) {\n        _super.call(this, destination);\n        this.hasFirst = false;\n        this.observables = [];\n        this.subscriptions = [];\n    }\n    RaceSubscriber.prototype._next = function (observable) {\n        this.observables.push(observable);\n    };\n    RaceSubscriber.prototype._complete = function () {\n        var observables = this.observables;\n        var len = observables.length;\n        if (len === 0) {\n            this.destination.complete();\n        }\n        else {\n            for (var i = 0; i < len && !this.hasFirst; i++) {\n                var observable = observables[i];\n                var subscription = subscribeToResult_1.subscribeToResult(this, observable, observable, i);\n                if (this.subscriptions) {\n                    this.subscriptions.push(subscription);\n                }\n                this.add(subscription);\n            }\n            this.observables = null;\n        }\n    };\n    RaceSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {\n        if (!this.hasFirst) {\n            this.hasFirst = true;\n            for (var i = 0; i < this.subscriptions.length; i++) {\n                if (i !== outerIndex) {\n                    var subscription = this.subscriptions[i];\n                    subscription.unsubscribe();\n                    this.remove(subscription);\n                }\n            }\n            this.subscriptions = null;\n        }\n        this.destination.next(innerValue);\n    };\n    return RaceSubscriber;\n}(OuterSubscriber_1.OuterSubscriber));\nexports.RaceSubscriber = RaceSubscriber;\n//# sourceMappingURL=race.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///2944\n\n}")},2970:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar baseClamp = __webpack_require__(85914),\n    toNumber = __webpack_require__(13257);\n\n/**\n * Clamps `number` within the inclusive `lower` and `upper` bounds.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Number\n * @param {number} number The number to clamp.\n * @param {number} [lower] The lower bound.\n * @param {number} upper The upper bound.\n * @returns {number} Returns the clamped number.\n * @example\n *\n * _.clamp(-10, -5, 5);\n * // => -5\n *\n * _.clamp(10, -5, 5);\n * // => 5\n */\nfunction clamp(number, lower, upper) {\n  if (upper === undefined) {\n    upper = lower;\n    lower = undefined;\n  }\n  if (upper !== undefined) {\n    upper = toNumber(upper);\n    upper = upper === upper ? upper : 0;\n  }\n  if (lower !== undefined) {\n    lower = toNumber(lower);\n    lower = lower === lower ? lower : 0;\n  }\n  return baseClamp(toNumber(number), lower, upper);\n}\n\nmodule.exports = clamp;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjk3MC5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsZ0JBQWdCLG1CQUFPLENBQUMsS0FBYyIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvbG9kYXNoL2NsYW1wLmpzP2M0MTQiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIGJhc2VDbGFtcCA9IHJlcXVpcmUoJy4vX2Jhc2VDbGFtcCcpLFxuICAgIHRvTnVtYmVyID0gcmVxdWlyZSgnLi90b051bWJlcicpO1xuXG4vKipcbiAqIENsYW1wcyBgbnVtYmVyYCB3aXRoaW4gdGhlIGluY2x1c2l2ZSBgbG93ZXJgIGFuZCBgdXBwZXJgIGJvdW5kcy5cbiAqXG4gKiBAc3RhdGljXG4gKiBAbWVtYmVyT2YgX1xuICogQHNpbmNlIDQuMC4wXG4gKiBAY2F0ZWdvcnkgTnVtYmVyXG4gKiBAcGFyYW0ge251bWJlcn0gbnVtYmVyIFRoZSBudW1iZXIgdG8gY2xhbXAuXG4gKiBAcGFyYW0ge251bWJlcn0gW2xvd2VyXSBUaGUgbG93ZXIgYm91bmQuXG4gKiBAcGFyYW0ge251bWJlcn0gdXBwZXIgVGhlIHVwcGVyIGJvdW5kLlxuICogQHJldHVybnMge251bWJlcn0gUmV0dXJucyB0aGUgY2xhbXBlZCBudW1iZXIuXG4gKiBAZXhhbXBsZVxuICpcbiAqIF8uY2xhbXAoLTEwLCAtNSwgNSk7XG4gKiAvLyA9PiAtNVxuICpcbiAqIF8uY2xhbXAoMTAsIC01LCA1KTtcbiAqIC8vID0+IDVcbiAqL1xuZnVuY3Rpb24gY2xhbXAobnVtYmVyLCBsb3dlciwgdXBwZXIpIHtcbiAgaWYgKHVwcGVyID09PSB1bmRlZmluZWQpIHtcbiAgICB1cHBlciA9IGxvd2VyO1xuICAgIGxvd2VyID0gdW5kZWZpbmVkO1xuICB9XG4gIGlmICh1cHBlciAhPT0gdW5kZWZpbmVkKSB7XG4gICAgdXBwZXIgPSB0b051bWJlcih1cHBlcik7XG4gICAgdXBwZXIgPSB1cHBlciA9PT0gdXBwZXIgPyB1cHBlciA6IDA7XG4gIH1cbiAgaWYgKGxvd2VyICE9PSB1bmRlZmluZWQpIHtcbiAgICBsb3dlciA9IHRvTnVtYmVyKGxvd2VyKTtcbiAgICBsb3dlciA9IGxvd2VyID09PSBsb3dlciA/IGxvd2VyIDogMDtcbiAgfVxuICByZXR1cm4gYmFzZUNsYW1wKHRvTnVtYmVyKG51bWJlciksIGxvd2VyLCB1cHBlcik7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gY2xhbXA7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///2970\n\n}")},3103:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\n/* tslint:enable:max-line-length */\n/**\n * Filter items emitted by the source Observable by only emitting those that\n * satisfy a specified predicate.\n *\n * <span class="informal">Like\n * [Array.prototype.filter()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter),\n * it only emits a value from the source if it passes a criterion function.</span>\n *\n * <img src="./img/filter.png" width="100%">\n *\n * Similar to the well-known `Array.prototype.filter` method, this operator\n * takes values from the source Observable, passes them through a `predicate`\n * function and only emits those values that yielded `true`.\n *\n * @example <caption>Emit only click events whose target was a DIV element</caption>\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var clicksOnDivs = clicks.filter(ev => ev.target.tagName === \'DIV\');\n * clicksOnDivs.subscribe(x => console.log(x));\n *\n * @see {@link distinct}\n * @see {@link distinctUntilChanged}\n * @see {@link distinctUntilKeyChanged}\n * @see {@link ignoreElements}\n * @see {@link partition}\n * @see {@link skip}\n *\n * @param {function(value: T, index: number): boolean} predicate A function that\n * evaluates each value emitted by the source Observable. If it returns `true`,\n * the value is emitted, if `false` the value is not passed to the output\n * Observable. The `index` parameter is the number `i` for the i-th source\n * emission that has happened since the subscription, starting from the number\n * `0`.\n * @param {any} [thisArg] An optional argument to determine the value of `this`\n * in the `predicate` function.\n * @return {Observable} An Observable of values from the source that were\n * allowed by the `predicate` function.\n * @method filter\n * @owner Observable\n */\nfunction filter(predicate, thisArg) {\n    return function filterOperatorFunction(source) {\n        return source.lift(new FilterOperator(predicate, thisArg));\n    };\n}\nexports.filter = filter;\nvar FilterOperator = (function () {\n    function FilterOperator(predicate, thisArg) {\n        this.predicate = predicate;\n        this.thisArg = thisArg;\n    }\n    FilterOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new FilterSubscriber(subscriber, this.predicate, this.thisArg));\n    };\n    return FilterOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar FilterSubscriber = (function (_super) {\n    __extends(FilterSubscriber, _super);\n    function FilterSubscriber(destination, predicate, thisArg) {\n        _super.call(this, destination);\n        this.predicate = predicate;\n        this.thisArg = thisArg;\n        this.count = 0;\n    }\n    // the try catch block below is left specifically for\n    // optimization and perf reasons. a tryCatcher is not necessary here.\n    FilterSubscriber.prototype._next = function (value) {\n        var result;\n        try {\n            result = this.predicate.call(this.thisArg, value, this.count++);\n        }\n        catch (err) {\n            this.destination.error(err);\n            return;\n        }\n        if (result) {\n            this.destination.next(value);\n        }\n    };\n    return FilterSubscriber;\n}(Subscriber_1.Subscriber));\n//# sourceMappingURL=filter.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///3103\n\n}')},3270:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/**\n * This method returns `false`.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {boolean} Returns `false`.\n * @example\n *\n * _.times(2, _.stubFalse);\n * // => [false, false]\n */\nfunction stubFalse() {\n  return false;\n}\n\nmodule.exports = stubFalse;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9zdHViRmFsc2UuanM/MGUzMCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFRoaXMgbWV0aG9kIHJldHVybnMgYGZhbHNlYC5cbiAqXG4gKiBAc3RhdGljXG4gKiBAbWVtYmVyT2YgX1xuICogQHNpbmNlIDQuMTMuMFxuICogQGNhdGVnb3J5IFV0aWxcbiAqIEByZXR1cm5zIHtib29sZWFufSBSZXR1cm5zIGBmYWxzZWAuXG4gKiBAZXhhbXBsZVxuICpcbiAqIF8udGltZXMoMiwgXy5zdHViRmFsc2UpO1xuICogLy8gPT4gW2ZhbHNlLCBmYWxzZV1cbiAqL1xuZnVuY3Rpb24gc3R1YkZhbHNlKCkge1xuICByZXR1cm4gZmFsc2U7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gc3R1YkZhbHNlO1xuIl0sImZpbGUiOiIzMjcwLmpzIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///3270\n\n}")},3315:(__unused_webpack_module,exports)=>{"use strict";eval('{\n\nObject.defineProperty(exports, "__esModule", ({\n  value: true\n}));\nexports["default"] = void 0;\nfunction _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }\nfunction ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }\nfunction _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }\nfunction _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }\nfunction _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }\nfunction _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }\n/**\n * #### Z Indexes\n * Used to position elements in the z-axis.\n * If a variable does not suit your purpose, set a value relatively, such as `zindexModal +1`.\n *\n * @categoryValue\n */\nvar zIndexes = {\n  zindexLayer: 1000,\n  zindexFixedNavbar: 1030,\n  zindexModalBackdrop: 1040,\n  zindexModal: 1050,\n  zindexPopover: 1060,\n  zindexToastMessages: 2000\n};\n\n/**\n * #### Shadows\n *\n * @categoryShadow\n */\nvar elevationShadows = {\n  embossShadow: \' \',\n  overlayShadow: \'\',\n  dragShadow: \'\',\n  modalShadow: \'\',\n  focusShadow: \'\',\n  focusShadowInset: \'\',\n  draggableBackground: \'\'\n};\nvar elevation = _objectSpread(_objectSpread({}, zIndexes), elevationShadows);\nvar _default = elevation;\nexports["default"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///3315\n\n}')},3325:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/**\n * A specialized version of `_.map` for arrays without support for iteratee\n * shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns the new mapped array.\n */\nfunction arrayMap(array, iteratee) {\n  var index = -1,\n      length = array == null ? 0 : array.length,\n      result = Array(length);\n\n  while (++index < length) {\n    result[index] = iteratee(array[index], index, array);\n  }\n  return result;\n}\n\nmodule.exports = arrayMap;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9fYXJyYXlNYXAuanM/MWZjZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEEgc3BlY2lhbGl6ZWQgdmVyc2lvbiBvZiBgXy5tYXBgIGZvciBhcnJheXMgd2l0aG91dCBzdXBwb3J0IGZvciBpdGVyYXRlZVxuICogc2hvcnRoYW5kcy5cbiAqXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtBcnJheX0gW2FycmF5XSBUaGUgYXJyYXkgdG8gaXRlcmF0ZSBvdmVyLlxuICogQHBhcmFtIHtGdW5jdGlvbn0gaXRlcmF0ZWUgVGhlIGZ1bmN0aW9uIGludm9rZWQgcGVyIGl0ZXJhdGlvbi5cbiAqIEByZXR1cm5zIHtBcnJheX0gUmV0dXJucyB0aGUgbmV3IG1hcHBlZCBhcnJheS5cbiAqL1xuZnVuY3Rpb24gYXJyYXlNYXAoYXJyYXksIGl0ZXJhdGVlKSB7XG4gIHZhciBpbmRleCA9IC0xLFxuICAgICAgbGVuZ3RoID0gYXJyYXkgPT0gbnVsbCA/IDAgOiBhcnJheS5sZW5ndGgsXG4gICAgICByZXN1bHQgPSBBcnJheShsZW5ndGgpO1xuXG4gIHdoaWxlICgrK2luZGV4IDwgbGVuZ3RoKSB7XG4gICAgcmVzdWx0W2luZGV4XSA9IGl0ZXJhdGVlKGFycmF5W2luZGV4XSwgaW5kZXgsIGFycmF5KTtcbiAgfVxuICByZXR1cm4gcmVzdWx0O1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGFycmF5TWFwO1xuIl0sImZpbGUiOiIzMzI1LmpzIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///3325\n\n}")},3653:(__unused_webpack_module,exports)=>{"use strict";eval("{\nfunction not(pred, thisArg) {\n    function notPred() {\n        return !(notPred.pred.apply(notPred.thisArg, arguments));\n    }\n    notPred.pred = pred;\n    notPred.thisArg = thisArg;\n    return notPred;\n}\nexports.not = not;\n//# sourceMappingURL=not.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzY1My5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXO0FBQ1giLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvdXRpbC9ub3QuanM/NTU1YSJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbmZ1bmN0aW9uIG5vdChwcmVkLCB0aGlzQXJnKSB7XG4gICAgZnVuY3Rpb24gbm90UHJlZCgpIHtcbiAgICAgICAgcmV0dXJuICEobm90UHJlZC5wcmVkLmFwcGx5KG5vdFByZWQudGhpc0FyZywgYXJndW1lbnRzKSk7XG4gICAgfVxuICAgIG5vdFByZWQucHJlZCA9IHByZWQ7XG4gICAgbm90UHJlZC50aGlzQXJnID0gdGhpc0FyZztcbiAgICByZXR1cm4gbm90UHJlZDtcbn1cbmV4cG9ydHMubm90ID0gbm90O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bm90LmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///3653\n\n}")},3789:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar mergeMapTo_1 = __webpack_require__(99881);\nObservable_1.Observable.prototype.flatMapTo = mergeMapTo_1.mergeMapTo;\nObservable_1.Observable.prototype.mergeMapTo = mergeMapTo_1.mergeMapTo;\n//# sourceMappingURL=mergeMapTo.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzc4OS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLG1CQUFtQixtQkFBTyxDQUFDLEtBQTJCO0FBQ3REO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcnhqcy9hZGQvb3BlcmF0b3IvbWVyZ2VNYXBUby5qcz81MGExIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xudmFyIE9ic2VydmFibGVfMSA9IHJlcXVpcmUoJy4uLy4uL09ic2VydmFibGUnKTtcbnZhciBtZXJnZU1hcFRvXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9tZXJnZU1hcFRvJyk7XG5PYnNlcnZhYmxlXzEuT2JzZXJ2YWJsZS5wcm90b3R5cGUuZmxhdE1hcFRvID0gbWVyZ2VNYXBUb18xLm1lcmdlTWFwVG87XG5PYnNlcnZhYmxlXzEuT2JzZXJ2YWJsZS5wcm90b3R5cGUubWVyZ2VNYXBUbyA9IG1lcmdlTWFwVG9fMS5tZXJnZU1hcFRvO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bWVyZ2VNYXBUby5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///3789\n\n}")},3963:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar do_1 = __webpack_require__(29551);\nObservable_1.Observable.prototype.do = do_1._do;\nObservable_1.Observable.prototype._do = do_1._do;\n//# sourceMappingURL=do.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzk2My5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLFdBQVcsbUJBQU8sQ0FBQyxLQUFtQjtBQUN0QztBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvYWRkL29wZXJhdG9yL2RvLmpzPzM1ODgiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgT2JzZXJ2YWJsZV8xID0gcmVxdWlyZSgnLi4vLi4vT2JzZXJ2YWJsZScpO1xudmFyIGRvXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9kbycpO1xuT2JzZXJ2YWJsZV8xLk9ic2VydmFibGUucHJvdG90eXBlLmRvID0gZG9fMS5fZG87XG5PYnNlcnZhYmxlXzEuT2JzZXJ2YWJsZS5wcm90b3R5cGUuX2RvID0gZG9fMS5fZG87XG4vLyMgc291cmNlTWFwcGluZ1VSTD1kby5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///3963\n\n}")},4754:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Observable_1 = __webpack_require__(91638);\nvar noop_1 = __webpack_require__(77694);\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @extends {Ignored}\n * @hide true\n */\nvar NeverObservable = (function (_super) {\n    __extends(NeverObservable, _super);\n    function NeverObservable() {\n        _super.call(this);\n    }\n    /**\n     * Creates an Observable that emits no items to the Observer.\n     *\n     * <span class="informal">An Observable that never emits anything.</span>\n     *\n     * <img src="./img/never.png" width="100%">\n     *\n     * This static operator is useful for creating a simple Observable that emits\n     * neither values nor errors nor the completion notification. It can be used\n     * for testing purposes or for composing with other Observables. Please note\n     * that by never emitting a complete notification, this Observable keeps the\n     * subscription from being disposed automatically. Subscriptions need to be\n     * manually disposed.\n     *\n     * @example <caption>Emit the number 7, then never emit anything else (not even complete).</caption>\n     * function info() {\n     *   console.log(\'Will not be called\');\n     * }\n     * var result = Rx.Observable.never().startWith(7);\n     * result.subscribe(x => console.log(x), info, info);\n     *\n     * @see {@link create}\n     * @see {@link empty}\n     * @see {@link of}\n     * @see {@link throw}\n     *\n     * @return {Observable} A "never" Observable: never emits anything.\n     * @static true\n     * @name never\n     * @owner Observable\n     */\n    NeverObservable.create = function () {\n        return new NeverObservable();\n    };\n    /** @deprecated internal use only */ NeverObservable.prototype._subscribe = function (subscriber) {\n        noop_1.noop();\n    };\n    return NeverObservable;\n}(Observable_1.Observable));\nexports.NeverObservable = NeverObservable;\n//# sourceMappingURL=NeverObservable.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///4754\n\n}')},4829:(__unused_webpack_module,exports)=>{"use strict";eval("{\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\nvar measures = {\n  spacingXSmall: '4px',\n  spacingSmall: '8px',\n  spacingMedium: '12px',\n  spacingLarge: '16px',\n  spacingXLarge: '24px',\n  spacingXXLarge: '32px',\n  spacingXXXLarge: '40px',\n  inputBorderWidth: '1px',\n  inputHeight: '32px',\n  borderRadius: '4px'\n};\nvar _default = measures;\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDgyOS5qcyIsIm1hcHBpbmdzIjoiQUFBYTs7QUFFYiw4Q0FBNkM7QUFDN0M7QUFDQSxDQUFDLEVBQUM7QUFDRixrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL0BzcGx1bmsvdGhlbWVzL3ByaXNtYS9jb21mb3J0YWJsZS5qcz8wY2EwIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuXG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHtcbiAgdmFsdWU6IHRydWVcbn0pO1xuZXhwb3J0c1tcImRlZmF1bHRcIl0gPSB2b2lkIDA7XG52YXIgbWVhc3VyZXMgPSB7XG4gIHNwYWNpbmdYU21hbGw6ICc0cHgnLFxuICBzcGFjaW5nU21hbGw6ICc4cHgnLFxuICBzcGFjaW5nTWVkaXVtOiAnMTJweCcsXG4gIHNwYWNpbmdMYXJnZTogJzE2cHgnLFxuICBzcGFjaW5nWExhcmdlOiAnMjRweCcsXG4gIHNwYWNpbmdYWExhcmdlOiAnMzJweCcsXG4gIHNwYWNpbmdYWFhMYXJnZTogJzQwcHgnLFxuICBpbnB1dEJvcmRlcldpZHRoOiAnMXB4JyxcbiAgaW5wdXRIZWlnaHQ6ICczMnB4JyxcbiAgYm9yZGVyUmFkaXVzOiAnNHB4J1xufTtcbnZhciBfZGVmYXVsdCA9IG1lYXN1cmVzO1xuZXhwb3J0c1tcImRlZmF1bHRcIl0gPSBfZGVmYXVsdDsiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///4829\n\n}")},4932:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Initializes an array clone.\n *\n * @private\n * @param {Array} array The array to clone.\n * @returns {Array} Returns the initialized clone.\n */\nfunction initCloneArray(array) {\n  var length = array.length,\n      result = new array.constructor(length);\n\n  // Add properties assigned by `RegExp#exec`.\n  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {\n    result.index = array.index;\n    result.input = array.input;\n  }\n  return result;\n}\n\nmodule.exports = initCloneArray;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9faW5pdENsb25lQXJyYXkuanM/ZGQwOSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogVXNlZCBmb3IgYnVpbHQtaW4gbWV0aG9kIHJlZmVyZW5jZXMuICovXG52YXIgb2JqZWN0UHJvdG8gPSBPYmplY3QucHJvdG90eXBlO1xuXG4vKiogVXNlZCB0byBjaGVjayBvYmplY3RzIGZvciBvd24gcHJvcGVydGllcy4gKi9cbnZhciBoYXNPd25Qcm9wZXJ0eSA9IG9iamVjdFByb3RvLmhhc093blByb3BlcnR5O1xuXG4vKipcbiAqIEluaXRpYWxpemVzIGFuIGFycmF5IGNsb25lLlxuICpcbiAqIEBwcml2YXRlXG4gKiBAcGFyYW0ge0FycmF5fSBhcnJheSBUaGUgYXJyYXkgdG8gY2xvbmUuXG4gKiBAcmV0dXJucyB7QXJyYXl9IFJldHVybnMgdGhlIGluaXRpYWxpemVkIGNsb25lLlxuICovXG5mdW5jdGlvbiBpbml0Q2xvbmVBcnJheShhcnJheSkge1xuICB2YXIgbGVuZ3RoID0gYXJyYXkubGVuZ3RoLFxuICAgICAgcmVzdWx0ID0gbmV3IGFycmF5LmNvbnN0cnVjdG9yKGxlbmd0aCk7XG5cbiAgLy8gQWRkIHByb3BlcnRpZXMgYXNzaWduZWQgYnkgYFJlZ0V4cCNleGVjYC5cbiAgaWYgKGxlbmd0aCAmJiB0eXBlb2YgYXJyYXlbMF0gPT0gJ3N0cmluZycgJiYgaGFzT3duUHJvcGVydHkuY2FsbChhcnJheSwgJ2luZGV4JykpIHtcbiAgICByZXN1bHQuaW5kZXggPSBhcnJheS5pbmRleDtcbiAgICByZXN1bHQuaW5wdXQgPSBhcnJheS5pbnB1dDtcbiAgfVxuICByZXR1cm4gcmVzdWx0O1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGluaXRDbG9uZUFycmF5O1xuIl0sImZpbGUiOiI0OTMyLmpzIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///4932\n\n}")},4989:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("{\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.clearfix = clearfix;\nexports.ellipsis = ellipsis;\nexports.printWidth100Percent = printWidth100Percent;\nexports.printHide = printHide;\nexports.printNoBackground = printNoBackground;\nexports.printWrapAll = printWrapAll;\nexports.screenReaderContent = screenReaderContent;\nexports.skipLink = skipLink;\nexports.overlayColors = overlayColors;\nexports.colorWithAlpha = colorWithAlpha;\nexports[\"default\"] = void 0;\nvar _colorBlend = __webpack_require__(93228);\nvar _tinycolor = _interopRequireDefault(__webpack_require__(45888));\nfunction _interopRequireDefault(e) { return e && e.__esModule ? e : { \"default\": e }; }\n/**\n * @file\n * A collection of style-related helper functions. All of them return a single object containing\n * DOM CSS properties, for example: `{ display: …, fontFamily: … }`.\n */\n\n/**\n * `clearfix` is used on a container to ensure its height is at least as tall as any floating\n * children.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { clearfix } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      ${clearfix()};\n *  `\n *  ```\n * @public\n */\nfunction clearfix() {\n  return {\n    '&::after': {\n      display: 'table',\n      content: '\"\"',\n      clear: 'both'\n    }\n  };\n}\n\n/**\n * Use `ellipsis` for overflowing text. Requires `display` to be set to `inline-block` or `block`.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { ellipsis } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      ${ellipsis()};\n *      width: 300px;\n *  `\n *  ```\n * @public\n */\nfunction ellipsis() {\n  return {\n    overflow: 'hidden',\n    textOverflow: 'ellipsis',\n    whiteSpace: 'nowrap'\n  };\n}\n\n/**\n * Force an element to be exactly 100% wide so that it doesn't overflow the page.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { printWidth100Percent } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      @media print {\n *          .myElement {\n *             ${printWidth100Percent()};\n *          }\n *      }\n *  }\n *  `\n *  ```\n *  @public\n */\nfunction printWidth100Percent() {\n  return {\n    maxWidth: '100% !important',\n    width: '100% !important',\n    overflow: 'hidden !important'\n  };\n}\n\n/**\n * Hide an element (such as a button).\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { printHide } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      @media print {\n *          .myElement {\n *              ${printHide()};\n *          }\n *      }\n *  }\n *  ```\n * @public\n */\nfunction printHide() {\n  return {\n    display: 'none !important'\n  };\n}\n\n/**\n * Remove background gradients and images.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { printNoBackground } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      @media print {\n *          .myElement {\n *              ${printNoBackground()};\n *          }\n *      }\n *  }\n *  ```\n * @public\n */\nfunction printNoBackground() {\n  return {\n    background: 'none !important'\n  };\n}\n\n/**\n * Ensure that all text wraps so that it doesn't overflow the page.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { printWrapAll } from '@splunk/themes/mixins';\n *\n *  const myBlock = styled.div`\n *      @media print {\n *          .myElement {\n *              ${printWrapAll()};\n *          }\n *      }\n *  }\n *  ```\n * @public\n */\nfunction printWrapAll() {\n  // TS: have to assert as CSSObject because csstype doesn't allow !important\n  return {\n    wordBreak: 'break-all !important',\n    wordWrap: 'break-word !important',\n    overflowWrap: 'break-word !important',\n    whiteSpace: 'normal !important'\n  };\n}\n\n/**\n * Visually hide content. Typically used to target content for assistive technologies.\n *\n *  ##### Example\n *  ``` js\n *  import { screenReaderContent } from '@splunk/themes/mixins';\n *\n *  .myElement {\n *      ${screenReaderContent()};\n *  }\n *  ```\n * @public\n */\nfunction screenReaderContent() {\n  return {\n    position: 'absolute',\n    overflow: 'hidden',\n    clip: 'rect(0 0 0 0)',\n    height: '1px',\n    width: '1px',\n    margin: '-1px',\n    padding: 0,\n    border: 0\n  };\n}\n\n/**\n * Visually hide interactive elements and reveal them on focus. Use this mixin to allow\n * keyboard users to skip over repeated content, such as navigation menus\n *\n * ##### Example\n * ```js\n * import styled from 'styled-components';\n * import Link from '@splunk/react-ui/Link';\n * import mixins from '@splunk/themes';\n *\n * const skipLink = styled(Link)`\n *   ${mixins.skipLink()};\n *  `;\n * // or if you have a container with several links inside it:\n * const skipLinkContainer = styled.div`\n *   ${mixins.skipLink()};\n * `;\n * ```\n * @public\n */\nfunction skipLink() {\n  return {\n    position: 'absolute',\n    '&:not(:focus-within)': {\n      overflow: 'hidden',\n      clipPath: 'inset(50%)',\n      height: '1px',\n      minHeight: '1px',\n      width: '1px',\n      minWidth: '1px',\n      padding: '0',\n      border: '0',\n      whiteSpace: 'nowrap'\n    }\n  };\n}\n/**\n * Calculates how one color would appear over another using a normal blend mode.\n * Colors can either be strings or functions, such as variable functions.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { overlayColors } from '@splunk/themes/mixins';\n *  import { interactiveColorAccent, interactiveColorOverlaySelected } from '@splunk/themes/variables';\n *\n *  const myButton = styled.button`\n *      background: ${overlayColors(interactiveColorAccent, interactiveColorOverlaySelected)};\n *  `\n *  ```\n * @name overlayColors\n * @kind function\n * @param {string|function} background\n * @param {string|function} foreground The color to overlay over the background.\n * @public\n */\nfunction overlayColors(c1, c2) {\n  return function (props) {\n    var c1Value = typeof c1 === 'function' ? c1(props) : c1;\n    var c2Value = typeof c2 === 'function' ? c2(props) : c2;\n    var c3 = (0, _colorBlend.normal)((0, _tinycolor[\"default\"])(c1Value).toRgb(), (0, _tinycolor[\"default\"])(c2Value).toRgb());\n    return (0, _tinycolor[\"default\"])(c3).toRgbString();\n  };\n}\n\n/**\n * Sets the alpha value on a given color.\n *\n *  ##### Example\n *  ```js\n *  import styled from 'styled-components';\n *  import { colorWithAlpha } from '@splunk/themes/mixins';\n *  import { actionColorBackgroundPrimary } from '@splunk/themes/variables';\n *\n *  const myButton = styled.button`\n *      background: ${colorWithAlpha(actionColorBackgroundPrimary, 0.5)};\n *  `\n *  ```\n * @name colorWithAlpha\n * @kind function\n * @param {string|function} color\n * @param {number} alpha The alpha value accepts range between 0-1.\n * @public\n */\nfunction colorWithAlpha(color, alpha) {\n  return function (props) {\n    var colorValue = typeof color === 'function' ? color(props) : color;\n    if (false) // removed by dead control flow\n{}\n    return (0, _tinycolor[\"default\"])(colorValue).setAlpha(alpha).toRgbString();\n  };\n}\nvar _default = {\n  clearfix: clearfix,\n  ellipsis: ellipsis,\n  printWidth100Percent: printWidth100Percent,\n  printHide: printHide,\n  printNoBackground: printNoBackground,\n  printWrapAll: printWrapAll,\n  screenReaderContent: screenReaderContent,\n  skipLink: skipLink,\n  colorWithAlpha: colorWithAlpha,\n  overlayColors: overlayColors\n};\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///4989\n\n}")},4993:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar baseGet = __webpack_require__(23153),\n    baseSet = __webpack_require__(5813),\n    castPath = __webpack_require__(49892);\n\n/**\n * The base implementation of  `_.pickBy` without support for iteratee shorthands.\n *\n * @private\n * @param {Object} object The source object.\n * @param {string[]} paths The property paths to pick.\n * @param {Function} predicate The function invoked per property.\n * @returns {Object} Returns the new object.\n */\nfunction basePickBy(object, paths, predicate) {\n  var index = -1,\n      length = paths.length,\n      result = {};\n\n  while (++index < length) {\n    var path = paths[index],\n        value = baseGet(object, path);\n\n    if (predicate(value, path)) {\n      baseSet(result, castPath(path, object), value);\n    }\n  }\n  return result;\n}\n\nmodule.exports = basePickBy;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDk5My5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsY0FBYyxtQkFBTyxDQUFDLEtBQVkiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9fYmFzZVBpY2tCeS5qcz8zYjU0Il0sInNvdXJjZXNDb250ZW50IjpbInZhciBiYXNlR2V0ID0gcmVxdWlyZSgnLi9fYmFzZUdldCcpLFxuICAgIGJhc2VTZXQgPSByZXF1aXJlKCcuL19iYXNlU2V0JyksXG4gICAgY2FzdFBhdGggPSByZXF1aXJlKCcuL19jYXN0UGF0aCcpO1xuXG4vKipcbiAqIFRoZSBiYXNlIGltcGxlbWVudGF0aW9uIG9mICBgXy5waWNrQnlgIHdpdGhvdXQgc3VwcG9ydCBmb3IgaXRlcmF0ZWUgc2hvcnRoYW5kcy5cbiAqXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtPYmplY3R9IG9iamVjdCBUaGUgc291cmNlIG9iamVjdC5cbiAqIEBwYXJhbSB7c3RyaW5nW119IHBhdGhzIFRoZSBwcm9wZXJ0eSBwYXRocyB0byBwaWNrLlxuICogQHBhcmFtIHtGdW5jdGlvbn0gcHJlZGljYXRlIFRoZSBmdW5jdGlvbiBpbnZva2VkIHBlciBwcm9wZXJ0eS5cbiAqIEByZXR1cm5zIHtPYmplY3R9IFJldHVybnMgdGhlIG5ldyBvYmplY3QuXG4gKi9cbmZ1bmN0aW9uIGJhc2VQaWNrQnkob2JqZWN0LCBwYXRocywgcHJlZGljYXRlKSB7XG4gIHZhciBpbmRleCA9IC0xLFxuICAgICAgbGVuZ3RoID0gcGF0aHMubGVuZ3RoLFxuICAgICAgcmVzdWx0ID0ge307XG5cbiAgd2hpbGUgKCsraW5kZXggPCBsZW5ndGgpIHtcbiAgICB2YXIgcGF0aCA9IHBhdGhzW2luZGV4XSxcbiAgICAgICAgdmFsdWUgPSBiYXNlR2V0KG9iamVjdCwgcGF0aCk7XG5cbiAgICBpZiAocHJlZGljYXRlKHZhbHVlLCBwYXRoKSkge1xuICAgICAgYmFzZVNldChyZXN1bHQsIGNhc3RQYXRoKHBhdGgsIG9iamVjdCksIHZhbHVlKTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHJlc3VsdDtcbn1cblxubW9kdWxlLmV4cG9ydHMgPSBiYXNlUGlja0J5O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///4993\n\n}")},5169:function(__unused_webpack_module,exports){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\n/**\n * An error thrown when an element was queried at a certain index of an\n * Observable, but no such index or position exists in that sequence.\n *\n * @see {@link elementAt}\n * @see {@link take}\n * @see {@link takeLast}\n *\n * @class ArgumentOutOfRangeError\n */\nvar ArgumentOutOfRangeError = (function (_super) {\n    __extends(ArgumentOutOfRangeError, _super);\n    function ArgumentOutOfRangeError() {\n        var err = _super.call(this, 'argument out of range');\n        this.name = err.name = 'ArgumentOutOfRangeError';\n        this.stack = err.stack;\n        this.message = err.message;\n    }\n    return ArgumentOutOfRangeError;\n}(Error));\nexports.ArgumentOutOfRangeError = ArgumentOutOfRangeError;\n//# sourceMappingURL=ArgumentOutOfRangeError.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTE2OS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiO0FBQ0E7QUFDQSxvQkFBb0I7QUFDcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNULFNBQVM7QUFDVCxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsQ0FBQztBQUNELCtCQUErQjtBQUMvQiIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcnhqcy91dGlsL0FyZ3VtZW50T3V0T2ZSYW5nZUVycm9yLmpzPzg0ZGIiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgX19leHRlbmRzID0gKHRoaXMgJiYgdGhpcy5fX2V4dGVuZHMpIHx8IGZ1bmN0aW9uIChkLCBiKSB7XG4gICAgZm9yICh2YXIgcCBpbiBiKSBpZiAoYi5oYXNPd25Qcm9wZXJ0eShwKSkgZFtwXSA9IGJbcF07XG4gICAgZnVuY3Rpb24gX18oKSB7IHRoaXMuY29uc3RydWN0b3IgPSBkOyB9XG4gICAgZC5wcm90b3R5cGUgPSBiID09PSBudWxsID8gT2JqZWN0LmNyZWF0ZShiKSA6IChfXy5wcm90b3R5cGUgPSBiLnByb3RvdHlwZSwgbmV3IF9fKCkpO1xufTtcbi8qKlxuICogQW4gZXJyb3IgdGhyb3duIHdoZW4gYW4gZWxlbWVudCB3YXMgcXVlcmllZCBhdCBhIGNlcnRhaW4gaW5kZXggb2YgYW5cbiAqIE9ic2VydmFibGUsIGJ1dCBubyBzdWNoIGluZGV4IG9yIHBvc2l0aW9uIGV4aXN0cyBpbiB0aGF0IHNlcXVlbmNlLlxuICpcbiAqIEBzZWUge0BsaW5rIGVsZW1lbnRBdH1cbiAqIEBzZWUge0BsaW5rIHRha2V9XG4gKiBAc2VlIHtAbGluayB0YWtlTGFzdH1cbiAqXG4gKiBAY2xhc3MgQXJndW1lbnRPdXRPZlJhbmdlRXJyb3JcbiAqL1xudmFyIEFyZ3VtZW50T3V0T2ZSYW5nZUVycm9yID0gKGZ1bmN0aW9uIChfc3VwZXIpIHtcbiAgICBfX2V4dGVuZHMoQXJndW1lbnRPdXRPZlJhbmdlRXJyb3IsIF9zdXBlcik7XG4gICAgZnVuY3Rpb24gQXJndW1lbnRPdXRPZlJhbmdlRXJyb3IoKSB7XG4gICAgICAgIHZhciBlcnIgPSBfc3VwZXIuY2FsbCh0aGlzLCAnYXJndW1lbnQgb3V0IG9mIHJhbmdlJyk7XG4gICAgICAgIHRoaXMubmFtZSA9IGVyci5uYW1lID0gJ0FyZ3VtZW50T3V0T2ZSYW5nZUVycm9yJztcbiAgICAgICAgdGhpcy5zdGFjayA9IGVyci5zdGFjaztcbiAgICAgICAgdGhpcy5tZXNzYWdlID0gZXJyLm1lc3NhZ2U7XG4gICAgfVxuICAgIHJldHVybiBBcmd1bWVudE91dE9mUmFuZ2VFcnJvcjtcbn0oRXJyb3IpKTtcbmV4cG9ydHMuQXJndW1lbnRPdXRPZlJhbmdlRXJyb3IgPSBBcmd1bWVudE91dE9mUmFuZ2VFcnJvcjtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPUFyZ3VtZW50T3V0T2ZSYW5nZUVycm9yLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///5169\n\n}")},5267:(__unused_webpack_module,exports)=>{"use strict";eval("{\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\nfunction _typeof(o) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && \"function\" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? \"symbol\" : typeof o; }, _typeof(o); }\nfunction ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }\nfunction _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }\nfunction _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }\nfunction _toPropertyKey(t) { var i = _toPrimitive(t, \"string\"); return \"symbol\" == _typeof(i) ? i : i + \"\"; }\nfunction _toPrimitive(t, r) { if (\"object\" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || \"default\"); if (\"object\" != _typeof(i)) return i; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (\"string\" === r ? String : Number)(t); }\n/**\n * #### Deprecated tokens\n *\n * @categoryValue\n */\nvar deprecated = {\n  contentColorInfo: '',\n  contentColorWarning: '',\n  contentColorPositive: '',\n  contentColorNegativeStrong: '',\n  /**\n   * Use a more specific token based on the semantic use case:\n   * [`interactiveColorAccent`](#interactiveColorAccent), [`contentColorAccent`](#contentColorAccent), or [`focusColor`](#focusColor).\n   */\n  interactiveColorPrimary: '',\n  /**\n   * Use `statusColorNormal`, `accentColor`, or ...\n   */\n  accentColorPositive: '',\n  accentColorWarning: '',\n  accentColorAlert: '',\n  accentColorNegative: '',\n  /**\n   * Use `contentColorDefault`\n   */\n  textColor: '',\n  /**\n   * Use `contentColorMuted`\n   */\n  textGray: '',\n  /**\n   * Use [`contentColorLink`](#contentColorLink) instead.\n   */\n  linkColor: '',\n  /**\n   * `Link` hover interaction should use `text-decoration: underline`, color should not change\n   */\n  linkColorHover: '',\n  /**\n   * Use `borderColorWeak`\n   */\n  borderLightColor: '',\n  /**\n   * Use `contentColorDisabled`\n   */\n  textDisabledColor: '',\n  /**\n   * Use `spacingXSmall`\n   */\n  spacingQuarter: '',\n  /**\n   * Use `spacingSmall`\n   */\n  spacingHalf: '',\n  /**\n   * Use `spacingLarge`\n   */\n  spacing: '',\n  /**\n   * Use `backgroundColorPage`\n   */\n  backgroundColor: '',\n  /**\n   * Set border using CSS and [borderColor](#borderColor).\n   */\n  border: '',\n  /**\n   * Set border using CSS and [borderColorStrong](#borderColorStrong).\n   */\n  borderDark: '',\n  /**\n   * Set border using CSS and [borderColorWeak](#borderColorWeak).\n   */\n  borderLight: '',\n  /**\n   * Use `interactiveColorBorderActive` for Data Entry components or `actionColorBorderSecondaryActive` for Buttons.\n   */\n  borderActiveColor: '',\n  /**\n   * Use `interactiveColorOverlayHover` for Data Entry components or `actionColorBackgroundSecondaryHover` for Buttons.\n   */\n  backgroundColorHover: '',\n  /**\n   * Don't use hover shadows - see notes on backgroundColorHover for hover affordances.\n   */\n  hoverShadow: '',\n  /**\n   *  Use `notificationColorInfo` or `severityColorInfo`\n   */\n  statusColorInfo: '',\n  /**\n   *  Use `notificationColorInfoWeak`\n   */\n  statusColorInfoWeak: '',\n  /**\n   *  Use `notificationColorInfoStrong`\n   */\n  statusColorInfoStrong: '',\n  /**\n   * Use `notificationColorPositive` or `severityColorNormal`\n   */\n  statusColorNormal: '',\n  /**\n   * Use `notificationColorPositiveWeak`\n   */\n  statusColorNormalWeak: '',\n  /**\n   * Use `notificationColorPositiveStrong`\n   */\n  statusColorNormalStrong: '',\n  /**\n   * Use `notificationColorCaution` or `severityColorNotice`\n   */\n  statusColorLow: '',\n  /**\n   * Use `notificationColorCautionWeak`\n   */\n  statusColorLowWeak: '',\n  /**\n   * Use `notificationColorCautionStrong`\n   */\n  statusColorLowStrong: '',\n  /**\n   * Use `severityColorWarning`\n   */\n  statusColorMedium: '',\n  statusColorMediumWeak: '',\n  statusColorMediumStrong: '',\n  /**\n   * Use `notificationColorNegative` or `severityColorAlert`\n   */\n  statusColorHigh: '',\n  /**\n   * Use `notificationColorNegativeWeak`\n   */\n  statusColorHighWeak: '',\n  /**\n   * Use `notificationColorNegativeStrong`\n   */\n  statusColorHighStrong: '',\n  /**\n   * Default color for critical alerts or urgent messages.\n   */\n  statusColorCritical: '',\n  /**\n   * Weaker, less prominent critical color, does not pass 3:1 graphical or 4.5:1 text contrast.\n   */\n  statusColorCriticalWeak: '',\n  /**\n   * Brighter, more prominent critical color.\n   */\n  statusColorCriticalStrong: '',\n  brandColorL50: '',\n  brandColorL40: '',\n  brandColorL30: '',\n  brandColorL20: '',\n  brandColorL10: '',\n  brandColor: '',\n  brandColorD10: '',\n  brandColorD20: '',\n  brandColorD30: '',\n  brandColorD40: '',\n  brandColorD50: '',\n  gray98: '',\n  gray96: '',\n  gray92: '',\n  gray80: '',\n  gray60: '',\n  gray45: '',\n  gray30: '',\n  gray25: '',\n  gray22: '',\n  gray20: '',\n  accentColorL50: '',\n  accentColorL40: '',\n  accentColorL30: '',\n  accentColorL20: '',\n  accentColorL10: '',\n  accentColor: '',\n  accentColorD10: '',\n  accentColorD20: '',\n  accentColorD30: '',\n  accentColorD40: '',\n  accentColorD50: '',\n  errorColorL50: '',\n  errorColorL40: '',\n  errorColorL30: '',\n  errorColorL20: '',\n  errorColorL10: '',\n  errorColor: '',\n  errorColorD10: '',\n  errorColorD20: '',\n  errorColorD30: '',\n  errorColorD40: '',\n  errorColorD50: '',\n  alertColorL50: '',\n  alertColorL40: '',\n  alertColorL30: '',\n  alertColorL20: '',\n  alertColorL10: '',\n  alertColor: '',\n  alertColorD10: '',\n  alertColorD20: '',\n  alertColorD30: '',\n  alertColorD40: '',\n  alertColorD50: '',\n  warningColorL50: '',\n  warningColorL40: '',\n  warningColorL30: '',\n  warningColorL20: '',\n  warningColorL10: '',\n  warningColor: '',\n  warningColorD10: '',\n  warningColorD20: '',\n  warningColorD30: '',\n  warningColorD40: '',\n  warningColorD50: '',\n  successColorL50: '',\n  successColorL40: '',\n  successColorL30: '',\n  successColorL20: '',\n  successColorL10: '',\n  successColor: '',\n  successColorD10: '',\n  successColorD20: '',\n  successColorD30: '',\n  successColorD40: '',\n  successColorD50: '',\n  infoColorL50: '',\n  infoColorL40: '',\n  infoColorL30: '',\n  infoColorL20: '',\n  infoColorL10: '',\n  infoColor: '',\n  infoColorD10: '',\n  infoColorD20: '',\n  infoColorD30: '',\n  infoColorD40: '',\n  infoColorD50: '',\n  diverging1ColorA: '',\n  diverging1ColorB: '',\n  diverging2ColorA: '',\n  diverging2ColorB: '',\n  diverging3ColorA: '',\n  diverging3ColorB: '',\n  diverging4ColorA: '',\n  diverging4ColorB: '',\n  diverging5ColorA: '',\n  diverging5ColorB: '',\n  cat1Color: '',\n  cat1ColorL: '',\n  cat2Color: '',\n  cat2ColorL: '',\n  cat3Color: '',\n  cat3ColorL: '',\n  cat4Color: '',\n  cat4ColorL: '',\n  cat5Color: '',\n  cat5ColorL: '',\n  cat6Color: '',\n  cat6ColorL: '',\n  cat7Color: '',\n  cat7ColorL: '',\n  cat8Color: '',\n  cat8ColorL: '',\n  cat9Color: '',\n  cat9ColorL: '',\n  cat10Color: '',\n  cat10ColorL: '',\n  cat11Color: '',\n  cat11ColorL: '',\n  cat12Color: '',\n  cat12ColorL: '',\n  cat13Color: '',\n  cat13ColorL: '',\n  cat14Color: '',\n  cat14ColorL: '',\n  cat15Color: '',\n  cat15ColorL: '',\n  cat16Color: '',\n  cat16ColorL: '',\n  cat17Color: '',\n  cat17ColorL: '',\n  cat18Color: '',\n  cat18ColorL: '',\n  cat19Color: '',\n  cat19ColorL: '',\n  cat20Color: '',\n  cat20ColorL: '',\n  cat21Color: '',\n  cat21ColorL: '',\n  cat22Color: '',\n  cat22ColorL: '',\n  cat23Color: '',\n  cat23ColorL: '',\n  cat24Color: '',\n  cat24ColorL: '',\n  cat25Color: '',\n  cat25ColorL: '',\n  cat26Color: '',\n  cat26ColorL: '',\n  cat27Color: '',\n  cat27ColorL: '',\n  cat28Color: '',\n  cat28ColorL: '',\n  cat29Color: '',\n  cat29ColorL: '',\n  cat30Color: '',\n  cat30ColorL: '',\n  syntaxBlueLight: '',\n  syntaxGreenLight: '',\n  syntaxPurpleLight: '',\n  syntaxRedLight: ''\n};\nvar _default = _objectSpread({}, deprecated);\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///5267\n\n}")},5414:(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createSnapModifier: () => (/* binding */ createSnapModifier),\n/* harmony export */   restrictToFirstScrollableAncestor: () => (/* binding */ restrictToFirstScrollableAncestor),\n/* harmony export */   restrictToHorizontalAxis: () => (/* binding */ restrictToHorizontalAxis),\n/* harmony export */   restrictToParentElement: () => (/* binding */ restrictToParentElement),\n/* harmony export */   restrictToVerticalAxis: () => (/* binding */ restrictToVerticalAxis),\n/* harmony export */   restrictToWindowEdges: () => (/* binding */ restrictToWindowEdges),\n/* harmony export */   snapCenterToCursor: () => (/* binding */ snapCenterToCursor)\n/* harmony export */ });\n/* harmony import */ var _dnd_kit_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56550);\n\n\nfunction createSnapModifier(gridSize) {\n  return _ref => {\n    let {\n      transform\n    } = _ref;\n    return { ...transform,\n      x: Math.ceil(transform.x / gridSize) * gridSize,\n      y: Math.ceil(transform.y / gridSize) * gridSize\n    };\n  };\n}\n\nconst restrictToHorizontalAxis = _ref => {\n  let {\n    transform\n  } = _ref;\n  return { ...transform,\n    y: 0\n  };\n};\n\nfunction restrictToBoundingRect(transform, rect, boundingRect) {\n  const value = { ...transform\n  };\n\n  if (rect.top + transform.y <= boundingRect.top) {\n    value.y = boundingRect.top - rect.top;\n  } else if (rect.bottom + transform.y >= boundingRect.top + boundingRect.height) {\n    value.y = boundingRect.top + boundingRect.height - rect.bottom;\n  }\n\n  if (rect.left + transform.x <= boundingRect.left) {\n    value.x = boundingRect.left - rect.left;\n  } else if (rect.right + transform.x >= boundingRect.left + boundingRect.width) {\n    value.x = boundingRect.left + boundingRect.width - rect.right;\n  }\n\n  return value;\n}\n\nconst restrictToParentElement = _ref => {\n  let {\n    containerNodeRect,\n    draggingNodeRect,\n    transform\n  } = _ref;\n\n  if (!draggingNodeRect || !containerNodeRect) {\n    return transform;\n  }\n\n  return restrictToBoundingRect(transform, draggingNodeRect, containerNodeRect);\n};\n\nconst restrictToFirstScrollableAncestor = _ref => {\n  let {\n    draggingNodeRect,\n    transform,\n    scrollableAncestorRects\n  } = _ref;\n  const firstScrollableAncestorRect = scrollableAncestorRects[0];\n\n  if (!draggingNodeRect || !firstScrollableAncestorRect) {\n    return transform;\n  }\n\n  return restrictToBoundingRect(transform, draggingNodeRect, firstScrollableAncestorRect);\n};\n\nconst restrictToVerticalAxis = _ref => {\n  let {\n    transform\n  } = _ref;\n  return { ...transform,\n    x: 0\n  };\n};\n\nconst restrictToWindowEdges = _ref => {\n  let {\n    transform,\n    draggingNodeRect,\n    windowRect\n  } = _ref;\n\n  if (!draggingNodeRect || !windowRect) {\n    return transform;\n  }\n\n  return restrictToBoundingRect(transform, draggingNodeRect, windowRect);\n};\n\nconst snapCenterToCursor = _ref => {\n  let {\n    activatorEvent,\n    draggingNodeRect,\n    transform\n  } = _ref;\n\n  if (draggingNodeRect && activatorEvent) {\n    const activatorCoordinates = (0,_dnd_kit_utilities__WEBPACK_IMPORTED_MODULE_0__.getEventCoordinates)(activatorEvent);\n\n    if (!activatorCoordinates) {\n      return transform;\n    }\n\n    const offsetX = activatorCoordinates.x - draggingNodeRect.left;\n    const offsetY = activatorCoordinates.y - draggingNodeRect.top;\n    return { ...transform,\n      x: transform.x + offsetX - draggingNodeRect.width / 2,\n      y: transform.y + offsetY - draggingNodeRect.height / 2\n    };\n  }\n\n  return transform;\n};\n\n\n//# sourceMappingURL=modifiers.esm.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///5414\n\n}")},5619:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\nvar async_1 = __webpack_require__(19545);\nvar timeoutWith_1 = __webpack_require__(52334);\n/* tslint:enable:max-line-length */\n/**\n *\n * Errors if Observable does not emit a value in given time span, in case of which\n * subscribes to the second Observable.\n *\n * <span class="informal">It\'s a version of `timeout` operator that let\'s you specify fallback Observable.</span>\n *\n * <img src="./img/timeoutWith.png" width="100%">\n *\n * `timeoutWith` is a variation of `timeout` operator. It behaves exactly the same,\n * still accepting as a first argument either a number or a Date, which control - respectively -\n * when values of source Observable should be emitted or when it should complete.\n *\n * The only difference is that it accepts a second, required parameter. This parameter\n * should be an Observable which will be subscribed when source Observable fails any timeout check.\n * So whenever regular `timeout` would emit an error, `timeoutWith` will instead start re-emitting\n * values from second Observable. Note that this fallback Observable is not checked for timeouts\n * itself, so it can emit values and complete at arbitrary points in time. From the moment of a second\n * subscription, Observable returned from `timeoutWith` simply mirrors fallback stream. When that\n * stream completes, it completes as well.\n *\n * Scheduler, which in case of `timeout` is provided as as second argument, can be still provided\n * here - as a third, optional parameter. It still is used to schedule timeout checks and -\n * as a consequence - when second Observable will be subscribed, since subscription happens\n * immediately after failing check.\n *\n * @example <caption>Add fallback observable</caption>\n * const seconds = Rx.Observable.interval(1000);\n * const minutes = Rx.Observable.interval(60 * 1000);\n *\n * seconds.timeoutWith(900, minutes)\n *     .subscribe(\n *         value => console.log(value), // After 900ms, will start emitting `minutes`,\n *                                      // since first value of `seconds` will not arrive fast enough.\n *         err => console.log(err) // Would be called after 900ms in case of `timeout`,\n *                                 // but here will never be called.\n *     );\n *\n * @param {number|Date} due Number specifying period within which Observable must emit values\n *                          or Date specifying before when Observable should complete\n * @param {Observable<T>} withObservable Observable which will be subscribed if source fails timeout check.\n * @param {Scheduler} [scheduler] Scheduler controlling when timeout checks occur.\n * @return {Observable<T>} Observable that mirrors behaviour of source or, when timeout check fails, of an Observable\n *                          passed as a second parameter.\n * @method timeoutWith\n * @owner Observable\n */\nfunction timeoutWith(due, withObservable, scheduler) {\n    if (scheduler === void 0) { scheduler = async_1.async; }\n    return timeoutWith_1.timeoutWith(due, withObservable, scheduler)(this);\n}\nexports.timeoutWith = timeoutWith;\n//# sourceMappingURL=timeoutWith.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///5619\n\n}')},5653:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar bufferCount_1 = __webpack_require__(15457);\nObservable_1.Observable.prototype.bufferCount = bufferCount_1.bufferCount;\n//# sourceMappingURL=bufferCount.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTY1My5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLG9CQUFvQixtQkFBTyxDQUFDLEtBQTRCO0FBQ3hEO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvYWRkL29wZXJhdG9yL2J1ZmZlckNvdW50LmpzP2MwYzkiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgT2JzZXJ2YWJsZV8xID0gcmVxdWlyZSgnLi4vLi4vT2JzZXJ2YWJsZScpO1xudmFyIGJ1ZmZlckNvdW50XzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9idWZmZXJDb3VudCcpO1xuT2JzZXJ2YWJsZV8xLk9ic2VydmFibGUucHJvdG90eXBlLmJ1ZmZlckNvdW50ID0gYnVmZmVyQ291bnRfMS5idWZmZXJDb3VudDtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWJ1ZmZlckNvdW50LmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///5653\n\n}")},5813:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar assignValue = __webpack_require__(38572),\n    castPath = __webpack_require__(49892),\n    isIndex = __webpack_require__(59858),\n    isObject = __webpack_require__(89862),\n    toKey = __webpack_require__(16410);\n\n/**\n * The base implementation of `_.set`.\n *\n * @private\n * @param {Object} object The object to modify.\n * @param {Array|string} path The path of the property to set.\n * @param {*} value The value to set.\n * @param {Function} [customizer] The function to customize path creation.\n * @returns {Object} Returns `object`.\n */\nfunction baseSet(object, path, value, customizer) {\n  if (!isObject(object)) {\n    return object;\n  }\n  path = castPath(path, object);\n\n  var index = -1,\n      length = path.length,\n      lastIndex = length - 1,\n      nested = object;\n\n  while (nested != null && ++index < length) {\n    var key = toKey(path[index]),\n        newValue = value;\n\n    if (key === '__proto__' || key === 'constructor' || key === 'prototype') {\n      return object;\n    }\n\n    if (index != lastIndex) {\n      var objValue = nested[key];\n      newValue = customizer ? customizer(objValue, key, nested) : undefined;\n      if (newValue === undefined) {\n        newValue = isObject(objValue)\n          ? objValue\n          : (isIndex(path[index + 1]) ? [] : {});\n      }\n    }\n    assignValue(nested, key, newValue);\n    nested = nested[key];\n  }\n  return object;\n}\n\nmodule.exports = baseSet;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///5813\n\n}")},5905:(__unused_webpack_module,exports)=>{"use strict";eval("{\nvar SubscriptionLog = (function () {\n    function SubscriptionLog(subscribedFrame, unsubscribedFrame) {\n        if (unsubscribedFrame === void 0) { unsubscribedFrame = Number.POSITIVE_INFINITY; }\n        this.subscribedFrame = subscribedFrame;\n        this.unsubscribedFrame = unsubscribedFrame;\n    }\n    return SubscriptionLog;\n}());\nexports.SubscriptionLog = SubscriptionLog;\n//# sourceMappingURL=SubscriptionLog.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTkwNS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiO0FBQ0E7QUFDQSw0Q0FBNEM7QUFDNUM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxDQUFDO0FBQ0QsdUJBQXVCO0FBQ3ZCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQHNwbHVuay90cmFja21lLy4uLy4uL25vZGVfbW9kdWxlcy9yeGpzL3Rlc3RpbmcvU3Vic2NyaXB0aW9uTG9nLmpzP2U4NWEiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgU3Vic2NyaXB0aW9uTG9nID0gKGZ1bmN0aW9uICgpIHtcbiAgICBmdW5jdGlvbiBTdWJzY3JpcHRpb25Mb2coc3Vic2NyaWJlZEZyYW1lLCB1bnN1YnNjcmliZWRGcmFtZSkge1xuICAgICAgICBpZiAodW5zdWJzY3JpYmVkRnJhbWUgPT09IHZvaWQgMCkgeyB1bnN1YnNjcmliZWRGcmFtZSA9IE51bWJlci5QT1NJVElWRV9JTkZJTklUWTsgfVxuICAgICAgICB0aGlzLnN1YnNjcmliZWRGcmFtZSA9IHN1YnNjcmliZWRGcmFtZTtcbiAgICAgICAgdGhpcy51bnN1YnNjcmliZWRGcmFtZSA9IHVuc3Vic2NyaWJlZEZyYW1lO1xuICAgIH1cbiAgICByZXR1cm4gU3Vic2NyaXB0aW9uTG9nO1xufSgpKTtcbmV4cG9ydHMuU3Vic2NyaXB0aW9uTG9nID0gU3Vic2NyaXB0aW9uTG9nO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9U3Vic2NyaXB0aW9uTG9nLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///5905\n\n}")},6043:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\nvar audit_1 = __webpack_require__(52266);\n/**\n * Ignores source values for a duration determined by another Observable, then\n * emits the most recent value from the source Observable, then repeats this\n * process.\n *\n * <span class="informal">It\'s like {@link auditTime}, but the silencing\n * duration is determined by a second Observable.</span>\n *\n * <img src="./img/audit.png" width="100%">\n *\n * `audit` is similar to `throttle`, but emits the last value from the silenced\n * time window, instead of the first value. `audit` emits the most recent value\n * from the source Observable on the output Observable as soon as its internal\n * timer becomes disabled, and ignores source values while the timer is enabled.\n * Initially, the timer is disabled. As soon as the first source value arrives,\n * the timer is enabled by calling the `durationSelector` function with the\n * source value, which returns the "duration" Observable. When the duration\n * Observable emits a value or completes, the timer is disabled, then the most\n * recent source value is emitted on the output Observable, and this process\n * repeats for the next source value.\n *\n * @example <caption>Emit clicks at a rate of at most one click per second</caption>\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var result = clicks.audit(ev => Rx.Observable.interval(1000));\n * result.subscribe(x => console.log(x));\n *\n * @see {@link auditTime}\n * @see {@link debounce}\n * @see {@link delayWhen}\n * @see {@link sample}\n * @see {@link throttle}\n *\n * @param {function(value: T): SubscribableOrPromise} durationSelector A function\n * that receives a value from the source Observable, for computing the silencing\n * duration, returned as an Observable or a Promise.\n * @return {Observable<T>} An Observable that performs rate-limiting of\n * emissions from the source Observable.\n * @method audit\n * @owner Observable\n */\nfunction audit(durationSelector) {\n    return audit_1.audit(durationSelector)(this);\n}\nexports.audit = audit;\n//# sourceMappingURL=audit.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6043\n\n}')},6085:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/** Used as references for various `Number` constants. */\nvar MAX_SAFE_INTEGER = 9007199254740991;\n\n/**\n * Checks if `value` is a valid array-like length.\n *\n * **Note:** This method is loosely based on\n * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.\n * @example\n *\n * _.isLength(3);\n * // => true\n *\n * _.isLength(Number.MIN_VALUE);\n * // => false\n *\n * _.isLength(Infinity);\n * // => false\n *\n * _.isLength('3');\n * // => false\n */\nfunction isLength(value) {\n  return typeof value == 'number' &&\n    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;\n}\n\nmodule.exports = isLength;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9pc0xlbmd0aC5qcz9iNzQyIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBVc2VkIGFzIHJlZmVyZW5jZXMgZm9yIHZhcmlvdXMgYE51bWJlcmAgY29uc3RhbnRzLiAqL1xudmFyIE1BWF9TQUZFX0lOVEVHRVIgPSA5MDA3MTk5MjU0NzQwOTkxO1xuXG4vKipcbiAqIENoZWNrcyBpZiBgdmFsdWVgIGlzIGEgdmFsaWQgYXJyYXktbGlrZSBsZW5ndGguXG4gKlxuICogKipOb3RlOioqIFRoaXMgbWV0aG9kIGlzIGxvb3NlbHkgYmFzZWQgb25cbiAqIFtgVG9MZW5ndGhgXShodHRwOi8vZWNtYS1pbnRlcm5hdGlvbmFsLm9yZy9lY21hLTI2Mi83LjAvI3NlYy10b2xlbmd0aCkuXG4gKlxuICogQHN0YXRpY1xuICogQG1lbWJlck9mIF9cbiAqIEBzaW5jZSA0LjAuMFxuICogQGNhdGVnb3J5IExhbmdcbiAqIEBwYXJhbSB7Kn0gdmFsdWUgVGhlIHZhbHVlIHRvIGNoZWNrLlxuICogQHJldHVybnMge2Jvb2xlYW59IFJldHVybnMgYHRydWVgIGlmIGB2YWx1ZWAgaXMgYSB2YWxpZCBsZW5ndGgsIGVsc2UgYGZhbHNlYC5cbiAqIEBleGFtcGxlXG4gKlxuICogXy5pc0xlbmd0aCgzKTtcbiAqIC8vID0+IHRydWVcbiAqXG4gKiBfLmlzTGVuZ3RoKE51bWJlci5NSU5fVkFMVUUpO1xuICogLy8gPT4gZmFsc2VcbiAqXG4gKiBfLmlzTGVuZ3RoKEluZmluaXR5KTtcbiAqIC8vID0+IGZhbHNlXG4gKlxuICogXy5pc0xlbmd0aCgnMycpO1xuICogLy8gPT4gZmFsc2VcbiAqL1xuZnVuY3Rpb24gaXNMZW5ndGgodmFsdWUpIHtcbiAgcmV0dXJuIHR5cGVvZiB2YWx1ZSA9PSAnbnVtYmVyJyAmJlxuICAgIHZhbHVlID4gLTEgJiYgdmFsdWUgJSAxID09IDAgJiYgdmFsdWUgPD0gTUFYX1NBRkVfSU5URUdFUjtcbn1cblxubW9kdWxlLmV4cG9ydHMgPSBpc0xlbmd0aDtcbiJdLCJmaWxlIjoiNjA4NS5qcyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///6085\n\n}")},6182:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\nvar async_1 = __webpack_require__(19545);\n/**\n * Emits the most recently emitted value from the source Observable within\n * periodic time intervals.\n *\n * <span class="informal">Samples the source Observable at periodic time\n * intervals, emitting what it samples.</span>\n *\n * <img src="./img/sampleTime.png" width="100%">\n *\n * `sampleTime` periodically looks at the source Observable and emits whichever\n * value it has most recently emitted since the previous sampling, unless the\n * source has not emitted anything since the previous sampling. The sampling\n * happens periodically in time every `period` milliseconds (or the time unit\n * defined by the optional `scheduler` argument). The sampling starts as soon as\n * the output Observable is subscribed.\n *\n * @example <caption>Every second, emit the most recent click at most once</caption>\n * var clicks = Rx.Observable.fromEvent(document, \'click\');\n * var result = clicks.sampleTime(1000);\n * result.subscribe(x => console.log(x));\n *\n * @see {@link auditTime}\n * @see {@link debounceTime}\n * @see {@link delay}\n * @see {@link sample}\n * @see {@link throttleTime}\n *\n * @param {number} period The sampling period expressed in milliseconds or the\n * time unit determined internally by the optional `scheduler`.\n * @param {Scheduler} [scheduler=async] The {@link IScheduler} to use for\n * managing the timers that handle the sampling.\n * @return {Observable<T>} An Observable that emits the results of sampling the\n * values emitted by the source Observable at the specified time interval.\n * @method sampleTime\n * @owner Observable\n */\nfunction sampleTime(period, scheduler) {\n    if (scheduler === void 0) { scheduler = async_1.async; }\n    return function (source) { return source.lift(new SampleTimeOperator(period, scheduler)); };\n}\nexports.sampleTime = sampleTime;\nvar SampleTimeOperator = (function () {\n    function SampleTimeOperator(period, scheduler) {\n        this.period = period;\n        this.scheduler = scheduler;\n    }\n    SampleTimeOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new SampleTimeSubscriber(subscriber, this.period, this.scheduler));\n    };\n    return SampleTimeOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar SampleTimeSubscriber = (function (_super) {\n    __extends(SampleTimeSubscriber, _super);\n    function SampleTimeSubscriber(destination, period, scheduler) {\n        _super.call(this, destination);\n        this.period = period;\n        this.scheduler = scheduler;\n        this.hasValue = false;\n        this.add(scheduler.schedule(dispatchNotification, period, { subscriber: this, period: period }));\n    }\n    SampleTimeSubscriber.prototype._next = function (value) {\n        this.lastValue = value;\n        this.hasValue = true;\n    };\n    SampleTimeSubscriber.prototype.notifyNext = function () {\n        if (this.hasValue) {\n            this.hasValue = false;\n            this.destination.next(this.lastValue);\n        }\n    };\n    return SampleTimeSubscriber;\n}(Subscriber_1.Subscriber));\nfunction dispatchNotification(state) {\n    var subscriber = state.subscriber, period = state.period;\n    subscriber.notifyNext();\n    this.schedule(state, period);\n}\n//# sourceMappingURL=sampleTime.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6182\n\n}')},6242:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Subscriber_1 = __webpack_require__(42741);\n/**\n * Emits the given constant value on the output Observable every time the source\n * Observable emits a value.\n *\n * <span class=\"informal\">Like {@link map}, but it maps every source value to\n * the same output value every time.</span>\n *\n * <img src=\"./img/mapTo.png\" width=\"100%\">\n *\n * Takes a constant `value` as argument, and emits that whenever the source\n * Observable emits a value. In other words, ignores the actual source value,\n * and simply uses the emission moment to know when to emit the given `value`.\n *\n * @example <caption>Map every click to the string 'Hi'</caption>\n * var clicks = Rx.Observable.fromEvent(document, 'click');\n * var greetings = clicks.mapTo('Hi');\n * greetings.subscribe(x => console.log(x));\n *\n * @see {@link map}\n *\n * @param {any} value The value to map each source value to.\n * @return {Observable} An Observable that emits the given `value` every time\n * the source Observable emits something.\n * @method mapTo\n * @owner Observable\n */\nfunction mapTo(value) {\n    return function (source) { return source.lift(new MapToOperator(value)); };\n}\nexports.mapTo = mapTo;\nvar MapToOperator = (function () {\n    function MapToOperator(value) {\n        this.value = value;\n    }\n    MapToOperator.prototype.call = function (subscriber, source) {\n        return source.subscribe(new MapToSubscriber(subscriber, this.value));\n    };\n    return MapToOperator;\n}());\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @ignore\n * @extends {Ignored}\n */\nvar MapToSubscriber = (function (_super) {\n    __extends(MapToSubscriber, _super);\n    function MapToSubscriber(destination, value) {\n        _super.call(this, destination);\n        this.value = value;\n    }\n    MapToSubscriber.prototype._next = function (x) {\n        this.destination.next(this.value);\n    };\n    return MapToSubscriber;\n}(Subscriber_1.Subscriber));\n//# sourceMappingURL=mapTo.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6242\n\n}")},6318:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('{\n\nObject.defineProperty(exports, "__esModule", ({\n  value: true\n}));\nexports["default"] = void 0;\nvar _utils = __webpack_require__(30281);\n/**\n * The theme settings in `props.theme` are not considered an API to allow support for fallbacks\n * and forward compatibility in future versions of `SplunkThemeProvider`. Use this utility to\n * access `family`, `colorScheme`, and `density` from a component\'s props. This is useful\n * in limited migration scenarios. Use `withSplunkTheme` or `useSplunkTheme` instead.\n *\n * ```js\n * import getSettingsFromThemedProps from \'@splunk/themes/getSettingsFromThemedProps\';\n * ...\n * const { family, colorScheme } = getSettingsFromThemedProps(props);\n *\n * ```\n * @param {object} props - The themed props passed to a styled-component.\n * @returns {object} An object consisting of `{ family, colorScheme, density }`.\n * @public\n */\n\nfunction getSettingsFromThemedProps(props) {\n  var _props$theme;\n  // props.theme is sometimes null\n  var _ref = ((_props$theme = props.theme) === null || _props$theme === void 0 ? void 0 : _props$theme.splunkThemeV1) || {},\n    family = _ref.family,\n    colorScheme = _ref.colorScheme,\n    density = _ref.density;\n  return (0, _utils.addThemeDefaults)({\n    family: family,\n    colorScheme: colorScheme,\n    density: density\n  });\n}\nvar _default = getSettingsFromThemedProps;\nexports["default"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6318\n\n}')},6441:function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("{\nvar __extends = (this && this.__extends) || function (d, b) {\n    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];\n    function __() { this.constructor = d; }\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n};\nvar Observable_1 = __webpack_require__(91638);\nvar asap_1 = __webpack_require__(16732);\nvar isNumeric_1 = __webpack_require__(11239);\n/**\n * We need this JSDoc comment for affecting ESDoc.\n * @extends {Ignored}\n * @hide true\n */\nvar SubscribeOnObservable = (function (_super) {\n    __extends(SubscribeOnObservable, _super);\n    function SubscribeOnObservable(source, delayTime, scheduler) {\n        if (delayTime === void 0) { delayTime = 0; }\n        if (scheduler === void 0) { scheduler = asap_1.asap; }\n        _super.call(this);\n        this.source = source;\n        this.delayTime = delayTime;\n        this.scheduler = scheduler;\n        if (!isNumeric_1.isNumeric(delayTime) || delayTime < 0) {\n            this.delayTime = 0;\n        }\n        if (!scheduler || typeof scheduler.schedule !== 'function') {\n            this.scheduler = asap_1.asap;\n        }\n    }\n    SubscribeOnObservable.create = function (source, delay, scheduler) {\n        if (delay === void 0) { delay = 0; }\n        if (scheduler === void 0) { scheduler = asap_1.asap; }\n        return new SubscribeOnObservable(source, delay, scheduler);\n    };\n    SubscribeOnObservable.dispatch = function (arg) {\n        var source = arg.source, subscriber = arg.subscriber;\n        return this.add(source.subscribe(subscriber));\n    };\n    /** @deprecated internal use only */ SubscribeOnObservable.prototype._subscribe = function (subscriber) {\n        var delay = this.delayTime;\n        var source = this.source;\n        var scheduler = this.scheduler;\n        return scheduler.schedule(SubscribeOnObservable.dispatch, delay, {\n            source: source, subscriber: subscriber\n        });\n    };\n    return SubscribeOnObservable;\n}(Observable_1.Observable));\nexports.SubscribeOnObservable = SubscribeOnObservable;\n//# sourceMappingURL=SubscribeOnObservable.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6441\n\n}")},6616:(module,exports,__webpack_require__)=>{eval("{var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!\n  * $script.js JS loader & dependency manager\n  * https://github.com/ded/script.js\n  * (c) Dustin Diaz 2014 | License MIT\n  */\n\n(function (name, definition) {\n  if ( true && module.exports) module.exports = definition()\n  else if (true) !(__WEBPACK_AMD_DEFINE_FACTORY__ = (definition),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?\n\t\t(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :\n\t\t__WEBPACK_AMD_DEFINE_FACTORY__),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))\n  else // removed by dead control flow\n{}\n})('$script', function () {\n  var doc = document\n    , head = doc.getElementsByTagName('head')[0]\n    , s = 'string'\n    , f = false\n    , push = 'push'\n    , readyState = 'readyState'\n    , onreadystatechange = 'onreadystatechange'\n    , list = {}\n    , ids = {}\n    , delay = {}\n    , scripts = {}\n    , scriptpath\n    , urlArgs\n\n  function every(ar, fn) {\n    for (var i = 0, j = ar.length; i < j; ++i) if (!fn(ar[i])) return f\n    return 1\n  }\n  function each(ar, fn) {\n    every(ar, function (el) {\n      fn(el)\n      return 1\n    })\n  }\n\n  function $script(paths, idOrDone, optDone) {\n    paths = paths[push] ? paths : [paths]\n    var idOrDoneIsDone = idOrDone && idOrDone.call\n      , done = idOrDoneIsDone ? idOrDone : optDone\n      , id = idOrDoneIsDone ? paths.join('') : idOrDone\n      , queue = paths.length\n    function loopFn(item) {\n      return item.call ? item() : list[item]\n    }\n    function callback() {\n      if (!--queue) {\n        list[id] = 1\n        done && done()\n        for (var dset in delay) {\n          every(dset.split('|'), loopFn) && !each(delay[dset], loopFn) && (delay[dset] = [])\n        }\n      }\n    }\n    setTimeout(function () {\n      each(paths, function loading(path, force) {\n        if (path === null) return callback()\n        \n        if (!force && !/^https?:\\/\\//.test(path) && scriptpath) {\n          path = (path.indexOf('.js') === -1) ? scriptpath + path + '.js' : scriptpath + path;\n        }\n        \n        if (scripts[path]) {\n          if (id) ids[id] = 1\n          return (scripts[path] == 2) ? callback() : setTimeout(function () { loading(path, true) }, 0)\n        }\n\n        scripts[path] = 1\n        if (id) ids[id] = 1\n        create(path, callback)\n      })\n    }, 0)\n    return $script\n  }\n\n  function create(path, fn) {\n    var el = doc.createElement('script'), loaded\n    el.onload = el.onerror = el[onreadystatechange] = function () {\n      if ((el[readyState] && !(/^c|loade/.test(el[readyState]))) || loaded) return;\n      el.onload = el[onreadystatechange] = null\n      loaded = 1\n      scripts[path] = 2\n      fn()\n    }\n    el.async = 1\n    el.src = urlArgs ? path + (path.indexOf('?') === -1 ? '?' : '&') + urlArgs : path;\n    head.insertBefore(el, head.lastChild)\n  }\n\n  $script.get = create\n\n  $script.order = function (scripts, id, done) {\n    (function callback(s) {\n      s = scripts.shift()\n      !scripts.length ? $script(s, id, done) : $script(s, callback)\n    }())\n  }\n\n  $script.path = function (p) {\n    scriptpath = p\n  }\n  $script.urlArgs = function (str) {\n    urlArgs = str;\n  }\n  $script.ready = function (deps, ready, req) {\n    deps = deps[push] ? deps : [deps]\n    var missing = [];\n    !each(deps, function (dep) {\n      list[dep] || missing[push](dep);\n    }) && every(deps, function (dep) {return list[dep]}) ?\n      ready() : !function (key) {\n      delay[key] = delay[key] || []\n      delay[key][push](ready)\n      req && req(missing)\n    }(deps.join('|'))\n    return $script\n  }\n\n  $script.done = function (idOrDone) {\n    $script([null], idOrDone)\n  }\n\n  return $script\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6616\n\n}")},6656:module=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\n/**\n * The base implementation of `_.findIndex` and `_.findLastIndex` without\n * support for iteratee shorthands.\n *\n * @private\n * @param {Array} array The array to inspect.\n * @param {Function} predicate The function invoked per iteration.\n * @param {number} fromIndex The index to search from.\n * @param {boolean} [fromRight] Specify iterating from right to left.\n * @returns {number} Returns the index of the matched value, else `-1`.\n */\nfunction baseFindIndex(array, predicate, fromIndex, fromRight) {\n  var length = array.length,\n      index = fromIndex + (fromRight ? 1 : -1);\n\n  while ((fromRight ? index-- : ++index < length)) {\n    if (predicate(array[index], index, array)) {\n      return index;\n    }\n  }\n  return -1;\n}\n\nmodule.exports = baseFindIndex;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL2xvZGFzaC9fYmFzZUZpbmRJbmRleC5qcz8wZWU1Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhlIGJhc2UgaW1wbGVtZW50YXRpb24gb2YgYF8uZmluZEluZGV4YCBhbmQgYF8uZmluZExhc3RJbmRleGAgd2l0aG91dFxuICogc3VwcG9ydCBmb3IgaXRlcmF0ZWUgc2hvcnRoYW5kcy5cbiAqXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtBcnJheX0gYXJyYXkgVGhlIGFycmF5IHRvIGluc3BlY3QuXG4gKiBAcGFyYW0ge0Z1bmN0aW9ufSBwcmVkaWNhdGUgVGhlIGZ1bmN0aW9uIGludm9rZWQgcGVyIGl0ZXJhdGlvbi5cbiAqIEBwYXJhbSB7bnVtYmVyfSBmcm9tSW5kZXggVGhlIGluZGV4IHRvIHNlYXJjaCBmcm9tLlxuICogQHBhcmFtIHtib29sZWFufSBbZnJvbVJpZ2h0XSBTcGVjaWZ5IGl0ZXJhdGluZyBmcm9tIHJpZ2h0IHRvIGxlZnQuXG4gKiBAcmV0dXJucyB7bnVtYmVyfSBSZXR1cm5zIHRoZSBpbmRleCBvZiB0aGUgbWF0Y2hlZCB2YWx1ZSwgZWxzZSBgLTFgLlxuICovXG5mdW5jdGlvbiBiYXNlRmluZEluZGV4KGFycmF5LCBwcmVkaWNhdGUsIGZyb21JbmRleCwgZnJvbVJpZ2h0KSB7XG4gIHZhciBsZW5ndGggPSBhcnJheS5sZW5ndGgsXG4gICAgICBpbmRleCA9IGZyb21JbmRleCArIChmcm9tUmlnaHQgPyAxIDogLTEpO1xuXG4gIHdoaWxlICgoZnJvbVJpZ2h0ID8gaW5kZXgtLSA6ICsraW5kZXggPCBsZW5ndGgpKSB7XG4gICAgaWYgKHByZWRpY2F0ZShhcnJheVtpbmRleF0sIGluZGV4LCBhcnJheSkpIHtcbiAgICAgIHJldHVybiBpbmRleDtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIC0xO1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IGJhc2VGaW5kSW5kZXg7XG4iXSwiZmlsZSI6IjY2NTYuanMiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///6656\n\n}")},6671:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar concatMapTo_1 = __webpack_require__(95067);\nObservable_1.Observable.prototype.concatMapTo = concatMapTo_1.concatMapTo;\n//# sourceMappingURL=concatMapTo.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNjY3MS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLG9CQUFvQixtQkFBTyxDQUFDLEtBQTRCO0FBQ3hEO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvYWRkL29wZXJhdG9yL2NvbmNhdE1hcFRvLmpzPzc3ZjciXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgT2JzZXJ2YWJsZV8xID0gcmVxdWlyZSgnLi4vLi4vT2JzZXJ2YWJsZScpO1xudmFyIGNvbmNhdE1hcFRvXzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci9jb25jYXRNYXBUbycpO1xuT2JzZXJ2YWJsZV8xLk9ic2VydmFibGUucHJvdG90eXBlLmNvbmNhdE1hcFRvID0gY29uY2F0TWFwVG9fMS5jb25jYXRNYXBUbztcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWNvbmNhdE1hcFRvLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///6671\n\n}")},6685:(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("{\nvar Observable_1 = __webpack_require__(91638);\nvar takeLast_1 = __webpack_require__(91681);\nObservable_1.Observable.prototype.takeLast = takeLast_1.takeLast;\n//# sourceMappingURL=takeLast.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNjY4NS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLG1CQUFtQixtQkFBTyxDQUFDLEtBQWtCO0FBQzdDLGlCQUFpQixtQkFBTyxDQUFDLEtBQXlCO0FBQ2xEO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac3BsdW5rL3RyYWNrbWUvLi4vLi4vbm9kZV9tb2R1bGVzL3J4anMvYWRkL29wZXJhdG9yL3Rha2VMYXN0LmpzPzZmMjYiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgT2JzZXJ2YWJsZV8xID0gcmVxdWlyZSgnLi4vLi4vT2JzZXJ2YWJsZScpO1xudmFyIHRha2VMYXN0XzEgPSByZXF1aXJlKCcuLi8uLi9vcGVyYXRvci90YWtlTGFzdCcpO1xuT2JzZXJ2YWJsZV8xLk9ic2VydmFibGUucHJvdG90eXBlLnRha2VMYXN0ID0gdGFrZUxhc3RfMS50YWtlTGFzdDtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXRha2VMYXN0LmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///6685\n\n}")},6802:(module,__unused_webpack_exports,__webpack_require__)=>{eval("{/*** IMPORTS FROM imports-loader ***/\n\nvar define = false;\n\nvar getMapData = __webpack_require__(62134);\n\n/**\n * Sets the map `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf MapCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the map cache instance.\n */\nfunction mapCacheSet(key, value) {\n  var data = getMapData(this, key),\n      size = data.size;\n\n  data.set(key, value);\n  this.size += data.size == size ? 0 : 1;\n  return this;\n}\n\nmodule.exports = mapCacheSet;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNjgwMi5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsaUJBQWlCLG1CQUFPLENBQUMsS0FBZSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvbG9kYXNoL19tYXBDYWNoZVNldC5qcz83YmFkIl0sInNvdXJjZXNDb250ZW50IjpbInZhciBnZXRNYXBEYXRhID0gcmVxdWlyZSgnLi9fZ2V0TWFwRGF0YScpO1xuXG4vKipcbiAqIFNldHMgdGhlIG1hcCBga2V5YCB0byBgdmFsdWVgLlxuICpcbiAqIEBwcml2YXRlXG4gKiBAbmFtZSBzZXRcbiAqIEBtZW1iZXJPZiBNYXBDYWNoZVxuICogQHBhcmFtIHtzdHJpbmd9IGtleSBUaGUga2V5IG9mIHRoZSB2YWx1ZSB0byBzZXQuXG4gKiBAcGFyYW0geyp9IHZhbHVlIFRoZSB2YWx1ZSB0byBzZXQuXG4gKiBAcmV0dXJucyB7T2JqZWN0fSBSZXR1cm5zIHRoZSBtYXAgY2FjaGUgaW5zdGFuY2UuXG4gKi9cbmZ1bmN0aW9uIG1hcENhY2hlU2V0KGtleSwgdmFsdWUpIHtcbiAgdmFyIGRhdGEgPSBnZXRNYXBEYXRhKHRoaXMsIGtleSksXG4gICAgICBzaXplID0gZGF0YS5zaXplO1xuXG4gIGRhdGEuc2V0KGtleSwgdmFsdWUpO1xuICB0aGlzLnNpemUgKz0gZGF0YS5zaXplID09IHNpemUgPyAwIDogMTtcbiAgcmV0dXJuIHRoaXM7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gbWFwQ2FjaGVTZXQ7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///6802\n\n}")},6956:(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("{\nvar TimerObservable_1 = __webpack_require__(37925);\nexports.timer = TimerObservable_1.TimerObservable.create;\n//# sourceMappingURL=timer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNjk1Ni5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLHdCQUF3QixtQkFBTyxDQUFDLEtBQW1CO0FBQ25ELGFBQWE7QUFDYiIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvcnhqcy9vYnNlcnZhYmxlL3RpbWVyLmpzP2E0Y2MiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgVGltZXJPYnNlcnZhYmxlXzEgPSByZXF1aXJlKCcuL1RpbWVyT2JzZXJ2YWJsZScpO1xuZXhwb3J0cy50aW1lciA9IFRpbWVyT2JzZXJ2YWJsZV8xLlRpbWVyT2JzZXJ2YWJsZS5jcmVhdGU7XG4vLyMgc291cmNlTWFwcGluZ1VSTD10aW1lci5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///6956\n\n}")},7343:(module,__unused_webpack_exports,__webpack_require__)=>{eval('{/******/ (() => {\n    // webpackBootstrap\n    /******/ "use strict";\n    /******/ // The require scope\n    /******/    var e = {};\n    /******/\n    /************************************************************************/\n    /******/ /* webpack/runtime/compat get default export */\n    /******/    (() => {\n        /******/ // getDefaultExport function for compatibility with non-harmony modules\n        /******/ e.n = t => {\n            /******/ var r = t && t.__esModule ? \n            /******/ () => t["default"]\n            /******/ : () => t\n            /******/;\n            e.d(r, {\n                a: r\n            });\n            /******/            return r;\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/define property getters */\n    /******/    (() => {\n        /******/ // define getter functions for harmony exports\n        /******/ e.d = (t, r) => {\n            /******/ for (var n in r) {\n                /******/ if (e.o(r, n) && !e.o(t, n)) {\n                    /******/ Object.defineProperty(t, n, {\n                        enumerable: true,\n                        get: r[n]\n                    });\n                    /******/                }\n                /******/            }\n            /******/        };\n        /******/    })();\n    /******/\n    /******/ /* webpack/runtime/hasOwnProperty shorthand */\n    /******/    (() => {\n        /******/ e.o = (e, t) => Object.prototype.hasOwnProperty.call(e, t)\n        /******/;\n    })();\n    /******/\n    /******/ /* webpack/runtime/make namespace object */\n    /******/    (() => {\n        /******/ // define __esModule on exports\n        /******/ e.r = e => {\n            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {\n                /******/ Object.defineProperty(e, Symbol.toStringTag, {\n                    value: "Module"\n                });\n                /******/            }\n            /******/            Object.defineProperty(e, "__esModule", {\n                value: true\n            });\n            /******/        };\n        /******/    })();\n    /******/\n    /************************************************************************/    var t = {};\n    // ESM COMPAT FLAG\n        e.r(t);\n    // EXPORTS\n        e.d(t, {\n        Divider: () => /* reexport */ R,\n        Heading: () => /* reexport */ Z,\n        Item: () => /* reexport */ Se,\n        MenuContext: () => /* reexport */ N,\n        default: () => /* reexport */ qe\n    });\n    // CONCATENATED MODULE: external "react"\n    const r = __webpack_require__(14041);\n    var n =  e.n(r);\n    // CONCATENATED MODULE: external "lodash/omit"\n    const a = __webpack_require__(36728);\n    var i =  e.n(a);\n    // CONCATENATED MODULE: external "prop-types"\n    const o = __webpack_require__(39067);\n    var l =  e.n(o);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/focus"\n    const s = __webpack_require__(14412);\n    // CONCATENATED MODULE: external "styled-components"\n    const c = __webpack_require__(53057);\n    var u =  e.n(c);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Divider"\n    const d = __webpack_require__(13339);\n    var v =  e.n(d);\n    // CONCATENATED MODULE: external "@splunk/themes"\n    const p = __webpack_require__(18672);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Checkbox"\n    const f = __webpack_require__(14729);\n    var m =  e.n(f);\n    // CONCATENATED MODULE: external "@splunk/react-ui/Clickable"\n    const b = __webpack_require__(43594);\n    var g =  e.n(b);\n    // CONCATENATED MODULE: ./src/Menu/ItemStyles.ts\n    var y = (0, c.css)([ "", " overflow:inherit;white-space:inherit;text-overflow:inherit;" ], p.mixins.typography("smallBody"));\n    var h = u().div.withConfig({\n        displayName: "ItemStyles__StyledItemDescriptionBottom",\n        componentId: "sc-4kc053-0"\n    })([ "", ";" ], y);\n    var S = u().span.withConfig({\n        displayName: "ItemStyles__StyledItemDescriptionRight",\n        componentId: "sc-4kc053-1"\n    })([ "", ";display:flex;align-self:flex-start;align-items:center;float:right;padding-left:", ";max-width:50%;min-height:20px;text-align:right;" ], y, p.variables.spacingLarge);\n    var w = (0, c.css)([ "", " flex:0 0 auto;& > svg{height:20px;}" ], p.mixins.reset("inline-flex"));\n    var O = u().div.withConfig({\n        displayName: "ItemStyles__StyledItemSelectedAdornment",\n        componentId: "sc-4kc053-2"\n    })([ "", ";padding-left:", ";align-items:flex-start;color:", ";" ], w, p.variables.spacingLarge, p.variables.contentColorActive);\n    var k = u().span.withConfig({\n        displayName: "ItemStyles__StyledItemAdornment",\n        componentId: "sc-4kc053-3"\n    })([ "", ";", " padding-right:", ";align-items:center;color:", ";" ], w, (function(e) {\n        var t = e.endAdornment;\n        return t && (0, c.css)([ "padding-left:", ";" ], p.variables.spacingSmall);\n    }), p.variables.spacingSmall, p.variables.contentColorMuted);\n    var x = u()(m()).withConfig({\n        displayName: "ItemStyles__StyledCheckbox",\n        componentId: "sc-4kc053-4"\n    })([ "min-height:0;padding-right:", ";" ], p.variables.spacingSmall);\n    var C = u()(g()).withConfig({\n        displayName: "ItemStyles__StyledClickable",\n        componentId: "sc-4kc053-5"\n    })([ "line-height:", ";display:block;position:relative;cursor:pointer;color:", ";word-wrap:break-word;max-width:100%;width:100%;min-height:", ";padding:", " ", ";", " ", " ", " &:not([disabled],[aria-disabled=\'true\']){&:hover{background:", ";", "}&:active{background:", ";}", "}&:focus{outline:0;box-shadow:", ";background:", ";}&[disabled],&[aria-disabled=\'true\']{color:", ";", ",", ",", ",", "{color:", ";}}" ], p.variables.lineHeightSpacious, p.variables.contentColorActive, p.variables.inputHeight, p.variables.spacingXSmall, p.variables.spacingLarge, (function(e) {\n        var t = e.$active, r = e.$preventFocus;\n        return t && !r && (0, c.css)([ "box-shadow:", ";" ], p.variables.focusShadowInset);\n    }), (function(e) {\n        var t = e.$active;\n        return t && (0, c.css)([ "background:", ";font-weight:", ";" ], p.variables.interactiveColorOverlayActive, p.variables.fontWeightBold);\n    }), (function(e) {\n        var t = e.$isSelectable, r = e.$selectableAppearance, n = e.$selected;\n        return t && !n && r === "checkmark" && // Adds whitespace to right to reserve space for checkmark for selectable Items\n        // spacingLarge x 3 = padding-left + icon size + padding-right\n        (0, c.css)([ "padding-right:calc(", " * 3);" ], p.variables.spacingLarge);\n    }), p.variables.interactiveColorOverlayHover, (function(e) {\n        var t = e.$active;\n        return t && (0, c.css)([ "background:", ";" ], p.mixins.overlayColors(p.variables.interactiveColorOverlayActive, p.variables.interactiveColorOverlayHover));\n    }), p.variables.interactiveColorOverlayActive, (function(e) {\n        var t = e.$selected, r = e.$active;\n        return t && (0, c.css)([ "font-weight:", ";", "" ], p.variables.fontWeightSemiBold, r && (0, \n        c.css)([ "font-weight:", ";" ], p.variables.fontWeightBold));\n    }), p.variables.focusShadowInset, p.variables.interactiveColorOverlayHover, p.variables.contentColorDisabled, /* sc-sel */ h, /* sc-sel */ S, /* sc-sel */ O, /* sc-sel */ k, p.variables.contentColorDisabled);\n    var I = u().span.withConfig({\n        displayName: "ItemStyles__StyledInnerWrapper",\n        componentId: "sc-4kc053-6"\n    })([ "display:flex;align-items:flex-start;" ]);\n    var E = u().div.withConfig({\n        displayName: "ItemStyles__StyledTitleAndDescriptionWrapper",\n        componentId: "sc-4kc053-7"\n    })([ "display:flex;flex:1;width:100%;align-self:flex-start;word-break:break-word;white-space:normal;", " ", "" ], (function(e) {\n        var t = e.$descriptionBottom;\n        return t && (0, c.css)([ "flex-direction:column;" ]);\n    }), (function(e) {\n        var t = e.$truncate;\n        return t && (0, c.css)([ "white-space:nowrap;overflow:hidden;text-overflow:ellipsis;" ]);\n    }));\n    var _ = u().div.withConfig({\n        displayName: "ItemStyles__StyledLabel",\n        componentId: "sc-4kc053-8"\n    })([ "flex:1;overflow:inherit;white-space:inherit;text-overflow:inherit;max-width:100%;min-height:20px;", "" ], (function(e) {\n        var t = e.$truncate;\n        return t && (0, c.css)([ "display:block;clear:both;" ]);\n    }));\n    var P = u().span.withConfig({\n        displayName: "ItemStyles__StyledMatch",\n        componentId: "sc-4kc053-9"\n    })([ "border-bottom:1px solid ", ";" ], p.variables.contentColorActive);\n    var j = u().span.withConfig({\n        displayName: "ItemStyles__StyledSubmenu",\n        componentId: "sc-4kc053-10"\n    })([ "float:right;padding-left:", ";color:", ";" ], p.variables.spacingSmall, p.variables.contentColorDefault);\n    // CONCATENATED MODULE: ./src/Menu/DividerStyles.ts\n    // Adds margin if direct sibling is a Menu.Item to provide spacing between Divider and Item\n    var A = u()(v()).withConfig({\n        displayName: "DividerStyles__Styled",\n        componentId: "l3zfh3-0"\n    })([ "", " + &,& + ", "{margin-block-start:", ";}" ], C, C, p.variables.spacingSmall);\n    // CONCATENATED MODULE: ./src/Menu/MenuContext.tsx\n    var D =  (0, r.createContext)({\n        role: "menu",\n        preventFocus: false\n    });\n    /* harmony default export */    const N = D;\n    // CONCATENATED MODULE: ./src/Menu/Divider.tsx\n    function T() {\n        return T = Object.assign ? Object.assign.bind() : function(e) {\n            for (var t = 1; t < arguments.length; t++) {\n                var r = arguments[t];\n                for (var n in r) {\n                    ({}).hasOwnProperty.call(r, n) && (e[n] = r[n]);\n                }\n            }\n            return e;\n        }, T.apply(null, arguments);\n    }\n    var q = {};\n    /**\n * A non-interactive menu item used to visually separate groups of items in the menu.\n */    function $(e) {\n        var t = T({}, e);\n        var a = (0, r.useContext)(N), i = a.role;\n        \n        return n().createElement(A, T({\n            "aria-hidden": i === "listbox",\n            "data-test": "divider",\n            role: "separator"\n        }, t));\n    }\n    $.propTypes = q;\n    /* Remove the item if it is the first item after filtering */    $.filterFirst = true;\n    /* Remove consecutive items with filterConsecutive = true (Dividers and Headings) */    $.filterConsecutive = true;\n    /* Remove the item if it is the last item after filtering. */    $.filterLast = true;\n    /* Tag the item as Divider */    $.as = "Divider";\n    /* harmony default export */    const R = $;\n    // CONCATENATED MODULE: external "@splunk/react-ui/Heading"\n    const H = __webpack_require__(63544);\n    var F =  e.n(H);\n    // CONCATENATED MODULE: ./src/Menu/HeadingStyles.ts\n    var M = u().div.withConfig({\n        displayName: "HeadingStyles__Styled",\n        componentId: "mcd2ws-0"\n    })([ "", " border-top:1px solid transparent;padding:", " ", ";&:not(:first-child){border-top:1px solid ", ";margin-top:", ";}" ], p.mixins.reset("block"), p.variables.spacingSmall, p.variables.spacingLarge, p.variables.borderColor, p.variables.spacingSmall);\n    var L = u()(F()).withConfig({\n        displayName: "HeadingStyles__StyledHeading",\n        componentId: "mcd2ws-1"\n    })([ "color:", ";" ], p.variables.contentColorDefault);\n    // CONCATENATED MODULE: ./src/Menu/Heading.tsx\n    function K(e) {\n        "@babel/helpers - typeof";\n        return K = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {\n            return typeof e;\n        } : function(e) {\n            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;\n        }, K(e);\n    }\n    function B() {\n        return B = Object.assign ? Object.assign.bind() : function(e) {\n            for (var t = 1; t < arguments.length; t++) {\n                var r = arguments[t];\n                for (var n in r) {\n                    ({}).hasOwnProperty.call(r, n) && (e[n] = r[n]);\n                }\n            }\n            return e;\n        }, B.apply(null, arguments);\n    }\n    function W(e, t) {\n        var r = Object.keys(e);\n        if (Object.getOwnPropertySymbols) {\n            var n = Object.getOwnPropertySymbols(e);\n            t && (n = n.filter((function(t) {\n                return Object.getOwnPropertyDescriptor(e, t).enumerable;\n            }))), r.push.apply(r, n);\n        }\n        return r;\n    }\n    function z(e) {\n        for (var t = 1; t < arguments.length; t++) {\n            var r = null != arguments[t] ? arguments[t] : {};\n            t % 2 ? W(Object(r), !0).forEach((function(t) {\n                V(e, t, r[t]);\n            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(r)) : W(Object(r)).forEach((function(t) {\n                Object.defineProperty(e, t, Object.getOwnPropertyDescriptor(r, t));\n            }));\n        }\n        return e;\n    }\n    function V(e, t, r) {\n        return (t = X(t)) in e ? Object.defineProperty(e, t, {\n            value: r,\n            enumerable: !0,\n            configurable: !0,\n            writable: !0\n        }) : e[t] = r, e;\n    }\n    function X(e) {\n        var t = G(e, "string");\n        return "symbol" == K(t) ? t : t + "";\n    }\n    function G(e, t) {\n        if ("object" != K(e) || !e) return e;\n        var r = e[Symbol.toPrimitive];\n        if (void 0 !== r) {\n            var n = r.call(e, t || "default");\n            if ("object" != K(n)) return n;\n            throw new TypeError("@@toPrimitive must return a primitive value.");\n        }\n        return ("string" === t ? String : Number)(e);\n    }\n    function J(e, t) {\n        if (null == e) return {};\n        var r, n, a = Q(e, t);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (n = 0; n < i.length; n++) {\n                r = i[n], -1 === t.indexOf(r) && {}.propertyIsEnumerable.call(e, r) && (a[r] = e[r]);\n            }\n        }\n        return a;\n    }\n    function Q(e, t) {\n        if (null == e) return {};\n        var r = {};\n        for (var n in e) {\n            if ({}.hasOwnProperty.call(e, n)) {\n                if (-1 !== t.indexOf(n)) continue;\n                r[n] = e[n];\n            }\n        }\n        return r;\n    }\n    var U = {\n        children: l().node,\n        title: l().bool,\n        outerStyle: l().object\n    };\n    /**\n * A non-interactive `Menu` item used to separate and label groups of `Menu` items.\n */    function Y(e) {\n        var t = e.children, a = e.outerStyle, i = e.title, o = J(e, [ "children", "outerStyle", "title" ]);\n        // @docs-props-type HeadingPropsBase\n                var l = (0, r.useContext)(N), s = l.role;\n        var c = (0, r.useMemo)((function() {\n            return z(z({}, a), {}, {\n                margin: 0\n            });\n        }), [ a ]);\n        // headings are not supported in role="listbox"\n        // this causes Firefox to incorrectly read the total number\n        // of items in the list if it contains a heading or divider\n        // so we set them to aria-hidden to prevent that\n                \n        return n().createElement(M, {\n            "aria-hidden": s === "listbox" ? true : undefined\n        },  n().createElement(L, B({\n            style: c,\n            level: i ? 4 : 5,\n            variant: i ? "title5" : "title6",\n            "data-test": "heading"\n        }, o), t));\n    }\n    Y.propTypes = U;\n    /* Remove consecutive items with filterConsecutive = true (Dividers and Headings) */    Y.filterConsecutive = true;\n    /* Remove the item if it is the last item after filtering. */    Y.filterLast = true;\n    /* Tag the item as a Heading */    Y.as = "Heading";\n    /* harmony default export */    const Z = Y;\n    // CONCATENATED MODULE: external "lodash/isString"\n    const ee = __webpack_require__(52804);\n    var te =  e.n(ee);\n    // CONCATENATED MODULE: external "@splunk/react-icons/Checkmark"\n    const re = __webpack_require__(72820);\n    var ne =  e.n(re);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ChevronRight"\n    const ae = __webpack_require__(38315);\n    var ie =  e.n(ae);\n    // CONCATENATED MODULE: external "@splunk/react-ui/ScreenReaderContent"\n    const oe = __webpack_require__(30762);\n    var le =  e.n(oe);\n    // CONCATENATED MODULE: external "@splunk/ui-utils/i18n"\n    const se = __webpack_require__(41454);\n    // CONCATENATED MODULE: external "@splunk/react-icons/ArrowSquareTopRightInset"\n    const ce = __webpack_require__(50354);\n    var ue =  e.n(ce);\n    // CONCATENATED MODULE: ./src/Menu/icons/External.tsx\n    var de = u()(ue()).withConfig({\n        displayName: "External__Styled",\n        componentId: "sc-1turs2s-0"\n    })([ "vertical-align:text-top;margin:0 0 0 4px;" ]);\n    function ve() {\n        \n        return n().createElement(de, null);\n    }\n    /* harmony default export */    const pe = ve;\n    // CONCATENATED MODULE: ./src/Menu/Item.tsx\n    function fe() {\n        return fe = Object.assign ? Object.assign.bind() : function(e) {\n            for (var t = 1; t < arguments.length; t++) {\n                var r = arguments[t];\n                for (var n in r) {\n                    ({}).hasOwnProperty.call(r, n) && (e[n] = r[n]);\n                }\n            }\n            return e;\n        }, fe.apply(null, arguments);\n    }\n    function me(e, t) {\n        if (null == e) return {};\n        var r, n, a = be(e, t);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (n = 0; n < i.length; n++) {\n                r = i[n], -1 === t.indexOf(r) && {}.propertyIsEnumerable.call(e, r) && (a[r] = e[r]);\n            }\n        }\n        return a;\n    }\n    function be(e, t) {\n        if (null == e) return {};\n        var r = {};\n        for (var n in e) {\n            if ({}.hasOwnProperty.call(e, n)) {\n                if (-1 !== t.indexOf(n)) continue;\n                r[n] = e[n];\n            }\n        }\n        return r;\n    }\n    var ge = {\n        active: l().bool,\n        children: l().node,\n        description: l().string,\n        descriptionPosition: l().oneOf([ "right", "bottom" ]),\n        disabled: l().oneOfType([ l().bool, l().oneOf([ "dimmed", "disabled" ]) ]),\n        elementRef: l().oneOfType([ l().func, l().object ]),\n        endAdornment: l().node,\n        hasSubmenu: l().bool,\n        /** @private. The internal key of the tab */\n        itemKey: l().number,\n        matchRanges: l().arrayOf(l().shape({\n            start: l().number.isRequired,\n            end: l().number.isRequired\n        })),\n        onClick: l().func,\n        /** @private */\n        onFocus: l().func,\n        openInNewContext: l().oneOfType([ l().bool, l().string ]),\n        /** @private */\n        preventFocus: l().bool,\n        role: l().oneOf([ "menuitem", "menuitemradio", "menuitemcheckbox", "listboxitem", "option" ]),\n        selectable: l().bool,\n        selectableAppearance: l().oneOf([ "checkmark", "checkbox" ]),\n        selected: l().oneOfType([ l().bool, l().oneOf([ "some" ]) ]),\n        startAdornment: l().node,\n        to: l().string,\n        truncate: l().bool\n    };\n    var ye = (0, se._)("(Opens new window)");\n    function he(e) {\n        var t;\n        var a = e.active, o = e.children, l = e.description, s = e.descriptionPosition, c = s === void 0 ? "bottom" : s, u = e.disabled, d = e.endAdornment, v = e.elementRef, p = e.hasSubmenu, f = e.itemKey, m = e.matchRanges, b = e.onClick, g = e.onFocus, y = e.openInNewContext, w = e.role, A = e.selectable, D = e.selectableAppearance, T = D === void 0 ? "checkmark" : D, q = e.selected, $ = e.startAdornment, R = e.to, H = e.truncate, F = me(e, [ "active", "children", "description", "descriptionPosition", "disabled", "endAdornment", "elementRef", "hasSubmenu", "itemKey", "matchRanges", "onClick", "onFocus", "openInNewContext", "role", "selectable", "selectableAppearance", "selected", "startAdornment", "to", "truncate" ]);\n        // @docs-props-type ItemPropsBase\n                var M = (0, r.useContext)(N), L = M.preventFocus;\n // Use arguments[0] (raw props) to check if `selectableAppearance` was explicitly passed by the caller.\n        // This prevents the default value from incorrectly triggering the dev warning.\n        // eslint-disable-next-line prefer-rest-params\n                var K = (t = arguments[0]) === null || t === void 0 ? void 0 : t.selectableAppearance;\n        (0, r.useEffect)((function() {\n            if (false) // removed by dead control flow\n{}\n        }), [ H, c, m, o, q, A, T, K ]);\n        var B = (0, r.useCallback)((function(e) {\n            g === null || g === void 0 ? void 0 : g(e, {\n                itemKey: f\n            });\n        }), [ f, g ]);\n        var W = (0, r.useCallback)((function(e) {\n            if (L) {\n                e.preventDefault();\n            }\n        }), [ L ]);\n        var z = (0, r.useMemo)((function() {\n            if (!m || !te()(o)) {\n                return o;\n            }\n            var e = [];\n            // before first match. May be empty string.\n                        e.push(o.substring(0, m[0].start));\n            m.forEach((function(t, r) {\n                e.push(\n                \n                // eslint-disable-next-line react/no-array-index-key\n                n().createElement(P, {\n                    key: r,\n                    "data-test": "match"\n                }, o.substring(t.start, t.end)));\n                if (r < m.length - 1) {\n                    e.push(o.substring(t.end, m[r + 1].start));\n                } else {\n                    e.push(o.substring(t.end, o.length));\n                }\n            }));\n            return e;\n        }), [ o, m ]);\n        var V = q === true || q === "some";\n        var X = A || V;\n        var G = w || {\n            nonselectable: "menuitem",\n            checkmark: "menuitemradio",\n            checkbox: "menuitemcheckbox"\n        }[X ? T : "nonselectable"];\n        var J = {\n            "aria-haspopup": p ? true : undefined\n        };\n        if (G === "menuitemradio" || G === "menuitemcheckbox") {\n            J["aria-checked"] = q === "some" ? "mixed" : V;\n        } else if (G === "option") {\n            J["aria-selected"] = V;\n        }\n        var Q = l && c === "right";\n        var U = l && !Q;\n        var Y = q && T === "checkmark" &&  n().createElement(O, null,  n().createElement(ne(), {\n            "data-test": "selected-checkmark",\n            inline: true\n        }));\n        var Z = false;\n        var ee;\n        if (y) {\n            Z = true;\n            ee = typeof y === "string" ? y : ye;\n        }\n        \n        return n().createElement(C, fe({\n            $active: a,\n            $isSelectable: X,\n            $preventFocus: L || false,\n            $selectableAppearance: T !== null && T !== void 0 ? T : false,\n            $selected: V,\n            "data-has-icon": !!$ || !!d,\n            "data-test": "item",\n            "data-test-selected": X ? V : null,\n            disabled: u,\n            elementRef: v,\n            onClick: b,\n            onFocus: B,\n            onMouseDown: W,\n            openInNewContext: Z,\n            role: G,\n            tabIndex: L ? -1 : undefined,\n            to: R,\n            title: H && te()(o) ? o : undefined\n        }, J, i()(F, "onFocus")), p &&  n().createElement(j, null,  n().createElement(ie(), null)),  n().createElement(I, null, A && T === "checkbox" &&  n().createElement(x, {\n            checked: q === "some" ? "indeterminate" : q,\n            disabled: !!u,\n            inert: true\n        }), $ &&  n().createElement(k, null, $),  n().createElement(E, {\n            $descriptionBottom: !!U,\n            $truncate: H !== null && H !== void 0 ? H : false\n        },  n().createElement(_, {\n            $truncate: H !== null && H !== void 0 ? H : false,\n            "data-test": "label"\n        }, z, y &&  n().createElement(n().Fragment, null,  n().createElement(pe, null),  n().createElement(le(), null, ee))), U &&  n().createElement(h, {\n            "data-test": "description"\n        }, l), Q &&  n().createElement(S, {\n            "data-test": "description"\n        }, l)), d &&  n().createElement(k, {\n            endAdornment: d\n        }, d), Y));\n    }\n    he.propTypes = ge;\n    he.as = "Item";\n    /* harmony default export */    const Se = he;\n    // only for styled components using Item\n        // CONCATENATED MODULE: external "@splunk/react-ui/Scroll"\n    const we = __webpack_require__(83521);\n    var Oe =  e.n(we);\n    // CONCATENATED MODULE: ./src/Menu/MenuStyles.ts\n    var ke = (0, c.css)([ "border-top:1px solid ", ";" ], p.variables.borderColor);\n    var xe = (0, c.css)([ "", ";background-color:", ";border-radius:", ";min-width:60px;overflow:auto;position:relative;padding:", " 0;&:focus{outline:0;box-shadow:", ";background:", ";}& + &{", "}" ], p.mixins.reset("block"), p.variables.backgroundColorPopup, p.variables.borderRadius, p.variables.spacingSmall, p.variables.focusShadowInset, p.variables.interactiveColorOverlayHover, ke);\n    var Ce = u().div.withConfig({\n        displayName: "MenuStyles__Styled",\n        componentId: "sc-1olffp9-0"\n    })([ "", "" ], xe);\n    var Ie = u()(Oe()).withConfig({\n        displayName: "MenuStyles__StyledScroll",\n        componentId: "sc-1olffp9-1"\n    })([ "", " ", " + &,& + ", "{", "}" ], xe, /* sc-sel */ Ce, /* sc-sel */ Ce, ke);\n    // CONCATENATED MODULE: ./src/utils/updateReactRef.ts\n    /**\n * Updates a React ref. Callback refs and object refs (from `createRef` and `useRef`) are supported.\n *\n * @param ref - The React callback or object ref. Can be `null` or `undefined`.\n * @param current - The new value of the ref.\n */\n    function Ee(e, t) {\n        if (e) {\n            if (typeof e === "function") {\n                e(t);\n            } else {\n                // the public signature of this util uses React.Ref<T> to mirror the way React types refs.\n                // the intention here is to signal "we will take care of setting \'current\', not you".\n                e.current = t;\n // eslint-disable-line no-param-reassign\n                        }\n        }\n    }\n    // CONCATENATED MODULE: ./src/Menu/Menu.tsx\n    function _e() {\n        return _e = Object.assign ? Object.assign.bind() : function(e) {\n            for (var t = 1; t < arguments.length; t++) {\n                var r = arguments[t];\n                for (var n in r) {\n                    ({}).hasOwnProperty.call(r, n) && (e[n] = r[n]);\n                }\n            }\n            return e;\n        }, _e.apply(null, arguments);\n    }\n    function Pe(e, t) {\n        if (null == e) return {};\n        var r, n, a = je(e, t);\n        if (Object.getOwnPropertySymbols) {\n            var i = Object.getOwnPropertySymbols(e);\n            for (n = 0; n < i.length; n++) {\n                r = i[n], -1 === t.indexOf(r) && {}.propertyIsEnumerable.call(e, r) && (a[r] = e[r]);\n            }\n        }\n        return a;\n    }\n    function je(e, t) {\n        if (null == e) return {};\n        var r = {};\n        for (var n in e) {\n            if ({}.hasOwnProperty.call(e, n)) {\n                if (-1 !== t.indexOf(n)) continue;\n                r[n] = e[n];\n            }\n        }\n        return r;\n    }\n    var Ae = {\n        children: l().node,\n        elementRef: l().oneOfType([ l().func, l().object ]),\n        focusMode: l().oneOf([ "roving", "normal", "never" ]),\n        stopScrollPropagation: l().bool\n    };\n    // the default focus control for Menu: loop, verticalArrows(up/down keys), home/end keys\n        var De = function e() {\n        return {\n            enableLoop: true,\n            orientation: "vertical",\n            enableTab: false,\n            enableHomeEnd: true\n        };\n    };\n    var Ne = function e(t) {\n        var r = t.key;\n // Handle special case for tab navigation\n                if (r === "Tab" && (0, s.isTabKey)(t)) {\n            return t.shiftKey ? "tabShift" : "Tab";\n        }\n        return r;\n    };\n    function Te(e) {\n        var t = e.children, a = e.elementRef, o = e.focusMode, l = o === void 0 ? "roving" : o, c = e.stopScrollPropagation, u = Pe(e, [ "children", "elementRef", "focusMode", "stopScrollPropagation" ]);\n        // @docs-props-type MenuPropsBase\n                var d = (0, r.useContext)(N), v = d.role, p = v === void 0 ? "menu" : v;\n        var f = (0, r.useRef)(null);\n        var m = r.Children.toArray(t).filter(r.isValidElement).reduce((function(e, t, r, n) {\n            /* Filter out initial Dividers\n     * Requires reduce() over filter() because a Heading may have been\n     * before the Divider.\n     */\n            if (t.type.as === "Divider" && e.length === 0) {\n                return e;\n            }\n            // Filter out consecutive Dividers and Headings\n            // If Divider is next to Heading then it will remove both Heading and Divider unless Heading has title prop set to it\n                        if ((t.type.as === "Heading" || t.type.as === "Divider") && !t.props.title && t.type.filterConsecutive && n.length > r + 1) {\n                var a = n[r + 1];\n                if (a.type.as === "Heading" || a.type.as === "Divider") {\n                    return e;\n                }\n            }\n            // Filter out last Dividers and Headings\n                        if ((t.type.as === "Divider" || t.type.as === "Heading") && r === n.length - 1) {\n                return e;\n            }\n            e.push(t);\n            return e;\n        }), []);\n        var b = (0, r.useCallback)((function(e) {\n            f.current = e;\n            Ee(a, e);\n        }), [ a ]);\n        var g = De();\n        var y = (0, r.useCallback)((function(e) {\n            // if command key on Mac was pressed ignore\n            if (e.nativeEvent.metaKey) {\n                return;\n            }\n            var t = Ne(e);\n            var r = t === "Tab" || t === "tabShift";\n            var n = t === "Enter";\n            // Allow default behavior for the enter key.\n            // If tab navigation is enabled, prevent default behavior for all other keys.\n            // If tab navigation is disabled, allow default behavior for tab and tab+shift key\n                        if (!n && (g.enableTab || !r)) {\n                e.preventDefault();\n            }\n            var a = f.current;\n            var i = [];\n            if (a) {\n                i = (0, s.getSortedTabbableElements)(a, {\n                    ignoreTabIndex: true\n                });\n            }\n            var o = (e === null || e === void 0 ? void 0 : e.target) instanceof Element ? e.target : null;\n            var l = a === null || a === void 0 ? void 0 : a.querySelector(":focus");\n            var c = o || l;\n            var u = c ? i.indexOf(c) : -1;\n            (0, s.handleFocus)(t, i, u, g);\n        }), [ g ]);\n        var h = function e() {\n            return {\n                role: "menu",\n                preventFocus: l === "never"\n            };\n        };\n        var S = l === "normal" || l === "never" ? undefined : y;\n        var w = {\n            "data-test": "menu",\n            onKeyDown: S,\n            role: p\n        };\n        return c ?  n().createElement(Ie, _e({}, w, {\n            elementRef: b,\n            stopScrollPropagation: true\n        }, i()(u, "tagName")), m) :  n().createElement(Ce, _e({}, w, {\n            ref: b\n        }, u),  n().createElement(N.Provider, {\n            value: h()\n        }, m));\n    }\n    Te.propTypes = Ae;\n    Te.Item = Se;\n    Te.Divider = R;\n    Te.Heading = Z;\n    /* harmony default export */    const qe = Te;\n    // CONCATENATED MODULE: ./src/Menu/index.ts\n    module.exports = t;\n    /******/})();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNzM0My5qcyIsIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0EscUJBQXFCO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFPO0FBQzdCO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBYTtBQUNuQztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQVk7QUFDbEM7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUF3QjtBQUM5QztBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUFtQjtBQUN6QztBQUNBO0FBQ0EsY0FBYyxtQkFBTyxDQUFDLEtBQTBCO0FBQ2hEO0FBQ0E7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBZ0I7QUFDdEM7QUFDQSxjQUFjLG1CQUFPLENBQUMsS0FBMkI7QUFDakQ7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUE0QjtBQUNsRDtBQUNBO0FBQ0EsZ0RBQWdELG9CQUFvQixzQkFBc0I7QUFDMUY7QUFDQTtBQUNBO0FBQ0EsS0FBSyxVQUFVO0FBQ2Y7QUFDQTtBQUNBO0FBQ0EsS0FBSyxVQUFVLGFBQWEsc0JBQXNCLG1CQUFtQixZQUFZLGtCQUFrQixjQUFjLGdCQUFnQixpQkFBaUI7QUFDbEosNkNBQTZDLFFBQVEsYUFBYTtBQUNsRTtBQUNBO0FBQ0E7QUFDQSxLQUFLLFVBQVUsa0JBQWtCLHVCQUF1QixXQUFXO0FBQ25FO0FBQ0E7QUFDQTtBQUNBLEtBQUssVUFBVSx3QkFBd0IsbUJBQW1CLFdBQVc7QUFDckU7QUFDQSxvREFBb0Q7QUFDcEQsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUssa0JBQWtCLG1CQUFtQjtBQUMxQztBQUNBO0FBQ0E7QUFDQSxLQUFLLHNCQUFzQixjQUFjLGtCQUFrQixlQUFlLFdBQVcscUJBQXFCLGVBQWUsV0FBVyxnQkFBZ0Isa0JBQWtCLHdEQUF3RCxRQUFRLGdCQUFnQixLQUFLLFNBQVMsaUJBQWlCLEtBQUssUUFBUSxVQUFVLGdCQUFnQixpQkFBaUIsb0NBQW9DLFdBQVcsb0JBQW9CLGFBQWE7QUFDN1o7QUFDQSx3REFBd0Q7QUFDeEQsS0FBSztBQUNMO0FBQ0Esa0RBQWtELGlCQUFpQjtBQUNuRSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsbURBQW1EO0FBQ25ELEtBQUs7QUFDTDtBQUNBLGtEQUFrRDtBQUNsRCxLQUFLO0FBQ0w7QUFDQSxtREFBbUQ7QUFDbkQsbUNBQW1DO0FBQ25DLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLLGtCQUFrQix1QkFBdUI7QUFDOUM7QUFDQTtBQUNBO0FBQ0EsS0FBSyxrQkFBa0IsT0FBTyxXQUFXLHNCQUFzQixzQkFBc0IsbUJBQW1CO0FBQ3hHO0FBQ0Esd0RBQXdEO0FBQ3hELEtBQUs7QUFDTDtBQUNBLHFEQUFxRCxnQkFBZ0IsdUJBQXVCO0FBQzVGLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxLQUFLLFlBQVksaUJBQWlCLG9CQUFvQixzQkFBc0IsZUFBZSxnQkFBZ0I7QUFDM0c7QUFDQSxnREFBZ0QsV0FBVztBQUMzRCxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsS0FBSyxrQ0FBa0M7QUFDdkM7QUFDQTtBQUNBO0FBQ0EsS0FBSyxpQkFBaUIsa0JBQWtCLFdBQVc7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssdUJBQXVCLHlCQUF5QjtBQUNyRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLG9CQUFvQjtBQUNwQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWMsbUJBQU8sQ0FBQyxLQUEwQjtBQUNoRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSywyQ0FBMkMsa0JBQWtCLG9CQUFvQiwwQkFBMEIsaUJBQWlCO0FBQ2pJO0FBQ0E7QUFDQTtBQUNBLEtBQUssZ0JBQWdCO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBLHdCQUF3QixzQkFBc0I7QUFDOUM7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EseUJBQXlCLFFBQVE7QUFDakM7QUFDQSxhQUFhO0FBQ2IsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQWlCO0FBQ3hDO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBK0I7QUFDdEQ7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUFrQztBQUN6RDtBQUNBO0FBQ0EsZUFBZSxtQkFBTyxDQUFDLEtBQXNDO0FBQzdEO0FBQ0E7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBdUI7QUFDOUM7QUFDQSxlQUFlLG1CQUFPLENBQUMsS0FBOEM7QUFDckU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUssNkJBQTZCLGlCQUFpQjtBQUNuRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLHNCQUFzQjtBQUNsRDtBQUNBO0FBQ0EsdUJBQXVCO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0IsY0FBYztBQUN0QyxtREFBbUQ7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZ0JBQWdCLEtBQUssRUFBRTtBQUFBLEVBQUU7QUFDekIsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0EsU0FBUztBQUNUO0FBQ0EsU0FBUztBQUNUO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGVBQWUsbUJBQU8sQ0FBQyxLQUF5QjtBQUNoRDtBQUNBO0FBQ0EscURBQXFEO0FBQ3JELGdDQUFnQyxzQkFBc0IsbUJBQW1CLGVBQWUsY0FBYyxrQkFBa0IsZUFBZSxRQUFRLFVBQVUsZ0JBQWdCLGlCQUFpQixNQUFNLEtBQUs7QUFDck07QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUssNEJBQTRCLEtBQUs7QUFDdEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDRCQUE0QixzQkFBc0I7QUFDbEQ7QUFDQTtBQUNBLHVCQUF1QjtBQUN2QjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLGNBQWM7QUFDdEMsbURBQW1EO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsK0NBQStDO0FBQy9DO0FBQ0E7QUFDQSxTQUFTLHVEQUF1RDtBQUNoRTtBQUNBLFNBQVM7QUFDVDtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzcGx1bmsvdHJhY2ttZS8uLi8uLi9ub2RlX21vZHVsZXMvQHNwbHVuay9yZWFjdC11aS9NZW51LmpzPzRjN2QiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKi8gKCgpID0+IHtcbiAgICAvLyB3ZWJwYWNrQm9vdHN0cmFwXG4gICAgLyoqKioqKi8gXCJ1c2Ugc3RyaWN0XCI7XG4gICAgLyoqKioqKi8gLy8gVGhlIHJlcXVpcmUgc2NvcGVcbiAgICAvKioqKioqLyAgICB2YXIgZSA9IHt9O1xuICAgIC8qKioqKiovXG4gICAgLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cbiAgICAvKioqKioqLyAvKiB3ZWJwYWNrL3J1bnRpbWUvY29tcGF0IGdldCBkZWZhdWx0IGV4cG9ydCAqL1xuICAgIC8qKioqKiovICAgICgoKSA9PiB7XG4gICAgICAgIC8qKioqKiovIC8vIGdldERlZmF1bHRFeHBvcnQgZnVuY3Rpb24gZm9yIGNvbXBhdGliaWxpdHkgd2l0aCBub24taGFybW9ueSBtb2R1bGVzXG4gICAgICAgIC8qKioqKiovIGUubiA9IHQgPT4ge1xuICAgICAgICAgICAgLyoqKioqKi8gdmFyIHIgPSB0ICYmIHQuX19lc01vZHVsZSA/IFxuICAgICAgICAgICAgLyoqKioqKi8gKCkgPT4gdFtcImRlZmF1bHRcIl1cbiAgICAgICAgICAgIC8qKioqKiovIDogKCkgPT4gdFxuICAgICAgICAgICAgLyoqKioqKi87XG4gICAgICAgICAgICBlLmQociwge1xuICAgICAgICAgICAgICAgIGE6IHJcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgLyoqKioqKi8gICAgICAgICAgICByZXR1cm4gcjtcbiAgICAgICAgICAgIC8qKioqKiovICAgICAgICB9O1xuICAgICAgICAvKioqKioqLyAgICB9KSgpO1xuICAgIC8qKioqKiovXG4gICAgLyoqKioqKi8gLyogd2VicGFjay9ydW50aW1lL2RlZmluZSBwcm9wZXJ0eSBnZXR0ZXJzICovXG4gICAgLyoqKioqKi8gICAgKCgpID0+IHtcbiAgICAgICAgLyoqKioqKi8gLy8gZGVmaW5lIGdldHRlciBmdW5jdGlvbnMgZm9yIGhhcm1vbnkgZXhwb3J0c1xuICAgICAgICAvKioqKioqLyBlLmQgPSAodCwgcikgPT4ge1xuICAgICAgICAgICAgLyoqKioqKi8gZm9yICh2YXIgbiBpbiByKSB7XG4gICAgICAgICAgICAgICAgLyoqKioqKi8gaWYgKGUubyhyLCBuKSAmJiAhZS5vKHQsIG4pKSB7XG4gICAgICAgICAgICAgICAgICAgIC8qKioqKiovIE9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0LCBuLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBlbnVtZXJhYmxlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgZ2V0OiByW25dXG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAvKioqKioqLyAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgLyoqKioqKi8gICAgICAgICAgICB9XG4gICAgICAgICAgICAvKioqKioqLyAgICAgICAgfTtcbiAgICAgICAgLyoqKioqKi8gICAgfSkoKTtcbiAgICAvKioqKioqL1xuICAgIC8qKioqKiovIC8qIHdlYnBhY2svcnVudGltZS9oYXNPd25Qcm9wZXJ0eSBzaG9ydGhhbmQgKi9cbiAgICAvKioqKioqLyAgICAoKCkgPT4ge1xuICAgICAgICAvKioqKioqLyBlLm8gPSAoZSwgdCkgPT4gT2JqZWN0LnByb3RvdHlwZS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIHQpXG4gICAgICAgIC8qKioqKiovO1xuICAgIH0pKCk7XG4gICAgLyoqKioqKi9cbiAgICAvKioqKioqLyAvKiB3ZWJwYWNrL3J1bnRpbWUvbWFrZSBuYW1lc3BhY2Ugb2JqZWN0ICovXG4gICAgLyoqKioqKi8gICAgKCgpID0+IHtcbiAgICAgICAgLyoqKioqKi8gLy8gZGVmaW5lIF9fZXNNb2R1bGUgb24gZXhwb3J0c1xuICAgICAgICAvKioqKioqLyBlLnIgPSBlID0+IHtcbiAgICAgICAgICAgIC8qKioqKiovIGlmICh0eXBlb2YgU3ltYm9sICE9PSBcInVuZGVmaW5lZFwiICYmIFN5bWJvbC50b1N0cmluZ1RhZykge1xuICAgICAgICAgICAgICAgIC8qKioqKiovIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShlLCBTeW1ib2wudG9TdHJpbmdUYWcsIHtcbiAgICAgICAgICAgICAgICAgICAgdmFsdWU6IFwiTW9kdWxlXCJcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAvKioqKioqLyAgICAgICAgICAgIH1cbiAgICAgICAgICAgIC8qKioqKiovICAgICAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIFwiX19lc01vZHVsZVwiLCB7XG4gICAgICAgICAgICAgICAgdmFsdWU6IHRydWVcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgLyoqKioqKi8gICAgICAgIH07XG4gICAgICAgIC8qKioqKiovICAgIH0pKCk7XG4gICAgLyoqKioqKi9cbiAgICAvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqLyAgICB2YXIgdCA9IHt9O1xuICAgIC8vIEVTTSBDT01QQVQgRkxBR1xuICAgICAgICBlLnIodCk7XG4gICAgLy8gRVhQT1JUU1xuICAgICAgICBlLmQodCwge1xuICAgICAgICBEaXZpZGVyOiAoKSA9PiAvKiByZWV4cG9ydCAqLyBSLFxuICAgICAgICBIZWFkaW5nOiAoKSA9PiAvKiByZWV4cG9ydCAqLyBaLFxuICAgICAgICBJdGVtOiAoKSA9PiAvKiByZWV4cG9ydCAqLyBTZSxcbiAgICAgICAgTWVudUNvbnRleHQ6ICgpID0+IC8qIHJlZXhwb3J0ICovIE4sXG4gICAgICAgIGRlZmF1bHQ6ICgpID0+IC8qIHJlZXhwb3J0ICovIHFlXG4gICAgfSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJyZWFjdFwiXG4gICAgY29uc3QgciA9IHJlcXVpcmUoXCJyZWFjdFwiKTtcbiAgICB2YXIgbiA9ICBlLm4ocik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJsb2Rhc2gvb21pdFwiXG4gICAgY29uc3QgYSA9IHJlcXVpcmUoXCJsb2Rhc2gvb21pdFwiKTtcbiAgICB2YXIgaSA9ICBlLm4oYSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJwcm9wLXR5cGVzXCJcbiAgICBjb25zdCBvID0gcmVxdWlyZShcInByb3AtdHlwZXNcIik7XG4gICAgdmFyIGwgPSAgZS5uKG8pO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay91aS11dGlscy9mb2N1c1wiXG4gICAgY29uc3QgcyA9IHJlcXVpcmUoXCJAc3BsdW5rL3VpLXV0aWxzL2ZvY3VzXCIpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwic3R5bGVkLWNvbXBvbmVudHNcIlxuICAgIGNvbnN0IGMgPSByZXF1aXJlKFwic3R5bGVkLWNvbXBvbmVudHNcIik7XG4gICAgdmFyIHUgPSAgZS5uKGMpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS9EaXZpZGVyXCJcbiAgICBjb25zdCBkID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtdWkvRGl2aWRlclwiKTtcbiAgICB2YXIgdiA9ICBlLm4oZCk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3RoZW1lc1wiXG4gICAgY29uc3QgcCA9IHJlcXVpcmUoXCJAc3BsdW5rL3RoZW1lc1wiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvQ2hlY2tib3hcIlxuICAgIGNvbnN0IGYgPSByZXF1aXJlKFwiQHNwbHVuay9yZWFjdC11aS9DaGVja2JveFwiKTtcbiAgICB2YXIgbSA9ICBlLm4oZik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3JlYWN0LXVpL0NsaWNrYWJsZVwiXG4gICAgY29uc3QgYiA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL0NsaWNrYWJsZVwiKTtcbiAgICB2YXIgZyA9ICBlLm4oYik7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvTWVudS9JdGVtU3R5bGVzLnRzXG4gICAgdmFyIHkgPSAoMCwgYy5jc3MpKFsgXCJcIiwgXCIgb3ZlcmZsb3c6aW5oZXJpdDt3aGl0ZS1zcGFjZTppbmhlcml0O3RleHQtb3ZlcmZsb3c6aW5oZXJpdDtcIiBdLCBwLm1peGlucy50eXBvZ3JhcGh5KFwic21hbGxCb2R5XCIpKTtcbiAgICB2YXIgaCA9IHUoKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkl0ZW1TdHlsZXNfX1N0eWxlZEl0ZW1EZXNjcmlwdGlvbkJvdHRvbVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtMFwiXG4gICAgfSkoWyBcIlwiLCBcIjtcIiBdLCB5KTtcbiAgICB2YXIgUyA9IHUoKS5zcGFuLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJJdGVtU3R5bGVzX19TdHlsZWRJdGVtRGVzY3JpcHRpb25SaWdodFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtMVwiXG4gICAgfSkoWyBcIlwiLCBcIjtkaXNwbGF5OmZsZXg7YWxpZ24tc2VsZjpmbGV4LXN0YXJ0O2FsaWduLWl0ZW1zOmNlbnRlcjtmbG9hdDpyaWdodDtwYWRkaW5nLWxlZnQ6XCIsIFwiO21heC13aWR0aDo1MCU7bWluLWhlaWdodDoyMHB4O3RleHQtYWxpZ246cmlnaHQ7XCIgXSwgeSwgcC52YXJpYWJsZXMuc3BhY2luZ0xhcmdlKTtcbiAgICB2YXIgdyA9ICgwLCBjLmNzcykoWyBcIlwiLCBcIiBmbGV4OjAgMCBhdXRvOyYgPiBzdmd7aGVpZ2h0OjIwcHg7fVwiIF0sIHAubWl4aW5zLnJlc2V0KFwiaW5saW5lLWZsZXhcIikpO1xuICAgIHZhciBPID0gdSgpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSXRlbVN0eWxlc19fU3R5bGVkSXRlbVNlbGVjdGVkQWRvcm5tZW50XCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTRrYzA1My0yXCJcbiAgICB9KShbIFwiXCIsIFwiO3BhZGRpbmctbGVmdDpcIiwgXCI7YWxpZ24taXRlbXM6ZmxleC1zdGFydDtjb2xvcjpcIiwgXCI7XCIgXSwgdywgcC52YXJpYWJsZXMuc3BhY2luZ0xhcmdlLCBwLnZhcmlhYmxlcy5jb250ZW50Q29sb3JBY3RpdmUpO1xuICAgIHZhciBrID0gdSgpLnNwYW4ud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkl0ZW1TdHlsZXNfX1N0eWxlZEl0ZW1BZG9ybm1lbnRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtNGtjMDUzLTNcIlxuICAgIH0pKFsgXCJcIiwgXCI7XCIsIFwiIHBhZGRpbmctcmlnaHQ6XCIsIFwiO2FsaWduLWl0ZW1zOmNlbnRlcjtjb2xvcjpcIiwgXCI7XCIgXSwgdywgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIHQgPSBlLmVuZEFkb3JubWVudDtcbiAgICAgICAgcmV0dXJuIHQgJiYgKDAsIGMuY3NzKShbIFwicGFkZGluZy1sZWZ0OlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwpO1xuICAgIH0pLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsIHAudmFyaWFibGVzLmNvbnRlbnRDb2xvck11dGVkKTtcbiAgICB2YXIgeCA9IHUoKShtKCkpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJJdGVtU3R5bGVzX19TdHlsZWRDaGVja2JveFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtNFwiXG4gICAgfSkoWyBcIm1pbi1oZWlnaHQ6MDtwYWRkaW5nLXJpZ2h0OlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwpO1xuICAgIHZhciBDID0gdSgpKGcoKSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkl0ZW1TdHlsZXNfX1N0eWxlZENsaWNrYWJsZVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtNVwiXG4gICAgfSkoWyBcImxpbmUtaGVpZ2h0OlwiLCBcIjtkaXNwbGF5OmJsb2NrO3Bvc2l0aW9uOnJlbGF0aXZlO2N1cnNvcjpwb2ludGVyO2NvbG9yOlwiLCBcIjt3b3JkLXdyYXA6YnJlYWstd29yZDttYXgtd2lkdGg6MTAwJTt3aWR0aDoxMDAlO21pbi1oZWlnaHQ6XCIsIFwiO3BhZGRpbmc6XCIsIFwiIFwiLCBcIjtcIiwgXCIgXCIsIFwiIFwiLCBcIiAmOm5vdChbZGlzYWJsZWRdLFthcmlhLWRpc2FibGVkPSd0cnVlJ10peyY6aG92ZXJ7YmFja2dyb3VuZDpcIiwgXCI7XCIsIFwifSY6YWN0aXZle2JhY2tncm91bmQ6XCIsIFwiO31cIiwgXCJ9Jjpmb2N1c3tvdXRsaW5lOjA7Ym94LXNoYWRvdzpcIiwgXCI7YmFja2dyb3VuZDpcIiwgXCI7fSZbZGlzYWJsZWRdLCZbYXJpYS1kaXNhYmxlZD0ndHJ1ZSdde2NvbG9yOlwiLCBcIjtcIiwgXCIsXCIsIFwiLFwiLCBcIixcIiwgXCJ7Y29sb3I6XCIsIFwiO319XCIgXSwgcC52YXJpYWJsZXMubGluZUhlaWdodFNwYWNpb3VzLCBwLnZhcmlhYmxlcy5jb250ZW50Q29sb3JBY3RpdmUsIHAudmFyaWFibGVzLmlucHV0SGVpZ2h0LCBwLnZhcmlhYmxlcy5zcGFjaW5nWFNtYWxsLCBwLnZhcmlhYmxlcy5zcGFjaW5nTGFyZ2UsIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciB0ID0gZS4kYWN0aXZlLCByID0gZS4kcHJldmVudEZvY3VzO1xuICAgICAgICByZXR1cm4gdCAmJiAhciAmJiAoMCwgYy5jc3MpKFsgXCJib3gtc2hhZG93OlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0KTtcbiAgICB9KSwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIHQgPSBlLiRhY3RpdmU7XG4gICAgICAgIHJldHVybiB0ICYmICgwLCBjLmNzcykoWyBcImJhY2tncm91bmQ6XCIsIFwiO2ZvbnQtd2VpZ2h0OlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5pbnRlcmFjdGl2ZUNvbG9yT3ZlcmxheUFjdGl2ZSwgcC52YXJpYWJsZXMuZm9udFdlaWdodEJvbGQpO1xuICAgIH0pLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgdCA9IGUuJGlzU2VsZWN0YWJsZSwgciA9IGUuJHNlbGVjdGFibGVBcHBlYXJhbmNlLCBuID0gZS4kc2VsZWN0ZWQ7XG4gICAgICAgIHJldHVybiB0ICYmICFuICYmIHIgPT09IFwiY2hlY2ttYXJrXCIgJiYgLy8gQWRkcyB3aGl0ZXNwYWNlIHRvIHJpZ2h0IHRvIHJlc2VydmUgc3BhY2UgZm9yIGNoZWNrbWFyayBmb3Igc2VsZWN0YWJsZSBJdGVtc1xuICAgICAgICAvLyBzcGFjaW5nTGFyZ2UgeCAzID0gcGFkZGluZy1sZWZ0ICsgaWNvbiBzaXplICsgcGFkZGluZy1yaWdodFxuICAgICAgICAoMCwgYy5jc3MpKFsgXCJwYWRkaW5nLXJpZ2h0OmNhbGMoXCIsIFwiICogMyk7XCIgXSwgcC52YXJpYWJsZXMuc3BhY2luZ0xhcmdlKTtcbiAgICB9KSwgcC52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlIb3ZlciwgKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgdmFyIHQgPSBlLiRhY3RpdmU7XG4gICAgICAgIHJldHVybiB0ICYmICgwLCBjLmNzcykoWyBcImJhY2tncm91bmQ6XCIsIFwiO1wiIF0sIHAubWl4aW5zLm92ZXJsYXlDb2xvcnMocC52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlBY3RpdmUsIHAudmFyaWFibGVzLmludGVyYWN0aXZlQ29sb3JPdmVybGF5SG92ZXIpKTtcbiAgICB9KSwgcC52YXJpYWJsZXMuaW50ZXJhY3RpdmVDb2xvck92ZXJsYXlBY3RpdmUsIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciB0ID0gZS4kc2VsZWN0ZWQsIHIgPSBlLiRhY3RpdmU7XG4gICAgICAgIHJldHVybiB0ICYmICgwLCBjLmNzcykoWyBcImZvbnQtd2VpZ2h0OlwiLCBcIjtcIiwgXCJcIiBdLCBwLnZhcmlhYmxlcy5mb250V2VpZ2h0U2VtaUJvbGQsIHIgJiYgKDAsIFxuICAgICAgICBjLmNzcykoWyBcImZvbnQtd2VpZ2h0OlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5mb250V2VpZ2h0Qm9sZCkpO1xuICAgIH0pLCBwLnZhcmlhYmxlcy5mb2N1c1NoYWRvd0luc2V0LCBwLnZhcmlhYmxlcy5pbnRlcmFjdGl2ZUNvbG9yT3ZlcmxheUhvdmVyLCBwLnZhcmlhYmxlcy5jb250ZW50Q29sb3JEaXNhYmxlZCwgLyogc2Mtc2VsICovIGgsIC8qIHNjLXNlbCAqLyBTLCAvKiBzYy1zZWwgKi8gTywgLyogc2Mtc2VsICovIGssIHAudmFyaWFibGVzLmNvbnRlbnRDb2xvckRpc2FibGVkKTtcbiAgICB2YXIgSSA9IHUoKS5zcGFuLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJJdGVtU3R5bGVzX19TdHlsZWRJbm5lcldyYXBwZXJcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtNGtjMDUzLTZcIlxuICAgIH0pKFsgXCJkaXNwbGF5OmZsZXg7YWxpZ24taXRlbXM6ZmxleC1zdGFydDtcIiBdKTtcbiAgICB2YXIgRSA9IHUoKS5kaXYud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkl0ZW1TdHlsZXNfX1N0eWxlZFRpdGxlQW5kRGVzY3JpcHRpb25XcmFwcGVyXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTRrYzA1My03XCJcbiAgICB9KShbIFwiZGlzcGxheTpmbGV4O2ZsZXg6MTt3aWR0aDoxMDAlO2FsaWduLXNlbGY6ZmxleC1zdGFydDt3b3JkLWJyZWFrOmJyZWFrLXdvcmQ7d2hpdGUtc3BhY2U6bm9ybWFsO1wiLCBcIiBcIiwgXCJcIiBdLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgdCA9IGUuJGRlc2NyaXB0aW9uQm90dG9tO1xuICAgICAgICByZXR1cm4gdCAmJiAoMCwgYy5jc3MpKFsgXCJmbGV4LWRpcmVjdGlvbjpjb2x1bW47XCIgXSk7XG4gICAgfSksIChmdW5jdGlvbihlKSB7XG4gICAgICAgIHZhciB0ID0gZS4kdHJ1bmNhdGU7XG4gICAgICAgIHJldHVybiB0ICYmICgwLCBjLmNzcykoWyBcIndoaXRlLXNwYWNlOm5vd3JhcDtvdmVyZmxvdzpoaWRkZW47dGV4dC1vdmVyZmxvdzplbGxpcHNpcztcIiBdKTtcbiAgICB9KSk7XG4gICAgdmFyIF8gPSB1KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJJdGVtU3R5bGVzX19TdHlsZWRMYWJlbFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtOFwiXG4gICAgfSkoWyBcImZsZXg6MTtvdmVyZmxvdzppbmhlcml0O3doaXRlLXNwYWNlOmluaGVyaXQ7dGV4dC1vdmVyZmxvdzppbmhlcml0O21heC13aWR0aDoxMDAlO21pbi1oZWlnaHQ6MjBweDtcIiwgXCJcIiBdLCAoZnVuY3Rpb24oZSkge1xuICAgICAgICB2YXIgdCA9IGUuJHRydW5jYXRlO1xuICAgICAgICByZXR1cm4gdCAmJiAoMCwgYy5jc3MpKFsgXCJkaXNwbGF5OmJsb2NrO2NsZWFyOmJvdGg7XCIgXSk7XG4gICAgfSkpO1xuICAgIHZhciBQID0gdSgpLnNwYW4ud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkl0ZW1TdHlsZXNfX1N0eWxlZE1hdGNoXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTRrYzA1My05XCJcbiAgICB9KShbIFwiYm9yZGVyLWJvdHRvbToxcHggc29saWQgXCIsIFwiO1wiIF0sIHAudmFyaWFibGVzLmNvbnRlbnRDb2xvckFjdGl2ZSk7XG4gICAgdmFyIGogPSB1KCkuc3Bhbi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSXRlbVN0eWxlc19fU3R5bGVkU3VibWVudVwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy00a2MwNTMtMTBcIlxuICAgIH0pKFsgXCJmbG9hdDpyaWdodDtwYWRkaW5nLWxlZnQ6XCIsIFwiO2NvbG9yOlwiLCBcIjtcIiBdLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsIHAudmFyaWFibGVzLmNvbnRlbnRDb2xvckRlZmF1bHQpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL01lbnUvRGl2aWRlclN0eWxlcy50c1xuICAgIC8vIEFkZHMgbWFyZ2luIGlmIGRpcmVjdCBzaWJsaW5nIGlzIGEgTWVudS5JdGVtIHRvIHByb3ZpZGUgc3BhY2luZyBiZXR3ZWVuIERpdmlkZXIgYW5kIEl0ZW1cbiAgICB2YXIgQSA9IHUoKSh2KCkpLndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJEaXZpZGVyU3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwibDN6ZmgzLTBcIlxuICAgIH0pKFsgXCJcIiwgXCIgKyAmLCYgKyBcIiwgXCJ7bWFyZ2luLWJsb2NrLXN0YXJ0OlwiLCBcIjt9XCIgXSwgQywgQywgcC52YXJpYWJsZXMuc3BhY2luZ1NtYWxsKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9NZW51L01lbnVDb250ZXh0LnRzeFxuICAgIHZhciBEID0gICgwLCByLmNyZWF0ZUNvbnRleHQpKHtcbiAgICAgICAgcm9sZTogXCJtZW51XCIsXG4gICAgICAgIHByZXZlbnRGb2N1czogZmFsc2VcbiAgICB9KTtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IE4gPSBEO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL01lbnUvRGl2aWRlci50c3hcbiAgICBmdW5jdGlvbiBUKCkge1xuICAgICAgICByZXR1cm4gVCA9IE9iamVjdC5hc3NpZ24gPyBPYmplY3QuYXNzaWduLmJpbmQoKSA6IGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIGZvciAodmFyIHQgPSAxOyB0IDwgYXJndW1lbnRzLmxlbmd0aDsgdCsrKSB7XG4gICAgICAgICAgICAgICAgdmFyIHIgPSBhcmd1bWVudHNbdF07XG4gICAgICAgICAgICAgICAgZm9yICh2YXIgbiBpbiByKSB7XG4gICAgICAgICAgICAgICAgICAgICh7fSkuaGFzT3duUHJvcGVydHkuY2FsbChyLCBuKSAmJiAoZVtuXSA9IHJbbl0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICB9LCBULmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIHZhciBxID0ge307XG4gICAgLyoqXG4gKiBBIG5vbi1pbnRlcmFjdGl2ZSBtZW51IGl0ZW0gdXNlZCB0byB2aXN1YWxseSBzZXBhcmF0ZSBncm91cHMgb2YgaXRlbXMgaW4gdGhlIG1lbnUuXG4gKi8gICAgZnVuY3Rpb24gJChlKSB7XG4gICAgICAgIHZhciB0ID0gVCh7fSwgZSk7XG4gICAgICAgIHZhciBhID0gKDAsIHIudXNlQ29udGV4dCkoTiksIGkgPSBhLnJvbGU7XG4gICAgICAgIFxuICAgICAgICByZXR1cm4gbigpLmNyZWF0ZUVsZW1lbnQoQSwgVCh7XG4gICAgICAgICAgICBcImFyaWEtaGlkZGVuXCI6IGkgPT09IFwibGlzdGJveFwiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJkaXZpZGVyXCIsXG4gICAgICAgICAgICByb2xlOiBcInNlcGFyYXRvclwiXG4gICAgICAgIH0sIHQpKTtcbiAgICB9XG4gICAgJC5wcm9wVHlwZXMgPSBxO1xuICAgIC8qIFJlbW92ZSB0aGUgaXRlbSBpZiBpdCBpcyB0aGUgZmlyc3QgaXRlbSBhZnRlciBmaWx0ZXJpbmcgKi8gICAgJC5maWx0ZXJGaXJzdCA9IHRydWU7XG4gICAgLyogUmVtb3ZlIGNvbnNlY3V0aXZlIGl0ZW1zIHdpdGggZmlsdGVyQ29uc2VjdXRpdmUgPSB0cnVlIChEaXZpZGVycyBhbmQgSGVhZGluZ3MpICovICAgICQuZmlsdGVyQ29uc2VjdXRpdmUgPSB0cnVlO1xuICAgIC8qIFJlbW92ZSB0aGUgaXRlbSBpZiBpdCBpcyB0aGUgbGFzdCBpdGVtIGFmdGVyIGZpbHRlcmluZy4gKi8gICAgJC5maWx0ZXJMYXN0ID0gdHJ1ZTtcbiAgICAvKiBUYWcgdGhlIGl0ZW0gYXMgRGl2aWRlciAqLyAgICAkLmFzID0gXCJEaXZpZGVyXCI7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBSID0gJDtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvSGVhZGluZ1wiXG4gICAgY29uc3QgSCA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL0hlYWRpbmdcIik7XG4gICAgdmFyIEYgPSAgZS5uKEgpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL01lbnUvSGVhZGluZ1N0eWxlcy50c1xuICAgIHZhciBNID0gdSgpLmRpdi53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiSGVhZGluZ1N0eWxlc19fU3R5bGVkXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcIm1jZDJ3cy0wXCJcbiAgICB9KShbIFwiXCIsIFwiIGJvcmRlci10b3A6MXB4IHNvbGlkIHRyYW5zcGFyZW50O3BhZGRpbmc6XCIsIFwiIFwiLCBcIjsmOm5vdCg6Zmlyc3QtY2hpbGQpe2JvcmRlci10b3A6MXB4IHNvbGlkIFwiLCBcIjttYXJnaW4tdG9wOlwiLCBcIjt9XCIgXSwgcC5taXhpbnMucmVzZXQoXCJibG9ja1wiKSwgcC52YXJpYWJsZXMuc3BhY2luZ1NtYWxsLCBwLnZhcmlhYmxlcy5zcGFjaW5nTGFyZ2UsIHAudmFyaWFibGVzLmJvcmRlckNvbG9yLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwpO1xuICAgIHZhciBMID0gdSgpKEYoKSkud2l0aENvbmZpZyh7XG4gICAgICAgIGRpc3BsYXlOYW1lOiBcIkhlYWRpbmdTdHlsZXNfX1N0eWxlZEhlYWRpbmdcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwibWNkMndzLTFcIlxuICAgIH0pKFsgXCJjb2xvcjpcIiwgXCI7XCIgXSwgcC52YXJpYWJsZXMuY29udGVudENvbG9yRGVmYXVsdCk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogLi9zcmMvTWVudS9IZWFkaW5nLnRzeFxuICAgIGZ1bmN0aW9uIEsoZSkge1xuICAgICAgICBcIkBiYWJlbC9oZWxwZXJzIC0gdHlwZW9mXCI7XG4gICAgICAgIHJldHVybiBLID0gXCJmdW5jdGlvblwiID09IHR5cGVvZiBTeW1ib2wgJiYgXCJzeW1ib2xcIiA9PSB0eXBlb2YgU3ltYm9sLml0ZXJhdG9yID8gZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgcmV0dXJuIHR5cGVvZiBlO1xuICAgICAgICB9IDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgcmV0dXJuIGUgJiYgXCJmdW5jdGlvblwiID09IHR5cGVvZiBTeW1ib2wgJiYgZS5jb25zdHJ1Y3RvciA9PT0gU3ltYm9sICYmIGUgIT09IFN5bWJvbC5wcm90b3R5cGUgPyBcInN5bWJvbFwiIDogdHlwZW9mIGU7XG4gICAgICAgIH0sIEsoZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEIoKSB7XG4gICAgICAgIHJldHVybiBCID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgdCA9IDE7IHQgPCBhcmd1bWVudHMubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgICAgICB2YXIgciA9IGFyZ3VtZW50c1t0XTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciBuIGluIHIpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHIsIG4pICYmIChlW25dID0gcltuXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIEIuYXBwbHkobnVsbCwgYXJndW1lbnRzKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gVyhlLCB0KSB7XG4gICAgICAgIHZhciByID0gT2JqZWN0LmtleXMoZSk7XG4gICAgICAgIGlmIChPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKSB7XG4gICAgICAgICAgICB2YXIgbiA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMoZSk7XG4gICAgICAgICAgICB0ICYmIChuID0gbi5maWx0ZXIoKGZ1bmN0aW9uKHQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcihlLCB0KS5lbnVtZXJhYmxlO1xuICAgICAgICAgICAgfSkpKSwgci5wdXNoLmFwcGx5KHIsIG4pO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICBmdW5jdGlvbiB6KGUpIHtcbiAgICAgICAgZm9yICh2YXIgdCA9IDE7IHQgPCBhcmd1bWVudHMubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgIHZhciByID0gbnVsbCAhPSBhcmd1bWVudHNbdF0gPyBhcmd1bWVudHNbdF0gOiB7fTtcbiAgICAgICAgICAgIHQgJSAyID8gVyhPYmplY3QociksICEwKS5mb3JFYWNoKChmdW5jdGlvbih0KSB7XG4gICAgICAgICAgICAgICAgVihlLCB0LCByW3RdKTtcbiAgICAgICAgICAgIH0pKSA6IE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3JzID8gT2JqZWN0LmRlZmluZVByb3BlcnRpZXMoZSwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMocikpIDogVyhPYmplY3QocikpLmZvckVhY2goKGZ1bmN0aW9uKHQpIHtcbiAgICAgICAgICAgICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoZSwgdCwgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcihyLCB0KSk7XG4gICAgICAgICAgICB9KSk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFYoZSwgdCwgcikge1xuICAgICAgICByZXR1cm4gKHQgPSBYKHQpKSBpbiBlID8gT2JqZWN0LmRlZmluZVByb3BlcnR5KGUsIHQsIHtcbiAgICAgICAgICAgIHZhbHVlOiByLFxuICAgICAgICAgICAgZW51bWVyYWJsZTogITAsXG4gICAgICAgICAgICBjb25maWd1cmFibGU6ICEwLFxuICAgICAgICAgICAgd3JpdGFibGU6ICEwXG4gICAgICAgIH0pIDogZVt0XSA9IHIsIGU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFgoZSkge1xuICAgICAgICB2YXIgdCA9IEcoZSwgXCJzdHJpbmdcIik7XG4gICAgICAgIHJldHVybiBcInN5bWJvbFwiID09IEsodCkgPyB0IDogdCArIFwiXCI7XG4gICAgfVxuICAgIGZ1bmN0aW9uIEcoZSwgdCkge1xuICAgICAgICBpZiAoXCJvYmplY3RcIiAhPSBLKGUpIHx8ICFlKSByZXR1cm4gZTtcbiAgICAgICAgdmFyIHIgPSBlW1N5bWJvbC50b1ByaW1pdGl2ZV07XG4gICAgICAgIGlmICh2b2lkIDAgIT09IHIpIHtcbiAgICAgICAgICAgIHZhciBuID0gci5jYWxsKGUsIHQgfHwgXCJkZWZhdWx0XCIpO1xuICAgICAgICAgICAgaWYgKFwib2JqZWN0XCIgIT0gSyhuKSkgcmV0dXJuIG47XG4gICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFwiQEB0b1ByaW1pdGl2ZSBtdXN0IHJldHVybiBhIHByaW1pdGl2ZSB2YWx1ZS5cIik7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIChcInN0cmluZ1wiID09PSB0ID8gU3RyaW5nIDogTnVtYmVyKShlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gSihlLCB0KSB7XG4gICAgICAgIGlmIChudWxsID09IGUpIHJldHVybiB7fTtcbiAgICAgICAgdmFyIHIsIG4sIGEgPSBRKGUsIHQpO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChuID0gMDsgbiA8IGkubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICByID0gaVtuXSwgLTEgPT09IHQuaW5kZXhPZihyKSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHIpICYmIChhW3JdID0gZVtyXSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGE7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFEoZSwgdCkge1xuICAgICAgICBpZiAobnVsbCA9PSBlKSByZXR1cm4ge307XG4gICAgICAgIHZhciByID0ge307XG4gICAgICAgIGZvciAodmFyIG4gaW4gZSkge1xuICAgICAgICAgICAgaWYgKHt9Lmhhc093blByb3BlcnR5LmNhbGwoZSwgbikpIHtcbiAgICAgICAgICAgICAgICBpZiAoLTEgIT09IHQuaW5kZXhPZihuKSkgY29udGludWU7XG4gICAgICAgICAgICAgICAgcltuXSA9IGVbbl07XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHI7XG4gICAgfVxuICAgIHZhciBVID0ge1xuICAgICAgICBjaGlsZHJlbjogbCgpLm5vZGUsXG4gICAgICAgIHRpdGxlOiBsKCkuYm9vbCxcbiAgICAgICAgb3V0ZXJTdHlsZTogbCgpLm9iamVjdFxuICAgIH07XG4gICAgLyoqXG4gKiBBIG5vbi1pbnRlcmFjdGl2ZSBgTWVudWAgaXRlbSB1c2VkIHRvIHNlcGFyYXRlIGFuZCBsYWJlbCBncm91cHMgb2YgYE1lbnVgIGl0ZW1zLlxuICovICAgIGZ1bmN0aW9uIFkoZSkge1xuICAgICAgICB2YXIgdCA9IGUuY2hpbGRyZW4sIGEgPSBlLm91dGVyU3R5bGUsIGkgPSBlLnRpdGxlLCBvID0gSihlLCBbIFwiY2hpbGRyZW5cIiwgXCJvdXRlclN0eWxlXCIsIFwidGl0bGVcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBIZWFkaW5nUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIGwgPSAoMCwgci51c2VDb250ZXh0KShOKSwgcyA9IGwucm9sZTtcbiAgICAgICAgdmFyIGMgPSAoMCwgci51c2VNZW1vKSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICByZXR1cm4geih6KHt9LCBhKSwge30sIHtcbiAgICAgICAgICAgICAgICBtYXJnaW46IDBcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KSwgWyBhIF0pO1xuICAgICAgICAvLyBoZWFkaW5ncyBhcmUgbm90IHN1cHBvcnRlZCBpbiByb2xlPVwibGlzdGJveFwiXG4gICAgICAgIC8vIHRoaXMgY2F1c2VzIEZpcmVmb3ggdG8gaW5jb3JyZWN0bHkgcmVhZCB0aGUgdG90YWwgbnVtYmVyXG4gICAgICAgIC8vIG9mIGl0ZW1zIGluIHRoZSBsaXN0IGlmIGl0IGNvbnRhaW5zIGEgaGVhZGluZyBvciBkaXZpZGVyXG4gICAgICAgIC8vIHNvIHdlIHNldCB0aGVtIHRvIGFyaWEtaGlkZGVuIHRvIHByZXZlbnQgdGhhdFxuICAgICAgICAgICAgICAgIFxuICAgICAgICByZXR1cm4gbigpLmNyZWF0ZUVsZW1lbnQoTSwge1xuICAgICAgICAgICAgXCJhcmlhLWhpZGRlblwiOiBzID09PSBcImxpc3Rib3hcIiA/IHRydWUgOiB1bmRlZmluZWRcbiAgICAgICAgfSwgIG4oKS5jcmVhdGVFbGVtZW50KEwsIEIoe1xuICAgICAgICAgICAgc3R5bGU6IGMsXG4gICAgICAgICAgICBsZXZlbDogaSA/IDQgOiA1LFxuICAgICAgICAgICAgdmFyaWFudDogaSA/IFwidGl0bGU1XCIgOiBcInRpdGxlNlwiLFxuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJoZWFkaW5nXCJcbiAgICAgICAgfSwgbyksIHQpKTtcbiAgICB9XG4gICAgWS5wcm9wVHlwZXMgPSBVO1xuICAgIC8qIFJlbW92ZSBjb25zZWN1dGl2ZSBpdGVtcyB3aXRoIGZpbHRlckNvbnNlY3V0aXZlID0gdHJ1ZSAoRGl2aWRlcnMgYW5kIEhlYWRpbmdzKSAqLyAgICBZLmZpbHRlckNvbnNlY3V0aXZlID0gdHJ1ZTtcbiAgICAvKiBSZW1vdmUgdGhlIGl0ZW0gaWYgaXQgaXMgdGhlIGxhc3QgaXRlbSBhZnRlciBmaWx0ZXJpbmcuICovICAgIFkuZmlsdGVyTGFzdCA9IHRydWU7XG4gICAgLyogVGFnIHRoZSBpdGVtIGFzIGEgSGVhZGluZyAqLyAgICBZLmFzID0gXCJIZWFkaW5nXCI7XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBaID0gWTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcImxvZGFzaC9pc1N0cmluZ1wiXG4gICAgY29uc3QgZWUgPSByZXF1aXJlKFwibG9kYXNoL2lzU3RyaW5nXCIpO1xuICAgIHZhciB0ZSA9ICBlLm4oZWUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9DaGVja21hcmtcIlxuICAgIGNvbnN0IHJlID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvQ2hlY2ttYXJrXCIpO1xuICAgIHZhciBuZSA9ICBlLm4ocmUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC1pY29ucy9DaGV2cm9uUmlnaHRcIlxuICAgIGNvbnN0IGFlID0gcmVxdWlyZShcIkBzcGx1bmsvcmVhY3QtaWNvbnMvQ2hldnJvblJpZ2h0XCIpO1xuICAgIHZhciBpZSA9ICBlLm4oYWUpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IGV4dGVybmFsIFwiQHNwbHVuay9yZWFjdC11aS9TY3JlZW5SZWFkZXJDb250ZW50XCJcbiAgICBjb25zdCBvZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL1NjcmVlblJlYWRlckNvbnRlbnRcIik7XG4gICAgdmFyIGxlID0gIGUubihvZSk7XG4gICAgLy8gQ09OQ0FURU5BVEVEIE1PRFVMRTogZXh0ZXJuYWwgXCJAc3BsdW5rL3VpLXV0aWxzL2kxOG5cIlxuICAgIGNvbnN0IHNlID0gcmVxdWlyZShcIkBzcGx1bmsvdWktdXRpbHMvaTE4blwiKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtaWNvbnMvQXJyb3dTcXVhcmVUb3BSaWdodEluc2V0XCJcbiAgICBjb25zdCBjZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LWljb25zL0Fycm93U3F1YXJlVG9wUmlnaHRJbnNldFwiKTtcbiAgICB2YXIgdWUgPSAgZS5uKGNlKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9NZW51L2ljb25zL0V4dGVybmFsLnRzeFxuICAgIHZhciBkZSA9IHUoKSh1ZSgpKS53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiRXh0ZXJuYWxfX1N0eWxlZFwiLFxuICAgICAgICBjb21wb25lbnRJZDogXCJzYy0xdHVyczJzLTBcIlxuICAgIH0pKFsgXCJ2ZXJ0aWNhbC1hbGlnbjp0ZXh0LXRvcDttYXJnaW46MCAwIDAgNHB4O1wiIF0pO1xuICAgIGZ1bmN0aW9uIHZlKCkge1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIG4oKS5jcmVhdGVFbGVtZW50KGRlLCBudWxsKTtcbiAgICB9XG4gICAgLyogaGFybW9ueSBkZWZhdWx0IGV4cG9ydCAqLyAgICBjb25zdCBwZSA9IHZlO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL01lbnUvSXRlbS50c3hcbiAgICBmdW5jdGlvbiBmZSgpIHtcbiAgICAgICAgcmV0dXJuIGZlID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgdCA9IDE7IHQgPCBhcmd1bWVudHMubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgICAgICB2YXIgciA9IGFyZ3VtZW50c1t0XTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciBuIGluIHIpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHIsIG4pICYmIChlW25dID0gcltuXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIGZlLmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIG1lKGUsIHQpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgciwgbiwgYSA9IGJlKGUsIHQpO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChuID0gMDsgbiA8IGkubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICByID0gaVtuXSwgLTEgPT09IHQuaW5kZXhPZihyKSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHIpICYmIChhW3JdID0gZVtyXSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGE7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGJlKGUsIHQpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgciA9IHt9O1xuICAgICAgICBmb3IgKHZhciBuIGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIG4pKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSB0LmluZGV4T2YobikpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIHJbbl0gPSBlW25dO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICB2YXIgZ2UgPSB7XG4gICAgICAgIGFjdGl2ZTogbCgpLmJvb2wsXG4gICAgICAgIGNoaWxkcmVuOiBsKCkubm9kZSxcbiAgICAgICAgZGVzY3JpcHRpb246IGwoKS5zdHJpbmcsXG4gICAgICAgIGRlc2NyaXB0aW9uUG9zaXRpb246IGwoKS5vbmVPZihbIFwicmlnaHRcIiwgXCJib3R0b21cIiBdKSxcbiAgICAgICAgZGlzYWJsZWQ6IGwoKS5vbmVPZlR5cGUoWyBsKCkuYm9vbCwgbCgpLm9uZU9mKFsgXCJkaW1tZWRcIiwgXCJkaXNhYmxlZFwiIF0pIF0pLFxuICAgICAgICBlbGVtZW50UmVmOiBsKCkub25lT2ZUeXBlKFsgbCgpLmZ1bmMsIGwoKS5vYmplY3QgXSksXG4gICAgICAgIGVuZEFkb3JubWVudDogbCgpLm5vZGUsXG4gICAgICAgIGhhc1N1Ym1lbnU6IGwoKS5ib29sLFxuICAgICAgICAvKiogQHByaXZhdGUuIFRoZSBpbnRlcm5hbCBrZXkgb2YgdGhlIHRhYiAqL1xuICAgICAgICBpdGVtS2V5OiBsKCkubnVtYmVyLFxuICAgICAgICBtYXRjaFJhbmdlczogbCgpLmFycmF5T2YobCgpLnNoYXBlKHtcbiAgICAgICAgICAgIHN0YXJ0OiBsKCkubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgICAgICAgICBlbmQ6IGwoKS5udW1iZXIuaXNSZXF1aXJlZFxuICAgICAgICB9KSksXG4gICAgICAgIG9uQ2xpY2s6IGwoKS5mdW5jLFxuICAgICAgICAvKiogQHByaXZhdGUgKi9cbiAgICAgICAgb25Gb2N1czogbCgpLmZ1bmMsXG4gICAgICAgIG9wZW5Jbk5ld0NvbnRleHQ6IGwoKS5vbmVPZlR5cGUoWyBsKCkuYm9vbCwgbCgpLnN0cmluZyBdKSxcbiAgICAgICAgLyoqIEBwcml2YXRlICovXG4gICAgICAgIHByZXZlbnRGb2N1czogbCgpLmJvb2wsXG4gICAgICAgIHJvbGU6IGwoKS5vbmVPZihbIFwibWVudWl0ZW1cIiwgXCJtZW51aXRlbXJhZGlvXCIsIFwibWVudWl0ZW1jaGVja2JveFwiLCBcImxpc3Rib3hpdGVtXCIsIFwib3B0aW9uXCIgXSksXG4gICAgICAgIHNlbGVjdGFibGU6IGwoKS5ib29sLFxuICAgICAgICBzZWxlY3RhYmxlQXBwZWFyYW5jZTogbCgpLm9uZU9mKFsgXCJjaGVja21hcmtcIiwgXCJjaGVja2JveFwiIF0pLFxuICAgICAgICBzZWxlY3RlZDogbCgpLm9uZU9mVHlwZShbIGwoKS5ib29sLCBsKCkub25lT2YoWyBcInNvbWVcIiBdKSBdKSxcbiAgICAgICAgc3RhcnRBZG9ybm1lbnQ6IGwoKS5ub2RlLFxuICAgICAgICB0bzogbCgpLnN0cmluZyxcbiAgICAgICAgdHJ1bmNhdGU6IGwoKS5ib29sXG4gICAgfTtcbiAgICB2YXIgeWUgPSAoMCwgc2UuXykoXCIoT3BlbnMgbmV3IHdpbmRvdylcIik7XG4gICAgZnVuY3Rpb24gaGUoZSkge1xuICAgICAgICB2YXIgdDtcbiAgICAgICAgdmFyIGEgPSBlLmFjdGl2ZSwgbyA9IGUuY2hpbGRyZW4sIGwgPSBlLmRlc2NyaXB0aW9uLCBzID0gZS5kZXNjcmlwdGlvblBvc2l0aW9uLCBjID0gcyA9PT0gdm9pZCAwID8gXCJib3R0b21cIiA6IHMsIHUgPSBlLmRpc2FibGVkLCBkID0gZS5lbmRBZG9ybm1lbnQsIHYgPSBlLmVsZW1lbnRSZWYsIHAgPSBlLmhhc1N1Ym1lbnUsIGYgPSBlLml0ZW1LZXksIG0gPSBlLm1hdGNoUmFuZ2VzLCBiID0gZS5vbkNsaWNrLCBnID0gZS5vbkZvY3VzLCB5ID0gZS5vcGVuSW5OZXdDb250ZXh0LCB3ID0gZS5yb2xlLCBBID0gZS5zZWxlY3RhYmxlLCBEID0gZS5zZWxlY3RhYmxlQXBwZWFyYW5jZSwgVCA9IEQgPT09IHZvaWQgMCA/IFwiY2hlY2ttYXJrXCIgOiBELCBxID0gZS5zZWxlY3RlZCwgJCA9IGUuc3RhcnRBZG9ybm1lbnQsIFIgPSBlLnRvLCBIID0gZS50cnVuY2F0ZSwgRiA9IG1lKGUsIFsgXCJhY3RpdmVcIiwgXCJjaGlsZHJlblwiLCBcImRlc2NyaXB0aW9uXCIsIFwiZGVzY3JpcHRpb25Qb3NpdGlvblwiLCBcImRpc2FibGVkXCIsIFwiZW5kQWRvcm5tZW50XCIsIFwiZWxlbWVudFJlZlwiLCBcImhhc1N1Ym1lbnVcIiwgXCJpdGVtS2V5XCIsIFwibWF0Y2hSYW5nZXNcIiwgXCJvbkNsaWNrXCIsIFwib25Gb2N1c1wiLCBcIm9wZW5Jbk5ld0NvbnRleHRcIiwgXCJyb2xlXCIsIFwic2VsZWN0YWJsZVwiLCBcInNlbGVjdGFibGVBcHBlYXJhbmNlXCIsIFwic2VsZWN0ZWRcIiwgXCJzdGFydEFkb3JubWVudFwiLCBcInRvXCIsIFwidHJ1bmNhdGVcIiBdKTtcbiAgICAgICAgLy8gQGRvY3MtcHJvcHMtdHlwZSBJdGVtUHJvcHNCYXNlXG4gICAgICAgICAgICAgICAgdmFyIE0gPSAoMCwgci51c2VDb250ZXh0KShOKSwgTCA9IE0ucHJldmVudEZvY3VzO1xuIC8vIFVzZSBhcmd1bWVudHNbMF0gKHJhdyBwcm9wcykgdG8gY2hlY2sgaWYgYHNlbGVjdGFibGVBcHBlYXJhbmNlYCB3YXMgZXhwbGljaXRseSBwYXNzZWQgYnkgdGhlIGNhbGxlci5cbiAgICAgICAgLy8gVGhpcyBwcmV2ZW50cyB0aGUgZGVmYXVsdCB2YWx1ZSBmcm9tIGluY29ycmVjdGx5IHRyaWdnZXJpbmcgdGhlIGRldiB3YXJuaW5nLlxuICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgcHJlZmVyLXJlc3QtcGFyYW1zXG4gICAgICAgICAgICAgICAgdmFyIEsgPSAodCA9IGFyZ3VtZW50c1swXSkgPT09IG51bGwgfHwgdCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdC5zZWxlY3RhYmxlQXBwZWFyYW5jZTtcbiAgICAgICAgKDAsIHIudXNlRWZmZWN0KSgoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICBpZiAoZmFsc2UpIHt9XG4gICAgICAgIH0pLCBbIEgsIGMsIG0sIG8sIHEsIEEsIFQsIEsgXSk7XG4gICAgICAgIHZhciBCID0gKDAsIHIudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBnID09PSBudWxsIHx8IGcgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGcoZSwge1xuICAgICAgICAgICAgICAgIGl0ZW1LZXk6IGZcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KSwgWyBmLCBnIF0pO1xuICAgICAgICB2YXIgVyA9ICgwLCByLnVzZUNhbGxiYWNrKSgoZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgaWYgKEwpIHtcbiAgICAgICAgICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pLCBbIEwgXSk7XG4gICAgICAgIHZhciB6ID0gKDAsIHIudXNlTWVtbykoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgaWYgKCFtIHx8ICF0ZSgpKG8pKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIG87XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgZSA9IFtdO1xuICAgICAgICAgICAgLy8gYmVmb3JlIGZpcnN0IG1hdGNoLiBNYXkgYmUgZW1wdHkgc3RyaW5nLlxuICAgICAgICAgICAgICAgICAgICAgICAgZS5wdXNoKG8uc3Vic3RyaW5nKDAsIG1bMF0uc3RhcnQpKTtcbiAgICAgICAgICAgIG0uZm9yRWFjaCgoZnVuY3Rpb24odCwgcikge1xuICAgICAgICAgICAgICAgIGUucHVzaChcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgcmVhY3Qvbm8tYXJyYXktaW5kZXgta2V5XG4gICAgICAgICAgICAgICAgbigpLmNyZWF0ZUVsZW1lbnQoUCwge1xuICAgICAgICAgICAgICAgICAgICBrZXk6IHIsXG4gICAgICAgICAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwibWF0Y2hcIlxuICAgICAgICAgICAgICAgIH0sIG8uc3Vic3RyaW5nKHQuc3RhcnQsIHQuZW5kKSkpO1xuICAgICAgICAgICAgICAgIGlmIChyIDwgbS5sZW5ndGggLSAxKSB7XG4gICAgICAgICAgICAgICAgICAgIGUucHVzaChvLnN1YnN0cmluZyh0LmVuZCwgbVtyICsgMV0uc3RhcnQpKTtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBlLnB1c2goby5zdWJzdHJpbmcodC5lbmQsIG8ubGVuZ3RoKSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0pLCBbIG8sIG0gXSk7XG4gICAgICAgIHZhciBWID0gcSA9PT0gdHJ1ZSB8fCBxID09PSBcInNvbWVcIjtcbiAgICAgICAgdmFyIFggPSBBIHx8IFY7XG4gICAgICAgIHZhciBHID0gdyB8fCB7XG4gICAgICAgICAgICBub25zZWxlY3RhYmxlOiBcIm1lbnVpdGVtXCIsXG4gICAgICAgICAgICBjaGVja21hcms6IFwibWVudWl0ZW1yYWRpb1wiLFxuICAgICAgICAgICAgY2hlY2tib3g6IFwibWVudWl0ZW1jaGVja2JveFwiXG4gICAgICAgIH1bWCA/IFQgOiBcIm5vbnNlbGVjdGFibGVcIl07XG4gICAgICAgIHZhciBKID0ge1xuICAgICAgICAgICAgXCJhcmlhLWhhc3BvcHVwXCI6IHAgPyB0cnVlIDogdW5kZWZpbmVkXG4gICAgICAgIH07XG4gICAgICAgIGlmIChHID09PSBcIm1lbnVpdGVtcmFkaW9cIiB8fCBHID09PSBcIm1lbnVpdGVtY2hlY2tib3hcIikge1xuICAgICAgICAgICAgSltcImFyaWEtY2hlY2tlZFwiXSA9IHEgPT09IFwic29tZVwiID8gXCJtaXhlZFwiIDogVjtcbiAgICAgICAgfSBlbHNlIGlmIChHID09PSBcIm9wdGlvblwiKSB7XG4gICAgICAgICAgICBKW1wiYXJpYS1zZWxlY3RlZFwiXSA9IFY7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIFEgPSBsICYmIGMgPT09IFwicmlnaHRcIjtcbiAgICAgICAgdmFyIFUgPSBsICYmICFRO1xuICAgICAgICB2YXIgWSA9IHEgJiYgVCA9PT0gXCJjaGVja21hcmtcIiAmJiAgbigpLmNyZWF0ZUVsZW1lbnQoTywgbnVsbCwgIG4oKS5jcmVhdGVFbGVtZW50KG5lKCksIHtcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwic2VsZWN0ZWQtY2hlY2ttYXJrXCIsXG4gICAgICAgICAgICBpbmxpbmU6IHRydWVcbiAgICAgICAgfSkpO1xuICAgICAgICB2YXIgWiA9IGZhbHNlO1xuICAgICAgICB2YXIgZWU7XG4gICAgICAgIGlmICh5KSB7XG4gICAgICAgICAgICBaID0gdHJ1ZTtcbiAgICAgICAgICAgIGVlID0gdHlwZW9mIHkgPT09IFwic3RyaW5nXCIgPyB5IDogeWU7XG4gICAgICAgIH1cbiAgICAgICAgXG4gICAgICAgIHJldHVybiBuKCkuY3JlYXRlRWxlbWVudChDLCBmZSh7XG4gICAgICAgICAgICAkYWN0aXZlOiBhLFxuICAgICAgICAgICAgJGlzU2VsZWN0YWJsZTogWCxcbiAgICAgICAgICAgICRwcmV2ZW50Rm9jdXM6IEwgfHwgZmFsc2UsXG4gICAgICAgICAgICAkc2VsZWN0YWJsZUFwcGVhcmFuY2U6IFQgIT09IG51bGwgJiYgVCAhPT0gdm9pZCAwID8gVCA6IGZhbHNlLFxuICAgICAgICAgICAgJHNlbGVjdGVkOiBWLFxuICAgICAgICAgICAgXCJkYXRhLWhhcy1pY29uXCI6ICEhJCB8fCAhIWQsXG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcIml0ZW1cIixcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0LXNlbGVjdGVkXCI6IFggPyBWIDogbnVsbCxcbiAgICAgICAgICAgIGRpc2FibGVkOiB1LFxuICAgICAgICAgICAgZWxlbWVudFJlZjogdixcbiAgICAgICAgICAgIG9uQ2xpY2s6IGIsXG4gICAgICAgICAgICBvbkZvY3VzOiBCLFxuICAgICAgICAgICAgb25Nb3VzZURvd246IFcsXG4gICAgICAgICAgICBvcGVuSW5OZXdDb250ZXh0OiBaLFxuICAgICAgICAgICAgcm9sZTogRyxcbiAgICAgICAgICAgIHRhYkluZGV4OiBMID8gLTEgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICB0bzogUixcbiAgICAgICAgICAgIHRpdGxlOiBIICYmIHRlKCkobykgPyBvIDogdW5kZWZpbmVkXG4gICAgICAgIH0sIEosIGkoKShGLCBcIm9uRm9jdXNcIikpLCBwICYmICBuKCkuY3JlYXRlRWxlbWVudChqLCBudWxsLCAgbigpLmNyZWF0ZUVsZW1lbnQoaWUoKSwgbnVsbCkpLCAgbigpLmNyZWF0ZUVsZW1lbnQoSSwgbnVsbCwgQSAmJiBUID09PSBcImNoZWNrYm94XCIgJiYgIG4oKS5jcmVhdGVFbGVtZW50KHgsIHtcbiAgICAgICAgICAgIGNoZWNrZWQ6IHEgPT09IFwic29tZVwiID8gXCJpbmRldGVybWluYXRlXCIgOiBxLFxuICAgICAgICAgICAgZGlzYWJsZWQ6ICEhdSxcbiAgICAgICAgICAgIGluZXJ0OiB0cnVlXG4gICAgICAgIH0pLCAkICYmICBuKCkuY3JlYXRlRWxlbWVudChrLCBudWxsLCAkKSwgIG4oKS5jcmVhdGVFbGVtZW50KEUsIHtcbiAgICAgICAgICAgICRkZXNjcmlwdGlvbkJvdHRvbTogISFVLFxuICAgICAgICAgICAgJHRydW5jYXRlOiBIICE9PSBudWxsICYmIEggIT09IHZvaWQgMCA/IEggOiBmYWxzZVxuICAgICAgICB9LCAgbigpLmNyZWF0ZUVsZW1lbnQoXywge1xuICAgICAgICAgICAgJHRydW5jYXRlOiBIICE9PSBudWxsICYmIEggIT09IHZvaWQgMCA/IEggOiBmYWxzZSxcbiAgICAgICAgICAgIFwiZGF0YS10ZXN0XCI6IFwibGFiZWxcIlxuICAgICAgICB9LCB6LCB5ICYmICBuKCkuY3JlYXRlRWxlbWVudChuKCkuRnJhZ21lbnQsIG51bGwsICBuKCkuY3JlYXRlRWxlbWVudChwZSwgbnVsbCksICBuKCkuY3JlYXRlRWxlbWVudChsZSgpLCBudWxsLCBlZSkpKSwgVSAmJiAgbigpLmNyZWF0ZUVsZW1lbnQoaCwge1xuICAgICAgICAgICAgXCJkYXRhLXRlc3RcIjogXCJkZXNjcmlwdGlvblwiXG4gICAgICAgIH0sIGwpLCBRICYmICBuKCkuY3JlYXRlRWxlbWVudChTLCB7XG4gICAgICAgICAgICBcImRhdGEtdGVzdFwiOiBcImRlc2NyaXB0aW9uXCJcbiAgICAgICAgfSwgbCkpLCBkICYmICBuKCkuY3JlYXRlRWxlbWVudChrLCB7XG4gICAgICAgICAgICBlbmRBZG9ybm1lbnQ6IGRcbiAgICAgICAgfSwgZCksIFkpKTtcbiAgICB9XG4gICAgaGUucHJvcFR5cGVzID0gZ2U7XG4gICAgaGUuYXMgPSBcIkl0ZW1cIjtcbiAgICAvKiBoYXJtb255IGRlZmF1bHQgZXhwb3J0ICovICAgIGNvbnN0IFNlID0gaGU7XG4gICAgLy8gb25seSBmb3Igc3R5bGVkIGNvbXBvbmVudHMgdXNpbmcgSXRlbVxuICAgICAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiBleHRlcm5hbCBcIkBzcGx1bmsvcmVhY3QtdWkvU2Nyb2xsXCJcbiAgICBjb25zdCB3ZSA9IHJlcXVpcmUoXCJAc3BsdW5rL3JlYWN0LXVpL1Njcm9sbFwiKTtcbiAgICB2YXIgT2UgPSAgZS5uKHdlKTtcbiAgICAvLyBDT05DQVRFTkFURUQgTU9EVUxFOiAuL3NyYy9NZW51L01lbnVTdHlsZXMudHNcbiAgICB2YXIga2UgPSAoMCwgYy5jc3MpKFsgXCJib3JkZXItdG9wOjFweCBzb2xpZCBcIiwgXCI7XCIgXSwgcC52YXJpYWJsZXMuYm9yZGVyQ29sb3IpO1xuICAgIHZhciB4ZSA9ICgwLCBjLmNzcykoWyBcIlwiLCBcIjtiYWNrZ3JvdW5kLWNvbG9yOlwiLCBcIjtib3JkZXItcmFkaXVzOlwiLCBcIjttaW4td2lkdGg6NjBweDtvdmVyZmxvdzphdXRvO3Bvc2l0aW9uOnJlbGF0aXZlO3BhZGRpbmc6XCIsIFwiIDA7Jjpmb2N1c3tvdXRsaW5lOjA7Ym94LXNoYWRvdzpcIiwgXCI7YmFja2dyb3VuZDpcIiwgXCI7fSYgKyAme1wiLCBcIn1cIiBdLCBwLm1peGlucy5yZXNldChcImJsb2NrXCIpLCBwLnZhcmlhYmxlcy5iYWNrZ3JvdW5kQ29sb3JQb3B1cCwgcC52YXJpYWJsZXMuYm9yZGVyUmFkaXVzLCBwLnZhcmlhYmxlcy5zcGFjaW5nU21hbGwsIHAudmFyaWFibGVzLmZvY3VzU2hhZG93SW5zZXQsIHAudmFyaWFibGVzLmludGVyYWN0aXZlQ29sb3JPdmVybGF5SG92ZXIsIGtlKTtcbiAgICB2YXIgQ2UgPSB1KCkuZGl2LndpdGhDb25maWcoe1xuICAgICAgICBkaXNwbGF5TmFtZTogXCJNZW51U3R5bGVzX19TdHlsZWRcIixcbiAgICAgICAgY29tcG9uZW50SWQ6IFwic2MtMW9sZmZwOS0wXCJcbiAgICB9KShbIFwiXCIsIFwiXCIgXSwgeGUpO1xuICAgIHZhciBJZSA9IHUoKShPZSgpKS53aXRoQ29uZmlnKHtcbiAgICAgICAgZGlzcGxheU5hbWU6IFwiTWVudVN0eWxlc19fU3R5bGVkU2Nyb2xsXCIsXG4gICAgICAgIGNvbXBvbmVudElkOiBcInNjLTFvbGZmcDktMVwiXG4gICAgfSkoWyBcIlwiLCBcIiBcIiwgXCIgKyAmLCYgKyBcIiwgXCJ7XCIsIFwifVwiIF0sIHhlLCAvKiBzYy1zZWwgKi8gQ2UsIC8qIHNjLXNlbCAqLyBDZSwga2UpO1xuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL3V0aWxzL3VwZGF0ZVJlYWN0UmVmLnRzXG4gICAgLyoqXG4gKiBVcGRhdGVzIGEgUmVhY3QgcmVmLiBDYWxsYmFjayByZWZzIGFuZCBvYmplY3QgcmVmcyAoZnJvbSBgY3JlYXRlUmVmYCBhbmQgYHVzZVJlZmApIGFyZSBzdXBwb3J0ZWQuXG4gKlxuICogQHBhcmFtIHJlZiAtIFRoZSBSZWFjdCBjYWxsYmFjayBvciBvYmplY3QgcmVmLiBDYW4gYmUgYG51bGxgIG9yIGB1bmRlZmluZWRgLlxuICogQHBhcmFtIGN1cnJlbnQgLSBUaGUgbmV3IHZhbHVlIG9mIHRoZSByZWYuXG4gKi9cbiAgICBmdW5jdGlvbiBFZShlLCB0KSB7XG4gICAgICAgIGlmIChlKSB7XG4gICAgICAgICAgICBpZiAodHlwZW9mIGUgPT09IFwiZnVuY3Rpb25cIikge1xuICAgICAgICAgICAgICAgIGUodCk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIHRoZSBwdWJsaWMgc2lnbmF0dXJlIG9mIHRoaXMgdXRpbCB1c2VzIFJlYWN0LlJlZjxUPiB0byBtaXJyb3IgdGhlIHdheSBSZWFjdCB0eXBlcyByZWZzLlxuICAgICAgICAgICAgICAgIC8vIHRoZSBpbnRlbnRpb24gaGVyZSBpcyB0byBzaWduYWwgXCJ3ZSB3aWxsIHRha2UgY2FyZSBvZiBzZXR0aW5nICdjdXJyZW50Jywgbm90IHlvdVwiLlxuICAgICAgICAgICAgICAgIGUuY3VycmVudCA9IHQ7XG4gLy8gZXNsaW50LWRpc2FibGUtbGluZSBuby1wYXJhbS1yZWFzc2lnblxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuICAgIC8vIENPTkNBVEVOQVRFRCBNT0RVTEU6IC4vc3JjL01lbnUvTWVudS50c3hcbiAgICBmdW5jdGlvbiBfZSgpIHtcbiAgICAgICAgcmV0dXJuIF9lID0gT2JqZWN0LmFzc2lnbiA/IE9iamVjdC5hc3NpZ24uYmluZCgpIDogZnVuY3Rpb24oZSkge1xuICAgICAgICAgICAgZm9yICh2YXIgdCA9IDE7IHQgPCBhcmd1bWVudHMubGVuZ3RoOyB0KyspIHtcbiAgICAgICAgICAgICAgICB2YXIgciA9IGFyZ3VtZW50c1t0XTtcbiAgICAgICAgICAgICAgICBmb3IgKHZhciBuIGluIHIpIHtcbiAgICAgICAgICAgICAgICAgICAgKHt9KS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHIsIG4pICYmIChlW25dID0gcltuXSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0sIF9lLmFwcGx5KG51bGwsIGFyZ3VtZW50cyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIFBlKGUsIHQpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgciwgbiwgYSA9IGplKGUsIHQpO1xuICAgICAgICBpZiAoT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scykge1xuICAgICAgICAgICAgdmFyIGkgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlTeW1ib2xzKGUpO1xuICAgICAgICAgICAgZm9yIChuID0gMDsgbiA8IGkubGVuZ3RoOyBuKyspIHtcbiAgICAgICAgICAgICAgICByID0gaVtuXSwgLTEgPT09IHQuaW5kZXhPZihyKSAmJiB7fS5wcm9wZXJ0eUlzRW51bWVyYWJsZS5jYWxsKGUsIHIpICYmIChhW3JdID0gZVtyXSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGE7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGplKGUsIHQpIHtcbiAgICAgICAgaWYgKG51bGwgPT0gZSkgcmV0dXJuIHt9O1xuICAgICAgICB2YXIgciA9IHt9O1xuICAgICAgICBmb3IgKHZhciBuIGluIGUpIHtcbiAgICAgICAgICAgIGlmICh7fS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsIG4pKSB7XG4gICAgICAgICAgICAgICAgaWYgKC0xICE9PSB0LmluZGV4T2YobikpIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIHJbbl0gPSBlW25dO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiByO1xuICAgIH1cbiAgICB2YXIgQWUgPSB7XG4gICAgICAgIGNoaWxkcmVuOiBsKCkubm9kZSxcbiAgICAgICAgZWxlbWVudFJlZjogbCgpLm9uZU9mVHlwZShbIGwoKS5mdW5jLCBsKCkub2JqZWN0IF0pLFxuICAgICAgICBmb2N1c01vZGU6IGwoKS5vbmVPZihbIFwicm92aW5nXCIsIFwibm9ybWFsXCIsIFwibmV2ZXJcIiBdKSxcbiAgICAgICAgc3RvcFNjcm9sbFByb3BhZ2F0aW9uOiBsKCkuYm9vbFxuICAgIH07XG4gICAgLy8gdGhlIGRlZmF1bHQgZm9jdXMgY29udHJvbCBmb3IgTWVudTogbG9vcCwgdmVydGljYWxBcnJvd3ModXAvZG93biBrZXlzKSwgaG9tZS9lbmQga2V5c1xuICAgICAgICB2YXIgRGUgPSBmdW5jdGlvbiBlKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZW5hYmxlTG9vcDogdHJ1ZSxcbiAgICAgICAgICAgIG9yaWVudGF0aW9uOiBcInZlcnRpY2FsXCIsXG4gICAgICAgICAgICBlbmFibGVUYWI6IGZhbHNlLFxuICAgICAgICAgICAgZW5hYmxlSG9tZUVuZDogdHJ1ZVxuICAgICAgICB9O1xuICAgIH07XG4gICAgdmFyIE5lID0gZnVuY3Rpb24gZSh0KSB7XG4gICAgICAgIHZhciByID0gdC5rZXk7XG4gLy8gSGFuZGxlIHNwZWNpYWwgY2FzZSBmb3IgdGFiIG5hdmlnYXRpb25cbiAgICAgICAgICAgICAgICBpZiAociA9PT0gXCJUYWJcIiAmJiAoMCwgcy5pc1RhYktleSkodCkpIHtcbiAgICAgICAgICAgIHJldHVybiB0LnNoaWZ0S2V5ID8gXCJ0YWJTaGlmdFwiIDogXCJUYWJcIjtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gcjtcbiAgICB9O1xuICAgIGZ1bmN0aW9uIFRlKGUpIHtcbiAgICAgICAgdmFyIHQgPSBlLmNoaWxkcmVuLCBhID0gZS5lbGVtZW50UmVmLCBvID0gZS5mb2N1c01vZGUsIGwgPSBvID09PSB2b2lkIDAgPyBcInJvdmluZ1wiIDogbywgYyA9IGUuc3RvcFNjcm9sbFByb3BhZ2F0aW9uLCB1ID0gUGUoZSwgWyBcImNoaWxkcmVuXCIsIFwiZWxlbWVudFJlZlwiLCBcImZvY3VzTW9kZVwiLCBcInN0b3BTY3JvbGxQcm9wYWdhdGlvblwiIF0pO1xuICAgICAgICAvLyBAZG9jcy1wcm9wcy10eXBlIE1lbnVQcm9wc0Jhc2VcbiAgICAgICAgICAgICAgICB2YXIgZCA9ICgwLCByLnVzZUNvbnRleHQpKE4pLCB2ID0gZC5yb2xlLCBwID0gdiA9PT0gdm9pZCAwID8gXCJtZW51XCIgOiB2O1xuICAgICAgICB2YXIgZiA9ICgwLCByLnVzZVJlZikobnVsbCk7XG4gICAgICAgIHZhciBtID0gci5DaGlsZHJlbi50b0FycmF5KHQpLmZpbHRlcihyLmlzVmFsaWRFbGVtZW50KS5yZWR1Y2UoKGZ1bmN0aW9uKGUsIHQsIHIsIG4pIHtcbiAgICAgICAgICAgIC8qIEZpbHRlciBvdXQgaW5pdGlhbCBEaXZpZGVyc1xuICAgICAqIFJlcXVpcmVzIHJlZHVjZSgpIG92ZXIgZmlsdGVyKCkgYmVjYXVzZSBhIEhlYWRpbmcgbWF5IGhhdmUgYmVlblxuICAgICAqIGJlZm9yZSB0aGUgRGl2aWRlci5cbiAgICAgKi9cbiAgICAgICAgICAgIGlmICh0LnR5cGUuYXMgPT09IFwiRGl2aWRlclwiICYmIGUubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICAvLyBGaWx0ZXIgb3V0IGNvbnNlY3V0aXZlIERpdmlkZXJzIGFuZCBIZWFkaW5nc1xuICAgICAgICAgICAgLy8gSWYgRGl2aWRlciBpcyBuZXh0IHRvIEhlYWRpbmcgdGhlbiBpdCB3aWxsIHJlbW92ZSBib3RoIEhlYWRpbmcgYW5kIERpdmlkZXIgdW5sZXNzIEhlYWRpbmcgaGFzIHRpdGxlIHByb3Agc2V0IHRvIGl0XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoKHQudHlwZS5hcyA9PT0gXCJIZWFkaW5nXCIgfHwgdC50eXBlLmFzID09PSBcIkRpdmlkZXJcIikgJiYgIXQucHJvcHMudGl0bGUgJiYgdC50eXBlLmZpbHRlckNvbnNlY3V0aXZlICYmIG4ubGVuZ3RoID4gciArIDEpIHtcbiAgICAgICAgICAgICAgICB2YXIgYSA9IG5bciArIDFdO1xuICAgICAgICAgICAgICAgIGlmIChhLnR5cGUuYXMgPT09IFwiSGVhZGluZ1wiIHx8IGEudHlwZS5hcyA9PT0gXCJEaXZpZGVyXCIpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgLy8gRmlsdGVyIG91dCBsYXN0IERpdmlkZXJzIGFuZCBIZWFkaW5nc1xuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCh0LnR5cGUuYXMgPT09IFwiRGl2aWRlclwiIHx8IHQudHlwZS5hcyA9PT0gXCJIZWFkaW5nXCIpICYmIHIgPT09IG4ubGVuZ3RoIC0gMSkge1xuICAgICAgICAgICAgICAgIHJldHVybiBlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZS5wdXNoKHQpO1xuICAgICAgICAgICAgcmV0dXJuIGU7XG4gICAgICAgIH0pLCBbXSk7XG4gICAgICAgIHZhciBiID0gKDAsIHIudXNlQ2FsbGJhY2spKChmdW5jdGlvbihlKSB7XG4gICAgICAgICAgICBmLmN1cnJlbnQgPSBlO1xuICAgICAgICAgICAgRWUoYSwgZSk7XG4gICAgICAgIH0pLCBbIGEgXSk7XG4gICAgICAgIHZhciBnID0gRGUoKTtcbiAgICAgICAgdmFyIHkgPSAoMCwgci51c2VDYWxsYmFjaykoKGZ1bmN0aW9uKGUpIHtcbiAgICAgICAgICAgIC8vIGlmIGNvbW1hbmQga2V5IG9uIE1hYyB3YXMgcHJlc3NlZCBpZ25vcmVcbiAgICAgICAgICAgIGlmIChlLm5hdGl2ZUV2ZW50Lm1ldGFLZXkpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgdCA9IE5lKGUpO1xuICAgICAgICAgICAgdmFyIHIgPSB0ID09PSBcIlRhYlwiIHx8IHQgPT09IFwidGFiU2hpZnRcIjtcbiAgICAgICAgICAgIHZhciBuID0gdCA9PT0gXCJFbnRlclwiO1xuICAgICAgICAgICAgLy8gQWxsb3cgZGVmYXVsdCBiZWhhdmlvciBmb3IgdGhlIGVudGVyIGtleS5cbiAgICAgICAgICAgIC8vIElmIHRhYiBuYXZpZ2F0aW9uIGlzIGVuYWJsZWQsIHByZXZlbnQgZGVmYXVsdCBiZWhhdmlvciBmb3IgYWxsIG90aGVyIGtleXMuXG4gICAgICAgICAgICAvLyBJZiB0YWIgbmF2aWdhdGlvbiBpcyBkaXNhYmxlZCwgYWxsb3cgZGVmYXVsdCBiZWhhdmlvciBmb3IgdGFiIGFuZCB0YWIrc2hpZnQga2V5XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoIW4gJiYgKGcuZW5hYmxlVGFiIHx8ICFyKSkge1xuICAgICAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhciBhID0gZi5jdXJyZW50O1xuICAgICAgICAgICAgdmFyIGkgPSBbXTtcbiAgICAgICAgICAgIGlmIChhKSB7XG4gICAgICAgICAgICAgICAgaSA9ICgwLCBzLmdldFNvcnRlZFRhYmJhYmxlRWxlbWVudHMpKGEsIHtcbiAgICAgICAgICAgICAgICAgICAgaWdub3JlVGFiSW5kZXg6IHRydWVcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhciBvID0gKGUgPT09IG51bGwgfHwgZSA9PT0gdm9pZCAwID8gdm9pZCAwIDogZS50YXJnZXQpIGluc3RhbmNlb2YgRWxlbWVudCA/IGUudGFyZ2V0IDogbnVsbDtcbiAgICAgICAgICAgIHZhciBsID0gYSA9PT0gbnVsbCB8fCBhID09PSB2b2lkIDAgPyB2b2lkIDAgOiBhLnF1ZXJ5U2VsZWN0b3IoXCI6Zm9jdXNcIik7XG4gICAgICAgICAgICB2YXIgYyA9IG8gfHwgbDtcbiAgICAgICAgICAgIHZhciB1ID0gYyA/IGkuaW5kZXhPZihjKSA6IC0xO1xuICAgICAgICAgICAgKDAsIHMuaGFuZGxlRm9jdXMpKHQsIGksIHUsIGcpO1xuICAgICAgICB9KSwgWyBnIF0