import os
import sys
import re
from os.path import dirname

ta_name = "trackme"
pattern = re.compile(r"[\\/]etc[\\/]apps[\\/][^\\/]+[\\/]bin[\\/]?$")
new_paths = [path for path in sys.path if not pattern.search(path) or ta_name in path]

# Define base paths
bindir = os.path.dirname(os.path.realpath(os.path.dirname(__file__)))
libdir = os.path.join(bindir, "lib")
ta_module_path = os.path.sep.join([os.path.dirname(__file__), ta_name])

# Platform-specific path to 3rdparty
platform = sys.platform
thirdparty_path = None
all_py_path = None

# Python version logic
py_version = sys.version_info

# if python version is 3.9 or higher, set the 3rdparty path
if py_version >= (3, 9):
    if platform.startswith("linux"):
        thirdparty_path = os.path.join(libdir, "3rdparty/linux_with_deps")
    elif platform.startswith("win"):
        thirdparty_path = os.path.join(libdir, "3rdparty/windows")
    all_py_path = os.path.join(libdir, "3rdparty/all_py39")

elif py_version >= (3, 7):
    all_py_path = os.path.join(libdir, "3rdparty/all_py37")

# Add in correct order: 3rdparty, all_pyXY, lib, ta module
if thirdparty_path:
    new_paths.insert(0, thirdparty_path)
if all_py_path:
    new_paths.insert(1, all_py_path)
new_paths.insert(2, libdir)
new_paths.insert(3, ta_module_path)

# Replace sys.path
sys.path = new_paths
