
import import_declare_test

from splunktaucclib.rest_handler.endpoint import (
    field,
    validator,
    RestModel,
    SingleModel,
)
from splunktaucclib.rest_handler import admin_external, util
from splunktaucclib.rest_handler.admin_external import AdminExternalHandler
import logging


util.remove_http_proxy_env_vars()


special_fields = [
    field.RestField(
        'name',
        required=True,
        encrypted=False,
        default=None,
        validator=validator.AllOf(
            validator.String(
                max_len=50, 
                min_len=1, 
            ), 
            validator.Pattern(
                regex=r"""^[a-z][0-9a-z_]*$""", 
            )
        )
    )
]

fields = [
    field.RestField(
        'email_server',
        required=True,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^(?!localhost|127\.0\.0\.1)[^\:]+:\d+$""", 
        )
    ), 
    field.RestField(
        'email_username',
        required=False,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'email_password',
        required=False,
        encrypted=True,
        default=None,
        validator=validator.Pattern(
            regex=r"""^.*$""", 
        )
    ), 
    field.RestField(
        'email_security',
        required=True,
        encrypted=False,
        default='tls',
        validator=validator.Pattern(
            regex=r"""^(ssl|tls)$""", 
        )
    ), 
    field.RestField(
        'allowed_email_domains',
        required=False,
        encrypted=False,
        default=None,
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'sender_email',
        required=True,
        encrypted=False,
        default='splunk',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    ), 
    field.RestField(
        'email_format',
        required=False,
        encrypted=False,
        default='html',
        validator=validator.Pattern(
            regex=r"""^(html|text)$""", 
        )
    ), 
    field.RestField(
        'email_footer',
        required=True,
        encrypted=False,
        default='This is an automated email, please do not reply directly to this email.',
        validator=validator.Pattern(
            regex=r"""^.+$""", 
        )
    )
]
model = RestModel(fields, name=None, special_fields=special_fields)


endpoint = SingleModel(
    'trackme_emails',
    model,
    config_name='emails',
    need_reload=False,
)


if __name__ == '__main__':
    logging.getLogger().addHandler(logging.NullHandler())
    admin_external.handle(
        endpoint,
        handler=AdminExternalHandler,
    )
